#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Word list originally created by dabura667 and released under The MIT License (MIT)
#
# The MIT License (MIT)
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#
# Code surrounding the word list is Copyright (c) 2014-2018, The Monero Project
#
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without modification, are
# permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice, this list of
#    conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice, this list
#    of conditions and the following disclaimer in the documentation and/or other
#    materials provided with the distribution.
#
# 3. Neither the name of the copyright holder nor the names of its contributors may be
#    used to endorse or promote products derived from this software without specific
#    prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
# THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
# THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# list of words from:
#     https://github.com/monero-project/monero/blob/master/src/mnemonics/chinese_simplified.h
#     Most recent commit: 8ea3c4d54429976e9001b8cc4868b721e6747e3c


from .wordlist import Wordlist


class ChineseSimplified(Wordlist):
    language_name = (u"简体中文 (中国)",)
    english_language_name = "Chinese (simplified)"
    unique_prefix_length = 1
    word_list = [
        u"的",
        u"一",
        u"是",
        u"在",
        u"不",
        u"了",
        u"有",
        u"和",
        u"人",
        u"这",
        u"中",
        u"大",
        u"为",
        u"上",
        u"个",
        u"国",
        u"我",
        u"以",
        u"要",
        u"他",
        u"时",
        u"来",
        u"用",
        u"们",
        u"生",
        u"到",
        u"作",
        u"地",
        u"于",
        u"出",
        u"就",
        u"分",
        u"对",
        u"成",
        u"会",
        u"可",
        u"主",
        u"发",
        u"年",
        u"动",
        u"同",
        u"工",
        u"也",
        u"能",
        u"下",
        u"过",
        u"子",
        u"说",
        u"产",
        u"种",
        u"面",
        u"而",
        u"方",
        u"后",
        u"多",
        u"定",
        u"行",
        u"学",
        u"法",
        u"所",
        u"民",
        u"得",
        u"经",
        u"十",
        u"三",
        u"之",
        u"进",
        u"着",
        u"等",
        u"部",
        u"度",
        u"家",
        u"电",
        u"力",
        u"里",
        u"如",
        u"水",
        u"化",
        u"高",
        u"自",
        u"二",
        u"理",
        u"起",
        u"小",
        u"物",
        u"现",
        u"实",
        u"加",
        u"量",
        u"都",
        u"两",
        u"体",
        u"制",
        u"机",
        u"当",
        u"使",
        u"点",
        u"从",
        u"业",
        u"本",
        u"去",
        u"把",
        u"性",
        u"好",
        u"应",
        u"开",
        u"它",
        u"合",
        u"还",
        u"因",
        u"由",
        u"其",
        u"些",
        u"然",
        u"前",
        u"外",
        u"天",
        u"政",
        u"四",
        u"日",
        u"那",
        u"社",
        u"义",
        u"事",
        u"平",
        u"形",
        u"相",
        u"全",
        u"表",
        u"间",
        u"样",
        u"与",
        u"关",
        u"各",
        u"重",
        u"新",
        u"线",
        u"内",
        u"数",
        u"正",
        u"心",
        u"反",
        u"你",
        u"明",
        u"看",
        u"原",
        u"又",
        u"么",
        u"利",
        u"比",
        u"或",
        u"但",
        u"质",
        u"气",
        u"第",
        u"向",
        u"道",
        u"命",
        u"此",
        u"变",
        u"条",
        u"只",
        u"没",
        u"结",
        u"解",
        u"问",
        u"意",
        u"建",
        u"月",
        u"公",
        u"无",
        u"系",
        u"军",
        u"很",
        u"情",
        u"者",
        u"最",
        u"立",
        u"代",
        u"想",
        u"已",
        u"通",
        u"并",
        u"提",
        u"直",
        u"题",
        u"党",
        u"程",
        u"展",
        u"五",
        u"果",
        u"料",
        u"象",
        u"员",
        u"革",
        u"位",
        u"入",
        u"常",
        u"文",
        u"总",
        u"次",
        u"品",
        u"式",
        u"活",
        u"设",
        u"及",
        u"管",
        u"特",
        u"件",
        u"长",
        u"求",
        u"老",
        u"头",
        u"基",
        u"资",
        u"边",
        u"流",
        u"路",
        u"级",
        u"少",
        u"图",
        u"山",
        u"统",
        u"接",
        u"知",
        u"较",
        u"将",
        u"组",
        u"见",
        u"计",
        u"别",
        u"她",
        u"手",
        u"角",
        u"期",
        u"根",
        u"论",
        u"运",
        u"农",
        u"指",
        u"几",
        u"九",
        u"区",
        u"强",
        u"放",
        u"决",
        u"西",
        u"被",
        u"干",
        u"做",
        u"必",
        u"战",
        u"先",
        u"回",
        u"则",
        u"任",
        u"取",
        u"据",
        u"处",
        u"队",
        u"南",
        u"给",
        u"色",
        u"光",
        u"门",
        u"即",
        u"保",
        u"治",
        u"北",
        u"造",
        u"百",
        u"规",
        u"热",
        u"领",
        u"七",
        u"海",
        u"口",
        u"东",
        u"导",
        u"器",
        u"压",
        u"志",
        u"世",
        u"金",
        u"增",
        u"争",
        u"济",
        u"阶",
        u"油",
        u"思",
        u"术",
        u"极",
        u"交",
        u"受",
        u"联",
        u"什",
        u"认",
        u"六",
        u"共",
        u"权",
        u"收",
        u"证",
        u"改",
        u"清",
        u"美",
        u"再",
        u"采",
        u"转",
        u"更",
        u"单",
        u"风",
        u"切",
        u"打",
        u"白",
        u"教",
        u"速",
        u"花",
        u"带",
        u"安",
        u"场",
        u"身",
        u"车",
        u"例",
        u"真",
        u"务",
        u"具",
        u"万",
        u"每",
        u"目",
        u"至",
        u"达",
        u"走",
        u"积",
        u"示",
        u"议",
        u"声",
        u"报",
        u"斗",
        u"完",
        u"类",
        u"八",
        u"离",
        u"华",
        u"名",
        u"确",
        u"才",
        u"科",
        u"张",
        u"信",
        u"马",
        u"节",
        u"话",
        u"米",
        u"整",
        u"空",
        u"元",
        u"况",
        u"今",
        u"集",
        u"温",
        u"传",
        u"土",
        u"许",
        u"步",
        u"群",
        u"广",
        u"石",
        u"记",
        u"需",
        u"段",
        u"研",
        u"界",
        u"拉",
        u"林",
        u"律",
        u"叫",
        u"且",
        u"究",
        u"观",
        u"越",
        u"织",
        u"装",
        u"影",
        u"算",
        u"低",
        u"持",
        u"音",
        u"众",
        u"书",
        u"布",
        u"复",
        u"容",
        u"儿",
        u"须",
        u"际",
        u"商",
        u"非",
        u"验",
        u"连",
        u"断",
        u"深",
        u"难",
        u"近",
        u"矿",
        u"千",
        u"周",
        u"委",
        u"素",
        u"技",
        u"备",
        u"半",
        u"办",
        u"青",
        u"省",
        u"列",
        u"习",
        u"响",
        u"约",
        u"支",
        u"般",
        u"史",
        u"感",
        u"劳",
        u"便",
        u"团",
        u"往",
        u"酸",
        u"历",
        u"市",
        u"克",
        u"何",
        u"除",
        u"消",
        u"构",
        u"府",
        u"称",
        u"太",
        u"准",
        u"精",
        u"值",
        u"号",
        u"率",
        u"族",
        u"维",
        u"划",
        u"选",
        u"标",
        u"写",
        u"存",
        u"候",
        u"毛",
        u"亲",
        u"快",
        u"效",
        u"斯",
        u"院",
        u"查",
        u"江",
        u"型",
        u"眼",
        u"王",
        u"按",
        u"格",
        u"养",
        u"易",
        u"置",
        u"派",
        u"层",
        u"片",
        u"始",
        u"却",
        u"专",
        u"状",
        u"育",
        u"厂",
        u"京",
        u"识",
        u"适",
        u"属",
        u"圆",
        u"包",
        u"火",
        u"住",
        u"调",
        u"满",
        u"县",
        u"局",
        u"照",
        u"参",
        u"红",
        u"细",
        u"引",
        u"听",
        u"该",
        u"铁",
        u"价",
        u"严",
        u"首",
        u"底",
        u"液",
        u"官",
        u"德",
        u"随",
        u"病",
        u"苏",
        u"失",
        u"尔",
        u"死",
        u"讲",
        u"配",
        u"女",
        u"黄",
        u"推",
        u"显",
        u"谈",
        u"罪",
        u"神",
        u"艺",
        u"呢",
        u"席",
        u"含",
        u"企",
        u"望",
        u"密",
        u"批",
        u"营",
        u"项",
        u"防",
        u"举",
        u"球",
        u"英",
        u"氧",
        u"势",
        u"告",
        u"李",
        u"台",
        u"落",
        u"木",
        u"帮",
        u"轮",
        u"破",
        u"亚",
        u"师",
        u"围",
        u"注",
        u"远",
        u"字",
        u"材",
        u"排",
        u"供",
        u"河",
        u"态",
        u"封",
        u"另",
        u"施",
        u"减",
        u"树",
        u"溶",
        u"怎",
        u"止",
        u"案",
        u"言",
        u"士",
        u"均",
        u"武",
        u"固",
        u"叶",
        u"鱼",
        u"波",
        u"视",
        u"仅",
        u"费",
        u"紧",
        u"爱",
        u"左",
        u"章",
        u"早",
        u"朝",
        u"害",
        u"续",
        u"轻",
        u"服",
        u"试",
        u"食",
        u"充",
        u"兵",
        u"源",
        u"判",
        u"护",
        u"司",
        u"足",
        u"某",
        u"练",
        u"差",
        u"致",
        u"板",
        u"田",
        u"降",
        u"黑",
        u"犯",
        u"负",
        u"击",
        u"范",
        u"继",
        u"兴",
        u"似",
        u"余",
        u"坚",
        u"曲",
        u"输",
        u"修",
        u"故",
        u"城",
        u"夫",
        u"够",
        u"送",
        u"笔",
        u"船",
        u"占",
        u"右",
        u"财",
        u"吃",
        u"富",
        u"春",
        u"职",
        u"觉",
        u"汉",
        u"画",
        u"功",
        u"巴",
        u"跟",
        u"虽",
        u"杂",
        u"飞",
        u"检",
        u"吸",
        u"助",
        u"升",
        u"阳",
        u"互",
        u"初",
        u"创",
        u"抗",
        u"考",
        u"投",
        u"坏",
        u"策",
        u"古",
        u"径",
        u"换",
        u"未",
        u"跑",
        u"留",
        u"钢",
        u"曾",
        u"端",
        u"责",
        u"站",
        u"简",
        u"述",
        u"钱",
        u"副",
        u"尽",
        u"帝",
        u"射",
        u"草",
        u"冲",
        u"承",
        u"独",
        u"令",
        u"限",
        u"阿",
        u"宣",
        u"环",
        u"双",
        u"请",
        u"超",
        u"微",
        u"让",
        u"控",
        u"州",
        u"良",
        u"轴",
        u"找",
        u"否",
        u"纪",
        u"益",
        u"依",
        u"优",
        u"顶",
        u"础",
        u"载",
        u"倒",
        u"房",
        u"突",
        u"坐",
        u"粉",
        u"敌",
        u"略",
        u"客",
        u"袁",
        u"冷",
        u"胜",
        u"绝",
        u"析",
        u"块",
        u"剂",
        u"测",
        u"丝",
        u"协",
        u"诉",
        u"念",
        u"陈",
        u"仍",
        u"罗",
        u"盐",
        u"友",
        u"洋",
        u"错",
        u"苦",
        u"夜",
        u"刑",
        u"移",
        u"频",
        u"逐",
        u"靠",
        u"混",
        u"母",
        u"短",
        u"皮",
        u"终",
        u"聚",
        u"汽",
        u"村",
        u"云",
        u"哪",
        u"既",
        u"距",
        u"卫",
        u"停",
        u"烈",
        u"央",
        u"察",
        u"烧",
        u"迅",
        u"境",
        u"若",
        u"印",
        u"洲",
        u"刻",
        u"括",
        u"激",
        u"孔",
        u"搞",
        u"甚",
        u"室",
        u"待",
        u"核",
        u"校",
        u"散",
        u"侵",
        u"吧",
        u"甲",
        u"游",
        u"久",
        u"菜",
        u"味",
        u"旧",
        u"模",
        u"湖",
        u"货",
        u"损",
        u"预",
        u"阻",
        u"毫",
        u"普",
        u"稳",
        u"乙",
        u"妈",
        u"植",
        u"息",
        u"扩",
        u"银",
        u"语",
        u"挥",
        u"酒",
        u"守",
        u"拿",
        u"序",
        u"纸",
        u"医",
        u"缺",
        u"雨",
        u"吗",
        u"针",
        u"刘",
        u"啊",
        u"急",
        u"唱",
        u"误",
        u"训",
        u"愿",
        u"审",
        u"附",
        u"获",
        u"茶",
        u"鲜",
        u"粮",
        u"斤",
        u"孩",
        u"脱",
        u"硫",
        u"肥",
        u"善",
        u"龙",
        u"演",
        u"父",
        u"渐",
        u"血",
        u"欢",
        u"械",
        u"掌",
        u"歌",
        u"沙",
        u"刚",
        u"攻",
        u"谓",
        u"盾",
        u"讨",
        u"晚",
        u"粒",
        u"乱",
        u"燃",
        u"矛",
        u"乎",
        u"杀",
        u"药",
        u"宁",
        u"鲁",
        u"贵",
        u"钟",
        u"煤",
        u"读",
        u"班",
        u"伯",
        u"香",
        u"介",
        u"迫",
        u"句",
        u"丰",
        u"培",
        u"握",
        u"兰",
        u"担",
        u"弦",
        u"蛋",
        u"沉",
        u"假",
        u"穿",
        u"执",
        u"答",
        u"乐",
        u"谁",
        u"顺",
        u"烟",
        u"缩",
        u"征",
        u"脸",
        u"喜",
        u"松",
        u"脚",
        u"困",
        u"异",
        u"免",
        u"背",
        u"星",
        u"福",
        u"买",
        u"染",
        u"井",
        u"概",
        u"慢",
        u"怕",
        u"磁",
        u"倍",
        u"祖",
        u"皇",
        u"促",
        u"静",
        u"补",
        u"评",
        u"翻",
        u"肉",
        u"践",
        u"尼",
        u"衣",
        u"宽",
        u"扬",
        u"棉",
        u"希",
        u"伤",
        u"操",
        u"垂",
        u"秋",
        u"宜",
        u"氢",
        u"套",
        u"督",
        u"振",
        u"架",
        u"亮",
        u"末",
        u"宪",
        u"庆",
        u"编",
        u"牛",
        u"触",
        u"映",
        u"雷",
        u"销",
        u"诗",
        u"座",
        u"居",
        u"抓",
        u"裂",
        u"胞",
        u"呼",
        u"娘",
        u"景",
        u"威",
        u"绿",
        u"晶",
        u"厚",
        u"盟",
        u"衡",
        u"鸡",
        u"孙",
        u"延",
        u"危",
        u"胶",
        u"屋",
        u"乡",
        u"临",
        u"陆",
        u"顾",
        u"掉",
        u"呀",
        u"灯",
        u"岁",
        u"措",
        u"束",
        u"耐",
        u"剧",
        u"玉",
        u"赵",
        u"跳",
        u"哥",
        u"季",
        u"课",
        u"凯",
        u"胡",
        u"额",
        u"款",
        u"绍",
        u"卷",
        u"齐",
        u"伟",
        u"蒸",
        u"殖",
        u"永",
        u"宗",
        u"苗",
        u"川",
        u"炉",
        u"岩",
        u"弱",
        u"零",
        u"杨",
        u"奏",
        u"沿",
        u"露",
        u"杆",
        u"探",
        u"滑",
        u"镇",
        u"饭",
        u"浓",
        u"航",
        u"怀",
        u"赶",
        u"库",
        u"夺",
        u"伊",
        u"灵",
        u"税",
        u"途",
        u"灭",
        u"赛",
        u"归",
        u"召",
        u"鼓",
        u"播",
        u"盘",
        u"裁",
        u"险",
        u"康",
        u"唯",
        u"录",
        u"菌",
        u"纯",
        u"借",
        u"糖",
        u"盖",
        u"横",
        u"符",
        u"私",
        u"努",
        u"堂",
        u"域",
        u"枪",
        u"润",
        u"幅",
        u"哈",
        u"竟",
        u"熟",
        u"虫",
        u"泽",
        u"脑",
        u"壤",
        u"碳",
        u"欧",
        u"遍",
        u"侧",
        u"寨",
        u"敢",
        u"彻",
        u"虑",
        u"斜",
        u"薄",
        u"庭",
        u"纳",
        u"弹",
        u"饲",
        u"伸",
        u"折",
        u"麦",
        u"湿",
        u"暗",
        u"荷",
        u"瓦",
        u"塞",
        u"床",
        u"筑",
        u"恶",
        u"户",
        u"访",
        u"塔",
        u"奇",
        u"透",
        u"梁",
        u"刀",
        u"旋",
        u"迹",
        u"卡",
        u"氯",
        u"遇",
        u"份",
        u"毒",
        u"泥",
        u"退",
        u"洗",
        u"摆",
        u"灰",
        u"彩",
        u"卖",
        u"耗",
        u"夏",
        u"择",
        u"忙",
        u"铜",
        u"献",
        u"硬",
        u"予",
        u"繁",
        u"圈",
        u"雪",
        u"函",
        u"亦",
        u"抽",
        u"篇",
        u"阵",
        u"阴",
        u"丁",
        u"尺",
        u"追",
        u"堆",
        u"雄",
        u"迎",
        u"泛",
        u"爸",
        u"楼",
        u"避",
        u"谋",
        u"吨",
        u"野",
        u"猪",
        u"旗",
        u"累",
        u"偏",
        u"典",
        u"馆",
        u"索",
        u"秦",
        u"脂",
        u"潮",
        u"爷",
        u"豆",
        u"忽",
        u"托",
        u"惊",
        u"塑",
        u"遗",
        u"愈",
        u"朱",
        u"替",
        u"纤",
        u"粗",
        u"倾",
        u"尚",
        u"痛",
        u"楚",
        u"谢",
        u"奋",
        u"购",
        u"磨",
        u"君",
        u"池",
        u"旁",
        u"碎",
        u"骨",
        u"监",
        u"捕",
        u"弟",
        u"暴",
        u"割",
        u"贯",
        u"殊",
        u"释",
        u"词",
        u"亡",
        u"壁",
        u"顿",
        u"宝",
        u"午",
        u"尘",
        u"闻",
        u"揭",
        u"炮",
        u"残",
        u"冬",
        u"桥",
        u"妇",
        u"警",
        u"综",
        u"招",
        u"吴",
        u"付",
        u"浮",
        u"遭",
        u"徐",
        u"您",
        u"摇",
        u"谷",
        u"赞",
        u"箱",
        u"隔",
        u"订",
        u"男",
        u"吹",
        u"园",
        u"纷",
        u"唐",
        u"败",
        u"宋",
        u"玻",
        u"巨",
        u"耕",
        u"坦",
        u"荣",
        u"闭",
        u"湾",
        u"键",
        u"凡",
        u"驻",
        u"锅",
        u"救",
        u"恩",
        u"剥",
        u"凝",
        u"碱",
        u"齿",
        u"截",
        u"炼",
        u"麻",
        u"纺",
        u"禁",
        u"废",
        u"盛",
        u"版",
        u"缓",
        u"净",
        u"睛",
        u"昌",
        u"婚",
        u"涉",
        u"筒",
        u"嘴",
        u"插",
        u"岸",
        u"朗",
        u"庄",
        u"街",
        u"藏",
        u"姑",
        u"贸",
        u"腐",
        u"奴",
        u"啦",
        u"惯",
        u"乘",
        u"伙",
        u"恢",
        u"匀",
        u"纱",
        u"扎",
        u"辩",
        u"耳",
        u"彪",
        u"臣",
        u"亿",
        u"璃",
        u"抵",
        u"脉",
        u"秀",
        u"萨",
        u"俄",
        u"网",
        u"舞",
        u"店",
        u"喷",
        u"纵",
        u"寸",
        u"汗",
        u"挂",
        u"洪",
        u"贺",
        u"闪",
        u"柬",
        u"爆",
        u"烯",
        u"津",
        u"稻",
        u"墙",
        u"软",
        u"勇",
        u"像",
        u"滚",
        u"厘",
        u"蒙",
        u"芳",
        u"肯",
        u"坡",
        u"柱",
        u"荡",
        u"腿",
        u"仪",
        u"旅",
        u"尾",
        u"轧",
        u"冰",
        u"贡",
        u"登",
        u"黎",
        u"削",
        u"钻",
        u"勒",
        u"逃",
        u"障",
        u"氨",
        u"郭",
        u"峰",
        u"币",
        u"港",
        u"伏",
        u"轨",
        u"亩",
        u"毕",
        u"擦",
        u"莫",
        u"刺",
        u"浪",
        u"秘",
        u"援",
        u"株",
        u"健",
        u"售",
        u"股",
        u"岛",
        u"甘",
        u"泡",
        u"睡",
        u"童",
        u"铸",
        u"汤",
        u"阀",
        u"休",
        u"汇",
        u"舍",
        u"牧",
        u"绕",
        u"炸",
        u"哲",
        u"磷",
        u"绩",
        u"朋",
        u"淡",
        u"尖",
        u"启",
        u"陷",
        u"柴",
        u"呈",
        u"徒",
        u"颜",
        u"泪",
        u"稍",
        u"忘",
        u"泵",
        u"蓝",
        u"拖",
        u"洞",
        u"授",
        u"镜",
        u"辛",
        u"壮",
        u"锋",
        u"贫",
        u"虚",
        u"弯",
        u"摩",
        u"泰",
        u"幼",
        u"廷",
        u"尊",
        u"窗",
        u"纲",
        u"弄",
        u"隶",
        u"疑",
        u"氏",
        u"宫",
        u"姐",
        u"震",
        u"瑞",
        u"怪",
        u"尤",
        u"琴",
        u"循",
        u"描",
        u"膜",
        u"违",
        u"夹",
        u"腰",
        u"缘",
        u"珠",
        u"穷",
        u"森",
        u"枝",
        u"竹",
        u"沟",
        u"催",
        u"绳",
        u"忆",
        u"邦",
        u"剩",
        u"幸",
        u"浆",
        u"栏",
        u"拥",
        u"牙",
        u"贮",
        u"礼",
        u"滤",
        u"钠",
        u"纹",
        u"罢",
        u"拍",
        u"咱",
        u"喊",
        u"袖",
        u"埃",
        u"勤",
        u"罚",
        u"焦",
        u"潜",
        u"伍",
        u"墨",
        u"欲",
        u"缝",
        u"姓",
        u"刊",
        u"饱",
        u"仿",
        u"奖",
        u"铝",
        u"鬼",
        u"丽",
        u"跨",
        u"默",
        u"挖",
        u"链",
        u"扫",
        u"喝",
        u"袋",
        u"炭",
        u"污",
        u"幕",
        u"诸",
        u"弧",
        u"励",
        u"梅",
        u"奶",
        u"洁",
        u"灾",
        u"舟",
        u"鉴",
        u"苯",
        u"讼",
        u"抱",
        u"毁",
        u"懂",
        u"寒",
        u"智",
        u"埔",
        u"寄",
        u"届",
        u"跃",
        u"渡",
        u"挑",
        u"丹",
        u"艰",
        u"贝",
        u"碰",
        u"拔",
        u"爹",
        u"戴",
        u"码",
        u"梦",
        u"芽",
        u"熔",
        u"赤",
        u"渔",
        u"哭",
        u"敬",
        u"颗",
        u"奔",
        u"铅",
        u"仲",
        u"虎",
        u"稀",
        u"妹",
        u"乏",
        u"珍",
        u"申",
        u"桌",
        u"遵",
        u"允",
        u"隆",
        u"螺",
        u"仓",
        u"魏",
        u"锐",
        u"晓",
        u"氮",
        u"兼",
        u"隐",
        u"碍",
        u"赫",
        u"拨",
        u"忠",
        u"肃",
        u"缸",
        u"牵",
        u"抢",
        u"博",
        u"巧",
        u"壳",
        u"兄",
        u"杜",
        u"讯",
        u"诚",
        u"碧",
        u"祥",
        u"柯",
        u"页",
        u"巡",
        u"矩",
        u"悲",
        u"灌",
        u"龄",
        u"伦",
        u"票",
        u"寻",
        u"桂",
        u"铺",
        u"圣",
        u"恐",
        u"恰",
        u"郑",
        u"趣",
        u"抬",
        u"荒",
        u"腾",
        u"贴",
        u"柔",
        u"滴",
        u"猛",
        u"阔",
        u"辆",
        u"妻",
        u"填",
        u"撤",
        u"储",
        u"签",
        u"闹",
        u"扰",
        u"紫",
        u"砂",
        u"递",
        u"戏",
        u"吊",
        u"陶",
        u"伐",
        u"喂",
        u"疗",
        u"瓶",
        u"婆",
        u"抚",
        u"臂",
        u"摸",
        u"忍",
        u"虾",
        u"蜡",
        u"邻",
        u"胸",
        u"巩",
        u"挤",
        u"偶",
        u"弃",
        u"槽",
        u"劲",
        u"乳",
        u"邓",
        u"吉",
        u"仁",
        u"烂",
        u"砖",
        u"租",
        u"乌",
        u"舰",
        u"伴",
        u"瓜",
        u"浅",
        u"丙",
        u"暂",
        u"燥",
        u"橡",
        u"柳",
        u"迷",
        u"暖",
        u"牌",
        u"秧",
        u"胆",
        u"详",
        u"簧",
        u"踏",
        u"瓷",
        u"谱",
        u"呆",
        u"宾",
        u"糊",
        u"洛",
        u"辉",
        u"愤",
        u"竞",
        u"隙",
        u"怒",
        u"粘",
        u"乃",
        u"绪",
        u"肩",
        u"籍",
        u"敏",
        u"涂",
        u"熙",
        u"皆",
        u"侦",
        u"悬",
        u"掘",
        u"享",
        u"纠",
        u"醒",
        u"狂",
        u"锁",
        u"淀",
        u"恨",
        u"牲",
        u"霸",
        u"爬",
        u"赏",
        u"逆",
        u"玩",
        u"陵",
        u"祝",
        u"秒",
        u"浙",
        u"貌",
    ]
