#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Word list originally created by dabura667 and released under The MIT License (MIT)
#
# The MIT License (MIT)
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#
# Code surrounding the word list is Copyright (c) 2014-2018, The Monero Project
#
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without modification, are
# permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice, this list of
#    conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice, this list
#    of conditions and the following disclaimer in the documentation and/or other
#    materials provided with the distribution.
#
# 3. Neither the name of the copyright holder nor the names of its contributors may be
#    used to endorse or promote products derived from this software without specific
#    prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
# THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
# THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# list of words from:
#     https://github.com/monero-project/monero/blob/master/src/mnemonics/russian.h
#     Most recent commit: 8ea3c4d54429976e9001b8cc4868b721e6747e3c


from .wordlist import Wordlist


class Russian(Wordlist):
    language_name = u"русский язык"
    english_language_name = "Russian"
    unique_prefix_length = 4
    word_list = [
        u"абажур",
        u"абзац",
        u"абонент",
        u"абрикос",
        u"абсурд",
        u"авангард",
        u"август",
        u"авиация",
        u"авоська",
        u"автор",
        u"агат",
        u"агент",
        u"агитатор",
        u"агнец",
        u"агония",
        u"агрегат",
        u"адвокат",
        u"адмирал",
        u"адрес",
        u"ажиотаж",
        u"азарт",
        u"азбука",
        u"азот",
        u"аист",
        u"айсберг",
        u"академия",
        u"аквариум",
        u"аккорд",
        u"акробат",
        u"аксиома",
        u"актер",
        u"акула",
        u"акция",
        u"алгоритм",
        u"алебарда",
        u"аллея",
        u"алмаз",
        u"алтарь",
        u"алфавит",
        u"алхимик",
        u"алый",
        u"альбом",
        u"алюминий",
        u"амбар",
        u"аметист",
        u"амнезия",
        u"ампула",
        u"амфора",
        u"анализ",
        u"ангел",
        u"анекдот",
        u"анимация",
        u"анкета",
        u"аномалия",
        u"ансамбль",
        u"антенна",
        u"апатия",
        u"апельсин",
        u"апофеоз",
        u"аппарат",
        u"апрель",
        u"аптека",
        u"арабский",
        u"арбуз",
        u"аргумент",
        u"арест",
        u"ария",
        u"арка",
        u"армия",
        u"аромат",
        u"арсенал",
        u"артист",
        u"архив",
        u"аршин",
        u"асбест",
        u"аскетизм",
        u"аспект",
        u"ассорти",
        u"астроном",
        u"асфальт",
        u"атака",
        u"ателье",
        u"атлас",
        u"атом",
        u"атрибут",
        u"аудитор",
        u"аукцион",
        u"аура",
        u"афера",
        u"афиша",
        u"ахинея",
        u"ацетон",
        u"аэропорт",
        u"бабушка",
        u"багаж",
        u"бадья",
        u"база",
        u"баклажан",
        u"балкон",
        u"бампер",
        u"банк",
        u"барон",
        u"бассейн",
        u"батарея",
        u"бахрома",
        u"башня",
        u"баян",
        u"бегство",
        u"бедро",
        u"бездна",
        u"бекон",
        u"белый",
        u"бензин",
        u"берег",
        u"беседа",
        u"бетонный",
        u"биатлон",
        u"библия",
        u"бивень",
        u"бигуди",
        u"бидон",
        u"бизнес",
        u"бикини",
        u"билет",
        u"бинокль",
        u"биология",
        u"биржа",
        u"бисер",
        u"битва",
        u"бицепс",
        u"благо",
        u"бледный",
        u"близкий",
        u"блок",
        u"блуждать",
        u"блюдо",
        u"бляха",
        u"бобер",
        u"богатый",
        u"бодрый",
        u"боевой",
        u"бокал",
        u"большой",
        u"борьба",
        u"босой",
        u"ботинок",
        u"боцман",
        u"бочка",
        u"боярин",
        u"брать",
        u"бревно",
        u"бригада",
        u"бросать",
        u"брызги",
        u"брюки",
        u"бублик",
        u"бугор",
        u"будущее",
        u"буква",
        u"бульвар",
        u"бумага",
        u"бунт",
        u"бурный",
        u"бусы",
        u"бутылка",
        u"буфет",
        u"бухта",
        u"бушлат",
        u"бывалый",
        u"быль",
        u"быстрый",
        u"быть",
        u"бюджет",
        u"бюро",
        u"бюст",
        u"вагон",
        u"важный",
        u"ваза",
        u"вакцина",
        u"валюта",
        u"вампир",
        u"ванная",
        u"вариант",
        u"вассал",
        u"вата",
        u"вафля",
        u"вахта",
        u"вдова",
        u"вдыхать",
        u"ведущий",
        u"веер",
        u"вежливый",
        u"везти",
        u"веко",
        u"великий",
        u"вена",
        u"верить",
        u"веселый",
        u"ветер",
        u"вечер",
        u"вешать",
        u"вещь",
        u"веяние",
        u"взаимный",
        u"взбучка",
        u"взвод",
        u"взгляд",
        u"вздыхать",
        u"взлетать",
        u"взмах",
        u"взнос",
        u"взор",
        u"взрыв",
        u"взывать",
        u"взятка",
        u"вибрация",
        u"визит",
        u"вилка",
        u"вино",
        u"вирус",
        u"висеть",
        u"витрина",
        u"вихрь",
        u"вишневый",
        u"включать",
        u"вкус",
        u"власть",
        u"влечь",
        u"влияние",
        u"влюблять",
        u"внешний",
        u"внимание",
        u"внук",
        u"внятный",
        u"вода",
        u"воевать",
        u"вождь",
        u"воздух",
        u"войти",
        u"вокзал",
        u"волос",
        u"вопрос",
        u"ворота",
        u"восток",
        u"впадать",
        u"впускать",
        u"врач",
        u"время",
        u"вручать",
        u"всадник",
        u"всеобщий",
        u"вспышка",
        u"встреча",
        u"вторник",
        u"вулкан",
        u"вурдалак",
        u"входить",
        u"въезд",
        u"выбор",
        u"вывод",
        u"выгодный",
        u"выделять",
        u"выезжать",
        u"выживать",
        u"вызывать",
        u"выигрыш",
        u"вылезать",
        u"выносить",
        u"выпивать",
        u"высокий",
        u"выходить",
        u"вычет",
        u"вышка",
        u"выяснять",
        u"вязать",
        u"вялый",
        u"гавань",
        u"гадать",
        u"газета",
        u"гаишник",
        u"галстук",
        u"гамма",
        u"гарантия",
        u"гастроли",
        u"гвардия",
        u"гвоздь",
        u"гектар",
        u"гель",
        u"генерал",
        u"геолог",
        u"герой",
        u"гешефт",
        u"гибель",
        u"гигант",
        u"гильза",
        u"гимн",
        u"гипотеза",
        u"гитара",
        u"глаз",
        u"глина",
        u"глоток",
        u"глубокий",
        u"глыба",
        u"глядеть",
        u"гнать",
        u"гнев",
        u"гнить",
        u"гном",
        u"гнуть",
        u"говорить",
        u"годовой",
        u"голова",
        u"гонка",
        u"город",
        u"гость",
        u"готовый",
        u"граница",
        u"грех",
        u"гриб",
        u"громкий",
        u"группа",
        u"грызть",
        u"грязный",
        u"губа",
        u"гудеть",
        u"гулять",
        u"гуманный",
        u"густой",
        u"гуща",
        u"давать",
        u"далекий",
        u"дама",
        u"данные",
        u"дарить",
        u"дать",
        u"дача",
        u"дверь",
        u"движение",
        u"двор",
        u"дебют",
        u"девушка",
        u"дедушка",
        u"дежурный",
        u"дезертир",
        u"действие",
        u"декабрь",
        u"дело",
        u"демократ",
        u"день",
        u"депутат",
        u"держать",
        u"десяток",
        u"детский",
        u"дефицит",
        u"дешевый",
        u"деятель",
        u"джаз",
        u"джинсы",
        u"джунгли",
        u"диалог",
        u"диван",
        u"диета",
        u"дизайн",
        u"дикий",
        u"динамика",
        u"диплом",
        u"директор",
        u"диск",
        u"дитя",
        u"дичь",
        u"длинный",
        u"дневник",
        u"добрый",
        u"доверие",
        u"договор",
        u"дождь",
        u"доза",
        u"документ",
        u"должен",
        u"домашний",
        u"допрос",
        u"дорога",
        u"доход",
        u"доцент",
        u"дочь",
        u"дощатый",
        u"драка",
        u"древний",
        u"дрожать",
        u"друг",
        u"дрянь",
        u"дубовый",
        u"дуга",
        u"дудка",
        u"дукат",
        u"дуло",
        u"думать",
        u"дупло",
        u"дурак",
        u"дуть",
        u"духи",
        u"душа",
        u"дуэт",
        u"дымить",
        u"дыня",
        u"дыра",
        u"дыханье",
        u"дышать",
        u"дьявол",
        u"дюжина",
        u"дюйм",
        u"дюна",
        u"дядя",
        u"дятел",
        u"егерь",
        u"единый",
        u"едкий",
        u"ежевика",
        u"ежик",
        u"езда",
        u"елка",
        u"емкость",
        u"ерунда",
        u"ехать",
        u"жадный",
        u"жажда",
        u"жалеть",
        u"жанр",
        u"жара",
        u"жать",
        u"жгучий",
        u"ждать",
        u"жевать",
        u"желание",
        u"жемчуг",
        u"женщина",
        u"жертва",
        u"жесткий",
        u"жечь",
        u"живой",
        u"жидкость",
        u"жизнь",
        u"жилье",
        u"жирный",
        u"житель",
        u"журнал",
        u"жюри",
        u"забывать",
        u"завод",
        u"загадка",
        u"задача",
        u"зажечь",
        u"зайти",
        u"закон",
        u"замечать",
        u"занимать",
        u"западный",
        u"зарплата",
        u"засыпать",
        u"затрата",
        u"захват",
        u"зацепка",
        u"зачет",
        u"защита",
        u"заявка",
        u"звать",
        u"звезда",
        u"звонить",
        u"звук",
        u"здание",
        u"здешний",
        u"здоровье",
        u"зебра",
        u"зевать",
        u"зеленый",
        u"земля",
        u"зенит",
        u"зеркало",
        u"зефир",
        u"зигзаг",
        u"зима",
        u"зиять",
        u"злак",
        u"злой",
        u"змея",
        u"знать",
        u"зной",
        u"зодчий",
        u"золотой",
        u"зомби",
        u"зона",
        u"зоопарк",
        u"зоркий",
        u"зрачок",
        u"зрение",
        u"зритель",
        u"зубной",
        u"зыбкий",
        u"зять",
        u"игла",
        u"иголка",
        u"играть",
        u"идея",
        u"идиот",
        u"идол",
        u"идти",
        u"иерархия",
        u"избрать",
        u"известие",
        u"изгонять",
        u"издание",
        u"излагать",
        u"изменять",
        u"износ",
        u"изоляция",
        u"изрядный",
        u"изучать",
        u"изымать",
        u"изящный",
        u"икона",
        u"икра",
        u"иллюзия",
        u"имбирь",
        u"иметь",
        u"имидж",
        u"иммунный",
        u"империя",
        u"инвестор",
        u"индивид",
        u"инерция",
        u"инженер",
        u"иномарка",
        u"институт",
        u"интерес",
        u"инфекция",
        u"инцидент",
        u"ипподром",
        u"ирис",
        u"ирония",
        u"искать",
        u"история",
        u"исходить",
        u"исчезать",
        u"итог",
        u"июль",
        u"июнь",
        u"кабинет",
        u"кавалер",
        u"кадр",
        u"казарма",
        u"кайф",
        u"кактус",
        u"калитка",
        u"камень",
        u"канал",
        u"капитан",
        u"картина",
        u"касса",
        u"катер",
        u"кафе",
        u"качество",
        u"каша",
        u"каюта",
        u"квартира",
        u"квинтет",
        u"квота",
        u"кедр",
        u"кекс",
        u"кенгуру",
        u"кепка",
        u"керосин",
        u"кетчуп",
        u"кефир",
        u"кибитка",
        u"кивнуть",
        u"кидать",
        u"километр",
        u"кино",
        u"киоск",
        u"кипеть",
        u"кирпич",
        u"кисть",
        u"китаец",
        u"класс",
        u"клетка",
        u"клиент",
        u"клоун",
        u"клуб",
        u"клык",
        u"ключ",
        u"клятва",
        u"книга",
        u"кнопка",
        u"кнут",
        u"князь",
        u"кобура",
        u"ковер",
        u"коготь",
        u"кодекс",
        u"кожа",
        u"козел",
        u"койка",
        u"коктейль",
        u"колено",
        u"компания",
        u"конец",
        u"копейка",
        u"короткий",
        u"костюм",
        u"котел",
        u"кофе",
        u"кошка",
        u"красный",
        u"кресло",
        u"кричать",
        u"кровь",
        u"крупный",
        u"крыша",
        u"крючок",
        u"кубок",
        u"кувшин",
        u"кудрявый",
        u"кузов",
        u"кукла",
        u"культура",
        u"кумир",
        u"купить",
        u"курс",
        u"кусок",
        u"кухня",
        u"куча",
        u"кушать",
        u"кювет",
        u"лабиринт",
        u"лавка",
        u"лагерь",
        u"ладонь",
        u"лазерный",
        u"лайнер",
        u"лакей",
        u"лампа",
        u"ландшафт",
        u"лапа",
        u"ларек",
        u"ласковый",
        u"лауреат",
        u"лачуга",
        u"лаять",
        u"лгать",
        u"лебедь",
        u"левый",
        u"легкий",
        u"ледяной",
        u"лежать",
        u"лекция",
        u"лента",
        u"лепесток",
        u"лесной",
        u"лето",
        u"лечь",
        u"леший",
        u"лживый",
        u"либерал",
        u"ливень",
        u"лига",
        u"лидер",
        u"ликовать",
        u"лиловый",
        u"лимон",
        u"линия",
        u"липа",
        u"лирика",
        u"лист",
        u"литр",
        u"лифт",
        u"лихой",
        u"лицо",
        u"личный",
        u"лишний",
        u"лобовой",
        u"ловить",
        u"логика",
        u"лодка",
        u"ложка",
        u"лозунг",
        u"локоть",
        u"ломать",
        u"лоно",
        u"лопата",
        u"лорд",
        u"лось",
        u"лоток",
        u"лохматый",
        u"лошадь",
        u"лужа",
        u"лукавый",
        u"луна",
        u"лупить",
        u"лучший",
        u"лыжный",
        u"лысый",
        u"львиный",
        u"льгота",
        u"льдина",
        u"любить",
        u"людской",
        u"люстра",
        u"лютый",
        u"лягушка",
        u"магазин",
        u"мадам",
        u"мазать",
        u"майор",
        u"максимум",
        u"мальчик",
        u"манера",
        u"март",
        u"масса",
        u"мать",
        u"мафия",
        u"махать",
        u"мачта",
        u"машина",
        u"маэстро",
        u"маяк",
        u"мгла",
        u"мебель",
        u"медведь",
        u"мелкий",
        u"мемуары",
        u"менять",
        u"мера",
        u"место",
        u"метод",
        u"механизм",
        u"мечтать",
        u"мешать",
        u"миграция",
        u"мизинец",
        u"микрофон",
        u"миллион",
        u"минута",
        u"мировой",
        u"миссия",
        u"митинг",
        u"мишень",
        u"младший",
        u"мнение",
        u"мнимый",
        u"могила",
        u"модель",
        u"мозг",
        u"мойка",
        u"мокрый",
        u"молодой",
        u"момент",
        u"монах",
        u"море",
        u"мост",
        u"мотор",
        u"мохнатый",
        u"мочь",
        u"мошенник",
        u"мощный",
        u"мрачный",
        u"мстить",
        u"мудрый",
        u"мужчина",
        u"музыка",
        u"мука",
        u"мумия",
        u"мундир",
        u"муравей",
        u"мусор",
        u"мутный",
        u"муфта",
        u"муха",
        u"мучить",
        u"мушкетер",
        u"мыло",
        u"мысль",
        u"мыть",
        u"мычать",
        u"мышь",
        u"мэтр",
        u"мюзикл",
        u"мягкий",
        u"мякиш",
        u"мясо",
        u"мятый",
        u"мячик",
        u"набор",
        u"навык",
        u"нагрузка",
        u"надежда",
        u"наемный",
        u"нажать",
        u"называть",
        u"наивный",
        u"накрыть",
        u"налог",
        u"намерен",
        u"наносить",
        u"написать",
        u"народ",
        u"натура",
        u"наука",
        u"нация",
        u"начать",
        u"небо",
        u"невеста",
        u"негодяй",
        u"неделя",
        u"нежный",
        u"незнание",
        u"нелепый",
        u"немалый",
        u"неправда",
        u"нервный",
        u"нести",
        u"нефть",
        u"нехватка",
        u"нечистый",
        u"неясный",
        u"нива",
        u"нижний",
        u"низкий",
        u"никель",
        u"нирвана",
        u"нить",
        u"ничья",
        u"ниша",
        u"нищий",
        u"новый",
        u"нога",
        u"ножницы",
        u"ноздря",
        u"ноль",
        u"номер",
        u"норма",
        u"нота",
        u"ночь",
        u"ноша",
        u"ноябрь",
        u"нрав",
        u"нужный",
        u"нутро",
        u"нынешний",
        u"нырнуть",
        u"ныть",
        u"нюанс",
        u"нюхать",
        u"няня",
        u"оазис",
        u"обаяние",
        u"обвинять",
        u"обгонять",
        u"обещать",
        u"обжигать",
        u"обзор",
        u"обида",
        u"область",
        u"обмен",
        u"обнимать",
        u"оборона",
        u"образ",
        u"обучение",
        u"обходить",
        u"обширный",
        u"общий",
        u"объект",
        u"обычный",
        u"обязать",
        u"овальный",
        u"овес",
        u"овощи",
        u"овраг",
        u"овца",
        u"овчарка",
        u"огненный",
        u"огонь",
        u"огромный",
        u"огурец",
        u"одежда",
        u"одинокий",
        u"одобрить",
        u"ожидать",
        u"ожог",
        u"озарение",
        u"озеро",
        u"означать",
        u"оказать",
        u"океан",
        u"оклад",
        u"окно",
        u"округ",
        u"октябрь",
        u"окурок",
        u"олень",
        u"опасный",
        u"операция",
        u"описать",
        u"оплата",
        u"опора",
        u"оппонент",
        u"опрос",
        u"оптимизм",
        u"опускать",
        u"опыт",
        u"орать",
        u"орбита",
        u"орган",
        u"орден",
        u"орел",
        u"оригинал",
        u"оркестр",
        u"орнамент",
        u"оружие",
        u"осадок",
        u"освещать",
        u"осень",
        u"осина",
        u"осколок",
        u"осмотр",
        u"основной",
        u"особый",
        u"осуждать",
        u"отбор",
        u"отвечать",
        u"отдать",
        u"отец",
        u"отзыв",
        u"открытие",
        u"отмечать",
        u"относить",
        u"отпуск",
        u"отрасль",
        u"отставка",
        u"оттенок",
        u"отходить",
        u"отчет",
        u"отъезд",
        u"офицер",
        u"охапка",
        u"охота",
        u"охрана",
        u"оценка",
        u"очаг",
        u"очередь",
        u"очищать",
        u"очки",
        u"ошейник",
        u"ошибка",
        u"ощущение",
        u"павильон",
        u"падать",
        u"паек",
        u"пакет",
        u"палец",
        u"память",
        u"панель",
        u"папка",
        u"партия",
        u"паспорт",
        u"патрон",
        u"пауза",
        u"пафос",
        u"пахнуть",
        u"пациент",
        u"пачка",
        u"пашня",
        u"певец",
        u"педагог",
        u"пейзаж",
        u"пельмень",
        u"пенсия",
        u"пепел",
        u"период",
        u"песня",
        u"петля",
        u"пехота",
        u"печать",
        u"пешеход",
        u"пещера",
        u"пианист",
        u"пиво",
        u"пиджак",
        u"пиковый",
        u"пилот",
        u"пионер",
        u"пирог",
        u"писать",
        u"пить",
        u"пицца",
        u"пишущий",
        u"пища",
        u"план",
        u"плечо",
        u"плита",
        u"плохой",
        u"плыть",
        u"плюс",
        u"пляж",
        u"победа",
        u"повод",
        u"погода",
        u"подумать",
        u"поехать",
        u"пожимать",
        u"позиция",
        u"поиск",
        u"покой",
        u"получать",
        u"помнить",
        u"пони",
        u"поощрять",
        u"попадать",
        u"порядок",
        u"пост",
        u"поток",
        u"похожий",
        u"поцелуй",
        u"почва",
        u"пощечина",
        u"поэт",
        u"пояснить",
        u"право",
        u"предмет",
        u"проблема",
        u"пруд",
        u"прыгать",
        u"прямой",
        u"психолог",
        u"птица",
        u"публика",
        u"пугать",
        u"пудра",
        u"пузырь",
        u"пуля",
        u"пункт",
        u"пурга",
        u"пустой",
        u"путь",
        u"пухлый",
        u"пучок",
        u"пушистый",
        u"пчела",
        u"пшеница",
        u"пыль",
        u"пытка",
        u"пыхтеть",
        u"пышный",
        u"пьеса",
        u"пьяный",
        u"пятно",
        u"работа",
        u"равный",
        u"радость",
        u"развитие",
        u"район",
        u"ракета",
        u"рамка",
        u"ранний",
        u"рапорт",
        u"рассказ",
        u"раунд",
        u"рация",
        u"рвать",
        u"реальный",
        u"ребенок",
        u"реветь",
        u"регион",
        u"редакция",
        u"реестр",
        u"режим",
        u"резкий",
        u"рейтинг",
        u"река",
        u"религия",
        u"ремонт",
        u"рента",
        u"реплика",
        u"ресурс",
        u"реформа",
        u"рецепт",
        u"речь",
        u"решение",
        u"ржавый",
        u"рисунок",
        u"ритм",
        u"рифма",
        u"робкий",
        u"ровный",
        u"рогатый",
        u"родитель",
        u"рождение",
        u"розовый",
        u"роковой",
        u"роль",
        u"роман",
        u"ронять",
        u"рост",
        u"рота",
        u"роща",
        u"рояль",
        u"рубль",
        u"ругать",
        u"руда",
        u"ружье",
        u"руины",
        u"рука",
        u"руль",
        u"румяный",
        u"русский",
        u"ручка",
        u"рыба",
        u"рывок",
        u"рыдать",
        u"рыжий",
        u"рынок",
        u"рысь",
        u"рыть",
        u"рыхлый",
        u"рыцарь",
        u"рычаг",
        u"рюкзак",
        u"рюмка",
        u"рябой",
        u"рядовой",
        u"сабля",
        u"садовый",
        u"сажать",
        u"салон",
        u"самолет",
        u"сани",
        u"сапог",
        u"сарай",
        u"сатира",
        u"сауна",
        u"сахар",
        u"сбегать",
        u"сбивать",
        u"сбор",
        u"сбыт",
        u"свадьба",
        u"свет",
        u"свидание",
        u"свобода",
        u"связь",
        u"сгорать",
        u"сдвигать",
        u"сеанс",
        u"северный",
        u"сегмент",
        u"седой",
        u"сезон",
        u"сейф",
        u"секунда",
        u"сельский",
        u"семья",
        u"сентябрь",
        u"сердце",
        u"сеть",
        u"сечение",
        u"сеять",
        u"сигнал",
        u"сидеть",
        u"сизый",
        u"сила",
        u"символ",
        u"синий",
        u"сирота",
        u"система",
        u"ситуация",
        u"сиять",
        u"сказать",
        u"скважина",
        u"скелет",
        u"скидка",
        u"склад",
        u"скорый",
        u"скрывать",
        u"скучный",
        u"слава",
        u"слеза",
        u"слияние",
        u"слово",
        u"случай",
        u"слышать",
        u"слюна",
        u"смех",
        u"смирение",
        u"смотреть",
        u"смутный",
        u"смысл",
        u"смятение",
        u"снаряд",
        u"снег",
        u"снижение",
        u"сносить",
        u"снять",
        u"событие",
        u"совет",
        u"согласие",
        u"сожалеть",
        u"сойти",
        u"сокол",
        u"солнце",
        u"сомнение",
        u"сонный",
        u"сообщать",
        u"соперник",
        u"сорт",
        u"состав",
        u"сотня",
        u"соус",
        u"социолог",
        u"сочинять",
        u"союз",
        u"спать",
        u"спешить",
        u"спина",
        u"сплошной",
        u"способ",
        u"спутник",
        u"средство",
        u"срок",
        u"срывать",
        u"стать",
        u"ствол",
        u"стена",
        u"стихи",
        u"сторона",
        u"страна",
        u"студент",
        u"стыд",
        u"субъект",
        u"сувенир",
        u"сугроб",
        u"судьба",
        u"суета",
        u"суждение",
        u"сукно",
        u"сулить",
        u"сумма",
        u"сунуть",
        u"супруг",
        u"суровый",
        u"сустав",
        u"суть",
        u"сухой",
        u"суша",
        u"существо",
        u"сфера",
        u"схема",
        u"сцена",
        u"счастье",
        u"счет",
        u"считать",
        u"сшивать",
        u"съезд",
        u"сынок",
        u"сыпать",
        u"сырье",
        u"сытый",
        u"сыщик",
        u"сюжет",
        u"сюрприз",
        u"таблица",
        u"таежный",
        u"таинство",
        u"тайна",
        u"такси",
        u"талант",
        u"таможня",
        u"танец",
        u"тарелка",
        u"таскать",
        u"тахта",
        u"тачка",
        u"таять",
        u"тварь",
        u"твердый",
        u"творить",
        u"театр",
        u"тезис",
        u"текст",
        u"тело",
        u"тема",
        u"тень",
        u"теория",
        u"теплый",
        u"терять",
        u"тесный",
        u"тетя",
        u"техника",
        u"течение",
        u"тигр",
        u"типичный",
        u"тираж",
        u"титул",
        u"тихий",
        u"тишина",
        u"ткань",
        u"товарищ",
        u"толпа",
        u"тонкий",
        u"топливо",
        u"торговля",
        u"тоска",
        u"точка",
        u"тощий",
        u"традиция",
        u"тревога",
        u"трибуна",
        u"трогать",
        u"труд",
        u"трюк",
        u"тряпка",
        u"туалет",
        u"тугой",
        u"туловище",
        u"туман",
        u"тундра",
        u"тупой",
        u"турнир",
        u"тусклый",
        u"туфля",
        u"туча",
        u"туша",
        u"тыкать",
        u"тысяча",
        u"тьма",
        u"тюльпан",
        u"тюрьма",
        u"тяга",
        u"тяжелый",
        u"тянуть",
        u"убеждать",
        u"убирать",
        u"убогий",
        u"убыток",
        u"уважение",
        u"уверять",
        u"увлекать",
        u"угнать",
        u"угол",
        u"угроза",
        u"удар",
        u"удивлять",
        u"удобный",
        u"уезд",
        u"ужас",
        u"ужин",
        u"узел",
        u"узкий",
        u"узнавать",
        u"узор",
        u"уйма",
        u"уклон",
        u"укол",
        u"уксус",
        u"улетать",
        u"улица",
        u"улучшать",
        u"улыбка",
        u"уметь",
        u"умиление",
        u"умный",
        u"умолять",
        u"умысел",
        u"унижать",
        u"уносить",
        u"уныние",
        u"упасть",
        u"уплата",
        u"упор",
        u"упрекать",
        u"упускать",
        u"уран",
        u"урна",
        u"уровень",
        u"усадьба",
        u"усердие",
        u"усилие",
        u"ускорять",
        u"условие",
        u"усмешка",
        u"уснуть",
        u"успеть",
        u"усыпать",
        u"утешать",
        u"утка",
        u"уточнять",
        u"утро",
        u"утюг",
        u"уходить",
        u"уцелеть",
        u"участие",
        u"ученый",
        u"учитель",
        u"ушко",
        u"ущерб",
        u"уютный",
        u"уяснять",
        u"фабрика",
        u"фаворит",
        u"фаза",
        u"файл",
        u"факт",
        u"фамилия",
        u"фантазия",
        u"фара",
        u"фасад",
        u"февраль",
        u"фельдшер",
        u"феномен",
        u"ферма",
        u"фигура",
        u"физика",
        u"фильм",
        u"финал",
        u"фирма",
        u"фишка",
        u"флаг",
        u"флейта",
        u"флот",
        u"фокус",
        u"фольклор",
        u"фонд",
        u"форма",
        u"фото",
        u"фраза",
        u"фреска",
        u"фронт",
        u"фрукт",
        u"функция",
        u"фуражка",
        u"футбол",
        u"фыркать",
        u"халат",
        u"хамство",
        u"хаос",
        u"характер",
        u"хата",
        u"хватать",
        u"хвост",
        u"хижина",
        u"хилый",
        u"химия",
        u"хирург",
        u"хитрый",
        u"хищник",
        u"хлам",
        u"хлеб",
        u"хлопать",
        u"хмурый",
        u"ходить",
        u"хозяин",
        u"хоккей",
        u"холодный",
        u"хороший",
        u"хотеть",
        u"хохотать",
        u"храм",
        u"хрен",
        u"хриплый",
        u"хроника",
        u"хрупкий",
        u"художник",
        u"хулиган",
        u"хутор",
        u"царь",
        u"цвет",
        u"цель",
        u"цемент",
        u"центр",
        u"цепь",
        u"церковь",
        u"цикл",
        u"цилиндр",
        u"циничный",
        u"цирк",
        u"цистерна",
        u"цитата",
        u"цифра",
        u"цыпленок",
        u"чадо",
        u"чайник",
        u"часть",
        u"чашка",
        u"человек",
        u"чемодан",
        u"чепуха",
        u"черный",
        u"честь",
        u"четкий",
        u"чехол",
        u"чиновник",
        u"число",
        u"читать",
        u"членство",
        u"чреватый",
        u"чтение",
        u"чувство",
        u"чугунный",
        u"чудо",
        u"чужой",
        u"чукча",
        u"чулок",
        u"чума",
        u"чуткий",
        u"чучело",
        u"чушь",
        u"шаблон",
        u"шагать",
        u"шайка",
        u"шакал",
        u"шалаш",
        u"шампунь",
        u"шанс",
        u"шапка",
        u"шарик",
        u"шасси",
        u"шатер",
        u"шахта",
        u"шашлык",
        u"швейный",
        u"швырять",
        u"шевелить",
        u"шедевр",
        u"шейка",
        u"шелковый",
        u"шептать",
        u"шерсть",
        u"шестерка",
        u"шикарный",
        u"шинель",
        u"шипеть",
        u"широкий",
        u"шить",
        u"шишка",
        u"шкаф",
        u"школа",
        u"шкура",
        u"шланг",
        u"шлем",
        u"шлюпка",
        u"шляпа",
        u"шнур",
        u"шоколад",
        u"шорох",
        u"шоссе",
        u"шофер",
        u"шпага",
        u"шпион",
        u"шприц",
        u"шрам",
        u"шрифт",
        u"штаб",
        u"штора",
        u"штраф",
        u"штука",
        u"штык",
        u"шуба",
        u"шуметь",
        u"шуршать",
        u"шутка",
        u"щадить",
        u"щедрый",
        u"щека",
        u"щель",
        u"щенок",
        u"щепка",
        u"щетка",
        u"щука",
        u"эволюция",
        u"эгоизм",
        u"экзамен",
        u"экипаж",
        u"экономия",
        u"экран",
        u"эксперт",
        u"элемент",
        u"элита",
        u"эмблема",
        u"эмигрант",
        u"эмоция",
        u"энергия",
        u"эпизод",
        u"эпоха",
        u"эскиз",
        u"эссе",
        u"эстрада",
        u"этап",
        u"этика",
        u"этюд",
        u"эфир",
        u"эффект",
        u"эшелон",
        u"юбилей",
        u"юбка",
        u"южный",
        u"юмор",
        u"юноша",
        u"юрист",
        u"яблоко",
        u"явление",
        u"ягода",
        u"ядерный",
        u"ядовитый",
        u"ядро",
        u"язва",
        u"язык",
        u"яйцо",
        u"якорь",
        u"январь",
        u"японец",
        u"яркий",
        u"ярмарка",
        u"ярость",
        u"ярус",
        u"ясный",
        u"яхта",
        u"ячейка",
        u"ящик",
    ]
