#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Word list originally created by dabura667 and released under The MIT License (MIT)
#
# The MIT License (MIT)
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#
# Code surrounding the word list is Copyright (c) 2014-2018, The Monero Project
#
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without modification, are
# permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice, this list of
#    conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice, this list
#    of conditions and the following disclaimer in the documentation and/or other
#    materials provided with the distribution.
#
# 3. Neither the name of the copyright holder nor the names of its contributors may be
#    used to endorse or promote products derived from this software without specific
#    prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
# THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
# THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# list of words from:
#     https://github.com/monero-project/monero/blob/master/src/mnemonics/spanish.h
#     Most recent commit: 8ea3c4d54429976e9001b8cc4868b721e6747e3c


from .wordlist import Wordlist


class Spanish(Wordlist):
    language_name = u"Español"
    english_language_name = "Spanish"
    unique_prefix_length = 4
    word_list = [
        u"ábaco",
        u"abdomen",
        u"abeja",
        u"abierto",
        u"abogado",
        u"abono",
        u"aborto",
        u"abrazo",
        u"abrir",
        u"abuelo",
        u"abuso",
        u"acabar",
        u"academia",
        u"acceso",
        u"acción",
        u"aceite",
        u"acelga",
        u"acento",
        u"aceptar",
        u"ácido",
        u"aclarar",
        u"acné",
        u"acoger",
        u"acoso",
        u"activo",
        u"acto",
        u"actriz",
        u"actuar",
        u"acudir",
        u"acuerdo",
        u"acusar",
        u"adicto",
        u"admitir",
        u"adoptar",
        u"adorno",
        u"aduana",
        u"adulto",
        u"aéreo",
        u"afectar",
        u"afición",
        u"afinar",
        u"afirmar",
        u"ágil",
        u"agitar",
        u"agonía",
        u"agosto",
        u"agotar",
        u"agregar",
        u"agrio",
        u"agua",
        u"agudo",
        u"águila",
        u"aguja",
        u"ahogo",
        u"ahorro",
        u"aire",
        u"aislar",
        u"ajedrez",
        u"ajeno",
        u"ajuste",
        u"alacrán",
        u"alambre",
        u"alarma",
        u"alba",
        u"álbum",
        u"alcalde",
        u"aldea",
        u"alegre",
        u"alejar",
        u"alerta",
        u"aleta",
        u"alfiler",
        u"alga",
        u"algodón",
        u"aliado",
        u"aliento",
        u"alivio",
        u"alma",
        u"almeja",
        u"almíbar",
        u"altar",
        u"alteza",
        u"altivo",
        u"alto",
        u"altura",
        u"alumno",
        u"alzar",
        u"amable",
        u"amante",
        u"amapola",
        u"amargo",
        u"amasar",
        u"ámbar",
        u"ámbito",
        u"ameno",
        u"amigo",
        u"amistad",
        u"amor",
        u"amparo",
        u"amplio",
        u"ancho",
        u"anciano",
        u"ancla",
        u"andar",
        u"andén",
        u"anemia",
        u"ángulo",
        u"anillo",
        u"ánimo",
        u"anís",
        u"anotar",
        u"antena",
        u"antiguo",
        u"antojo",
        u"anual",
        u"anular",
        u"anuncio",
        u"añadir",
        u"añejo",
        u"año",
        u"apagar",
        u"aparato",
        u"apetito",
        u"apio",
        u"aplicar",
        u"apodo",
        u"aporte",
        u"apoyo",
        u"aprender",
        u"aprobar",
        u"apuesta",
        u"apuro",
        u"arado",
        u"araña",
        u"arar",
        u"árbitro",
        u"árbol",
        u"arbusto",
        u"archivo",
        u"arco",
        u"arder",
        u"ardilla",
        u"arduo",
        u"área",
        u"árido",
        u"aries",
        u"armonía",
        u"arnés",
        u"aroma",
        u"arpa",
        u"arpón",
        u"arreglo",
        u"arroz",
        u"arruga",
        u"arte",
        u"artista",
        u"asa",
        u"asado",
        u"asalto",
        u"ascenso",
        u"asegurar",
        u"aseo",
        u"asesor",
        u"asiento",
        u"asilo",
        u"asistir",
        u"asno",
        u"asombro",
        u"áspero",
        u"astilla",
        u"astro",
        u"astuto",
        u"asumir",
        u"asunto",
        u"atajo",
        u"ataque",
        u"atar",
        u"atento",
        u"ateo",
        u"ático",
        u"atleta",
        u"átomo",
        u"atraer",
        u"atroz",
        u"atún",
        u"audaz",
        u"audio",
        u"auge",
        u"aula",
        u"aumento",
        u"ausente",
        u"autor",
        u"aval",
        u"avance",
        u"avaro",
        u"ave",
        u"avellana",
        u"avena",
        u"avestruz",
        u"avión",
        u"aviso",
        u"ayer",
        u"ayuda",
        u"ayuno",
        u"azafrán",
        u"azar",
        u"azote",
        u"azúcar",
        u"azufre",
        u"azul",
        u"baba",
        u"babor",
        u"bache",
        u"bahía",
        u"baile",
        u"bajar",
        u"balanza",
        u"balcón",
        u"balde",
        u"bambú",
        u"banco",
        u"banda",
        u"baño",
        u"barba",
        u"barco",
        u"barniz",
        u"barro",
        u"báscula",
        u"bastón",
        u"basura",
        u"batalla",
        u"batería",
        u"batir",
        u"batuta",
        u"baúl",
        u"bazar",
        u"bebé",
        u"bebida",
        u"bello",
        u"besar",
        u"beso",
        u"bestia",
        u"bicho",
        u"bien",
        u"bingo",
        u"blanco",
        u"bloque",
        u"blusa",
        u"boa",
        u"bobina",
        u"bobo",
        u"boca",
        u"bocina",
        u"boda",
        u"bodega",
        u"boina",
        u"bola",
        u"bolero",
        u"bolsa",
        u"bomba",
        u"bondad",
        u"bonito",
        u"bono",
        u"bonsái",
        u"borde",
        u"borrar",
        u"bosque",
        u"bote",
        u"botín",
        u"bóveda",
        u"bozal",
        u"bravo",
        u"brazo",
        u"brecha",
        u"breve",
        u"brillo",
        u"brinco",
        u"brisa",
        u"broca",
        u"broma",
        u"bronce",
        u"brote",
        u"bruja",
        u"brusco",
        u"bruto",
        u"buceo",
        u"bucle",
        u"bueno",
        u"buey",
        u"bufanda",
        u"bufón",
        u"búho",
        u"buitre",
        u"bulto",
        u"burbuja",
        u"burla",
        u"burro",
        u"buscar",
        u"butaca",
        u"buzón",
        u"caballo",
        u"cabeza",
        u"cabina",
        u"cabra",
        u"cacao",
        u"cadáver",
        u"cadena",
        u"caer",
        u"café",
        u"caída",
        u"caimán",
        u"caja",
        u"cajón",
        u"cal",
        u"calamar",
        u"calcio",
        u"caldo",
        u"calidad",
        u"calle",
        u"calma",
        u"calor",
        u"calvo",
        u"cama",
        u"cambio",
        u"camello",
        u"camino",
        u"campo",
        u"cáncer",
        u"candil",
        u"canela",
        u"canguro",
        u"canica",
        u"canto",
        u"caña",
        u"cañón",
        u"caoba",
        u"caos",
        u"capaz",
        u"capitán",
        u"capote",
        u"captar",
        u"capucha",
        u"cara",
        u"carbón",
        u"cárcel",
        u"careta",
        u"carga",
        u"cariño",
        u"carne",
        u"carpeta",
        u"carro",
        u"carta",
        u"casa",
        u"casco",
        u"casero",
        u"caspa",
        u"castor",
        u"catorce",
        u"catre",
        u"caudal",
        u"causa",
        u"cazo",
        u"cebolla",
        u"ceder",
        u"cedro",
        u"celda",
        u"célebre",
        u"celoso",
        u"célula",
        u"cemento",
        u"ceniza",
        u"centro",
        u"cerca",
        u"cerdo",
        u"cereza",
        u"cero",
        u"cerrar",
        u"certeza",
        u"césped",
        u"cetro",
        u"chacal",
        u"chaleco",
        u"champú",
        u"chancla",
        u"chapa",
        u"charla",
        u"chico",
        u"chiste",
        u"chivo",
        u"choque",
        u"choza",
        u"chuleta",
        u"chupar",
        u"ciclón",
        u"ciego",
        u"cielo",
        u"cien",
        u"cierto",
        u"cifra",
        u"cigarro",
        u"cima",
        u"cinco",
        u"cine",
        u"cinta",
        u"ciprés",
        u"circo",
        u"ciruela",
        u"cisne",
        u"cita",
        u"ciudad",
        u"clamor",
        u"clan",
        u"claro",
        u"clase",
        u"clave",
        u"cliente",
        u"clima",
        u"clínica",
        u"cobre",
        u"cocción",
        u"cochino",
        u"cocina",
        u"coco",
        u"código",
        u"codo",
        u"cofre",
        u"coger",
        u"cohete",
        u"cojín",
        u"cojo",
        u"cola",
        u"colcha",
        u"colegio",
        u"colgar",
        u"colina",
        u"collar",
        u"colmo",
        u"columna",
        u"combate",
        u"comer",
        u"comida",
        u"cómodo",
        u"compra",
        u"conde",
        u"conejo",
        u"conga",
        u"conocer",
        u"consejo",
        u"contar",
        u"copa",
        u"copia",
        u"corazón",
        u"corbata",
        u"corcho",
        u"cordón",
        u"corona",
        u"correr",
        u"coser",
        u"cosmos",
        u"costa",
        u"cráneo",
        u"cráter",
        u"crear",
        u"crecer",
        u"creído",
        u"crema",
        u"cría",
        u"crimen",
        u"cripta",
        u"crisis",
        u"cromo",
        u"crónica",
        u"croqueta",
        u"crudo",
        u"cruz",
        u"cuadro",
        u"cuarto",
        u"cuatro",
        u"cubo",
        u"cubrir",
        u"cuchara",
        u"cuello",
        u"cuento",
        u"cuerda",
        u"cuesta",
        u"cueva",
        u"cuidar",
        u"culebra",
        u"culpa",
        u"culto",
        u"cumbre",
        u"cumplir",
        u"cuna",
        u"cuneta",
        u"cuota",
        u"cupón",
        u"cúpula",
        u"curar",
        u"curioso",
        u"curso",
        u"curva",
        u"cutis",
        u"dama",
        u"danza",
        u"dar",
        u"dardo",
        u"dátil",
        u"deber",
        u"débil",
        u"década",
        u"decir",
        u"dedo",
        u"defensa",
        u"definir",
        u"dejar",
        u"delfín",
        u"delgado",
        u"delito",
        u"demora",
        u"denso",
        u"dental",
        u"deporte",
        u"derecho",
        u"derrota",
        u"desayuno",
        u"deseo",
        u"desfile",
        u"desnudo",
        u"destino",
        u"desvío",
        u"detalle",
        u"detener",
        u"deuda",
        u"día",
        u"diablo",
        u"diadema",
        u"diamante",
        u"diana",
        u"diario",
        u"dibujo",
        u"dictar",
        u"diente",
        u"dieta",
        u"diez",
        u"difícil",
        u"digno",
        u"dilema",
        u"diluir",
        u"dinero",
        u"directo",
        u"dirigir",
        u"disco",
        u"diseño",
        u"disfraz",
        u"diva",
        u"divino",
        u"doble",
        u"doce",
        u"dolor",
        u"domingo",
        u"don",
        u"donar",
        u"dorado",
        u"dormir",
        u"dorso",
        u"dos",
        u"dosis",
        u"dragón",
        u"droga",
        u"ducha",
        u"duda",
        u"duelo",
        u"dueño",
        u"dulce",
        u"dúo",
        u"duque",
        u"durar",
        u"dureza",
        u"duro",
        u"ébano",
        u"ebrio",
        u"echar",
        u"eco",
        u"ecuador",
        u"edad",
        u"edición",
        u"edificio",
        u"editor",
        u"educar",
        u"efecto",
        u"eficaz",
        u"eje",
        u"ejemplo",
        u"elefante",
        u"elegir",
        u"elemento",
        u"elevar",
        u"elipse",
        u"élite",
        u"elixir",
        u"elogio",
        u"eludir",
        u"embudo",
        u"emitir",
        u"emoción",
        u"empate",
        u"empeño",
        u"empleo",
        u"empresa",
        u"enano",
        u"encargo",
        u"enchufe",
        u"encía",
        u"enemigo",
        u"enero",
        u"enfado",
        u"enfermo",
        u"engaño",
        u"enigma",
        u"enlace",
        u"enorme",
        u"enredo",
        u"ensayo",
        u"enseñar",
        u"entero",
        u"entrar",
        u"envase",
        u"envío",
        u"época",
        u"equipo",
        u"erizo",
        u"escala",
        u"escena",
        u"escolar",
        u"escribir",
        u"escudo",
        u"esencia",
        u"esfera",
        u"esfuerzo",
        u"espada",
        u"espejo",
        u"espía",
        u"esposa",
        u"espuma",
        u"esquí",
        u"estar",
        u"este",
        u"estilo",
        u"estufa",
        u"etapa",
        u"eterno",
        u"ética",
        u"etnia",
        u"evadir",
        u"evaluar",
        u"evento",
        u"evitar",
        u"exacto",
        u"examen",
        u"exceso",
        u"excusa",
        u"exento",
        u"exigir",
        u"exilio",
        u"existir",
        u"éxito",
        u"experto",
        u"explicar",
        u"exponer",
        u"extremo",
        u"fábrica",
        u"fábula",
        u"fachada",
        u"fácil",
        u"factor",
        u"faena",
        u"faja",
        u"falda",
        u"fallo",
        u"falso",
        u"faltar",
        u"fama",
        u"familia",
        u"famoso",
        u"faraón",
        u"farmacia",
        u"farol",
        u"farsa",
        u"fase",
        u"fatiga",
        u"fauna",
        u"favor",
        u"fax",
        u"febrero",
        u"fecha",
        u"feliz",
        u"feo",
        u"feria",
        u"feroz",
        u"fértil",
        u"fervor",
        u"festín",
        u"fiable",
        u"fianza",
        u"fiar",
        u"fibra",
        u"ficción",
        u"ficha",
        u"fideo",
        u"fiebre",
        u"fiel",
        u"fiera",
        u"fiesta",
        u"figura",
        u"fijar",
        u"fijo",
        u"fila",
        u"filete",
        u"filial",
        u"filtro",
        u"fin",
        u"finca",
        u"fingir",
        u"finito",
        u"firma",
        u"flaco",
        u"flauta",
        u"flecha",
        u"flor",
        u"flota",
        u"fluir",
        u"flujo",
        u"flúor",
        u"fobia",
        u"foca",
        u"fogata",
        u"fogón",
        u"folio",
        u"folleto",
        u"fondo",
        u"forma",
        u"forro",
        u"fortuna",
        u"forzar",
        u"fosa",
        u"foto",
        u"fracaso",
        u"frágil",
        u"franja",
        u"frase",
        u"fraude",
        u"freír",
        u"freno",
        u"fresa",
        u"frío",
        u"frito",
        u"fruta",
        u"fuego",
        u"fuente",
        u"fuerza",
        u"fuga",
        u"fumar",
        u"función",
        u"funda",
        u"furgón",
        u"furia",
        u"fusil",
        u"fútbol",
        u"futuro",
        u"gacela",
        u"gafas",
        u"gaita",
        u"gajo",
        u"gala",
        u"galería",
        u"gallo",
        u"gamba",
        u"ganar",
        u"gancho",
        u"ganga",
        u"ganso",
        u"garaje",
        u"garza",
        u"gasolina",
        u"gastar",
        u"gato",
        u"gavilán",
        u"gemelo",
        u"gemir",
        u"gen",
        u"género",
        u"genio",
        u"gente",
        u"geranio",
        u"gerente",
        u"germen",
        u"gesto",
        u"gigante",
        u"gimnasio",
        u"girar",
        u"giro",
        u"glaciar",
        u"globo",
        u"gloria",
        u"gol",
        u"golfo",
        u"goloso",
        u"golpe",
        u"goma",
        u"gordo",
        u"gorila",
        u"gorra",
        u"gota",
        u"goteo",
        u"gozar",
        u"grada",
        u"gráfico",
        u"grano",
        u"grasa",
        u"gratis",
        u"grave",
        u"grieta",
        u"grillo",
        u"gripe",
        u"gris",
        u"grito",
        u"grosor",
        u"grúa",
        u"grueso",
        u"grumo",
        u"grupo",
        u"guante",
        u"guapo",
        u"guardia",
        u"guerra",
        u"guía",
        u"guiño",
        u"guion",
        u"guiso",
        u"guitarra",
        u"gusano",
        u"gustar",
        u"haber",
        u"hábil",
        u"hablar",
        u"hacer",
        u"hacha",
        u"hada",
        u"hallar",
        u"hamaca",
        u"harina",
        u"haz",
        u"hazaña",
        u"hebilla",
        u"hebra",
        u"hecho",
        u"helado",
        u"helio",
        u"hembra",
        u"herir",
        u"hermano",
        u"héroe",
        u"hervir",
        u"hielo",
        u"hierro",
        u"hígado",
        u"higiene",
        u"hijo",
        u"himno",
        u"historia",
        u"hocico",
        u"hogar",
        u"hoguera",
        u"hoja",
        u"hombre",
        u"hongo",
        u"honor",
        u"honra",
        u"hora",
        u"hormiga",
        u"horno",
        u"hostil",
        u"hoyo",
        u"hueco",
        u"huelga",
        u"huerta",
        u"hueso",
        u"huevo",
        u"huida",
        u"huir",
        u"humano",
        u"húmedo",
        u"humilde",
        u"humo",
        u"hundir",
        u"huracán",
        u"hurto",
        u"icono",
        u"ideal",
        u"idioma",
        u"ídolo",
        u"iglesia",
        u"iglú",
        u"igual",
        u"ilegal",
        u"ilusión",
        u"imagen",
        u"imán",
        u"imitar",
        u"impar",
        u"imperio",
        u"imponer",
        u"impulso",
        u"incapaz",
        u"índice",
        u"inerte",
        u"infiel",
        u"informe",
        u"ingenio",
        u"inicio",
        u"inmenso",
        u"inmune",
        u"innato",
        u"insecto",
        u"instante",
        u"interés",
        u"íntimo",
        u"intuir",
        u"inútil",
        u"invierno",
        u"ira",
        u"iris",
        u"ironía",
        u"isla",
        u"islote",
        u"jabalí",
        u"jabón",
        u"jamón",
        u"jarabe",
        u"jardín",
        u"jarra",
        u"jaula",
        u"jazmín",
        u"jefe",
        u"jeringa",
        u"jinete",
        u"jornada",
        u"joroba",
        u"joven",
        u"joya",
        u"juerga",
        u"jueves",
        u"juez",
        u"jugador",
        u"jugo",
        u"juguete",
        u"juicio",
        u"junco",
        u"jungla",
        u"junio",
        u"juntar",
        u"júpiter",
        u"jurar",
        u"justo",
        u"juvenil",
        u"juzgar",
        u"kilo",
        u"koala",
        u"labio",
        u"lacio",
        u"lacra",
        u"lado",
        u"ladrón",
        u"lagarto",
        u"lágrima",
        u"laguna",
        u"laico",
        u"lamer",
        u"lámina",
        u"lámpara",
        u"lana",
        u"lancha",
        u"langosta",
        u"lanza",
        u"lápiz",
        u"largo",
        u"larva",
        u"lástima",
        u"lata",
        u"látex",
        u"latir",
        u"laurel",
        u"lavar",
        u"lazo",
        u"leal",
        u"lección",
        u"leche",
        u"lector",
        u"leer",
        u"legión",
        u"legumbre",
        u"lejano",
        u"lengua",
        u"lento",
        u"leña",
        u"león",
        u"leopardo",
        u"lesión",
        u"letal",
        u"letra",
        u"leve",
        u"leyenda",
        u"libertad",
        u"libro",
        u"licor",
        u"líder",
        u"lidiar",
        u"lienzo",
        u"liga",
        u"ligero",
        u"lima",
        u"límite",
        u"limón",
        u"limpio",
        u"lince",
        u"lindo",
        u"línea",
        u"lingote",
        u"lino",
        u"linterna",
        u"líquido",
        u"liso",
        u"lista",
        u"litera",
        u"litio",
        u"litro",
        u"llaga",
        u"llama",
        u"llanto",
        u"llave",
        u"llegar",
        u"llenar",
        u"llevar",
        u"llorar",
        u"llover",
        u"lluvia",
        u"lobo",
        u"loción",
        u"loco",
        u"locura",
        u"lógica",
        u"logro",
        u"lombriz",
        u"lomo",
        u"lonja",
        u"lote",
        u"lucha",
        u"lucir",
        u"lugar",
        u"lujo",
        u"luna",
        u"lunes",
        u"lupa",
        u"lustro",
        u"luto",
        u"luz",
        u"maceta",
        u"macho",
        u"madera",
        u"madre",
        u"maduro",
        u"maestro",
        u"mafia",
        u"magia",
        u"mago",
        u"maíz",
        u"maldad",
        u"maleta",
        u"malla",
        u"malo",
        u"mamá",
        u"mambo",
        u"mamut",
        u"manco",
        u"mando",
        u"manejar",
        u"manga",
        u"maniquí",
        u"manjar",
        u"mano",
        u"manso",
        u"manta",
        u"mañana",
        u"mapa",
        u"máquina",
        u"mar",
        u"marco",
        u"marea",
        u"marfil",
        u"margen",
        u"marido",
        u"mármol",
        u"marrón",
        u"martes",
        u"marzo",
        u"masa",
        u"máscara",
        u"masivo",
        u"matar",
        u"materia",
        u"matiz",
        u"matriz",
        u"máximo",
        u"mayor",
        u"mazorca",
        u"mecha",
        u"medalla",
        u"medio",
        u"médula",
        u"mejilla",
        u"mejor",
        u"melena",
        u"melón",
        u"memoria",
        u"menor",
        u"mensaje",
        u"mente",
        u"menú",
        u"mercado",
        u"merengue",
        u"mérito",
        u"mes",
        u"mesón",
        u"meta",
        u"meter",
        u"método",
        u"metro",
        u"mezcla",
        u"miedo",
        u"miel",
        u"miembro",
        u"miga",
        u"mil",
        u"milagro",
        u"militar",
        u"millón",
        u"mimo",
        u"mina",
        u"minero",
        u"mínimo",
        u"minuto",
        u"miope",
        u"mirar",
        u"misa",
        u"miseria",
        u"misil",
        u"mismo",
        u"mitad",
        u"mito",
        u"mochila",
        u"moción",
        u"moda",
        u"modelo",
        u"moho",
        u"mojar",
        u"molde",
        u"moler",
        u"molino",
        u"momento",
        u"momia",
        u"monarca",
        u"moneda",
        u"monja",
        u"monto",
        u"moño",
        u"morada",
        u"morder",
        u"moreno",
        u"morir",
        u"morro",
        u"morsa",
        u"mortal",
        u"mosca",
        u"mostrar",
        u"motivo",
        u"mover",
        u"móvil",
        u"mozo",
        u"mucho",
        u"mudar",
        u"mueble",
        u"muela",
        u"muerte",
        u"muestra",
        u"mugre",
        u"mujer",
        u"mula",
        u"muleta",
        u"multa",
        u"mundo",
        u"muñeca",
        u"mural",
        u"muro",
        u"músculo",
        u"museo",
        u"musgo",
        u"música",
        u"muslo",
        u"nácar",
        u"nación",
        u"nadar",
        u"naipe",
        u"naranja",
        u"nariz",
        u"narrar",
        u"nasal",
        u"natal",
        u"nativo",
        u"natural",
        u"náusea",
        u"naval",
        u"nave",
        u"navidad",
        u"necio",
        u"néctar",
        u"negar",
        u"negocio",
        u"negro",
        u"neón",
        u"nervio",
        u"neto",
        u"neutro",
        u"nevar",
        u"nevera",
        u"nicho",
        u"nido",
        u"niebla",
        u"nieto",
        u"niñez",
        u"niño",
        u"nítido",
        u"nivel",
        u"nobleza",
        u"noche",
        u"nómina",
        u"noria",
        u"norma",
        u"norte",
        u"nota",
        u"noticia",
        u"novato",
        u"novela",
        u"novio",
        u"nube",
        u"nuca",
        u"núcleo",
        u"nudillo",
        u"nudo",
        u"nuera",
        u"nueve",
        u"nuez",
        u"nulo",
        u"número",
        u"nutria",
        u"oasis",
        u"obeso",
        u"obispo",
        u"objeto",
        u"obra",
        u"obrero",
        u"observar",
        u"obtener",
        u"obvio",
        u"oca",
        u"ocaso",
        u"océano",
        u"ochenta",
        u"ocho",
        u"ocio",
        u"ocre",
        u"octavo",
        u"octubre",
        u"oculto",
        u"ocupar",
        u"ocurrir",
        u"odiar",
        u"odio",
        u"odisea",
        u"oeste",
        u"ofensa",
        u"oferta",
        u"oficio",
        u"ofrecer",
        u"ogro",
        u"oído",
        u"oír",
        u"ojo",
        u"ola",
        u"oleada",
        u"olfato",
        u"olivo",
        u"olla",
        u"olmo",
        u"olor",
        u"olvido",
        u"ombligo",
        u"onda",
        u"onza",
        u"opaco",
        u"opción",
        u"ópera",
        u"opinar",
        u"oponer",
        u"optar",
        u"óptica",
        u"opuesto",
        u"oración",
        u"orador",
        u"oral",
        u"órbita",
        u"orca",
        u"orden",
        u"oreja",
        u"órgano",
        u"orgía",
        u"orgullo",
        u"oriente",
        u"origen",
        u"orilla",
        u"oro",
        u"orquesta",
        u"oruga",
        u"osadía",
        u"oscuro",
        u"osezno",
        u"oso",
        u"ostra",
        u"otoño",
        u"otro",
        u"oveja",
        u"óvulo",
        u"óxido",
        u"oxígeno",
        u"oyente",
        u"ozono",
        u"pacto",
        u"padre",
        u"paella",
        u"página",
        u"pago",
        u"país",
        u"pájaro",
        u"palabra",
        u"palco",
        u"paleta",
        u"pálido",
        u"palma",
        u"paloma",
        u"palpar",
        u"pan",
        u"panal",
        u"pánico",
        u"pantera",
        u"pañuelo",
        u"papá",
        u"papel",
        u"papilla",
        u"paquete",
        u"parar",
        u"parcela",
        u"pared",
        u"parir",
        u"paro",
        u"párpado",
        u"parque",
        u"párrafo",
        u"parte",
        u"pasar",
        u"paseo",
        u"pasión",
        u"paso",
        u"pasta",
        u"pata",
        u"patio",
        u"patria",
        u"pausa",
        u"pauta",
        u"pavo",
        u"payaso",
        u"peatón",
        u"pecado",
        u"pecera",
        u"pecho",
        u"pedal",
        u"pedir",
        u"pegar",
        u"peine",
        u"pelar",
        u"peldaño",
        u"pelea",
        u"peligro",
        u"pellejo",
        u"pelo",
        u"peluca",
        u"pena",
        u"pensar",
        u"peñón",
        u"peón",
        u"peor",
        u"pepino",
        u"pequeño",
        u"pera",
        u"percha",
        u"perder",
        u"pereza",
        u"perfil",
        u"perico",
        u"perla",
        u"permiso",
        u"perro",
        u"persona",
        u"pesa",
        u"pesca",
        u"pésimo",
        u"pestaña",
        u"pétalo",
        u"petróleo",
        u"pez",
        u"pezuña",
        u"picar",
        u"pichón",
        u"pie",
        u"piedra",
        u"pierna",
        u"pieza",
        u"pijama",
        u"pilar",
        u"piloto",
        u"pimienta",
        u"pino",
        u"pintor",
        u"pinza",
        u"piña",
        u"piojo",
        u"pipa",
        u"pirata",
        u"pisar",
        u"piscina",
        u"piso",
        u"pista",
        u"pitón",
        u"pizca",
        u"placa",
        u"plan",
        u"plata",
        u"playa",
        u"plaza",
        u"pleito",
        u"pleno",
        u"plomo",
        u"pluma",
        u"plural",
        u"pobre",
        u"poco",
        u"poder",
        u"podio",
        u"poema",
        u"poesía",
        u"poeta",
        u"polen",
        u"policía",
        u"pollo",
        u"polvo",
        u"pomada",
        u"pomelo",
        u"pomo",
        u"pompa",
        u"poner",
        u"porción",
        u"portal",
        u"posada",
        u"poseer",
        u"posible",
        u"poste",
        u"potencia",
        u"potro",
        u"pozo",
        u"prado",
        u"precoz",
        u"pregunta",
        u"premio",
        u"prensa",
        u"preso",
        u"previo",
        u"primo",
        u"príncipe",
        u"prisión",
        u"privar",
        u"proa",
        u"probar",
        u"proceso",
        u"producto",
        u"proeza",
        u"profesor",
        u"programa",
        u"prole",
        u"promesa",
        u"pronto",
        u"propio",
        u"próximo",
        u"prueba",
        u"público",
        u"puchero",
        u"pudor",
        u"pueblo",
        u"puerta",
        u"puesto",
        u"pulga",
        u"pulir",
        u"pulmón",
        u"pulpo",
        u"pulso",
        u"puma",
        u"punto",
        u"puñal",
        u"puño",
        u"pupa",
        u"pupila",
        u"puré",
        u"quedar",
        u"queja",
        u"quemar",
        u"querer",
        u"queso",
        u"quieto",
        u"química",
        u"quince",
        u"quitar",
        u"rábano",
        u"rabia",
        u"rabo",
        u"ración",
        u"radical",
        u"raíz",
        u"rama",
        u"rampa",
        u"rancho",
        u"rango",
        u"rapaz",
        u"rápido",
        u"rapto",
        u"rasgo",
        u"raspa",
        u"rato",
        u"rayo",
        u"raza",
        u"razón",
        u"reacción",
        u"realidad",
        u"rebaño",
        u"rebote",
        u"recaer",
        u"receta",
        u"rechazo",
        u"recoger",
        u"recreo",
        u"recto",
        u"recurso",
        u"red",
        u"redondo",
        u"reducir",
        u"reflejo",
        u"reforma",
        u"refrán",
        u"refugio",
        u"regalo",
        u"regir",
        u"regla",
        u"regreso",
        u"rehén",
        u"reino",
        u"reír",
        u"reja",
        u"relato",
        u"relevo",
        u"relieve",
        u"relleno",
        u"reloj",
        u"remar",
        u"remedio",
        u"remo",
        u"rencor",
        u"rendir",
        u"renta",
        u"reparto",
        u"repetir",
        u"reposo",
        u"reptil",
        u"res",
        u"rescate",
        u"resina",
        u"respeto",
        u"resto",
        u"resumen",
        u"retiro",
        u"retorno",
        u"retrato",
        u"reunir",
        u"revés",
        u"revista",
        u"rey",
        u"rezar",
        u"rico",
        u"riego",
        u"rienda",
        u"riesgo",
        u"rifa",
        u"rígido",
        u"rigor",
        u"rincón",
        u"riñón",
        u"río",
        u"riqueza",
        u"risa",
        u"ritmo",
        u"rito",
    ]
