import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [inspector](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoninspector.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Inspector extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    protected resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [inspector](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoninspector.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_AddAttributesToFindings.html
     */
    toAddAttributesToFindings(): this;
    /**
     * Creates a new assessment target using the ARN of the resource group that is generated by CreateResourceGroup.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTarget.html
     */
    toCreateAssessmentTarget(): this;
    /**
     * Creates an assessment template for the assessment target that is specified by the ARN of the assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTemplate.html
     */
    toCreateAssessmentTemplate(): this;
    /**
     * Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateResourceGroup.html
     */
    toCreateResourceGroup(): this;
    /**
     * Deletes the assessment run that is specified by the ARN of the assessment run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentRun.html
     */
    toDeleteAssessmentRun(): this;
    /**
     * Deletes the assessment target that is specified by the ARN of the assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTarget.html
     */
    toDeleteAssessmentTarget(): this;
    /**
     * Deletes the assessment template that is specified by the ARN of the assessment template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTemplate.html
     */
    toDeleteAssessmentTemplate(): this;
    /**
     * Describes the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentRuns.html
     */
    toDescribeAssessmentRuns(): this;
    /**
     * Describes the assessment targets that are specified by the ARNs of the assessment targets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTargets.html
     */
    toDescribeAssessmentTargets(): this;
    /**
     * Describes the assessment templates that are specified by the ARNs of the assessment templates.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTemplates.html
     */
    toDescribeAssessmentTemplates(): this;
    /**
     * Describes the IAM role that enables Amazon Inspector to access your AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeCrossAccountAccessRole.html
     */
    toDescribeCrossAccountAccessRole(): this;
    /**
     * Describes the findings that are specified by the ARNs of the findings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeFindings.html
     */
    toDescribeFindings(): this;
    /**
     * Describes the resource groups that are specified by the ARNs of the resource groups.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeResourceGroups.html
     */
    toDescribeResourceGroups(): this;
    /**
     * Describes the rules packages that are specified by the ARNs of the rules packages.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeRulesPackages.html
     */
    toDescribeRulesPackages(): this;
    /**
     * Information about the data that is collected for the specified assessment run.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_GetTelemetryMetadata.html
     */
    toGetTelemetryMetadata(): this;
    /**
     * Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRunAgents.html
     */
    toListAssessmentRunAgents(): this;
    /**
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRuns.html
     */
    toListAssessmentRuns(): this;
    /**
     * Lists the ARNs of the assessment targets within this AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTargets.html
     */
    toListAssessmentTargets(): this;
    /**
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTemplates.html
     */
    toListAssessmentTemplates(): this;
    /**
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListEventSubscriptions.html
     */
    toListEventSubscriptions(): this;
    /**
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListFindings.html
     */
    toListFindings(): this;
    /**
     * Lists all available Amazon Inspector rules packages.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListRulesPackages.html
     */
    toListRulesPackages(): this;
    /**
     * Lists all tags associated with an assessment template.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Previews the agents installed on the EC2 instances that are part of the specified assessment target.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_PreviewAgents.html
     */
    toPreviewAgents(): this;
    /**
     * Registers the IAM role that Amazon Inspector uses to list your EC2 instances at the start of the assessment run or when you call the PreviewAgents action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_RegisterCrossAccountAccessRole.html
     */
    toRegisterCrossAccountAccessRole(): this;
    /**
     * Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_RemoveAttributesFromFindings.html
     */
    toRemoveAttributesFromFindings(): this;
    /**
     * Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_SetTagsForResource.html
     */
    toSetTagsForResource(): this;
    /**
     * Starts the assessment run specified by the ARN of the assessment template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_StartAssessmentRun.html
     */
    toStartAssessmentRun(): this;
    /**
     * Stops the assessment run that is specified by the ARN of the assessment run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_StopAssessmentRun.html
     */
    toStopAssessmentRun(): this;
    /**
     * Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_SubscribeToEvent.html
     */
    toSubscribeToEvent(): this;
    /**
     * Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_UnsubscribeFromEvent.html
     */
    toUnsubscribeFromEvent(): this;
    /**
     * Updates the assessment target that is specified by the ARN of the assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_UpdateAssessmentTarget.html
     */
    toUpdateAssessmentTarget(): this;
}
