"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mechanicalturk = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmechanicalturk.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Mechanicalturk extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmechanicalturk.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'mechanicalturk';
        this.actionList = {
            "AcceptQualificationRequest": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AcceptQualificationRequestOperation.html",
                "description": "The AcceptQualificationRequest operation grants a Worker's request for a Qualification",
                "accessLevel": "Write"
            },
            "ApproveAssignment": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ApproveAssignmentOperation.html",
                "description": "The ApproveAssignment operation approves the results of a completed assignment",
                "accessLevel": "Write"
            },
            "AssociateQualificationWithWorker": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AssociateQualificationWithWorkerOperation.html",
                "description": "The AssociateQualificationWithWorker operation gives a Worker a Qualification",
                "accessLevel": "Write"
            },
            "CreateAdditionalAssignmentsForHIT": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateAdditionalAssignmentsForHITOperation.html",
                "description": "The CreateAdditionalAssignmentsForHIT operation increases the maximum number of assignments of an existing HIT",
                "accessLevel": "Write"
            },
            "CreateHIT": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITOperation.html",
                "description": "The CreateHIT operation creates a new HIT (Human Intelligence Task)",
                "accessLevel": "Write"
            },
            "CreateHITType": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITTypeOperation.html",
                "description": "The CreateHITType operation creates a new HIT type",
                "accessLevel": "Write"
            },
            "CreateHITWithHITType": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITWithHITTypeOperation.html",
                "description": "The CreateHITWithHITType operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the CreateHITType operation",
                "accessLevel": "Write"
            },
            "CreateQualificationType": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateQualificationTypeOperation.html",
                "description": "The CreateQualificationType operation creates a new Qualification type, which is represented by a QualificationType data structure",
                "accessLevel": "Write"
            },
            "CreateWorkerBlock": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateWorkerBlockOperation.html",
                "description": "The CreateWorkerBlock operation allows you to prevent a Worker from working on your HITs",
                "accessLevel": "Write"
            },
            "DeleteHIT": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteHITOperation.html",
                "description": "The DeleteHIT operation disposes of a HIT that is no longer needed",
                "accessLevel": "Write"
            },
            "DeleteQualificationType": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteQualificationTypeOperation.html",
                "description": "The DeleteQualificationType disposes a Qualification type and disposes any HIT types that are associated with the Qualification type",
                "accessLevel": "Write"
            },
            "DeleteWorkerBlock": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteWorkerBlockOperation.html",
                "description": "The DeleteWorkerBlock operation allows you to reinstate a blocked Worker to work on your HITs",
                "accessLevel": "Write"
            },
            "DisassociateQualificationFromWorker": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DisassociateQualificationFromWorkerOperation.html",
                "description": "The DisassociateQualificationFromWorker revokes a previously granted Qualification from a user",
                "accessLevel": "Write"
            },
            "GetAccountBalance": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAccountBalanceOperation.html",
                "description": "The GetAccountBalance operation retrieves the amount of money in your Amazon Mechanical Turk account",
                "accessLevel": "Read"
            },
            "GetAssignment": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAssignmentOperation.html",
                "description": "The GetAssignment retrieves an assignment with an AssignmentStatus value of Submitted, Approved, or Rejected, using the assignment's ID",
                "accessLevel": "Read"
            },
            "GetFileUploadURL": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetFileUploadURLOperation.html",
                "description": "The GetFileUploadURL operation generates and returns a temporary URL",
                "accessLevel": "Read"
            },
            "GetHIT": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetHITOperation.html",
                "description": "The GetHIT operation retrieves the details of the specified HIT",
                "accessLevel": "Read"
            },
            "GetQualificationScore": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationScoreOperation.html",
                "description": "The GetQualificationScore operation returns the value of a Worker's Qualification for a given Qualification type",
                "accessLevel": "Read"
            },
            "GetQualificationType": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationTypeOperation.html",
                "description": "The GetQualificationType operation retrieves information about a Qualification type using its ID",
                "accessLevel": "Read"
            },
            "ListAssignmentsForHIT": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListAssignmentsForHITOperation.html",
                "description": "The ListAssignmentsForHIT operation retrieves completed assignments for a HIT",
                "accessLevel": "List"
            },
            "ListBonusPayments": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListBonusPaymentsOperation.html",
                "description": "The ListBonusPayments operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment",
                "accessLevel": "List"
            },
            "ListHITs": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsOperation.html",
                "description": "The ListHITs operation returns all of a Requester's HITs",
                "accessLevel": "List"
            },
            "ListHITsForQualificationType": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsForQualificationTypeOperation.html",
                "description": "The ListHITsForQualificationType operation returns the HITs that use the given QualififcationType for a QualificationRequirement",
                "accessLevel": "List"
            },
            "ListQualificationRequests": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationRequestsOperation.html",
                "description": "The ListQualificationRequests operation retrieves requests for Qualifications of a particular Qualification type",
                "accessLevel": "List"
            },
            "ListQualificationTypes": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationTypesOperation.html",
                "description": "The ListQualificationTypes operation searches for Qualification types using the specified search query, and returns a list of Qualification types",
                "accessLevel": "List"
            },
            "ListReviewPolicyResultsForHIT": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewPolicyResultsForHITOperation.html",
                "description": "The ListReviewPolicyResultsForHIT operation retrieves the computed results and the actions taken in the course of executing your Review Policies during a CreateHIT operation",
                "accessLevel": "List"
            },
            "ListReviewableHITs": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewableHITsOperation.html",
                "description": "The ListReviewableHITs operation returns all of a Requester's HITs that have not been approved or rejected",
                "accessLevel": "List"
            },
            "ListWorkerBlocks": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkerBlocksOperation.html",
                "description": "The ListWorkersBlocks operation retrieves a list of Workers who are blocked from working on your HITs",
                "accessLevel": "List"
            },
            "ListWorkersWithQualificationType": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkersWithQualificationTypeOperation.html",
                "description": "The ListWorkersWithQualificationType operation returns all of the Workers with a given Qualification type",
                "accessLevel": "List"
            },
            "NotifyWorkers": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_NotifyWorkersOperation.html",
                "description": "The NotifyWorkers operation sends an email to one or more Workers that you specify with the Worker ID",
                "accessLevel": "Write"
            },
            "RejectAssignment": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectAssignmentOperation.html",
                "description": "The RejectAssignment operation rejects the results of a completed assignment",
                "accessLevel": "Write"
            },
            "RejectQualificationRequest": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectQualificationRequestOperation.html",
                "description": "The RejectQualificationRequest operation rejects a user's request for a Qualification",
                "accessLevel": "Write"
            },
            "SendBonus": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendBonusOperation.html",
                "description": "The SendBonus operation issues a payment of money from your account to a Worker",
                "accessLevel": "Write"
            },
            "SendTestEventNotification": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendTestEventNotificationOperation.html",
                "description": "The SendTestEventNotification operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification",
                "accessLevel": "Write"
            },
            "UpdateExpirationForHIT": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateExpirationForHITOperation.html",
                "description": "The UpdateExpirationForHIT operation allows you extend the expiration time of a HIT beyond is current expiration or expire a HIT immediately",
                "accessLevel": "Write"
            },
            "UpdateHITReviewStatus": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITReviewStatusOperation.html",
                "description": "The UpdateHITReviewStatus operation toggles the status of a HIT",
                "accessLevel": "Write"
            },
            "UpdateHITTypeOfHIT": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITTypeOfHITOperation.html",
                "description": "The UpdateHITTypeOfHIT operation allows you to change the HITType properties of a HIT",
                "accessLevel": "Write"
            },
            "UpdateNotificationSettings": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateNotificationSettingsOperation.html",
                "description": "The UpdateNotificationSettings operation creates, updates, disables or re-enables notifications for a HIT type",
                "accessLevel": "Write"
            },
            "UpdateQualificationType": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateQualificationTypeOperation.html",
                "description": "The UpdateQualificationType operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * The AcceptQualificationRequest operation grants a Worker's request for a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AcceptQualificationRequestOperation.html
     */
    toAcceptQualificationRequest() {
        this.add('mechanicalturk:AcceptQualificationRequest');
        return this;
    }
    /**
     * The ApproveAssignment operation approves the results of a completed assignment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ApproveAssignmentOperation.html
     */
    toApproveAssignment() {
        this.add('mechanicalturk:ApproveAssignment');
        return this;
    }
    /**
     * The AssociateQualificationWithWorker operation gives a Worker a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AssociateQualificationWithWorkerOperation.html
     */
    toAssociateQualificationWithWorker() {
        this.add('mechanicalturk:AssociateQualificationWithWorker');
        return this;
    }
    /**
     * The CreateAdditionalAssignmentsForHIT operation increases the maximum number of assignments of an existing HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateAdditionalAssignmentsForHITOperation.html
     */
    toCreateAdditionalAssignmentsForHIT() {
        this.add('mechanicalturk:CreateAdditionalAssignmentsForHIT');
        return this;
    }
    /**
     * The CreateHIT operation creates a new HIT (Human Intelligence Task)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITOperation.html
     */
    toCreateHIT() {
        this.add('mechanicalturk:CreateHIT');
        return this;
    }
    /**
     * The CreateHITType operation creates a new HIT type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITTypeOperation.html
     */
    toCreateHITType() {
        this.add('mechanicalturk:CreateHITType');
        return this;
    }
    /**
     * The CreateHITWithHITType operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the CreateHITType operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITWithHITTypeOperation.html
     */
    toCreateHITWithHITType() {
        this.add('mechanicalturk:CreateHITWithHITType');
        return this;
    }
    /**
     * The CreateQualificationType operation creates a new Qualification type, which is represented by a QualificationType data structure
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateQualificationTypeOperation.html
     */
    toCreateQualificationType() {
        this.add('mechanicalturk:CreateQualificationType');
        return this;
    }
    /**
     * The CreateWorkerBlock operation allows you to prevent a Worker from working on your HITs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateWorkerBlockOperation.html
     */
    toCreateWorkerBlock() {
        this.add('mechanicalturk:CreateWorkerBlock');
        return this;
    }
    /**
     * The DeleteHIT operation disposes of a HIT that is no longer needed
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteHITOperation.html
     */
    toDeleteHIT() {
        this.add('mechanicalturk:DeleteHIT');
        return this;
    }
    /**
     * The DeleteQualificationType disposes a Qualification type and disposes any HIT types that are associated with the Qualification type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteQualificationTypeOperation.html
     */
    toDeleteQualificationType() {
        this.add('mechanicalturk:DeleteQualificationType');
        return this;
    }
    /**
     * The DeleteWorkerBlock operation allows you to reinstate a blocked Worker to work on your HITs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteWorkerBlockOperation.html
     */
    toDeleteWorkerBlock() {
        this.add('mechanicalturk:DeleteWorkerBlock');
        return this;
    }
    /**
     * The DisassociateQualificationFromWorker revokes a previously granted Qualification from a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DisassociateQualificationFromWorkerOperation.html
     */
    toDisassociateQualificationFromWorker() {
        this.add('mechanicalturk:DisassociateQualificationFromWorker');
        return this;
    }
    /**
     * The GetAccountBalance operation retrieves the amount of money in your Amazon Mechanical Turk account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAccountBalanceOperation.html
     */
    toGetAccountBalance() {
        this.add('mechanicalturk:GetAccountBalance');
        return this;
    }
    /**
     * The GetAssignment retrieves an assignment with an AssignmentStatus value of Submitted, Approved, or Rejected, using the assignment's ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAssignmentOperation.html
     */
    toGetAssignment() {
        this.add('mechanicalturk:GetAssignment');
        return this;
    }
    /**
     * The GetFileUploadURL operation generates and returns a temporary URL
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetFileUploadURLOperation.html
     */
    toGetFileUploadURL() {
        this.add('mechanicalturk:GetFileUploadURL');
        return this;
    }
    /**
     * The GetHIT operation retrieves the details of the specified HIT
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetHITOperation.html
     */
    toGetHIT() {
        this.add('mechanicalturk:GetHIT');
        return this;
    }
    /**
     * The GetQualificationScore operation returns the value of a Worker's Qualification for a given Qualification type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationScoreOperation.html
     */
    toGetQualificationScore() {
        this.add('mechanicalturk:GetQualificationScore');
        return this;
    }
    /**
     * The GetQualificationType operation retrieves information about a Qualification type using its ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationTypeOperation.html
     */
    toGetQualificationType() {
        this.add('mechanicalturk:GetQualificationType');
        return this;
    }
    /**
     * The ListAssignmentsForHIT operation retrieves completed assignments for a HIT
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListAssignmentsForHITOperation.html
     */
    toListAssignmentsForHIT() {
        this.add('mechanicalturk:ListAssignmentsForHIT');
        return this;
    }
    /**
     * The ListBonusPayments operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListBonusPaymentsOperation.html
     */
    toListBonusPayments() {
        this.add('mechanicalturk:ListBonusPayments');
        return this;
    }
    /**
     * The ListHITs operation returns all of a Requester's HITs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsOperation.html
     */
    toListHITs() {
        this.add('mechanicalturk:ListHITs');
        return this;
    }
    /**
     * The ListHITsForQualificationType operation returns the HITs that use the given QualififcationType for a QualificationRequirement
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsForQualificationTypeOperation.html
     */
    toListHITsForQualificationType() {
        this.add('mechanicalturk:ListHITsForQualificationType');
        return this;
    }
    /**
     * The ListQualificationRequests operation retrieves requests for Qualifications of a particular Qualification type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationRequestsOperation.html
     */
    toListQualificationRequests() {
        this.add('mechanicalturk:ListQualificationRequests');
        return this;
    }
    /**
     * The ListQualificationTypes operation searches for Qualification types using the specified search query, and returns a list of Qualification types
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationTypesOperation.html
     */
    toListQualificationTypes() {
        this.add('mechanicalturk:ListQualificationTypes');
        return this;
    }
    /**
     * The ListReviewPolicyResultsForHIT operation retrieves the computed results and the actions taken in the course of executing your Review Policies during a CreateHIT operation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewPolicyResultsForHITOperation.html
     */
    toListReviewPolicyResultsForHIT() {
        this.add('mechanicalturk:ListReviewPolicyResultsForHIT');
        return this;
    }
    /**
     * The ListReviewableHITs operation returns all of a Requester's HITs that have not been approved or rejected
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewableHITsOperation.html
     */
    toListReviewableHITs() {
        this.add('mechanicalturk:ListReviewableHITs');
        return this;
    }
    /**
     * The ListWorkersBlocks operation retrieves a list of Workers who are blocked from working on your HITs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkerBlocksOperation.html
     */
    toListWorkerBlocks() {
        this.add('mechanicalturk:ListWorkerBlocks');
        return this;
    }
    /**
     * The ListWorkersWithQualificationType operation returns all of the Workers with a given Qualification type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkersWithQualificationTypeOperation.html
     */
    toListWorkersWithQualificationType() {
        this.add('mechanicalturk:ListWorkersWithQualificationType');
        return this;
    }
    /**
     * The NotifyWorkers operation sends an email to one or more Workers that you specify with the Worker ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_NotifyWorkersOperation.html
     */
    toNotifyWorkers() {
        this.add('mechanicalturk:NotifyWorkers');
        return this;
    }
    /**
     * The RejectAssignment operation rejects the results of a completed assignment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectAssignmentOperation.html
     */
    toRejectAssignment() {
        this.add('mechanicalturk:RejectAssignment');
        return this;
    }
    /**
     * The RejectQualificationRequest operation rejects a user's request for a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectQualificationRequestOperation.html
     */
    toRejectQualificationRequest() {
        this.add('mechanicalturk:RejectQualificationRequest');
        return this;
    }
    /**
     * The SendBonus operation issues a payment of money from your account to a Worker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendBonusOperation.html
     */
    toSendBonus() {
        this.add('mechanicalturk:SendBonus');
        return this;
    }
    /**
     * The SendTestEventNotification operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendTestEventNotificationOperation.html
     */
    toSendTestEventNotification() {
        this.add('mechanicalturk:SendTestEventNotification');
        return this;
    }
    /**
     * The UpdateExpirationForHIT operation allows you extend the expiration time of a HIT beyond is current expiration or expire a HIT immediately
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateExpirationForHITOperation.html
     */
    toUpdateExpirationForHIT() {
        this.add('mechanicalturk:UpdateExpirationForHIT');
        return this;
    }
    /**
     * The UpdateHITReviewStatus operation toggles the status of a HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITReviewStatusOperation.html
     */
    toUpdateHITReviewStatus() {
        this.add('mechanicalturk:UpdateHITReviewStatus');
        return this;
    }
    /**
     * The UpdateHITTypeOfHIT operation allows you to change the HITType properties of a HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITTypeOfHITOperation.html
     */
    toUpdateHITTypeOfHIT() {
        this.add('mechanicalturk:UpdateHITTypeOfHIT');
        return this;
    }
    /**
     * The UpdateNotificationSettings operation creates, updates, disables or re-enables notifications for a HIT type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateNotificationSettingsOperation.html
     */
    toUpdateNotificationSettings() {
        this.add('mechanicalturk:UpdateNotificationSettings');
        return this;
    }
    /**
     * The UpdateQualificationType operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateQualificationTypeOperation.html
     */
    toUpdateQualificationType() {
        this.add('mechanicalturk:UpdateQualificationType');
        return this;
    }
}
exports.Mechanicalturk = Mechanicalturk;
//# sourceMappingURL=data:application/json;base64,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