"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2messages = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [ec2messages](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmessagedeliveryservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Ec2messages extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [ec2messages](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmessagedeliveryservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'ec2messages';
        this.actionList = {
            "AcknowledgeMessage": {
                "url": "",
                "description": "Acknowledges a message, ensuring it will not be delivered again",
                "accessLevel": "Write"
            },
            "DeleteMessage": {
                "url": "",
                "description": "Deletes a message",
                "accessLevel": "Write"
            },
            "FailMessage": {
                "url": "",
                "description": "Fails a message, signifying the message could not be processed successfully, ensuring it cannot be replied to or delivered again",
                "accessLevel": "Write"
            },
            "GetEndpoint": {
                "url": "",
                "description": "Routes traffic to the correct endpoint based on the given destination for the messages",
                "accessLevel": "Read"
            },
            "GetMessages": {
                "url": "",
                "description": "Delivers messages to clients/instances using long polling",
                "accessLevel": "Read"
            },
            "SendReply": {
                "url": "",
                "description": "Sends replies from clients/instances to upstream service",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Acknowledges a message, ensuring it will not be delivered again
     *
     * Access Level: Write
     */
    toAcknowledgeMessage() {
        this.add('ec2messages:AcknowledgeMessage');
        return this;
    }
    /**
     * Deletes a message
     *
     * Access Level: Write
     */
    toDeleteMessage() {
        this.add('ec2messages:DeleteMessage');
        return this;
    }
    /**
     * Fails a message, signifying the message could not be processed successfully, ensuring it cannot be replied to or delivered again
     *
     * Access Level: Write
     */
    toFailMessage() {
        this.add('ec2messages:FailMessage');
        return this;
    }
    /**
     * Routes traffic to the correct endpoint based on the given destination for the messages
     *
     * Access Level: Read
     */
    toGetEndpoint() {
        this.add('ec2messages:GetEndpoint');
        return this;
    }
    /**
     * Delivers messages to clients/instances using long polling
     *
     * Access Level: Read
     */
    toGetMessages() {
        this.add('ec2messages:GetMessages');
        return this;
    }
    /**
     * Sends replies from clients/instances to upstream service
     *
     * Access Level: Write
     */
    toSendReply() {
        this.add('ec2messages:SendReply');
        return this;
    }
}
exports.Ec2messages = Ec2messages;
//# sourceMappingURL=data:application/json;base64,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