"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RdsData = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [rds-data](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonrdsdataapi.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class RdsData extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [rds-data](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonrdsdataapi.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'rds-data';
        this.actionList = {
            "BatchExecuteStatement": {
                "url": "https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_BatchExecuteStatement.html",
                "description": "Runs a batch SQL statement over an array of data.",
                "accessLevel": "Write"
            },
            "BeginTransaction": {
                "url": "https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_BeginTransaction.html",
                "description": "Starts a SQL transaction.",
                "accessLevel": "Write"
            },
            "CommitTransaction": {
                "url": "https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_CommitTransaction.html",
                "description": "Ends a SQL transaction started with the BeginTransaction operation and commits the changes.",
                "accessLevel": "Write",
                "dependentActions": [
                    "rds-data:BeginTransaction"
                ]
            },
            "ExecuteSql": {
                "url": "https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_ExecuteSql.html",
                "description": "Runs one or more SQL statements. This operation is deprecated. Use the BatchExecuteStatement or ExecuteStatement operation.",
                "accessLevel": "Write"
            },
            "ExecuteStatement": {
                "url": "https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_ExecuteStatement.html",
                "description": "Runs a SQL statement against a database.",
                "accessLevel": "Write"
            },
            "RollbackTransaction": {
                "url": "https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_RollbackTransaction.html",
                "description": "Performs a rollback of a transaction. Rolling back a transaction cancels its changes.",
                "accessLevel": "Write",
                "dependentActions": [
                    "rds-data:BeginTransaction"
                ]
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Runs a batch SQL statement over an array of data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_BatchExecuteStatement.html
     */
    toBatchExecuteStatement() {
        this.add('rds-data:BatchExecuteStatement');
        return this;
    }
    /**
     * Starts a SQL transaction.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_BeginTransaction.html
     */
    toBeginTransaction() {
        this.add('rds-data:BeginTransaction');
        return this;
    }
    /**
     * Ends a SQL transaction started with the BeginTransaction operation and commits the changes.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - rds-data:BeginTransaction
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_CommitTransaction.html
     */
    toCommitTransaction() {
        this.add('rds-data:CommitTransaction');
        return this;
    }
    /**
     * Runs one or more SQL statements. This operation is deprecated. Use the BatchExecuteStatement or ExecuteStatement operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_ExecuteSql.html
     */
    toExecuteSql() {
        this.add('rds-data:ExecuteSql');
        return this;
    }
    /**
     * Runs a SQL statement against a database.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_ExecuteStatement.html
     */
    toExecuteStatement() {
        this.add('rds-data:ExecuteStatement');
        return this;
    }
    /**
     * Performs a rollback of a transaction. Rolling back a transaction cancels its changes.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - rds-data:BeginTransaction
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_RollbackTransaction.html
     */
    toRollbackTransaction() {
        this.add('rds-data:RollbackTransaction');
        return this;
    }
}
exports.RdsData = RdsData;
//# sourceMappingURL=data:application/json;base64,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