"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Translate = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [translate](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranslate.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Translate extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [translate](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranslate.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'translate';
        this.actionList = {
            "DeleteTerminology": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_DeleteTerminology.html",
                "description": "A synchronous action that deletes a custom terminology.",
                "accessLevel": "Write"
            },
            "DescribeTextTranslationJob": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_DescribeTextTranslationJob.html",
                "description": "Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and target languages, input/output S3 buckets, and so on.",
                "accessLevel": "Read"
            },
            "GetTerminology": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_GetTerminology.html",
                "description": "Retrieves a custom terminology.",
                "accessLevel": "Read"
            },
            "ImportTerminology": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_ImportTerminology.html",
                "description": "Creates or updates a custom terminology, depending on whether or not one already exists for the given terminology name.",
                "accessLevel": "Write"
            },
            "ListTerminologies": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_ListTerminologies.html",
                "description": "Provides a list of custom terminologies associated with your account.",
                "accessLevel": "Read"
            },
            "ListTextTranslationJobs": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_ListTextTranslationJobs.html",
                "description": "Gets a list of the batch translation jobs that you have submitted.",
                "accessLevel": "Read"
            },
            "StartTextTranslationJob": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_StartTextTranslationJob.html",
                "description": "Starts an asynchronous batch translation job. Batch translation jobs can be used to translate large volumes of text across multiple documents at once.",
                "accessLevel": "Write"
            },
            "StopTextTranslationJob": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_StopTextTranslationJob.html",
                "description": "Stops an asynchronous batch translation job that is in progress.",
                "accessLevel": "Write"
            },
            "TranslateText": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_TranslateText.html",
                "description": "Translate text from a source language to a target language.",
                "accessLevel": "Read"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * A synchronous action that deletes a custom terminology.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DeleteTerminology.html
     */
    toDeleteTerminology() {
        this.add('translate:DeleteTerminology');
        return this;
    }
    /**
     * Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and target languages, input/output S3 buckets, and so on.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DescribeTextTranslationJob.html
     */
    toDescribeTextTranslationJob() {
        this.add('translate:DescribeTextTranslationJob');
        return this;
    }
    /**
     * Retrieves a custom terminology.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_GetTerminology.html
     */
    toGetTerminology() {
        this.add('translate:GetTerminology');
        return this;
    }
    /**
     * Creates or updates a custom terminology, depending on whether or not one already exists for the given terminology name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ImportTerminology.html
     */
    toImportTerminology() {
        this.add('translate:ImportTerminology');
        return this;
    }
    /**
     * Provides a list of custom terminologies associated with your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTerminologies.html
     */
    toListTerminologies() {
        this.add('translate:ListTerminologies');
        return this;
    }
    /**
     * Gets a list of the batch translation jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTextTranslationJobs.html
     */
    toListTextTranslationJobs() {
        this.add('translate:ListTextTranslationJobs');
        return this;
    }
    /**
     * Starts an asynchronous batch translation job. Batch translation jobs can be used to translate large volumes of text across multiple documents at once.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StartTextTranslationJob.html
     */
    toStartTextTranslationJob() {
        this.add('translate:StartTextTranslationJob');
        return this;
    }
    /**
     * Stops an asynchronous batch translation job that is in progress.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StopTextTranslationJob.html
     */
    toStopTextTranslationJob() {
        this.add('translate:StopTextTranslationJob');
        return this;
    }
    /**
     * Translate text from a source language to a target language.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_TranslateText.html
     */
    toTranslateText() {
        this.add('translate:TranslateText');
        return this;
    }
}
exports.Translate = Translate;
//# sourceMappingURL=data:application/json;base64,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