import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [arsenal](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_applicationdiscoveryarsenal.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Arsenal extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    protected resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [arsenal](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_applicationdiscoveryarsenal.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to register AWS provided data collectors to the Application Discovery Service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/setting-up.html#setting-up-user-policy
     */
    toRegisterOnPremisesAgent(): this;
}
