import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [ce](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awscostexplorerservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Ce extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    protected resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [ce](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awscostexplorerservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a new Cost Category with the requested name and rules.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CreateCostCategoryDefinition.html
     */
    toCreateCostCategoryDefinition(): this;
    /**
     * Grants permission to delete a Cost Category.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DeleteCostCategoryDefinition.html
     */
    toDeleteCostCategoryDefinition(): this;
    /**
     * Grants permission to retrieve descriptions such as the name, ARN, rules, definition, and effective dates of a Cost Category.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DescribeCostCategoryDefinition.html
     */
    toDescribeCostCategoryDefinition(): this;
    /**
     * Grants permission to retrieve the cost and usage metrics for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetCostAndUsage.html
     */
    toGetCostAndUsage(): this;
    /**
     * Grants permission to retrieve the cost and usage metrics with resources for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetCostAndUsageWithResources.html
     */
    toGetCostAndUsageWithResources(): this;
    /**
     * Grants permission to retrieve a cost forecast for a forecast time period.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetCostForecast.html
     */
    toGetCostForecast(): this;
    /**
     * Grants permission to retrieve all available filter values for a filter for a period of time.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html
     */
    toGetDimensionValues(): this;
    /**
     * Grants permission to retrieve the reservation coverage for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetReservationCoverage.html
     */
    toGetReservationCoverage(): this;
    /**
     * Grants permission to retrieve the reservation recommendations for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetReservationPurchaseRecommendation.html
     */
    toGetReservationPurchaseRecommendation(): this;
    /**
     * Grants permission to retrieve the reservation utilization for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetReservationUtilization.html
     */
    toGetReservationUtilization(): this;
    /**
     * Grants permission to retrieve the rightsizing recommendations for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetRightsizingRecommendation.html
     */
    toGetRightsizingRecommendation(): this;
    /**
     * Grants permission to retrieve the Savings Plans coverage for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetSavingsPlansCoverage.html
     */
    toGetSavingsPlansCoverage(): this;
    /**
     * Grants permission to retrieve the Savings Plans recommendations for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetSavingsPlansPurchaseRecommendation.html
     */
    toGetSavingsPlansPurchaseRecommendation(): this;
    /**
     * Grants permission to retrieve the Savings Plans utilization for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetSavingsPlansUtilization.html
     */
    toGetSavingsPlansUtilization(): this;
    /**
     * Grants permission to retrieve the Savings Plans utilization details for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetSavingsPlansUtilizationDetails.html
     */
    toGetSavingsPlansUtilizationDetails(): this;
    /**
     * Grants permission to query tags for a specified time period.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetTags.html
     */
    toGetTags(): this;
    /**
     * Grants permission to retrieve a usage forecast for a forecast time period.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetUsageForecast.html
     */
    toGetUsageForecast(): this;
    /**
     * Grants permission to retrieve names, ARN, and effective dates for all Cost Categories.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_ListCostCategoryDefinitions.html
     */
    toListCostCategoryDefinitions(): this;
    /**
     * Grants permission to update an existing Cost Category.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_UpdateCostCategoryDefinition.html
     */
    toUpdateCostCategoryDefinition(): this;
}
