"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Importexport = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [importexport](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsimportexportdiskservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Importexport extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [importexport](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsimportexportdiskservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'importexport';
        this.actionList = {
            "CancelJob": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebCancelJob.html",
                "description": "This action cancels a specified job. Only the job owner can cancel it. The action fails if the job has already started or is complete.",
                "accessLevel": "Write"
            },
            "CreateJob": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebCreateJob.html",
                "description": "This action initiates the process of scheduling an upload or download of your data.",
                "accessLevel": "Write"
            },
            "GetShippingLabel": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebGetShippingLabel.html",
                "description": "This action generates a pre-paid shipping label that you will use to ship your device to AWS for processing.",
                "accessLevel": "Read"
            },
            "GetStatus": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebGetStatus.html",
                "description": "This action returns information about a job, including where the job is in the processing pipeline, the status of the results, and the signature value associated with the job.",
                "accessLevel": "Read"
            },
            "ListJobs": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebListJobs.html",
                "description": "This action returns the jobs associated with the requester.",
                "accessLevel": "List"
            },
            "UpdateJob": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebUpdateJob.html",
                "description": "You use this action to change the parameters specified in the original manifest file by supplying a new manifest file.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * This action cancels a specified job. Only the job owner can cancel it. The action fails if the job has already started or is complete.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebCancelJob.html
     */
    toCancelJob() {
        this.add('importexport:CancelJob');
        return this;
    }
    /**
     * This action initiates the process of scheduling an upload or download of your data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebCreateJob.html
     */
    toCreateJob() {
        this.add('importexport:CreateJob');
        return this;
    }
    /**
     * This action generates a pre-paid shipping label that you will use to ship your device to AWS for processing.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebGetShippingLabel.html
     */
    toGetShippingLabel() {
        this.add('importexport:GetShippingLabel');
        return this;
    }
    /**
     * This action returns information about a job, including where the job is in the processing pipeline, the status of the results, and the signature value associated with the job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebGetStatus.html
     */
    toGetStatus() {
        this.add('importexport:GetStatus');
        return this;
    }
    /**
     * This action returns the jobs associated with the requester.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebListJobs.html
     */
    toListJobs() {
        this.add('importexport:ListJobs');
        return this;
    }
    /**
     * You use this action to change the parameters specified in the original manifest file by supplying a new manifest file.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebUpdateJob.html
     */
    toUpdateJob() {
        this.add('importexport:UpdateJob');
        return this;
    }
}
exports.Importexport = Importexport;
//# sourceMappingURL=data:application/json;base64,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