"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceMeteringService = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-marketplace-metering-service](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplacemeteringservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceMeteringService extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-marketplace-metering-service](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplacemeteringservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'aws-marketplace-metering-service';
        this.actionList = {
            "BatchMeterUsage": {
                "url": "https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_BatchMeterUsage.html",
                "description": "Called from a SaaS application listed on the AWS Marketplace to post metering records for a set of customers.",
                "accessLevel": "Write"
            },
            "MeterUsage": {
                "url": "https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_MeterUsage.html",
                "description": "Emits metering records.",
                "accessLevel": "Write"
            },
            "RegisterUsage": {
                "url": "https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_RegisterUsage.html",
                "description": "Allows you to verify that the customer running your paid software is subscribed to your product on AWS Marketplace, enabling you to guard against unauthorized use. Meters software use per ECS task, per hour, with usage prorated to the second.",
                "accessLevel": "Write"
            },
            "ResolveCustomer": {
                "url": "https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_ResolveCustomer.html",
                "description": "Resolves a registration token to obtain a CustomerIdentifier and product code.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Called from a SaaS application listed on the AWS Marketplace to post metering records for a set of customers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_BatchMeterUsage.html
     */
    toBatchMeterUsage() {
        this.add('aws-marketplace-metering-service:BatchMeterUsage');
        return this;
    }
    /**
     * Emits metering records.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_MeterUsage.html
     */
    toMeterUsage() {
        this.add('aws-marketplace-metering-service:MeterUsage');
        return this;
    }
    /**
     * Allows you to verify that the customer running your paid software is subscribed to your product on AWS Marketplace, enabling you to guard against unauthorized use. Meters software use per ECS task, per hour, with usage prorated to the second.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_RegisterUsage.html
     */
    toRegisterUsage() {
        this.add('aws-marketplace-metering-service:RegisterUsage');
        return this;
    }
    /**
     * Resolves a registration token to obtain a CustomerIdentifier and product code.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_ResolveCustomer.html
     */
    toResolveCustomer() {
        this.add('aws-marketplace-metering-service:ResolveCustomer');
        return this;
    }
}
exports.AwsMarketplaceMeteringService = AwsMarketplaceMeteringService;
//# sourceMappingURL=data:application/json;base64,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