"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Support = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [support](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awssupport.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Support extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [support](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awssupport.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'support';
        this.actionList = {
            "AddAttachmentsToSet": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddAttachmentsToSet.html",
                "description": "Adds one or more attachments to an AWS Support case.",
                "accessLevel": "Write"
            },
            "AddCommunicationToCase": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddCommunicationToCase.html",
                "description": "Adds a customer communication to an AWS Support case.",
                "accessLevel": "Write"
            },
            "CreateCase": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CreateCase.html",
                "description": "Creates a new AWS Support case.",
                "accessLevel": "Write"
            },
            "DescribeAttachment": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeAttachment.html",
                "description": "Returns the description for an attachment.",
                "accessLevel": "Read"
            },
            "DescribeCaseAttributes": {
                "url": "",
                "description": "This is an internally managed function which allows secondary services to read AWS Support case attributes.",
                "accessLevel": "Read"
            },
            "DescribeCases": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCases.html",
                "description": "Returns a list of AWS Support cases that matches the given inputs.",
                "accessLevel": "Read"
            },
            "DescribeCommunications": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCommunications.html",
                "description": "Returns the communications and attachments for one or more AWS Support cases.",
                "accessLevel": "Read"
            },
            "DescribeIssueTypes": {
                "url": "",
                "description": "Returns issue types for AWS Support cases.",
                "accessLevel": "Read"
            },
            "DescribeServices": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeServices.html",
                "description": "Returns the current list of AWS services and categories that applies to each service.",
                "accessLevel": "Read"
            },
            "DescribeSeverityLevels": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeSeverityLevels.html",
                "description": "Returns the list of severity levels that can be assigned to an AWS Support case.",
                "accessLevel": "Read"
            },
            "DescribeSupportLevel": {
                "url": "",
                "description": "Returns the support level for an AWS Account identifier.",
                "accessLevel": "Read"
            },
            "DescribeTrustedAdvisorCheckRefreshStatuses": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckRefreshStatuses.html",
                "description": "Returns the status of a Trusted Advisor refresh check based on a list of check identifiers.",
                "accessLevel": "Read"
            },
            "DescribeTrustedAdvisorCheckResult": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckResult.html",
                "description": "Returns the results of the Trusted Advisor check that has the specified check identifier.",
                "accessLevel": "Read"
            },
            "DescribeTrustedAdvisorCheckSummaries": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckSummaries.html",
                "description": "Returns the summaries of the results of the Trusted Advisor checks that have the specified check identifiers.",
                "accessLevel": "Read"
            },
            "DescribeTrustedAdvisorChecks": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorChecks.html",
                "description": "Returns a list of all available Trusted Advisor checks, including name, identifier, category and description.",
                "accessLevel": "Read"
            },
            "InitiateCallForCase": {
                "url": "",
                "description": "This is an internally managed function to initiate a call on AWS Support Center.",
                "accessLevel": "Write"
            },
            "InitiateChatForCase": {
                "url": "",
                "description": "This is an internally managed function to initiate a chat on AWS Support Center.",
                "accessLevel": "Write"
            },
            "PutCaseAttributes": {
                "url": "",
                "description": "This is an internally managed function which allows secondary services to attach attributes to AWS Support cases.",
                "accessLevel": "Write"
            },
            "RateCaseCommunication": {
                "url": "",
                "description": "Rate an AWS Support case communication.",
                "accessLevel": "Write"
            },
            "RefreshTrustedAdvisorCheck": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_RefreshTrustedAdvisorCheck.html",
                "description": "Requests a refresh of the Trusted Advisor check that has the specified check identifier.",
                "accessLevel": "Write"
            },
            "ResolveCase": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_ResolveCase.html",
                "description": "Resolves an AWS Support case.",
                "accessLevel": "Write"
            },
            "SearchForCases": {
                "url": "",
                "description": "Returns a list of AWS Support cases that matches the given inputs.",
                "accessLevel": "Read"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Adds one or more attachments to an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddAttachmentsToSet.html
     */
    toAddAttachmentsToSet() {
        this.add('support:AddAttachmentsToSet');
        return this;
    }
    /**
     * Adds a customer communication to an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddCommunicationToCase.html
     */
    toAddCommunicationToCase() {
        this.add('support:AddCommunicationToCase');
        return this;
    }
    /**
     * Creates a new AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CreateCase.html
     */
    toCreateCase() {
        this.add('support:CreateCase');
        return this;
    }
    /**
     * Returns the description for an attachment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeAttachment.html
     */
    toDescribeAttachment() {
        this.add('support:DescribeAttachment');
        return this;
    }
    /**
     * This is an internally managed function which allows secondary services to read AWS Support case attributes.
     *
     * Access Level: Read
     */
    toDescribeCaseAttributes() {
        this.add('support:DescribeCaseAttributes');
        return this;
    }
    /**
     * Returns a list of AWS Support cases that matches the given inputs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCases.html
     */
    toDescribeCases() {
        this.add('support:DescribeCases');
        return this;
    }
    /**
     * Returns the communications and attachments for one or more AWS Support cases.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCommunications.html
     */
    toDescribeCommunications() {
        this.add('support:DescribeCommunications');
        return this;
    }
    /**
     * Returns issue types for AWS Support cases.
     *
     * Access Level: Read
     */
    toDescribeIssueTypes() {
        this.add('support:DescribeIssueTypes');
        return this;
    }
    /**
     * Returns the current list of AWS services and categories that applies to each service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeServices.html
     */
    toDescribeServices() {
        this.add('support:DescribeServices');
        return this;
    }
    /**
     * Returns the list of severity levels that can be assigned to an AWS Support case.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeSeverityLevels.html
     */
    toDescribeSeverityLevels() {
        this.add('support:DescribeSeverityLevels');
        return this;
    }
    /**
     * Returns the support level for an AWS Account identifier.
     *
     * Access Level: Read
     */
    toDescribeSupportLevel() {
        this.add('support:DescribeSupportLevel');
        return this;
    }
    /**
     * Returns the status of a Trusted Advisor refresh check based on a list of check identifiers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckRefreshStatuses.html
     */
    toDescribeTrustedAdvisorCheckRefreshStatuses() {
        this.add('support:DescribeTrustedAdvisorCheckRefreshStatuses');
        return this;
    }
    /**
     * Returns the results of the Trusted Advisor check that has the specified check identifier.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckResult.html
     */
    toDescribeTrustedAdvisorCheckResult() {
        this.add('support:DescribeTrustedAdvisorCheckResult');
        return this;
    }
    /**
     * Returns the summaries of the results of the Trusted Advisor checks that have the specified check identifiers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckSummaries.html
     */
    toDescribeTrustedAdvisorCheckSummaries() {
        this.add('support:DescribeTrustedAdvisorCheckSummaries');
        return this;
    }
    /**
     * Returns a list of all available Trusted Advisor checks, including name, identifier, category and description.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorChecks.html
     */
    toDescribeTrustedAdvisorChecks() {
        this.add('support:DescribeTrustedAdvisorChecks');
        return this;
    }
    /**
     * This is an internally managed function to initiate a call on AWS Support Center.
     *
     * Access Level: Write
     */
    toInitiateCallForCase() {
        this.add('support:InitiateCallForCase');
        return this;
    }
    /**
     * This is an internally managed function to initiate a chat on AWS Support Center.
     *
     * Access Level: Write
     */
    toInitiateChatForCase() {
        this.add('support:InitiateChatForCase');
        return this;
    }
    /**
     * This is an internally managed function which allows secondary services to attach attributes to AWS Support cases.
     *
     * Access Level: Write
     */
    toPutCaseAttributes() {
        this.add('support:PutCaseAttributes');
        return this;
    }
    /**
     * Rate an AWS Support case communication.
     *
     * Access Level: Write
     */
    toRateCaseCommunication() {
        this.add('support:RateCaseCommunication');
        return this;
    }
    /**
     * Requests a refresh of the Trusted Advisor check that has the specified check identifier.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_RefreshTrustedAdvisorCheck.html
     */
    toRefreshTrustedAdvisorCheck() {
        this.add('support:RefreshTrustedAdvisorCheck');
        return this;
    }
    /**
     * Resolves an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_ResolveCase.html
     */
    toResolveCase() {
        this.add('support:ResolveCase');
        return this;
    }
    /**
     * Returns a list of AWS Support cases that matches the given inputs.
     *
     * Access Level: Read
     */
    toSearchForCases() {
        this.add('support:SearchForCases');
        return this;
    }
}
exports.Support = Support;
//# sourceMappingURL=data:application/json;base64,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