"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dbqms = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [dbqms](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_databasequerymetadataservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Dbqms extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [dbqms](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_databasequerymetadataservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'dbqms';
        this.actionList = {
            "CreateFavoriteQuery": {
                "url": "https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#CreateFavoriteQuery",
                "description": "Creates a new favorite query",
                "accessLevel": "Write"
            },
            "CreateQueryHistory": {
                "url": "",
                "description": "Add a query to the history",
                "accessLevel": "Write"
            },
            "DeleteFavoriteQueries": {
                "url": "https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteFavoriteQueries",
                "description": "Delete saved queries",
                "accessLevel": "Write"
            },
            "DeleteQueryHistory": {
                "url": "https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteQueryHistory",
                "description": "Delete a historical query",
                "accessLevel": "Write"
            },
            "DescribeFavoriteQueries": {
                "url": "https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeFavoriteQueries",
                "description": "List saved queries and associated metadata",
                "accessLevel": "List"
            },
            "DescribeQueryHistory": {
                "url": "https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeQueryHistory",
                "description": "List history of queries that were run",
                "accessLevel": "List"
            },
            "GetQueryString": {
                "url": "https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#GetQueryString",
                "description": "Retrieve favorite or history query string by id",
                "accessLevel": "Read"
            },
            "UpdateFavoriteQuery": {
                "url": "https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateFavoriteQuery",
                "description": "Update saved query and description",
                "accessLevel": "Write"
            },
            "UpdateQueryHistory": {
                "url": "https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateQueryHistory",
                "description": "Update the query history",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Creates a new favorite query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#CreateFavoriteQuery
     */
    toCreateFavoriteQuery() {
        this.add('dbqms:CreateFavoriteQuery');
        return this;
    }
    /**
     * Add a query to the history
     *
     * Access Level: Write
     */
    toCreateQueryHistory() {
        this.add('dbqms:CreateQueryHistory');
        return this;
    }
    /**
     * Delete saved queries
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteFavoriteQueries
     */
    toDeleteFavoriteQueries() {
        this.add('dbqms:DeleteFavoriteQueries');
        return this;
    }
    /**
     * Delete a historical query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteQueryHistory
     */
    toDeleteQueryHistory() {
        this.add('dbqms:DeleteQueryHistory');
        return this;
    }
    /**
     * List saved queries and associated metadata
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeFavoriteQueries
     */
    toDescribeFavoriteQueries() {
        this.add('dbqms:DescribeFavoriteQueries');
        return this;
    }
    /**
     * List history of queries that were run
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeQueryHistory
     */
    toDescribeQueryHistory() {
        this.add('dbqms:DescribeQueryHistory');
        return this;
    }
    /**
     * Retrieve favorite or history query string by id
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#GetQueryString
     */
    toGetQueryString() {
        this.add('dbqms:GetQueryString');
        return this;
    }
    /**
     * Update saved query and description
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateFavoriteQuery
     */
    toUpdateFavoriteQuery() {
        this.add('dbqms:UpdateFavoriteQuery');
        return this;
    }
    /**
     * Update the query history
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateQueryHistory
     */
    toUpdateQueryHistory() {
        this.add('dbqms:UpdateQueryHistory');
        return this;
    }
}
exports.Dbqms = Dbqms;
//# sourceMappingURL=data:application/json;base64,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