"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.All = void 0;
const policy_statement_1 = require("./policy-statement");
/**
 * Action provider for all services
 */
class All extends policy_statement_1.PolicyStatement {
    /**
     * Action provider for all services.
     *
     * Use this provider to globally allow/deny actions, based on global conditions.
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
    }
    /**
     * Adds all actions to the statement: `actions: '*'`
     */
    all() {
        this.add('*');
        return this;
    }
}
exports.All = All;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWxsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYWxsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHlEQUFxRDtBQUVyRDs7R0FFRztBQUNILE1BQWEsR0FBSSxTQUFRLGtDQUFlO0lBQ3RDOzs7Ozs7T0FNRztJQUNILFlBQVksR0FBWTtRQUN0QixLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDYixDQUFDO0lBRUQ7O09BRUc7SUFDSSxHQUFHO1FBQ1IsSUFBSSxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUNkLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztDQUNGO0FBbkJELGtCQW1CQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFBvbGljeVN0YXRlbWVudCB9IGZyb20gJy4vcG9saWN5LXN0YXRlbWVudCc7XG5cbi8qKlxuICogQWN0aW9uIHByb3ZpZGVyIGZvciBhbGwgc2VydmljZXNcbiAqL1xuZXhwb3J0IGNsYXNzIEFsbCBleHRlbmRzIFBvbGljeVN0YXRlbWVudCB7XG4gIC8qKlxuICAgKiBBY3Rpb24gcHJvdmlkZXIgZm9yIGFsbCBzZXJ2aWNlcy5cbiAgICpcbiAgICogVXNlIHRoaXMgcHJvdmlkZXIgdG8gZ2xvYmFsbHkgYWxsb3cvZGVueSBhY3Rpb25zLCBiYXNlZCBvbiBnbG9iYWwgY29uZGl0aW9ucy5cbiAgICpcbiAgICogQHBhcmFtIHNpZCBbU0lEXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX3NpZC5odG1sKSBvZiB0aGUgc3RhdGVtZW50XG4gICAqL1xuICBjb25zdHJ1Y3RvcihzaWQ/OiBzdHJpbmcpIHtcbiAgICBzdXBlcihzaWQpO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYWxsIGFjdGlvbnMgdG8gdGhlIHN0YXRlbWVudDogYGFjdGlvbnM6ICcqJ2BcbiAgICovXG4gIHB1YmxpYyBhbGwoKSB7XG4gICAgdGhpcy5hZGQoJyonKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxufVxuIl19