import { AccessLevel } from '../access-level';
import { PolicyStatementWithCondition } from './2-conditions';
export interface Action {
    url: string;
    description: string;
    accessLevel: string;
    resourceTypes?: any;
    conditions?: string[];
    dependentActions?: string[];
}
export interface Actions {
    [key: string]: Action;
}
/**
 * Adds "action" functionality to the Policy Statement
 */
export declare class PolicyStatementWithActions extends PolicyStatementWithCondition {
    protected actionList: Actions;
    private useNotActions;
    protected actions: string[];
    private cdkActionsApplied;
    /**
     * Injects actions into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     */
    toJSON(): any;
    toStatementJson(): any;
    private cdkApplyActions;
    /**
     * Switches the statement to use [`NotAction`](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notaction.html).
     */
    notActions(): this;
    /**
     * Checks weather actions have been applied to the policy.
     */
    hasActions(): boolean;
    /**
     * Adds actions by name.
     *
     * Depending on the "mode", actions will be either added to the list of [`Actions`](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_action.html) or [`NotActions`](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notaction.html).
     *
     * The mode can be switched by calling `notActions()`.
     *
     * @param action Actions that will be added to the statement.
     */
    add(action: string): this;
    /**
     * Adds actions to the statement, matching an `AccessLevel` or regular expression.
     *
     * When no value is passed, all actions of the service will be added.
     */
    allActions(...rules: (AccessLevel | string)[]): PolicyStatementWithActions;
}
