"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithEffect = exports.Effect = void 0;
const _4_resources_1 = require("./4-resources");
/**
 * Policy effects
 */
var Effect;
(function (Effect) {
    Effect["ALLOW"] = "Allow";
    Effect["DENY"] = "Deny";
})(Effect = exports.Effect || (exports.Effect = {}));
/**
 * Adds "effect" functionality to the Policy Statement
 */
class PolicyStatementWithEffect extends _4_resources_1.PolicyStatementWithResources {
    constructor() {
        super(...arguments);
        this.effect = Effect.ALLOW;
    }
    /**
     * Injects effect into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     */
    toJSON() {
        // @ts-ignore only available after swapping 1-base
        if (typeof this.addResources == 'function') {
            return super.toJSON();
        }
        const statement = super.toJSON();
        if (this.effect != Effect.ALLOW) {
            statement.Effect = this.effect;
        }
        return statement;
    }
    /**
     * Allow the actions in this statement
     */
    allow() {
        this.effect = Effect.ALLOW;
        return this;
    }
    /**
     * Deny the actions in this statement
     */
    deny() {
        this.effect = Effect.DENY;
        return this;
    }
}
exports.PolicyStatementWithEffect = PolicyStatementWithEffect;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNS1lZmZlY3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyI1LWVmZmVjdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxnREFBNkQ7QUFFN0Q7O0dBRUc7QUFDSCxJQUFZLE1BR1g7QUFIRCxXQUFZLE1BQU07SUFDaEIseUJBQWUsQ0FBQTtJQUNmLHVCQUFhLENBQUE7QUFDZixDQUFDLEVBSFcsTUFBTSxHQUFOLGNBQU0sS0FBTixjQUFNLFFBR2pCO0FBRUQ7O0dBRUc7QUFDSCxNQUFhLHlCQUEwQixTQUFRLDJDQUE0QjtJQUEzRTs7UUFDUyxXQUFNLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQztJQW9DL0IsQ0FBQztJQWxDQzs7OztPQUlHO0lBQ0ksTUFBTTtRQUNYLGtEQUFrRDtRQUNsRCxJQUFJLE9BQU8sSUFBSSxDQUFDLFlBQVksSUFBSSxVQUFVLEVBQUU7WUFDMUMsT0FBTyxLQUFLLENBQUMsTUFBTSxFQUFFLENBQUM7U0FDdkI7UUFDRCxNQUFNLFNBQVMsR0FBRyxLQUFLLENBQUMsTUFBTSxFQUFFLENBQUM7UUFFakMsSUFBSSxJQUFJLENBQUMsTUFBTSxJQUFJLE1BQU0sQ0FBQyxLQUFLLEVBQUU7WUFDL0IsU0FBUyxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDO1NBQ2hDO1FBRUQsT0FBTyxTQUFTLENBQUM7SUFDbkIsQ0FBQztJQUVEOztPQUVHO0lBQ0ksS0FBSztRQUNWLElBQUksQ0FBQyxNQUFNLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQztRQUMzQixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7T0FFRztJQUNJLElBQUk7UUFDVCxJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDMUIsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0NBQ0Y7QUFyQ0QsOERBcUNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50V2l0aFJlc291cmNlcyB9IGZyb20gJy4vNC1yZXNvdXJjZXMnO1xuXG4vKipcbiAqIFBvbGljeSBlZmZlY3RzXG4gKi9cbmV4cG9ydCBlbnVtIEVmZmVjdCB7XG4gIEFMTE9XID0gJ0FsbG93JyxcbiAgREVOWSA9ICdEZW55Jyxcbn1cblxuLyoqXG4gKiBBZGRzIFwiZWZmZWN0XCIgZnVuY3Rpb25hbGl0eSB0byB0aGUgUG9saWN5IFN0YXRlbWVudFxuICovXG5leHBvcnQgY2xhc3MgUG9saWN5U3RhdGVtZW50V2l0aEVmZmVjdCBleHRlbmRzIFBvbGljeVN0YXRlbWVudFdpdGhSZXNvdXJjZXMge1xuICBwdWJsaWMgZWZmZWN0ID0gRWZmZWN0LkFMTE9XO1xuXG4gIC8qKlxuICAgKiBJbmplY3RzIGVmZmVjdCBpbnRvIHRoZSBzdGF0ZW1lbnQuXG4gICAqXG4gICAqIE9ubHkgcmVsZXZhbnQgZm9yIHRoZSBtYWluIHBhY2thZ2UuIEluIENESyBtb2RlIHRoaXMgb25seSBjYWxscyBzdXBlci5cbiAgICovXG4gIHB1YmxpYyB0b0pTT04oKTogYW55IHtcbiAgICAvLyBAdHMtaWdub3JlIG9ubHkgYXZhaWxhYmxlIGFmdGVyIHN3YXBwaW5nIDEtYmFzZVxuICAgIGlmICh0eXBlb2YgdGhpcy5hZGRSZXNvdXJjZXMgPT0gJ2Z1bmN0aW9uJykge1xuICAgICAgcmV0dXJuIHN1cGVyLnRvSlNPTigpO1xuICAgIH1cbiAgICBjb25zdCBzdGF0ZW1lbnQgPSBzdXBlci50b0pTT04oKTtcblxuICAgIGlmICh0aGlzLmVmZmVjdCAhPSBFZmZlY3QuQUxMT1cpIHtcbiAgICAgIHN0YXRlbWVudC5FZmZlY3QgPSB0aGlzLmVmZmVjdDtcbiAgICB9XG5cbiAgICByZXR1cm4gc3RhdGVtZW50O1xuICB9XG5cbiAgLyoqXG4gICAqIEFsbG93IHRoZSBhY3Rpb25zIGluIHRoaXMgc3RhdGVtZW50XG4gICAqL1xuICBwdWJsaWMgYWxsb3coKSB7XG4gICAgdGhpcy5lZmZlY3QgPSBFZmZlY3QuQUxMT1c7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGVueSB0aGUgYWN0aW9ucyBpbiB0aGlzIHN0YXRlbWVudFxuICAgKi9cbiAgcHVibGljIGRlbnkoKSB7XG4gICAgdGhpcy5lZmZlY3QgPSBFZmZlY3QuREVOWTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxufVxuIl19