# -*- coding: utf-8 -*-
# Copyright 2021 Cohesity Inc.

class SiteBackupFile(object):

    """Implementation of the 'SiteBackupFile' model.

    Attributes:
        file_path (string): Output file path on Windows proxy VM or on SMB
            share. This will be autogenerated when
            'BackupSiteParam.data_dir_path' is empty. The file
            'sitetemplate.pnp' in the directory contains the PnP site
            template.
        file_size (long|int): File size in bytes.
        file_type (int): Type of file.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "file_path":'filePath',
        "file_size":'fileSize',
        "file_type":'fileType'
    }

    def __init__(self,
                 file_path=None,
                 file_size=None,
                 file_type=None):
        """Constructor for the SiteBackupFile class"""

        # Initialize members of the class
        self.file_path = file_path
        self.file_size = file_size
        self.file_type = file_type


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        file_path = dictionary.get('filePath')
        file_size = dictionary.get('fileSize')
        file_type = dictionary.get('fileType')

        # Return an object of this model
        return cls(file_path,
                   file_size,
                   file_type)


