from django import forms
from edc_form_validators import FormValidatorMixin
from edc_sites.forms import SiteModelFormMixin

from edc_transfer.form_validators import SubjectTransferFormValidator

from .models import SubjectTransfer


class SubjectTransferForm(
    SiteModelFormMixin,
    FormValidatorMixin,
    forms.ModelForm,
):

    form_validator_cls = SubjectTransferFormValidator

    subject_identifier = forms.CharField(
        label="Subject Identifier",
        required=False,
        widget=forms.TextInput(attrs={"readonly": "readonly"}),
    )

    class Meta:
        model = SubjectTransfer
        fields = "__all__"
