# Generated by Django 2.2.6 on 2019-10-10 17:00

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Category",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "categories",
                "abstract": False,
            },
            managers=[
                ("objects", django.db.models.manager.Manager()),
                ("_plain_manager", django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="Media",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("file", models.FileField(upload_to="")),
                (
                    "thumbnail",
                    models.ImageField(
                        blank=True, max_length=500, null=True, upload_to="thumbnails"
                    ),
                ),
                ("created", models.DateTimeField(auto_now=True)),
                ("name", models.CharField(blank=True, max_length=200, null=True)),
                ("size", models.IntegerField(blank=True, default=0, null=True)),
                ("is_image", models.BooleanField(default=False)),
            ],
            options={
                "ordering": ["-pk"],
            },
            managers=[
                ("objects", django.db.models.manager.Manager()),
                ("_plain_manager", django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="MediaFolder",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("slug", models.SlugField()),
                ("creation_date", models.DateTimeField(auto_now_add=True)),
                ("last_modified", models.DateTimeField(auto_now=True)),
                (
                    "icon",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="camomilla.Media",
                        verbose_name="Image cover",
                    ),
                ),
                (
                    "updir",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="camomilla.MediaFolder",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            managers=[
                ("objects", django.db.models.manager.Manager()),
                ("_plain_manager", django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="Page",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("identifier", models.CharField(max_length=200, unique=True)),
                (
                    "og_image",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="camomilla_page_related",
                        to="camomilla.Media",
                    ),
                ),
            ],
            options={
                "verbose_name": "Page",
                "verbose_name_plural": "Pages",
                "abstract": False,
            },
            managers=[
                ("objects", django.db.models.manager.Manager()),
                ("_plain_manager", django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="Tag",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            managers=[
                ("objects", django.db.models.manager.Manager()),
                ("_plain_manager", django.db.models.manager.Manager()),
            ],
        ),
        migrations.AddField(
            model_name="media",
            name="folder",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="media_folder",
                to="camomilla.MediaFolder",
            ),
        ),
        migrations.CreateModel(
            name="Content",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("identifier", models.CharField(max_length=200)),
                (
                    "page",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="contents",
                        to="camomilla.Page",
                    ),
                ),
            ],
            options={
                "abstract": False,
                "unique_together": {("page", "identifier")},
            },
            managers=[
                ("objects", django.db.models.manager.Manager()),
                ("_plain_manager", django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="Article",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("trash", models.BooleanField(default=False)),
                ("identifier", models.CharField(max_length=200, unique=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PUB", "Published"),
                            ("DRF", "Draft"),
                            ("TRS", "Trash"),
                            ("PLA", "Planned"),
                        ],
                        default="DRF",
                        max_length=3,
                    ),
                ),
                ("date", models.DateTimeField(auto_now=True)),
                ("pubblication_date", models.DateTimeField(blank=True, null=True)),
                (
                    "author",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "categories",
                    models.ManyToManyField(blank=True, to="camomilla.Category"),
                ),
                (
                    "highlight_image",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="camomilla.Media",
                    ),
                ),
                (
                    "og_image",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="camomilla_article_related",
                        to="camomilla.Media",
                    ),
                ),
                ("tags", models.ManyToManyField(blank=True, to="camomilla.Tag")),
            ],
            options={
                "abstract": False,
            },
            managers=[
                ("trashmanager", django.db.models.manager.Manager()),
                ("_plain_manager", django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="TagTranslation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=200)),
                ("language_code", models.CharField(db_index=True, max_length=15)),
                (
                    "master",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="camomilla.Tag",
                    ),
                ),
            ],
            options={
                "db_table": "camomilla_tag_translation",
                "db_tablespace": "",
                "abstract": False,
                "managed": True,
                "default_permissions": (),
                "unique_together": {
                    ("language_code", "master"),
                    ("title", "language_code"),
                },
            },
        ),
        migrations.CreateModel(
            name="PageTranslation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=200)),
                ("description", models.TextField(blank=True, default="", null=True)),
                ("permalink", models.CharField(blank=True, max_length=200)),
                ("og_description", models.TextField(blank=True, default="", null=True)),
                (
                    "og_title",
                    models.CharField(blank=True, default="", max_length=200, null=True),
                ),
                (
                    "og_type",
                    models.CharField(blank=True, default="", max_length=200, null=True),
                ),
                (
                    "og_url",
                    models.CharField(blank=True, default="", max_length=200, null=True),
                ),
                (
                    "canonical",
                    models.CharField(blank=True, default="", max_length=200, null=True),
                ),
                ("language_code", models.CharField(db_index=True, max_length=15)),
                (
                    "master",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="camomilla.Page",
                    ),
                ),
            ],
            options={
                "db_table": "camomilla_page_translation",
                "db_tablespace": "",
                "abstract": False,
                "managed": True,
                "default_permissions": (),
                "unique_together": {("language_code", "master")},
            },
        ),
        migrations.CreateModel(
            name="MediaTranslation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("alt_text", models.CharField(blank=True, max_length=200, null=True)),
                ("title", models.CharField(blank=True, max_length=200, null=True)),
                ("description", models.TextField(blank=True, null=True)),
                ("language_code", models.CharField(db_index=True, max_length=15)),
                (
                    "master",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="camomilla.Media",
                    ),
                ),
            ],
            options={
                "db_table": "camomilla_media_translation",
                "db_tablespace": "",
                "abstract": False,
                "managed": True,
                "default_permissions": (),
                "unique_together": {("language_code", "master")},
            },
        ),
        migrations.CreateModel(
            name="MediaFolderTranslation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "description",
                    models.CharField(blank=True, max_length=200, null=True),
                ),
                ("title", models.CharField(blank=True, max_length=200, null=True)),
                ("language_code", models.CharField(db_index=True, max_length=15)),
                (
                    "master",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="camomilla.MediaFolder",
                    ),
                ),
            ],
            options={
                "db_table": "camomilla_mediafolder_translation",
                "db_tablespace": "",
                "abstract": False,
                "managed": True,
                "default_permissions": (),
                "unique_together": {("language_code", "master")},
            },
        ),
        migrations.CreateModel(
            name="ContentTranslation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=200)),
                (
                    "subtitle",
                    models.CharField(blank=True, default="", max_length=200, null=True),
                ),
                ("permalink", models.CharField(blank=True, max_length=200, null=True)),
                ("content", models.TextField()),
                ("language_code", models.CharField(db_index=True, max_length=15)),
                (
                    "master",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="camomilla.Content",
                    ),
                ),
            ],
            options={
                "db_table": "camomilla_content_translation",
                "db_tablespace": "",
                "abstract": False,
                "managed": True,
                "default_permissions": (),
                "unique_together": {("language_code", "master")},
            },
        ),
        migrations.CreateModel(
            name="CategoryTranslation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=200)),
                ("description", models.TextField(blank=True, default="", null=True)),
                ("slug", models.SlugField()),
                ("language_code", models.CharField(db_index=True, max_length=15)),
                (
                    "master",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="camomilla.Category",
                    ),
                ),
            ],
            options={
                "db_table": "camomilla_category_translation",
                "db_tablespace": "",
                "abstract": False,
                "managed": True,
                "default_permissions": (),
                "unique_together": {
                    ("language_code", "master"),
                    ("title", "language_code"),
                },
            },
        ),
        migrations.CreateModel(
            name="ArticleTranslation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=200)),
                ("description", models.TextField(blank=True, default="", null=True)),
                ("permalink", models.CharField(blank=True, max_length=200)),
                ("og_description", models.TextField(blank=True, default="", null=True)),
                (
                    "og_title",
                    models.CharField(blank=True, default="", max_length=200, null=True),
                ),
                (
                    "og_type",
                    models.CharField(blank=True, default="", max_length=200, null=True),
                ),
                (
                    "og_url",
                    models.CharField(blank=True, default="", max_length=200, null=True),
                ),
                (
                    "canonical",
                    models.CharField(blank=True, default="", max_length=200, null=True),
                ),
                ("content", models.TextField()),
                ("language_code", models.CharField(db_index=True, max_length=15)),
                (
                    "master",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="camomilla.Article",
                    ),
                ),
            ],
            options={
                "db_table": "camomilla_article_translation",
                "db_tablespace": "",
                "abstract": False,
                "managed": True,
                "default_permissions": (),
                "unique_together": {
                    ("permalink", "language_code"),
                    ("language_code", "master"),
                },
            },
        ),
    ]
