## Nomenclature of non-human primate MHC genes

https://www.ebi.ac.uk/ipd/mhc/group/NHP/page/nomenclature

In non-human primate (NHP) MHC nomenclature the Mhc symbol is followed by a four-letter abbreviation of the species’ scientific name. The first two letters are derived from the name of the genus, and the last two letters from the name of the species. For example, MhcPatr defines the MHC system of the common chimpanzee (Pan troglodytes). The prefix “Mhc” is nowadays often omitted.

The assignment of genus and species level in non-human primates is based on Groves (Groves C.P. et al., 2005). In the 2012 nomenclature report for non-human primate MHC (de Groot N.G. et al., 2012) a register of officially accepted MHC symbols for NHP is provided.

## Non-human primate specific nomenclature

Within the designations of particular MHC alleles of non-human primates, specific prefixes or suffixes are used:

Within the non-human primate MHC class I region, expansion of the number of genes can be observed. For instance, in macaques 1 to 3 MHC-A genes can be present per haplotype. These genes are identified with sequential Arabic numbers (Mamu-A1, A2, etc.).

The prefix AG is introduced in the MHC nomenclature of the Old World monkeys to describe a new gene. In Old World monkeys the MHC-G gene is a pseudogene, and its function has been take over by the functional AG gene.

The prefix AL is only used in Pan troglodytes MHC nomenclature, and refers to a MHC-A-like gene identified in this species (Adams E.J. et al., 2001).

The prefix Ap is only used in Pongo pygmeaus MHC nomenclature and indicates a MHC-A pseudogene identified in this species (Adams et al., 2001).

The prefix I is used in macaque MHC nomenclature to indicate an oligomorphic B-like gene identified in these species.

The prefix N is only used in the Saguinus oedipus MHC nomenclature to indicate “new, non-functional” MHC class I genes identified in this species (Watkins D.I. et al., 1991).

The prefix OKO is only used in the gorilla MHC nomenclature to indicate a new gene identified in the species (Lawlor D.A. et al., 1991, and Watkins D.I. et al., 1991).

The prefix W or w is used to indicate when an allele cannot be defined to a locus/gene yet.

Ps is used as prefix and suffix, and indicates when the described gene is a pseudogene.

The suffix N (null allele) is used to indicate that the allele is characterised by a premature stop codon.

Occasionally the suffix Sp is used to indicate that the described allele is a splice variant.