from mhcgnomes import parse

def test_Anpl_UAA_01():
    # Anpl-UAA*01 occurs 34 times in 2019 IEDB snapshot
    parse("Anpl-UAA*01")

def test_B12_class_I():
    # B12 class I occurs 4 times in 2019 IEDB snapshot
    parse("B12 class I")

def test_B19_class_I():
    # B19 class I occurs 30 times in 2019 IEDB snapshot
    parse("B19 class I")

def test_BF1_0201():
    # BF1*0201 occurs 2 times in 2019 IEDB snapshot
    parse("BF1*0201")

def test_BF19_class_II():
    # BF19 class II occurs 1 times in 2019 IEDB snapshot
    parse("BF19 class II")

def test_BF2():
    # BF2 occurs 2 times in 2019 IEDB snapshot
    parse("BF2")

def test_BF2_0201():
    # BF2*0201 occurs 13 times in 2019 IEDB snapshot
    parse("BF2*0201")

def test_BF2_0401():
    # BF2*0401 occurs 33 times in 2019 IEDB snapshot
    parse("BF2*0401")

def test_BF2_1201():
    # BF2*1201 occurs 12 times in 2019 IEDB snapshot
    parse("BF2*1201")

def test_BF2_1301():
    # BF2*1301 occurs 30 times in 2019 IEDB snapshot
    parse("BF2*1301")

def test_BF2_1401():
    # BF2*1401 occurs 9 times in 2019 IEDB snapshot
    parse("BF2*1401")

def test_BF2_1501():
    # BF2*1501 occurs 2 times in 2019 IEDB snapshot
    parse("BF2*1501")

def test_BF2_2101():
    # BF2*2101 occurs 82 times in 2019 IEDB snapshot
    parse("BF2*2101")

def test_BF21_class_II():
    # BF21 class II occurs 4 times in 2019 IEDB snapshot
    parse("BF21 class II")

def test_BoLA_1_02101():
    # BoLA-1*02101 occurs 2 times in 2019 IEDB snapshot
    parse("BoLA-1*02101")

def test_BoLA_2_00801():
    # BoLA-2*00801 occurs 14 times in 2019 IEDB snapshot
    parse("BoLA-2*00801")

def test_BoLA_2_01201():
    # BoLA-2*01201 occurs 60 times in 2019 IEDB snapshot
    parse("BoLA-2*01201")

def test_BoLA_2_01801():
    # BoLA-2*01801 occurs 6 times in 2019 IEDB snapshot
    parse("BoLA-2*01801")

def test_BoLA_4_02401():
    # BoLA-4*02401 occurs 4 times in 2019 IEDB snapshot
    parse("BoLA-4*02401")

def test_BoLA_6_01301():
    # BoLA-6*01301 occurs 92 times in 2019 IEDB snapshot
    parse("BoLA-6*01301")

def test_BoLA_6_01302():
    # BoLA-6*01302 occurs 1 times in 2019 IEDB snapshot
    parse("BoLA-6*01302")

def test_BoLA_6_04101():
    # BoLA-6*04101 occurs 2 times in 2019 IEDB snapshot
    parse("BoLA-6*04101")

def test_BoLA_A11():
    # BoLA-A11 occurs 40 times in 2019 IEDB snapshot
    parse("BoLA-A11")

def test_BoLA_DQ():
    # BoLA-DQ occurs 1 times in 2019 IEDB snapshot
    parse("BoLA-DQ")

def test_BoLA_DR():
    # BoLA-DR occurs 3 times in 2019 IEDB snapshot
    parse("BoLA-DR")

def test_BoLA_DRB3_0101():
    # BoLA-DRB3*0101 occurs 6 times in 2019 IEDB snapshot
    parse("BoLA-DRB3*0101")

def test_BoLA_DRB3_0201():
    # BoLA-DRB3*0201 occurs 5 times in 2019 IEDB snapshot
    parse("BoLA-DRB3*0201")

def test_BoLA_DRB3_1101():
    # BoLA-DRB3*1101 occurs 5 times in 2019 IEDB snapshot
    parse("BoLA-DRB3*1101")

def test_BoLA_DRB3_1201():
    # BoLA-DRB3*1201 occurs 24 times in 2019 IEDB snapshot
    parse("BoLA-DRB3*1201")

def test_BoLA_DRB3_2703():
    # BoLA-DRB3*2703 occurs 14 times in 2019 IEDB snapshot
    parse("BoLA-DRB3*2703")

def test_BoLA_DRB6():
    # BoLA-DRB6 occurs 37 times in 2019 IEDB snapshot
    parse("BoLA-DRB6")

def test_Caja_E():
    # Caja-E occurs 13 times in 2019 IEDB snapshot
    parse("Caja-E")

def test_DLA_88_50101():
    # DLA-88*50101 occurs 1963 times in 2019 IEDB snapshot
    parse("DLA-88*50101")

def test_DLA_88_50801():
    # DLA-88*50801 occurs 20 times in 2019 IEDB snapshot
    parse("DLA-88*50801")

def test_ELA_A1_class_I():
    # ELA-A1 class I occurs 21 times in 2019 IEDB snapshot
    parse("ELA-A1 class I")

def test_Eqca_1_00101():
    # Eqca-1*00101 occurs 702 times in 2019 IEDB snapshot
    parse("Eqca-1*00101")

def test_Eqca_1_00201():
    # Eqca-1*00201 occurs 80 times in 2019 IEDB snapshot
    parse("Eqca-1*00201")

def test_Eqca_16_00101():
    # Eqca-16*00101 occurs 80 times in 2019 IEDB snapshot
    parse("Eqca-16*00101")

def test_Eqca_N_00601():
    # Eqca-N*00601 occurs 4 times in 2019 IEDB snapshot
    parse("Eqca-N*00601")

def test_Eqca_N_00602():
    # Eqca-N*00602 occurs 21 times in 2019 IEDB snapshot
    parse("Eqca-N*00602")

def test_Gogo_B_0101():
    # Gogo-B*0101 occurs 14 times in 2019 IEDB snapshot
    parse("Gogo-B*0101")

def test_H2_class_I():
    # H2 class I occurs 5 times in 2019 IEDB snapshot
    parse("H2 class I")

def test_H2_Db():
    # H2-Db occurs 6700 times in 2019 IEDB snapshot
    parse("H2-Db")

def test_H2_Db_H155A_mutant():
    # H2-Db H155A mutant occurs 4 times in 2019 IEDB snapshot
    parse("H2-Db H155A mutant")

def test_H2_Db_Q70H_mutant():
    # H2-Db Q70H mutant occurs 1 times in 2019 IEDB snapshot
    parse("H2-Db Q70H mutant")

def test_H2_Db_Y159F_mutant():
    # H2-Db Y159F mutant occurs 3 times in 2019 IEDB snapshot
    parse("H2-Db Y159F mutant")

def test_H2_Dd():
    # H2-Dd occurs 331 times in 2019 IEDB snapshot
    parse("H2-Dd")

def test_H2_Dk():
    # H2-Dk occurs 8 times in 2019 IEDB snapshot
    parse("H2-Dk")

def test_H2_IAb():
    # H2-IAb occurs 4683 times in 2019 IEDB snapshot
    parse("H2-IAb")

def test_H2_IAb_I67F_R70Q_T71K_mutant():
    # H2-IAb I67F, R70Q, T71K mutant occurs 4 times in 2019 IEDB snapshot
    parse("H2-IAb I67F, R70Q, T71K mutant")

def test_H2_IAd():
    # H2-IAd occurs 888 times in 2019 IEDB snapshot
    parse("H2-IAd")

def test_H2_IAg7():
    # H2-IAg7 occurs 721 times in 2019 IEDB snapshot
    parse("H2-IAg7")

def test_H2_IAg7_H56P_S57D_mutant():
    # H2-IAg7 H56P, S57D mutant occurs 52 times in 2019 IEDB snapshot
    parse("H2-IAg7 H56P, S57D mutant")

def test_H2_IAk():
    # H2-IAk occurs 358 times in 2019 IEDB snapshot
    parse("H2-IAk")

def test_H2_IAp():
    # H2-IAp occurs 20 times in 2019 IEDB snapshot
    parse("H2-IAp")

def test_H2_IAq():
    # H2-IAq occurs 144 times in 2019 IEDB snapshot
    parse("H2-IAq")

def test_H2_IAr():
    # H2-IAr occurs 24 times in 2019 IEDB snapshot
    parse("H2-IAr")

def test_H2_IAs():
    # H2-IAs occurs 255 times in 2019 IEDB snapshot
    parse("H2-IAs")

def test_H2_IAu():
    # H2-IAu occurs 231 times in 2019 IEDB snapshot
    parse("H2-IAu")

def test_H2_IEb():
    # H2-IEb occurs 24 times in 2019 IEDB snapshot
    parse("H2-IEb")

def test_H2_IEd():
    # H2-IEd occurs 431 times in 2019 IEDB snapshot
    parse("H2-IEd")

def test_H2_IEg7():
    # H2-IEg7 occurs 262 times in 2019 IEDB snapshot
    parse("H2-IEg7")

def test_H2_IEk():
    # H2-IEk occurs 319 times in 2019 IEDB snapshot
    parse("H2-IEk")

def test_H2_IEk_alpha_E11Q_D66N_mutant():
    # H2-IEk alpha E11Q, D66N mutant occurs 4 times in 2019 IEDB snapshot
    parse("H2-IEk alpha E11Q, D66N mutant")

def test_H2_IEp():
    # H2-IEp occurs 135 times in 2019 IEDB snapshot
    parse("H2-IEp")

def test_H2_IEr():
    # H2-IEr occurs 7 times in 2019 IEDB snapshot
    parse("H2-IEr")

def test_H2_Kb():
    # H2-Kb occurs 8710 times in 2019 IEDB snapshot
    parse("H2-Kb")

def test_H2_Kb_D77S_K89A_mutant():
    # H2-Kb D77S, K89A mutant occurs 3 times in 2019 IEDB snapshot
    parse("H2-Kb D77S, K89A mutant")

def test_H2_Kb_E152A_R155Y_L156Y_mutant():
    # H2-Kb E152A, R155Y, L156Y mutant occurs 8 times in 2019 IEDB snapshot
    parse("H2-Kb E152A, R155Y, L156Y mutant")

def test_H2_Kb_Y22F_M23I_E24S_D30N_mutant():
    # H2-Kb Y22F, M23I, E24S, D30N mutant occurs 50 times in 2019 IEDB snapshot
    parse("H2-Kb Y22F, M23I, E24S, D30N mutant")

def test_H2_Kb_Y84A_mutant():
    # H2-Kb Y84A mutant occurs 3 times in 2019 IEDB snapshot
    parse("H2-Kb Y84A mutant")

def test_H2_Kb_Y84C_mutant():
    # H2-Kb Y84C mutant occurs 9 times in 2019 IEDB snapshot
    parse("H2-Kb Y84C mutant")

def test_H2_Kd():
    # H2-Kd occurs 2076 times in 2019 IEDB snapshot
    parse("H2-Kd")

def test_H2_Kk():
    # H2-Kk occurs 627 times in 2019 IEDB snapshot
    parse("H2-Kk")

def test_H2_Kwm7():
    # H2-Kwm7 occurs 7 times in 2019 IEDB snapshot
    parse("H2-Kwm7")

def test_H2_Ld():
    # H2-Ld occurs 487 times in 2019 IEDB snapshot
    parse("H2-Ld")

def test_H2_Lq():
    # H2-Lq occurs 16 times in 2019 IEDB snapshot
    parse("H2-Lq")

def test_H2_M3():
    # H2-M3 occurs 37 times in 2019 IEDB snapshot
    parse("H2-M3")

def test_H2_Q1():
    # H2-Q1 occurs 235 times in 2019 IEDB snapshot
    parse("H2-Q1")

def test_H2_Q2():
    # H2-Q2 occurs 682 times in 2019 IEDB snapshot
    parse("H2-Q2")

def test_H2_Q9():
    # H2-Q9 occurs 11 times in 2019 IEDB snapshot
    parse("H2-Q9")

def test_H2_Qa_1b():
    # H2-Qa-1b occurs 1 times in 2019 IEDB snapshot
    parse("H2-Qa-1b")

def test_H2_b_class_I():
    # H2-b class I occurs 188 times in 2019 IEDB snapshot
    parse("H2-b class I")

def test_H2_b_class_II():
    # H2-b class II occurs 11 times in 2019 IEDB snapshot
    parse("H2-b class II")

def test_H2_d_class_I():
    # H2-d class I occurs 7 times in 2019 IEDB snapshot
    parse("H2-d class I")

def test_H2_d_class_II():
    # H2-d class II occurs 4170 times in 2019 IEDB snapshot
    parse("H2-d class II")

def test_H2_f_class_I():
    # H2-f class I occurs 2 times in 2019 IEDB snapshot
    parse("H2-f class I")

def test_H2_f_class_II():
    # H2-f class II occurs 3 times in 2019 IEDB snapshot
    parse("H2-f class II")

def test_H2_k_class_I():
    # H2-k class I occurs 2 times in 2019 IEDB snapshot
    parse("H2-k class I")

def test_H2_k_class_II():
    # H2-k class II occurs 3 times in 2019 IEDB snapshot
    parse("H2-k class II")

def test_H2_p_class_I():
    # H2-p class I occurs 2 times in 2019 IEDB snapshot
    parse("H2-p class I")

def test_H2_q_class_I():
    # H2-q class I occurs 2 times in 2019 IEDB snapshot
    parse("H2-q class I")

def test_H2_q_class_II():
    # H2-q class II occurs 3 times in 2019 IEDB snapshot
    parse("H2-q class II")

def test_H2_r_class_I():
    # H2-r class I occurs 2 times in 2019 IEDB snapshot
    parse("H2-r class I")

def test_H2_s_class_I():
    # H2-s class I occurs 2 times in 2019 IEDB snapshot
    parse("H2-s class I")

def test_H2_s_class_II():
    # H2-s class II occurs 14 times in 2019 IEDB snapshot
    parse("H2-s class II")

def test_H2_v_class_I():
    # H2-v class I occurs 2 times in 2019 IEDB snapshot
    parse("H2-v class I")

def test_H2_z_class_I():
    # H2-z class I occurs 2 times in 2019 IEDB snapshot
    parse("H2-z class I")

def test_H2_z_d_class_II():
    # H2-z/d class II occurs 253 times in 2019 IEDB snapshot
    parse("H2-z/d class II")

def test_HLA_class_I():
    # HLA class I occurs 116121 times in 2019 IEDB snapshot
    parse("HLA class I")

def test_HLA_class_II():
    # HLA class II occurs 509 times in 2019 IEDB snapshot
    parse("HLA class II")

def test_HLA_A_01_01():
    # HLA-A*01:01 occurs 15962 times in 2019 IEDB snapshot
    parse("HLA-A*01:01")

def test_HLA_A_01_03():
    # HLA-A*01:03 occurs 7 times in 2019 IEDB snapshot
    parse("HLA-A*01:03")

def test_HLA_A_02_01():
    # HLA-A*02:01 occurs 45025 times in 2019 IEDB snapshot
    parse("HLA-A*02:01")

def test_HLA_A_02_01_A150P_mutant():
    # HLA-A*02:01 A150P mutant occurs 2 times in 2019 IEDB snapshot
    parse("HLA-A*02:01 A150P mutant")

def test_HLA_A_02_01_K66A_mutant():
    # HLA-A*02:01 K66A mutant occurs 4 times in 2019 IEDB snapshot
    parse("HLA-A*02:01 K66A mutant")

def test_HLA_A_02_01_K66A_E63Q_mutant():
    # HLA-A*02:01 K66A, E63Q mutant occurs 3 times in 2019 IEDB snapshot
    parse("HLA-A*02:01 K66A, E63Q mutant")

def test_HLA_A_02_01_T163A_mutant():
    # HLA-A*02:01 T163A mutant occurs 1 times in 2019 IEDB snapshot
    parse("HLA-A*02:01 T163A mutant")

def test_HLA_A_02_01_W167A_mutant():
    # HLA-A*02:01 W167A mutant occurs 1 times in 2019 IEDB snapshot
    parse("HLA-A*02:01 W167A mutant")

def test_HLA_A_02_02():
    # HLA-A*02:02 occurs 5298 times in 2019 IEDB snapshot
    parse("HLA-A*02:02")

def test_HLA_A_02_03():
    # HLA-A*02:03 occurs 8374 times in 2019 IEDB snapshot
    parse("HLA-A*02:03")

def test_HLA_A_02_04():
    # HLA-A*02:04 occurs 1684 times in 2019 IEDB snapshot
    parse("HLA-A*02:04")

def test_HLA_A_02_05():
    # HLA-A*02:05 occurs 420 times in 2019 IEDB snapshot
    parse("HLA-A*02:05")

def test_HLA_A_02_06():
    # HLA-A*02:06 occurs 5951 times in 2019 IEDB snapshot
    parse("HLA-A*02:06")

def test_HLA_A_02_07():
    # HLA-A*02:07 occurs 3567 times in 2019 IEDB snapshot
    parse("HLA-A*02:07")

def test_HLA_A_02_08():
    # HLA-A*02:08 occurs 5 times in 2019 IEDB snapshot
    parse("HLA-A*02:08")

def test_HLA_A_02_09():
    # HLA-A*02:09 occurs 5 times in 2019 IEDB snapshot
    parse("HLA-A*02:09")

def test_HLA_A_02_10():
    # HLA-A*02:10 occurs 18 times in 2019 IEDB snapshot
    parse("HLA-A*02:10")

def test_HLA_A_02_11():
    # HLA-A*02:11 occurs 718 times in 2019 IEDB snapshot
    parse("HLA-A*02:11")

def test_HLA_A_02_12():
    # HLA-A*02:12 occurs 892 times in 2019 IEDB snapshot
    parse("HLA-A*02:12")

def test_HLA_A_02_14():
    # HLA-A*02:14 occurs 12 times in 2019 IEDB snapshot
    parse("HLA-A*02:14")

def test_HLA_A_02_16():
    # HLA-A*02:16 occurs 604 times in 2019 IEDB snapshot
    parse("HLA-A*02:16")

def test_HLA_A_02_17():
    # HLA-A*02:17 occurs 332 times in 2019 IEDB snapshot
    parse("HLA-A*02:17")

def test_HLA_A_02_19():
    # HLA-A*02:19 occurs 836 times in 2019 IEDB snapshot
    parse("HLA-A*02:19")

def test_HLA_A_02_50():
    # HLA-A*02:50 occurs 125 times in 2019 IEDB snapshot
    parse("HLA-A*02:50")

def test_HLA_A_03_01():
    # HLA-A*03:01 occurs 16821 times in 2019 IEDB snapshot
    parse("HLA-A*03:01")

def test_HLA_A_03_02():
    # HLA-A*03:02 occurs 17 times in 2019 IEDB snapshot
    parse("HLA-A*03:02")

def test_HLA_A_03_19():
    # HLA-A*03:19 occurs 29 times in 2019 IEDB snapshot
    parse("HLA-A*03:19")

def test_HLA_A_11_01():
    # HLA-A*11:01 occurs 11248 times in 2019 IEDB snapshot
    parse("HLA-A*11:01")

def test_HLA_A_11_02():
    # HLA-A*11:02 occurs 14 times in 2019 IEDB snapshot
    parse("HLA-A*11:02")

def test_HLA_A_23_01():
    # HLA-A*23:01 occurs 1894 times in 2019 IEDB snapshot
    parse("HLA-A*23:01")

def test_HLA_A_24_02():
    # HLA-A*24:02 occurs 12788 times in 2019 IEDB snapshot
    parse("HLA-A*24:02")

def test_HLA_A_24_03():
    # HLA-A*24:03 occurs 1434 times in 2019 IEDB snapshot
    parse("HLA-A*24:03")

def test_HLA_A_24_06():
    # HLA-A*24:06 occurs 407 times in 2019 IEDB snapshot
    parse("HLA-A*24:06")

def test_HLA_A_24_13():
    # HLA-A*24:13 occurs 250 times in 2019 IEDB snapshot
    parse("HLA-A*24:13")

def test_HLA_A_25_01():
    # HLA-A*25:01 occurs 912 times in 2019 IEDB snapshot
    parse("HLA-A*25:01")

def test_HLA_A_26_01():
    # HLA-A*26:01 occurs 4190 times in 2019 IEDB snapshot
    parse("HLA-A*26:01")

def test_HLA_A_26_02():
    # HLA-A*26:02 occurs 399 times in 2019 IEDB snapshot
    parse("HLA-A*26:02")

def test_HLA_A_26_03():
    # HLA-A*26:03 occurs 269 times in 2019 IEDB snapshot
    parse("HLA-A*26:03")

def test_HLA_A_29_02():
    # HLA-A*29:02 occurs 9741 times in 2019 IEDB snapshot
    parse("HLA-A*29:02")

def test_HLA_A_30_01():
    # HLA-A*30:01 occurs 2234 times in 2019 IEDB snapshot
    parse("HLA-A*30:01")

def test_HLA_A_30_02():
    # HLA-A*30:02 occurs 1944 times in 2019 IEDB snapshot
    parse("HLA-A*30:02")

def test_HLA_A_30_03():
    # HLA-A*30:03 occurs 4 times in 2019 IEDB snapshot
    parse("HLA-A*30:03")

def test_HLA_A_30_04():
    # HLA-A*30:04 occurs 5 times in 2019 IEDB snapshot
    parse("HLA-A*30:04")

def test_HLA_A_30_14L():
    # HLA-A*30:14L occurs 33 times in 2019 IEDB snapshot
    parse("HLA-A*30:14L")

def test_HLA_A_31_01():
    # HLA-A*31:01 occurs 6861 times in 2019 IEDB snapshot
    parse("HLA-A*31:01")

def test_HLA_A_32_01():
    # HLA-A*32:01 occurs 1421 times in 2019 IEDB snapshot
    parse("HLA-A*32:01")

def test_HLA_A_32_07():
    # HLA-A*32:07 occurs 87 times in 2019 IEDB snapshot
    parse("HLA-A*32:07")

def test_HLA_A_32_15():
    # HLA-A*32:15 occurs 74 times in 2019 IEDB snapshot
    parse("HLA-A*32:15")

def test_HLA_A_33_01():
    # HLA-A*33:01 occurs 2937 times in 2019 IEDB snapshot
    parse("HLA-A*33:01")

def test_HLA_A_33_03():
    # HLA-A*33:03 occurs 22 times in 2019 IEDB snapshot
    parse("HLA-A*33:03")

def test_HLA_A_66_01():
    # HLA-A*66:01 occurs 122 times in 2019 IEDB snapshot
    parse("HLA-A*66:01")

def test_HLA_A_66_02():
    # HLA-A*66:02 occurs 31 times in 2019 IEDB snapshot
    parse("HLA-A*66:02")

def test_HLA_A_68_01():
    # HLA-A*68:01 occurs 3552 times in 2019 IEDB snapshot
    parse("HLA-A*68:01")

def test_HLA_A_68_02():
    # HLA-A*68:02 occurs 8820 times in 2019 IEDB snapshot
    parse("HLA-A*68:02")

def test_HLA_A_68_23():
    # HLA-A*68:23 occurs 80 times in 2019 IEDB snapshot
    parse("HLA-A*68:23")

def test_HLA_A_69_01():
    # HLA-A*69:01 occurs 3020 times in 2019 IEDB snapshot
    parse("HLA-A*69:01")

def test_HLA_A_80_01():
    # HLA-A*80:01 occurs 1123 times in 2019 IEDB snapshot
    parse("HLA-A*80:01")

def test_HLA_A1():
    # HLA-A1 occurs 291 times in 2019 IEDB snapshot
    parse("HLA-A1")

def test_HLA_A11():
    # HLA-A11 occurs 759 times in 2019 IEDB snapshot
    parse("HLA-A11")

def test_HLA_A2():
    # HLA-A2 occurs 2380 times in 2019 IEDB snapshot
    parse("HLA-A2")

def test_HLA_A23():
    # HLA-A23 occurs 18 times in 2019 IEDB snapshot
    parse("HLA-A23")

def test_HLA_A24():
    # HLA-A24 occurs 431 times in 2019 IEDB snapshot
    parse("HLA-A24")

def test_HLA_A25():
    # HLA-A25 occurs 63 times in 2019 IEDB snapshot
    parse("HLA-A25")

def test_HLA_A26():
    # HLA-A26 occurs 457 times in 2019 IEDB snapshot
    parse("HLA-A26")

def test_HLA_A29():
    # HLA-A29 occurs 124 times in 2019 IEDB snapshot
    parse("HLA-A29")

def test_HLA_A3():
    # HLA-A3 occurs 1685 times in 2019 IEDB snapshot
    parse("HLA-A3")

def test_HLA_A30():
    # HLA-A30 occurs 44 times in 2019 IEDB snapshot
    parse("HLA-A30")

def test_HLA_A31():
    # HLA-A31 occurs 23 times in 2019 IEDB snapshot
    parse("HLA-A31")

def test_HLA_A32():
    # HLA-A32 occurs 115 times in 2019 IEDB snapshot
    parse("HLA-A32")

def test_HLA_A33():
    # HLA-A33 occurs 21 times in 2019 IEDB snapshot
    parse("HLA-A33")

def test_HLA_A68():
    # HLA-A68 occurs 53 times in 2019 IEDB snapshot
    parse("HLA-A68")

def test_HLA_B_07_02():
    # HLA-B*07:02 occurs 20812 times in 2019 IEDB snapshot
    parse("HLA-B*07:02")

def test_HLA_B_08_01():
    # HLA-B*08:01 occurs 7345 times in 2019 IEDB snapshot
    parse("HLA-B*08:01")

def test_HLA_B_08_01_B_I66A_mutant():
    # HLA-B*08:01 B:I66A mutant occurs 2 times in 2019 IEDB snapshot
    parse("HLA-B*08:01 B:I66A mutant")

def test_HLA_B_08_01_N80I_mutant():
    # HLA-B*08:01 N80I mutant occurs 2 times in 2019 IEDB snapshot
    parse("HLA-B*08:01 N80I mutant")

def test_HLA_B_08_02():
    # HLA-B*08:02 occurs 431 times in 2019 IEDB snapshot
    parse("HLA-B*08:02")

def test_HLA_B_08_03():
    # HLA-B*08:03 occurs 203 times in 2019 IEDB snapshot
    parse("HLA-B*08:03")

def test_HLA_B_13_01():
    # HLA-B*13:01 occurs 54 times in 2019 IEDB snapshot
    parse("HLA-B*13:01")

def test_HLA_B_13_02():
    # HLA-B*13:02 occurs 45 times in 2019 IEDB snapshot
    parse("HLA-B*13:02")

def test_HLA_B_14_02():
    # HLA-B*14:02 occurs 440 times in 2019 IEDB snapshot
    parse("HLA-B*14:02")

def test_HLA_B_14_03():
    # HLA-B*14:03 occurs 21 times in 2019 IEDB snapshot
    parse("HLA-B*14:03")

def test_HLA_B_15_01():
    # HLA-B*15:01 occurs 16684 times in 2019 IEDB snapshot
    parse("HLA-B*15:01")

def test_HLA_B_15_02():
    # HLA-B*15:02 occurs 364 times in 2019 IEDB snapshot
    parse("HLA-B*15:02")

def test_HLA_B_15_03():
    # HLA-B*15:03 occurs 397 times in 2019 IEDB snapshot
    parse("HLA-B*15:03")

def test_HLA_B_15_08():
    # HLA-B*15:08 occurs 33 times in 2019 IEDB snapshot
    parse("HLA-B*15:08")

def test_HLA_B_15_09():
    # HLA-B*15:09 occurs 425 times in 2019 IEDB snapshot
    parse("HLA-B*15:09")

def test_HLA_B_15_10():
    # HLA-B*15:10 occurs 23 times in 2019 IEDB snapshot
    parse("HLA-B*15:10")

def test_HLA_B_15_11():
    # HLA-B*15:11 occurs 109 times in 2019 IEDB snapshot
    parse("HLA-B*15:11")

def test_HLA_B_15_13():
    # HLA-B*15:13 occurs 6 times in 2019 IEDB snapshot
    parse("HLA-B*15:13")

def test_HLA_B_15_16():
    # HLA-B*15:16 occurs 46 times in 2019 IEDB snapshot
    parse("HLA-B*15:16")

def test_HLA_B_15_17():
    # HLA-B*15:17 occurs 1412 times in 2019 IEDB snapshot
    parse("HLA-B*15:17")

def test_HLA_B_15_18():
    # HLA-B*15:18 occurs 5 times in 2019 IEDB snapshot
    parse("HLA-B*15:18")

def test_HLA_B_15_42():
    # HLA-B*15:42 occurs 362 times in 2019 IEDB snapshot
    parse("HLA-B*15:42")

def test_HLA_B_18_01():
    # HLA-B*18:01 occurs 3468 times in 2019 IEDB snapshot
    parse("HLA-B*18:01")

def test_HLA_B_18_03():
    # HLA-B*18:03 occurs 215 times in 2019 IEDB snapshot
    parse("HLA-B*18:03")

def test_HLA_B_27_01():
    # HLA-B*27:01 occurs 3944 times in 2019 IEDB snapshot
    parse("HLA-B*27:01")

def test_HLA_B_27_02():
    # HLA-B*27:02 occurs 3682 times in 2019 IEDB snapshot
    parse("HLA-B*27:02")

def test_HLA_B_27_03():
    # HLA-B*27:03 occurs 2150 times in 2019 IEDB snapshot
    parse("HLA-B*27:03")

def test_HLA_B_27_04():
    # HLA-B*27:04 occurs 1637 times in 2019 IEDB snapshot
    parse("HLA-B*27:04")

def test_HLA_B_27_05():
    # HLA-B*27:05 occurs 95076 times in 2019 IEDB snapshot
    parse("HLA-B*27:05")

def test_HLA_B_27_05_D74Y_D77N_mutant():
    # HLA-B*27:05 D74Y D77N mutant occurs 3 times in 2019 IEDB snapshot
    parse("HLA-B*27:05 D74Y D77N mutant")

def test_HLA_B_27_05_L81A_mutant():
    # HLA-B*27:05 L81A mutant occurs 4 times in 2019 IEDB snapshot
    parse("HLA-B*27:05 L81A mutant")

def test_HLA_B_27_06():
    # HLA-B*27:06 occurs 1540 times in 2019 IEDB snapshot
    parse("HLA-B*27:06")

def test_HLA_B_27_07():
    # HLA-B*27:07 occurs 2232 times in 2019 IEDB snapshot
    parse("HLA-B*27:07")

def test_HLA_B_27_08():
    # HLA-B*27:08 occurs 2354 times in 2019 IEDB snapshot
    parse("HLA-B*27:08")

def test_HLA_B_27_09():
    # HLA-B*27:09 occurs 2515 times in 2019 IEDB snapshot
    parse("HLA-B*27:09")

def test_HLA_B_27_10():
    # HLA-B*27:10 occurs 13 times in 2019 IEDB snapshot
    parse("HLA-B*27:10")

def test_HLA_B_27_20():
    # HLA-B*27:20 occurs 87 times in 2019 IEDB snapshot
    parse("HLA-B*27:20")

def test_HLA_B_35_01():
    # HLA-B*35:01 occurs 5427 times in 2019 IEDB snapshot
    parse("HLA-B*35:01")

def test_HLA_B_35_02():
    # HLA-B*35:02 occurs 38 times in 2019 IEDB snapshot
    parse("HLA-B*35:02")

def test_HLA_B_35_03():
    # HLA-B*35:03 occurs 256 times in 2019 IEDB snapshot
    parse("HLA-B*35:03")

def test_HLA_B_35_04():
    # HLA-B*35:04 occurs 12 times in 2019 IEDB snapshot
    parse("HLA-B*35:04")

def test_HLA_B_35_06():
    # HLA-B*35:06 occurs 10 times in 2019 IEDB snapshot
    parse("HLA-B*35:06")

def test_HLA_B_35_08():
    # HLA-B*35:08 occurs 432 times in 2019 IEDB snapshot
    parse("HLA-B*35:08")

def test_HLA_B_35_08_Q65A_T69A_Q155A_mutant():
    # HLA-B*35:08 Q65A, T69A, Q155A mutant occurs 2 times in 2019 IEDB snapshot
    parse("HLA-B*35:08 Q65A, T69A, Q155A mutant")

def test_HLA_B_37_01():
    # HLA-B*37:01 occurs 39 times in 2019 IEDB snapshot
    parse("HLA-B*37:01")

def test_HLA_B_38_01():
    # HLA-B*38:01 occurs 158 times in 2019 IEDB snapshot
    parse("HLA-B*38:01")

def test_HLA_B_39_01():
    # HLA-B*39:01 occurs 2250 times in 2019 IEDB snapshot
    parse("HLA-B*39:01")

def test_HLA_B_39_05():
    # HLA-B*39:05 occurs 8 times in 2019 IEDB snapshot
    parse("HLA-B*39:05")

def test_HLA_B_39_06():
    # HLA-B*39:06 occurs 54 times in 2019 IEDB snapshot
    parse("HLA-B*39:06")

def test_HLA_B_39_09():
    # HLA-B*39:09 occurs 9 times in 2019 IEDB snapshot
    parse("HLA-B*39:09")

def test_HLA_B_39_10():
    # HLA-B*39:10 occurs 6 times in 2019 IEDB snapshot
    parse("HLA-B*39:10")

def test_HLA_B_39_24():
    # HLA-B*39:24 occurs 261 times in 2019 IEDB snapshot
    parse("HLA-B*39:24")

def test_HLA_B_40_01():
    # HLA-B*40:01 occurs 6071 times in 2019 IEDB snapshot
    parse("HLA-B*40:01")

def test_HLA_B_40_02():
    # HLA-B*40:02 occurs 9574 times in 2019 IEDB snapshot
    parse("HLA-B*40:02")

def test_HLA_B_40_13():
    # HLA-B*40:13 occurs 56 times in 2019 IEDB snapshot
    parse("HLA-B*40:13")

def test_HLA_B_41_01():
    # HLA-B*41:01 occurs 486 times in 2019 IEDB snapshot
    parse("HLA-B*41:01")

def test_HLA_B_41_02():
    # HLA-B*41:02 occurs 22 times in 2019 IEDB snapshot
    parse("HLA-B*41:02")

def test_HLA_B_41_03():
    # HLA-B*41:03 occurs 86 times in 2019 IEDB snapshot
    parse("HLA-B*41:03")

def test_HLA_B_41_04():
    # HLA-B*41:04 occurs 53 times in 2019 IEDB snapshot
    parse("HLA-B*41:04")

def test_HLA_B_41_05():
    # HLA-B*41:05 occurs 41 times in 2019 IEDB snapshot
    parse("HLA-B*41:05")

def test_HLA_B_41_06():
    # HLA-B*41:06 occurs 22 times in 2019 IEDB snapshot
    parse("HLA-B*41:06")

def test_HLA_B_42_01():
    # HLA-B*42:01 occurs 21 times in 2019 IEDB snapshot
    parse("HLA-B*42:01")

def test_HLA_B_42_02():
    # HLA-B*42:02 occurs 5 times in 2019 IEDB snapshot
    parse("HLA-B*42:02")

def test_HLA_B_44_02():
    # HLA-B*44:02 occurs 9186 times in 2019 IEDB snapshot
    parse("HLA-B*44:02")

def test_HLA_B_44_03():
    # HLA-B*44:03 occurs 11405 times in 2019 IEDB snapshot
    parse("HLA-B*44:03")

def test_HLA_B_44_05():
    # HLA-B*44:05 occurs 25 times in 2019 IEDB snapshot
    parse("HLA-B*44:05")

def test_HLA_B_44_08():
    # HLA-B*44:08 occurs 50 times in 2019 IEDB snapshot
    parse("HLA-B*44:08")

def test_HLA_B_44_27():
    # HLA-B*44:27 occurs 207 times in 2019 IEDB snapshot
    parse("HLA-B*44:27")

def test_HLA_B_44_28():
    # HLA-B*44:28 occurs 131 times in 2019 IEDB snapshot
    parse("HLA-B*44:28")

def test_HLA_B_45_01():
    # HLA-B*45:01 occurs 1365 times in 2019 IEDB snapshot
    parse("HLA-B*45:01")

def test_HLA_B_45_06():
    # HLA-B*45:06 occurs 355 times in 2019 IEDB snapshot
    parse("HLA-B*45:06")

def test_HLA_B_46_01():
    # HLA-B*46:01 occurs 3822 times in 2019 IEDB snapshot
    parse("HLA-B*46:01")

def test_HLA_B_47_01():
    # HLA-B*47:01 occurs 27 times in 2019 IEDB snapshot
    parse("HLA-B*47:01")

def test_HLA_B_48_01():
    # HLA-B*48:01 occurs 877 times in 2019 IEDB snapshot
    parse("HLA-B*48:01")

def test_HLA_B_49_01():
    # HLA-B*49:01 occurs 208 times in 2019 IEDB snapshot
    parse("HLA-B*49:01")

def test_HLA_B_50_01():
    # HLA-B*50:01 occurs 694 times in 2019 IEDB snapshot
    parse("HLA-B*50:01")

def test_HLA_B_50_02():
    # HLA-B*50:02 occurs 2 times in 2019 IEDB snapshot
    parse("HLA-B*50:02")

def test_HLA_B_51_01():
    # HLA-B*51:01 occurs 6591 times in 2019 IEDB snapshot
    parse("HLA-B*51:01")

def test_HLA_B_51_02():
    # HLA-B*51:02 occurs 7 times in 2019 IEDB snapshot
    parse("HLA-B*51:02")

def test_HLA_B_51_08():
    # HLA-B*51:08 occurs 624 times in 2019 IEDB snapshot
    parse("HLA-B*51:08")

def test_HLA_B_52_01():
    # HLA-B*52:01 occurs 10 times in 2019 IEDB snapshot
    parse("HLA-B*52:01")

def test_HLA_B_53_01():
    # HLA-B*53:01 occurs 1248 times in 2019 IEDB snapshot
    parse("HLA-B*53:01")

def test_HLA_B_54_01():
    # HLA-B*54:01 occurs 1903 times in 2019 IEDB snapshot
    parse("HLA-B*54:01")

def test_HLA_B_55_01():
    # HLA-B*55:01 occurs 4 times in 2019 IEDB snapshot
    parse("HLA-B*55:01")

def test_HLA_B_55_02():
    # HLA-B*55:02 occurs 28 times in 2019 IEDB snapshot
    parse("HLA-B*55:02")

def test_HLA_B_56_01():
    # HLA-B*56:01 occurs 728 times in 2019 IEDB snapshot
    parse("HLA-B*56:01")

def test_HLA_B_57_01():
    # HLA-B*57:01 occurs 17139 times in 2019 IEDB snapshot
    parse("HLA-B*57:01")

def test_HLA_B_57_01_I80N_mutant():
    # HLA-B*57:01 I80N mutant occurs 2 times in 2019 IEDB snapshot
    parse("HLA-B*57:01 I80N mutant")

def test_HLA_B_57_01_I80T_mutant():
    # HLA-B*57:01 I80T mutant occurs 1 times in 2019 IEDB snapshot
    parse("HLA-B*57:01 I80T mutant")

def test_HLA_B_57_02():
    # HLA-B*57:02 occurs 8 times in 2019 IEDB snapshot
    parse("HLA-B*57:02")

def test_HLA_B_57_03():
    # HLA-B*57:03 occurs 32 times in 2019 IEDB snapshot
    parse("HLA-B*57:03")

def test_HLA_B_58_01():
    # HLA-B*58:01 occurs 4026 times in 2019 IEDB snapshot
    parse("HLA-B*58:01")

def test_HLA_B_58_02():
    # HLA-B*58:02 occurs 7 times in 2019 IEDB snapshot
    parse("HLA-B*58:02")

def test_HLA_B_73_01():
    # HLA-B*73:01 occurs 306 times in 2019 IEDB snapshot
    parse("HLA-B*73:01")

def test_HLA_B_81_01():
    # HLA-B*81:01 occurs 7 times in 2019 IEDB snapshot
    parse("HLA-B*81:01")

def test_HLA_B_83_01():
    # HLA-B*83:01 occurs 333 times in 2019 IEDB snapshot
    parse("HLA-B*83:01")

def test_HLA_B12():
    # HLA-B12 occurs 3 times in 2019 IEDB snapshot
    parse("HLA-B12")

def test_HLA_B13():
    # HLA-B13 occurs 43 times in 2019 IEDB snapshot
    parse("HLA-B13")

def test_HLA_B15():
    # HLA-B15 occurs 20 times in 2019 IEDB snapshot
    parse("HLA-B15")

def test_HLA_B18():
    # HLA-B18 occurs 95 times in 2019 IEDB snapshot
    parse("HLA-B18")

def test_HLA_B27():
    # HLA-B27 occurs 1883 times in 2019 IEDB snapshot
    parse("HLA-B27")

def test_HLA_B35():
    # HLA-B35 occurs 913 times in 2019 IEDB snapshot
    parse("HLA-B35")

def test_HLA_B37():
    # HLA-B37 occurs 131 times in 2019 IEDB snapshot
    parse("HLA-B37")

def test_HLA_B38():
    # HLA-B38 occurs 48 times in 2019 IEDB snapshot
    parse("HLA-B38")

def test_HLA_B39():
    # HLA-B39 occurs 1343 times in 2019 IEDB snapshot
    parse("HLA-B39")

def test_HLA_B40():
    # HLA-B40 occurs 1632 times in 2019 IEDB snapshot
    parse("HLA-B40")

def test_HLA_B44():
    # HLA-B44 occurs 727 times in 2019 IEDB snapshot
    parse("HLA-B44")

def test_HLA_B45():
    # HLA-B45 occurs 1 times in 2019 IEDB snapshot
    parse("HLA-B45")

def test_HLA_B49():
    # HLA-B49 occurs 7 times in 2019 IEDB snapshot
    parse("HLA-B49")

def test_HLA_B50():
    # HLA-B50 occurs 10 times in 2019 IEDB snapshot
    parse("HLA-B50")

def test_HLA_B51():
    # HLA-B51 occurs 545 times in 2019 IEDB snapshot
    parse("HLA-B51")

def test_HLA_B53():
    # HLA-B53 occurs 2 times in 2019 IEDB snapshot
    parse("HLA-B53")

def test_HLA_B54():
    # HLA-B54 occurs 2 times in 2019 IEDB snapshot
    parse("HLA-B54")

def test_HLA_B55():
    # HLA-B55 occurs 14 times in 2019 IEDB snapshot
    parse("HLA-B55")

def test_HLA_B57():
    # HLA-B57 occurs 398 times in 2019 IEDB snapshot
    parse("HLA-B57")

def test_HLA_B58():
    # HLA-B58 occurs 8 times in 2019 IEDB snapshot
    parse("HLA-B58")

def test_HLA_B60():
    # HLA-B60 occurs 6 times in 2019 IEDB snapshot
    parse("HLA-B60")

def test_HLA_B61():
    # HLA-B61 occurs 15 times in 2019 IEDB snapshot
    parse("HLA-B61")

def test_HLA_B62():
    # HLA-B62 occurs 37 times in 2019 IEDB snapshot
    parse("HLA-B62")

def test_HLA_B7():
    # HLA-B7 occurs 6241 times in 2019 IEDB snapshot
    parse("HLA-B7")

def test_HLA_B78():
    # HLA-B78 occurs 3 times in 2019 IEDB snapshot
    parse("HLA-B78")

def test_HLA_B8():
    # HLA-B8 occurs 263 times in 2019 IEDB snapshot
    parse("HLA-B8")

def test_HLA_C_01_02():
    # HLA-C*01:02 occurs 732 times in 2019 IEDB snapshot
    parse("HLA-C*01:02")

def test_HLA_C_03_03():
    # HLA-C*03:03 occurs 235 times in 2019 IEDB snapshot
    parse("HLA-C*03:03")

def test_HLA_C_03_04():
    # HLA-C*03:04 occurs 500 times in 2019 IEDB snapshot
    parse("HLA-C*03:04")

def test_HLA_C_04_01():
    # HLA-C*04:01 occurs 1700 times in 2019 IEDB snapshot
    parse("HLA-C*04:01")

def test_HLA_C_05_01():
    # HLA-C*05:01 occurs 2920 times in 2019 IEDB snapshot
    parse("HLA-C*05:01")

def test_HLA_C_06_02():
    # HLA-C*06:02 occurs 3080 times in 2019 IEDB snapshot
    parse("HLA-C*06:02")

def test_HLA_C_07_01():
    # HLA-C*07:01 occurs 495 times in 2019 IEDB snapshot
    parse("HLA-C*07:01")

def test_HLA_C_07_02():
    # HLA-C*07:02 occurs 734 times in 2019 IEDB snapshot
    parse("HLA-C*07:02")

def test_HLA_C_07_04():
    # HLA-C*07:04 occurs 1 times in 2019 IEDB snapshot
    parse("HLA-C*07:04")

def test_HLA_C_08_01():
    # HLA-C*08:01 occurs 48 times in 2019 IEDB snapshot
    parse("HLA-C*08:01")

def test_HLA_C_08_02():
    # HLA-C*08:02 occurs 135 times in 2019 IEDB snapshot
    parse("HLA-C*08:02")

def test_HLA_C_12_02():
    # HLA-C*12:02 occurs 10 times in 2019 IEDB snapshot
    parse("HLA-C*12:02")

def test_HLA_C_12_03():
    # HLA-C*12:03 occurs 185 times in 2019 IEDB snapshot
    parse("HLA-C*12:03")

def test_HLA_C_12_04():
    # HLA-C*12:04 occurs 3 times in 2019 IEDB snapshot
    parse("HLA-C*12:04")

def test_HLA_C_14_02():
    # HLA-C*14:02 occurs 320 times in 2019 IEDB snapshot
    parse("HLA-C*14:02")

def test_HLA_C_15_02():
    # HLA-C*15:02 occurs 181 times in 2019 IEDB snapshot
    parse("HLA-C*15:02")

def test_HLA_C_16_01():
    # HLA-C*16:01 occurs 774 times in 2019 IEDB snapshot
    parse("HLA-C*16:01")

def test_HLA_Cw1():
    # HLA-Cw1 occurs 17 times in 2019 IEDB snapshot
    parse("HLA-Cw1")

def test_HLA_Cw12():
    # HLA-Cw12 occurs 1 times in 2019 IEDB snapshot
    parse("HLA-Cw12")

def test_HLA_Cw3():
    # HLA-Cw3 occurs 2 times in 2019 IEDB snapshot
    parse("HLA-Cw3")

def test_HLA_Cw4():
    # HLA-Cw4 occurs 38 times in 2019 IEDB snapshot
    parse("HLA-Cw4")

def test_HLA_Cw7():
    # HLA-Cw7 occurs 14 times in 2019 IEDB snapshot
    parse("HLA-Cw7")

def test_HLA_DP():
    # HLA-DP occurs 10 times in 2019 IEDB snapshot
    parse("HLA-DP")

def test_HLA_DPA1_01_03_DPB1_02_01():
    # HLA-DPA1*01:03/DPB1*02:01 occurs 850 times in 2019 IEDB snapshot
    parse("HLA-DPA1*01:03/DPB1*02:01")

def test_HLA_DPA1_01_03_DPB1_03_01():
    # HLA-DPA1*01:03/DPB1*03:01 occurs 176 times in 2019 IEDB snapshot
    parse("HLA-DPA1*01:03/DPB1*03:01")

def test_HLA_DPA1_01_03_DPB1_04_01():
    # HLA-DPA1*01:03/DPB1*04:01 occurs 984 times in 2019 IEDB snapshot
    parse("HLA-DPA1*01:03/DPB1*04:01")

def test_HLA_DPA1_01_03_DPB1_04_02():
    # HLA-DPA1*01:03/DPB1*04:02 occurs 44 times in 2019 IEDB snapshot
    parse("HLA-DPA1*01:03/DPB1*04:02")

def test_HLA_DPA1_02_01_DPB1_01_01():
    # HLA-DPA1*02:01/DPB1*01:01 occurs 983 times in 2019 IEDB snapshot
    parse("HLA-DPA1*02:01/DPB1*01:01")

def test_HLA_DPA1_02_01_DPB1_05_01():
    # HLA-DPA1*02:01/DPB1*05:01 occurs 972 times in 2019 IEDB snapshot
    parse("HLA-DPA1*02:01/DPB1*05:01")

def test_HLA_DPA1_02_02_DPB1_05_01():
    # HLA-DPA1*02:02/DPB1*05:01 occurs 7 times in 2019 IEDB snapshot
    parse("HLA-DPA1*02:02/DPB1*05:01")

def test_HLA_DPA1_03_01_DPB1_04_02():
    # HLA-DPA1*03:01/DPB1*04:02 occurs 974 times in 2019 IEDB snapshot
    parse("HLA-DPA1*03:01/DPB1*04:02")

def test_HLA_DPB1_01_01():
    # HLA-DPB1*01:01 occurs 106 times in 2019 IEDB snapshot
    parse("HLA-DPB1*01:01")

def test_HLA_DPB1_02_01():
    # HLA-DPB1*02:01 occurs 301 times in 2019 IEDB snapshot
    parse("HLA-DPB1*02:01")

def test_HLA_DPB1_02_01_E69K_mutant():
    # HLA-DPB1*02:01 E69K mutant occurs 2 times in 2019 IEDB snapshot
    parse("HLA-DPB1*02:01 E69K mutant")

def test_HLA_DPB1_03_01():
    # HLA-DPB1*03:01 occurs 117 times in 2019 IEDB snapshot
    parse("HLA-DPB1*03:01")

def test_HLA_DPB1_04_01():
    # HLA-DPB1*04:01 occurs 357 times in 2019 IEDB snapshot
    parse("HLA-DPB1*04:01")

def test_HLA_DPB1_04_02():
    # HLA-DPB1*04:02 occurs 317 times in 2019 IEDB snapshot
    parse("HLA-DPB1*04:02")

def test_HLA_DPB1_05_01():
    # HLA-DPB1*05:01 occurs 124 times in 2019 IEDB snapshot
    parse("HLA-DPB1*05:01")

def test_HLA_DPB1_09_01():
    # HLA-DPB1*09:01 occurs 65 times in 2019 IEDB snapshot
    parse("HLA-DPB1*09:01")

def test_HLA_DPB1_11_01():
    # HLA-DPB1*11:01 occurs 2 times in 2019 IEDB snapshot
    parse("HLA-DPB1*11:01")

def test_HLA_DPB1_14_01():
    # HLA-DPB1*14:01 occurs 285 times in 2019 IEDB snapshot
    parse("HLA-DPB1*14:01")

def test_HLA_DPB1_20_01():
    # HLA-DPB1*20:01 occurs 278 times in 2019 IEDB snapshot
    parse("HLA-DPB1*20:01")

def test_HLA_DPw2():
    # HLA-DPw2 occurs 78 times in 2019 IEDB snapshot
    parse("HLA-DPw2")

def test_HLA_DPw4():
    # HLA-DPw4 occurs 12 times in 2019 IEDB snapshot
    parse("HLA-DPw4")

def test_HLA_DQ():
    # HLA-DQ occurs 165 times in 2019 IEDB snapshot
    parse("HLA-DQ")

def test_HLA_DQ1():
    # HLA-DQ1 occurs 3 times in 2019 IEDB snapshot
    parse("HLA-DQ1")

def test_HLA_DQ2():
    # HLA-DQ2 occurs 281 times in 2019 IEDB snapshot
    parse("HLA-DQ2")

def test_HLA_DQ5():
    # HLA-DQ5 occurs 1 times in 2019 IEDB snapshot
    parse("HLA-DQ5")

def test_HLA_DQ6():
    # HLA-DQ6 occurs 26 times in 2019 IEDB snapshot
    parse("HLA-DQ6")

def test_HLA_DQ7():
    # HLA-DQ7 occurs 18 times in 2019 IEDB snapshot
    parse("HLA-DQ7")

def test_HLA_DQ8():
    # HLA-DQ8 occurs 214 times in 2019 IEDB snapshot
    parse("HLA-DQ8")

def test_HLA_DQ9():
    # HLA-DQ9 occurs 1 times in 2019 IEDB snapshot
    parse("HLA-DQ9")

def test_HLA_DQA1_01_01():
    # HLA-DQA1*01:01 occurs 90 times in 2019 IEDB snapshot
    parse("HLA-DQA1*01:01")

def test_HLA_DQA1_01_01_DQB1_05_01():
    # HLA-DQA1*01:01/DQB1*05:01 occurs 1023 times in 2019 IEDB snapshot
    parse("HLA-DQA1*01:01/DQB1*05:01")

def test_HLA_DQA1_01_01_DQB1_05_03():
    # HLA-DQA1*01:01/DQB1*05:03 occurs 1 times in 2019 IEDB snapshot
    parse("HLA-DQA1*01:01/DQB1*05:03")

def test_HLA_DQA1_01_02():
    # HLA-DQA1*01:02 occurs 90 times in 2019 IEDB snapshot
    parse("HLA-DQA1*01:02")

def test_HLA_DQA1_01_02_DQB1_05_01():
    # HLA-DQA1*01:02/DQB1*05:01 occurs 839 times in 2019 IEDB snapshot
    parse("HLA-DQA1*01:02/DQB1*05:01")

def test_HLA_DQA1_01_02_DQB1_05_02():
    # HLA-DQA1*01:02/DQB1*05:02 occurs 176 times in 2019 IEDB snapshot
    parse("HLA-DQA1*01:02/DQB1*05:02")

def test_HLA_DQA1_01_02_DQB1_06_02():
    # HLA-DQA1*01:02/DQB1*06:02 occurs 1189 times in 2019 IEDB snapshot
    parse("HLA-DQA1*01:02/DQB1*06:02")

def test_HLA_DQA1_01_02_DQB1_06_04():
    # HLA-DQA1*01:02/DQB1*06:04 occurs 111 times in 2019 IEDB snapshot
    parse("HLA-DQA1*01:02/DQB1*06:04")

def test_HLA_DQA1_01_03_DQB1_03_02():
    # HLA-DQA1*01:03/DQB1*03:02 occurs 6 times in 2019 IEDB snapshot
    parse("HLA-DQA1*01:03/DQB1*03:02")

def test_HLA_DQA1_01_03_DQB1_06_01():
    # HLA-DQA1*01:03/DQB1*06:01 occurs 4 times in 2019 IEDB snapshot
    parse("HLA-DQA1*01:03/DQB1*06:01")

def test_HLA_DQA1_01_03_DQB1_06_03():
    # HLA-DQA1*01:03/DQB1*06:03 occurs 378 times in 2019 IEDB snapshot
    parse("HLA-DQA1*01:03/DQB1*06:03")

def test_HLA_DQA1_01_04_DQB1_05_03():
    # HLA-DQA1*01:04/DQB1*05:03 occurs 169 times in 2019 IEDB snapshot
    parse("HLA-DQA1*01:04/DQB1*05:03")

def test_HLA_DQA1_02_01_DQB1_02_01():
    # HLA-DQA1*02:01/DQB1*02:01 occurs 94 times in 2019 IEDB snapshot
    parse("HLA-DQA1*02:01/DQB1*02:01")

def test_HLA_DQA1_02_01_DQB1_02_02():
    # HLA-DQA1*02:01/DQB1*02:02 occurs 7584 times in 2019 IEDB snapshot
    parse("HLA-DQA1*02:01/DQB1*02:02")

def test_HLA_DQA1_02_01_DQB1_03_01():
    # HLA-DQA1*02:01/DQB1*03:01 occurs 829 times in 2019 IEDB snapshot
    parse("HLA-DQA1*02:01/DQB1*03:01")

def test_HLA_DQA1_02_01_DQB1_03_03():
    # HLA-DQA1*02:01/DQB1*03:03 occurs 764 times in 2019 IEDB snapshot
    parse("HLA-DQA1*02:01/DQB1*03:03")

def test_HLA_DQA1_02_01_DQB1_04_02():
    # HLA-DQA1*02:01/DQB1*04:02 occurs 768 times in 2019 IEDB snapshot
    parse("HLA-DQA1*02:01/DQB1*04:02")

def test_HLA_DQA1_03_01():
    # HLA-DQA1*03:01 occurs 90 times in 2019 IEDB snapshot
    parse("HLA-DQA1*03:01")

def test_HLA_DQA1_03_01_DQB1_02_01():
    # HLA-DQA1*03:01/DQB1*02:01 occurs 28 times in 2019 IEDB snapshot
    parse("HLA-DQA1*03:01/DQB1*02:01")

def test_HLA_DQA1_03_01_DQB1_03_01():
    # HLA-DQA1*03:01/DQB1*03:01 occurs 139 times in 2019 IEDB snapshot
    parse("HLA-DQA1*03:01/DQB1*03:01")

def test_HLA_DQA1_03_01_DQB1_03_02():
    # HLA-DQA1*03:01/DQB1*03:02 occurs 1298 times in 2019 IEDB snapshot
    parse("HLA-DQA1*03:01/DQB1*03:02")

def test_HLA_DQA1_03_01_DQB1_04_01():
    # HLA-DQA1*03:01/DQB1*04:01 occurs 5 times in 2019 IEDB snapshot
    parse("HLA-DQA1*03:01/DQB1*04:01")

def test_HLA_DQA1_03_02_DQB1_03_01():
    # HLA-DQA1*03:02/DQB1*03:01 occurs 24 times in 2019 IEDB snapshot
    parse("HLA-DQA1*03:02/DQB1*03:01")

def test_HLA_DQA1_03_02_DQB1_03_03():
    # HLA-DQA1*03:02/DQB1*03:03 occurs 10 times in 2019 IEDB snapshot
    parse("HLA-DQA1*03:02/DQB1*03:03")

def test_HLA_DQA1_03_02_DQB1_04_01():
    # HLA-DQA1*03:02/DQB1*04:01 occurs 154 times in 2019 IEDB snapshot
    parse("HLA-DQA1*03:02/DQB1*04:01")

def test_HLA_DQA1_03_03_DQB1_04_02():
    # HLA-DQA1*03:03/DQB1*04:02 occurs 567 times in 2019 IEDB snapshot
    parse("HLA-DQA1*03:03/DQB1*04:02")

def test_HLA_DQA1_04_01_DQB1_04_02():
    # HLA-DQA1*04:01/DQB1*04:02 occurs 976 times in 2019 IEDB snapshot
    parse("HLA-DQA1*04:01/DQB1*04:02")

def test_HLA_DQA1_05_01():
    # HLA-DQA1*05:01 occurs 90 times in 2019 IEDB snapshot
    parse("HLA-DQA1*05:01")

def test_HLA_DQA1_05_01_DQB1_02_01():
    # HLA-DQA1*05:01/DQB1*02:01 occurs 5922 times in 2019 IEDB snapshot
    parse("HLA-DQA1*05:01/DQB1*02:01")

def test_HLA_DQA1_05_01_DQB1_03_01():
    # HLA-DQA1*05:01/DQB1*03:01 occurs 1009 times in 2019 IEDB snapshot
    parse("HLA-DQA1*05:01/DQB1*03:01")

def test_HLA_DQA1_05_01_DQB1_03_02():
    # HLA-DQA1*05:01/DQB1*03:02 occurs 881 times in 2019 IEDB snapshot
    parse("HLA-DQA1*05:01/DQB1*03:02")

def test_HLA_DQA1_05_01_DQB1_03_03():
    # HLA-DQA1*05:01/DQB1*03:03 occurs 564 times in 2019 IEDB snapshot
    parse("HLA-DQA1*05:01/DQB1*03:03")

def test_HLA_DQA1_05_01_DQB1_04_02():
    # HLA-DQA1*05:01/DQB1*04:02 occurs 749 times in 2019 IEDB snapshot
    parse("HLA-DQA1*05:01/DQB1*04:02")

def test_HLA_DQA1_05_05_DQB1_03_01():
    # HLA-DQA1*05:05/DQB1*03:01 occurs 7441 times in 2019 IEDB snapshot
    parse("HLA-DQA1*05:05/DQB1*03:01")

def test_HLA_DQA1_06_01_DQB1_04_02():
    # HLA-DQA1*06:01/DQB1*04:02 occurs 565 times in 2019 IEDB snapshot
    parse("HLA-DQA1*06:01/DQB1*04:02")

def test_HLA_DQB1_02_01():
    # HLA-DQB1*02:01 occurs 284 times in 2019 IEDB snapshot
    parse("HLA-DQB1*02:01")

def test_HLA_DQB1_02_02():
    # HLA-DQB1*02:02 occurs 102 times in 2019 IEDB snapshot
    parse("HLA-DQB1*02:02")

def test_HLA_DQB1_03_01():
    # HLA-DQB1*03:01 occurs 313 times in 2019 IEDB snapshot
    parse("HLA-DQB1*03:01")

def test_HLA_DQB1_03_02():
    # HLA-DQB1*03:02 occurs 549 times in 2019 IEDB snapshot
    parse("HLA-DQB1*03:02")

def test_HLA_DQB1_03_19():
    # HLA-DQB1*03:19 occurs 6 times in 2019 IEDB snapshot
    parse("HLA-DQB1*03:19")

def test_HLA_DQB1_04_02():
    # HLA-DQB1*04:02 occurs 113 times in 2019 IEDB snapshot
    parse("HLA-DQB1*04:02")

def test_HLA_DQB1_05_01():
    # HLA-DQB1*05:01 occurs 210 times in 2019 IEDB snapshot
    parse("HLA-DQB1*05:01")

def test_HLA_DQB1_05_02():
    # HLA-DQB1*05:02 occurs 102 times in 2019 IEDB snapshot
    parse("HLA-DQB1*05:02")

def test_HLA_DQB1_05_03():
    # HLA-DQB1*05:03 occurs 102 times in 2019 IEDB snapshot
    parse("HLA-DQB1*05:03")

def test_HLA_DQB1_06_02():
    # HLA-DQB1*06:02 occurs 399 times in 2019 IEDB snapshot
    parse("HLA-DQB1*06:02")

def test_HLA_DQB1_06_03():
    # HLA-DQB1*06:03 occurs 2 times in 2019 IEDB snapshot
    parse("HLA-DQB1*06:03")

def test_HLA_DQB1_06_04():
    # HLA-DQB1*06:04 occurs 3 times in 2019 IEDB snapshot
    parse("HLA-DQB1*06:04")

def test_HLA_DR():
    # HLA-DR occurs 14136 times in 2019 IEDB snapshot
    parse("HLA-DR")

def test_HLA_DR1():
    # HLA-DR1 occurs 6290 times in 2019 IEDB snapshot
    parse("HLA-DR1")

def test_HLA_DR11():
    # HLA-DR11 occurs 417 times in 2019 IEDB snapshot
    parse("HLA-DR11")

def test_HLA_DR12():
    # HLA-DR12 occurs 1 times in 2019 IEDB snapshot
    parse("HLA-DR12")

def test_HLA_DR13():
    # HLA-DR13 occurs 354 times in 2019 IEDB snapshot
    parse("HLA-DR13")

def test_HLA_DR14():
    # HLA-DR14 occurs 100 times in 2019 IEDB snapshot
    parse("HLA-DR14")

def test_HLA_DR15():
    # HLA-DR15 occurs 302 times in 2019 IEDB snapshot
    parse("HLA-DR15")

def test_HLA_DR17():
    # HLA-DR17 occurs 80 times in 2019 IEDB snapshot
    parse("HLA-DR17")

def test_HLA_DR2():
    # HLA-DR2 occurs 452 times in 2019 IEDB snapshot
    parse("HLA-DR2")

def test_HLA_DR3():
    # HLA-DR3 occurs 900 times in 2019 IEDB snapshot
    parse("HLA-DR3")

def test_HLA_DR4():
    # HLA-DR4 occurs 735 times in 2019 IEDB snapshot
    parse("HLA-DR4")

def test_HLA_DR5():
    # HLA-DR5 occurs 56 times in 2019 IEDB snapshot
    parse("HLA-DR5")

def test_HLA_DR52():
    # HLA-DR52 occurs 15 times in 2019 IEDB snapshot
    parse("HLA-DR52")

def test_HLA_DR53():
    # HLA-DR53 occurs 21 times in 2019 IEDB snapshot
    parse("HLA-DR53")

def test_HLA_DR6():
    # HLA-DR6 occurs 27 times in 2019 IEDB snapshot
    parse("HLA-DR6")

def test_HLA_DR7():
    # HLA-DR7 occurs 586 times in 2019 IEDB snapshot
    parse("HLA-DR7")

def test_HLA_DR8():
    # HLA-DR8 occurs 115 times in 2019 IEDB snapshot
    parse("HLA-DR8")

def test_HLA_DR9():
    # HLA-DR9 occurs 34 times in 2019 IEDB snapshot
    parse("HLA-DR9")

def test_HLA_DRA_01_01_F54C_mutant_DRB1_01_01():
    # HLA-DRA*01:01 F54C mutant/DRB1*01:01 occurs 3 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01 F54C mutant/DRB1*01:01")

def test_HLA_DRA_01_01_DRB1_01_01():
    # HLA-DRA*01:01/DRB1*01:01 occurs 251 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB1*01:01")

def test_HLA_DRA_01_01_DRB1_01_01_C30S_mutant():
    # HLA-DRA*01:01/DRB1*01:01 C30S mutant occurs 888 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB1*01:01 C30S mutant")

def test_HLA_DRA_01_01_DRB1_01_01_G86Y_mutant():
    # HLA-DRA*01:01/DRB1*01:01 G86Y mutant occurs 3 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB1*01:01 G86Y mutant")

def test_HLA_DRA_01_01_DRB1_03_01():
    # HLA-DRA*01:01/DRB1*03:01 occurs 974 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB1*03:01")

def test_HLA_DRA_01_01_DRB1_03_01_Q74R_mutant():
    # HLA-DRA*01:01/DRB1*03:01 Q74R mutant occurs 3 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB1*03:01 Q74R mutant")

def test_HLA_DRA_01_01_DRB1_04_01():
    # HLA-DRA*01:01/DRB1*04:01 occurs 241 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB1*04:01")

def test_HLA_DRA_01_01_DRB1_04_04():
    # HLA-DRA*01:01/DRB1*04:04 occurs 891 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB1*04:04")

def test_HLA_DRA_01_01_DRB1_07_01():
    # HLA-DRA*01:01/DRB1*07:01 occurs 873 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB1*07:01")

def test_HLA_DRA_01_01_DRB1_08_01():
    # HLA-DRA*01:01/DRB1*08:01 occurs 1386 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB1*08:01")

def test_HLA_DRA_01_01_DRB1_09_01():
    # HLA-DRA*01:01/DRB1*09:01 occurs 866 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB1*09:01")

def test_HLA_DRA_01_01_DRB1_10_01():
    # HLA-DRA*01:01/DRB1*10:01 occurs 238 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB1*10:01")

def test_HLA_DRA_01_01_DRB1_11_01():
    # HLA-DRA*01:01/DRB1*11:01 occurs 874 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB1*11:01")

def test_HLA_DRA_01_01_DRB1_13_01():
    # HLA-DRA*01:01/DRB1*13:01 occurs 841 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB1*13:01")

def test_HLA_DRA_01_01_DRB1_14_54():
    # HLA-DRA*01:01/DRB1*14:54 occurs 864 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB1*14:54")

def test_HLA_DRA_01_01_DRB1_15_01():
    # HLA-DRA*01:01/DRB1*15:01 occurs 15 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB1*15:01")

def test_HLA_DRA_01_01_DRB3_01_01():
    # HLA-DRA*01:01/DRB3*01:01 occurs 842 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB3*01:01")

def test_HLA_DRA_01_01_DRB3_02_02():
    # HLA-DRA*01:01/DRB3*02:02 occurs 775 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB3*02:02")

def test_HLA_DRA_01_01_DRB3_03_01():
    # HLA-DRA*01:01/DRB3*03:01 occurs 861 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB3*03:01")

def test_HLA_DRA_01_01_DRB4_01_03():
    # HLA-DRA*01:01/DRB4*01:03 occurs 827 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB4*01:03")

def test_HLA_DRA_01_01_DRB5_01_01():
    # HLA-DRA*01:01/DRB5*01:01 occurs 778 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:01/DRB5*01:01")

def test_HLA_DRA_01_02_DRB1_03_01_Q74R_mutant():
    # HLA-DRA*01:02/DRB1*03:01 Q74R mutant occurs 5 times in 2019 IEDB snapshot
    parse("HLA-DRA*01:02/DRB1*03:01 Q74R mutant")

def test_HLA_DRB1():
    # HLA-DRB1 occurs 463 times in 2019 IEDB snapshot
    parse("HLA-DRB1")

def test_HLA_DRB1_01_01():
    # HLA-DRB1*01:01 occurs 14358 times in 2019 IEDB snapshot
    parse("HLA-DRB1*01:01")

def test_HLA_DRB1_01_01_D57A_mutant():
    # HLA-DRB1*01:01 D57A mutant occurs 21 times in 2019 IEDB snapshot
    parse("HLA-DRB1*01:01 D57A mutant")

def test_HLA_DRB1_01_01_D57A_Y60H_mutant():
    # HLA-DRB1*01:01 D57A, Y60H mutant occurs 21 times in 2019 IEDB snapshot
    parse("HLA-DRB1*01:01 D57A, Y60H mutant")

def test_HLA_DRB1_01_01_D57V_mutant():
    # HLA-DRB1*01:01 D57V mutant occurs 21 times in 2019 IEDB snapshot
    parse("HLA-DRB1*01:01 D57V mutant")

def test_HLA_DRB1_01_01_D57V_Y60S_mutant():
    # HLA-DRB1*01:01 D57V, Y60S mutant occurs 21 times in 2019 IEDB snapshot
    parse("HLA-DRB1*01:01 D57V, Y60S mutant")

def test_HLA_DRB1_01_01_N82A_mutant():
    # HLA-DRB1*01:01 N82A mutant occurs 3 times in 2019 IEDB snapshot
    parse("HLA-DRB1*01:01 N82A mutant")

def test_HLA_DRB1_01_02():
    # HLA-DRB1*01:02 occurs 158 times in 2019 IEDB snapshot
    parse("HLA-DRB1*01:02")

def test_HLA_DRB1_01_03():
    # HLA-DRB1*01:03 occurs 218 times in 2019 IEDB snapshot
    parse("HLA-DRB1*01:03")

def test_HLA_DRB1_03_01():
    # HLA-DRB1*03:01 occurs 4374 times in 2019 IEDB snapshot
    parse("HLA-DRB1*03:01")

def test_HLA_DRB1_03_02():
    # HLA-DRB1*03:02 occurs 100 times in 2019 IEDB snapshot
    parse("HLA-DRB1*03:02")

def test_HLA_DRB1_03_03():
    # HLA-DRB1*03:03 occurs 28 times in 2019 IEDB snapshot
    parse("HLA-DRB1*03:03")

def test_HLA_DRB1_03_04():
    # HLA-DRB1*03:04 occurs 1 times in 2019 IEDB snapshot
    parse("HLA-DRB1*03:04")

def test_HLA_DRB1_03_05():
    # HLA-DRB1*03:05 occurs 18 times in 2019 IEDB snapshot
    parse("HLA-DRB1*03:05")

def test_HLA_DRB1_04_01():
    # HLA-DRB1*04:01 occurs 7188 times in 2019 IEDB snapshot
    parse("HLA-DRB1*04:01")

def test_HLA_DRB1_04_02():
    # HLA-DRB1*04:02 occurs 452 times in 2019 IEDB snapshot
    parse("HLA-DRB1*04:02")

def test_HLA_DRB1_04_03():
    # HLA-DRB1*04:03 occurs 214 times in 2019 IEDB snapshot
    parse("HLA-DRB1*04:03")

def test_HLA_DRB1_04_04():
    # HLA-DRB1*04:04 occurs 1850 times in 2019 IEDB snapshot
    parse("HLA-DRB1*04:04")

def test_HLA_DRB1_04_05():
    # HLA-DRB1*04:05 occurs 2456 times in 2019 IEDB snapshot
    parse("HLA-DRB1*04:05")

def test_HLA_DRB1_04_06():
    # HLA-DRB1*04:06 occurs 94 times in 2019 IEDB snapshot
    parse("HLA-DRB1*04:06")

def test_HLA_DRB1_04_07():
    # HLA-DRB1*04:07 occurs 10 times in 2019 IEDB snapshot
    parse("HLA-DRB1*04:07")

def test_HLA_DRB1_04_11():
    # HLA-DRB1*04:11 occurs 4 times in 2019 IEDB snapshot
    parse("HLA-DRB1*04:11")

def test_HLA_DRB1_07_01():
    # HLA-DRB1*07:01 occurs 4097 times in 2019 IEDB snapshot
    parse("HLA-DRB1*07:01")

def test_HLA_DRB1_08_01():
    # HLA-DRB1*08:01 occurs 150 times in 2019 IEDB snapshot
    parse("HLA-DRB1*08:01")

def test_HLA_DRB1_08_02():
    # HLA-DRB1*08:02 occurs 2514 times in 2019 IEDB snapshot
    parse("HLA-DRB1*08:02")

def test_HLA_DRB1_08_03():
    # HLA-DRB1*08:03 occurs 8 times in 2019 IEDB snapshot
    parse("HLA-DRB1*08:03")

def test_HLA_DRB1_08_04():
    # HLA-DRB1*08:04 occurs 3 times in 2019 IEDB snapshot
    parse("HLA-DRB1*08:04")

def test_HLA_DRB1_09_01():
    # HLA-DRB1*09:01 occurs 2389 times in 2019 IEDB snapshot
    parse("HLA-DRB1*09:01")

def test_HLA_DRB1_10_01():
    # HLA-DRB1*10:01 occurs 428 times in 2019 IEDB snapshot
    parse("HLA-DRB1*10:01")

def test_HLA_DRB1_11_01():
    # HLA-DRB1*11:01 occurs 4287 times in 2019 IEDB snapshot
    parse("HLA-DRB1*11:01")

def test_HLA_DRB1_11_02():
    # HLA-DRB1*11:02 occurs 70 times in 2019 IEDB snapshot
    parse("HLA-DRB1*11:02")

def test_HLA_DRB1_11_03():
    # HLA-DRB1*11:03 occurs 67 times in 2019 IEDB snapshot
    parse("HLA-DRB1*11:03")

def test_HLA_DRB1_11_04():
    # HLA-DRB1*11:04 occurs 140 times in 2019 IEDB snapshot
    parse("HLA-DRB1*11:04")

def test_HLA_DRB1_12_01():
    # HLA-DRB1*12:01 occurs 1310 times in 2019 IEDB snapshot
    parse("HLA-DRB1*12:01")

def test_HLA_DRB1_12_02():
    # HLA-DRB1*12:02 occurs 60 times in 2019 IEDB snapshot
    parse("HLA-DRB1*12:02")

def test_HLA_DRB1_13_01():
    # HLA-DRB1*13:01 occurs 619 times in 2019 IEDB snapshot
    parse("HLA-DRB1*13:01")

def test_HLA_DRB1_13_02():
    # HLA-DRB1*13:02 occurs 2681 times in 2019 IEDB snapshot
    parse("HLA-DRB1*13:02")

def test_HLA_DRB1_13_03():
    # HLA-DRB1*13:03 occurs 24 times in 2019 IEDB snapshot
    parse("HLA-DRB1*13:03")

def test_HLA_DRB1_13_04():
    # HLA-DRB1*13:04 occurs 12 times in 2019 IEDB snapshot
    parse("HLA-DRB1*13:04")

def test_HLA_DRB1_13_05():
    # HLA-DRB1*13:05 occurs 1 times in 2019 IEDB snapshot
    parse("HLA-DRB1*13:05")

def test_HLA_DRB1_14_01():
    # HLA-DRB1*14:01 occurs 49 times in 2019 IEDB snapshot
    parse("HLA-DRB1*14:01")

def test_HLA_DRB1_14_02():
    # HLA-DRB1*14:02 occurs 40 times in 2019 IEDB snapshot
    parse("HLA-DRB1*14:02")

def test_HLA_DRB1_15_01():
    # HLA-DRB1*15:01 occurs 4752 times in 2019 IEDB snapshot
    parse("HLA-DRB1*15:01")

def test_HLA_DRB1_15_02():
    # HLA-DRB1*15:02 occurs 167 times in 2019 IEDB snapshot
    parse("HLA-DRB1*15:02")

def test_HLA_DRB1_15_03():
    # HLA-DRB1*15:03 occurs 59 times in 2019 IEDB snapshot
    parse("HLA-DRB1*15:03")

def test_HLA_DRB1_16_01():
    # HLA-DRB1*16:01 occurs 56 times in 2019 IEDB snapshot
    parse("HLA-DRB1*16:01")

def test_HLA_DRB1_16_02():
    # HLA-DRB1*16:02 occurs 249 times in 2019 IEDB snapshot
    parse("HLA-DRB1*16:02")

def test_HLA_DRB3():
    # HLA-DRB3 occurs 141 times in 2019 IEDB snapshot
    parse("HLA-DRB3")

def test_HLA_DRB3_01_01():
    # HLA-DRB3*01:01 occurs 2270 times in 2019 IEDB snapshot
    parse("HLA-DRB3*01:01")

def test_HLA_DRB3_02_02():
    # HLA-DRB3*02:02 occurs 1111 times in 2019 IEDB snapshot
    parse("HLA-DRB3*02:02")

def test_HLA_DRB3_03_01():
    # HLA-DRB3*03:01 occurs 31 times in 2019 IEDB snapshot
    parse("HLA-DRB3*03:01")

def test_HLA_DRB4():
    # HLA-DRB4 occurs 140 times in 2019 IEDB snapshot
    parse("HLA-DRB4")

def test_HLA_DRB4_01_01():
    # HLA-DRB4*01:01 occurs 2424 times in 2019 IEDB snapshot
    parse("HLA-DRB4*01:01")

def test_HLA_DRB4_01_03():
    # HLA-DRB4*01:03 occurs 22 times in 2019 IEDB snapshot
    parse("HLA-DRB4*01:03")

def test_HLA_DRB5():
    # HLA-DRB5 occurs 166 times in 2019 IEDB snapshot
    parse("HLA-DRB5")

def test_HLA_DRB5_01_01():
    # HLA-DRB5*01:01 occurs 3273 times in 2019 IEDB snapshot
    parse("HLA-DRB5*01:01")

def test_HLA_DRB5_01_02():
    # HLA-DRB5*01:02 occurs 64 times in 2019 IEDB snapshot
    parse("HLA-DRB5*01:02")

def test_HLA_E():
    # HLA-E occurs 35 times in 2019 IEDB snapshot
    parse("HLA-E")

def test_HLA_E_01_01():
    # HLA-E*01:01 occurs 57 times in 2019 IEDB snapshot
    parse("HLA-E*01:01")

def test_HLA_E_01_03():
    # HLA-E*01:03 occurs 737 times in 2019 IEDB snapshot
    parse("HLA-E*01:03")

def test_HLA_G():
    # HLA-G occurs 16 times in 2019 IEDB snapshot
    parse("HLA-G")

def test_HLA_G_01_01():
    # HLA-G*01:01 occurs 8 times in 2019 IEDB snapshot
    parse("HLA-G*01:01")

def test_Mamu_class_I():
    # Mamu class I occurs 3 times in 2019 IEDB snapshot
    parse("Mamu class I")

def test_Mamu_A1_001_01():
    # Mamu-A1*001:01 occurs 2421 times in 2019 IEDB snapshot
    parse("Mamu-A1*001:01")

def test_Mamu_A1_002_01():
    # Mamu-A1*002:01 occurs 625 times in 2019 IEDB snapshot
    parse("Mamu-A1*002:01")

def test_Mamu_A1_011_01():
    # Mamu-A1*011:01 occurs 960 times in 2019 IEDB snapshot
    parse("Mamu-A1*011:01")

def test_Mamu_B_001_01():
    # Mamu-B*001:01 occurs 650 times in 2019 IEDB snapshot
    parse("Mamu-B*001:01")

def test_Mamu_B_003_01():
    # Mamu-B*003:01 occurs 32 times in 2019 IEDB snapshot
    parse("Mamu-B*003:01")

def test_Mamu_B_004_01():
    # Mamu-B*004:01 occurs 9 times in 2019 IEDB snapshot
    parse("Mamu-B*004:01")

def test_Mamu_B_008_01():
    # Mamu-B*008:01 occurs 880 times in 2019 IEDB snapshot
    parse("Mamu-B*008:01")

def test_Mamu_B_017_04():
    # Mamu-B*017:04 occurs 1458 times in 2019 IEDB snapshot
    parse("Mamu-B*017:04")

def test_Mamu_B_065_02():
    # Mamu-B*065:02 occurs 17 times in 2019 IEDB snapshot
    parse("Mamu-B*065:02")

def test_Mamu_DR1B():
    # Mamu-DR1B occurs 2 times in 2019 IEDB snapshot
    parse("Mamu-DR1B")

def test_Mamu_DR2():
    # Mamu-DR2 occurs 2 times in 2019 IEDB snapshot
    parse("Mamu-DR2")

def test_Mamu_DR3A():
    # Mamu-DR3A occurs 2 times in 2019 IEDB snapshot
    parse("Mamu-DR3A")

def test_Mamu_DR4():
    # Mamu-DR4 occurs 2 times in 2019 IEDB snapshot
    parse("Mamu-DR4")

def test_Mamu_DR6():
    # Mamu-DR6 occurs 2 times in 2019 IEDB snapshot
    parse("Mamu-DR6")

def test_Mamu_DR7A():
    # Mamu-DR7A occurs 2 times in 2019 IEDB snapshot
    parse("Mamu-DR7A")

def test_Mamu_DR8():
    # Mamu-DR8 occurs 2 times in 2019 IEDB snapshot
    parse("Mamu-DR8")

def test_Mamu_DRB_w2_01():
    # Mamu-DRB*w2:01 occurs 93 times in 2019 IEDB snapshot
    parse("Mamu-DRB*w2:01")

def test_Mamu_DRB1_03_03():
    # Mamu-DRB1*03:03 occurs 2 times in 2019 IEDB snapshot
    parse("Mamu-DRB1*03:03")

def test_Mamu_DRB1_03_06():
    # Mamu-DRB1*03:06 occurs 2 times in 2019 IEDB snapshot
    parse("Mamu-DRB1*03:06")

def test_Mamu_DRB1_03_08():
    # Mamu-DRB1*03:08 occurs 2 times in 2019 IEDB snapshot
    parse("Mamu-DRB1*03:08")

def test_Mamu_DRB1_04_06():
    # Mamu-DRB1*04:06 occurs 94 times in 2019 IEDB snapshot
    parse("Mamu-DRB1*04:06")

def test_Patr_A_01_01():
    # Patr-A*01:01 occurs 108 times in 2019 IEDB snapshot
    parse("Patr-A*01:01")

def test_Patr_A_03_01():
    # Patr-A*03:01 occurs 8 times in 2019 IEDB snapshot
    parse("Patr-A*03:01")

def test_Patr_A_04_01():
    # Patr-A*04:01 occurs 3 times in 2019 IEDB snapshot
    parse("Patr-A*04:01")

def test_Patr_A_05_01():
    # Patr-A*05:01 occurs 4 times in 2019 IEDB snapshot
    parse("Patr-A*05:01")

def test_Patr_A_06_01():
    # Patr-A*06:01 occurs 4 times in 2019 IEDB snapshot
    parse("Patr-A*06:01")

def test_Patr_A_06_02():
    # Patr-A*06:02 occurs 41 times in 2019 IEDB snapshot
    parse("Patr-A*06:02")

def test_Patr_A_07_01():
    # Patr-A*07:01 occurs 99 times in 2019 IEDB snapshot
    parse("Patr-A*07:01")

def test_Patr_A_09_01():
    # Patr-A*09:01 occurs 138 times in 2019 IEDB snapshot
    parse("Patr-A*09:01")

def test_Patr_AL():
    # Patr-AL occurs 69 times in 2019 IEDB snapshot
    parse("Patr-AL")

def test_Patr_B_01_01():
    # Patr-B*01:01 occurs 141 times in 2019 IEDB snapshot
    parse("Patr-B*01:01")

def test_Patr_B_09_01():
    # Patr-B*09:01 occurs 48 times in 2019 IEDB snapshot
    parse("Patr-B*09:01")

def test_Patr_B_13_01():
    # Patr-B*13:01 occurs 128 times in 2019 IEDB snapshot
    parse("Patr-B*13:01")

def test_Patr_B_17_01():
    # Patr-B*17:01 occurs 8 times in 2019 IEDB snapshot
    parse("Patr-B*17:01")

def test_Patr_B_24_01():
    # Patr-B*24:01 occurs 76 times in 2019 IEDB snapshot
    parse("Patr-B*24:01")

def test_Patr_DR1():
    # Patr-DR1 occurs 2 times in 2019 IEDB snapshot
    parse("Patr-DR1")

def test_Patr_DR10():
    # Patr-DR10 occurs 2 times in 2019 IEDB snapshot
    parse("Patr-DR10")

def test_Patr_DR2():
    # Patr-DR2 occurs 2 times in 2019 IEDB snapshot
    parse("Patr-DR2")

def test_Patr_DR3():
    # Patr-DR3 occurs 2 times in 2019 IEDB snapshot
    parse("Patr-DR3")

def test_Patr_DR4():
    # Patr-DR4 occurs 2 times in 2019 IEDB snapshot
    parse("Patr-DR4")

def test_Patr_DR5():
    # Patr-DR5 occurs 2 times in 2019 IEDB snapshot
    parse("Patr-DR5")

def test_Patr_DR7():
    # Patr-DR7 occurs 2 times in 2019 IEDB snapshot
    parse("Patr-DR7")

def test_Patr_DR8():
    # Patr-DR8 occurs 2 times in 2019 IEDB snapshot
    parse("Patr-DR8")

def test_Patr_DR9():
    # Patr-DR9 occurs 2 times in 2019 IEDB snapshot
    parse("Patr-DR9")

def test_Patr_DRB1_03_08():
    # Patr-DRB1*03:08 occurs 2 times in 2019 IEDB snapshot
    parse("Patr-DRB1*03:08")

def test_RT1_A():
    # RT1-A occurs 3 times in 2019 IEDB snapshot
    parse("RT1-A")

def test_RT1_A1():
    # RT1-A1 occurs 6 times in 2019 IEDB snapshot
    parse("RT1-A1")

def test_RT1_A2():
    # RT1-A2 occurs 8 times in 2019 IEDB snapshot
    parse("RT1-A2")

def test_RT1_Aa():
    # RT1-Aa occurs 13 times in 2019 IEDB snapshot
    parse("RT1-Aa")

def test_RT1_Ac():
    # RT1-Ac occurs 1 times in 2019 IEDB snapshot
    parse("RT1-Ac")

def test_RT1_B():
    # RT1-B occurs 32 times in 2019 IEDB snapshot
    parse("RT1-B")

def test_RT1_Ba():
    # RT1-Ba occurs 59 times in 2019 IEDB snapshot
    parse("RT1-Ba")

def test_RT1_Bl():
    # RT1-Bl occurs 135 times in 2019 IEDB snapshot
    parse("RT1-Bl")

def test_RT1_Bn():
    # RT1-Bn occurs 59 times in 2019 IEDB snapshot
    parse("RT1-Bn")

def test_RT1_Bu():
    # RT1-Bu occurs 48 times in 2019 IEDB snapshot
    parse("RT1-Bu")

def test_RT1_Da():
    # RT1-Da occurs 59 times in 2019 IEDB snapshot
    parse("RT1-Da")

def test_RT1_Dl():
    # RT1-Dl occurs 61 times in 2019 IEDB snapshot
    parse("RT1-Dl")

def test_RT1_Dn():
    # RT1-Dn occurs 59 times in 2019 IEDB snapshot
    parse("RT1-Dn")

def test_RT1_Du():
    # RT1-Du occurs 48 times in 2019 IEDB snapshot
    parse("RT1-Du")

def test_RT11_class_II():
    # RT11 class II occurs 2 times in 2019 IEDB snapshot
    parse("RT11 class II")

def test_SLA_class_I():
    # SLA class I occurs 8 times in 2019 IEDB snapshot
    parse("SLA class I")

def test_SLA_1_0401():
    # SLA-1*0401 occurs 70 times in 2019 IEDB snapshot
    parse("SLA-1*0401")

def test_SLA_1_07_02():
    # SLA-1*07:02 occurs 15 times in 2019 IEDB snapshot
    parse("SLA-1*07:02")

def test_SLA_1_1502():
    # SLA-1*1502 occurs 2 times in 2019 IEDB snapshot
    parse("SLA-1*1502")

def test_SLA_2_0401():
    # SLA-2*0401 occurs 11 times in 2019 IEDB snapshot
    parse("SLA-2*0401")

def test_SLA_3_0202():
    # SLA-3*0202 occurs 23 times in 2019 IEDB snapshot
    parse("SLA-3*0202")

def test_YF1w_7_1():
    # YF1w*7.1 occurs 2 times in 2019 IEDB snapshot
    parse("YF1w*7.1")

def test_cattle_CD1b3():
    # cattle CD1b3 occurs 2 times in 2019 IEDB snapshot
    parse("cattle CD1b3")

def test_cattle_CD1d():
    # cattle CD1d occurs 1 times in 2019 IEDB snapshot
    parse("cattle CD1d")

def test_chicken_CD1_1():
    # chicken CD1-1 occurs 3 times in 2019 IEDB snapshot
    parse("chicken CD1-1")

def test_human_BTN3A1():
    # human BTN3A1 occurs 4 times in 2019 IEDB snapshot
    parse("human BTN3A1")

def test_human_CD1a():
    # human CD1a occurs 8 times in 2019 IEDB snapshot
    parse("human CD1a")

def test_human_CD1b():
    # human CD1b occurs 2 times in 2019 IEDB snapshot
    parse("human CD1b")

def test_human_CD1c():
    # human CD1c occurs 4 times in 2019 IEDB snapshot
    parse("human CD1c")

def test_human_CD1d():
    # human CD1d occurs 8 times in 2019 IEDB snapshot
    parse("human CD1d")

def test_human_MR1():
    # human MR1 occurs 48 times in 2019 IEDB snapshot
    parse("human MR1")

def test_mouse_CD1d():
    # mouse CD1d occurs 40 times in 2019 IEDB snapshot
    parse("mouse CD1d")
