![CrowdStrike](https://raw.githubusercontent.com/CrowdStrike/falcon-integration-gateway/main/docs/assets/cs-logo.png)

# falcon-integration-gateway [![Python Lint](https://github.com/CrowdStrike/falcon-integration-gateway/actions/workflows/linting.yml/badge.svg)](https://github.com/CrowdStrike/falcon-integration-gateway/actions/workflows/linting.yml) [![Container Build on Quay](https://quay.io/repository/crowdstrike/falcon-integration-gateway/status "Docker Repository on Quay")](https://quay.io/repository/crowdstrike/falcon-integration-gateway)

Falcon Integration Gateway (FIG) forwards threat detection findings and audit events from the CrowdStrike Falcon platform to the [backend](fig/backends) of your choice.

Detection findings and audit events generated by CrowdStrike Falcon platform inform you about suspicious files and behaviors in your environment. You will see detections on a range of activities from the presence of a bad file (indicator of compromise (IOC)) to a nuanced collection of suspicious behaviors (indicator of attack (IOA)) occurring on one of your hosts or containers. You can learn more about the individual detections in [Falcon documentation](https://falcon.crowdstrike.com/support/documentation/40/mitre-based-falcon-detections-framework).

This project facilitates the export of the individual detections and audit events from CrowdStrike Falcon to third-party security dashboards (so called backends). The export is useful in cases where security operation team workflows are tied to given third-party solution to get early real-time heads-up about malicious activities or unusual user activities detected by CrowdStrike Falcon platform.

## Backends w/ Available Deployment Guide(s)

| Backend | Description | Deployment Guide(s) | Developer Guide(s) |
|:--------|:------------|:--------------------|:-------------------|
| AWS | Pushes events to AWS Security Hub | *Coming Soon* | [AWS backend](fig/backends/aws) |
| AWS_SQS | Pushes events to AWS SQS | *Coming Soon* | [AWS SQS backend](fig/backends/aws_sqs) |
| Azure | Pushes events to Azure Log Analytics | <ul><li>[Deployment to AKS](docs/aks)</li></ul> | [Azure backend](fig/backends/azure) |
| Chronicle | Pushes events to Google Chronicle | <ul><li>[Deployment to GKE](docs/listings/gke-chronicle/UserGuide.md) (using [marketplace](https://console.cloud.google.com/marketplace/product/crowdstrike-saas/falcon-integration-gateway-chronicle))</li><li>[Deployment to GKE](docs/chronicle) (manual)</li></ul> | [Chronicle backend](fig/backends/chronicle) |
| GCP | Pushes events to GCP Security Command Center | <ul><li>[Deployment to GKE](docs/listings/gke/UserGuide.md) (using [marketplace](https://console.cloud.google.com/marketplace/product/crowdstrike-saas/falcon-integration-gateway-scc))</li><li>[Deployment to GKE](docs/gke) (manual)</li></ul> | [GCP backend](fig/backends/gcp) |
| Workspace ONE | Pushes events to VMware Workspace ONE Intelligence | *Coming Soon* | [Workspace ONE backend](fig/backends/workspaceone) |

## Alternative Deployment Options
> :exclamation: Prior to any deployment, ensure you refer to the [configuration options](./config/config.ini) available to the application :exclamation:
### Installation to Kubernetes using the helm chart

Please refer to the [FIG helm chart documentation](https://github.com/CrowdStrike/falcon-helm/tree/main/helm-charts/falcon-integration-gateway) for detailed instructions on deploying the FIG via helm chart for your respective backend(s).

### Manual Installation and Removal
#### With Docker/Podman
To install as a container:
1. Pull the image
    ```bash
    docker pull quay.io/crowdstrike/falcon-integration-gateway:latest
    ```
2. Run the application in the background passing in your backend [CONFIG](./config/config.ini) options
    ```bash
    docker run -d --rm \
      -e FALCON_CLIENT_ID="$FALCON_CLIENT_ID" \
      -e FALCON_CLIENT_SECRET="$FALCON_CLIENT_SECRET" \
      -e FALCON_CLOUD_REGION="us-1" \
      -e FIG_BACKENDS=<BACKEND> \
      -e CONFIG_OPTION=CONFIG_OPTION_VALUE \
      quay.io/crowdstrike/falcon-integration-gateway:latest
    ```
3. Confirm deployment
    ```bash
    docker logs <container>
    ```

#### From Git Repository
1. Clone the repository
    ```bash
    git clone https://github.com/CrowdStrike/falcon-integration-gateway.git
    ```
2. Modify the `./config/config.ini` file with your backend options

3. Run the application
    ```bash
    python3 -m fig
    ```

## [Developers Guide](./docs/developer_guide.md)

## Statement of Support
Falcon Integration Gateway (FIG) is an open source project, not CrowdStrike product. As such it carries no formal support, expressed or implied.
