import lambda = require('@aws-cdk/aws-lambda');
import cdk = require('@aws-cdk/core');
import { WorkGroup } from './workGroup';
/**
 * Definition of the Athena NamedQuery
 */
export interface NamedQueryProps extends cdk.StackProps {
    /**
     * The query name
     */
    readonly name: string;
    /**
     * The query description
     */
    readonly desc?: string;
    /**
     * The database to which the query belongs
     */
    readonly database: string;
    /**
     * The workgroup in which the named query is being created
     */
    readonly workGroup?: WorkGroup | string;
    /**
     * The contents of the query with all query statements
     */
    readonly queryString: string;
}
/**
 * An Athena NamedQuery
 */
export declare class NamedQuery extends cdk.Construct {
    /**
     * The lambda function that is created
     */
    readonly lambda: lambda.IFunction;
    /**
     * Name of the query
     */
    readonly name: string;
    /**
     * The unique ID of the query
     */
    readonly id: string;
    /**
     * Defines a new Athena NamedQuery
     */
    constructor(scope: cdk.Construct, id: string, props: NamedQueryProps);
}
