"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NamedQuery = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const lambda_1 = require("./lambda");
const resourceType = 'Custom::Athena-NamedQuery';
/**
 * An Athena NamedQuery
 */
class NamedQuery extends cdk.Construct {
    /**
     * Defines a new Athena NamedQuery
     */
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Name of the query
         */
        this.name = '';
        /**
         * The unique ID of the query
         */
        this.id = '';
        this.lambda = lambda_1.ensureLambda(this);
        this.name = props.name;
        const queryProps = {
            serviceToken: this.lambda.functionArn,
            resourceType: resourceType,
            properties: {
                Name: this.name,
                Description: props.desc || '',
                Database: props.database,
                QueryString: props.queryString,
                WorkGroup: '',
            },
        };
        if (typeof props.workGroup === 'string') {
            queryProps.properties.WorkGroup = props.workGroup;
        }
        else if (typeof props.workGroup !== 'undefined') {
            queryProps.properties.WorkGroup = props.workGroup.name;
        }
        const namedQuery = new cdk.CustomResource(this, `Athena-NamedQuery-${props.name
            .replace(/\s+/g, '-')
            .replace(/[a-z0-9_-]+/gi, '')}`, queryProps);
        if (['undefined', 'string'].indexOf(typeof props.workGroup) < 0) {
            namedQuery.node.addDependency(props.workGroup);
        }
        this.id = namedQuery.getAttString('id');
    }
}
exports.NamedQuery = NamedQuery;
_a = JSII_RTTI_SYMBOL_1;
NamedQuery[_a] = { fqn: "cdk-athena.NamedQuery", version: "2.1.1" };
//# sourceMappingURL=data:application/json;base64,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