"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkGroup = exports.EncryptionOption = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const lambda_1 = require("./lambda");
const resourceType = 'Custom::Athena-WorkGroup';
const ID = `CFN::Resource::${resourceType}`;
const createdByTag = 'CreatedByCfnCustomResource';
var EncryptionOption;
(function (EncryptionOption) {
    EncryptionOption["SSE_S3"] = "SSE_S3";
    EncryptionOption["SSE_KMS"] = "SSE_KMS";
    EncryptionOption["CSE_KMS"] = "CSE_KMS";
})(EncryptionOption = exports.EncryptionOption || (exports.EncryptionOption = {}));
/**
 * An Athena WorkGroup
 */
class WorkGroup extends cdk.Construct {
    /**
     * Defines a new Athena WorkGroup
     */
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Name of the WorkGroup
         */
        this.name = '';
        /**
         * ARN of the WorkGroup
         */
        this.arn = '';
        if (typeof props.bytesScannedCutoffPerQuery !== 'undefined' &&
            props.bytesScannedCutoffPerQuery < 10000000) {
            cdk.Annotations.of(scope.node).addError(`Parameter bytesScannedCutoffPerQuery must have value greater than or equal to 10000000. Got ${props.bytesScannedCutoffPerQuery}`);
        }
        if (!props.name.match(/^[a-zA-Z0-9._-]{1,128}$/)) {
            cdk.Annotations.of(scope.node).addError(`The WorkGroup name must match /^[a-zA-Z0-9._-]{1,128}$/. Got "${props.name}"`);
        }
        this.tags = new cdk.TagManager(cdk.TagType.MAP, resourceType);
        this.tags.setTag(createdByTag, ID);
        const stack = cdk.Stack.of(this);
        this.lambda = lambda_1.ensureLambda(this);
        this.name = props.name;
        const workGroup = new cdk.CustomResource(this, `Athena-WorkGroup-${this.name}`, {
            serviceToken: this.lambda.functionArn,
            resourceType: resourceType,
            properties: {
                Name: this.name,
                Description: props.desc || '',
                BytesScannedCutoffPerQuery: props.bytesScannedCutoffPerQuery,
                EnforceWorkGroupConfiguration: props.enforceWorkGroupConfiguration || false,
                PublishCloudWatchMetricsEnabled: props.publishCloudWatchMetricsEnabled || false,
                RequesterPaysEnabled: props.requesterPaysEnabled || false,
                //EngineVersion: props.engineVersion,
                ResultConfiguration: props.resultConfiguration,
                StackName: stack.stackName,
                Arn: `arn:aws:athena:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:workgroup/${this.name}`,
                Tags: cdk.Lazy.any({
                    produce: () => this.tags.renderTags(),
                }),
            },
        });
        this.arn = workGroup.getAttString('ARN');
    }
}
exports.WorkGroup = WorkGroup;
_a = JSII_RTTI_SYMBOL_1;
WorkGroup[_a] = { fqn: "cdk-athena.WorkGroup", version: "2.1.1" };
//# sourceMappingURL=data:application/json;base64,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