"""Broadworks OCI-P Interface Request Classes"""
# Autogenerated from the Broadworks XML Schemas.
# Do not edit as changes will be overwritten.
# Generated on 2020-10-13T18:33:21.784178
# fmt: off
from classforge import Field

import broadworks_ocip.types as OCI
from .base import ElementInfo as E
from .base import OCIRequest


class AuthenticationRequest(OCIRequest):
    """
    ``AuthenticationRequest()`` is 1st stage of the 2 stage OCI login process.

    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class AuthenticationVerifyRequest(OCIRequest):
    """
    ``AuthenticationVerifyRequest()`` is used to authenticate a user using the user Id and
    password.

    The response is a ``AuthenticationVerifyResponse()`` or an ``ErrorResponse()``

    Replaced By: ``AuthenticationVerifyRequest14sp8()``
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("password", "password", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* password
    password = Field(type=str, required=True, mutable=False)


class AuthenticationVerifyRequest14sp8(OCIRequest):
    """
    ``AuthenticationVerifyRequest14sp8()`` is used to authenticate a user either by
    userId/password, userId/sip username/sip password, dn/passcode or a token previously
    authorized with the ``ExternalAuthenticationAuthorizeTokenRequest()``.

    The phone number may be any DN associated with a user.

    The response is a ``AuthenticationVerifyResponse14sp8()`` or an ``ErrorResponse()``
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("password", "password", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
        E("passcode", "passcode", str, is_required=True),
        E("login_token", "loginToken", str, is_required=True),
        E("sip_authentication_user_name", "sipAuthenticationUserName", str, is_required=True),
        E("sip_authentication_password", "sipAuthenticationPassword", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* password
    password = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)
    #: str: *Required* passcode
    passcode = Field(type=str, required=True, mutable=False)
    #: str: *Required* loginToken
    login_token = Field(type=str, required=True, mutable=False)
    #: str: *Required* sipAuthenticationUserName
    sip_authentication_user_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* sipAuthenticationPassword
    sip_authentication_password = Field(type=str, required=True, mutable=False)


class AvailabilityTestRequest(OCIRequest):
    """
    ``AvailabilityTestRequest()`` is for high-availability support.

    Response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class DeviceManagementFileAuthLocationGetRequest(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either a ``DeviceManagementFileAuthLocationGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str, is_required=True),
        E("device_access_method", "deviceAccessMethod", str, is_required=True),
        E("device_access_uri", "deviceAccessURI", str, is_required=True),
        E("access_device_user_name", "accessDeviceUserName", str),
        E("access_device_user_password", "accessDeviceUserPassword", str),
        E("signed_password", "signedPassword", str),
        E("mac_address", "macAddress", str),
        E("realm_name", "realmName", str),
        E("digest_ha1_complement", "digestHa1Complement", str),
        E("digest_response", "digestResponse", str),
    )

    #: str: *Required* deviceAccessProtocol
    device_access_protocol = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceAccessMethod
    device_access_method = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceAccessURI
    device_access_uri = Field(type=str, required=True, mutable=False)
    #: str: *Optional* accessDeviceUserName
    access_device_user_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* accessDeviceUserPassword
    access_device_user_password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* signedPassword
    signed_password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* macAddress
    mac_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* realmName
    realm_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* digestHa1Complement
    digest_ha1_complement = Field(type=str, required=False, mutable=False)
    #: str: *Optional* digestResponse
    digest_response = Field(type=str, required=False, mutable=False)


class DeviceManagementFileAuthLocationGetRequest17(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either a ``DeviceManagementFileAuthLocationGetResponse17()`` or an
    ``ErrorResponse()``. Replaced by: ``DeviceManagementFileAuthLocationGetRequest18()``
    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str, is_required=True),
        E("device_access_method", "deviceAccessMethod", str, is_required=True),
        E("device_access_uri", "deviceAccessURI", str, is_required=True),
        E("access_device_user_name", "accessDeviceUserName", str),
        E("access_device_user_password", "accessDeviceUserPassword", str),
        E("signed_password", "signedPassword", str),
        E("mac_address", "macAddress", str),
        E("realm_name", "realmName", str),
        E("digest_ha1_complement", "digestHa1Complement", str),
        E("digest_response", "digestResponse", str),
    )

    #: str: *Required* deviceAccessProtocol
    device_access_protocol = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceAccessMethod
    device_access_method = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceAccessURI
    device_access_uri = Field(type=str, required=True, mutable=False)
    #: str: *Optional* accessDeviceUserName
    access_device_user_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* accessDeviceUserPassword
    access_device_user_password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* signedPassword
    signed_password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* macAddress
    mac_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* realmName
    realm_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* digestHa1Complement
    digest_ha1_complement = Field(type=str, required=False, mutable=False)
    #: str: *Optional* digestResponse
    digest_response = Field(type=str, required=False, mutable=False)


class DeviceManagementFileAuthLocationGetRequest18(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either a ``DeviceManagementFileAuthLocationGetResponse18()`` or an
    ``ErrorResponse()``. Replaced by: ``DeviceManagementFileAuthLocationGetRequest21()``.
    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str, is_required=True),
        E("device_access_method", "deviceAccessMethod", str, is_required=True),
        E("device_access_uri", "deviceAccessURI", str, is_required=True),
        E("access_device_user_name", "accessDeviceUserName", str),
        E("access_device_user_password", "accessDeviceUserPassword", str),
        E("signed_password", "signedPassword", str),
        E("mac_address", "macAddress", str),
        E("realm_name", "realmName", str),
        E("digest_ha1_complement", "digestHa1Complement", str),
        E("digest_response", "digestResponse", str),
    )

    #: str: *Required* deviceAccessProtocol
    device_access_protocol = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceAccessMethod
    device_access_method = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceAccessURI
    device_access_uri = Field(type=str, required=True, mutable=False)
    #: str: *Optional* accessDeviceUserName
    access_device_user_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* accessDeviceUserPassword
    access_device_user_password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* signedPassword
    signed_password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* macAddress
    mac_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* realmName
    realm_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* digestHa1Complement
    digest_ha1_complement = Field(type=str, required=False, mutable=False)
    #: str: *Optional* digestResponse
    digest_response = Field(type=str, required=False, mutable=False)


class DeviceManagementFileAuthLocationGetRequest21(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either ``DeviceManagementFileAuthLocationGetResponse21()`` or
    ``ErrorResponse()``. The following elements are only used in AS data mode and will
    fail in HSS data mode: deviceToken
    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str, is_required=True),
        E("device_access_method", "deviceAccessMethod", str, is_required=True),
        E("device_access_uri", "deviceAccessURI", str, is_required=True),
        E("access_device_user_name", "accessDeviceUserName", str),
        E("access_device_user_password", "accessDeviceUserPassword", str),
        E("device_token", "deviceToken", str),
        E("signed_password", "signedPassword", str),
        E("mac_address", "macAddress", str),
        E("realm_name", "realmName", str),
        E("digest_ha1_complement", "digestHa1Complement", str),
        E("digest_response", "digestResponse", str),
    )

    #: str: *Required* deviceAccessProtocol
    device_access_protocol = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceAccessMethod
    device_access_method = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceAccessURI
    device_access_uri = Field(type=str, required=True, mutable=False)
    #: str: *Optional* accessDeviceUserName
    access_device_user_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* accessDeviceUserPassword
    access_device_user_password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* deviceToken
    device_token = Field(type=str, required=False, mutable=False)
    #: str: *Optional* signedPassword
    signed_password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* macAddress
    mac_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* realmName
    realm_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* digestHa1Complement
    digest_ha1_complement = Field(type=str, required=False, mutable=False)
    #: str: *Optional* digestResponse
    digest_response = Field(type=str, required=False, mutable=False)


class DeviceManagementPutFileRequest(OCIRequest):
    """
    Informs BroadWorks that a file was uploaded to the repository.

    The response is always a ``SuccessResponse()``.
    """

    _ELEMENTS = (
        E("device_access_uri", "deviceAccessURI", str, is_required=True),
        E("ip_address", "ipAddress", str, is_required=True),
    )

    #: str: *Required* deviceAccessURI
    device_access_uri = Field(type=str, required=True, mutable=False)
    #: str: *Required* ipAddress
    ip_address = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerActivationRequest(OCIRequest):
    """
    Activates or Deactivates the BroadWorks Mobile Manager.

    The deactivationReason is required when isActive is set to false.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("deactivation_reason", "deactivationReason", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* deactivationReason
    deactivation_reason = Field(type=str, required=False, mutable=False)


class EnterpriseBroadWorksMobileManagerAddHomeZoneRequest(OCIRequest):
    """
    Add a home zone to the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("home_zone_domain_name", "homeZoneDomainName", str, is_required=True),
        E("mobile_country_code", "mobileCountryCode", str, is_required=True),
        E("mobile_network_code", "mobileNetworkCode", str, is_required=True),
        E("location_area_code", "locationAreaCode", str, is_required=True),
        E("cell_identity", "cellIdentity", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* homeZoneDomainName
    home_zone_domain_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* mobileCountryCode
    mobile_country_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* mobileNetworkCode
    mobile_network_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* locationAreaCode
    location_area_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* cellIdentity
    cell_identity = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerAddRequest(OCIRequest):
    """
    Add the BroadWorks Mobile Manager.

    Only one BroadWorks Mobile Manager can be added per enterprise.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("information_file", "informationFile", str, is_required=True),
        E("certificate_file", "certificateFile", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("local_to_carrier", "localToCarrier", bool, is_required=True),
        E("max_tx_per_second_enabled", "maxTxPerSecondEnabled", bool, is_required=True),
        E("max_tx_per_second", "maxTxPerSecond", int),
        E("tldn_enabled", "tldnEnabled", bool, is_required=True),
        E("generic_number_enabled", "genericNumberEnabled", bool, is_required=True),
        E("mobile_state_check_enabled", "mobileStateCheckEnabled", bool, is_required=True),
        E(
            "location_based_services_enabled", "locationBasedServicesEnabled", bool,
            is_required=True,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* informationFile
    information_file = Field(type=str, required=True, mutable=False)
    #: str: *Required* certificateFile
    certificate_file = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* localToCarrier
    local_to_carrier = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* maxTxPerSecondEnabled
    max_tx_per_second_enabled = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* maxTxPerSecond
    max_tx_per_second = Field(type=int, required=False, mutable=False)
    #: bool: *Required* tldnEnabled
    tldn_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* genericNumberEnabled
    generic_number_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* mobileStateCheckEnabled
    mobile_state_check_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* locationBasedServicesEnabled
    location_based_services_enabled = Field(type=bool, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerDeleteHomeZoneListRequest(OCIRequest):
    """
    Delete a list of home zones from the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("home_zone_id", "homeZoneId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* homeZoneId
    home_zone_id = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerDeleteHomeZoneRequest(OCIRequest):
    """
    Delete a home zone from the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("home_zone_id", "homeZoneId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* homeZoneId
    home_zone_id = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerDeleteRequest(OCIRequest):
    """
    Delete the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerGetDomainListRequest(OCIRequest):
    """
    Get the list of domains of the BroadWorks Mobile Manager.

    The response is either ``EnterpriseBroadWorksMobileManagerGetDomainListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerGetHomeZoneListRequest(OCIRequest):
    """
    Get the list of home zones of the BroadWorks Mobile Manager.

    The response is either ``EnterpriseBroadWorksMobileManagerGetHomeZoneListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerGetHomeZoneRequest(OCIRequest):
    """
    Get a home zone from the BroadWorks Mobile Manager.

    The response is either ``EnterpriseBroadWorksMobileManagerGetHomeZoneResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("home_zone_id", "homeZoneId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* homeZoneId
    home_zone_id = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerGetRequest(OCIRequest):
    """
    Get the BroadWorks Mobile Manager.

    The response is either ``EnterpriseBroadWorksMobileManagerGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerModifyHomeZoneRequest(OCIRequest):
    """
    Modify an existing home zone in the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("home_zone_id", "homeZoneId", str, is_required=True),
        E("home_zone_domain_name", "homeZoneDomainName", str),
        E("mobile_country_code", "mobileCountryCode", str),
        E("mobile_network_code", "mobileNetworkCode", str),
        E("location_area_code", "locationAreaCode", str),
        E("cell_identity", "cellIdentity", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* homeZoneId
    home_zone_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* homeZoneDomainName
    home_zone_domain_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* mobileCountryCode
    mobile_country_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* mobileNetworkCode
    mobile_network_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* locationAreaCode
    location_area_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* cellIdentity
    cell_identity = Field(type=str, required=False, mutable=False)


class EnterpriseBroadWorksMobileManagerModifyRequest(OCIRequest):
    """
    Modify the BroadWorks Mobile Manager settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("information_file", "informationFile", str),
        E("certificate_file", "certificateFile", str),
        E("local_to_carrier", "localToCarrier", bool),
        E("max_tx_per_second_enabled", "maxTxPerSecondEnabled", bool),
        E("max_tx_per_second", "maxTxPerSecond", int),
        E("tldn_enabled", "tldnEnabled", bool),
        E("generic_number_enabled", "genericNumberEnabled", bool),
        E("mobile_state_check_enabled", "mobileStateCheckEnabled", bool),
        E("location_based_services_enabled", "locationBasedServicesEnabled", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* informationFile
    information_file = Field(type=str, required=False, mutable=False)
    #: str: *Optional* certificateFile
    certificate_file = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* localToCarrier
    local_to_carrier = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* maxTxPerSecondEnabled
    max_tx_per_second_enabled = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxTxPerSecond
    max_tx_per_second = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* tldnEnabled
    tldn_enabled = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* genericNumberEnabled
    generic_number_enabled = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* mobileStateCheckEnabled
    mobile_state_check_enabled = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* locationBasedServicesEnabled
    location_based_services_enabled = Field(type=bool, required=False, mutable=False)


class EnterpriseBroadWorksMobileManagerSendCarrierFilesRequest(OCIRequest):
    """
    Sends an email with the carrier information and certificate files.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("email_to", "emailTo", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* emailTo
    email_to = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest(OCIRequest):
    """
    Request a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any user.

    The response is either
    ``EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileAddAgentListRequest(OCIRequest):
    """
    Add agent(s) to a Agent Threshold Profile.

    When an agent is assigned (added) to a profile, it is automatically unassigned
    (deleted) from the previous profile it was assigned to.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
        E("agent_user_id", "agentUserId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* profileName
    profile_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* agentUserId
    agent_user_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileAddRequest(OCIRequest):
    """
    Add a new Call Center Agent Threshold Profile in an Enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
        E("profile_description", "profileDescription", str),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed", int,
        ),
        E("threshold_average_busy_in_time_yellow", "thresholdAverageBusyInTimeYellow", int),
        E("threshold_average_busy_in_time_red", "thresholdAverageBusyInTimeRed", int),
        E("threshold_average_busy_out_time_yellow", "thresholdAverageBusyOutTimeYellow", int),
        E("threshold_average_busy_out_time_red", "thresholdAverageBusyOutTimeRed", int),
        E("threshold_average_wrap_up_time_yellow", "thresholdAverageWrapUpTimeYellow", int),
        E("threshold_average_wrap_up_time_red", "thresholdAverageWrapUpTimeRed", int),
        E("enable_notification_email", "enableNotificationEmail", bool, is_required=True),
        E("notification_email_address", "notificationEmailAddress", str),
        E("agent_user_id", "agentUserId", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* profileName
    profile_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* profileDescription
    profile_description = Field(type=str, required=False, mutable=False)
    #: int: *Optional* thresholdCurrentCallStateIdleTimeYellow
    threshold_current_call_state_idle_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeRed
    threshold_current_call_state_idle_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeYellow
    threshold_current_call_state_on_call_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeRed
    threshold_current_call_state_on_call_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeYellow
    threshold_current_agent_state_unavailable_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeRed
    threshold_current_agent_state_unavailable_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeYellow
    threshold_average_busy_in_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyInTimeRed
    threshold_average_busy_in_time_red = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyOutTimeYellow
    threshold_average_busy_out_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyOutTimeRed
    threshold_average_busy_out_time_red = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageWrapUpTimeYellow
    threshold_average_wrap_up_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageWrapUpTimeRed
    threshold_average_wrap_up_time_red = Field(type=int, required=False, mutable=False)
    #: bool: *Required* enableNotificationEmail
    enable_notification_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* notificationEmailAddress
    notification_email_address = Field(type=str, required=False, mutable=False)
    #: list(str): *Optional* agentUserId  *Array*
    agent_user_id = Field(type=list, required=False, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileDeleteAgentListRequest(OCIRequest):
    """
    Delete agent(s) from a Agent Threshold Profile.

    Agents cannot be unassigned (deleted) directly from the default profile, they need to
    be assigned (added) to a different profile.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
        E("agent_user_id", "agentUserId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* profileName
    profile_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* agentUserId
    agent_user_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileDeleteRequest(OCIRequest):
    """
    Deletes an existing Call Center Agent Threshold Profile in an Enterprise.

    The default profile cannot be deleted.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* profileName
    profile_name = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileGetListRequest(OCIRequest):
    """
    Get the list of Call Center Agent Threshold Profiles in the Enterprise.

    The response is either ``EnterpriseCallCenterAgentThresholdProfileGetListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileGetRequest(OCIRequest):
    """
    Gets an existing non-default Call Center Agent Threshold Profile in an Enterprise.

    The response is either a ``EnterpriseCallCenterAgentThresholdProfileGetResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* profileName
    profile_name = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeAddRequest(OCIRequest):
    """
    Add a Call Center Agent Unavailable Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("code", "code", str, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Agent Unavailable Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Agent Unavailable Codes.

    The response is either ``EnterpriseCallCenterAgentUnavailableCodeGetListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeGetRequest(OCIRequest):
    """
    Get a Call Center Agent Unavailable Code.

    The response is either ``EnterpriseCallCenterAgentUnavailableCodeGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Agent Unavailable Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool),
        E("description", "description", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* isActive
    is_active = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest(OCIRequest):
    """
    Request the enterprise level data associated with Call Center Agents Unavailable Code
    Settings.

    The response is either an
    ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse()`` or an
    ``ErrorResponse()``. Replaced by
    ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest17sp4()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest17sp4(OCIRequest):
    """
    Request the enterprise level data associated with Call Center Agents Unavailable Code
    Settings.

    The response is either an
    ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse17sp4()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterCallDispositionCodeAddRequest(OCIRequest):
    """
    Add a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterCallDispositionCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterCallDispositionCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Call Disposition Codes.

    The response is either ``EnterpriseCallCenterCallDispositionCodeGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterCallDispositionCodeGetRequest(OCIRequest):
    """
    Get a Call Center Call Disposition Code.

    The response is either ``EnterpriseCallCenterCallDispositionCodeGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterCallDispositionCodeGetUsageListRequest(OCIRequest):
    """
    Get the list of Call Centers and Route Points using the specified disposition code.

    The response is either
    ``EnterpriseCallCenterCallDispositionCodeGetUsageListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterCallDispositionCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool),
        E("description", "description", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* isActive
    is_active = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterCurrentAndPastDNISGetListRequest(OCIRequest):
    """
    Request to get all the past and current DNIS for the Call Center for the enterprise.

    The response is either ``EnterpriseCallCenterCurrentAndPastDNISGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingBrandingGetRequest(OCIRequest):
    """
    Request to get the enterprise branding information.

    The response is either ``EnterpriseCallCenterEnhancedReportingBrandingGetResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListRequest(OCIRequest):
    """
    Request to get all enabled call center report template for an enterprise.

    The response is either an
    ``EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingGetRequest(OCIRequest):
    """
    Request to get an enterprise level call center enhanced reporting setting.

    The response is either an ``EnterpriseCallCenterEnhancedReportingGetResponse()`` or an
    ``ErrorResponse()``. Replaced by
    ``EnterpriseCallCenterEnhancedReportingGetRequest19()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingGetRequest19(OCIRequest):
    """
    Request to get an enterprise level call center enhanced reporting setting.

    The response is either an ``EnterpriseCallCenterEnhancedReportingGetResponse19()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingModifyRequest(OCIRequest):
    """
    Request to modify enterprise level call center enhanced reporting settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Replaced by
    ``EnterpriseCallCenterEnhancedReportingModifyRequest19()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("reporting_server", "reportingServer", str),
        E("web_statistic_source", "webStatisticSource", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* reportingServer
    reporting_server = Field(type=str, required=False, mutable=False)
    #: str: *Optional* webStatisticSource
    web_statistic_source = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterEnhancedReportingModifyRequest19(OCIRequest):
    """
    Request to modify enterprise level call center enhanced reporting settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("reporting_server", "reportingServer", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* reportingServer
    reporting_server = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterEnhancedReportingReportTemplateDeleteRequest(OCIRequest):
    """
    Request to delete an enterprise level call center report template.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingReportTemplateGetListRequest(OCIRequest):
    """
    Request to get enterprise level call center report template list.

    The response is either an
    ``EnterpriseCallCenterEnhancedReportingReportTemplateGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingReportTemplateGetRequest(OCIRequest):
    """
    Request to get an enterprise level call center report template.

    The response is either an
    ``EnterpriseCallCenterEnhancedReportingReportTemplateGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingScheduledReportDeleteRequest(OCIRequest):
    """
    Request to delete an enterprise level call center reporting scheduled report.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest(OCIRequest):
    """
    Request to get all the call center reporting scheduled report in an enterprise that
    uses a given enterprise level report template.

    The response is either a
    ``EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingScheduledReportGetRequest(OCIRequest):
    """
    Request to get an enterprise level call center reporting scheduled report.

    The response is either an
    ``EnterpriseCallCenterEnhancedReportingScheduledReportGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterGetRequest(OCIRequest):
    """
    Request the enterprise level data associated with Call Center.

    The response is either an ``EnterpriseCallCenterGetResponse()`` or an
    ``ErrorResponse()``. Replaced by ``EnterpriseCallCenterGetRequest17sp4()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterGetRequest17sp4(OCIRequest):
    """
    Request the enterprise level data associated with Call Center.

    The response is either an ``EnterpriseCallCenterGetResponse17sp4()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterGetRoutingPolicyRequest(OCIRequest):
    """
    Request the enterprise call center routing policy.

    The response is either an ``EnterpriseCallCenterGetRoutingPolicyResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterModifyRequest(OCIRequest):
    """
    Modify the enterprise level data associated with Call Center The response is either a
    ``SuccessResponse()`` or an ``ErrorResponse()``.

    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("use_system_default_guard_timer", "useSystemDefaultGuardTimer", bool),
        E("enable_guard_timer", "enableGuardTimer", bool),
        E("guard_timer_seconds", "guardTimerSeconds", int),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings", bool,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable", bool,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useSystemDefaultGuardTimer
    use_system_default_guard_timer = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableGuardTimer
    enable_guard_timer = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* guardTimerSeconds
    guard_timer_seconds = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useSystemDefaultUnavailableSettings
    use_system_default_unavailable_settings = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnNotReachable
    force_agent_unavailable_on_not_reachable = Field(type=bool, required=False, mutable=False)


class EnterpriseCommonPhoneListDeleteListRequest(OCIRequest):
    """
    Delete one or more entries from an enterprise's common phone list.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("entry_name", "entryName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* entryName
    entry_name = Field(type=str, required=True, mutable=False)


class EnterpriseCommonPhoneListModifyRequest(OCIRequest):
    """
    Modify an entry in an enterprise's common phone list.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("entry_name", "entryName", str, is_required=True),
        E("new_entry_name", "newEntryName", str),
        E("phone_number", "phoneNumber", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* entryName
    entry_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* newEntryName
    new_entry_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)


class EnterpriseDepartmentDeleteRequest(OCIRequest):
    """
    Delete a department from an enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("enterprise_id", "enterpriseId", str, is_required=True),
        E("department_name", "departmentName", str, is_required=True),
    )

    #: str: *Required* enterpriseId
    enterprise_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)


class EnterpriseDepartmentGetAvailableParentListRequest(OCIRequest):
    """
    Get a list of enterprise level departments in an enterprise that could be the parent
    of the specified department.

    The department itself and all its decendents are not eligible to be the parent
    department.

    The response is either ``EnterpriseDepartmentGetAvailableParentListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("enterprise_id", "enterpriseId", str, is_required=True),
        E("department_name", "departmentName", str, is_required=True),
    )

    #: str: *Required* enterpriseId
    enterprise_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)


class EnterpriseDepartmentGetListRequest(OCIRequest):
    """
    Request a list of departments in an enterprise.

    You may request only the list of departments defined at the enterprise-level, or you
    may request the list of all departments in the enterprise including all the
    departments defined within the groups inside the enterprise.

    The response is either ``EnterpriseDepartmentGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("enterprise_id", "enterpriseId", str, is_required=True),
        E("include_group_departments", "includeGroupDepartments", bool, is_required=True),
    )

    #: str: *Required* enterpriseId
    enterprise_id = Field(type=str, required=True, mutable=False)
    #: bool: *Required* includeGroupDepartments
    include_group_departments = Field(type=bool, required=True, mutable=False)


class EnterpriseEnterpriseTrunkAddRequest(OCIRequest):
    """
    Request to add an enterprise trunk in an enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Replaced by:
    ``EnterpriseEnterpriseTrunkAddRequest21()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int, is_required=True),
        E("route_exhaustion_action", "routeExhaustionAction", str, is_required=True),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)
    #: int: *Required* maximumRerouteAttempts
    maximum_reroute_attempts = Field(type=int, required=True, mutable=False)
    #: str: *Required* routeExhaustionAction
    route_exhaustion_action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* orderedRouting
    ordered_routing = Field(type=str, required=False, mutable=False)
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(type=str, required=False, mutable=False)


class EnterpriseEnterpriseTrunkAddRequest21(OCIRequest):
    """
    Request to add an enterprise trunk in an enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int, is_required=True),
        E("route_exhaustion_action", "routeExhaustionAction", str, is_required=True),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
        E("enable_capacity_management", "enableCapacityManagement", bool, is_required=True),
        E("max_active_calls", "maxActiveCalls", int),
        E("capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls", int),
        E("capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)
    #: int: *Required* maximumRerouteAttempts
    maximum_reroute_attempts = Field(type=int, required=True, mutable=False)
    #: str: *Required* routeExhaustionAction
    route_exhaustion_action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* orderedRouting
    ordered_routing = Field(type=str, required=False, mutable=False)
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(type=str, required=False, mutable=False)
    #: bool: *Required* enableCapacityManagement
    enable_capacity_management = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* maxActiveCalls
    max_active_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(type=int, required=False, mutable=False)


class EnterpriseEnterpriseTrunkAddUserListRequest(OCIRequest):
    """
    Request to add users to an enterprise trunk in an enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class EnterpriseEnterpriseTrunkDeleteRequest(OCIRequest):
    """
    Request to delete an enterprise trunk in an enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)


class EnterpriseEnterpriseTrunkDeleteUserListRequest(OCIRequest):
    """
    Request to delete users from an enterprise trunk in an enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class EnterpriseEnterpriseTrunkForceAssignUserListRequest(OCIRequest):
    """
    Request to add users to an enterprise trunk in an enterprise.

    If the user is already assigned to another enterprise trunk, it will be unassigned
    from the old enterprise trunk and assigned to the new enterprise trunk specified in
    this request.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class EnterpriseEnterpriseTrunkGetListRequest(OCIRequest):
    """
    Request to get the list of all enterprise trunks defined in an enterprise.

    The response is either a ``EnterpriseEnterpriseTrunkGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseEnterpriseTrunkGetRequest(OCIRequest):
    """
    Request to get an enterprise trunk The response is either an
    ``EnterpriseEnterpriseTrunkGetResponse()`` or an ``ErrorResponse()``.

    Replaced by: ``EnterpriseEnterpriseTrunkGetRequest21()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)


class EnterpriseEnterpriseTrunkGetRequest21(OCIRequest):
    """
    Request to get an enterprise trunk The response is either an
    ``EnterpriseEnterpriseTrunkGetResponse21()`` or an ``ErrorResponse()``.

    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)


class EnterpriseEnterpriseTrunkModifyRequest(OCIRequest):
    """
    Request to modify an enterprise trunk in an enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("new_enterprise_trunk_name", "newEnterpriseTrunkName", str),
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int),
        E("route_exhaustion_action", "routeExhaustionAction", str),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
        E("enable_capacity_management", "enableCapacityManagement", bool),
        E("max_active_calls", "maxActiveCalls", int),
        E("capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls", int),
        E("capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* newEnterpriseTrunkName
    new_enterprise_trunk_name = Field(type=str, required=False, mutable=False)
    #: int: *Optional* maximumRerouteAttempts
    maximum_reroute_attempts = Field(type=int, required=False, mutable=False)
    #: str: *Optional* routeExhaustionAction
    route_exhaustion_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* orderedRouting
    ordered_routing = Field(type=str, required=False, mutable=False)
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableCapacityManagement
    enable_capacity_management = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxActiveCalls
    max_active_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(type=int, required=False, mutable=False)


class EnterprisePreAlertingAnnouncementGetRequest(OCIRequest):
    """
    Get the Enterprise pre-alerting service settings.

    The response is either a ``EnterprisePreAlertingAnnouncementGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest(OCIRequest):
    """
    Request a list of number ranges that are assigned to an enterprise and still available
    for assignment to users within the enterprise.

    The response is either
    ``EnterpriseRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest(OCIRequest):
    """
    Request a summary table of all enterprise trunk number ranges in the enterprise.

    The response is either
    ``EnterpriseRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseSessionAdmissionControlGroupDeleteListRequest(OCIRequest):
    """
    Request to delete one or more session admission control groups for the enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class EnterpriseSessionAdmissionControlGroupGetListRequest(OCIRequest):
    """
    Request to get the list of session admission control group for the enterprise.

    The response is either an ``EnterpriseSessionAdmissionControlGroupGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseSessionAdmissionControlGroupGetRequest(OCIRequest):
    """
    Request to get a session admission control group for the enterprise.

    The response is either an ``EnterpriseSessionAdmissionControlGroupGetResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class EnterpriseSessionAdmissionControlGroupGetRequest19sp1(OCIRequest):
    """
    Request to get a session admission control group for the enterprise.

    The response is either an ``EnterpriseSessionAdmissionControlGroupGetResponse19sp1()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNDeletePolicyRequest(OCIRequest):
    """
    Delete a enterprise voice VPN location.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("location_dialing_code", "locationDialingCode", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* locationDialingCode
    location_dialing_code = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNGetDefaultRequest(OCIRequest):
    """
    Request the Voice VPN default settings for the enterprise.

    The response is ``EnterpriseVoiceVPNGetDefaultResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNGetPolicyRequest(OCIRequest):
    """
    Request the enterprise level data associated with Voice VPN location code.

    The response is either a ``EnterpriseVoiceVPNGetPolicyResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("location_dialing_code", "locationDialingCode", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* locationDialingCode
    location_dialing_code = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNGetRequest(OCIRequest):
    """
    Request the enterprise level data associated with Voice VPN.

    The response is either a ``EnterpriseVoiceVPNGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced By: ``EnterpriseVoiceVPNGetRequest14sp3()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNGetRequest14sp3(OCIRequest):
    """
    Request the enterprise level data associated with Voice VPN.

    The response is either a ``EnterpriseVoiceVPNGetResponse14sp3()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNModifyRequest(OCIRequest):
    """
    Modify the enterprise voice VPN level data associated with voice VPN.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("is_active", "isActive", bool),
        E("default_selection", "defaultSelection", str),
        E("e164_selection", "e164Selection", str),
        E("use_phone_context", "usePhoneContext", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* isActive
    is_active = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* defaultSelection
    default_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* e164Selection
    e164_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* usePhoneContext
    use_phone_context = Field(type=bool, required=False, mutable=False)


class ExternalAuthenticationAuthorizeTokenRequest(OCIRequest):
    """
    This command is part of the Portal API.

    Sent when a Web or CLI user logs in using external authentication.  The password must
    be hashed.  The password hashing algorithm is: 1) The message digest of the user's
    plain password is calculated using the SHA algorithm.  2) For every four bits in the
    160-bit digest, starting from the first bit, it is converted into a character in ASCII
    Hex format (0 through 9, a through f). The result is a 40-character string, for
    example, f7a9e24777ec23212c54d7a350bc5bea5477fdbb.  3) The above string then is used
    to populate the password field in the request.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("password", "password", str),
        E("login_token", "loginToken", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: str: *Required* loginToken
    login_token = Field(type=str, required=True, mutable=False)


class ExternalAuthenticationCreateLoginTokenRequest(OCIRequest):
    """
    This command allows a BroadWorks or Third-Party Client Application to create a Single
    Sign-On token for a user.

    The response is either ``ExternalAuthenticationCreateLoginTokenResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceCustomTagAddRequest(OCIRequest):
    """
    Request to add a static configuration tag for a group access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
        E("tag_value", "tagValue", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* tagName
    tag_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* tagValue
    tag_value = Field(type=str, required=False, mutable=False)


class GroupAccessDeviceCustomTagDeleteListRequest(OCIRequest):
    """
    Request to delete static configuration tags for a group access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* tagName
    tag_name = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceCustomTagGetListRequest(OCIRequest):
    """
    Request to get the list of custom configuration tags managed by the Device Management
    System, on a per-device profile basis.

    The response is either ``GroupAccessDeviceCustomTagGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceCustomTagModifyRequest(OCIRequest):
    """
    Request to modify a static configuration tag for a group access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
        E("tag_value", "tagValue", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* tagName
    tag_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* tagValue
    tag_value = Field(type=str, required=False, mutable=False)


class GroupAccessDeviceDeleteRequest(OCIRequest):
    """
    Request to delete a specified group access device.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceFileGetListRequest(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System, on a
    per-device profile basis.

    The response is either ``GroupAccessDeviceFileGetListResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupAccessDeviceFileGetListRequest14sp8()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceFileGetListRequest14sp8(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System, on a
    per-device profile basis.

    The response is either ``GroupAccessDeviceFileGetListResponse14sp8()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceFileGetRequest(OCIRequest):
    """
    Request to get a group device profile file.

    The response is either ``GroupAccessDeviceFileGetResponse()`` or ``ErrorResponse()``.

    Replaced By: ``GroupAccessDeviceFileGetRequest14sp8()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("file_type", "fileType", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileType
    file_type = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceFileGetRequest14sp8(OCIRequest):
    """
    Request to get a group device profile file.

    The response is either ``GroupAccessDeviceFileGetResponse14sp8()`` or
    ``ErrorResponse()``. Replaced by: ``GroupAccessDeviceFileGetRequest16sp1()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileFormat
    file_format = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceFileGetRequest16sp1(OCIRequest):
    """
    Request to get a group device profile file.

    The response is either ``GroupAccessDeviceFileGetResponse16sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileFormat
    file_format = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceFileGetRequest20(OCIRequest):
    """
    Request to get a group device profile file.

    The response is either ``GroupAccessDeviceFileGetResponse20()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileFormat
    file_format = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceGetAvailableDetailListRequest14(OCIRequest):
    """
    Requests the list of available access devices for assignment to a user within a group.

    The list includes devices created at the system, service provider, and group levels.

    The response is either ``GroupAccessDeviceGetAvailableDetailListResponse14()`` or
    ``ErrorResponse()``. Replaced by:
    ``GroupAccessDeviceGetAvailableDetailListRequest19()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("is_music_on_hold", "isMusicOnHold", bool, is_required=True),
        E("only_video_capable", "onlyVideoCapable", bool, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isMusicOnHold
    is_music_on_hold = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* onlyVideoCapable
    only_video_capable = Field(type=bool, required=True, mutable=False)


class GroupAccessDeviceGetAvailableDetailListRequest19(OCIRequest):
    """
    Requests the list of available access devices for assignment to a user within a group.

    The list includes devices created at the system, service provider, and group levels.

    The response is either ``GroupAccessDeviceGetAvailableDetailListResponse19()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("is_music_on_hold", "isMusicOnHold", bool, is_required=True),
        E("only_video_capable", "onlyVideoCapable", bool, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isMusicOnHold
    is_music_on_hold = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* onlyVideoCapable
    only_video_capable = Field(type=bool, required=True, mutable=False)


class GroupAccessDeviceGetEnhancedConfigurationTypeListRequest(OCIRequest):
    """
    Requests the list of configurable device types of devices that have already been added
    to the group.

    The response is either ``GroupAccessDeviceGetEnhancedConfigurationTypeListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceGetEnhancedConfigurationTypeRequest14(OCIRequest):
    """
    Requests the details of a specified configurable device type for a group.

    The response is either ``GroupAccessDeviceGetEnhancedConfigurationTypeResponse14()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceGetRequest14(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either ``GroupAccessDeviceGetResponse14()`` or ``ErrorResponse()``.

    Replaced By: ``GroupAccessDeviceGetRequest14sp3()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceGetRequest14sp3(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either ``GroupAccessDeviceGetResponse14sp3()`` or ``ErrorResponse()``.

    Replaced By: ``GroupAccessDeviceGetRequest14sp6()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceGetRequest14sp6(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either ``GroupAccessDeviceGetResponse14sp6()`` or ``ErrorResponse()``.
    Replaced by: ``GroupAccessDeviceGetRequest16()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceGetRequest16(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either ``GroupAccessDeviceGetResponse16()`` or ``ErrorResponse()``.
    Replaced by: ``GroupAccessDeviceGetRequest18sp1()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceGetRequest18sp1(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either ``GroupAccessDeviceGetResponse18sp1()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceModifyUserRequest(OCIRequest):
    """
    Request to modify attributes for line/ports assigned on the group device profile.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in HSS data mode and ignored in AS data mode: privateIdentity
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("private_identity", "privateIdentity", str),
        E("is_primary_line_port", "isPrimaryLinePort", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* privateIdentity
    private_identity = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* isPrimaryLinePort
    is_primary_line_port = Field(type=bool, required=False, mutable=False)


class GroupAccessDeviceResetRequest(OCIRequest):
    """
    Reset a specific group SIP device that supports the reset operation.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class GroupAccountAuthorizationCodesDeleteListRequest(OCIRequest):
    """
    Delete a list of account/authorization codes from a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)


class GroupAccountAuthorizationCodesGetListRequest(OCIRequest):
    """
    Request the list of account/authorization codes for a group.

    The response is either a ``GroupAccountAuthorizationCodesGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupAccountAuthorizationCodesGetRequest(OCIRequest):
    """
    Request the group's account/authorization codes setting.

    The response is either a ``GroupAccountAuthorizationCodesGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupAdminAddRequest(OCIRequest):
    """
    Add a group administrator.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("password", "password", str),
        E("language", "language", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* firstName
    first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* lastName
    last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)


class GroupAdminDeleteRequest(OCIRequest):
    """
    Delete a group administrator.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupAdminGetListRequest(OCIRequest):
    """
    Get a list of group and department administrators within the group.

    The response is either a ``GroupAdminGetListResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest14sp1(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse14sp1()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest16sp1(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse16sp1()`` or ``ErrorResponse()``.
    Replaced by: ``GroupAdminGetPolicyRequest17()``
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest16sp2(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse16sp2()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest17(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse17()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest17sp3(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse17sp3()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest18(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse18()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest19sp1(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse19sp1()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest20(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse20()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupAdminGetRequest(OCIRequest):
    """
    Get a group administrators profile.

    The response is either a ``GroupAdminGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupAdminModifyPolicyRequest(OCIRequest):
    """
    Request to modify the group administrator's policy settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in AS data mode: dialableCallerIDAccess
    verifyTranslationAndRoutingAccess communicationBarringUserProfileAccess (only
    applicable to groups in an Enterprise)
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("profile_access", "profileAccess", str),
        E("user_access", "userAccess", str),
        E("admin_access", "adminAccess", str),
        E("department_access", "departmentAccess", str),
        E("access_device_access", "accessDeviceAccess", str),
        E("enhanced_service_instance_access", "enhancedServiceInstanceAccess", str),
        E("feature_access_code_access", "featureAccessCodeAccess", str),
        E("phone_number_extension_access", "phoneNumberExtensionAccess", str),
        E("calling_line_id_number_access", "callingLineIdNumberAccess", str),
        E("service_access", "serviceAccess", str),
        E("trunk_group_access", "trunkGroupAccess", str),
        E("session_admission_control_access", "sessionAdmissionControlAccess", str),
        E("office_zone_access", "officeZoneAccess", str),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str),
        E("number_activation_access", "numberActivationAccess", str),
        E("verify_translation_and_routing_access", "verifyTranslationAndRoutingAccess", str),
        E(
            "communication_barring_user_profile_access",
            "communicationBarringUserProfileAccess", str,
        ),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* profileAccess
    profile_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userAccess
    user_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* adminAccess
    admin_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* departmentAccess
    department_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* accessDeviceAccess
    access_device_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* featureAccessCodeAccess
    feature_access_code_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdNumberAccess
    calling_line_id_number_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceAccess
    service_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* trunkGroupAccess
    trunk_group_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* sessionAdmissionControlAccess
    session_admission_control_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* officeZoneAccess
    office_zone_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* dialableCallerIDAccess
    dialable_caller_id_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* numberActivationAccess
    number_activation_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* verifyTranslationAndRoutingAccess
    verify_translation_and_routing_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* communicationBarringUserProfileAccess
    communication_barring_user_profile_access = Field(type=str, required=False, mutable=False)


class GroupAdminModifyRequest(OCIRequest):
    """
    Modify a group administrator.

    Since old password is not specified here, any password rule related to old password
    does not apply.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("password", "password", str),
        E("language", "language", str),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* firstName
    first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* lastName
    last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)


class GroupAdviceOfChargeGetRequest(OCIRequest):
    """
    Request to get the list of Advice of Charge group parameters.

    The response is either ``GroupAdviceOfChargeGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupAdviceOfChargeModifyRequest(OCIRequest):
    """
    Modify the service provider level Advice Of Charge group settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_group_level_ao_c_settings", "useGroupLevelAoCSettings", bool),
        E("delay_between_notification_seconds", "delayBetweenNotificationSeconds", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useGroupLevelAoCSettings
    use_group_level_ao_c_settings = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* delayBetweenNotificationSeconds
    delay_between_notification_seconds = Field(type=int, required=False, mutable=False)


class GroupApplicationServerSetGetRequest(OCIRequest):
    """
    Get the Application Server set for a group.

    The response is either a ``GroupApplicationServerSetGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupApplicationServerSetModifyRequest(OCIRequest):
    """
    Modify the Application Server set for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("application_server_set_name", "applicationServerSetName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* applicationServerSetName
    application_server_set_name = Field(type=str, required=False, mutable=False)


class GroupAutoAttendantDeleteInstanceRequest(OCIRequest):
    """
    Delete a Auto Attendant instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantGetInstanceListRequest(OCIRequest):
    """
    Get a list of Auto Attendant instances within a group.

    The response is either ``GroupAutoAttendantGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(type=str, required=False, mutable=False)


class GroupAutoAttendantGetInstanceRequest14(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either ``GroupAutoAttendantGetInstanceResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupAutoAttendantGetInstanceRequest16()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantGetInstanceRequest16(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either ``GroupAutoAttendantGetInstanceResponse16()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either ``GroupAutoAttendantGetInstanceResponse17()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantGetInstanceRequest17sp1(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either ``GroupAutoAttendantGetInstanceResponse17sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantGetInstanceRequest19(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either ``GroupAutoAttendantGetInstanceResponse19()`` or
    ``ErrorResponse()``. Replaced by: ``GroupAutoAttendantGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either ``GroupAutoAttendantGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``. Replaced by: ``GroupAutoAttendantGetInstanceRequest20()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantGetInstanceRequest20(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either ``GroupAutoAttendantGetInstanceResponse20()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantSubmenuDeleteListRequest(OCIRequest):
    """
    Delete a submenu form an auto attendant.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. This request is
    only valid for Standard auto attendants.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("submenu_id", "submenuId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* submenuId
    submenu_id = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantSubmenuGetListRequest(OCIRequest):
    """
    Get a list of Auto Attendant Submenus.

    The response is either ``GroupAutoAttendantSubmenuGetListResponse()`` or
    ``ErrorResponse()``. This request is only valid for Standard auto attendants.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantSubmenuGetRequest(OCIRequest):
    """
    Request to get an Auto Attendant submenu instance.

    The response is either ``GroupAutoAttendantSubmenuGetResponse()`` or
    ``ErrorResponse()``. This request is only valid for Standard auto attendants.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("submenu_id", "submenuId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* submenuId
    submenu_id = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantSubmenuGetRequest20(OCIRequest):
    """
    Request to get an Auto Attendant submenu instance.

    The response is either ``GroupAutoAttendantSubmenuGetResponse20()`` or
    ``ErrorResponse()``. This request is only valid for Standard auto attendants.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("submenu_id", "submenuId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* submenuId
    submenu_id = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantSubmenuGetUsageListRequest(OCIRequest):
    """
    Get a list of Auto Attendant Business Hours Menu,After Hours Menu,Holiday Menu and
    Submenus that use this submenu.

    The response is either ``GroupAutoAttendantSubmenuGetUsageListResponse()`` or
    ``ErrorResponse()``. This request is only valid for Standard auto attendants.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("submenu_id", "submenuId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* submenuId
    submenu_id = Field(type=str, required=True, mutable=False)


class GroupBroadWorksAnywhereDeleteInstanceRequest(OCIRequest):
    """
    Delete a BroadWorks Anywhere instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupBroadWorksAnywhereGetInstanceListRequest(OCIRequest):
    """
    Get a list of BroadWorks Anywhere instances within a group.

    The response is either ``GroupBroadWorksAnywhereGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(type=str, required=False, mutable=False)


class GroupBroadWorksAnywhereGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a BroadWorks Anywhere instance.

    The response is either ``GroupBroadWorksAnywhereGetInstanceResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupBroadWorksAnywhereGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of a BroadWorks Anywhere instance.

    The response is either ``GroupBroadWorksAnywhereGetInstanceResponse17()`` or
    ``ErrorResponse()``. Replaced by: ``GroupBroadWorksAnywhereGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupBroadWorksAnywhereGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a BroadWorks Anywhere instance.

    The response is either ``GroupBroadWorksAnywhereGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerActivationRequest(OCIRequest):
    """
    Activates or Deactivates the BroadWorks Mobile Manager.

    The deactivationReason is required when isActive is set to false.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("deactivation_reason", "deactivationReason", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* deactivationReason
    deactivation_reason = Field(type=str, required=False, mutable=False)


class GroupBroadWorksMobileManagerAddHomeZoneRequest(OCIRequest):
    """
    Add a home zone to the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("home_zone_domain_name", "homeZoneDomainName", str, is_required=True),
        E("mobile_country_code", "mobileCountryCode", str, is_required=True),
        E("mobile_network_code", "mobileNetworkCode", str, is_required=True),
        E("location_area_code", "locationAreaCode", str, is_required=True),
        E("cell_identity", "cellIdentity", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* homeZoneDomainName
    home_zone_domain_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* mobileCountryCode
    mobile_country_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* mobileNetworkCode
    mobile_network_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* locationAreaCode
    location_area_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* cellIdentity
    cell_identity = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerAddRequest(OCIRequest):
    """
    Add the BroadWorks Mobile Manager.

    Only one BroadWorks Mobile Manager can be added per group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("information_file", "informationFile", str, is_required=True),
        E("certificate_file", "certificateFile", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("local_to_carrier", "localToCarrier", bool, is_required=True),
        E("max_tx_per_second_enabled", "maxTxPerSecondEnabled", bool, is_required=True),
        E("max_tx_per_second", "maxTxPerSecond", int),
        E("tldn_enabled", "tldnEnabled", bool, is_required=True),
        E("generic_number_enabled", "genericNumberEnabled", bool, is_required=True),
        E("mobile_state_check_enabled", "mobileStateCheckEnabled", bool, is_required=True),
        E(
            "location_based_services_enabled", "locationBasedServicesEnabled", bool,
            is_required=True,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* informationFile
    information_file = Field(type=str, required=True, mutable=False)
    #: str: *Required* certificateFile
    certificate_file = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* localToCarrier
    local_to_carrier = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* maxTxPerSecondEnabled
    max_tx_per_second_enabled = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* maxTxPerSecond
    max_tx_per_second = Field(type=int, required=False, mutable=False)
    #: bool: *Required* tldnEnabled
    tldn_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* genericNumberEnabled
    generic_number_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* mobileStateCheckEnabled
    mobile_state_check_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* locationBasedServicesEnabled
    location_based_services_enabled = Field(type=bool, required=True, mutable=False)


class GroupBroadWorksMobileManagerDeleteHomeZoneListRequest(OCIRequest):
    """
    Delete a list of home zones from the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("home_zone_id", "homeZoneId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* homeZoneId
    home_zone_id = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerDeleteHomeZoneRequest(OCIRequest):
    """
    Delete a home zone from the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("home_zone_id", "homeZoneId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* homeZoneId
    home_zone_id = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerDeleteRequest(OCIRequest):
    """
    Delete the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerGetDomainListRequest(OCIRequest):
    """
    Get the list of domains of the BroadWorks Mobile Manager.

    The response is either ``GroupBroadWorksMobileManagerGetDomainListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerGetHomeZoneListRequest(OCIRequest):
    """
    Get the list of home zones of the BroadWorks Mobile Manager.

    The response is either ``GroupBroadWorksMobileManagerGetHomeZoneListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerGetHomeZoneRequest(OCIRequest):
    """
    Get a home zone from the BroadWorks Mobile Manager.

    The response is either ``GroupBroadWorksMobileManagerGetHomeZoneResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("home_zone_id", "homeZoneId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* homeZoneId
    home_zone_id = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerGetRequest(OCIRequest):
    """
    Get the BroadWorks Mobile Manager.

    The response is either ``GroupBroadWorksMobileManagerGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerModifyHomeZoneRequest(OCIRequest):
    """
    Modify an existing home zone in the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("home_zone_id", "homeZoneId", str, is_required=True),
        E("home_zone_domain_name", "homeZoneDomainName", str),
        E("mobile_country_code", "mobileCountryCode", str),
        E("mobile_network_code", "mobileNetworkCode", str),
        E("location_area_code", "locationAreaCode", str),
        E("cell_identity", "cellIdentity", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* homeZoneId
    home_zone_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* homeZoneDomainName
    home_zone_domain_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* mobileCountryCode
    mobile_country_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* mobileNetworkCode
    mobile_network_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* locationAreaCode
    location_area_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* cellIdentity
    cell_identity = Field(type=str, required=False, mutable=False)


class GroupBroadWorksMobileManagerModifyRequest(OCIRequest):
    """
    Modify the BroadWorks Mobile Manager settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("information_file", "informationFile", str),
        E("certificate_file", "certificateFile", str),
        E("local_to_carrier", "localToCarrier", bool),
        E("max_tx_per_second_enabled", "maxTxPerSecondEnabled", bool),
        E("max_tx_per_second", "maxTxPerSecond", int),
        E("tldn_enabled", "tldnEnabled", bool),
        E("generic_number_enabled", "genericNumberEnabled", bool),
        E("mobile_state_check_enabled", "mobileStateCheckEnabled", bool),
        E("location_based_services_enabled", "locationBasedServicesEnabled", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* informationFile
    information_file = Field(type=str, required=False, mutable=False)
    #: str: *Optional* certificateFile
    certificate_file = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* localToCarrier
    local_to_carrier = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* maxTxPerSecondEnabled
    max_tx_per_second_enabled = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxTxPerSecond
    max_tx_per_second = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* tldnEnabled
    tldn_enabled = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* genericNumberEnabled
    generic_number_enabled = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* mobileStateCheckEnabled
    mobile_state_check_enabled = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* locationBasedServicesEnabled
    location_based_services_enabled = Field(type=bool, required=False, mutable=False)


class GroupBroadWorksMobileManagerSendCarrierFilesRequest(OCIRequest):
    """
    Sends an email with the carrier information and certificate files.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("email_to", "emailTo", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* emailTo
    email_to = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobilityGetRequest(OCIRequest):
    """
    Get the groups BroadWorks Mobility settings.

    The response is either a ``GroupBroadWorksMobilityGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobilityGetRequest19sp1(OCIRequest):
    """
    Get the group's BroadWorks Mobility settings.

    The response is either a ``GroupBroadWorksMobilityGetResponse19sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberAssignListRequest(OCIRequest):
    """
    Assign Mobile Subscriber Directory Numbers to a group.

    It is possible to add a single DN,or a list of DNs.  . This command is applicable only
    for group in a service provider and will fail for a group in an enterprise.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E(
            "mobile_subscriber_directory_number", "mobileSubscriberDirectoryNumber", str,
            is_array=True,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* mobileSubscriberDirectoryNumber  *Array*
    mobile_subscriber_directory_number = Field(type=list, required=False, mutable=False)


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest(OCIRequest):
    """
    Request a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any user.

    . This command is applicable only for group in a service provider and will fail for a
    group in an enterprise.

    The response is either
    ``GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberUnassignListRequest(OCIRequest):
    """
    Unassign Mobile Subscriber Directory Numbers from a group.

    It is possible to unassign either: a single DN, or a list of DNs.  . This command is
    applicable only for group in a service provider and will fail for a group in an
    enterprise.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E(
            "mobile_subscriber_directory_number", "mobileSubscriberDirectoryNumber", str,
            is_array=True,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* mobileSubscriberDirectoryNumber  *Array*
    mobile_subscriber_directory_number = Field(type=list, required=False, mutable=False)


class GroupBroadWorksMobilityModifyRequest(OCIRequest):
    """
    Modify the group level broadworks mobility service settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_setting_level", "useSettingLevel", str),
        E("enable_location_services", "enableLocationServices", bool),
        E("enable_msrn_lookup", "enableMSRNLookup", bool),
        E("enable_mobile_state_checking", "enableMobileStateChecking", bool),
        E("deny_call_originations", "denyCallOriginations", bool),
        E("deny_call_terminations", "denyCallTerminations", bool),
        E("enable_announcement_suppression", "enableAnnouncementSuppression", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* useSettingLevel
    use_setting_level = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableLocationServices
    enable_location_services = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableMSRNLookup
    enable_msrn_lookup = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableMobileStateChecking
    enable_mobile_state_checking = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* denyCallOriginations
    deny_call_originations = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* denyCallTerminations
    deny_call_terminations = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableAnnouncementSuppression
    enable_announcement_suppression = Field(type=bool, required=False, mutable=False)


class GroupCPEConfigRebuildConfigFileRequest(OCIRequest):
    """
    Rebuild the group default config file for the specified device type.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
        E("force", "force", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* force
    force = Field(type=bool, required=False, mutable=False)


class GroupCPEConfigRebuildDeviceConfigFileRequest(OCIRequest):
    """
    Rebuild the config file for a specified device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("force", "force", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* force
    force = Field(type=bool, required=False, mutable=False)


class GroupCPEConfigReorderDeviceLinePortsRequest(OCIRequest):
    """
    Reorder the lines of a group device.

    You can not add or delete line ports, only re-ordering the list is allowed.  The
    ordered list of line ports can be obtained with the
    ``GroupAccessDeviceGetRequest16()`` command.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("ordered_line_port_list", "orderedLinePortList", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* orderedLinePortList
    ordered_line_port_list = Field(type=str, required=True, mutable=False)


class GroupCPEConfigResetDeviceRequest(OCIRequest):
    """
    Reset a specific group device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class GroupCPEConfigResetDeviceTypeRequest(OCIRequest):
    """
    Reset all the devices of the specified device type in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)


class GroupCallCapacityManagementAddInstanceRequest(OCIRequest):
    """
    Adds a Call Capacity Management group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("max_active_calls_allowed", "maxActiveCallsAllowed", int, is_required=True),
        E("max_incoming_active_calls_allowed", "maxIncomingActiveCallsAllowed", int),
        E("max_outgoing_active_calls_allowed", "maxOutgoingActiveCallsAllowed", int),
        E(
            "become_default_group_for_new_users", "becomeDefaultGroupForNewUsers", bool,
            is_required=True,
        ),
        E("user_id", "userId", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: int: *Required* maxActiveCallsAllowed
    max_active_calls_allowed = Field(type=int, required=True, mutable=False)
    #: int: *Optional* maxIncomingActiveCallsAllowed
    max_incoming_active_calls_allowed = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxOutgoingActiveCallsAllowed
    max_outgoing_active_calls_allowed = Field(type=int, required=False, mutable=False)
    #: bool: *Required* becomeDefaultGroupForNewUsers
    become_default_group_for_new_users = Field(type=bool, required=True, mutable=False)
    #: list(str): *Optional* userId  *Array*
    user_id = Field(type=list, required=False, mutable=False)


class GroupCallCapacityManagementAddUserListRequest(OCIRequest):
    """
    Adds one or more users to a Call Capacity Management group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupCallCapacityManagementDeleteInstanceListRequest(OCIRequest):
    """
    Deletes one or more Call Capacity Management groups.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupCallCapacityManagementDeleteUserListRequest(OCIRequest):
    """
    Deletes one or more users from a Call Capacity Management group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupCallCapacityManagementGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Call Capacity Management instances within a group.

    The response is either ``GroupCallCapacityManagementGetInstanceListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallCapacityManagementGetInstanceRequest(OCIRequest):
    """
    Gets a Call Capacity Management group.

    The response is either ``GroupCallCapacityManagementGetInstanceResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupCallCenterAddSupervisorListRequest(OCIRequest):
    """
    Add supervisor(s) to a call center.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("supervisor_user_id", "supervisorUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* supervisorUserId
    supervisor_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentThresholdProfileAddAgentListRequest(OCIRequest):
    """
    Add agent(s) to a Agent Threshold Profile.

    When an agent is assigned (added )to a profile, it is automatically unassigned
    (deleted) from the previous profile it was assigned to.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
        E("agent_user_id", "agentUserId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* profileName
    profile_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* agentUserId
    agent_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentThresholdProfileAddRequest(OCIRequest):
    """
    Add a new Call Center Agent Threshold Profile in a Group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
        E("profile_description", "profileDescription", str),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed", int,
        ),
        E("threshold_average_busy_in_time_yellow", "thresholdAverageBusyInTimeYellow", int),
        E("threshold_average_busy_in_time_red", "thresholdAverageBusyInTimeRed", int),
        E("threshold_average_busy_out_time_yellow", "thresholdAverageBusyOutTimeYellow", int),
        E("threshold_average_busy_out_time_red", "thresholdAverageBusyOutTimeRed", int),
        E("threshold_average_wrap_up_time_yellow", "thresholdAverageWrapUpTimeYellow", int),
        E("threshold_average_wrap_up_time_red", "thresholdAverageWrapUpTimeRed", int),
        E("enable_notification_email", "enableNotificationEmail", bool, is_required=True),
        E("notification_email_address", "notificationEmailAddress", str),
        E("agent_user_id", "agentUserId", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* profileName
    profile_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* profileDescription
    profile_description = Field(type=str, required=False, mutable=False)
    #: int: *Optional* thresholdCurrentCallStateIdleTimeYellow
    threshold_current_call_state_idle_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeRed
    threshold_current_call_state_idle_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeYellow
    threshold_current_call_state_on_call_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeRed
    threshold_current_call_state_on_call_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeYellow
    threshold_current_agent_state_unavailable_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeRed
    threshold_current_agent_state_unavailable_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeYellow
    threshold_average_busy_in_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyInTimeRed
    threshold_average_busy_in_time_red = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyOutTimeYellow
    threshold_average_busy_out_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyOutTimeRed
    threshold_average_busy_out_time_red = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageWrapUpTimeYellow
    threshold_average_wrap_up_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageWrapUpTimeRed
    threshold_average_wrap_up_time_red = Field(type=int, required=False, mutable=False)
    #: bool: *Required* enableNotificationEmail
    enable_notification_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* notificationEmailAddress
    notification_email_address = Field(type=str, required=False, mutable=False)
    #: list(str): *Optional* agentUserId  *Array*
    agent_user_id = Field(type=list, required=False, mutable=False)


class GroupCallCenterAgentThresholdProfileDeleteAgentListRequest(OCIRequest):
    """
    Delete agent(s) from a Agent Threshold Profile.

    Agents cannot be unassigned (deleted) directly from the default profile, they need to
    be assigned (added) to a different profile.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
        E("agent_user_id", "agentUserId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* profileName
    profile_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* agentUserId
    agent_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentThresholdProfileDeleteRequest(OCIRequest):
    """
    Deletes an existing Call Center Agent Threshold Profile in a Group.

    The default profile cannot be deleted.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* profileName
    profile_name = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentThresholdProfileGetListRequest(OCIRequest):
    """
    Get the list of Call Center Agent Threshold Profiles in the Group.

    The response is either ``GroupCallCenterAgentThresholdProfileGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentThresholdProfileGetRequest(OCIRequest):
    """
    Gets an existing non-default Call Center Agent Threshold Profile in a Group.

    The response is either a ``GroupCallCenterAgentThresholdProfileGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* profileName
    profile_name = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentUnavailableCodeAddRequest(OCIRequest):
    """
    Add a Call Center Agent Unavailable Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("code", "code", str, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class GroupCallCenterAgentUnavailableCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Agent Unavailable Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentUnavailableCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Agent Unavailable Codes.

    The response is either ``GroupCallCenterAgentUnavailableCodeGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentUnavailableCodeGetRequest(OCIRequest):
    """
    Get a Call Center Agent Unavailable Code.

    The response is either ``GroupCallCenterAgentUnavailableCodeGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentUnavailableCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Agent Unavailable Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool),
        E("description", "description", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* isActive
    is_active = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class GroupCallCenterAgentUnavailableCodeSettingsGetRequest(OCIRequest):
    """
    Request the group level data associated with Call Center Agents Unavailable Code
    Settings.

    The response is either an ``GroupCallCenterAgentUnavailableCodeSettingsGetResponse()``
    or an ``ErrorResponse()``. Replaced by
    ``GroupCallCenterAgentUnavailableCodeSettingsGetRequest17sp4()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentUnavailableCodeSettingsGetRequest17sp4(OCIRequest):
    """
    Request the group level data associated with Call Center Agents Unavailable Code
    Settings.

    The response is either a
    ``GroupCallCenterAgentUnavailableCodeSettingsGetResponse17sp4()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterBouncedCallGetRequest(OCIRequest):
    """
    Get a call center's bounced call settings.

    The response is either a ``GroupCallCenterBouncedCallGetResponse()`` or an
    ``ErrorResponse()``. Replaced by: ``GroupCallCenterBouncedCallGetRequest17()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterBouncedCallGetRequest17(OCIRequest):
    """
    Get a call center's bounced call settings.

    The response is either a ``GroupCallCenterBouncedCallGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterBouncedCallModifyRequest(OCIRequest):
    """
    Modify a call center's bounced call settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("is_active", "isActive", bool),
        E("number_of_rings_before_bouncing_call", "numberOfRingsBeforeBouncingCall", int),
        E("enable_transfer", "enableTransfer", bool),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E("bounce_call_when_agent_unavailable", "bounceCallWhenAgentUnavailable", bool),
        E("alert_call_center_call_on_hold", "alertCallCenterCallOnHold", bool),
        E("alert_call_center_call_on_hold_seconds", "alertCallCenterCallOnHoldSeconds", int),
        E("bounce_call_center_call_on_hold", "bounceCallCenterCallOnHold", bool),
        E(
            "bounce_call_center_call_on_hold_seconds",
            "bounceCallCenterCallOnHoldSeconds", int,
        ),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* isActive
    is_active = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* numberOfRingsBeforeBouncingCall
    number_of_rings_before_bouncing_call = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* enableTransfer
    enable_transfer = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* bounceCallWhenAgentUnavailable
    bounce_call_when_agent_unavailable = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* alertCallCenterCallOnHold
    alert_call_center_call_on_hold = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* alertCallCenterCallOnHoldSeconds
    alert_call_center_call_on_hold_seconds = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* bounceCallCenterCallOnHold
    bounce_call_center_call_on_hold = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* bounceCallCenterCallOnHoldSeconds
    bounce_call_center_call_on_hold_seconds = Field(type=int, required=False, mutable=False)


class GroupCallCenterCallDispositionCodeAddRequest(OCIRequest):
    """
    Add a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class GroupCallCenterCallDispositionCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)


class GroupCallCenterCallDispositionCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Call Disposition Codes.

    The response is either ``GroupCallCenterCallDispositionCodeGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterCallDispositionCodeGetRequest(OCIRequest):
    """
    Get a Call Center Call Disposition Code.

    The response is either ``GroupCallCenterCallDispositionCodeGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)


class GroupCallCenterCallDispositionCodeGetUsageListRequest(OCIRequest):
    """
    Get the list of Call Centers and Route Points using the specified disposition code.

    The response is either ``GroupCallCenterCallDispositionCodeGetUsageListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)


class GroupCallCenterCallDispositionCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool),
        E("description", "description", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* isActive
    is_active = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class GroupCallCenterComfortMessageBypassGetRequest(OCIRequest):
    """
    Get a call center's comfort message bypass settings.

    The response is either a ``GroupCallCenterComfortMessageBypassGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterComfortMessageBypassGetRequest17(OCIRequest):
    """
    Get a call center's comfort message bypass settings.

    The response is either a ``GroupCallCenterComfortMessageBypassGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterComfortMessageBypassGetRequest20(OCIRequest):
    """
    Get a call center's comfort message bypass settings.

    The response is either a ``GroupCallCenterComfortMessageBypassGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterCurrentAndPastDNISGetListRequest(OCIRequest):
    """
    Request to get all the past and current DNIS for the Call Center for the group.

    The response is either ``GroupCallCenterCurrentAndPastDNISGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterDeleteAgentListRequest(OCIRequest):
    """
    Delete agent(s) from a call center.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("agent_user_id", "agentUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* agentUserId
    agent_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterDeleteInstanceRequest(OCIRequest):
    """
    Delete a Call Center instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterDeleteSupervisorListRequest(OCIRequest):
    """
    Delete supervisor(s) from a call center.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("supervisor_user_id", "supervisorUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* supervisorUserId
    supervisor_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterDistinctiveRingingGetRequest(OCIRequest):
    """
    Get the distinctive ringing configuration values for call center.

    The response is either a ``GroupCallCenterDistinctiveRingingGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterDistinctiveRingingModifyRequest(OCIRequest):
    """
    Modify the distinctive ringing configuration values for call center.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("distinctive_ringing_call_center_calls", "distinctiveRingingCallCenterCalls", bool),
        E(
            "distinctive_ringing_ring_pattern_for_call_center",
            "distinctiveRingingRingPatternForCallCenter", str,
        ),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern", str,
        ),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* distinctiveRingingCallCenterCalls
    distinctive_ringing_call_center_calls = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* distinctiveRingingRingPatternForCallCenter
    distinctive_ringing_ring_pattern_for_call_center = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* distinctiveRingingForceDeliveryRingPattern
    distinctive_ringing_force_delivery_ring_pattern = Field(
        type=str, required=False, mutable=False,
    )


class GroupCallCenterEnhancedGetRequest(OCIRequest):
    """
    Request to get the Call Center Enhanced configuration data for a Call Center.

    The response is either ``GroupCallCenterEnhancedGetResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterGetInstanceResponse16()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedModifyRequest(OCIRequest):
    """
    Modify the Call Center Enhanced configuration data for a Call Center.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterModifyInstanceRequest16()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("override_agent_wrap_up_time", "overrideAgentWrapUpTime", bool),
        E("wrap_up_seconds", "wrapUpSeconds", int),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* overrideAgentWrapUpTime
    override_agent_wrap_up_time = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* wrapUpSeconds
    wrap_up_seconds = Field(type=int, required=False, mutable=False)


class GroupCallCenterEnhancedReportingBrandingGetRequest(OCIRequest):
    """
    Request to get the group branding information.

    The response is either ``GroupCallCenterEnhancedReportingBrandingGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingGetAvailableReportTemplateListRequest(OCIRequest):
    """
    Request to get all enabled call center report template for a group.

    The response is either a
    ``GroupCallCenterEnhancedReportingGetAvailableReportTemplateListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingGetRequest(OCIRequest):
    """
    Request to get a group level call center enhanced reporting setting.

    The response is either a ``GroupCallCenterEnhancedReportingGetResponse()`` or an
    ``ErrorResponse()``. Replaced by ``GroupCallCenterEnhancedReportingGetRequest19()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingGetRequest19(OCIRequest):
    """
    Request to get a group level call center enhanced reporting setting.

    The response is either a ``GroupCallCenterEnhancedReportingGetResponse19()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingModifyRequest(OCIRequest):
    """
    Request to modify group level call center enhanced reporting settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Replaced by
    ``GroupCallCenterEnhancedReportingModifyRequest19()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("reporting_server", "reportingServer", str),
        E("web_statistic_source", "webStatisticSource", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* reportingServer
    reporting_server = Field(type=str, required=False, mutable=False)
    #: str: *Optional* webStatisticSource
    web_statistic_source = Field(type=str, required=False, mutable=False)


class GroupCallCenterEnhancedReportingModifyRequest19(OCIRequest):
    """
    Request to modify group level call center enhanced reporting settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("reporting_server", "reportingServer", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* reportingServer
    reporting_server = Field(type=str, required=False, mutable=False)


class GroupCallCenterEnhancedReportingReportTemplateDeleteRequest(OCIRequest):
    """
    Request to delete a group level call center report template.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingReportTemplateGetListRequest(OCIRequest):
    """
    Request to get group level call center report template list.

    The response is either a
    ``GroupCallCenterEnhancedReportingReportTemplateGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingReportTemplateGetRequest(OCIRequest):
    """
    Request to get a group level call center report template.

    The response is either a
    ``GroupCallCenterEnhancedReportingReportTemplateGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingScheduledReportDeleteRequest(OCIRequest):
    """
    Request to delete a group level call center reporting scheduled report.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest(OCIRequest):
    """
    Request to get all the call center reporting scheduled report in a group that uses a
    given group level report template.

    The response is either a
    ``GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingScheduledReportGetRequest(OCIRequest):
    """
    Request to get a group level call center reporting scheduled report.

    The response is either a
    ``GroupCallCenterEnhancedReportingScheduledReportGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupCallCenterForcedForwardingGetRequest(OCIRequest):
    """
    Get a call center's forced forwarding settings.

    The response is either a ``GroupCallCenterForcedForwardingGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterForcedForwardingGetRequest17(OCIRequest):
    """
    Get a call center's forced forwarding settings.

    The response is either a ``GroupCallCenterForcedForwardingGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterForcedForwardingGetRequest20(OCIRequest):
    """
    Get a call center's forced forwarding settings.

    The response is either a ``GroupCallCenterForcedForwardingGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetAnnouncementRequest(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a ``GroupCallCenterGetAnnouncementResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetAnnouncementRequest14sp6(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a ``GroupCallCenterGetAnnouncementResponse14sp6()`` or an
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterGetAnnouncementRequest16()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetAnnouncementRequest16(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a ``GroupCallCenterGetAnnouncementResponse16()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetAnnouncementRequest17(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a ``GroupCallCenterGetAnnouncementResponse17()`` or an
    ``ErrorResponse()``. Replaced by ``GroupCallCenterGetAnnouncementRequest17sp4()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetAnnouncementRequest17sp4(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a ``GroupCallCenterGetAnnouncementResponse17sp4()`` or an
    ``ErrorResponse()``. Replaced by: ``GroupCallCenterGetAnnouncementRequest19()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetAnnouncementRequest19(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a ``GroupCallCenterGetAnnouncementResponse19()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetAnnouncementRequest20(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a ``GroupCallCenterGetAnnouncementResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetDNISListRequest(OCIRequest):
    """
    Get a list of DNIS that are configured for a Call Center.

    The response is either ``GroupCallCenterGetDNISListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetDistinctiveRingingRequest(OCIRequest):
    """
    Get the distinctive ringing configuration values for call center.

    The response is either a ``GroupCallCenterGetDistinctiveRingingResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceListRequest(OCIRequest):
    """
    Get a list of Call Center instances within a group.

    The response is either ``GroupCallCenterGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(type=str, required=False, mutable=False)


class GroupCallCenterGetInstanceQueueStatusRequest(OCIRequest):
    """
    Get Call Center queue status.

    The response is either ``GroupCallCenterGetInstanceQueueStatusResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest14(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse14()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterGetInstanceRequest14sp3()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest14sp3(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse14sp3()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterGetInstanceRequest14sp9()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest14sp9(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse14sp9()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterGetInstanceRequest16()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest16(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse16()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse17()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest17sp1(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse17sp1()`` or
    ``ErrorResponse()``. Replaced by: ``GroupCallCenterGetInstanceRequest17sp3()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest17sp3(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse17sp3()`` or
    ``ErrorResponse()``. Replaced by ``GroupCallCenterGetInstanceRequest19()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest19(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse19()`` or
    ``ErrorResponse()``. Replaced by: ``GroupCallCenterGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceStatisticsReportingRequest(OCIRequest):
    """
    Request to get the call center statistics reporting settings.

    The response is either ``GroupCallCenterGetInstanceStatisticsReportingResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterGetInstanceStatisticsReportingRequest16()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceStatisticsReportingRequest16(OCIRequest):
    """
    Request to get the call center statistics reporting settings.

    The response is either ``GroupCallCenterGetInstanceStatisticsReportingResponse16()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceStatisticsReportingRequest17sp1(OCIRequest):
    """
    Request to get the call center statistics reporting settings.

    The response is either
    ``GroupCallCenterGetInstanceStatisticsReportingResponse17sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceStatisticsRequest13mp8(OCIRequest):
    """
    Get Call Center queue and agent statistics.

    The response is either ``GroupCallCenterGetInstanceStatisticsResponse13mp8()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterGetInstanceStatisticsRequest14sp9()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetRequest(OCIRequest):
    """
    Request the Group level data associated with Call Center.

    The response is either a ``GroupCallCenterGetResponse()`` or an ``ErrorResponse()``.
    Replaced by ``GroupCallCenterGetRequest17sp4()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetRequest17sp4(OCIRequest):
    """
    Request the Group level data associated with Call Center.

    The response is either a ``GroupCallCenterGetResponse17sp4()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetRoutingPolicyRequest(OCIRequest):
    """
    Request the group call center routing policy.

    The response is either a ``GroupCallCenterGetRoutingPolicyResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetSupervisorListRequest(OCIRequest):
    """
    Get a list of supervisors assigned to a call center.

    Only users in the same group or enterprise as this call center can successfully
    execute this request.

    The response is either a ``GroupCallCenterGetSupervisorListResponse()`` or an
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterSupervisorReportingGetRequest()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetSupervisorListRequest16(OCIRequest):
    """
    Get a list of supervisors assigned to a call center.

    The response is either a ``GroupCallCenterGetSupervisorListResponse16()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetUnlicensedAgentListRequest(OCIRequest):
    """
    Get a list of unlicensed users who are preventing the Call Center from upgrading to
    another type.

    The response is either ``GroupCallCenterGetUnlicensedAgentListRequest()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("call_center_type", "callCenterType", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* callCenterType
    call_center_type = Field(type=str, required=True, mutable=False)


class GroupCallCenterHolidayServiceGetRequest(OCIRequest):
    """
    Get a call center's holiday service settings.

    The response is either a ``GroupCallCenterHolidayServiceGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterHolidayServiceGetRequest17(OCIRequest):
    """
    Get a call center's holiday service settings.

    The response is either a ``GroupCallCenterHolidayServiceGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterHolidayServiceGetRequest17sp1(OCIRequest):
    """
    Get a call center's holiday service settings.

    The response is either a ``GroupCallCenterHolidayServiceGetResponse17sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterHolidayServiceGetRequest20(OCIRequest):
    """
    Get a call center's holiday service settings.

    The response is either a ``GroupCallCenterHolidayServiceGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterModifyDNISParametersRequest(OCIRequest):
    """
    Modify the setting that are configured for all the DNIS in a Call Center.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("display_dnis_number", "displayDNISNumber", bool),
        E("display_dnis_name", "displayDNISName", bool),
        E("promote_calls_from_priority1to0", "promoteCallsFromPriority1to0", bool),
        E("promote_calls_from_priority2to1", "promoteCallsFromPriority2to1", bool),
        E("promote_calls_from_priority3to2", "promoteCallsFromPriority3to2", bool),
        E(
            "promote_calls_from_priority1to0_seconds",
            "promoteCallsFromPriority1to0Seconds", int,
        ),
        E(
            "promote_calls_from_priority2to1_seconds",
            "promoteCallsFromPriority2to1Seconds", int,
        ),
        E(
            "promote_calls_from_priority3to2_seconds",
            "promoteCallsFromPriority3to2Seconds", int,
        ),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* displayDNISNumber
    display_dnis_number = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* displayDNISName
    display_dnis_name = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* promoteCallsFromPriority1to0
    promote_calls_from_priority1to0 = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* promoteCallsFromPriority2to1
    promote_calls_from_priority2to1 = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* promoteCallsFromPriority3to2
    promote_calls_from_priority3to2 = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* promoteCallsFromPriority1to0Seconds
    promote_calls_from_priority1to0_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* promoteCallsFromPriority2to1Seconds
    promote_calls_from_priority2to1_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* promoteCallsFromPriority3to2Seconds
    promote_calls_from_priority3to2_seconds = Field(type=int, required=False, mutable=False)


class GroupCallCenterModifyDistinctiveRingingRequest(OCIRequest):
    """
    Modify the distinctive ringing configuration values for call center.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("distinctive_ringing_call_center_calls", "distinctiveRingingCallCenterCalls", bool),
        E(
            "distinctive_ringing_ring_pattern_for_call_center",
            "distinctiveRingingRingPatternForCallCenter", str,
        ),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern", str,
        ),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* distinctiveRingingCallCenterCalls
    distinctive_ringing_call_center_calls = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* distinctiveRingingRingPatternForCallCenter
    distinctive_ringing_ring_pattern_for_call_center = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* distinctiveRingingForceDeliveryRingPattern
    distinctive_ringing_force_delivery_ring_pattern = Field(
        type=str, required=False, mutable=False,
    )


class GroupCallCenterModifyInstanceStatisticsReportingRequest(OCIRequest):
    """
    Modify the Call Center statistics reporting frequency and destination.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterModifyInstanceStatisticsReportingRequest14sp9()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("clear_today_statistics", "clearTodayStatistics", bool),
        E("generate_daily_report", "generateDailyReport", bool),
        E("collection_period_minutes", "collectionPeriodMinutes", int),
        E("reporting_email_address1", "reportingEmailAddress1", str),
        E("reporting_email_address2", "reportingEmailAddress2", str),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* clearTodayStatistics
    clear_today_statistics = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* generateDailyReport
    generate_daily_report = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* collectionPeriodMinutes
    collection_period_minutes = Field(type=int, required=False, mutable=False)
    #: str: *Optional* reportingEmailAddress1
    reporting_email_address1 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* reportingEmailAddress2
    reporting_email_address2 = Field(type=str, required=False, mutable=False)


class GroupCallCenterModifyInstanceStatisticsReportingRequest14sp9(OCIRequest):
    """
    Modify the Call Center statistics reporting frequency and destination.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("generate_daily_report", "generateDailyReport", bool),
        E("collection_period_minutes", "collectionPeriodMinutes", int),
        E("reporting_email_address1", "reportingEmailAddress1", str),
        E("reporting_email_address2", "reportingEmailAddress2", str),
        E("statistics_source", "statisticsSource", str),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* generateDailyReport
    generate_daily_report = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* collectionPeriodMinutes
    collection_period_minutes = Field(type=int, required=False, mutable=False)
    #: str: *Optional* reportingEmailAddress1
    reporting_email_address1 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* reportingEmailAddress2
    reporting_email_address2 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* statisticsSource
    statistics_source = Field(type=str, required=False, mutable=False)


class GroupCallCenterModifyInstanceStatisticsReportingRequest17sp1(OCIRequest):
    """
    Modify the Call Center statistics reporting frequency and destination.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("generate_daily_report", "generateDailyReport", bool),
        E("collection_period_minutes", "collectionPeriodMinutes", int),
        E("reporting_email_address1", "reportingEmailAddress1", str),
        E("reporting_email_address2", "reportingEmailAddress2", str),
        E("statistics_source", "statisticsSource", str),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* generateDailyReport
    generate_daily_report = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* collectionPeriodMinutes
    collection_period_minutes = Field(type=int, required=False, mutable=False)
    #: str: *Optional* reportingEmailAddress1
    reporting_email_address1 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* reportingEmailAddress2
    reporting_email_address2 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* statisticsSource
    statistics_source = Field(type=str, required=False, mutable=False)


class GroupCallCenterModifyRequest(OCIRequest):
    """
    Modify the group level data associated with Call Center and the active status of Call
    Center instances.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_system_default_guard_timer", "useSystemDefaultGuardTimer", bool),
        E("enable_guard_timer", "enableGuardTimer", bool),
        E("guard_timer_seconds", "guardTimerSeconds", int),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings", bool,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable", bool,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useSystemDefaultGuardTimer
    use_system_default_guard_timer = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableGuardTimer
    enable_guard_timer = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* guardTimerSeconds
    guard_timer_seconds = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useSystemDefaultUnavailableSettings
    use_system_default_unavailable_settings = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnNotReachable
    force_agent_unavailable_on_not_reachable = Field(type=bool, required=False, mutable=False)


class GroupCallCenterNightServiceGetRequest(OCIRequest):
    """
    Get a call center's night service settings.

    The response is either a ``GroupCallCenterNightServiceGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterNightServiceGetRequest17(OCIRequest):
    """
    Get a call center's night service settings.

    The response is either a ``GroupCallCenterNightServiceGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterNightServiceGetRequest17sp1(OCIRequest):
    """
    Get a call center's night service settings.

    The response is either a ``GroupCallCenterNightServiceGetResponse17sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterNightServiceGetRequest20(OCIRequest):
    """
    Get a call center's night service settings.

    The response is either a ``GroupCallCenterNightServiceGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterOverflowGetRequest(OCIRequest):
    """
    Get a call center's overflow settings.

    The response is either a ``GroupCallCenterOverflowGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterOverflowGetRequest17(OCIRequest):
    """
    Get a call center's overflow settings.

    The response is either a ``GroupCallCenterOverflowGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterOverflowGetRequest20(OCIRequest):
    """
    Get a call center's overflow settings.

    The response is either a ``GroupCallCenterOverflowGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterQueueCallDispositionCodeAddRequest(OCIRequest):
    """
    Add a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class GroupCallCenterQueueCallDispositionCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)


class GroupCallCenterQueueCallDispositionCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Level and Organization Level Call Disposition Codes.

    The response is either ``GroupCallCenterQueueCallDispositionCodeGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterQueueCallDispositionCodeGetRequest(OCIRequest):
    """
    Get a Call Center Call Disposition Code.

    The response is either ``GroupCallCenterQueueCallDispositionCodeGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)


class GroupCallCenterQueueCallDispositionCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool),
        E("description", "description", str),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* isActive
    is_active = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class GroupCallCenterQueueCallDispositionCodeSettingsGetRequest(OCIRequest):
    """
    Request the user level data associated with Call Center Call Disposition Code
    Settings.

    The response is either a
    ``GroupCallCenterQueueCallDispositionCodeSettingsGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterQueueStatusNotificationGetRequest(OCIRequest):
    """
    Get the status configuration for a given call center.

    The response is either a ``GroupCallCenterQueueStatusNotificationGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterQueueStatusNotificationModifyRequest(OCIRequest):
    """
    Set the status configuration for a given call center.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("enable_queue_status_notification", "enableQueueStatusNotification", bool),
        E("enable_queue_depth_threshold", "enableQueueDepthThreshold", bool),
        E("enable_waiting_time_threshold", "enableWaitingTimeThreshold", bool),
        E("number_of_calls_threshold", "numberOfCallsThreshold", int),
        E("waiting_time_of_calls_threshold", "waitingTimeOfCallsThreshold", int),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* enableQueueStatusNotification
    enable_queue_status_notification = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableQueueDepthThreshold
    enable_queue_depth_threshold = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableWaitingTimeThreshold
    enable_waiting_time_threshold = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* numberOfCallsThreshold
    number_of_calls_threshold = Field(type=int, required=False, mutable=False)
    #: int: *Optional* waitingTimeOfCallsThreshold
    waiting_time_of_calls_threshold = Field(type=int, required=False, mutable=False)


class GroupCallCenterQueueThresholdsGetRequest(OCIRequest):
    """
    Get a call center's queue Thresholds settings.

    The response is either a ``GroupCallCenterQueueThresholdsGetRequest()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterStrandedCallGetRequest(OCIRequest):
    """
    Get a call center's stranded call settings.

    The response is either a ``GroupCallCenterStrandedCallGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterStrandedCallGetRequest17(OCIRequest):
    """
    Get a call center's stranded call settings.

    The response is either a ``GroupCallCenterStrandedCallGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterStrandedCallGetRequest20(OCIRequest):
    """
    Get a call center's stranded call settings.

    The response is either a ``GroupCallCenterStrandedCallGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterStrandedCallUnavailableGetRequest(OCIRequest):
    """
    Get a call center's stranded calls - unavailable settings.

    The response is either a ``GroupCallCenterStrandedCallUnavailableGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterStrandedCallUnavailableGetRequest20(OCIRequest):
    """
    Get a call center's stranded calls - unavailable settings.

    The response is either a ``GroupCallCenterStrandedCallUnavailableGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallCenterSupervisorReportingGetRequest(OCIRequest):
    """
    Get a list of supervisors assigned to a call center.

    Only users in the same group or enterprise as this call center can successfully
    execute this request.

    The response is either a ``GroupCallCenterSupervisorReportingGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterGetSupervisorListRequest16()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCallParkAddInstanceRequest(OCIRequest):
    """
    Adds a Call Park group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("user_id", "userId", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* userId  *Array*
    user_id = Field(type=list, required=False, mutable=False)


class GroupCallParkAddInstanceRequest16sp2(OCIRequest):
    """
    Adds a Call Park group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in AS data mode: recallAlternateUserId recallTo, use value
    "Parking User Only" in HSS data mode
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("user_id", "userId", str, is_array=True),
        E("recall_alternate_user_id", "recallAlternateUserId", str),
        E("recall_to", "recallTo", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* userId  *Array*
    user_id = Field(type=list, required=False, mutable=False)
    #: str: *Optional* recallAlternateUserId
    recall_alternate_user_id = Field(type=str, required=False, mutable=False)
    #: str: *Required* recallTo
    recall_to = Field(type=str, required=True, mutable=False)


class GroupCallParkDeleteInstanceRequest(OCIRequest):
    """
    Deletes a Call Park group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupCallParkGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Call Park group instances within a group.

    The response is either ``GroupCallParkGetInstanceListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallParkGetInstanceRequest(OCIRequest):
    """
    Gets a Call Park group.

    The response is either ``GroupCallParkGetInstanceResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupCallParkGetInstanceRequest16sp2(OCIRequest):
    """
    Gets a Call Park group.

    The response is either ``GroupCallParkGetInstanceResponse16sp2()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupCallParkGetRequest(OCIRequest):
    """
    Gets the Call Park Group settings.

    The response is either ``GroupCallParkGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallParkGetRequest16sp2(OCIRequest):
    """
    Gets the Call Park Group settings.

    The response is either ``GroupCallParkGetResponse16sp2()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallParkModifyRequest(OCIRequest):
    """
    Modifies the Group's Call Park settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in AS data mode: recallAlternateUserId recallRingPattern
    recallTo alternateUserRecallTimerSeconds
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("recall_timer_seconds", "recallTimerSeconds", int),
        E("display_timer_seconds", "displayTimerSeconds", int),
        E("enable_destination_announcement", "enableDestinationAnnouncement", bool),
        E("recall_alternate_user_id", "recallAlternateUserId", str),
        E("recall_ring_pattern", "recallRingPattern", str),
        E("recall_to", "recallTo", str),
        E("alternate_user_recall_timer_seconds", "alternateUserRecallTimerSeconds", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: int: *Optional* recallTimerSeconds
    recall_timer_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* displayTimerSeconds
    display_timer_seconds = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* enableDestinationAnnouncement
    enable_destination_announcement = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* recallAlternateUserId
    recall_alternate_user_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* recallRingPattern
    recall_ring_pattern = Field(type=str, required=False, mutable=False)
    #: str: *Optional* recallTo
    recall_to = Field(type=str, required=False, mutable=False)
    #: int: *Optional* alternateUserRecallTimerSeconds
    alternate_user_recall_timer_seconds = Field(type=int, required=False, mutable=False)


class GroupCallPickupAddInstanceRequest(OCIRequest):
    """
    Adds a Call Pickup group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("user_id", "userId", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* userId  *Array*
    user_id = Field(type=list, required=False, mutable=False)


class GroupCallPickupDeleteInstanceRequest(OCIRequest):
    """
    Deletes a Call Pickup group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupCallPickupGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Call Pickup instances within a group.

    The response is either ``GroupCallPickupGetInstanceListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallPickupGetInstanceRequest(OCIRequest):
    """
    Gets a Call Pickup group.

    The response is either ``GroupCallPickupGetInstanceResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest14(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse14()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest14sp1(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse14sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest14sp4(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse14sp4()`` or an
    ``ErrorResponse()``.

    Replaced By : ``GroupCallProcessingGetPolicyRequest15()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest14sp7(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse14sp7()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    Replaced By: ``GroupCallProcessingGetPolicyRequest16()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest15(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse15()`` or an
    ``ErrorResponse()``.

    Replaced By: ``GroupCallProcessingGetPolicyRequest16()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest15sp2(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse15sp2()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest16(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse16()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest16sp2(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse16sp2()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The useGroupDCLIDSetting controls the Dialable
    Caller ID settings (enableDialableCallerID)
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest17(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse17()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest17sp3(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse17sp3()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The useGroupDCLIDSetting controls the Dialable
    Caller ID settings (enableDialableCallerID) The following elements are only used in AS
    data mode: useGroupDCLIDSetting enableDialableCallerID Replaced by
    ``GroupCallProcessingGetPolicyRequest17sp4()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest17sp4(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse17sp4()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName, allowConfigurableCLIDForRedirectingIdentity) The useGroupMediaSetting
    attribute controls the Media settings (medisPolicySelection, supportedMediaSetName)
    The useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls, useMaxSimultaneousVideoCalls,
    maxSimultaneousVideoCalls, useMaxCallTimeForAnsweredCalls,
    maxCallTimeForAnsweredCallsMinutes, useMaxCallTimeForUnansweredCalls,
    maxCallTimeForUnansweredCallsMinutes, useMaxConcurrentRedirectedCalls,
    useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The following elements are only used in AS data
    mode: useGroupDCLIDSetting enableDialableCallerID Replaced by
    ``GroupCallProcessingGetPolicyRequest18()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest18(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse18()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName, allowDepartmentCLIDNameOverride) The useGroupMediaSetting attribute
    controls the Media settings (medisPolicySelection, supportedMediaSetName) The
    useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls, useMaxSimultaneousVideoCalls,
    maxSimultaneousVideoCalls, useMaxCallTimeForAnsweredCalls,
    maxCallTimeForAnsweredCallsMinutes, useMaxCallTimeForUnansweredCalls,
    maxCallTimeForUnansweredCallsMinutes, useMaxConcurrentRedirectedCalls,
    useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The following elements are only used in AS data
    mode: useGroupDCLIDSetting enableDialableCallerID allowDepartmentCLIDNameOverride

    Replaced By : ``GroupCallProcessingGetPolicyRequest18sp1()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest18sp1(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse18sp1()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy, emergencyClidPolicy,
    allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowDepartmentCLIDNameOverride) The useGroupMediaSetting attribute controls the Media
    settings (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting
    attribute controls the Call Limits settings (useMaxSimultaneousCalls,
    maxSimultaneousCalls, useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The following elements are only used in AS data
    mode: useGroupDCLIDSetting enableDialableCallerID allowDepartmentCLIDNameOverride
    enterpriseCallsCLIDPolicy groupCallsCLIDPolicy Replaced by:
    ``GroupCallProcessingGetPolicyRequest19sp1()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest19sp1(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse19sp1()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy, emergencyClidPolicy,
    allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowDepartmentCLIDNameOverride) The useGroupMediaSetting attribute controls the Media
    settings (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting
    attribute controls the Call Limits settings (useMaxSimultaneousCalls,
    maxSimultaneousCalls, useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The following elements are only used in AS data
    mode: useGroupDCLIDSetting enableDialableCallerID allowDepartmentCLIDNameOverride
    enterpriseCallsCLIDPolicy groupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallProcessingModifyPolicyRequest14(OCIRequest):
    """
    Modify the group level data associated with Call Procesing Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Replaced By : ``GroupCallProcessingModifyPolicyRequest15()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_group_setting", "useGroupSetting", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("media_policy_selection", "mediaPolicySelection", str),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
        ),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useGroupSetting
    use_group_setting = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int, required=False, mutable=False,
    )
    #: str: *Optional* mediaPolicySelection
    media_policy_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=False, mutable=False,
    )


class GroupCallProcessingModifyPolicyRequest14sp7(OCIRequest):
    """
    Modify the group level data associated with Call Procesing Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. The
    useGroupCLIDSetting attribute controls the CLID settings (clidPolicy,
    emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity, useGroupName) The
    useGroupMediaSetting attribute controls the Media settings (medisPolicySelection,
    supportedMediaSetName) The useGroupCallLimitsSetting attribute controls the Call
    Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    Replaced By: ``GroupCallProcessingModifyPolicyRequest15sp2()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_group_clid_setting", "useGroupCLIDSetting", bool),
        E("use_group_media_setting", "useGroupMediaSetting", bool),
        E("use_group_call_limits_setting", "useGroupCallLimitsSetting", bool),
        E("use_group_translation_routing_setting", "useGroupTranslationRoutingSetting", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("media_policy_selection", "mediaPolicySelection", str),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
        ),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
        E("clid_policy", "clidPolicy", str),
        E("emergency_clid_policy", "emergencyClidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("use_group_name", "useGroupName", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useGroupCLIDSetting
    use_group_clid_setting = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useGroupMediaSetting
    use_group_media_setting = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int, required=False, mutable=False,
    )
    #: str: *Optional* mediaPolicySelection
    media_policy_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=False, mutable=False,
    )
    #: str: *Optional* clidPolicy
    clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useGroupName
    use_group_name = Field(type=bool, required=False, mutable=False)


class GroupCallProcessingModifyPolicyRequest15(OCIRequest):
    """
    Modify the group level data associated with Call Procesing Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Replaced By: ``GroupCallProcessingModifyPolicyRequest15sp2()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_group_setting", "useGroupSetting", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("media_policy_selection", "mediaPolicySelection", str),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useGroupSetting
    use_group_setting = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int, required=False, mutable=False,
    )
    #: str: *Optional* mediaPolicySelection
    media_policy_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=False, mutable=False,
    )


class GroupCallProcessingModifyPolicyRequest15sp2(OCIRequest):
    """
    Modify the group level data associated with Call Procesing Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. The
    useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy, emergencyClidPolicy,
    allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowConfigurableCLIDForRedirectingIdentity, allowDepartmentCLIDNameOverride) The
    allowDepartmentCLID attribute is automatically set to false when the useGroupName
    attribute is set to false.  The useGroupMediaSetting attribute controls the Media
    settings (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting
    attribute controls the Call Limits settings (useMaxSimultaneousCalls,
    maxSimultaneousCalls, useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The useGroupDCLIDSetting controls the Dialable
    Caller ID settings (enableDialableCallerID) The following elements are only used in AS
    data mode: useGroupDCLIDSetting enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity allowDepartmentCLIDNameOverride
    allowConfigurableCLIDForRedirectingIdentity enterpriseCallsCLIDPolicy
    groupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_group_clid_setting", "useGroupCLIDSetting", bool),
        E("use_group_media_setting", "useGroupMediaSetting", bool),
        E("use_group_call_limits_setting", "useGroupCallLimitsSetting", bool),
        E("use_group_translation_routing_setting", "useGroupTranslationRoutingSetting", bool),
        E("use_group_dclid_setting", "useGroupDCLIDSetting", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("media_policy_selection", "mediaPolicySelection", str),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
        E("clid_policy", "clidPolicy", str),
        E("emergency_clid_policy", "emergencyClidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("use_group_name", "useGroupName", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("allow_department_clid_name_override", "allowDepartmentCLIDNameOverride", bool),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("group_calls_clid_policy", "groupCallsCLIDPolicy", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useGroupCLIDSetting
    use_group_clid_setting = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useGroupMediaSetting
    use_group_media_setting = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useGroupDCLIDSetting
    use_group_dclid_setting = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int, required=False, mutable=False,
    )
    #: str: *Optional* mediaPolicySelection
    media_policy_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=False, mutable=False,
    )
    #: str: *Optional* clidPolicy
    clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useGroupName
    use_group_name = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* groupCallsCLIDPolicy
    group_calls_clid_policy = Field(type=str, required=False, mutable=False)


class GroupCallRecordingGetRequest(OCIRequest):
    """
    Get the Call Recording platform for a group.

    The response is either a ``GroupCallRecordingGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallRecordingModifyRequest(OCIRequest):
    """
    Modify the Call Recording platform assignment for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* name
    name = Field(type=str, required=False, mutable=False)


class GroupCallingLineIdGetRequest(OCIRequest):
    """
    Get the calling line id settings for a group.

    The response is either a ``GroupCallingLineIdGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallingLineIdModifyRequest(OCIRequest):
    """
    Modify the calling line id settings for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_group_number", "useGroupNumber", bool),
        E("use_group_name", "useGroupName", bool),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useGroupNumber
    use_group_number = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useGroupName
    use_group_name = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(type=str, required=False, mutable=False)


class GroupCallingPlanAddDigitPatternRequest(OCIRequest):
    """
    Add a new calling plan digit string.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("digit_pattern", "digitPattern", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* digitPattern
    digit_pattern = Field(type=str, required=True, mutable=False)


class GroupCallingPlanDeleteDigitPatternListRequest(OCIRequest):
    """
    Delete one or more calling plan digit strings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupCallingPlanGetDigitPatternListRequest(OCIRequest):
    """
    Get the list of calling plan digit strings for a group.

    The response is either a ``GroupCallingPlanGetDigitPatternListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCallingPlanModifyDigitPatternRequest(OCIRequest):
    """
    Modify a calling plan digit string.

    The name is a key; it cannot be changed.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("digit_pattern", "digitPattern", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* digitPattern
    digit_pattern = Field(type=str, required=False, mutable=False)


class GroupCollaborateBridgeDeleteInstanceRequest(OCIRequest):
    """
    Delete a collaborate bridge from a group.

    The request fails when attempting to delete the default collaborate bridge.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCollaborateBridgeGetInstanceListRequest(OCIRequest):
    """
    Get a list of collaborate bridges within a group.

    The response is either ``GroupCollaborateBridgeGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("department_name", "departmentName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* departmentName
    department_name = Field(type=str, required=False, mutable=False)


class GroupCollaborateBridgeGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a collaborate bridge.

    The response is either ``GroupCollaborateBridgeGetInstanceResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupCommPilotCallManagerGetRequest(OCIRequest):
    """
    Request the group level data associated with CommPilot Call Manager.

    The response is either a ``GroupCommPilotCallManagerGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCommPilotCallManagerModifyRequest(OCIRequest):
    """
    Modify the group level data associated with CommPilot Call Manager.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_directory", "groupDirectory", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* groupDirectory
    group_directory = Field(type=str, required=False, mutable=False)


class GroupCommonPhoneListDeleteListRequest(OCIRequest):
    """
    Delete one or more entries from a group's common phone list.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("entry_name", "entryName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* entryName
    entry_name = Field(type=str, required=True, mutable=False)


class GroupCommonPhoneListModifyRequest(OCIRequest):
    """
    Modify an entry in a group's common phone list.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("entry_name", "entryName", str, is_required=True),
        E("new_entry_name", "newEntryName", str),
        E("phone_number", "phoneNumber", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* entryName
    entry_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* newEntryName
    new_entry_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)


class GroupCommunicationBarringAuthorizationCodeDeleteListRequest(OCIRequest):
    """
    Delete a list of Communication Barring Authorization codes from a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)


class GroupCommunicationBarringAuthorizationCodeGetListRequest(OCIRequest):
    """
    Get a list of Communication Barring Authorization Codes for a group.

    The response is either a
    ``GroupCommunicationBarringAuthorizationCodeGetListResponse()`` or an
    ``ErorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCommunicationBarringGetRequest(OCIRequest):
    """
    Gets Communication Barring setting for a group.

    The response is either a ``GroupCommunicationBarringGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCommunicationBarringModifyRequest(OCIRequest):
    """
    Gets Communication Barring setting for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_default_service_provider_profile", "useDefaultServiceProviderProfile", bool),
        E("profile", "profile", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useDefaultServiceProviderProfile
    use_default_service_provider_profile = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* profile
    profile = Field(type=str, required=False, mutable=False)


class GroupCommunicationBarringProfileGetAssignedListRequest(OCIRequest):
    """
    Get the list of all communication barring profiles assigned to the group.

    The response is either a ``GroupCommunicationBarringProfileGetAssignedListResponse()``
    or an ``ErrorResponse()``. This command only applies to groups in an Enterprise.  This
    command will fail for groups in a Service Provider.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCustomContactDirectoryAddRequest(OCIRequest):
    """
    Adds a Custom Contact Directory to a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. Replace by:
    ``GroupCustomContactDirectoryAddRequest17()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("user_id", "userId", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* userId
    user_id = Field(type=str, required=False, mutable=False)


class GroupCustomContactDirectoryDeleteRequest(OCIRequest):
    """
    Deletes a Custom Contact Directory to a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupCustomContactDirectoryGetListRequest(OCIRequest):
    """
    Gets the list of Custom Contact Directories for a group.

    The response is either ``GroupCustomContactDirectoryGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCustomContactDirectoryGetRequest(OCIRequest):
    """
    Gets a Custom Contact Directory in a group.

    The response is either ``GroupCustomContactDirectoryGetResponse()`` or
    ``ErrorResponse()``. Replace by: ``GroupCustomContactDirectoryGetRequest17()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupCustomRingbackGroupGetRequest(OCIRequest):
    """
    Get the group's custom ring back service settings.

    The response is either a ``GroupCustomRingbackGroupGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced By: ``GroupCustomRingbackGroupGetRequest16()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCustomRingbackGroupGetRequest16(OCIRequest):
    """
    Get the group's custom ring back service settings.

    The response is either a ``GroupCustomRingbackGroupGetResponse16()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupCustomRingbackGroupGetRequest20(OCIRequest):
    """
    Get the group's custom ring back service settings.

    The response is either a ``GroupCustomRingbackGroupGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupDeleteRequest(OCIRequest):
    """
    Delete a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupDepartmentAdminDeleteRequest(OCIRequest):
    """
    Delete a group department administrator.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupDepartmentAdminGetRequest(OCIRequest):
    """
    Get a group department administrators profile.

    The response is either a ``GroupDepartmentAdminGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupDepartmentAdminModifyRequest(OCIRequest):
    """
    Modify a group department administrator.

    Since old password is not specified here, any password rule related to old password
    does not apply.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("password", "password", str),
        E("language", "language", str),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* firstName
    first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* lastName
    last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)


class GroupDepartmentDeleteRequest(OCIRequest):
    """
    Delete a department from a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("department_name", "departmentName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)


class GroupDepartmentGetAvailableParentListRequest(OCIRequest):
    """
    Get a list of departments that could be the parent department of the specified
    department.

    The department itself and all its descendents are not eligible to be the parent
    department.  If the group belongs to an enterprise, it also returns the departments
    defined in the enterprise it belongs to.

    The response is either ``GroupDepartmentGetAvailableParentListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("department_name", "departmentName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)


class GroupDepartmentGetListRequest(OCIRequest):
    """
    Request a list of departments in a group.

    You may request only the list of departments defined at the group-level, or you may
    request the list of all departments in the group including all the departments defined
    within the enterprise the group belongs to.

    The response is either ``GroupDepartmentGetListResponse()`` or ``ErrorResponse()``.
    Replaced by: ``GroupDepartmentGetListRequest18()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E(
            "include_enterprise_departments", "includeEnterpriseDepartments", bool,
            is_required=True,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Required* includeEnterpriseDepartments
    include_enterprise_departments = Field(type=bool, required=True, mutable=False)


class GroupDepartmentGetListRequest18(OCIRequest):
    """
    Request a list of departments in a group.

    You may request only the list of departments defined at the group-level, or you may
    request the list of all departments in the group including all the departments defined
    within the enterprise the group belongs to.

    The response is either ``GroupDepartmentGetListResponse18()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E(
            "include_enterprise_departments", "includeEnterpriseDepartments", bool,
            is_required=True,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Required* includeEnterpriseDepartments
    include_enterprise_departments = Field(type=bool, required=True, mutable=False)


class GroupDepartmentGetRequest(OCIRequest):
    """
    Request the attributes of a department.

    The response is either a ``GroupDepartmentGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("department_name", "departmentName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)


class GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupRequest(OCIRequest):
    """
    Request the number of access device of a particular device type and group.

    If countOnlyResetSupportedDevice is true, count only access devices if the device type
    supports reset.  Devices are counted only if their device type supports Device
    Management.  An error is returned if deviceType is specified but does not support
    device management.

    The response is either
    ``GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
        E("count_only_reset_supported_device", "countOnlyResetSupportedDevice", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* countOnlyResetSupportedDevice
    count_only_reset_supported_device = Field(type=bool, required=False, mutable=False)


class GroupDeviceManagementInProgressAndPendingEventCancelRequest(OCIRequest):
    """
    Cancel pending and in progress events.

    A list of individual events can be canceled.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("event_id", "eventId", int, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: int: *Required* eventId
    event_id = Field(type=int, required=True, mutable=False)


class GroupDeviceTypeCustomTagAddRequest(OCIRequest):
    """
    Request to add a static configuration tag for an access device type used in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
        E("tag_value", "tagValue", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* tagName
    tag_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* tagValue
    tag_value = Field(type=str, required=False, mutable=False)


class GroupDeviceTypeCustomTagDeleteListRequest(OCIRequest):
    """
    Request to delete static configuration tags for an access device type used in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* tagName
    tag_name = Field(type=str, required=True, mutable=False)


class GroupDeviceTypeCustomTagGetListRequest(OCIRequest):
    """
    Request to get the list of custom configuration tags managed by the Device Management
    System, on a per-device type basis for a group.

    The response is either ``GroupDeviceTypeCustomTagGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)


class GroupDeviceTypeCustomTagModifyRequest(OCIRequest):
    """
    Request to modify a static configuration tag for an access device type used in a
    group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
        E("tag_value", "tagValue", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* tagName
    tag_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* tagValue
    tag_value = Field(type=str, required=False, mutable=False)


class GroupDeviceTypeFileGetListRequest(OCIRequest):
    """
    Request to get the list of device type files managed by the Device Management System,
    on a per-group basis.

    The response is either ``GroupDeviceTypeFileGetListResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupDeviceTypeFileGetListRequest14sp8()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)


class GroupDeviceTypeFileGetListRequest14sp8(OCIRequest):
    """
    Request to get the list of device type files managed by the Device Management System,
    on a per-group basis.

    The response is either ``GroupDeviceTypeFileGetListResponse14sp8()`` or
    ``ErrorResponse()``. Replaced by: ``GroupDeviceTypeFileGetListRequest21()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)


class GroupDeviceTypeFileGetListRequest21(OCIRequest):
    """
    Request to get the list of device type files managed by the Device Management System,
    on a per-group basis.

    The response is either ``GroupDeviceTypeFileGetListResponse21()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)


class GroupDeviceTypeFileGetRequest(OCIRequest):
    """
    Request to get a group device type file.

    The response is either ``GroupDeviceTypeFileGetResponse()`` or ``ErrorResponse()``.

    Replaced By: ``GroupDeviceTypeFileGetRequest14sp8()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
        E("file_type", "fileType", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileType
    file_type = Field(type=str, required=True, mutable=False)


class GroupDeviceTypeFileGetRequest14sp8(OCIRequest):
    """
    Request to get a group device type file.

    The response is either ``GroupDeviceTypeFileGetResponse14sp8()`` or
    ``ErrorResponse()``. Replaced by: ``GroupDeviceTypeFileGetRequest16sp1()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileFormat
    file_format = Field(type=str, required=True, mutable=False)


class GroupDeviceTypeFileGetRequest16sp1(OCIRequest):
    """
    Request to get a group device type file.

    The response is either ``GroupDeviceTypeFileGetResponse16sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileFormat
    file_format = Field(type=str, required=True, mutable=False)


class GroupDialPlanPolicyAddAccessCodeRequest(OCIRequest):
    """
    Request to add a Group level Dial Plan Access Code and its all attribues.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("access_code", "accessCode", str, is_required=True),
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting", bool, is_required=True,
        ),
        E(
            "include_code_for_screening_services", "includeCodeForScreeningServices",
            bool, is_required=True,
        ),
        E("enable_secondary_dial_tone", "enableSecondaryDialTone", bool, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessCode
    access_code = Field(type=str, required=True, mutable=False)
    #: bool: *Required* includeCodeForNetworkTranslationsAndRouting
    include_code_for_network_translations_and_routing = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* includeCodeForScreeningServices
    include_code_for_screening_services = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableSecondaryDialTone
    enable_secondary_dial_tone = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class GroupDialPlanPolicyDeleteAccessCodeRequest(OCIRequest):
    """
    Request to delete a Group level Dial Plan Access Code and its all attribues.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("access_code", "accessCode", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessCode
    access_code = Field(type=str, required=True, mutable=False)


class GroupDialPlanPolicyGetAccessCodeListRequest(OCIRequest):
    """
    Request the Group level data associated with Dial Plan Policy.

    The response is either a ``GroupDialPlanPolicyGetAccessCodeListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupDialPlanPolicyGetAccessCodeRequest(OCIRequest):
    """
    Request access code data associated with Group level Dial Plan Policy access codes.

    The response is either a ``GroupDialPlanPolicyGetAccessCodeResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("access_code", "accessCode", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessCode
    access_code = Field(type=str, required=True, mutable=False)


class GroupDialPlanPolicyGetRequest(OCIRequest):
    """
    Request the Group level data associated with Dial Plan Policy.

    The response is either a ``GroupDialPlanPolicyGetResponse()`` or an
    ``ErrorResponse()``. Replaced by: ``GroupDialPlanPolicyGetRequest17()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupDialPlanPolicyGetRequest17(OCIRequest):
    """
    Request the Group level data associated with Dial Plan Policy.

    The response is either a ``GroupDialPlanPolicyGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupDialPlanPolicyModifyAccessCodeRequest(OCIRequest):
    """
    Request to modify a Group level Dial Plan Access Code and its attribues.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("access_code", "accessCode", str, is_required=True),
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting", bool,
        ),
        E("include_code_for_screening_services", "includeCodeForScreeningServices", bool),
        E("enable_secondary_dial_tone", "enableSecondaryDialTone", bool),
        E("description", "description", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessCode
    access_code = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* includeCodeForNetworkTranslationsAndRouting
    include_code_for_network_translations_and_routing = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* includeCodeForScreeningServices
    include_code_for_screening_services = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableSecondaryDialTone
    enable_secondary_dial_tone = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class GroupDialPlanPolicyModifyRequest(OCIRequest):
    """
    Modify the Group level data associated with Dial Plan Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_setting", "useSetting", str),
        E("requires_access_code_for_public_calls", "requiresAccessCodeForPublicCalls", bool),
        E("allow_e164_public_calls", "allowE164PublicCalls", bool),
        E(
            "prefer_e164_number_format_for_callback_services",
            "preferE164NumberFormatForCallbackServices", bool,
        ),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* useSetting
    use_setting = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* requiresAccessCodeForPublicCalls
    requires_access_code_for_public_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowE164PublicCalls
    allow_e164_public_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* preferE164NumberFormatForCallbackServices
    prefer_e164_number_format_for_callback_services = Field(
        type=bool, required=False, mutable=False,
    )
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(type=str, required=False, mutable=False)
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(type=str, required=False, mutable=False)


class GroupDialableCallerIDCriteriaAddRequest(OCIRequest):
    """
    Add a new Dialable Caller ID Criteria.

    Criteria are added at the bottom of the list with the lowest priority.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("description", "description", str),
        E("prefix_digits", "prefixDigits", str),
        E("match_call_type", "matchCallType", str, is_array=True),
        E(
            "match_alternate_call_indicator", "matchAlternateCallIndicator", str,
            is_array=True,
        ),
        E("match_local_category", "matchLocalCategory", bool, is_required=True),
        E("match_national_category", "matchNationalCategory", bool, is_required=True),
        E("match_interlata_category", "matchInterlataCategory", bool, is_required=True),
        E("match_intralata_category", "matchIntralataCategory", bool, is_required=True),
        E(
            "match_international_category", "matchInternationalCategory", bool,
            is_required=True,
        ),
        E("match_private_category", "matchPrivateCategory", bool, is_required=True),
        E("match_emergency_category", "matchEmergencyCategory", bool, is_required=True),
        E("match_other_category", "matchOtherCategory", bool, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* prefixDigits
    prefix_digits = Field(type=str, required=False, mutable=False)
    #: list(str): *Optional* matchCallType  *Array*
    match_call_type = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* matchAlternateCallIndicator  *Array*
    match_alternate_call_indicator = Field(type=list, required=False, mutable=False)
    #: bool: *Required* matchLocalCategory
    match_local_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchNationalCategory
    match_national_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchInterlataCategory
    match_interlata_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchIntralataCategory
    match_intralata_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchInternationalCategory
    match_international_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchPrivateCategory
    match_private_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchEmergencyCategory
    match_emergency_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchOtherCategory
    match_other_category = Field(type=bool, required=True, mutable=False)


class GroupDialableCallerIDCriteriaDeleteRequest(OCIRequest):
    """
    Delete a Dialable Caller ID Criteria.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupDialableCallerIDCriteriaGetRequest(OCIRequest):
    """
    Get an existing Dialable Caller ID Criteria.

    The response is either a ``GroupDialableCallerIDCriteriaGetRequest()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupDialableCallerIDGetRequest(OCIRequest):
    """
    Get the Group’s Dialable Caller ID settings and criteria list.

    The response is either a ``GroupDialableCallerIDGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupDigitCollectionGetRequest13mp4(OCIRequest):
    """
    Request the group's digit collection attributes.

    The response is either a ``GroupDigitCollectionGetResponse13mp4()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupDigitCollectionModifyRequest(OCIRequest):
    """
    Modifies the group's digit collection attributes.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_setting", "useSetting", str),
        E("access_code", "accessCode", str),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* useSetting
    use_setting = Field(type=str, required=False, mutable=False)
    #: str: *Optional* accessCode
    access_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(type=str, required=False, mutable=False)
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(type=str, required=False, mutable=False)


class GroupDirectoryNumberHuntingGetAvailableUserListRequest(OCIRequest):
    """
    Request to get the agents of a call center or hunt group that are available to be
    assigned to a directory number hunting group.

    They are agents that are not already assigned to any other directory number hunting
    group.

    The response is either ``GroupDirectoryNumberHuntingGetAvailableUserListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupDirectoryNumberHuntingGetRequest(OCIRequest):
    """
    Request to get the properties of the DNH service for a specified serviceUserId.

    It gets the agents of a call center or hunt group that are members of a directory
    number hunting group.  They are agents that are not already assigned to any other
    directory number hunting group.

    The response is either ``GroupDirectoryNumberHuntingGetResponse()`` or
    ``ErrorResponse()``. Replaced by: ``GroupDirectoryNumberHuntingGetRequest17sp1()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupDirectoryNumberHuntingGetRequest17sp1(OCIRequest):
    """
    Request to get the properties of the DNH service for a specified serviceUserId.

    It gets the agents of a call center or hunt group that are members of a directory
    number hunting group.  They are agents that are not already assigned to any other
    directory number hunting group.

    The response is either ``GroupDirectoryNumberHuntingGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupDnGetActivationListRequest(OCIRequest):
    """
    Get the list of activated and deactivated DNs in a group.

    Ranges of DNs with identical assignment and activation properties are coalesced to a
    single table row entry.  Only DNs assigned to a users are listed in the response when
    the number activation Mode is set to "User Activation Enabled" Dns assigned to the
    IMRN pool are not listed in the response.

    The response is either a ``GroupDnGetActivationListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupDnGetAvailableListRequest(OCIRequest):
    """
    Get the list of DNs that are assigned to a group and still available for assignment to
    users or service instances within the group.

    Dns assigned to the IMRN pool are not listed in the response.

    The response is either a ``GroupDnGetAvailableListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupDnGetAvailableRangesListRequest(OCIRequest):
    """
    Get a list of group DNs that are not assigned to user, service instances or IMRN pool.

    The Dns are returned in a list of DNs or DN ranges and formated in E164 format for
    display.

    The response is either a ``GroupDnGetAvailableRangeListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupDnGetDetailedAvailableListRequest(OCIRequest):
    """
    Get the list of DNs that are assigned to a group and still available for assignment to
    users within the group with the department name, if the DN is assigned to the
    department.

    Dns assigned to the IMRN pool are not listed in the response.

    The response is either a ``GroupDnGetDetailedAvailableListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupDnGetListRequest(OCIRequest):
    """
    Get the list of DNs that are assigned to a group.

    Dns assigned to the IMRN pool are not listed in the response.

    The response is either a ``GroupDnGetListResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupDnGetSummaryListRequest(OCIRequest):
    """
    Get the list of assigned and unassigned DN ranges in a group.

    Dns assigned to the IMRN pool are not listed in the response.

    The response is either a ``GroupDnGetSummaryListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupDomainAssignListRequest(OCIRequest):
    """
    Assign a list of domains to a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("domain", "domain", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* domain
    domain = Field(type=str, required=True, mutable=False)


class GroupDomainGetAssignedListRequest(OCIRequest):
    """
    Requests the list of all domains assigned to a group.

    The response is either ``GroupDomainGetAssignedListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupDomainUnassignListRequest(OCIRequest):
    """
    Unassign a list of domains from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("domain", "domain", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* domain
    domain = Field(type=str, required=True, mutable=False)


class GroupEmergencyZonesGetHomeZoneListRequest(OCIRequest):
    """
    Request the group level data associated with Emergency Zones.

    The response is either a ``GroupEmergencyZonesGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupEmergencyZonesGetRequest(OCIRequest):
    """
    Request the group level data associated with Emergency Zones.

    The response is either a ``GroupEmergencyZonesGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupEmergencyZonesModifyHomeZoneListRequest(OCIRequest):
    """
    Modify a list of home zones and/or home zone ranges.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E(
            "home_zone_ip_address_list", "homeZoneIpAddressList", str, is_complex=True,
            is_array=True,
        ),  # unknown
        E(
            "home_zone_ip_address_range_list", "homeZoneIpAddressRangeList", str,
            is_complex=True, is_array=True,
        ),  # unknown
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* homeZoneIpAddressList  *Array*
    home_zone_ip_address_list = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* homeZoneIpAddressRangeList  *Array*
    home_zone_ip_address_range_list = Field(type=list, required=False, mutable=False)


class GroupEmergencyZonesModifyRequest(OCIRequest):
    """
    Modify the group level data associated with Emergency Zones.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("is_active", "isActive", bool),
        E("emergency_zones_prohibition", "emergencyZonesProhibition", str),
        E("send_emergency_call_notify_email", "sendEmergencyCallNotifyEmail", bool),
        E("emergency_call_notify_email_address", "emergencyCallNotifyEmailAddress", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* isActive
    is_active = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* emergencyZonesProhibition
    emergency_zones_prohibition = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* sendEmergencyCallNotifyEmail
    send_emergency_call_notify_email = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* emergencyCallNotifyEmailAddress
    emergency_call_notify_email_address = Field(type=str, required=False, mutable=False)


class GroupEnterpriseTrunkAddRequest(OCIRequest):
    """
    Request to add an enterprise trunk in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Replaced by:
    ``GroupEnterpriseTrunkAddRequest21()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int, is_required=True),
        E("route_exhaustion_action", "routeExhaustionAction", str, is_required=True),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)
    #: int: *Required* maximumRerouteAttempts
    maximum_reroute_attempts = Field(type=int, required=True, mutable=False)
    #: str: *Required* routeExhaustionAction
    route_exhaustion_action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* orderedRouting
    ordered_routing = Field(type=str, required=False, mutable=False)
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(type=str, required=False, mutable=False)


class GroupEnterpriseTrunkAddRequest21(OCIRequest):
    """
    Request to add an enterprise trunk in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int, is_required=True),
        E("route_exhaustion_action", "routeExhaustionAction", str, is_required=True),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
        E("enable_capacity_management", "enableCapacityManagement", bool, is_required=True),
        E("max_active_calls", "maxActiveCalls", int),
        E("capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls", int),
        E("capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)
    #: int: *Required* maximumRerouteAttempts
    maximum_reroute_attempts = Field(type=int, required=True, mutable=False)
    #: str: *Required* routeExhaustionAction
    route_exhaustion_action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* orderedRouting
    ordered_routing = Field(type=str, required=False, mutable=False)
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(type=str, required=False, mutable=False)
    #: bool: *Required* enableCapacityManagement
    enable_capacity_management = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* maxActiveCalls
    max_active_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(type=int, required=False, mutable=False)


class GroupEnterpriseTrunkAddUserListRequest(OCIRequest):
    """
    Request to add users to an enterprise trunk in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupEnterpriseTrunkDeleteRequest(OCIRequest):
    """
    Request to delete an enterprise trunk in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)


class GroupEnterpriseTrunkDeleteUserListRequest(OCIRequest):
    """
    Request to delete users from an enterprise trunk in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupEnterpriseTrunkForceAssignUserListRequest(OCIRequest):
    """
    Request to add users to an enterprise trunk in a group.

    If the user is already assigned to another enterprise trunk, it will be unassigned
    from the old enterprise trunk and assigned to the new enterprise trunk specified in
    this request.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class GroupEnterpriseTrunkGetListRequest(OCIRequest):
    """
    Request to get the list of all enterprise trunks defined in a group.

    The response is either a ``GroupEnterpriseTrunkGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupEnterpriseTrunkGetRequest(OCIRequest):
    """
    Request to get an enterprise trunk The response is either an
    ``GroupEnterpriseTrunkGetResponse()`` or an ``ErrorResponse()``.

    Replaced by: ``GroupEnterpriseTrunkGetRequest21()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)


class GroupEnterpriseTrunkGetRequest21(OCIRequest):
    """
    Request to get an enterprise trunk The response is either an
    ``GroupEnterpriseTrunkGetResponse21()`` or an ``ErrorResponse()``.

    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)


class GroupEnterpriseTrunkModifyRequest(OCIRequest):
    """
    Request to modify an enterprise trunk in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("new_enterprise_trunk_name", "newEnterpriseTrunkName", str),
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int),
        E("route_exhaustion_action", "routeExhaustionAction", str),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
        E("enable_capacity_management", "enableCapacityManagement", bool),
        E("max_active_calls", "maxActiveCalls", int),
        E("capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls", int),
        E("capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* newEnterpriseTrunkName
    new_enterprise_trunk_name = Field(type=str, required=False, mutable=False)
    #: int: *Optional* maximumRerouteAttempts
    maximum_reroute_attempts = Field(type=int, required=False, mutable=False)
    #: str: *Optional* routeExhaustionAction
    route_exhaustion_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* orderedRouting
    ordered_routing = Field(type=str, required=False, mutable=False)
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableCapacityManagement
    enable_capacity_management = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxActiveCalls
    max_active_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(type=int, required=False, mutable=False)


class GroupExchangeIntegrationGetRequest(OCIRequest):
    """
    Request the group level configuration for Exchange Integration.

    The response is either a ``GroupExchangeIntegrationGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupExistingUsersAssignUserServiceListRequest(OCIRequest):
    """
    Request to assign the user services and service packs to all existing users within the
    group.

    BroadSoft recommends using this command only for small groups with less than 100
    users.  This command will return an error if the group has over 500 users.  The
    recommended way to bulk assign/unassign services is Service Pack Migration.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_name", "serviceName", str, is_array=True),
        E("service_pack_name", "servicePackName", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* serviceName  *Array*
    service_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(type=list, required=False, mutable=False)


class GroupExistingUsersUnassignUserServiceListRequest(OCIRequest):
    """
    Requests to unassign the user services and service packs for all existing users within
    the group.

    BroadSoft recommends using this command only for small groups with less than 100
    users.  This command will return an error if the group has over 500 users.  The
    recommended way to bulk assign/unassign services is Service Pack Migration.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_name", "serviceName", str, is_array=True),
        E("service_pack_name", "servicePackName", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* serviceName  *Array*
    service_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(type=list, required=False, mutable=False)


class GroupExtensionLengthGetRequest(OCIRequest):
    """
    Request the group's extension length.

    The response is either a ``GroupExtensionLengthGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupExtensionLengthGetRequest17(OCIRequest):
    """
    Request the group's extension length.

    The response is either a ``GroupExtensionLengthGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupExtensionLengthModifyRequest(OCIRequest):
    """
    Modify the group's extension length.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("extension_length", "extensionLength", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: int: *Optional* extensionLength
    extension_length = Field(type=int, required=False, mutable=False)


class GroupExtensionLengthModifyRequest17(OCIRequest):
    """
    Modify the group's extension length range.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("min_extension_length", "minExtensionLength", int),
        E("max_extension_length", "maxExtensionLength", int),
        E("default_extension_length", "defaultExtensionLength", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: int: *Optional* minExtensionLength
    min_extension_length = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxExtensionLength
    max_extension_length = Field(type=int, required=False, mutable=False)
    #: int: *Optional* defaultExtensionLength
    default_extension_length = Field(type=int, required=False, mutable=False)


class GroupFeatureAccessCodeGetListRequest(OCIRequest):
    """
    Get the list of feature access codes for a group.

    The response is either a ``GroupFeatureAccessCodeGetListResponse()`` or an
    ``ErrorResponse()``. Replaced by: ``GroupFeatureAccessCodeGetRequest()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupFeatureAccessCodeGetRequest(OCIRequest):
    """
    Get group FAC code level and the list of feature access codes for a group.

    The response is either a ``GroupFeatureAccessCodeGetResponse()`` or an
    ``ErrorResponse()``. Returned Feature Access Codes may be group specific, or Service
    Provider Feature Access Codes, depending on FAC code level.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupFeatureAccessCodeGetRequest20(OCIRequest):
    """
    Get group FAC code level and the list of feature access codes for a group.

    The response is either a ``GroupFeatureAccessCodeGetResponse20()`` or an
    ``ErrorResponse()``. Returned Feature Access Codes may be group specific, or Service
    Provider Feature Access Codes, depending on FAC code level.  In release 20 the "Call
    Recording" FAC name is changed to "Call Recording - Start". Replaced by:
    ``GroupFeatureAccessCodeGetRequest21()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupFeatureAccessCodeGetRequest21(OCIRequest):
    """
    Get group FAC code level and the list of feature access codes for a group.

    The response is either a ``GroupFeatureAccessCodeGetResponse20()`` or an
    ``ErrorResponse()``. Returned Feature Access Codes may be group specific, or Service
    Provider Feature Access Codes, depending on FAC code level.  In release 20 the "Call
    Recording" FAC name is changed to "Call Recording - Start".
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupFileRepositoryDeviceUserAddRequest(OCIRequest):
    """
    Add a new group file repository user.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
        E("user_name", "userName", str, is_required=True),
        E("password", "password", str, is_required=True),
        E("allow_put", "allowPut", bool, is_required=True),
        E("allow_delete", "allowDelete", bool, is_required=True),
        E("allow_get", "allowGet", bool, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* userName
    user_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* password
    password = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowPut
    allow_put = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowDelete
    allow_delete = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowGet
    allow_get = Field(type=bool, required=True, mutable=False)


class GroupFileRepositoryDeviceUserDeleteRequest(OCIRequest):
    """
    Delete a group file repository user.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
        E("user_name", "userName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* userName
    user_name = Field(type=str, required=True, mutable=False)


class GroupFileRepositoryDeviceUserGetListRequest(OCIRequest):
    """
    Request the list of group users for a file repository in the system.

    The response is either a ``GroupFileRepositoryDeviceUserGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(type=str, required=True, mutable=False)


class GroupFileRepositoryDeviceUserModifyRequest(OCIRequest):
    """
    Modify a group file repository user.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
        E("user_name", "userName", str, is_required=True),
        E("password", "password", str),
        E("allow_put", "allowPut", bool),
        E("allow_delete", "allowDelete", bool),
        E("allow_get", "allowGet", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* userName
    user_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowPut
    allow_put = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowDelete
    allow_delete = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowGet
    allow_get = Field(type=bool, required=False, mutable=False)


class GroupFindMeFollowMeAddAlertingGroupRequest(OCIRequest):
    """
    Add an alerting group to a Find-me/Follow-me instance.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("alerting_group_name", "alertingGroupName", str, is_required=True),
        E("alerting_group_description", "alertingGroupDescription", str),
        E("use_diversion_inhibitor", "useDiversionInhibitor", bool, is_required=True),
        E(
            "answer_confirmation_required", "answerConfirmationRequired", bool,
            is_required=True,
        ),
        E("number_of_rings", "numberOfRings", int, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("user_id", "userId", str),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* alertingGroupName
    alerting_group_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* alertingGroupDescription
    alerting_group_description = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useDiversionInhibitor
    use_diversion_inhibitor = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* answerConfirmationRequired
    answer_confirmation_required = Field(type=bool, required=True, mutable=False)
    #: int: *Required* numberOfRings
    number_of_rings = Field(type=int, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userId
    user_id = Field(type=str, required=False, mutable=False)


class GroupFindMeFollowMeDeleteAlertingGroupRequest(OCIRequest):
    """
    Delete an alerting group from a Find-me/Follow-me instance.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("alerting_group_name", "alertingGroupName", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* alertingGroupName
    alerting_group_name = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeDeleteAlertingGroupSelectiveCriteriaRequest(OCIRequest):
    """
    Delete a criteria from the Find-me/Follow-me alerting group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("alerting_group_name", "alertingGroupName", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* alertingGroupName
    alerting_group_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* criteriaName
    criteria_name = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeDeleteInstanceRequest(OCIRequest):
    """
    Delete a Find-me/Follow-me instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeGetAlertingGroupListRequest(OCIRequest):
    """
    Get a list of Find-me/Follow-me alerting groups within a group.

    The response is either ``GroupFindMeFollowMeGetAlertingGroupListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeGetAlertingGroupRequest(OCIRequest):
    """
    Request to get all the information of a Find-me/Follow-me alerting group.

    The response is either ``GroupFindMeFollowMeGetAlertingGroupResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("alerting_group_name", "alertingGroupName", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* alertingGroupName
    alerting_group_name = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeGetAlertingGroupSelectiveCriteriaRequest(OCIRequest):
    """
    Request to get all the information of a specific Find-me/Follow-me alerting group
    selective criteria.

    The response is either ``GroupFindMeFollowMeGetAlertingGroupResponse()`` or
    ``ErrorResponse()``. Replaced by:
    ``GroupFindMeFollowMeGetAlertingGroupSelectiveCriteriaRequest21()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("alerting_group_name", "alertingGroupName", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* alertingGroupName
    alerting_group_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* criteriaName
    criteria_name = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeGetAlertingGroupSelectiveCriteriaRequest21(OCIRequest):
    """
    Request to get all the information of a specific Find-me/Follow-me alerting group
    selective criteria.

    The response is either ``GroupFindMeFollowMeGetAlertingGroupResponse21()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("alerting_group_name", "alertingGroupName", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* alertingGroupName
    alerting_group_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* criteriaName
    criteria_name = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeGetInstanceListRequest(OCIRequest):
    """
    Get a list of Find-me/Follow-me instances within a group.

    The response is either ``GroupFindMeFollowMeGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(type=str, required=False, mutable=False)


class GroupFindMeFollowMeGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a Find-me/Follow-me instance.

    The response is either ``GroupFindMeFollowMeGetInstanceResponse()`` or
    ``ErrorResponse()``. Replaced by: ``GroupFindMeFollowMeGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Find-me/Follow-me instance.

    The response is either ``GroupFindMeFollowMeGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeModifyAlertingGroupListRequest(OCIRequest):
    """
    Modify the priorities assigned to alerting groups The response is either a
    ``SuccessResponse()`` or an ``ErrorResponse()``.

    NOTE: The command fails if all the alerting groups defined for the user are not
    provided.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("alerting_group_name", "alertingGroupName", str),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* alertingGroupName
    alerting_group_name = Field(type=str, required=False, mutable=False)


class GroupFlexibleSeatingAccessDeviceGetListRequest(OCIRequest):
    """
    Requests the list of access devices available for assignment to a flexible seating
    host or guest.

    The list includes devices created at the system, service provider, and group levels
    that support device management.

    The response is either ``GroupFlexibleSeatingAccessDeviceGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupFlexibleSeatingHostDeleteInstanceRequest(OCIRequest):
    """
    Delete a flexible seating host instance from a group.

    Host cannot be deleted when a guest is associated to a host.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupFlexibleSeatingHostGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a flexible seating host instance.

    The response is either ``GroupFlexibleSeatingHostGetInstanceResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupFlexibleSeatingHostGuestAssociationGetRequest(OCIRequest):
    """
    Request the flexible seating host guest association details.

    The response is either a ``GroupFlexibleSeatingHostGuestAssociationGetResponse()`` or
    an ``ErrorResponse()``. accessLevel is always set to Group for a Service Provider
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupFlexibleSeatingHostGuestAssociationModifyRequest(OCIRequest):
    """
    Modify the flexible seating host’s guest association attributes.

    The request fails if enforceAssociationLimit or associationLimitHours are changed when
    the host is associated to a guest.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("enforce_association_limit", "enforceAssociationLimit", bool),
        E("association_limit_hours", "associationLimitHours", int),
        E("access_level", "accessLevel", str),
        E("remove_guest_association", "removeGuestAssociation", bool),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* enforceAssociationLimit
    enforce_association_limit = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* associationLimitHours
    association_limit_hours = Field(type=int, required=False, mutable=False)
    #: str: *Optional* accessLevel
    access_level = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* removeGuestAssociation
    remove_guest_association = Field(type=bool, required=False, mutable=False)


class GroupFlexibleSeatingHostRoutingPoliciesGetRequest(OCIRequest):
    """
    Get a flexible seating host’s routing policies The response is either a
    ``GroupFlexibleSeatingHostRoutingPoliciesGetResponse()`` or an ``ErrorResponse()``.

    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupFlexibleSeatingHostRoutingPoliciesModifyRequest(OCIRequest):
    """
    Modify a flexible seating host’s routing policies The response is either a
    ``SuccessResponse()`` or an ``ErrorResponse()``.

    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("allow_emergency_calls", "allowEmergencyCalls", bool),
        E("allow_calls_to_voice_portal", "allowCallsToVoicePortal", bool),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* allowEmergencyCalls
    allow_emergency_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowCallsToVoicePortal
    allow_calls_to_voice_portal = Field(type=bool, required=False, mutable=False)


class GroupGetDefaultRequest(OCIRequest):
    """
    Request the default profile for a group.

    The response is either a ``GroupGetDefaultResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class GroupGetRequest(OCIRequest):
    """
    Get the profile for a group.

    The response is either a ``GroupGetResponse()`` or an ``ErrorResponse()``.

    Replaced By: ``GroupGetRequest14sp7()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupGetRequest14sp7(OCIRequest):
    """
    Get the profile for a group.

    The response is either a ``GroupGetResponse14sp7()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupGetUserServiceAssignedUserListRequest(OCIRequest):
    """
    Get the list of users assigned the user service or service pack.

    The response is either a ``GroupGetUserServiceAssignedUserListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_name", "serviceName", str),
        E("service_pack_name", "servicePackName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* serviceName
    service_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* servicePackName
    service_pack_name = Field(type=str, required=False, mutable=False)


class GroupGroupNightForwardingGetRequest(OCIRequest):
    """
    Request to get the Group Night Forwarding group parameters.

    The response is either ``GroupGroupNightForwardingGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupGroupPagingAddOriginatorListRequest(OCIRequest):
    """
    Add originator(s) to a paging group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("originator_user_id", "originatorUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* originatorUserId
    originator_user_id = Field(type=str, required=True, mutable=False)


class GroupGroupPagingAddTargetListRequest(OCIRequest):
    """
    Add target(s) to a paging group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("target_user_id", "targetUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* targetUserId
    target_user_id = Field(type=str, required=True, mutable=False)


class GroupGroupPagingDeleteInstanceRequest(OCIRequest):
    """
    Delete a Group Paging instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupGroupPagingDeleteOriginatorListRequest(OCIRequest):
    """
    Delete originator(s) from a paging group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("originator_user_id", "originatorUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* originatorUserId
    originator_user_id = Field(type=str, required=True, mutable=False)


class GroupGroupPagingDeleteTargetListRequest(OCIRequest):
    """
    Delete target(s) from a paging group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("target_user_id", "targetUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* targetUserId
    target_user_id = Field(type=str, required=True, mutable=False)


class GroupGroupPagingGetInstanceListRequest(OCIRequest):
    """
    Get a list of Paging Groups instances within a group.

    The response is either ``GroupGroupPagingGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(type=str, required=False, mutable=False)


class GroupGroupPagingGetInstanceRequest(OCIRequest):
    """
    Replaced By ``GroupGroupPagingGetInstanceRequest17sp3()`` Request to get all the
    information of a Group Paging instance.

    The response is either ``GroupGroupPagingGetInstanceResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupGroupPagingGetInstanceRequest17sp3(OCIRequest):
    """
    Request to get all the information of a Group Paging instance.

    The response is either ``GroupGroupPagingGetInstanceResponse17sp3()`` or
    ``ErrorResponse()``. Replaced by: ``GroupGroupPagingGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupGroupPagingGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Group Paging instance.

    The response is either ``GroupGroupPagingGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupGroupPagingGetOriginatorListRequest(OCIRequest):
    """
    Get a list of originators assigned to a paging group.

    The response is either a ``GroupGroupPagingGetOriginatorListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupGroupPagingGetTargetListRequest(OCIRequest):
    """
    Get a list of targets assigned to a paging group.

    The response is either a ``GroupGroupPagingGetTargetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupGroupPagingTargetsCapacityGetRequest(OCIRequest):
    """
    Request the maximum number of target users per paging group configured for a group.

    The response is either a ``GroupGroupPagingTargetsCapacityGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupGroupPagingTargetsCapacityModifyRequest(OCIRequest):
    """
    Modify the maximum number of target users per paging group configured for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("maximum_target_users", "maximumTargetUsers", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: int: *Optional* maximumTargetUsers
    maximum_target_users = Field(type=int, required=False, mutable=False)


class GroupHolidayScheduleDeleteRequest(OCIRequest):
    """
    Delete a holiday schedule from a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("holiday_schedule_name", "holidayScheduleName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* holidayScheduleName
    holiday_schedule_name = Field(type=str, required=True, mutable=False)


class GroupHolidayScheduleGetListRequest(OCIRequest):
    """
    Get a holiday schedule in a group.

    The response is either a ``GroupHolidayScheduleGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupHolidayScheduleGetRequest(OCIRequest):
    """
    Get a holiday schedule in a group.

    The response is either a ``GroupHolidayScheduleGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("holiday_schedule_name", "holidayScheduleName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* holidayScheduleName
    holiday_schedule_name = Field(type=str, required=True, mutable=False)


class GroupHuntGroupDeleteInstanceRequest(OCIRequest):
    """
    Delete a Hunt Group instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupHuntGroupGetInstanceListRequest(OCIRequest):
    """
    Get a list of Hunt Group instances within a group.

    The response is either ``GroupHuntGroupGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(type=str, required=False, mutable=False)


class GroupHuntGroupGetInstanceRequest14(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either ``GroupHuntGroupGetInstanceResponse14()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupHuntGroupGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either ``GroupHuntGroupGetInstanceResponse17()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupHuntGroupGetInstanceRequest17sp3(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either ``GroupHuntGroupGetInstanceResponse17sp3()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupHuntGroupGetInstanceRequest17sp4(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either ``GroupHuntGroupGetInstanceResponse17sp4()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupHuntGroupGetInstanceRequest19(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either ``GroupHuntGroupGetInstanceResponse19()`` or
    ``ErrorResponse()``. Replaced by: ``GroupHuntGroupGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupHuntGroupGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either ``GroupHuntGroupGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``. Replaced by: ``GroupHuntGroupGetInstanceRequest20()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupHuntGroupGetInstanceRequest20(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either ``GroupHuntGroupGetInstanceResponse20()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupIMRNGetListRequest(OCIRequest):
    """
    Request a summary table of all DNs in a group IMRN pool.

    The response is either ``GroupIMRNGetListResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupIncomingCallingPlanGetListRequest(OCIRequest):
    """
    Request the group's incoming calling plan settings.

    The response is either a ``GroupIncomingCallingPlanGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupInstantGroupCallDeleteInstanceRequest(OCIRequest):
    """
    Request to delete an Instant Group Call service instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupInstantGroupCallGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Instant Group Call service instances within a group.

    The response is either ``GroupInstantGroupCallGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the service instances within a specified
    department.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(type=str, required=False, mutable=False)


class GroupInstantGroupCallGetInstanceRequest14(OCIRequest):
    """
    Request to get all the information of an Instant Group Call service instance.

    The response is either ``GroupInstantGroupCallGetInstanceResponse14()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupInstantGroupCallGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of an Instant Group Call service instance.

    The response is either ``GroupInstantGroupCallGetInstanceResponse17()`` or
    ``ErrorResponse()``. Replaced by: ``GroupInstantGroupCallGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupInstantGroupCallGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of an Instant Group Call service instance.

    The response is either ``GroupInstantGroupCallGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupIntegratedIMPGetRequest(OCIRequest):
    """
    Get the Integrated IMP service attributes for the group.

    The response is either ``GroupIntegratedIMPGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupIntegratedIMPModifyRequest(OCIRequest):
    """
    Modify the Integrated IMP service attributes for the group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_service_provider_setting", "useServiceProviderSetting", bool),
        E("service_domain", "serviceDomain", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useServiceProviderSetting
    use_service_provider_setting = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* serviceDomain
    service_domain = Field(type=str, required=False, mutable=False)


class GroupInterceptGroupGetRequest(OCIRequest):
    """
    Get the group's intercept group service settings.

    The response is either a ``GroupInterceptGroupGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced By: ``GroupInterceptGroupGetRequest16()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupInterceptGroupGetRequest16(OCIRequest):
    """
    Get the group's intercept group service settings.

    The response is either a ``GroupInterceptGroupGetResponse16()`` or an
    ``ErrorResponse()``.

    Replaced By: ``GroupInterceptGroupGetRequest16sp1()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupInterceptGroupGetRequest16sp1(OCIRequest):
    """
    Get the group's intercept group service settings.

    The response is either a ``GroupInterceptGroupGetResponse16sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupInventoryReportGetRequest(OCIRequest):
    """
    Request the group's inventory report.

    The response is either a ``GroupInventoryReportGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("include_users", "includeUsers", bool, is_required=True),
        E("include_services", "includeServices", bool, is_required=True),
        E("include_dns", "includeDns", bool, is_required=True),
        E("include_access_devices", "includeAccessDevices", bool, is_required=True),
        E("include_departments", "includeDepartments", bool, is_required=True),
        E("report_delivery_email_address", "reportDeliveryEmailAddress", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Required* includeUsers
    include_users = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* includeServices
    include_services = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* includeDns
    include_dns = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* includeAccessDevices
    include_access_devices = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* includeDepartments
    include_departments = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* reportDeliveryEmailAddress
    report_delivery_email_address = Field(type=str, required=False, mutable=False)


class GroupLDAPIntegrationGetDirectoryRequest(OCIRequest):
    """
    Get the LDAP directory attributes for a group.

    The response is either a ``GroupLDAPIntegrationGetDirectoryResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupLDAPIntegrationGetRequest(OCIRequest):
    """
    Request the group level data associated with LDAP Integration.

    The response is either a ``GroupLDAPIntegrationGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupLDAPIntegrationModifyDirectoryRequest(OCIRequest):
    """
    Modify the LDAP directory attributes for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_level", "useLevel", str),
        E("server_net_address", "serverNetAddress", str),
        E("server_port", "serverPort", int),
        E("search_base", "searchBase", str),
        E("use_ssl", "useSSL", bool),
        E("require_authentication", "requireAuthentication", bool),
        E("authenticated_dn", "authenticatedDN", str),
        E("authenticated_password", "authenticatedPassword", str),
        E("is_sort_enabled", "isSortEnabled", bool),
        E("is_paged_result_enabled", "isPagedResultEnabled", bool),
        E("search_filter", "searchFilter", str),
        E(
            "include_search_attribute_in_search_filter",
            "includeSearchAttributeInSearchFilter", bool,
        ),
        E("column1_attribute_name", "column1AttributeName", str),
        E("column2_attribute_name", "column2AttributeName", str),
        E("column3_attribute_name", "column3AttributeName", str),
        E("column4_attribute_name", "column4AttributeName", str),
        E("column1_label", "column1Label", str),
        E("column2_label", "column2Label", str),
        E("column3_label", "column3Label", str),
        E("column4_label", "column4Label", str),
        E("search_column", "searchColumn", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* useLevel
    use_level = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serverNetAddress
    server_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* serverPort
    server_port = Field(type=int, required=False, mutable=False)
    #: str: *Optional* searchBase
    search_base = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useSSL
    use_ssl = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* requireAuthentication
    require_authentication = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* authenticatedDN
    authenticated_dn = Field(type=str, required=False, mutable=False)
    #: str: *Optional* authenticatedPassword
    authenticated_password = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* isSortEnabled
    is_sort_enabled = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* isPagedResultEnabled
    is_paged_result_enabled = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* searchFilter
    search_filter = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* includeSearchAttributeInSearchFilter
    include_search_attribute_in_search_filter = Field(
        type=bool, required=False, mutable=False,
    )
    #: str: *Optional* column1AttributeName
    column1_attribute_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column2AttributeName
    column2_attribute_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column3AttributeName
    column3_attribute_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column4AttributeName
    column4_attribute_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column1Label
    column1_label = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column2Label
    column2_label = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column3Label
    column3_label = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column4Label
    column4_label = Field(type=str, required=False, mutable=False)
    #: int: *Optional* searchColumn
    search_column = Field(type=int, required=False, mutable=False)


class GroupLDAPIntegrationModifyRequest(OCIRequest):
    """
    Modify the group level data associated with LDAP Integration.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("is_active", "isActive", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* isActive
    is_active = Field(type=bool, required=False, mutable=False)


class GroupMWIDeliveryToMobileEndpointCustomTemplateDeleteRequest(OCIRequest):
    """
    Delete a MWI Delivery to Mobile Endpoint Custom Template.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("language", "language", str, is_required=True),
        E("type", "type", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* language
    language = Field(type=str, required=True, mutable=False)
    #: str: *Required* type
    type = Field(type=str, required=True, mutable=False)


class GroupMWIDeliveryToMobileEndpointCustomTemplateGetRequest(OCIRequest):
    """
    Request a MWI Delivery to Mobile Endpoint Custom Template.

    The response is either a
    ``GroupMWIDeliveryToMobileEndpointCustomTemplateGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("language", "language", str, is_required=True),
        E("type", "type", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* language
    language = Field(type=str, required=True, mutable=False)
    #: str: *Required* type
    type = Field(type=str, required=True, mutable=False)


class GroupMWIDeliveryToMobileEndpointGetRequest(OCIRequest):
    """
    Requests group MWI custom notifications settings.

    The response is either a ``GroupMWIDeliveryToMobileEndpointGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupMeetMeConferencingDeleteInstanceRequest(OCIRequest):
    """
    Delete a Meet-Me Conferencing bridge from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupMeetMeConferencingGetInstanceListRequest(OCIRequest):
    """
    Get a list of Meet-Me Conferencing instances within a group.

    The response is either ``GroupMeetMeConferencingGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("department_name", "departmentName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* departmentName
    department_name = Field(type=str, required=False, mutable=False)


class GroupMeetMeConferencingGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either ``GroupMeetMeConferencingGetInstanceResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupMeetMeConferencingGetInstanceRequest17sp3(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either ``GroupMeetMeConferencingGetInstanceResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupMeetMeConferencingGetInstanceRequest17sp4(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either ``GroupMeetMeConferencingGetInstanceResponse17sp4()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupMeetMeConferencingGetInstanceRequest18(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either ``GroupMeetMeConferencingGetInstanceResponse18()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupMeetMeConferencingGetInstanceRequest19(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either ``GroupMeetMeConferencingGetInstanceResponse19()`` or
    ``ErrorResponse()``. Replaced by: ``GroupMeetMeConferencingGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupMeetMeConferencingGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either ``GroupMeetMeConferencingGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupMeetMeConferencingGetRequest(OCIRequest):
    """
    Request the group level data associated with Meet-Me Conferencing functions.

    The response is either a ``GroupMeetMeConferencingGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupMusicOnHoldGetDepartmentListRequest(OCIRequest):
    """
    Returns a list of all departments that have a Music On Hold instance.

    The response is either ``GroupMusicOnHoldGetDepartmentListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(type=str, required=False, mutable=False)


class GroupNetworkClassOfServiceAssignListRequest(OCIRequest):
    """
    Assign a list of Network Classes of Service to a group.

    The Element defaultNetworkClassOfService is required only for the first assignment,
    for subsequent assignments it is optional.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_array=True),
        E("default_network_class_of_service", "defaultNetworkClassOfService", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* networkClassOfService  *Array*
    network_class_of_service = Field(type=list, required=False, mutable=False)
    #: str: *Optional* defaultNetworkClassOfService
    default_network_class_of_service = Field(type=str, required=False, mutable=False)


class GroupNetworkClassOfServiceAssignToAllUsersRequest(OCIRequest):
    """
    Assign a Network Classes of Service to all users with in a group.

    The Network Classes of Service must be currently assigned to the group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* networkClassOfService
    network_class_of_service = Field(type=str, required=True, mutable=False)


class GroupNetworkClassOfServiceGetAssignedListRequest(OCIRequest):
    """
    Get a list of Network Classes of Service assigned to a group.

    The response is either a ``GroupNetworkClassOfServiceGetAssignedListResponse()`` or an
    ``ErorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupNetworkClassOfServiceModifyDefaultRequest(OCIRequest):
    """
    Modifies the default Network Classes of Service of a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* networkClassOfService
    network_class_of_service = Field(type=str, required=True, mutable=False)


class GroupNetworkClassOfServiceUnassignListRequest(OCIRequest):
    """
    Unassign a list of Network Classes of Service from a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_array=True),
        E("default_network_class_of_service", "defaultNetworkClassOfService", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* networkClassOfService  *Array*
    network_class_of_service = Field(type=list, required=False, mutable=False)
    #: str: *Optional* defaultNetworkClassOfService
    default_network_class_of_service = Field(type=str, required=False, mutable=False)


class GroupNewUserTemplateAssignUserServiceListRequest(OCIRequest):
    """
    Request to assign the user services and service packs to all new users created within
    the group after the completion of this request.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_name", "serviceName", str, is_array=True),
        E("service_pack_name", "servicePackName", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* serviceName  *Array*
    service_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(type=list, required=False, mutable=False)


class GroupNewUserTemplateUnassignUserServiceListRequest(OCIRequest):
    """
    Requests to unassign the user services and service packs for all new users created
    within the group after the completion of this request.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_name", "serviceName", str, is_array=True),
        E("service_pack_name", "servicePackName", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* serviceName  *Array*
    service_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(type=list, required=False, mutable=False)


class GroupOfficeZoneAssignListRequest(OCIRequest):
    """
    Assign a list of Office Zones to a group.

    The Element defaultOfficeZone is required only for the first assignment, for
    subsequent assignments it is optional.  Office Zones can only be assigned if the
    Location-Based Calling Restrictions has been authorized to the group otherwise the
    request will fail.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("office_zone_name", "officeZoneName", str, is_array=True),
        E("default_office_zone_name", "defaultOfficeZoneName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* officeZoneName  *Array*
    office_zone_name = Field(type=list, required=False, mutable=False)
    #: str: *Optional* defaultOfficeZoneName
    default_office_zone_name = Field(type=str, required=False, mutable=False)


class GroupOfficeZoneGetAssignedListRequest(OCIRequest):
    """
    Get a list of Office Zones assigned to a group.

    The response is either a ``GroupOfficeZoneGetAssignedListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupOfficeZoneUnassignListRequest(OCIRequest):
    """
    Unassign a list of OfficeZones from a group.

    Note: a new default must be provided if unassigning the current default.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("office_zone_name", "officeZoneName", str, is_array=True),
        E("default_office_zone_name", "defaultOfficeZoneName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* officeZoneName  *Array*
    office_zone_name = Field(type=list, required=False, mutable=False)
    #: str: *Optional* defaultOfficeZoneName
    default_office_zone_name = Field(type=str, required=False, mutable=False)


class GroupOutgoingCallingPlanAuthorizationCodeGetListRequest(OCIRequest):
    """
    Request the list of authorization codes for a group default and it's departments.

    The response is either a
    ``GroupOutgoingCallingPlanAuthorizationCodeGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanCallMeNowGetListRequest(OCIRequest):
    """
    Request the Call Me Now call permissions for a group default and it's departments.

    The response is either a ``GroupOutgoingCallingPlanCallMeNowGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanDigitPlanCallMeNowGetListRequest(OCIRequest):
    """
    Request the Call Me Now call permissions for digit patterns for a group default and
    it's departments.

    The response is either a
    ``GroupOutgoingCallingPlanDigitPlanCallMeNowGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanDigitPlanOriginatingGetListRequest(OCIRequest):
    """
    Request the originating permissions for digit patterns for a group default and it's
    departments.

    The response is either a
    ``GroupOutgoingCallingPlanDigitPlanOriginatingGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanDigitPlanRedirectingGetListRequest(OCIRequest):
    """
    Request the redirecting permissions for digit patterns for a group default and it's
    departments.

    The response is either a
    ``GroupOutgoingCallingPlanDigitPlanRedirectingGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanOriginatingGetListRequest(OCIRequest):
    """
    Request the originating permissions for a group default and it's departments.

    The response is either a ``GroupOutgoingCallingPlanOriginatingGetListResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanPinholeDigitPatternAddRequest(OCIRequest):
    """
    Add a new calling plan Pinhole digit string.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("digit_pattern", "digitPattern", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* digitPattern
    digit_pattern = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanPinholeDigitPatternDeleteListRequest(OCIRequest):
    """
    Delete one or more calling plan Pinhole digit strings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanPinholeDigitPatternGetListRequest(OCIRequest):
    """
    Get the list of calling plan Pinhole digit strings for a group.

    The response is either a
    ``GroupOutgoingCallingPlanPinholeDigitPatternGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanPinholeDigitPatternModifyRequest(OCIRequest):
    """
    Modify a calling plan Pinhole digit string.

    The name is a key; it cannot be changed.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("digit_pattern", "digitPattern", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* digitPattern
    digit_pattern = Field(type=str, required=False, mutable=False)


class GroupOutgoingCallingPlanPinholeDigitPlanCallMeNowGetListRequest(OCIRequest):
    """
    Request the Call Me Now permissions for Pinhole digit patterns for a group default and
    its departments.

    The response is either a
    ``GroupOutgoingCallingPlanPinholeDigitPlanCallMeNowGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanPinholeDigitPlanOriginatingGetListRequest(OCIRequest):
    """
    Request the originating permissions for Pinhole digit patterns for a group default and
    its departments.

    The response is either a
    ``GroupOutgoingCallingPlanPinholeDigitPlanOriginatingGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanPinholeDigitPlanRedirectingGetListRequest(OCIRequest):
    """
    Request the redirecting permissions for Pinhole digit patterns for a group default and
    its departments.

    The response is either a
    ``GroupOutgoingCallingPlanPinholeDigitPlanRedirectingGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanRedirectedGetListRequest(OCIRequest):
    """
    Request the call forwarded/transferred permissions for a group default and it's
    departments.

    The response is either a ``GroupOutgoingCallingPlanRedirectedGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanRedirectingGetListRequest(OCIRequest):
    """
    Request the initiating call forwards/transfer permissions for a group default and it's
    departments.

    The response is either a ``GroupOutgoingCallingPlanRedirectingGetListResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanTransferNumbersGetListRequest(OCIRequest):
    """
    Request the list of transfer numbers for a group default and it's departments.

    The response is either a ``GroupOutgoingCallingPlanTransferNumbersGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupPasswordRulesGetRequest(OCIRequest):
    """
    Requests the group's password rules setting that is applicable to users within the
    group.

    The response is either ``GroupPasswordRulesGetResponse()`` or ``ErrorResponse()``.
    Repleced by: ``GroupPasswordRulesGetRequest16()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupPasswordRulesGetRequest16(OCIRequest):
    """
    Requests the group's password rules setting that is applicable to users within the
    group.

    The response is either ``GroupPasswordRulesGetResponse16()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupPasswordRulesModifyRequest(OCIRequest):
    """
    Request to modify the group's password rules setting that apply to the users within
    the group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("disallow_user_id", "disallowUserId", bool),
        E("disallow_old_password", "disallowOldPassword", bool),
        E("disallow_reversed_old_password", "disallowReversedOldPassword", bool),
        E("restrict_min_digits", "restrictMinDigits", bool),
        E("min_digits", "minDigits", int),
        E("restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool),
        E("min_upper_case_letters", "minUpperCaseLetters", int),
        E("restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool),
        E("min_lower_case_letters", "minLowerCaseLetters", int),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool,
        ),
        E("min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int),
        E("min_length", "minLength", int),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("password_expires_days", "passwordExpiresDays", int),
        E("send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
        E("disallow_previous_passwords", "disallowPreviousPasswords", bool),
        E("number_of_previous_passwords", "numberOfPreviousPasswords", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* disallowUserId
    disallow_user_id = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowOldPassword
    disallow_old_password = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowReversedOldPassword
    disallow_reversed_old_password = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* restrictMinDigits
    restrict_min_digits = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minDigits
    min_digits = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minUpperCaseLetters
    min_upper_case_letters = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minLowerCaseLetters
    min_lower_case_letters = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(type=int, required=False, mutable=False)
    #: int: *Optional* minLength
    min_length = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=False, mutable=False)
    #: int: *Optional* passwordExpiresDays
    password_expires_days = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* disallowPreviousPasswords
    disallow_previous_passwords = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* numberOfPreviousPasswords
    number_of_previous_passwords = Field(type=int, required=False, mutable=False)


class GroupPolicyGetRequest(OCIRequest):
    """
    Requests the Group's policy settings.

    The response is either ``GroupPolicyGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupPolicyGetRequest14sp1(OCIRequest):
    """
    Requests the Group's policy settings.

    The response is either ``GroupPolicyGetResponse14sp1()`` or ``ErrorResponse()``.

    Replaced By : ``GroupPolicyGetRequest14sp4()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupPolicyGetRequest14sp4(OCIRequest):
    """
    Requests the Group's policy settings.

    The response is either ``GroupPolicyGetResponse14sp4()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupPolicyGetRequest17(OCIRequest):
    """
    Requests the Group's policy settings.

    The response is either ``GroupPolicyGetResponse17()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupPolicyGetRequest20(OCIRequest):
    """
    Requests the Group's policy settings.

    The response is either ``GroupPolicyGetResponse20()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupPolicyModifyRequest(OCIRequest):
    """
    Request to modify the policies for a Group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("calling_plan_access", "callingPlanAccess", str),
        E("extension_access", "extensionAccess", str),
        E("ldap_integration_access", "ldapIntegrationAccess", str),
        E("voice_messaging_access", "voiceMessagingAccess", str),
        E("department_admin_user_access", "departmentAdminUserAccess", str),
        E("department_admin_trunk_group_access", "departmentAdminTrunkGroupAccess", str),
        E(
            "department_admin_phone_number_extension_access",
            "departmentAdminPhoneNumberExtensionAccess", str,
        ),
        E(
            "department_admin_calling_line_id_number_access",
            "departmentAdminCallingLineIdNumberAccess", str,
        ),
        E("user_authentication_access", "userAuthenticationAccess", str),
        E("user_group_directory_access", "userGroupDirectoryAccess", str),
        E("user_profile_access", "userProfileAccess", str),
        E("user_enhanced_call_log_access", "userEnhancedCallLogAccess", str),
        E(
            "user_auto_attendant_name_dialing_access",
            "userAutoAttendantNameDialingAccess", str,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* callingPlanAccess
    calling_plan_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extensionAccess
    extension_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* ldapIntegrationAccess
    ldap_integration_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* voiceMessagingAccess
    voice_messaging_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* departmentAdminUserAccess
    department_admin_user_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* departmentAdminTrunkGroupAccess
    department_admin_trunk_group_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* departmentAdminPhoneNumberExtensionAccess
    department_admin_phone_number_extension_access = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* departmentAdminCallingLineIdNumberAccess
    department_admin_calling_line_id_number_access = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* userAuthenticationAccess
    user_authentication_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userGroupDirectoryAccess
    user_group_directory_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userProfileAccess
    user_profile_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userEnhancedCallLogAccess
    user_enhanced_call_log_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userAutoAttendantNameDialingAccess
    user_auto_attendant_name_dialing_access = Field(type=str, required=False, mutable=False)


class GroupPolycomPhoneServicesGetRequest(OCIRequest):
    """
    Request the group's Polycom Phone Services attributes.

    The response is either a ``GroupPolycomPhoneServicesGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupPolycomPhoneServicesModifyRequest(OCIRequest):
    """
    Modify the group's Polycom Phone Services attributes.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E(
            "include_group_common_phone_list_in_directory",
            "includeGroupCommonPhoneListInDirectory", bool,
        ),
        E(
            "include_group_custom_contact_directory_in_directory",
            "includeGroupCustomContactDirectoryInDirectory", bool,
        ),
        E("group_custom_contact_directory", "groupCustomContactDirectory", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* includeGroupCommonPhoneListInDirectory
    include_group_common_phone_list_in_directory = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* includeGroupCustomContactDirectoryInDirectory
    include_group_custom_contact_directory_in_directory = Field(
        type=bool, required=False, mutable=False,
    )
    #: str: *Optional* groupCustomContactDirectory
    group_custom_contact_directory = Field(type=str, required=False, mutable=False)


class GroupPortalPasscodeRulesGetRequest(OCIRequest):
    """
    Requests the group's passcode rules setting.

    The response is either ``GroupPortalPasscodeRulesGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupPortalPasscodeRulesGetRequest19(OCIRequest):
    """
    Requests the group's passcode rules setting.

    The response is either ``GroupPortalPasscodeRulesGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupPortalPasscodeRulesModifyRequest(OCIRequest):
    """
    Request to modify the group's passcode rules setting.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in AS data mode: numberOfRepeatedDigits
    disallowRepeatedPatterns disallowContiguousSequences numberOfAscendingDigits
    numberOfDescendingDigits numberOfPreviousPasscodes
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_rule_level", "useRuleLevel", str),
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool),
        E("number_of_repeated_digits", "numberOfRepeatedDigits", int),
        E("disallow_repeated_patterns", "disallowRepeatedPatterns", bool),
        E("disallow_contiguous_sequences", "disallowContiguousSequences", bool),
        E("number_of_ascending_digits", "numberOfAscendingDigits", int),
        E("number_of_descending_digits", "numberOfDescendingDigits", int),
        E("disallow_user_number", "disallowUserNumber", bool),
        E("disallow_reversed_user_number", "disallowReversedUserNumber", bool),
        E("disallow_old_passcode", "disallowOldPasscode", bool),
        E("number_of_previous_passcodes", "numberOfPreviousPasscodes", int),
        E("disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool),
        E("min_code_length", "minCodeLength", int),
        E("max_code_length", "maxCodeLength", int),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E("send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* useRuleLevel
    use_rule_level = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* disallowRepeatedDigits
    disallow_repeated_digits = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* numberOfRepeatedDigits
    number_of_repeated_digits = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* disallowRepeatedPatterns
    disallow_repeated_patterns = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowContiguousSequences
    disallow_contiguous_sequences = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* numberOfAscendingDigits
    number_of_ascending_digits = Field(type=int, required=False, mutable=False)
    #: int: *Optional* numberOfDescendingDigits
    number_of_descending_digits = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* disallowUserNumber
    disallow_user_number = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowReversedUserNumber
    disallow_reversed_user_number = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowOldPasscode
    disallow_old_passcode = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* numberOfPreviousPasscodes
    number_of_previous_passcodes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minCodeLength
    min_code_length = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxCodeLength
    max_code_length = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* expirePassword
    expire_password = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)


class GroupPreAlertingAnnouncementGetRequest(OCIRequest):
    """
    Get the group�s PreAlertingservice settings.

    The response is either a ``GroupPreAlertingAnnouncementGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupPreAlertingAnnouncementGetRequest20(OCIRequest):
    """
    Get the group’s PreAlertingservice settings.

    The response is either a ``GroupPreAlertingAnnouncementGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupPreferredCarrierGroupGetRequest(OCIRequest):
    """
    Requests the currently configured carriers for a group.

    The response is either a ``GroupPreferredCarrierGroupGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupRouteListEnterpriseTrunkNumberRangeAssignListRequest(OCIRequest):
    """
    Assign a list of service provider number ranges to a group.

    The number ranges must have previously been added to the service provider.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("number_range_start", "numberRangeStart", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* numberRangeStart  *Array*
    number_range_start = Field(type=list, required=False, mutable=False)


class GroupRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest(OCIRequest):
    """
    Request a list of number ranges that are assigned to a group and still available for
    assignment to users within the group.

    The response is either
    ``GroupRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest(OCIRequest):
    """
    Get the list of assigned and unassigned enterprise trunknumber ranges in a group.

    The response is either
    ``GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupRouteListEnterpriseTrunkNumberRangeUnassignListRequest(OCIRequest):
    """
    Unassign a list of service provider number ranges from a group.

    The number ranges then become available for assignment to other groups.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("number_range_start", "numberRangeStart", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* numberRangeStart  *Array*
    number_range_start = Field(type=list, required=False, mutable=False)


class GroupRoutePointBouncedCallGetRequest(OCIRequest):
    """
    Get a route point's bounced call settings.

    The response is either a ``GroupRoutePointBouncedCallGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointBouncedCallModifyRequest(OCIRequest):
    """
    Modify a route point's bounced call settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("is_active", "isActive", bool),
        E("number_of_rings_before_bouncing_call", "numberOfRingsBeforeBouncingCall", int),
        E("enable_transfer", "enableTransfer", bool),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E("bounce_call_when_agent_unavailable", "bounceCallWhenAgentUnavailable", bool),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* isActive
    is_active = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* numberOfRingsBeforeBouncingCall
    number_of_rings_before_bouncing_call = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* enableTransfer
    enable_transfer = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* bounceCallWhenAgentUnavailable
    bounce_call_when_agent_unavailable = Field(type=bool, required=False, mutable=False)


class GroupRoutePointDeleteInstanceRequest(OCIRequest):
    """
    Delete a Route Point instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointDistinctiveRingingGetRequest(OCIRequest):
    """
    Get the distinctive ringing configuration values for route point.

    The response is either a ``GroupRoutePointDistinctiveRingingGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointDistinctiveRingingModifyRequest(OCIRequest):
    """
    Modify the distinctive ringing configuration values for route point.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("enable_distinctive_ringing", "enableDistinctiveRinging", bool),
        E("distinctive_ringing_ring_pattern", "distinctiveRingingRingPattern", str),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern", str,
        ),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* enableDistinctiveRinging
    enable_distinctive_ringing = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* distinctiveRingingRingPattern
    distinctive_ringing_ring_pattern = Field(type=str, required=False, mutable=False)
    #: str: *Optional* distinctiveRingingForceDeliveryRingPattern
    distinctive_ringing_force_delivery_ring_pattern = Field(
        type=str, required=False, mutable=False,
    )


class GroupRoutePointExternalSystemAssignListRequest(OCIRequest):
    """
    Assign a list of route point external systems to a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("route_point_external_system", "routePointExternalSystem", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* routePointExternalSystem  *Array*
    route_point_external_system = Field(type=list, required=False, mutable=False)


class GroupRoutePointExternalSystemGetAssignedListRequest(OCIRequest):
    """
    Requests the list of all Route Point External Systems assigned to a group.

    The response is either ``GroupRoutePointExternalSystemGetAssignedListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointExternalSystemUnassignListRequest(OCIRequest):
    """
    Unassign a list of route point external systems from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("route_point_external_system", "routePointExternalSystem", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* routePointExternalSystem  *Array*
    route_point_external_system = Field(type=list, required=False, mutable=False)


class GroupRoutePointForcedForwardingGetRequest(OCIRequest):
    """
    Get a route point's forced forwarding settings.

    The response is either a ``GroupRoutePointForcedForwardingGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointForcedForwardingGetRequest20(OCIRequest):
    """
    Get a route point's forced forwarding settings.

    The response is either a ``GroupRoutePointForcedForwardingGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointGetAnnouncementRequest(OCIRequest):
    """
    Get a route point's announcement settings.

    The response is either a ``GroupRoutePointGetAnnouncementResponse()`` or an
    ``ErrorResponse()``. Replaced by: ``GroupRoutePointGetAnnouncementRequest19()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointGetAnnouncementRequest19(OCIRequest):
    """
    Get a route point's announcement settings.

    The response is either a ``GroupRoutePointGetAnnouncementResponse19()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointGetAnnouncementRequest20(OCIRequest):
    """
    Get a route point's announcement settings.

    The response is either a ``GroupRoutePointGetAnnouncementResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointGetDNISListRequest(OCIRequest):
    """
    Get a list of DNIS that are configured for a Route Point.

    The response is either ``GroupRoutePointGetDNISListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointGetFailoverPolicyRequest(OCIRequest):
    """
    Get the route point failover policy.

    The response is either a ``GroupRoutePointGetFailoverPolicyResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a Route Point instance.

    The response is either ``GroupRoutePointGetInstanceResponse()`` or
    ``ErrorResponse()``. Replaced by: ``GroupRoutePointGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Route Point instance.

    The response is either ``GroupRoutePointGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointHolidayServiceGetRequest(OCIRequest):
    """
    Get a route point's holiday service settings.

    The response is either a ``GroupRoutePointHolidayServiceGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointHolidayServiceGetRequest17sp1(OCIRequest):
    """
    Get a route point's holiday service settings.

    The response is either a ``GroupRoutePointHolidayServiceGetResponse17sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointHolidayServiceGetRequest20(OCIRequest):
    """
    Get a route point's holiday service settings.

    The response is either a ``GroupRoutePointHolidayServiceGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointManualFailoverRequest(OCIRequest):
    """
    Initiate manual failover for the Route Point.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointModifyDNISParametersRequest(OCIRequest):
    """
    Modify the setting that are configured for all the DNIS in a Route Point.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("display_dnis_number", "displayDNISNumber", bool),
        E("display_dnis_name", "displayDNISName", bool),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* displayDNISNumber
    display_dnis_number = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* displayDNISName
    display_dnis_name = Field(type=bool, required=False, mutable=False)


class GroupRoutePointModifyFailoverPolicyRequest(OCIRequest):
    """
    Modify the route point failover policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("enable_failover_support", "enableFailoverSupport", bool),
        E("external_system", "externalSystem", str),
        E("failover_phone_number", "failoverPhoneNumber", str),
        E("per_call_enable_failover_support", "perCallEnableFailoverSupport", bool),
        E("per_call_call_failure_timeout_seconds", "perCallCallFailureTimeoutSeconds", int),
        E(
            "per_call_outbound_call_failure_timeout_seconds",
            "perCallOutboundCallFailureTimeoutSeconds", int,
        ),
        E("per_call_failover_phone_number", "perCallFailoverPhoneNumber", str),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* enableFailoverSupport
    enable_failover_support = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* externalSystem
    external_system = Field(type=str, required=False, mutable=False)
    #: str: *Optional* failoverPhoneNumber
    failover_phone_number = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* perCallEnableFailoverSupport
    per_call_enable_failover_support = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* perCallCallFailureTimeoutSeconds
    per_call_call_failure_timeout_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* perCallOutboundCallFailureTimeoutSeconds
    per_call_outbound_call_failure_timeout_seconds = Field(
        type=int, required=False, mutable=False,
    )
    #: str: *Optional* perCallFailoverPhoneNumber
    per_call_failover_phone_number = Field(type=str, required=False, mutable=False)


class GroupRoutePointNightServiceGetRequest(OCIRequest):
    """
    Get a route point's night service settings.

    The response is either a ``GroupRoutePointNightServiceGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointNightServiceGetRequest17sp1(OCIRequest):
    """
    Get a route point's night service settings.

    The response is either a ``GroupRoutePointNightServiceGetResponse17sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointNightServiceGetRequest20(OCIRequest):
    """
    Get a route point's night service settings.

    The response is either a ``GroupRoutePointNightServiceGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointOverflowGetRequest(OCIRequest):
    """
    Get a route point's overflow settings.

    The response is either a ``GroupRoutePointOverflowGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointOverflowGetRequest20(OCIRequest):
    """
    Get a route point's overflow settings.

    The response is either a ``GroupRoutePointOverflowGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointQueueCallDispositionCodeAddRequest(OCIRequest):
    """
    Add a Route Point Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class GroupRoutePointQueueCallDispositionCodeDeleteRequest(OCIRequest):
    """
    Delete a Route Point Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)


class GroupRoutePointQueueCallDispositionCodeGetListRequest(OCIRequest):
    """
    Get the list of Route Point Level and Organization Level Call Disposition Codes.

    The response is either ``GroupRoutePointQueueCallDispositionCodeGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutePointQueueCallDispositionCodeGetRequest(OCIRequest):
    """
    Get a Route Point Call Disposition Code.

    The response is either ``GroupRoutePointQueueCallDispositionCodeGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)


class GroupRoutePointQueueCallDispositionCodeModifyRequest(OCIRequest):
    """
    Modify a Route Point Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool),
        E("description", "description", str),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* isActive
    is_active = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class GroupRoutePointQueueCallDispositionCodeSettingsGetRequest(OCIRequest):
    """
    Request the queue level data associated with Route Point Call Disposition Code
    Settings.

    The response is either an
    ``GroupRoutePointQueueCallDispositionCodeSettingsGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupRoutingProfileGetRequest(OCIRequest):
    """
    Request the routing profile for the group.

    The response is either a ``GroupRoutingProfileGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupRoutingProfileModifyRequest(OCIRequest):
    """
    Requests to modify the routing profile for a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("routing_profile", "routingProfile", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* routingProfile
    routing_profile = Field(type=str, required=False, mutable=False)


class GroupScheduleAddRequest(OCIRequest):
    """
    Add a group schedule.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("schedule_name", "scheduleName", str, is_required=True),
        E("schedule_type", "scheduleType", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* scheduleName
    schedule_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* scheduleType
    schedule_type = Field(type=str, required=True, mutable=False)


class GroupScheduleGetListRequest(OCIRequest):
    """
    Get the list of a group schedules.

    The list can be filtered by schedule type.

    The response is either a ``GroupScheduleGetListResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("schedule_type", "scheduleType", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* scheduleType
    schedule_type = Field(type=str, required=False, mutable=False)


class GroupScheduleGetListRequest17sp1(OCIRequest):
    """
    Get the list of schedules viewable by a group.

    The list can be filtered by schedule type.

    The response is either a ``GroupScheduleGetListResponse17sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("schedule_type", "scheduleType", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* scheduleType
    schedule_type = Field(type=str, required=False, mutable=False)


class GroupSeriesCompletionAddInstanceRequest(OCIRequest):
    """
    Adds a Series Completion group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("user_id", "userId", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* userId  *Array*
    user_id = Field(type=list, required=False, mutable=False)


class GroupSeriesCompletionDeleteInstanceRequest(OCIRequest):
    """
    Deletes a Series Completion group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupSeriesCompletionGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Series Completion instances within a group.

    The response is either ``GroupSeriesCompletionGetInstanceListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupSeriesCompletionGetInstanceRequest(OCIRequest):
    """
    Gets a Series Completion group.

    The response is either ``GroupSeriesCompletionGetInstanceResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupServiceAssignListRequest(OCIRequest):
    """
    Assign one or more group services to the group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_name", "serviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceName
    service_name = Field(type=str, required=True, mutable=False)


class GroupServiceGetAuthorizationListRequest(OCIRequest):
    """
    Requests the group's service authorization status.

    The response is either ``GroupServiceGetAuthorizationListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupServiceGetAuthorizedListRequest(OCIRequest):
    """
    Requests the list of services and service packs authorized to a group.

    The response is either ``GroupServiceGetAuthorizedListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupServiceInstancePrivacyGetRequest(OCIRequest):
    """
    Request the data associated with Privacy for a service instance.

    The response is either a ``GroupServiceInstancePrivacyGetResponse()``. Replaced by:
    ``GroupServiceInstancePrivacyGetRequest17sp4()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupServiceInstancePrivacyGetRequest17sp4(OCIRequest):
    """
    Request the data associated with Privacy for a service instance.

    The response is either a ``GroupServiceInstancePrivacyGetResponse17sp4()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupServiceInstancePrivacyModifyRequest(OCIRequest):
    """
    Modify the data associated with Privacy for a service instance.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("enable_directory_privacy", "enableDirectoryPrivacy", bool),
        E(
            "enable_auto_attendant_extension_dialing_privacy",
            "enableAutoAttendantExtensionDialingPrivacy", bool,
        ),
        E(
            "enable_auto_attendant_name_dialing_privacy",
            "enableAutoAttendantNameDialingPrivacy", bool,
        ),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* enableDirectoryPrivacy
    enable_directory_privacy = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableAutoAttendantExtensionDialingPrivacy
    enable_auto_attendant_extension_dialing_privacy = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enableAutoAttendantNameDialingPrivacy
    enable_auto_attendant_name_dialing_privacy = Field(
        type=bool, required=False, mutable=False,
    )


class GroupServiceIsAssignedRequest(OCIRequest):
    """
    Request to determine if a GroupService is assigned to the group.

    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_name", "serviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceName
    service_name = Field(type=str, required=True, mutable=False)


class GroupServicePhoneNumberLookupRequest(OCIRequest):
    """
    Lookup if the given number is defined in the specified service in the group.

    The response is ``GroupServicePhoneNumberLookupResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_type", "serviceType", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceType
    service_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)


class GroupServiceScriptsGroupClearLogRequest(OCIRequest):
    """
    Clear the Service Script Group Log.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupServiceScriptsGroupGetLogRequest(OCIRequest):
    """
    Request the group level data associated with Service Scripts Group Log.

    The response is either a ``GroupServiceScriptsGroupGetLogResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupServiceScriptsGroupGetRequest(OCIRequest):
    """
    Request the group level data associated with Service Scripts Group Configuration.

    The response is either a ``GroupServiceScriptsGroupGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupServiceUnassignListRequest(OCIRequest):
    """
    Unassign one or more of the group's assigned services.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_name", "serviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceName
    service_name = Field(type=str, required=True, mutable=False)


class GroupSessionAdmissionControlGetRequest(OCIRequest):
    """
    Get the session admission control capacity for the group.

    The response is either a ``GroupSessionAdmissionControlGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupSessionAdmissionControlGroupDeleteListRequest(OCIRequest):
    """
    Request to delete one or more session admission control groups for the group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupSessionAdmissionControlGroupGetListRequest(OCIRequest):
    """
    Request to get the list of session admission control group for the group.

    The response is either a ``GroupSessionAdmissionControlGroupGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupSessionAdmissionControlGroupGetRequest(OCIRequest):
    """
    Request to get a session admission control group for the group.

    The response is either a ``GroupSessionAdmissionControlGroupGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupSessionAdmissionControlGroupGetRequest19sp1(OCIRequest):
    """
    Request to get a session admission control group for the group.

    The response is either a ``GroupSessionAdmissionControlGroupGetResponse19sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupSessionAdmissionControlModifyRequest(OCIRequest):
    """
    Request to modify session admission control capacity for the group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("restrict_aggregate_sessions", "restrictAggregateSessions", bool),
        E("max_sessions", "maxSessions", int),
        E("max_user_originating_sessions", "maxUserOriginatingSessions", int),
        E("max_user_terminating_sessions", "maxUserTerminatingSessions", int),
        E("count_intra_group_sessions", "countIntraGroupSessions", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* restrictAggregateSessions
    restrict_aggregate_sessions = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSessions
    max_sessions = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxUserOriginatingSessions
    max_user_originating_sessions = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxUserTerminatingSessions
    max_user_terminating_sessions = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* countIntraGroupSessions
    count_intra_group_sessions = Field(type=bool, required=False, mutable=False)


class GroupShInterfaceGetUserListRequest(OCIRequest):
    """
    Returns a list of all Public User Identities and associated data in a group.

    The response is either a ``GroupShInterfaceGetUserListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupSpeedDial100GetRequest(OCIRequest):
    """
    Get the speed dial 100 service settings for a group.

    The response is either a ``GroupSpeedDial100GetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupSpeedDial100GetRequest17sp1(OCIRequest):
    """
    Get the speed dial 100 service settings for a group.

    The response is either a ``GroupSpeedDial100GetResponse17sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupSpeedDial100ModifyRequest(OCIRequest):
    """
    Modify the speed dial 100 prefix setting for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("prefix", "prefix", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* prefix
    prefix = Field(type=str, required=False, mutable=False)


class GroupThirdPartyVoiceMailSupportGetRequest(OCIRequest):
    """
    Request the group level data associated with Third-Party Voice Mail Support.

    The response is either a ``GroupThirdPartyVoiceMailSupportGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupThirdPartyVoiceMailSupportModifyRequest(OCIRequest):
    """
    Modify the Third Party Voice Mail Support settings for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("is_active", "isActive", bool),
        E("group_server", "groupServer", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* isActive
    is_active = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* groupServer
    group_server = Field(type=str, required=False, mutable=False)


class GroupTimeScheduleDeleteRequest(OCIRequest):
    """
    Delete a time schedule from a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("time_schedule_name", "timeScheduleName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* timeScheduleName
    time_schedule_name = Field(type=str, required=True, mutable=False)


class GroupTimeScheduleGetListRequest(OCIRequest):
    """
    Request a list of all time schedules in a group.

    The response is either a ``GroupTimeScheduleGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupTimeScheduleGetRequest(OCIRequest):
    """
    Request to get a group time schedule.

    The response is either a ``GroupTimeScheduleGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("time_schedule_name", "timeScheduleName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* timeScheduleName
    time_schedule_name = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupDeleteInstanceRequest(OCIRequest):
    """
    Delete a Trunk Group Instance from a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupGetAvailableDetailListRequest(OCIRequest):
    """
    Requests the list of available trunk groups within a group.

    The response is either ``GroupTrunkGroupGetAvailableDetailListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupGetInstanceListRequest14(OCIRequest):
    """
    Get a list of Trunk Groups for the group or enterprise.

    It is possible to restrict the results to a particular department, or expand the list
    to the entire enterprise.

    The response is either a ``GroupTrunkGroupGetInstanceListResponse14()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
        E("include_enterprise_trunk_groups", "includeEnterpriseTrunkGroups", bool),
        E("only_trunk_groups_with_device", "onlyTrunkGroupsWithDevice", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* includeEnterpriseTrunkGroups
    include_enterprise_trunk_groups = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* onlyTrunkGroupsWithDevice
    only_trunk_groups_with_device = Field(type=bool, required=False, mutable=False)


class GroupTrunkGroupGetInstanceListRequest14sp4(OCIRequest):
    """
    Get a list of Trunk Groups for the group or enterprise.

    It is possible to restrict the results to a particular department, or expand the list
    to the entire enterprise.

    The response is either a ``GroupTrunkGroupGetInstanceListResponse14sp4()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
        E("include_enterprise_trunk_groups", "includeEnterpriseTrunkGroups", bool),
        E("only_trunk_groups_with_device", "onlyTrunkGroupsWithDevice", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* includeEnterpriseTrunkGroups
    include_enterprise_trunk_groups = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* onlyTrunkGroupsWithDevice
    only_trunk_groups_with_device = Field(type=bool, required=False, mutable=False)


class GroupTrunkGroupGetInstanceRequest14(OCIRequest):
    """
    Get a Trunk Group Instance's profile.

    The response is either a ``GroupTrunkGroupGetInstanceResponse14()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupGetInstanceRequest14sp1(OCIRequest):
    """
    Get a Trunk Group Instance's profile.

    The response is either a ``GroupTrunkGroupGetInstanceResponse14sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupGetRequest(OCIRequest):
    """
    Get the maximum permissible active trunk group calls for the group.

    The response is either a ``GroupTrunkGroupGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupGetRequest14sp1(OCIRequest):
    """
    Get the maximum and bursting maximum permissible active trunk group calls for the
    group.

    The response is either a ``GroupTrunkGroupGetResponse14sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupGetRequest14sp9(OCIRequest):
    """
    Get the maximum and bursting maximum permissible active trunk group calls for the
    group.

    The response is either a ``GroupTrunkGroupGetResponse14sp9()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupUserCreationTaskAddRequest(OCIRequest):
    """
    Add a user creation task for a trunk group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
        E("user_id_format", "userIdFormat", str, is_required=True),
        E("user_id_domain", "userIdDomain", str, is_required=True),
        E("populate_extension", "populateExtension", bool, is_required=True),
        E("line_port_format", "linePortFormat", str, is_required=True),
        E("line_port_domain", "linePortDomain", str, is_required=True),
        E("populate_contact", "populateContact", bool, is_required=True),
        E("contact_format", "contactFormat", str),
        E("contact_domain", "contactDomain", str),
        E("user_phone_numbers", "userPhoneNumbers", str, is_complex=True),  # unknown
        E("user_extensions", "userExtensions", str, is_complex=True),  # unknown
        E("service_pack_name", "servicePackName", str, is_array=True),
        E("user_service", "userService", str, is_array=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* taskName
    task_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* userIdFormat
    user_id_format = Field(type=str, required=True, mutable=False)
    #: str: *Required* userIdDomain
    user_id_domain = Field(type=str, required=True, mutable=False)
    #: bool: *Required* populateExtension
    populate_extension = Field(type=bool, required=True, mutable=False)
    #: str: *Required* linePortFormat
    line_port_format = Field(type=str, required=True, mutable=False)
    #: str: *Required* linePortDomain
    line_port_domain = Field(type=str, required=True, mutable=False)
    #: bool: *Required* populateContact
    populate_contact = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* contactFormat
    contact_format = Field(type=str, required=False, mutable=False)
    #: str: *Optional* contactDomain
    contact_domain = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userPhoneNumbers
    user_phone_numbers = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userExtensions
    user_extensions = Field(type=str, required=False, mutable=False)
    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* userService  *Array*
    user_service = Field(type=list, required=False, mutable=False)


class GroupTrunkGroupUserCreationTaskDeleteRequest(OCIRequest):
    """
    Delete a user creation task for a trunk group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* taskName
    task_name = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupUserCreationTaskGetListRequest(OCIRequest):
    """
    Get the list of user creation tasks for a trunk group.

    The response is either ``GroupTrunkGroupUserCreationTaskGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupUserCreationTaskGetRequest(OCIRequest):
    """
    Request the details of a specified user creation task for a trunk group.

    The response is either ``GroupTrunkGroupUserCreationTaskGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* taskName
    task_name = Field(type=str, required=True, mutable=False)


class GroupVirtualOnNetEnterpriseExtensionsDeleteUserRequest(OCIRequest):
    """
    Delete an existing Virtual On-Net user from a Group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)


class GroupVirtualOnNetEnterpriseExtensionsGetUserRequest(OCIRequest):
    """
    Get an existing Virtual On-Net user from a Group.

    The response is either a ``GroupVirtualOnNetEnterpriseExtensionsGetUserResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)


class GroupVirtualOnNetEnterpriseExtensionsModifyUserRequest(OCIRequest):
    """
    Modify an existing Virtual On-Net user of a Group.

    The serviceProviderId, groupId and phoneNumber combination uniquely identifies a
    Virtual On-Net User.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
        E("extension", "extension", str),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("calling_line_id_first_name", "callingLineIdFirstName", str),
        E("calling_line_id_last_name", "callingLineIdLastName", str),
        E("virtual_on_net_call_type_name", "virtualOnNetCallTypeName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: str: *Optional* firstName
    first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* lastName
    last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* virtualOnNetCallTypeName
    virtual_on_net_call_type_name = Field(type=str, required=False, mutable=False)


class GroupVoiceMessagingGroupGetPasscodeRulesRequest(OCIRequest):
    """
    Requests the group's voice portal passcode rules setting.

    The response is either ``GroupVoiceMessagingGroupGetPasscodeRulesResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupPortalPasscodeRulesGetRequest()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetRequest(OCIRequest):
    """
    Requests the group's Voice Messaging settings.

    The response is either ``GroupVoiceMessagingGroupGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalBrandingRequest(OCIRequest):
    """
    Get the group's voice portal branding settings.

    The response is either a ``GroupVoiceMessagingGroupGetVoicePortalBrandingResponse()``
    or an ``ErrorResponse()``.

    Replaced By: ``GroupVoiceMessagingGroupGetVoicePortalBrandingRequest16()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalBrandingRequest16(OCIRequest):
    """
    Get the group's voice portal branding settings.

    The response is either a
    ``GroupVoiceMessagingGroupGetVoicePortalBrandingResponse16()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalBrandingRequest20(OCIRequest):
    """
    Get the group's voice portal branding settings.

    The response is either a
    ``GroupVoiceMessagingGroupGetVoicePortalBrandingResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalRequest14(OCIRequest):
    """
    Requests the group's voice messaging settings The response is either
    ``GroupVoiceMessagingGroupGetVoicePortalResponse14()`` or ``ErrorResponse()``.

    Replaced by ``GroupVoiceMessagingGroupGetVoicePortalRequest15()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalRequest15(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.

    The response is either ``GroupVoiceMessagingGroupGetVoicePortalResponse15()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalRequest17(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.

    The response is either ``GroupVoiceMessagingGroupGetVoicePortalResponse17()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalRequest17sp4(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.

    The response is either ``GroupVoiceMessagingGroupGetVoicePortalResponse17sp4()`` or
    ``ErrorResponse()``. Replaced by:
    ``GroupVoiceMessagingGroupGetVoicePortalRequest19sp1()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalRequest19sp1(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.

    The response is either ``GroupVoiceMessagingGroupGetVoicePortalResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupModifyPasscodeRulesRequest(OCIRequest):
    """
    Request to modify the group's voice portal passcode rules setting.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Replaced By: ``GroupPortalPasscodeRulesModifyRequest()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_rule_level", "useRuleLevel", str),
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool),
        E("disallow_user_number", "disallowUserNumber", bool),
        E("disallow_reversed_user_number", "disallowReversedUserNumber", bool),
        E("disallow_old_passcode", "disallowOldPasscode", bool),
        E("disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool),
        E("min_code_length", "minCodeLength", int),
        E("max_code_length", "maxCodeLength", int),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E("send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* useRuleLevel
    use_rule_level = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* disallowRepeatedDigits
    disallow_repeated_digits = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowUserNumber
    disallow_user_number = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowReversedUserNumber
    disallow_reversed_user_number = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowOldPasscode
    disallow_old_passcode = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minCodeLength
    min_code_length = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxCodeLength
    max_code_length = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* expirePassword
    expire_password = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)


class GroupVoiceMessagingGroupModifyRequest(OCIRequest):
    """
    Request to modify the group's voice messaging settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_mail_server_setting", "useMailServerSetting", str),
        E(
            "warn_caller_before_recording_voice_message",
            "warnCallerBeforeRecordingVoiceMessage", bool,
        ),
        E(
            "allow_users_configuring_advanced_settings",
            "allowUsersConfiguringAdvancedSettings", bool,
        ),
        E(
            "allow_compose_or_forward_message_to_entire_group",
            "allowComposeOrForwardMessageToEntireGroup", bool,
        ),
        E("mail_server_net_address", "mailServerNetAddress", str),
        E("mail_server_protocol", "mailServerProtocol", str),
        E("real_delete_for_imap", "realDeleteForImap", bool),
        E("max_mailbox_length_minutes", "maxMailboxLengthMinutes", int),
        E("does_message_age", "doesMessageAge", bool),
        E("hold_period_days", "holdPeriodDays", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* useMailServerSetting
    use_mail_server_setting = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* warnCallerBeforeRecordingVoiceMessage
    warn_caller_before_recording_voice_message = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowUsersConfiguringAdvancedSettings
    allow_users_configuring_advanced_settings = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowComposeOrForwardMessageToEntireGroup
    allow_compose_or_forward_message_to_entire_group = Field(
        type=bool, required=False, mutable=False,
    )
    #: str: *Optional* mailServerNetAddress
    mail_server_net_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* mailServerProtocol
    mail_server_protocol = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* realDeleteForImap
    real_delete_for_imap = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxMailboxLengthMinutes
    max_mailbox_length_minutes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* doesMessageAge
    does_message_age = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* holdPeriodDays
    hold_period_days = Field(type=int, required=False, mutable=False)


class GroupVoiceXmlDeleteInstanceRequest(OCIRequest):
    """
    Delete a VoiceXML instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupVoiceXmlGetInstanceListRequest(OCIRequest):
    """
    Get a list of VoiceXML instances within a group.

    The response is either ``GroupVoiceXmlGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(type=str, required=False, mutable=False)


class GroupVoiceXmlGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a VoiceXML instance.

    The response is either ``GroupVoiceXmlGetInstanceResponse()`` or ``ErrorResponse()``.
    Replaced by: ``GroupVoiceXmlGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupVoiceXmlGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a VoiceXML instance.

    The response is either ``GroupVoiceXmlGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class LoginRequest13mp10(OCIRequest):
    """
    ``LoginRequest13mp10()`` is 2nd stage of the 2 stage OCI login process.

    The signedPassword is not required for external authentication login from a trusted
    host (ACL).
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("signed_password", "signedPassword", str),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* signedPassword
    signed_password = Field(type=str, required=False, mutable=False)


class LoginRequest14sp4(OCIRequest):
    """
    ``LoginRequest14sp4()`` is 2nd stage of the 2 stage OCI login process.

    The signedPassword is not required for external authentication login from a trusted
    host (ACL).
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("signed_password", "signedPassword", str),
        E("plain_text_password", "plainTextPassword", str),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* signedPassword
    signed_password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* plainTextPassword
    plain_text_password = Field(type=str, required=False, mutable=False)


class LogoutRequest(OCIRequest):
    """
    ``LogoutRequest()`` is sent when an OCI user logs out or when connection is lost.

    This command can be sent either to the server, or to the client from OCS. Response is
    either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("reason", "reason", str),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* reason
    reason = Field(type=str, required=False, mutable=False)


class PasswordModifyRequest(OCIRequest):
    """
    Modify the password for a user/administrator.

    When oldPassword is specified, password rule applies.  If oldPassword in not
    specified, any password rule related to old password does not apply.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("old_password", "oldPassword", str),
        E("new_password", "newPassword", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* oldPassword
    old_password = Field(type=str, required=False, mutable=False)
    #: str: *Required* newPassword
    new_password = Field(type=str, required=True, mutable=False)


class PrimaryInfoGetRequest(OCIRequest):
    """
    Requests information about the primary server for high-availability support.

    """

    _ELEMENTS = (
        E("is_private", "isPrivate", bool, is_required=True),
        E("is_address_info_requested", "isAddressInfoRequested", bool, is_required=True),
    )

    #: bool: *Required* isPrivate
    is_private = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isAddressInfoRequested
    is_address_info_requested = Field(type=bool, required=True, mutable=False)


class PublicClusterGetFullyQualifiedDomainNameRequest(OCIRequest):
    """
    Get the public cluster fully qualified domain name (FQDN).

    The response is either a ``PublicClusterGetFullyQualifiedDomainNameResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class ServiceProviderAccessDeviceCustomTagAddRequest(OCIRequest):
    """
    Request to add a static configuration tag for a service provider access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
        E("tag_value", "tagValue", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* tagName
    tag_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* tagValue
    tag_value = Field(type=str, required=False, mutable=False)


class ServiceProviderAccessDeviceCustomTagDeleteListRequest(OCIRequest):
    """
    Request to delete static configuration tags for a service provider access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* tagName
    tag_name = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceCustomTagGetListRequest(OCIRequest):
    """
    Request to get the list of custom configuration tags managed by the Device Management
    System, on a per-device profile basis.

    The response is either ``ServiceProviderAccessDeviceCustomTagGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceCustomTagModifyRequest(OCIRequest):
    """
    Request to modify a static configuration tag for a service provider access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
        E("tag_value", "tagValue", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* tagName
    tag_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* tagValue
    tag_value = Field(type=str, required=False, mutable=False)


class ServiceProviderAccessDeviceDeleteRequest(OCIRequest):
    """
    Request to delete a specified service provider access device.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetListRequest(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System, on a
    per-device profile basis.

    The response is either ``ServiceProviderAccessDeviceFileGetListResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderAccessDeviceFileGetListRequest14sp8()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetListRequest14sp8(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System, on a
    per-device profile basis.

    The response is either ``ServiceProviderAccessDeviceFileGetListResponse14sp8()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetRequest(OCIRequest):
    """
    Request to get a service provider device profile file.

    The response is either ``ServiceProviderAccessDeviceFileGetResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderAccessDeviceFileGetRequest14sp8()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("file_type", "fileType", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileType
    file_type = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetRequest14sp8(OCIRequest):
    """
    Request to get a service provider device profile file.

    The response is either ``ServiceProviderAccessDeviceFileGetResponse14sp8()`` or
    ``ErrorResponse()``. Replaced by: ``ServiceProviderAccessDeviceFileGetRequest16sp1()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileFormat
    file_format = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetRequest16sp1(OCIRequest):
    """
    Request to get a service provider device profile file.

    The response is either ``ServiceProviderAccessDeviceFileGetResponse16sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileFormat
    file_format = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetRequest20(OCIRequest):
    """
    Request to get a service provider device profile file.

    The response is either ``ServiceProviderAccessDeviceFileGetResponse20()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileFormat
    file_format = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceGetRequest14(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either ``ServiceProviderAccessDeviceGetResponse14()`` or
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderAccessDeviceGetRequest14sp3()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceGetRequest14sp3(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either ``ServiceProviderAccessDeviceGetResponse14sp3()`` or
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderAccessDeviceGetRequest14sp6()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceGetRequest14sp6(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either ``ServiceProviderAccessDeviceGetResponse14sp6()`` or
    ``ErrorResponse()``. Replaced by: ``ServiceProviderAccessDeviceGetRequest16()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceGetRequest16(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either ``ServiceProviderAccessDeviceGetResponse16()`` or
    ``ErrorResponse()``. Replaced by: ``ServiceProviderAccessDeviceGetRequest19()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceGetRequest18sp1(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either ``ServiceProviderAccessDeviceGetResponse18sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceModifyUserRequest(OCIRequest):
    """
    Request to modify attributes for line/ports assigned on the service provider device
    profile.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in HSS data mode and ignored in AS data mode: privateIdentity
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("private_identity", "privateIdentity", str),
        E("is_primary_line_port", "isPrimaryLinePort", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* privateIdentity
    private_identity = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* isPrimaryLinePort
    is_primary_line_port = Field(type=bool, required=False, mutable=False)


class ServiceProviderAccessDeviceResetRequest(OCIRequest):
    """
    Reset a specific service provider SIP device that supports the reset operation.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminAddRequest14(OCIRequest):
    """
    Add a service provider administrator.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("password", "password", str),
        E("language", "language", str),
        E("administrator_type", "administratorType", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* firstName
    first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* lastName
    last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)
    #: str: *Required* administratorType
    administrator_type = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminDeleteRequest(OCIRequest):
    """
    Delete a service provider administrator.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetListRequest14(OCIRequest):
    """
    Get a list of service provider administrators.

    The response is either a ``ServiceProviderAdminGetListResponse14()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyRequest14(OCIRequest):
    """
    Requests the service provider administrator's policy settings.

    The response is either ``ServiceProviderAdminGetPolicyResponse14()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyRequest16sp1(OCIRequest):
    """
    Requests the service provider administrator's policy settings.

    The response is either ``ServiceProviderAdminGetPolicyResponse16sp1()`` or
    ``ErrorResponse()``. Replaced by: ``ServiceProviderAdminGetPolicyRequest17()``
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyRequest16sp2(OCIRequest):
    """
    Requests the service provider administrator's policy settings.

    The response is either ``ServiceProviderAdminGetPolicyResponse16sp2()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyRequest17(OCIRequest):
    """
    Requests the service provider administrator's policy settings.

    The response is either ``ServiceProviderAdminGetPolicyResponse17()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyRequest17sp1(OCIRequest):
    """
    Requests the service provider administrator's policy settings.

    The response is either ``ServiceProviderAdminGetPolicyResponse17sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyRequest17sp3(OCIRequest):
    """
    Requests the service provider administrator's policy settings.

    The response is either ``ServiceProviderAdminGetPolicyResponse17sp3()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyRequest18(OCIRequest):
    """
    Requests the service provider administrator's policy settings.

    The response is either ``ServiceProviderAdminGetPolicyResponse18()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyRequest20(OCIRequest):
    """
    Requests the service provider administrator's policy settings.

    The response is either ``ServiceProviderAdminGetPolicyResponse20()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetRequest14(OCIRequest):
    """
    Get a service provider administrators profile.

    The response is either a ``ServiceProviderAdminGetResponse14()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminModifyPolicyRequest14(OCIRequest):
    """
    Request to modify the service provider administrator's policy settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The
    networkPolicyAccess is only modified for the enterprise administrator.  The following
    elements are only used in AS data mode: dialableCallerIDAccess
    verifyTranslationAndroutingAccess
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("profile_access", "profileAccess", str),
        E("group_access", "groupAccess", str),
        E("user_access", "userAccess", str),
        E("admin_access", "adminAccess", str),
        E("department_access", "departmentAccess", str),
        E("access_device_access", "accessDeviceAccess", str),
        E("phone_number_extension_access", "phoneNumberExtensionAccess", str),
        E("calling_line_id_number_access", "callingLineIdNumberAccess", str),
        E("service_access", "serviceAccess", str),
        E("service_pack_access", "servicePackAccess", str),
        E("session_admission_control_access", "sessionAdmissionControlAccess", str),
        E("web_branding_access", "webBrandingAccess", str),
        E("office_zone_access", "officeZoneAccess", str),
        E("communication_barring_access", "communicationBarringAccess", str),
        E("network_policy_access", "networkPolicyAccess", str),
        E("number_activation_access", "numberActivationAccess", str),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str),
        E("verify_translation_and_routing_access", "verifyTranslationAndRoutingAccess", str),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* profileAccess
    profile_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* groupAccess
    group_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userAccess
    user_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* adminAccess
    admin_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* departmentAccess
    department_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* accessDeviceAccess
    access_device_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdNumberAccess
    calling_line_id_number_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceAccess
    service_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* servicePackAccess
    service_pack_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* sessionAdmissionControlAccess
    session_admission_control_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* webBrandingAccess
    web_branding_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* officeZoneAccess
    office_zone_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* communicationBarringAccess
    communication_barring_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* numberActivationAccess
    number_activation_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* dialableCallerIDAccess
    dialable_caller_id_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* verifyTranslationAndRoutingAccess
    verify_translation_and_routing_access = Field(type=str, required=False, mutable=False)


class ServiceProviderAdminModifyRequest(OCIRequest):
    """
    Modify a service provider administrator.

    Since old password is not specified here, any password rule related to old password
    does not apply.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("password", "password", str),
        E("language", "language", str),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* firstName
    first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* lastName
    last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)


class ServiceProviderAdviceOfChargeGetRequest(OCIRequest):
    """
    Request to get the list of Advice of Charge service provider parameters.

    The response is either ``ServiceProviderAdviceOfChargeGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderAdviceOfChargeModifyRequest(OCIRequest):
    """
    Modify the service provider level Advice Of Charge service provider settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("use_sp_level_ao_c_settings", "useSPLevelAoCSettings", bool),
        E("delay_between_notification_seconds", "delayBetweenNotificationSeconds", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useSPLevelAoCSettings
    use_sp_level_ao_c_settings = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* delayBetweenNotificationSeconds
    delay_between_notification_seconds = Field(type=int, required=False, mutable=False)


class ServiceProviderAnswerConfirmationGetRequest(OCIRequest):
    """
    Get a service provider or enterprise's answer confirmation settings.

    The response is either a ``ServiceProviderAnswerConfirmationGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderAnswerConfirmationGetRequest16()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderAnswerConfirmationGetRequest16(OCIRequest):
    """
    Get a service provider or enterprise's answer confirmation settings.

    The response is either a ``ServiceProviderAnswerConfirmationGetResponse16()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderApplicationServerSetGetRequest(OCIRequest):
    """
    Get the Application Server set for a service provider or enterprise.

    The response is either a ``ServiceProviderApplicationServerSetGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderApplicationServerSetModifyRequest(OCIRequest):
    """
    Modify the Application Server set assigned to the service provider or enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("application_server_set_name", "applicationServerSetName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* applicationServerSetName
    application_server_set_name = Field(type=str, required=False, mutable=False)


class ServiceProviderBroadWorksCommunicatorGetRequest(OCIRequest):
    """
    Request to get Configuration Server for a specified service provider.

    The response is either a ``ServiceProviderBroadWorksCommunicatorGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderBroadWorksCommunicatorModifyRequest(OCIRequest):
    """
    Request to modify the Configuration URL.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str),
        E("configuration_server_url", "configurationServerURL", str),
    )

    #: str: *Optional* serviceProviderId
    service_provider_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* configurationServerURL
    configuration_server_url = Field(type=str, required=False, mutable=False)


class ServiceProviderBroadWorksMobilityGetRequest(OCIRequest):
    """
    Get the service provider BroadWorks Mobility service settings.

    The response is either a ``ServiceProviderBroadWorksMobilityGetResponse()`` or an
    ``ErrorResponse()``. Replaced by:
    ``ServiceProviderBroadWorksMobilityGetRequest19sp1()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderBroadWorksMobilityGetRequest19sp1(OCIRequest):
    """
    Get the service provider BroadWorks Mobility service settings.

    The response is either a ``ServiceProviderBroadWorksMobilityGetResponse19sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberAddListRequest(OCIRequest):
    """
    Adds Mobile Subscriber Directory Numbers to a service provider.

    It is possible to add a single DN, or a list of DNs.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. Replaced by
    ``ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberAddListRequest21()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E(
            "mobile_subscriber_directory_number", "mobileSubscriberDirectoryNumber", str,
            is_array=True,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* mobileSubscriberDirectoryNumber  *Array*
    mobile_subscriber_directory_number = Field(type=list, required=False, mutable=False)


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberAddListRequest21(OCIRequest):
    """
    Adds Mobile Subscriber Directory Numbers to a service provider-mobile network
    combination.

    It is possible to add a single DN, or a list of DNs.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("mobile_network_name", "mobileNetworkName", str, is_required=True),
        E(
            "mobile_subscriber_directory_number", "mobileSubscriberDirectoryNumber", str,
            is_array=True,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* mobileNetworkName
    mobile_network_name = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* mobileSubscriberDirectoryNumber  *Array*
    mobile_subscriber_directory_number = Field(type=list, required=False, mutable=False)


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberDeleteListRequest(OCIRequest):
    """
    Deletes Mobile Subscriber Directory Numbers from a service provider.

    It is possible to delete either: a single number, or a list of numbers.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E(
            "mobile_subscriber_directory_number", "mobileSubscriberDirectoryNumber", str,
            is_array=True,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* mobileSubscriberDirectoryNumber  *Array*
    mobile_subscriber_directory_number = Field(type=list, required=False, mutable=False)


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest(OCIRequest):
    """
    Request a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any group.

    This command is applicable only for service providers and will fail for enterprises.

    The response is either
    ``ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderBroadWorksMobilityModifyRequest(OCIRequest):
    """
    Modify the service provider level BroadWorks Mobility service settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("use_setting_level", "useSettingLevel", str),
        E("enable_location_services", "enableLocationServices", bool),
        E("enable_msrn_lookup", "enableMSRNLookup", bool),
        E("enable_mobile_state_checking", "enableMobileStateChecking", bool),
        E("deny_call_originations", "denyCallOriginations", bool),
        E("deny_call_terminations", "denyCallTerminations", bool),
        E("enable_announcement_suppression", "enableAnnouncementSuppression", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* useSettingLevel
    use_setting_level = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableLocationServices
    enable_location_services = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableMSRNLookup
    enable_msrn_lookup = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableMobileStateChecking
    enable_mobile_state_checking = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* denyCallOriginations
    deny_call_originations = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* denyCallTerminations
    deny_call_terminations = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableAnnouncementSuppression
    enable_announcement_suppression = Field(type=bool, required=False, mutable=False)


class ServiceProviderCPEConfigRebuildDeviceConfigFileRequest(OCIRequest):
    """
    Rebuild the config file for a specified device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("force", "force", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* force
    force = Field(type=bool, required=False, mutable=False)


class ServiceProviderCPEConfigReorderDeviceLinePortsRequest(OCIRequest):
    """
    Reorder the lines of a Service Provider device.

    You can not add or delete line ports, only re-ordering the list is allowed.  The
    ordered list of line ports can be obtained with the
    ``ServiceProviderAccessDeviceGetRequest()`` command.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("ordered_line_port_list", "orderedLinePortList", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* orderedLinePortList
    ordered_line_port_list = Field(type=str, required=True, mutable=False)


class ServiceProviderCPEConfigResetDeviceRequest(OCIRequest):
    """
    Reset a specific service provider or enterprise device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("force", "force", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* force
    force = Field(type=bool, required=False, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest14(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse14()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest14sp1(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse14sp1()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest14sp4(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse14sp4()`` or
    an ``ErrorResponse()``.

    Replaced By : ``ServiceProviderCallProcessingGetPolicyRequest15()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest14sp7(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse14sp7()`` or
    an ``ErrorResponse()``.

    Replaced By: ``ServiceProviderCallProcessingGetPolicyRequest16()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest15(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse15()`` or an
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderCallProcessingGetPolicyRequest16()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest15sp2(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse15sp2()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest16(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse16()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest16sp2(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse16sp2()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest17(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest17sp3(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse17sp3()`` or
    an ``ErrorResponse()``. Replaced by
    ``ServiceProviderCallProcessingGetPolicyResponse17sp4()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest17sp4(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse17sp4()`` or
    an ``ErrorResponse()``.

    Replaced By : ``ServiceProviderCallProcessingGetPolicyRequest18sp1()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest18sp1(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse18sp1()`` or
    an ``ErrorResponse()``. Replaced by:
    ``ServiceProviderCallProcessingGetPolicyRequest19sp1()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest19sp1(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse18sp1()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingModifyPolicyRequest14(OCIRequest):
    """
    Modify the service provider level data associated with Call Procesing Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("media_policy_selection", "mediaPolicySelection", str),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
        ),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E("use_setting_level", "useSettingLevel", str),
        E("conference_uri", "conferenceURI", str),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
        E("clid_policy", "clidPolicy", str),
        E("emergency_clid_policy", "emergencyClidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int, required=False, mutable=False,
    )
    #: str: *Optional* mediaPolicySelection
    media_policy_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: str: *Optional* useSettingLevel
    use_setting_level = Field(type=str, required=False, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=False, mutable=False,
    )
    #: str: *Optional* clidPolicy
    clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )


class ServiceProviderCallProcessingModifyPolicyRequest15(OCIRequest):
    """
    Modify the service provider level data associated with Call Procesing Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. The
    following elements are only used in AS data mode: useServiceProviderDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    enterpriseCallsCLIDPolicy groupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("use_service_provider_dclid_setting", "useServiceProviderDCLIDSetting", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("media_policy_selection", "mediaPolicySelection", str),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E("use_setting_level", "useSettingLevel", str),
        E("conference_uri", "conferenceURI", str),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
        E("clid_policy", "clidPolicy", str),
        E("emergency_clid_policy", "emergencyClidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("group_calls_clid_policy", "groupCallsCLIDPolicy", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useServiceProviderDCLIDSetting
    use_service_provider_dclid_setting = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int, required=False, mutable=False,
    )
    #: str: *Optional* mediaPolicySelection
    media_policy_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: str: *Optional* useSettingLevel
    use_setting_level = Field(type=str, required=False, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=False, mutable=False,
    )
    #: str: *Optional* clidPolicy
    clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: str: *Optional* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* groupCallsCLIDPolicy
    group_calls_clid_policy = Field(type=str, required=False, mutable=False)


class ServiceProviderCommunicationBarringCriteriaAssignListRequest(OCIRequest):
    """
    Assign a list of Communication Barring Criteria to a service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* criteriaName  *Array*
    criteria_name = Field(type=list, required=False, mutable=False)


class ServiceProviderCommunicationBarringCriteriaGetAssignedListRequest(OCIRequest):
    """
    Get a list of Communication Barring Criteria assigned to a service provider.

    The response is either a
    ``ServiceProviderCommunicationBarringCriteriaGetAssignedListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringCriteriaUnassignListRequest(OCIRequest):
    """
    Unassign a list of Communication Barring Criteria from a service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* criteriaName  *Array*
    criteria_name = Field(type=list, required=False, mutable=False)


class ServiceProviderCommunicationBarringDigitPatternCriteriaAddRequest(OCIRequest):
    """
    Add a new Communication Barring Digit Pattern Criteria.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("description", "description", str),
        E("match_digit_pattern", "matchDigitPattern", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: list(str): *Optional* matchDigitPattern  *Array*
    match_digit_pattern = Field(type=list, required=False, mutable=False)


class ServiceProviderCommunicationBarringDigitPatternCriteriaDeleteRequest(OCIRequest):
    """
    Delete an existing Communication Barring Digit Pattern Criteria.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringDigitPatternCriteriaGetListRequest(OCIRequest):
    """
    Get the list of all Digit Pattern Criteria defined for the service provider.

    The response is either a
    ``ServiceProviderCommunicationBarringDigitPatternCriteriaGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringDigitPatternCriteriaGetRequest(OCIRequest):
    """
    Get an existing Digit Pattern Criteria.

    The response is either a
    ``ServiceProviderCommunicationBarringDigitPatternCriteriaGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringDigitPatternCriteriaModifyRequest(OCIRequest):
    """
    Modify an existing Communication Barring Digit Pattern Criteria.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("new_name", "newName", str),
        E("description", "description", str),
        E("add_match_digit_pattern", "addMatchDigitPattern", str, is_array=True),
        E("delete_match_digit_pattern", "deleteMatchDigitPattern", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* newName
    new_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: list(str): *Optional* addMatchDigitPattern  *Array*
    add_match_digit_pattern = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* deleteMatchDigitPattern  *Array*
    delete_match_digit_pattern = Field(type=list, required=False, mutable=False)


class ServiceProviderCommunicationBarringIncomingCriteriaAssignListRequest(OCIRequest):
    """
    Assign a list of Communication Barring Incoming Criteria to a service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* criteriaName
    criteria_name = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringIncomingCriteriaGetAssignedListRequest(OCIRequest):
    """
    Get a list of Communication Barring Incoming Criteria assigned to a service provider.

    The response is either a
    ``ServiceProviderCommunicationBarringIncomingCriteriaGetAssignedListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringIncomingCriteriaUnassignListRequest(OCIRequest):
    """
    Unassign a list of Communication Barring Incoming Criteria from a service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* criteriaName
    criteria_name = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileDeleteRequest(OCIRequest):
    """
    Deletes an existing Communication Barring Profile.

    Optionally, a new default profile can be chosen if the current default profile is
    being deleted.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("default_profile", "defaultProfile", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* defaultProfile
    default_profile = Field(type=str, required=False, mutable=False)


class ServiceProviderCommunicationBarringProfileGetCriteriaUsageListRequest(OCIRequest):
    """
    Get a list of Communication Barring profiles within a service provider that have a
    given Communication Barring Criteria assigned.

    The response is either a ServiceProviderCommunicationBarring
    ``ProfileGetCriteriaUsageListResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* criteriaName
    criteria_name = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetDigitPatternCriteriaUsageListRequest(OCIRequest):
    """
    Get the list of Profiles that use a specific Digit Pattern Criteria.

    The response is either a
    ``ServiceProviderCommunicationBarringProfileGetDigitPatternCriteriaUsageListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetIncomingCriteriaUsageListRequest(OCIRequest):
    """
    Get a list of Communication Barring profiles within a service provider that have a
    given Communication Barring Incoming Criteria assigned.

    The response is either a ServiceProviderCommunicationBarring
    ``ProfileGetIncomingCriteriaUsageListResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* criteriaName
    criteria_name = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetListRequest(OCIRequest):
    """
    Get the list of all Communication Barring Profiles.

    The response is either a
    ``ServiceProviderCommunicationBarringProfileGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetRequest(OCIRequest):
    """
    Get an existing Communication Barring Profile.

    The response is either a ``ServiceProviderCommunicationBarringProfileGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetRequest17sp3(OCIRequest):
    """
    Get an existing Communication Barring Profile.

    The response is either a
    ``ServiceProviderCommunicationBarringProfileGetResponse17sp3()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetRequest19sp1(OCIRequest):
    """
    Get an existing Communication Barring Profile.

    The response is either a
    ``ServiceProviderCommunicationBarringProfileGetResponse19sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileModifyDefaultRequest(OCIRequest):
    """
    Modifies the default Communication Barring Profile of a Service Provider.

    If a default has been previously selected, this command will swap the default profile
    with the profile provided.  Selecting a nil profile will cause the service provider to
    not have a default Communicaton Barring Profile.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class ServiceProviderDeleteRequest(OCIRequest):
    """
    Delete a service provider or enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderDeviceManagementInProgressAndPendingEventCancelRequest(OCIRequest):
    """
    Cancel pending and in progress events.

    A list of individual events can be canceled.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("event_id", "eventId", int, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: int: *Required* eventId
    event_id = Field(type=int, required=True, mutable=False)


class ServiceProviderDeviceProfileAuthenticationPasswordRulesGetRequest(OCIRequest):
    """
    Request to get the service provider level device profile authentication password rule
    settings.

    The response is either a
    ``ServiceProviderDeviceProfileAuthenticationPasswordRulesGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderDeviceProfileAuthenticationPasswordRulesModifyRequest(OCIRequest):
    """
    Request to modify the service provider level device profile authentication password
    rule settings.

    The useServiceProviderSettings element can only be modified by a system administrator
    or a provisioning administrator.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("use_service_provider_settings", "useServiceProviderSettings", bool),
        E("disallow_authentication_name", "disallowAuthenticationName", bool),
        E("disallow_old_password", "disallowOldPassword", bool),
        E("disallow_reversed_old_password", "disallowReversedOldPassword", bool),
        E("restrict_min_digits", "restrictMinDigits", bool),
        E("min_digits", "minDigits", int),
        E("restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool),
        E("min_upper_case_letters", "minUpperCaseLetters", int),
        E("restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool),
        E("min_lower_case_letters", "minLowerCaseLetters", int),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool,
        ),
        E("min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int),
        E("min_length", "minLength", int),
        E("send_permanent_lockout_notification", "sendPermanentLockoutNotification", bool),
        E(
            "permanent_lockout_notify_email_address",
            "permanentLockoutNotifyEmailAddress", str,
        ),
        E(
            "device_profile_authentication_lockout_type",
            "deviceProfileAuthenticationLockoutType", str,
        ),
        E(
            "device_profile_temporary_lockout_threshold",
            "deviceProfileTemporaryLockoutThreshold", int,
        ),
        E("device_profile_wait_algorithm", "deviceProfileWaitAlgorithm", str),
        E("device_profile_lockout_fixed_minutes", "deviceProfileLockoutFixedMinutes", str),
        E(
            "device_profile_permanent_lockout_threshold",
            "deviceProfilePermanentLockoutThreshold", int,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useServiceProviderSettings
    use_service_provider_settings = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowAuthenticationName
    disallow_authentication_name = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowOldPassword
    disallow_old_password = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowReversedOldPassword
    disallow_reversed_old_password = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* restrictMinDigits
    restrict_min_digits = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minDigits
    min_digits = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minUpperCaseLetters
    min_upper_case_letters = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minLowerCaseLetters
    min_lower_case_letters = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(type=int, required=False, mutable=False)
    #: int: *Optional* minLength
    min_length = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* sendPermanentLockoutNotification
    send_permanent_lockout_notification = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* permanentLockoutNotifyEmailAddress
    permanent_lockout_notify_email_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* deviceProfileAuthenticationLockoutType
    device_profile_authentication_lockout_type = Field(
        type=str, required=False, mutable=False,
    )
    #: int: *Optional* deviceProfileTemporaryLockoutThreshold
    device_profile_temporary_lockout_threshold = Field(
        type=int, required=False, mutable=False,
    )
    #: str: *Optional* deviceProfileWaitAlgorithm
    device_profile_wait_algorithm = Field(type=str, required=False, mutable=False)
    #: str: *Optional* deviceProfileLockoutFixedMinutes
    device_profile_lockout_fixed_minutes = Field(type=str, required=False, mutable=False)
    #: int: *Optional* deviceProfilePermanentLockoutThreshold
    device_profile_permanent_lockout_threshold = Field(
        type=int, required=False, mutable=False,
    )


class ServiceProviderDialPlanPolicyAddAccessCodeRequest(OCIRequest):
    """
    Request to add a Service Provider level Dial Plan Access Code and its all attribues.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("access_code", "accessCode", str, is_required=True),
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting", bool, is_required=True,
        ),
        E(
            "include_code_for_screening_services", "includeCodeForScreeningServices",
            bool, is_required=True,
        ),
        E("enable_secondary_dial_tone", "enableSecondaryDialTone", bool, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessCode
    access_code = Field(type=str, required=True, mutable=False)
    #: bool: *Required* includeCodeForNetworkTranslationsAndRouting
    include_code_for_network_translations_and_routing = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* includeCodeForScreeningServices
    include_code_for_screening_services = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableSecondaryDialTone
    enable_secondary_dial_tone = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class ServiceProviderDialPlanPolicyDeleteAccessCodeRequest(OCIRequest):
    """
    Request to delete a Service Provider level Dial Plan Access Code and its all
    attribues.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("access_code", "accessCode", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessCode
    access_code = Field(type=str, required=True, mutable=False)


class ServiceProviderDialPlanPolicyGetAccessCodeListRequest(OCIRequest):
    """
    Request the Service Provider level data associated with Dial Plan Policy.

    The response is either a ``ServiceProviderDialPlanPolicyGetAccessCodeListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderDialPlanPolicyGetAccessCodeRequest(OCIRequest):
    """
    Request access code data associated with Service Provider level Dial Plan Policy
    access codes.

    The response is either a ``ServiceProviderDialPlanPolicyGetAccessCodeResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("access_code", "accessCode", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessCode
    access_code = Field(type=str, required=True, mutable=False)


class ServiceProviderDialPlanPolicyGetRequest(OCIRequest):
    """
    Request the Service Provider level data associated with Dial Plan Policy.

    The response is either a ``ServiceProviderDialPlanPolicyGetResponse()`` or an
    ``ErrorResponse()``. Replaced by: ``ServiceProviderDialPlanPolicyGetRequest17()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderDialPlanPolicyGetRequest17(OCIRequest):
    """
    Request the Service Provider level data associated with Dial Plan Policy.

    The response is either a ``ServiceProviderDialPlanPolicyGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderDialPlanPolicyModifyAccessCodeRequest(OCIRequest):
    """
    Request to modify a Service Provider level Dial Plan Access Code and its attribues.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("access_code", "accessCode", str, is_required=True),
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting", bool,
        ),
        E("include_code_for_screening_services", "includeCodeForScreeningServices", bool),
        E("enable_secondary_dial_tone", "enableSecondaryDialTone", bool),
        E("description", "description", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessCode
    access_code = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* includeCodeForNetworkTranslationsAndRouting
    include_code_for_network_translations_and_routing = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* includeCodeForScreeningServices
    include_code_for_screening_services = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableSecondaryDialTone
    enable_secondary_dial_tone = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class ServiceProviderDialPlanPolicyModifyRequest(OCIRequest):
    """
    Modify the Service Provider level data associated with Dial Plan Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("requires_access_code_for_public_calls", "requiresAccessCodeForPublicCalls", bool),
        E("allow_e164_public_calls", "allowE164PublicCalls", bool),
        E(
            "prefer_e164_number_format_for_callback_services",
            "preferE164NumberFormatForCallbackServices", bool,
        ),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* requiresAccessCodeForPublicCalls
    requires_access_code_for_public_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowE164PublicCalls
    allow_e164_public_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* preferE164NumberFormatForCallbackServices
    prefer_e164_number_format_for_callback_services = Field(
        type=bool, required=False, mutable=False,
    )
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(type=str, required=False, mutable=False)
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(type=str, required=False, mutable=False)


class ServiceProviderDialableCallerIDCriteriaAddRequest(OCIRequest):
    """
    Add a new Dialable Caller ID Criteria.

    Criteria are added at the bottom of the list with the lowest priority.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("description", "description", str),
        E("prefix_digits", "prefixDigits", str),
        E("match_call_type", "matchCallType", str, is_array=True),
        E(
            "match_alternate_call_indicator", "matchAlternateCallIndicator", str,
            is_array=True,
        ),
        E("match_local_category", "matchLocalCategory", bool, is_required=True),
        E("match_national_category", "matchNationalCategory", bool, is_required=True),
        E("match_interlata_category", "matchInterlataCategory", bool, is_required=True),
        E("match_intralata_category", "matchIntralataCategory", bool, is_required=True),
        E(
            "match_international_category", "matchInternationalCategory", bool,
            is_required=True,
        ),
        E("match_private_category", "matchPrivateCategory", bool, is_required=True),
        E("match_emergency_category", "matchEmergencyCategory", bool, is_required=True),
        E("match_other_category", "matchOtherCategory", bool, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* prefixDigits
    prefix_digits = Field(type=str, required=False, mutable=False)
    #: list(str): *Optional* matchCallType  *Array*
    match_call_type = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* matchAlternateCallIndicator  *Array*
    match_alternate_call_indicator = Field(type=list, required=False, mutable=False)
    #: bool: *Required* matchLocalCategory
    match_local_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchNationalCategory
    match_national_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchInterlataCategory
    match_interlata_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchIntralataCategory
    match_intralata_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchInternationalCategory
    match_international_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchPrivateCategory
    match_private_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchEmergencyCategory
    match_emergency_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchOtherCategory
    match_other_category = Field(type=bool, required=True, mutable=False)


class ServiceProviderDialableCallerIDCriteriaDeleteRequest(OCIRequest):
    """
    Delete a Dialable Caller ID Criteria.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class ServiceProviderDialableCallerIDCriteriaGetRequest(OCIRequest):
    """
    Get an existing Dialable Caller ID Criteria.

    The response is either a ``ServiceProviderDialableCallerIDCriteriaGetRequest()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class ServiceProviderDialableCallerIDGetRequest(OCIRequest):
    """
    Get the service provider?s Dialable Caller ID settings and criteria list.

    The response is either a ``ServiceProviderDialableCallerIDGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderDigitCollectionGetRequest13mp4(OCIRequest):
    """
    Request the service provider's digit collection attributes.

    The response is either a ``ServiceProviderDigitCollectionGetResponse13mp4()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderDigitCollectionModifyRequest(OCIRequest):
    """
    Modifies the service provider's digit collection attributes.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("access_code", "accessCode", str),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* accessCode
    access_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(type=str, required=False, mutable=False)
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(type=str, required=False, mutable=False)


class ServiceProviderDnGetAvailableListRequest(OCIRequest):
    """
    Request a list of available DNs not yet assigned to any group.

    Dns assigned to the IMRN pool are not listed in the response.

    The response is either ``ServiceProviderDnGetAvailableListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderDnGetSummaryListRequest(OCIRequest):
    """
    Request a summary table of all DNs in a service provider.

    Dns assigned to the IMRN pool are not listed in the response.

    The response is either ``ServiceProviderDnGetSummaryListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderDomainAssignListRequest(OCIRequest):
    """
    Assign a list of domains to a service provider.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("domain", "domain", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* domain
    domain = Field(type=str, required=True, mutable=False)


class ServiceProviderDomainGetAssignedListRequest(OCIRequest):
    """
    Requests the list of all domains assigned to a service provider.

    The response is either ``ServiceProviderDomainGetAssignedListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderDomainUnassignListRequest(OCIRequest):
    """
    Unassign a list of domains from a service provider.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("domain", "domain", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* domain
    domain = Field(type=str, required=True, mutable=False)


class ServiceProviderEnhancedCallLogsGetRequest(OCIRequest):
    """
    Get the service provider's enhanced call log settings.

    The response is either a ``ServiceProviderEnhancedCallLogsGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderEnhancedCallLogsGetRequest17sp4(OCIRequest):
    """
    Get the service provider's enhanced call log settings.

    The response is either a ``ServiceProviderEnhancedCallLogsGetResponse17sp4()`` or an
    ``ErrorResponse()``. This command will return an ``ErrorResponse()`` if DBS is used as
    the call log server.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderEnhancedCallLogsModifyRequest(OCIRequest):
    """
    Modify the Service Provider level data associated with Enhanced Call Logs.

    Configures the maximum number of logged calls and maximum age of your user's call
    logs.  Log entries are deleted when either of the two limits is reached.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("max_logged_calls", "maxLoggedCalls", int),
        E("call_expiration_days", "callExpirationDays", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: int: *Optional* maxLoggedCalls
    max_logged_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* callExpirationDays
    call_expiration_days = Field(type=int, required=False, mutable=False)


class ServiceProviderExternalCustomRingbackGetRequest(OCIRequest):
    """
    Request the service provider level data associated with External Custom Ringback.

    The response is either a ``ServiceProviderExternalCustomRingbackGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderExternalCustomRingbackModifyRequest(OCIRequest):
    """
    Modify the service provider level data associated with External Custom Ringback.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("prefix_digits", "prefixDigits", str),
        E("server_net_address", "serverNetAddress", str),
        E("server_port", "serverPort", int),
        E("timeout_seconds", "timeoutSeconds", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* prefixDigits
    prefix_digits = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serverNetAddress
    server_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* serverPort
    server_port = Field(type=int, required=False, mutable=False)
    #: int: *Optional* timeoutSeconds
    timeout_seconds = Field(type=int, required=False, mutable=False)


class ServiceProviderFeatureAccessCodeGetListRequest(OCIRequest):
    """
    Get the list of feature access codes for a service provider or enterprise.

    The response is either a ``ServiceProviderFeatureAccessCodeGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderFeatureAccessCodeGetListRequest20(OCIRequest):
    """
    Get the list of feature access codes for a service provider or enterprise.

    The response is either a ``ServiceProviderFeatureAccessCodeGetListResponse20()`` or an
    ``ErrorResponse()``. In release 20 the "Call Recording" FAC name is changed to "Call
    Recording - Start". Replaced by:
    ``ServiceProviderFeatureAccessCodeGetListRequest21()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderFeatureAccessCodeGetListRequest21(OCIRequest):
    """
    Get the list of feature access codes for a service provider or enterprise.

    The response is either a ``ServiceProviderFeatureAccessCodeGetListResponse21()`` or an
    ``ErrorResponse()``. In release 20 the "Call Recording" FAC name is changed to "Call
    Recording - Start".
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderFileRepositoryDeviceUserAddRequest(OCIRequest):
    """
    Add a new service provider file repository user.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
        E("user_name", "userName", str, is_required=True),
        E("password", "password", str, is_required=True),
        E("allow_put", "allowPut", bool, is_required=True),
        E("allow_delete", "allowDelete", bool, is_required=True),
        E("allow_get", "allowGet", bool, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* userName
    user_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* password
    password = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowPut
    allow_put = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowDelete
    allow_delete = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowGet
    allow_get = Field(type=bool, required=True, mutable=False)


class ServiceProviderFileRepositoryDeviceUserDeleteRequest(OCIRequest):
    """
    Delete a service provider file repository user.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
        E("user_name", "userName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* userName
    user_name = Field(type=str, required=True, mutable=False)


class ServiceProviderFileRepositoryDeviceUserGetListRequest(OCIRequest):
    """
    Request the list of service provider users for a file repository in the system.

    The response is either a ``ServiceProviderFileRepositoryDeviceUserGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(type=str, required=True, mutable=False)


class ServiceProviderFileRepositoryDeviceUserModifyRequest(OCIRequest):
    """
    Modify a service provider file repository user.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
        E("user_name", "userName", str, is_required=True),
        E("password", "password", str),
        E("allow_put", "allowPut", bool),
        E("allow_delete", "allowDelete", bool),
        E("allow_get", "allowGet", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* userName
    user_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowPut
    allow_put = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowDelete
    allow_delete = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowGet
    allow_get = Field(type=bool, required=False, mutable=False)


class ServiceProviderGetDefaultRequest(OCIRequest):
    """
    Request the default profile for a service provider or enterprise.

    The response is either a ``ServiceProviderGetDefaultResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class ServiceProviderGetRequest13mp2(OCIRequest):
    """
    Get the profile for a service provider or enterprise.

    The response is either a ``ServiceProviderGetResponse13mp2()`` or an
    ``ErrorResponse()``. Replaced by: ``ServiceProviderGetRequest17sp1()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderGetRequest17sp1(OCIRequest):
    """
    Get the profile for a service provider or enterprise.

    The response is either a ``ServiceProviderGetResponse17sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderGroupPagingTargetsCapacityGetRequest(OCIRequest):
    """
    Request the maximum number of target users per paging group configured for a service
    provider.

    The response is either a ``ServiceProviderGroupPagingTargetsCapacityGetResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderGroupPagingTargetsCapacityModifyRequest(OCIRequest):
    """
    Modify the maximum number of target users per paging group configured for a service
    provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("maximum_target_users", "maximumTargetUsers", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: int: *Optional* maximumTargetUsers
    maximum_target_users = Field(type=int, required=False, mutable=False)


class ServiceProviderIMRNGetListRequest(OCIRequest):
    """
    Returns a list of dns or dn ranges in a service provider IMRN pool.

    The response is either ``ServiceProviderIMRNGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderInCallServiceActivationGetRequest(OCIRequest):
    """
    Request the service provider's DTMF based in-call service activation trigger
    attributes.

    The response is either a ``ServiceProviderInCallServiceActivationGetResponse()`` or an
    ``ErrorResponse()``. Replaced by:
    ``ServiceProviderInCallServiceActivationGetRequest17()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderInCallServiceActivationGetRequest17(OCIRequest):
    """
    Request the service provider's DTMF based in-call service activation trigger
    attributes.

    The response is either a ``ServiceProviderInCallServiceActivationGetResponse17()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderInCallServiceActivationModifyRequest(OCIRequest):
    """
    Modifies the service provider's DTMF based in-call service activation trigger
    attributes.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Replaced by:
    ``ServiceProviderInCallServiceActivationModifyRequest17()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("activation_digits", "activationDigits", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* activationDigits
    activation_digits = Field(type=str, required=False, mutable=False)


class ServiceProviderInCallServiceActivationModifyRequest17(OCIRequest):
    """
    Modifies the service provider's DTMF based in-call service activation trigger
    attributes.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("flash_activation_digits", "flashActivationDigits", str),
        E("call_transfer_activation_digits", "callTransferActivationDigits", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* flashActivationDigits
    flash_activation_digits = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callTransferActivationDigits
    call_transfer_activation_digits = Field(type=str, required=False, mutable=False)


class ServiceProviderIntegratedIMPGetRequest(OCIRequest):
    """
    Get the Integrated IMP service attributes for the service provider.

    The response is either ``ServiceProviderIntegratedIMPGetResponse()`` or
    ``ErrorResponse()``. Replaced by: ``ServiceProviderIntegratedIMPGetRequest21()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderIntegratedIMPGetRequest21(OCIRequest):
    """
    Get the Integrated IMP service attributes for the service provider.

    The response is either ``ServiceProviderIntegratedIMPGetResponse21()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderIntegratedIMPModifyRequest(OCIRequest):
    """
    Modify the Integrated IMP service attributes for the service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("use_system_service_domain", "useSystemServiceDomain", bool),
        E("service_domain", "serviceDomain", str),
        E("service_port", "servicePort", int),
        E("use_system_messaging_server", "useSystemMessagingServer", bool),
        E("provisioning_url", "provisioningUrl", str),
        E("provisioning_user_id", "provisioningUserId", str),
        E("provisioning_password", "provisioningPassword", str),
        E("bosh_url", "boshURL", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useSystemServiceDomain
    use_system_service_domain = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* serviceDomain
    service_domain = Field(type=str, required=False, mutable=False)
    #: int: *Optional* servicePort
    service_port = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useSystemMessagingServer
    use_system_messaging_server = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* provisioningUrl
    provisioning_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* provisioningUserId
    provisioning_user_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* provisioningPassword
    provisioning_password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* boshURL
    bosh_url = Field(type=str, required=False, mutable=False)


class ServiceProviderLDAPIntegrationGetDirectoryRequest(OCIRequest):
    """
    Get the LDAP directory attributes for a service provider.

    The response is either a ``ServiceProviderLDAPIntegrationGetDirectoryResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderLDAPIntegrationModifyDirectoryRequest(OCIRequest):
    """
    Modify the LDAP directory attributes for a service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("server_net_address", "serverNetAddress", str),
        E("server_port", "serverPort", int),
        E("search_base", "searchBase", str),
        E("use_ssl", "useSSL", bool),
        E("require_authentication", "requireAuthentication", bool),
        E("authenticated_dn", "authenticatedDN", str),
        E("authenticated_password", "authenticatedPassword", str),
        E("is_sort_enabled", "isSortEnabled", bool),
        E("is_paged_result_enabled", "isPagedResultEnabled", bool),
        E("search_filter", "searchFilter", str),
        E(
            "include_search_attribute_in_search_filter",
            "includeSearchAttributeInSearchFilter", bool,
        ),
        E("column1_attribute_name", "column1AttributeName", str),
        E("column2_attribute_name", "column2AttributeName", str),
        E("column3_attribute_name", "column3AttributeName", str),
        E("column4_attribute_name", "column4AttributeName", str),
        E("column1_label", "column1Label", str),
        E("column2_label", "column2Label", str),
        E("column3_label", "column3Label", str),
        E("column4_label", "column4Label", str),
        E("search_column", "searchColumn", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* serverNetAddress
    server_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* serverPort
    server_port = Field(type=int, required=False, mutable=False)
    #: str: *Optional* searchBase
    search_base = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useSSL
    use_ssl = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* requireAuthentication
    require_authentication = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* authenticatedDN
    authenticated_dn = Field(type=str, required=False, mutable=False)
    #: str: *Optional* authenticatedPassword
    authenticated_password = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* isSortEnabled
    is_sort_enabled = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* isPagedResultEnabled
    is_paged_result_enabled = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* searchFilter
    search_filter = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* includeSearchAttributeInSearchFilter
    include_search_attribute_in_search_filter = Field(
        type=bool, required=False, mutable=False,
    )
    #: str: *Optional* column1AttributeName
    column1_attribute_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column2AttributeName
    column2_attribute_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column3AttributeName
    column3_attribute_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column4AttributeName
    column4_attribute_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column1Label
    column1_label = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column2Label
    column2_label = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column3Label
    column3_label = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column4Label
    column4_label = Field(type=str, required=False, mutable=False)
    #: int: *Optional* searchColumn
    search_column = Field(type=int, required=False, mutable=False)


class ServiceProviderLanguageAddRequest(OCIRequest):
    """
    Request to add a language for a service provder.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("language", "language", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* language
    language = Field(type=str, required=True, mutable=False)


class ServiceProviderLanguageDeleteRequest(OCIRequest):
    """
    Request to delete a language from a service provider supported languages.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("language", "language", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* language
    language = Field(type=str, required=True, mutable=False)


class ServiceProviderLanguageGetAvailableListRequest(OCIRequest):
    """
    Request the list of languages that a user or admin in a service provider is allowed to
    use.

    The list will either be the system or service provider languages list, depending on
    the useServiceProviderLanguages flag.

    The response is either a ``ServiceProviderLanguageGetAvailableListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderLanguageGetListRequest(OCIRequest):
    """
    Request the defined languages for a service provider.

    The response is either a ``ServiceProviderLanguageGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderLanguageModifyRequest(OCIRequest):
    """
    Request to modify a language properties for a service provider/enterprise.

    If the becomeDefaultLanguage element is present, the language in this request Becomes
    the default language for the service provider/enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("language", "language", str, is_required=True),
        E("become_default_language", "becomeDefaultLanguage", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* language
    language = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* becomeDefaultLanguage
    become_default_language = Field(type=bool, required=False, mutable=False)


class ServiceProviderMWIDeliveryToMobileEndpointCustomTemplateDeleteRequest(OCIRequest):
    """
    Delete a MWI Delivery to Mobile Endpoint Custom Template.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("language", "language", str, is_required=True),
        E("type", "type", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* language
    language = Field(type=str, required=True, mutable=False)
    #: str: *Required* type
    type = Field(type=str, required=True, mutable=False)


class ServiceProviderMWIDeliveryToMobileEndpointCustomTemplateGetRequest(OCIRequest):
    """
    Request a MWI Delivery to Mobile Endpoint Custom Template.

    The response is either a
    ``ServiceProviderMWIDeliveryToMobileEndpointCustomTemplateGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("language", "language", str, is_required=True),
        E("type", "type", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* language
    language = Field(type=str, required=True, mutable=False)
    #: str: *Required* type
    type = Field(type=str, required=True, mutable=False)


class ServiceProviderMWIDeliveryToMobileEndpointGetRequest(OCIRequest):
    """
    Request the service provider level data associated with MWI Delivery to Mobile
    Endpoint service.

    The response is either a ``ServiceProviderMWIDeliveryToMobileEndpointGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderMaliciousCallTraceGetRequest(OCIRequest):
    """
    Get the service provider's Malicious Call Trace settings.

    The response is either a ``ServiceProviderMaliciousCallTraceGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderMaliciousCallTraceModifyRequest(OCIRequest):
    """
    Modify the service provider's Malicious Call Trace settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E(
            "use_system_play_mct_warning_announcement",
            "useSystemPlayMCTWarningAnnouncement", bool,
        ),
        E("play_mct_warning_announcement", "playMCTWarningAnnouncement", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useSystemPlayMCTWarningAnnouncement
    use_system_play_mct_warning_announcement = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* playMCTWarningAnnouncement
    play_mct_warning_announcement = Field(type=bool, required=False, mutable=False)


class ServiceProviderMeetMeConferencingGetRequest(OCIRequest):
    """
    Request the service provider/enterprise level data associated with Meet-Me
    Conferencing functions.

    The response is either a ``ServiceProviderMeetMeConferencingGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderNetworkClassOfServiceAssignListRequest(OCIRequest):
    """
    Assign a list of Network Classes of Service to a service provider.

    The Element defaultNetworkClassOfService is required only for the first assignment,
    for subsequent assignments it is optional.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_array=True),
        E("default_network_class_of_service", "defaultNetworkClassOfService", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* networkClassOfService  *Array*
    network_class_of_service = Field(type=list, required=False, mutable=False)
    #: str: *Optional* defaultNetworkClassOfService
    default_network_class_of_service = Field(type=str, required=False, mutable=False)


class ServiceProviderNetworkClassOfServiceAssignListToAllGroupsRequest(OCIRequest):
    """
    Assign a list of Network Classes of Service to all groups with in a service provider.

    If it is the first assigned Network Class of Service in the group, it will be set as
    the default one.  The Network Classes of Service must be currently assigned to the
    service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* networkClassOfService
    network_class_of_service = Field(type=str, required=True, mutable=False)


class ServiceProviderNetworkClassOfServiceAssignToAllUsersRequest(OCIRequest):
    """
    Assign a Network Classes of Service to all users with in a service provider.

    This will also assign the Network Class of Service to all the groups in the service
    provider if it is not assigned yet.  If it is the first assigned Network Class of
    Service in the group, it will be set as the default one.  However, the Network Classes
    of Service must be currently assigned to the service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* networkClassOfService
    network_class_of_service = Field(type=str, required=True, mutable=False)


class ServiceProviderNetworkClassOfServiceGetAssignedListRequest(OCIRequest):
    """
    Get a list of Network Classes of Service assigned to a service provider.

    The response is either a
    ``ServiceProviderNetworkClassOfServiceGetAssignedListResponse()`` or an
    ``ErorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderNetworkClassOfServiceModifyDefaultRequest(OCIRequest):
    """
    Modifies the default Network Classes of Service of a Service Provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* networkClassOfService
    network_class_of_service = Field(type=str, required=True, mutable=False)


class ServiceProviderNetworkClassOfServiceUnassignListRequest(OCIRequest):
    """
    Unassign a list of Network Classes of Service from a service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_array=True),
        E("default_network_class_of_service", "defaultNetworkClassOfService", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* networkClassOfService  *Array*
    network_class_of_service = Field(type=list, required=False, mutable=False)
    #: str: *Optional* defaultNetworkClassOfService
    default_network_class_of_service = Field(type=str, required=False, mutable=False)


class ServiceProviderNumberPortabilityQueryAddListRequest(OCIRequest):
    """
    Add a list of the Service Provider Number Portability Query Digit Patterns.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("digit_pattern", "digitPattern", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* digitPattern
    digit_pattern = Field(type=str, required=True, mutable=False)


class ServiceProviderNumberPortabilityQueryModifyRequest(OCIRequest):
    """
    Modify the Service Provider Number Portability Query information.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E(
            "enable_number_portability_query_for_outgoing_calls",
            "enableNumberPortabilityQueryForOutgoingCalls", bool,
        ),
        E(
            "enable_number_portability_query_for_incoming_calls",
            "enableNumberPortabilityQueryForIncomingCalls", bool,
        ),
        E(
            "enable_number_portability_query_for_network_calls_only",
            "enableNumberPortabilityQueryForNetworkCallsOnly", bool,
        ),
        E("delete_digit_pattern", "deleteDigitPattern", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* enableNumberPortabilityQueryForOutgoingCalls
    enable_number_portability_query_for_outgoing_calls = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enableNumberPortabilityQueryForIncomingCalls
    enable_number_portability_query_for_incoming_calls = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enableNumberPortabilityQueryForNetworkCallsOnly
    enable_number_portability_query_for_network_calls_only = Field(
        type=bool, required=False, mutable=False,
    )
    #: list(str): *Optional* deleteDigitPattern  *Array*
    delete_digit_pattern = Field(type=list, required=False, mutable=False)


class ServiceProviderOfficeZoneAssignListRequest(OCIRequest):
    """
    Assign a list of Office Zones to a service provider.

    The Element defaultOfficeZone is required only for the first assignment, for
    subsequent assignments it is optional.  Office Zones can only be assigned if the
    Location-Based Calling Restrictions has been authorized to the service provider
    otherwise the request will fail.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("office_zone_name", "officeZoneName", str, is_array=True),
        E("default_office_zone_name", "defaultOfficeZoneName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* officeZoneName  *Array*
    office_zone_name = Field(type=list, required=False, mutable=False)
    #: str: *Optional* defaultOfficeZoneName
    default_office_zone_name = Field(type=str, required=False, mutable=False)


class ServiceProviderOfficeZoneGetAssignedListRequest(OCIRequest):
    """
    Get a list of Office Zones assigned to a service provider.

    The response is either a ``ServiceProviderOfficeZoneGetAssignedListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderOfficeZoneUnassignListRequest(OCIRequest):
    """
    Unassign a list of OfficeZones from a service provider.

    Note: a new default must be provided if unassigning the current default.  Office Zones
    can only be unassigned if the Location-Based Calling Restrictions has been authorized
    to the service provider otherwise the request will fail.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("office_zone_name", "officeZoneName", str, is_array=True),
        E("default_office_zone_name", "defaultOfficeZoneName", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* officeZoneName  *Array*
    office_zone_name = Field(type=list, required=False, mutable=False)
    #: str: *Optional* defaultOfficeZoneName
    default_office_zone_name = Field(type=str, required=False, mutable=False)


class ServiceProviderPasswordRulesGetRequest13mp2(OCIRequest):
    """
    Requests the service provider's password rules setting applicable to Administrators
    (Group and Department) and Users.

    The response is either ``ServiceProviderPasswordRulesGetResponse13mp2()`` or
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderPasswordRulesGetRequest16()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderPasswordRulesGetRequest16(OCIRequest):
    """
    Requests the service provider's password rules setting applicable to Administrators
    (Group and Department) and Users.

    The response is either ``ServiceProviderPasswordRulesGetResponse16()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderPasswordRulesModifyRequest(OCIRequest):
    """
    Request to modify the service provider's password rules settings setting applicable to
    Administrators (Group and Department) and Users.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Replaced By: ``ServiceProviderPasswordRulesModifyRequest14sp3()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("rules_apply_to", "rulesApplyTo", str),
        E(
            "allow_web_add_external_authentication_users",
            "allowWebAddExternalAuthenticationUsers", bool,
        ),
        E("disallow_user_id", "disallowUserId", bool),
        E("disallow_old_password", "disallowOldPassword", bool),
        E("disallow_reversed_old_password", "disallowReversedOldPassword", bool),
        E("restrict_min_digits", "restrictMinDigits", bool),
        E("min_digits", "minDigits", int),
        E("restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool),
        E("min_upper_case_letters", "minUpperCaseLetters", int),
        E("restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool),
        E("min_lower_case_letters", "minLowerCaseLetters", int),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool,
        ),
        E("min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int),
        E("min_length", "minLength", int),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("password_expires_days", "passwordExpiresDays", int),
        E("send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
        E("disallow_rules_modification", "disallowRulesModification", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* rulesApplyTo
    rules_apply_to = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowWebAddExternalAuthenticationUsers
    allow_web_add_external_authentication_users = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* disallowUserId
    disallow_user_id = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowOldPassword
    disallow_old_password = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowReversedOldPassword
    disallow_reversed_old_password = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* restrictMinDigits
    restrict_min_digits = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minDigits
    min_digits = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minUpperCaseLetters
    min_upper_case_letters = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minLowerCaseLetters
    min_lower_case_letters = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(type=int, required=False, mutable=False)
    #: int: *Optional* minLength
    min_length = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=False, mutable=False)
    #: int: *Optional* passwordExpiresDays
    password_expires_days = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* disallowRulesModification
    disallow_rules_modification = Field(type=bool, required=False, mutable=False)


class ServiceProviderPasswordRulesModifyRequest14sp3(OCIRequest):
    """
    Request to modify the service provider's password rules settings setting applicable to
    Administrators (Group and Department) and Users.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("rules_apply_to", "rulesApplyTo", str),
        E(
            "allow_web_add_external_authentication_users",
            "allowWebAddExternalAuthenticationUsers", bool,
        ),
        E("disallow_user_id", "disallowUserId", bool),
        E("disallow_old_password", "disallowOldPassword", bool),
        E("disallow_reversed_old_password", "disallowReversedOldPassword", bool),
        E("restrict_min_digits", "restrictMinDigits", bool),
        E("min_digits", "minDigits", int),
        E("restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool),
        E("min_upper_case_letters", "minUpperCaseLetters", int),
        E("restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool),
        E("min_lower_case_letters", "minLowerCaseLetters", int),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool,
        ),
        E("min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int),
        E("min_length", "minLength", int),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("password_expires_days", "passwordExpiresDays", int),
        E("send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
        E("disallow_previous_passwords", "disallowPreviousPasswords", bool),
        E("number_of_previous_passwords", "numberOfPreviousPasswords", int),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* rulesApplyTo
    rules_apply_to = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowWebAddExternalAuthenticationUsers
    allow_web_add_external_authentication_users = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* disallowUserId
    disallow_user_id = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowOldPassword
    disallow_old_password = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowReversedOldPassword
    disallow_reversed_old_password = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* restrictMinDigits
    restrict_min_digits = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minDigits
    min_digits = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minUpperCaseLetters
    min_upper_case_letters = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minLowerCaseLetters
    min_lower_case_letters = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(type=int, required=False, mutable=False)
    #: int: *Optional* minLength
    min_length = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=False, mutable=False)
    #: int: *Optional* passwordExpiresDays
    password_expires_days = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* disallowPreviousPasswords
    disallow_previous_passwords = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* numberOfPreviousPasswords
    number_of_previous_passwords = Field(type=int, required=False, mutable=False)


class ServiceProviderPortalPasscodeRulesGetRequest(OCIRequest):
    """
    Requests the service provider's passcode rules setting.

    The response is either ``ServiceProviderPortalPasscodeRulesGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderPortalPasscodeRulesGetRequest19(OCIRequest):
    """
    Requests the service provider's passcode rules setting.

    The response is either ``ServiceProviderPortalPasscodeRulesGetResponse19()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderPortalPasscodeRulesModifyRequest(OCIRequest):
    """
    Request to modify the service provider's passcode rules setting.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in AS data mode: numberOfRepeatedDigits
    disallowRepeatedPatterns disallowContiguousSequences numberOfAscendingDigits
    numberOfDescendingDigits numberOfPreviousPasscodes
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool),
        E("number_of_repeated_digits", "numberOfRepeatedDigits", int),
        E("disallow_repeated_patterns", "disallowRepeatedPatterns", bool),
        E("disallow_contiguous_sequences", "disallowContiguousSequences", bool),
        E("number_of_ascending_digits", "numberOfAscendingDigits", int),
        E("number_of_descending_digits", "numberOfDescendingDigits", int),
        E("disallow_user_number", "disallowUserNumber", bool),
        E("disallow_reversed_user_number", "disallowReversedUserNumber", bool),
        E("disallow_old_passcode", "disallowOldPasscode", bool),
        E("number_of_previous_passcodes", "numberOfPreviousPasscodes", int),
        E("disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool),
        E("min_code_length", "minCodeLength", int),
        E("max_code_length", "maxCodeLength", int),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E("send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* disallowRepeatedDigits
    disallow_repeated_digits = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* numberOfRepeatedDigits
    number_of_repeated_digits = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* disallowRepeatedPatterns
    disallow_repeated_patterns = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowContiguousSequences
    disallow_contiguous_sequences = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* numberOfAscendingDigits
    number_of_ascending_digits = Field(type=int, required=False, mutable=False)
    #: int: *Optional* numberOfDescendingDigits
    number_of_descending_digits = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* disallowUserNumber
    disallow_user_number = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowReversedUserNumber
    disallow_reversed_user_number = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowOldPasscode
    disallow_old_passcode = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* numberOfPreviousPasscodes
    number_of_previous_passcodes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minCodeLength
    min_code_length = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxCodeLength
    max_code_length = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* expirePassword
    expire_password = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)


class ServiceProviderPreferredCarrierAddRequest(OCIRequest):
    """
    Add the country code preferred carriers for a service provider or enterprise.

    For each combination of service provider and country code, you can assign an intra-
    lata, inter-lata, and international carrier.  Each of the three types of carriers is
    optional.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Note: At the
    system level, more than one carrier may be assigned to each country code.  At the
    service provider level, you must choose from the carriers assigned at the system
    level.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
        E("intra_lata_carrier", "intraLataCarrier", str),
        E("inter_lata_carrier", "interLataCarrier", str),
        E("international_carrier", "internationalCarrier", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* countryCode
    country_code = Field(type=str, required=True, mutable=False)
    #: str: *Optional* intraLataCarrier
    intra_lata_carrier = Field(type=str, required=False, mutable=False)
    #: str: *Optional* interLataCarrier
    inter_lata_carrier = Field(type=str, required=False, mutable=False)
    #: str: *Optional* internationalCarrier
    international_carrier = Field(type=str, required=False, mutable=False)


class ServiceProviderPreferredCarrierDeleteRequest(OCIRequest):
    """
    Delete the country code preferred carriers for a service provider or enterprise.

    Note that this is different from unassigning all 3 types of carriers with the
    ``ServiceProviderPreferredCarrierModifyRequest()``.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. An
    ``ErrorResponse()`` will be returned if the country code preferred carriers were never
    added or were already deleted.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* countryCode
    country_code = Field(type=str, required=True, mutable=False)


class ServiceProviderPreferredCarrierGetAvailableCountryCodeListRequest(OCIRequest):
    """
    Requests the default country code and the list of unused country codes for a service
    provider / enterprise.

    The response is either a
    ``ServiceProviderPreferredCarrierGetAvailableCountryCodeListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderPreferredCarrierGetCarrierListRequest(OCIRequest):
    """
    Requests the lists of carriers for a specified country code for a service provider /
    enterprise.

    The response is either a ``ServiceProviderPreferredCarrierGetCarrierListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* countryCode
    country_code = Field(type=str, required=True, mutable=False)


class ServiceProviderPreferredCarrierGetListRequest(OCIRequest):
    """
    Requests a table of all the carriers defined in a specified service provider or
    enterprise.

    The response is either a ``ServiceProviderPreferredCarrierGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderPreferredCarrierGetRequest(OCIRequest):
    """
    Requests the currently configured carriers for a specified country code for a service
    provider / enterprise.

    The response is either a ``ServiceProviderPreferredCarrierGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* countryCode
    country_code = Field(type=str, required=True, mutable=False)


class ServiceProviderPreferredCarrierModifyRequest(OCIRequest):
    """
    Modify the country code preferred carriers for a service provider or enterprise.

    For each combination of service provider and country code, you can assign an intra-
    lata, inter-lata, and international carrier.  Each of the 3 types of carriers is
    optional.  If an optional carrier is not specified, the assignment will not change.
    To clear a preferred carrier, set the value to an empty string.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Note: At the
    system level, more than one carrier may be assigned to each country code.  At the
    service provider level, you must choose from the carriers assigned at the system
    level.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
        E("intra_lata_carrier", "intraLataCarrier", str),
        E("inter_lata_carrier", "interLataCarrier", str),
        E("international_carrier", "internationalCarrier", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* countryCode
    country_code = Field(type=str, required=True, mutable=False)
    #: str: *Optional* intraLataCarrier
    intra_lata_carrier = Field(type=str, required=False, mutable=False)
    #: str: *Optional* interLataCarrier
    inter_lata_carrier = Field(type=str, required=False, mutable=False)
    #: str: *Optional* internationalCarrier
    international_carrier = Field(type=str, required=False, mutable=False)


class ServiceProviderRouteListEnterpriseTrunkNumberRangeActivateListRequest(OCIRequest):
    """
    Activate number ranges in a service provider.

    It is not an error to activate an already activated number range.  The command fails
    if executed when system level enterprise trunk number range activation is disabled.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("number_range_start", "numberRangeStart", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* numberRangeStart  *Array*
    number_range_start = Field(type=list, required=False, mutable=False)


class ServiceProviderRouteListEnterpriseTrunkNumberRangeDeactivateListRequest(OCIRequest):
    """
    Deactivate number ranges in a service provider.

    It is not an error to deactivate an already deactivated number range.  The command
    fails if executed when system level enterprise trunk number range activation is
    disabled.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("number_range_start", "numberRangeStart", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* numberRangeStart  *Array*
    number_range_start = Field(type=list, required=False, mutable=False)


class ServiceProviderRouteListEnterpriseTrunkNumberRangeDeleteListRequest(OCIRequest):
    """
    Delete number ranges from a service provider.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("number_range_start", "numberRangeStart", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* numberRangeStart  *Array*
    number_range_start = Field(type=list, required=False, mutable=False)


class ServiceProviderRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest(OCIRequest):
    """
    Request a list of available number ranges not yet assigned to any group.

    The response is either
    ``ServiceProviderRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest(OCIRequest):
    """
    Request a summary table of all enterprise trunk number ranges in the service provider.

    The response is either
    ``ServiceProviderRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderRoutePointExternalSystemAssignListRequest(OCIRequest):
    """
    Assign a list of route point external systems to a service provider.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("route_point_external_system", "routePointExternalSystem", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* routePointExternalSystem  *Array*
    route_point_external_system = Field(type=list, required=False, mutable=False)


class ServiceProviderRoutePointExternalSystemGetAssignedListRequest(OCIRequest):
    """
    Requests the list of all Route Point External Systems assigned to a service provider.

    The response is either
    ``ServiceProviderRoutePointExternalSystemGetAssignedListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderRoutePointExternalSystemUnassignListRequest(OCIRequest):
    """
    Unassign a list of route point external systems from a service provider.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("route_point_external_system", "routePointExternalSystem", str, is_array=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* routePointExternalSystem  *Array*
    route_point_external_system = Field(type=list, required=False, mutable=False)


class ServiceProviderRoutingProfileGetRequest(OCIRequest):
    """
    Request the routing profile for the service provider/enterprise.

    The response is either a ``ServiceProviderRoutingProfileGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderRoutingProfileModifyRequest(OCIRequest):
    """
    Requests to modify the routing profile for a service provider.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("routing_profile", "routingProfile", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* routingProfile
    routing_profile = Field(type=str, required=False, mutable=False)


class ServiceProviderSIPAuthenticationPasswordRulesGetRequest(OCIRequest):
    """
    Request to get the service provider level SIP authentication password rule settings.

    The response is either a
    ``ServiceProviderSIPAuthenticationPasswordRulesGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderSIPAuthenticationPasswordRulesModifyRequest(OCIRequest):
    """
    Request to modify the service provider level SIP authentication password rule
    settings.

    The useServiceProviderSettings element can only be modified by a system administrator
    or a provisioning administrator.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("use_service_provider_settings", "useServiceProviderSettings", bool),
        E("disallow_authentication_name", "disallowAuthenticationName", bool),
        E("disallow_old_password", "disallowOldPassword", bool),
        E("disallow_reversed_old_password", "disallowReversedOldPassword", bool),
        E("restrict_min_digits", "restrictMinDigits", bool),
        E("min_digits", "minDigits", int),
        E("restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool),
        E("min_upper_case_letters", "minUpperCaseLetters", int),
        E("restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool),
        E("min_lower_case_letters", "minLowerCaseLetters", int),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool,
        ),
        E("min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int),
        E("min_length", "minLength", int),
        E("send_permanent_lockout_notification", "sendPermanentLockoutNotification", bool),
        E(
            "permanent_lockout_notify_email_address",
            "permanentLockoutNotifyEmailAddress", str,
        ),
        E("endpoint_authentication_lockout_type", "endpointAuthenticationLockoutType", str),
        E("endpoint_temporary_lockout_threshold", "endpointTemporaryLockoutThreshold", int),
        E("endpoint_wait_algorithm", "endpointWaitAlgorithm", str),
        E("endpoint_lockout_fixed_minutes", "endpointLockoutFixedMinutes", str),
        E("endpoint_permanent_lockout_threshold", "endpointPermanentLockoutThreshold", int),
        E(
            "trunk_group_authentication_lockout_type",
            "trunkGroupAuthenticationLockoutType", str,
        ),
        E(
            "trunk_group_temporary_lockout_threshold",
            "trunkGroupTemporaryLockoutThreshold", int,
        ),
        E("trunk_group_wait_algorithm", "trunkGroupWaitAlgorithm", str),
        E("trunk_group_lockout_fixed_minutes", "trunkGroupLockoutFixedMinutes", str),
        E(
            "trunk_group_permanent_lockout_threshold",
            "trunkGroupPermanentLockoutThreshold", int,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useServiceProviderSettings
    use_service_provider_settings = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowAuthenticationName
    disallow_authentication_name = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowOldPassword
    disallow_old_password = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowReversedOldPassword
    disallow_reversed_old_password = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* restrictMinDigits
    restrict_min_digits = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minDigits
    min_digits = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minUpperCaseLetters
    min_upper_case_letters = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minLowerCaseLetters
    min_lower_case_letters = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(type=int, required=False, mutable=False)
    #: int: *Optional* minLength
    min_length = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* sendPermanentLockoutNotification
    send_permanent_lockout_notification = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* permanentLockoutNotifyEmailAddress
    permanent_lockout_notify_email_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* endpointAuthenticationLockoutType
    endpoint_authentication_lockout_type = Field(type=str, required=False, mutable=False)
    #: int: *Optional* endpointTemporaryLockoutThreshold
    endpoint_temporary_lockout_threshold = Field(type=int, required=False, mutable=False)
    #: str: *Optional* endpointWaitAlgorithm
    endpoint_wait_algorithm = Field(type=str, required=False, mutable=False)
    #: str: *Optional* endpointLockoutFixedMinutes
    endpoint_lockout_fixed_minutes = Field(type=str, required=False, mutable=False)
    #: int: *Optional* endpointPermanentLockoutThreshold
    endpoint_permanent_lockout_threshold = Field(type=int, required=False, mutable=False)
    #: str: *Optional* trunkGroupAuthenticationLockoutType
    trunk_group_authentication_lockout_type = Field(type=str, required=False, mutable=False)
    #: int: *Optional* trunkGroupTemporaryLockoutThreshold
    trunk_group_temporary_lockout_threshold = Field(type=int, required=False, mutable=False)
    #: str: *Optional* trunkGroupWaitAlgorithm
    trunk_group_wait_algorithm = Field(type=str, required=False, mutable=False)
    #: str: *Optional* trunkGroupLockoutFixedMinutes
    trunk_group_lockout_fixed_minutes = Field(type=str, required=False, mutable=False)
    #: int: *Optional* trunkGroupPermanentLockoutThreshold
    trunk_group_permanent_lockout_threshold = Field(type=int, required=False, mutable=False)


class ServiceProviderScheduleAddRequest(OCIRequest):
    """
    Add a service provider schedule.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("schedule_name", "scheduleName", str, is_required=True),
        E("schedule_type", "scheduleType", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* scheduleName
    schedule_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* scheduleType
    schedule_type = Field(type=str, required=True, mutable=False)


class ServiceProviderScheduleGetListRequest(OCIRequest):
    """
    Get the list of a service provider schedules.

    The list can be filtered by schedule type.

    The response is either a ``ServiceProviderScheduleGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("schedule_type", "scheduleType", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* scheduleType
    schedule_type = Field(type=str, required=False, mutable=False)


class ServiceProviderServiceGetAuthorizationListRequest(OCIRequest):
    """
    Requests the service provider's service authorization status.

    The response is either ``ServiceProviderServiceGetAuthorizationListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderServiceGetUserAssignableListRequest(OCIRequest):
    """
    Requests the list of all user services assignable to users in the specified service
    provider.

    The response is either ``ServiceProviderServiceGetUserAssignableListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackAddServiceListRequest(OCIRequest):
    """
    Request to add services to a service pack if the pack has not been authorized to a
    group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("service_pack_name", "servicePackName", str, is_required=True),
        E("service_name", "serviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* servicePackName
    service_pack_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceName
    service_name = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackDeleteRequest(OCIRequest):
    """
    Request to delete a service pack from a service provider.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("service_pack_name", "servicePackName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* servicePackName
    service_pack_name = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackGetDetailListRequest(OCIRequest):
    """
    Request to get a service pack details.

    The response is either ``ServiceProviderServicePackGetDetailListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("service_pack_name", "servicePackName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* servicePackName
    service_pack_name = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackGetListRequest(OCIRequest):
    """
    Request to get a list of defined service packs for a service provider.

    The response is either ``ServiceProviderServicePackGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackGetServiceUsageListRequest(OCIRequest):
    """
    Request to get the list of service packs containing a specified service.

    The response is either ``ServiceProviderServicePackGetServiceUsageListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("service_name", "serviceName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceName
    service_name = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackGetUtilizationListRequest(OCIRequest):
    """
    Request to get the service pack utilization for a service provider.

    For each service pack, a table of groups utilizing the pack is returned.

    The response is either ``ServiceProviderServicePackGetUtilizationListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskAddRequest(OCIRequest):
    """
    Create a service pack migration task.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Replaced By: ``ServiceProviderServicePackMigrationTaskAddRequest21()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
        E("start_timestamp", "startTimestamp", str, is_required=True),
        E("max_duration_hours", "maxDurationHours", int, is_required=True),
        E("send_report_email", "sendReportEmail", bool, is_required=True),
        E("report_delivery_email_address", "reportDeliveryEmailAddress", str),
        E("abort_on_error", "abortOnError", bool, is_required=True),
        E("abort_error_threshold", "abortErrorThreshold", int),
        E("report_all_users", "reportAllUsers", bool, is_required=True),
        E(
            "automatically_increment_service_quantity",
            "automaticallyIncrementServiceQuantity", bool, is_required=True,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* taskName
    task_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* startTimestamp
    start_timestamp = Field(type=str, required=True, mutable=False)
    #: int: *Required* maxDurationHours
    max_duration_hours = Field(type=int, required=True, mutable=False)
    #: bool: *Required* sendReportEmail
    send_report_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* reportDeliveryEmailAddress
    report_delivery_email_address = Field(type=str, required=False, mutable=False)
    #: bool: *Required* abortOnError
    abort_on_error = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* abortErrorThreshold
    abort_error_threshold = Field(type=int, required=False, mutable=False)
    #: bool: *Required* reportAllUsers
    report_all_users = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* automaticallyIncrementServiceQuantity
    automatically_increment_service_quantity = Field(type=bool, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskAddRequest21(OCIRequest):
    """
    Create a service pack migration task.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
        E("start_timestamp", "startTimestamp", str, is_required=True),
        E("expire_after_num_hours", "expireAfterNumHours", int, is_required=True),
        E("max_duration_hours", "maxDurationHours", int, is_required=True),
        E("send_report_email", "sendReportEmail", bool, is_required=True),
        E("report_delivery_email_address", "reportDeliveryEmailAddress", str),
        E("abort_on_error", "abortOnError", bool, is_required=True),
        E("abort_error_threshold", "abortErrorThreshold", int),
        E("report_all_users", "reportAllUsers", bool, is_required=True),
        E(
            "automatically_increment_service_quantity",
            "automaticallyIncrementServiceQuantity", bool, is_required=True,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* taskName
    task_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* startTimestamp
    start_timestamp = Field(type=str, required=True, mutable=False)
    #: int: *Required* expireAfterNumHours
    expire_after_num_hours = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxDurationHours
    max_duration_hours = Field(type=int, required=True, mutable=False)
    #: bool: *Required* sendReportEmail
    send_report_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* reportDeliveryEmailAddress
    report_delivery_email_address = Field(type=str, required=False, mutable=False)
    #: bool: *Required* abortOnError
    abort_on_error = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* abortErrorThreshold
    abort_error_threshold = Field(type=int, required=False, mutable=False)
    #: bool: *Required* reportAllUsers
    report_all_users = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* automaticallyIncrementServiceQuantity
    automatically_increment_service_quantity = Field(type=bool, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskCopyRequest(OCIRequest):
    """
    Makes a copy of one or more existing service pack migration tasks.

    A copied task can be edited with other commands and scheduled for future execution.
    The name of the new task is chosen automatically.  The name will be "Copy (number) of
    taskName".

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* taskName
    task_name = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskDeleteRequest(OCIRequest):
    """
    Deletes a service pack migration task.

    It is not possible to delete a task while it is currently executing.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* taskName
    task_name = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskGetListRequest(OCIRequest):
    """
    Requests a list of all service pack migration task for a service provider.

    The response is either ``ServiceProviderServicePackMigrationTaskGetListResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderServicePackMigrationTaskGetListRequest21()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskGetListRequest21(OCIRequest):
    """
    Requests a list of all service pack migration tasks for a service provider.

    The response is either ``ServiceProviderServicePackMigrationTaskGetListResponse21()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskGetRequest(OCIRequest):
    """
    Requests the details of a specified service pack migration task.

    The response is either ``ServiceProviderServicePackMigrationTaskGetResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderServicePackMigrationTaskGetRequest14sp4()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* taskName
    task_name = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskGetRequest14sp4(OCIRequest):
    """
    Requests the details of a specified service pack migration task.

    The response is either ``ServiceProviderServicePackMigrationTaskGetResponse14sp4()``
    or ``ErrorResponse()``.

    Replaced By: ``ServiceProviderServicePackMigrationTaskGetRequest21()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* taskName
    task_name = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskGetRequest21(OCIRequest):
    """
    Requests the details of a specified service pack migration task.

    The response is either ``ServiceProviderServicePackMigrationTaskGetResponse21()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* taskName
    task_name = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskModifyGroupListRequest(OCIRequest):
    """
    Replace the list of groups to be migrated for a specified service pack migration task.

    Modification is only allowed prior to task execution.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
        E("migrate_all_groups", "migrateAllGroups", bool),
        E("group_id_list", "groupIdList", str, is_complex=True),  # unknown
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* taskName
    task_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* migrateAllGroups
    migrate_all_groups = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* groupIdList
    group_id_list = Field(type=str, required=False, mutable=False)


class ServiceProviderServicePackMigrationTaskModifyRequest(OCIRequest):
    """
    Modify the properties of a specified service pack migration task.

    Modification is only allowed prior to task execution.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
        E("new_task_name", "newTaskName", str),
        E("start_timestamp", "startTimestamp", str),
        E("expire_after_num_hours", "expireAfterNumHours", int),
        E("max_duration_hours", "maxDurationHours", int),
        E("send_report_email", "sendReportEmail", bool),
        E("report_delivery_email_address", "reportDeliveryEmailAddress", str),
        E("abort_on_error", "abortOnError", bool),
        E("abort_error_threshold", "abortErrorThreshold", int),
        E("report_all_users", "reportAllUsers", bool),
        E(
            "automatically_increment_service_quantity",
            "automaticallyIncrementServiceQuantity", bool,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* taskName
    task_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* newTaskName
    new_task_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* startTimestamp
    start_timestamp = Field(type=str, required=False, mutable=False)
    #: int: *Optional* expireAfterNumHours
    expire_after_num_hours = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxDurationHours
    max_duration_hours = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* sendReportEmail
    send_report_email = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* reportDeliveryEmailAddress
    report_delivery_email_address = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* abortOnError
    abort_on_error = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* abortErrorThreshold
    abort_error_threshold = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* reportAllUsers
    report_all_users = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* automaticallyIncrementServiceQuantity
    automatically_increment_service_quantity = Field(type=bool, required=False, mutable=False)


class ServiceProviderServicePackMigrationTaskTerminateRequest(OCIRequest):
    """
    Terminates a service pack migration task that is currently executing.

    Modification is only allowed prior to task execution.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* taskName
    task_name = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePhoneNumberLookupRequest(OCIRequest):
    """
    Lookup if the given number is defined in the specified service in the service
    provider.

    The response is ``ServiceProviderServicePhoneNumberLookupResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("service_type", "serviceType", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceType
    service_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)


class ServiceProviderSessionAdmissionControlGetRequest(OCIRequest):
    """
    Get the session admission control capacity for the service provider.

    The response is either a ``ServiceProviderSessionAdmissionControlGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderSessionAdmissionControlModifyRequest(OCIRequest):
    """
    Request to modify session admission control capacity for the service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("restrict_aggregate_sessions", "restrictAggregateSessions", bool),
        E("max_sessions", "maxSessions", int),
        E("max_user_originating_sessions", "maxUserOriginatingSessions", int),
        E("max_user_terminating_sessions", "maxUserTerminatingSessions", int),
        E("count_intra_service_provider_sessions", "countIntraServiceProviderSessions", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* restrictAggregateSessions
    restrict_aggregate_sessions = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSessions
    max_sessions = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxUserOriginatingSessions
    max_user_originating_sessions = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxUserTerminatingSessions
    max_user_terminating_sessions = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* countIntraServiceProviderSessions
    count_intra_service_provider_sessions = Field(type=bool, required=False, mutable=False)


class ServiceProviderSessionAdmissionControlWhiteListGetRequest(OCIRequest):
    """
    Request to get the Service Provider Session Admission White List information.

    The response is either a
    ``ServiceProviderSessionAdmissionControlWhiteListGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderSessionAdmissionControlWhiteListModifyRequest(OCIRequest):
    """
    Modify the Service Provider Session Admission Control White List information.

    The number of digit pattern entries is limited to 100.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("add_match_digit_pattern", "addMatchDigitPattern", str),
        E("delete_match_digit_pattern", "deleteMatchDigitPattern", str),
        E("enable_white_list", "enableWhiteList", bool),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* addMatchDigitPattern
    add_match_digit_pattern = Field(type=str, required=False, mutable=False)
    #: str: *Optional* deleteMatchDigitPattern
    delete_match_digit_pattern = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableWhiteList
    enable_white_list = Field(type=bool, required=False, mutable=False)


class ServiceProviderTrunkGroupGetRequest(OCIRequest):
    """
    Get the maximum permissible active Trunk Group calls for the service provider.

    The response is either a ``ServiceProviderTrunkGroupGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderTrunkGroupGetRequest14sp1(OCIRequest):
    """
    Get the maximum and bursting maximum permissible active Trunk Group calls for the
    service provider.

    The response is either a ``ServiceProviderTrunkGroupGetResponse14sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderVoiceMessagingGroupGetPasscodeRulesRequest(OCIRequest):
    """
    Requests the service provider's voice portal passcode rules setting.

    The response is either
    ``ServiceProviderVoiceMessagingGroupGetPasscodeRulesResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderPortalPasscodeRulesGetRequest()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderVoiceMessagingGroupGetRequest(OCIRequest):
    """
    Requests the service provider's or enterprise's voice messaging settings.

    The response is either ``ServiceProviderVoiceMessagingGroupGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingRequest(OCIRequest):
    """
    Get the service provider's voice portal branding settings.

    The response is either a
    ``ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingResponse()`` or an
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingRequest16()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingRequest16(OCIRequest):
    """
    Get the service provider's voice portal branding settings.

    The response is either a
    ``ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingResponse16()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderVoiceMessagingGroupGetVoicePortalRequest(OCIRequest):
    """
    Requests the service provider's or enterprise's voice portal settings.

    The response is either ``ServiceProviderVoiceMessagingGroupGetVoicePortalResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderVoiceMessagingGroupModifyPasscodeRulesRequest(OCIRequest):
    """
    Request to modify the service provider's voice portal passcode rules setting.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Replaced By: ``ServiceProviderPortalPasscodeRulesModifyRequest()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool),
        E("disallow_user_number", "disallowUserNumber", bool),
        E("disallow_reversed_user_number", "disallowReversedUserNumber", bool),
        E("disallow_old_passcode", "disallowOldPasscode", bool),
        E("disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool),
        E("min_code_length", "minCodeLength", int),
        E("max_code_length", "maxCodeLength", int),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E("send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* disallowRepeatedDigits
    disallow_repeated_digits = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowUserNumber
    disallow_user_number = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowReversedUserNumber
    disallow_reversed_user_number = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowOldPasscode
    disallow_old_passcode = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* minCodeLength
    min_code_length = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxCodeLength
    max_code_length = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* expirePassword
    expire_password = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)


class ServiceProviderVoiceMessagingGroupModifyRequest(OCIRequest):
    """
    Request to modify a service provider's or enterprise's voice messaging settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("delivery_from_address", "deliveryFromAddress", str),
        E("notification_from_address", "notificationFromAddress", str),
        E("voice_portal_lockout_from_address", "voicePortalLockoutFromAddress", str),
        E(
            "use_system_default_delivery_from_address",
            "useSystemDefaultDeliveryFromAddress", bool,
        ),
        E(
            "use_system_default_notification_from_address",
            "useSystemDefaultNotificationFromAddress", bool,
        ),
        E(
            "use_system_default_voice_portal_lockout_from_address",
            "useSystemDefaultVoicePortalLockoutFromAddress", bool,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* deliveryFromAddress
    delivery_from_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* notificationFromAddress
    notification_from_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* voicePortalLockoutFromAddress
    voice_portal_lockout_from_address = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useSystemDefaultDeliveryFromAddress
    use_system_default_delivery_from_address = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useSystemDefaultNotificationFromAddress
    use_system_default_notification_from_address = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useSystemDefaultVoicePortalLockoutFromAddress
    use_system_default_voice_portal_lockout_from_address = Field(
        type=bool, required=False, mutable=False,
    )


class ServiceProviderVoiceMessagingGroupModifyVoicePortalRequest(OCIRequest):
    """
    Request to change the service provider's or enterprise's voice portal settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("voice_portal_scope", "voicePortalScope", str),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* voicePortalScope
    voice_portal_scope = Field(type=str, required=False, mutable=False)


class ServiceProviderZoneCallingRestrictionsGetRequest(OCIRequest):
    """
    Gets the Service Provider/Enterprise level Zone Calling Restrictions Policies.

    The response is ``ServiceProviderZoneCallingRestrictionsGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class ServiceProviderZoneCallingRestrictionsModifyRequest(OCIRequest):
    """
    Modifies the Service Provider/Enterprise level Zone Calling Restrictions Policies.

    The response is ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enable_zone_calling_restrictions", "enableZoneCallingRestrictions", bool),
        E(
            "enable_origination_roaming_restrictions",
            "enableOriginationRoamingRestrictions", bool,
        ),
        E(
            "enable_emergency_origination_roaming_restrictions",
            "enableEmergencyOriginationRoamingRestrictions", bool,
        ),
        E(
            "enable_termination_roaming_restrictions",
            "enableTerminationRoamingRestrictions", bool,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* enableZoneCallingRestrictions
    enable_zone_calling_restrictions = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableOriginationRoamingRestrictions
    enable_origination_roaming_restrictions = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableEmergencyOriginationRoamingRestrictions
    enable_emergency_origination_roaming_restrictions = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enableTerminationRoamingRestrictions
    enable_termination_roaming_restrictions = Field(type=bool, required=False, mutable=False)


class SystemASRParametersGetRequest(OCIRequest):
    """
    Request to get the list of Application Server Registration system parameters.

    The response is either ``SystemASRParametersGetResponse()`` or ``ErrorResponse()``.

    Replaced By: ``SystemASRParametersGetRequest14sp5()``
    """

    _ELEMENTS = ()


class SystemASRParametersGetRequest14sp5(OCIRequest):
    """
    Request to get the list of Application Server Registration system parameters.

    The response is either ``SystemASRParametersGetResponse14sp5()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemASRParametersGetRequest14sp7(OCIRequest):
    """
    Request to get the list of Application Server Registration system parameters.

    The response is either ``SystemASRParametersGetResponse14sp7()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemASRParametersModifyRequest(OCIRequest):
    """
    Request to modify Application Server Registration system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("max_transmissions", "maxTransmissions", int),
        E("retransmission_delay_milli_seconds", "retransmissionDelayMilliSeconds", int),
        E("listening_port", "listeningPort", int),
        E("source_address", "sourceAddress", str),
    )

    #: int: *Optional* maxTransmissions
    max_transmissions = Field(type=int, required=False, mutable=False)
    #: int: *Optional* retransmissionDelayMilliSeconds
    retransmission_delay_milli_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* listeningPort
    listening_port = Field(type=int, required=False, mutable=False)
    #: str: *Optional* sourceAddress
    source_address = Field(type=str, required=False, mutable=False)


class SystemASRParametersModifyRequest14sp7(OCIRequest):
    """
    Request to modify Application Server Registration system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("max_transmissions", "maxTransmissions", int),
        E("retransmission_delay_milli_seconds", "retransmissionDelayMilliSeconds", int),
        E("listening_port", "listeningPort", int),
    )

    #: int: *Optional* maxTransmissions
    max_transmissions = Field(type=int, required=False, mutable=False)
    #: int: *Optional* retransmissionDelayMilliSeconds
    retransmission_delay_milli_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* listeningPort
    listening_port = Field(type=int, required=False, mutable=False)


class SystemAccessDeviceCustomTagAddRequest(OCIRequest):
    """
    Request to add a static configuration tag for a system access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
        E("tag_value", "tagValue", str),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* tagName
    tag_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* tagValue
    tag_value = Field(type=str, required=False, mutable=False)


class SystemAccessDeviceCustomTagDeleteListRequest(OCIRequest):
    """
    Request to delete static configuration tags for a system access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* tagName
    tag_name = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceCustomTagGetListRequest(OCIRequest):
    """
    Request to get the list of custom configuration tags managed by the Device Management
    System, on a per-device profile basis.

    The response is either ``SystemAccessDeviceCustomTagGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceCustomTagModifyRequest(OCIRequest):
    """
    Request to modify a static configuration tag for a system access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
        E("tag_value", "tagValue", str),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* tagName
    tag_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* tagValue
    tag_value = Field(type=str, required=False, mutable=False)


class SystemAccessDeviceDeleteRequest(OCIRequest):
    """
    Request to delete a specified system access device.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceFileGetListRequest(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System, on a
    per-device profile basis.

    The response is either ``SystemAccessDeviceFileGetListResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``SystemAccessDeviceFileGetListRequest14sp8()``
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceFileGetListRequest14sp8(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System, on a
    per-device profile basis.

    The response is either ``SystemAccessDeviceFileGetListResponse14sp8()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceFileGetRequest(OCIRequest):
    """
    Request to get a device profile file.

    The response is either ``SystemAccessDeviceFileGetResponse()`` or ``ErrorResponse()``.

    Replaced By: ``SystemAccessDeviceFileGetRequest14sp8()``
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("file_type", "fileType", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileType
    file_type = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceFileGetRequest14sp8(OCIRequest):
    """
    Request to get a device profile file.

    The response is either ``SystemAccessDeviceFileGetResponse14sp8()`` or
    ``ErrorResponse()``. Replaced by: ``SystemAccessDeviceFileGetRequest16sp1()``
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileFormat
    file_format = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceFileGetRequest16sp1(OCIRequest):
    """
    Request to get a device profile file.

    The response is either ``SystemAccessDeviceFileGetResponse16sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileFormat
    file_format = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceFileGetRequest20(OCIRequest):
    """
    Request to get a device profile file.

    The response is either ``SystemAccessDeviceFileGetResponse20()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileFormat
    file_format = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceGetRequest(OCIRequest):
    """
    Requests the configuration of a specified system access device.

    The response is either ``SystemAccessDeviceGetResponse()`` or ``ErrorResponse()``.

    Replaced By: ``SystemAccessDeviceGetRequest14sp3()``
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceGetRequest14sp3(OCIRequest):
    """
    Requests the configuration of a specified system access device.

    The response is either ``SystemAccessDeviceGetResponse14sp3()`` or
    ``ErrorResponse()``.

    Replaced By: ``SystemAccessDeviceGetRequest14sp6()``
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceGetRequest14sp6(OCIRequest):
    """
    Requests the configuration of a specified system access device.

    The response is either ``SystemAccessDeviceGetResponse14sp6()`` or
    ``ErrorResponse()``. Replaced by: ``SystemAccessDeviceGetRequest16()``
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceGetRequest16(OCIRequest):
    """
    Requests the configuration of a specified system access device.

    The response is either ``SystemAccessDeviceGetResponse16()`` or ``ErrorResponse()``.
    Replaced by: ``SystemAccessDeviceGetRequest19()``
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceGetRequest18sp1(OCIRequest):
    """
    Requests the configuration of a specified system access device.

    The response is either ``SystemAccessDeviceGetResponse18sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceModifyUserRequest(OCIRequest):
    """
    Request to modify attributes for line/ports assigned on the system device profile.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in HSS data mode and ignored in AS data mode: privateIdentity
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("private_identity", "privateIdentity", str),
        E("is_primary_line_port", "isPrimaryLinePort", bool),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* privateIdentity
    private_identity = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* isPrimaryLinePort
    is_primary_line_port = Field(type=bool, required=False, mutable=False)


class SystemAccessDeviceMonitorAddDeviceTypeRequest(OCIRequest):
    """
    Add a device type to be monitored.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("add_all_device_types", "addAllDeviceTypes", bool),
        E("device_type", "deviceType", str),
    )

    #: bool: *Optional* addAllDeviceTypes
    add_all_device_types = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* deviceType
    device_type = Field(type=str, required=False, mutable=False)


class SystemAccessDeviceMonitorDeleteDeviceTypeRequest(OCIRequest):
    """
    Remove a device type to be monitored.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("delete_all_device_types", "deleteAllDeviceTypes", bool),
        E("device_type", "deviceType", str),
    )

    #: bool: *Optional* deleteAllDeviceTypes
    delete_all_device_types = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* deviceType
    device_type = Field(type=str, required=False, mutable=False)


class SystemAccessDeviceMonitorGetDeviceTypeListRequest(OCIRequest):
    """
    Get a list of monitored device types.

    The response is either a ``SystemAccessDeviceMonitorGetDeviceTypeListResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAccessDeviceMonitorParametersGetRequest(OCIRequest):
    """
    Request to get the list of Access Device Monitor system parameters.

    The response is either ``SystemAccessDeviceMonitorParametersGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAccessDeviceMonitorParametersModifyRequest(OCIRequest):
    """
    Request to modify Access Device Monitor system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("polling_interval_minutes", "pollingIntervalMinutes", int),
    )

    #: int: *Optional* pollingIntervalMinutes
    polling_interval_minutes = Field(type=int, required=False, mutable=False)


class SystemAccessDeviceResetRequest(OCIRequest):
    """
    Reset a specific system SIP device that supports the reset operation.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceTypeGetEnhancedConfigurableListRequest(OCIRequest):
    """
    Requests the list of device types supporting enhanced configuration.

    The response is either ``SystemAccessDeviceTypeGetEnhancedConfigurableListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAccessDeviceTypeGetListRequest(OCIRequest):
    """
    Requests the list of access device types.

    The response is either ``SystemAccessDeviceTypeGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAccountingAddChargingFunctionElementServerRequest(OCIRequest):
    """
    Request to add a ChargingFunctionElement Server to the system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("address", "address", str, is_required=True),
        E("is_net_address_extended", "isNetAddressExtended", bool, is_required=True),
        E("type", "type", str, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* address
    address = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isNetAddressExtended
    is_net_address_extended = Field(type=bool, required=True, mutable=False)
    #: str: *Required* type
    type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class SystemAccountingAddRadiusServerRequest(OCIRequest):
    """
    Request to add a Radius Server to the system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("net_address", "netAddress", str, is_required=True),
        E("port", "port", int, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* netAddress
    net_address = Field(type=str, required=True, mutable=False)
    #: int: *Required* port
    port = Field(type=int, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class SystemAccountingDeleteChargingFunctionElementServerRequest(OCIRequest):
    """
    Request to delete a ChargingFunctionElementServer from the system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("address", "address", str, is_required=True),
    )

    #: str: *Required* address
    address = Field(type=str, required=True, mutable=False)


class SystemAccountingDeleteRadiusServerRequest(OCIRequest):
    """
    Request to delete a Radius Server from the system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("net_address", "netAddress", str, is_required=True),
        E("port", "port", int, is_required=True),
    )

    #: str: *Required* netAddress
    net_address = Field(type=str, required=True, mutable=False)
    #: int: *Required* port
    port = Field(type=int, required=True, mutable=False)


class SystemAccountingGetChargingFunctionElementServerListRequest(OCIRequest):
    """
    Request to get a list of ChargingFunctionElementServers defined in the system.

    The response is either a
    ``SystemAccountingGetChargingFunctionElementServerListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAccountingGetRadiusServerListRequest(OCIRequest):
    """
    Request to get a list of Radius Servers defined in the system.

    The response is either a ``SystemAccountingGetRadiusServerListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAccountingInhibitedAttributeValuePairCodeAddRequest(OCIRequest):
    """
    Add an Attribute Value Pair (AVP) combination to disable.

    The AVP combination includes a diameter AVP and a vendor ID.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("attribute_value_pair_code", "attributeValuePairCode", int, is_required=True),
        E("vendor_id", "vendorId", int, is_required=True),
    )

    #: int: *Required* attributeValuePairCode
    attribute_value_pair_code = Field(type=int, required=True, mutable=False)
    #: int: *Required* vendorId
    vendor_id = Field(type=int, required=True, mutable=False)


class SystemAccountingInhibitedAttributeValuePairCodeDeleteRequest(OCIRequest):
    """
    Remove an Attribute Value Pair (AVP) combination from the list of disabled AVP codes.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("attribute_value_pair_code", "attributeValuePairCode", int, is_required=True),
        E("vendor_id", "vendorId", int, is_required=True),
    )

    #: int: *Required* attributeValuePairCode
    attribute_value_pair_code = Field(type=int, required=True, mutable=False)
    #: int: *Required* vendorId
    vendor_id = Field(type=int, required=True, mutable=False)


class SystemAccountingInhibitedAttributeValuePairCodeGetListRequest(OCIRequest):
    """
    Get a list of Attribute Value Pair (AVP) combinations that are disabled.

    The response is either a
    ``SystemAccountingInhibitedAttributeValuePairCodeGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAccountingModifyChargingFunctionElementServerRequest(OCIRequest):
    """
    Request to modify a ChargingFunctionElementServer in the system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("address", "address", str, is_required=True),
        E("type", "type", str),
        E("description", "description", str),
    )

    #: str: *Required* address
    address = Field(type=str, required=True, mutable=False)
    #: str: *Optional* type
    type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class SystemAccountingModifyRadiusServerRequest(OCIRequest):
    """
    Request to modify a Radius Server in the system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("net_address", "netAddress", str, is_required=True),
        E("port", "port", int, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* netAddress
    net_address = Field(type=str, required=True, mutable=False)
    #: int: *Required* port
    port = Field(type=int, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class SystemAccountingReorderChargingFunctionElementServerRequest(OCIRequest):
    """
    Reorder the charging function element servers.

    You can not add or delete addresses, only re-ordering the list is allowed.  The
    ordered list of addresses can be obtained with the
    ``SystemAccountingGetChargingFunctionElementServerListRequest()`` command.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("ordered_address_list", "orderedAddressList", str, is_required=True),
    )

    #: str: *Required* orderedAddressList
    ordered_address_list = Field(type=str, required=True, mutable=False)


class SystemAdminAddRequest(OCIRequest):
    """
    Add a system or provisioning administrator.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("password", "password", str, is_required=True),
        E("language", "language", str),
        E("admin_type", "adminType", str, is_required=True),
        E("read_only", "readOnly", bool, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* firstName
    first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* lastName
    last_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* password
    password = Field(type=str, required=True, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)
    #: str: *Required* adminType
    admin_type = Field(type=str, required=True, mutable=False)
    #: bool: *Required* readOnly
    read_only = Field(type=bool, required=True, mutable=False)


class SystemAdminDeleteRequest(OCIRequest):
    """
    Delete a system or provisioning administrator.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class SystemAdminGetListRequest(OCIRequest):
    """
    Get a list of system administrators.

    The response is either a ``SystemAdminGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAdminGetRequest(OCIRequest):
    """
    Get a system or provisioning administrators profile.

    The response is either a ``SystemAdminGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class SystemAdminModifyRequest(OCIRequest):
    """
    Modify a system or provisioning administrator.

    Since old password is not specified here, any password rule related to old password
    does not apply.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("password", "password", str),
        E("language", "language", str),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* firstName
    first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* lastName
    last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)


class SystemAdviceOfChargeCostInformationSourceAddRequest(OCIRequest):
    """
    Add a cost information source.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("peer_identity", "peerIdentity", str, is_required=True),
        E("priority", "priority", int, is_required=True),
    )

    #: str: *Required* peerIdentity
    peer_identity = Field(type=str, required=True, mutable=False)
    #: int: *Required* priority
    priority = Field(type=int, required=True, mutable=False)


class SystemAdviceOfChargeCostInformationSourceDeleteRequest(OCIRequest):
    """
    Delete a cost information source.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("peer_identity", "peerIdentity", str, is_required=True),
    )

    #: str: *Required* peerIdentity
    peer_identity = Field(type=str, required=True, mutable=False)


class SystemAdviceOfChargeCostInformationSourceGetListRequest(OCIRequest):
    """
    Get a list of cost information sources.

    The response is either ``SystemAdviceOfChargeCostInformationSourceGetListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAdviceOfChargeCostInformationSourceModifyRequest(OCIRequest):
    """
    Modify a cost information source.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("peer_identity", "peerIdentity", str, is_required=True),
        E("priority", "priority", int, is_required=True),
    )

    #: str: *Required* peerIdentity
    peer_identity = Field(type=str, required=True, mutable=False)
    #: int: *Required* priority
    priority = Field(type=int, required=True, mutable=False)


class SystemAdviceOfChargeGetRequest(OCIRequest):
    """
    Request to get the list of Advice of Charge system parameters.

    The response is either ``SystemAdviceOfChargeGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAdviceOfChargeGetRequest19sp1(OCIRequest):
    """
    Request to get the list of Advice of Charge system parameters.

    The response is either ``SystemAdviceOfChargeGetResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAdviceOfChargeModifyRequest(OCIRequest):
    """
    Request to modify Advice of Charge system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("delay_between_notification_seconds", "delayBetweenNotificationSeconds", int),
        E("incoming_aoc_handling", "incomingAocHandling", str),
        E("cost_information_source", "costInformationSource", str),
    )

    #: int: *Optional* delayBetweenNotificationSeconds
    delay_between_notification_seconds = Field(type=int, required=False, mutable=False)
    #: str: *Optional* incomingAocHandling
    incoming_aoc_handling = Field(type=str, required=False, mutable=False)
    #: str: *Optional* costInformationSource
    cost_information_source = Field(type=str, required=False, mutable=False)


class SystemAdviceOfChargeModifyRequest19sp1(OCIRequest):
    """
    Request to modify Advice of Charge system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("delay_between_notification_seconds", "delayBetweenNotificationSeconds", int),
        E("incoming_aoc_handling", "incomingAocHandling", str),
        E("use_ocs_enquiry", "useOCSEnquiry", bool),
        E("ocs_enquiry_type", "OCSEnquiryType", str),
    )

    #: int: *Optional* delayBetweenNotificationSeconds
    delay_between_notification_seconds = Field(type=int, required=False, mutable=False)
    #: str: *Optional* incomingAocHandling
    incoming_aoc_handling = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useOCSEnquiry
    use_ocs_enquiry = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* OCSEnquiryType
    ocs_enquiry_type = Field(type=str, required=False, mutable=False)


class SystemAliasAddRequest(OCIRequest):
    """
    Add a system-level Application Server alias to the system.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("alias_net_address", "aliasNetAddress", str, is_required=True),
    )

    #: str: *Required* aliasNetAddress
    alias_net_address = Field(type=str, required=True, mutable=False)


class SystemAliasDeleteRequest(OCIRequest):
    """
    Delete a system-level Application Server alias from the system.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("alias_net_address", "aliasNetAddress", str, is_required=True),
    )

    #: str: *Required* aliasNetAddress
    alias_net_address = Field(type=str, required=True, mutable=False)


class SystemAliasGetListRequest(OCIRequest):
    """
    Requests the list of all system-level Application Server aliases.

    The response is either ``SystemAliasGetListResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAnonymousCallRejectionGetRequest(OCIRequest):
    """
    Get Anonymous Call Rejection system parameters.

    The response is either a ``SystemAnonymousCallRejectionGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAnonymousCallRejectionModifyRequest(OCIRequest):
    """
    Modify a system Anonymous Call Rejection parameter.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("pai_required", "paiRequired", bool),
        E("screen_only_local_calls", "screenOnlyLocalCalls", bool),
    )

    #: bool: *Optional* paiRequired
    pai_required = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* screenOnlyLocalCalls
    screen_only_local_calls = Field(type=bool, required=False, mutable=False)


class SystemApplicationControllerAddRequest(OCIRequest):
    """
    Add an application controller, which is a server where remote application resides and
    controls the Route Point.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("subscriber_id", "subscriberId", str, is_required=True),
        E("channel_set_id", "channelSetId", str, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* subscriberId
    subscriber_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* channelSetId
    channel_set_id = Field(type=str, required=True, mutable=False)


class SystemApplicationControllerDeleteRequest(OCIRequest):
    """
    Delete an application controller.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class SystemApplicationControllerGetListRequest(OCIRequest):
    """
    Get a list of application controllers that are configured for the system.

    The response is either ``SystemApplicationControllerGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAttendantConsoleGetRequest(OCIRequest):
    """
    Request to get the list of Attendant Console parameters.

    The response is either ``SystemAttendantConsoleGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAttendantConsoleModifyRequest(OCIRequest):
    """
    Modify Attendant Console settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("max_monitored_users", "maxMonitoredUsers", int),
    )

    #: int: *Optional* maxMonitoredUsers
    max_monitored_users = Field(type=int, required=False, mutable=False)


class SystemAuthenticationLockoutExportDataGetRequest(OCIRequest):
    """
    Request to export system wide authentication lockout data to a file.

    All locked out device profiles, sip endpoints, and sip trunk groups are returned.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("file_name", "fileName", str, is_required=True),
    )

    #: str: *Required* fileName
    file_name = Field(type=str, required=True, mutable=False)


class SystemAuthenticationLockoutSettingsGetRequest(OCIRequest):
    """
    Request to get the authentication lockout settings in the system.

    The response is either a ``SystemAuthenticationLockoutSettingsResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAuthenticationLockoutSettingsModifyRequest(OCIRequest):
    """
    Request to modify the system level device password lockout settings The response is
    either ``SuccessResponse()`` or ``ErrorResponse()``.

    """

    _ELEMENTS = (
        E("counter_reset_interval_days", "counterResetIntervalDays", int),
        E("counter_reset_hour", "counterResetHour", int),
        E("counter_reset_minute", "counterResetMinute", int),
        E("emergency_sip_bypass_allowed", "emergencySIPBypassAllowed", bool),
    )

    #: int: *Optional* counterResetIntervalDays
    counter_reset_interval_days = Field(type=int, required=False, mutable=False)
    #: int: *Optional* counterResetHour
    counter_reset_hour = Field(type=int, required=False, mutable=False)
    #: int: *Optional* counterResetMinute
    counter_reset_minute = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* emergencySIPBypassAllowed
    emergency_sip_bypass_allowed = Field(type=bool, required=False, mutable=False)


class SystemAutomaticCallbackAddReleaseCauseListRequest(OCIRequest):
    """
    Adds automatic callback release cause to the releaseCause attribute.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("release_cause", "releaseCause", str, is_array=True),
    )

    #: list(str): *Optional* releaseCause  *Array*
    release_cause = Field(type=list, required=False, mutable=False)


class SystemAutomaticCallbackDeleteReleaseCauseListRequest(OCIRequest):
    """
    Deletes automatic callback release causes from the release cause attribute.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("release_cause", "releaseCause", str, is_array=True),
    )

    #: list(str): *Optional* releaseCause  *Array*
    release_cause = Field(type=list, required=False, mutable=False)


class SystemAutomaticCallbackGetReleaseCauseListRequest(OCIRequest):
    """
    Request the system's automatic callback attributes.

    The response is either a ``SystemAutomaticCallbackGetReleaseCauseListResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAutomaticCallbackGetRequest(OCIRequest):
    """
    Request the system's automatic callback attributes.

    The response is either a ``SystemAutomaticCallbackGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced By: ``SystemAutomaticCallbackGetRequest15()``
    """

    _ELEMENTS = ()


class SystemAutomaticCallbackGetRequest15(OCIRequest):
    """
    Request the system's automatic callback attributes.

    The response is either a ``SystemAutomaticCallbackGetResponse15()`` or an
    ``ErrorResponse()``.

    Replaced By: ``SystemAutomaticCallbackGetRequest15sp2()``
    """

    _ELEMENTS = ()


class SystemAutomaticCallbackGetRequest15sp2(OCIRequest):
    """
    Request the system's automatic callback attributes.

    The response is either a ``SystemAutomaticCallbackGetResponse15sp2()`` or an
    ``ErrorResponse()``. Replaced by: ``SystemAutomaticCallbackGetRequest17()``
    """

    _ELEMENTS = ()


class SystemAutomaticCallbackGetRequest17(OCIRequest):
    """
    Request the system's automatic callback attributes.

    The response is either a ``SystemAutomaticCallbackGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAutomaticCallbackModifyRequest(OCIRequest):
    """
    Modifies the system's automatic callback attributes.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Replaced By: ``SystemAutomaticCallbackModifyRequest15()``
    """

    _ELEMENTS = (
        E("monitor_minutes", "monitorMinutes", int),
        E("wait_between_retry_originator_minutes", "waitBetweenRetryOriginatorMinutes", int),
        E("max_monitors_per_originator", "maxMonitorsPerOriginator", int),
        E("max_callback_rings", "maxCallbackRings", int),
        E("max_retry_originator_minutes", "maxRetryOriginatorMinutes", int),
    )

    #: int: *Optional* monitorMinutes
    monitor_minutes = Field(type=int, required=False, mutable=False)
    #: int: *Optional* waitBetweenRetryOriginatorMinutes
    wait_between_retry_originator_minutes = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxMonitorsPerOriginator
    max_monitors_per_originator = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxCallbackRings
    max_callback_rings = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxRetryOriginatorMinutes
    max_retry_originator_minutes = Field(type=int, required=False, mutable=False)


class SystemAutomaticCallbackModifyRequest15(OCIRequest):
    """
    Modifies the system's automatic callback attributes.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("monitor_minutes", "monitorMinutes", int),
        E("max_monitors_per_originator", "maxMonitorsPerOriginator", int),
        E("max_callback_rings", "maxCallbackRings", int),
        E("max_monitors_per_terminator", "maxMonitorsPerTerminator", int),
        E("terminator_idle_guard_seconds", "terminatorIdleGuardSeconds", int),
        E("callback_method", "callbackMethod", str),
        E("polling_interval_seconds", "pollingIntervalSeconds", int),
        E("activation_digit", "activationDigit", int),
    )

    #: int: *Optional* monitorMinutes
    monitor_minutes = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxMonitorsPerOriginator
    max_monitors_per_originator = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxCallbackRings
    max_callback_rings = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxMonitorsPerTerminator
    max_monitors_per_terminator = Field(type=int, required=False, mutable=False)
    #: int: *Optional* terminatorIdleGuardSeconds
    terminator_idle_guard_seconds = Field(type=int, required=False, mutable=False)
    #: str: *Optional* callbackMethod
    callback_method = Field(type=str, required=False, mutable=False)
    #: int: *Optional* pollingIntervalSeconds
    polling_interval_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* activationDigit
    activation_digit = Field(type=int, required=False, mutable=False)


class SystemBCCTAddOCIInterfaceAddressRequest(OCIRequest):
    """
    Add an OCI entry to the Broadworks Common Communication Transport (BCCT) protocol to
    interface mapping table.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("interface_net_address", "interfaceNetAddress", str, is_required=True),
    )

    #: str: *Required* interfaceNetAddress
    interface_net_address = Field(type=str, required=True, mutable=False)


class SystemBCCTDeleteOCIInterfaceAddressRequest(OCIRequest):
    """
    Delete an OCI entry in the Broadworks Common Communication Transport (BCCT) protocol
    to interface mapping table.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("interface_net_address", "interfaceNetAddress", str, is_required=True),
    )

    #: str: *Required* interfaceNetAddress
    interface_net_address = Field(type=str, required=True, mutable=False)


class SystemBCCTGetOCIInterfaceAddressListRequest(OCIRequest):
    """
    Get the OCI entries from the Broadworks Common Communication Transport (BCCT) protocol
    to interface mapping list.

    The response is ``SystemBCCTGetOCIInterfaceAddressListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBroadCloudGetRequest(OCIRequest):
    """
    Get the system interface attributes for Messaging Server.

    The response is either ``SystemBroadCloudGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBroadCloudModifyRequest(OCIRequest):
    """
    Modify the system interface attributes for Messaging Server.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("provisioning_url", "provisioningUrl", str),
        E("provisioning_user_id", "provisioningUserId", str),
        E("provisioning_password", "provisioningPassword", str),
        E("enable_synchronization", "enableSynchronization", bool),
    )

    #: str: *Optional* provisioningUrl
    provisioning_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* provisioningUserId
    provisioning_user_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* provisioningPassword
    provisioning_password = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableSynchronization
    enable_synchronization = Field(type=bool, required=False, mutable=False)


class SystemBroadWorksMobileManagerGetRequest(OCIRequest):
    """
    Get the BroadWorks Mobile Manager service system settings.

    The response is either ``SystemBroadWorksMobileManagerGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBroadWorksMobileManagerModifyRequest(OCIRequest):
    """
    Modify the BroadWorks Mobile Manager service system settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("scf_api_net_address1", "scfApiNetAddress1", str),
        E("scf_api_net_address2", "scfApiNetAddress2", str),
        E("user_name", "userName", str),
        E("password", "password", str),
        E("email_from_address", "emailFromAddress", str),
        E("scf_ims_only", "scfIMSOnly", bool),
        E("signaling_ip_address", "signalingIPAddress", str),
        E("signaling_port", "signalingPort", int),
    )

    #: str: *Optional* scfApiNetAddress1
    scf_api_net_address1 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* scfApiNetAddress2
    scf_api_net_address2 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userName
    user_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* emailFromAddress
    email_from_address = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* scfIMSOnly
    scf_ims_only = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* signalingIPAddress
    signaling_ip_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* signalingPort
    signaling_port = Field(type=int, required=False, mutable=False)


class SystemBroadWorksMobilityDeleteIMRNListRequest(OCIRequest):
    """
    Removes a BroadWorks Mobility IMRN number from the system.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("imrn_number", "imrnNumber", str, is_required=True),
    )

    #: str: *Required* imrnNumber
    imrn_number = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityDeleteMobileNetworkIMRNListRequest(OCIRequest):
    """
    Remove BroadWorks Mobility IMRN numbers from a Mobile Network.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("mobile_network_name", "mobileNetworkName", str, is_required=True),
        E("imrn_number", "imrnNumber", str, is_required=True),
    )

    #: str: *Required* mobileNetworkName
    mobile_network_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* imrnNumber
    imrn_number = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityGetRequest(OCIRequest):
    """
    Get the broadworks mobility system parameters.

    The response is either a ``SystemBroadWorksMobilityGetResponse()`` or an
    ``ErrorResponse()``. Replaced by: ``SystemBroadWorksMobilityGetRequest17sp4()``.
    """

    _ELEMENTS = ()


class SystemBroadWorksMobilityGetRequest17sp4(OCIRequest):
    """
    Get the broadworks mobility system parameters.

    The response is either a ``SystemBroadWorksMobilityGetResponse17sp4()`` or an
    ``ErrorResponse()``. Replaced by: ``SystemBroadWorksMobilityGetRequest19sp1()``
    """

    _ELEMENTS = ()


class SystemBroadWorksMobilityGetRequest19sp1(OCIRequest):
    """
    Get the broadworks mobility system parameters.

    The response is either a ``SystemBroadWorksMobilityGetResponse19sp1()`` or an
    ``ErrorResponse()``. Replaced by ``SystemBroadWorksMobilityGetRequest21()``
    """

    _ELEMENTS = ()


class SystemBroadWorksMobilityGetRequest21(OCIRequest):
    """
    Get the broadworks mobility system parameters.

    The response is either a ``SystemBroadWorksMobilityGetResponse21()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBroadWorksMobilityMobileNetworkAddRequest(OCIRequest):
    """
    Add a Mobile Network.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("scf_signaling_net_address", "scfSignalingNetAddress", str),
        E("scf_signaling_port", "scfSignalingPort", int),
        E("refresh_period_seconds", "refreshPeriodSeconds", int, is_required=True),
        E("max_consecutive_failures", "maxConsecutiveFailures", int, is_required=True),
        E(
            "max_response_wait_time_milliseconds", "maxResponseWaitTimeMilliseconds", int,
            is_required=True,
        ),
        E(
            "enable_announcement_suppression", "enableAnnouncementSuppression", bool,
            is_required=True,
        ),
        E("service_access_code_list_name", "serviceAccessCodeListName", str),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* scfSignalingNetAddress
    scf_signaling_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* scfSignalingPort
    scf_signaling_port = Field(type=int, required=False, mutable=False)
    #: int: *Required* refreshPeriodSeconds
    refresh_period_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxConsecutiveFailures
    max_consecutive_failures = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxResponseWaitTimeMilliseconds
    max_response_wait_time_milliseconds = Field(type=int, required=True, mutable=False)
    #: bool: *Required* enableAnnouncementSuppression
    enable_announcement_suppression = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* serviceAccessCodeListName
    service_access_code_list_name = Field(type=str, required=False, mutable=False)


class SystemBroadWorksMobilityMobileNetworkDeleteRequest(OCIRequest):
    """
    Delete a Mobile Network.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityMobileNetworkGetListRequest(OCIRequest):
    """
    Get the list of Mobile Networks.

    The response is either ``SystemBroadWorksMobilityMobileNetworkGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBroadWorksMobilityMobileNetworkGetRequest(OCIRequest):
    """
    Get a Mobile Network.

    The response is either ``SystemBroadWorksMobilityMobileNetworkGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityMobileNetworkModifyRequest(OCIRequest):
    """
    Modify a Mobile Network.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("new_name", "newName", str),
        E("scf_signaling_net_address", "scfSignalingNetAddress", str),
        E("scf_signaling_port", "scfSignalingPort", int),
        E("refresh_period_seconds", "refreshPeriodSeconds", int),
        E("max_consecutive_failures", "maxConsecutiveFailures", int),
        E("max_response_wait_time_milliseconds", "maxResponseWaitTimeMilliseconds", int),
        E("enable_announcement_suppression", "enableAnnouncementSuppression", bool),
        E("service_access_code_list_name", "serviceAccessCodeListName", str),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* newName
    new_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* scfSignalingNetAddress
    scf_signaling_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* scfSignalingPort
    scf_signaling_port = Field(type=int, required=False, mutable=False)
    #: int: *Optional* refreshPeriodSeconds
    refresh_period_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxConsecutiveFailures
    max_consecutive_failures = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxResponseWaitTimeMilliseconds
    max_response_wait_time_milliseconds = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* enableAnnouncementSuppression
    enable_announcement_suppression = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* serviceAccessCodeListName
    service_access_code_list_name = Field(type=str, required=False, mutable=False)


class SystemBroadWorksMobilityModifyRequest(OCIRequest):
    """
    Modify the BroadWorks Mobility system parameters.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Replaced by:
    ``SystemBroadWorksMobilityModifyRequest17sp4()``.
    """

    _ELEMENTS = (
        E("enable_location_services", "enableLocationServices", bool),
        E("enable_msrn_lookup", "enableMSRNLookup", bool),
        E("enable_mobile_state_checking", "enableMobileStateChecking", bool),
        E("deny_call_originations", "denyCallOriginations", bool),
        E("deny_call_terminations", "denyCallTerminations", bool),
        E("imrn_timeout_milliseconds", "imrnTimeoutMilliseconds", int),
        E("scf_signaling_ip_address", "scfSignalingIPAddress", str),
        E("scf_signaling_port", "scfSignalingPort", int),
    )

    #: bool: *Optional* enableLocationServices
    enable_location_services = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableMSRNLookup
    enable_msrn_lookup = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableMobileStateChecking
    enable_mobile_state_checking = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* denyCallOriginations
    deny_call_originations = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* denyCallTerminations
    deny_call_terminations = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* imrnTimeoutMilliseconds
    imrn_timeout_milliseconds = Field(type=int, required=False, mutable=False)
    #: str: *Optional* scfSignalingIPAddress
    scf_signaling_ip_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* scfSignalingPort
    scf_signaling_port = Field(type=int, required=False, mutable=False)


class SystemBroadWorksMobilityModifyRequest17sp4(OCIRequest):
    """
    Modify the BroadWorks Mobility system parameters.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Replaced by
    ``SystemBroadWorksMobilityModifyRequest21()``.
    """

    _ELEMENTS = (
        E("enable_location_services", "enableLocationServices", bool),
        E("enable_msrn_lookup", "enableMSRNLookup", bool),
        E("enable_mobile_state_checking", "enableMobileStateChecking", bool),
        E("deny_call_originations", "denyCallOriginations", bool),
        E("deny_call_terminations", "denyCallTerminations", bool),
        E("imrn_timeout_milliseconds", "imrnTimeoutMilliseconds", int),
        E("scf_signaling_net_address", "scfSignalingNetAddress", str),
        E("scf_signaling_port", "scfSignalingPort", int),
        E("refresh_period_seconds", "refreshPeriodSeconds", int),
        E("max_consecutive_failures", "maxConsecutiveFailures", int),
        E("max_response_wait_time_milliseconds", "maxResponseWaitTimeMilliseconds", int),
        E("enable_announcement_suppression", "enableAnnouncementSuppression", bool),
    )

    #: bool: *Optional* enableLocationServices
    enable_location_services = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableMSRNLookup
    enable_msrn_lookup = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableMobileStateChecking
    enable_mobile_state_checking = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* denyCallOriginations
    deny_call_originations = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* denyCallTerminations
    deny_call_terminations = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* imrnTimeoutMilliseconds
    imrn_timeout_milliseconds = Field(type=int, required=False, mutable=False)
    #: str: *Optional* scfSignalingNetAddress
    scf_signaling_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* scfSignalingPort
    scf_signaling_port = Field(type=int, required=False, mutable=False)
    #: int: *Optional* refreshPeriodSeconds
    refresh_period_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxConsecutiveFailures
    max_consecutive_failures = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxResponseWaitTimeMilliseconds
    max_response_wait_time_milliseconds = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* enableAnnouncementSuppression
    enable_announcement_suppression = Field(type=bool, required=False, mutable=False)


class SystemBroadWorksMobilityModifyRequest21(OCIRequest):
    """
    Modify the BroadWorks Mobility system parameters.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("enable_location_services", "enableLocationServices", bool),
        E("enable_msrn_lookup", "enableMSRNLookup", bool),
        E("enable_mobile_state_checking", "enableMobileStateChecking", bool),
        E("deny_call_originations", "denyCallOriginations", bool),
        E("deny_call_terminations", "denyCallTerminations", bool),
        E("imrn_timeout_milliseconds", "imrnTimeoutMilliseconds", int),
    )

    #: bool: *Optional* enableLocationServices
    enable_location_services = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableMSRNLookup
    enable_msrn_lookup = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableMobileStateChecking
    enable_mobile_state_checking = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* denyCallOriginations
    deny_call_originations = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* denyCallTerminations
    deny_call_terminations = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* imrnTimeoutMilliseconds
    imrn_timeout_milliseconds = Field(type=int, required=False, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeAddRequest(OCIRequest):
    """
    Add a system service access code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. Replaced by
    ``SystemBroadWorksMobilityServiceAccessCodeAddRequest21()``.
    """

    _ELEMENTS = (
        E("service_access_code", "serviceAccessCode", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* serviceAccessCode
    service_access_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* countryCode
    country_code = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeAddRequest21(OCIRequest):
    """
    Add a service access code to a list.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_access_code_list_name", "serviceAccessCodeListName", str,
            is_required=True,
        ),
        E("country_code", "countryCode", str, is_required=True),
        E("service_access_code", "serviceAccessCode", str, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* serviceAccessCodeListName
    service_access_code_list_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* countryCode
    country_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccessCode
    service_access_code = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeDeleteRequest(OCIRequest):
    """
    Delete a system service access code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. Replaced by
    ``SystemBroadWorksMobilityServiceAccessCodeDeleteRequest21()``.
    """

    _ELEMENTS = (
        E("country_code", "countryCode", str, is_required=True),
        E("service_access_code", "serviceAccessCode", str, is_required=True),
    )

    #: str: *Required* countryCode
    country_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccessCode
    service_access_code = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeDeleteRequest21(OCIRequest):
    """
    Delete a service access code from a list.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_access_code_list_name", "serviceAccessCodeListName", str,
            is_required=True,
        ),
        E("country_code", "countryCode", str, is_required=True),
        E("service_access_code", "serviceAccessCode", str, is_required=True),
    )

    #: str: *Required* serviceAccessCodeListName
    service_access_code_list_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* countryCode
    country_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccessCode
    service_access_code = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeGetListRequest(OCIRequest):
    """
    Get a list of system service access codes.

    The response is either ``SystemBroadWorksMobilityServiceAccessCodeGetListResponse()``
    or ``ErrorResponse()``. Replaced by
    ``SystemBroadWorksMobilityServiceAccessCodeGetListRequest21()``.
    """

    _ELEMENTS = ()


class SystemBroadWorksMobilityServiceAccessCodeGetListRequest21(OCIRequest):
    """
    Get a list of system service access codes.

    The response is either
    ``SystemBroadWorksMobilityServiceAccessCodeGetListResponse21()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_access_code_list_name", "serviceAccessCodeListName", str,
            is_required=True,
        ),
    )

    #: str: *Required* serviceAccessCodeListName
    service_access_code_list_name = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeListAddRequest(OCIRequest):
    """
    Add a Service Access Code list.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeListDeleteRequest(OCIRequest):
    """
    Delete a Service Access Code list.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeListGetListRequest(OCIRequest):
    """
    Get the list of Service Access Code lists.

    The response is either
    ``SystemBroadWorksMobilityServiceAccessCodeListGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBroadWorksMobilityServiceAccessCodeListModifyRequest(OCIRequest):
    """
    Modify a Service Access Code list.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("new_name", "newName", str),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* newName
    new_name = Field(type=str, required=False, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeListUsageGetRequest(OCIRequest):
    """
    Get all the Mobile Networks using a given Service Access Code list.

    The response is either
    ``SystemBroadWorksMobilityServiceAccessCodeListUsageGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_access_code_list_name", "serviceAccessCodeListName", str,
            is_required=True,
        ),
    )

    #: str: *Required* serviceAccessCodeListName
    service_access_code_list_name = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeModifyRequest(OCIRequest):
    """
    Modify a system service access code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. Replaced by
    ``SystemBroadWorksMobilityServiceAccessCodeModifyRequest21()``.
    """

    _ELEMENTS = (
        E("country_code", "countryCode", str, is_required=True),
        E("service_access_code", "serviceAccessCode", str, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* countryCode
    country_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccessCode
    service_access_code = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeModifyRequest21(OCIRequest):
    """
    Modify a service access code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_access_code_list_name", "serviceAccessCodeListName", str,
            is_required=True,
        ),
        E("country_code", "countryCode", str, is_required=True),
        E("service_access_code", "serviceAccessCode", str, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* serviceAccessCodeListName
    service_access_code_list_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* countryCode
    country_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccessCode
    service_access_code = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class SystemBroadWorksReceptionistEnterpriseGetRequest(OCIRequest):
    """
    Request to get the list of BroadWorks Receptionist - Enterprise parameters.

    The response is either ``SystemBroadWorksReceptionistEnterpriseGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBroadWorksReceptionistEnterpriseModifyRequest(OCIRequest):
    """
    Request to modify BroadWorks Receptionist - Enterprise settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("max_monitored_users", "maxMonitoredUsers", int),
    )

    #: int: *Optional* maxMonitoredUsers
    max_monitored_users = Field(type=int, required=False, mutable=False)


class SystemBusyLampFieldGetRequest(OCIRequest):
    """
    Request the system level data associated with the Busy Lamp Field service.

    The response is either a ``SystemBusyLampFieldGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBusyLampFieldGetRequest18(OCIRequest):
    """
    Request the system level data associated with the Busy Lamp Field service.

    The response is either a ``SystemBusyLampFieldGetResponse18()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBusyLampFieldModifyRequest(OCIRequest):
    """
    Modify the system level data associated with the Busy Lamp Field Service.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. The
    following elements are only used in AS data mode: forceUseOfTCP
    """

    _ELEMENTS = (
        E(
            "display_local_user_identity_last_name_first",
            "displayLocalUserIdentityLastNameFirst", bool,
        ),
        E("force_use_of_tcp", "forceUseOfTCP", bool),
    )

    #: bool: *Optional* displayLocalUserIdentityLastNameFirst
    display_local_user_identity_last_name_first = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* forceUseOfTCP
    force_use_of_tcp = Field(type=bool, required=False, mutable=False)


class SystemBwDiameterBaseDataGetRequest(OCIRequest):
    """
    Requests the list of System Diameter base parameters.

    The response is either ``SystemBwDiameterBaseDataGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBwDiameterBaseDataGetRequest17sp3(OCIRequest):
    """
    Requests the list of System Diameter base parameters.

    The response is either ``SystemBwDiameterBaseDataGetResponse17sp3()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBwDiameterBaseDataModifyRequest(OCIRequest):
    """
    Modifies the System Diameter base parameters.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("xs_realm", "xsRealm", str),
        E("xs_listening_port", "xsListeningPort", int),
        E("ps_realm", "psRealm", str),
        E("ps_listening_port", "psListeningPort", int),
        E("ps_relay_through_xs", "psRelayThroughXs", bool),
        E("xs_relay_listening_port", "xsRelayListeningPort", int),
        E("tc_timer_seconds", "tcTimerSeconds", int),
        E("tw_timer_seconds", "twTimerSeconds", int),
        E("request_timer_seconds", "requestTimerSeconds", int),
        E(
            "busy_peer_detection_outstanding_txn_count",
            "busyPeerDetectionOutstandingTxnCount", int,
        ),
        E(
            "busy_peer_restore_outstanding_txn_count",
            "busyPeerRestoreOutstandingTxnCount", int,
        ),
        E("dynamic_entry_inactivity_timer_hours", "dynamicEntryInactivityTimerHours", int),
        E(
            "advertised_offline_billing_application",
            "advertisedOfflineBillingApplication", str,
        ),
        E("advertised_online_billing_application", "advertisedOnlineBillingApplication", str),
    )

    #: str: *Optional* xsRealm
    xs_realm = Field(type=str, required=False, mutable=False)
    #: int: *Optional* xsListeningPort
    xs_listening_port = Field(type=int, required=False, mutable=False)
    #: str: *Optional* psRealm
    ps_realm = Field(type=str, required=False, mutable=False)
    #: int: *Optional* psListeningPort
    ps_listening_port = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* psRelayThroughXs
    ps_relay_through_xs = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* xsRelayListeningPort
    xs_relay_listening_port = Field(type=int, required=False, mutable=False)
    #: int: *Optional* tcTimerSeconds
    tc_timer_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* twTimerSeconds
    tw_timer_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* requestTimerSeconds
    request_timer_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* busyPeerDetectionOutstandingTxnCount
    busy_peer_detection_outstanding_txn_count = Field(type=int, required=False, mutable=False)
    #: int: *Optional* busyPeerRestoreOutstandingTxnCount
    busy_peer_restore_outstanding_txn_count = Field(type=int, required=False, mutable=False)
    #: int: *Optional* dynamicEntryInactivityTimerHours
    dynamic_entry_inactivity_timer_hours = Field(type=int, required=False, mutable=False)
    #: str: *Optional* advertisedOfflineBillingApplication
    advertised_offline_billing_application = Field(type=str, required=False, mutable=False)
    #: str: *Optional* advertisedOnlineBillingApplication
    advertised_online_billing_application = Field(type=str, required=False, mutable=False)


class SystemBwDiameterPeerAddRequest(OCIRequest):
    """
    Add a static entry in the Diameter Peer Table.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("identity", "identity", str, is_required=True),
        E("ip_address", "ipAddress", str),
        E("port", "port", int, is_required=True),
        E("enabled", "enabled", bool, is_required=True),
    )

    #: str: *Required* instance
    instance = Field(type=str, required=True, mutable=False)
    #: str: *Required* identity
    identity = Field(type=str, required=True, mutable=False)
    #: str: *Optional* ipAddress
    ip_address = Field(type=str, required=False, mutable=False)
    #: int: *Required* port
    port = Field(type=int, required=True, mutable=False)
    #: bool: *Required* enabled
    enabled = Field(type=bool, required=True, mutable=False)


class SystemBwDiameterPeerDeleteRequest(OCIRequest):
    """
    Remove a Diameter peer.

    A peer cannot be removed if is referenced by a Realm Routing Table entry.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("identity", "identity", str, is_required=True),
    )

    #: str: *Required* instance
    instance = Field(type=str, required=True, mutable=False)
    #: str: *Required* identity
    identity = Field(type=str, required=True, mutable=False)


class SystemBwDiameterPeerGetListRequest(OCIRequest):
    """
    Requests the list of Diameter peers.

    The response is either ``SystemBwDiameterPeerGetListResponse()`` or
    ``ErrorResponse()``
    """

    _ELEMENTS = ()


class SystemBwDiameterPeerModifyRequest(OCIRequest):
    """
    Modifies the attributes of an entry in the Diameter Peer Table.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("identity", "identity", str, is_required=True),
        E("ip_address", "ipAddress", str),
        E("port", "port", int),
        E("enabled", "enabled", bool),
    )

    #: str: *Required* instance
    instance = Field(type=str, required=True, mutable=False)
    #: str: *Required* identity
    identity = Field(type=str, required=True, mutable=False)
    #: str: *Optional* ipAddress
    ip_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* port
    port = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* enabled
    enabled = Field(type=bool, required=False, mutable=False)


class SystemBwDiameterRoutingPeerAddRequest(OCIRequest):
    """
    Add a Diameter routing peer.

    The realm must refer to a Diameter routing realm whose action is relay.  The
    destinationPeerIdentity must refer to an existing Diameter peer whose mode is active.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("realm", "realm", str, is_required=True),
        E("application_id", "applicationId", str, is_required=True),
        E("identity", "identity", str, is_required=True),
        E("priority", "priority", int, is_required=True),
        E("weight", "weight", int, is_required=True),
    )

    #: str: *Required* instance
    instance = Field(type=str, required=True, mutable=False)
    #: str: *Required* realm
    realm = Field(type=str, required=True, mutable=False)
    #: str: *Required* applicationId
    application_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* identity
    identity = Field(type=str, required=True, mutable=False)
    #: int: *Required* priority
    priority = Field(type=int, required=True, mutable=False)
    #: int: *Required* weight
    weight = Field(type=int, required=True, mutable=False)


class SystemBwDiameterRoutingPeerDeleteRequest(OCIRequest):
    """
    Remove a Diameter routing peer.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("realm", "realm", str, is_required=True),
        E("application_id", "applicationId", str, is_required=True),
        E("identity", "identity", str, is_required=True),
    )

    #: str: *Required* instance
    instance = Field(type=str, required=True, mutable=False)
    #: str: *Required* realm
    realm = Field(type=str, required=True, mutable=False)
    #: str: *Required* applicationId
    application_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* identity
    identity = Field(type=str, required=True, mutable=False)


class SystemBwDiameterRoutingPeerGetListRequest(OCIRequest):
    """
    Requests the list of Diameter routing peers associated with the specified realm.

    The response is either ``SystemBwDiameterRoutingPeerGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBwDiameterRoutingPeerModifyRequest(OCIRequest):
    """
    Modify a Diameter routing peer.

    The realm must refer to a Diameter routing realm whose action is relay.  The
    destinationPeerIdentity must refer to an existing Diameter peer whose mode is active.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("realm", "realm", str, is_required=True),
        E("application_id", "applicationId", str, is_required=True),
        E("identity", "identity", str, is_required=True),
        E("priority", "priority", int),
        E("weight", "weight", int),
    )

    #: str: *Required* instance
    instance = Field(type=str, required=True, mutable=False)
    #: str: *Required* realm
    realm = Field(type=str, required=True, mutable=False)
    #: str: *Required* applicationId
    application_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* identity
    identity = Field(type=str, required=True, mutable=False)
    #: int: *Optional* priority
    priority = Field(type=int, required=False, mutable=False)
    #: int: *Optional* weight
    weight = Field(type=int, required=False, mutable=False)


class SystemBwDiameterRoutingRealmAddRequest(OCIRequest):
    """
    Add a static entry in the Realm Routing Table.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("realm", "realm", str, is_required=True),
        E("application_id", "applicationId", str, is_required=True),
        E("default", "default", bool, is_required=True),
    )

    #: str: *Required* instance
    instance = Field(type=str, required=True, mutable=False)
    #: str: *Required* realm
    realm = Field(type=str, required=True, mutable=False)
    #: str: *Required* applicationId
    application_id = Field(type=str, required=True, mutable=False)
    #: bool: *Required* default
    default = Field(type=bool, required=True, mutable=False)


class SystemBwDiameterRoutingRealmDeleteRequest(OCIRequest):
    """
    Delete a static entry in the Realm Routing Table.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("realm", "realm", str, is_required=True),
        E("application_id", "applicationId", str, is_required=True),
    )

    #: str: *Required* instance
    instance = Field(type=str, required=True, mutable=False)
    #: str: *Required* realm
    realm = Field(type=str, required=True, mutable=False)
    #: str: *Required* applicationId
    application_id = Field(type=str, required=True, mutable=False)


class SystemBwDiameterRoutingRealmGetListRequest(OCIRequest):
    """
    Requests the list of Diameter routing realms.

    The response is either ``SystemBwDiameterRoutingRealmGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBwDiameterRoutingRealmModifyRequest(OCIRequest):
    """
    Modify a static entry in the Realm Routing Table.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("realm", "realm", str, is_required=True),
        E("application_id", "applicationId", str, is_required=True),
        E("default", "default", bool),
    )

    #: str: *Required* instance
    instance = Field(type=str, required=True, mutable=False)
    #: str: *Required* realm
    realm = Field(type=str, required=True, mutable=False)
    #: str: *Required* applicationId
    application_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* default
    default = Field(type=bool, required=False, mutable=False)


class SystemCAPAddACLEntryRequest14(OCIRequest):
    """
    Add an entry to the CAP access control list.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("net_address", "netAddress", str, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* netAddress
    net_address = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class SystemCAPDeleteACLEntryRequest(OCIRequest):
    """
    Delete an entry from the CAP access control list.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("net_address", "netAddress", str, is_required=True),
    )

    #: str: *Required* netAddress
    net_address = Field(type=str, required=True, mutable=False)


class SystemCAPGetACLListRequest14(OCIRequest):
    """
    Get the CAP access control list.

    The response is either ``SystemCAPGetACLListResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCAPModifyACLEntryRequest14(OCIRequest):
    """
    Modify an entry from the CAP access control list.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("net_address", "netAddress", str, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* netAddress
    net_address = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class SystemCAPParametersGetRequest(OCIRequest):
    """
    Request to get the list of CAP system parameters.

    The response is either ``SystemCAPParametersGetResponse()`` or ``ErrorResponse()``.

    Replaced By: ``SystemCAPParametersGetRequest14sp3()``
    """

    _ELEMENTS = ()


class SystemCAPParametersGetRequest14sp3(OCIRequest):
    """
    Request to get the list of CAP system parameters.

    The response is either ``SystemCAPParametersGetResponse14sp3()`` or
    ``ErrorResponse()``. Replaced by ``SystemCAPParametersGetRequest19()``
    """

    _ELEMENTS = ()


class SystemCAPParametersGetRequest19(OCIRequest):
    """
    Request to get the list of CAP system parameters.

    The response is either ``SystemCAPParametersGetResponse19()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCAPParametersModifyRequest(OCIRequest):
    """
    Request to modify CAP system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. Replaced by
    ``SystemCAPParametersModifyRequest19()``
    """

    _ELEMENTS = (
        E("server_port", "serverPort", int),
        E("max_client_connections", "maxClientConnections", int),
        E("enable_connection_ping", "enableConnectionPing", bool),
        E("connection_ping_interval_minutes", "connectionPingIntervalMinutes", int),
        E("ccc2_server_port", "CCC2ServerPort", int),
        E("ccc2_max_client_connections", "CCC2MaxClientConnections", int),
        E("cap_server_call_center_port", "capServerCallCenterPort", int),
        E(
            "cap_server_call_center_max_client_connections",
            "capServerCallCenterMaxClientConnections", int,
        ),
    )

    #: int: *Optional* serverPort
    server_port = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxClientConnections
    max_client_connections = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* enableConnectionPing
    enable_connection_ping = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* connectionPingIntervalMinutes
    connection_ping_interval_minutes = Field(type=int, required=False, mutable=False)
    #: int: *Optional* CCC2ServerPort
    ccc2_server_port = Field(type=int, required=False, mutable=False)
    #: int: *Optional* CCC2MaxClientConnections
    ccc2_max_client_connections = Field(type=int, required=False, mutable=False)
    #: int: *Optional* capServerCallCenterPort
    cap_server_call_center_port = Field(type=int, required=False, mutable=False)
    #: int: *Optional* capServerCallCenterMaxClientConnections
    cap_server_call_center_max_client_connections = Field(
        type=int, required=False, mutable=False,
    )


class SystemCAPParametersModifyRequest19(OCIRequest):
    """
    Request to modify CAP system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("server_port", "serverPort", int),
        E("max_client_connections", "maxClientConnections", int),
        E("enable_connection_ping", "enableConnectionPing", bool),
        E("connection_ping_interval_minutes", "connectionPingIntervalMinutes", int),
        E("ccc2_server_port", "CCC2ServerPort", int),
        E("ccc2_max_client_connections", "CCC2MaxClientConnections", int),
    )

    #: int: *Optional* serverPort
    server_port = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxClientConnections
    max_client_connections = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* enableConnectionPing
    enable_connection_ping = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* connectionPingIntervalMinutes
    connection_ping_interval_minutes = Field(type=int, required=False, mutable=False)
    #: int: *Optional* CCC2ServerPort
    ccc2_server_port = Field(type=int, required=False, mutable=False)
    #: int: *Optional* CCC2MaxClientConnections
    ccc2_max_client_connections = Field(type=int, required=False, mutable=False)


class SystemCPEConfigAddFileServerRequest(OCIRequest):
    """
    Add a device CPE config file server.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Replaced By: ``SystemCPEConfigAddFileServerRequest14sp6()``
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
        E("ftp_host_net_address", "ftpHostNetAddress", str, is_required=True),
        E("ftp_user_id", "ftpUserId", str, is_required=True),
        E("ftp_user_password", "ftpUserPassword", str, is_required=True),
        E("cpe_file_directory", "cpeFileDirectory", str),
        E("passive_ftp", "passiveFTP", bool),
    )

    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* ftpHostNetAddress
    ftp_host_net_address = Field(type=str, required=True, mutable=False)
    #: str: *Required* ftpUserId
    ftp_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* ftpUserPassword
    ftp_user_password = Field(type=str, required=True, mutable=False)
    #: str: *Optional* cpeFileDirectory
    cpe_file_directory = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* passiveFTP
    passive_ftp = Field(type=bool, required=False, mutable=False)


class SystemCPEConfigAddFileServerRequest14sp6(OCIRequest):
    """
    Add a device CPE config file server.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
        E("cpe_file_directory", "cpeFileDirectory", str),
        E("extended_capture_file_repository_name", "extendedCaptureFileRepositoryName", str),
    )

    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* cpeFileDirectory
    cpe_file_directory = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extendedCaptureFileRepositoryName
    extended_capture_file_repository_name = Field(type=str, required=False, mutable=False)


class SystemCPEConfigDeleteFileServerRequest(OCIRequest):
    """
    Delete a device CPE config file server.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
    )

    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)


class SystemCPEConfigGetFileServerListRequest(OCIRequest):
    """
    Requests the list of device CPE config file servers.

    The response is either ``SystemCPEConfigGetFileServerListResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``SystemCPEConfigGetFileServerListRequest14sp6()``
    """

    _ELEMENTS = ()


class SystemCPEConfigGetFileServerListRequest14sp6(OCIRequest):
    """
    Requests the list of device CPE config file servers.

    The response is either ``SystemCPEConfigGetFileServerListResponse14sp6()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCPEConfigModifyFileServerRequest(OCIRequest):
    """
    Modify a device CPE config file server.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Replaced By: ``SystemCPEConfigModifyFileServerRequest14sp6()``
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
        E("ftp_host_net_address", "ftpHostNetAddress", str),
        E("ftp_user_id", "ftpUserId", str),
        E("ftp_user_password", "ftpUserPassword", str),
        E("cpe_file_directory", "cpeFileDirectory", str),
        E("passive_ftp", "passiveFTP", bool),
    )

    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* ftpHostNetAddress
    ftp_host_net_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* ftpUserId
    ftp_user_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* ftpUserPassword
    ftp_user_password = Field(type=str, required=False, mutable=False)
    #: str: *Optional* cpeFileDirectory
    cpe_file_directory = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* passiveFTP
    passive_ftp = Field(type=bool, required=False, mutable=False)


class SystemCPEConfigModifyFileServerRequest14sp6(OCIRequest):
    """
    Modify a device CPE config file server.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str),
        E("cpe_file_directory", "cpeFileDirectory", str),
        E("extended_capture_file_repository_name", "extendedCaptureFileRepositoryName", str),
    )

    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* fileRepositoryName
    file_repository_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* cpeFileDirectory
    cpe_file_directory = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extendedCaptureFileRepositoryName
    extended_capture_file_repository_name = Field(type=str, required=False, mutable=False)


class SystemCPEConfigParametersGetRequest(OCIRequest):
    """
    Request to get the list of CPE Config system parameters.

    The response is either ``SystemCPEConfigParametersGetResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``SystemCPEConfigParametersGetRequest14sp6()``
    """

    _ELEMENTS = ()


class SystemCPEConfigParametersGetRequest14sp6(OCIRequest):
    """
    Request to get the list of CPE Config system parameters.

    The response is either ``SystemCPEConfigParametersGetResponse14sp6()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCPEConfigParametersGetRequest20(OCIRequest):
    """
    Request to get the list of CPE Config system parameters.

    The response is either ``SystemCPEConfigParametersGetResponse20()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCPEConfigParametersGetRequest21(OCIRequest):
    """
    Request to get the list of CPE Config system parameters.

    The response is either ``SystemCPEConfigParametersGetResponse21()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCPEConfigParametersModifyRequest(OCIRequest):
    """
    Request to modify CPE Config system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("enable_ip_device_management", "enableIPDeviceManagement", bool),
        E("ftp_connect_timeout_seconds", "ftpConnectTimeoutSeconds", int),
        E("ftp_file_transfer_timeout_seconds", "ftpFileTransferTimeoutSeconds", int),
        E(
            "pause_between_file_rebuild_milliseconds",
            "pauseBetweenFileRebuildMilliseconds", int,
        ),
        E("max_busy_time_minutes", "maxBusyTimeMinutes", int),
        E("device_access_app_server_cluster_name", "deviceAccessAppServerClusterName", str),
        E("file_rebuild_immediate", "fileRebuildImmediate", str, is_complex=True),  # unknown
        E("file_rebuild_daily", "fileRebuildDaily", str, is_complex=True),  # unknown
        E("file_rebuild_hourly", "fileRebuildHourly", str, is_complex=True),  # unknown
    )

    #: bool: *Optional* enableIPDeviceManagement
    enable_ip_device_management = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* ftpConnectTimeoutSeconds
    ftp_connect_timeout_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* ftpFileTransferTimeoutSeconds
    ftp_file_transfer_timeout_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* pauseBetweenFileRebuildMilliseconds
    pause_between_file_rebuild_milliseconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxBusyTimeMinutes
    max_busy_time_minutes = Field(type=int, required=False, mutable=False)
    #: str: *Optional* deviceAccessAppServerClusterName
    device_access_app_server_cluster_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* fileRebuildImmediate
    file_rebuild_immediate = Field(type=str, required=False, mutable=False)
    #: str: *Optional* fileRebuildDaily
    file_rebuild_daily = Field(type=str, required=False, mutable=False)
    #: str: *Optional* fileRebuildHourly
    file_rebuild_hourly = Field(type=str, required=False, mutable=False)


class SystemCPEConfigParametersModifyRequest20(OCIRequest):
    """
    Request to modify CPE Config system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("enable_ip_device_management", "enableIPDeviceManagement", bool),
        E("ftp_connect_timeout_seconds", "ftpConnectTimeoutSeconds", int),
        E("ftp_file_transfer_timeout_seconds", "ftpFileTransferTimeoutSeconds", int),
        E(
            "pause_between_file_rebuild_milliseconds",
            "pauseBetweenFileRebuildMilliseconds", int,
        ),
        E("max_busy_time_minutes", "maxBusyTimeMinutes", int),
        E("device_access_app_server_cluster_name", "deviceAccessAppServerClusterName", str),
    )

    #: bool: *Optional* enableIPDeviceManagement
    enable_ip_device_management = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* ftpConnectTimeoutSeconds
    ftp_connect_timeout_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* ftpFileTransferTimeoutSeconds
    ftp_file_transfer_timeout_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* pauseBetweenFileRebuildMilliseconds
    pause_between_file_rebuild_milliseconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxBusyTimeMinutes
    max_busy_time_minutes = Field(type=int, required=False, mutable=False)
    #: str: *Optional* deviceAccessAppServerClusterName
    device_access_app_server_cluster_name = Field(type=str, required=False, mutable=False)


class SystemCPEConfigParametersModifyRequest21(OCIRequest):
    """
    Request to modify CPE Config system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("enable_ip_device_management", "enableIPDeviceManagement", bool),
        E("ftp_connect_timeout_seconds", "ftpConnectTimeoutSeconds", int),
        E("ftp_file_transfer_timeout_seconds", "ftpFileTransferTimeoutSeconds", int),
        E(
            "pause_between_file_rebuild_milliseconds",
            "pauseBetweenFileRebuildMilliseconds", int,
        ),
        E("device_access_app_server_cluster_name", "deviceAccessAppServerClusterName", str),
        E("min_time_between_reset_milliseconds", "minTimeBetweenResetMilliseconds", int),
        E("always_push_files_on_rebuild", "alwaysPushFilesOnRebuild", bool),
        E("max_file_operation_retry_attempts", "maxFileOperationRetryAttempts", int),
        E("enable_auto_rebuild_config", "enableAutoRebuildConfig", bool),
        E("event_queue_size", "eventQueueSize", int),
        E("allow_device_credentials_retrieval", "allowDeviceCredentialsRetrieval", bool),
    )

    #: bool: *Optional* enableIPDeviceManagement
    enable_ip_device_management = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* ftpConnectTimeoutSeconds
    ftp_connect_timeout_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* ftpFileTransferTimeoutSeconds
    ftp_file_transfer_timeout_seconds = Field(type=int, required=False, mutable=False)
    #: int: *Optional* pauseBetweenFileRebuildMilliseconds
    pause_between_file_rebuild_milliseconds = Field(type=int, required=False, mutable=False)
    #: str: *Optional* deviceAccessAppServerClusterName
    device_access_app_server_cluster_name = Field(type=str, required=False, mutable=False)
    #: int: *Optional* minTimeBetweenResetMilliseconds
    min_time_between_reset_milliseconds = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* alwaysPushFilesOnRebuild
    always_push_files_on_rebuild = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxFileOperationRetryAttempts
    max_file_operation_retry_attempts = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* enableAutoRebuildConfig
    enable_auto_rebuild_config = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* eventQueueSize
    event_queue_size = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* allowDeviceCredentialsRetrieval
    allow_device_credentials_retrieval = Field(type=bool, required=False, mutable=False)


class SystemCPEConfigRebuildConfigFileRequest(OCIRequest):
    """
    Rebuild the system default config file for the specified device type.

    If the device type is not specified, all files for all device types in the system are
    rebuilt.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str),
        E("rebuild_type", "rebuildType", str),
        E("force", "force", bool),
    )

    #: str: *Optional* deviceType
    device_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* rebuildType
    rebuild_type = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* force
    force = Field(type=bool, required=False, mutable=False)


class SystemCPEConfigRebuildDeviceConfigFileRequest(OCIRequest):
    """
    Rebuild the config file for a specified device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("force", "force", bool),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* force
    force = Field(type=bool, required=False, mutable=False)


class SystemCPEConfigReorderDeviceLinePortsRequest(OCIRequest):
    """
    Reorder the lines of a System device.

    You can not add or delete line ports, only re-ordering the list is allowed.  The
    ordered list of line ports can be obtained with the
    ``SystemAccessDeviceGetRequest16()`` command.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("ordered_line_port_list", "orderedLinePortList", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* orderedLinePortList
    ordered_line_port_list = Field(type=str, required=True, mutable=False)


class SystemCPEConfigResetDeviceRequest(OCIRequest):
    """
    Reset a specific system device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class SystemCPEConfigResetDeviceTypeRequest(OCIRequest):
    """
    Reset all the devices of the specified device type in the system.

    If the device type is not specified, all device in the system are reset.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str),
    )

    #: str: *Optional* deviceType
    device_type = Field(type=str, required=False, mutable=False)


class SystemCPEConfigSetConfigFileRequest(OCIRequest):
    """
    Request to set a new system default configuration file for a device type.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
        E("config_file", "configFile", str, is_required=True),
    )

    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* configFile
    config_file = Field(type=str, required=True, mutable=False)


class SystemCallCenterEnhancedReportingBrandingGetRequest(OCIRequest):
    """
    Request to get the system branding information.

    The response is either ``SystemCallCenterEnhancedReportingBrandingGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallCenterEnhancedReportingDataTemplateGetListRequest(OCIRequest):
    """
    Request to get the list of data template and the corresponding information in the
    system.

    The response is either a
    ``SystemCallCenterEnhancedReportingDataTemplateGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallCenterEnhancedReportingGetRequest(OCIRequest):
    """
    Request to get the call center enhanced reporting system settings.

    The response is either a ``SystemCallCenterEnhancedReportingGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallCenterEnhancedReportingModifyRequest(OCIRequest):
    """
    Modify the system settings for call center enhanced reporting.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("archive_reports", "archiveReports", bool),
        E("report_application_url", "reportApplicationURL", str),
        E("repository_application_url", "repositoryApplicationURL", str),
    )

    #: bool: *Optional* archiveReports
    archive_reports = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* reportApplicationURL
    report_application_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* repositoryApplicationURL
    repository_application_url = Field(type=str, required=False, mutable=False)


class SystemCallCenterEnhancedReportingReportTemplateDeleteRequest(OCIRequest):
    """
    Request to delete a system level call center report template.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class SystemCallCenterEnhancedReportingReportTemplateGetListRequest(OCIRequest):
    """
    Request to get system level call center report template list.

    The response is either a
    ``SystemCallCenterEnhancedReportingReportTemplateGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallCenterEnhancedReportingReportTemplateGetRequest(OCIRequest):
    """
    Request to get a system level call center report template.

    The response is either a
    ``SystemCallCenterEnhancedReportingReportTemplateGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class SystemCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest(OCIRequest):
    """
    Request to get all the call center reporting scheduled report in the system that uses
    a given system level report template.

    The response is either a
    ``SystemCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class SystemCallCenterEnhancedReportingScheduledTaskParametersGetRequest(OCIRequest):
    """
    Request to get the system settings for the call center enhanced reporting scheduling
    tasks.

    The response is either a
    ``SystemCallCenterEnhancedReportingScheduledTaskParametersGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallCenterEnhancedReportingScheduledTaskParametersModifyRequest(OCIRequest):
    """
    Modify the system settings for the call center enhanced reporting scheduling tasks.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "scheduled_report_search_interval_minutes",
            "scheduledReportSearchIntervalMinutes", int,
        ),
        E(
            "maximum_scheduled_reports_per_interval",
            "maximumScheduledReportsPerInterval", int,
        ),
        E(
            "delete_scheduled_report_days_after_completion",
            "deleteScheduledReportDaysAfterCompletion", int,
        ),
    )

    #: int: *Optional* scheduledReportSearchIntervalMinutes
    scheduled_report_search_interval_minutes = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maximumScheduledReportsPerInterval
    maximum_scheduled_reports_per_interval = Field(type=int, required=False, mutable=False)
    #: int: *Optional* deleteScheduledReportDaysAfterCompletion
    delete_scheduled_report_days_after_completion = Field(
        type=int, required=False, mutable=False,
    )


class SystemCallCenterGetRequest(OCIRequest):
    """
    Request the system level data associated with Call Center.

    The response is either a ``SystemCallCenterGetResponse()`` or an ``ErrorResponse()``.

    Replaced By: ``SystemCallCenterGetRequest14sp9()``
    """

    _ELEMENTS = ()


class SystemCallCenterGetRequest14sp9(OCIRequest):
    """
    Request the system level data associated with Call Center.

    The response is either a ``SystemCallCenterGetResponse14sp9()`` or an
    ``ErrorResponse()``.

    Replaced By: ``SystemCallCenterGetRequest16()``
    """

    _ELEMENTS = ()


class SystemCallCenterGetRequest16(OCIRequest):
    """
    Request the system level data associated with Call Center.

    The response is either a ``SystemCallCenterGetResponse16()`` or an
    ``ErrorResponse()``. Replaced by: ``SystemCallCenterGetRequest17()``
    """

    _ELEMENTS = ()


class SystemCallCenterGetRequest17(OCIRequest):
    """
    Request the system level data associated with Call Center.

    The response is either a ``SystemCallCenterGetResponse17()`` or an
    ``ErrorResponse()``. Replaced by ``SystemCallCenterGetRequest17sp4()``.
    """

    _ELEMENTS = ()


class SystemCallCenterGetRequest17sp4(OCIRequest):
    """
    Request the system level data associated with Call Center.

    The response is either a ``SystemCallCenterGetResponse17sp4()`` or an
    ``ErrorResponse()``. Replaced by: ``SystemCallCenterGetRequest19()``
    """

    _ELEMENTS = ()


class SystemCallCenterGetRequest19(OCIRequest):
    """
    Request the system level data associated with Call Center.

    The response is either a ``SystemCallCenterGetResponse19()`` or an
    ``ErrorResponse()``. Replaced by ``SystemCallCenterGetRequest21()``.
    """

    _ELEMENTS = ()


class SystemCallCenterGetRequest21(OCIRequest):
    """
    Request the system level data associated with Call Center.

    The response is either a ``SystemCallCenterGetResponse21()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallCenterModifyRequest(OCIRequest):
    """
    Modify the system level data associated with Call Center.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str),
        E("statistics_sampling_period_minutes", "statisticsSamplingPeriodMinutes", int),
        E("default_enable_guard_timer", "defaultEnableGuardTimer", bool),
        E("default_guard_timer_seconds", "defaultGuardTimerSeconds", int),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable", bool,
        ),
        E("default_play_ring_when_offer_call", "defaultPlayRingWhenOfferCall", bool),
        E(
            "uniform_call_distribution_policy_scope",
            "uniformCallDistributionPolicyScope", str,
        ),
        E("call_handling_sampling_period_minutes", "callHandlingSamplingPeriodMinutes", int),
        E("call_handling_minimum_sampling_size", "callHandlingMinimumSamplingSize", int),
        E("play_tone_to_agent_for_emergency_call", "playToneToAgentForEmergencyCall", bool),
        E("emergency_call_clid_prefix", "emergencyCallCLIDPrefix", str),
        E(
            "threshold_crossing_notification_email_guard_timer_seconds",
            "thresholdCrossingNotificationEmailGuardTimerSeconds", int,
        ),
        E("allow_agent_device_initiated_forward", "allowAgentDeviceInitiatedForward", bool),
    )

    #: str: *Optional* defaultFromAddress
    default_from_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* statisticsSamplingPeriodMinutes
    statistics_sampling_period_minutes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* defaultEnableGuardTimer
    default_enable_guard_timer = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* defaultGuardTimerSeconds
    default_guard_timer_seconds = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnNotReachable
    force_agent_unavailable_on_not_reachable = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* defaultPlayRingWhenOfferCall
    default_play_ring_when_offer_call = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* uniformCallDistributionPolicyScope
    uniform_call_distribution_policy_scope = Field(type=str, required=False, mutable=False)
    #: int: *Optional* callHandlingSamplingPeriodMinutes
    call_handling_sampling_period_minutes = Field(type=int, required=False, mutable=False)
    #: int: *Optional* callHandlingMinimumSamplingSize
    call_handling_minimum_sampling_size = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* playToneToAgentForEmergencyCall
    play_tone_to_agent_for_emergency_call = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* emergencyCallCLIDPrefix
    emergency_call_clid_prefix = Field(type=str, required=False, mutable=False)
    #: int: *Optional* thresholdCrossingNotificationEmailGuardTimerSeconds
    threshold_crossing_notification_email_guard_timer_seconds = Field(
        type=int, required=False, mutable=False,
    )
    #: bool: *Optional* allowAgentDeviceInitiatedForward
    allow_agent_device_initiated_forward = Field(type=bool, required=False, mutable=False)


class SystemCallCenterReportingServerGetListRequest(OCIRequest):
    """
    Request to get a list of Call Center Reporting Server.

    The response is either ``SystemCallCenterReportingServerGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallMeNowGetRequest(OCIRequest):
    """
    Request the system level data associated with Call Me Now service.

    The response is either a ``SystemCallMeNowGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallMeNowModifyRequest(OCIRequest):
    """
    Modify the system level data associated with Call me now service.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("passcode_length", "passcodeLength", int),
        E("passcode_timeout_seconds", "passcodeTimeoutSeconds", int),
    )

    #: int: *Optional* passcodeLength
    passcode_length = Field(type=int, required=False, mutable=False)
    #: int: *Optional* passcodeTimeoutSeconds
    passcode_timeout_seconds = Field(type=int, required=False, mutable=False)


class SystemCallNotifyGetRequest(OCIRequest):
    """
    Request the system level data associated with Call Notify.

    The response is either a ``SystemCallNotifyGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallNotifyModifyRequest(OCIRequest):
    """
    Modify the system level data associated with Call Notify.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str),
        E("use_short_subject_line", "useShortSubjectLine", bool),
        E("use_dn_in_mail_body", "useDnInMailBody", bool),
    )

    #: str: *Optional* defaultFromAddress
    default_from_address = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useShortSubjectLine
    use_short_subject_line = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useDnInMailBody
    use_dn_in_mail_body = Field(type=bool, required=False, mutable=False)


class SystemCallProcessingGetPolicyRequest14(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse14()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest14sp1(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse14sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest14sp4(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse14sp4()`` or an
    ``ErrorResponse()``.

    Replaced By : ``SystemCallProcessingGetPolicyRequest15()``
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest14sp7(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse14sp7()`` or an
    ``ErrorResponse()``.

    Replaced By: ``SystemCallProcessingGetPolicyRequest16()``
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest15(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse15()`` or an
    ``ErrorResponse()``.

    Replaced By: ``SystemCallProcessingGetPolicyRequest16()``
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest15sp2(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse15sp2()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest16(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse16()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest16sp2(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse16sp2()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest17(OCIRequest):
    """
    The response is either a ``SystemCallProcessingGetPolicyResponse17()`` or an
    ``ErrorResponse()``.

    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest17sp3(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse17sp3()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest17sp4(OCIRequest):
    """
    The response is either a ``SystemCallProcessingGetPolicyResponse17sp4()`` or an
    ``ErrorResponse()``.

    Replaced By : ``SystemCallProcessingGetPolicyRequest18sp1()``
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest18sp1(OCIRequest):
    """
    The response is either a ``SystemCallProcessingGetPolicyResponse18sp1()`` or an
    ``ErrorResponse()``.

    Replaced by: ``SystemCallProcessingGetPolicyRequest19sp1()``
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest19sp1(OCIRequest):
    """
    The response is either a ``SystemCallProcessingGetPolicyResponse19sp1()`` or an
    ``ErrorResponse()``.

    """

    _ELEMENTS = ()


class SystemCallProcessingModifyPolicyRequest14(OCIRequest):
    """
    Modify the system level data associated with Call Processing Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Replaced By : ``SystemCallProcessingModifyPolicyRequest15()``
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("media_policy_selection", "mediaPolicySelection", str),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
        ),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
        E("clid_policy", "clidPolicy", str),
        E("emergency_clid_policy", "emergencyClidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
    )

    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int, required=False, mutable=False,
    )
    #: str: *Optional* mediaPolicySelection
    media_policy_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: int: *Optional* maxConferenceParties
    max_conference_parties = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=False, mutable=False,
    )
    #: str: *Optional* clidPolicy
    clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )


class SystemCallProcessingModifyPolicyRequest15(OCIRequest):
    """
    Modify the system level data associated with Call Processing Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. The
    following elements are only used in AS data mode: enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity enterpriseCallsCLIDPolicy
    enterpriseGroupCallsCLIDPolicy serviceProviderGroupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("media_policy_selection", "mediaPolicySelection", str),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
        E("clid_policy", "clidPolicy", str),
        E("emergency_clid_policy", "emergencyClidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("enterprise_group_calls_clid_policy", "enterpriseGroupCallsCLIDPolicy", str),
        E(
            "service_provider_group_calls_clid_policy",
            "serviceProviderGroupCallsCLIDPolicy", str,
        ),
    )

    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int, required=False, mutable=False,
    )
    #: str: *Optional* mediaPolicySelection
    media_policy_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: int: *Optional* maxConferenceParties
    max_conference_parties = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=False, mutable=False,
    )
    #: str: *Optional* clidPolicy
    clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: str: *Optional* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* enterpriseGroupCallsCLIDPolicy
    enterprise_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceProviderGroupCallsCLIDPolicy
    service_provider_group_calls_clid_policy = Field(type=str, required=False, mutable=False)


class SystemCallProcessingPolicyProfileAddRequest(OCIRequest):
    """
    Add a call processing policy profile to system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Replaced by
    ``SystemCallProcessingPolicyProfileAddRequest20()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("description", "description", str),
        E("assigned_subscriber_type", "assignedSubscriberType", str, is_array=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: list(str): *Optional* assignedSubscriberType  *Array*
    assigned_subscriber_type = Field(type=list, required=False, mutable=False)


class SystemCallProcessingPolicyProfileAddRequest20(OCIRequest):
    """
    Add a call processing policy profile to system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("description", "description", str),
        E("assigned_subscriber_type", "assignedSubscriberType", str, is_array=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: list(str): *Optional* assignedSubscriberType  *Array*
    assigned_subscriber_type = Field(type=list, required=False, mutable=False)


class SystemCallProcessingPolicyProfileAddRequest21(OCIRequest):
    """
    Add a call processing policy profile to system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("description", "description", str),
        E("assigned_subscriber_type", "assignedSubscriberType", str, is_array=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: list(str): *Optional* assignedSubscriberType  *Array*
    assigned_subscriber_type = Field(type=list, required=False, mutable=False)


class SystemCallProcessingPolicyProfileAutoAttendantProfileGetRequest(OCIRequest):
    """
    Request to get the configuration for a call processing policy profile Auto Attendant
    subscriber type profile.

    The response is either a
    ``SystemCallProcessingPolicyProfileAutoAttendantProfileGetRequestResponse()`` or an
    ``ErrorResponse()``. The response contains the call processing policy profile setting
    for Auto Attendant.
    """

    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
    )

    #: str: *Required* callProcessingPolicyProfileName
    call_processing_policy_profile_name = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileAutoAttendantProfileModifyRequest(OCIRequest):
    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
        E("use_clid_policy", "useCLIDPolicy", bool),
        E("clid_policy", "clidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("use_group_name", "useGroupName", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("allow_department_clid_name_override", "allowDepartmentCLIDNameOverride", bool),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("enterprise_group_calls_clid_policy", "enterpriseGroupCallsCLIDPolicy", str),
        E(
            "service_provider_group_calls_clid_policy",
            "serviceProviderGroupCallsCLIDPolicy", str,
        ),
        E("use_call_limits_policy", "useCallLimitsPolicy", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E("use_translation_routing_policy", "useTranslationRoutingPolicy", bool),
        E("network_usage_selection", "networkUsageSelection", str),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E("use_incoming_clid_policy", "useIncomingCLIDPolicy", bool),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool),
    )

    #: str: *Required* callProcessingPolicyProfileName
    call_processing_policy_profile_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useCLIDPolicy
    use_clid_policy = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* clidPolicy
    clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useGroupName
    use_group_name = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* enterpriseGroupCallsCLIDPolicy
    enterprise_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceProviderGroupCallsCLIDPolicy
    service_provider_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useCallLimitsPolicy
    use_call_limits_policy = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useTranslationRoutingPolicy
    use_translation_routing_policy = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useIncomingCLIDPolicy
    use_incoming_clid_policy = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=False, mutable=False)


class SystemCallProcessingPolicyProfileBroadWorksAnywhereProfileGetRequest(OCIRequest):
    """
    Request to get the configuration for a call processing policy profile BroadWorks
    Anywhere subscriber type profile.

    The response is either a
    ``SystemCallProcessingPolicyProfileBroadWorksAnywhereProfileGetRequestResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
    )

    #: str: *Required* callProcessingPolicyProfileName
    call_processing_policy_profile_name = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileBroadWorksAnywhereProfileModifyRequest(OCIRequest):
    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
        E("use_clid_policy", "useCLIDPolicy", bool),
        E("clid_policy", "clidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("use_group_name", "useGroupName", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("allow_department_clid_name_override", "allowDepartmentCLIDNameOverride", bool),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("enterprise_group_calls_clid_policy", "enterpriseGroupCallsCLIDPolicy", str),
        E(
            "service_provider_group_calls_clid_policy",
            "serviceProviderGroupCallsCLIDPolicy", str,
        ),
        E("use_call_limits_policy", "useCallLimitsPolicy", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E("use_translation_routing_policy", "useTranslationRoutingPolicy", bool),
        E("network_usage_selection", "networkUsageSelection", str),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E("use_incoming_clid_policy", "useIncomingCLIDPolicy", bool),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool),
    )

    #: str: *Required* callProcessingPolicyProfileName
    call_processing_policy_profile_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useCLIDPolicy
    use_clid_policy = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* clidPolicy
    clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useGroupName
    use_group_name = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* enterpriseGroupCallsCLIDPolicy
    enterprise_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceProviderGroupCallsCLIDPolicy
    service_provider_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useCallLimitsPolicy
    use_call_limits_policy = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useTranslationRoutingPolicy
    use_translation_routing_policy = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useIncomingCLIDPolicy
    use_incoming_clid_policy = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=False, mutable=False)


class SystemCallProcessingPolicyProfileCallCenterProfileGetRequest(OCIRequest):
    """
    Request to get the configuration for a call processing policy profile Call Center
    subscriber type profile.

    The response is either a
    ``SystemCallProcessingPolicyProfileCallCenterProfileGetRequestResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
    )

    #: str: *Required* callProcessingPolicyProfileName
    call_processing_policy_profile_name = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileCallCenterProfileModifyRequest(OCIRequest):
    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
        E("use_clid_policy", "useCLIDPolicy", bool),
        E("clid_policy", "clidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("use_group_name", "useGroupName", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("allow_department_clid_name_override", "allowDepartmentCLIDNameOverride", bool),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("enterprise_group_calls_clid_policy", "enterpriseGroupCallsCLIDPolicy", str),
        E(
            "service_provider_group_calls_clid_policy",
            "serviceProviderGroupCallsCLIDPolicy", str,
        ),
        E("use_call_limits_policy", "useCallLimitsPolicy", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E("use_translation_routing_policy", "useTranslationRoutingPolicy", bool),
        E("network_usage_selection", "networkUsageSelection", str),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E("use_incoming_clid_policy", "useIncomingCLIDPolicy", bool),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool),
    )

    #: str: *Required* callProcessingPolicyProfileName
    call_processing_policy_profile_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useCLIDPolicy
    use_clid_policy = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* clidPolicy
    clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useGroupName
    use_group_name = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* enterpriseGroupCallsCLIDPolicy
    enterprise_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceProviderGroupCallsCLIDPolicy
    service_provider_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useCallLimitsPolicy
    use_call_limits_policy = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useTranslationRoutingPolicy
    use_translation_routing_policy = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useIncomingCLIDPolicy
    use_incoming_clid_policy = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=False, mutable=False)


class SystemCallProcessingPolicyProfileCollaborateProfileGetRequest(OCIRequest):
    """
    Request to get the configuration for a call processing policy profile Collaborate
    subscriber type profile.

    The response is either a
    ``SystemCallProcessingPolicyProfileCollaborateProfileGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
    )

    #: str: *Required* callProcessingPolicyProfileName
    call_processing_policy_profile_name = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileCollaborateProfileModifyRequest(OCIRequest):
    """
    Request to get to modify the call processing policy profile collaborate subscriber
    type profile.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
        E("use_clid_policy", "useCLIDPolicy", bool),
        E("clid_policy", "clidPolicy", str),
        E("emergency_clid_policy", "emergencyClidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("use_group_name", "useGroupName", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("allow_department_clid_name_override", "allowDepartmentCLIDNameOverride", bool),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("enterprise_group_calls_clid_policy", "enterpriseGroupCallsCLIDPolicy", str),
        E(
            "service_provider_group_calls_clid_policy",
            "serviceProviderGroupCallsCLIDPolicy", str,
        ),
        E("use_call_limits_policy", "useCallLimitsPolicy", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E("use_translation_routing_policy", "useTranslationRoutingPolicy", bool),
        E("network_usage_selection", "networkUsageSelection", str),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E("use_incoming_clid_policy", "useIncomingCLIDPolicy", bool),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool),
    )

    #: str: *Required* callProcessingPolicyProfileName
    call_processing_policy_profile_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useCLIDPolicy
    use_clid_policy = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* clidPolicy
    clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useGroupName
    use_group_name = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* enterpriseGroupCallsCLIDPolicy
    enterprise_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceProviderGroupCallsCLIDPolicy
    service_provider_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useCallLimitsPolicy
    use_call_limits_policy = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int, required=False, mutable=False,
    )
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useTranslationRoutingPolicy
    use_translation_routing_policy = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useIncomingCLIDPolicy
    use_incoming_clid_policy = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=False, mutable=False)


class SystemCallProcessingPolicyProfileDeleteRequest(OCIRequest):
    """
    Delete a call processing policy profile from system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileFindMeFollowMeProfileGetRequest(OCIRequest):
    """
    Request to get the configuration for a call processing policy profile Find-me/Follow-
    me subscriber type profile.

    The response is either a
    ``SystemCallProcessingPolicyProfileFindMeFollowMeProfileGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
    )

    #: str: *Required* callProcessingPolicyProfileName
    call_processing_policy_profile_name = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileFindMeFollowMeProfileModifyRequest(OCIRequest):
    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
        E("use_clid_policy", "useCLIDPolicy", bool),
        E("clid_policy", "clidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("use_group_name", "useGroupName", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("allow_department_clid_name_override", "allowDepartmentCLIDNameOverride", bool),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("enterprise_group_calls_clid_policy", "enterpriseGroupCallsCLIDPolicy", str),
        E(
            "service_provider_group_calls_clid_policy",
            "serviceProviderGroupCallsCLIDPolicy", str,
        ),
        E("use_call_limits_policy", "useCallLimitsPolicy", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E("use_translation_routing_policy", "useTranslationRoutingPolicy", bool),
        E("network_usage_selection", "networkUsageSelection", str),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E("use_incoming_clid_policy", "useIncomingCLIDPolicy", bool),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool),
    )

    #: str: *Required* callProcessingPolicyProfileName
    call_processing_policy_profile_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useCLIDPolicy
    use_clid_policy = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* clidPolicy
    clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useGroupName
    use_group_name = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* enterpriseGroupCallsCLIDPolicy
    enterprise_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceProviderGroupCallsCLIDPolicy
    service_provider_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useCallLimitsPolicy
    use_call_limits_policy = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int, required=False, mutable=False,
    )
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=False, mutable=False,
    )
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useTranslationRoutingPolicy
    use_translation_routing_policy = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useIncomingCLIDPolicy
    use_incoming_clid_policy = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=False, mutable=False)


class SystemCallProcessingPolicyProfileFlexibleSeatingHostProfileGetRequest(OCIRequest):
    """
    Request to get the configuration for a call processing policy profile Flexible Seating
    Host subscriber type profile.

    The response is either a
    ``SystemCallProcessingPolicyProfileFlexibleSeatingHostProfileGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
    )

    #: str: *Required* callProcessingPolicyProfileName
    call_processing_policy_profile_name = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileFlexibleSeatingHostProfileModifyRequest(OCIRequest):
    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
        E("use_clid_policy", "useCLIDPolicy", bool),
        E("clid_policy", "clidPolicy", str),
        E("emergency_clid_policy", "emergencyClidPolicy", str),
        E("use_group_name", "useGroupName", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("allow_department_clid_name_override", "allowDepartmentCLIDNameOverride", bool),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("enterprise_group_calls_clid_policy", "enterpriseGroupCallsCLIDPolicy", str),
        E(
            "service_provider_group_calls_clid_policy",
            "serviceProviderGroupCallsCLIDPolicy", str,
        ),
        E("use_call_limits_policy", "useCallLimitsPolicy", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("use_translation_routing_policy", "useTranslationRoutingPolicy", bool),
        E("network_usage_selection", "networkUsageSelection", str),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
    )

    #: str: *Required* callProcessingPolicyProfileName
    call_processing_policy_profile_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useCLIDPolicy
    use_clid_policy = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* clidPolicy
    clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useGroupName
    use_group_name = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* enterpriseGroupCallsCLIDPolicy
    enterprise_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceProviderGroupCallsCLIDPolicy
    service_provider_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useCallLimitsPolicy
    use_call_limits_policy = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int, required=False, mutable=False,
    )
    #: bool: *Optional* useTranslationRoutingPolicy
    use_translation_routing_policy = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )


class SystemCallProcessingPolicyProfileGetAssignedNCOSListRequest(OCIRequest):
    """
    Request a list of NCOSs that have a given CallP Policy Profile assigned.

    The response is either a
    ``SystemCallProcessingPolicyProfileGetAssignedNCOSListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("profile_name", "profileName", str, is_required=True),
    )

    #: str: *Required* profileName
    profile_name = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileGetListRequest(OCIRequest):
    """
    Get the list of all Call Processing Policy Profiles.

    The response is either a ``SystemCallProcessingPolicyProfileGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallProcessingPolicyProfileGetRequest(OCIRequest):
    """
    Request to get a call processing policy profile in system.

    The response is either a ``SystemCallProcessingPolicyProfileGetResponse()`` or an
    ``ErrorResponse()``. Replaced by ``SystemCallProcessingPolicyProfileGetRequest20()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileGetRequest20(OCIRequest):
    """
    Request to get a call processing policy profile in system.

    The response is either a ``SystemCallProcessingPolicyProfileGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileGetRequest21(OCIRequest):
    """
    Request to get a call processing policy profile in system.

    The response is either a ``SystemCallProcessingPolicyProfileGetResponse21()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileGroupPagingProfileGetRequest(OCIRequest):
    """
    Request to get the configuration for a call processing policy profile Group Paging
    subscriber type profile.

    The response is either a
    ``SystemCallProcessingPolicyProfileGroupPagingProfileGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
    )

    #: str: *Required* callProcessingPolicyProfileName
    call_processing_policy_profile_name = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileGroupPagingProfileModifyRequest(OCIRequest):
    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
        E("use_clid_policy", "useCLIDPolicy", bool),
        E("clid_policy", "clidPolicy", str),
        E("use_group_name", "useGroupName", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("allow_department_clid_name_override", "allowDepartmentCLIDNameOverride", bool),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("enterprise_group_calls_clid_policy", "enterpriseGroupCallsCLIDPolicy", str),
        E(
            "service_provider_group_calls_clid_policy",
            "serviceProviderGroupCallsCLIDPolicy", str,
        ),
        E("use_call_limits_policy", "useCallLimitsPolicy", bool),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E("use_translation_routing_policy", "useTranslationRoutingPolicy", bool),
        E("network_usage_selection", "networkUsageSelection", str),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
    )

    #: str: *Required* callProcessingPolicyProfileName
    call_processing_policy_profile_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useCLIDPolicy
    use_clid_policy = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* clidPolicy
    clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useGroupName
    use_group_name = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* enterpriseGroupCallsCLIDPolicy
    enterprise_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceProviderGroupCallsCLIDPolicy
    service_provider_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useCallLimitsPolicy
    use_call_limits_policy = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int, required=False, mutable=False,
    )
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useTranslationRoutingPolicy
    use_translation_routing_policy = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )


class SystemCallProcessingPolicyProfileHuntGroupProfileGetRequest(OCIRequest):
    """
    Request to get the configuration for a call processing policy profile Hunt Group
    subscriber type profile.

    The response is either a
    ``SystemCallProcessingPolicyProfileHuntGroupProfileGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
    )

    #: str: *Required* callProcessingPolicyProfileName
    call_processing_policy_profile_name = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileHuntGroupProfileModifyRequest(OCIRequest):
    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
        E("use_clid_policy", "useCLIDPolicy", bool),
        E("clid_policy", "clidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("use_group_name", "useGroupName", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("allow_department_clid_name_override", "allowDepartmentCLIDNameOverride", bool),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("enterprise_group_calls_clid_policy", "enterpriseGroupCallsCLIDPolicy", str),
        E(
            "service_provider_group_calls_clid_policy",
            "serviceProviderGroupCallsCLIDPolicy", str,
        ),
        E("use_call_limits_policy", "useCallLimitsPolicy", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E("use_translation_routing_policy", "useTranslationRoutingPolicy", bool),
        E("network_usage_selection", "networkUsageSelection", str),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E("use_incoming_clid_policy", "useIncomingCLIDPolicy", bool),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool),
    )

    #: str: *Required* callProcessingPolicyProfileName
    call_processing_policy_profile_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* useCLIDPolicy
    use_clid_policy = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* clidPolicy
    clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useGroupName
    use_group_name = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* enterpriseGroupCallsCLIDPolicy
    enterprise_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceProviderGroupCallsCLIDPolicy
    service_provider_group_calls_clid_policy = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useCallLimitsPolicy
    use_call_limits_policy = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int, required=False, mutable=False,
    )
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=False, mutable=False,
    )
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=False, mutable=False)
    #: int: *