"""Broadworks OCI-P Interface Response Classes"""
# Autogenerated from the Broadworks XML Schemas.
# Do not edit as changes will be overwritten.
# Generated on 2020-10-13T18:33:21.784178
# fmt: off
from classforge import Field

import broadworks_ocip.types as OCI
from .base import ElementInfo as E
from .base import OCIResponse


class AuthenticationResponse(OCIResponse):
    """
    ``AuthenticationRequest()``/Response is 1st stage of the 2 stage OCI login process.

    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("nonce", "nonce", str, is_required=True),
        E("password_algorithm", "passwordAlgorithm", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* nonce
    nonce = Field(type=str, required=True, mutable=False)
    #: str: *Required* passwordAlgorithm
    password_algorithm = Field(type=str, required=True, mutable=False)


class AuthenticationVerifyResponse(OCIResponse):
    """
    Response to ``AuthenticationVerifyRequest()``

    Replaced By: ``AuthenticationVerifyResponse14sp8()``
    """

    _ELEMENTS = (
        E("login_type", "loginType", str, is_required=True),
        E("locale", "locale", str, is_required=True),
        E("encoding", "encoding", str, is_required=True),
        E("group_id", "groupId", str),
        E("service_provider_id", "serviceProviderId", str),
        E("is_enterprise", "isEnterprise", bool, is_required=True),
        E("password_expires_days", "passwordExpiresDays", int),
        E("user_domain", "userDomain", str, is_required=True),
        E("last_name", "lastName", str),
        E("first_name", "firstName", str),
    )

    #: str: *Required* loginType
    login_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* locale
    locale = Field(type=str, required=True, mutable=False)
    #: str: *Required* encoding
    encoding = Field(type=str, required=True, mutable=False)
    #: str: *Optional* groupId
    group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceProviderId
    service_provider_id = Field(type=str, required=False, mutable=False)
    #: bool: *Required* isEnterprise
    is_enterprise = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* passwordExpiresDays
    password_expires_days = Field(type=int, required=False, mutable=False)
    #: str: *Required* userDomain
    user_domain = Field(type=str, required=True, mutable=False)
    #: str: *Optional* lastName
    last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* firstName
    first_name = Field(type=str, required=False, mutable=False)


class AuthenticationVerifyResponse14sp8(OCIResponse):
    """
    Response to ``AuthenticationVerifyRequest14sp8()`` If a phoneNumber is returned, it
    will be the primay DN of the user
    """

    _ELEMENTS = (
        E("login_type", "loginType", str, is_required=True),
        E("locale", "locale", str, is_required=True),
        E("encoding", "encoding", str, is_required=True),
        E("group_id", "groupId", str),
        E("service_provider_id", "serviceProviderId", str),
        E("is_enterprise", "isEnterprise", bool, is_required=True),
        E("password_expires_days", "passwordExpiresDays", int),
        E("last_name", "lastName", str),
        E("first_name", "firstName", str),
        E("user_id", "userId", str, is_required=True),
        E("phone_number", "phoneNumber", str),
    )

    #: str: *Required* loginType
    login_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* locale
    locale = Field(type=str, required=True, mutable=False)
    #: str: *Required* encoding
    encoding = Field(type=str, required=True, mutable=False)
    #: str: *Optional* groupId
    group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceProviderId
    service_provider_id = Field(type=str, required=False, mutable=False)
    #: bool: *Required* isEnterprise
    is_enterprise = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* passwordExpiresDays
    password_expires_days = Field(type=int, required=False, mutable=False)
    #: str: *Optional* lastName
    last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* firstName
    first_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)


class DeviceManagementFileAuthLocationGetResponse(OCIResponse):
    """
    Return the address and credentials of the File Repository hosting the requested access
    device file.

    Also return the file name and path on the File Repository.  This is a response to
    ``DeviceManagementFileAuthLocationGetRequest()``.
    """

    _ELEMENTS = (
        E("file_repository_user_name", "fileRepositoryUserName", str, is_required=True),
        E("file_repository_password", "fileRepositoryPassword", str, is_required=True),
        E("net_address", "netAddress", str, is_required=True),
        E("remote_file_format", "remoteFileFormat", str, is_required=True),
        E("port_number", "portNumber", int),
        E("root_directory", "rootDirectory", str),
        E("cpe_file_directory", "cpeFileDirectory", str),
        E("secure", "secure", bool),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
        E("use_http_digest_authentication", "useHttpDigestAuthentication", bool),
        E("mac_based_file_authentication", "macBasedFileAuthentication", bool),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool,
        ),
        E("completion_notification", "completionNotification", bool),
        E("file_category", "fileCategory", str),
    )

    #: str: *Required* fileRepositoryUserName
    file_repository_user_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileRepositoryPassword
    file_repository_password = Field(type=str, required=True, mutable=False)
    #: str: *Required* netAddress
    net_address = Field(type=str, required=True, mutable=False)
    #: str: *Required* remoteFileFormat
    remote_file_format = Field(type=str, required=True, mutable=False)
    #: int: *Optional* portNumber
    port_number = Field(type=int, required=False, mutable=False)
    #: str: *Optional* rootDirectory
    root_directory = Field(type=str, required=False, mutable=False)
    #: str: *Optional* cpeFileDirectory
    cpe_file_directory = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* secure
    secure = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* macInNonRequestURI
    mac_in_non_request_uri = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useHttpDigestAuthentication
    use_http_digest_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* macBasedFileAuthentication
    mac_based_file_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* completionNotification
    completion_notification = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* fileCategory
    file_category = Field(type=str, required=False, mutable=False)


class DeviceManagementFileAuthLocationGetResponse17(OCIResponse):
    """
    Return the address and credentials of the File Repository hosting the requested access
    device file.

    Also return the file name and path on the File Repository.  This is a response to
    ``DeviceManagementFileAuthLocationGetRequest17()``. Replaced by:
    ``DeviceManagementFileAuthLocationGetRequest18()``
    """

    _ELEMENTS = (
        E("file_repository_user_name", "fileRepositoryUserName", str, is_required=True),
        E("file_repository_password", "fileRepositoryPassword", str, is_required=True),
        E("net_address", "netAddress", str, is_required=True),
        E("remote_file_format", "remoteFileFormat", str, is_required=True),
        E("port_number", "portNumber", int),
        E("root_directory", "rootDirectory", str),
        E("cpe_file_directory", "cpeFileDirectory", str),
        E("secure", "secure", bool),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
        E("use_http_digest_authentication", "useHttpDigestAuthentication", bool),
        E("mac_based_file_authentication", "macBasedFileAuthentication", bool),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool,
        ),
        E("completion_notification", "completionNotification", bool),
        E("file_category", "fileCategory", str),
    )

    #: str: *Required* fileRepositoryUserName
    file_repository_user_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileRepositoryPassword
    file_repository_password = Field(type=str, required=True, mutable=False)
    #: str: *Required* netAddress
    net_address = Field(type=str, required=True, mutable=False)
    #: str: *Required* remoteFileFormat
    remote_file_format = Field(type=str, required=True, mutable=False)
    #: int: *Optional* portNumber
    port_number = Field(type=int, required=False, mutable=False)
    #: str: *Optional* rootDirectory
    root_directory = Field(type=str, required=False, mutable=False)
    #: str: *Optional* cpeFileDirectory
    cpe_file_directory = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* secure
    secure = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* macInNonRequestURI
    mac_in_non_request_uri = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useHttpDigestAuthentication
    use_http_digest_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* macBasedFileAuthentication
    mac_based_file_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* completionNotification
    completion_notification = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* fileCategory
    file_category = Field(type=str, required=False, mutable=False)


class DeviceManagementFileAuthLocationGetResponse18(OCIResponse):
    """
    Return the address and credentials of the File Repository hosting the requested access
    device file.

    Also return the file name and path on the File Repository.  This is a response to
    ``DeviceManagementFileAuthLocationGetRequest18()``. Replaced by:
    ``DeviceManagementFileAuthLocationGetResponse21()``.
    """

    _ELEMENTS = (
        E("file_repository_user_name", "fileRepositoryUserName", str, is_required=True),
        E("file_repository_password", "fileRepositoryPassword", str, is_required=True),
        E("net_address", "netAddress", str, is_required=True),
        E("remote_file_format", "remoteFileFormat", str, is_required=True),
        E("port_number", "portNumber", int),
        E("root_directory", "rootDirectory", str),
        E("cpe_file_directory", "cpeFileDirectory", str),
        E("secure", "secure", bool),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
        E("use_http_digest_authentication", "useHttpDigestAuthentication", bool),
        E("mac_based_file_authentication", "macBasedFileAuthentication", bool),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool,
        ),
        E("completion_notification", "completionNotification", bool),
        E("file_category", "fileCategory", str),
        E("enable_caching", "enableCaching", bool),
    )

    #: str: *Required* fileRepositoryUserName
    file_repository_user_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileRepositoryPassword
    file_repository_password = Field(type=str, required=True, mutable=False)
    #: str: *Required* netAddress
    net_address = Field(type=str, required=True, mutable=False)
    #: str: *Required* remoteFileFormat
    remote_file_format = Field(type=str, required=True, mutable=False)
    #: int: *Optional* portNumber
    port_number = Field(type=int, required=False, mutable=False)
    #: str: *Optional* rootDirectory
    root_directory = Field(type=str, required=False, mutable=False)
    #: str: *Optional* cpeFileDirectory
    cpe_file_directory = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* secure
    secure = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* macInNonRequestURI
    mac_in_non_request_uri = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useHttpDigestAuthentication
    use_http_digest_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* macBasedFileAuthentication
    mac_based_file_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* completionNotification
    completion_notification = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* fileCategory
    file_category = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableCaching
    enable_caching = Field(type=bool, required=False, mutable=False)


class DeviceManagementFileAuthLocationGetResponse21(OCIResponse):
    """
    This is a response to ``DeviceManagementFileAuthLocationGetRequest21()``.

    Return the address and credentials of the File Repository hosting the requested access
    device file.  Also return the file name and path on the File Repository.  Also returns
    the status of the file authentication.
    """

    _ELEMENTS = (
        E("status", "status", str),
        E("file_repository_user_name", "fileRepositoryUserName", str, is_required=True),
        E("file_repository_password", "fileRepositoryPassword", str, is_required=True),
        E("net_address", "netAddress", str, is_required=True),
        E("remote_file_format", "remoteFileFormat", str, is_required=True),
        E("port_number", "portNumber", int),
        E("root_directory", "rootDirectory", str),
        E("cpe_file_directory", "cpeFileDirectory", str),
        E("secure", "secure", bool),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
        E("use_http_digest_authentication", "useHttpDigestAuthentication", bool),
        E("mac_based_file_authentication", "macBasedFileAuthentication", bool),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool,
        ),
        E("completion_notification", "completionNotification", bool),
        E("file_category", "fileCategory", str),
        E("enable_caching", "enableCaching", bool),
        E("notify_file_upload", "notifyFileUpload", bool),
    )

    #: str: *Optional* status
    status = Field(type=str, required=False, mutable=False)
    #: str: *Required* fileRepositoryUserName
    file_repository_user_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* fileRepositoryPassword
    file_repository_password = Field(type=str, required=True, mutable=False)
    #: str: *Required* netAddress
    net_address = Field(type=str, required=True, mutable=False)
    #: str: *Required* remoteFileFormat
    remote_file_format = Field(type=str, required=True, mutable=False)
    #: int: *Optional* portNumber
    port_number = Field(type=int, required=False, mutable=False)
    #: str: *Optional* rootDirectory
    root_directory = Field(type=str, required=False, mutable=False)
    #: str: *Optional* cpeFileDirectory
    cpe_file_directory = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* secure
    secure = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* macInNonRequestURI
    mac_in_non_request_uri = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* useHttpDigestAuthentication
    use_http_digest_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* macBasedFileAuthentication
    mac_based_file_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* completionNotification
    completion_notification = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* fileCategory
    file_category = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableCaching
    enable_caching = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* notifyFileUpload
    notify_file_upload = Field(type=bool, required=False, mutable=False)


class EnterpriseBroadWorksMobileManagerGetDomainListResponse(OCIResponse):
    """
    Response to the ``EnterpriseBroadWorksMobileManagerGetDomainListRequest()``.

    Contains the list of domains.
    """

    _ELEMENTS = (
        E("domain_name", "domainName", str, is_array=True),
    )

    #: list(str): *Optional* domainName  *Array*
    domain_name = Field(type=list, required=False, mutable=False)


class EnterpriseBroadWorksMobileManagerGetHomeZoneListResponse(OCIResponse):
    """
    Response to the ``EnterpriseBroadWorksMobileManagerGetHomeZoneListRequest()``.

    Contains a table with column headings: "Home Zone Id", "Domain Name", "Mobile Country
    Code", "Mobile Network Code", "Local Area Code" and "Cell Identity".
    """

    _ELEMENTS = (
        E(
            "home_zones_table", "homeZonesTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* homeZonesTable  *Tabular*
    home_zones_table = Field(type=list, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerGetHomeZoneResponse(OCIResponse):
    """
    Response to the ``EnterpriseBroadWorksMobileManagerGetHomeZoneRequest()``
    """

    _ELEMENTS = (
        E("home_zone_domain_name", "homeZoneDomainName", str, is_required=True),
        E("mobile_country_code", "mobileCountryCode", str, is_required=True),
        E("mobile_network_code", "mobileNetworkCode", str, is_required=True),
        E("location_area_code", "locationAreaCode", str, is_required=True),
        E("cell_identity", "cellIdentity", str, is_required=True),
    )

    #: str: *Required* homeZoneDomainName
    home_zone_domain_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* mobileCountryCode
    mobile_country_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* mobileNetworkCode
    mobile_network_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* locationAreaCode
    location_area_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* cellIdentity
    cell_identity = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseBroadWorksMobileManagerGetRequest()``
    """

    _ELEMENTS = (
        E("mobile_manager_id", "mobileManagerId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("local_to_carrier", "localToCarrier", bool, is_required=True),
        E("deactivation_reason", "deactivationReason", str),
        E("max_tx_per_second_enabled", "maxTxPerSecondEnabled", bool, is_required=True),
        E("max_tx_per_second", "maxTxPerSecond", int),
        E("tldn_enabled", "tldnEnabled", bool, is_required=True),
        E("generic_number_enabled", "genericNumberEnabled", bool, is_required=True),
        E("mobile_state_check_enabled", "mobileStateCheckEnabled", bool, is_required=True),
        E(
            "location_based_services_enabled", "locationBasedServicesEnabled", bool,
            is_required=True,
        ),
    )

    #: str: *Required* mobileManagerId
    mobile_manager_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* localToCarrier
    local_to_carrier = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* deactivationReason
    deactivation_reason = Field(type=str, required=False, mutable=False)
    #: bool: *Required* maxTxPerSecondEnabled
    max_tx_per_second_enabled = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* maxTxPerSecond
    max_tx_per_second = Field(type=int, required=False, mutable=False)
    #: bool: *Required* tldnEnabled
    tldn_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* genericNumberEnabled
    generic_number_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* mobileStateCheckEnabled
    mobile_state_check_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* locationBasedServicesEnabled
    location_based_services_enabled = Field(type=bool, required=True, mutable=False)


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListResponse(OCIResponse):
    """
    Response to
    ``EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListRequest()``.

    The response contains a table with columns: "Mobile Number", "User Id", "Last Name",
    "First Name","Phone Number","Extension", "Group Id", "Department" and "Mobile
    Network". The "Mobile Number" column contains a single DN. The "User Id", "Last Name"
    and "First Name" columns contains the corresponding attributes of the user possessing
    the DN(s). The "Phone Number" column contains a single DN. The "Group Id" column
    contains the Group Id of the user.  The "Department" column contains the department of
    the user if it is part of a department.  The "Mobile Network" column contains the
    Mobile Network the number belongs to.
    """

    _ELEMENTS = (
        E(
            "mobile_subscriber_directory_numbers_assignment_table",
            "mobileSubscriberDirectoryNumbersAssignmentTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* mobileSubscriberDirectoryNumbersAssignmentTable  *Tabular*
    mobile_subscriber_directory_numbers_assignment_table = Field(
        type=list, required=True, mutable=False,
    )


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse(OCIResponse):
    """
    Response to
    ``EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest()``.

    Contains a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any user.
    """

    _ELEMENTS = (
        E(
            "available_mobile_subscriber_directory_number",
            "availableMobileSubscriberDirectoryNumber", str, is_array=True,
        ),
    )

    #: list(str): *Optional* availableMobileSubscriberDirectoryNumber  *Array*
    available_mobile_subscriber_directory_number = Field(
        type=list, required=False, mutable=False,
    )


class EnterpriseCallCenterAgentThresholdDefaultProfileGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterAgentThresholdDefaultProfileGetRequest()``.

    The agent table contains the agents assigned to the profile and has column headings:
    "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address";
    """

    _ELEMENTS = (
        E("profile_name", "profileName", str, is_required=True),
        E("profile_description", "profileDescription", str),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed", int,
        ),
        E("threshold_average_busy_in_time_yellow", "thresholdAverageBusyInTimeYellow", int),
        E("threshold_average_busy_in_time_red", "thresholdAverageBusyInTimeRed", int),
        E("threshold_average_busy_out_time_yellow", "thresholdAverageBusyOutTimeYellow", int),
        E("threshold_average_busy_out_time_red", "thresholdAverageBusyOutTimeRed", int),
        E("threshold_average_wrap_up_time_yellow", "thresholdAverageWrapUpTimeYellow", int),
        E("threshold_average_wrap_up_time_red", "thresholdAverageWrapUpTimeRed", int),
        E("enable_notification_email", "enableNotificationEmail", bool, is_required=True),
        E("notification_email_address", "notificationEmailAddress", str),
        E("agent_table", "agentTable", list, is_complex=True, is_table=True),
    )

    #: str: *Required* profileName
    profile_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* profileDescription
    profile_description = Field(type=str, required=False, mutable=False)
    #: int: *Optional* thresholdCurrentCallStateIdleTimeYellow
    threshold_current_call_state_idle_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeRed
    threshold_current_call_state_idle_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeYellow
    threshold_current_call_state_on_call_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeRed
    threshold_current_call_state_on_call_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeYellow
    threshold_current_agent_state_unavailable_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeRed
    threshold_current_agent_state_unavailable_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeYellow
    threshold_average_busy_in_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyInTimeRed
    threshold_average_busy_in_time_red = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyOutTimeYellow
    threshold_average_busy_out_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyOutTimeRed
    threshold_average_busy_out_time_red = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageWrapUpTimeYellow
    threshold_average_wrap_up_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageWrapUpTimeRed
    threshold_average_wrap_up_time_red = Field(type=int, required=False, mutable=False)
    #: bool: *Required* enableNotificationEmail
    enable_notification_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* notificationEmailAddress
    notification_email_address = Field(type=str, required=False, mutable=False)
    #: list: *Optional* agentTable  *Tabular*
    agent_table = Field(type=list, required=False, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileGetAvailableAgentListResponse(OCIResponse):
    """
    Response to the
    ``EnterpriseCallCenterAgentThresholdProfileGetAvailableAgentListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address", "Agent Threshold Profile";
    """

    _ELEMENTS = (
        E(
            "agent_table", "agentTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* agentTable  *Tabular*
    agent_table = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterAgentThresholdProfileGetListRequest()``.

    Contains a table with all the Call Center Agent Threshold Profiles in the Enterprise.
    The column headings are: "Default", "Name", "Description".
    """

    _ELEMENTS = (
        E(
            "profiles_table", "profilesTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* profilesTable  *Tabular*
    profiles_table = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterAgentThresholdProfileGetRequest()``.

    The agentTable contains the agents assigned to the profile and has the column
    headings: "User Id", "Group Id", "Last Name", "First Name", "Hiragana Last Name",
    "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address";
    """

    _ELEMENTS = (
        E("profile_description", "profileDescription", str),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed", int,
        ),
        E("threshold_average_busy_in_time_yellow", "thresholdAverageBusyInTimeYellow", int),
        E("threshold_average_busy_in_time_red", "thresholdAverageBusyInTimeRed", int),
        E("threshold_average_busy_out_time_yellow", "thresholdAverageBusyOutTimeYellow", int),
        E("threshold_average_busy_out_time_red", "thresholdAverageBusyOutTimeRed", int),
        E("threshold_average_wrap_up_time_yellow", "thresholdAverageWrapUpTimeYellow", int),
        E("threshold_average_wrap_up_time_red", "thresholdAverageWrapUpTimeRed", int),
        E("enable_notification_email", "enableNotificationEmail", bool, is_required=True),
        E("notification_email_address", "notificationEmailAddress", str),
        E(
            "agent_table", "agentTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: str: *Optional* profileDescription
    profile_description = Field(type=str, required=False, mutable=False)
    #: int: *Optional* thresholdCurrentCallStateIdleTimeYellow
    threshold_current_call_state_idle_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeRed
    threshold_current_call_state_idle_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeYellow
    threshold_current_call_state_on_call_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeRed
    threshold_current_call_state_on_call_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeYellow
    threshold_current_agent_state_unavailable_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeRed
    threshold_current_agent_state_unavailable_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeYellow
    threshold_average_busy_in_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyInTimeRed
    threshold_average_busy_in_time_red = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyOutTimeYellow
    threshold_average_busy_out_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyOutTimeRed
    threshold_average_busy_out_time_red = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageWrapUpTimeYellow
    threshold_average_wrap_up_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageWrapUpTimeRed
    threshold_average_wrap_up_time_red = Field(type=int, required=False, mutable=False)
    #: bool: *Required* enableNotificationEmail
    enable_notification_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* notificationEmailAddress
    notification_email_address = Field(type=str, required=False, mutable=False)
    #: list: *Required* agentTable  *Tabular*
    agent_table = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterAgentUnavailableCodeGetListRequest()``.

    Contains a table with column headings: "Is Active", "Code", "Description".
    """

    _ELEMENTS = (
        E(
            "unavailable_codes_table", "unavailableCodesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* unavailableCodesTable  *Tabular*
    unavailable_codes_table = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterAgentUnavailableCodeGetRequest()``
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest()``.

    Replaced by ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse17sp4()``.
    """

    _ELEMENTS = (
        E(
            "enable_agent_unavailable_codes", "enableAgentUnavailableCodes", bool,
            is_required=True,
        ),
        E("default_agent_unavailable_code_on_dnd", "defaultAgentUnavailableCodeOnDND", str),
        E(
            "default_agent_unavailable_code_on_personal_calls",
            "defaultAgentUnavailableCodeOnPersonalCalls", str,
        ),
        E(
            "default_agent_unavailable_code_on_consecutive_bounces",
            "defaultAgentUnavailableCodeOnConsecutiveBounces", str,
        ),
        E(
            "force_use_of_agent_unavailable_codes", "forceUseOfAgentUnavailableCodes",
            bool, is_required=True,
        ),
        E("default_agent_unavailable_code", "defaultAgentUnavailableCode", str),
    )

    #: bool: *Required* enableAgentUnavailableCodes
    enable_agent_unavailable_codes = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* defaultAgentUnavailableCodeOnDND
    default_agent_unavailable_code_on_dnd = Field(type=str, required=False, mutable=False)
    #: str: *Optional* defaultAgentUnavailableCodeOnPersonalCalls
    default_agent_unavailable_code_on_personal_calls = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnConsecutiveBounces
    default_agent_unavailable_code_on_consecutive_bounces = Field(
        type=str, required=False, mutable=False,
    )
    #: bool: *Required* forceUseOfAgentUnavailableCodes
    force_use_of_agent_unavailable_codes = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* defaultAgentUnavailableCode
    default_agent_unavailable_code = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse17sp4(OCIResponse):
    """
    Response to ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest17sp4()``.

    """

    _ELEMENTS = (
        E(
            "enable_agent_unavailable_codes", "enableAgentUnavailableCodes", bool,
            is_required=True,
        ),
        E("default_agent_unavailable_code_on_dnd", "defaultAgentUnavailableCodeOnDND", str),
        E(
            "default_agent_unavailable_code_on_personal_calls",
            "defaultAgentUnavailableCodeOnPersonalCalls", str,
        ),
        E(
            "default_agent_unavailable_code_on_consecutive_bounces",
            "defaultAgentUnavailableCodeOnConsecutiveBounces", str,
        ),
        E(
            "default_agent_unavailable_code_on_not_reachable",
            "defaultAgentUnavailableCodeOnNotReachable", str,
        ),
        E(
            "force_use_of_agent_unavailable_codes", "forceUseOfAgentUnavailableCodes",
            bool, is_required=True,
        ),
        E("default_agent_unavailable_code", "defaultAgentUnavailableCode", str),
    )

    #: bool: *Required* enableAgentUnavailableCodes
    enable_agent_unavailable_codes = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* defaultAgentUnavailableCodeOnDND
    default_agent_unavailable_code_on_dnd = Field(type=str, required=False, mutable=False)
    #: str: *Optional* defaultAgentUnavailableCodeOnPersonalCalls
    default_agent_unavailable_code_on_personal_calls = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnConsecutiveBounces
    default_agent_unavailable_code_on_consecutive_bounces = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnNotReachable
    default_agent_unavailable_code_on_not_reachable = Field(
        type=str, required=False, mutable=False,
    )
    #: bool: *Required* forceUseOfAgentUnavailableCodes
    force_use_of_agent_unavailable_codes = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* defaultAgentUnavailableCode
    default_agent_unavailable_code = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterCallDispositionCodeGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCallDispositionCodeGetListRequest()``.

    Contains a table with column headings: "Is Active", "Code", "Description".
    """

    _ELEMENTS = (
        E(
            "disposition_codes_table", "dispositionCodesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* dispositionCodesTable  *Tabular*
    disposition_codes_table = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterCallDispositionCodeGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCallDispositionCodeGetRequest()``
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterCallDispositionCodeGetUsageListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCallDispositionCodeGetUsageListRequest()``.

    The Type column contains either "Call Center" or "Route Point". Contains a table with
    column headings: "Group Id", "Id", "Name" and "Type".
    """

    _ELEMENTS = (
        E(
            "call_center_table", "callCenterTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* callCenterTable  *Tabular*
    call_center_table = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterCurrentAndPastAgentGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCurrentAndPastAgentGetListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E(
            "agent_user_table", "agentUserTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
        E(
            "deleted_agent_user_table", "deletedAgentUserTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* agentUserTable  *Tabular*
    agent_user_table = Field(type=list, required=True, mutable=False)
    #: list: *Required* deletedAgentUserTable  *Tabular*
    deleted_agent_user_table = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterCurrentAndPastCallCenterGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCurrentAndPastCallCenterGetListRequest()``.

    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_array=True),
        E("deleted_service_user_id", "deletedServiceUserId", str, is_array=True),
    )

    #: list(str): *Optional* serviceUserId  *Array*
    service_user_id = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* deletedServiceUserId  *Array*
    deleted_service_user_id = Field(type=list, required=False, mutable=False)


class EnterpriseCallCenterCurrentAndPastDNISGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCurrentAndPastDNISGetListRequest()``.

    """

    _ELEMENTS = (
        E("name", "name", str, is_array=True),
        E("deleted_name", "deletedName", str, is_array=True),
    )

    #: list(str): *Optional* name  *Array*
    name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* deletedName  *Array*
    deleted_name = Field(type=list, required=False, mutable=False)


class EnterpriseCallCenterEnhancedReportingBrandingGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterEnhancedReportingBrandingGetRequest()``.

    """

    _ELEMENTS = (
        E("branding_choice", "brandingChoice", str, is_required=True),
        E("branding_file_description", "brandingFileDescription", str),
    )

    #: str: *Required* brandingChoice
    branding_choice = Field(type=str, required=True, mutable=False)
    #: str: *Optional* brandingFileDescription
    branding_file_description = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListResponse(OCIResponse):
    """
    Response to
    ``EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListRequest()``.

    Contains a table with column headings: "Name", "Description" and "Level", "Is Agent
    Required", "Is Call Center Required", "Is Call Center Dnis Required", "Is Real Time
    Report", "Is Sampling Period Required", "Call Completion Threshold Parameter", "Short
    Duration Threshold Parameter", "Service Level Threshold Parameter", "Service Level
    Inclusions Parameter", "Service Level Objective Threshold Parameter", "Abandoned Call
    Threshold Parameter", "Service Level Threshold Parameter Number", "Abandoned Call
    Threshold Parameter Number" and "Scope". The possible values for "Level" are "System"
    and "Enterprise". The possible values for "Is Agent Required", "Is Call Center
    Required", "Is Call Center Dnis Required", "Is Real Time Report" and "Is Sampling
    Period Required" are "true" and "false". The possible values for "Call Completion
    Threshold Parameter", "Short Duration Threshold Parameter", "Service Level Threshold
    Parameter", "Service Level Inclusions Parameter", "Service Level Objective Threshold
    Parameter" and "Abandoned Call Threshold Parameter" are "Required", "Hidden" and "Does
    Not Apply". The possible values for "Scope" are "Supervisor Only" and "Supervisor and
    Agent".
    """

    _ELEMENTS = (
        E(
            "report_template_table", "reportTemplateTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* reportTemplateTable  *Tabular*
    report_template_table = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingGetResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingGetRequest()``.

    Replaced by ``EnterpriseCallCenterEnhancedReportingGetResponse19()``
    """

    _ELEMENTS = (
        E("reporting_server", "reportingServer", str, is_required=True),
        E("web_statistic_source", "webStatisticSource", str, is_required=True),
    )

    #: str: *Required* reportingServer
    reporting_server = Field(type=str, required=True, mutable=False)
    #: str: *Required* webStatisticSource
    web_statistic_source = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingGetResponse19(OCIResponse):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingGetRequest19()``.

    """

    _ELEMENTS = (
        E("reporting_server", "reportingServer", str, is_required=True),
    )

    #: str: *Required* reportingServer
    reporting_server = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingReportTemplateGetListResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingReportTemplateGetListRequest()``.

    Contains a table with column headings: "Name", "Description", "Type" and "Enabled".
    """

    _ELEMENTS = (
        E(
            "report_template_table", "reportTemplateTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* reportTemplateTable  *Tabular*
    report_template_table = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingReportTemplateGetResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingReportTemplateGetRequest()``.

    """

    _ELEMENTS = (
        E("description", "description", str),
        E("data_template", "dataTemplate", str, is_required=True),
        E("filter_number", "filterNumber", int),
        E("xslt_template_description", "xsltTemplateDescription", str, is_required=True),
        E("scope", "scope", str, is_required=True),
        E("is_enabled", "isEnabled", bool, is_required=True),
        E("is_realtime_report", "isRealtimeReport", bool),
        E("call_completion_threshold_param", "callCompletionThresholdParam", str),
        E("short_duration_threshold_param", "shortDurationThresholdParam", str),
        E("service_level_threshold_param", "serviceLevelThresholdParam", str),
        E("service_level_inclusions_param", "serviceLevelInclusionsParam", str),
        E(
            "service_level_objective_threshold_param",
            "serviceLevelObjectiveThresholdParam", str,
        ),
        E("abandoned_call_threshold_param", "abandonedCallThresholdParam", str),
        E("service_level_threshold_param_number", "serviceLevelThresholdParamNumber", int),
        E("abandoned_call_threshold_param_number", "abandonedCallThresholdParamNumber", int),
        E("filter_value", "filterValue", str),
    )

    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Required* dataTemplate
    data_template = Field(type=str, required=True, mutable=False)
    #: int: *Optional* filterNumber
    filter_number = Field(type=int, required=False, mutable=False)
    #: str: *Required* xsltTemplateDescription
    xslt_template_description = Field(type=str, required=True, mutable=False)
    #: str: *Required* scope
    scope = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isEnabled
    is_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Optional* isRealtimeReport
    is_realtime_report = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* callCompletionThresholdParam
    call_completion_threshold_param = Field(type=str, required=False, mutable=False)
    #: str: *Optional* shortDurationThresholdParam
    short_duration_threshold_param = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceLevelThresholdParam
    service_level_threshold_param = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceLevelInclusionsParam
    service_level_inclusions_param = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceLevelObjectiveThresholdParam
    service_level_objective_threshold_param = Field(type=str, required=False, mutable=False)
    #: str: *Optional* abandonedCallThresholdParam
    abandoned_call_threshold_param = Field(type=str, required=False, mutable=False)
    #: int: *Optional* serviceLevelThresholdParamNumber
    service_level_threshold_param_number = Field(type=int, required=False, mutable=False)
    #: int: *Optional* abandonedCallThresholdParamNumber
    abandoned_call_threshold_param_number = Field(type=int, required=False, mutable=False)
    #: str: *Optional* filterValue
    filter_value = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterEnhancedReportingScheduledReportGetActiveListResponse(OCIResponse):
    """
    Response to
    ``EnterpriseCallCenterEnhancedReportingScheduledReportGetActiveListRequest()``.

    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Report Template Name", "Report Template Level" and
    "Recurring". The "Created By" can be either "Administrator" or user id if created by
    supervisor.  The possible values for "Recurring" are "None", "Daily", "Weekly",
    "Monthly" and "Yearly". The possible values for "Report Level" are "System" and
    "Enterprise".
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* scheduledReportTable  *Tabular*
    scheduled_report_table = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingScheduledReportGetCompletedListResponse(OCIResponse):
    """
    Response to
    ``EnterpriseCallCenterEnhancedReportingScheduledReportGetCompletedListRequest()``
    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Report Template Name", "Report Template Level" and
    "Recurring".

    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and
    "Yearly". The possible values for "Report Level" are "System" and "Enterprise".
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* scheduledReportTable  *Tabular*
    scheduled_report_table = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingScheduledReportGetListResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingScheduledReportGetListRequest()``.

    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Status", "Report Template Name", "Report Template Level" and
    "Recurring". The "Created By" can be either "Administrator" or user id if created by
    supervisor.  The possible values for "Status" are "Active", and "Completed". The
    possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and "Yearly".
    The possible values for "Report Level" are "System" and "Enterprise".
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* scheduledReportTable  *Tabular*
    scheduled_report_table = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse(OCIResponse):
    """
    Response to
    ``EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest()``.

    Contains a table with column headings: "Schedule Name", "Created By", "Created By
    Supervisor", and "Is Active". The "Created By" can be either "Administrator" or user
    id if created by supervisor.
    """

    _ELEMENTS = (
        E(
            "schedule_report_table", "scheduleReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* scheduleReportTable  *Tabular*
    schedule_report_table = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterGetResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterGetRequest()``.

    Replaced by ``EnterpriseCallCenterGetResponse17sp4()``.
    """

    _ELEMENTS = (
        E(
            "use_system_default_guard_timer", "useSystemDefaultGuardTimer", bool,
            is_required=True,
        ),
        E("enable_guard_timer", "enableGuardTimer", bool, is_required=True),
        E("guard_timer_seconds", "guardTimerSeconds", int, is_required=True),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings", bool,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int,
        ),
    )

    #: bool: *Required* useSystemDefaultGuardTimer
    use_system_default_guard_timer = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableGuardTimer
    enable_guard_timer = Field(type=bool, required=True, mutable=False)
    #: int: *Required* guardTimerSeconds
    guard_timer_seconds = Field(type=int, required=True, mutable=False)
    #: bool: *Optional* useSystemDefaultUnavailableSettings
    use_system_default_unavailable_settings = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int, required=False, mutable=False,
    )


class EnterpriseCallCenterGetResponse17sp4(OCIResponse):
    """
    Response to ``EnterpriseCallCenterGetRequest17sp4()``.

    """

    _ELEMENTS = (
        E(
            "use_system_default_guard_timer", "useSystemDefaultGuardTimer", bool,
            is_required=True,
        ),
        E("enable_guard_timer", "enableGuardTimer", bool, is_required=True),
        E("guard_timer_seconds", "guardTimerSeconds", int, is_required=True),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings", bool,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable", bool,
        ),
    )

    #: bool: *Required* useSystemDefaultGuardTimer
    use_system_default_guard_timer = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableGuardTimer
    enable_guard_timer = Field(type=bool, required=True, mutable=False)
    #: int: *Required* guardTimerSeconds
    guard_timer_seconds = Field(type=int, required=True, mutable=False)
    #: bool: *Optional* useSystemDefaultUnavailableSettings
    use_system_default_unavailable_settings = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnNotReachable
    force_agent_unavailable_on_not_reachable = Field(type=bool, required=False, mutable=False)


class EnterpriseCallCenterGetRoutingPolicyResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterGetRoutingPolicyRequest()``.

    Contains a table with column headings: "Service User Id", "Name" and "Priority".
    """

    _ELEMENTS = (
        E("routing_policy", "routingPolicy", str, is_required=True),
        E(
            "call_center_table", "callCenterTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: str: *Required* routingPolicy
    routing_policy = Field(type=str, required=True, mutable=False)
    #: list: *Required* callCenterTable  *Tabular*
    call_center_table = Field(type=list, required=True, mutable=False)


class EnterpriseEnterpriseTrunkGetAvailableUserListResponse(OCIResponse):
    """
    Response to ``EnterpriseEnterpriseTrunkGetAvailableUserListRequest()``.

    The column headings for the enterpriseTrunkUserTable are: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name", "Phone Number",
    "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class EnterpriseEnterpriseTrunkGetListResponse(OCIResponse):
    """
    Response to ``EnterpriseEnterpriseTrunkGetListRequest()``.

    Contains a table of enterprise trunks defined in the enterprise The column headings
    are: "Enterprise Trunk Name", "Routing Type"
    """

    _ELEMENTS = (
        E(
            "enterprise_trunk_table", "enterpriseTrunkTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* enterpriseTrunkTable  *Tabular*
    enterprise_trunk_table = Field(type=list, required=True, mutable=False)


class EnterpriseEnterpriseTrunkGetResponse(OCIResponse):
    """
    Response to ``EnterpriseEnterpriseTrunkGetRequest()``.

    Replaced by: ``EnterpriseEnterpriseTrunkGetResponse21()``.
    """

    _ELEMENTS = (
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int, is_required=True),
        E("route_exhaustion_action", "routeExhaustionAction", str, is_required=True),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
    )

    #: int: *Required* maximumRerouteAttempts
    maximum_reroute_attempts = Field(type=int, required=True, mutable=False)
    #: str: *Required* routeExhaustionAction
    route_exhaustion_action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* orderedRouting
    ordered_routing = Field(type=str, required=False, mutable=False)
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(type=str, required=False, mutable=False)


class EnterpriseEnterpriseTrunkGetResponse21(OCIResponse):
    """
    Response to ``EnterpriseEnterpriseTrunkGetRequest21()``.

    """

    _ELEMENTS = (
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int, is_required=True),
        E("route_exhaustion_action", "routeExhaustionAction", str, is_required=True),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
        E("enable_capacity_management", "enableCapacityManagement", bool, is_required=True),
        E("max_active_calls", "maxActiveCalls", int),
        E("capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls", int),
        E("capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int),
    )

    #: int: *Required* maximumRerouteAttempts
    maximum_reroute_attempts = Field(type=int, required=True, mutable=False)
    #: str: *Required* routeExhaustionAction
    route_exhaustion_action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* orderedRouting
    ordered_routing = Field(type=str, required=False, mutable=False)
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(type=str, required=False, mutable=False)
    #: bool: *Required* enableCapacityManagement
    enable_capacity_management = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* maxActiveCalls
    max_active_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(type=int, required=False, mutable=False)


class EnterpriseEnterpriseTrunkGetUserListResponse(OCIResponse):
    """
    Response to ``EnterpriseEnterpriseTrunkGetUserListRequest()``.

    The column headings for the enterpriseTrunkUserTable are: "Group Id", "User Id", "Last
    Name", "First Name", "Phone Number", "Alternate Trunk Identity", "Hiragana Last Name",
    "Hiragana First Name", "Extension", "Department", "Email Address" and "Route List
    Assigned".
    """

    _ELEMENTS = (
        E(
            "enterprise_trunk_user_table", "enterpriseTrunkUserTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* enterpriseTrunkUserTable  *Tabular*
    enterprise_trunk_user_table = Field(type=list, required=True, mutable=False)


class EnterprisePhoneDirectoryGetListResponse(OCIResponse):
    """
    Response to ``EnterprisePhoneDirectoryGetListRequest()``.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id". If extended directory information is requested, the following
    columns are also included: "First Name", "Last Name", "User Id", "Pager", "Title",
    "Time Zone", "Location", "Address Line 1", "Address Line 2", "City", "State", "Zip",
    "Country". Replace by: ``EnterprisePhoneDirectoryGetListResponse17()``
    """

    _ELEMENTS = (
        E(
            "directory_table", "directoryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* directoryTable  *Tabular*
    directory_table = Field(type=list, required=True, mutable=False)


class EnterprisePhoneDirectoryGetListResponse17(OCIResponse):
    """
    Response to ``EnterprisePhoneDirectoryGetListRequest17()``.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "Is Virtual On-Net User". If extended directory information is
    requested, the following columns are also included: "First Name", "Last Name", "User
    Id", "Pager", "Title", "Time Zone", "Location", "Address Line 1", "Address Line 2",
    "City", "State", "Zip", "Country". Replaced by:
    ``EnterprisePhoneDirectoryGetListResponse18()``
    """

    _ELEMENTS = (
        E(
            "directory_table", "directoryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* directoryTable  *Tabular*
    directory_table = Field(type=list, required=True, mutable=False)


class EnterprisePhoneDirectoryGetListResponse17sp3(OCIResponse):
    """
    Response to ``EnterprisePhoneDirectoryGetListRequest17sp3()``.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "IMP Id", "Is Virtual On-Net User". If extended directory
    information is requested, the following columns are also included: "First Name", "Last
    Name", "User Id", "Pager", "Title", "Time Zone", "Location", "Address Line 1",
    "Address Line 2", "City", "State", "Zip", "Country". Replaced by:
    ``EnterprisePhoneDirectoryGetListResponse18()``
    """

    _ELEMENTS = (
        E(
            "directory_table", "directoryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* directoryTable  *Tabular*
    directory_table = Field(type=list, required=True, mutable=False)


class EnterprisePhoneDirectoryGetListResponse18(OCIResponse):
    """
    Response to ``EnterprisePhoneDirectoryGetListRequest18()``.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "User Id", "IMP Id", "Is Virtual On-Net User". If extended
    directory information is requested, the following columns are also included: "First
    Name", "Last Name", "Pager", "Title", "Time Zone", "Location", "Address Line 1",
    "Address Line 2", "City", "State", "Zip", "Country".
    """

    _ELEMENTS = (
        E(
            "directory_table", "directoryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* directoryTable  *Tabular*
    directory_table = Field(type=list, required=True, mutable=False)


class EnterprisePreAlertingAnnouncementGetResponse(OCIResponse):
    """
    Get the Enterprise level pre-alerting service settings.

    The response is either a ``EnterprisePreAlertingAnnouncementGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("announcement_interruption", "announcementInterruption", str, is_required=True),
        E("interruption_digit_sequence", "interruptionDigitSequence", str),
        E("audio_selection", "audioSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("audio_file_url", "audioFileUrl", str),
        E("video_selection", "videoSelection", str, is_required=True),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E("video_file_url", "videoFileUrl", str),
    )

    #: str: *Required* announcementInterruption
    announcement_interruption = Field(type=str, required=True, mutable=False)
    #: str: *Optional* interruptionDigitSequence
    interruption_digit_sequence = Field(type=str, required=False, mutable=False)
    #: str: *Required* audioSelection
    audio_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMediaType
    audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Required* videoSelection
    video_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMediaType
    video_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileUrl
    video_file_url = Field(type=str, required=False, mutable=False)


class EnterpriseRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse(OCIResponse):
    """
    Response to
    ``EnterpriseRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest()``.

    Contains a list of number ranges that are assigned to an enterprise and still
    available for assignment to users within the enterprise.  The column headings are
    "Number Range Start", "Number Range End" and "Is Active".
    """

    _ELEMENTS = (
        E(
            "available_number_range_table", "availableNumberRangeTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* availableNumberRangeTable  *Tabular*
    available_number_range_table = Field(type=list, required=True, mutable=False)


class EnterpriseRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse(OCIResponse):
    """
    Response to ``EnterpriseRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest()``.

    The response contains a table with columns: "Number Range Start", "Number Range End",
    "Group Id", "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana
    First Name", "Phone Number", "Extension", "Department", "Email Address", "Enterprise
    Trunk" and "Is Active". The "User Id", "Last Name", "First Name", "Hiragana Last
    Name", "Hiragana First Name", "Phone Number", "Extension", "Department" and "Email
    Address" columns contains the corresponding attributes of the user possessing the
    number range.  The "Enterprise Trunk" column contains the enterprise trunk the user
    possessing the number range belongs to.  The "Is Active" column indicates if the
    number range has been activated.
    """

    _ELEMENTS = (
        E(
            "number_range_summary_table", "numberRangeSummaryTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* numberRangeSummaryTable  *Tabular*
    number_range_summary_table = Field(type=list, required=True, mutable=False)


class EnterpriseSessionAdmissionControlGroupGetListResponse(OCIResponse):
    """
    Response to ``EnterpriseSessionAdmissionControlGroupGetListRequest()``.

    Contains a table of session admission control group configured in the enterprise.  The
    column headings are: "Name", "Is Default", "Maximum Sessions", "Maximum Originating
    Sessions", "Maximum Terminating Sessions"..
    """

    _ELEMENTS = (
        E(
            "session_admission_control_group_table", "sessionAdmissionControlGroupTable",
            list, is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* sessionAdmissionControlGroupTable  *Tabular*
    session_admission_control_group_table = Field(type=list, required=True, mutable=False)


class EnterpriseVirtualOnNetEnterpriseExtensionsGetUserListResponse(OCIResponse):
    """
    Response to ``EnterpriseVirtualOnNetEnterpriseExtensionsGetUserListRequest()``.

    Contains a table with column headings : "Group Id", "Last Name", "First Name", "Phone
    Number", "Extension", "Virtual On-Net Call Type" in a row for each user.
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class EnterpriseVoiceVPNGetPolicyListResponse(OCIResponse):
    """
    Response to ``EnterpriseVoiceVPNGetListResponse()``.

    Returns a 4 column table with column headings: "Location Code", "Min Extension
    Length", "Max Extension Length", "Location Selection".
    """

    _ELEMENTS = (
        E(
            "location_list", "locationList", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* locationList  *Tabular*
    location_list = Field(type=list, required=True, mutable=False)


class EnterpriseVoiceVPNGetResponse(OCIResponse):
    """
    Response to ``EnterpriseVoiceVPNGetRequest()``.

    Replaced By: ``EnterpriseVoiceVPNGetResponse14sp3()``
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("default_selection", "defaultSelection", str, is_required=True),
        E("e164_selection", "e164Selection", str, is_required=True),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Required* defaultSelection
    default_selection = Field(type=str, required=True, mutable=False)
    #: str: *Required* e164Selection
    e164_selection = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNGetResponse14sp3(OCIResponse):
    """
    Response to ``EnterpriseVoiceVPNGetRequest14sp3()``.

    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("default_selection", "defaultSelection", str, is_required=True),
        E("e164_selection", "e164Selection", str, is_required=True),
        E("use_phone_context", "usePhoneContext", bool, is_required=True),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Required* defaultSelection
    default_selection = Field(type=str, required=True, mutable=False)
    #: str: *Required* e164Selection
    e164_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* usePhoneContext
    use_phone_context = Field(type=bool, required=True, mutable=False)


class ExternalAuthenticationCreateLoginTokenResponse(OCIResponse):
    """
    Response to ``ExternalAuthenticationCreateLoginTokenRequest()``.

    """

    _ELEMENTS = (
        E("login_token", "loginToken", str, is_required=True),
    )

    #: str: *Required* loginToken
    login_token = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceAvailablePortGetListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceAvailablePortGetListRequest()``.

    Contains a list of available ports in a device using static mode.  The list is empty
    in case the device is using dynamic mode.
    """

    _ELEMENTS = (
        E("port_number", "portNumber", int, is_array=True),
    )

    #: list(int): *Optional* portNumber  *Array*
    port_number = Field(type=list, required=False, mutable=False)


class GroupAccessDeviceCustomTagGetListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceCustomTagGetListRequest()``.

    Contains a table of custom configuration tags managed by the Device Management System
    on a per-device profile basis.  The column headings are: "Tag Name", "Tag Value"
    """

    _ELEMENTS = (
        E(
            "device_custom_tags_table", "deviceCustomTagsTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* deviceCustomTagsTable  *Tabular*
    device_custom_tags_table = Field(type=list, required=True, mutable=False)


class GroupAccessDeviceFileGetListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetListRequest()``.

    Contains a table of device files managed by the Device Management System on a per-
    device profile basis.  The column headings are: "File Type", "File Format", "Is
    Authenticated".

    Replaced By: ``GroupAccessDeviceFileGetListResponse14sp8()``
    """

    _ELEMENTS = (
        E(
            "device_files_table", "deviceFilesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* deviceFilesTable  *Tabular*
    device_files_table = Field(type=list, required=True, mutable=False)


class GroupAccessDeviceFileGetListResponse14sp8(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetListRequest14sp8()``.

    Contains a table of device files managed by the Device Management System on a per-
    device profile basis.  The column headings are: "File Format", "Is Authenticated",
    "Access URL", "Repository URL", "Template URL", "Extended Capture". The following
    columns are only used in AS data mode: "Extended Capture"
    """

    _ELEMENTS = (
        E(
            "device_files_table", "deviceFilesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* deviceFilesTable  *Tabular*
    device_files_table = Field(type=list, required=True, mutable=False)


class GroupAccessDeviceFileGetResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetRequest()``.

    Replaced By: ``GroupAccessDeviceFileGetResponse14sp8()``
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
    )

    #: str: *Required* fileSource
    file_source = Field(type=str, required=True, mutable=False)
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(type=str, required=False, mutable=False)


class GroupAccessDeviceFileGetResponse14sp8(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetRequest14sp8()``.

    Replaced by: ``GroupAccessDeviceFileGetResponse16sp1()``
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
    )

    #: str: *Required* fileSource
    file_source = Field(type=str, required=True, mutable=False)
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(type=str, required=False, mutable=False)


class GroupAccessDeviceFileGetResponse16sp1(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetRequest16sp1()``.

    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
        E("access_url", "accessUrl", str, is_required=True),
        E("repository_url", "repositoryUrl", str),
        E("template_url", "templateUrl", str),
    )

    #: str: *Required* fileSource
    file_source = Field(type=str, required=True, mutable=False)
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* accessUrl
    access_url = Field(type=str, required=True, mutable=False)
    #: str: *Optional* repositoryUrl
    repository_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* templateUrl
    template_url = Field(type=str, required=False, mutable=False)


class GroupAccessDeviceFileGetResponse20(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetRequest20()``.

    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
        E("access_url", "accessUrl", str, is_required=True),
        E("repository_url", "repositoryUrl", str),
        E("template_url", "templateUrl", str),
        E("extended_capture_enabled", "extendedCaptureEnabled", bool),
        E("extended_capture_url", "extendedCaptureURL", str),
    )

    #: str: *Required* fileSource
    file_source = Field(type=str, required=True, mutable=False)
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* accessUrl
    access_url = Field(type=str, required=True, mutable=False)
    #: str: *Optional* repositoryUrl
    repository_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* templateUrl
    template_url = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* extendedCaptureEnabled
    extended_capture_enabled = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* extendedCaptureURL
    extended_capture_url = Field(type=str, required=False, mutable=False)


class GroupAccessDeviceGetAvailableDetailListResponse14(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetAvailableDetailListRequest14()``.

    """

    _ELEMENTS = (
        E(
            "available_access_device", "availableAccessDevice", str, is_complex=True,
            is_array=True,
        ),  # unknown
    )

    #: list(str): *Optional* availableAccessDevice  *Array*
    available_access_device = Field(type=list, required=False, mutable=False)


class GroupAccessDeviceGetAvailableDetailListResponse19(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetAvailableDetailListRequest19()``.

    """

    _ELEMENTS = (
        E(
            "available_access_device", "availableAccessDevice", str, is_complex=True,
            is_array=True,
        ),  # unknown
    )

    #: list(str): *Optional* availableAccessDevice  *Array*
    available_access_device = Field(type=list, required=False, mutable=False)


class GroupAccessDeviceGetEnhancedConfigurationTypeListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetEnhancedConfigurationTypeListRequest()``.

    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_array=True),
    )

    #: list(str): *Optional* deviceType  *Array*
    device_type = Field(type=list, required=False, mutable=False)


class GroupAccessDeviceGetEnhancedConfigurationTypeResponse14(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetEnhancedConfigurationTypeRequest14()``.

    """

    _ELEMENTS = (
        E(
            "supports_enhanced_configuration", "supportsEnhancedConfiguration", bool,
            is_required=True,
        ),
        E("supports_reset", "supportsReset", bool, is_required=True),
        E("configuration_type", "configurationType", str),
        E("configuration_file_name", "configurationFileName", str),
    )

    #: bool: *Required* supportsEnhancedConfiguration
    supports_enhanced_configuration = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* supportsReset
    supports_reset = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* configurationType
    configuration_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(type=str, required=False, mutable=False)


class GroupAccessDeviceGetListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetListRequest()``.

    Contains a table of devices configured in the group.  The column headings are: "Device
    Name", "Device Type", "Available Ports", "Net Address", "MAC Address", "Status" and
    "Version".
    """

    _ELEMENTS = (
        E(
            "access_device_table", "accessDeviceTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* accessDeviceTable  *Tabular*
    access_device_table = Field(type=list, required=True, mutable=False)


class GroupAccessDeviceGetUserListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetUserListRequest()``.

    The column headings for the deviceUserTable are: "Line/Port", "Last Name", "First
    Name", "Phone Number", "User Id", "User Type", "Endpoint Type", "Order", "Primary
    Line/Port", "Extension", "Department", "Email Address", "Private Identity". In IMS
    mode, the table will contain a row for each TEL-URI in the Phone Number column.  In
    Standalone mode, rows for the alternate numbers are not included.  The User Type
    column contains one of the enumerated UserType values.  The Endpoint Type column
    contains one of the enumerated EndpointType values.  The Private Identity column is
    empty is AS mode.
    """

    _ELEMENTS = (
        E(
            "device_user_table", "deviceUserTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* deviceUserTable  *Tabular*
    device_user_table = Field(type=list, required=True, mutable=False)


class GroupAccountAuthorizationCodesGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupAccountAuthorizationCodesGetAvailableUserListRequest()``.

    The column headings are: "User Id", "Last Name", "First Name", "Hiragana Last Name"
    and "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupAccountAuthorizationCodesGetResponse(OCIResponse):
    """
    Response to ``GroupAccountAuthorizationCodesGetRequest()``.

    The tables has the following column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name", "Phone Number", "Extension",
    "Department", "Email Address".
    """

    _ELEMENTS = (
        E("type", "type", str, is_required=True),
        E("number_of_digits", "numberOfDigits", int, is_required=True),
        E(
            "allow_local_and_toll_free_calls", "allowLocalAndTollFreeCalls", bool,
            is_required=True,
        ),
        E(
            "mandatory_usage_user_table", "mandatoryUsageUserTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
        E(
            "optional_usage_user_table", "optionalUsageUserTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: str: *Required* type
    type = Field(type=str, required=True, mutable=False)
    #: int: *Required* numberOfDigits
    number_of_digits = Field(type=int, required=True, mutable=False)
    #: bool: *Required* allowLocalAndTollFreeCalls
    allow_local_and_toll_free_calls = Field(type=bool, required=True, mutable=False)
    #: list: *Required* mandatoryUsageUserTable  *Tabular*
    mandatory_usage_user_table = Field(type=list, required=True, mutable=False)
    #: list: *Required* optionalUsageUserTable  *Tabular*
    optional_usage_user_table = Field(type=list, required=True, mutable=False)


class GroupAdminGetListResponse(OCIResponse):
    """
    Response to ``GroupAdminGetListRequest()``.

    Contains a 5 column table with column headings "Administrator ID", "Last Name", "First
    Name", "Department", "Language".
    """

    _ELEMENTS = (
        E(
            "group_admin_table", "groupAdminTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* groupAdminTable  *Tabular*
    group_admin_table = Field(type=list, required=True, mutable=False)


class GroupAdminGetPolicyResponse(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest()``.

    Contains the policy settings for the group administrator.
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyResponse14sp1(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest14sp1()``.

    Contains the policy settings for the group administrator.
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("trunk_group_access", "trunkGroupAccess", str, is_required=True),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* trunkGroupAccess
    trunk_group_access = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyResponse16sp1(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest16sp1()``.

    Contains the policy settings for the group administrator.  Replaced by:
    ``GroupAdminGetPolicyRequest17()``
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("trunk_group_access", "trunkGroupAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* trunkGroupAccess
    trunk_group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyResponse16sp2(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest16sp2()``.

    Contains the policy settings for the group administrator.
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("trunk_group_access", "trunkGroupAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* trunkGroupAccess
    trunk_group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyResponse17(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest17()``.

    Contains the policy settings for the group administrator.
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("trunk_group_access", "trunkGroupAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* trunkGroupAccess
    trunk_group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyResponse17sp3(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest17sp3()``.

    Contains the policy settings for the group administrator.  The following elements are
    only used in AS data mode: dialableCallerIDAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("trunk_group_access", "trunkGroupAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* trunkGroupAccess
    trunk_group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyResponse18(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest18()``.

    Contains the policy settings for the group administrator.  The following elements are
    only used in AS data mode: dialableCallerIDAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("trunk_group_access", "trunkGroupAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E("number_activation_access", "numberActivationAccess", str, is_required=True),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* trunkGroupAccess
    trunk_group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* numberActivationAccess
    number_activation_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyResponse19sp1(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest19sp1()``.

    Contains the policy settings for the group administrator.  The following elements are
    only used in AS data mode: dialableCallerIDAccess
    communicationBarringUserProfileAccess (This element will not be returned in the
    response for Service Provider group administrators)
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("trunk_group_access", "trunkGroupAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E("number_activation_access", "numberActivationAccess", str, is_required=True),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
        E(
            "communication_barring_user_profile_access",
            "communicationBarringUserProfileAccess", str,
        ),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* trunkGroupAccess
    trunk_group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* numberActivationAccess
    number_activation_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(type=str, required=True, mutable=False)
    #: str: *Optional* communicationBarringUserProfileAccess
    communication_barring_user_profile_access = Field(type=str, required=False, mutable=False)


class GroupAdminGetPolicyResponse20(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest20()``.

    Contains the policy settings for the group administrator.  The following elements are
    only used in AS data mode: dialableCallerIDAccess verifyTranslationAndroutingAccess
    communicationBarringUserProfileAccess (This element is only returned for groups in an
    enterprise)
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("trunk_group_access", "trunkGroupAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E("number_activation_access", "numberActivationAccess", str, is_required=True),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
        E(
            "verify_translation_and_routing_access", "verifyTranslationAndRoutingAccess",
            str, is_required=True,
        ),
        E(
            "communication_barring_user_profile_access",
            "communicationBarringUserProfileAccess", str,
        ),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* trunkGroupAccess
    trunk_group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* numberActivationAccess
    number_activation_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* verifyTranslationAndRoutingAccess
    verify_translation_and_routing_access = Field(type=str, required=True, mutable=False)
    #: str: *Optional* communicationBarringUserProfileAccess
    communication_barring_user_profile_access = Field(type=str, required=False, mutable=False)


class GroupAdminGetResponse(OCIResponse):
    """
    Response to the ``GroupAdminGetRequest()``.

    The response contains the group administrators profile information.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("language", "language", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* firstName
    first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* lastName
    last_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* language
    language = Field(type=str, required=True, mutable=False)


class GroupAdviceOfChargeGetResponse(OCIResponse):
    """
    Response to ``GroupAdviceOfChargeGetRequest()``.

    Contains a list of Advice of Charge group parameters.
    """

    _ELEMENTS = (
        E(
            "use_group_level_ao_c_settings", "useGroupLevelAoCSettings", bool,
            is_required=True,
        ),
        E(
            "delay_between_notification_seconds", "delayBetweenNotificationSeconds", int,
            is_required=True,
        ),
    )

    #: bool: *Required* useGroupLevelAoCSettings
    use_group_level_ao_c_settings = Field(type=bool, required=True, mutable=False)
    #: int: *Required* delayBetweenNotificationSeconds
    delay_between_notification_seconds = Field(type=int, required=True, mutable=False)


class GroupAnnouncementFileGetListResponse(OCIResponse):
    """
    Response to ``GroupAnnouncementFileGetAvailableListRequest()``.

    When requested, the response contains a table with columns: "Name", "Media Type" and
    "File Size". The "Name" column contains the name of the announcement file.  The "Media
    Type" column contains the media type of the announcement File with the possible
    values: WMA - Windows Media Audio file WAV - A WAV file 3GP - A 3GP file MOV - A MOV
    file using a H.263 or H.264 codec.  The "File Size" column contains the file size (KB)
    of the announcement file.

    The response also contains the current total file size (KB) for the group across all
    media types and the maximum total file size (MB) allowed for the group.
    """

    _ELEMENTS = (
        E("announcement_table", "announcementTable", list, is_complex=True, is_table=True),
        E("total_file_size", "totalFileSize", int, is_required=True),
        E("max_file_size", "maxFileSize", int, is_required=True),
    )

    #: list: *Optional* announcementTable  *Tabular*
    announcement_table = Field(type=list, required=False, mutable=False)
    #: int: *Required* totalFileSize
    total_file_size = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxFileSize
    max_file_size = Field(type=int, required=True, mutable=False)


class GroupAnnouncementFileGetResponse(OCIResponse):
    """
    Response to ``GroupAnnouncementFileGetRequest()``.

    The response contains the file size, uploaded timestamp, description and usage for an
    announcement file in the user announcement repository.  The usage table has columns
    "Service Name", and "Instance Name". The Service Name values correspond to string
    values of the GroupService and UserService data types.  With the exception of the
    string "Voice Portal" which is returned when the announcement is being used by Voice
    Portal Personalized Name.
    """

    _ELEMENTS = (
        E("description", "description", str, is_required=True),
        E("filesize", "filesize", int, is_required=True),
        E("last_uploaded", "lastUploaded", str, is_required=True),
        E(
            "usage_table", "usageTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: str: *Required* description
    description = Field(type=str, required=True, mutable=False)
    #: int: *Required* filesize
    filesize = Field(type=int, required=True, mutable=False)
    #: str: *Required* lastUploaded
    last_uploaded = Field(type=str, required=True, mutable=False)
    #: list: *Required* usageTable  *Tabular*
    usage_table = Field(type=list, required=True, mutable=False)


class GroupApplicationServerSetGetResponse(OCIResponse):
    """
    Response to the ``GroupApplicationServerSetGetRequest()``.

    The response contains the group's Application Server set information.
    """

    _ELEMENTS = (
        E("application_server_set_name", "applicationServerSetName", str),
    )

    #: str: *Optional* applicationServerSetName
    application_server_set_name = Field(type=str, required=False, mutable=False)


class GroupAutoAttendantGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupAutoAttendantGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Video", "Phone
    Number", "Extension", "Department", "Is Active", "Type". The column values for "Video"
    and "Is Active" can either be true, or false.  The column values for "Type" can either
    be Basic or Standard.  In HSS Mode the value for the "Type" column will always be
    populated with Basic.
    """

    _ELEMENTS = (
        E(
            "auto_attendant_table", "autoAttendantTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* autoAttendantTable  *Tabular*
    auto_attendant_table = Field(type=list, required=True, mutable=False)


class GroupAutoAttendantSubmenuGetListResponse(OCIResponse):
    """
    Response to the ``GroupAutoAttendantSubmenuGetListRequest()``.

    Contains a table with column headings: "Submenu Id" "Is Used". The column values for
    "Is Used" can either be true, or false.
    """

    _ELEMENTS = (
        E(
            "submenu_table", "submenuTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* submenuTable  *Tabular*
    submenu_table = Field(type=list, required=True, mutable=False)


class GroupAutoAttendantSubmenuGetUsageListResponse(OCIResponse):
    """
    Response to the ``GroupAutoAttendantSubmenuGetUsageListRequest()``.

    Contains a table with column headings: "Type" and "Submenu ID". The "Type" Column will
    contain one of the following: Business Hours Menu, After Hours Menu, Holiday Menu or
    Submenu.  The "Submenu ID" Column will be left blank when the "Type" Column contains
    one of the base menu types (Business Hours Menu, After Hours Menu or Holiday Menu),
    and will contain the Submenu ID when the "Type" Column contains type Submenu.
    """

    _ELEMENTS = (
        E(
            "submenu_table", "submenuTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* submenuTable  *Tabular*
    submenu_table = Field(type=list, required=True, mutable=False)


class GroupBroadWorksAnywhereGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupBroadWorksAnywhereGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active". The column value for "Is Active" can either be
    true, or false.
    """

    _ELEMENTS = (
        E(
            "broad_works_anywhere_table", "broadWorksAnywhereTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* broadWorksAnywhereTable  *Tabular*
    broad_works_anywhere_table = Field(type=list, required=True, mutable=False)


class GroupBroadWorksMobileManagerGetDomainListResponse(OCIResponse):
    """
    Response to the ``GroupBroadWorksMobileManagerGetDomainListRequest()``.

    Contains the list of domains.
    """

    _ELEMENTS = (
        E("domain_name", "domainName", str, is_array=True),
    )

    #: list(str): *Optional* domainName  *Array*
    domain_name = Field(type=list, required=False, mutable=False)


class GroupBroadWorksMobileManagerGetHomeZoneListResponse(OCIResponse):
    """
    Response to the ``GroupBroadWorksMobileManagerGetHomeZoneListRequest()``.

    Contains a table with column headings: "Home Zone Id", "Domain Name", "Mobile Country
    Code", "Mobile Network Code", "Local Area Code" and "Cell Identity".
    """

    _ELEMENTS = (
        E(
            "home_zones_table", "homeZonesTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* homeZonesTable  *Tabular*
    home_zones_table = Field(type=list, required=True, mutable=False)


class GroupBroadWorksMobileManagerGetHomeZoneResponse(OCIResponse):
    """
    Response to the ``GroupBroadWorksMobileManagerGetHomeZoneRequest()``
    """

    _ELEMENTS = (
        E("home_zone_domain_name", "homeZoneDomainName", str, is_required=True),
        E("mobile_country_code", "mobileCountryCode", str, is_required=True),
        E("mobile_network_code", "mobileNetworkCode", str, is_required=True),
        E("location_area_code", "locationAreaCode", str, is_required=True),
        E("cell_identity", "cellIdentity", str, is_required=True),
    )

    #: str: *Required* homeZoneDomainName
    home_zone_domain_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* mobileCountryCode
    mobile_country_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* mobileNetworkCode
    mobile_network_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* locationAreaCode
    location_area_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* cellIdentity
    cell_identity = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerGetResponse(OCIResponse):
    """
    Response to the ``GroupBroadWorksMobileManagerGetRequest()``
    """

    _ELEMENTS = (
        E("mobile_manager_id", "mobileManagerId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("local_to_carrier", "localToCarrier", bool, is_required=True),
        E("deactivation_reason", "deactivationReason", str),
        E("max_tx_per_second_enabled", "maxTxPerSecondEnabled", bool, is_required=True),
        E("max_tx_per_second", "maxTxPerSecond", int),
        E("tldn_enabled", "tldnEnabled", bool, is_required=True),
        E("generic_number_enabled", "genericNumberEnabled", bool, is_required=True),
        E("mobile_state_check_enabled", "mobileStateCheckEnabled", bool, is_required=True),
        E(
            "location_based_services_enabled", "locationBasedServicesEnabled", bool,
            is_required=True,
        ),
    )

    #: str: *Required* mobileManagerId
    mobile_manager_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* localToCarrier
    local_to_carrier = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* deactivationReason
    deactivation_reason = Field(type=str, required=False, mutable=False)
    #: bool: *Required* maxTxPerSecondEnabled
    max_tx_per_second_enabled = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* maxTxPerSecond
    max_tx_per_second = Field(type=int, required=False, mutable=False)
    #: bool: *Required* tldnEnabled
    tldn_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* genericNumberEnabled
    generic_number_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* mobileStateCheckEnabled
    mobile_state_check_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* locationBasedServicesEnabled
    location_based_services_enabled = Field(type=bool, required=True, mutable=False)


class GroupBroadWorksMobilityGetResponse(OCIResponse):
    """
    The response to a ``GroupBroadWorksMobilityGetRequest()``.

    """

    _ELEMENTS = (
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("enable_location_services", "enableLocationServices", bool, is_required=True),
        E("enable_msrn_lookup", "enableMSRNLookup", bool, is_required=True),
        E(
            "enable_mobile_state_checking", "enableMobileStateChecking", bool,
            is_required=True,
        ),
        E("deny_call_originations", "denyCallOriginations", bool, is_required=True),
        E("deny_call_terminations", "denyCallTerminations", bool, is_required=True),
    )

    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enableLocationServices
    enable_location_services = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableMSRNLookup
    enable_msrn_lookup = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableMobileStateChecking
    enable_mobile_state_checking = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* denyCallOriginations
    deny_call_originations = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* denyCallTerminations
    deny_call_terminations = Field(type=bool, required=True, mutable=False)


class GroupBroadWorksMobilityGetResponse19sp1(OCIResponse):
    """
    The response to a ``GroupBroadWorksMobilityGetRequest19sp1()``.

    """

    _ELEMENTS = (
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("enable_location_services", "enableLocationServices", bool, is_required=True),
        E("enable_msrn_lookup", "enableMSRNLookup", bool, is_required=True),
        E(
            "enable_mobile_state_checking", "enableMobileStateChecking", bool,
            is_required=True,
        ),
        E("deny_call_originations", "denyCallOriginations", bool, is_required=True),
        E("deny_call_terminations", "denyCallTerminations", bool, is_required=True),
        E(
            "enable_announcement_suppression", "enableAnnouncementSuppression", bool,
            is_required=True,
        ),
    )

    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enableLocationServices
    enable_location_services = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableMSRNLookup
    enable_msrn_lookup = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableMobileStateChecking
    enable_mobile_state_checking = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* denyCallOriginations
    deny_call_originations = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* denyCallTerminations
    deny_call_terminations = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableAnnouncementSuppression
    enable_announcement_suppression = Field(type=bool, required=True, mutable=False)


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListResponse(OCIResponse):
    """
    Response to the
    ``GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListRequest()``.

    The response contains a table with columns: "Mobile Number", "User Id", "Last Name",
    "First Name","Phone Number", "Extension", "Department",. The "Mobile Number" column
    contains a single DN. The "User Id", "Last Name" and "First Name" columns contains the
    corresponding attributes of the user possessing the DN(s). The "Phone Number" column
    contains a single DN. The "Department" column contains the department of the user if
    it is part of a department.
    """

    _ELEMENTS = (
        E(
            "mobile_subscriber_directory_number_table",
            "mobileSubscriberDirectoryNumberTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* mobileSubscriberDirectoryNumberTable  *Tabular*
    mobile_subscriber_directory_number_table = Field(type=list, required=True, mutable=False)


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse(OCIResponse):
    """
    Response to
    ``GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest()``.

    Contains a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any user.
    """

    _ELEMENTS = (
        E(
            "mobile_subscriber_directory_number", "mobileSubscriberDirectoryNumber", str,
            is_array=True,
        ),
    )

    #: list(str): *Optional* mobileSubscriberDirectoryNumber  *Array*
    mobile_subscriber_directory_number = Field(type=list, required=False, mutable=False)


class GroupCallCapacityManagementGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCallCapacityManagementGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupCallCapacityManagementGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupCallCapacityManagementGetInstanceListRequest()``.

    Contains a table with column headings: "Name", "Is Default", "Maximum Calls", "Maximum
    Incoming Calls", "Maximum Outgoing Calls".
    """

    _ELEMENTS = (
        E(
            "call_capacity_group_table", "callCapacityGroupTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* callCapacityGroupTable  *Tabular*
    call_capacity_group_table = Field(type=list, required=True, mutable=False)


class GroupCallCapacityManagementGetInstanceResponse(OCIResponse):
    """
    Response to the ``GroupCallCapacityManagementGetInstanceRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("max_active_calls_allowed", "maxActiveCallsAllowed", int, is_required=True),
        E("max_incoming_active_calls_allowed", "maxIncomingActiveCallsAllowed", int),
        E("max_outgoing_active_calls_allowed", "maxOutgoingActiveCallsAllowed", int),
        E("default_group_for_new_users", "defaultGroupForNewUsers", bool, is_required=True),
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: int: *Required* maxActiveCallsAllowed
    max_active_calls_allowed = Field(type=int, required=True, mutable=False)
    #: int: *Optional* maxIncomingActiveCallsAllowed
    max_incoming_active_calls_allowed = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxOutgoingActiveCallsAllowed
    max_outgoing_active_calls_allowed = Field(type=int, required=False, mutable=False)
    #: bool: *Required* defaultGroupForNewUsers
    default_group_for_new_users = Field(type=bool, required=True, mutable=False)
    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterAgentThresholdDefaultProfileGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterAgentThresholdDefaultProfileGetRequest()``.

    The agent table contains the agents assigned to the profile and has column headings:
    "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address";
    """

    _ELEMENTS = (
        E("profile_name", "profileName", str, is_required=True),
        E("profile_description", "profileDescription", str),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed", int,
        ),
        E("threshold_average_busy_in_time_yellow", "thresholdAverageBusyInTimeYellow", int),
        E("threshold_average_busy_in_time_red", "thresholdAverageBusyInTimeRed", int),
        E("threshold_average_busy_out_time_yellow", "thresholdAverageBusyOutTimeYellow", int),
        E("threshold_average_busy_out_time_red", "thresholdAverageBusyOutTimeRed", int),
        E("threshold_average_wrap_up_time_yellow", "thresholdAverageWrapUpTimeYellow", int),
        E("threshold_average_wrap_up_time_red", "thresholdAverageWrapUpTimeRed", int),
        E("enable_notification_email", "enableNotificationEmail", bool, is_required=True),
        E("notification_email_address", "notificationEmailAddress", str),
        E("agent_table", "agentTable", list, is_complex=True, is_table=True),
    )

    #: str: *Required* profileName
    profile_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* profileDescription
    profile_description = Field(type=str, required=False, mutable=False)
    #: int: *Optional* thresholdCurrentCallStateIdleTimeYellow
    threshold_current_call_state_idle_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeRed
    threshold_current_call_state_idle_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeYellow
    threshold_current_call_state_on_call_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeRed
    threshold_current_call_state_on_call_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeYellow
    threshold_current_agent_state_unavailable_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeRed
    threshold_current_agent_state_unavailable_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeYellow
    threshold_average_busy_in_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyInTimeRed
    threshold_average_busy_in_time_red = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyOutTimeYellow
    threshold_average_busy_out_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyOutTimeRed
    threshold_average_busy_out_time_red = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageWrapUpTimeYellow
    threshold_average_wrap_up_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageWrapUpTimeRed
    threshold_average_wrap_up_time_red = Field(type=int, required=False, mutable=False)
    #: bool: *Required* enableNotificationEmail
    enable_notification_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* notificationEmailAddress
    notification_email_address = Field(type=str, required=False, mutable=False)
    #: list: *Optional* agentTable  *Tabular*
    agent_table = Field(type=list, required=False, mutable=False)


class GroupCallCenterAgentThresholdProfileGetAvailableAgentListResponse(OCIResponse):
    """
    Response to the
    ``GroupCallCenterAgentThresholdProfileGetAvailableAgentListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address", "Agent Threshold Profile";
    """

    _ELEMENTS = (
        E(
            "agent_table", "agentTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* agentTable  *Tabular*
    agent_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterAgentThresholdProfileGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterAgentThresholdProfileGetListRequest()``.

    Contains a table with all the Call Center Agent Threshold Profiles in the Group.  The
    column headings are: "Default", "Name", "Description".
    """

    _ELEMENTS = (
        E(
            "profiles_table", "profilesTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* profilesTable  *Tabular*
    profiles_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterAgentThresholdProfileGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterAgentThresholdProfileGetRequest()``.

    The agentTable contains the agents assigned to the profile and has the column
    headings: "User Id", "Group Id", "Last Name", "First Name", "Hiragana Last Name",
    "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address";
    """

    _ELEMENTS = (
        E("profile_description", "profileDescription", str),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed", int,
        ),
        E("threshold_average_busy_in_time_yellow", "thresholdAverageBusyInTimeYellow", int),
        E("threshold_average_busy_in_time_red", "thresholdAverageBusyInTimeRed", int),
        E("threshold_average_busy_out_time_yellow", "thresholdAverageBusyOutTimeYellow", int),
        E("threshold_average_busy_out_time_red", "thresholdAverageBusyOutTimeRed", int),
        E("threshold_average_wrap_up_time_yellow", "thresholdAverageWrapUpTimeYellow", int),
        E("threshold_average_wrap_up_time_red", "thresholdAverageWrapUpTimeRed", int),
        E("enable_notification_email", "enableNotificationEmail", bool, is_required=True),
        E("notification_email_address", "notificationEmailAddress", str),
        E(
            "agent_table", "agentTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: str: *Optional* profileDescription
    profile_description = Field(type=str, required=False, mutable=False)
    #: int: *Optional* thresholdCurrentCallStateIdleTimeYellow
    threshold_current_call_state_idle_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeRed
    threshold_current_call_state_idle_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeYellow
    threshold_current_call_state_on_call_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeRed
    threshold_current_call_state_on_call_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeYellow
    threshold_current_agent_state_unavailable_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeRed
    threshold_current_agent_state_unavailable_time_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeYellow
    threshold_average_busy_in_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyInTimeRed
    threshold_average_busy_in_time_red = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyOutTimeYellow
    threshold_average_busy_out_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageBusyOutTimeRed
    threshold_average_busy_out_time_red = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageWrapUpTimeYellow
    threshold_average_wrap_up_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageWrapUpTimeRed
    threshold_average_wrap_up_time_red = Field(type=int, required=False, mutable=False)
    #: bool: *Required* enableNotificationEmail
    enable_notification_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* notificationEmailAddress
    notification_email_address = Field(type=str, required=False, mutable=False)
    #: list: *Required* agentTable  *Tabular*
    agent_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterAgentUnavailableCodeGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterAgentUnavailableCodeGetListRequest()``.

    Contains a table with column headings: "Is Active", "Code", "Description".
    """

    _ELEMENTS = (
        E(
            "unavailable_codes_table", "unavailableCodesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* unavailableCodesTable  *Tabular*
    unavailable_codes_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterAgentUnavailableCodeGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterAgentUnavailableCodeGetRequest()``
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class GroupCallCenterAgentUnavailableCodeSettingsGetResponse(OCIResponse):
    """
    Response to ``GroupCallCenterAgentUnavailableCodeSettingsGetRequest()``.

    Replaced by ``GroupCallCenterAgentUnavailableCodeSettingsGetResponse17sp4()``.
    """

    _ELEMENTS = (
        E(
            "enable_agent_unavailable_codes", "enableAgentUnavailableCodes", bool,
            is_required=True,
        ),
        E("default_agent_unavailable_code_on_dnd", "defaultAgentUnavailableCodeOnDND", str),
        E(
            "default_agent_unavailable_code_on_personal_calls",
            "defaultAgentUnavailableCodeOnPersonalCalls", str,
        ),
        E(
            "default_agent_unavailable_code_on_consecutive_bounces",
            "defaultAgentUnavailableCodeOnConsecutiveBounces", str,
        ),
        E(
            "force_use_of_agent_unavailable_codes", "forceUseOfAgentUnavailableCodes",
            bool, is_required=True,
        ),
        E("default_agent_unavailable_code", "defaultAgentUnavailableCode", str),
    )

    #: bool: *Required* enableAgentUnavailableCodes
    enable_agent_unavailable_codes = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* defaultAgentUnavailableCodeOnDND
    default_agent_unavailable_code_on_dnd = Field(type=str, required=False, mutable=False)
    #: str: *Optional* defaultAgentUnavailableCodeOnPersonalCalls
    default_agent_unavailable_code_on_personal_calls = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnConsecutiveBounces
    default_agent_unavailable_code_on_consecutive_bounces = Field(
        type=str, required=False, mutable=False,
    )
    #: bool: *Required* forceUseOfAgentUnavailableCodes
    force_use_of_agent_unavailable_codes = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* defaultAgentUnavailableCode
    default_agent_unavailable_code = Field(type=str, required=False, mutable=False)


class GroupCallCenterAgentUnavailableCodeSettingsGetResponse17sp4(OCIResponse):
    """
    Response to ``GroupCallCenterAgentUnavailableCodeSettingsGetRequest17sp4()``.

    """

    _ELEMENTS = (
        E(
            "enable_agent_unavailable_codes", "enableAgentUnavailableCodes", bool,
            is_required=True,
        ),
        E("default_agent_unavailable_code_on_dnd", "defaultAgentUnavailableCodeOnDND", str),
        E(
            "default_agent_unavailable_code_on_personal_calls",
            "defaultAgentUnavailableCodeOnPersonalCalls", str,
        ),
        E(
            "default_agent_unavailable_code_on_consecutive_bounces",
            "defaultAgentUnavailableCodeOnConsecutiveBounces", str,
        ),
        E(
            "default_agent_unavailable_code_on_not_reachable",
            "defaultAgentUnavailableCodeOnNotReachable", str,
        ),
        E(
            "force_use_of_agent_unavailable_codes", "forceUseOfAgentUnavailableCodes",
            bool, is_required=True,
        ),
        E("default_agent_unavailable_code", "defaultAgentUnavailableCode", str),
    )

    #: bool: *Required* enableAgentUnavailableCodes
    enable_agent_unavailable_codes = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* defaultAgentUnavailableCodeOnDND
    default_agent_unavailable_code_on_dnd = Field(type=str, required=False, mutable=False)
    #: str: *Optional* defaultAgentUnavailableCodeOnPersonalCalls
    default_agent_unavailable_code_on_personal_calls = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnConsecutiveBounces
    default_agent_unavailable_code_on_consecutive_bounces = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnNotReachable
    default_agent_unavailable_code_on_not_reachable = Field(
        type=str, required=False, mutable=False,
    )
    #: bool: *Required* forceUseOfAgentUnavailableCodes
    force_use_of_agent_unavailable_codes = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* defaultAgentUnavailableCode
    default_agent_unavailable_code = Field(type=str, required=False, mutable=False)


class GroupCallCenterBouncedCallGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterBouncedCallGetRequest()``.

    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E(
            "number_of_rings_before_bouncing_call", "numberOfRingsBeforeBouncingCall",
            int, is_required=True,
        ),
        E("enable_transfer", "enableTransfer", bool),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E(
            "bounce_call_when_agent_unavailable", "bounceCallWhenAgentUnavailable", bool,
            is_required=True,
        ),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: int: *Required* numberOfRingsBeforeBouncingCall
    number_of_rings_before_bouncing_call = Field(type=int, required=True, mutable=False)
    #: bool: *Optional* enableTransfer
    enable_transfer = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(type=str, required=False, mutable=False)
    #: bool: *Required* bounceCallWhenAgentUnavailable
    bounce_call_when_agent_unavailable = Field(type=bool, required=True, mutable=False)


class GroupCallCenterBouncedCallGetResponse17(OCIResponse):
    """
    Response to the ``GroupCallCenterBouncedCallGetRequest17()``.

    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E(
            "number_of_rings_before_bouncing_call", "numberOfRingsBeforeBouncingCall",
            int, is_required=True,
        ),
        E("enable_transfer", "enableTransfer", bool),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E("bounce_call_when_agent_unavailable", "bounceCallWhenAgentUnavailable", bool),
        E("alert_call_center_call_on_hold", "alertCallCenterCallOnHold", bool),
        E("alert_call_center_call_on_hold_seconds", "alertCallCenterCallOnHoldSeconds", int),
        E("bounce_call_center_call_on_hold", "bounceCallCenterCallOnHold", bool),
        E(
            "bounce_call_center_call_on_hold_seconds",
            "bounceCallCenterCallOnHoldSeconds", int,
        ),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: int: *Required* numberOfRingsBeforeBouncingCall
    number_of_rings_before_bouncing_call = Field(type=int, required=True, mutable=False)
    #: bool: *Optional* enableTransfer
    enable_transfer = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* bounceCallWhenAgentUnavailable
    bounce_call_when_agent_unavailable = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* alertCallCenterCallOnHold
    alert_call_center_call_on_hold = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* alertCallCenterCallOnHoldSeconds
    alert_call_center_call_on_hold_seconds = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* bounceCallCenterCallOnHold
    bounce_call_center_call_on_hold = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* bounceCallCenterCallOnHoldSeconds
    bounce_call_center_call_on_hold_seconds = Field(type=int, required=False, mutable=False)


class GroupCallCenterCallDispositionCodeGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCallDispositionCodeGetListRequest()``.

    Contains a table with column headings: "Is Active", "Code", "Description".
    """

    _ELEMENTS = (
        E(
            "disposition_codes_table", "dispositionCodesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* dispositionCodesTable  *Tabular*
    disposition_codes_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterCallDispositionCodeGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCallDispositionCodeGetRequest()``
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class GroupCallCenterCallDispositionCodeGetUsageListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCallDispositionCodeGetUsageListRequest()``.

    The Type column contains either "Call Center" or "Route Point". Contains a table with
    column headings: "Id", "Name" and "Type".
    """

    _ELEMENTS = (
        E(
            "call_center_table", "callCenterTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* callCenterTable  *Tabular*
    call_center_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterComfortMessageBypassGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterComfortMessageBypassGetRequest()``.

    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E(
            "call_waiting_age_threshold_seconds", "callWaitingAgeThresholdSeconds", int,
            is_required=True,
        ),
        E(
            "play_announcement_after_ringing", "playAnnouncementAfterRinging", bool,
            is_required=True,
        ),
        E(
            "ring_time_before_playing_announcement_seconds",
            "ringTimeBeforePlayingAnnouncementSeconds", int, is_required=True,
        ),
        E("audio_message_selection", "audioMessageSelection", str, is_required=True),
        E("audio_file_url", "audioFileUrl", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_message_selection", "videoMessageSelection", str, is_required=True),
        E("video_file_url", "videoFileUrl", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: int: *Required* callWaitingAgeThresholdSeconds
    call_waiting_age_threshold_seconds = Field(type=int, required=True, mutable=False)
    #: bool: *Required* playAnnouncementAfterRinging
    play_announcement_after_ringing = Field(type=bool, required=True, mutable=False)
    #: int: *Required* ringTimeBeforePlayingAnnouncementSeconds
    ring_time_before_playing_announcement_seconds = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* audioMessageSelection
    audio_message_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMediaType
    audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Required* videoMessageSelection
    video_message_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* videoFileUrl
    video_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMediaType
    video_media_type = Field(type=str, required=False, mutable=False)


class GroupCallCenterCurrentAndPastAgentGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCurrentAndPastAgentGetListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E(
            "agent_user_table", "agentUserTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
        E(
            "deleted_agent_user_table", "deletedAgentUserTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* agentUserTable  *Tabular*
    agent_user_table = Field(type=list, required=True, mutable=False)
    #: list: *Required* deletedAgentUserTable  *Tabular*
    deleted_agent_user_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterCurrentAndPastCallCenterGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCurrentAndPastCallCenterGetListRequest()``.

    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_array=True),
        E("deleted_service_user_id", "deletedServiceUserId", str, is_array=True),
    )

    #: list(str): *Optional* serviceUserId  *Array*
    service_user_id = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* deletedServiceUserId  *Array*
    deleted_service_user_id = Field(type=list, required=False, mutable=False)


class GroupCallCenterCurrentAndPastDNISGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCurrentAndPastDNISGetListRequest()``.

    """

    _ELEMENTS = (
        E("name", "name", str, is_array=True),
        E("deleted_name", "deletedName", str, is_array=True),
    )

    #: list(str): *Optional* name  *Array*
    name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* deletedName  *Array*
    deleted_name = Field(type=list, required=False, mutable=False)


class GroupCallCenterDistinctiveRingingGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterDistinctiveRingingGetRequest()``.

    """

    _ELEMENTS = (
        E(
            "distinctive_ringing_call_center_calls", "distinctiveRingingCallCenterCalls",
            bool, is_required=True,
        ),
        E(
            "distinctive_ringing_ring_pattern_for_call_center",
            "distinctiveRingingRingPatternForCallCenter", str, is_required=True,
        ),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern", str,
        ),
    )

    #: bool: *Required* distinctiveRingingCallCenterCalls
    distinctive_ringing_call_center_calls = Field(type=bool, required=True, mutable=False)
    #: str: *Required* distinctiveRingingRingPatternForCallCenter
    distinctive_ringing_ring_pattern_for_call_center = Field(
        type=str, required=True, mutable=False,
    )
    #: str: *Optional* distinctiveRingingForceDeliveryRingPattern
    distinctive_ringing_force_delivery_ring_pattern = Field(
        type=str, required=False, mutable=False,
    )


class GroupCallCenterEnhancedGetResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedGetRequest()``.

    """

    _ELEMENTS = (
        E("override_agent_wrap_up_time", "overrideAgentWrapUpTime", bool, is_required=True),
        E("wrap_up_seconds", "wrapUpSeconds", int),
    )

    #: bool: *Required* overrideAgentWrapUpTime
    override_agent_wrap_up_time = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* wrapUpSeconds
    wrap_up_seconds = Field(type=int, required=False, mutable=False)


class GroupCallCenterEnhancedReportingBrandingGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterEnhancedReportingBrandingGetRequest()``.

    """

    _ELEMENTS = (
        E("branding_choice", "brandingChoice", str, is_required=True),
        E("branding_file_description", "brandingFileDescription", str),
    )

    #: str: *Required* brandingChoice
    branding_choice = Field(type=str, required=True, mutable=False)
    #: str: *Optional* brandingFileDescription
    branding_file_description = Field(type=str, required=False, mutable=False)


class GroupCallCenterEnhancedReportingGetAvailableReportTemplateListResponse(OCIResponse):
    """
    Response to
    ``GroupCallCenterEnhancedReportingGetAvailableReportTemplateListRequest()``.

    Contains a table with column headings: "Name", "Description" and "Level", "Is Agent
    Required", "Is Call Center Required", "Is Call Center Dnis Required","Is Real Time
    Report", "Is Sampling Period Required", "Call Completion Threshold Parameter", "Short
    Duration Threshold Parameter", "Service Level Threshold Parameter", "Service Level
    Inclusions Parameter", "Service Level Objective Threshold Parameter", "Abandoned Call
    Threshold Parameter", "Service Level Threshold Parameter Number", and "Abandoned Call
    Threshold Parameter Number". The possible values for "Level" are "System" and "Group".
    The possible values for "Is Agent Required", "Is Call Center Required", "Is Call
    Center Dnis Required", "Is Real Time Report" and "Is Sampling Period Required" are
    "true" and "false". The possible values for "Call Completion Threshold Parameter",
    "Short Duration Threshold Parameter", "Service Level Threshold Parameter", "Service
    Level Inclusions Parameter","Service Level Objective Threshold Parameter" and
    "Abandoned Call Threshold Parameter" are "Required", "Hidden" and "Does Not Apply".
    """

    _ELEMENTS = (
        E(
            "report_template_table", "reportTemplateTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* reportTemplateTable  *Tabular*
    report_template_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterEnhancedReportingGetResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingGetRequest()``.

    Replaced by ``GroupCallCenterEnhancedReportingGetResponse19()``
    """

    _ELEMENTS = (
        E("reporting_server", "reportingServer", str, is_required=True),
        E("web_statistic_source", "webStatisticSource", str, is_required=True),
    )

    #: str: *Required* reportingServer
    reporting_server = Field(type=str, required=True, mutable=False)
    #: str: *Required* webStatisticSource
    web_statistic_source = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingGetResponse19(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingGetRequest19()``.

    """

    _ELEMENTS = (
        E("reporting_server", "reportingServer", str, is_required=True),
    )

    #: str: *Required* reportingServer
    reporting_server = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingReportTemplateGetListResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingReportTemplateGetListRequest()``.

    Contains a table with column headings: "Name", "Description", "Type" and "Enabled"
    """

    _ELEMENTS = (
        E(
            "report_template_table", "reportTemplateTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* reportTemplateTable  *Tabular*
    report_template_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterEnhancedReportingReportTemplateGetResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingReportTemplateGetRequest()``.

    """

    _ELEMENTS = (
        E("description", "description", str),
        E("data_template", "dataTemplate", str, is_required=True),
        E("filter_number", "filterNumber", int),
        E("xslt_template_description", "xsltTemplateDescription", str, is_required=True),
        E("scope", "scope", str, is_required=True),
        E("is_enabled", "isEnabled", bool, is_required=True),
        E("is_realtime_report", "isRealtimeReport", bool),
        E("call_completion_threshold_param", "callCompletionThresholdParam", str),
        E("short_duration_threshold_param", "shortDurationThresholdParam", str),
        E("service_level_threshold_param", "serviceLevelThresholdParam", str),
        E("service_level_inclusions_param", "serviceLevelInclusionsParam", str),
        E(
            "service_level_objective_threshold_param",
            "serviceLevelObjectiveThresholdParam", str,
        ),
        E("abandoned_call_threshold_param", "abandonedCallThresholdParam", str),
        E("service_level_threshold_param_number", "serviceLevelThresholdParamNumber", int),
        E("abandoned_call_threshold_param_number", "abandonedCallThresholdParamNumber", int),
        E("filter_value", "filterValue", str),
    )

    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Required* dataTemplate
    data_template = Field(type=str, required=True, mutable=False)
    #: int: *Optional* filterNumber
    filter_number = Field(type=int, required=False, mutable=False)
    #: str: *Required* xsltTemplateDescription
    xslt_template_description = Field(type=str, required=True, mutable=False)
    #: str: *Required* scope
    scope = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isEnabled
    is_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Optional* isRealtimeReport
    is_realtime_report = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* callCompletionThresholdParam
    call_completion_threshold_param = Field(type=str, required=False, mutable=False)
    #: str: *Optional* shortDurationThresholdParam
    short_duration_threshold_param = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceLevelThresholdParam
    service_level_threshold_param = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceLevelInclusionsParam
    service_level_inclusions_param = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceLevelObjectiveThresholdParam
    service_level_objective_threshold_param = Field(type=str, required=False, mutable=False)
    #: str: *Optional* abandonedCallThresholdParam
    abandoned_call_threshold_param = Field(type=str, required=False, mutable=False)
    #: int: *Optional* serviceLevelThresholdParamNumber
    service_level_threshold_param_number = Field(type=int, required=False, mutable=False)
    #: int: *Optional* abandonedCallThresholdParamNumber
    abandoned_call_threshold_param_number = Field(type=int, required=False, mutable=False)
    #: str: *Optional* filterValue
    filter_value = Field(type=str, required=False, mutable=False)


class GroupCallCenterEnhancedReportingScheduledReportGetActiveListResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingScheduledReportGetActiveListRequest()``
    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Report Template Name", "Report Template Level" and
    "Recurring".

    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and
    "Yearly". The possible values for "Report Template Level" are "System" and "Group".
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* scheduledReportTable  *Tabular*
    scheduled_report_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterEnhancedReportingScheduledReportGetCompletedListResponse(OCIResponse):
    """
    Response to
    ``GroupCallCenterEnhancedReportingScheduledReportGetCompletedListRequest()`` Contains
    a table with column headings : "Schedule Name", "Description", "Created By", "Is
    Supervisor Report", "Report Template Name", "Report Template Level" and "Recurring".

    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and
    "Yearly". The possible values for "Report Template Level" are "System" and "Group".
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* scheduledReportTable  *Tabular*
    scheduled_report_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterEnhancedReportingScheduledReportGetListResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingScheduledReportGetListRequest()``.

    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Status", "Report Template Name", "Report Template Level" and
    "Recurring". The "Created By" can be either "Administrator" or user id if created by
    supervisor.  The possible values for "Status" are "Active", and "Completed". The
    possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and "Yearly".
    The possible values for "Report Template Level" are "System" and "Group".
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* scheduledReportTable  *Tabular*
    scheduled_report_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse(OCIResponse):
    """
    Response to
    ``GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest()``.

    Contains a table with column headings: "Schedule Name", "Created By", "Created By
    Supervisor", and "Is Active". The "Created By" can be either "Administrator" or user
    id if created by supervisor.
    """

    _ELEMENTS = (
        E(
            "schedule_report_table", "scheduleReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* scheduleReportTable  *Tabular*
    schedule_report_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterForcedForwardingGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterForcedForwardingGetRequest()``.

    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("forward_to_phone_number", "forwardToPhoneNumber", str),
        E("allow_enable_via_fac", "allowEnableViaFAC", bool, is_required=True),
        E(
            "play_announcement_before_forwarding", "playAnnouncementBeforeForwarding",
            bool, is_required=True,
        ),
        E("audio_message_selection", "audioMessageSelection", str, is_required=True),
        E("audio_file_url", "audioFileUrl", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_message_selection", "videoMessageSelection", str, is_required=True),
        E("video_file_url", "videoFileUrl", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* forwardToPhoneNumber
    forward_to_phone_number = Field(type=str, required=False, mutable=False)
    #: bool: *Required* allowEnableViaFAC
    allow_enable_via_fac = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* playAnnouncementBeforeForwarding
    play_announcement_before_forwarding = Field(type=bool, required=True, mutable=False)
    #: str: *Required* audioMessageSelection
    audio_message_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMediaType
    audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Required* videoMessageSelection
    video_message_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* videoFileUrl
    video_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMediaType
    video_media_type = Field(type=str, required=False, mutable=False)


class GroupCallCenterGetAgentListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetAgentListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Weight", "Phone Number", "Extension",
    "Department", "Email Address", "Skill Level".
    """

    _ELEMENTS = (
        E(
            "agent_table", "agentTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* agentTable  *Tabular*
    agent_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetAnnouncementResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetAnnouncementRequest()``.

    """

    _ELEMENTS = (
        E("entrance_message_selection", "entranceMessageSelection", str, is_required=True),
        E(
            "entrance_message_audio_file_description",
            "entranceMessageAudioFileDescription", str,
        ),
        E(
            "entrance_message_video_file_description",
            "entranceMessageVideoFileDescription", str,
        ),
        E(
            "periodic_comfort_message_selection", "periodicComfortMessageSelection", str,
            is_required=True,
        ),
        E(
            "periodic_comfort_message_audio_file_description",
            "periodicComfortMessageAudioFileDescription", str,
        ),
        E(
            "periodic_comfort_message_video_file_description",
            "periodicComfortMessageVideoFileDescription", str,
        ),
        E("on_hold_message_selection", "onHoldMessageSelection", str, is_required=True),
        E("on_hold_message_audio_file_description", "onHoldMessageAudioFileDescription", str),
        E("on_hold_message_video_file_description", "onHoldMessageVideoFileDescription", str),
    )

    #: str: *Required* entranceMessageSelection
    entrance_message_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* entranceMessageAudioFileDescription
    entrance_message_audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* entranceMessageVideoFileDescription
    entrance_message_video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Required* periodicComfortMessageSelection
    periodic_comfort_message_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* periodicComfortMessageAudioFileDescription
    periodic_comfort_message_audio_file_description = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* periodicComfortMessageVideoFileDescription
    periodic_comfort_message_video_file_description = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Required* onHoldMessageSelection
    on_hold_message_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* onHoldMessageAudioFileDescription
    on_hold_message_audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* onHoldMessageVideoFileDescription
    on_hold_message_video_file_description = Field(type=str, required=False, mutable=False)


class GroupCallCenterGetAvailableAgentListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetAvailableAgentListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetAvailableSupervisorListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetAvailableSupervisorListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetDNISAgentListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetDNISAgentListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E(
            "agent_table", "agentTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* agentTable  *Tabular*
    agent_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetDNISListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetDNISListResponse()``.

    Contains a table with column headings: "Name", "Phone Number", "Extension",
    "Priority", "Is Primary DNIS".
    """

    _ELEMENTS = (
        E("display_dnis_number", "displayDNISNumber", bool, is_required=True),
        E("display_dnis_name", "displayDNISName", bool, is_required=True),
        E(
            "promote_calls_from_priority1to0", "promoteCallsFromPriority1to0", bool,
            is_required=True,
        ),
        E(
            "promote_calls_from_priority2to1", "promoteCallsFromPriority2to1", bool,
            is_required=True,
        ),
        E(
            "promote_calls_from_priority3to2", "promoteCallsFromPriority3to2", bool,
            is_required=True,
        ),
        E(
            "promote_calls_from_priority1to0_seconds",
            "promoteCallsFromPriority1to0Seconds", int, is_required=True,
        ),
        E(
            "promote_calls_from_priority2to1_seconds",
            "promoteCallsFromPriority2to1Seconds", int, is_required=True,
        ),
        E(
            "promote_calls_from_priority3to2_seconds",
            "promoteCallsFromPriority3to2Seconds", int, is_required=True,
        ),
        E("dnis_table", "dnisTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: bool: *Required* displayDNISNumber
    display_dnis_number = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* displayDNISName
    display_dnis_name = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* promoteCallsFromPriority1to0
    promote_calls_from_priority1to0 = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* promoteCallsFromPriority2to1
    promote_calls_from_priority2to1 = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* promoteCallsFromPriority3to2
    promote_calls_from_priority3to2 = Field(type=bool, required=True, mutable=False)
    #: int: *Required* promoteCallsFromPriority1to0Seconds
    promote_calls_from_priority1to0_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* promoteCallsFromPriority2to1Seconds
    promote_calls_from_priority2to1_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* promoteCallsFromPriority3to2Seconds
    promote_calls_from_priority3to2_seconds = Field(type=int, required=True, mutable=False)
    #: list: *Required* dnisTable  *Tabular*
    dnis_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetDNISResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetDNISResponse()``.

    """

    _ELEMENTS = (
        E("dnis_phone_number", "dnisPhoneNumber", str),
        E("extension", "extension", str),
        E("use_custom_clid_settings", "useCustomCLIDSettings", bool, is_required=True),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
        E("calling_line_id_last_name", "callingLineIdLastName", str),
        E("calling_line_id_first_name", "callingLineIdFirstName", str),
        E(
            "use_custom_dnis_announcement_settings", "useCustomDnisAnnouncementSettings",
            bool, is_required=True,
        ),
        E("priority", "priority", str, is_required=True),
        E("allow_outgoing_acd_call", "allowOutgoingACDCall", bool, is_required=True),
    )

    #: str: *Optional* dnisPhoneNumber
    dnis_phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useCustomCLIDSettings
    use_custom_clid_settings = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useCustomDnisAnnouncementSettings
    use_custom_dnis_announcement_settings = Field(type=bool, required=True, mutable=False)
    #: str: *Required* priority
    priority = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowOutgoingACDCall
    allow_outgoing_acd_call = Field(type=bool, required=True, mutable=False)


class GroupCallCenterGetDistinctiveRingingResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetDistinctiveRingingRequest()``.

    """

    _ELEMENTS = (
        E(
            "distinctive_ringing_call_center_calls", "distinctiveRingingCallCenterCalls",
            bool, is_required=True,
        ),
        E(
            "distinctive_ringing_ring_pattern_for_call_center",
            "distinctiveRingingRingPatternForCallCenter", str, is_required=True,
        ),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern", str,
        ),
    )

    #: bool: *Required* distinctiveRingingCallCenterCalls
    distinctive_ringing_call_center_calls = Field(type=bool, required=True, mutable=False)
    #: str: *Required* distinctiveRingingRingPatternForCallCenter
    distinctive_ringing_ring_pattern_for_call_center = Field(
        type=str, required=True, mutable=False,
    )
    #: str: *Optional* distinctiveRingingForceDeliveryRingPattern
    distinctive_ringing_force_delivery_ring_pattern = Field(
        type=str, required=False, mutable=False,
    )


class GroupCallCenterGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Video", "Phone
    Number", "Extension", "Department", "Is Active", "Policy", "Type". The column values
    for "Video" and "Is Active" can either be true, or false.  The column values for
    "Type" can be "Basic", "Standard" or "Premium". NOTE: prior to release 14, the policy
    column did not match the HuntPolicy enumerated type.
    """

    _ELEMENTS = (
        E(
            "call_center_table", "callCenterTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* callCenterTable  *Tabular*
    call_center_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetInstanceQueueStatusResponse(OCIResponse):
    """
    Contains Call Center queue status and a table with column headings: "User Id", "First
    Name", "Last Name", "Phone Number", "Extension", "Department", "Email Address".

    """

    _ELEMENTS = (
        E("number_of_calls_queued_now", "numberOfCallsQueuedNow", int, is_required=True),
        E(
            "agents_currently_staffed", "agentsCurrentlyStaffed", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: int: *Required* numberOfCallsQueuedNow
    number_of_calls_queued_now = Field(type=int, required=True, mutable=False)
    #: list: *Required* agentsCurrentlyStaffed  *Tabular*
    agents_currently_staffed = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetInstanceStatisticsReportingResponse(OCIResponse):
    """
    Contains Call Center statistics reporting settings.

    """

    _ELEMENTS = (
        E("generate_daily_report", "generateDailyReport", bool, is_required=True),
        E("collection_period_minutes", "collectionPeriodMinutes", int, is_required=True),
        E("reporting_email_address1", "reportingEmailAddress1", str),
        E("reporting_email_address2", "reportingEmailAddress2", str),
    )

    #: bool: *Required* generateDailyReport
    generate_daily_report = Field(type=bool, required=True, mutable=False)
    #: int: *Required* collectionPeriodMinutes
    collection_period_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Optional* reportingEmailAddress1
    reporting_email_address1 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* reportingEmailAddress2
    reporting_email_address2 = Field(type=str, required=False, mutable=False)


class GroupCallCenterGetInstanceStatisticsReportingResponse16(OCIResponse):
    """
    Contains Call Center statistics reporting settings.

    """

    _ELEMENTS = (
        E("generate_daily_report", "generateDailyReport", bool, is_required=True),
        E("collection_period_minutes", "collectionPeriodMinutes", int, is_required=True),
        E("reporting_email_address1", "reportingEmailAddress1", str),
        E("reporting_email_address2", "reportingEmailAddress2", str),
        E("statistics_source", "statisticsSource", str, is_required=True),
    )

    #: bool: *Required* generateDailyReport
    generate_daily_report = Field(type=bool, required=True, mutable=False)
    #: int: *Required* collectionPeriodMinutes
    collection_period_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Optional* reportingEmailAddress1
    reporting_email_address1 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* reportingEmailAddress2
    reporting_email_address2 = Field(type=str, required=False, mutable=False)
    #: str: *Required* statisticsSource
    statistics_source = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceStatisticsReportingResponse17sp1(OCIResponse):
    """
    Response to ``GroupCallCenterGetInstanceStatisticsReportingRequest17sp1()``.

    Contains Call Center statistics reporting settings.
    """

    _ELEMENTS = (
        E("generate_daily_report", "generateDailyReport", bool, is_required=True),
        E("collection_period_minutes", "collectionPeriodMinutes", int, is_required=True),
        E("reporting_email_address1", "reportingEmailAddress1", str),
        E("reporting_email_address2", "reportingEmailAddress2", str),
        E("statistics_source", "statisticsSource", str, is_required=True),
    )

    #: bool: *Required* generateDailyReport
    generate_daily_report = Field(type=bool, required=True, mutable=False)
    #: int: *Required* collectionPeriodMinutes
    collection_period_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Optional* reportingEmailAddress1
    reporting_email_address1 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* reportingEmailAddress2
    reporting_email_address2 = Field(type=str, required=False, mutable=False)
    #: str: *Required* statisticsSource
    statistics_source = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetResponse(OCIResponse):
    """
    Response to ``GroupCallCenterGetRequest()``.

    Replaced by ``GroupCallCenterGetResponse17sp4()``.
    """

    _ELEMENTS = (
        E(
            "use_system_default_guard_timer", "useSystemDefaultGuardTimer", bool,
            is_required=True,
        ),
        E("enable_guard_timer", "enableGuardTimer", bool, is_required=True),
        E("guard_timer_seconds", "guardTimerSeconds", int, is_required=True),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings", bool,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int,
        ),
    )

    #: bool: *Required* useSystemDefaultGuardTimer
    use_system_default_guard_timer = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableGuardTimer
    enable_guard_timer = Field(type=bool, required=True, mutable=False)
    #: int: *Required* guardTimerSeconds
    guard_timer_seconds = Field(type=int, required=True, mutable=False)
    #: bool: *Optional* useSystemDefaultUnavailableSettings
    use_system_default_unavailable_settings = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int, required=False, mutable=False,
    )


class GroupCallCenterGetResponse17sp4(OCIResponse):
    """
    Response to ``GroupCallCenterGetRequest17sp4()``.

    """

    _ELEMENTS = (
        E(
            "use_system_default_guard_timer", "useSystemDefaultGuardTimer", bool,
            is_required=True,
        ),
        E("enable_guard_timer", "enableGuardTimer", bool, is_required=True),
        E("guard_timer_seconds", "guardTimerSeconds", int, is_required=True),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings", bool,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable", bool,
        ),
    )

    #: bool: *Required* useSystemDefaultGuardTimer
    use_system_default_guard_timer = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableGuardTimer
    enable_guard_timer = Field(type=bool, required=True, mutable=False)
    #: int: *Required* guardTimerSeconds
    guard_timer_seconds = Field(type=int, required=True, mutable=False)
    #: bool: *Optional* useSystemDefaultUnavailableSettings
    use_system_default_unavailable_settings = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool, required=False, mutable=False,
    )
    #: int: *Optional* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int, required=False, mutable=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnNotReachable
    force_agent_unavailable_on_not_reachable = Field(type=bool, required=False, mutable=False)


class GroupCallCenterGetRoutingPolicyResponse(OCIResponse):
    """
    Response to ``GroupCallCenterGetRoutingPolicyRequest()``.

    Contains a table with column headings: "Service User Id", "Name" and "Priority".
    """

    _ELEMENTS = (
        E("routing_policy", "routingPolicy", str, is_required=True),
        E(
            "call_center_table", "callCenterTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: str: *Required* routingPolicy
    routing_policy = Field(type=str, required=True, mutable=False)
    #: list: *Required* callCenterTable  *Tabular*
    call_center_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetSupervisorListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetSupervisorListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name". Element "reportingServerURL"" will always be blank.

    Replaced By: ``GroupCallCenterSupervisorReportingGetResponse()``
    """

    _ELEMENTS = (
        E("reporting_server_url", "reportingServerURL", str),
        E(
            "supervisor_table", "supervisorTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: str: *Optional* reportingServerURL
    reporting_server_url = Field(type=str, required=False, mutable=False)
    #: list: *Required* supervisorTable  *Tabular*
    supervisor_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetSupervisorListResponse16(OCIResponse):
    """
    Response to the ``GroupCallCenterGetSupervisorListRequest16()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E(
            "supervisor_table", "supervisorTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* supervisorTable  *Tabular*
    supervisor_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetUnlicensedAgentListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetUnlicensedAgentListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Group Id", "Extension",
    "Department", "Email Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterHolidayServiceGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterHolidayServiceGetRequest()``.

    """

    _ELEMENTS = (
        E("action", "action", str, is_required=True),
        E("holiday_schedule", "holidaySchedule", str),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E(
            "play_announcement_before_action", "playAnnouncementBeforeAction", bool,
            is_required=True,
        ),
        E("audio_message_selection", "audioMessageSelection", str, is_required=True),
        E("audio_file_url", "audioFileUrl", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_message_selection", "videoMessageSelection", str, is_required=True),
        E("video_file_url", "videoFileUrl", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
    )

    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* holidaySchedule
    holiday_schedule = Field(type=str, required=False, mutable=False)
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(type=str, required=False, mutable=False)
    #: bool: *Required* playAnnouncementBeforeAction
    play_announcement_before_action = Field(type=bool, required=True, mutable=False)
    #: str: *Required* audioMessageSelection
    audio_message_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMediaType
    audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Required* videoMessageSelection
    video_message_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* videoFileUrl
    video_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMediaType
    video_media_type = Field(type=str, required=False, mutable=False)


class GroupCallCenterNightServiceGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterNightServiceGetRequest()``.

    """

    _ELEMENTS = (
        E("action", "action", str, is_required=True),
        E("business_hours", "businessHours", str),
        E("force_night_service", "forceNightService", bool, is_required=True),
        E(
            "allow_manual_override_via_fac", "allowManualOverrideViaFAC", bool,
            is_required=True,
        ),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E(
            "play_announcement_before_action", "playAnnouncementBeforeAction", bool,
            is_required=True,
        ),
        E("audio_message_selection", "audioMessageSelection", str, is_required=True),
        E("audio_file_url", "audioFileUrl", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_message_selection", "videoMessageSelection", str, is_required=True),
        E("video_file_url", "videoFileUrl", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E("manual_announcement_mode", "manualAnnouncementMode", str, is_required=True),
        E(
            "manual_audio_message_selection", "manualAudioMessageSelection", str,
            is_required=True,
        ),
        E("manual_audio_file_url", "manualAudioFileUrl", str),
        E("manual_audio_file_description", "manualAudioFileDescription", str),
        E("manual_audio_media_type", "manualAudioMediaType", str),
        E(
            "manual_video_message_selection", "manualVideoMessageSelection", str,
            is_required=True,
        ),
        E("manual_video_file_url", "manualVideoFileUrl", str),
        E("manual_video_file_description", "manualVideoFileDescription", str),
        E("manual_video_media_type", "manualVideoMediaType", str),
    )

    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* businessHours
    business_hours = Field(type=str, required=False, mutable=False)
    #: bool: *Required* forceNightService
    force_night_service = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowManualOverrideViaFAC
    allow_manual_override_via_fac = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(type=str, required=False, mutable=False)
    #: bool: *Required* playAnnouncementBeforeAction
    play_announcement_before_action = Field(type=bool, required=True, mutable=False)
    #: str: *Required* audioMessageSelection
    audio_message_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMediaType
    audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Required* videoMessageSelection
    video_message_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* videoFileUrl
    video_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMediaType
    video_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Required* manualAnnouncementMode
    manual_announcement_mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* manualAudioMessageSelection
    manual_audio_message_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* manualAudioFileUrl
    manual_audio_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* manualAudioFileDescription
    manual_audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* manualAudioMediaType
    manual_audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Required* manualVideoMessageSelection
    manual_video_message_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* manualVideoFileUrl
    manual_video_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* manualVideoFileDescription
    manual_video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* manualVideoMediaType
    manual_video_media_type = Field(type=str, required=False, mutable=False)


class GroupCallCenterOverflowGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterOverflowGetRequest()``.

    """

    _ELEMENTS = (
        E("action", "action", str, is_required=True),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E("overflow_after_timeout", "overflowAfterTimeout", bool, is_required=True),
        E("timeout_seconds", "timeoutSeconds", int, is_required=True),
        E(
            "play_announcement_before_overflow_processing",
            "playAnnouncementBeforeOverflowProcessing", bool, is_required=True,
        ),
        E("audio_message_selection", "audioMessageSelection", str, is_required=True),
        E("audio_file_url", "audioFileUrl", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_message_selection", "videoMessageSelection", str),
        E("video_file_url", "videoFileUrl", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
    )

    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(type=str, required=False, mutable=False)
    #: bool: *Required* overflowAfterTimeout
    overflow_after_timeout = Field(type=bool, required=True, mutable=False)
    #: int: *Required* timeoutSeconds
    timeout_seconds = Field(type=int, required=True, mutable=False)
    #: bool: *Required* playAnnouncementBeforeOverflowProcessing
    play_announcement_before_overflow_processing = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* audioMessageSelection
    audio_message_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMediaType
    audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMessageSelection
    video_message_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileUrl
    video_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMediaType
    video_media_type = Field(type=str, required=False, mutable=False)


class GroupCallCenterQueueCallDispositionCodeGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterQueueCallDispositionCodeGetListRequest()``.

    Contains a table with column headings: "Is Active", "Code", "Description" and "Level".
    Level column can be any of the values in the data type CallDispositionCodeLevel.
    """

    _ELEMENTS = (
        E(
            "disposition_codes_table", "dispositionCodesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* dispositionCodesTable  *Tabular*
    disposition_codes_table = Field(type=list, required=True, mutable=False)


class GroupCallCenterQueueCallDispositionCodeGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterQueueCallDispositionCodeGetRequest()``
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class GroupCallCenterQueueStatusNotificationGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterQueueStatusNotificationGetRequest()``.

    The response contains the call center status configuration information.
    """

    _ELEMENTS = (
        E(
            "enable_queue_status_notification", "enableQueueStatusNotification", bool,
            is_required=True,
        ),
        E(
            "enable_queue_depth_threshold", "enableQueueDepthThreshold", bool,
            is_required=True,
        ),
        E(
            "enable_waiting_time_threshold", "enableWaitingTimeThreshold", bool,
            is_required=True,
        ),
        E("number_of_calls_threshold", "numberOfCallsThreshold", int, is_required=True),
        E(
            "waiting_time_of_calls_threshold", "waitingTimeOfCallsThreshold", int,
            is_required=True,
        ),
    )

    #: bool: *Required* enableQueueStatusNotification
    enable_queue_status_notification = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableQueueDepthThreshold
    enable_queue_depth_threshold = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableWaitingTimeThreshold
    enable_waiting_time_threshold = Field(type=bool, required=True, mutable=False)
    #: int: *Required* numberOfCallsThreshold
    number_of_calls_threshold = Field(type=int, required=True, mutable=False)
    #: int: *Required* waitingTimeOfCallsThreshold
    waiting_time_of_calls_threshold = Field(type=int, required=True, mutable=False)


class GroupCallCenterQueueThresholdsGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterQueueThresholdsGetRequest()``.

    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E(
            "threshold_current_calls_in_queue_yellow",
            "thresholdCurrentCallsInQueueYellow", int,
        ),
        E("threshold_current_calls_in_queue_red", "thresholdCurrentCallsInQueueRed", int),
        E(
            "threshold_current_longest_waiting_call_yellow",
            "thresholdCurrentLongestWaitingCallYellow", int,
        ),
        E(
            "threshold_current_longest_waiting_call_red",
            "thresholdCurrentLongestWaitingCallRed", int,
        ),
        E(
            "threshold_average_estimated_wait_time_yellow",
            "thresholdAverageEstimatedWaitTimeYellow", int,
        ),
        E(
            "threshold_average_estimated_wait_time_red",
            "thresholdAverageEstimatedWaitTimeRed", int,
        ),
        E(
            "threshold_average_handling_time_yellow",
            "thresholdAverageHandlingTimeYellow", int,
        ),
        E("threshold_average_handling_time_red", "thresholdAverageHandlingTimeRed", int),
        E(
            "threshold_average_speed_of_answer_yellow",
            "thresholdAverageSpeedOfAnswerYellow", int,
        ),
        E("threshold_average_speed_of_answer_red", "thresholdAverageSpeedOfAnswerRed", int),
        E("enable_notification_email", "enableNotificationEmail", bool, is_required=True),
        E("notification_email_address", "notificationEmailAddress", str),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* thresholdCurrentCallsInQueueYellow
    threshold_current_calls_in_queue_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdCurrentCallsInQueueRed
    threshold_current_calls_in_queue_red = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdCurrentLongestWaitingCallYellow
    threshold_current_longest_waiting_call_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdCurrentLongestWaitingCallRed
    threshold_current_longest_waiting_call_red = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdAverageEstimatedWaitTimeYellow
    threshold_average_estimated_wait_time_yellow = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* thresholdAverageEstimatedWaitTimeRed
    threshold_average_estimated_wait_time_red = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageHandlingTimeYellow
    threshold_average_handling_time_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageHandlingTimeRed
    threshold_average_handling_time_red = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageSpeedOfAnswerYellow
    threshold_average_speed_of_answer_yellow = Field(type=int, required=False, mutable=False)
    #: int: *Optional* thresholdAverageSpeedOfAnswerRed
    threshold_average_speed_of_answer_red = Field(type=int, required=False, mutable=False)
    #: bool: *Required* enableNotificationEmail
    enable_notification_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* notificationEmailAddress
    notification_email_address = Field(type=str, required=False, mutable=False)


class GroupCallCenterStrandedCallGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterStrandedCallGetRequest()``.

    """

    _ELEMENTS = (
        E("action", "action", str, is_required=True),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E("audio_message_selection", "audioMessageSelection", str),
        E("audio_file_url", "audioFileUrl", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_message_selection", "videoMessageSelection", str),
        E("video_file_url", "videoFileUrl", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
    )

    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMessageSelection
    audio_message_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMediaType
    audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMessageSelection
    video_message_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileUrl
    video_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMediaType
    video_media_type = Field(type=str, required=False, mutable=False)


class GroupCallCenterSupervisorReportingGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterSupervisorReportingGetRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name".
    """

    _ELEMENTS = (
        E("reporting_server_name", "reportingServerName", str),
        E(
            "supervisor_table", "supervisorTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: str: *Optional* reportingServerName
    reporting_server_name = Field(type=str, required=False, mutable=False)
    #: list: *Required* supervisorTable  *Tabular*
    supervisor_table = Field(type=list, required=True, mutable=False)


class GroupCallParkGetAvailableAlternateRecallUserListResponse(OCIResponse):
    """
    Response to the ``GroupCallParkGetAvailableAlternateRecallUserListResponse()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name".
    """

    _ELEMENTS = (
        E(
            "available_hunt_group_table", "availableHuntGroupTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* availableHuntGroupTable  *Tabular*
    available_hunt_group_table = Field(type=list, required=True, mutable=False)


class GroupCallParkGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCallParkGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupCallParkGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupCallParkGetInstanceListRequest()``.

    """

    _ELEMENTS = (
        E("name", "name", str, is_array=True),
    )

    #: list(str): *Optional* name  *Array*
    name = Field(type=list, required=False, mutable=False)


class GroupCallParkGetInstanceResponse(OCIResponse):
    """
    Response to the ``GroupCallParkGetInstanceRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name". The users are in the table are in the order they
    will try to be parked on.
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupCallParkGetInstanceResponse16sp2(OCIResponse):
    """
    Response to the ``GroupCallParkGetInstanceRequest16sp2()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address". The users are in the table are in the order they will try to be parked on.
    The following elements are only used in AS data mode: recallAlternateUserId recallTo
    """

    _ELEMENTS = (
        E("recall_alternate_user_id", "recallAlternateUserId", str),
        E("recall_to", "recallTo", str, is_required=True),
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: str: *Optional* recallAlternateUserId
    recall_alternate_user_id = Field(type=str, required=False, mutable=False)
    #: str: *Required* recallTo
    recall_to = Field(type=str, required=True, mutable=False)
    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupCallParkGetResponse(OCIResponse):
    """
    Response to the ``GroupCallParkGetRequest()``.

    Contains the settings that apply to the whole group for Call Park.
    """

    _ELEMENTS = (
        E("recall_timer_seconds", "recallTimerSeconds", int, is_required=True),
        E("display_timer_seconds", "displayTimerSeconds", int, is_required=True),
        E(
            "enable_destination_announcement", "enableDestinationAnnouncement", bool,
            is_required=True,
        ),
    )

    #: int: *Required* recallTimerSeconds
    recall_timer_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* displayTimerSeconds
    display_timer_seconds = Field(type=int, required=True, mutable=False)
    #: bool: *Required* enableDestinationAnnouncement
    enable_destination_announcement = Field(type=bool, required=True, mutable=False)


class GroupCallParkGetResponse16sp2(OCIResponse):
    """
    Response to the ``GroupCallParkGetRequest16sp2()``.

    Contains the settings that apply to the whole group for Call Park.  The following
    elements are only used in AS data mode: recallAlternateUserId recallRingPattern
    recallTo alternateUserRecallTimerSeconds
    """

    _ELEMENTS = (
        E("recall_timer_seconds", "recallTimerSeconds", int, is_required=True),
        E("display_timer_seconds", "displayTimerSeconds", int, is_required=True),
        E(
            "enable_destination_announcement", "enableDestinationAnnouncement", bool,
            is_required=True,
        ),
        E("recall_alternate_user_id", "recallAlternateUserId", str),
        E("recall_ring_pattern", "recallRingPattern", str, is_required=True),
        E("recall_to", "recallTo", str, is_required=True),
        E(
            "alternate_user_recall_timer_seconds", "alternateUserRecallTimerSeconds", int,
            is_required=True,
        ),
    )

    #: int: *Required* recallTimerSeconds
    recall_timer_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* displayTimerSeconds
    display_timer_seconds = Field(type=int, required=True, mutable=False)
    #: bool: *Required* enableDestinationAnnouncement
    enable_destination_announcement = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* recallAlternateUserId
    recall_alternate_user_id = Field(type=str, required=False, mutable=False)
    #: str: *Required* recallRingPattern
    recall_ring_pattern = Field(type=str, required=True, mutable=False)
    #: str: *Required* recallTo
    recall_to = Field(type=str, required=True, mutable=False)
    #: int: *Required* alternateUserRecallTimerSeconds
    alternate_user_recall_timer_seconds = Field(type=int, required=True, mutable=False)


class GroupCallPickupGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCallPickupGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupCallPickupGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupCallPickupGetInstanceListRequest()``.

    """

    _ELEMENTS = (
        E("name", "name", str, is_array=True),
    )

    #: list(str): *Optional* name  *Array*
    name = Field(type=list, required=False, mutable=False)


class GroupCallPickupGetInstanceResponse(OCIResponse):
    """
    Response to the ``GroupCallPickupGetInstanceRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse14(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest14()``.

    """

    _ELEMENTS = (
        E("use_group_setting", "useGroupSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
    )

    #: bool: *Required* useGroupSetting
    use_group_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )


class GroupCallProcessingGetPolicyResponse14sp1(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest14sp1()``.

    """

    _ELEMENTS = (
        E("use_group_setting", "useGroupSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    #: bool: *Required* useGroupSetting
    use_group_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )


class GroupCallProcessingGetPolicyResponse14sp4(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest14sp4()``.

    Replaced By : ``GroupCallProcessingGetPolicyResponse15()``
    """

    _ELEMENTS = (
        E("use_group_setting", "useGroupSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
            is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    #: bool: *Required* useGroupSetting
    use_group_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )


class GroupCallProcessingGetPolicyResponse14sp7(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest14sp7()``.

    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
            is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
    )

    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(type=bool, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse15(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest15()``.

    """

    _ELEMENTS = (
        E("use_group_setting", "useGroupSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    #: bool: *Required* useGroupSetting
    use_group_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )


class GroupCallProcessingGetPolicyResponse15sp2(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest15sp2()``.

    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
    )

    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(type=bool, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse16(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest16()``.

    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
    )

    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(type=bool, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse16sp2(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest16sp2()``.

    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_group_dclid_setting", "useGroupDCLIDSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
    )

    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupDCLIDSetting
    use_group_dclid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse17(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest17()``.

    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
    )

    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse17sp3(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest17sp3()``.

    The following elements are only used in AS data mode: useGroupDCLIDSetting
    enableDialableCallerID Replaced by ``GroupCallProcessingGetPolicyResponse17sp4()``
    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_group_dclid_setting", "useGroupDCLIDSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
    )

    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupDCLIDSetting
    use_group_dclid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse17sp4(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest17sp4()``.

    The following elements are only used in AS data mode: useGroupDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity Replaced by
    ``GroupCallProcessingGetPolicyResponse18()``
    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_group_dclid_setting", "useGroupDCLIDSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
    )

    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupDCLIDSetting
    use_group_dclid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )


class GroupCallProcessingGetPolicyResponse18(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest18()``.

    The following elements are only used in AS data mode: useGroupDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride
    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_group_dclid_setting", "useGroupDCLIDSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "allow_department_clid_name_override", "allowDepartmentCLIDNameOverride",
            bool, is_required=True,
        ),
    )

    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupDCLIDSetting
    use_group_dclid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(type=bool, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse18sp1(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest18()``.

    The following elements are only used in AS data mode: useGroupDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride enterpriseCallsCLIDPolicy groupCallsCLIDPolicy
    Replaced by: ``GroupCallProcessingGetPolicyResponse19sp1()``
    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_group_dclid_setting", "useGroupDCLIDSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "allow_department_clid_name_override", "allowDepartmentCLIDNameOverride",
            bool, is_required=True,
        ),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str, is_required=True),
        E("group_calls_clid_policy", "groupCallsCLIDPolicy", str, is_required=True),
    )

    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupDCLIDSetting
    use_group_dclid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(type=bool, required=True, mutable=False)
    #: str: *Required* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupCallsCLIDPolicy
    group_calls_clid_policy = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse19sp1(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest()``.

    The following elements are only used in AS data mode: useGroupDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride enterpriseCallsCLIDPolicy groupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_group_dclid_setting", "useGroupDCLIDSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "allow_department_clid_name_override", "allowDepartmentCLIDNameOverride",
            bool, is_required=True,
        ),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str, is_required=True),
        E("group_calls_clid_policy", "groupCallsCLIDPolicy", str, is_required=True),
    )

    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupDCLIDSetting
    use_group_dclid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(type=bool, required=True, mutable=False)
    #: str: *Required* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupCallsCLIDPolicy
    group_calls_clid_policy = Field(type=str, required=True, mutable=False)


class GroupCallRecordingGetResponse(OCIResponse):
    """
    Response to the ``GroupCallRecordingGetRequest()``.

    The response contains the group's Call Recording platform information.
    """

    _ELEMENTS = (
        E("name", "name", str),
    )

    #: str: *Optional* name
    name = Field(type=str, required=False, mutable=False)


class GroupCallingLineIdGetResponse(OCIResponse):
    """
    Response to the ``GroupCallingLineIdGetRequest()``.

    The response contains the group's calling line id settings.
    """

    _ELEMENTS = (
        E("use_group_number", "useGroupNumber", bool, is_required=True),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
        E("calling_line_id_name", "callingLineIdName", str),
    )

    #: bool: *Required* useGroupNumber
    use_group_number = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useGroupName
    use_group_name = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdName
    calling_line_id_name = Field(type=str, required=False, mutable=False)


class GroupCallingPlanGetDigitPatternListResponse(OCIResponse):
    """
    Response to ``GroupCallingPlanGetDigitPatternListRequest()``.

    Contains a table with column headings: "Name", "Digit Pattern".
    """

    _ELEMENTS = (
        E(
            "digit_pattern_table", "digitPatternTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* digitPatternTable  *Tabular*
    digit_pattern_table = Field(type=list, required=True, mutable=False)


class GroupCollaborateBridgeGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCollaborateBridgeGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", and "Hiragana First Name", "Phone Number", "Extension", "Department",
    "Email Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupCollaborateBridgeGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupCollaborateBridgeGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Participants", and "Is Default". The column values for "Is
    default" can either be true, or false.
    """

    _ELEMENTS = (
        E(
            "collaborate_bridge_table", "collaborateBridgeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* collaborateBridgeTable  *Tabular*
    collaborate_bridge_table = Field(type=list, required=True, mutable=False)


class GroupCommPilotCallManagerGetResponse(OCIResponse):
    """
    Response to ``GroupCommPilotCallManagerGetRequest()``.

    """

    _ELEMENTS = (
        E("group_directory", "groupDirectory", str, is_required=True),
    )

    #: str: *Required* groupDirectory
    group_directory = Field(type=str, required=True, mutable=False)


class GroupCommunicationBarringGetResponse(OCIResponse):
    """
    Response to ``SystemCommunicationBarringGetRequest()``.

    """

    _ELEMENTS = (
        E(
            "use_default_service_provider_profile", "useDefaultServiceProviderProfile",
            bool, is_required=True,
        ),
        E("profile", "profile", str),
    )

    #: bool: *Required* useDefaultServiceProviderProfile
    use_default_service_provider_profile = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* profile
    profile = Field(type=str, required=False, mutable=False)


class GroupCommunicationBarringProfileGetAssignedListResponse(OCIResponse):
    """
    Response to the ``GroupCommunicationBarringProfileGetAssignedListRequest()``.

    The response contains a simple list of all communication barring profiles assigned to
    the group.
    """

    _ELEMENTS = (
        E("profile_name", "profileName", str, is_array=True),
    )

    #: list(str): *Optional* profileName  *Array*
    profile_name = Field(type=list, required=False, mutable=False)


class GroupCustomContactDirectoryGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCustomContactDirectoryGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name". Replace by:
    ``GroupCustomContactDirectoryGetAvailableUserListResponse17()``
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupCustomContactDirectoryGetAvailableUserListResponse17(OCIResponse):
    """
    Response to the ``GroupCustomContactDirectoryGetAvailableUserListRequest17()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Virtual On-Net Phone Number", "Group Id", "Is
    Virtual On-Net User", "Phone Number", "Extension", "Department", "Email Address". If
    the entry represents a Virtual On-Net user then "User Id" is blank, the "Virtual On-
    Net Phone Number" contains the phone Number of the Virtual On-Net user, the "Group Id"
    contains the Virtual On-Net user's group and the "Is Virtual On-Net User" contains
    true.  If the entry represents a BroadWorks user then the "User Id" contains his
    BroadWorks userId, the "Virtual On-Net Phone Number" and "Group Id" fields are blank
    and the "Is Virtual On-Net User" contains false.
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupCustomContactDirectoryGetListResponse(OCIResponse):
    """
    Response to the ``GroupCustomContactDirectoryGetListRequest()``.

    The response contains all the group's custom contact directory names.
    """

    _ELEMENTS = (
        E("name", "name", str, is_array=True),
    )

    #: list(str): *Optional* name  *Array*
    name = Field(type=list, required=False, mutable=False)


class GroupCustomContactDirectoryGetResponse(OCIResponse):
    """
    Response to the ``GroupCustomContactDirectoryGetRequest()``.

    The response contains all the group's custom contact directory names.  Contains a
    table with column headings: "User Id", "Last Name", "First Name", "Hiragana Last
    Name", "Hiragana First Name". Replace by:
    ``GroupCustomContactDirectoryGetResponse17()``
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupCustomContactDirectoryGetResponse17(OCIResponse):
    """
    Response to the ``GroupCustomContactDirectoryGetRequest17()``.

    The response contains all the contacts in the group's given custom contact directory.
    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Virtual On-Net Phone Number", "Group Id", "Is
    Virtual On-Net User", "Department", "Phone Number", "Extension", "Mobile", "Email
    Address", "Yahoo Id", "Title", "IMP Id". If the entry represents a Virtual On-Net user
    then "User Id" is blank, the "Virtual On-Net Phone Number" contains the phone Number
    of the Virtual On-Net user, the "Group Id" contains the Virtual On-Net user's group
    and the "Is Virtual On-Net User" contains true.  If the entry represents a BroadWorks
    user then the "User Id" contains his BroadWorks userId, the "Virtual On-Net Phone
    Number" and "Group Id" fields are field is blank and the "Is Virtual On-Net User"
    contains false.
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupCustomRingbackGroupGetResponse(OCIResponse):
    """
    Response to the ``GroupCustomRingbackGroupGetRequest()``.

    Replaced By: ``GroupCustomRingbackGroupGetResponse16()``
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("audio_selection", "audioSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_file_url", "audioFileUrl", str),
        E("video_selection", "videoSelection", str, is_required=True),
        E("video_file_description", "videoFileDescription", str),
        E("video_file_url", "videoFileUrl", str),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Required* audioSelection
    audio_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Required* videoSelection
    video_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileUrl
    video_file_url = Field(type=str, required=False, mutable=False)


class GroupCustomRingbackGroupGetResponse16(OCIResponse):
    """
    Response to the ``GroupCustomRingbackGroupGetRequest16()``.

    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("audio_selection", "audioSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("audio_file_url", "audioFileUrl", str),
        E("video_selection", "videoSelection", str, is_required=True),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E("video_file_url", "videoFileUrl", str),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Required* audioSelection
    audio_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMediaType
    audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Required* videoSelection
    video_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMediaType
    video_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileUrl
    video_file_url = Field(type=str, required=False, mutable=False)


class GroupDepartmentAdminGetListResponse(OCIResponse):
    """
    Response to ``GroupDepartmentAdminGetListRequest()``.

    Contains a 5 column table with column headings "Administrator ID", "Last Name", "First
    Name", "Department", "Language".
    """

    _ELEMENTS = (
        E(
            "department_admin_table", "departmentAdminTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* departmentAdminTable  *Tabular*
    department_admin_table = Field(type=list, required=True, mutable=False)


class GroupDepartmentGetListResponse18(OCIResponse):
    """
    Response to ``GroupDepartmentGetListRequest18()``.

    Contains a table of department attributes.  The column headings are: "Is Enterprise
    Department", "Department Name", "Full Path Name", "Calling Line Id Name", and "Calling
    Line Id Phone Number"
    """

    _ELEMENTS = (
        E(
            "department_table", "departmentTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* departmentTable  *Tabular*
    department_table = Field(type=list, required=True, mutable=False)


class GroupDeviceManagementEventGetListResponse(OCIResponse):
    """
    Response to ``GroupDeviceManagementEventGetListRequest()``.

    Contains a table with column headings: "Event Id", "Status", "Action", "Level",
    "Type", "Additional Info", "Is Local", "Completion %", "Pushed/ Same Hash/ Not
    Pushed", "Login Id", "Start Time", "Process Time". "Event Id" is a unique identifer
    for the event.  "Status" can be: Pending, Queued, In Progress, Process On Other Host,
    Stale, Completed, Canceled.  "Action" can be: Delete, Download, Rebuild, Reset,
    Upload.  "Level" can be: Device, Device Type, Device Type Group, Group, User.  "Type"
    can be: Automatic, Manual.  "Additional Info" includes the affected device type,
    device or group.  It depends on the level of the event: Device Profile: "Device Name"
    "Service Provider Id" "Group Id" Device Type: "Device Type Name" Device Type Group:
    "Service Provider Id" "Group Id" "Device Type Name" Group: "Service Provider Id"
    "Group Id" User: "User Id" "Is Local" is set to "yes" if the event is processed on the
    server who received the request, "no" otherwise meaning that the event is processed on
    another server.  "Completion %" provides an estimate of the completion of the event.
    A percentage is given, the current number of completed expanded event, and the total
    number of expanded event.  "Pushed/ Same Hash/ Not Pushed" gives the total number of
    files that were pushed, not pushed because of same hash, and not pushed when
    processing the event.  "LoginId" is the user or admin id who triggered the event.
    "Start Time" is the date when the event was started.  The display shows the month,
    days, hours, and minutes (MM-dd hh:mm). "Process Time" is the time taken to process
    the event in hours, minutes, seconds, and milliseconds (hhhh:mm:ss.SSS). Each row
    represents an event sorted by priority of processing.  The first row in the table is
    an event that has an associated expanded event currently being processed or next in
    line to be processed.
    """

    _ELEMENTS = (
        E(
            "event_table", "eventTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* eventTable  *Tabular*
    event_table = Field(type=list, required=True, mutable=False)


class GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupResponse(OCIResponse):
    """
    Response to ``GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupRequest()``.

    """

    _ELEMENTS = (
        E("access_device_count", "accessDeviceCount", int, is_required=True),
    )

    #: int: *Required* accessDeviceCount
    access_device_count = Field(type=int, required=True, mutable=False)


class GroupDeviceTypeCustomTagGetListResponse(OCIResponse):
    """
    Response to ``GroupDeviceTypeCustomTagGetListRequest()``.

    Contains a table of custom configuration tags managed by the Device Management System
    on a per-device type basis for a group.  The column headings are: "Tag Name", "Tag
    Value"
    """

    _ELEMENTS = (
        E(
            "group_device_type_custom_tags_table", "groupDeviceTypeCustomTagsTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* groupDeviceTypeCustomTagsTable  *Tabular*
    group_device_type_custom_tags_table = Field(type=list, required=True, mutable=False)


class GroupDeviceTypeFileGetListResponse(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetListRequest()``.

    Contains a table of device type files managed by the Device Management System, on a
    per-group basis.  The column headings are: "File Type", "File Format", "Is
    Authenticated".

    Replaced By: ``GroupDeviceTypeFileGetListResponse14sp8()``
    """

    _ELEMENTS = (
        E(
            "group_device_type_files_table", "groupDeviceTypeFilesTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* groupDeviceTypeFilesTable  *Tabular*
    group_device_type_files_table = Field(type=list, required=True, mutable=False)


class GroupDeviceTypeFileGetListResponse14sp8(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetListRequest14sp8()``.

    Contains a table of device type files managed by the Device Management System, on a
    per-group basis.  The column headings are: "File Format", "Is Authenticated", "Access
    URL", "Repository URL", "Template URL". Replaced by:
    GroupDeviceTypeFileGetListResponset21.
    """

    _ELEMENTS = (
        E(
            "group_device_type_files_table", "groupDeviceTypeFilesTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
        E(
            "group_has_files_with_customizable_tags", "groupHasFilesWithCustomizableTags",
            bool,
        ),
    )

    #: list: *Required* groupDeviceTypeFilesTable  *Tabular*
    group_device_type_files_table = Field(type=list, required=True, mutable=False)
    #: bool: *Optional* groupHasFilesWithCustomizableTags
    group_has_files_with_customizable_tags = Field(type=bool, required=False, mutable=False)


class GroupDeviceTypeFileGetListResponse21(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetListRequest21()``.

    Contains a table of device type files managed by the Device Management System, on a
    per-group basis.  The column headings are: "File Format", "Is Authenticated", "Access
    URL", "Repository URL", "Template URL".
    """

    _ELEMENTS = (
        E(
            "group_device_type_files_table", "groupDeviceTypeFilesTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
        E(
            "group_has_customizable_dynamic_files", "groupHasCustomizableDynamicFiles",
            bool, is_required=True,
        ),
    )

    #: list: *Required* groupDeviceTypeFilesTable  *Tabular*
    group_device_type_files_table = Field(type=list, required=True, mutable=False)
    #: bool: *Required* groupHasCustomizableDynamicFiles
    group_has_customizable_dynamic_files = Field(type=bool, required=True, mutable=False)


class GroupDeviceTypeFileGetResponse(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetRequest()``.

    Replaced By: ``GroupDeviceTypeFileGetResponse14sp8()``
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str),
        E("configuration_file_name", "configurationFileName", str),
    )

    #: str: *Optional* fileSource
    file_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(type=str, required=False, mutable=False)


class GroupDeviceTypeFileGetResponse14sp8(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetRequest14sp8()``.

    Replaced by: ``GroupDeviceTypeFileGetResponse16sp1()``
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str),
        E("configuration_file_name", "configurationFileName", str),
    )

    #: str: *Optional* fileSource
    file_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(type=str, required=False, mutable=False)


class GroupDeviceTypeFileGetResponse16sp1(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetRequest16sp1()``.

    """

    _ELEMENTS = (
        E("file_source", "fileSource", str),
        E("configuration_file_name", "configurationFileName", str),
        E("access_url", "accessUrl", str, is_required=True),
        E("repository_url", "repositoryUrl", str),
        E("template_url", "templateUrl", str),
    )

    #: str: *Optional* fileSource
    file_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* accessUrl
    access_url = Field(type=str, required=True, mutable=False)
    #: str: *Optional* repositoryUrl
    repository_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* templateUrl
    template_url = Field(type=str, required=False, mutable=False)


class GroupDialPlanPolicyGetAccessCodeListResponse(OCIResponse):
    """
    Response to ``GroupDialPlanPolicyGetAccessCodeListRequest()`` Contains a table with
    column headings: "Access Code", "Enable Secondary Dial Tone", "Description"
    """

    _ELEMENTS = (
        E(
            "access_code_table", "accessCodeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* accessCodeTable  *Tabular*
    access_code_table = Field(type=list, required=True, mutable=False)


class GroupDialPlanPolicyGetAccessCodeResponse(OCIResponse):
    """
    Response to ``GroupDialPlanPolicyGetAccessCodeRequest()``
    """

    _ELEMENTS = (
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting", bool, is_required=True,
        ),
        E(
            "include_code_for_screening_services", "includeCodeForScreeningServices",
            bool, is_required=True,
        ),
        E("enable_secondary_dial_tone", "enableSecondaryDialTone", bool, is_required=True),
        E("description", "description", str),
    )

    #: bool: *Required* includeCodeForNetworkTranslationsAndRouting
    include_code_for_network_translations_and_routing = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* includeCodeForScreeningServices
    include_code_for_screening_services = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableSecondaryDialTone
    enable_secondary_dial_tone = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class GroupDialPlanPolicyGetResponse(OCIResponse):
    """
    Response to ``GroupDialPlanPolicyGetRequest()`` Replaced by:
    ``GroupDialPlanPolicyGetResponse17()``
    """

    _ELEMENTS = (
        E("use_setting", "useSetting", str, is_required=True),
        E(
            "requires_access_code_for_public_calls", "requiresAccessCodeForPublicCalls",
            bool, is_required=True,
        ),
        E("allow_e164_public_calls", "allowE164PublicCalls", bool, is_required=True),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    #: str: *Required* useSetting
    use_setting = Field(type=str, required=True, mutable=False)
    #: bool: *Required* requiresAccessCodeForPublicCalls
    requires_access_code_for_public_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowE164PublicCalls
    allow_e164_public_calls = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(type=str, required=False, mutable=False)
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(type=str, required=False, mutable=False)


class GroupDialPlanPolicyGetResponse17(OCIResponse):
    """
    Response to ``GroupDialPlanPolicyGetRequest17()``
    """

    _ELEMENTS = (
        E("use_setting", "useSetting", str, is_required=True),
        E(
            "requires_access_code_for_public_calls", "requiresAccessCodeForPublicCalls",
            bool, is_required=True,
        ),
        E("allow_e164_public_calls", "allowE164PublicCalls", bool, is_required=True),
        E(
            "prefer_e164_number_format_for_callback_services",
            "preferE164NumberFormatForCallbackServices", bool, is_required=True,
        ),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    #: str: *Required* useSetting
    use_setting = Field(type=str, required=True, mutable=False)
    #: bool: *Required* requiresAccessCodeForPublicCalls
    requires_access_code_for_public_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowE164PublicCalls
    allow_e164_public_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* preferE164NumberFormatForCallbackServices
    prefer_e164_number_format_for_callback_services = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(type=str, required=False, mutable=False)
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(type=str, required=False, mutable=False)


class GroupDialableCallerIDCriteriaGetResponse(OCIResponse):
    """
    Response to the ``GroupDialableCallerIDCriteriaGetRequest()``.

    The response contains the Dialable Caller ID Criteria information.
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("prefix_digits", "prefixDigits", str),
        E("match_call_type", "matchCallType", str, is_array=True),
        E(
            "match_alternate_call_indicator", "matchAlternateCallIndicator", str,
            is_array=True,
        ),
        E("match_local_category", "matchLocalCategory", bool, is_required=True),
        E("match_national_category", "matchNationalCategory", bool, is_required=True),
        E("match_interlata_category", "matchInterlataCategory", bool, is_required=True),
        E("match_intralata_category", "matchIntralataCategory", bool, is_required=True),
        E(
            "match_international_category", "matchInternationalCategory", bool,
            is_required=True,
        ),
        E("match_private_category", "matchPrivateCategory", bool, is_required=True),
        E("match_emergency_category", "matchEmergencyCategory", bool, is_required=True),
        E("match_other_category", "matchOtherCategory", bool, is_required=True),
    )

    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* prefixDigits
    prefix_digits = Field(type=str, required=False, mutable=False)
    #: list(str): *Optional* matchCallType  *Array*
    match_call_type = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* matchAlternateCallIndicator  *Array*
    match_alternate_call_indicator = Field(type=list, required=False, mutable=False)
    #: bool: *Required* matchLocalCategory
    match_local_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchNationalCategory
    match_national_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchInterlataCategory
    match_interlata_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchIntralataCategory
    match_intralata_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchInternationalCategory
    match_international_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchPrivateCategory
    match_private_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchEmergencyCategory
    match_emergency_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchOtherCategory
    match_other_category = Field(type=bool, required=True, mutable=False)


class GroupDialableCallerIDGetResponse(OCIResponse):
    """
    Response to the ``GroupDialableCallerIDGetRequest()``.

    The criteria table�s column headings are "Active", "Name", "Description", �Prefix
    Digits�, �Priority�.
    """

    _ELEMENTS = (
        E("use_group_criteria", "useGroupCriteria", bool, is_required=True),
        E("ns_screening_failure_policy", "nsScreeningFailurePolicy", str, is_required=True),
        E(
            "criteria_table", "criteriaTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: bool: *Required* useGroupCriteria
    use_group_criteria = Field(type=bool, required=True, mutable=False)
    #: str: *Required* nsScreeningFailurePolicy
    ns_screening_failure_policy = Field(type=str, required=True, mutable=False)
    #: list: *Required* criteriaTable  *Tabular*
    criteria_table = Field(type=list, required=True, mutable=False)


class GroupDigitCollectionGetResponse13mp4(OCIResponse):
    """
    Response to ``GroupDigitCollectionGetRequest13mp4()``.

    """

    _ELEMENTS = (
        E("use_setting", "useSetting", str, is_required=True),
        E("access_code", "accessCode", str),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    #: str: *Required* useSetting
    use_setting = Field(type=str, required=True, mutable=False)
    #: str: *Optional* accessCode
    access_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(type=str, required=False, mutable=False)
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(type=str, required=False, mutable=False)


class GroupDirectoryNumberHuntingGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupDirectoryNumberHuntingGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupDirectoryNumberHuntingGetResponse(OCIResponse):
    """
    Response to the ``GroupDirectoryNumberHuntingGetRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address". Replaced by: ``GroupDirectoryNumberHuntingGetResponse17sp1()``
    """

    _ELEMENTS = (
        E(
            "agent_user_table", "agentUserTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* agentUserTable  *Tabular*
    agent_user_table = Field(type=list, required=True, mutable=False)


class GroupDirectoryNumberHuntingGetResponse17sp1(OCIResponse):
    """
    Response to the ``GroupDirectoryNumberHuntingGetRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E(
            "agent_user_table", "agentUserTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
        E(
            "use_terminate_call_to_agent_first", "useTerminateCallToAgentFirst", bool,
            is_required=True,
        ),
        E(
            "use_original_agent_services_for_busy_and_no_answer_calls",
            "useOriginalAgentServicesForBusyAndNoAnswerCalls", bool, is_required=True,
        ),
    )

    #: list: *Required* agentUserTable  *Tabular*
    agent_user_table = Field(type=list, required=True, mutable=False)
    #: bool: *Required* useTerminateCallToAgentFirst
    use_terminate_call_to_agent_first = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useOriginalAgentServicesForBusyAndNoAnswerCalls
    use_original_agent_services_for_busy_and_no_answer_calls = Field(
        type=bool, required=True, mutable=False,
    )


class GroupDnGetActivationListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetActivationListRequest()``.

    The response contains a table with columns: "Phone Numbers", and "Activated". ". Phone
    Numbers are only returned if assigned to a user.  The "Phone Numbers" column contains
    either a single DN or a range of DNs.  The "Activated" column indicates if the phone
    number(s) are activated or not.
    """

    _ELEMENTS = (
        E("dn_table", "dnTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* dnTable  *Tabular*
    dn_table = Field(type=list, required=True, mutable=False)


class GroupDnGetAssignmentListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetAssignmentListRequest()``.

    The response contains a table with columns: "Phone Numbers", "Assigned To",
    "Department", "Activated". The "Phone Numbers" column contains either a single DN or a
    range of DNs.  The "Assigned To" column contains the user name or service instance
    name possessing the DN(s). The "Department" column contains the department of the DN,
    not the department of the user or service instance.  The "Activated" column indicates
    if the DN or DN range has been activated.  Only has a value if the DN(s) is assigned
    to a user.  Replaced by: ``GroupDnGetAssignmentListResponse18()``
    """

    _ELEMENTS = (
        E("dn_table", "dnTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* dnTable  *Tabular*
    dn_table = Field(type=list, required=True, mutable=False)


class GroupDnGetAssignmentListResponse18(OCIResponse):
    """
    Response to the ``GroupDnGetAssignmentListRequest18()``.

    The response contains a table with columns: "Phone Numbers", "Department",
    "Activated", "User Id", "Last Name", "First Name", "Extension", "Email Address", "User
    Type". The "Phone Numbers" column contains either a single DN or a range of DNs.  The
    "User Id", "Last Name" and "First Name" columns contains the corresponding attributes
    of the user possessing the DN(s). For a service instance, "Last Name" contains the
    service instance name and "First Name" column contains the corresponding enumerated
    UserType value.  The "Department" column contains the department of the DN, not the
    department of the user or service instance.  The "Activated" column indicates if the
    DN or DN range has been activated.  Only has a value if the DN(s) is assigned to a
    user.  The "User Type" column contains the corresponding enumerated UserType value.
    NOTE: the same phone number can show up in the list twice if the phone number is being
    used as the group calling line Id.
    """

    _ELEMENTS = (
        E("dn_table", "dnTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* dnTable  *Tabular*
    dn_table = Field(type=list, required=True, mutable=False)


class GroupDnGetAvailableListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetAvailableListRequest()``.

    The response contains the list of DNs that are assigned to a group and still available
    for assignment to users or service instances within the group.
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_array=True),
    )

    #: list(str): *Optional* phoneNumber  *Array*
    phone_number = Field(type=list, required=False, mutable=False)


class GroupDnGetAvailableRangesListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetAvailableRangesListRequest()``.

    The response contains the list of group DNs that are not assigned to user, service
    instances or IMRN pool.  The Dns are returned in a list of DNs or DN ranges and
    formated in E164 format for display.
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_array=True),
    )

    #: list(str): *Optional* phoneNumber  *Array*
    phone_number = Field(type=list, required=False, mutable=False)


class GroupDnGetDetailedAvailableListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetDetailedAvailableListRequest()``.

    The response contains a table with columns: "Phone Number", "Department". The "Phone
    Numbers" column contains a single DN. The "Department" column contains the department
    of the DN if the DN is part of the department.  The "Activated" column indicates if
    the DN has been activated.  Only has a value if the DN(s) is assigned to a user or if
    "Group Enable Activation Mode" is enabled.
    """

    _ELEMENTS = (
        E("dn_table", "dnTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* dnTable  *Tabular*
    dn_table = Field(type=list, required=True, mutable=False)


class GroupDnGetListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetListRequest()``.

    The response contains the list of DNs assigned to the group.
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_array=True),
    )

    #: list(str): *Optional* phoneNumber  *Array*
    phone_number = Field(type=list, required=False, mutable=False)


class GroupDnGetSummaryListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetSummaryListRequest()``.

    The response contains a table with columns: "Phone Numbers", "Assigned". The "Phone
    Numbers" column contains either a single DN or a range of DNs.  The "Assigned" column
    contains a boolean flag indicating if the DN(s) are currently assigned to a user or
    service instance.  The "Activated" column indicates if the DN or DN range has been
    activated.  Only has a value if the DN(s) is assigned to a user or if "Group Enable
    Activation Mode" is enabled.
    """

    _ELEMENTS = (
        E("dn_table", "dnTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* dnTable  *Tabular*
    dn_table = Field(type=list, required=True, mutable=False)


class GroupDomainGetAssignedListResponse(OCIResponse):
    """
    Contains a simple list of all group domain names.

    """

    _ELEMENTS = (
        E("group_default_domain", "groupDefaultDomain", str, is_required=True),
        E("domain", "domain", str, is_array=True),
    )

    #: str: *Required* groupDefaultDomain
    group_default_domain = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* domain  *Array*
    domain = Field(type=list, required=False, mutable=False)


class GroupDomainGetAssignedUserListResponse(OCIResponse):
    """
    Response to ``GroupDomainGetAssignedUserListRequest()``.

    The table columns are: "User Id", "Last Name", "First Name", "Department", "Phone
    Number", "Email Address", "Service Provider Id", "Group Id", "Hiragana Last Name" and
    "Hiragana First Name", "Extension".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupEmergencyZonesGetResponse(OCIResponse):
    """
    Response to ``GroupEmergencyZonesGetRequest()``.

    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("emergency_zones_prohibition", "emergencyZonesProhibition", str, is_required=True),
        E(
            "send_emergency_call_notify_email", "sendEmergencyCallNotifyEmail", bool,
            is_required=True,
        ),
        E("emergency_call_notify_email_address", "emergencyCallNotifyEmailAddress", str),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Required* emergencyZonesProhibition
    emergency_zones_prohibition = Field(type=str, required=True, mutable=False)
    #: bool: *Required* sendEmergencyCallNotifyEmail
    send_emergency_call_notify_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* emergencyCallNotifyEmailAddress
    emergency_call_notify_email_address = Field(type=str, required=False, mutable=False)


class GroupEndpointGetListResponse(OCIResponse):
    """
    Response to ``GroupEndpointGetListRequest()``.

    The column headings for the endpointTable are: "Line/Port", "Last Name", "First Name",
    "User Id", "User Type", "Phone Number", "Extension", "Device Type", "Device Name",
    "Net Address", "MAC Address", "Department", "Email Address". Possible values for User
    Type are �User�, �CCBasic�, �CCStandard�, �CCPremium�, �RP�, �MOH�, �MOHVideo�.
    """

    _ELEMENTS = (
        E(
            "endpoint_table", "endpointTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* endpointTable  *Tabular*
    endpoint_table = Field(type=list, required=True, mutable=False)


class GroupEnterpriseTrunkGetAvailableTrunkGroupListResponse(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetAvailableTrunkGroupListRequest()``.

    """

    _ELEMENTS = (
        E("trunk_group_name", "trunkGroupName", str, is_array=True),
    )

    #: list(str): *Optional* trunkGroupName  *Array*
    trunk_group_name = Field(type=list, required=False, mutable=False)


class GroupEnterpriseTrunkGetAvailableUserListResponse(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetAvailableUserListRequest()``.

    The column headings for the enterpriseTrunkUserTable are: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name", "Phone Number",
    "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupEnterpriseTrunkGetListResponse(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetListRequest()``.

    Contains a table of enterprise trunks defined in the enterprise The column headings
    are: "Enterprise Trunk Name", "Routing Type"
    """

    _ELEMENTS = (
        E(
            "enterprise_trunk_table", "enterpriseTrunkTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* enterpriseTrunkTable  *Tabular*
    enterprise_trunk_table = Field(type=list, required=True, mutable=False)


class GroupEnterpriseTrunkGetResponse(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetRequest()``.

    Replaced by: ``GroupEnterpriseTrunkGetResponse21()``.
    """

    _ELEMENTS = (
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int, is_required=True),
        E("route_exhaustion_action", "routeExhaustionAction", str, is_required=True),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
    )

    #: int: *Required* maximumRerouteAttempts
    maximum_reroute_attempts = Field(type=int, required=True, mutable=False)
    #: str: *Required* routeExhaustionAction
    route_exhaustion_action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* orderedRouting
    ordered_routing = Field(type=str, required=False, mutable=False)
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(type=str, required=False, mutable=False)


class GroupEnterpriseTrunkGetResponse21(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetRequest21()``.

    """

    _ELEMENTS = (
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int, is_required=True),
        E("route_exhaustion_action", "routeExhaustionAction", str, is_required=True),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
        E("enable_capacity_management", "enableCapacityManagement", bool, is_required=True),
        E("max_active_calls", "maxActiveCalls", int),
        E("capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls", int),
        E("capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int),
    )

    #: int: *Required* maximumRerouteAttempts
    maximum_reroute_attempts = Field(type=int, required=True, mutable=False)
    #: str: *Required* routeExhaustionAction
    route_exhaustion_action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* orderedRouting
    ordered_routing = Field(type=str, required=False, mutable=False)
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(type=str, required=False, mutable=False)
    #: bool: *Required* enableCapacityManagement
    enable_capacity_management = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* maxActiveCalls
    max_active_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(type=int, required=False, mutable=False)


class GroupEnterpriseTrunkGetUserListResponse(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetUserListRequest()``.

    The column headings for the enterpriseTrunkUserTable are: "User Id", "Last Name",
    "First Name", "Phone Number", "Alternate Trunk Identity", "Hiragana Last Name",
    "Hiragana First Name", "Extension", "Department", "Email Address" and "Route List
    Assigned".
    """

    _ELEMENTS = (
        E(
            "enterprise_trunk_user_table", "enterpriseTrunkUserTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* enterpriseTrunkUserTable  *Tabular*
    enterprise_trunk_user_table = Field(type=list, required=True, mutable=False)


class GroupExchangeIntegrationGetResponse(OCIResponse):
    """
    Response to ``GroupExchangeIntegrationGetRequest()``.

    """

    _ELEMENTS = (
        E("enable_exchange_integration", "enableExchangeIntegration", bool, is_required=True),
        E("exchange_url", "exchangeURL", str),
        E("exchange_user_name", "exchangeUserName", str),
    )

    #: bool: *Required* enableExchangeIntegration
    enable_exchange_integration = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* exchangeURL
    exchange_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* exchangeUserName
    exchange_user_name = Field(type=str, required=False, mutable=False)


class GroupExtensionLengthGetResponse(OCIResponse):
    """
    Response to ``GroupExtensionLengthGetRequest()``.

    """

    _ELEMENTS = (
        E("extension_length", "extensionLength", int, is_required=True),
    )

    #: int: *Required* extensionLength
    extension_length = Field(type=int, required=True, mutable=False)


class GroupExtensionLengthGetResponse17(OCIResponse):
    """
    Response to ``GroupExtensionLengthGetRequest17()``.

    """

    _ELEMENTS = (
        E("min_extension_length", "minExtensionLength", int, is_required=True),
        E("max_extension_length", "maxExtensionLength", int, is_required=True),
        E("default_extension_length", "defaultExtensionLength", int, is_required=True),
    )

    #: int: *Required* minExtensionLength
    min_extension_length = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxExtensionLength
    max_extension_length = Field(type=int, required=True, mutable=False)
    #: int: *Required* defaultExtensionLength
    default_extension_length = Field(type=int, required=True, mutable=False)


class GroupFileRepositoryDeviceUserGetListResponse(OCIResponse):
    """
    Response to ``GroupFileRepositoryDeviceUserGetListRequest()``.

    Contains a table with column headings : "User Name","Allow Delete","Allow Get","Allow
    Put" in a row for each file repository service provider user.
    """

    _ELEMENTS = (
        E(
            "file_repository_user_table", "fileRepositoryUserTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* fileRepositoryUserTable  *Tabular*
    file_repository_user_table = Field(type=list, required=True, mutable=False)


class GroupFindMeFollowMeAlertingGroupGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupFindMeFollowMeAlertingGroupGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupFindMeFollowMeGetAlertingGroupListResponse(OCIResponse):
    """
    Response to the ``GroupFindMeFollowMeGetAlertingGroupListRequest()``.

    Contains a table with column headings: "Name", "Priority".
    """

    _ELEMENTS = (
        E(
            "alerting_group_table", "alertingGroupTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* alertingGroupTable  *Tabular*
    alerting_group_table = Field(type=list, required=True, mutable=False)


class GroupFindMeFollowMeGetAlertingGroupResponse(OCIResponse):
    """
    Response to ``GroupFindMeFollowMeGetAlertingGroupRequest()``.

    Contains the alerting group information.  The user table’s column headings are: "User
    Id", "Last Name", "First Name", "Hiragana Last Name" and "Hiragana First Name", "Phone
    Number", "Extension", "Department", "Email Address". The criteria table's column
    headings are: "Is Active", "Criteria Name", "Time Schedule", "Calls From",
    "Blacklisted", "Holiday Schedule"", "Calls To Type", "Calls To Number" and "Calls To
    Extension". The possible values for the "Calls To Type" column are the following or a
    combination of them separated by comma: - Primary - Alternate X (where x is a number
    between 1 and 10) The possible values for the "Calls To Number" column are the
    following or a combination of them separated by comma: - The value of the phone number
    for the corresponding Calls To Type, when the number is available.  i.e.  Alternate 1
    may have extension, but no number.  - When no number is available a blank space is
    provided instead.  The possible values for the "Calls To Extension" column are the
    following or a combination of them separated by comma: - The value of the extension
    for the corresponding Calls To Type, when the extension is available.  i.e.  Primary
    may have number, but no extension.  - When no extension is available a blank space is
    provided instead.
    """

    _ELEMENTS = (
        E("alerting_group_description", "alertingGroupDescription", str),
        E("use_diversion_inhibitor", "useDiversionInhibitor", bool, is_required=True),
        E(
            "answer_confirmation_required", "answerConfirmationRequired", bool,
            is_required=True,
        ),
        E("number_of_rings", "numberOfRings", int, is_required=True),
        E("phone_number", "phoneNumber", str, is_array=True),
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
        E(
            "criteria_table", "criteriaTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: str: *Optional* alertingGroupDescription
    alerting_group_description = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useDiversionInhibitor
    use_diversion_inhibitor = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* answerConfirmationRequired
    answer_confirmation_required = Field(type=bool, required=True, mutable=False)
    #: int: *Required* numberOfRings
    number_of_rings = Field(type=int, required=True, mutable=False)
    #: list(str): *Optional* phoneNumber  *Array*
    phone_number = Field(type=list, required=False, mutable=False)
    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)
    #: list: *Required* criteriaTable  *Tabular*
    criteria_table = Field(type=list, required=True, mutable=False)


class GroupFindMeFollowMeGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupFindMeFollowMeGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active". The column value for "Is Active" can either be
    true, or false.
    """

    _ELEMENTS = (
        E(
            "find_me_follow_me_table", "findMeFollowMeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* findMeFollowMeTable  *Tabular*
    find_me_follow_me_table = Field(type=list, required=True, mutable=False)


class GroupFlexibleSeatingAccessDeviceGetListResponse(OCIResponse):
    """
    Response to ``GroupFlexibleSeatingAccessDeviceGetListRequest()``
    """

    _ELEMENTS = (
        E(
            "available_access_device", "availableAccessDevice", str, is_complex=True,
            is_array=True,
        ),  # unknown
    )

    #: list(str): *Optional* availableAccessDevice  *Array*
    available_access_device = Field(type=list, required=False, mutable=False)


class GroupFlexibleSeatingHostGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupFlexibleSeatingHostGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active". The column value for "Is Active" can either be
    true, or false.
    """

    _ELEMENTS = (
        E(
            "flexible_seating_host_table", "flexibleSeatingHostTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* flexibleSeatingHostTable  *Tabular*
    flexible_seating_host_table = Field(type=list, required=True, mutable=False)


class GroupFlexibleSeatingHostGuestAssociationGetResponse(OCIResponse):
    """
    Response to ``GroupFlexibleSeatingHostGuestAssociationGetRequest()``.

    """

    _ELEMENTS = (
        E("enforce_association_limit", "enforceAssociationLimit", bool, is_required=True),
        E("association_limit_hours", "associationLimitHours", int, is_required=True),
        E("access_level", "accessLevel", str, is_required=True),
        E("guest_last_name", "guestLastName", str),
        E("guest_first_name", "guestFirstName", str),
        E("guest_phone_number", "guestPhoneNumber", str),
        E("guest_extension", "guestExtension", str),
        E("guest_location_dialing_code", "guestLocationDialingCode", str),
        E("guest_association_date_time", "guestAssociationDateTime", str),
    )

    #: bool: *Required* enforceAssociationLimit
    enforce_association_limit = Field(type=bool, required=True, mutable=False)
    #: int: *Required* associationLimitHours
    association_limit_hours = Field(type=int, required=True, mutable=False)
    #: str: *Required* accessLevel
    access_level = Field(type=str, required=True, mutable=False)
    #: str: *Optional* guestLastName
    guest_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* guestFirstName
    guest_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* guestPhoneNumber
    guest_phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* guestExtension
    guest_extension = Field(type=str, required=False, mutable=False)
    #: str: *Optional* guestLocationDialingCode
    guest_location_dialing_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* guestAssociationDateTime
    guest_association_date_time = Field(type=str, required=False, mutable=False)


class GroupFlexibleSeatingHostRoutingPoliciesGetResponse(OCIResponse):
    """
    Response to the ``GroupFlexibleSeatingHostRoutingPoliciesGetRequest()``.

    """

    _ELEMENTS = (
        E("allow_emergency_calls", "allowEmergencyCalls", bool, is_required=True),
        E("allow_calls_to_voice_portal", "allowCallsToVoicePortal", bool, is_required=True),
    )

    #: bool: *Required* allowEmergencyCalls
    allow_emergency_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowCallsToVoicePortal
    allow_calls_to_voice_portal = Field(type=bool, required=True, mutable=False)


class GroupGetDefaultResponse(OCIResponse):
    """
    Response to the ``GroupGetDefaultRequest()``.

    All values are default values for a group's profile.
    """

    _ELEMENTS = (
        E("default_domain", "defaultDomain", str, is_required=True),
        E("user_limit", "userLimit", int, is_required=True),
        E("time_zone", "timeZone", str, is_required=True),
        E("time_zone_display_name", "timeZoneDisplayName", str, is_required=True),
    )

    #: str: *Required* defaultDomain
    default_domain = Field(type=str, required=True, mutable=False)
    #: int: *Required* userLimit
    user_limit = Field(type=int, required=True, mutable=False)
    #: str: *Required* timeZone
    time_zone = Field(type=str, required=True, mutable=False)
    #: str: *Required* timeZoneDisplayName
    time_zone_display_name = Field(type=str, required=True, mutable=False)


class GroupGetListInServiceProviderResponse(OCIResponse):
    """
    Response to ``GroupGetListInServiceProviderRequest()``.

    Contains a 3 column table with column headings: "Group Id", "Group Name", "User Limit"
    and a row for each group.
    """

    _ELEMENTS = (
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* groupTable  *Tabular*
    group_table = Field(type=list, required=True, mutable=False)


class GroupGetListInSystemResponse(OCIResponse):
    """
    Response to ``GroupGetListInSystemRequest()``.

    Contains a table with column headings: "Group Id", "Group Name", "User Limit",
    "Organization Id", "Organization Type" and a row for each group.  The "Organization
    Id" column is populated with either a service provider Id or an enterprise Id.  The
    "Organization Type" column is populated with one of the enumerated strings defined in
    the OrganizationType OCI data type.  Please see OCISchemaDataTypes.xsd for details on
    OrganizationType.
    """

    _ELEMENTS = (
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* groupTable  *Tabular*
    group_table = Field(type=list, required=True, mutable=False)


class GroupGetUserServiceAssignedUserListResponse(OCIResponse):
    """
    Return a table containing the list of users assigned the user service or service pack.

    The table contains columns: "User Id", "Last Name", "First Name", "Department", "Phone
    Number", "Email Address", "Hiragana Last Name"; "Hiragana First Name", "Extension".
    This is a response to the ``GroupGetUserServiceAssignedUserListRequest()``.
    """

    _ELEMENTS = (
        E(
            "user_list_table", "userListTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* userListTable  *Tabular*
    user_list_table = Field(type=list, required=True, mutable=False)


class GroupGroupPagingGetAvailableOriginatorListResponse(OCIResponse):
    """
    Response to the ``GroupGroupPagingGetAvailableOriginatorListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name" and "Hiragana First Name", "Phone Number", "Extension", "Department",
    "Email Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupGroupPagingGetAvailableTargetListResponse(OCIResponse):
    """
    Response to the ``GroupGroupPagingGetAvailableTargetListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name" and "Hiragana First Name", "Phone Number", "Extension", "Department",
    "Email Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupGroupPagingGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupGroupPagingGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active". The column value for "Is Active" can either be
    true, or false.
    """

    _ELEMENTS = (
        E(
            "paging_group_table", "pagingGroupTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* pagingGroupTable  *Tabular*
    paging_group_table = Field(type=list, required=True, mutable=False)


class GroupGroupPagingGetOriginatorListResponse(OCIResponse):
    """
    Response to the ``GroupGroupPagingGetOriginatorListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E(
            "originator_table", "originatorTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* originatorTable  *Tabular*
    originator_table = Field(type=list, required=True, mutable=False)


class GroupGroupPagingGetTargetListResponse(OCIResponse):
    """
    Response to the ``GroupGroupPagingGetTargetListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E(
            "target_table", "targetTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* targetTable  *Tabular*
    target_table = Field(type=list, required=True, mutable=False)


class GroupGroupPagingTargetsCapacityGetResponse(OCIResponse):
    """
    Response to ``GroupGroupPagingTargetsCapacityGetRequest()``.

    """

    _ELEMENTS = (
        E(
            "maximum_target_users_from_service_provider",
            "maximumTargetUsersFromServiceProvider", int, is_required=True,
        ),
        E("maximum_target_users", "maximumTargetUsers", int, is_required=True),
    )

    #: int: *Required* maximumTargetUsersFromServiceProvider
    maximum_target_users_from_service_provider = Field(type=int, required=True, mutable=False)
    #: int: *Required* maximumTargetUsers
    maximum_target_users = Field(type=int, required=True, mutable=False)


class GroupHolidayScheduleGetListResponse(OCIResponse):
    """
    Response to the ``GroupHolidayScheduleGetListRequest()``.

    The response contains all the group's holiday schedule name.
    """

    _ELEMENTS = (
        E("holiday_schedule_name", "holidayScheduleName", str, is_array=True),
    )

    #: list(str): *Optional* holidayScheduleName  *Array*
    holiday_schedule_name = Field(type=list, required=False, mutable=False)


class GroupHuntGroupGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupHuntGroupGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupHuntGroupGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupHuntGroupGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active", "Policy". The column values for "Is Active"
    can either be true, or false.  NOTE: prior to release 14, the policy column did not
    match the HuntPolicy enumerated type.
    """

    _ELEMENTS = (
        E(
            "hunt_group_table", "huntGroupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* huntGroupTable  *Tabular*
    hunt_group_table = Field(type=list, required=True, mutable=False)


class GroupIMRNGetListResponse(OCIResponse):
    """
    Response to ``GroupIMRNGetListRequest()``.

    """

    _ELEMENTS = (
        E("imrn", "imrn", str, is_array=True),
    )

    #: list(str): *Optional* imrn  *Array*
    imrn = Field(type=list, required=False, mutable=False)


class GroupInstantGroupCallGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupInstantGroupCallGetInstanceListRequest()``.

    Contains a 6 column table with column headings: "Service User Id", "Name", "Phone
    Number", "Extension", "Department", "Is Active". The column values for Is Active can
    either be true, or false.
    """

    _ELEMENTS = (
        E(
            "instant_group_call_table", "instantGroupCallTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* instantGroupCallTable  *Tabular*
    instant_group_call_table = Field(type=list, required=True, mutable=False)


class GroupIntegratedIMPGetResponse(OCIResponse):
    """
    Response to the ``GroupIntegratedIMPGetRequest()``.

    The response contains the group Integrated IMP service attributes.
    """

    _ELEMENTS = (
        E(
            "use_service_provider_setting", "useServiceProviderSetting", bool,
            is_required=True,
        ),
        E("service_domain", "serviceDomain", str),
    )

    #: bool: *Required* useServiceProviderSetting
    use_service_provider_setting = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* serviceDomain
    service_domain = Field(type=str, required=False, mutable=False)


class GroupInterceptGroupGetResponse(OCIResponse):
    """
    Response to the ``GroupInterceptGroupGetRequest()``.

    Replaced By: ``GroupInterceptGroupGetResponse16()``
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("video_file_description", "videoFileDescription", str),
        E("play_new_phone_number", "playNewPhoneNumber", bool, is_required=True),
        E("new_phone_number", "newPhoneNumber", str),
        E(
            "transfer_on_zero_to_phone_number", "transferOnZeroToPhoneNumber", bool,
            is_required=True,
        ),
        E("transfer_phone_number", "transferPhoneNumber", str),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Required* announcementSelection
    announcement_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: bool: *Required* playNewPhoneNumber
    play_new_phone_number = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* newPhoneNumber
    new_phone_number = Field(type=str, required=False, mutable=False)
    #: bool: *Required* transferOnZeroToPhoneNumber
    transfer_on_zero_to_phone_number = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(type=str, required=False, mutable=False)


class GroupInterceptGroupGetResponse16(OCIResponse):
    """
    Response to the ``GroupInterceptGroupGetRequest16()``.

    Replaced By: ``GroupInterceptGroupGetResponse16sp1()``
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E("play_new_phone_number", "playNewPhoneNumber", bool, is_required=True),
        E("new_phone_number", "newPhoneNumber", str),
        E(
            "transfer_on_zero_to_phone_number", "transferOnZeroToPhoneNumber", bool,
            is_required=True,
        ),
        E("transfer_phone_number", "transferPhoneNumber", str),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Required* announcementSelection
    announcement_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMediaType
    audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMediaType
    video_media_type = Field(type=str, required=False, mutable=False)
    #: bool: *Required* playNewPhoneNumber
    play_new_phone_number = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* newPhoneNumber
    new_phone_number = Field(type=str, required=False, mutable=False)
    #: bool: *Required* transferOnZeroToPhoneNumber
    transfer_on_zero_to_phone_number = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(type=str, required=False, mutable=False)


class GroupInterceptGroupGetResponse16sp1(OCIResponse):
    """
    Response to the ``GroupInterceptGroupGetRequest16sp1()``.

    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E("play_new_phone_number", "playNewPhoneNumber", bool, is_required=True),
        E("new_phone_number", "newPhoneNumber", str),
        E(
            "transfer_on_zero_to_phone_number", "transferOnZeroToPhoneNumber", bool,
            is_required=True,
        ),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E("reroute_outbound_calls", "rerouteOutboundCalls", bool, is_required=True),
        E("outbound_reroute_phone_number", "outboundReroutePhoneNumber", str),
        E("allow_outbound_local_calls", "allowOutboundLocalCalls", bool, is_required=True),
        E("inbound_call_mode", "inboundCallMode", str, is_required=True),
        E(
            "alternate_blocking_announcement", "alternateBlockingAnnouncement", bool,
            is_required=True,
        ),
        E("route_to_voice_mail", "routeToVoiceMail", bool, is_required=True),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Required* announcementSelection
    announcement_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMediaType
    audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMediaType
    video_media_type = Field(type=str, required=False, mutable=False)
    #: bool: *Required* playNewPhoneNumber
    play_new_phone_number = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* newPhoneNumber
    new_phone_number = Field(type=str, required=False, mutable=False)
    #: bool: *Required* transferOnZeroToPhoneNumber
    transfer_on_zero_to_phone_number = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(type=str, required=False, mutable=False)
    #: bool: *Required* rerouteOutboundCalls
    reroute_outbound_calls = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* outboundReroutePhoneNumber
    outbound_reroute_phone_number = Field(type=str, required=False, mutable=False)
    #: bool: *Required* allowOutboundLocalCalls
    allow_outbound_local_calls = Field(type=bool, required=True, mutable=False)
    #: str: *Required* inboundCallMode
    inbound_call_mode = Field(type=str, required=True, mutable=False)
    #: bool: *Required* alternateBlockingAnnouncement
    alternate_blocking_announcement = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* routeToVoiceMail
    route_to_voice_mail = Field(type=bool, required=True, mutable=False)


class GroupInventoryReportGetResponse(OCIResponse):
    """
    Response to ``GroupInventoryReportGetRequest()``.

    """

    _ELEMENTS = (
        E(
            "inventory_report_table", "inventoryReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* inventoryReportTable  *Tabular*
    inventory_report_table = Field(type=list, required=True, mutable=False)


class GroupLDAPIntegrationGetDirectoryResponse(OCIResponse):
    """
    Response to ``GroupLDAPIntegrationGetDirectoryRequest()``.

    """

    _ELEMENTS = (
        E("use_level", "useLevel", str, is_required=True),
        E("server_net_address", "serverNetAddress", str),
        E("server_port", "serverPort", int, is_required=True),
        E("search_base", "searchBase", str),
        E("use_ssl", "useSSL", bool, is_required=True),
        E("require_authentication", "requireAuthentication", bool, is_required=True),
        E("authenticated_dn", "authenticatedDN", str),
        E("authenticated_password", "authenticatedPassword", str),
        E("is_sort_enabled", "isSortEnabled", bool, is_required=True),
        E("is_paged_result_enabled", "isPagedResultEnabled", bool, is_required=True),
        E("search_filter", "searchFilter", str),
        E(
            "include_search_attribute_in_search_filter",
            "includeSearchAttributeInSearchFilter", bool, is_required=True,
        ),
        E("column1_attribute_name", "column1AttributeName", str, is_required=True),
        E("column2_attribute_name", "column2AttributeName", str),
        E("column3_attribute_name", "column3AttributeName", str),
        E("column4_attribute_name", "column4AttributeName", str),
        E("column1_label", "column1Label", str),
        E("column2_label", "column2Label", str),
        E("column3_label", "column3Label", str),
        E("column4_label", "column4Label", str),
        E("search_column", "searchColumn", int, is_required=True),
    )

    #: str: *Required* useLevel
    use_level = Field(type=str, required=True, mutable=False)
    #: str: *Optional* serverNetAddress
    server_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Required* serverPort
    server_port = Field(type=int, required=True, mutable=False)
    #: str: *Optional* searchBase
    search_base = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useSSL
    use_ssl = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* requireAuthentication
    require_authentication = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* authenticatedDN
    authenticated_dn = Field(type=str, required=False, mutable=False)
    #: str: *Optional* authenticatedPassword
    authenticated_password = Field(type=str, required=False, mutable=False)
    #: bool: *Required* isSortEnabled
    is_sort_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isPagedResultEnabled
    is_paged_result_enabled = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* searchFilter
    search_filter = Field(type=str, required=False, mutable=False)
    #: bool: *Required* includeSearchAttributeInSearchFilter
    include_search_attribute_in_search_filter = Field(type=bool, required=True, mutable=False)
    #: str: *Required* column1AttributeName
    column1_attribute_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* column2AttributeName
    column2_attribute_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column3AttributeName
    column3_attribute_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column4AttributeName
    column4_attribute_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column1Label
    column1_label = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column2Label
    column2_label = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column3Label
    column3_label = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column4Label
    column4_label = Field(type=str, required=False, mutable=False)
    #: int: *Required* searchColumn
    search_column = Field(type=int, required=True, mutable=False)


class GroupLDAPIntegrationGetResponse(OCIResponse):
    """
    Response to ``GroupLDAPIntegrationGetRequest()``.

    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)


class GroupMWIDeliveryToMobileEndpointGetResponse(OCIResponse):
    """
    Response to ``GroupMWIDeliveryToMobileEndpointGetRequest()``.

    The templateActivationTable contains the list of templates defined for the group.  The
    column headings are "Enable", "Language", "Type".
    """

    _ELEMENTS = (
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E(
            "template_activation_table", "templateActivationTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: list: *Required* templateActivationTable  *Tabular*
    template_activation_table = Field(type=list, required=True, mutable=False)


class GroupMeetMeConferencingGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupMeetMeConferencingGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", and "Hiragana First Name", "Phone Number", "Extension", "Department",
    "Email Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupMeetMeConferencingGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupMeetMeConferencingGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Ports", and "Is Active". The column values for "Is Active"
    can either be true, or false.
    """

    _ELEMENTS = (
        E(
            "conference_bridge_table", "conferenceBridgeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* conferenceBridgeTable  *Tabular*
    conference_bridge_table = Field(type=list, required=True, mutable=False)


class GroupNetworkClassOfServiceGetAssignedListResponse(OCIResponse):
    """
    Response to ``GroupNetworkClassOfServiceGetAssignedListRequest()``.

    Contains a table of all Network Classes of Service assigned to the group.  The column
    headings are: "Name", "Description" and "Default".
    """

    _ELEMENTS = (
        E(
            "network_class_of_service_table", "networkClassOfServiceTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* networkClassOfServiceTable  *Tabular*
    network_class_of_service_table = Field(type=list, required=True, mutable=False)


class GroupNetworkClassOfServiceGetAssignedUserListResponse(OCIResponse):
    """
    Response to ``GroupNetworkClassOfServiceGetAssignedUserListRequest()``.

    Contains a table of users that have the Network Class of Service assigned.  The column
    headings are: "User Id", "User Type", "Last Name", "First Name", "Department", "Phone
    Number", "Email Address", "Service Provider Id", "Group Id", "Hiragana Last Name" and
    "Hiragana First Name" , "Extension". Replaced by
    ``GroupNetworkClassOfServiceGetAssignedUserListResponse21()``
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupNetworkClassOfServiceGetAssignedUserListResponse21(OCIResponse):
    """
    Response to ``GroupNetworkClassOfServiceGetAssignedUserListRequest21()``.

    Contains a table of users that have the Network Class of Service assigned.  The column
    headings are: "User Id", "User Type", "Last Name", "First Name", "Department", "Phone
    Number", "Email Address", "Service Provider Id", "Group Id", "Hiragana Last Name" and
    "Hiragana First Name" , "Extension". The User type column will display Auto Attendant
    and the Call Center subtype.  Call Center - Basic, Call Center - Standard and Call
    Center - Premium will be displayed instead of Call Center and Auto Attendant (for the
    Basic Auto Attendant) and Auto Attendant - Standard instead of Auto Attendant.
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupOfficeZoneGetAssignedListResponse(OCIResponse):
    """
    Response to ``GroupOfficeZoneGetAssignedListRequest()``.

    Contains a table of all Office Zones assigned to the group.  The column headings are:
    "Name", "Description" and "Default".
    """

    _ELEMENTS = (
        E(
            "office_zone_table", "officeZoneTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* officeZoneTable  *Tabular*
    office_zone_table = Field(type=list, required=True, mutable=False)


class GroupOfficeZoneGetAssignedUserListResponse(OCIResponse):
    """
    Response to ``GroupOfiiceZoneGetAssignedUserListRequest()``.

    Contains a table of users that have the Office Zone assigned.  The column headings
    are: "User Id", "User Type", "Last Name", "First Name", "Department", "Phone Number",
    "Email Address", "Hiragana Last Name" and "Hiragana First Name", "Extension". Office
    Zones can only be unassigned if the Location-Based Calling Restrictions has been
    authorized to the group otherwise the request will fail.
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupOutgoingCallingPlanPinholeDigitPatternGetListResponse(OCIResponse):
    """
    Response to ``GroupOutgoingCallingPlanPinholeDigitPatternGetListRequest()``.

    Contains a table with column headings: "Name", "Digit Pattern".
    """

    _ELEMENTS = (
        E(
            "digit_pattern_table", "digitPatternTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* digitPatternTable  *Tabular*
    digit_pattern_table = Field(type=list, required=True, mutable=False)


class GroupPasswordRulesGetResponse(OCIResponse):
    """
    Response to ``GroupPasswordRulesGetRequest()``.

    Contains the password rules applicable to users within the group.  Repleced by:
    ``GroupPasswordRulesGetResponse16()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("disallow_user_id", "disallowUserId", bool, is_required=True),
        E("disallow_old_password", "disallowOldPassword", bool, is_required=True),
        E(
            "disallow_reversed_old_password", "disallowReversedOldPassword", bool,
            is_required=True,
        ),
        E("restrict_min_digits", "restrictMinDigits", bool, is_required=True),
        E("min_digits", "minDigits", int, is_required=True),
        E(
            "restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool,
            is_required=True,
        ),
        E("min_upper_case_letters", "minUpperCaseLetters", int, is_required=True),
        E(
            "restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool,
            is_required=True,
        ),
        E("min_lower_case_letters", "minLowerCaseLetters", int, is_required=True),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool, is_required=True,
        ),
        E(
            "min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int,
            is_required=True,
        ),
        E("min_length", "minLength", int, is_required=True),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int, is_required=True),
        E("password_expires_days", "passwordExpiresDays", int, is_required=True),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
        E("disallow_rules_modification", "disallowRulesModification", bool, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: bool: *Required* disallowUserId
    disallow_user_id = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowOldPassword
    disallow_old_password = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowReversedOldPassword
    disallow_reversed_old_password = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* restrictMinDigits
    restrict_min_digits = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minDigits
    min_digits = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minUpperCaseLetters
    min_upper_case_letters = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minLowerCaseLetters
    min_lower_case_letters = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(type=int, required=True, mutable=False)
    #: int: *Required* minLength
    min_length = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=True, mutable=False)
    #: int: *Required* passwordExpiresDays
    password_expires_days = Field(type=int, required=True, mutable=False)
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)
    #: bool: *Required* disallowRulesModification
    disallow_rules_modification = Field(type=bool, required=True, mutable=False)


class GroupPasswordRulesGetResponse16(OCIResponse):
    """
    Response to ``GroupPasswordRulesGetRequest16()``.

    Contains the password rules applicable to users within the group.
    """

    _ELEMENTS = (
        E("disallow_user_id", "disallowUserId", bool, is_required=True),
        E("disallow_old_password", "disallowOldPassword", bool, is_required=True),
        E(
            "disallow_reversed_old_password", "disallowReversedOldPassword", bool,
            is_required=True,
        ),
        E("restrict_min_digits", "restrictMinDigits", bool, is_required=True),
        E("min_digits", "minDigits", int, is_required=True),
        E(
            "restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool,
            is_required=True,
        ),
        E("min_upper_case_letters", "minUpperCaseLetters", int, is_required=True),
        E(
            "restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool,
            is_required=True,
        ),
        E("min_lower_case_letters", "minLowerCaseLetters", int, is_required=True),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool, is_required=True,
        ),
        E(
            "min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int,
            is_required=True,
        ),
        E("min_length", "minLength", int, is_required=True),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int, is_required=True),
        E("password_expires_days", "passwordExpiresDays", int, is_required=True),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
        E("disallow_rules_modification", "disallowRulesModification", bool, is_required=True),
        E("disallow_previous_passwords", "disallowPreviousPasswords", bool, is_required=True),
        E("number_of_previous_passwords", "numberOfPreviousPasswords", int, is_required=True),
    )

    #: bool: *Required* disallowUserId
    disallow_user_id = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowOldPassword
    disallow_old_password = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowReversedOldPassword
    disallow_reversed_old_password = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* restrictMinDigits
    restrict_min_digits = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minDigits
    min_digits = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minUpperCaseLetters
    min_upper_case_letters = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minLowerCaseLetters
    min_lower_case_letters = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(type=int, required=True, mutable=False)
    #: int: *Required* minLength
    min_length = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=True, mutable=False)
    #: int: *Required* passwordExpiresDays
    password_expires_days = Field(type=int, required=True, mutable=False)
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)
    #: bool: *Required* disallowRulesModification
    disallow_rules_modification = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowPreviousPasswords
    disallow_previous_passwords = Field(type=bool, required=True, mutable=False)
    #: int: *Required* numberOfPreviousPasswords
    number_of_previous_passwords = Field(type=int, required=True, mutable=False)


class GroupPhoneDirectoryGetListResponse(OCIResponse):
    """
    Response to ``GroupPhoneDirectoryGetListRequest()``.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id". If extended directory information is requested, the following
    columns are also included: "First Name", "Last Name", "User Id", "Pager", "Title",
    "Time Zone", "Location", "Address Line 1", "Address Line 2", "City", "State", "Zip",
    "Country". Replace by: ``GroupPhoneDirectoryGetListResponse17()``
    """

    _ELEMENTS = (
        E(
            "directory_table", "directoryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* directoryTable  *Tabular*
    directory_table = Field(type=list, required=True, mutable=False)


class GroupPhoneDirectoryGetListResponse17(OCIResponse):
    """
    Response to ``GroupPhoneDirectoryGetListRequest17()``.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "Is Virtual On-Net User" If extended directory information is
    requested, the following columns are also included: "First Name", "Last Name", "User
    Id", "Pager", "Title", "Time Zone", "Location", "Address Line 1", "Address Line 2",
    "City", "State", "Zip", "Country". Replaced by:
    ``GroupPhoneDirectoryGetListResponse18()``
    """

    _ELEMENTS = (
        E(
            "directory_table", "directoryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* directoryTable  *Tabular*
    directory_table = Field(type=list, required=True, mutable=False)


class GroupPhoneDirectoryGetListResponse17sp3(OCIResponse):
    """
    Response to ``GroupPhoneDirectoryGetListRequest17sp3()``.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "IMP Id" and "Is Virtual On-Net User" If extended directory
    information is requested, the following columns are also included: "First Name", "Last
    Name", "User Id", "Pager", "Title", "Time Zone", "Location", "Address Line 1",
    "Address Line 2", "City", "State", "Zip", "Country". Replaced by:
    ``GroupPhoneDirectoryGetListResponse18()``
    """

    _ELEMENTS = (
        E(
            "directory_table", "directoryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* directoryTable  *Tabular*
    directory_table = Field(type=list, required=True, mutable=False)


class GroupPhoneDirectoryGetListResponse18(OCIResponse):
    """
    Response to ``GroupPhoneDirectoryGetListRequest18()``.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "User Id", "IMP Id" and "Is Virtual On-Net User". If extended
    directory information is requested, the following columns are also included: "First
    Name", "Last Name", "Pager", "Title", "Time Zone", "Location", "Address Line 1",
    "Address Line 2", "City", "State", "Zip", "Country".
    """

    _ELEMENTS = (
        E(
            "directory_table", "directoryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* directoryTable  *Tabular*
    directory_table = Field(type=list, required=True, mutable=False)


class GroupPolicyGetResponse(OCIResponse):
    """
    Response to ``GroupPolicyGetRequest()``.

    Contains the policy settings for the group.
    """

    _ELEMENTS = (
        E("calling_plan_access", "callingPlanAccess", str, is_required=True),
        E("extension_access", "extensionAccess", str, is_required=True),
        E("ldap_integration_access", "ldapIntegrationAccess", str, is_required=True),
        E("voice_messaging_access", "voiceMessagingAccess", str, is_required=True),
        E("department_admin_user_access", "departmentAdminUserAccess", str, is_required=True),
        E("user_authentication_access", "userAuthenticationAccess", str, is_required=True),
        E("user_group_directory_access", "userGroupDirectoryAccess", str, is_required=True),
        E("user_profile_access", "userProfileAccess", str, is_required=True),
    )

    #: str: *Required* callingPlanAccess
    calling_plan_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* extensionAccess
    extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* ldapIntegrationAccess
    ldap_integration_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* voiceMessagingAccess
    voice_messaging_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAdminUserAccess
    department_admin_user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAuthenticationAccess
    user_authentication_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userGroupDirectoryAccess
    user_group_directory_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userProfileAccess
    user_profile_access = Field(type=str, required=True, mutable=False)


class GroupPolicyGetResponse14sp1(OCIResponse):
    """
    Response to ``GroupPolicyGetRequest14sp1()``.

    Contains the policy settings for the group.
    """

    _ELEMENTS = (
        E("calling_plan_access", "callingPlanAccess", str, is_required=True),
        E("extension_access", "extensionAccess", str, is_required=True),
        E("ldap_integration_access", "ldapIntegrationAccess", str, is_required=True),
        E("voice_messaging_access", "voiceMessagingAccess", str, is_required=True),
        E("department_admin_user_access", "departmentAdminUserAccess", str, is_required=True),
        E(
            "department_admin_trunk_group_access", "departmentAdminTrunkGroupAccess", str,
            is_required=True,
        ),
        E("user_authentication_access", "userAuthenticationAccess", str, is_required=True),
        E("user_group_directory_access", "userGroupDirectoryAccess", str, is_required=True),
        E("user_profile_access", "userProfileAccess", str, is_required=True),
    )

    #: str: *Required* callingPlanAccess
    calling_plan_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* extensionAccess
    extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* ldapIntegrationAccess
    ldap_integration_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* voiceMessagingAccess
    voice_messaging_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAdminUserAccess
    department_admin_user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAdminTrunkGroupAccess
    department_admin_trunk_group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAuthenticationAccess
    user_authentication_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userGroupDirectoryAccess
    user_group_directory_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userProfileAccess
    user_profile_access = Field(type=str, required=True, mutable=False)


class GroupPolicyGetResponse14sp4(OCIResponse):
    """
    Response to ``GroupPolicyGetRequest14sp4()``.

    Contains the policy settings for the group.
    """

    _ELEMENTS = (
        E("calling_plan_access", "callingPlanAccess", str, is_required=True),
        E("extension_access", "extensionAccess", str, is_required=True),
        E("ldap_integration_access", "ldapIntegrationAccess", str, is_required=True),
        E("voice_messaging_access", "voiceMessagingAccess", str, is_required=True),
        E("department_admin_user_access", "departmentAdminUserAccess", str, is_required=True),
        E(
            "department_admin_trunk_group_access", "departmentAdminTrunkGroupAccess", str,
            is_required=True,
        ),
        E("user_authentication_access", "userAuthenticationAccess", str, is_required=True),
        E("user_group_directory_access", "userGroupDirectoryAccess", str, is_required=True),
        E("user_profile_access", "userProfileAccess", str, is_required=True),
        E(
            "user_enhanced_call_log_access", "userEnhancedCallLogAccess", str,
            is_required=True,
        ),
    )

    #: str: *Required* callingPlanAccess
    calling_plan_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* extensionAccess
    extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* ldapIntegrationAccess
    ldap_integration_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* voiceMessagingAccess
    voice_messaging_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAdminUserAccess
    department_admin_user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAdminTrunkGroupAccess
    department_admin_trunk_group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAuthenticationAccess
    user_authentication_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userGroupDirectoryAccess
    user_group_directory_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userProfileAccess
    user_profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userEnhancedCallLogAccess
    user_enhanced_call_log_access = Field(type=str, required=True, mutable=False)


class GroupPolicyGetResponse17(OCIResponse):
    """
    Response to ``GroupPolicyGetRequest17()``.

    Contains the policy settings for the group.
    """

    _ELEMENTS = (
        E("calling_plan_access", "callingPlanAccess", str, is_required=True),
        E("extension_access", "extensionAccess", str, is_required=True),
        E("ldap_integration_access", "ldapIntegrationAccess", str, is_required=True),
        E("voice_messaging_access", "voiceMessagingAccess", str, is_required=True),
        E("department_admin_user_access", "departmentAdminUserAccess", str, is_required=True),
        E(
            "department_admin_trunk_group_access", "departmentAdminTrunkGroupAccess", str,
            is_required=True,
        ),
        E(
            "department_admin_phone_number_extension_access",
            "departmentAdminPhoneNumberExtensionAccess", str, is_required=True,
        ),
        E(
            "department_admin_calling_line_id_number_access",
            "departmentAdminCallingLineIdNumberAccess", str, is_required=True,
        ),
        E("user_authentication_access", "userAuthenticationAccess", str, is_required=True),
        E("user_group_directory_access", "userGroupDirectoryAccess", str, is_required=True),
        E("user_profile_access", "userProfileAccess", str, is_required=True),
        E(
            "user_enhanced_call_log_access", "userEnhancedCallLogAccess", str,
            is_required=True,
        ),
    )

    #: str: *Required* callingPlanAccess
    calling_plan_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* extensionAccess
    extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* ldapIntegrationAccess
    ldap_integration_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* voiceMessagingAccess
    voice_messaging_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAdminUserAccess
    department_admin_user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAdminTrunkGroupAccess
    department_admin_trunk_group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAdminPhoneNumberExtensionAccess
    department_admin_phone_number_extension_access = Field(
        type=str, required=True, mutable=False,
    )
    #: str: *Required* departmentAdminCallingLineIdNumberAccess
    department_admin_calling_line_id_number_access = Field(
        type=str, required=True, mutable=False,
    )
    #: str: *Required* userAuthenticationAccess
    user_authentication_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userGroupDirectoryAccess
    user_group_directory_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userProfileAccess
    user_profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userEnhancedCallLogAccess
    user_enhanced_call_log_access = Field(type=str, required=True, mutable=False)


class GroupPolicyGetResponse20(OCIResponse):
    """
    Response to ``GroupPolicyGetRequest20()``.

    Contains the policy settings for the group.
    """

    _ELEMENTS = (
        E("calling_plan_access", "callingPlanAccess", str, is_required=True),
        E("extension_access", "extensionAccess", str, is_required=True),
        E("ldap_integration_access", "ldapIntegrationAccess", str, is_required=True),
        E("voice_messaging_access", "voiceMessagingAccess", str, is_required=True),
        E("department_admin_user_access", "departmentAdminUserAccess", str, is_required=True),
        E(
            "department_admin_trunk_group_access", "departmentAdminTrunkGroupAccess", str,
            is_required=True,
        ),
        E(
            "department_admin_phone_number_extension_access",
            "departmentAdminPhoneNumberExtensionAccess", str, is_required=True,
        ),
        E(
            "department_admin_calling_line_id_number_access",
            "departmentAdminCallingLineIdNumberAccess", str, is_required=True,
        ),
        E("user_authentication_access", "userAuthenticationAccess", str, is_required=True),
        E("user_group_directory_access", "userGroupDirectoryAccess", str, is_required=True),
        E("user_profile_access", "userProfileAccess", str, is_required=True),
        E(
            "user_enhanced_call_log_access", "userEnhancedCallLogAccess", str,
            is_required=True,
        ),
        E(
            "user_auto_attendant_name_dialing_access",
            "userAutoAttendantNameDialingAccess", str, is_required=True,
        ),
    )

    #: str: *Required* callingPlanAccess
    calling_plan_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* extensionAccess
    extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* ldapIntegrationAccess
    ldap_integration_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* voiceMessagingAccess
    voice_messaging_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAdminUserAccess
    department_admin_user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAdminTrunkGroupAccess
    department_admin_trunk_group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAdminPhoneNumberExtensionAccess
    department_admin_phone_number_extension_access = Field(
        type=str, required=True, mutable=False,
    )
    #: str: *Required* departmentAdminCallingLineIdNumberAccess
    department_admin_calling_line_id_number_access = Field(
        type=str, required=True, mutable=False,
    )
    #: str: *Required* userAuthenticationAccess
    user_authentication_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userGroupDirectoryAccess
    user_group_directory_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userProfileAccess
    user_profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userEnhancedCallLogAccess
    user_enhanced_call_log_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAutoAttendantNameDialingAccess
    user_auto_attendant_name_dialing_access = Field(type=str, required=True, mutable=False)


class GroupPolycomPhoneServicesGetResponse(OCIResponse):
    """
    Response to ``GroupPolycomPhoneServicesGetRequest()``.

    """

    _ELEMENTS = (
        E(
            "include_group_common_phone_list_in_directory",
            "includeGroupCommonPhoneListInDirectory", bool, is_required=True,
        ),
        E(
            "include_group_custom_contact_directory_in_directory",
            "includeGroupCustomContactDirectoryInDirectory", bool, is_required=True,
        ),
        E("group_custom_contact_directory", "groupCustomContactDirectory", str),
    )

    #: bool: *Required* includeGroupCommonPhoneListInDirectory
    include_group_common_phone_list_in_directory = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* includeGroupCustomContactDirectoryInDirectory
    include_group_custom_contact_directory_in_directory = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Optional* groupCustomContactDirectory
    group_custom_contact_directory = Field(type=str, required=False, mutable=False)


class GroupPortalPasscodeRulesGetResponse(OCIResponse):
    """
    Response to ``GroupPortalPasscodeRulesGetRequest()``.

    Contains the group's passcode rules setting.
    """

    _ELEMENTS = (
        E("use_rule_level", "useRuleLevel", str, is_required=True),
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool, is_required=True),
        E("disallow_user_number", "disallowUserNumber", bool, is_required=True),
        E(
            "disallow_reversed_user_number", "disallowReversedUserNumber", bool,
            is_required=True,
        ),
        E("disallow_old_passcode", "disallowOldPasscode", bool, is_required=True),
        E(
            "disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool,
            is_required=True,
        ),
        E("min_code_length", "minCodeLength", int, is_required=True),
        E("max_code_length", "maxCodeLength", int, is_required=True),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool, is_required=True,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool, is_required=True),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    #: str: *Required* useRuleLevel
    use_rule_level = Field(type=str, required=True, mutable=False)
    #: bool: *Required* disallowRepeatedDigits
    disallow_repeated_digits = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowUserNumber
    disallow_user_number = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowReversedUserNumber
    disallow_reversed_user_number = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowOldPasscode
    disallow_old_passcode = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minCodeLength
    min_code_length = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxCodeLength
    max_code_length = Field(type=int, required=True, mutable=False)
    #: bool: *Required* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=False, mutable=False)
    #: bool: *Required* expirePassword
    expire_password = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(type=int, required=False, mutable=False)
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)


class GroupPortalPasscodeRulesGetResponse19(OCIResponse):
    """
    Response to ``GroupPortalPasscodeRulesGetRequest19()``.

    Contains the group's passcode rules setting.  The following elements are only used in
    AS data mode: numberOfRepeatedDigits disallowRepeatedPatterns
    disallowContiguousSequences numberOfAscendingDigits numberOfDescendingDigits
    numberOfPreviousPasscodes
    """

    _ELEMENTS = (
        E("use_rule_level", "useRuleLevel", str, is_required=True),
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool, is_required=True),
        E("number_of_repeated_digits", "numberOfRepeatedDigits", int, is_required=True),
        E("disallow_repeated_patterns", "disallowRepeatedPatterns", bool, is_required=True),
        E(
            "disallow_contiguous_sequences", "disallowContiguousSequences", bool,
            is_required=True,
        ),
        E("number_of_ascending_digits", "numberOfAscendingDigits", int, is_required=True),
        E("number_of_descending_digits", "numberOfDescendingDigits", int, is_required=True),
        E("disallow_user_number", "disallowUserNumber", bool, is_required=True),
        E(
            "disallow_reversed_user_number", "disallowReversedUserNumber", bool,
            is_required=True,
        ),
        E("disallow_old_passcode", "disallowOldPasscode", bool, is_required=True),
        E("number_of_previous_passcodes", "numberOfPreviousPasscodes", int, is_required=True),
        E(
            "disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool,
            is_required=True,
        ),
        E("min_code_length", "minCodeLength", int, is_required=True),
        E("max_code_length", "maxCodeLength", int, is_required=True),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool, is_required=True,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool, is_required=True),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    #: str: *Required* useRuleLevel
    use_rule_level = Field(type=str, required=True, mutable=False)
    #: bool: *Required* disallowRepeatedDigits
    disallow_repeated_digits = Field(type=bool, required=True, mutable=False)
    #: int: *Required* numberOfRepeatedDigits
    number_of_repeated_digits = Field(type=int, required=True, mutable=False)
    #: bool: *Required* disallowRepeatedPatterns
    disallow_repeated_patterns = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowContiguousSequences
    disallow_contiguous_sequences = Field(type=bool, required=True, mutable=False)
    #: int: *Required* numberOfAscendingDigits
    number_of_ascending_digits = Field(type=int, required=True, mutable=False)
    #: int: *Required* numberOfDescendingDigits
    number_of_descending_digits = Field(type=int, required=True, mutable=False)
    #: bool: *Required* disallowUserNumber
    disallow_user_number = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowReversedUserNumber
    disallow_reversed_user_number = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowOldPasscode
    disallow_old_passcode = Field(type=bool, required=True, mutable=False)
    #: int: *Required* numberOfPreviousPasscodes
    number_of_previous_passcodes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minCodeLength
    min_code_length = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxCodeLength
    max_code_length = Field(type=int, required=True, mutable=False)
    #: bool: *Required* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=False, mutable=False)
    #: bool: *Required* expirePassword
    expire_password = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(type=int, required=False, mutable=False)
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)


class GroupPreAlertingAnnouncementGetResponse(OCIResponse):
    """
    Get the group level pre-alerting service settings.

    The response is either a ``GroupPreAlertingAnnouncementGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("announcement_interruption", "announcementInterruption", str, is_required=True),
        E("interruption_digit_sequence", "interruptionDigitSequence", str),
        E("audio_selection", "audioSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("audio_file_url", "audioFileUrl", str),
        E("video_selection", "videoSelection", str, is_required=True),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E("video_file_url", "videoFileUrl", str),
    )

    #: str: *Required* announcementInterruption
    announcement_interruption = Field(type=str, required=True, mutable=False)
    #: str: *Optional* interruptionDigitSequence
    interruption_digit_sequence = Field(type=str, required=False, mutable=False)
    #: str: *Required* audioSelection
    audio_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMediaType
    audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Required* videoSelection
    video_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMediaType
    video_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileUrl
    video_file_url = Field(type=str, required=False, mutable=False)


class GroupRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse(OCIResponse):
    """
    Response to ``GroupRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest()``.

    Contains a list of number ranges that are assigned to a group and still available for
    assignment to users within the group.  The column headings are "Number Range Start",
    "Number Range End" and "Is Active".
    """

    _ELEMENTS = (
        E(
            "available_number_range_table", "availableNumberRangeTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* availableNumberRangeTable  *Tabular*
    available_number_range_table = Field(type=list, required=True, mutable=False)


class GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse(OCIResponse):
    """
    Response to ``GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest()``.

    The response contains a table with columns: "Number Range Start", "Number Range End",
    "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address", "Enterprise Trunk" and "Is
    Active". The "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana
    First Name", "Phone Number", "Extension", "Department" and "Email Address" columns
    contains the corresponding attributes of the user possessing the number range.  The
    "Enterprise Trunk" column contains the enterprise trunk the user possessing the number
    range belongs to.  The "Is Active" column indicates if the number range has been
    activated.
    """

    _ELEMENTS = (
        E(
            "number_range_summary_table", "numberRangeSummaryTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* numberRangeSummaryTable  *Tabular*
    number_range_summary_table = Field(type=list, required=True, mutable=False)


class GroupRoutePointBouncedCallGetResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointBouncedCallGetRequest()``.

    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E(
            "number_of_rings_before_bouncing_call", "numberOfRingsBeforeBouncingCall",
            int, is_required=True,
        ),
        E("enable_transfer", "enableTransfer", bool),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E(
            "bounce_call_when_agent_unavailable", "bounceCallWhenAgentUnavailable", bool,
            is_required=True,
        ),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: int: *Required* numberOfRingsBeforeBouncingCall
    number_of_rings_before_bouncing_call = Field(type=int, required=True, mutable=False)
    #: bool: *Optional* enableTransfer
    enable_transfer = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(type=str, required=False, mutable=False)
    #: bool: *Required* bounceCallWhenAgentUnavailable
    bounce_call_when_agent_unavailable = Field(type=bool, required=True, mutable=False)


class GroupRoutePointDistinctiveRingingGetResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointDistinctiveRingingGetRequest()``.

    """

    _ELEMENTS = (
        E("enable_distinctive_ringing", "enableDistinctiveRinging", bool, is_required=True),
        E(
            "distinctive_ringing_ring_pattern", "distinctiveRingingRingPattern", str,
            is_required=True,
        ),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern", str, is_required=True,
        ),
    )

    #: bool: *Required* enableDistinctiveRinging
    enable_distinctive_ringing = Field(type=bool, required=True, mutable=False)
    #: str: *Required* distinctiveRingingRingPattern
    distinctive_ringing_ring_pattern = Field(type=str, required=True, mutable=False)
    #: str: *Required* distinctiveRingingForceDeliveryRingPattern
    distinctive_ringing_force_delivery_ring_pattern = Field(
        type=str, required=True, mutable=False,
    )


class GroupRoutePointExternalSystemGetAssignedListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointExternalSystemGetAssignedListRequest()``.

    Contains a table of all Route Point External Systems assigned to the group.  The
    column headings are: "Name" and "Description".
    """

    _ELEMENTS = (
        E(
            "external_system_table", "externalSystemTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* externalSystemTable  *Tabular*
    external_system_table = Field(type=list, required=True, mutable=False)


class GroupRoutePointExternalSystemGetAssignedRoutePointListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointExternalSystemGetAssignedRoutePointListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Video", "Phone
    Number", "Extension", "Department". The column values for "Video" can either be
    "true", or "false".
    """

    _ELEMENTS = (
        E(
            "route_point_table", "routePointTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* routePointTable  *Tabular*
    route_point_table = Field(type=list, required=True, mutable=False)


class GroupRoutePointGetDNISAgentListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointGetDNISAgentListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E(
            "agent_table", "agentTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* agentTable  *Tabular*
    agent_table = Field(type=list, required=True, mutable=False)


class GroupRoutePointGetDNISListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointGetDNISListRequest()``.

    Contains a table with column headings: "Name", "Phone Number", "Extension".
    """

    _ELEMENTS = (
        E("display_dnis_number", "displayDNISNumber", bool, is_required=True),
        E("display_dnis_name", "displayDNISName", bool, is_required=True),
        E("dnis_table", "dnisTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: bool: *Required* displayDNISNumber
    display_dnis_number = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* displayDNISName
    display_dnis_name = Field(type=bool, required=True, mutable=False)
    #: list: *Required* dnisTable  *Tabular*
    dnis_table = Field(type=list, required=True, mutable=False)


class GroupRoutePointGetDNISResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointGetDNISRequest()``.

    """

    _ELEMENTS = (
        E("dnis_phone_number", "dnisPhoneNumber", str),
        E("extension", "extension", str),
        E("use_custom_clid_settings", "useCustomCLIDSettings", bool, is_required=True),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
        E("calling_line_id_last_name", "callingLineIdLastName", str),
        E("calling_line_id_first_name", "callingLineIdFirstName", str),
        E(
            "use_custom_dnis_announcement_settings", "useCustomDnisAnnouncementSettings",
            bool, is_required=True,
        ),
        E("allow_outgoing_acd_call", "allowOutgoingACDCall", bool, is_required=True),
    )

    #: str: *Optional* dnisPhoneNumber
    dnis_phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useCustomCLIDSettings
    use_custom_clid_settings = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useCustomDnisAnnouncementSettings
    use_custom_dnis_announcement_settings = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowOutgoingACDCall
    allow_outgoing_acd_call = Field(type=bool, required=True, mutable=False)


class GroupRoutePointGetFailoverPolicyResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointGetFailoverPolicyRequest()``.

    """

    _ELEMENTS = (
        E("enable_failover_support", "enableFailoverSupport", bool, is_required=True),
        E("external_system", "externalSystem", str),
        E("failover_phone_number", "failoverPhoneNumber", str),
        E("failover_status", "failoverStatus", str, is_required=True),
        E(
            "per_call_enable_failover_support", "perCallEnableFailoverSupport", bool,
            is_required=True,
        ),
        E(
            "per_call_call_failure_timeout_seconds", "perCallCallFailureTimeoutSeconds",
            int, is_required=True,
        ),
        E(
            "per_call_outbound_call_failure_timeout_seconds",
            "perCallOutboundCallFailureTimeoutSeconds", int, is_required=True,
        ),
        E("per_call_failover_phone_number", "perCallFailoverPhoneNumber", str),
    )

    #: bool: *Required* enableFailoverSupport
    enable_failover_support = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* externalSystem
    external_system = Field(type=str, required=False, mutable=False)
    #: str: *Optional* failoverPhoneNumber
    failover_phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Required* failoverStatus
    failover_status = Field(type=str, required=True, mutable=False)
    #: bool: *Required* perCallEnableFailoverSupport
    per_call_enable_failover_support = Field(type=bool, required=True, mutable=False)
    #: int: *Required* perCallCallFailureTimeoutSeconds
    per_call_call_failure_timeout_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* perCallOutboundCallFailureTimeoutSeconds
    per_call_outbound_call_failure_timeout_seconds = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Optional* perCallFailoverPhoneNumber
    per_call_failover_phone_number = Field(type=str, required=False, mutable=False)


class GroupRoutePointGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Video", "Phone
    Number", "Extension", "Department", "Is Active". The column values for "Video" and "Is
    Active" can either be true, or false.
    """

    _ELEMENTS = (
        E(
            "route_point_table", "routePointTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* routePointTable  *Tabular*
    route_point_table = Field(type=list, required=True, mutable=False)


class GroupRoutePointQueueCallDispositionCodeGetListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointQueueCallDispositionCodeGetListRequest()``.

    Contains a table with column headings: "Is Active", "Code", "Description" and "Level".
    Level column can be any of the values in the data type CallDispositionCodeLevel.
    """

    _ELEMENTS = (
        E(
            "disposition_codes_table", "dispositionCodesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* dispositionCodesTable  *Tabular*
    disposition_codes_table = Field(type=list, required=True, mutable=False)


class GroupRoutePointQueueCallDispositionCodeGetResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointQueueCallDispositionCodeGetRequest()``
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class GroupRoutingProfileGetResponse(OCIResponse):
    """
    Response to ``GroupRoutingProfileGetRequest()``.

    """

    _ELEMENTS = (
        E("routing_profile", "routingProfile", str),
    )

    #: str: *Optional* routingProfile
    routing_profile = Field(type=str, required=False, mutable=False)


class GroupScheduleGetEventListResponse(OCIResponse):
    """
    Response to ``GroupScheduleGetEventListRequest()``.

    The response contains a list of events.
    """

    _ELEMENTS = (
        E("event_name", "eventName", str, is_array=True),
    )

    #: list(str): *Optional* eventName  *Array*
    event_name = Field(type=list, required=False, mutable=False)


class GroupScheduleGetListResponse(OCIResponse):
    """
    Response to ``GroupScheduleGetListRequest()``.

    The response contains a list of system schedules.
    """

    _ELEMENTS = (
        E("schedule_name", "scheduleName", str, is_array=True),
        E("schedule_type", "scheduleType", str, is_array=True),
        E("schedule_level", "scheduleLevel", str, is_array=True),
    )

    #: list(str): *Optional* scheduleName  *Array*
    schedule_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* scheduleType  *Array*
    schedule_type = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* scheduleLevel  *Array*
    schedule_level = Field(type=list, required=False, mutable=False)


class GroupSeriesCompletionGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupSeriesCompletionGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupSeriesCompletionGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupSeriesCompletionGetInstanceListRequest()``.

    """

    _ELEMENTS = (
        E("name", "name", str, is_array=True),
    )

    #: list(str): *Optional* name  *Array*
    name = Field(type=list, required=False, mutable=False)


class GroupSeriesCompletionGetInstanceResponse(OCIResponse):
    """
    Response to the ``GroupSeriesCompletionGetInstanceRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupServiceGetAuthorizationListResponse(OCIResponse):
    """
    Response to ``GroupServiceGetAuthorizationListRequest()``.

    Contains three tables, one for the service packs, one for the group services, and one
    for the user services.  The user table has the following column headings: "Service
    Name", "Authorized", "Assigned", "Limited", "Quantity", "Usage", "Licensed",
    "Allowed", "User Assignable", "Group Service Assignable". The group service table has
    the following column headings: "Service Name", "Authorized", "Assigned", "Limited",
    "Quantity", "Usage", "Licensed", "Allowed". The service pack table's column headings
    are: "Service Pack Name", "Authorized", "Assigned", "Limited", "Allocated", "Allowed",
    "Usage", "Description".
    """

    _ELEMENTS = (
        E(
            "service_packs_authorization_table", "servicePacksAuthorizationTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
        E(
            "group_services_authorization_table", "groupServicesAuthorizationTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
        E(
            "user_services_authorization_table", "userServicesAuthorizationTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* servicePacksAuthorizationTable  *Tabular*
    service_packs_authorization_table = Field(type=list, required=True, mutable=False)
    #: list: *Required* groupServicesAuthorizationTable  *Tabular*
    group_services_authorization_table = Field(type=list, required=True, mutable=False)
    #: list: *Required* userServicesAuthorizationTable  *Tabular*
    user_services_authorization_table = Field(type=list, required=True, mutable=False)


class GroupServiceGetAuthorizedListResponse(OCIResponse):
    """
    Response to ``GroupServiceGetAuthorizedListRequest()``.

    """

    _ELEMENTS = (
        E("service_pack_name", "servicePackName", str, is_array=True),
        E("group_service_name", "groupServiceName", str, is_array=True),
        E("user_service_name", "userServiceName", str, is_array=True),
    )

    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* groupServiceName  *Array*
    group_service_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* userServiceName  *Array*
    user_service_name = Field(type=list, required=False, mutable=False)


class GroupServiceInstancePrivacyGetResponse(OCIResponse):
    """
    Response to ``GroupServiceInstancePrivacyGetRequest()``.

    Replaced by: ``GroupServiceInstancePrivacyGetResponse17sp4()``
    """

    _ELEMENTS = (
        E("enable_directory_privacy", "enableDirectoryPrivacy", bool, is_required=True),
        E(
            "enable_auto_attendant_extension_dialing_privacy",
            "enableAutoAttendantExtensionDialingPrivacy", bool, is_required=True,
        ),
    )

    #: bool: *Required* enableDirectoryPrivacy
    enable_directory_privacy = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableAutoAttendantExtensionDialingPrivacy
    enable_auto_attendant_extension_dialing_privacy = Field(
        type=bool, required=True, mutable=False,
    )


class GroupServiceInstancePrivacyGetResponse17sp4(OCIResponse):
    """
    Response to ``GroupServiceInstancePrivacyGetRequest17sp4()``.

    """

    _ELEMENTS = (
        E("enable_directory_privacy", "enableDirectoryPrivacy", bool, is_required=True),
        E(
            "enable_auto_attendant_extension_dialing_privacy",
            "enableAutoAttendantExtensionDialingPrivacy", bool, is_required=True,
        ),
        E(
            "enable_auto_attendant_name_dialing_privacy",
            "enableAutoAttendantNameDialingPrivacy", bool, is_required=True,
        ),
    )

    #: bool: *Required* enableDirectoryPrivacy
    enable_directory_privacy = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableAutoAttendantExtensionDialingPrivacy
    enable_auto_attendant_extension_dialing_privacy = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableAutoAttendantNameDialingPrivacy
    enable_auto_attendant_name_dialing_privacy = Field(
        type=bool, required=True, mutable=False,
    )


class GroupServiceIsAssignedResponse(OCIResponse):
    """
    Returns true if the GroupService is assigned, otherwise false.

    """

    _ELEMENTS = (
        E("is_assigned", "isAssigned", bool, is_required=True),
    )

    #: bool: *Required* isAssigned
    is_assigned = Field(type=bool, required=True, mutable=False)


class GroupServicePhoneNumberLookupResponse(OCIResponse):
    """
    Response to the ``GroupServicePhoneNumberLookupRequest()``.

    The column headings for the userTable are: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name", "Phone Number", "Extension" and
    "Department".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupServiceScriptsGroupGetLogResponse(OCIResponse):
    """
    Response to ``GroupServiceScriptsGroupGetLogRequest()``.

    """

    _ELEMENTS = (
        E("log_content", "logContent", str),
    )

    #: str: *Optional* logContent
    log_content = Field(type=str, required=False, mutable=False)


class GroupServiceScriptsGroupGetResponse(OCIResponse):
    """
    Response to ``GroupServiceScriptsGroupGetRequest()``.

    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("script_name", "scriptName", str),
        E("script_content", "scriptContent", str),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* scriptName
    script_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* scriptContent
    script_content = Field(type=str, required=False, mutable=False)


class GroupSessionAdmissionControlGetResponse(OCIResponse):
    """
    Response to the ``GroupSessionAdmissionControlGetRequest()``.

    The response contains the session admission control capacity allocated for the group.
    """

    _ELEMENTS = (
        E("restrict_aggregate_sessions", "restrictAggregateSessions", bool, is_required=True),
        E("max_sessions", "maxSessions", int),
        E("max_user_originating_sessions", "maxUserOriginatingSessions", int),
        E("max_user_terminating_sessions", "maxUserTerminatingSessions", int),
        E("count_intra_group_sessions", "countIntraGroupSessions", bool, is_required=True),
    )

    #: bool: *Required* restrictAggregateSessions
    restrict_aggregate_sessions = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* maxSessions
    max_sessions = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxUserOriginatingSessions
    max_user_originating_sessions = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxUserTerminatingSessions
    max_user_terminating_sessions = Field(type=int, required=False, mutable=False)
    #: bool: *Required* countIntraGroupSessions
    count_intra_group_sessions = Field(type=bool, required=True, mutable=False)


class GroupSessionAdmissionControlGroupGetListResponse(OCIResponse):
    """
    Response to ``GroupSessionAdmissionControlGroupGetListRequest()``.

    Contains a table of session admission control group configured in the group.  The
    column headings are: "Name", "Is Default", "Maximum Sessions", "Maximum Originating
    Sessions", "Maximum Terminating Sessions".
    """

    _ELEMENTS = (
        E(
            "session_admission_control_group_table", "sessionAdmissionControlGroupTable",
            list, is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* sessionAdmissionControlGroupTable  *Tabular*
    session_admission_control_group_table = Field(type=list, required=True, mutable=False)


class GroupSpeedDial100GetResponse(OCIResponse):
    """
    Response to the ``GroupSpeedDial100GetRequest()``.

    """

    _ELEMENTS = (
        E("prefix", "prefix", str, is_required=True),
    )

    #: str: *Required* prefix
    prefix = Field(type=str, required=True, mutable=False)


class GroupSpeedDial100GetResponse17sp1(OCIResponse):
    """
    Response to the ``GroupSpeedDial100GetRequest17sp1()``.

    """

    _ELEMENTS = (
        E("prefix", "prefix", str),
    )

    #: str: *Optional* prefix
    prefix = Field(type=str, required=False, mutable=False)


class GroupThirdPartyVoiceMailSupportGetResponse(OCIResponse):
    """
    Response to ``GroupThirdPartyVoiceMailSupportGetRequest()``.

    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("group_server", "groupServer", str),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* groupServer
    group_server = Field(type=str, required=False, mutable=False)


class GroupTimeScheduleGetListResponse(OCIResponse):
    """
    Response to the ``GroupTimeScheduleGetListRequest()``.

    The response contains all the group's time schedule name.
    """

    _ELEMENTS = (
        E("time_schedule", "timeSchedule", str, is_array=True),
    )

    #: list(str): *Optional* timeSchedule  *Array*
    time_schedule = Field(type=list, required=False, mutable=False)


class GroupTrunkGroupGetAvailableDetailListResponse(OCIResponse):
    """
    Response to ``GroupTrunkGroupGetAvailableDetailListRequest()``.

    """

    _ELEMENTS = (
        E("trunk_group", "trunkGroup", str, is_complex=True, is_array=True),  # unknown
    )

    #: list(str): *Optional* trunkGroup  *Array*
    trunk_group = Field(type=list, required=False, mutable=False)


class GroupTrunkGroupGetAvailableHostedUserListResponse(OCIResponse):
    """
    Response to the ``GroupTrunkGroupGetAvailableHostedUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupTrunkGroupGetInstanceListResponse14(OCIResponse):
    """
    Response to ``GroupTrunkGroupGetInstanceListRequest14()``.

    Contains a table with column headings "Service User Id", "Name", "Department", "Device
    Name", "Device Level", "Group Id". The "Device Level" column contains one of the
    AccessDeviceLevel enumerated constants.
    """

    _ELEMENTS = (
        E(
            "trunk_group_table", "trunkGroupTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* trunkGroupTable  *Tabular*
    trunk_group_table = Field(type=list, required=True, mutable=False)


class GroupTrunkGroupGetInstanceListResponse14sp4(OCIResponse):
    """
    Response to ``GroupTrunkGroupGetInstanceListRequest14sp4()``.

    Contains a table with column headings "Name", "Department", "Device Name", "Device
    Level", "Group Id". The "Device Level" column contains one of the AccessDeviceLevel
    enumerated constants.
    """

    _ELEMENTS = (
        E(
            "trunk_group_table", "trunkGroupTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* trunkGroupTable  *Tabular*
    trunk_group_table = Field(type=list, required=True, mutable=False)


class GroupTrunkGroupGetInstanceUserListResponse(OCIResponse):
    """
    Response to ``GroupTrunkGroupGetInstanceUserListRequest()``.

    The response contains a 7 column table with column headings "User Id", "Last Name",
    "First Name", "Department", "Phone Number", "Hiragana Last Name", "Hiragana First
    Name".
    """

    _ELEMENTS = (
        E(
            "trunk_group_user_table", "trunkGroupUserTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* trunkGroupUserTable  *Tabular*
    trunk_group_user_table = Field(type=list, required=True, mutable=False)


class GroupTrunkGroupGetInstanceUserListResponse14sp4(OCIResponse):
    """
    Response to ``GroupTrunkGroupGetInstanceUserListRequest14sp4()``.

    The response contains a 9 column table with column headings "User Id", "Last Name",
    "First Name", "Department", "Phone Number", "Hiragana Last Name", "Hiragana First
    Name", "Extension", "Email Address".
    """

    _ELEMENTS = (
        E(
            "trunk_group_user_table", "trunkGroupUserTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* trunkGroupUserTable  *Tabular*
    trunk_group_user_table = Field(type=list, required=True, mutable=False)


class GroupTrunkGroupSecurityClassificationGetResponse(OCIResponse):
    """
    Response to the ``GroupTrunkGroupSecurityClassificationGetRequest()``.

    """

    _ELEMENTS = (
        E("default_security_classification", "defaultSecurityClassification", str),
    )

    #: str: *Optional* defaultSecurityClassification
    default_security_classification = Field(type=str, required=False, mutable=False)


class GroupTrunkGroupUserCreationTaskGetListResponse(OCIResponse):
    """
    Response to ``GroupTrunkGroupUserCreationTaskGetListRequest()``.

    Contains a table with a row for each user creation task and column headings : "Name",
    "Status", "Users Created", "Total Users To Create", "Error Count".
    """

    _ELEMENTS = (
        E("task_table", "taskTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* taskTable  *Tabular*
    task_table = Field(type=list, required=True, mutable=False)


class GroupTrunkGroupUserCreationTaskGetListResponse14sp4(OCIResponse):
    """
    Response to ``GroupTrunkGroupUserCreationTaskGetListRequest14sp4()``.

    Contains a table with a row for each user creation task and column headings : "Name",
    "Status", "Users Created", "Total Users To Create", "Error Count".
    """

    _ELEMENTS = (
        E("task_table", "taskTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* taskTable  *Tabular*
    task_table = Field(type=list, required=True, mutable=False)


class GroupTrunkGroupUserCreationTaskGetResponse(OCIResponse):
    """
    Response to a ``GroupTrunkGroupUserCreationTaskGetRequest()``.

    """

    _ELEMENTS = (
        E("user_id_format", "userIdFormat", str, is_required=True),
        E("user_id_domain", "userIdDomain", str, is_required=True),
        E("populate_extension", "populateExtension", bool, is_required=True),
        E("line_port_format", "linePortFormat", str, is_required=True),
        E("line_port_domain", "linePortDomain", str, is_required=True),
        E("populate_contact", "populateContact", bool, is_required=True),
        E("contact_format", "contactFormat", str),
        E("contact_domain", "contactDomain", str),
        E("users_created", "usersCreated", int, is_required=True),
        E("total_users_to_create", "totalUsersToCreate", int, is_required=True),
        E("error_count", "errorCount", int, is_required=True),
        E("service_pack_name", "servicePackName", str, is_array=True),
        E("user_service_name", "userServiceName", str, is_array=True),
        E("status", "status", str, is_required=True),
        E("user_creation_mode", "userCreationMode", str, is_required=True),
        E("task_summary", "taskSummary", str, is_required=True),
    )

    #: str: *Required* userIdFormat
    user_id_format = Field(type=str, required=True, mutable=False)
    #: str: *Required* userIdDomain
    user_id_domain = Field(type=str, required=True, mutable=False)
    #: bool: *Required* populateExtension
    populate_extension = Field(type=bool, required=True, mutable=False)
    #: str: *Required* linePortFormat
    line_port_format = Field(type=str, required=True, mutable=False)
    #: str: *Required* linePortDomain
    line_port_domain = Field(type=str, required=True, mutable=False)
    #: bool: *Required* populateContact
    populate_contact = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* contactFormat
    contact_format = Field(type=str, required=False, mutable=False)
    #: str: *Optional* contactDomain
    contact_domain = Field(type=str, required=False, mutable=False)
    #: int: *Required* usersCreated
    users_created = Field(type=int, required=True, mutable=False)
    #: int: *Required* totalUsersToCreate
    total_users_to_create = Field(type=int, required=True, mutable=False)
    #: int: *Required* errorCount
    error_count = Field(type=int, required=True, mutable=False)
    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* userServiceName  *Array*
    user_service_name = Field(type=list, required=False, mutable=False)
    #: str: *Required* status
    status = Field(type=str, required=True, mutable=False)
    #: str: *Required* userCreationMode
    user_creation_mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* taskSummary
    task_summary = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupUserCreationTaskGetResponse14sp4(OCIResponse):
    """
    Response to a ``GroupTrunkGroupUserCreationTaskGetRequest14sp4()``.

    """

    _ELEMENTS = (
        E("user_id_format", "userIdFormat", str, is_required=True),
        E("user_id_domain", "userIdDomain", str, is_required=True),
        E("populate_extension", "populateExtension", bool, is_required=True),
        E("line_port_format", "linePortFormat", str, is_required=True),
        E("line_port_domain", "linePortDomain", str, is_required=True),
        E("populate_contact", "populateContact", bool, is_required=True),
        E("contact_format", "contactFormat", str),
        E("contact_domain", "contactDomain", str),
        E("users_created", "usersCreated", int, is_required=True),
        E("total_users_to_create", "totalUsersToCreate", int, is_required=True),
        E("error_count", "errorCount", int, is_required=True),
        E("service_pack_name", "servicePackName", str, is_array=True),
        E("user_service_name", "userServiceName", str, is_array=True),
        E("status", "status", str, is_required=True),
        E("user_creation_mode", "userCreationMode", str, is_required=True),
        E("task_summary", "taskSummary", str, is_required=True),
        E("report_file_key", "reportFileKey", str, is_required=True),
    )

    #: str: *Required* userIdFormat
    user_id_format = Field(type=str, required=True, mutable=False)
    #: str: *Required* userIdDomain
    user_id_domain = Field(type=str, required=True, mutable=False)
    #: bool: *Required* populateExtension
    populate_extension = Field(type=bool, required=True, mutable=False)
    #: str: *Required* linePortFormat
    line_port_format = Field(type=str, required=True, mutable=False)
    #: str: *Required* linePortDomain
    line_port_domain = Field(type=str, required=True, mutable=False)
    #: bool: *Required* populateContact
    populate_contact = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* contactFormat
    contact_format = Field(type=str, required=False, mutable=False)
    #: str: *Optional* contactDomain
    contact_domain = Field(type=str, required=False, mutable=False)
    #: int: *Required* usersCreated
    users_created = Field(type=int, required=True, mutable=False)
    #: int: *Required* totalUsersToCreate
    total_users_to_create = Field(type=int, required=True, mutable=False)
    #: int: *Required* errorCount
    error_count = Field(type=int, required=True, mutable=False)
    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* userServiceName  *Array*
    user_service_name = Field(type=list, required=False, mutable=False)
    #: str: *Required* status
    status = Field(type=str, required=True, mutable=False)
    #: str: *Required* userCreationMode
    user_creation_mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* taskSummary
    task_summary = Field(type=str, required=True, mutable=False)
    #: str: *Required* reportFileKey
    report_file_key = Field(type=str, required=True, mutable=False)


class GroupVirtualOnNetEnterpriseExtensionsGetUserListResponse(OCIResponse):
    """
    Response to ``GroupVirtualOnNetEnterpriseExtensionsGetUserListRequest()``.

    Contains a table with column headings: "Last Name", "First Name", "Phone Number",
    "Extension", "Virtual On-Net Call Type Name" in a row for each user.
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class GroupVirtualOnNetEnterpriseExtensionsGetUserResponse(OCIResponse):
    """
    Response to ``GroupVirtualOnNetEnterpriseExtensionsGetUserRequest()``.

    """

    _ELEMENTS = (
        E("extension", "extension", str, is_required=True),
        E("first_name", "firstName", str, is_required=True),
        E("last_name", "lastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("virtual_on_net_call_type_name", "virtualOnNetCallTypeName", str, is_required=True),
    )

    #: str: *Required* extension
    extension = Field(type=str, required=True, mutable=False)
    #: str: *Required* firstName
    first_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* lastName
    last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* virtualOnNetCallTypeName
    virtual_on_net_call_type_name = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetPasscodeRulesResponse(OCIResponse):
    """
    Response to ``GroupVoiceMessagingGroupGetPasscodeRulesRequest()``.

    Contains the group's voice portal passcode rules setting.

    Replaced By: ``GroupPortalPasscodeRulesGetResponse()``
    """

    _ELEMENTS = (
        E("use_rule_level", "useRuleLevel", str, is_required=True),
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool, is_required=True),
        E("disallow_user_number", "disallowUserNumber", bool, is_required=True),
        E(
            "disallow_reversed_user_number", "disallowReversedUserNumber", bool,
            is_required=True,
        ),
        E("disallow_old_passcode", "disallowOldPasscode", bool, is_required=True),
        E(
            "disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool,
            is_required=True,
        ),
        E("min_code_length", "minCodeLength", int, is_required=True),
        E("max_code_length", "maxCodeLength", int, is_required=True),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool, is_required=True,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool, is_required=True),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    #: str: *Required* useRuleLevel
    use_rule_level = Field(type=str, required=True, mutable=False)
    #: bool: *Required* disallowRepeatedDigits
    disallow_repeated_digits = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowUserNumber
    disallow_user_number = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowReversedUserNumber
    disallow_reversed_user_number = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowOldPasscode
    disallow_old_passcode = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minCodeLength
    min_code_length = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxCodeLength
    max_code_length = Field(type=int, required=True, mutable=False)
    #: bool: *Required* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=False, mutable=False)
    #: bool: *Required* expirePassword
    expire_password = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(type=int, required=False, mutable=False)
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)


class GroupVoiceMessagingGroupGetResponse(OCIResponse):
    """
    Response to ``GroupVoiceMessagingGroupGetRequest()``.

    Contains the group's voice messaging settings.
    """

    _ELEMENTS = (
        E("use_mail_server_setting", "useMailServerSetting", str, is_required=True),
        E(
            "warn_caller_before_recording_voice_message",
            "warnCallerBeforeRecordingVoiceMessage", bool, is_required=True,
        ),
        E(
            "allow_users_configuring_advanced_settings",
            "allowUsersConfiguringAdvancedSettings", bool, is_required=True,
        ),
        E(
            "allow_compose_or_forward_message_to_entire_group",
            "allowComposeOrForwardMessageToEntireGroup", bool, is_required=True,
        ),
        E("mail_server_net_address", "mailServerNetAddress", str),
        E("mail_server_protocol", "mailServerProtocol", str, is_required=True),
        E("real_delete_for_imap", "realDeleteForImap", bool, is_required=True),
        E("max_mailbox_length_minutes", "maxMailboxLengthMinutes", int, is_required=True),
        E("does_message_age", "doesMessageAge", bool, is_required=True),
        E("hold_period_days", "holdPeriodDays", int, is_required=True),
    )

    #: str: *Required* useMailServerSetting
    use_mail_server_setting = Field(type=str, required=True, mutable=False)
    #: bool: *Required* warnCallerBeforeRecordingVoiceMessage
    warn_caller_before_recording_voice_message = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowUsersConfiguringAdvancedSettings
    allow_users_configuring_advanced_settings = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowComposeOrForwardMessageToEntireGroup
    allow_compose_or_forward_message_to_entire_group = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Optional* mailServerNetAddress
    mail_server_net_address = Field(type=str, required=False, mutable=False)
    #: str: *Required* mailServerProtocol
    mail_server_protocol = Field(type=str, required=True, mutable=False)
    #: bool: *Required* realDeleteForImap
    real_delete_for_imap = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxMailboxLengthMinutes
    max_mailbox_length_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* doesMessageAge
    does_message_age = Field(type=bool, required=True, mutable=False)
    #: int: *Required* holdPeriodDays
    hold_period_days = Field(type=int, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalBrandingResponse(OCIResponse):
    """
    Response to the ``GroupVoiceMessagingGroupGetVoicePortalBrandingRequest()``.

    Replaced By: ``GroupVoiceMessagingGroupGetVoicePortalBrandingResponse16()``
    """

    _ELEMENTS = (
        E(
            "voice_portal_greeting_selection", "voicePortalGreetingSelection", str,
            is_required=True,
        ),
        E(
            "voice_portal_greeting_file_description",
            "voicePortalGreetingFileDescription", str,
        ),
        E(
            "voice_messaging_greeting_selection", "voiceMessagingGreetingSelection", str,
            is_required=True,
        ),
        E(
            "voice_messaging_greeting_file_description",
            "voiceMessagingGreetingFileDescription", str,
        ),
    )

    #: str: *Required* voicePortalGreetingSelection
    voice_portal_greeting_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* voicePortalGreetingFileDescription
    voice_portal_greeting_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Required* voiceMessagingGreetingSelection
    voice_messaging_greeting_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* voiceMessagingGreetingFileDescription
    voice_messaging_greeting_file_description = Field(type=str, required=False, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalBrandingResponse16(OCIResponse):
    """
    Response to the ``GroupVoiceMessagingGroupGetVoicePortalBrandingRequest16()``.

    """

    _ELEMENTS = (
        E(
            "voice_portal_greeting_selection", "voicePortalGreetingSelection", str,
            is_required=True,
        ),
        E(
            "voice_portal_greeting_file_description",
            "voicePortalGreetingFileDescription", str,
        ),
        E("voice_portal_greeting_media_type", "voicePortalGreetingMediaType", str),
        E(
            "voice_messaging_greeting_selection", "voiceMessagingGreetingSelection", str,
            is_required=True,
        ),
        E(
            "voice_messaging_greeting_file_description",
            "voiceMessagingGreetingFileDescription", str,
        ),
        E("voice_messaging_greeting_media_type", "voiceMessagingGreetingMediaType", str),
    )

    #: str: *Required* voicePortalGreetingSelection
    voice_portal_greeting_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* voicePortalGreetingFileDescription
    voice_portal_greeting_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* voicePortalGreetingMediaType
    voice_portal_greeting_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Required* voiceMessagingGreetingSelection
    voice_messaging_greeting_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* voiceMessagingGreetingFileDescription
    voice_messaging_greeting_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* voiceMessagingGreetingMediaType
    voice_messaging_greeting_media_type = Field(type=str, required=False, mutable=False)


class GroupVoiceXmlGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupVoiceXmlGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active". The column values for "Is Active" can either
    be true, or false.
    """

    _ELEMENTS = (
        E(
            "voice_xml_table", "voiceXmlTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* voiceXmlTable  *Tabular*
    voice_xml_table = Field(type=list, required=True, mutable=False)


class LoginResponse13mp10(OCIResponse):
    """
    ``LoginRequest13mp10()``/Response13mp10 is 2nd stage of the 2 stage OCI login process.

    """

    _ELEMENTS = (
        E("login_type", "loginType", str, is_required=True),
        E("locale", "locale", str, is_required=True),
        E("encoding", "encoding", str, is_required=True),
    )

    #: str: *Required* loginType
    login_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* locale
    locale = Field(type=str, required=True, mutable=False)
    #: str: *Required* encoding
    encoding = Field(type=str, required=True, mutable=False)


class LoginResponse14sp4(OCIResponse):
    """
    ``LoginRequest14sp4()``/Response14sp4 is 2nd stage of the 2 stage OCI login process.

    """

    _ELEMENTS = (
        E("login_type", "loginType", str, is_required=True),
        E("locale", "locale", str, is_required=True),
        E("encoding", "encoding", str, is_required=True),
        E("group_id", "groupId", str),
        E("service_provider_id", "serviceProviderId", str),
        E("is_enterprise", "isEnterprise", bool, is_required=True),
        E("password_expires_days", "passwordExpiresDays", int),
        E("user_domain", "userDomain", str, is_required=True),
    )

    #: str: *Required* loginType
    login_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* locale
    locale = Field(type=str, required=True, mutable=False)
    #: str: *Required* encoding
    encoding = Field(type=str, required=True, mutable=False)
    #: str: *Optional* groupId
    group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceProviderId
    service_provider_id = Field(type=str, required=False, mutable=False)
    #: bool: *Required* isEnterprise
    is_enterprise = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* passwordExpiresDays
    password_expires_days = Field(type=int, required=False, mutable=False)
    #: str: *Required* userDomain
    user_domain = Field(type=str, required=True, mutable=False)


class PrimaryInfoGetResponse(OCIResponse):
    """
    Information about the primary server in the high-availablity cluster.

    For optimization, we only get the hostname and addresses for primary if they are
    explicitly requested or if the current server is not the primary.
    """

    _ELEMENTS = (
        E("is_primary", "isPrimary", bool, is_required=True),
        E("hostname_for_primary", "hostnameForPrimary", str),
        E("address_for_primary", "addressForPrimary", str, is_array=True),
        E("private_address_for_primary", "privateAddressForPrimary", str, is_array=True),
    )

    #: bool: *Required* isPrimary
    is_primary = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* hostnameForPrimary
    hostname_for_primary = Field(type=str, required=False, mutable=False)
    #: list(str): *Optional* addressForPrimary  *Array*
    address_for_primary = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* privateAddressForPrimary  *Array*
    private_address_for_primary = Field(type=list, required=False, mutable=False)


class PublicClusterGetFullyQualifiedDomainNameResponse(OCIResponse):
    """
    Response to ``PublicClusterGetFullyQualifiedDomainNameRequest()``.

    """

    _ELEMENTS = (
        E("public_cluster_fqdn", "publicClusterFQDN", str),
    )

    #: str: *Optional* publicClusterFQDN
    public_cluster_fqdn = Field(type=str, required=False, mutable=False)


class ServiceProviderAccessDeviceCustomTagGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceCustomTagGetListRequest()``.

    Contains a table of custom configuration tags managed by the Device Management System
    on a per-device profile basis.  The column headings are: "Tag Name", "Tag Value"
    """

    _ELEMENTS = (
        E(
            "device_custom_tags_table", "deviceCustomTagsTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* deviceCustomTagsTable  *Tabular*
    device_custom_tags_table = Field(type=list, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetListRequest()``.

    Contains a table of device files managed by the Device Management System on a per-
    device profile basis.  The column headings are: "File Type", "File Format", "Is
    Authenticated".

    Replaced By: ``ServiceProviderAccessDeviceFileGetListResponse14sp8()``
    """

    _ELEMENTS = (
        E(
            "device_files_table", "deviceFilesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* deviceFilesTable  *Tabular*
    device_files_table = Field(type=list, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetListResponse14sp8(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetListRequest14sp8()``.

    Contains a table of device files managed by the Device Management System on a per-
    device profile basis.  The column headings are: "File Format", "Is Authenticated",
    "Access URL", "Repository URL", "Template URL", "Extended Capture". The following
    columns are only used in AS data mode: "Extended Capture"
    """

    _ELEMENTS = (
        E(
            "device_files_table", "deviceFilesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* deviceFilesTable  *Tabular*
    device_files_table = Field(type=list, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetRequest()``.

    Replaced By: ``ServiceProviderAccessDeviceFileGetResponse14sp8()``
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
    )

    #: str: *Required* fileSource
    file_source = Field(type=str, required=True, mutable=False)
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(type=str, required=False, mutable=False)


class ServiceProviderAccessDeviceFileGetResponse14sp8(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetRequest14sp8()``.

    Replaced by: ``ServiceProviderAccessDeviceFileGetResponse16sp1()``
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
    )

    #: str: *Required* fileSource
    file_source = Field(type=str, required=True, mutable=False)
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(type=str, required=False, mutable=False)


class ServiceProviderAccessDeviceFileGetResponse16sp1(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetRequest16sp1()``.

    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
        E("access_url", "accessUrl", str, is_required=True),
        E("repository_url", "repositoryUrl", str),
        E("template_url", "templateUrl", str),
    )

    #: str: *Required* fileSource
    file_source = Field(type=str, required=True, mutable=False)
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* accessUrl
    access_url = Field(type=str, required=True, mutable=False)
    #: str: *Optional* repositoryUrl
    repository_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* templateUrl
    template_url = Field(type=str, required=False, mutable=False)


class ServiceProviderAccessDeviceFileGetResponse20(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetRequest20()``.

    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
        E("access_url", "accessUrl", str, is_required=True),
        E("repository_url", "repositoryUrl", str),
        E("template_url", "templateUrl", str),
        E("extended_capture_enabled", "extendedCaptureEnabled", bool),
        E("extended_capture_url", "extendedCaptureURL", str),
    )

    #: str: *Required* fileSource
    file_source = Field(type=str, required=True, mutable=False)
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* accessUrl
    access_url = Field(type=str, required=True, mutable=False)
    #: str: *Optional* repositoryUrl
    repository_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* templateUrl
    template_url = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* extendedCaptureEnabled
    extended_capture_enabled = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* extendedCaptureURL
    extended_capture_url = Field(type=str, required=False, mutable=False)


class ServiceProviderAccessDeviceGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceGetListRequest()``.

    Contains a table of devices configured in the service provider.  The column headings
    are: "Device Name", "Device Type", "Available Ports", "Net Address", "MAC Address",
    "Status", and "Version".
    """

    _ELEMENTS = (
        E(
            "access_device_table", "accessDeviceTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* accessDeviceTable  *Tabular*
    access_device_table = Field(type=list, required=True, mutable=False)


class ServiceProviderAccessDeviceGetUserListResponse(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceGetUserListRequest()``.

    The column headings for the deviceUserTable are: "Line/Port", "Last Name", "First
    Name", "Phone Number", "Group Id", "User Id", "User Type", "Endpoint Type", "Primary
    Line/Port", "Order", "Extension", "Department", "Email Address", "Private Identity".
    In IMS mode, the table will contain a row for each TEL-URI in the Phone Number column.
    In standalone mode, rows for the alternate numbers are not included.  The User Type
    column contains one of the enumerated UserType values.  The Endpoint Type column
    contains one of the enumerated EndpointType values.  The Private Identity column is
    empty is AS mode.
    """

    _ELEMENTS = (
        E(
            "device_user_table", "deviceUserTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* deviceUserTable  *Tabular*
    device_user_table = Field(type=list, required=True, mutable=False)


class ServiceProviderAdminGetListResponse14(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetListRequest14()``.

    Contains a 5 column table with column headings "Administrator ID", "Last Name", "First
    Name", "Administrator Type", "Language".
    """

    _ELEMENTS = (
        E(
            "service_provider_admin_table", "serviceProviderAdminTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* serviceProviderAdminTable  *Tabular*
    service_provider_admin_table = Field(type=list, required=True, mutable=False)


class ServiceProviderAdminGetPolicyResponse14(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest14()``.

    Contains the policy settings for the service provider administrator.  The
    networkPolicyAccess is returned only for the enterprise administrator.
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("group_access", "groupAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("service_pack_access", "servicePackAccess", str, is_required=True),
        E("web_branding_access", "webBrandingAccess", str, is_required=True),
        E("network_policy_access", "networkPolicyAccess", str),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupAccess
    group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* servicePackAccess
    service_pack_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* webBrandingAccess
    web_branding_access = Field(type=str, required=True, mutable=False)
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(type=str, required=False, mutable=False)


class ServiceProviderAdminGetPolicyResponse16sp1(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest16sp1()``.

    Contains the policy settings for the service provider administrator.  The
    networkPolicyAccess is returned only for the enterprise administrator.  Replaced by:
    ``ServiceProviderAdminGetPolicyResponse17()``
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("group_access", "groupAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("service_pack_access", "servicePackAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("web_branding_access", "webBrandingAccess", str, is_required=True),
        E("network_policy_access", "networkPolicyAccess", str),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupAccess
    group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* servicePackAccess
    service_pack_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* webBrandingAccess
    web_branding_access = Field(type=str, required=True, mutable=False)
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(type=str, required=False, mutable=False)


class ServiceProviderAdminGetPolicyResponse16sp2(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest16sp1()``.

    Response to ``ServiceProviderAdminGetPolicyRequest16sp2()``. Contains the policy
    settings for the service provider administrator.  The networkPolicyAccess is returned
    only for the enterprise administrator.
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("group_access", "groupAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("service_pack_access", "servicePackAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("web_branding_access", "webBrandingAccess", str, is_required=True),
        E("network_policy_access", "networkPolicyAccess", str),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupAccess
    group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* servicePackAccess
    service_pack_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* webBrandingAccess
    web_branding_access = Field(type=str, required=True, mutable=False)
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(type=str, required=False, mutable=False)
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyResponse17(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest17()``.

    Contains the policy settings for the service provider administrator.  The
    networkPolicyAccess is returned only for the enterprise administrator.
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("group_access", "groupAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("service_pack_access", "servicePackAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("web_branding_access", "webBrandingAccess", str, is_required=True),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E("network_policy_access", "networkPolicyAccess", str),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupAccess
    group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* servicePackAccess
    service_pack_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* webBrandingAccess
    web_branding_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(type=str, required=True, mutable=False)
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(type=str, required=False, mutable=False)


class ServiceProviderAdminGetPolicyResponse17sp1(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest17sp1()``.

    Contains the policy settings for the service provider administrator.  The
    networkPolicyAccess is returned only for the enterprise administrator.  The following
    elements are only used in HSS data mode: communicationBarringAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("group_access", "groupAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("service_pack_access", "servicePackAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("web_branding_access", "webBrandingAccess", str, is_required=True),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E(
            "communication_barring_access", "communicationBarringAccess", str,
            is_required=True,
        ),
        E("network_policy_access", "networkPolicyAccess", str),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupAccess
    group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* servicePackAccess
    service_pack_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* webBrandingAccess
    web_branding_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* communicationBarringAccess
    communication_barring_access = Field(type=str, required=True, mutable=False)
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(type=str, required=False, mutable=False)


class ServiceProviderAdminGetPolicyResponse17sp3(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest17sp3()``.

    Contains the policy settings for the service provider administrator.  The
    networkPolicyAccess is returned only for the enterprise administrator.  The following
    elements are only used in AS data mode: dialableCallerIDAccess The following elements
    are only used in HSS data mode: communicationBarringAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("group_access", "groupAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("service_pack_access", "servicePackAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("web_branding_access", "webBrandingAccess", str, is_required=True),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E(
            "communication_barring_access", "communicationBarringAccess", str,
            is_required=True,
        ),
        E("network_policy_access", "networkPolicyAccess", str),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupAccess
    group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* servicePackAccess
    service_pack_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* webBrandingAccess
    web_branding_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* communicationBarringAccess
    communication_barring_access = Field(type=str, required=True, mutable=False)
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(type=str, required=False, mutable=False)
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyResponse18(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest18()``.

    Contains the policy settings for the service provider administrator.  The
    networkPolicyAccess and numberActivationAccess are returned only for the enterprise
    administrator.  The following elements are only used in AS data mode:
    dialableCallerIDAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("group_access", "groupAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("service_pack_access", "servicePackAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("web_branding_access", "webBrandingAccess", str, is_required=True),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E(
            "communication_barring_access", "communicationBarringAccess", str,
            is_required=True,
        ),
        E("network_policy_access", "networkPolicyAccess", str),
        E("number_activation_access", "numberActivationAccess", str),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupAccess
    group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* servicePackAccess
    service_pack_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* webBrandingAccess
    web_branding_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* communicationBarringAccess
    communication_barring_access = Field(type=str, required=True, mutable=False)
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* numberActivationAccess
    number_activation_access = Field(type=str, required=False, mutable=False)
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyResponse20(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest20()``.

    Contains the policy settings for the service provider administrator.  The
    networkPolicyAccess and numberActivationAccess are returned only for the enterprise
    administrator.  The following elements are only used in AS data mode:
    dialableCallerIDAccess verifyTranslationAndRoutingAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("group_access", "groupAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("service_pack_access", "servicePackAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("web_branding_access", "webBrandingAccess", str, is_required=True),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E(
            "communication_barring_access", "communicationBarringAccess", str,
            is_required=True,
        ),
        E("network_policy_access", "networkPolicyAccess", str),
        E("number_activation_access", "numberActivationAccess", str),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
        E(
            "verify_translation_and_routing_access", "verifyTranslationAndRoutingAccess",
            str, is_required=True,
        ),
    )

    #: str: *Required* profileAccess
    profile_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupAccess
    group_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* userAccess
    user_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminAccess
    admin_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* departmentAccess
    department_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceAccess
    service_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* servicePackAccess
    service_pack_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* webBrandingAccess
    web_branding_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* communicationBarringAccess
    communication_barring_access = Field(type=str, required=True, mutable=False)
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(type=str, required=False, mutable=False)
    #: str: *Optional* numberActivationAccess
    number_activation_access = Field(type=str, required=False, mutable=False)
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(type=str, required=True, mutable=False)
    #: str: *Required* verifyTranslationAndRoutingAccess
    verify_translation_and_routing_access = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetResponse14(OCIResponse):
    """
    Response to the ``ServiceProviderAdminGetRequest14()``.

    The response contains the service provider administrators profile information.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("language", "language", str, is_required=True),
        E("administrator_type", "administratorType", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* firstName
    first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* lastName
    last_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* language
    language = Field(type=str, required=True, mutable=False)
    #: str: *Required* administratorType
    administrator_type = Field(type=str, required=True, mutable=False)


class ServiceProviderAdviceOfChargeGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderAdviceOfChargeGetRequest()``.

    Contains a list of Advice of Charge service provider parameters.
    """

    _ELEMENTS = (
        E("use_sp_level_ao_c_settings", "useSPLevelAoCSettings", bool, is_required=True),
        E(
            "delay_between_notification_seconds", "delayBetweenNotificationSeconds", int,
            is_required=True,
        ),
    )

    #: bool: *Required* useSPLevelAoCSettings
    use_sp_level_ao_c_settings = Field(type=bool, required=True, mutable=False)
    #: int: *Required* delayBetweenNotificationSeconds
    delay_between_notification_seconds = Field(type=int, required=True, mutable=False)


class ServiceProviderAnswerConfirmationGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderAnswerConfirmationGetRequest()``.

    Replaced By: ``ServiceProviderAnswerConfirmationGetResponse16()``
    """

    _ELEMENTS = (
        E(
            "announcement_message_selection", "announcementMessageSelection", str,
            is_required=True,
        ),
        E(
            "confirmation_message_audio_file_description",
            "confirmationMessageAudioFileDescription", str,
        ),
        E("confirmation_timout_seconds", "confirmationTimoutSeconds", int, is_required=True),
    )

    #: str: *Required* announcementMessageSelection
    announcement_message_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* confirmationMessageAudioFileDescription
    confirmation_message_audio_file_description = Field(
        type=str, required=False, mutable=False,
    )
    #: int: *Required* confirmationTimoutSeconds
    confirmation_timout_seconds = Field(type=int, required=True, mutable=False)


class ServiceProviderAnswerConfirmationGetResponse16(OCIResponse):
    """
    Response to the ``ServiceProviderAnswerConfirmationGetRequest16()``.

    """

    _ELEMENTS = (
        E(
            "announcement_message_selection", "announcementMessageSelection", str,
            is_required=True,
        ),
        E(
            "confirmation_message_audio_file_description",
            "confirmationMessageAudioFileDescription", str,
        ),
        E("confirmation_message_media_type", "confirmationMessageMediaType", str),
        E("confirmation_timout_seconds", "confirmationTimoutSeconds", int, is_required=True),
    )

    #: str: *Required* announcementMessageSelection
    announcement_message_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* confirmationMessageAudioFileDescription
    confirmation_message_audio_file_description = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* confirmationMessageMediaType
    confirmation_message_media_type = Field(type=str, required=False, mutable=False)
    #: int: *Required* confirmationTimoutSeconds
    confirmation_timout_seconds = Field(type=int, required=True, mutable=False)


class ServiceProviderApplicationServerSetGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderApplicationServerSetGetRequest()``.

    The response contains the service provider or enterprise's Application Server set
    information.
    """

    _ELEMENTS = (
        E("application_server_set_name", "applicationServerSetName", str),
    )

    #: str: *Optional* applicationServerSetName
    application_server_set_name = Field(type=str, required=False, mutable=False)


class ServiceProviderBroadWorksCommunicatorGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderBroadWorksCommunicatorGetRequest()``.

    """

    _ELEMENTS = (
        E("configuration_server_url", "configurationServerURL", str),
    )

    #: str: *Optional* configurationServerURL
    configuration_server_url = Field(type=str, required=False, mutable=False)


class ServiceProviderBroadWorksMobilityGetResponse(OCIResponse):
    """
    The response to a ``ServiceProviderBroadWorksMobilityGetRequest()``.

    """

    _ELEMENTS = (
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("enable_location_services", "enableLocationServices", bool, is_required=True),
        E("enable_msrn_lookup", "enableMSRNLookup", bool, is_required=True),
        E(
            "enable_mobile_state_checking", "enableMobileStateChecking", bool,
            is_required=True,
        ),
        E("deny_call_originations", "denyCallOriginations", bool, is_required=True),
        E("deny_call_terminations", "denyCallTerminations", bool, is_required=True),
    )

    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enableLocationServices
    enable_location_services = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableMSRNLookup
    enable_msrn_lookup = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableMobileStateChecking
    enable_mobile_state_checking = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* denyCallOriginations
    deny_call_originations = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* denyCallTerminations
    deny_call_terminations = Field(type=bool, required=True, mutable=False)


class ServiceProviderBroadWorksMobilityGetResponse19sp1(OCIResponse):
    """
    The response to a ``ServiceProviderBroadWorksMobilityGetRequest19sp1()``.

    """

    _ELEMENTS = (
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("enable_location_services", "enableLocationServices", bool, is_required=True),
        E("enable_msrn_lookup", "enableMSRNLookup", bool, is_required=True),
        E(
            "enable_mobile_state_checking", "enableMobileStateChecking", bool,
            is_required=True,
        ),
        E("deny_call_originations", "denyCallOriginations", bool, is_required=True),
        E("deny_call_terminations", "denyCallTerminations", bool, is_required=True),
        E(
            "enable_announcement_suppression", "enableAnnouncementSuppression", bool,
            is_required=True,
        ),
    )

    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enableLocationServices
    enable_location_services = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableMSRNLookup
    enable_msrn_lookup = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableMobileStateChecking
    enable_mobile_state_checking = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* denyCallOriginations
    deny_call_originations = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* denyCallTerminations
    deny_call_terminations = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableAnnouncementSuppression
    enable_announcement_suppression = Field(type=bool, required=True, mutable=False)


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse(OCIResponse):
    """
    Response to
    ``ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest()``.

    Contains a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any group.
    """

    _ELEMENTS = (
        E(
            "available_mobile_subscriber_directory_number",
            "availableMobileSubscriberDirectoryNumber", str, is_array=True,
        ),
    )

    #: list(str): *Optional* availableMobileSubscriberDirectoryNumber  *Array*
    available_mobile_subscriber_directory_number = Field(
        type=list, required=False, mutable=False,
    )


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetSummaryListResponse(OCIResponse):
    """
    Response to
    ``ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetSummaryListRequest()``.

    The column headings are "Phone Number", "Group Id" and "Mobile Network".
    """

    _ELEMENTS = (
        E(
            "mobile_subscriber_directory_numbers_summary_table",
            "mobileSubscriberDirectoryNumbersSummaryTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* mobileSubscriberDirectoryNumbersSummaryTable  *Tabular*
    mobile_subscriber_directory_numbers_summary_table = Field(
        type=list, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse14(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest14()``.

    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)


class ServiceProviderCallProcessingGetPolicyResponse14sp1(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest14sp1()``.

    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse14sp4(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest14sp4()``.

    Replaced By : ``ServiceProviderCallProcessingGetPolicyResponse15()``
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
            is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse14sp7(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest14sp7()``.

    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
            is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse15(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest15()``.

    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse15sp2(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest15sp2()``.

    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse16(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest16()``.

    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse16sp2(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest16sp2()``.

    """

    _ELEMENTS = (
        E(
            "use_service_provider_dclid_setting", "useServiceProviderDCLIDSetting", bool,
            is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
    )

    #: bool: *Required* useServiceProviderDCLIDSetting
    use_service_provider_dclid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyResponse17(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest17()``.

    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyResponse17sp3(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest17sp3()``.

    The following elements are only used in AS data mode: useServiceProviderDCLIDSetting
    enableDialableCallerID
    """

    _ELEMENTS = (
        E(
            "use_service_provider_dclid_setting", "useServiceProviderDCLIDSetting", bool,
            is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
    )

    #: bool: *Required* useServiceProviderDCLIDSetting
    use_service_provider_dclid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyResponse17sp4(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest17sp4()``.

    The following elements are only used in AS data mode: useServiceProviderDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    """

    _ELEMENTS = (
        E(
            "use_service_provider_dclid_setting", "useServiceProviderDCLIDSetting", bool,
            is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
    )

    #: bool: *Required* useServiceProviderDCLIDSetting
    use_service_provider_dclid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse18sp1(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest18sp1()``.

    The following elements are only used in AS data mode: useServiceProviderDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    enterpriseCallsCLIDPolicy groupCallsCLIDPolicy Replaced by:
    ``ServiceProviderCallProcessingGetPolicyResponse19sp1()``
    """

    _ELEMENTS = (
        E(
            "use_service_provider_dclid_setting", "useServiceProviderDCLIDSetting", bool,
            is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str, is_required=True),
        E("group_calls_clid_policy", "groupCallsCLIDPolicy", str, is_required=True),
    )

    #: bool: *Required* useServiceProviderDCLIDSetting
    use_service_provider_dclid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupCallsCLIDPolicy
    group_calls_clid_policy = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyResponse19sp1(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest19sp1()``.

    The following elements are only used in AS data mode: useServiceProviderDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    enterpriseCallsCLIDPolicy groupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E(
            "use_service_provider_dclid_setting", "useServiceProviderDCLIDSetting", bool,
            is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str, is_required=True),
        E("group_calls_clid_policy", "groupCallsCLIDPolicy", str, is_required=True),
    )

    #: bool: *Required* useServiceProviderDCLIDSetting
    use_service_provider_dclid_setting = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(type=str, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupCallsCLIDPolicy
    group_calls_clid_policy = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringCriteriaGetAssignedListResponse(OCIResponse):
    """
    Response to ``ServiceProviderCommunicationBarringCriteriaGetAssignedListRequest()``.

    Contains a table of all Communication Barring Criteria assigned to the service
    provider.  The column headings are: "Name" and "Description".
    """

    _ELEMENTS = (
        E(
            "criteria_table", "criteriaTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* criteriaTable  *Tabular*
    criteria_table = Field(type=list, required=True, mutable=False)


class ServiceProviderCommunicationBarringDigitPatternCriteriaGetListResponse(OCIResponse):
    """
    Response to the
    ``ServiceProviderCommunicationBarringDigitPatternCriteriaGetListRequest()``.

    The response contains a table of all Digit Pattern Criteria defined for the service
    provider.  The column headings are "Name" and "Description"
    """

    _ELEMENTS = (
        E(
            "criteria_table", "criteriaTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* criteriaTable  *Tabular*
    criteria_table = Field(type=list, required=True, mutable=False)


class ServiceProviderCommunicationBarringDigitPatternCriteriaGetPatternListResponse(OCIResponse):
    """
    Response to the
    ``ServiceProviderCommunicationBarringDigitPatternCriteriaGetPatternListRequest()``.

    The response contains the Digit Pattern Criteria information.
    """

    _ELEMENTS = (
        E("match_digit_pattern", "matchDigitPattern", str, is_array=True),
    )

    #: list(str): *Optional* matchDigitPattern  *Array*
    match_digit_pattern = Field(type=list, required=False, mutable=False)


class ServiceProviderCommunicationBarringDigitPatternCriteriaGetResponse(OCIResponse):
    """
    Response to the
    ``ServiceProviderCommunicationBarringDigitPatternCriteriaGetRequest()``.

    The response contains the Digit Pattern Criteria information.
    """

    _ELEMENTS = (
        E("description", "description", str),
    )

    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class ServiceProviderCommunicationBarringIncomingCriteriaGetAssignedListResponse(OCIResponse):
    """
    Response to
    ``ServiceProviderCommunicationBarringIncomingCriteriaGetAssignedListRequest()``.

    Contains a table of all Communication Barring Incoming Criteria assigned to the
    service provider.  The column headings are: "Name" and "Description".
    """

    _ELEMENTS = (
        E(
            "criteria_table", "criteriaTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* criteriaTable  *Tabular*
    criteria_table = Field(type=list, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetAssignedGroupListResponse(OCIResponse):
    """
    Response to
    ``ServiceProviderCommunicationBarringProfileGetAssignedGroupListRequest()``.

    Contains a table of groups that have the Communication Barring Profile assigned.  The
    column headings are: "Group Id" and "Group Name".
    """

    _ELEMENTS = (
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* groupTable  *Tabular*
    group_table = Field(type=list, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetCriteriaUsageListResponse(OCIResponse):
    """
    Response to ServiceProviderCommunicationBarring
    ``ProfileGetCriteriaUsageListRequest()``.

    Contains a table of profiles that have the Communication Barring Criteria assigned.
    The column headings are: "Name" and "Description".
    """

    _ELEMENTS = (
        E(
            "profile_table", "profileTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* profileTable  *Tabular*
    profile_table = Field(type=list, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetDigitPatternCriteriaUsageListResponse(OCIResponse):
    """
    Response to the
    ``ServiceProviderCommunicationBarringProfileGetDigitPatternCriteriaUsageListRequest()``.

    The response contains a table of all Profiles that use the specific Digit Pattern
    Criteria.  The column headings are "Name" and "Description"
    """

    _ELEMENTS = (
        E(
            "profile_table", "profileTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* profileTable  *Tabular*
    profile_table = Field(type=list, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetIncomingCriteriaUsageListResponse(OCIResponse):
    """
    Response to
    ``ServiceProviderCommunicationBarringProfileGetIncomingCriteriaUsageListRequest()``.

    Contains a table of profiles that have the Communication Barring Incoming Criteria
    assigned.  The column headings are: "Name" and "Description".
    """

    _ELEMENTS = (
        E(
            "profile_table", "profileTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* profileTable  *Tabular*
    profile_table = Field(type=list, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetListResponse(OCIResponse):
    """
    Response to the ``ServiceProviderCommunicationBarringProfileGetListRequest()``.

    The response contains a table of all Communication Barring Profiles for the service
    provider.  The column headings are "Default" , "Name" and "Description"
    """

    _ELEMENTS = (
        E(
            "profile_table", "profileTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* profileTable  *Tabular*
    profile_table = Field(type=list, required=True, mutable=False)


class ServiceProviderDeviceManagementEventGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderDeviceManagementEventGetListRequest()``.

    Contains a table with column headings: "Event Id", "Status", "Action", "Level",
    "Type", "Additional Info", "Is Local", "Completion %", "Pushed/ Same Hash/ Not
    Pushed", "Login Id", "Start Time", "Process Time". "Event Id" is a unique identifer
    for the event.  "Status" can be: Pending, Queued, In Progress, Process On Other Host,
    Stale, Completed, Canceled.  "Action" can be: Delete, Download, Rebuild, Reset,
    Upload.  "Level" can be: Device, Device Type, Device Type Group, Group, User.  "Type"
    can be: Automatic, Manual.  "Additional Info" includes the affected device type,
    device or group.  It depends on the level of the event: Device Profile: "Device Name"
    "Service Provider Id" "Group Id" Device Type: "Device Type Name" Device Type Group:
    "Service Provider Id" "Group Id" "Device Type Name" Group: "Service Provider Id"
    "Group Id" User: "User Id" "Is Local" is set to "yes" if the event is processed on the
    server who received the request, "no" otherwise meaning that the event is processed on
    another server.  "Completion %" provides an estimate of the completion of the event.
    A percentage is given, the current number of completed expanded event, and the total
    number of expanded event.  "Pushed/ Same Hash/ Not Pushed" gives the total number of
    files that were pushed, not pushed because of same hash, and not pushed when
    processing the event.  "LoginId" is the user or admin id who triggered the event.
    "Start Time" is the date when the event was started.  The display shows the month,
    days, hours, and minutes (MM-dd hh:mm). "Process Time" is the time taken to process
    the event in hours, minutes, seconds, and milliseconds (hhhh:mm:ss.SSS). Each row
    represents an event sorted by priority of processing.  The first row in the table is
    an event that has an associated expanded event currently being processed or next in
    line to be processed.
    """

    _ELEMENTS = (
        E(
            "event_table", "eventTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* eventTable  *Tabular*
    event_table = Field(type=list, required=True, mutable=False)


class ServiceProviderDeviceProfileAuthenticationPasswordRulesGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderDeviceProfileAuthenticationPasswordRulesGetRequest()``.

    Contains the device profile authentication password rules for the service provider.
    """

    _ELEMENTS = (
        E(
            "use_service_provider_settings", "useServiceProviderSettings", bool,
            is_required=True,
        ),
        E(
            "disallow_authentication_name", "disallowAuthenticationName", bool,
            is_required=True,
        ),
        E("disallow_old_password", "disallowOldPassword", bool, is_required=True),
        E(
            "disallow_reversed_old_password", "disallowReversedOldPassword", bool,
            is_required=True,
        ),
        E("restrict_min_digits", "restrictMinDigits", bool, is_required=True),
        E("min_digits", "minDigits", int, is_required=True),
        E(
            "restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool,
            is_required=True,
        ),
        E("min_upper_case_letters", "minUpperCaseLetters", int, is_required=True),
        E(
            "restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool,
            is_required=True,
        ),
        E("min_lower_case_letters", "minLowerCaseLetters", int, is_required=True),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool, is_required=True,
        ),
        E(
            "min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int,
            is_required=True,
        ),
        E("min_length", "minLength", int, is_required=True),
        E(
            "send_permanent_lockout_notification", "sendPermanentLockoutNotification",
            bool, is_required=True,
        ),
        E(
            "permanent_lockout_notify_email_address",
            "permanentLockoutNotifyEmailAddress", str,
        ),
        E(
            "device_profile_authentication_lockout_type",
            "deviceProfileAuthenticationLockoutType", str, is_required=True,
        ),
        E(
            "device_profile_temporary_lockout_threshold",
            "deviceProfileTemporaryLockoutThreshold", int, is_required=True,
        ),
        E(
            "device_profile_wait_algorithm", "deviceProfileWaitAlgorithm", str,
            is_required=True,
        ),
        E(
            "device_profile_lockout_fixed_minutes", "deviceProfileLockoutFixedMinutes",
            str, is_required=True,
        ),
        E(
            "device_profile_permanent_lockout_threshold",
            "deviceProfilePermanentLockoutThreshold", int, is_required=True,
        ),
    )

    #: bool: *Required* useServiceProviderSettings
    use_service_provider_settings = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowAuthenticationName
    disallow_authentication_name = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowOldPassword
    disallow_old_password = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowReversedOldPassword
    disallow_reversed_old_password = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* restrictMinDigits
    restrict_min_digits = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minDigits
    min_digits = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minUpperCaseLetters
    min_upper_case_letters = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minLowerCaseLetters
    min_lower_case_letters = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(type=int, required=True, mutable=False)
    #: int: *Required* minLength
    min_length = Field(type=int, required=True, mutable=False)
    #: bool: *Required* sendPermanentLockoutNotification
    send_permanent_lockout_notification = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* permanentLockoutNotifyEmailAddress
    permanent_lockout_notify_email_address = Field(type=str, required=False, mutable=False)
    #: str: *Required* deviceProfileAuthenticationLockoutType
    device_profile_authentication_lockout_type = Field(type=str, required=True, mutable=False)
    #: int: *Required* deviceProfileTemporaryLockoutThreshold
    device_profile_temporary_lockout_threshold = Field(type=int, required=True, mutable=False)
    #: str: *Required* deviceProfileWaitAlgorithm
    device_profile_wait_algorithm = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceProfileLockoutFixedMinutes
    device_profile_lockout_fixed_minutes = Field(type=str, required=True, mutable=False)
    #: int: *Required* deviceProfilePermanentLockoutThreshold
    device_profile_permanent_lockout_threshold = Field(type=int, required=True, mutable=False)


class ServiceProviderDialPlanPolicyGetAccessCodeListResponse(OCIResponse):
    """
    Response to ``ServiceProviderDialPlanPolicyGetAccessCodeListRequest()``.

    Contains a table with column headings: "Access Code", "Enable Secondary Dial Tone",
    "Description".
    """

    _ELEMENTS = (
        E(
            "access_code_table", "accessCodeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* accessCodeTable  *Tabular*
    access_code_table = Field(type=list, required=True, mutable=False)


class ServiceProviderDialPlanPolicyGetAccessCodeResponse(OCIResponse):
    """
    Response to ``ServiceProviderDialPlanPolicyGetAccessCodeRequest()``
    """

    _ELEMENTS = (
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting", bool, is_required=True,
        ),
        E(
            "include_code_for_screening_services", "includeCodeForScreeningServices",
            bool, is_required=True,
        ),
        E("enable_secondary_dial_tone", "enableSecondaryDialTone", bool, is_required=True),
        E("description", "description", str),
    )

    #: bool: *Required* includeCodeForNetworkTranslationsAndRouting
    include_code_for_network_translations_and_routing = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* includeCodeForScreeningServices
    include_code_for_screening_services = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableSecondaryDialTone
    enable_secondary_dial_tone = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class ServiceProviderDialPlanPolicyGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderDialPlanPolicyGetRequest()`` Replaced by:
    ``ServiceProviderDialPlanPolicyGetResponse17()``
    """

    _ELEMENTS = (
        E(
            "requires_access_code_for_public_calls", "requiresAccessCodeForPublicCalls",
            bool, is_required=True,
        ),
        E("allow_e164_public_calls", "allowE164PublicCalls", bool, is_required=True),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    #: bool: *Required* requiresAccessCodeForPublicCalls
    requires_access_code_for_public_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowE164PublicCalls
    allow_e164_public_calls = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(type=str, required=False, mutable=False)
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(type=str, required=False, mutable=False)


class ServiceProviderDialPlanPolicyGetResponse17(OCIResponse):
    """
    Response to ``ServiceProviderDialPlanPolicyGetRequest17()``
    """

    _ELEMENTS = (
        E(
            "requires_access_code_for_public_calls", "requiresAccessCodeForPublicCalls",
            bool, is_required=True,
        ),
        E("allow_e164_public_calls", "allowE164PublicCalls", bool, is_required=True),
        E(
            "prefer_e164_number_format_for_callback_services",
            "preferE164NumberFormatForCallbackServices", bool, is_required=True,
        ),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    #: bool: *Required* requiresAccessCodeForPublicCalls
    requires_access_code_for_public_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowE164PublicCalls
    allow_e164_public_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* preferE164NumberFormatForCallbackServices
    prefer_e164_number_format_for_callback_services = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(type=str, required=False, mutable=False)
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(type=str, required=False, mutable=False)


class ServiceProviderDialableCallerIDCriteriaGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderDialableCallerIDCriteriaGetRequest()``.

    The response contains the Dialable Caller ID Criteria information.
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("prefix_digits", "prefixDigits", str),
        E("match_call_type", "matchCallType", str, is_array=True),
        E(
            "match_alternate_call_indicator", "matchAlternateCallIndicator", str,
            is_array=True,
        ),
        E("match_local_category", "matchLocalCategory", bool, is_required=True),
        E("match_national_category", "matchNationalCategory", bool, is_required=True),
        E("match_interlata_category", "matchInterlataCategory", bool, is_required=True),
        E("match_intralata_category", "matchIntralataCategory", bool, is_required=True),
        E(
            "match_international_category", "matchInternationalCategory", bool,
            is_required=True,
        ),
        E("match_private_category", "matchPrivateCategory", bool, is_required=True),
        E("match_emergency_category", "matchEmergencyCategory", bool, is_required=True),
        E("match_other_category", "matchOtherCategory", bool, is_required=True),
    )

    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* prefixDigits
    prefix_digits = Field(type=str, required=False, mutable=False)
    #: list(str): *Optional* matchCallType  *Array*
    match_call_type = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* matchAlternateCallIndicator  *Array*
    match_alternate_call_indicator = Field(type=list, required=False, mutable=False)
    #: bool: *Required* matchLocalCategory
    match_local_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchNationalCategory
    match_national_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchInterlataCategory
    match_interlata_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchIntralataCategory
    match_intralata_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchInternationalCategory
    match_international_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchPrivateCategory
    match_private_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchEmergencyCategory
    match_emergency_category = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* matchOtherCategory
    match_other_category = Field(type=bool, required=True, mutable=False)


class ServiceProviderDialableCallerIDGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderDialableCallerIDGetRequest()``.

    The criteria table?s column headings are ?Active?, "Name", "Description", ?Prefix
    Digits?, and ?Priority?.
    """

    _ELEMENTS = (
        E(
            "use_service_provider_criteria", "useServiceProviderCriteria", bool,
            is_required=True,
        ),
        E("ns_screening_failure_policy", "nsScreeningFailurePolicy", str, is_required=True),
        E(
            "criteria_table", "criteriaTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: bool: *Required* useServiceProviderCriteria
    use_service_provider_criteria = Field(type=bool, required=True, mutable=False)
    #: str: *Required* nsScreeningFailurePolicy
    ns_screening_failure_policy = Field(type=str, required=True, mutable=False)
    #: list: *Required* criteriaTable  *Tabular*
    criteria_table = Field(type=list, required=True, mutable=False)


class ServiceProviderDigitCollectionGetResponse13mp4(OCIResponse):
    """
    Response to ``ServiceProviderDigitCollectionGetRequest13mp4()``.

    """

    _ELEMENTS = (
        E("access_code", "accessCode", str),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    #: str: *Optional* accessCode
    access_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(type=str, required=False, mutable=False)
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(type=str, required=False, mutable=False)


class ServiceProviderDnGetAvailableListResponse(OCIResponse):
    """
    Response to ``ServiceProviderDnGetAvailableListRequest()``.

    Contains a list of available DNs not yet assigned to any group.
    """

    _ELEMENTS = (
        E("available_dn", "availableDn", str, is_array=True),
    )

    #: list(str): *Optional* availableDn  *Array*
    available_dn = Field(type=list, required=False, mutable=False)


class ServiceProviderDnGetSummaryListResponse(OCIResponse):
    """
    Response to ``ServiceProviderDnGetSummaryListRequest()``.

    The column headings are "Phone Numbers, "Group Id" and "Can Delete"
    """

    _ELEMENTS = (
        E(
            "dn_summary_table", "dnSummaryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* dnSummaryTable  *Tabular*
    dn_summary_table = Field(type=list, required=True, mutable=False)


class ServiceProviderDomainGetAssignedGroupListResponse(OCIResponse):
    """
    Response to ``ServiceProviderDomainGetAssignedGroupListRequest()``.

    Contains a table with column headings: "Group Id", "Group Name" and a row for each
    group.
    """

    _ELEMENTS = (
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* groupTable  *Tabular*
    group_table = Field(type=list, required=True, mutable=False)


class ServiceProviderDomainGetAssignedListResponse(OCIResponse):
    """
    Contains a simple list of all service provider domain names.

    """

    _ELEMENTS = (
        E(
            "service_provider_default_domain", "serviceProviderDefaultDomain", str,
            is_required=True,
        ),
        E("domain", "domain", str, is_array=True),
    )

    #: str: *Required* serviceProviderDefaultDomain
    service_provider_default_domain = Field(type=str, required=True, mutable=False)
    #: list(str): *Optional* domain  *Array*
    domain = Field(type=list, required=False, mutable=False)


class ServiceProviderEndpointGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderEndpointGetListRequest()``.

    The column headings for the endpointTable are: "Group Id", "Line/Port", "Last Name",
    "First Name", "User Id", "User Type", "Phone Number", "Extension", "Device Type",
    "Device Name", "Net Address", "MAC Address", "Department", "Email Address". Possible
    values for User Type are "User", "CCBasic", "CCStandard", "CCPremium", "RP", "MOH",
    "MOHVideo".
    """

    _ELEMENTS = (
        E(
            "endpoint_table", "endpointTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* endpointTable  *Tabular*
    endpoint_table = Field(type=list, required=True, mutable=False)


class ServiceProviderEnhancedCallLogsGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderEnhancedCallLogsGetRequest()``.

    """

    _ELEMENTS = (
        E("max_logged_calls", "maxLoggedCalls", int, is_required=True),
        E("call_expiration_days", "callExpirationDays", int, is_required=True),
    )

    #: int: *Required* maxLoggedCalls
    max_logged_calls = Field(type=int, required=True, mutable=False)
    #: int: *Required* callExpirationDays
    call_expiration_days = Field(type=int, required=True, mutable=False)


class ServiceProviderEnhancedCallLogsGetResponse17sp4(OCIResponse):
    """
    Response to ``ServiceProviderEnhancedCallLogsGetRequest17sp4()``.

    """

    _ELEMENTS = (
        E("max_logged_calls", "maxLoggedCalls", int, is_required=True),
        E("call_expiration_days", "callExpirationDays", int, is_required=True),
    )

    #: int: *Required* maxLoggedCalls
    max_logged_calls = Field(type=int, required=True, mutable=False)
    #: int: *Required* callExpirationDays
    call_expiration_days = Field(type=int, required=True, mutable=False)


class ServiceProviderExternalCustomRingbackGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderExternalCustomRingbackGetRequest()``.

    """

    _ELEMENTS = (
        E("prefix_digits", "prefixDigits", str),
        E("server_net_address", "serverNetAddress", str),
        E("server_port", "serverPort", int),
        E("timeout_seconds", "timeoutSeconds", int, is_required=True),
    )

    #: str: *Optional* prefixDigits
    prefix_digits = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serverNetAddress
    server_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* serverPort
    server_port = Field(type=int, required=False, mutable=False)
    #: int: *Required* timeoutSeconds
    timeout_seconds = Field(type=int, required=True, mutable=False)


class ServiceProviderFileRepositoryDeviceUserGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderFileRepositoryDeviceUserGetListRequest()``.

    Contains a table with column headings : "User Name","Allow Delete","Allow Get","Allow
    Put" in a row for each file repository service provider user.
    """

    _ELEMENTS = (
        E(
            "file_repository_user_table", "fileRepositoryUserTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* fileRepositoryUserTable  *Tabular*
    file_repository_user_table = Field(type=list, required=True, mutable=False)


class ServiceProviderGetDefaultResponse(OCIResponse):
    """
    Response to the ``ServiceProviderGetDefaultRequest()``.

    All values are default values for a service provider or enterprise's profile.
    """

    _ELEMENTS = (
        E("is_enterprise", "isEnterprise", bool, is_required=True),
        E("default_domain", "defaultDomain", str, is_required=True),
    )

    #: bool: *Required* isEnterprise
    is_enterprise = Field(type=bool, required=True, mutable=False)
    #: str: *Required* defaultDomain
    default_domain = Field(type=str, required=True, mutable=False)


class ServiceProviderGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderGetListRequest()``.

    Contains a 3 column table with column headings 'Service Provider Id', 'Service
    Provider Name' and 'Is Enterprise' and a row for each service provider or enterprise.
    """

    _ELEMENTS = (
        E(
            "service_provider_table", "serviceProviderTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* serviceProviderTable  *Tabular*
    service_provider_table = Field(type=list, required=True, mutable=False)


class ServiceProviderGroupPagingTargetsCapacityGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderGroupPagingTargetsCapacityGetRequest()``.

    """

    _ELEMENTS = (
        E("maximum_target_users", "maximumTargetUsers", int, is_required=True),
    )

    #: int: *Required* maximumTargetUsers
    maximum_target_users = Field(type=int, required=True, mutable=False)


class ServiceProviderIMRNGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderIMRNGetListRequest()``.

    """

    _ELEMENTS = (
        E("imrn", "imrn", str, is_array=True),
    )

    #: list(str): *Optional* imrn  *Array*
    imrn = Field(type=list, required=False, mutable=False)


class ServiceProviderInCallServiceActivationGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderInCallServiceActivationGetRequest()``.

    Replaced by: ``ServiceProviderInCallServiceActivationGetResponse17()``
    """

    _ELEMENTS = (
        E("activation_digits", "activationDigits", str, is_required=True),
    )

    #: str: *Required* activationDigits
    activation_digits = Field(type=str, required=True, mutable=False)


class ServiceProviderInCallServiceActivationGetResponse17(OCIResponse):
    """
    Response to ``ServiceProviderInCallServiceActivationGetRequest17()``.

    """

    _ELEMENTS = (
        E("flash_activation_digits", "flashActivationDigits", str, is_required=True),
        E(
            "call_transfer_activation_digits", "callTransferActivationDigits", str,
            is_required=True,
        ),
    )

    #: str: *Required* flashActivationDigits
    flash_activation_digits = Field(type=str, required=True, mutable=False)
    #: str: *Required* callTransferActivationDigits
    call_transfer_activation_digits = Field(type=str, required=True, mutable=False)


class ServiceProviderIntegratedIMPGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderIntegratedIMPGetRequest()``.

    The response contains the service provider Integrated IMP service attributes.
    Replaced by: ``ServiceProviderIntegratedIMPGetResponse21()``
    """

    _ELEMENTS = (
        E("use_system_service_domain", "useSystemServiceDomain", bool, is_required=True),
        E("service_domain", "serviceDomain", str),
    )

    #: bool: *Required* useSystemServiceDomain
    use_system_service_domain = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* serviceDomain
    service_domain = Field(type=str, required=False, mutable=False)


class ServiceProviderIntegratedIMPGetResponse21(OCIResponse):
    """
    Response to the ``ServiceProviderIntegratedIMPGetRequest21()``.

    The response contains the service provider Integrated IMP service attributes.
    """

    _ELEMENTS = (
        E("use_system_service_domain", "useSystemServiceDomain", bool, is_required=True),
        E("service_domain", "serviceDomain", str),
        E("service_port", "servicePort", int),
        E("use_system_messaging_server", "useSystemMessagingServer", bool, is_required=True),
        E("provisioning_url", "provisioningUrl", str),
        E("provisioning_user_id", "provisioningUserId", str),
        E("bosh_url", "boshURL", str),
    )

    #: bool: *Required* useSystemServiceDomain
    use_system_service_domain = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* serviceDomain
    service_domain = Field(type=str, required=False, mutable=False)
    #: int: *Optional* servicePort
    service_port = Field(type=int, required=False, mutable=False)
    #: bool: *Required* useSystemMessagingServer
    use_system_messaging_server = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* provisioningUrl
    provisioning_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* provisioningUserId
    provisioning_user_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* boshURL
    bosh_url = Field(type=str, required=False, mutable=False)


class ServiceProviderLDAPIntegrationGetDirectoryResponse(OCIResponse):
    """
    Response to ``ServiceProviderLDAPIntegrationGetDirectoryRequest()``.

    """

    _ELEMENTS = (
        E("server_net_address", "serverNetAddress", str),
        E("server_port", "serverPort", int, is_required=True),
        E("search_base", "searchBase", str),
        E("use_ssl", "useSSL", bool, is_required=True),
        E("require_authentication", "requireAuthentication", bool, is_required=True),
        E("authenticated_dn", "authenticatedDN", str),
        E("authenticated_password", "authenticatedPassword", str),
        E("is_sort_enabled", "isSortEnabled", bool, is_required=True),
        E("is_paged_result_enabled", "isPagedResultEnabled", bool, is_required=True),
        E("search_filter", "searchFilter", str),
        E(
            "include_search_attribute_in_search_filter",
            "includeSearchAttributeInSearchFilter", bool, is_required=True,
        ),
        E("column1_attribute_name", "column1AttributeName", str, is_required=True),
        E("column2_attribute_name", "column2AttributeName", str),
        E("column3_attribute_name", "column3AttributeName", str),
        E("column4_attribute_name", "column4AttributeName", str),
        E("column1_label", "column1Label", str),
        E("column2_label", "column2Label", str),
        E("column3_label", "column3Label", str),
        E("column4_label", "column4Label", str),
        E("search_column", "searchColumn", int, is_required=True),
    )

    #: str: *Optional* serverNetAddress
    server_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Required* serverPort
    server_port = Field(type=int, required=True, mutable=False)
    #: str: *Optional* searchBase
    search_base = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useSSL
    use_ssl = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* requireAuthentication
    require_authentication = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* authenticatedDN
    authenticated_dn = Field(type=str, required=False, mutable=False)
    #: str: *Optional* authenticatedPassword
    authenticated_password = Field(type=str, required=False, mutable=False)
    #: bool: *Required* isSortEnabled
    is_sort_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isPagedResultEnabled
    is_paged_result_enabled = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* searchFilter
    search_filter = Field(type=str, required=False, mutable=False)
    #: bool: *Required* includeSearchAttributeInSearchFilter
    include_search_attribute_in_search_filter = Field(type=bool, required=True, mutable=False)
    #: str: *Required* column1AttributeName
    column1_attribute_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* column2AttributeName
    column2_attribute_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column3AttributeName
    column3_attribute_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column4AttributeName
    column4_attribute_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column1Label
    column1_label = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column2Label
    column2_label = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column3Label
    column3_label = Field(type=str, required=False, mutable=False)
    #: str: *Optional* column4Label
    column4_label = Field(type=str, required=False, mutable=False)
    #: int: *Required* searchColumn
    search_column = Field(type=int, required=True, mutable=False)


class ServiceProviderLanguageGetAvailableListResponse(OCIResponse):
    """
    Response to ``ServiceProviderLanguageGetAvailableListRequest()``.

    The language table column headings are: "Language", "Locale" and "Encoding".
    """

    _ELEMENTS = (
        E("default_language", "defaultLanguage", str, is_required=True),
        E(
            "language_table", "languageTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: str: *Required* defaultLanguage
    default_language = Field(type=str, required=True, mutable=False)
    #: list: *Required* languageTable  *Tabular*
    language_table = Field(type=list, required=True, mutable=False)


class ServiceProviderLanguageGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderLanguageGetListRequest()``.

    """

    _ELEMENTS = (
        E("language", "language", str, is_array=True),
        E("default_language", "defaultLanguage", str),
    )

    #: list(str): *Optional* language  *Array*
    language = Field(type=list, required=False, mutable=False)
    #: str: *Optional* defaultLanguage
    default_language = Field(type=str, required=False, mutable=False)


class ServiceProviderMWIDeliveryToMobileEndpointGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderMWIDeliveryToMobileEndpointGetRequest()``.

    The templateActivationTable contains the list of templates defined for the service
    provider.  The column headings are "Enable", "Language", "Type".
    """

    _ELEMENTS = (
        E(
            "template_activation_table", "templateActivationTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* templateActivationTable  *Tabular*
    template_activation_table = Field(type=list, required=True, mutable=False)


class ServiceProviderMaliciousCallTraceGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderMaliciousCallTraceGetRequest()``.

    The response contains the service provider Malicious Call Trace settings.
    """

    _ELEMENTS = (
        E(
            "use_system_play_mct_warning_announcement",
            "useSystemPlayMCTWarningAnnouncement", bool, is_required=True,
        ),
        E(
            "play_mct_warning_announcement", "playMCTWarningAnnouncement", bool,
            is_required=True,
        ),
    )

    #: bool: *Required* useSystemPlayMCTWarningAnnouncement
    use_system_play_mct_warning_announcement = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* playMCTWarningAnnouncement
    play_mct_warning_announcement = Field(type=bool, required=True, mutable=False)


class ServiceProviderNetworkClassOfServiceGetAssignedGroupListResponse(OCIResponse):
    """
    Response to ``ServiceProviderNetworkClassOfServiceGetAssignedGroupListRequest()``.

    Contains a table of groups that have the Network Class of Service assigned.  The
    column headings are: "Group Id" and "Group Name".
    """

    _ELEMENTS = (
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* groupTable  *Tabular*
    group_table = Field(type=list, required=True, mutable=False)


class ServiceProviderNetworkClassOfServiceGetAssignedListResponse(OCIResponse):
    """
    Response to ``ServiceProviderNetworkClassOfServiceGetAssignedListRequest()``.

    Contains a table of all Network Classes of Service assigned to the service provider.
    The column headings are: "Name", "Description" and "Default".
    """

    _ELEMENTS = (
        E(
            "network_class_of_service_table", "networkClassOfServiceTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* networkClassOfServiceTable  *Tabular*
    network_class_of_service_table = Field(type=list, required=True, mutable=False)


class ServiceProviderNumberPortabilityQueryGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderNumberPortabilityQueryGetRequest()``.

    The response contains the service provider number portability query information.
    """

    _ELEMENTS = (
        E(
            "enable_number_portability_query_for_outgoing_calls",
            "enableNumberPortabilityQueryForOutgoingCalls", bool, is_required=True,
        ),
        E(
            "enable_number_portability_query_for_incoming_calls",
            "enableNumberPortabilityQueryForIncomingCalls", bool, is_required=True,
        ),
        E(
            "enable_number_portability_query_for_network_calls_only",
            "enableNumberPortabilityQueryForNetworkCallsOnly", bool, is_required=True,
        ),
        E("digit_pattern", "digitPattern", str, is_array=True),
    )

    #: bool: *Required* enableNumberPortabilityQueryForOutgoingCalls
    enable_number_portability_query_for_outgoing_calls = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableNumberPortabilityQueryForIncomingCalls
    enable_number_portability_query_for_incoming_calls = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableNumberPortabilityQueryForNetworkCallsOnly
    enable_number_portability_query_for_network_calls_only = Field(
        type=bool, required=True, mutable=False,
    )
    #: list(str): *Optional* digitPattern  *Array*
    digit_pattern = Field(type=list, required=False, mutable=False)


class ServiceProviderOfficeZoneGetAssignedGroupListResponse(OCIResponse):
    """
    Response to ``ServiceProviderOfficeZoneGetAssignedGroupListRequest()``.

    Contains a table of groups that have the Office Zone assigned.  The column headings
    are: "Group Id" and "Group Name".
    """

    _ELEMENTS = (
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* groupTable  *Tabular*
    group_table = Field(type=list, required=True, mutable=False)


class ServiceProviderOfficeZoneGetAssignedListResponse(OCIResponse):
    """
    Response to ``ServiceProviderOfficeZoneGetAssignedListRequest()``.

    Contains a table of all Office Zones assigned to the service provider.  The column
    headings are: "Name", "Description" and "Default".
    """

    _ELEMENTS = (
        E(
            "office_zone_table", "officeZoneTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* officeZoneTable  *Tabular*
    office_zone_table = Field(type=list, required=True, mutable=False)


class ServiceProviderPasswordRulesGetResponse13mp2(OCIResponse):
    """
    Response to ``ServiceProviderPasswordRulesGetRequest13mp2()``.

    Contains the group, department administrator and/or user password rules setting.

    Replaced By: ``ServiceProviderPasswordRulesGetResponse16()``
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("rules_apply_to", "rulesApplyTo", str, is_required=True),
        E(
            "allow_web_add_external_authentication_users",
            "allowWebAddExternalAuthenticationUsers", bool, is_required=True,
        ),
        E("disallow_user_id", "disallowUserId", bool, is_required=True),
        E("disallow_old_password", "disallowOldPassword", bool, is_required=True),
        E(
            "disallow_reversed_old_password", "disallowReversedOldPassword", bool,
            is_required=True,
        ),
        E("restrict_min_digits", "restrictMinDigits", bool, is_required=True),
        E("min_digits", "minDigits", int, is_required=True),
        E(
            "restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool,
            is_required=True,
        ),
        E("min_upper_case_letters", "minUpperCaseLetters", int, is_required=True),
        E(
            "restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool,
            is_required=True,
        ),
        E("min_lower_case_letters", "minLowerCaseLetters", int, is_required=True),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool, is_required=True,
        ),
        E(
            "min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int,
            is_required=True,
        ),
        E("min_length", "minLength", int, is_required=True),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int, is_required=True),
        E("password_expires_days", "passwordExpiresDays", int, is_required=True),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
        E("disallow_rules_modification", "disallowRulesModification", bool, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* rulesApplyTo
    rules_apply_to = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowWebAddExternalAuthenticationUsers
    allow_web_add_external_authentication_users = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* disallowUserId
    disallow_user_id = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowOldPassword
    disallow_old_password = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowReversedOldPassword
    disallow_reversed_old_password = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* restrictMinDigits
    restrict_min_digits = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minDigits
    min_digits = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minUpperCaseLetters
    min_upper_case_letters = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minLowerCaseLetters
    min_lower_case_letters = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(type=int, required=True, mutable=False)
    #: int: *Required* minLength
    min_length = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=True, mutable=False)
    #: int: *Required* passwordExpiresDays
    password_expires_days = Field(type=int, required=True, mutable=False)
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)
    #: bool: *Required* disallowRulesModification
    disallow_rules_modification = Field(type=bool, required=True, mutable=False)


class ServiceProviderPasswordRulesGetResponse16(OCIResponse):
    """
    Response to ``ServiceProviderPasswordRulesGetRequest16()``.

    Contains the group, department administrator and/or user password rules setting.
    """

    _ELEMENTS = (
        E("rules_apply_to", "rulesApplyTo", str, is_required=True),
        E(
            "allow_web_add_external_authentication_users",
            "allowWebAddExternalAuthenticationUsers", bool, is_required=True,
        ),
        E("disallow_user_id", "disallowUserId", bool, is_required=True),
        E("disallow_old_password", "disallowOldPassword", bool, is_required=True),
        E(
            "disallow_reversed_old_password", "disallowReversedOldPassword", bool,
            is_required=True,
        ),
        E("restrict_min_digits", "restrictMinDigits", bool, is_required=True),
        E("min_digits", "minDigits", int, is_required=True),
        E(
            "restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool,
            is_required=True,
        ),
        E("min_upper_case_letters", "minUpperCaseLetters", int, is_required=True),
        E(
            "restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool,
            is_required=True,
        ),
        E("min_lower_case_letters", "minLowerCaseLetters", int, is_required=True),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool, is_required=True,
        ),
        E(
            "min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int,
            is_required=True,
        ),
        E("min_length", "minLength", int, is_required=True),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int, is_required=True),
        E("password_expires_days", "passwordExpiresDays", int, is_required=True),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
        E("disallow_rules_modification", "disallowRulesModification", bool, is_required=True),
        E("disallow_previous_passwords", "disallowPreviousPasswords", bool, is_required=True),
        E("number_of_previous_passwords", "numberOfPreviousPasswords", int, is_required=True),
    )

    #: str: *Required* rulesApplyTo
    rules_apply_to = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowWebAddExternalAuthenticationUsers
    allow_web_add_external_authentication_users = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* disallowUserId
    disallow_user_id = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowOldPassword
    disallow_old_password = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowReversedOldPassword
    disallow_reversed_old_password = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* restrictMinDigits
    restrict_min_digits = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minDigits
    min_digits = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minUpperCaseLetters
    min_upper_case_letters = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minLowerCaseLetters
    min_lower_case_letters = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(type=int, required=True, mutable=False)
    #: int: *Required* minLength
    min_length = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=True, mutable=False)
    #: int: *Required* passwordExpiresDays
    password_expires_days = Field(type=int, required=True, mutable=False)
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)
    #: bool: *Required* disallowRulesModification
    disallow_rules_modification = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowPreviousPasswords
    disallow_previous_passwords = Field(type=bool, required=True, mutable=False)
    #: int: *Required* numberOfPreviousPasswords
    number_of_previous_passwords = Field(type=int, required=True, mutable=False)


class ServiceProviderPortalPasscodeRulesGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderPortalPasscodeRulesGetRequest()``.

    Contains the service provider's passcode rules setting.
    """

    _ELEMENTS = (
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool, is_required=True),
        E("disallow_user_number", "disallowUserNumber", bool, is_required=True),
        E(
            "disallow_reversed_user_number", "disallowReversedUserNumber", bool,
            is_required=True,
        ),
        E("disallow_old_passcode", "disallowOldPasscode", bool, is_required=True),
        E(
            "disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool,
            is_required=True,
        ),
        E("min_code_length", "minCodeLength", int, is_required=True),
        E("max_code_length", "maxCodeLength", int, is_required=True),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool, is_required=True,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool, is_required=True),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    #: bool: *Required* disallowRepeatedDigits
    disallow_repeated_digits = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowUserNumber
    disallow_user_number = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowReversedUserNumber
    disallow_reversed_user_number = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowOldPasscode
    disallow_old_passcode = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minCodeLength
    min_code_length = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxCodeLength
    max_code_length = Field(type=int, required=True, mutable=False)
    #: bool: *Required* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=False, mutable=False)
    #: bool: *Required* expirePassword
    expire_password = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(type=int, required=False, mutable=False)
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)


class ServiceProviderPortalPasscodeRulesGetResponse19(OCIResponse):
    """
    Response to ``ServiceProviderPortalPasscodeRulesGetRequest19()``.

    Contains the service provider's passcode rules setting.  The following elements are
    only used in AS data mode: numberOfRepeatedDigits disallowRepeatedPatterns
    disallowContiguousSequences numberOfAscendingDigits numberOfDescendingDigits
    numberOfPreviousPasscodes
    """

    _ELEMENTS = (
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool, is_required=True),
        E("number_of_repeated_digits", "numberOfRepeatedDigits", int, is_required=True),
        E("disallow_repeated_patterns", "disallowRepeatedPatterns", bool, is_required=True),
        E(
            "disallow_contiguous_sequences", "disallowContiguousSequences", bool,
            is_required=True,
        ),
        E("number_of_ascending_digits", "numberOfAscendingDigits", int, is_required=True),
        E("number_of_descending_digits", "numberOfDescendingDigits", int, is_required=True),
        E("disallow_user_number", "disallowUserNumber", bool, is_required=True),
        E(
            "disallow_reversed_user_number", "disallowReversedUserNumber", bool,
            is_required=True,
        ),
        E("disallow_old_passcode", "disallowOldPasscode", bool, is_required=True),
        E("number_of_previous_passcodes", "numberOfPreviousPasscodes", int, is_required=True),
        E(
            "disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool,
            is_required=True,
        ),
        E("min_code_length", "minCodeLength", int, is_required=True),
        E("max_code_length", "maxCodeLength", int, is_required=True),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool, is_required=True,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool, is_required=True),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    #: bool: *Required* disallowRepeatedDigits
    disallow_repeated_digits = Field(type=bool, required=True, mutable=False)
    #: int: *Required* numberOfRepeatedDigits
    number_of_repeated_digits = Field(type=int, required=True, mutable=False)
    #: bool: *Required* disallowRepeatedPatterns
    disallow_repeated_patterns = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowContiguousSequences
    disallow_contiguous_sequences = Field(type=bool, required=True, mutable=False)
    #: int: *Required* numberOfAscendingDigits
    number_of_ascending_digits = Field(type=int, required=True, mutable=False)
    #: int: *Required* numberOfDescendingDigits
    number_of_descending_digits = Field(type=int, required=True, mutable=False)
    #: bool: *Required* disallowUserNumber
    disallow_user_number = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowReversedUserNumber
    disallow_reversed_user_number = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowOldPasscode
    disallow_old_passcode = Field(type=bool, required=True, mutable=False)
    #: int: *Required* numberOfPreviousPasscodes
    number_of_previous_passcodes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minCodeLength
    min_code_length = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxCodeLength
    max_code_length = Field(type=int, required=True, mutable=False)
    #: bool: *Required* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=False, mutable=False)
    #: bool: *Required* expirePassword
    expire_password = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(type=int, required=False, mutable=False)
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)


class ServiceProviderPreferredCarrierGetAvailableCountryCodeListResponse(OCIResponse):
    """
    Response to a ``ServiceProviderPreferredCarrierGetAvailableCountryCodeListRequest()``.

    Contains the default country code and the list of unused country codes for a service
    provider / enterprise.
    """

    _ELEMENTS = (
        E("default_country_code", "defaultCountryCode", str),
        E("country_code", "countryCode", str, is_array=True),
    )

    #: str: *Optional* defaultCountryCode
    default_country_code = Field(type=str, required=False, mutable=False)
    #: list(str): *Optional* countryCode  *Array*
    country_code = Field(type=list, required=False, mutable=False)


class ServiceProviderPreferredCarrierGetCarrierListResponse(OCIResponse):
    """
    Response to a ``ServiceProviderPreferredCarrierGetCarrierListRequest()``.

    Contains the lists of carriers for a specified country code for a service provider /
    enterprise.
    """

    _ELEMENTS = (
        E("intra_lata_carrier", "intraLataCarrier", str, is_array=True),
        E("inter_lata_carrier", "interLataCarrier", str, is_array=True),
        E("international_carrier", "internationalCarrier", str, is_array=True),
    )

    #: list(str): *Optional* intraLataCarrier  *Array*
    intra_lata_carrier = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* interLataCarrier  *Array*
    inter_lata_carrier = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* internationalCarrier  *Array*
    international_carrier = Field(type=list, required=False, mutable=False)


class ServiceProviderPreferredCarrierGetListResponse(OCIResponse):
    """
    Response to a ``ServiceProviderPreferredCarrierGetListRequest()``.

    Contains a table with one row per carrier.  The table columns are: "Country Code",
    "Intra-Lata PIC", "Inter-Lata PIC", "International PIC".
    """

    _ELEMENTS = (
        E(
            "service_provider_carrier_table", "serviceProviderCarrierTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* serviceProviderCarrierTable  *Tabular*
    service_provider_carrier_table = Field(type=list, required=True, mutable=False)


class ServiceProviderPreferredCarrierGetResponse(OCIResponse):
    """
    Response to a ``ServiceProviderPreferredCarrierGetRequest()``.

    Contains the currently configured carriers for a specified country code for a service
    provider / enterprise.
    """

    _ELEMENTS = (
        E("intra_lata_carrier", "intraLataCarrier", str),
        E("inter_lata_carrier", "interLataCarrier", str),
        E("international_carrier", "internationalCarrier", str),
    )

    #: str: *Optional* intraLataCarrier
    intra_lata_carrier = Field(type=str, required=False, mutable=False)
    #: str: *Optional* interLataCarrier
    inter_lata_carrier = Field(type=str, required=False, mutable=False)
    #: str: *Optional* internationalCarrier
    international_carrier = Field(type=str, required=False, mutable=False)


class ServiceProviderRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse(OCIResponse):
    """
    Response to
    ``ServiceProviderRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest()``.

    Contains a list of available number ranges not yet assigned to any group.  The column
    headings are "Number Range Start", "Number Range End" and "Is Active".
    """

    _ELEMENTS = (
        E(
            "available_number_range_table", "availableNumberRangeTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* availableNumberRangeTable  *Tabular*
    available_number_range_table = Field(type=list, required=True, mutable=False)


class ServiceProviderRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse(OCIResponse):
    """
    Response to
    ``ServiceProviderRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest()``.

    The column headings are "Number Range Start", "Number Range End", "Group Id" and "Is
    Active".
    """

    _ELEMENTS = (
        E(
            "number_range_summary_table", "numberRangeSummaryTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* numberRangeSummaryTable  *Tabular*
    number_range_summary_table = Field(type=list, required=True, mutable=False)


class ServiceProviderRoutePointExternalSystemGetAssignedGroupListResponse(OCIResponse):
    """
    Response to ``ServiceProviderRoutePointExternalSystemGetAssignedGroupListRequest()``.

    Contains a table with column headings: "Group Id", "Group Name" and a row for each
    group.
    """

    _ELEMENTS = (
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* groupTable  *Tabular*
    group_table = Field(type=list, required=True, mutable=False)


class ServiceProviderRoutePointExternalSystemGetAssignedListResponse(OCIResponse):
    """
    Response to the ``ServiceProviderRoutePointExternalSystemGetAssignedListRequest()``.

    Contains a table of all Route Point External Systems assigned to the service provider.
    The column headings are: "Name" and "Description".
    """

    _ELEMENTS = (
        E(
            "external_system_table", "externalSystemTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* externalSystemTable  *Tabular*
    external_system_table = Field(type=list, required=True, mutable=False)


class ServiceProviderRoutingProfileGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderRoutingProfileGetRequest()``.

    """

    _ELEMENTS = (
        E("routing_profile", "routingProfile", str),
    )

    #: str: *Optional* routingProfile
    routing_profile = Field(type=str, required=False, mutable=False)


class ServiceProviderSIPAuthenticationPasswordRulesGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderSIPAuthenticationPasswordRulesGetRequest()``.

    Contains the SIP authentication password rules for the service provider.
    """

    _ELEMENTS = (
        E(
            "use_service_provider_settings", "useServiceProviderSettings", bool,
            is_required=True,
        ),
        E(
            "disallow_authentication_name", "disallowAuthenticationName", bool,
            is_required=True,
        ),
        E("disallow_old_password", "disallowOldPassword", bool, is_required=True),
        E(
            "disallow_reversed_old_password", "disallowReversedOldPassword", bool,
            is_required=True,
        ),
        E("restrict_min_digits", "restrictMinDigits", bool, is_required=True),
        E("min_digits", "minDigits", int, is_required=True),
        E(
            "restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool,
            is_required=True,
        ),
        E("min_upper_case_letters", "minUpperCaseLetters", int, is_required=True),
        E(
            "restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool,
            is_required=True,
        ),
        E("min_lower_case_letters", "minLowerCaseLetters", int, is_required=True),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool, is_required=True,
        ),
        E(
            "min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int,
            is_required=True,
        ),
        E("min_length", "minLength", int, is_required=True),
        E(
            "send_permanent_lockout_notification", "sendPermanentLockoutNotification",
            bool, is_required=True,
        ),
        E(
            "permanent_lockout_notify_email_address",
            "permanentLockoutNotifyEmailAddress", str,
        ),
        E(
            "endpoint_authentication_lockout_type", "endpointAuthenticationLockoutType",
            str, is_required=True,
        ),
        E(
            "endpoint_temporary_lockout_threshold", "endpointTemporaryLockoutThreshold",
            int, is_required=True,
        ),
        E("endpoint_wait_algorithm", "endpointWaitAlgorithm", str, is_required=True),
        E(
            "endpoint_lockout_fixed_minutes", "endpointLockoutFixedMinutes", str,
            is_required=True,
        ),
        E(
            "endpoint_permanent_lockout_threshold", "endpointPermanentLockoutThreshold",
            int, is_required=True,
        ),
        E(
            "trunk_group_temporary_lockout_threshold",
            "trunkGroupTemporaryLockoutThreshold", int, is_required=True,
        ),
        E(
            "trunk_group_authentication_lockout_type",
            "trunkGroupAuthenticationLockoutType", str, is_required=True,
        ),
        E("trunk_group_wait_algorithm", "trunkGroupWaitAlgorithm", str, is_required=True),
        E(
            "trunk_group_lockout_fixed_minutes", "trunkGroupLockoutFixedMinutes", str,
            is_required=True,
        ),
        E(
            "trunk_group_permanent_lockout_threshold",
            "trunkGroupPermanentLockoutThreshold", int, is_required=True,
        ),
    )

    #: bool: *Required* useServiceProviderSettings
    use_service_provider_settings = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowAuthenticationName
    disallow_authentication_name = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowOldPassword
    disallow_old_password = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowReversedOldPassword
    disallow_reversed_old_password = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* restrictMinDigits
    restrict_min_digits = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minDigits
    min_digits = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minUpperCaseLetters
    min_upper_case_letters = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minLowerCaseLetters
    min_lower_case_letters = Field(type=int, required=True, mutable=False)
    #: bool: *Required* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(type=int, required=True, mutable=False)
    #: int: *Required* minLength
    min_length = Field(type=int, required=True, mutable=False)
    #: bool: *Required* sendPermanentLockoutNotification
    send_permanent_lockout_notification = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* permanentLockoutNotifyEmailAddress
    permanent_lockout_notify_email_address = Field(type=str, required=False, mutable=False)
    #: str: *Required* endpointAuthenticationLockoutType
    endpoint_authentication_lockout_type = Field(type=str, required=True, mutable=False)
    #: int: *Required* endpointTemporaryLockoutThreshold
    endpoint_temporary_lockout_threshold = Field(type=int, required=True, mutable=False)
    #: str: *Required* endpointWaitAlgorithm
    endpoint_wait_algorithm = Field(type=str, required=True, mutable=False)
    #: str: *Required* endpointLockoutFixedMinutes
    endpoint_lockout_fixed_minutes = Field(type=str, required=True, mutable=False)
    #: int: *Required* endpointPermanentLockoutThreshold
    endpoint_permanent_lockout_threshold = Field(type=int, required=True, mutable=False)
    #: int: *Required* trunkGroupTemporaryLockoutThreshold
    trunk_group_temporary_lockout_threshold = Field(type=int, required=True, mutable=False)
    #: str: *Required* trunkGroupAuthenticationLockoutType
    trunk_group_authentication_lockout_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* trunkGroupWaitAlgorithm
    trunk_group_wait_algorithm = Field(type=str, required=True, mutable=False)
    #: str: *Required* trunkGroupLockoutFixedMinutes
    trunk_group_lockout_fixed_minutes = Field(type=str, required=True, mutable=False)
    #: int: *Required* trunkGroupPermanentLockoutThreshold
    trunk_group_permanent_lockout_threshold = Field(type=int, required=True, mutable=False)


class ServiceProviderScheduleGetEventListResponse(OCIResponse):
    """
    Response to ``ServiceProviderScheduleGetEventListRequest()``.

    The response contains a list of events.
    """

    _ELEMENTS = (
        E("event_name", "eventName", str, is_array=True),
    )

    #: list(str): *Optional* eventName  *Array*
    event_name = Field(type=list, required=False, mutable=False)


class ServiceProviderServiceGetAuthorizationListResponse(OCIResponse):
    """
    Response to ``ServiceProviderServiceGetAuthorizationListRequest()``.

    Contains two tables, one for the group services and one for the user services.  The
    Group Service table has column headings: "Service Name", "Authorized", "Assigned",
    "Limited", "Quantity", "Allocated", "Licensed", "Service Pack Allocation" The User
    Service table has column headings: "Service Name", "Authorized", "Assigned",
    "Limited", "Quantity", "Allocated", "Licensed", "Service Pack Allocation", "User
    Assignable", "Service Pack Assignable".
    """

    _ELEMENTS = (
        E(
            "group_services_authorization_table", "groupServicesAuthorizationTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
        E(
            "user_services_authorization_table", "userServicesAuthorizationTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* groupServicesAuthorizationTable  *Tabular*
    group_services_authorization_table = Field(type=list, required=True, mutable=False)
    #: list: *Required* userServicesAuthorizationTable  *Tabular*
    user_services_authorization_table = Field(type=list, required=True, mutable=False)


class ServiceProviderServiceGetUserAssignableListResponse(OCIResponse):
    """
    Response to ``ServiceProviderServiceGetUserAssignableListRequest()``.

    """

    _ELEMENTS = (
        E("service_name", "serviceName", str, is_array=True),
    )

    #: list(str): *Optional* serviceName  *Array*
    service_name = Field(type=list, required=False, mutable=False)


class ServiceProviderServicePackGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderServicePackGetListRequest()``.

    """

    _ELEMENTS = (
        E("service_pack_name", "servicePackName", str, is_array=True),
    )

    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(type=list, required=False, mutable=False)


class ServiceProviderServicePackGetServiceUsageListResponse(OCIResponse):
    """
    Response to ``ServiceProviderServicePackGetServiceUsageListRequest()``.

    The column headings are "Service Pack Name", "Total Packs" and "Allocated to Groups"
    """

    _ELEMENTS = (
        E(
            "service_usage_table", "serviceUsageTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* serviceUsageTable  *Tabular*
    service_usage_table = Field(type=list, required=True, mutable=False)


class ServiceProviderServicePackGetUtilizationListResponse(OCIResponse):
    """
    Response to ``ServiceProviderServicePackGetUtilizationListRequest()``.

    For each service pack, a table of groups utilizing the pack is returned.  The
    utilization table column headings are "Group", "Total Packs" and "Assigned".
    """

    _ELEMENTS = (
        E("service_pack_name", "servicePackName", str, is_array=True),
        E(
            "service_utilization_table", "serviceUtilizationTable", list, is_complex=True,
            is_array=True, is_table=True,
        ),
    )

    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(type=list, required=False, mutable=False)
    #: list(list): *Optional* serviceUtilizationTable  *Array*  *Tabular*
    service_utilization_table = Field(type=list, required=False, mutable=False)


class ServiceProviderServicePackMigrationTaskGetAvailableGroupListResponse(OCIResponse):
    """
    Response to ``ServiceProviderServicePackMigrationTaskGetAvailableGroupListRequest()``.

    The groupTable column headings are: "Group Id", "Group Name", "User Count".
    """

    _ELEMENTS = (
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* groupTable  *Tabular*
    group_table = Field(type=list, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderServicePackMigrationTaskGetListRequest()``.

    Contains a table with a row for each service pack migration task and column headings :
    "Start Timestamp Milliseconds", "Name", "Status", "Error Count", "Users Processed",
    "Users Total". The start timestamp column is the number of milliseconds since the
    standard base time known as "the epoch", namely January 1, 1970, 00:00:00 GMT.
    """

    _ELEMENTS = (
        E("task_table", "taskTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* taskTable  *Tabular*
    task_table = Field(type=list, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskGetListResponse21(OCIResponse):
    """
    Response to ``ServiceProviderServicePackMigrationTaskGetListRequest21()``.

    Contains a table with a row for each service pack migration task and column headings :
    "Start Timestamp Milliseconds", "Name", "Status", "Error Count", "Users Processed",
    "Users Total". The start timestamp column is the number of milliseconds since the
    standard base time known as "the epoch", namely January 1, 1970, 00:00:00 GMT. The
    status column is the task status which can be Awaiting edit, Pending, Processing,
    Terminating, Terminated, Stopped by system, Completed, or Expired.
    """

    _ELEMENTS = (
        E("task_table", "taskTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* taskTable  *Tabular*
    task_table = Field(type=list, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderServicePackMigrationTaskGetRequest()``.

    The groupTable column headings are: "Migrate", "Group Id", "Group Name", "User Count".

    Replaced By: ``ServiceProviderServicePackMigrationTaskGetResponse14sp4()``
    """

    _ELEMENTS = (
        E("task_name", "taskName", str, is_required=True),
        E("start_timestamp", "startTimestamp", str),
        E("max_duration_hours", "maxDurationHours", int, is_required=True),
        E("send_report_email", "sendReportEmail", bool, is_required=True),
        E("report_delivery_email_address", "reportDeliveryEmailAddress", str),
        E("abort_on_error", "abortOnError", bool, is_required=True),
        E("abort_error_threshold", "abortErrorThreshold", int),
        E("report_all_users", "reportAllUsers", bool, is_required=True),
        E(
            "automatically_increment_service_quantity",
            "automaticallyIncrementServiceQuantity", bool, is_required=True,
        ),
        E("error_count", "errorCount", int, is_required=True),
        E("status", "status", str, is_required=True),
        E("groups_processed", "groupsProcessed", int, is_required=True),
        E("groups_total", "groupsTotal", int, is_required=True),
        E("users_processed", "usersProcessed", int, is_required=True),
        E("users_total", "usersTotal", int, is_required=True),
        E("user_selection_type", "userSelectionType", str, is_required=True),
        E("report_file_path_name", "reportFilePathName", str, is_required=True),
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
        E(
            "user_selection_service_pack_name", "userSelectionServicePackName", str,
            is_array=True,
        ),
        E("user_selection_service_name", "userSelectionServiceName", str, is_array=True),
        E("remove_service_pack_name", "removeServicePackName", str, is_array=True),
        E("remove_service_name", "removeServiceName", str, is_array=True),
        E("assign_service_pack_name", "assignServicePackName", str, is_array=True),
        E("assign_service_name", "assignServiceName", str, is_array=True),
    )

    #: str: *Required* taskName
    task_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* startTimestamp
    start_timestamp = Field(type=str, required=False, mutable=False)
    #: int: *Required* maxDurationHours
    max_duration_hours = Field(type=int, required=True, mutable=False)
    #: bool: *Required* sendReportEmail
    send_report_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* reportDeliveryEmailAddress
    report_delivery_email_address = Field(type=str, required=False, mutable=False)
    #: bool: *Required* abortOnError
    abort_on_error = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* abortErrorThreshold
    abort_error_threshold = Field(type=int, required=False, mutable=False)
    #: bool: *Required* reportAllUsers
    report_all_users = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* automaticallyIncrementServiceQuantity
    automatically_increment_service_quantity = Field(type=bool, required=True, mutable=False)
    #: int: *Required* errorCount
    error_count = Field(type=int, required=True, mutable=False)
    #: str: *Required* status
    status = Field(type=str, required=True, mutable=False)
    #: int: *Required* groupsProcessed
    groups_processed = Field(type=int, required=True, mutable=False)
    #: int: *Required* groupsTotal
    groups_total = Field(type=int, required=True, mutable=False)
    #: int: *Required* usersProcessed
    users_processed = Field(type=int, required=True, mutable=False)
    #: int: *Required* usersTotal
    users_total = Field(type=int, required=True, mutable=False)
    #: str: *Required* userSelectionType
    user_selection_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* reportFilePathName
    report_file_path_name = Field(type=str, required=True, mutable=False)
    #: list: *Required* groupTable  *Tabular*
    group_table = Field(type=list, required=True, mutable=False)
    #: list(str): *Optional* userSelectionServicePackName  *Array*
    user_selection_service_pack_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* userSelectionServiceName  *Array*
    user_selection_service_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* removeServicePackName  *Array*
    remove_service_pack_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* removeServiceName  *Array*
    remove_service_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* assignServicePackName  *Array*
    assign_service_pack_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* assignServiceName  *Array*
    assign_service_name = Field(type=list, required=False, mutable=False)


class ServiceProviderServicePackMigrationTaskGetResponse14sp4(OCIResponse):
    """
    Response to ``ServiceProviderServicePackMigrationTaskGetRequest14sp4()``.

    The groupTable column headings are: "Group Id", "Group Name", "User Count".
    """

    _ELEMENTS = (
        E("task_name", "taskName", str, is_required=True),
        E("start_timestamp", "startTimestamp", str),
        E("max_duration_hours", "maxDurationHours", int, is_required=True),
        E("send_report_email", "sendReportEmail", bool, is_required=True),
        E("report_delivery_email_address", "reportDeliveryEmailAddress", str),
        E("abort_on_error", "abortOnError", bool, is_required=True),
        E("abort_error_threshold", "abortErrorThreshold", int),
        E("report_all_users", "reportAllUsers", bool, is_required=True),
        E(
            "automatically_increment_service_quantity",
            "automaticallyIncrementServiceQuantity", bool, is_required=True,
        ),
        E("error_count", "errorCount", int, is_required=True),
        E("status", "status", str, is_required=True),
        E("groups_processed", "groupsProcessed", int, is_required=True),
        E("groups_total", "groupsTotal", int, is_required=True),
        E("users_processed", "usersProcessed", int, is_required=True),
        E("users_total", "usersTotal", int, is_required=True),
        E("user_selection_type", "userSelectionType", str, is_required=True),
        E("report_file_path_name", "reportFilePathName", str, is_required=True),
        E("migrate_all_groups", "migrateAllGroups", bool),
        E("group_table", "groupTable", list, is_complex=True, is_table=True),
        E(
            "user_selection_service_pack_name", "userSelectionServicePackName", str,
            is_array=True,
        ),
        E("user_selection_service_name", "userSelectionServiceName", str, is_array=True),
        E("remove_service_pack_name", "removeServicePackName", str, is_array=True),
        E("remove_service_name", "removeServiceName", str, is_array=True),
        E("assign_service_pack_name", "assignServicePackName", str, is_array=True),
        E("assign_service_name", "assignServiceName", str, is_array=True),
    )

    #: str: *Required* taskName
    task_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* startTimestamp
    start_timestamp = Field(type=str, required=False, mutable=False)
    #: int: *Required* maxDurationHours
    max_duration_hours = Field(type=int, required=True, mutable=False)
    #: bool: *Required* sendReportEmail
    send_report_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* reportDeliveryEmailAddress
    report_delivery_email_address = Field(type=str, required=False, mutable=False)
    #: bool: *Required* abortOnError
    abort_on_error = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* abortErrorThreshold
    abort_error_threshold = Field(type=int, required=False, mutable=False)
    #: bool: *Required* reportAllUsers
    report_all_users = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* automaticallyIncrementServiceQuantity
    automatically_increment_service_quantity = Field(type=bool, required=True, mutable=False)
    #: int: *Required* errorCount
    error_count = Field(type=int, required=True, mutable=False)
    #: str: *Required* status
    status = Field(type=str, required=True, mutable=False)
    #: int: *Required* groupsProcessed
    groups_processed = Field(type=int, required=True, mutable=False)
    #: int: *Required* groupsTotal
    groups_total = Field(type=int, required=True, mutable=False)
    #: int: *Required* usersProcessed
    users_processed = Field(type=int, required=True, mutable=False)
    #: int: *Required* usersTotal
    users_total = Field(type=int, required=True, mutable=False)
    #: str: *Required* userSelectionType
    user_selection_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* reportFilePathName
    report_file_path_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* migrateAllGroups
    migrate_all_groups = Field(type=bool, required=False, mutable=False)
    #: list: *Optional* groupTable  *Tabular*
    group_table = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* userSelectionServicePackName  *Array*
    user_selection_service_pack_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* userSelectionServiceName  *Array*
    user_selection_service_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* removeServicePackName  *Array*
    remove_service_pack_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* removeServiceName  *Array*
    remove_service_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* assignServicePackName  *Array*
    assign_service_pack_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* assignServiceName  *Array*
    assign_service_name = Field(type=list, required=False, mutable=False)


class ServiceProviderServicePackMigrationTaskGetResponse21(OCIResponse):
    """
    Response to ``ServiceProviderServicePackMigrationTaskGetRequest21()``.

    The groupTable column headings are: "Group Id", "Group Name", and "User Count".
    """

    _ELEMENTS = (
        E("task_name", "taskName", str, is_required=True),
        E("start_timestamp", "startTimestamp", str),
        E("actual_start_timestamp", "actualStartTimestamp", str),
        E("expire_after_num_hours", "expireAfterNumHours", int, is_required=True),
        E("max_duration_hours", "maxDurationHours", int, is_required=True),
        E("send_report_email", "sendReportEmail", bool, is_required=True),
        E("report_delivery_email_address", "reportDeliveryEmailAddress", str),
        E("abort_on_error", "abortOnError", bool, is_required=True),
        E("abort_error_threshold", "abortErrorThreshold", int),
        E("report_all_users", "reportAllUsers", bool, is_required=True),
        E(
            "automatically_increment_service_quantity",
            "automaticallyIncrementServiceQuantity", bool, is_required=True,
        ),
        E("error_count", "errorCount", int, is_required=True),
        E("status", "status", str, is_required=True),
        E("groups_processed", "groupsProcessed", int, is_required=True),
        E("groups_total", "groupsTotal", int, is_required=True),
        E("users_processed", "usersProcessed", int, is_required=True),
        E("users_total", "usersTotal", int, is_required=True),
        E("user_selection_type", "userSelectionType", str, is_required=True),
        E("report_file_path_name", "reportFilePathName", str, is_required=True),
        E("migrate_all_groups", "migrateAllGroups", bool),
        E("group_table", "groupTable", list, is_complex=True, is_table=True),
        E(
            "user_selection_service_pack_name", "userSelectionServicePackName", str,
            is_array=True,
        ),
        E("user_selection_service_name", "userSelectionServiceName", str, is_array=True),
        E("remove_service_pack_name", "removeServicePackName", str, is_array=True),
        E("remove_service_name", "removeServiceName", str, is_array=True),
        E("assign_service_pack_name", "assignServicePackName", str, is_array=True),
        E("assign_service_name", "assignServiceName", str, is_array=True),
    )

    #: str: *Required* taskName
    task_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* startTimestamp
    start_timestamp = Field(type=str, required=False, mutable=False)
    #: str: *Optional* actualStartTimestamp
    actual_start_timestamp = Field(type=str, required=False, mutable=False)
    #: int: *Required* expireAfterNumHours
    expire_after_num_hours = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxDurationHours
    max_duration_hours = Field(type=int, required=True, mutable=False)
    #: bool: *Required* sendReportEmail
    send_report_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* reportDeliveryEmailAddress
    report_delivery_email_address = Field(type=str, required=False, mutable=False)
    #: bool: *Required* abortOnError
    abort_on_error = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* abortErrorThreshold
    abort_error_threshold = Field(type=int, required=False, mutable=False)
    #: bool: *Required* reportAllUsers
    report_all_users = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* automaticallyIncrementServiceQuantity
    automatically_increment_service_quantity = Field(type=bool, required=True, mutable=False)
    #: int: *Required* errorCount
    error_count = Field(type=int, required=True, mutable=False)
    #: str: *Required* status
    status = Field(type=str, required=True, mutable=False)
    #: int: *Required* groupsProcessed
    groups_processed = Field(type=int, required=True, mutable=False)
    #: int: *Required* groupsTotal
    groups_total = Field(type=int, required=True, mutable=False)
    #: int: *Required* usersProcessed
    users_processed = Field(type=int, required=True, mutable=False)
    #: int: *Required* usersTotal
    users_total = Field(type=int, required=True, mutable=False)
    #: str: *Required* userSelectionType
    user_selection_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* reportFilePathName
    report_file_path_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* migrateAllGroups
    migrate_all_groups = Field(type=bool, required=False, mutable=False)
    #: list: *Optional* groupTable  *Tabular*
    group_table = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* userSelectionServicePackName  *Array*
    user_selection_service_pack_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* userSelectionServiceName  *Array*
    user_selection_service_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* removeServicePackName  *Array*
    remove_service_pack_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* removeServiceName  *Array*
    remove_service_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* assignServicePackName  *Array*
    assign_service_pack_name = Field(type=list, required=False, mutable=False)
    #: list(str): *Optional* assignServiceName  *Array*
    assign_service_name = Field(type=list, required=False, mutable=False)


class ServiceProviderServicePhoneNumberLookupResponse(OCIResponse):
    """
    Response to the ``ServiceProviderServicePhoneNumberLookupRequest()``.

    The column headings for the userTable are: "Group Id", "User Id", "Last Name", "First
    Name", "Hiragana Last Name", "Hiragana First Name", "Phone Number", "Extension" and
    "Department".
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* userTable  *Tabular*
    user_table = Field(type=list, required=True, mutable=False)


class ServiceProviderSessionAdmissionControlGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderSessionAdmissionControlGetRequest()``.

    The response contains the session admission control capacity allocated for the service
    provider.
    """

    _ELEMENTS = (
        E("restrict_aggregate_sessions", "restrictAggregateSessions", bool, is_required=True),
        E("max_sessions", "maxSessions", int),
        E("max_user_originating_sessions", "maxUserOriginatingSessions", int),
        E("max_user_terminating_sessions", "maxUserTerminatingSessions", int),
        E(
            "count_intra_service_provider_sessions", "countIntraServiceProviderSessions",
            bool, is_required=True,
        ),
    )

    #: bool: *Required* restrictAggregateSessions
    restrict_aggregate_sessions = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* maxSessions
    max_sessions = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxUserOriginatingSessions
    max_user_originating_sessions = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxUserTerminatingSessions
    max_user_terminating_sessions = Field(type=int, required=False, mutable=False)
    #: bool: *Required* countIntraServiceProviderSessions
    count_intra_service_provider_sessions = Field(type=bool, required=True, mutable=False)


class ServiceProviderSessionAdmissionControlWhiteListGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderSessionAdmissionControlWhiteListGetRequest()``.

    The response contains the White List information.
    """

    _ELEMENTS = (
        E("match_digit_pattern", "matchDigitPattern", str, is_array=True),
        E("enable_white_list", "enableWhiteList", bool, is_required=True),
    )

    #: list(str): *Optional* matchDigitPattern  *Array*
    match_digit_pattern = Field(type=list, required=False, mutable=False)
    #: bool: *Required* enableWhiteList
    enable_white_list = Field(type=bool, required=True, mutable=False)


class ServiceProviderVoiceMessagingGroupGetPasscodeRulesResponse(OCIResponse):
    """
    Response to ``ServiceProviderVoiceMessagingGroupGetPasscodeRulesRequest()``.

    Contains the service provider's voice portal passcode rules setting.

    Replaced By: ``ServiceProviderPortalPasscodeRulesGetResponse()``
    """

    _ELEMENTS = (
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool, is_required=True),
        E("disallow_user_number", "disallowUserNumber", bool, is_required=True),
        E(
            "disallow_reversed_user_number", "disallowReversedUserNumber", bool,
            is_required=True,
        ),
        E("disallow_old_passcode", "disallowOldPasscode", bool, is_required=True),
        E(
            "disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool,
            is_required=True,
        ),
        E("min_code_length", "minCodeLength", int, is_required=True),
        E("max_code_length", "maxCodeLength", int, is_required=True),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool, is_required=True,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool, is_required=True),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    #: bool: *Required* disallowRepeatedDigits
    disallow_repeated_digits = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowUserNumber
    disallow_user_number = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowReversedUserNumber
    disallow_reversed_user_number = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowOldPasscode
    disallow_old_passcode = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(type=bool, required=True, mutable=False)
    #: int: *Required* minCodeLength
    min_code_length = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxCodeLength
    max_code_length = Field(type=int, required=True, mutable=False)
    #: bool: *Required* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(type=int, required=False, mutable=False)
    #: bool: *Required* expirePassword
    expire_password = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(type=int, required=False, mutable=False)
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(type=str, required=False, mutable=False)


class ServiceProviderVoiceMessagingGroupGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderVoiceMessagingGroupGetRequest()``.

    Contains the service provider's or enterprise's voice messaging settings.
    """

    _ELEMENTS = (
        E("delivery_from_address", "deliveryFromAddress", str),
        E("notification_from_address", "notificationFromAddress", str),
        E("voice_portal_lockout_from_address", "voicePortalLockoutFromAddress", str),
        E(
            "use_system_default_delivery_from_address",
            "useSystemDefaultDeliveryFromAddress", bool, is_required=True,
        ),
        E(
            "use_system_default_notification_from_address",
            "useSystemDefaultNotificationFromAddress", bool, is_required=True,
        ),
        E(
            "use_system_default_voice_portal_lockout_from_address",
            "useSystemDefaultVoicePortalLockoutFromAddress", bool, is_required=True,
        ),
    )

    #: str: *Optional* deliveryFromAddress
    delivery_from_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* notificationFromAddress
    notification_from_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* voicePortalLockoutFromAddress
    voice_portal_lockout_from_address = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useSystemDefaultDeliveryFromAddress
    use_system_default_delivery_from_address = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useSystemDefaultNotificationFromAddress
    use_system_default_notification_from_address = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useSystemDefaultVoicePortalLockoutFromAddress
    use_system_default_voice_portal_lockout_from_address = Field(
        type=bool, required=True, mutable=False,
    )


class ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingResponse(OCIResponse):
    """
    Response to the ``ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingRequest()``.

    Replaced By: ``ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingResponse16()``
    """

    _ELEMENTS = (
        E(
            "voice_portal_greeting_selection", "voicePortalGreetingSelection", str,
            is_required=True,
        ),
        E(
            "voice_portal_greeting_file_description",
            "voicePortalGreetingFileDescription", str,
        ),
        E(
            "voice_messaging_greeting_selection", "voiceMessagingGreetingSelection", str,
            is_required=True,
        ),
        E(
            "voice_messaging_greeting_file_description",
            "voiceMessagingGreetingFileDescription", str,
        ),
    )

    #: str: *Required* voicePortalGreetingSelection
    voice_portal_greeting_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* voicePortalGreetingFileDescription
    voice_portal_greeting_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Required* voiceMessagingGreetingSelection
    voice_messaging_greeting_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* voiceMessagingGreetingFileDescription
    voice_messaging_greeting_file_description = Field(type=str, required=False, mutable=False)


class ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingResponse16(OCIResponse):
    """
    Response to the
    ``ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingRequest16()``.

    """

    _ELEMENTS = (
        E(
            "voice_portal_greeting_selection", "voicePortalGreetingSelection", str,
            is_required=True,
        ),
        E(
            "voice_portal_greeting_file_description",
            "voicePortalGreetingFileDescription", str,
        ),
        E("voice_portal_greeting_media_file_type", "voicePortalGreetingMediaFileType", str),
        E(
            "voice_messaging_greeting_selection", "voiceMessagingGreetingSelection", str,
            is_required=True,
        ),
        E(
            "voice_messaging_greeting_file_description",
            "voiceMessagingGreetingFileDescription", str,
        ),
        E(
            "voice_messaging_greeting_media_file_type",
            "voiceMessagingGreetingMediaFileType", str,
        ),
    )

    #: str: *Required* voicePortalGreetingSelection
    voice_portal_greeting_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* voicePortalGreetingFileDescription
    voice_portal_greeting_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* voicePortalGreetingMediaFileType
    voice_portal_greeting_media_file_type = Field(type=str, required=False, mutable=False)
    #: str: *Required* voiceMessagingGreetingSelection
    voice_messaging_greeting_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* voiceMessagingGreetingFileDescription
    voice_messaging_greeting_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* voiceMessagingGreetingMediaFileType
    voice_messaging_greeting_media_file_type = Field(type=str, required=False, mutable=False)


class ServiceProviderVoiceMessagingGroupGetVoicePortalResponse(OCIResponse):
    """
    Response to ``ServiceProviderVoiceMessagingGroupGetVoicePortalRequest()``.

    """

    _ELEMENTS = (
        E("voice_portal_scope", "voicePortalScope", str, is_required=True),
    )

    #: str: *Required* voicePortalScope
    voice_portal_scope = Field(type=str, required=True, mutable=False)


class ServiceProviderZoneCallingRestrictionsGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderZoneCallingRestrictionsGetRequest()``
    """

    _ELEMENTS = (
        E(
            "enable_zone_calling_restrictions", "enableZoneCallingRestrictions", bool,
            is_required=True,
        ),
        E(
            "enable_origination_roaming_restrictions",
            "enableOriginationRoamingRestrictions", bool, is_required=True,
        ),
        E(
            "enable_emergency_origination_roaming_restrictions",
            "enableEmergencyOriginationRoamingRestrictions", bool, is_required=True,
        ),
        E(
            "enable_termination_roaming_restrictions",
            "enableTerminationRoamingRestrictions", bool, is_required=True,
        ),
    )

    #: bool: *Required* enableZoneCallingRestrictions
    enable_zone_calling_restrictions = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableOriginationRoamingRestrictions
    enable_origination_roaming_restrictions = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableEmergencyOriginationRoamingRestrictions
    enable_emergency_origination_roaming_restrictions = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableTerminationRoamingRestrictions
    enable_termination_roaming_restrictions = Field(type=bool, required=True, mutable=False)


class SystemASRParametersGetResponse(OCIResponse):
    """
    Response to ``SystemASRParametersGetRequest()``.

    Contains a list of system Application Server Registration parameters.

    Replaced By: ``SystemASRParametersGetResponse14sp5()``
    """

    _ELEMENTS = (
        E("max_transmissions", "maxTransmissions", int, is_required=True),
        E(
            "retransmission_delay_milli_seconds", "retransmissionDelayMilliSeconds", int,
            is_required=True,
        ),
        E("listening_port", "listeningPort", int, is_required=True),
    )

    #: int: *Required* maxTransmissions
    max_transmissions = Field(type=int, required=True, mutable=False)
    #: int: *Required* retransmissionDelayMilliSeconds
    retransmission_delay_milli_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* listeningPort
    listening_port = Field(type=int, required=True, mutable=False)


class SystemASRParametersGetResponse14sp5(OCIResponse):
    """
    Response to ``SystemASRParametersGetRequest14sp5()``.

    Contains a list of system Application Server Registration parameters.
    """

    _ELEMENTS = (
        E("max_transmissions", "maxTransmissions", int, is_required=True),
        E(
            "retransmission_delay_milli_seconds", "retransmissionDelayMilliSeconds", int,
            is_required=True,
        ),
        E("listening_port", "listeningPort", int, is_required=True),
        E("source_address", "sourceAddress", str),
    )

    #: int: *Required* maxTransmissions
    max_transmissions = Field(type=int, required=True, mutable=False)
    #: int: *Required* retransmissionDelayMilliSeconds
    retransmission_delay_milli_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* listeningPort
    listening_port = Field(type=int, required=True, mutable=False)
    #: str: *Optional* sourceAddress
    source_address = Field(type=str, required=False, mutable=False)


class SystemASRParametersGetResponse14sp7(OCIResponse):
    """
    Response to ``SystemASRParametersGetRequest14sp7()``.

    Contains a list of system Application Server Registration parameters.
    """

    _ELEMENTS = (
        E("max_transmissions", "maxTransmissions", int, is_required=True),
        E(
            "retransmission_delay_milli_seconds", "retransmissionDelayMilliSeconds", int,
            is_required=True,
        ),
        E("listening_port", "listeningPort", int, is_required=True),
    )

    #: int: *Required* maxTransmissions
    max_transmissions = Field(type=int, required=True, mutable=False)
    #: int: *Required* retransmissionDelayMilliSeconds
    retransmission_delay_milli_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* listeningPort
    listening_port = Field(type=int, required=True, mutable=False)


class SystemAccessDeviceCustomTagGetListResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceCustomTagGetListRequest()``.

    Contains a table of custom configuration tags managed by the Device Management System
    on a per-device profile basis.  The column headings are: "Tag Name", "Tag Value"
    """

    _ELEMENTS = (
        E(
            "device_custom_tags_table", "deviceCustomTagsTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* deviceCustomTagsTable  *Tabular*
    device_custom_tags_table = Field(type=list, required=True, mutable=False)


class SystemAccessDeviceFileGetListResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceFileGetListRequest()``.

    Contains a table of device files managed by the Device Management System on a per-
    device profile basis.  The column headings are: "File Type", "File Format", "Is
    Authenticated".

    Replaced By: ``SystemAccessDeviceFileGetListResponse14sp8()``
    """

    _ELEMENTS = (
        E(
            "device_files_table", "deviceFilesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* deviceFilesTable  *Tabular*
    device_files_table = Field(type=list, required=True, mutable=False)


class SystemAccessDeviceFileGetListResponse14sp8(OCIResponse):
    """
    Response to ``SystemAccessDeviceFileGetListRequest14sp8()``.

    Contains a table of device files managed by the Device Management System on a per-
    device profile basis.  The column headings are: "File Format", "Is Authenticated",
    "Access URL", "Repository URL", "Template URL", "Extended Capture". The following
    columns are only used in AS data mode: "Extended Capture"
    """

    _ELEMENTS = (
        E(
            "device_files_table", "deviceFilesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* deviceFilesTable  *Tabular*
    device_files_table = Field(type=list, required=True, mutable=False)


class SystemAccessDeviceFileGetResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceFileGetRequest()``.

    Replaced By: ``SystemAccessDeviceFileGetResponse14sp8()``
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
    )

    #: str: *Required* fileSource
    file_source = Field(type=str, required=True, mutable=False)
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(type=str, required=False, mutable=False)


class SystemAccessDeviceFileGetResponse14sp8(OCIResponse):
    """
    Response to ``SystemAccessDeviceFileGetRequest14sp8()``.

    Replaced by: ``SystemAccessDeviceFileGetResponse16sp1()``
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
    )

    #: str: *Required* fileSource
    file_source = Field(type=str, required=True, mutable=False)
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(type=str, required=False, mutable=False)


class SystemAccessDeviceFileGetResponse16sp1(OCIResponse):
    """
    Response to ``SystemAccessDeviceFileGetRequest16sp1()``.

    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
        E("access_url", "accessUrl", str, is_required=True),
        E("repository_url", "repositoryUrl", str),
        E("template_url", "templateUrl", str),
    )

    #: str: *Required* fileSource
    file_source = Field(type=str, required=True, mutable=False)
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* accessUrl
    access_url = Field(type=str, required=True, mutable=False)
    #: str: *Optional* repositoryUrl
    repository_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* templateUrl
    template_url = Field(type=str, required=False, mutable=False)


class SystemAccessDeviceFileGetResponse20(OCIResponse):
    """
    Response to ``SystemAccessDeviceFileGetRequest20()``.

    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
        E("access_url", "accessUrl", str, is_required=True),
        E("repository_url", "repositoryUrl", str),
        E("template_url", "templateUrl", str),
        E("extended_capture_enabled", "extendedCaptureEnabled", bool),
        E("extended_capture_url", "extendedCaptureURL", str),
    )

    #: str: *Required* fileSource
    file_source = Field(type=str, required=True, mutable=False)
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* accessUrl
    access_url = Field(type=str, required=True, mutable=False)
    #: str: *Optional* repositoryUrl
    repository_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* templateUrl
    template_url = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* extendedCaptureEnabled
    extended_capture_enabled = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* extendedCaptureURL
    extended_capture_url = Field(type=str, required=False, mutable=False)


class SystemAccessDeviceGetAllResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceGetAllRequest()``.

    Contains a table of devices configured in the entire system.  The column headings are:
    "Service Provider Id", "Is Enterprise", "Group Id", "Device Name", "Device Type", "Net
    Address", "MAC Address", "Status".
    """

    _ELEMENTS = (
        E(
            "access_device_table", "accessDeviceTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* accessDeviceTable  *Tabular*
    access_device_table = Field(type=list, required=True, mutable=False)


class SystemAccessDeviceGetListResponse14(OCIResponse):
    """
    Response to ``SystemAccessDeviceGetListRequest14()``.

    Contains a table of devices defined at the System-level.  The column headings are:
    "Device Name", "Device Type", "Available Ports", "Net Address" and "MAC Address",
    "Status", "Version".
    """

    _ELEMENTS = (
        E(
            "access_device_table", "accessDeviceTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* accessDeviceTable  *Tabular*
    access_device_table = Field(type=list, required=True, mutable=False)


class SystemAccessDeviceGetUserListResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceGetUserListRequest()``.

    The column headings for the deviceUserTable are: "Line/Port", "Last Name", "First
    Name", "Phone Number", "Service Provider Id", "Group Id", "User Id", "User Type",
    "Endpoint Type", "Primary Line/Port", "Order", "Extension", "Department", "Email
    Address", "Private Identity". If the identity/device profile is an identity, the table
    will contain a row for each TEL-URI in the Phone Number column.  If the
    identity/device profile is a real device, rows for the alternate numbers are not
    included.  The User Type column contains one of the enumerated UserType values.  The
    Endpoint Type column contains one of the enumerated EndpointType values.  The Private
    Identity column is empty is AS mode.
    """

    _ELEMENTS = (
        E(
            "device_user_table", "deviceUserTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* deviceUserTable  *Tabular*
    device_user_table = Field(type=list, required=True, mutable=False)


class SystemAccessDeviceMonitorGetDeviceTypeListResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceMonitorGetDeviceTypeListRequest()``.

    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_array=True),
    )

    #: list(str): *Optional* deviceType  *Array*
    device_type = Field(type=list, required=False, mutable=False)


class SystemAccessDeviceMonitorParametersGetResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceMonitorParametersGetListRequest()``.

    Contains a list of system Access Device Monitor parameters.
    """

    _ELEMENTS = (
        E("polling_interval_minutes", "pollingIntervalMinutes", int, is_required=True),
    )

    #: int: *Required* pollingIntervalMinutes
    polling_interval_minutes = Field(type=int, required=True, mutable=False)


class SystemAccessDeviceTypeGetEnhancedConfigurableListResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceTypeGetEnhancedConfigurableListRequest()``.

    Contains a table with columns: "Access Device Type", "Enhanced Configuration Type",
    "Supports Reset". The "Enhanced Configuration Type" column contains one of the
    AccessDeviceEnhancedConfigurationType14 enumerated values.  The "Supports Reset"
    column is a boolean flag indicating the device can be remotely reset.
    """

    _ELEMENTS = (
        E(
            "device_type_table", "deviceTypeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* deviceTypeTable  *Tabular*
    device_type_table = Field(type=list, required=True, mutable=False)


class SystemAccessDeviceTypeGetListResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceTypeGetListRequest()``.

    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
    )

    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)


class SystemAccountingGetChargingFunctionElementServerListResponse(OCIResponse):
    """
    Response to ``SystemAccountingGetChargingFunctionElementServerListRequest()``.

    The accounting charging function element Server table column headings are: "Address",
    "Extended Net Address", "Type", "Description".
    """

    _ELEMENTS = (
        E(
            "charging_function_element_server_table",
            "chargingFunctionElementServerTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: list: *Required* chargingFunctionElementServerTable  *Tabular*
    charging_function_element_server_table = Field(type=list, required=True, mutable=False)


class SystemAccountingGetRadiusServerListResponse(OCIResponse):
    """
    Response to ``SystemAccountingGetRadiusServerListRequest()``.

    The Radius Server table column headings are: "Net Address", "Port", "Description"
    """

    _ELEMENTS = (
        E(
            "radius_server_table", "radiusServerTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* radiusServerTable  *Tabular*
    radius_server_table = Field(type=list, required=True, mutable=False)


class SystemAccountingInhibitedAttributeValuePairCodeGetListResponse(OCIResponse):
    """
    Response to ``SystemAccountingInhibitedAttributeValuePairCodeGetListRequest()``.

    Contains a 2 column table with column headings "Attribute Value Pair Code" and "Vendor
    Id".
    """

    _ELEMENTS = (
        E(
            "inhibited_attribute_value_pair_code_table",
            "inhibitedAttributeValuePairCodeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* inhibitedAttributeValuePairCodeTable  *Tabular*
    inhibited_attribute_value_pair_code_table = Field(type=list, required=True, mutable=False)


class SystemAdminGetListResponse(OCIResponse):
    """
    Response to ``SystemAdminGetListRequest()``.

    Contains a 6 column table with column headings "Administrator ID", "Last Name", "First
    Name", "Type", "Read Only", "Language".
    """

    _ELEMENTS = (
        E(
            "system_admin_table", "systemAdminTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* systemAdminTable  *Tabular*
    system_admin_table = Field(type=list, required=True, mutable=False)


class SystemAdminGetResponse(OCIResponse):
    """
    Response to the ``SystemAdminGetRequest()``.

    The response contains the system or provisioning administrators profile information.
    """

    _ELEMENTS = (
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("language", "language", str, is_required=True),
        E("admin_type", "adminType", str, is_required=True),
        E("read_only", "readOnly", bool, is_required=True),
    )

    #: str: *Optional* firstName
    first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* lastName
    last_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* language
    language = Field(type=str, required=True, mutable=False)
    #: str: *Required* adminType
    admin_type = Field(type=str, required=True, mutable=False)
    #: bool: *Required* readOnly
    read_only = Field(type=bool, required=True, mutable=False)


class SystemAdviceOfChargeCostInformationSourceGetListResponse(OCIResponse):
    """
    Response to ``SystemAdviceOfChargeCostInformationSourceGetListRequest()``.

    Contains a table with column headings: "PeerIdentity", "Priority"
    """

    _ELEMENTS = (
        E(
            "cost_information_source_table", "costInformationSourceTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* costInformationSourceTable  *Tabular*
    cost_information_source_table = Field(type=list, required=True, mutable=False)


class SystemAdviceOfChargeGetResponse(OCIResponse):
    """
    Response to ``SystemAdviceOfChargeGetRequest()``.

    Contains a list of system Advice of Charge parameters.
    """

    _ELEMENTS = (
        E(
            "delay_between_notification_seconds", "delayBetweenNotificationSeconds", int,
            is_required=True,
        ),
        E("incoming_aoc_handling", "incomingAocHandling", str, is_required=True),
        E("cost_information_source", "costInformationSource", str),
    )

    #: int: *Required* delayBetweenNotificationSeconds
    delay_between_notification_seconds = Field(type=int, required=True, mutable=False)
    #: str: *Required* incomingAocHandling
    incoming_aoc_handling = Field(type=str, required=True, mutable=False)
    #: str: *Optional* costInformationSource
    cost_information_source = Field(type=str, required=False, mutable=False)


class SystemAdviceOfChargeGetResponse19sp1(OCIResponse):
    """
    Response to ``SystemAdviceOfChargeGetRequest()``.

    Contains a list of system Advice of Charge parameters.
    """

    _ELEMENTS = (
        E(
            "delay_between_notification_seconds", "delayBetweenNotificationSeconds", int,
            is_required=True,
        ),
        E("incoming_aoc_handling", "incomingAocHandling", str, is_required=True),
        E("use_ocs_enquiry", "useOCSEnquiry", bool, is_required=True),
        E("ocs_enquiry_type", "OCSEnquiryType", str, is_required=True),
    )

    #: int: *Required* delayBetweenNotificationSeconds
    delay_between_notification_seconds = Field(type=int, required=True, mutable=False)
    #: str: *Required* incomingAocHandling
    incoming_aoc_handling = Field(type=str, required=True, mutable=False)
    #: bool: *Required* useOCSEnquiry
    use_ocs_enquiry = Field(type=bool, required=True, mutable=False)
    #: str: *Required* OCSEnquiryType
    ocs_enquiry_type = Field(type=str, required=True, mutable=False)


class SystemAliasGetListResponse(OCIResponse):
    """
    Response to ``SystemAliasGetListRequest()``.

    Contains the list of all network alias' for the Application Server.
    """

    _ELEMENTS = (
        E("alias_net_address", "aliasNetAddress", str, is_array=True),
    )

    #: list(str): *Optional* aliasNetAddress  *Array*
    alias_net_address = Field(type=list, required=False, mutable=False)


class SystemAnonymousCallRejectionGetResponse(OCIResponse):
    """
    Response to the ``SystemAnonymousCallRejectionGetRequest()``.

    The response contains the anonymous call rejection system.".
    """

    _ELEMENTS = (
        E("pai_required", "paiRequired", bool, is_required=True),
        E("screen_only_local_calls", "screenOnlyLocalCalls", bool, is_required=True),
    )

    #: bool: *Required* paiRequired
    pai_required = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* screenOnlyLocalCalls
    screen_only_local_calls = Field(type=bool, required=True, mutable=False)


class SystemApplicationControllerGetListResponse(OCIResponse):
    """
    Response to the ``SystemApplicationControllerGetListRequest()``.

    Contains a table with column headings: "Name", "Subscriber Id", "Channel Set Id",
    "Status". The column values for "Status" can either be "ready" or "notReady".
    """

    _ELEMENTS = (
        E(
            "application_controller_table", "applicationControllerTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    #: list: *Required* applicationControllerTable  *Tabular*
    application_controller_table = Field(type=list, required=True, mutable=False)


class SystemAttendantConsoleGetResponse(OCIResponse):
    """
    Response to ``SystemAttendantConsoleGetRequest()``.

    Contains a list of Attendant Console parameters.
    """

    _ELEMENTS = (
        E("max_monitored_users", "maxMonitoredUsers", int, is_required=True),
    )

    #: int: *Required* maxMonitoredUsers
    max_monitored_users = Field(type=int, required=True, mutable=False)


class SystemAuthenticationLockoutSettingsGetResponse(OCIResponse):
    """
    Response to ``SystemAuthenticationLockoutSettingsGetRequest()``.

    Contains the authentication lockout settings in the system.
    """

    _ELEMENTS = (
        E("counter_reset_interval_days", "counterResetIntervalDays", int, is_required=True),
        E("counter_reset_hour", "counterResetHour", int, is_required=True),
        E("counter_reset_minute", "counterResetMinute", int, is_required=True),
        E(
            "emergency_sip_bypass_allowed", "emergencySIPBypassAllowed", bool,
            is_required=True,
        ),
    )

    #: int: *Required* counterResetIntervalDays
    counter_reset_interval_days = Field(type=int, required=True, mutable=False)
    #: int: *Required* counterResetHour
    counter_reset_hour = Field(type=int, required=True, mutable=False)
    #: int: *Required* counterResetMinute
    counter_reset_minute = Field(type=int, required=True, mutable=False)
    #: bool: *Required* emergencySIPBypassAllowed
    emergency_sip_bypass_allowed = Field(type=bool, required=True, mutable=False)


class SystemAutomaticCallbackGetReleaseCauseListResponse(OCIResponse):
    """
    Response to ``SystemAutomaticCallbackGetReleaseCauseListRequest()``.

    """

    _ELEMENTS = (
        E("release_cause", "releaseCause", str, is_array=True),
    )

    #: list(str): *Optional* releaseCause  *Array*
    release_cause = Field(type=list, required=False, mutable=False)


class SystemAutomaticCallbackGetResponse(OCIResponse):
    """
    Response to ``SystemAutomaticCallbackGetRequest()``.

    Replaced By: ``SystemAutomaticCallbackGetResponse15()``
    """

    _ELEMENTS = (
        E("monitor_minutes", "monitorMinutes", int, is_required=True),
        E(
            "wait_between_retry_originator_minutes", "waitBetweenRetryOriginatorMinutes",
            int, is_required=True,
        ),
        E("max_monitors_per_originator", "maxMonitorsPerOriginator", int, is_required=True),
        E("max_callback_rings", "maxCallbackRings", int, is_required=True),
        E("max_retry_originator_minutes", "maxRetryOriginatorMinutes", int, is_required=True),
    )

    #: int: *Required* monitorMinutes
    monitor_minutes = Field(type=int, required=True, mutable=False)
    #: int: *Required* waitBetweenRetryOriginatorMinutes
    wait_between_retry_originator_minutes = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxMonitorsPerOriginator
    max_monitors_per_originator = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxCallbackRings
    max_callback_rings = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRetryOriginatorMinutes
    max_retry_originator_minutes = Field(type=int, required=True, mutable=False)


class SystemAutomaticCallbackGetResponse15(OCIResponse):
    """
    Response to ``SystemAutomaticCallbackGetRequest15()``.

    Replaced By: ``SystemAutomaticCallbackGetResponse15sp2()``
    """

    _ELEMENTS = (
        E("monitor_minutes", "monitorMinutes", int, is_required=True),
        E("max_monitors_per_originator", "maxMonitorsPerOriginator", int, is_required=True),
        E("max_callback_rings", "maxCallbackRings", int, is_required=True),
        E("max_monitors_per_terminator", "maxMonitorsPerTerminator", int, is_required=True),
        E(
            "terminator_idle_guard_seconds", "terminatorIdleGuardSeconds", int,
            is_required=True,
        ),
    )

    #: int: *Required* monitorMinutes
    monitor_minutes = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxMonitorsPerOriginator
    max_monitors_per_originator = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxCallbackRings
    max_callback_rings = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxMonitorsPerTerminator
    max_monitors_per_terminator = Field(type=int, required=True, mutable=False)
    #: int: *Required* terminatorIdleGuardSeconds
    terminator_idle_guard_seconds = Field(type=int, required=True, mutable=False)


class SystemAutomaticCallbackGetResponse15sp2(OCIResponse):
    """
    Response to ``SystemAutomaticCallbackGetRequest15sp2()``.

    """

    _ELEMENTS = (
        E("monitor_minutes", "monitorMinutes", int, is_required=True),
        E("max_monitors_per_originator", "maxMonitorsPerOriginator", int, is_required=True),
        E("max_callback_rings", "maxCallbackRings", int, is_required=True),
        E("max_monitors_per_terminator", "maxMonitorsPerTerminator", int, is_required=True),
        E(
            "terminator_idle_guard_seconds", "terminatorIdleGuardSeconds", int,
            is_required=True,
        ),
        E("callback_method", "callbackMethod", str, is_required=True),
        E("polling_interval_seconds", "pollingIntervalSeconds", int, is_required=True),
    )

    #: int: *Required* monitorMinutes
    monitor_minutes = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxMonitorsPerOriginator
    max_monitors_per_originator = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxCallbackRings
    max_callback_rings = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxMonitorsPerTerminator
    max_monitors_per_terminator = Field(type=int, required=True, mutable=False)
    #: int: *Required* terminatorIdleGuardSeconds
    terminator_idle_guard_seconds = Field(type=int, required=True, mutable=False)
    #: str: *Required* callbackMethod
    callback_method = Field(type=str, required=True, mutable=False)
    #: int: *Required* pollingIntervalSeconds
    polling_interval_seconds = Field(type=int, required=True, mutable=False)


class SystemAutomaticCallbackGetResponse17(OCIResponse):
    """
    Response to ``SystemAutomaticCallbackGetRequest17()``.

    """

    _ELEMENTS = (
        E("monitor_minutes", "monitorMinutes", int, is_required=True),
        E("max_monitors_per_originator", "maxMonitorsPerOriginator", int, is_required=True),
        E("max_callback_rings", "maxCallbackRings", int, is_required=True),
        E("max_monitors_per_terminator", "maxMonitorsPerTerminator", int, is_required=True),
        E(
            "terminator_idle_guard_seconds", "terminatorIdleGuardSeconds", int,
            is_required=True,
        ),
        E("callback_method", "callbackMethod", str, is_required=True),
        E("polling_interval_seconds", "pollingIntervalSeconds", int, is_required=True),
        E("activation_digit", "activationDigit", int, is_required=True),
    )

    #: int: *Required* monitorMinutes
    monitor_minutes = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxMonitorsPerOriginator
    max_monitors_per_originator = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxCallbackRings
    max_callback_rings = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxMonitorsPerTerminator
    max_monitors_per_terminator = Field(type=int, required=True, mutable=False)
    #: int: *Required* terminatorIdleGuardSeconds
    terminator_idle_guard_seconds = Field(type=int, required=True, mutable=False)
    #: str: *Required* callbackMethod
    callback_method = Field(type=str, required=True, mutable=False)
    #: int: *Required* pollingIntervalSeconds
    polling_interval_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* activationDigit
    activation_digit = Field(type=int, required=True, mutable=False)


class SystemBCCTGetOCIInterfaceAddressListResponse(OCIResponse):
    """
    Response to ``SystemBCCTGetOCIInterfaceAddressListRequest()``.

    """

    _ELEMENTS = (
        E("interface_net_address", "interfaceNetAddress", str, is_array=True),
    )

    #: list(str): *Optional* interfaceNetAddress  *Array*
    interface_net_address = Field(type=list, required=False, mutable=False)


class SystemBroadCloudGetResponse(OCIResponse):
    """
    Response to the ``SystemBroadCloudGetRequest()``.

    The response contains the system interface attributes for Messaging Server.
    """

    _ELEMENTS = (
        E("provisioning_url", "provisioningUrl", str),
        E("provisioning_user_id", "provisioningUserId", str),
        E("enable_synchronization", "enableSynchronization", bool, is_required=True),
    )

    #: str: *Optional* provisioningUrl
    provisioning_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* provisioningUserId
    provisioning_user_id = Field(type=str, required=False, mutable=False)
    #: bool: *Required* enableSynchronization
    enable_synchronization = Field(type=bool, required=True, mutable=False)


class SystemBroadWorksMobileManagerGetResponse(OCIResponse):
    """
    Response to the ``SystemBroadWorksMobileManagerGetRequest()``
    """

    _ELEMENTS = (
        E("scf_api_net_address1", "scfApiNetAddress1", str),
        E("scf_api_net_address2", "scfApiNetAddress2", str),
        E("user_name", "userName", str),
        E("email_from_address", "emailFromAddress", str),
        E("scf_ims_only", "scfIMSOnly", bool, is_required=True),
        E("signaling_ip_address", "signalingIPAddress", str),
        E("signaling_port", "signalingPort", int),
    )

    #: str: *Optional* scfApiNetAddress1
    scf_api_net_address1 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* scfApiNetAddress2
    scf_api_net_address2 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userName
    user_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* emailFromAddress
    email_from_address = Field(type=str, required=False, mutable=False)
    #: bool: *Required* scfIMSOnly
    scf_ims_only = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* signalingIPAddress
    signaling_ip_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* signalingPort
    signaling_port = Field(type=int, required=False, mutable=False)


class SystemBroadWorksMobilityGetIMRNListResponse(OCIResponse):
    """
    Response to ``SystemBroadWorksMobilityDnGetListRequest()``.

    """

    _ELEMENTS = (
        E("imrn_number", "imrnNumber", str, is_array=True),
    )

    #: list(str): *Optional* imrnNumber  *Array*
    imrn_number = Field(type=list, required=False, mutable=False)


class SystemBroadWorksMobilityGetMobileNetworkIMRNListResponse(OCIResponse):
    """
    Response to ``SystemBroadWorksMobilityGetMobileNetworkIMRNListRequest()``.

    """

    _ELEMENTS = (
        E("imrn_number", "imrnNumber", str, is_array=True),
    )

    #: list(str): *Optional* imrnNumber  *Array*
    imrn_number = Field(type=list, required=False, mutable=False)


class SystemBroadWorksMobilityGetResponse(OCIResponse):
    """
    The response to a ``SystemBroadWorksMobilityGetRequest()``.

    Replaced by: ``SystemBroadWorksMobilityGetResponse17sp4()``.
    """

    _ELEMENTS = (
        E("enable_location_services", "enableLocationServices", bool, is_required=True),
        E("enable_msrn_lookup", "enableMSRNLookup", bool, is_required=True),
        E(
            "enable_mobile_state_checking", "enableMobileStateChecking", bool,
            is_required=True,
        ),
        E("deny_call_originations", "denyCallOriginations", bool, is_required=True),
        E("deny_call_terminations", "denyCallTerminations", bool, is_required=True),
        E("imrn_timeout_millisecnds", "imrnTimeoutMillisecnds", int, is_required=True),
        E("scf_signaling_ip_address", "scfSignalingIPAddress", str),
        E("scf_signaling_port", "scfSignalingPort", int),
    )

    #: bool: *Required* enableLocationServices
    enable_location_services = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableMSRNLookup
    enable_msrn_lookup = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableMobileStateChecking
    enable_mobile_state_checking = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* denyCallOriginations
    deny_call_originations = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* denyCallTerminations
    deny_call_terminations = Field(type=bool, required=True, mutable=False)
    #: int: *Required* imrnTimeoutMillisecnds
    imrn_timeout_millisecnds = Field(type=int, required=True, mutable=False)
    #: str: *Optional* scfSignalingIPAddress
    scf_signaling_ip_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* scfSignalingPort
    scf_signaling_port = Field(type=int, required=False, mutable=False)


class SystemBroadWorksMobilityGetResponse17sp4(OCIResponse):
    """
    The response to a ``SystemBroadWorksMobilityGetRequest17sp4()``.

    """

    _ELEMENTS = (
        E("enable_location_services", "enableLocationServices", bool, is_required=True),
        E("enable_msrn_lookup", "enableMSRNLookup", bool, is_required=True),
        E(
            "enable_mobile_state_checking", "enableMobileStateChecking", bool,
            is_required=True,
        ),
        E("deny_call_originations", "denyCallOriginations", bool, is_required=True),
        E("deny_call_terminations", "denyCallTerminations", bool, is_required=True),
        E("imrn_timeout_millisecnds", "imrnTimeoutMillisecnds", int, is_required=True),
        E("scf_signaling_net_address", "scfSignalingNetAddress", str),
        E("scf_signaling_port", "scfSignalingPort", int),
        E("refresh_period_seconds", "refreshPeriodSeconds", int, is_required=True),
        E("max_consecutive_failures", "maxConsecutiveFailures", int, is_required=True),
        E(
            "max_response_wait_time_milliseconds", "maxResponseWaitTimeMilliseconds", int,
            is_required=True,
        ),
    )

    #: bool: *Required* enableLocationServices
    enable_location_services = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableMSRNLookup
    enable_msrn_lookup = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableMobileStateChecking
    enable_mobile_state_checking = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* denyCallOriginations
    deny_call_originations = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* denyCallTerminations
    deny_call_terminations = Field(type=bool, required=True, mutable=False)
    #: int: *Required* imrnTimeoutMillisecnds
    imrn_timeout_millisecnds = Field(type=int, required=True, mutable=False)
    #: str: *Optional* scfSignalingNetAddress
    scf_signaling_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* scfSignalingPort
    scf_signaling_port = Field(type=int, required=False, mutable=False)
    #: int: *Required* refreshPeriodSeconds
    refresh_period_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxConsecutiveFailures
    max_consecutive_failures = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxResponseWaitTimeMilliseconds
    max_response_wait_time_milliseconds = Field(type=int, required=True, mutable=False)


class SystemBroadWorksMobilityGetResponse19sp1(OCIResponse):
    """
    The response to a ``SystemBroadWorksMobilityGetRequest19sp1()``.

    Replaced by ``SystemBroadWorksMobilityGetResponse21()``
    """

    _ELEMENTS = (
        E("enable_location_services", "enableLocationServices", bool, is_required=True),
        E("enable_msrn_lookup", "enableMSRNLookup", bool, is_required=True),
        E(
            "enable_mobile_state_checking", "enableMobileStateChecking", bool,
            is_required=True,
        ),
        E("deny_call_originations", "denyCallOriginations", bool, is_required=True),
        E("deny_call_terminations", "denyCallTerminations", bool, is_required=True),
        E("imrn_timeout_millisecnds", "imrnTimeoutMillisecnds", int, is_required=True),
        E("scf_signaling_net_address", "scfSignalingNetAddress", str),
        E("scf_signaling_port", "scfSignalingPort", int),
        E("refresh_period_seconds", "refreshPeriodSeconds", int, is_required=True),
        E("max_consecutive_failures", "maxConsecutiveFailures", int, is_required=True),
        E(
            "max_response_wait_time_milliseconds", "maxResponseWaitTimeMilliseconds", int,
            is_required=True,
        ),
        E(
            "enable_announcement_suppression", "enableAnnouncementSuppression", bool,
            is_required=True,
        ),
    )

    #: bool: *Required* enableLocationServices
    enable_location_services = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableMSRNLookup
    enable_msrn_lookup = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableMobileStateChecking
    enable_mobile_state_checking = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* denyCallOriginations
    deny_call_originations = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* denyCallTerminations
    deny_call_terminations = Field(type=bool, required=True, mutable=False)
    #: int: *Required* imrnTimeoutMillisecnds
    imrn_timeout_millisecnds = Field(type=int, required=True, mutable=False)
    #: str: *Optional* scfSignalingNetAddress
    scf_signaling_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* scfSignalingPort
    scf_signaling_port = Field(type=int, required=False, mutable=False)
    #: int: *Required* refreshPeriodSeconds
    refresh_period_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxConsecutiveFailures
    max_consecutive_failures = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxResponseWaitTimeMilliseconds
    max_response_wait_time_milliseconds = Field(type=int, required=True, mutable=False)
    #: bool: *Required* enableAnnouncementSuppression
    enable_announcement_suppression = Field(type=bool, required=True, mutable=False)


class SystemBroadWorksMobilityGetResponse21(OCIResponse):
    """
    The response to a ``SystemBroadWorksMobilityGetRequest21()``.

    """

    _ELEMENTS = (
        E("enable_location_services", "enableLocationServices", bool, is_required=True),
        E("enable_msrn_lookup", "enableMSRNLookup", bool, is_required=True),
        E(
            "enable_mobile_state_checking", "enableMobileStateChecking", bool,
            is_required=True,
        ),
        E("deny_call_originations", "denyCallOriginations", bool, is_required=True),
        E("deny_call_terminations", "denyCallTerminations", bool, is_required=True),
        E("imrn_timeout_millisecnds", "imrnTimeoutMillisecnds", int, is_required=True),
    )

    #: bool: *Required* enableLocationServices
    enable_location_services = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableMSRNLookup
    enable_msrn_lookup = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableMobileStateChecking
    enable_mobile_state_checking = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* denyCallOriginations
    deny_call_originations = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* denyCallTerminations
    deny_call_terminations = Field(type=bool, required=True, mutable=False)
    #: int: *Required* imrnTimeoutMillisecnds
    imrn_timeout_millisecnds = Field(type=int, required=True, mutable=False)


class SystemBroadWorksMobilityMobileNetworkGetListResponse(OCIResponse):
    """
    The response to a ``SystemBroadWorksMobilityMobileNetworkGetListRequest()``.

    Contains a table with column headings: "Name", "SCF Signaling Net Address", "SCF
    Signaling Port"
    """

    _ELEMENTS = (
        E(
            "mobile_network_table", "mobileNetworkTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* mobileNetworkTable  *Tabular*
    mobile_network_table = Field(type=list, required=True, mutable=False)


class SystemBroadWorksMobilityMobileNetworkGetResponse(OCIResponse):
    """
    The response to a ``SystemBroadWorksMobilityMobileNetworkGetRequest()``.

    """

    _ELEMENTS = (
        E("scf_signaling_net_address", "scfSignalingNetAddress", str),
        E("scf_signaling_port", "scfSignalingPort", int),
        E("refresh_period_seconds", "refreshPeriodSeconds", int, is_required=True),
        E("max_consecutive_failures", "maxConsecutiveFailures", int, is_required=True),
        E(
            "max_response_wait_time_milliseconds", "maxResponseWaitTimeMilliseconds", int,
            is_required=True,
        ),
        E(
            "enable_announcement_suppression", "enableAnnouncementSuppression", bool,
            is_required=True,
        ),
        E("service_access_code_list_name", "serviceAccessCodeListName", str),
    )

    #: str: *Optional* scfSignalingNetAddress
    scf_signaling_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* scfSignalingPort
    scf_signaling_port = Field(type=int, required=False, mutable=False)
    #: int: *Required* refreshPeriodSeconds
    refresh_period_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxConsecutiveFailures
    max_consecutive_failures = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxResponseWaitTimeMilliseconds
    max_response_wait_time_milliseconds = Field(type=int, required=True, mutable=False)
    #: bool: *Required* enableAnnouncementSuppression
    enable_announcement_suppression = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* serviceAccessCodeListName
    service_access_code_list_name = Field(type=str, required=False, mutable=False)


class SystemBroadWorksMobilityMobileSubscriberDirectoryNumberGetSummaryListResponse(OCIResponse):
    """
    Response to
    ``SystemBroadWorksMobilityMobileSubscriberDirectoryNumberGetSummaryListRequest()``.

    The response contains a table with columns: "Mobile Number", "Mobile Network",
    "Service Provider Id", "Is Enterprise", "Group Id", "User Id", "Last Name", "First
    Name", "Hiragana Last Name", "Hiragana First Name", "Phone Number" and "Extension".
    """

    _ELEMENTS = (
        E(
            "mobile_subscriber_directory_numbers_summary_table",
            "mobileSubscriberDirectoryNumbersSummaryTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* mobileSubscriberDirectoryNumbersSummaryTable  *Tabular*
    mobile_subscriber_directory_numbers_summary_table = Field(
        type=list, required=True, mutable=False,
    )


class SystemBroadWorksMobilityServiceAccessCodeGetListResponse(OCIResponse):
    """
    Response to ``SystemBroadWorksMobilityServiceAccessCodeGetListRequest()``.

    Contains a table with column headings: "Country Code", "Service Access Code",
    "Description". Replaced by SystemBroadWorksMobilityServiceAccessCodeGetListReponse21.
    """

    _ELEMENTS = (
        E(
            "service_access_code_table", "serviceAccessCodeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* serviceAccessCodeTable  *Tabular*
    service_access_code_table = Field(type=list, required=True, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeGetListResponse21(OCIResponse):
    """
    Response to ``SystemBroadWorksMobilityServiceAccessCodeGetListRequest21()``.

    Contains a table with column headings: "Country Code", "Service Access Code",
    "Description"
    """

    _ELEMENTS = (
        E(
            "service_access_code_table", "serviceAccessCodeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* serviceAccessCodeTable  *Tabular*
    service_access_code_table = Field(type=list, required=True, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeListGetListResponse(OCIResponse):
    """
    Response to ``SystemBroadWorksMobilityServiceAccessCodeListGetListRequest()``.

    """

    _ELEMENTS = (
        E("name", "name", str, is_array=True),
    )

    #: list(str): *Optional* name  *Array*
    name = Field(type=list, required=False, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeListUsageGetResponse(OCIResponse):
    """
    Response to ``SystemBroadWorksMobilityServiceAccessCodeListUsageGetRequest()``.

    """

    _ELEMENTS = (
        E("mobile_network_name", "mobileNetworkName", str, is_array=True),
    )

    #: list(str): *Optional* mobileNetworkName  *Array*
    mobile_network_name = Field(type=list, required=False, mutable=False)


class SystemBroadWorksReceptionistEnterpriseGetResponse(OCIResponse):
    """
    Response to ``SystemBroadWorksReceptionistEnterpriseGetRequest()``.

    Contains a list of BroadWorks Receptionist - Enterprise parameters.
    """

    _ELEMENTS = (
        E("max_monitored_users", "maxMonitoredUsers", int, is_required=True),
    )

    #: int: *Required* maxMonitoredUsers
    max_monitored_users = Field(type=int, required=True, mutable=False)


class SystemBusyLampFieldGetResponse(OCIResponse):
    """
    Response to ``SystemBusyLampFieldGetRequest()``.

    """

    _ELEMENTS = (
        E(
            "display_local_user_identity_last_name_first",
            "displayLocalUserIdentityLastNameFirst", bool, is_required=True,
        ),
    )

    #: bool: *Required* displayLocalUserIdentityLastNameFirst
    display_local_user_identity_last_name_first = Field(
        type=bool, required=True, mutable=False,
    )


class SystemBusyLampFieldGetResponse18(OCIResponse):
    """
    Response to ``SystemBusyLampFieldGetRequest18()``.

    The following elements are only used in AS data mode: forceUseOfTCP
    """

    _ELEMENTS = (
        E(
            "display_local_user_identity_last_name_first",
            "displayLocalUserIdentityLastNameFirst", bool, is_required=True,
        ),
        E("force_use_of_tcp", "forceUseOfTCP", bool, is_required=True),
    )

    #: bool: *Required* displayLocalUserIdentityLastNameFirst
    display_local_user_identity_last_name_first = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* forceUseOfTCP
    force_use_of_tcp = Field(type=bool, required=True, mutable=False)


class SystemBwDiameterBaseDataGetResponse(OCIResponse):
    """
    Response to ``SystemBwDiameterBaseDataGetRequest()``.

    Contains a list of System Diameter base parameters.
    """

    _ELEMENTS = (
        E("xs_realm", "xsRealm", str),
        E("xs_listening_port", "xsListeningPort", int, is_required=True),
        E("ps_realm", "psRealm", str),
        E("ps_listening_port", "psListeningPort", int, is_required=True),
        E("ps_relay_through_xs", "psRelayThroughXs", bool, is_required=True),
        E("xs_relay_listening_port", "xsRelayListeningPort", int, is_required=True),
        E("tc_timer_seconds", "tcTimerSeconds", int, is_required=True),
        E("tw_timer_seconds", "twTimerSeconds", int, is_required=True),
        E("request_timer_seconds", "requestTimerSeconds", int, is_required=True),
        E(
            "busy_peer_detection_outstanding_txn_count",
            "busyPeerDetectionOutstandingTxnCount", int, is_required=True,
        ),
        E(
            "busy_peer_restore_outstanding_txn_count",
            "busyPeerRestoreOutstandingTxnCount", int, is_required=True,
        ),
        E(
            "dynamic_entry_inactivity_timer_hours", "dynamicEntryInactivityTimerHours",
            int, is_required=True,
        ),
    )

    #: str: *Optional* xsRealm
    xs_realm = Field(type=str, required=False, mutable=False)
    #: int: *Required* xsListeningPort
    xs_listening_port = Field(type=int, required=True, mutable=False)
    #: str: *Optional* psRealm
    ps_realm = Field(type=str, required=False, mutable=False)
    #: int: *Required* psListeningPort
    ps_listening_port = Field(type=int, required=True, mutable=False)
    #: bool: *Required* psRelayThroughXs
    ps_relay_through_xs = Field(type=bool, required=True, mutable=False)
    #: int: *Required* xsRelayListeningPort
    xs_relay_listening_port = Field(type=int, required=True, mutable=False)
    #: int: *Required* tcTimerSeconds
    tc_timer_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* twTimerSeconds
    tw_timer_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* requestTimerSeconds
    request_timer_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* busyPeerDetectionOutstandingTxnCount
    busy_peer_detection_outstanding_txn_count = Field(type=int, required=True, mutable=False)
    #: int: *Required* busyPeerRestoreOutstandingTxnCount
    busy_peer_restore_outstanding_txn_count = Field(type=int, required=True, mutable=False)
    #: int: *Required* dynamicEntryInactivityTimerHours
    dynamic_entry_inactivity_timer_hours = Field(type=int, required=True, mutable=False)


class SystemBwDiameterBaseDataGetResponse17sp3(OCIResponse):
    """
    Response to ``SystemBwDiameterBaseDataGetRequest17sp3()``.

    Contains a list of System Diameter base parameters.
    """

    _ELEMENTS = (
        E("xs_realm", "xsRealm", str),
        E("xs_listening_port", "xsListeningPort", int, is_required=True),
        E("ps_realm", "psRealm", str),
        E("ps_listening_port", "psListeningPort", int, is_required=True),
        E("ps_relay_through_xs", "psRelayThroughXs", bool, is_required=True),
        E("xs_relay_listening_port", "xsRelayListeningPort", int, is_required=True),
        E("tc_timer_seconds", "tcTimerSeconds", int, is_required=True),
        E("tw_timer_seconds", "twTimerSeconds", int, is_required=True),
        E("request_timer_seconds", "requestTimerSeconds", int, is_required=True),
        E(
            "busy_peer_detection_outstanding_txn_count",
            "busyPeerDetectionOutstandingTxnCount", int, is_required=True,
        ),
        E(
            "busy_peer_restore_outstanding_txn_count",
            "busyPeerRestoreOutstandingTxnCount", int, is_required=True,
        ),
        E(
            "dynamic_entry_inactivity_timer_hours", "dynamicEntryInactivityTimerHours",
            int, is_required=True,
        ),
        E(
            "advertised_offline_billing_application",
            "advertisedOfflineBillingApplication", str, is_required=True,
        ),
        E(
            "advertised_online_billing_application", "advertisedOnlineBillingApplication",
            str, is_required=True,
        ),
    )

    #: str: *Optional* xsRealm
    xs_realm = Field(type=str, required=False, mutable=False)
    #: int: *Required* xsListeningPort
    xs_listening_port = Field(type=int, required=True, mutable=False)
    #: str: *Optional* psRealm
    ps_realm = Field(type=str, required=False, mutable=False)
    #: int: *Required* psListeningPort
    ps_listening_port = Field(type=int, required=True, mutable=False)
    #: bool: *Required* psRelayThroughXs
    ps_relay_through_xs = Field(type=bool, required=True, mutable=False)
    #: int: *Required* xsRelayListeningPort
    xs_relay_listening_port = Field(type=int, required=True, mutable=False)
    #: int: *Required* tcTimerSeconds
    tc_timer_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* twTimerSeconds
    tw_timer_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* requestTimerSeconds
    request_timer_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* busyPeerDetectionOutstandingTxnCount
    busy_peer_detection_outstanding_txn_count = Field(type=int, required=True, mutable=False)
    #: int: *Required* busyPeerRestoreOutstandingTxnCount
    busy_peer_restore_outstanding_txn_count = Field(type=int, required=True, mutable=False)
    #: int: *Required* dynamicEntryInactivityTimerHours
    dynamic_entry_inactivity_timer_hours = Field(type=int, required=True, mutable=False)
    #: str: *Required* advertisedOfflineBillingApplication
    advertised_offline_billing_application = Field(type=str, required=True, mutable=False)
    #: str: *Required* advertisedOnlineBillingApplication
    advertised_online_billing_application = Field(type=str, required=True, mutable=False)


class SystemBwDiameterPeerGetListResponse(OCIResponse):
    """
    Contains a 5 column table with column headings 'Instance', 'Identity', 'IP Address',
    'Port', and 'Enabled'.

    One row is present for each peer.
    """

    _ELEMENTS = (
        E("peer_table", "peerTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* peerTable  *Tabular*
    peer_table = Field(type=list, required=True, mutable=False)


class SystemBwDiameterRoutingPeerGetListResponse(OCIResponse):
    """
    Contains a 6 column table with column headings 'Instance', 'Realm', 'ApplicationID',
    'Identity, 'Priority', and 'Weight'.

    One row is present for each Diameter Routing Peer.
    """

    _ELEMENTS = (
        E(
            "routing_peer_table", "routingPeerTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* routingPeerTable  *Tabular*
    routing_peer_table = Field(type=list, required=True, mutable=False)


class SystemBwDiameterRoutingRealmGetListResponse(OCIResponse):
    """
    Contains a 4 column table with column headings 'Instance', 'Realm', 'ApplicationID',
    and 'Default'.

    One row is present for each Diameter routing realm.
    """

    _ELEMENTS = (
        E(
            "routing_realm_table", "routingRealmTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* routingRealmTable  *Tabular*
    routing_realm_table = Field(type=list, required=True, mutable=False)


class SystemCAPGetACLListResponse14(OCIResponse):
    """
    Response to ``SystemCAPGetACLListRequest14()``.

    The table columns are: "Net Address" and "Description".
    """

    _ELEMENTS = (
        E("acl_table", "aclTable", list, is_complex=True, is_required=True, is_table=True),
    )

    #: list: *Required* aclTable  *Tabular*
    acl_table = Field(type=list, required=True, mutable=False)


class SystemCAPParametersGetResponse(OCIResponse):
    """
    Response to ``SystemCAPParametersGetRequest()``.

    Contains a list of system CAP parameters.

    Replaced By: ``SystemCAPParametersGetResponse14sp3()``
    """

    _ELEMENTS = (
        E("server_port", "serverPort", int, is_required=True),
        E("max_client_connections", "maxClientConnections", int, is_required=True),
        E("enable_connection_ping", "enableConnectionPing", bool, is_required=True),
        E(
            "connection_ping_interval_minutes", "connectionPingIntervalMinutes", int,
            is_required=True,
        ),
        E("ccc2_server_port", "CCC2ServerPort", int, is_required=True),
        E("ccc2_max_client_connections", "CCC2MaxClientConnections", int, is_required=True),
    )

    #: int: *Required* serverPort
    server_port = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxClientConnections
    max_client_connections = Field(type=int, required=True, mutable=False)
    #: bool: *Required* enableConnectionPing
    enable_connection_ping = Field(type=bool, required=True, mutable=False)
    #: int: *Required* connectionPingIntervalMinutes
    connection_ping_interval_minutes = Field(type=int, required=True, mutable=False)
    #: int: *Required* CCC2ServerPort
    ccc2_server_port = Field(type=int, required=True, mutable=False)
    #: int: *Required* CCC2MaxClientConnections
    ccc2_max_client_connections = Field(type=int, required=True, mutable=False)


class SystemCAPParametersGetResponse14sp3(OCIResponse):
    """
    Response to ``SystemCAPParametersGetListRequest14sp3()``.

    Contains a list of system CAP parameters.  Replaced by
    ``SystemCAPParametersGetResponse19()``
    """

    _ELEMENTS = (
        E("server_port", "serverPort", int, is_required=True),
        E("max_client_connections", "maxClientConnections", int, is_required=True),
        E("enable_connection_ping", "enableConnectionPing", bool, is_required=True),
        E(
            "connection_ping_interval_minutes", "connectionPingIntervalMinutes", int,
            is_required=True,
        ),
        E("ccc2_server_port", "CCC2ServerPort", int, is_required=True),
        E("ccc2_max_client_connections", "CCC2MaxClientConnections", int, is_required=True),
        E("cap_server_call_center_port", "capServerCallCenterPort", int, is_required=True),
        E(
            "cap_server_call_center_max_client_connections",
            "capServerCallCenterMaxClientConnections", int, is_required=True,
        ),
    )

    #: int: *Required* serverPort
    server_port = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxClientConnections
    max_client_connections = Field(type=int, required=True, mutable=False)
    #: bool: *Required* enableConnectionPing
    enable_connection_ping = Field(type=bool, required=True, mutable=False)
    #: int: *Required* connectionPingIntervalMinutes
    connection_ping_interval_minutes = Field(type=int, required=True, mutable=False)
    #: int: *Required* CCC2ServerPort
    ccc2_server_port = Field(type=int, required=True, mutable=False)
    #: int: *Required* CCC2MaxClientConnections
    ccc2_max_client_connections = Field(type=int, required=True, mutable=False)
    #: int: *Required* capServerCallCenterPort
    cap_server_call_center_port = Field(type=int, required=True, mutable=False)
    #: int: *Required* capServerCallCenterMaxClientConnections
    cap_server_call_center_max_client_connections = Field(
        type=int, required=True, mutable=False,
    )


class SystemCAPParametersGetResponse19(OCIResponse):
    """
    Response to ``SystemCAPParametersGetRequest19()``.

    Contains a list of system CAP parameters.
    """

    _ELEMENTS = (
        E("server_port", "serverPort", int, is_required=True),
        E("max_client_connections", "maxClientConnections", int, is_required=True),
        E("enable_connection_ping", "enableConnectionPing", bool, is_required=True),
        E(
            "connection_ping_interval_minutes", "connectionPingIntervalMinutes", int,
            is_required=True,
        ),
        E("ccc2_server_port", "CCC2ServerPort", int, is_required=True),
        E("ccc2_max_client_connections", "CCC2MaxClientConnections", int, is_required=True),
    )

    #: int: *Required* serverPort
    server_port = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxClientConnections
    max_client_connections = Field(type=int, required=True, mutable=False)
    #: bool: *Required* enableConnectionPing
    enable_connection_ping = Field(type=bool, required=True, mutable=False)
    #: int: *Required* connectionPingIntervalMinutes
    connection_ping_interval_minutes = Field(type=int, required=True, mutable=False)
    #: int: *Required* CCC2ServerPort
    ccc2_server_port = Field(type=int, required=True, mutable=False)
    #: int: *Required* CCC2MaxClientConnections
    ccc2_max_client_connections = Field(type=int, required=True, mutable=False)


class SystemCPEConfigGetFileServerListResponse(OCIResponse):
    """
    Response to ``SystemCPEConfigGetFileServerListRequest()``.

    The table columns are: "Device Type", "FTP Host Net Address", "FTP User Id",
    "Directory" and "Passive FTP".

    Replaced By: ``SystemCPEConfigGetFileServerListResponse14sp6()``
    """

    _ELEMENTS = (
        E(
            "file_server_table", "fileServerTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* fileServerTable  *Tabular*
    file_server_table = Field(type=list, required=True, mutable=False)


class SystemCPEConfigGetFileServerListResponse14sp6(OCIResponse):
    """
    Response to ``SystemCPEConfigGetFileServerListRequest14sp6()``.

    The table columns are: "Device Type", "File Repository Name", "Directory", "Extended
    File Repository Name". The following columns are only used in AS data mode: "Extended
    File Repository Name"
    """

    _ELEMENTS = (
        E(
            "file_server_table", "fileServerTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* fileServerTable  *Tabular*
    file_server_table = Field(type=list, required=True, mutable=False)


class SystemCPEConfigParametersGetResponse(OCIResponse):
    """
    Response to ``SystemCPEConfigParametersGetListRequest()``.

    Contains a list of system CPE Config parameters.

    Replaced By: ``SystemCPEConfigParametersGetResponse14sp6()``
    """

    _ELEMENTS = (
        E("enable_ip_device_management", "enableIPDeviceManagement", bool, is_required=True),
        E("ftp_connect_timeout_seconds", "ftpConnectTimeoutSeconds", int, is_required=True),
        E(
            "ftp_file_transfer_timeout_seconds", "ftpFileTransferTimeoutSeconds", int,
            is_required=True,
        ),
    )

    #: bool: *Required* enableIPDeviceManagement
    enable_ip_device_management = Field(type=bool, required=True, mutable=False)
    #: int: *Required* ftpConnectTimeoutSeconds
    ftp_connect_timeout_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* ftpFileTransferTimeoutSeconds
    ftp_file_transfer_timeout_seconds = Field(type=int, required=True, mutable=False)


class SystemCPEConfigParametersGetResponse14sp6(OCIResponse):
    """
    Response to ``SystemCPEConfigParametersGetListRequest14sp6()``.

    Contains a list of system CPE Config parameters.
    """

    _ELEMENTS = (
        E("enable_ip_device_management", "enableIPDeviceManagement", bool, is_required=True),
        E("ftp_connect_timeout_seconds", "ftpConnectTimeoutSeconds", int, is_required=True),
        E(
            "ftp_file_transfer_timeout_seconds", "ftpFileTransferTimeoutSeconds", int,
            is_required=True,
        ),
        E(
            "pause_between_file_rebuild_milliseconds",
            "pauseBetweenFileRebuildMilliseconds", int, is_required=True,
        ),
        E("max_busy_time_minutes", "maxBusyTimeMinutes", int, is_required=True),
        E("device_access_app_server_cluster_name", "deviceAccessAppServerClusterName", str),
        E("file_rebuild_immediate", "fileRebuildImmediate", str, is_complex=True),  # unknown
        E("file_rebuild_daily", "fileRebuildDaily", str, is_complex=True),  # unknown
        E("file_rebuild_hourly", "fileRebuildHourly", str, is_complex=True),  # unknown
    )

    #: bool: *Required* enableIPDeviceManagement
    enable_ip_device_management = Field(type=bool, required=True, mutable=False)
    #: int: *Required* ftpConnectTimeoutSeconds
    ftp_connect_timeout_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* ftpFileTransferTimeoutSeconds
    ftp_file_transfer_timeout_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* pauseBetweenFileRebuildMilliseconds
    pause_between_file_rebuild_milliseconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxBusyTimeMinutes
    max_busy_time_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Optional* deviceAccessAppServerClusterName
    device_access_app_server_cluster_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* fileRebuildImmediate
    file_rebuild_immediate = Field(type=str, required=False, mutable=False)
    #: str: *Optional* fileRebuildDaily
    file_rebuild_daily = Field(type=str, required=False, mutable=False)
    #: str: *Optional* fileRebuildHourly
    file_rebuild_hourly = Field(type=str, required=False, mutable=False)


class SystemCPEConfigParametersGetResponse20(OCIResponse):
    """
    Response to ``SystemCPEConfigParametersGetListRequest20()``.

    Contains a list of system CPE Config parameters.  Replaced by:
    ``SystemCPEConfigParametersGetResponse21()``
    """

    _ELEMENTS = (
        E("enable_ip_device_management", "enableIPDeviceManagement", bool, is_required=True),
        E("ftp_connect_timeout_seconds", "ftpConnectTimeoutSeconds", int, is_required=True),
        E(
            "ftp_file_transfer_timeout_seconds", "ftpFileTransferTimeoutSeconds", int,
            is_required=True,
        ),
        E(
            "pause_between_file_rebuild_milliseconds",
            "pauseBetweenFileRebuildMilliseconds", int, is_required=True,
        ),
        E("max_busy_time_minutes", "maxBusyTimeMinutes", int, is_required=True),
        E("device_access_app_server_cluster_name", "deviceAccessAppServerClusterName", str),
    )

    #: bool: *Required* enableIPDeviceManagement
    enable_ip_device_management = Field(type=bool, required=True, mutable=False)
    #: int: *Required* ftpConnectTimeoutSeconds
    ftp_connect_timeout_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* ftpFileTransferTimeoutSeconds
    ftp_file_transfer_timeout_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* pauseBetweenFileRebuildMilliseconds
    pause_between_file_rebuild_milliseconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxBusyTimeMinutes
    max_busy_time_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Optional* deviceAccessAppServerClusterName
    device_access_app_server_cluster_name = Field(type=str, required=False, mutable=False)


class SystemCPEConfigParametersGetResponse21(OCIResponse):
    """
    Response to ``SystemCPEConfigParametersGetListRequest21()``.

    Contains a list of system CPE Config parameters.
    """

    _ELEMENTS = (
        E("enable_ip_device_management", "enableIPDeviceManagement", bool, is_required=True),
        E("ftp_connect_timeout_seconds", "ftpConnectTimeoutSeconds", int, is_required=True),
        E(
            "ftp_file_transfer_timeout_seconds", "ftpFileTransferTimeoutSeconds", int,
            is_required=True,
        ),
        E(
            "pause_between_file_rebuild_milliseconds",
            "pauseBetweenFileRebuildMilliseconds", int, is_required=True,
        ),
        E("device_access_app_server_cluster_name", "deviceAccessAppServerClusterName", str),
        E(
            "min_time_between_reset_milliseconds", "minTimeBetweenResetMilliseconds", int,
            is_required=True,
        ),
        E("always_push_files_on_rebuild", "alwaysPushFilesOnRebuild", bool, is_required=True),
        E(
            "max_file_operation_retry_attempts", "maxFileOperationRetryAttempts", int,
            is_required=True,
        ),
        E("enable_auto_rebuild_config", "enableAutoRebuildConfig", bool, is_required=True),
        E("event_queue_size", "eventQueueSize", int, is_required=True),
        E(
            "allow_device_credentials_retrieval", "allowDeviceCredentialsRetrieval", bool,
            is_required=True,
        ),
    )

    #: bool: *Required* enableIPDeviceManagement
    enable_ip_device_management = Field(type=bool, required=True, mutable=False)
    #: int: *Required* ftpConnectTimeoutSeconds
    ftp_connect_timeout_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* ftpFileTransferTimeoutSeconds
    ftp_file_transfer_timeout_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* pauseBetweenFileRebuildMilliseconds
    pause_between_file_rebuild_milliseconds = Field(type=int, required=True, mutable=False)
    #: str: *Optional* deviceAccessAppServerClusterName
    device_access_app_server_cluster_name = Field(type=str, required=False, mutable=False)
    #: int: *Required* minTimeBetweenResetMilliseconds
    min_time_between_reset_milliseconds = Field(type=int, required=True, mutable=False)
    #: bool: *Required* alwaysPushFilesOnRebuild
    always_push_files_on_rebuild = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFileOperationRetryAttempts
    max_file_operation_retry_attempts = Field(type=int, required=True, mutable=False)
    #: bool: *Required* enableAutoRebuildConfig
    enable_auto_rebuild_config = Field(type=bool, required=True, mutable=False)
    #: int: *Required* eventQueueSize
    event_queue_size = Field(type=int, required=True, mutable=False)
    #: bool: *Required* allowDeviceCredentialsRetrieval
    allow_device_credentials_retrieval = Field(type=bool, required=True, mutable=False)


class SystemCallCenterEnhancedReportingBrandingGetResponse(OCIResponse):
    """
    Response to the ``SystemCallCenterEnhancedReportingBrandingGetRequest()``.

    """

    _ELEMENTS = (
        E("branding_choice", "brandingChoice", str, is_required=True),
        E("custom_branding_file_description", "customBrandingFileDescription", str),
    )

    #: str: *Required* brandingChoice
    branding_choice = Field(type=str, required=True, mutable=False)
    #: str: *Optional* customBrandingFileDescription
    custom_branding_file_description = Field(type=str, required=False, mutable=False)


class SystemCallCenterEnhancedReportingGetResponse(OCIResponse):
    """
    Response to ``SystemCallCenterEnhancedReportingGetRequest()``.

    """

    _ELEMENTS = (
        E("archive_reports", "archiveReports", bool, is_required=True),
        E("report_application_url", "reportApplicationURL", str),
        E("repository_application_url", "repositoryApplicationURL", str),
    )

    #: bool: *Required* archiveReports
    archive_reports = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* reportApplicationURL
    report_application_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* repositoryApplicationURL
    repository_application_url = Field(type=str, required=False, mutable=False)


class SystemCallCenterEnhancedReportingReportTemplateGetListResponse(OCIResponse):
    """
    Response to ``SystemCallCenterEnhancedReportingReportTemplateGetListRequest()``.

    Contains a table with column headings: "Name", "Description", "Is Custom", "Type" and
    "Enabled"
    """

    _ELEMENTS = (
        E(
            "report_template_table", "reportTemplateTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* reportTemplateTable  *Tabular*
    report_template_table = Field(type=list, required=True, mutable=False)


class SystemCallCenterEnhancedReportingReportTemplateGetResponse(OCIResponse):
    """
    Response to ``SystemCallCenterEnhancedReportingReportTemplateGetRequest()``.

    """

    _ELEMENTS = (
        E("description", "description", str),
        E("data_template", "dataTemplate", str, is_required=True),
        E("filter_number", "filterNumber", int),
        E("xslt_template_description", "xsltTemplateDescription", str, is_required=True),
        E("scope", "scope", str, is_required=True),
        E("is_enabled", "isEnabled", bool, is_required=True),
        E("is_realtime_report", "isRealtimeReport", bool),
        E("call_completion_threshold_param", "callCompletionThresholdParam", str),
        E("short_duration_threshold_param", "shortDurationThresholdParam", str),
        E("service_level_threshold_param", "serviceLevelThresholdParam", str),
        E("service_level_inclusions_param", "serviceLevelInclusionsParam", str),
        E(
            "service_level_objective_threshold_param",
            "serviceLevelObjectiveThresholdParam", str,
        ),
        E("abandoned_call_threshold_param", "abandonedCallThresholdParam", str),
        E("service_level_threshold_param_number", "serviceLevelThresholdParamNumber", int),
        E("abandoned_call_threshold_param_number", "abandonedCallThresholdParamNumber", int),
        E("filter_value", "filterValue", str),
    )

    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Required* dataTemplate
    data_template = Field(type=str, required=True, mutable=False)
    #: int: *Optional* filterNumber
    filter_number = Field(type=int, required=False, mutable=False)
    #: str: *Required* xsltTemplateDescription
    xslt_template_description = Field(type=str, required=True, mutable=False)
    #: str: *Required* scope
    scope = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isEnabled
    is_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Optional* isRealtimeReport
    is_realtime_report = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* callCompletionThresholdParam
    call_completion_threshold_param = Field(type=str, required=False, mutable=False)
    #: str: *Optional* shortDurationThresholdParam
    short_duration_threshold_param = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceLevelThresholdParam
    service_level_threshold_param = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceLevelInclusionsParam
    service_level_inclusions_param = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceLevelObjectiveThresholdParam
    service_level_objective_threshold_param = Field(type=str, required=False, mutable=False)
    #: str: *Optional* abandonedCallThresholdParam
    abandoned_call_threshold_param = Field(type=str, required=False, mutable=False)
    #: int: *Optional* serviceLevelThresholdParamNumber
    service_level_threshold_param_number = Field(type=int, required=False, mutable=False)
    #: int: *Optional* abandonedCallThresholdParamNumber
    abandoned_call_threshold_param_number = Field(type=int, required=False, mutable=False)
    #: str: *Optional* filterValue
    filter_value = Field(type=str, required=False, mutable=False)


class SystemCallCenterEnhancedReportingScheduledReportGetActiveListResponse(OCIResponse):
    """
    Response to ``SystemCallCenterEnhancedReportingScheduledReportGetActiveListRequest()``
    Contains a table with column headings : "Scheduled Report Name", "Description",
    "Service Provider Id", "Is Enterprise", "Group Id", "Created By", "Is Supervisor
    Report", "Report Template Name", "Report Template Level" and "Recurring".

    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and
    "Yearly". The possible values for "Report Template Level" are "System", "Enterprise"
    and "Group". For the rows with "Is Enterprise" column value "true", the "Group Id"
    column will be empty.
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* scheduledReportTable  *Tabular*
    scheduled_report_table = Field(type=list, required=True, mutable=False)


class SystemCallCenterEnhancedReportingScheduledReportGetCompletedListResponse(OCIResponse):
    """
    Response to
    ``SystemCallCenterEnhancedReportingScheduledReportGetCompletedListRequest()`` Contains
    a table with column headings : "Scheduled Report Name", "Description", "Service
    Provider Id", "Is Enterprise", "Group Id", "Created By", "Is Supervisor Report",
    "Report Template Name", "Report Template Level" and "Recurring".

    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and
    "Yearly". The possible values for "Report Template Level" are "System", "Enterprise"
    and "Group". For the rows with "Is Enterprise" column value "true", the "Group Id"
    column will be empty.
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* scheduledReportTable  *Tabular*
    scheduled_report_table = Field(type=list, required=True, mutable=False)


class SystemCallCenterEnhancedReportingScheduledReportGetListResponse(OCIResponse):
    """
    Response to ``SystemCallCenterEnhancedReportingScheduledReportGetListRequest()``.

    Contains a table with column headings : "Scheduled Report Name", "Description",
    "Service Provider Id", "Is Enterprise", "Group Id", "Created By", "Is Supervisor
    Report", "Status", "Report Template Name", "Report Template Level" and "Recurring".
    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Status" are "Active", and "Completed". The possible values
    for "Recurring" are "None", "Daily", "Weekly", "Monthly" and "Yearly". The possible
    values for "Report Template Level" are "System", "Enterprise" and "Group". For the
    rows with "Is Enterprise" column value "true", the "Group Id" column will be empty.
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* scheduledReportTable  *Tabular*
    scheduled_report_table = Field(type=list, required=True, mutable=False)


class SystemCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse(OCIResponse):
    """
    Response to
    ``SystemCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest()``.

    Contains a table with column headings: "Schedule Name", "Organization Type", "Service
    Provider Id", "Group Id", "Created By", "Created By Supervisor", and "Is Active". The
    "Organization Type" is either "Service Provider" or "Enterprise". The "Created By" can
    be either "Administrator" or user id if created by supervisor.  The possible values
    for "Created By Supervisor" are "true" and "false".
    """

    _ELEMENTS = (
        E(
            "schedule_report_table", "scheduleReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* scheduleReportTable  *Tabular*
    schedule_report_table = Field(type=list, required=True, mutable=False)


class SystemCallCenterEnhancedReportingScheduledTaskParametersGetResponse(OCIResponse):
    """
    Response to ``SystemCallCenterEnhancedReportingScheduledTaskParametersGetRequest()``
    """

    _ELEMENTS = (
        E(
            "scheduled_report_search_interval_minutes",
            "scheduledReportSearchIntervalMinutes", int, is_required=True,
        ),
        E(
            "maximum_scheduled_reports_per_interval",
            "maximumScheduledReportsPerInterval", int, is_required=True,
        ),
        E(
            "delete_scheduled_report_days_after_completion",
            "deleteScheduledReportDaysAfterCompletion", int, is_required=True,
        ),
    )

    #: int: *Required* scheduledReportSearchIntervalMinutes
    scheduled_report_search_interval_minutes = Field(type=int, required=True, mutable=False)
    #: int: *Required* maximumScheduledReportsPerInterval
    maximum_scheduled_reports_per_interval = Field(type=int, required=True, mutable=False)
    #: int: *Required* deleteScheduledReportDaysAfterCompletion
    delete_scheduled_report_days_after_completion = Field(
        type=int, required=True, mutable=False,
    )


class SystemCallCenterGetResponse(OCIResponse):
    """
    Response to ``SystemCallCenterGetRequest()``.

    Replaced By: ``SystemCallCenterGetResponse14sp9()``
    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str, is_required=True),
    )

    #: str: *Required* defaultFromAddress
    default_from_address = Field(type=str, required=True, mutable=False)


class SystemCallCenterGetResponse14sp9(OCIResponse):
    """
    Response to ``SystemCallCenterGetRequest14sp9()``.

    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str, is_required=True),
        E(
            "statistics_sampling_period_minutes", "statisticsSamplingPeriodMinutes", int,
            is_required=True,
        ),
    )

    #: str: *Required* defaultFromAddress
    default_from_address = Field(type=str, required=True, mutable=False)
    #: int: *Required* statisticsSamplingPeriodMinutes
    statistics_sampling_period_minutes = Field(type=int, required=True, mutable=False)


class SystemCallCenterGetResponse16(OCIResponse):
    """
    Response to ``SystemCallCenterGetRequest16()``.

    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str, is_required=True),
        E(
            "statistics_sampling_period_minutes", "statisticsSamplingPeriodMinutes", int,
            is_required=True,
        ),
        E("default_enable_guard_timer", "defaultEnableGuardTimer", bool, is_required=True),
        E("default_guard_timer_seconds", "defaultGuardTimerSeconds", int, is_required=True),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool, is_required=True,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int, is_required=True,
        ),
    )

    #: str: *Required* defaultFromAddress
    default_from_address = Field(type=str, required=True, mutable=False)
    #: int: *Required* statisticsSamplingPeriodMinutes
    statistics_sampling_period_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* defaultEnableGuardTimer
    default_enable_guard_timer = Field(type=bool, required=True, mutable=False)
    #: int: *Required* defaultGuardTimerSeconds
    default_guard_timer_seconds = Field(type=int, required=True, mutable=False)
    #: bool: *Required* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int, required=True, mutable=False,
    )


class SystemCallCenterGetResponse17(OCIResponse):
    """
    Response to ``SystemCallCenterGetRequest17()``.

    Replaced by ``SystemCallCenterGetResponse17sp4()``.
    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str, is_required=True),
        E(
            "statistics_sampling_period_minutes", "statisticsSamplingPeriodMinutes", int,
            is_required=True,
        ),
        E("default_enable_guard_timer", "defaultEnableGuardTimer", bool, is_required=True),
        E("default_guard_timer_seconds", "defaultGuardTimerSeconds", int, is_required=True),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool, is_required=True,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int, is_required=True,
        ),
        E(
            "default_play_ring_when_offer_call", "defaultPlayRingWhenOfferCall", bool,
            is_required=True,
        ),
        E(
            "uniform_call_distribution_policy_scope",
            "uniformCallDistributionPolicyScope", str, is_required=True,
        ),
        E(
            "call_handling_sampling_period_minutes", "callHandlingSamplingPeriodMinutes",
            int, is_required=True,
        ),
        E(
            "call_handling_minimum_sampling_size", "callHandlingMinimumSamplingSize", int,
            is_required=True,
        ),
        E(
            "play_tone_to_agent_for_emergency_call", "playToneToAgentForEmergencyCall",
            bool, is_required=True,
        ),
        E("emergency_call_clid_prefix", "emergencyCallCLIDPrefix", str, is_required=True),
    )

    #: str: *Required* defaultFromAddress
    default_from_address = Field(type=str, required=True, mutable=False)
    #: int: *Required* statisticsSamplingPeriodMinutes
    statistics_sampling_period_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* defaultEnableGuardTimer
    default_enable_guard_timer = Field(type=bool, required=True, mutable=False)
    #: int: *Required* defaultGuardTimerSeconds
    default_guard_timer_seconds = Field(type=int, required=True, mutable=False)
    #: bool: *Required* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int, required=True, mutable=False,
    )
    #: bool: *Required* defaultPlayRingWhenOfferCall
    default_play_ring_when_offer_call = Field(type=bool, required=True, mutable=False)
    #: str: *Required* uniformCallDistributionPolicyScope
    uniform_call_distribution_policy_scope = Field(type=str, required=True, mutable=False)
    #: int: *Required* callHandlingSamplingPeriodMinutes
    call_handling_sampling_period_minutes = Field(type=int, required=True, mutable=False)
    #: int: *Required* callHandlingMinimumSamplingSize
    call_handling_minimum_sampling_size = Field(type=int, required=True, mutable=False)
    #: bool: *Required* playToneToAgentForEmergencyCall
    play_tone_to_agent_for_emergency_call = Field(type=bool, required=True, mutable=False)
    #: str: *Required* emergencyCallCLIDPrefix
    emergency_call_clid_prefix = Field(type=str, required=True, mutable=False)


class SystemCallCenterGetResponse17sp4(OCIResponse):
    """
    Response to ``SystemCallCenterGetRequest17sp4()``.

    Replaced by: ``SystemCallCenterGetResponse19()``.
    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str, is_required=True),
        E(
            "statistics_sampling_period_minutes", "statisticsSamplingPeriodMinutes", int,
            is_required=True,
        ),
        E("default_enable_guard_timer", "defaultEnableGuardTimer", bool, is_required=True),
        E("default_guard_timer_seconds", "defaultGuardTimerSeconds", int, is_required=True),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool, is_required=True,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable", bool, is_required=True,
        ),
        E(
            "default_play_ring_when_offer_call", "defaultPlayRingWhenOfferCall", bool,
            is_required=True,
        ),
        E(
            "uniform_call_distribution_policy_scope",
            "uniformCallDistributionPolicyScope", str, is_required=True,
        ),
        E(
            "call_handling_sampling_period_minutes", "callHandlingSamplingPeriodMinutes",
            int, is_required=True,
        ),
        E(
            "call_handling_minimum_sampling_size", "callHandlingMinimumSamplingSize", int,
            is_required=True,
        ),
        E(
            "play_tone_to_agent_for_emergency_call", "playToneToAgentForEmergencyCall",
            bool, is_required=True,
        ),
        E("emergency_call_clid_prefix", "emergencyCallCLIDPrefix", str, is_required=True),
    )

    #: str: *Required* defaultFromAddress
    default_from_address = Field(type=str, required=True, mutable=False)
    #: int: *Required* statisticsSamplingPeriodMinutes
    statistics_sampling_period_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* defaultEnableGuardTimer
    default_enable_guard_timer = Field(type=bool, required=True, mutable=False)
    #: int: *Required* defaultGuardTimerSeconds
    default_guard_timer_seconds = Field(type=int, required=True, mutable=False)
    #: bool: *Required* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int, required=True, mutable=False,
    )
    #: bool: *Required* forceAgentUnavailableOnNotReachable
    force_agent_unavailable_on_not_reachable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* defaultPlayRingWhenOfferCall
    default_play_ring_when_offer_call = Field(type=bool, required=True, mutable=False)
    #: str: *Required* uniformCallDistributionPolicyScope
    uniform_call_distribution_policy_scope = Field(type=str, required=True, mutable=False)
    #: int: *Required* callHandlingSamplingPeriodMinutes
    call_handling_sampling_period_minutes = Field(type=int, required=True, mutable=False)
    #: int: *Required* callHandlingMinimumSamplingSize
    call_handling_minimum_sampling_size = Field(type=int, required=True, mutable=False)
    #: bool: *Required* playToneToAgentForEmergencyCall
    play_tone_to_agent_for_emergency_call = Field(type=bool, required=True, mutable=False)
    #: str: *Required* emergencyCallCLIDPrefix
    emergency_call_clid_prefix = Field(type=str, required=True, mutable=False)


class SystemCallCenterGetResponse19(OCIResponse):
    """
    Response to ``SystemCallCenterGetRequest19()``.

    Replaced by ``SystemCallCenterGetRequest21()``.
    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str, is_required=True),
        E(
            "statistics_sampling_period_minutes", "statisticsSamplingPeriodMinutes", int,
            is_required=True,
        ),
        E("default_enable_guard_timer", "defaultEnableGuardTimer", bool, is_required=True),
        E("default_guard_timer_seconds", "defaultGuardTimerSeconds", int, is_required=True),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool, is_required=True,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable", bool, is_required=True,
        ),
        E(
            "default_play_ring_when_offer_call", "defaultPlayRingWhenOfferCall", bool,
            is_required=True,
        ),
        E(
            "uniform_call_distribution_policy_scope",
            "uniformCallDistributionPolicyScope", str, is_required=True,
        ),
        E(
            "call_handling_sampling_period_minutes", "callHandlingSamplingPeriodMinutes",
            int, is_required=True,
        ),
        E(
            "call_handling_minimum_sampling_size", "callHandlingMinimumSamplingSize", int,
            is_required=True,
        ),
        E(
            "play_tone_to_agent_for_emergency_call", "playToneToAgentForEmergencyCall",
            bool, is_required=True,
        ),
        E("emergency_call_clid_prefix", "emergencyCallCLIDPrefix", str, is_required=True),
        E(
            "threshold_crossing_notification_email_guard_timer_seconds",
            "thresholdCrossingNotificationEmailGuardTimerSeconds", int, is_required=True,
        ),
    )

    #: str: *Required* defaultFromAddress
    default_from_address = Field(type=str, required=True, mutable=False)
    #: int: *Required* statisticsSamplingPeriodMinutes
    statistics_sampling_period_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* defaultEnableGuardTimer
    default_enable_guard_timer = Field(type=bool, required=True, mutable=False)
    #: int: *Required* defaultGuardTimerSeconds
    default_guard_timer_seconds = Field(type=int, required=True, mutable=False)
    #: bool: *Required* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int, required=True, mutable=False,
    )
    #: bool: *Required* forceAgentUnavailableOnNotReachable
    force_agent_unavailable_on_not_reachable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* defaultPlayRingWhenOfferCall
    default_play_ring_when_offer_call = Field(type=bool, required=True, mutable=False)
    #: str: *Required* uniformCallDistributionPolicyScope
    uniform_call_distribution_policy_scope = Field(type=str, required=True, mutable=False)
    #: int: *Required* callHandlingSamplingPeriodMinutes
    call_handling_sampling_period_minutes = Field(type=int, required=True, mutable=False)
    #: int: *Required* callHandlingMinimumSamplingSize
    call_handling_minimum_sampling_size = Field(type=int, required=True, mutable=False)
    #: bool: *Required* playToneToAgentForEmergencyCall
    play_tone_to_agent_for_emergency_call = Field(type=bool, required=True, mutable=False)
    #: str: *Required* emergencyCallCLIDPrefix
    emergency_call_clid_prefix = Field(type=str, required=True, mutable=False)
    #: int: *Required* thresholdCrossingNotificationEmailGuardTimerSeconds
    threshold_crossing_notification_email_guard_timer_seconds = Field(
        type=int, required=True, mutable=False,
    )


class SystemCallCenterGetResponse21(OCIResponse):
    """
    Response to ``SystemCallCenterGetRequest21()``.

    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str, is_required=True),
        E(
            "statistics_sampling_period_minutes", "statisticsSamplingPeriodMinutes", int,
            is_required=True,
        ),
        E("default_enable_guard_timer", "defaultEnableGuardTimer", bool, is_required=True),
        E("default_guard_timer_seconds", "defaultGuardTimerSeconds", int, is_required=True),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool, is_required=True,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable", bool, is_required=True,
        ),
        E(
            "default_play_ring_when_offer_call", "defaultPlayRingWhenOfferCall", bool,
            is_required=True,
        ),
        E(
            "uniform_call_distribution_policy_scope",
            "uniformCallDistributionPolicyScope", str, is_required=True,
        ),
        E(
            "call_handling_sampling_period_minutes", "callHandlingSamplingPeriodMinutes",
            int, is_required=True,
        ),
        E(
            "call_handling_minimum_sampling_size", "callHandlingMinimumSamplingSize", int,
            is_required=True,
        ),
        E(
            "play_tone_to_agent_for_emergency_call", "playToneToAgentForEmergencyCall",
            bool, is_required=True,
        ),
        E("emergency_call_clid_prefix", "emergencyCallCLIDPrefix", str, is_required=True),
        E(
            "threshold_crossing_notification_email_guard_timer_seconds",
            "thresholdCrossingNotificationEmailGuardTimerSeconds", int, is_required=True,
        ),
        E(
            "allow_agent_device_initiated_forward", "allowAgentDeviceInitiatedForward",
            bool, is_required=True,
        ),
    )

    #: str: *Required* defaultFromAddress
    default_from_address = Field(type=str, required=True, mutable=False)
    #: int: *Required* statisticsSamplingPeriodMinutes
    statistics_sampling_period_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* defaultEnableGuardTimer
    default_enable_guard_timer = Field(type=bool, required=True, mutable=False)
    #: int: *Required* defaultGuardTimerSeconds
    default_guard_timer_seconds = Field(type=int, required=True, mutable=False)
    #: bool: *Required* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int, required=True, mutable=False,
    )
    #: bool: *Required* forceAgentUnavailableOnNotReachable
    force_agent_unavailable_on_not_reachable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* defaultPlayRingWhenOfferCall
    default_play_ring_when_offer_call = Field(type=bool, required=True, mutable=False)
    #: str: *Required* uniformCallDistributionPolicyScope
    uniform_call_distribution_policy_scope = Field(type=str, required=True, mutable=False)
    #: int: *Required* callHandlingSamplingPeriodMinutes
    call_handling_sampling_period_minutes = Field(type=int, required=True, mutable=False)
    #: int: *Required* callHandlingMinimumSamplingSize
    call_handling_minimum_sampling_size = Field(type=int, required=True, mutable=False)
    #: bool: *Required* playToneToAgentForEmergencyCall
    play_tone_to_agent_for_emergency_call = Field(type=bool, required=True, mutable=False)
    #: str: *Required* emergencyCallCLIDPrefix
    emergency_call_clid_prefix = Field(type=str, required=True, mutable=False)
    #: int: *Required* thresholdCrossingNotificationEmailGuardTimerSeconds
    threshold_crossing_notification_email_guard_timer_seconds = Field(
        type=int, required=True, mutable=False,
    )
    #: bool: *Required* allowAgentDeviceInitiatedForward
    allow_agent_device_initiated_forward = Field(type=bool, required=True, mutable=False)


class SystemCallCenterReportingServerGetListResponse(OCIResponse):
    """
    Response to ``SystemCallCenterReportingServerGetListRequest()``.

    The table columns are: "Name", "URL", "Net Address", and "Description".
    """

    _ELEMENTS = (
        E(
            "reporting_server_table", "reportingServerTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    #: list: *Required* reportingServerTable  *Tabular*
    reporting_server_table = Field(type=list, required=True, mutable=False)


class SystemCallMeNowGetResponse(OCIResponse):
    """
    Response to ``SystemCallMeNowGetRequest()``.

    """

    _ELEMENTS = (
        E("passcode_length", "passcodeLength", int, is_required=True),
        E("passcode_timeout_seconds", "passcodeTimeoutSeconds", int, is_required=True),
    )

    #: int: *Required* passcodeLength
    passcode_length = Field(type=int, required=True, mutable=False)
    #: int: *Required* passcodeTimeoutSeconds
    passcode_timeout_seconds = Field(type=int, required=True, mutable=False)


class SystemCallNotifyGetResponse(OCIResponse):
    """
    Response to ``SystemCallNotifyGetRequest()``.

    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str, is_required=True),
        E("use_short_subject_line", "useShortSubjectLine", bool, is_required=True),
        E("use_dn_in_mail_body", "useDnInMailBody", bool, is_required=True),
    )

    #: str: *Required* defaultFromAddress
    default_from_address = Field(type=str, required=True, mutable=False)
    #: bool: *Required* useShortSubjectLine
    use_short_subject_line = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useDnInMailBody
    use_dn_in_mail_body = Field(type=bool, required=True, mutable=False)


class SystemCallProcessingGetPolicyResponse14(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest14()``.

    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: int: *Required* maxConferenceParties
    max_conference_parties = Field(type=int, required=True, mutable=False)


class SystemCallProcessingGetPolicyResponse14sp1(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest14sp1()``.

    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: int: *Required* maxConferenceParties
    max_conference_parties = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )


class SystemCallProcessingGetPolicyResponse14sp4(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest14sp4()``.

    Replaced By : ``SystemCallProcessingGetPolicyResponse15()``
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
            is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: int: *Required* maxConferenceParties
    max_conference_parties = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )


class SystemCallProcessingGetPolicyResponse14sp7(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest14sp7()``.

    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
            is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: int: *Required* maxConferenceParties
    max_conference_parties = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )


class SystemCallProcessingGetPolicyResponse15(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest15()``.

    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: int: *Required* maxConferenceParties
    max_conference_parties = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )


class SystemCallProcessingGetPolicyResponse15sp2(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest15sp2()``.

    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: int: *Required* maxConferenceParties
    max_conference_parties = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )


class SystemCallProcessingGetPolicyResponse16(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest16()``.

    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: int: *Required* maxConferenceParties
    max_conference_parties = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )


class SystemCallProcessingGetPolicyResponse16sp2(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest16sp2()``.

    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: int: *Required* maxConferenceParties
    max_conference_parties = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=True, mutable=False)


class SystemCallProcessingGetPolicyResponse17(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest17()``.

    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: int: *Required* maxConferenceParties
    max_conference_parties = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)


class SystemCallProcessingGetPolicyResponse17sp3(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest17sp3()``.

    The following elements are only used in AS data mode: enableDialableCallerID
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: int: *Required* maxConferenceParties
    max_conference_parties = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=True, mutable=False)


class SystemCallProcessingGetPolicyResponse17sp4(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest17sp4()``.

    The following elements are only used in AS data mode: enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: int: *Required* maxConferenceParties
    max_conference_parties = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )


class SystemCallProcessingGetPolicyResponse18sp1(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest18sp1()``.

    The following elements are only used in AS data mode: enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity enterpriseCallsCLIDPolicy
    enterpriseGroupCallsCLIDPolicy serviceProviderGroupCallsCLIDPolicy Replaced by:
    ``SystemCallProcessingGetPolicyResponse19sp1()``
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str, is_required=True),
        E(
            "enterprise_group_calls_clid_policy", "enterpriseGroupCallsCLIDPolicy", str,
            is_required=True,
        ),
        E(
            "service_provider_group_calls_clid_policy",
            "serviceProviderGroupCallsCLIDPolicy", str, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: int: *Required* maxConferenceParties
    max_conference_parties = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseGroupCallsCLIDPolicy
    enterprise_group_calls_clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceProviderGroupCallsCLIDPolicy
    service_provider_group_calls_clid_policy = Field(type=str, required=True, mutable=False)


class SystemCallProcessingGetPolicyResponse19sp1(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest19sp1()``.

    The following elements are only used in AS data mode: enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity enterpriseCallsCLIDPolicy
    enterpriseGroupCallsCLIDPolicy serviceProviderGroupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str, is_required=True),
        E(
            "enterprise_group_calls_clid_policy", "enterpriseGroupCallsCLIDPolicy", str,
            is_required=True,
        ),
        E(
            "service_provider_group_calls_clid_policy",
            "serviceProviderGroupCallsCLIDPolicy", str, is_required=True,
        ),
    )

    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* conferenceURI
    conference_uri = Field(type=str, required=False, mutable=False)
    #: int: *Required* maxConferenceParties
    max_conference_parties = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int, required=True, mutable=False,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseGroupCallsCLIDPolicy
    enterprise_group_calls_clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceProviderGroupCallsCLIDPolicy
    service_provider_group_calls_clid_policy = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileAutoAttendantProfileGetResponse(OCIResponse):
    """
    Response to ``SystemCallProcessingPolicyProfileAutoAttendantProfileGetRequest()``.

    """

    _ELEMENTS = (
        E("use_clid_policy", "useCLIDPolicy", bool, is_required=True),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "allow_department_clid_name_override", "allowDepartmentCLIDNameOverride",
            bool, is_required=True,
        ),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str, is_required=True),
        E(
            "enterprise_group_calls_clid_policy", "enterpriseGroupCallsCLIDPolicy", str,
            is_required=True,
        ),
        E(
            "service_provider_group_calls_clid_policy",
            "serviceProviderGroupCallsCLIDPolicy", str, is_required=True,
        ),
        E("use_call_limits_policy", "useCallLimitsPolicy", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_translation_routing_policy", "useTranslationRoutingPolicy", bool,
            is_required=True,
        ),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E("use_incoming_clid_policy", "useIncomingCLIDPolicy", bool, is_required=True),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
    )

    #: bool: *Required* useCLIDPolicy
    use_clid_policy = Field(type=bool, required=True, mutable=False)
    #: str: *Required* clidPolicy
    clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(type=bool, required=True, mutable=False)
    #: str: *Required* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* enterpriseGroupCallsCLIDPolicy
    enterprise_group_calls_clid_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceProviderGroupCallsCLIDPolicy
    service_provider_group_calls_clid_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* useCallLimitsPolicy
    use_call_limits_policy = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(type=int, required=True, mutable=False)
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(type=int, required=True, mutable=False)
    #: bool: *Required* useTranslationRoutingPolicy
    use_translation_routing_policy = Field(type=bool, required=True, mutable=False)
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extensio