"""Broadworks OCI-P Interface Type Classes"""
# Autogenerated from the Broadworks XML Schemas.
# Do not edit as changes will be overwritten.
# Generated on 2020-10-13T18:33:21.784178
# fmt: off
from classforge import Field

from .base import ElementInfo as E
from .base import OCIType


class AccessDevice(OCIType):
    """
    Uniquely identifies an Identity/device profile created anywhere in the system.

    """

    _ELEMENTS = (
        E("device_level", "deviceLevel", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Required* deviceLevel
    device_level = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class AccessDeviceKey(OCIType):
    """
    Key to uniquely identify a system, service provider, or group device.

    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str),
        E("group_id", "groupId", str),
        E("device_name", "deviceName", str, is_required=True),
    )

    #: str: *Optional* serviceProviderId
    service_provider_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* groupId
    group_id = Field(type=str, required=False, mutable=False)
    #: str: *Required* deviceName
    device_name = Field(type=str, required=True, mutable=False)


class AccountAuthorizationCodeEntry(OCIType):
    """
    Account/Authorization Code.

    """

    _ELEMENTS = (
        E("code", "code", str, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class AgentStatistics(OCIType):
    """
    Contains Call Center Agent statistics for a given time frame.

    """

    _ELEMENTS = (
        E("number_of_calls_handled", "numberOfCallsHandled", int, is_required=True),
        E("number_of_calls_unanswered", "numberOfCallsUnanswered", int, is_required=True),
        E("average_call_seconds", "averageCallSeconds", int, is_required=True),
        E("total_talk_seconds", "totalTalkSeconds", int, is_required=True),
        E("total_staffed_seconds", "totalStaffedSeconds", int, is_required=True),
    )

    #: int: *Required* numberOfCallsHandled
    number_of_calls_handled = Field(type=int, required=True, mutable=False)
    #: int: *Required* numberOfCallsUnanswered
    number_of_calls_unanswered = Field(type=int, required=True, mutable=False)
    #: int: *Required* averageCallSeconds
    average_call_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* totalTalkSeconds
    total_talk_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* totalStaffedSeconds
    total_staffed_seconds = Field(type=int, required=True, mutable=False)


class AlternateNumberEntry(OCIType):
    """
    Alternate Number Entry.

    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("ring_pattern", "ringPattern", str),
    )

    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: str: *Optional* ringPattern
    ring_pattern = Field(type=str, required=False, mutable=False)


class AlternateNumberEntry17(OCIType):
    """
    Alternate Number Entry.

    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("ring_pattern", "ringPattern", str),
    )

    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: str: *Optional* ringPattern
    ring_pattern = Field(type=str, required=False, mutable=False)


class AlternateNumberEntry21(OCIType):
    """
    Alternate Number Entry.

    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("ring_pattern", "ringPattern", str),
        E("description", "description", str),
    )

    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: str: *Optional* ringPattern
    ring_pattern = Field(type=str, required=False, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class AnnouncementFileKey(OCIType):
    """
    Uniquely identifies a file within a group or user repository.

    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("media_file_type", "mediaFileType", str, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* mediaFileType
    media_file_type = Field(type=str, required=True, mutable=False)


class AnnouncementFileLevelKey(OCIType):
    """
    Uniquely identifies a file within a group or user repository.

    Includes level to distinguish between group and user announcements in scenarios where
    both are listed.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("media_file_type", "mediaFileType", str, is_required=True),
        E("level", "level", str, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* mediaFileType
    media_file_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* level
    level = Field(type=str, required=True, mutable=False)


class AssignedGroupServicesEntry(OCIType):
    """
    Assigned Group Services List Entry.

    The isActive element is true, false, or could be missing completely.
    """

    _ELEMENTS = (
        E("service_name", "serviceName", str, is_required=True),
        E("is_active", "isActive", bool),
    )

    #: str: *Required* serviceName
    service_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* isActive
    is_active = Field(type=bool, required=False, mutable=False)


class AssignedUserServicesEntry(OCIType):
    """
    Assigned User Services List Entry.

    The isActive element is true, false, or could be missing completely.
    """

    _ELEMENTS = (
        E("service_name", "serviceName", str, is_required=True),
        E("is_active", "isActive", bool),
    )

    #: str: *Required* serviceName
    service_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* isActive
    is_active = Field(type=bool, required=False, mutable=False)


class AttendantConsoleReplacementDisplayColumnList(OCIType):
    """
    A list of attendant console display columns that replaces a previously configured
    list.

    By convention, an element of this type may be set nil to clear the list.
    """

    _ELEMENTS = (
        E("display_column", "displayColumn", str, is_required=True),
    )

    #: str: *Required* displayColumn
    display_column = Field(type=str, required=True, mutable=False)


class AutoAttendantKeyConfigurationReadEntry(OCIType):
    """
    The read configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: audioFileDescription
    audioMediaType videoFileDescription videoMediaType
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("action", "action", str, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
    )

    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMediaType
    audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMediaType
    video_media_type = Field(type=str, required=False, mutable=False)


class AutoAttendantKeyConfigurationReadEntry19(OCIType):
    """
    The read configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: audioFileDescription
    audioMediaType videoFileDescription videoMediaType submenuId The following data
    elements are only valid for Standard Auto Attendants: submenuId
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("action", "action", str, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E("submenu_id", "submenuId", str),
    )

    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMediaType
    audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMediaType
    video_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* submenuId
    submenu_id = Field(type=str, required=False, mutable=False)


class BasicCallLogsEntry(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.

    Replaced By: CallLogsEntry
    """

    _ELEMENTS = (
        E("country_code", "countryCode", str),
        E("phone_number", "phoneNumber", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("time", "time", str, is_required=True),
    )

    #: str: *Optional* countryCode
    country_code = Field(type=str, required=False, mutable=False)
    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* time
    time = Field(type=str, required=True, mutable=False)


class BroadWorksMobilityAlertingMobileNumberReplacementList(OCIType):
    """
    A list of Mobile Numbers to be alerted.

    By convention, an element of this type may be set nil to clear the list.
    """

    _ELEMENTS = (
        E("mobile_number", "mobileNumber", str, is_required=True),
    )

    #: str: *Required* mobileNumber
    mobile_number = Field(type=str, required=True, mutable=False)


class BroadWorksMobilityUserMobileIdentityEntry(OCIType):
    """
    User's Mobile Identity Read Entry
    """

    _ELEMENTS = (
        E("mobile_number", "mobileNumber", str, is_required=True),
        E("description", "description", str),
        E("is_primary", "isPrimary", bool, is_required=True),
        E("enable_alerting", "enableAlerting", bool, is_required=True),
    )

    #: str: *Required* mobileNumber
    mobile_number = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: bool: *Required* isPrimary
    is_primary = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableAlerting
    enable_alerting = Field(type=bool, required=True, mutable=False)


class BroadWorksMobilityUserMobileIdentityModifyEntry(OCIType):
    """
    User's Mobile Identity Modify Entry
    """

    _ELEMENTS = (
        E("mobile_number", "mobileNumber", str, is_required=True),
        E("description", "description", str),
        E("is_primary", "isPrimary", bool),
        E("enable_alerting", "enableAlerting", bool),
    )

    #: str: *Required* mobileNumber
    mobile_number = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* isPrimary
    is_primary = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableAlerting
    enable_alerting = Field(type=bool, required=False, mutable=False)


class CPEDeviceOptions(OCIType):
    """
    CPE device's options.

    Replaced by: CPEDeviceOptions14sp6
    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool, is_required=True),
        E("reset_event", "resetEvent", str),
        E("config_type", "configType", str, is_required=True),
        E("system_file_name", "systemFileName", str, is_required=True),
        E("device_file_format", "deviceFileFormat", str, is_required=True),
    )

    #: bool: *Required* enableMonitoring
    enable_monitoring = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* resetEvent
    reset_event = Field(type=str, required=False, mutable=False)
    #: str: *Required* configType
    config_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* systemFileName
    system_file_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceFileFormat
    device_file_format = Field(type=str, required=True, mutable=False)


class CallCenterAgentAvailability(OCIType):
    """
    Specifies an agent's login state (availability) for a particular Call Center.

    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("available", "available", bool, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Required* available
    available = Field(type=bool, required=True, mutable=False)


class CallCenterAgentDailyStatistics13mp8(OCIType):
    """
    Contains Call Center Agent statistics for one day.

    """

    _ELEMENTS = (
        E("number_of_calls_received", "numberOfCallsReceived", int, is_required=True),
        E("number_of_calls_not_answered", "numberOfCallsNotAnswered", int, is_required=True),
        E(
            "average_time_per_call_seconds", "averageTimePerCallSeconds", int,
            is_required=True,
        ),
        E("time_in_calls_seconds", "timeInCallsSeconds", int, is_required=True),
        E("time_logged_off_seconds", "timeLoggedOffSeconds", int, is_required=True),
        E(
            "time_logged_on_and_idle_seconds", "timeLoggedOnAndIdleSeconds", int,
            is_required=True,
        ),
    )

    #: int: *Required* numberOfCallsReceived
    number_of_calls_received = Field(type=int, required=True, mutable=False)
    #: int: *Required* numberOfCallsNotAnswered
    number_of_calls_not_answered = Field(type=int, required=True, mutable=False)
    #: int: *Required* averageTimePerCallSeconds
    average_time_per_call_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* timeInCallsSeconds
    time_in_calls_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* timeLoggedOffSeconds
    time_logged_off_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* timeLoggedOnAndIdleSeconds
    time_logged_on_and_idle_seconds = Field(type=int, required=True, mutable=False)


class CallCenterAgentSettings(OCIType):
    """
    Specifies an agent's settings for a particular Call Center.

    The skillLevel only applies to Premium agents.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("available", "available", bool),
        E("skill_level", "skillLevel", int),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* available
    available = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* skillLevel
    skill_level = Field(type=int, required=False, mutable=False)


class CallCenterAgentThresholdProfileReplacementNotificationEmailList(OCIType):
    """
    List of email addresses to which the Agent Threshold Profile email is sent.

    The list replaces a previously configured list.
    """

    _ELEMENTS = (
        E("email_address", "emailAddress", str, is_required=True),
    )

    #: str: *Required* emailAddress
    email_address = Field(type=str, required=True, mutable=False)


class CallCenterAgentUnavailableCodeStateModify(OCIType):
    """
    Contains a Call Center Agent Unavailable Code and its active state
    """

    _ELEMENTS = (
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
    )

    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)


class CallCenterAnnouncementDescriptionList(OCIType):
    """
    Contains list of file descriptions for audio or video files
    """

    _ELEMENTS = (
        E("file_description1", "fileDescription1", str),
        E("file_description2", "fileDescription2", str),
        E("file_description3", "fileDescription3", str),
        E("file_description4", "fileDescription4", str),
    )

    #: str: *Optional* fileDescription1
    file_description1 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* fileDescription2
    file_description2 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* fileDescription3
    file_description3 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* fileDescription4
    file_description4 = Field(type=str, required=False, mutable=False)


class CallCenterAnnouncementMediaFileTypeList(OCIType):
    """
    Contains list of file media types for audio or video files
    """

    _ELEMENTS = (
        E("media_type1", "mediaType1", str),
        E("media_type2", "mediaType2", str),
        E("media_type3", "mediaType3", str),
        E("media_type4", "mediaType4", str),
    )

    #: str: *Optional* mediaType1
    media_type1 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* mediaType2
    media_type2 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* mediaType3
    media_type3 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* mediaType4
    media_type4 = Field(type=str, required=False, mutable=False)


class CallCenterAnnouncementURLList(OCIType):
    """
    Contains list of urls
    """

    _ELEMENTS = (
        E("url1", "url1", str),
        E("url2", "url2", str),
        E("url3", "url3", str),
        E("url4", "url4", str),
    )

    #: str: *Optional* url1
    url1 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* url2
    url2 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* url3
    url3 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* url4
    url4 = Field(type=str, required=False, mutable=False)


class CallCenterAnnouncementURLListModify(OCIType):
    """
    Contains a list of URLs for modify.

    """

    _ELEMENTS = (
        E("url1", "url1", str),
        E("url2", "url2", str),
        E("url3", "url3", str),
        E("url4", "url4", str),
    )

    #: str: *Optional* url1
    url1 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* url2
    url2 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* url3
    url3 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* url4
    url4 = Field(type=str, required=False, mutable=False)


class CallCenterMusicOnHoldSourceModify(OCIType):
    """
    Contains the music on hold source configuration.

    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str),
        E("message_source_selection", "messageSourceSelection", str),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
    )

    #: str: *Optional* audioFilePreferredCodec
    audio_file_preferred_codec = Field(type=str, required=False, mutable=False)
    #: str: *Optional* messageSourceSelection
    message_source_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)


class CallCenterMusicOnHoldSourceRead(OCIType):
    """
    Contains the music on hold source configuration.

    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
    )

    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(type=str, required=True, mutable=False)
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)


class CallCenterQueueStatistics13mp8(OCIType):
    """
    Contains Call Center Queue statistics.

    """

    _ELEMENTS = (
        E("number_of_incoming_calls", "numberOfIncomingCalls", int, is_required=True),
        E("number_of_calls_queued", "numberOfCallsQueued", int, is_required=True),
        E("number_of_busy_overflows", "numberOfBusyOverflows", int, is_required=True),
        E("number_of_calls_answered", "numberOfCallsAnswered", int, is_required=True),
        E(
            "average_time_with_agent_seconds", "averageTimeWithAgentSeconds", int,
            is_required=True,
        ),
        E(
            "average_time_in_queue_seconds", "averageTimeInQueueSeconds", int,
            is_required=True,
        ),
        E(
            "average_number_of_agents_busy", "averageNumberOfAgentsBusy", int,
            is_required=True,
        ),
        E(
            "average_number_of_agents_logged_off", "averageNumberOfAgentsLoggedOff", int,
            is_required=True,
        ),
        E(
            "average_hold_time_before_call_loss_seconds",
            "averageHoldTimeBeforeCallLossSeconds", int, is_required=True,
        ),
    )

    #: int: *Required* numberOfIncomingCalls
    number_of_incoming_calls = Field(type=int, required=True, mutable=False)
    #: int: *Required* numberOfCallsQueued
    number_of_calls_queued = Field(type=int, required=True, mutable=False)
    #: int: *Required* numberOfBusyOverflows
    number_of_busy_overflows = Field(type=int, required=True, mutable=False)
    #: int: *Required* numberOfCallsAnswered
    number_of_calls_answered = Field(type=int, required=True, mutable=False)
    #: int: *Required* averageTimeWithAgentSeconds
    average_time_with_agent_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* averageTimeInQueueSeconds
    average_time_in_queue_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* averageNumberOfAgentsBusy
    average_number_of_agents_busy = Field(type=int, required=True, mutable=False)
    #: int: *Required* averageNumberOfAgentsLoggedOff
    average_number_of_agents_logged_off = Field(type=int, required=True, mutable=False)
    #: int: *Required* averageHoldTimeBeforeCallLossSeconds
    average_hold_time_before_call_loss_seconds = Field(type=int, required=True, mutable=False)


class CallCenterQueueStatistics14sp9(OCIType):
    """
    Contains Call Center Queue statistics.

    """

    _ELEMENTS = (
        E("number_of_busy_overflows", "numberOfBusyOverflows", int, is_required=True),
        E("number_of_calls_answered", "numberOfCallsAnswered", int, is_required=True),
        E("number_of_calls_abandoned", "numberOfCallsAbandoned", int, is_required=True),
        E("number_of_calls_transferred", "numberOfCallsTransferred", int, is_required=True),
        E("number_of_calls_timedout", "numberOfCallsTimedout", int, is_required=True),
        E(
            "average_number_of_agents_talking", "averageNumberOfAgentsTalking", int,
            is_required=True,
        ),
        E(
            "average_number_of_agents_staffed", "averageNumberOfAgentsStaffed", int,
            is_required=True,
        ),
        E("average_wait_seconds", "averageWaitSeconds", int, is_required=True),
        E("average_abandonment_seconds", "averageAbandonmentSeconds", int, is_required=True),
    )

    #: int: *Required* numberOfBusyOverflows
    number_of_busy_overflows = Field(type=int, required=True, mutable=False)
    #: int: *Required* numberOfCallsAnswered
    number_of_calls_answered = Field(type=int, required=True, mutable=False)
    #: int: *Required* numberOfCallsAbandoned
    number_of_calls_abandoned = Field(type=int, required=True, mutable=False)
    #: int: *Required* numberOfCallsTransferred
    number_of_calls_transferred = Field(type=int, required=True, mutable=False)
    #: int: *Required* numberOfCallsTimedout
    number_of_calls_timedout = Field(type=int, required=True, mutable=False)
    #: int: *Required* averageNumberOfAgentsTalking
    average_number_of_agents_talking = Field(type=int, required=True, mutable=False)
    #: int: *Required* averageNumberOfAgentsStaffed
    average_number_of_agents_staffed = Field(type=int, required=True, mutable=False)
    #: int: *Required* averageWaitSeconds
    average_wait_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* averageAbandonmentSeconds
    average_abandonment_seconds = Field(type=int, required=True, mutable=False)


class CallCenterQueueThresholdReplacementNotificationEmailList(OCIType):
    """
    List of email addresses to which the Call Center Queue Threshold email is sent.

    The list replaces a previously configured list.
    """

    _ELEMENTS = (
        E("email_address", "emailAddress", str, is_required=True),
    )

    #: str: *Required* emailAddress
    email_address = Field(type=str, required=True, mutable=False)


class CallCenterReportAbandonedCallThresholdReplacementList(OCIType):
    """
    A list of call center reporting abandoned call threshold seconds that replaces a
    previously configured list.

    """

    _ELEMENTS = (
        E(
            "abandoned_call_threshold_seconds", "abandonedCallThresholdSeconds", int,
            is_required=True,
        ),
    )

    #: int: *Required* abandonedCallThresholdSeconds
    abandoned_call_threshold_seconds = Field(type=int, required=True, mutable=False)


class CallCenterReportCurrentInterval(OCIType):
    """
    The call center enhanced reporting report current interval, for example, current week.

    """

    _ELEMENTS = (
        E("time_unit", "timeUnit", str, is_required=True),
    )

    #: str: *Required* timeUnit
    time_unit = Field(type=str, required=True, mutable=False)


class CallCenterReportDataTemplateInfo(OCIType):
    """
    Call center reporting data template info.

    """

    _ELEMENTS = (
        E("data_template", "dataTemplate", str, is_required=True),
        E("report_type", "reportType", str, is_required=True),
        E("is_realtime_report", "isRealtimeReport", bool, is_required=True),
        E("is_agent_param_required", "isAgentParamRequired", str, is_required=True),
        E(
            "is_call_center_param_required", "isCallCenterParamRequired", str,
            is_required=True,
        ),
        E(
            "is_call_center_dnis_param_required", "isCallCenterDnisParamRequired", str,
            is_required=True,
        ),
        E(
            "is_sampling_period_param_required", "isSamplingPeriodParamRequired", str,
            is_required=True,
        ),
        E(
            "is_call_completion_threshold_param_required",
            "isCallCompletionThresholdParamRequired", str, is_required=True,
        ),
        E(
            "is_short_duration_threshold_param_required",
            "isShortDurationThresholdParamRequired", str, is_required=True,
        ),
        E(
            "is_service_level_threshold_param_required",
            "isServiceLevelThresholdParamRequired", str, is_required=True,
        ),
        E(
            "is_service_level_inclusions_param_required",
            "isServiceLevelInclusionsParamRequired", str, is_required=True,
        ),
        E(
            "is_service_level_objective_threshold_param_required",
            "isServiceLevelObjectiveThresholdParamRequired", str, is_required=True,
        ),
        E(
            "is_abandoned_call_threshold_param_required",
            "isAbandonedCallThresholdParamRequired", str, is_required=True,
        ),
    )

    #: str: *Required* dataTemplate
    data_template = Field(type=str, required=True, mutable=False)
    #: str: *Required* reportType
    report_type = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isRealtimeReport
    is_realtime_report = Field(type=bool, required=True, mutable=False)
    #: str: *Required* isAgentParamRequired
    is_agent_param_required = Field(type=str, required=True, mutable=False)
    #: str: *Required* isCallCenterParamRequired
    is_call_center_param_required = Field(type=str, required=True, mutable=False)
    #: str: *Required* isCallCenterDnisParamRequired
    is_call_center_dnis_param_required = Field(type=str, required=True, mutable=False)
    #: str: *Required* isSamplingPeriodParamRequired
    is_sampling_period_param_required = Field(type=str, required=True, mutable=False)
    #: str: *Required* isCallCompletionThresholdParamRequired
    is_call_completion_threshold_param_required = Field(
        type=str, required=True, mutable=False,
    )
    #: str: *Required* isShortDurationThresholdParamRequired
    is_short_duration_threshold_param_required = Field(type=str, required=True, mutable=False)
    #: str: *Required* isServiceLevelThresholdParamRequired
    is_service_level_threshold_param_required = Field(type=str, required=True, mutable=False)
    #: str: *Required* isServiceLevelInclusionsParamRequired
    is_service_level_inclusions_param_required = Field(type=str, required=True, mutable=False)
    #: str: *Required* isServiceLevelObjectiveThresholdParamRequired
    is_service_level_objective_threshold_param_required = Field(
        type=str, required=True, mutable=False,
    )
    #: str: *Required* isAbandonedCallThresholdParamRequired
    is_abandoned_call_threshold_param_required = Field(type=str, required=True, mutable=False)


class CallCenterReportDataTemplateQueryFilterValueReplacementList(OCIType):
    """
    A list of call center reporting data template query filter values that replaces a
    previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("filter_value", "filterValue", str, is_required=True),
    )

    #: str: *Required* filterValue
    filter_value = Field(type=str, required=True, mutable=False)


class CallCenterReportPastInterval(OCIType):
    """
    The call center enhanced reporting report past interval, for example, last 24 month.

    """

    _ELEMENTS = (
        E("number", "number", int, is_required=True),
        E("time_unit", "timeUnit", str, is_required=True),
    )

    #: int: *Required* number
    number = Field(type=int, required=True, mutable=False)
    #: str: *Required* timeUnit
    time_unit = Field(type=str, required=True, mutable=False)


class CallCenterReportReplacementEmailList(OCIType):
    """
    A list of call center reporting email addresses that replaces a previously configured
    list.

    """

    _ELEMENTS = (
        E("email_address", "emailAddress", str, is_required=True),
    )

    #: str: *Required* emailAddress
    email_address = Field(type=str, required=True, mutable=False)


class CallCenterReportServiceLevelThresholdReplacementList(OCIType):
    """
    A list of call center reporting service level threshold seconds that replaces a
    previously configured list.

    """

    _ELEMENTS = (
        E(
            "service_level_threshold_seconds", "serviceLevelThresholdSeconds", int,
            is_required=True,
        ),
    )

    #: int: *Required* serviceLevelThresholdSeconds
    service_level_threshold_seconds = Field(type=int, required=True, mutable=False)


class CallCenterReportTemplateKey(OCIType):
    """
    Uniquely identifies a call center report template created in the system.

    """

    _ELEMENTS = (
        E("template_level", "templateLevel", str, is_required=True),
        E("template_name", "templateName", str, is_required=True),
    )

    #: str: *Required* templateLevel
    template_level = Field(type=str, required=True, mutable=False)
    #: str: *Required* templateName
    template_name = Field(type=str, required=True, mutable=False)


class CallCenterRoutingPriorityOrder(OCIType):
    """
    Call center routing order
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("priority", "priority", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* priority
    priority = Field(type=str, required=True, mutable=False)


class CallCenterScheduledReportAgentSelection(OCIType):
    """
    Either all agents or list of agents.

    """

    _ELEMENTS = (
        E("all_agent", "allAgent", bool),
        E("agent_user_id", "agentUserId", str),
    )

    #: bool: *Optional* allAgent
    all_agent = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* agentUserId
    agent_user_id = Field(type=str, required=False, mutable=False)


class CallCenterScheduledReportAgentSelectionAdminRead(OCIType):
    """
    Either all agents or 2 list of agents: one for current and one for past (deleted)
    agents.

    This is used when an admin reads a Scheduled Report.  Each agent table has the
    following column headings: "User Id", "Last Name", "First Name", "Hiragana Last Name"
    and "Hiragana First Name".
    """

    _ELEMENTS = (
        E("all_agent", "allAgent", bool),
        E(
            "current_agent_table", "currentAgentTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
        E(
            "past_agent_table", "pastAgentTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    #: bool: *Optional* allAgent
    all_agent = Field(type=bool, required=False, mutable=False)
    #: list: *Required* currentAgentTable  *Tabular*
    current_agent_table = Field(type=list, required=True, mutable=False)
    #: list: *Required* pastAgentTable  *Tabular*
    past_agent_table = Field(type=list, required=True, mutable=False)


class CallCenterScheduledReportAgentSelectionRead(OCIType):
    """
    Either all agents or list of agents.

    The agent table has the following column headings: "User Id", "Last Name", "First
    Name", "Hiragana Last Name" and "Hiragana First Name".
    """

    _ELEMENTS = (
        E("all_agent", "allAgent", bool),
        E("agent_table", "agentTable", list, is_complex=True, is_table=True),
    )

    #: bool: *Optional* allAgent
    all_agent = Field(type=bool, required=False, mutable=False)
    #: list: *Optional* agentTable  *Tabular*
    agent_table = Field(type=list, required=False, mutable=False)


class CallCenterScheduledReportCallCenterSelection(OCIType):
    """
    Either all call centers or list of call centers.

    """

    _ELEMENTS = (
        E("all_call_center", "allCallCenter", bool),
        E("service_user_id", "serviceUserId", str),
    )

    #: bool: *Optional* allCallCenter
    all_call_center = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* serviceUserId
    service_user_id = Field(type=str, required=False, mutable=False)


class CallCenterScheduledReportCallCenterSelectionRead(OCIType):
    """
    User for admin read.

    Either all call centers or 2 lists of call centers: one for current and one for
    deleted call centers.
    """

    _ELEMENTS = (
        E("all_call_center", "allCallCenter", bool),
        E("current_user_id", "currentUserId", str),
        E("past_user_id", "pastUserId", str),
    )

    #: bool: *Optional* allCallCenter
    all_call_center = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* currentUserId
    current_user_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* pastUserId
    past_user_id = Field(type=str, required=False, mutable=False)


class CallCenterScheduledReportDNISSelection(OCIType):
    """
    Either all DNIS under the specified Call Center or list of DNIS.

    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("all_dnis", "allDNIS", bool),
        E("name", "name", str),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* allDNIS
    all_dnis = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* name
    name = Field(type=str, required=False, mutable=False)


class CallCenterScheduledReportDNISSelectionRead(OCIType):
    """
    Either all DNIS under the specified Call Center or 2 lists of DNIS, one for current
    one for past (deleted).

    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("deleted", "deleted", bool),
        E("all_dnis", "allDNIS", bool),
        E("current_name", "currentName", str),
        E("past_name", "pastName", str),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* deleted
    deleted = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allDNIS
    all_dnis = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* currentName
    current_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* pastName
    past_name = Field(type=str, required=False, mutable=False)


class CallCenterScheduledReportServiceLevelInclusions(OCIType):
    """
    The call center enhanced reporting scheduled report inclusions related to the Service
    Level thresholds
    """

    _ELEMENTS = (
        E(
            "include_overflow_time_transfered_in_service_level",
            "includeOverflowTimeTransferedInServiceLevel", bool, is_required=True,
        ),
        E(
            "include_other_transfers_in_service_level",
            "includeOtherTransfersInServiceLevel", bool, is_required=True,
        ),
        E(
            "abandoned_calls_in_service_level", "abandonedCallsInServiceLevel", str,
            is_required=True,
        ),
        E("abandoned_call_interval_seconds", "abandonedCallIntervalSeconds", int),
    )

    #: bool: *Required* includeOverflowTimeTransferedInServiceLevel
    include_overflow_time_transfered_in_service_level = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* includeOtherTransfersInServiceLevel
    include_other_transfers_in_service_level = Field(type=bool, required=True, mutable=False)
    #: str: *Required* abandonedCallsInServiceLevel
    abandoned_calls_in_service_level = Field(type=str, required=True, mutable=False)
    #: int: *Optional* abandonedCallIntervalSeconds
    abandoned_call_interval_seconds = Field(type=int, required=False, mutable=False)


class CallCenterScheduledReportServiceLevelInclusionsModify(OCIType):
    """
    The call center enhanced reporting scheduled report modified inclusions related to the
    Service Level thresholds
    """

    _ELEMENTS = (
        E(
            "include_overflow_time_transfered_in_service_level",
            "includeOverflowTimeTransferedInServiceLevel", bool,
        ),
        E(
            "include_other_transfers_in_service_level",
            "includeOtherTransfersInServiceLevel", bool,
        ),
        E("abandoned_calls_in_service_level", "abandonedCallsInServiceLevel", str),
        E("abandoned_call_interval_seconds", "abandonedCallIntervalSeconds", int),
    )

    #: bool: *Optional* includeOverflowTimeTransferedInServiceLevel
    include_overflow_time_transfered_in_service_level = Field(
        type=bool, required=False, mutable=False,
    )
    #: bool: *Optional* includeOtherTransfersInServiceLevel
    include_other_transfers_in_service_level = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* abandonedCallsInServiceLevel
    abandoned_calls_in_service_level = Field(type=str, required=False, mutable=False)
    #: int: *Optional* abandonedCallIntervalSeconds
    abandoned_call_interval_seconds = Field(type=int, required=False, mutable=False)


class CallCenterSkillAgentList(OCIType):
    """
    A list of agents for a particular skill Level.

    """

    _ELEMENTS = (
        E("skill_level", "skillLevel", int, is_required=True),
        E("agent", "agent", str, is_array=True),
    )

    #: int: *Required* skillLevel
    skill_level = Field(type=int, required=True, mutable=False)
    #: list(str): *Optional* agent  *Array*
    agent = Field(type=list, required=False, mutable=False)


class CallCenterStatisticsRange(OCIType):
    """
    Statistics Range
    """

    _ELEMENTS = (
        E("start", "start", str, is_required=True),
        E("end", "end", str),
    )

    #: str: *Required* start
    start = Field(type=str, required=True, mutable=False)
    #: str: *Optional* end
    end = Field(type=str, required=False, mutable=False)


class CallDispositionCodeActivation(OCIType):
    """
    Contains a Call Center Call Disposition Code and its active state
    """

    _ELEMENTS = (
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
    )

    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)


class CallDispositionCodeWithLevel(OCIType):
    """
    Contains a Call Center Call Disposition Code and its Level
    """

    _ELEMENTS = (
        E("code", "code", str, is_required=True),
        E("level", "level", str, is_required=True),
    )

    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: str: *Required* level
    level = Field(type=str, required=True, mutable=False)


class CallLogsEntry(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.

    """

    _ELEMENTS = (
        E("country_code", "countryCode", str),
        E("call_log_id", "callLogId", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("time", "time", str, is_required=True),
    )

    #: str: *Optional* countryCode
    country_code = Field(type=str, required=False, mutable=False)
    #: str: *Required* callLogId
    call_log_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* time
    time = Field(type=str, required=True, mutable=False)


class CallMeNowToDnCriteria(OCIType):
    """
    The To dn criteria used on the call me now external number.

    """

    _ELEMENTS = (
        E("to_dn_criteria_selection", "toDnCriteriaSelection", str, is_required=True),
        E("phone_number", "phoneNumber", str),
    )

    #: str: *Required* toDnCriteriaSelection
    to_dn_criteria_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)


class CallToNumber(OCIType):
    """
    Call to Number.

    """

    _ELEMENTS = (
        E("type", "type", str, is_required=True),
        E("number", "number", str),
        E("extension", "extension", str),
    )

    #: str: *Required* type
    type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* number
    number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)


class CollaborateBridgeMaximumParticipants(OCIType):
    """
    Maximum number of Collaborate bridge participants.

    Can either be unlimited or limited to a value between 3 and 999999.
    """

    _ELEMENTS = (
        E("unlimited", "unlimited", bool),
        E("quantity", "quantity", int),
    )

    #: bool: *Optional* unlimited
    unlimited = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* quantity
    quantity = Field(type=int, required=False, mutable=False)


class CollaborateGracePeriodDuration(OCIType):
    """
    Collaborate grace period duration.

    """

    _ELEMENTS = (
        E("hours", "hours", int, is_required=True),
        E("minutes", "minutes", int, is_required=True),
    )

    #: int: *Required* hours
    hours = Field(type=int, required=True, mutable=False)
    #: int: *Required* minutes
    minutes = Field(type=int, required=True, mutable=False)


class CollaborateRoomSchedule(OCIType):
    """
    Collaborate room schedule.

    """

    _ELEMENTS = (
        E(
            "schedule_reservationless", "scheduleReservationless", str, is_complex=True,
        ),  # unknown
        E("schedule_one_time", "scheduleOneTime", str, is_complex=True),  # unknown
        E("schedule_recurring", "scheduleRecurring", str, is_complex=True),  # unknown
    )

    #: str: *Optional* scheduleReservationless
    schedule_reservationless = Field(type=str, required=False, mutable=False)
    #: str: *Optional* scheduleOneTime
    schedule_one_time = Field(type=str, required=False, mutable=False)
    #: str: *Optional* scheduleRecurring
    schedule_recurring = Field(type=str, required=False, mutable=False)


class CollaborateRoomScheduleDuration(OCIType):
    """
    Collaborate room schedule duration.

    """

    _ELEMENTS = (
        E("hours", "hours", int, is_required=True),
        E("minutes", "minutes", int, is_required=True),
    )

    #: int: *Required* hours
    hours = Field(type=int, required=True, mutable=False)
    #: int: *Required* minutes
    minutes = Field(type=int, required=True, mutable=False)


class CommPilotExpressEmailNotify(OCIType):
    """
    CommPilot Express Email Notify configuration used in the context of a get.

    """

    _ELEMENTS = (
        E("send_email", "sendEmail", bool, is_required=True),
        E("email_address", "emailAddress", str),
    )

    #: bool: *Required* sendEmail
    send_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* emailAddress
    email_address = Field(type=str, required=False, mutable=False)


class CommPilotExpressEmailNotifyModify(OCIType):
    """
    CommPilot Express Email Notify configuration used in the context of a modify.

    """

    _ELEMENTS = (
        E("send_email", "sendEmail", bool),
        E("email_address", "emailAddress", str),
    )

    #: bool: *Optional* sendEmail
    send_email = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* emailAddress
    email_address = Field(type=str, required=False, mutable=False)


class CommPilotExpressRedirection(OCIType):
    """
    CommPilot Express type to transfer to voice Mail or forward to a number used in the
    context of a get.

    """

    _ELEMENTS = (
        E("action", "action", str, is_required=True),
        E("forwarding_phone_number", "forwardingPhoneNumber", str),
    )

    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* forwardingPhoneNumber
    forwarding_phone_number = Field(type=str, required=False, mutable=False)


class CommPilotExpressRedirectionModify(OCIType):
    """
    CommPilot Express type to transfer to voice Mail or forward to a number used in the
    context of a modify.

    """

    _ELEMENTS = (
        E("action", "action", str),
        E("forwarding_phone_number", "forwardingPhoneNumber", str),
    )

    #: str: *Optional* action
    action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* forwardingPhoneNumber
    forwarding_phone_number = Field(type=str, required=False, mutable=False)


class CommPilotExpressRedirectionWithException(OCIType):
    """
    CommPilot Express type to transfer to voice mail or forward to a number with certain
    exceptions used in the context of a get.

    """

    _ELEMENTS = (
        E(
            "send_calls_to_voice_mail_except_excluded_numbers",
            "sendCallsToVoiceMailExceptExcludedNumbers", bool, is_required=True,
        ),
        E("excluded_phone_number01", "excludedPhoneNumber01", str),
        E("excluded_phone_number02", "excludedPhoneNumber02", str),
        E("excluded_phone_number03", "excludedPhoneNumber03", str),
        E("forward_excluded_numbers_to", "forwardExcludedNumbersTo", str),
    )

    #: bool: *Required* sendCallsToVoiceMailExceptExcludedNumbers
    send_calls_to_voice_mail_except_excluded_numbers = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Optional* excludedPhoneNumber01
    excluded_phone_number01 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* excludedPhoneNumber02
    excluded_phone_number02 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* excludedPhoneNumber03
    excluded_phone_number03 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* forwardExcludedNumbersTo
    forward_excluded_numbers_to = Field(type=str, required=False, mutable=False)


class CommPilotExpressRedirectionWithExceptionModify(OCIType):
    """
    CommPilot Express type to transfer to voice mail or forward to a number with certain
    exceptions used in the context of a modify.

    """

    _ELEMENTS = (
        E(
            "send_calls_to_voice_mail_except_excluded_numbers",
            "sendCallsToVoiceMailExceptExcludedNumbers", bool,
        ),
        E("excluded_phone_number01", "excludedPhoneNumber01", str),
        E("excluded_phone_number02", "excludedPhoneNumber02", str),
        E("excluded_phone_number03", "excludedPhoneNumber03", str),
        E("forward_excluded_numbers_to", "forwardExcludedNumbersTo", str),
    )

    #: bool: *Optional* sendCallsToVoiceMailExceptExcludedNumbers
    send_calls_to_voice_mail_except_excluded_numbers = Field(
        type=bool, required=False, mutable=False,
    )
    #: str: *Optional* excludedPhoneNumber01
    excluded_phone_number01 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* excludedPhoneNumber02
    excluded_phone_number02 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* excludedPhoneNumber03
    excluded_phone_number03 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* forwardExcludedNumbersTo
    forward_excluded_numbers_to = Field(type=str, required=False, mutable=False)


class CommPilotExpressSREmailNotify(OCIType):
    """
    CommPilot Express SR Email Notify configuration used in the context of a get.

    """

    _ELEMENTS = (
        E("send_email", "sendEmail", bool, is_required=True),
        E("email_address", "emailAddress", str),
    )

    #: bool: *Required* sendEmail
    send_email = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* emailAddress
    email_address = Field(type=str, required=False, mutable=False)


class CommPilotExpressSREmailNotifyModify(OCIType):
    """
    CommPilot Express SR Email Notify configuration used in the context of a modify.

    """

    _ELEMENTS = (
        E("send_email", "sendEmail", bool),
        E("email_address", "emailAddress", str),
    )

    #: bool: *Optional* sendEmail
    send_email = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* emailAddress
    email_address = Field(type=str, required=False, mutable=False)


class CommPilotExpressSRRedirection(OCIType):
    """
    CommPilot Express SR type to transfer to voice Mail or forward to a number used in the
    context of a get.

    """

    _ELEMENTS = (
        E("action", "action", str, is_required=True),
        E("forwarding_phone_number", "forwardingPhoneNumber", str),
    )

    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* forwardingPhoneNumber
    forwarding_phone_number = Field(type=str, required=False, mutable=False)


class CommPilotExpressSRRedirectionModify(OCIType):
    """
    CommPilot Express SR type to transfer to voice Mail or forward to a number used in the
    context of a modify.

    """

    _ELEMENTS = (
        E("action", "action", str),
        E("forwarding_phone_number", "forwardingPhoneNumber", str),
    )

    #: str: *Optional* action
    action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* forwardingPhoneNumber
    forwarding_phone_number = Field(type=str, required=False, mutable=False)


class CommPilotExpressSRRedirectionWithException(OCIType):
    """
    CommPilot Express SR type to transfer to voice mail or forward to a number with
    certain exceptions used in the context of a get.

    """

    _ELEMENTS = (
        E(
            "send_calls_to_voice_mail_except_excluded_numbers",
            "sendCallsToVoiceMailExceptExcludedNumbers", bool, is_required=True,
        ),
        E("excluded_phone_number01", "excludedPhoneNumber01", str),
        E("excluded_phone_number02", "excludedPhoneNumber02", str),
        E("excluded_phone_number03", "excludedPhoneNumber03", str),
        E("forward_excluded_numbers_to", "forwardExcludedNumbersTo", str),
    )

    #: bool: *Required* sendCallsToVoiceMailExceptExcludedNumbers
    send_calls_to_voice_mail_except_excluded_numbers = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Optional* excludedPhoneNumber01
    excluded_phone_number01 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* excludedPhoneNumber02
    excluded_phone_number02 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* excludedPhoneNumber03
    excluded_phone_number03 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* forwardExcludedNumbersTo
    forward_excluded_numbers_to = Field(type=str, required=False, mutable=False)


class CommPilotExpressSRRedirectionWithExceptionModify(OCIType):
    """
    CommPilot Express SR type to transfer to voice mail or forward to a number with
    certain exceptions used in the context of a modify.

    """

    _ELEMENTS = (
        E(
            "send_calls_to_voice_mail_except_excluded_numbers",
            "sendCallsToVoiceMailExceptExcludedNumbers", bool,
        ),
        E("excluded_phone_number01", "excludedPhoneNumber01", str),
        E("excluded_phone_number02", "excludedPhoneNumber02", str),
        E("excluded_phone_number03", "excludedPhoneNumber03", str),
        E("forward_excluded_numbers_to", "forwardExcludedNumbersTo", str),
    )

    #: bool: *Optional* sendCallsToVoiceMailExceptExcludedNumbers
    send_calls_to_voice_mail_except_excluded_numbers = Field(
        type=bool, required=False, mutable=False,
    )
    #: str: *Optional* excludedPhoneNumber01
    excluded_phone_number01 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* excludedPhoneNumber02
    excluded_phone_number02 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* excludedPhoneNumber03
    excluded_phone_number03 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* forwardExcludedNumbersTo
    forward_excluded_numbers_to = Field(type=str, required=False, mutable=False)


class CommPilotExpressSRRedirectionWithRing(OCIType):
    """
    CommPilot Express SR Forward Number Entry with number of times to ring.

    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str),
        E("number_of_times_to_ring", "numberOfTimesToRing", int, is_required=True),
    )

    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: int: *Required* numberOfTimesToRing
    number_of_times_to_ring = Field(type=int, required=True, mutable=False)


class CommunicationBarringAuthorizationCodeEntry(OCIType):
    """
    Communication Barring Authorization Code entry.

    """

    _ELEMENTS = (
        E("code", "code", str, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class CommunicationBarringCallMeNowRule(OCIType):
    """
    Communication Barring Call Me Now Rule
    """

    _ELEMENTS = (
        E("criteria", "criteria", str, is_required=True),
        E("action", "action", str, is_required=True),
        E("call_timeout_seconds", "callTimeoutSeconds", int),
    )

    #: str: *Required* criteria
    criteria = Field(type=str, required=True, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: int: *Optional* callTimeoutSeconds
    call_timeout_seconds = Field(type=int, required=False, mutable=False)


class CommunicationBarringIncomingRule(OCIType):
    """
    Communication Barring Incoming Rule
    """

    _ELEMENTS = (
        E("digit_pattern_criteria", "digitPatternCriteria", str, is_required=True),
        E("action", "action", str, is_required=True),
        E("call_timeout_seconds", "callTimeoutSeconds", int),
        E("time_schedule", "timeSchedule", str),
        E("holiday_schedule", "holidaySchedule", str),
        E("priority", "priority", str, is_required=True),
    )

    #: str: *Required* digitPatternCriteria
    digit_pattern_criteria = Field(type=str, required=True, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: int: *Optional* callTimeoutSeconds
    call_timeout_seconds = Field(type=int, required=False, mutable=False)
    #: str: *Optional* timeSchedule
    time_schedule = Field(type=str, required=False, mutable=False)
    #: str: *Optional* holidaySchedule
    holiday_schedule = Field(type=str, required=False, mutable=False)
    #: str: *Required* priority
    priority = Field(type=str, required=True, mutable=False)


class CommunicationBarringIncomingRule19sp1(OCIType):
    """
    Communication Barring Incoming Rule
    """

    _ELEMENTS = (
        E("digit_pattern_criteria", "digitPatternCriteria", str),
        E("incoming_criteria", "incomingCriteria", str),
        E("action", "action", str, is_required=True),
        E("call_timeout_seconds", "callTimeoutSeconds", int),
        E("time_schedule", "timeSchedule", str),
        E("holiday_schedule", "holidaySchedule", str),
        E("priority", "priority", str, is_required=True),
    )

    #: str: *Optional* digitPatternCriteria
    digit_pattern_criteria = Field(type=str, required=False, mutable=False)
    #: str: *Optional* incomingCriteria
    incoming_criteria = Field(type=str, required=False, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: int: *Optional* callTimeoutSeconds
    call_timeout_seconds = Field(type=int, required=False, mutable=False)
    #: str: *Optional* timeSchedule
    time_schedule = Field(type=str, required=False, mutable=False)
    #: str: *Optional* holidaySchedule
    holiday_schedule = Field(type=str, required=False, mutable=False)
    #: str: *Required* priority
    priority = Field(type=str, required=True, mutable=False)


class CommunicationBarringOriginatingRule(OCIType):
    """
    Communication Barring Originating Rule
    """

    _ELEMENTS = (
        E("criteria", "criteria", str, is_required=True),
        E("action", "action", str, is_required=True),
        E("treatment_id", "treatmentId", str),
        E("transfer_number", "transferNumber", str),
        E("call_timeout_seconds", "callTimeoutSeconds", int),
    )

    #: str: *Required* criteria
    criteria = Field(type=str, required=True, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* treatmentId
    treatment_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* transferNumber
    transfer_number = Field(type=str, required=False, mutable=False)
    #: int: *Optional* callTimeoutSeconds
    call_timeout_seconds = Field(type=int, required=False, mutable=False)


class CommunicationBarringOriginatingRule15sp2(OCIType):
    """
    Communication Barring Originating Rule
    """

    _ELEMENTS = (
        E("criteria", "criteria", str, is_required=True),
        E("action", "action", str, is_required=True),
        E("treatment_id", "treatmentId", str),
        E("transfer_number", "transferNumber", str),
    )

    #: str: *Required* criteria
    criteria = Field(type=str, required=True, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* treatmentId
    treatment_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* transferNumber
    transfer_number = Field(type=str, required=False, mutable=False)


class CommunicationBarringProfileReplacementList(OCIType):
    """
    A list of communication barring profiles that replaces a previously configured list.

    By convention, an element of this type may be set nil to clear the list.
    """

    _ELEMENTS = (
        E("profile_name", "profileName", str, is_required=True),
    )

    #: str: *Required* profileName
    profile_name = Field(type=str, required=True, mutable=False)


class CommunicationBarringRedirectingRule(OCIType):
    """
    Communication Barring Redirecting Rule
    """

    _ELEMENTS = (
        E("criteria", "criteria", str, is_required=True),
        E("action", "action", str, is_required=True),
        E("call_timeout_seconds", "callTimeoutSeconds", int),
    )

    #: str: *Required* criteria
    criteria = Field(type=str, required=True, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: int: *Optional* callTimeoutSeconds
    call_timeout_seconds = Field(type=int, required=False, mutable=False)


class CommunicationBarringRedirectingRule15sp2(OCIType):
    """
    Communication Barring Redirecting Rule
    """

    _ELEMENTS = (
        E("criteria", "criteria", str, is_required=True),
        E("action", "action", str, is_required=True),
    )

    #: str: *Required* criteria
    criteria = Field(type=str, required=True, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)


class Contact(OCIType):
    """
    Contact information.

    """

    _ELEMENTS = (
        E("contact_name", "contactName", str),
        E("contact_number", "contactNumber", str),
        E("contact_email", "contactEmail", str),
    )

    #: str: *Optional* contactName
    contact_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* contactNumber
    contact_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* contactEmail
    contact_email = Field(type=str, required=False, mutable=False)


class CriteriaActivation(OCIType):
    """
    Criteria active status indicator
    """

    _ELEMENTS = (
        E("criteria_name", "criteriaName", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
    )

    #: str: *Required* criteriaName
    criteria_name = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)


class CriteriaFromDn(OCIType):
    """
    The from dn criteria used within an add/get request.

    """

    _ELEMENTS = (
        E("from_dn_criteria_selection", "fromDnCriteriaSelection", str, is_required=True),
        E("include_anonymous_callers", "includeAnonymousCallers", bool, is_required=True),
        E("include_unavailable_callers", "includeUnavailableCallers", bool, is_required=True),
        E("phone_number", "phoneNumber", str),
    )

    #: str: *Required* fromDnCriteriaSelection
    from_dn_criteria_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* includeAnonymousCallers
    include_anonymous_callers = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* includeUnavailableCallers
    include_unavailable_callers = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)


class CriteriaReplacementDNList(OCIType):
    """
    A list of criteria DNs that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)


class CustomContactDirectoryEntry(OCIType):
    """
    Represents either an existing user's Id or an existing Virtual On-Net user's DN.

    For a DN the groupId is used to make it unique within an Enterprise, however the
    groupId is not used with Service Providers.
    """

    _ELEMENTS = (
        E("user_id", "userId", str),
        E("virtual_on_net_phone_number", "virtualOnNetPhoneNumber", str, is_required=True),
        E("group_id", "groupId", str),
    )

    #: str: *Optional* userId
    user_id = Field(type=str, required=False, mutable=False)
    #: str: *Required* virtualOnNetPhoneNumber
    virtual_on_net_phone_number = Field(type=str, required=True, mutable=False)
    #: str: *Optional* groupId
    group_id = Field(type=str, required=False, mutable=False)


class DNISKey(OCIType):
    """
    Uniquely identifies a Call Center DNIS.

    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class DNRange(OCIType):
    """
    Directory number range.

    The minimum and maximum values are inclusive.
    """

    _ELEMENTS = (
        E("min_phone_number", "minPhoneNumber", str, is_required=True),
        E("max_phone_number", "maxPhoneNumber", str, is_required=True),
    )

    #: str: *Required* minPhoneNumber
    min_phone_number = Field(type=str, required=True, mutable=False)
    #: str: *Required* maxPhoneNumber
    max_phone_number = Field(type=str, required=True, mutable=False)


class DefaultNetworkClassOfService(OCIType):
    """
    The default Network Class of Service to set during assignation/unassignation.

    """

    _ELEMENTS = (
        E("use_existing", "useExisting", bool),
        E("network_class_of_service_name", "networkClassOfServiceName", str),
    )

    #: bool: *Optional* useExisting
    use_existing = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* networkClassOfServiceName
    network_class_of_service_name = Field(type=str, required=False, mutable=False)


class DepartmentKey(OCIType):
    """
    Uniquely identifies a department system-wide.

    Departments are contained in either an enterprise or a group.  Enterprise departments
    can be used by any or all groups within the enterprise.  Department names are unique
    within a group and within an enterprise, but the same department name can exist in 2
    different groups or in both a group and its parent enterprise.  Therefore, to uniquely
    identify a department, we must know the department name and which enterprise or group
    contains the department.  This type is extended by group and enterprise department
    keys.
    """

    _ELEMENTS = ()


class DeviceManagementAutoRebuildConfigEntry(OCIType):
    """
    Contains one automatic rebuild configuration list entry.

    """

    _ELEMENTS = (
        E("oci_request_prefix", "ociRequestPrefix", str, is_required=True),
        E("auto_rebuild_enabled", "autoRebuildEnabled", bool),
    )

    #: str: *Required* ociRequestPrefix
    oci_request_prefix = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* autoRebuildEnabled
    auto_rebuild_enabled = Field(type=bool, required=False, mutable=False)


class DeviceManagementDeviceTypeOptionsRead(OCIType):
    """
    Device Management System device type options.

    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str, is_required=True),
        E("tag_mode", "tagMode", str, is_required=True),
        E("tag_set", "tagSet", str),
        E(
            "allow_device_profile_custom_tag_set", "allowDeviceProfileCustomTagSet", bool,
            is_required=True,
        ),
        E("allow_group_custom_tag_set", "allowGroupCustomTagSet", bool, is_required=True),
        E(
            "send_email_upon_reset_failure", "sendEmailUponResetFailure", bool,
            is_required=True,
        ),
        E("device_access_net_address", "deviceAccessNetAddress", str),
        E("device_access_port", "deviceAccessPort", int),
        E("device_access_context", "deviceAccessContext", str),
        E("device_access_uri", "deviceAccessURI", str),
        E("default_device_language", "defaultDeviceLanguage", str),
        E("default_device_encoding", "defaultDeviceEncoding", str),
        E("access_device_credentials", "accessDeviceCredentials", str),
        E(
            "use_http_digest_authentication", "useHttpDigestAuthentication", bool,
            is_required=True,
        ),
        E(
            "mac_based_file_authentication", "macBasedFileAuthentication", bool,
            is_required=True,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool, is_required=True,
        ),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool, is_required=True),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
    )

    #: str: *Required* deviceAccessProtocol
    device_access_protocol = Field(type=str, required=True, mutable=False)
    #: str: *Required* tagMode
    tag_mode = Field(type=str, required=True, mutable=False)
    #: str: *Optional* tagSet
    tag_set = Field(type=str, required=False, mutable=False)
    #: bool: *Required* allowDeviceProfileCustomTagSet
    allow_device_profile_custom_tag_set = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowGroupCustomTagSet
    allow_group_custom_tag_set = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* sendEmailUponResetFailure
    send_email_upon_reset_failure = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* deviceAccessNetAddress
    device_access_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* deviceAccessPort
    device_access_port = Field(type=int, required=False, mutable=False)
    #: str: *Optional* deviceAccessContext
    device_access_context = Field(type=str, required=False, mutable=False)
    #: str: *Optional* deviceAccessURI
    device_access_uri = Field(type=str, required=False, mutable=False)
    #: str: *Optional* defaultDeviceLanguage
    default_device_language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* defaultDeviceEncoding
    default_device_encoding = Field(type=str, required=False, mutable=False)
    #: str: *Optional* accessDeviceCredentials
    access_device_credentials = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useHttpDigestAuthentication
    use_http_digest_authentication = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* macBasedFileAuthentication
    mac_based_file_authentication = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* macInNonRequestURI
    mac_in_non_request_uri = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(type=str, required=False, mutable=False)


class DeviceManagementDeviceTypeOptionsRead16(OCIType):
    """
    Device Management System device type options.

    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str, is_required=True),
        E("tag_mode", "tagMode", str, is_required=True),
        E("tag_set", "tagSet", str),
        E(
            "allow_device_profile_custom_tag_set", "allowDeviceProfileCustomTagSet", bool,
            is_required=True,
        ),
        E("allow_group_custom_tag_set", "allowGroupCustomTagSet", bool, is_required=True),
        E(
            "send_email_upon_reset_failure", "sendEmailUponResetFailure", bool,
            is_required=True,
        ),
        E("device_access_net_address", "deviceAccessNetAddress", str),
        E("device_access_port", "deviceAccessPort", int),
        E("device_access_context", "deviceAccessContext", str),
        E("device_access_uri", "deviceAccessURI", str),
        E("default_device_language", "defaultDeviceLanguage", str),
        E("default_device_encoding", "defaultDeviceEncoding", str),
        E("access_device_credentials", "accessDeviceCredentials", str),
        E(
            "use_http_digest_authentication", "useHttpDigestAuthentication", bool,
            is_required=True,
        ),
        E(
            "mac_based_file_authentication", "macBasedFileAuthentication", bool,
            is_required=True,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool, is_required=True,
        ),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool, is_required=True),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
    )

    #: str: *Required* deviceAccessProtocol
    device_access_protocol = Field(type=str, required=True, mutable=False)
    #: str: *Required* tagMode
    tag_mode = Field(type=str, required=True, mutable=False)
    #: str: *Optional* tagSet
    tag_set = Field(type=str, required=False, mutable=False)
    #: bool: *Required* allowDeviceProfileCustomTagSet
    allow_device_profile_custom_tag_set = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowGroupCustomTagSet
    allow_group_custom_tag_set = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* sendEmailUponResetFailure
    send_email_upon_reset_failure = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* deviceAccessNetAddress
    device_access_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* deviceAccessPort
    device_access_port = Field(type=int, required=False, mutable=False)
    #: str: *Optional* deviceAccessContext
    device_access_context = Field(type=str, required=False, mutable=False)
    #: str: *Optional* deviceAccessURI
    device_access_uri = Field(type=str, required=False, mutable=False)
    #: str: *Optional* defaultDeviceLanguage
    default_device_language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* defaultDeviceEncoding
    default_device_encoding = Field(type=str, required=False, mutable=False)
    #: str: *Optional* accessDeviceCredentials
    access_device_credentials = Field(type=str, required=False, mutable=False)
    #: bool: *Required* useHttpDigestAuthentication
    use_http_digest_authentication = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* macBasedFileAuthentication
    mac_based_file_authentication = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* macInNonRequestURI
    mac_in_non_request_uri = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(type=str, required=False, mutable=False)


class DeviceManagementLanguageMapping(OCIType):
    """
    Maps a BroadWorks language to a device-equivalent language.

    """

    _ELEMENTS = (
        E("broad_works_language", "broadWorksLanguage", str, is_required=True),
        E("device_language", "deviceLanguage", str, is_required=True),
    )

    #: str: *Required* broadWorksLanguage
    broad_works_language = Field(type=str, required=True, mutable=False)
    #: str: *Required* deviceLanguage
    device_language = Field(type=str, required=True, mutable=False)


class DeviceManagementUserNamePassword(OCIType):
    """
    Access device credentials.

    """

    _ELEMENTS = (
        E("user_name", "userName", str, is_required=True),
        E("password", "password", str, is_required=True),
    )

    #: str: *Required* userName
    user_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* password
    password = Field(type=str, required=True, mutable=False)


class DeviceManagementUserNamePassword16(OCIType):
    """
    Access device credentials.

    """

    _ELEMENTS = (
        E("user_name", "userName", str, is_required=True),
        E("password", "password", str, is_required=True),
    )

    #: str: *Required* userName
    user_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* password
    password = Field(type=str, required=True, mutable=False)


class DialableCallerIDCriteriaPriorityOrder(OCIType):
    """
    Dialable Caller ID routing order
    """

    _ELEMENTS = (
        E("criteria_name", "criteriaName", str, is_required=True),
        E("priority", "priority", str, is_required=True),
    )

    #: str: *Required* criteriaName
    criteria_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* priority
    priority = Field(type=str, required=True, mutable=False)


class EnhancedCallLogsAccountAuthorizationCodeFilter(OCIType):
    """
    Filter criteria based on the account code.

    When "callsWithCodes" is set to true, all call logs with account/authorization codes
    are returned.  When it set to false, all call logs without account/authorization codes
    are returned.
    """

    _ELEMENTS = (
        E("calls_with_codes", "callsWithCodes", bool),
        E("account_authorization_code", "accountAuthorizationCode", str),
    )

    #: bool: *Optional* callsWithCodes
    calls_with_codes = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* accountAuthorizationCode
    account_authorization_code = Field(type=str, required=False, mutable=False)


class EnhancedCallLogsCallAuthorizationCodeFilter(OCIType):
    """
    Filter criteria based on call authorization code.

    Note that this code filter is different than
    EnhancedCallLogsAccountAuthorizationCodeFilter, which applies strictly to codes
    entered using the account/authorization code service.  When "callsWithCodes" is set to
    true, all call logs with authorization codes are returned.  When it set to false, all
    call logs without authorization codes are returned.  If "authorizationCode" is set,
    all call logs matching that specific authorization code are returned.
    """

    _ELEMENTS = (
        E("calls_with_codes", "callsWithCodes", bool),
        E("authorization_code", "authorizationCode", str),
    )

    #: bool: *Optional* callsWithCodes
    calls_with_codes = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* authorizationCode
    authorization_code = Field(type=str, required=False, mutable=False)


class EnhancedCallLogsEntry(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.

    Replaced By: CallLogsEntry
    """

    _ELEMENTS = (
        E("country_code", "countryCode", str),
        E("phone_number", "phoneNumber", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("time", "time", str, is_required=True),
    )

    #: str: *Optional* countryCode
    country_code = Field(type=str, required=False, mutable=False)
    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* time
    time = Field(type=str, required=True, mutable=False)


class EnhancedCallLogsRedirectedCallSelection(OCIType):
    """
    Redirected call selection.

    When " redirectedCall " is set to true, all call logs with redirected call are
    returned.  When it set to false, all call logs without redirected call are returned.
    The redirected call can be defined by including a subset of Service Invocation
    Disposition here.  If none included, any call has a ServiceInvocationDisposition value
    defined in ServiceInvocationDisposition is considered as a redirected call.
    """

    _ELEMENTS = (
        E("redirected_call", "redirectedCall", bool, is_required=True),
        E("redirect_type", "redirectType", str, is_array=True),
    )

    #: bool: *Required* redirectedCall
    redirected_call = Field(type=bool, required=True, mutable=False)
    #: list(str): *Optional* redirectType  *Array*
    redirect_type = Field(type=list, required=False, mutable=False)


class EnhancedCallLogsRedirectedCallSelection21(OCIType):
    """
    Redirected call selection.

    When " redirectedCall " is set to true, all call logs with redirected call are
    returned.  When it set to false, all call logs without redirected call are returned.
    The redirected call can be defined by including a subset of Service Invocation
    Disposition here.  If none included, any call has a ServiceInvocationDisposition value
    defined in ServiceInvocationDisposition is considered as a redirected call.
    """

    _ELEMENTS = (
        E("redirected_call", "redirectedCall", bool, is_required=True),
        E("redirect_type", "redirectType", str, is_array=True),
    )

    #: bool: *Required* redirectedCall
    redirected_call = Field(type=bool, required=True, mutable=False)
    #: list(str): *Optional* redirectType  *Array*
    redirect_type = Field(type=list, required=False, mutable=False)


class EnhancedCallLogsResponsePagingControl(OCIType):
    """
    Used in enhanced call logs group and enterprise queries to restrict the set of result
    rows when making a request that can result in a large dataset.

    The client specifies the starting row and the number of rows requested.  The server
    only provides those rows in results, if available.
    """

    _ELEMENTS = (
        E("response_start_index", "responseStartIndex", int, is_required=True),
        E("response_page_size", "responsePageSize", int, is_required=True),
    )

    #: int: *Required* responseStartIndex
    response_start_index = Field(type=int, required=True, mutable=False)
    #: int: *Required* responsePageSize
    response_page_size = Field(type=int, required=True, mutable=False)


class EnhancedCallLogsTimeRange(OCIType):
    """
    Time range used to filter call logs.

    """

    _ELEMENTS = (
        E("start_date_time", "startDateTime", str, is_required=True),
        E("end_date_time", "endDateTime", str, is_required=True),
    )

    #: str: *Required* startDateTime
    start_date_time = Field(type=str, required=True, mutable=False)
    #: str: *Required* endDateTime
    end_date_time = Field(type=str, required=True, mutable=False)


class EnterpriseDepartmentKey(OCIType):
    """
    Uniquely identifies a department defined within an enterprise.

    To uniquely identify an enterprise department, we must know the department name and
    which enterprise contains the department.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class EnterpriseTrunkTrunkGroupKey(OCIType):
    """
    Identifies a trunk group within an Enterprise Trunk where the service provider id is
    already known.

    """

    _ELEMENTS = (
        E("group_id", "groupId", str, is_required=True),
        E("trunk_group_name", "trunkGroupName", str, is_required=True),
    )

    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* trunkGroupName
    trunk_group_name = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNDigitManipulation(OCIType):
    """
    Enterprise Voice VPN Digit Manipulation Entry.

    """

    _ELEMENTS = ()


class EnterpriseVoiceVPNDigitManipulationNoValue(OCIType):
    """
    Enterprise Voice VPN Digit Manipulation Entry that has no value.

    """

    _ELEMENTS = (
        E("operation", "operation", str, is_required=True),
    )

    #: str: *Required* operation
    operation = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNDigitManipulationOptionalValue(OCIType):
    """
    Enterprise Voice VPN Digit Manipulation Entry that optionally has a value.

    """

    _ELEMENTS = (
        E("operation", "operation", str, is_required=True),
        E("value", "value", str),
    )

    #: str: *Required* operation
    operation = Field(type=str, required=True, mutable=False)
    #: str: *Optional* value
    value = Field(type=str, required=False, mutable=False)


class EnterpriseVoiceVPNDigitManipulationRequiredValue(OCIType):
    """
    Enterprise Voice VPN Digit Manipulation Entry that has a value.

    """

    _ELEMENTS = (
        E("operation", "operation", str, is_required=True),
        E("value", "value", str, is_required=True),
    )

    #: str: *Required* operation
    operation = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNTreatmentEntry(OCIType):
    """
    Enterprise Voice VPN Treatment entry
    """

    _ELEMENTS = (
        E("id", "id", str, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* id
    id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class EstimatedWaitMessageOptionsModify(OCIType):
    """
    Estimated Wait Message Options
    """

    _ELEMENTS = (
        E("enabled", "enabled", bool),
        E("operating_mode", "operatingMode", str),
        E("play_position_high_volume", "playPositionHighVolume", bool),
        E("play_time_high_volume", "playTimeHighVolume", bool),
        E("maximum_positions", "maximumPositions", int),
        E("maximum_waiting_minutes", "maximumWaitingMinutes", int),
        E("default_call_handling_minutes", "defaultCallHandlingMinutes", int),
        E("play_updated_ewm", "playUpdatedEWM", bool),
        E("time_between_ewm_updates_seconds", "timeBetweenEWMUpdatesSeconds", int),
    )

    #: bool: *Optional* enabled
    enabled = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* operatingMode
    operating_mode = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* playPositionHighVolume
    play_position_high_volume = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* playTimeHighVolume
    play_time_high_volume = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* maximumPositions
    maximum_positions = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maximumWaitingMinutes
    maximum_waiting_minutes = Field(type=int, required=False, mutable=False)
    #: int: *Optional* defaultCallHandlingMinutes
    default_call_handling_minutes = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* playUpdatedEWM
    play_updated_ewm = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* timeBetweenEWMUpdatesSeconds
    time_between_ewm_updates_seconds = Field(type=int, required=False, mutable=False)


class EstimatedWaitMessageOptionsRead(OCIType):
    """
    Estimated Wait Message Options Replaced by EstimatedWaitMessageOptionsRead17sp4
    """

    _ELEMENTS = (
        E("enabled", "enabled", bool, is_required=True),
        E("operating_mode", "operatingMode", str, is_required=True),
        E("play_position_high_volume", "playPositionHighVolume", bool, is_required=True),
        E("play_time_high_volume", "playTimeHighVolume", bool, is_required=True),
        E("maximum_positions", "maximumPositions", int, is_required=True),
        E("maximum_waiting_minutes", "maximumWaitingMinutes", int, is_required=True),
        E(
            "default_call_handling_minutes", "defaultCallHandlingMinutes", int,
            is_required=True,
        ),
    )

    #: bool: *Required* enabled
    enabled = Field(type=bool, required=True, mutable=False)
    #: str: *Required* operatingMode
    operating_mode = Field(type=str, required=True, mutable=False)
    #: bool: *Required* playPositionHighVolume
    play_position_high_volume = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* playTimeHighVolume
    play_time_high_volume = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maximumPositions
    maximum_positions = Field(type=int, required=True, mutable=False)
    #: int: *Required* maximumWaitingMinutes
    maximum_waiting_minutes = Field(type=int, required=True, mutable=False)
    #: int: *Required* defaultCallHandlingMinutes
    default_call_handling_minutes = Field(type=int, required=True, mutable=False)


class EstimatedWaitMessageOptionsRead17sp4(OCIType):
    """
    Estimated Wait Message Options
    """

    _ELEMENTS = (
        E("enabled", "enabled", bool, is_required=True),
        E("operating_mode", "operatingMode", str, is_required=True),
        E("play_position_high_volume", "playPositionHighVolume", bool, is_required=True),
        E("play_time_high_volume", "playTimeHighVolume", bool, is_required=True),
        E("maximum_positions", "maximumPositions", int, is_required=True),
        E("maximum_waiting_minutes", "maximumWaitingMinutes", int, is_required=True),
        E(
            "default_call_handling_minutes", "defaultCallHandlingMinutes", int,
            is_required=True,
        ),
        E("play_updated_ewm", "playUpdatedEWM", bool, is_required=True),
        E("time_between_ewm_updates_seconds", "timeBetweenEWMUpdatesSeconds", int),
    )

    #: bool: *Required* enabled
    enabled = Field(type=bool, required=True, mutable=False)
    #: str: *Required* operatingMode
    operating_mode = Field(type=str, required=True, mutable=False)
    #: bool: *Required* playPositionHighVolume
    play_position_high_volume = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* playTimeHighVolume
    play_time_high_volume = Field(type=bool, required=True, mutable=False)
    #: int: *Required* maximumPositions
    maximum_positions = Field(type=int, required=True, mutable=False)
    #: int: *Required* maximumWaitingMinutes
    maximum_waiting_minutes = Field(type=int, required=True, mutable=False)
    #: int: *Required* defaultCallHandlingMinutes
    default_call_handling_minutes = Field(type=int, required=True, mutable=False)
    #: bool: *Required* playUpdatedEWM
    play_updated_ewm = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* timeBetweenEWMUpdatesSeconds
    time_between_ewm_updates_seconds = Field(type=int, required=False, mutable=False)


class ExchangeUserNamePassword(OCIType):
    """
    Exchange server user name and password.

    """

    _ELEMENTS = (
        E("user_name", "userName", str, is_required=True),
        E("password", "password", str, is_required=True),
    )

    #: str: *Required* userName
    user_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* password
    password = Field(type=str, required=True, mutable=False)


class ExecutiveAssistantOptInStatus(OCIType):
    """
    Executive assistant Opt-in status with executive.

    """

    _ELEMENTS = (
        E("executive_user_id", "executiveUserId", str, is_required=True),
        E("opt_in", "optIn", bool, is_required=True),
    )

    #: str: *Required* executiveUserId
    executive_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Required* optIn
    opt_in = Field(type=bool, required=True, mutable=False)


class ExecutiveCallFilteringCriteriaFromDn(OCIType):
    """
    The from dn criteria used within an executive call filtering criteria add/get request.

    """

    _ELEMENTS = (
        E("from_dn_criteria_selection", "fromDnCriteriaSelection", str, is_required=True),
        E("include_anonymous_callers", "includeAnonymousCallers", bool, is_required=True),
        E("include_unavailable_callers", "includeUnavailableCallers", bool, is_required=True),
        E("phone_number", "phoneNumber", str),
    )

    #: str: *Required* fromDnCriteriaSelection
    from_dn_criteria_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* includeAnonymousCallers
    include_anonymous_callers = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* includeUnavailableCallers
    include_unavailable_callers = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)


class ExtendedMixedCallLogsEntry(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachTime" represents the time when the call is successfully
    redirected by the system.  "releaseTime" represents the time when the call is
    released.  This time corresponds to the moment the call is released by the system, and
    not necessarily when one party hangs up, since this does not always mean the call is
    released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  Replaced by
    ExtendedMixedCallLogsEntry17sp4. Originally deprecated in release 20.
    """

    _ELEMENTS = (
        E("call_log_type", "callLogType", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
        E("call_log_id", "callLogId", str, is_required=True),
        E("call_id", "callId", str, is_required=True),
        E("subscriber_type", "subscriberType", str, is_required=True),
        E("dialed_number", "dialedNumber", str),
        E("called_number", "calledNumber", str),
        E("network_translated_address", "networkTranslatedAddress", str),
        E("calling_asserted_number", "callingAssertedNumber", str),
        E("calling_presentation_number", "callingPresentationNumber", str),
        E("calling_presentation_number_source", "callingPresentationNumberSource", str),
        E("calling_presentation_name", "callingPresentationName", str),
        E(
            "calling_presentation_indicator", "callingPresentationIndicator", str,
            is_required=True,
        ),
        E("calling_group_id", "callingGroupId", str),
        E("called_directory_name", "calledDirectoryName", str),
        E("called_group_id", "calledGroupId", str),
        E("connected_number", "connectedNumber", str),
        E("connected_number_source", "connectedNumberSource", str),
        E("connected_name", "connectedName", str),
        E("connected_presentation_indicator", "connectedPresentationIndicator", str),
        E("type_of_network", "typeOfNetwork", str),
        E("call_category", "callCategory", str),
        E("basic_call_type", "basicCallType", str, is_required=True),
        E("configurable_call_type", "configurableCallType", str),
        E("alternate_call_indicator", "alternateCallIndicator", str),
        E("virtual_on_net_call_type", "virtualOnNetCallType", str),
        E("time", "time", str, is_required=True),
        E("start_time", "startTime", int, is_required=True),
        E("answer_time", "answerTime", int),
        E("release_time", "releaseTime", int),
        E("detached_time", "detachedTime", int),
        E("detached_answer_time", "detachedAnswerTime", int),
        E("outgoing_dnis", "outgoingDnis", str),
        E("service_invocation_disposition", "serviceInvocationDisposition", str),
        E("service_invocation_dialed_number", "serviceInvocationDialedNumber", str),
        E("service_invocation_called_number", "serviceInvocationCalledNumber", str),
        E(
            "service_invocation_network_translated_address",
            "serviceInvocationNetworkTranslatedAddress", str,
        ),
        E("service_invocation_type_of_network", "serviceInvocationTypeOfNetwork", str),
        E("service_invocation_call_category", "serviceInvocationCallCategory", str),
        E("service_invocation_basic_call_type", "serviceInvocationBasicCallType", str),
        E(
            "service_invocation_configurable_call_type",
            "serviceInvocationConfigurableCallType", str,
        ),
        E(
            "service_invocation_alternate_call_indicator",
            "serviceInvocationAlternateCallIndicator", str,
        ),
        E(
            "service_invocation_virtual_on_net_call_type",
            "serviceInvocationVirtualOnNetCallType", str,
        ),
        E(
            "service_invocation_called_directory_name",
            "serviceInvocationCalledDirectoryName", str,
        ),
        E("service_invocation_called_group_id", "serviceInvocationCalledGroupId", str),
        E("redirecting_number", "redirectingNumber", str),
        E("redirecting_name", "redirectingName", str),
        E("redirecting_presentation_indicator", "redirectingPresentationIndicator", str),
        E("redirecting_reason", "RedirectingReason", str),
        E("account_authorization_code", "accountAuthorizationCode", str),
        E("user_group_id", "userGroupId", str),
        E("user_id", "userId", str),
        E("user_primary_dn", "userPrimaryDn", str),
        E("user_primary_extension", "userPrimaryExtension", str),
    )

    #: str: *Required* callLogType
    call_log_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* countryCode
    country_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* callLogId
    call_log_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* callId
    call_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* subscriberType
    subscriber_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* dialedNumber
    dialed_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* calledNumber
    called_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* networkTranslatedAddress
    network_translated_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingAssertedNumber
    calling_asserted_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingPresentationNumber
    calling_presentation_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingPresentationNumberSource
    calling_presentation_number_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingPresentationName
    calling_presentation_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* callingPresentationIndicator
    calling_presentation_indicator = Field(type=str, required=True, mutable=False)
    #: str: *Optional* callingGroupId
    calling_group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* calledDirectoryName
    called_directory_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* calledGroupId
    called_group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* connectedNumber
    connected_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* connectedNumberSource
    connected_number_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* connectedName
    connected_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* connectedPresentationIndicator
    connected_presentation_indicator = Field(type=str, required=False, mutable=False)
    #: str: *Optional* typeOfNetwork
    type_of_network = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callCategory
    call_category = Field(type=str, required=False, mutable=False)
    #: str: *Required* basicCallType
    basic_call_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* configurableCallType
    configurable_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateCallIndicator
    alternate_call_indicator = Field(type=str, required=False, mutable=False)
    #: str: *Optional* virtualOnNetCallType
    virtual_on_net_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Required* time
    time = Field(type=str, required=True, mutable=False)
    #: int: *Required* startTime
    start_time = Field(type=int, required=True, mutable=False)
    #: int: *Optional* answerTime
    answer_time = Field(type=int, required=False, mutable=False)
    #: int: *Optional* releaseTime
    release_time = Field(type=int, required=False, mutable=False)
    #: int: *Optional* detachedTime
    detached_time = Field(type=int, required=False, mutable=False)
    #: int: *Optional* detachedAnswerTime
    detached_answer_time = Field(type=int, required=False, mutable=False)
    #: str: *Optional* outgoingDnis
    outgoing_dnis = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationDisposition
    service_invocation_disposition = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationDialedNumber
    service_invocation_dialed_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationCalledNumber
    service_invocation_called_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationNetworkTranslatedAddress
    service_invocation_network_translated_address = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* serviceInvocationTypeOfNetwork
    service_invocation_type_of_network = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationCallCategory
    service_invocation_call_category = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationBasicCallType
    service_invocation_basic_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationConfigurableCallType
    service_invocation_configurable_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationAlternateCallIndicator
    service_invocation_alternate_call_indicator = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* serviceInvocationVirtualOnNetCallType
    service_invocation_virtual_on_net_call_type = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* serviceInvocationCalledDirectoryName
    service_invocation_called_directory_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationCalledGroupId
    service_invocation_called_group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* redirectingNumber
    redirecting_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* redirectingName
    redirecting_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* redirectingPresentationIndicator
    redirecting_presentation_indicator = Field(type=str, required=False, mutable=False)
    #: str: *Optional* RedirectingReason
    redirecting_reason = Field(type=str, required=False, mutable=False)
    #: str: *Optional* accountAuthorizationCode
    account_authorization_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userGroupId
    user_group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userId
    user_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userPrimaryDn
    user_primary_dn = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userPrimaryExtension
    user_primary_extension = Field(type=str, required=False, mutable=False)


class ExtendedMixedCallLogsEntry17sp4(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachedTime" represents the time when the call is
    successfully redirected by the system.  "releaseTime" represents the time when the
    call is released.  This time corresponds to the moment the call is released by the
    system, and not necessarily when one party hangs up, since this does not always mean
    the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  The following elements are only used in
    AS data mode: callAuthorizationCode
    """

    _ELEMENTS = (
        E("call_log_type", "callLogType", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
        E("call_log_id", "callLogId", str, is_required=True),
        E("call_id", "callId", str, is_required=True),
        E("subscriber_type", "subscriberType", str, is_required=True),
        E("dialed_number", "dialedNumber", str),
        E("called_number", "calledNumber", str),
        E("network_translated_address", "networkTranslatedAddress", str),
        E("calling_asserted_number", "callingAssertedNumber", str),
        E("calling_presentation_number", "callingPresentationNumber", str),
        E("calling_presentation_number_source", "callingPresentationNumberSource", str),
        E("calling_presentation_name", "callingPresentationName", str),
        E(
            "calling_presentation_indicator", "callingPresentationIndicator", str,
            is_required=True,
        ),
        E("calling_group_id", "callingGroupId", str),
        E("called_directory_name", "calledDirectoryName", str),
        E("called_group_id", "calledGroupId", str),
        E("connected_number", "connectedNumber", str),
        E("connected_number_source", "connectedNumberSource", str),
        E("connected_name", "connectedName", str),
        E("connected_presentation_indicator", "connectedPresentationIndicator", str),
        E("type_of_network", "typeOfNetwork", str),
        E("call_category", "callCategory", str),
        E("basic_call_type", "basicCallType", str, is_required=True),
        E("configurable_call_type", "configurableCallType", str),
        E("alternate_call_indicator", "alternateCallIndicator", str),
        E("virtual_on_net_call_type", "virtualOnNetCallType", str),
        E("time", "time", str, is_required=True),
        E("start_time", "startTime", int, is_required=True),
        E("answer_time", "answerTime", int),
        E("release_time", "releaseTime", int),
        E("detached_time", "detachedTime", int),
        E("detached_answer_time", "detachedAnswerTime", int),
        E("outgoing_dnis", "outgoingDnis", str),
        E("service_invocation_disposition", "serviceInvocationDisposition", str),
        E("service_invocation_dialed_number", "serviceInvocationDialedNumber", str),
        E("service_invocation_called_number", "serviceInvocationCalledNumber", str),
        E(
            "service_invocation_network_translated_address",
            "serviceInvocationNetworkTranslatedAddress", str,
        ),
        E("service_invocation_type_of_network", "serviceInvocationTypeOfNetwork", str),
        E("service_invocation_call_category", "serviceInvocationCallCategory", str),
        E("service_invocation_basic_call_type", "serviceInvocationBasicCallType", str),
        E(
            "service_invocation_configurable_call_type",
            "serviceInvocationConfigurableCallType", str,
        ),
        E(
            "service_invocation_alternate_call_indicator",
            "serviceInvocationAlternateCallIndicator", str,
        ),
        E(
            "service_invocation_virtual_on_net_call_type",
            "serviceInvocationVirtualOnNetCallType", str,
        ),
        E(
            "service_invocation_called_directory_name",
            "serviceInvocationCalledDirectoryName", str,
        ),
        E("service_invocation_called_group_id", "serviceInvocationCalledGroupId", str),
        E("redirecting_number", "redirectingNumber", str),
        E("redirecting_name", "redirectingName", str),
        E("redirecting_presentation_indicator", "redirectingPresentationIndicator", str),
        E("redirecting_reason", "RedirectingReason", str),
        E("account_authorization_code", "accountAuthorizationCode", str),
        E("call_authorization_code", "callAuthorizationCode", str),
        E("user_group_id", "userGroupId", str),
        E("user_id", "userId", str),
        E("user_primary_dn", "userPrimaryDn", str),
        E("user_primary_extension", "userPrimaryExtension", str),
    )

    #: str: *Required* callLogType
    call_log_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* countryCode
    country_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* callLogId
    call_log_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* callId
    call_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* subscriberType
    subscriber_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* dialedNumber
    dialed_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* calledNumber
    called_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* networkTranslatedAddress
    network_translated_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingAssertedNumber
    calling_asserted_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingPresentationNumber
    calling_presentation_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingPresentationNumberSource
    calling_presentation_number_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingPresentationName
    calling_presentation_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* callingPresentationIndicator
    calling_presentation_indicator = Field(type=str, required=True, mutable=False)
    #: str: *Optional* callingGroupId
    calling_group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* calledDirectoryName
    called_directory_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* calledGroupId
    called_group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* connectedNumber
    connected_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* connectedNumberSource
    connected_number_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* connectedName
    connected_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* connectedPresentationIndicator
    connected_presentation_indicator = Field(type=str, required=False, mutable=False)
    #: str: *Optional* typeOfNetwork
    type_of_network = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callCategory
    call_category = Field(type=str, required=False, mutable=False)
    #: str: *Required* basicCallType
    basic_call_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* configurableCallType
    configurable_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateCallIndicator
    alternate_call_indicator = Field(type=str, required=False, mutable=False)
    #: str: *Optional* virtualOnNetCallType
    virtual_on_net_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Required* time
    time = Field(type=str, required=True, mutable=False)
    #: int: *Required* startTime
    start_time = Field(type=int, required=True, mutable=False)
    #: int: *Optional* answerTime
    answer_time = Field(type=int, required=False, mutable=False)
    #: int: *Optional* releaseTime
    release_time = Field(type=int, required=False, mutable=False)
    #: int: *Optional* detachedTime
    detached_time = Field(type=int, required=False, mutable=False)
    #: int: *Optional* detachedAnswerTime
    detached_answer_time = Field(type=int, required=False, mutable=False)
    #: str: *Optional* outgoingDnis
    outgoing_dnis = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationDisposition
    service_invocation_disposition = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationDialedNumber
    service_invocation_dialed_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationCalledNumber
    service_invocation_called_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationNetworkTranslatedAddress
    service_invocation_network_translated_address = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* serviceInvocationTypeOfNetwork
    service_invocation_type_of_network = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationCallCategory
    service_invocation_call_category = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationBasicCallType
    service_invocation_basic_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationConfigurableCallType
    service_invocation_configurable_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationAlternateCallIndicator
    service_invocation_alternate_call_indicator = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* serviceInvocationVirtualOnNetCallType
    service_invocation_virtual_on_net_call_type = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* serviceInvocationCalledDirectoryName
    service_invocation_called_directory_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationCalledGroupId
    service_invocation_called_group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* redirectingNumber
    redirecting_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* redirectingName
    redirecting_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* redirectingPresentationIndicator
    redirecting_presentation_indicator = Field(type=str, required=False, mutable=False)
    #: str: *Optional* RedirectingReason
    redirecting_reason = Field(type=str, required=False, mutable=False)
    #: str: *Optional* accountAuthorizationCode
    account_authorization_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callAuthorizationCode
    call_authorization_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userGroupId
    user_group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userId
    user_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userPrimaryDn
    user_primary_dn = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userPrimaryExtension
    user_primary_extension = Field(type=str, required=False, mutable=False)


class ExtendedMixedCallLogsEntry20(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachedTime" represents the time when the call is
    successfully redirected by the system.  "releaseTime" represents the time when the
    call is released.  This time corresponds to the moment the call is released by the
    system, and not necessarily when one party hangs up, since this does not always mean
    the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  The following elements are only used in
    AS data mode: callAuthorizationCode callSecurityClassification
    """

    _ELEMENTS = (
        E("call_log_type", "callLogType", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
        E("call_log_id", "callLogId", str, is_required=True),
        E("call_id", "callId", str, is_required=True),
        E("subscriber_type", "subscriberType", str, is_required=True),
        E("dialed_number", "dialedNumber", str),
        E("called_number", "calledNumber", str),
        E("network_translated_address", "networkTranslatedAddress", str),
        E("calling_asserted_number", "callingAssertedNumber", str),
        E("calling_presentation_number", "callingPresentationNumber", str),
        E("calling_presentation_number_source", "callingPresentationNumberSource", str),
        E("calling_presentation_name", "callingPresentationName", str),
        E(
            "calling_presentation_indicator", "callingPresentationIndicator", str,
            is_required=True,
        ),
        E("calling_group_id", "callingGroupId", str),
        E("called_directory_name", "calledDirectoryName", str),
        E("called_group_id", "calledGroupId", str),
        E("connected_number", "connectedNumber", str),
        E("connected_number_source", "connectedNumberSource", str),
        E("connected_name", "connectedName", str),
        E("connected_presentation_indicator", "connectedPresentationIndicator", str),
        E("type_of_network", "typeOfNetwork", str),
        E("call_category", "callCategory", str),
        E("basic_call_type", "basicCallType", str, is_required=True),
        E("configurable_call_type", "configurableCallType", str),
        E("alternate_call_indicator", "alternateCallIndicator", str),
        E("virtual_on_net_call_type", "virtualOnNetCallType", str),
        E("time", "time", str, is_required=True),
        E("start_time", "startTime", int, is_required=True),
        E("answer_time", "answerTime", int),
        E("release_time", "releaseTime", int),
        E("detached_time", "detachedTime", int),
        E("detached_answer_time", "detachedAnswerTime", int),
        E("outgoing_dnis", "outgoingDnis", str),
        E("service_invocation_disposition", "serviceInvocationDisposition", str),
        E("service_invocation_dialed_number", "serviceInvocationDialedNumber", str),
        E("service_invocation_called_number", "serviceInvocationCalledNumber", str),
        E(
            "service_invocation_network_translated_address",
            "serviceInvocationNetworkTranslatedAddress", str,
        ),
        E("service_invocation_type_of_network", "serviceInvocationTypeOfNetwork", str),
        E("service_invocation_call_category", "serviceInvocationCallCategory", str),
        E("service_invocation_basic_call_type", "serviceInvocationBasicCallType", str),
        E(
            "service_invocation_configurable_call_type",
            "serviceInvocationConfigurableCallType", str,
        ),
        E(
            "service_invocation_alternate_call_indicator",
            "serviceInvocationAlternateCallIndicator", str,
        ),
        E(
            "service_invocation_virtual_on_net_call_type",
            "serviceInvocationVirtualOnNetCallType", str,
        ),
        E(
            "service_invocation_called_directory_name",
            "serviceInvocationCalledDirectoryName", str,
        ),
        E("service_invocation_called_group_id", "serviceInvocationCalledGroupId", str),
        E("redirecting_number", "redirectingNumber", str),
        E("redirecting_name", "redirectingName", str),
        E("redirecting_presentation_indicator", "redirectingPresentationIndicator", str),
        E("redirecting_reason", "RedirectingReason", str),
        E("account_authorization_code", "accountAuthorizationCode", str),
        E("call_authorization_code", "callAuthorizationCode", str),
        E("user_group_id", "userGroupId", str),
        E("user_id", "userId", str),
        E("user_primary_dn", "userPrimaryDn", str),
        E("user_primary_extension", "userPrimaryExtension", str),
        E("security_classification", "securityClassification", str),
    )

    #: str: *Required* callLogType
    call_log_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* countryCode
    country_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* callLogId
    call_log_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* callId
    call_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* subscriberType
    subscriber_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* dialedNumber
    dialed_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* calledNumber
    called_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* networkTranslatedAddress
    network_translated_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingAssertedNumber
    calling_asserted_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingPresentationNumber
    calling_presentation_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingPresentationNumberSource
    calling_presentation_number_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingPresentationName
    calling_presentation_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* callingPresentationIndicator
    calling_presentation_indicator = Field(type=str, required=True, mutable=False)
    #: str: *Optional* callingGroupId
    calling_group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* calledDirectoryName
    called_directory_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* calledGroupId
    called_group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* connectedNumber
    connected_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* connectedNumberSource
    connected_number_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* connectedName
    connected_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* connectedPresentationIndicator
    connected_presentation_indicator = Field(type=str, required=False, mutable=False)
    #: str: *Optional* typeOfNetwork
    type_of_network = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callCategory
    call_category = Field(type=str, required=False, mutable=False)
    #: str: *Required* basicCallType
    basic_call_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* configurableCallType
    configurable_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateCallIndicator
    alternate_call_indicator = Field(type=str, required=False, mutable=False)
    #: str: *Optional* virtualOnNetCallType
    virtual_on_net_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Required* time
    time = Field(type=str, required=True, mutable=False)
    #: int: *Required* startTime
    start_time = Field(type=int, required=True, mutable=False)
    #: int: *Optional* answerTime
    answer_time = Field(type=int, required=False, mutable=False)
    #: int: *Optional* releaseTime
    release_time = Field(type=int, required=False, mutable=False)
    #: int: *Optional* detachedTime
    detached_time = Field(type=int, required=False, mutable=False)
    #: int: *Optional* detachedAnswerTime
    detached_answer_time = Field(type=int, required=False, mutable=False)
    #: str: *Optional* outgoingDnis
    outgoing_dnis = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationDisposition
    service_invocation_disposition = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationDialedNumber
    service_invocation_dialed_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationCalledNumber
    service_invocation_called_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationNetworkTranslatedAddress
    service_invocation_network_translated_address = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* serviceInvocationTypeOfNetwork
    service_invocation_type_of_network = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationCallCategory
    service_invocation_call_category = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationBasicCallType
    service_invocation_basic_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationConfigurableCallType
    service_invocation_configurable_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationAlternateCallIndicator
    service_invocation_alternate_call_indicator = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* serviceInvocationVirtualOnNetCallType
    service_invocation_virtual_on_net_call_type = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* serviceInvocationCalledDirectoryName
    service_invocation_called_directory_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationCalledGroupId
    service_invocation_called_group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* redirectingNumber
    redirecting_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* redirectingName
    redirecting_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* redirectingPresentationIndicator
    redirecting_presentation_indicator = Field(type=str, required=False, mutable=False)
    #: str: *Optional* RedirectingReason
    redirecting_reason = Field(type=str, required=False, mutable=False)
    #: str: *Optional* accountAuthorizationCode
    account_authorization_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callAuthorizationCode
    call_authorization_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userGroupId
    user_group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userId
    user_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userPrimaryDn
    user_primary_dn = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userPrimaryExtension
    user_primary_extension = Field(type=str, required=False, mutable=False)
    #: str: *Optional* securityClassification
    security_classification = Field(type=str, required=False, mutable=False)


class ExtendedMixedCallLogsEntry21(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachedTime" represents the time when the call is
    successfully redirected by the system.  "releaseTime" represents the time when the
    call is released.  This time corresponds to the moment the call is released by the
    system, and not necessarily when one party hangs up, since this does not always mean
    the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  The following elements are only used in
    AS data mode: callAuthorizationCode securityClassification
    """

    _ELEMENTS = (
        E("call_log_type", "callLogType", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
        E("call_log_id", "callLogId", str, is_required=True),
        E("call_id", "callId", str, is_required=True),
        E("subscriber_type", "subscriberType", str, is_required=True),
        E("dialed_number", "dialedNumber", str),
        E("called_number", "calledNumber", str),
        E("network_translated_address", "networkTranslatedAddress", str),
        E("calling_asserted_number", "callingAssertedNumber", str),
        E("calling_presentation_number", "callingPresentationNumber", str),
        E("calling_presentation_number_source", "callingPresentationNumberSource", str),
        E("calling_presentation_name", "callingPresentationName", str),
        E(
            "calling_presentation_indicator", "callingPresentationIndicator", str,
            is_required=True,
        ),
        E("calling_group_id", "callingGroupId", str),
        E("called_directory_name", "calledDirectoryName", str),
        E("called_group_id", "calledGroupId", str),
        E("connected_number", "connectedNumber", str),
        E("connected_number_source", "connectedNumberSource", str),
        E("connected_name", "connectedName", str),
        E("connected_presentation_indicator", "connectedPresentationIndicator", str),
        E("type_of_network", "typeOfNetwork", str),
        E("call_category", "callCategory", str),
        E("basic_call_type", "basicCallType", str, is_required=True),
        E("configurable_call_type", "configurableCallType", str),
        E("alternate_call_indicator", "alternateCallIndicator", str),
        E("virtual_on_net_call_type", "virtualOnNetCallType", str),
        E("time", "time", str, is_required=True),
        E("start_time", "startTime", int, is_required=True),
        E("answer_time", "answerTime", int),
        E("release_time", "releaseTime", int),
        E("detached_time", "detachedTime", int),
        E("detached_answer_time", "detachedAnswerTime", int),
        E("outgoing_dnis", "outgoingDnis", str),
        E("service_invocation_disposition", "serviceInvocationDisposition", str),
        E("service_invocation_dialed_number", "serviceInvocationDialedNumber", str),
        E("service_invocation_called_number", "serviceInvocationCalledNumber", str),
        E(
            "service_invocation_network_translated_address",
            "serviceInvocationNetworkTranslatedAddress", str,
        ),
        E("service_invocation_type_of_network", "serviceInvocationTypeOfNetwork", str),
        E("service_invocation_call_category", "serviceInvocationCallCategory", str),
        E("service_invocation_basic_call_type", "serviceInvocationBasicCallType", str),
        E(
            "service_invocation_configurable_call_type",
            "serviceInvocationConfigurableCallType", str,
        ),
        E(
            "service_invocation_alternate_call_indicator",
            "serviceInvocationAlternateCallIndicator", str,
        ),
        E(
            "service_invocation_virtual_on_net_call_type",
            "serviceInvocationVirtualOnNetCallType", str,
        ),
        E(
            "service_invocation_called_directory_name",
            "serviceInvocationCalledDirectoryName", str,
        ),
        E("service_invocation_called_group_id", "serviceInvocationCalledGroupId", str),
        E("redirecting_number", "redirectingNumber", str),
        E("redirecting_name", "redirectingName", str),
        E("redirecting_presentation_indicator", "redirectingPresentationIndicator", str),
        E("redirecting_reason", "RedirectingReason", str),
        E("account_authorization_code", "accountAuthorizationCode", str),
        E("call_authorization_code", "callAuthorizationCode", str),
        E("user_group_id", "userGroupId", str),
        E("user_id", "userId", str),
        E("user_primary_dn", "userPrimaryDn", str),
        E("user_primary_extension", "userPrimaryExtension", str),
        E("security_classification", "securityClassification", str),
    )

    #: str: *Required* callLogType
    call_log_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* countryCode
    country_code = Field(type=str, required=True, mutable=False)
    #: str: *Required* callLogId
    call_log_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* callId
    call_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* subscriberType
    subscriber_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* dialedNumber
    dialed_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* calledNumber
    called_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* networkTranslatedAddress
    network_translated_address = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingAssertedNumber
    calling_asserted_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingPresentationNumber
    calling_presentation_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingPresentationNumberSource
    calling_presentation_number_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingPresentationName
    calling_presentation_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* callingPresentationIndicator
    calling_presentation_indicator = Field(type=str, required=True, mutable=False)
    #: str: *Optional* callingGroupId
    calling_group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* calledDirectoryName
    called_directory_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* calledGroupId
    called_group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* connectedNumber
    connected_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* connectedNumberSource
    connected_number_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* connectedName
    connected_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* connectedPresentationIndicator
    connected_presentation_indicator = Field(type=str, required=False, mutable=False)
    #: str: *Optional* typeOfNetwork
    type_of_network = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callCategory
    call_category = Field(type=str, required=False, mutable=False)
    #: str: *Required* basicCallType
    basic_call_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* configurableCallType
    configurable_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateCallIndicator
    alternate_call_indicator = Field(type=str, required=False, mutable=False)
    #: str: *Optional* virtualOnNetCallType
    virtual_on_net_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Required* time
    time = Field(type=str, required=True, mutable=False)
    #: int: *Required* startTime
    start_time = Field(type=int, required=True, mutable=False)
    #: int: *Optional* answerTime
    answer_time = Field(type=int, required=False, mutable=False)
    #: int: *Optional* releaseTime
    release_time = Field(type=int, required=False, mutable=False)
    #: int: *Optional* detachedTime
    detached_time = Field(type=int, required=False, mutable=False)
    #: int: *Optional* detachedAnswerTime
    detached_answer_time = Field(type=int, required=False, mutable=False)
    #: str: *Optional* outgoingDnis
    outgoing_dnis = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationDisposition
    service_invocation_disposition = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationDialedNumber
    service_invocation_dialed_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationCalledNumber
    service_invocation_called_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationNetworkTranslatedAddress
    service_invocation_network_translated_address = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* serviceInvocationTypeOfNetwork
    service_invocation_type_of_network = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationCallCategory
    service_invocation_call_category = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationBasicCallType
    service_invocation_basic_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationConfigurableCallType
    service_invocation_configurable_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationAlternateCallIndicator
    service_invocation_alternate_call_indicator = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* serviceInvocationVirtualOnNetCallType
    service_invocation_virtual_on_net_call_type = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* serviceInvocationCalledDirectoryName
    service_invocation_called_directory_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* serviceInvocationCalledGroupId
    service_invocation_called_group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* redirectingNumber
    redirecting_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* redirectingName
    redirecting_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* redirectingPresentationIndicator
    redirecting_presentation_indicator = Field(type=str, required=False, mutable=False)
    #: str: *Optional* RedirectingReason
    redirecting_reason = Field(type=str, required=False, mutable=False)
    #: str: *Optional* accountAuthorizationCode
    account_authorization_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callAuthorizationCode
    call_authorization_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userGroupId
    user_group_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userId
    user_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userPrimaryDn
    user_primary_dn = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userPrimaryExtension
    user_primary_extension = Field(type=str, required=False, mutable=False)
    #: str: *Optional* securityClassification
    security_classification = Field(type=str, required=False, mutable=False)


class ExtensionRange(OCIType):
    """
    Extension range.

    The minimum and maximum values are inclusive.
    """

    _ELEMENTS = (
        E("min_extension", "minExtension", str, is_required=True),
        E("max_extension", "maxExtension", str, is_required=True),
    )

    #: str: *Required* minExtension
    min_extension = Field(type=str, required=True, mutable=False)
    #: str: *Required* maxExtension
    max_extension = Field(type=str, required=True, mutable=False)


class ExtensionRange17(OCIType):
    """
    Extension range.

    The minimum and maximum values are inclusive.
    """

    _ELEMENTS = (
        E("min_extension", "minExtension", str, is_required=True),
        E("max_extension", "maxExtension", str, is_required=True),
    )

    #: str: *Required* minExtension
    min_extension = Field(type=str, required=True, mutable=False)
    #: str: *Required* maxExtension
    max_extension = Field(type=str, required=True, mutable=False)


class FeatureAccessCodeEntry(OCIType):
    """
    Feature Access Code Entry
    """

    _ELEMENTS = (
        E("feature_access_code_name", "featureAccessCodeName", str, is_required=True),
        E("main_code", "mainCode", str),
        E("alternate_code", "alternateCode", str),
    )

    #: str: *Required* featureAccessCodeName
    feature_access_code_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* mainCode
    main_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateCode
    alternate_code = Field(type=str, required=False, mutable=False)


class FeatureAccessCodeModifyEntry(OCIType):
    """
    Feature Access Code Entry to be used in all the system, service provider and group
    modify commands.

    """

    _ELEMENTS = (
        E("feature_access_code_name", "featureAccessCodeName", str, is_required=True),
        E("main_code", "mainCode", str),
        E("alternate_code", "alternateCode", str),
        E("enable_fac", "enableFAC", bool),
    )

    #: str: *Required* featureAccessCodeName
    feature_access_code_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* mainCode
    main_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateCode
    alternate_code = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableFAC
    enable_fac = Field(type=bool, required=False, mutable=False)


class FeatureAccessCodeReadEntry(OCIType):
    """
    Feature Access Code Entry to be used in all GET commands.

    """

    _ELEMENTS = (
        E("feature_access_code_name", "featureAccessCodeName", str, is_required=True),
        E("main_code", "mainCode", str),
        E("alternate_code", "alternateCode", str),
        E("enable_fac", "enableFAC", bool),
    )

    #: str: *Required* featureAccessCodeName
    feature_access_code_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* mainCode
    main_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateCode
    alternate_code = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* enableFAC
    enable_fac = Field(type=bool, required=False, mutable=False)


class FileRepositoryProtocolFTP(OCIType):
    """
    Attributes of the FTP protocol when the file repository interface is using FTP.

    """

    _ELEMENTS = (
        E("ftp_passive", "ftpPassive", bool, is_required=True),
        E("net_address", "netAddress", str, is_required=True),
    )

    #: bool: *Required* ftpPassive
    ftp_passive = Field(type=bool, required=True, mutable=False)
    #: str: *Required* netAddress
    net_address = Field(type=str, required=True, mutable=False)


class FileRepositoryProtocolFTP16(OCIType):
    """
    Attributes of the FTP protocol when the file repository interface is using FTP.

    """

    _ELEMENTS = (
        E("ftp_passive", "ftpPassive", bool, is_required=True),
        E("net_address", "netAddress", str, is_required=True),
        E("ftp_remote_verification", "ftpRemoteVerification", bool, is_required=True),
    )

    #: bool: *Required* ftpPassive
    ftp_passive = Field(type=bool, required=True, mutable=False)
    #: str: *Required* netAddress
    net_address = Field(type=str, required=True, mutable=False)
    #: bool: *Required* ftpRemoteVerification
    ftp_remote_verification = Field(type=bool, required=True, mutable=False)


class FileRepositoryProtocolWebDAV(OCIType):
    """
    Attributes of the WebDav protocol when the file repository interface is using WebDav.

    """

    _ELEMENTS = (
        E("secure", "secure", bool, is_required=True),
        E("net_address", "netAddress", str, is_required=True),
    )

    #: bool: *Required* secure
    secure = Field(type=bool, required=True, mutable=False)
    #: str: *Required* netAddress
    net_address = Field(type=str, required=True, mutable=False)


class FileRepositoryProtocolWebDAV20(OCIType):
    """
    Attributes of the WebDav protocol when the file repository interface is using WebDav.

    """

    _ELEMENTS = (
        E("secure", "secure", bool, is_required=True),
        E("net_address", "netAddress", str, is_required=True),
        E(
            "extended_file_capture_support", "extendedFileCaptureSupport", bool,
            is_required=True,
        ),
    )

    #: bool: *Required* secure
    secure = Field(type=bool, required=True, mutable=False)
    #: str: *Required* netAddress
    net_address = Field(type=str, required=True, mutable=False)
    #: bool: *Required* extendedFileCaptureSupport
    extended_file_capture_support = Field(type=bool, required=True, mutable=False)


class FileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer.

    """

    _ELEMENTS = (
        E("source_file_name", "sourceFileName", str),
        E("file_content", "fileContent", str),
    )

    #: str: *Optional* sourceFileName
    source_file_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* fileContent
    file_content = Field(type=str, required=False, mutable=False)


class FindMeFollowMeAlertingGroupReplacementOutgoingDNSIPURIorUserIdList(OCIType):
    """
    A list of phone numbers/sipuris or user ids that replaces a previously configured
    list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str),
        E("user_id", "userId", str),
    )

    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userId
    user_id = Field(type=str, required=False, mutable=False)


class GroupDepartmentKey(OCIType):
    """
    Uniquely identifies a department defined within a group.

    To uniquely identify a group department, we must know the department name and which
    group contains the department.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class GroupEnterpriseTrunkPriorityWeightedTrunkGroup(OCIType):
    """
    Trunk group details (order and weight) for each trunk group
    """

    _ELEMENTS = (
        E("trunk_group", "trunkGroup", str, is_required=True),
        E("priority", "priority", int, is_required=True),
        E("weight", "weight", int, is_required=True),
    )

    #: str: *Required* trunkGroup
    trunk_group = Field(type=str, required=True, mutable=False)
    #: int: *Required* priority
    priority = Field(type=int, required=True, mutable=False)
    #: int: *Required* weight
    weight = Field(type=int, required=True, mutable=False)


class GroupHuntGroupGetInstanceRequest17sp1V1(OCIType):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either GroupHuntGroupGetInstanceResponse17sp1V1 or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)


class GroupPreferredCarrierName(OCIType):
    """
    Group can either use it's service provider/enterprise's preferred carrier or use it's
    own.

    The group carrier name is exposed if it was previously configured.
    """

    _ELEMENTS = (
        E(
            "use_service_provider_preferred_carrier",
            "useServiceProviderPreferredCarrier", bool, is_required=True,
        ),
        E("carrier", "carrier", str),
    )

    #: bool: *Required* useServiceProviderPreferredCarrier
    use_service_provider_preferred_carrier = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* carrier
    carrier = Field(type=str, required=False, mutable=False)


class GroupPreferredCarrierNameModify(OCIType):
    """
    Group can either use it's service provider/enterprise's preferred carrier or use it's
    own.

    You can use the Service Provider preferred carrier without clearing the group carrier
    name -- in this case, the group carrier name is retained.
    """

    _ELEMENTS = (
        E(
            "use_service_provider_preferred_carrier",
            "useServiceProviderPreferredCarrier", bool, is_required=True,
        ),
        E("carrier", "carrier", str),
    )

    #: bool: *Required* useServiceProviderPreferredCarrier
    use_service_provider_preferred_carrier = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* carrier
    carrier = Field(type=str, required=False, mutable=False)


class Holiday(OCIType):
    """
    Holiday entry.

    """

    _ELEMENTS = (
        E("holiday_name", "holidayName", str, is_required=True),
        E("start_date", "startDate", str, is_required=True),
        E("end_date", "endDate", str),
    )

    #: str: *Required* holidayName
    holiday_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* startDate
    start_date = Field(type=str, required=True, mutable=False)
    #: str: *Optional* endDate
    end_date = Field(type=str, required=False, mutable=False)


class HolidaySchedule(OCIType):
    """
    Holiday Schedule.

    """

    _ELEMENTS = (
        E("type", "type", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* type
    type = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class HourMinute(OCIType):
    """
    Represents a specific time with hour and minute granularity
    """

    _ELEMENTS = (
        E("hour", "hour", int, is_required=True),
        E("minute", "minute", int, is_required=True),
    )

    #: int: *Required* hour
    hour = Field(type=int, required=True, mutable=False)
    #: int: *Required* minute
    minute = Field(type=int, required=True, mutable=False)


class HuntAgentWeight(OCIType):
    """
    The weighted call distribution weight for an agent.

    """

    _ELEMENTS = (
        E("agent_user_id", "agentUserId", str, is_required=True),
        E("weight", "weight", int, is_required=True),
    )

    #: str: *Required* agentUserId
    agent_user_id = Field(type=str, required=True, mutable=False)
    #: int: *Required* weight
    weight = Field(type=int, required=True, mutable=False)


class IPAddressRange(OCIType):
    """
    IP Address Range.

    """

    _ELEMENTS = (
        E("min_ip_address", "minIpAddress", str, is_required=True),
        E("max_ip_address", "maxIpAddress", str, is_required=True),
    )

    #: str: *Required* minIpAddress
    min_ip_address = Field(type=str, required=True, mutable=False)
    #: str: *Required* maxIpAddress
    max_ip_address = Field(type=str, required=True, mutable=False)


class IncomingCallingPlanDigitPatternPermission(OCIType):
    """
    Indicates whether calls from specified digit patterns are permitted.

    """

    _ELEMENTS = (
        E("digit_pattern_name", "digitPatternName", str, is_required=True),
        E("allow", "allow", bool, is_required=True),
    )

    #: str: *Required* digitPatternName
    digit_pattern_name = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allow
    allow = Field(type=bool, required=True, mutable=False)


class InterceptDNListEntry(OCIType):
    """
    Intercept User Entry containing the phone number and a Description.

    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class LDAPEntryField(OCIType):
    """
    One name value pair for a LDAP entry.

    """

    _ELEMENTS = (
        E("attribute_name", "attributeName", str, is_required=True),
        E("attribute_value", "attributeValue", str),
    )

    #: str: *Required* attributeName
    attribute_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* attributeValue
    attribute_value = Field(type=str, required=False, mutable=False)


class LDAPPage(OCIType):
    """
    Type to retrieve a particular page or the last page.

    """

    _ELEMENTS = (
        E("last_page", "lastPage", bool),
        E("number", "number", int),
    )

    #: bool: *Optional* lastPage
    last_page = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* number
    number = Field(type=int, required=False, mutable=False)


class LabeledFileNameResource(OCIType):
    """
    Represents an existing file for the application server to use, along with a
    description and mediaType.

    """

    _ELEMENTS = (
        E("description", "description", str, is_required=True),
        E("media_type", "mediaType", str, is_required=True),
        E("source_file_name", "sourceFileName", str, is_required=True),
    )

    #: str: *Required* description
    description = Field(type=str, required=True, mutable=False)
    #: str: *Required* mediaType
    media_type = Field(type=str, required=True, mutable=False)
    #: str: *Required* sourceFileName
    source_file_name = Field(type=str, required=True, mutable=False)


class LabeledFileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer with a description.

    """

    _ELEMENTS = (
        E("description", "description", str, is_required=True),
        E("source_file_name", "sourceFileName", str),
        E("content", "content", str),
    )

    #: str: *Required* description
    description = Field(type=str, required=True, mutable=False)
    #: str: *Optional* sourceFileName
    source_file_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* content
    content = Field(type=str, required=False, mutable=False)


class LabeledMediaFileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer with a description.

    """

    _ELEMENTS = (
        E("description", "description", str, is_required=True),
        E("media_type", "mediaType", str, is_required=True),
        E("source_file_name", "sourceFileName", str),
        E("content", "content", str),
    )

    #: str: *Required* description
    description = Field(type=str, required=True, mutable=False)
    #: str: *Required* mediaType
    media_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* sourceFileName
    source_file_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* content
    content = Field(type=str, required=False, mutable=False)


class MWIDeliveryToMobileEndpointTemplateActivation(OCIType):
    """
    MWI Delivery To Mobile Endpoint enabled status indicator
    """

    _ELEMENTS = (
        E("language", "language", str, is_required=True),
        E("type", "type", str, is_required=True),
        E("is_enabled", "isEnabled", bool, is_required=True),
    )

    #: str: *Required* language
    language = Field(type=str, required=True, mutable=False)
    #: str: *Required* type
    type = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isEnabled
    is_enabled = Field(type=bool, required=True, mutable=False)


class MWIDeliveryToMobileEndpointTemplateLine(OCIType):
    """
    MWI Delivery To Mobile Endpoint template section associated with a specific tag.

    """

    _ELEMENTS = (
        E("prefix", "prefix", str),
        E("tag", "tag", str),
        E("postfix", "postfix", str),
    )

    #: str: *Optional* prefix
    prefix = Field(type=str, required=False, mutable=False)
    #: str: *Optional* tag
    tag = Field(type=str, required=False, mutable=False)
    #: str: *Optional* postfix
    postfix = Field(type=str, required=False, mutable=False)


class MaliciousCallTraceTimePeriod(OCIType):
    """
    Modify the user level data associated with Malicious Call Trace.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("start_date_time", "startDateTime", str, is_required=True),
        E("stop_date_time", "stopDateTime", str, is_required=True),
    )

    #: str: *Required* startDateTime
    start_date_time = Field(type=str, required=True, mutable=False)
    #: str: *Required* stopDateTime
    stop_date_time = Field(type=str, required=True, mutable=False)


class MeetMeConferencingConferenceDuration(OCIType):
    """
    Conference duration.

    """

    _ELEMENTS = (
        E("hours", "hours", int, is_required=True),
        E("minutes", "minutes", int, is_required=True),
    )

    #: int: *Required* hours
    hours = Field(type=int, required=True, mutable=False)
    #: int: *Required* minutes
    minutes = Field(type=int, required=True, mutable=False)


class MeetMeConferencingConferenceKey(OCIType):
    """
    Identifier for conference.

    """

    _ELEMENTS = (
        E("bridge_id", "bridgeId", str, is_required=True),
        E("conference_id", "conferenceId", str, is_required=True),
    )

    #: str: *Required* bridgeId
    bridge_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* conferenceId
    conference_id = Field(type=str, required=True, mutable=False)


class MeetMeConferencingConferencePorts(OCIType):
    """
    Number of conference ports.

    Can either be unlimited or limited to a value between 0 and 999999.
    """

    _ELEMENTS = (
        E("unlimited", "unlimited", bool),
        E("quantity", "quantity", int),
    )

    #: bool: *Optional* unlimited
    unlimited = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* quantity
    quantity = Field(type=int, required=False, mutable=False)


class MeetMeConferencingConferenceRecordingKey(OCIType):
    """
    Identifier for conference recording.

    startTime is the recording start timestamp.
    """

    _ELEMENTS = (
        E("bridge_id", "bridgeId", str, is_required=True),
        E("conference_id", "conferenceId", str, is_required=True),
        E("start_time", "startTime", str, is_required=True),
    )

    #: str: *Required* bridgeId
    bridge_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* conferenceId
    conference_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* startTime
    start_time = Field(type=str, required=True, mutable=False)


class MeetMeConferencingConferenceSchedule(OCIType):
    """
    Conference schedule.

    """

    _ELEMENTS = (
        E(
            "schedule_reservationless", "scheduleReservationless", str, is_complex=True,
        ),  # unknown
        E("schedule_one_time", "scheduleOneTime", str, is_complex=True),  # unknown
        E("schedule_recurring", "scheduleRecurring", str, is_complex=True),  # unknown
    )

    #: str: *Optional* scheduleReservationless
    schedule_reservationless = Field(type=str, required=False, mutable=False)
    #: str: *Optional* scheduleOneTime
    schedule_one_time = Field(type=str, required=False, mutable=False)
    #: str: *Optional* scheduleRecurring
    schedule_recurring = Field(type=str, required=False, mutable=False)


class MixedCallLogsEntry(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.

    """

    _ELEMENTS = (
        E("call_log_type", "callLogType", str, is_required=True),
        E("country_code", "countryCode", str),
        E("call_log_id", "callLogId", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("time", "time", str, is_required=True),
    )

    #: str: *Required* callLogType
    call_log_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* countryCode
    country_code = Field(type=str, required=False, mutable=False)
    #: str: *Required* callLogId
    call_log_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* time
    time = Field(type=str, required=True, mutable=False)


class MusicOnHoldSourceAdd(OCIType):
    """
    Contains the music on hold source configuration.

    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(type=str, required=True, mutable=False)
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* externalSource
    external_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceAdd16(OCIType):
    """
    Contains the music on hold source configuration.

    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(type=str, required=True, mutable=False)
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* externalSource
    external_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceAdd20(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced by: MusicOnHoldSourceAdd21
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(type=str, required=True, mutable=False)
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* externalSource
    external_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceAdd21(OCIType):
    """
    Contains the music on hold source configuration.

    The following elements are only used in HSS data mode and ignored in AS data mode:
    labeledMediaFiles The following elements are only used in AS data mode and ignored in
    HSS data mode: announcementMediaFiles
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E(
            "labeled_custom_source_media_files", "labeledCustomSourceMediaFiles", str,
            is_complex=True,
        ),  # unknown
        E(
            "announcement_custom_source_media_files",
            "announcementCustomSourceMediaFiles", str, is_complex=True,
        ),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(type=str, required=True, mutable=False)
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* labeledCustomSourceMediaFiles
    labeled_custom_source_media_files = Field(type=str, required=False, mutable=False)
    #: str: *Optional* announcementCustomSourceMediaFiles
    announcement_custom_source_media_files = Field(type=str, required=False, mutable=False)
    #: str: *Optional* externalSource
    external_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceModify(OCIType):
    """
    Contains the music on hold source configuration.

    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str),
        E("message_source_selection", "messageSourceSelection", str),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    #: str: *Optional* audioFilePreferredCodec
    audio_file_preferred_codec = Field(type=str, required=False, mutable=False)
    #: str: *Optional* messageSourceSelection
    message_source_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* externalSource
    external_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceModify16(OCIType):
    """
    Contains the music on hold source configuration.

    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str),
        E("message_source_selection", "messageSourceSelection", str),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    #: str: *Optional* audioFilePreferredCodec
    audio_file_preferred_codec = Field(type=str, required=False, mutable=False)
    #: str: *Optional* messageSourceSelection
    message_source_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* externalSource
    external_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceModify20(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced by: MusicOnHoldSourceModify21
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str),
        E("message_source_selection", "messageSourceSelection", str),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    #: str: *Optional* audioFilePreferredCodec
    audio_file_preferred_codec = Field(type=str, required=False, mutable=False)
    #: str: *Optional* messageSourceSelection
    message_source_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* externalSource
    external_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceModify21(OCIType):
    """
    Contains the music on hold source configuration.

    The following elements are only used in HSS data mode and ignored in AS data mode:
    labeledMediaFiles The following elements are only used in AS data mode and ignored in
    HSS data mode: announcementMediaFiles
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str),
        E("message_source_selection", "messageSourceSelection", str),
        E(
            "labeled_custom_source_media_files", "labeledCustomSourceMediaFiles", str,
            is_complex=True,
        ),  # unknown
        E(
            "announcement_custom_source_media_files",
            "announcementCustomSourceMediaFiles", str, is_complex=True,
        ),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    #: str: *Optional* audioFilePreferredCodec
    audio_file_preferred_codec = Field(type=str, required=False, mutable=False)
    #: str: *Optional* messageSourceSelection
    message_source_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* labeledCustomSourceMediaFiles
    labeled_custom_source_media_files = Field(type=str, required=False, mutable=False)
    #: str: *Optional* announcementCustomSourceMediaFiles
    announcement_custom_source_media_files = Field(type=str, required=False, mutable=False)
    #: str: *Optional* externalSource
    external_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceRead(OCIType):
    """
    Contains the music on hold source configuration.

    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(type=str, required=True, mutable=False)
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* externalSource
    external_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceRead16(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced by: MusicOnHoldSourceRead19.
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(type=str, required=True, mutable=False)
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* externalSource
    external_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceRead19(OCIType):
    """
    Contains the music on hold source configuration.

    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(type=str, required=True, mutable=False)
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* externalSource
    external_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceRead20(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced by: MusicOnHoldSourceRead21
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(type=str, required=True, mutable=False)
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)
    #: str: *Optional* externalSource
    external_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceRead21(OCIType):
    """
    Contains the music on hold source configuration.

    The following elements are only used in HSS data mode and not returned in AS data
    mode: labeledCustomSourceMediaFiles The following elements are only used in AS data
    mode and not returned in HSS data mode: announcementMediaFiles
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E(
            "labeled_custom_source_media_files", "labeledCustomSourceMediaFiles", str,
            is_complex=True,
        ),  # unknown
        E(
            "announcement_custom_source_media_files",
            "announcementCustomSourceMediaFiles", str, is_complex=True,
        ),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(type=str, required=True, mutable=False)
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* labeledCustomSourceMediaFiles
    labeled_custom_source_media_files = Field(type=str, required=False, mutable=False)
    #: str: *Optional* announcementCustomSourceMediaFiles
    announcement_custom_source_media_files = Field(type=str, required=False, mutable=False)
    #: str: *Optional* externalSource
    external_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldUserSourceModify(OCIType):
    """
    Contains the music on hold user source configuration.

    """

    _ELEMENTS = (
        E("message_source_selection", "messageSourceSelection", str),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
    )

    #: str: *Optional* messageSourceSelection
    message_source_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldUserSourceModify16(OCIType):
    """
    Contains the music on hold user source configuration.

    """

    _ELEMENTS = (
        E("message_source_selection", "messageSourceSelection", str),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
    )

    #: str: *Optional* messageSourceSelection
    message_source_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldUserSourceModify20(OCIType):
    """
    Contains the music on hold user source configuration.

    """

    _ELEMENTS = (
        E("message_source_selection", "messageSourceSelection", str),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
    )

    #: str: *Optional* messageSourceSelection
    message_source_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldUserSourceRead(OCIType):
    """
    Contains the music on hold user source configuration.

    """

    _ELEMENTS = (
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
    )

    #: str: *Required* messageSourceSelection
    message_source_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldUserSourceRead16(OCIType):
    """
    Contains the music on hold user source configuration.

    """

    _ELEMENTS = (
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
    )

    #: str: *Required* messageSourceSelection
    message_source_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)


class MusicOnHoldUserSourceRead20(OCIType):
    """
    Contains the music on hold user source configuration.

    """

    _ELEMENTS = (
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
    )

    #: str: *Required* messageSourceSelection
    message_source_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* customSource
    custom_source = Field(type=str, required=False, mutable=False)


class NameDialingName(OCIType):
    """
    Name dialing last and first names.

    """

    _ELEMENTS = (
        E("name_dialing_last_name", "nameDialingLastName", str, is_required=True),
        E("name_dialing_first_name", "nameDialingFirstName", str, is_required=True),
    )

    #: str: *Required* nameDialingLastName
    name_dialing_last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* nameDialingFirstName
    name_dialing_first_name = Field(type=str, required=True, mutable=False)


class NetworkClassOfServiceCommunicationBarringProfile(OCIType):
    """
    Communication Barring Profile defined as part of the Network Class Of Service.

    There can be only one primary profile within a Network Class Of Service.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("is_primary", "isPrimary", bool, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isPrimary
    is_primary = Field(type=bool, required=True, mutable=False)


class OutgoingCallingPlanAuthorizationCodeEntry(OCIType):
    """
    Outgoing Calling Plan Authorization Code.

    """

    _ELEMENTS = (
        E("code", "code", str, is_required=True),
        E("description", "description", str),
    )

    #: str: *Required* code
    code = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class OutgoingCallingPlanCallMeNowPermissions(OCIType):
    """
    Outgoing Calling Plan for Call Me Now call permissions.

    """

    _ELEMENTS = (
        E("group", "group", bool, is_required=True),
        E("local", "local", bool, is_required=True),
        E("toll_free", "tollFree", bool, is_required=True),
        E("toll", "toll", bool, is_required=True),
        E("international", "international", bool, is_required=True),
        E("operator_assisted", "operatorAssisted", bool, is_required=True),
        E(
            "chargeable_directory_assisted", "chargeableDirectoryAssisted", bool,
            is_required=True,
        ),
        E("special_services_i", "specialServicesI", bool, is_required=True),
        E("special_services_ii", "specialServicesII", bool, is_required=True),
        E("premium_services_i", "premiumServicesI", bool, is_required=True),
        E("premium_services_ii", "premiumServicesII", bool, is_required=True),
        E("casual", "casual", bool, is_required=True),
        E("url_dialing", "urlDialing", bool, is_required=True),
        E("unknown", "unknown", bool, is_required=True),
    )

    #: bool: *Required* group
    group = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* local
    local = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* tollFree
    toll_free = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* toll
    toll = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* international
    international = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* operatorAssisted
    operator_assisted = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* chargeableDirectoryAssisted
    chargeable_directory_assisted = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* specialServicesI
    special_services_i = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* specialServicesII
    special_services_ii = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* premiumServicesI
    premium_services_i = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* premiumServicesII
    premium_services_ii = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* casual
    casual = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* urlDialing
    url_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* unknown
    unknown = Field(type=bool, required=True, mutable=False)


class OutgoingCallingPlanCallMeNowPermissionsModify(OCIType):
    """
    Modify outgoing Calling Plan for Call Me Now call permissions.

    """

    _ELEMENTS = (
        E("group", "group", bool),
        E("local", "local", bool),
        E("toll_free", "tollFree", bool),
        E("toll", "toll", bool),
        E("international", "international", bool),
        E("operator_assisted", "operatorAssisted", bool),
        E("chargeable_directory_assisted", "chargeableDirectoryAssisted", bool),
        E("special_services_i", "specialServicesI", bool),
        E("special_services_ii", "specialServicesII", bool),
        E("premium_services_i", "premiumServicesI", bool),
        E("premium_services_ii", "premiumServicesII", bool),
        E("casual", "casual", bool),
        E("url_dialing", "urlDialing", bool),
        E("unknown", "unknown", bool),
    )

    #: bool: *Optional* group
    group = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* local
    local = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* tollFree
    toll_free = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* toll
    toll = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* international
    international = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* operatorAssisted
    operator_assisted = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* chargeableDirectoryAssisted
    chargeable_directory_assisted = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* specialServicesI
    special_services_i = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* specialServicesII
    special_services_ii = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* premiumServicesI
    premium_services_i = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* premiumServicesII
    premium_services_ii = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* casual
    casual = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* urlDialing
    url_dialing = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* unknown
    unknown = Field(type=bool, required=False, mutable=False)


class OutgoingCallingPlanDigitPatternCallMeNowPermission(OCIType):
    """
    Indicates whether Call Me Now calls using specified digit patterns are permitted.

    """

    _ELEMENTS = (
        E("digit_pattern_name", "digitPatternName", str, is_required=True),
        E("permission", "permission", bool, is_required=True),
    )

    #: str: *Required* digitPatternName
    digit_pattern_name = Field(type=str, required=True, mutable=False)
    #: bool: *Required* permission
    permission = Field(type=bool, required=True, mutable=False)


class OutgoingCallingPlanDigitPatternOriginatingPermission(OCIType):
    """
    Indicates whether originating calls using specified digit patterns are permitted.

    """

    _ELEMENTS = (
        E("digit_pattern_name", "digitPatternName", str, is_required=True),
        E("permission", "permission", str, is_required=True),
    )

    #: str: *Required* digitPatternName
    digit_pattern_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* permission
    permission = Field(type=str, required=True, mutable=False)


class OutgoingCallingPlanDigitPatternRedirectingPermission(OCIType):
    """
    Indicates whether redirecting calls using specified digit patterns are permitted.

    """

    _ELEMENTS = (
        E("digit_pattern_name", "digitPatternName", str, is_required=True),
        E("permission", "permission", bool, is_required=True),
    )

    #: str: *Required* digitPatternName
    digit_pattern_name = Field(type=str, required=True, mutable=False)
    #: bool: *Required* permission
    permission = Field(type=bool, required=True, mutable=False)


class OutgoingCallingPlanOriginatingPermissions(OCIType):
    """
    Outgoing Calling Plan originating call permissions.

    """

    _ELEMENTS = (
        E("group", "group", str, is_required=True),
        E("local", "local", str, is_required=True),
        E("toll_free", "tollFree", str, is_required=True),
        E("toll", "toll", str, is_required=True),
        E("international", "international", str, is_required=True),
        E("operator_assisted", "operatorAssisted", str, is_required=True),
        E(
            "chargeable_directory_assisted", "chargeableDirectoryAssisted", str,
            is_required=True,
        ),
        E("special_services_i", "specialServicesI", str, is_required=True),
        E("special_services_ii", "specialServicesII", str, is_required=True),
        E("premium_services_i", "premiumServicesI", str, is_required=True),
        E("premium_services_ii", "premiumServicesII", str, is_required=True),
        E("casual", "casual", str, is_required=True),
        E("url_dialing", "urlDialing", str, is_required=True),
        E("unknown", "unknown", str, is_required=True),
    )

    #: str: *Required* group
    group = Field(type=str, required=True, mutable=False)
    #: str: *Required* local
    local = Field(type=str, required=True, mutable=False)
    #: str: *Required* tollFree
    toll_free = Field(type=str, required=True, mutable=False)
    #: str: *Required* toll
    toll = Field(type=str, required=True, mutable=False)
    #: str: *Required* international
    international = Field(type=str, required=True, mutable=False)
    #: str: *Required* operatorAssisted
    operator_assisted = Field(type=str, required=True, mutable=False)
    #: str: *Required* chargeableDirectoryAssisted
    chargeable_directory_assisted = Field(type=str, required=True, mutable=False)
    #: str: *Required* specialServicesI
    special_services_i = Field(type=str, required=True, mutable=False)
    #: str: *Required* specialServicesII
    special_services_ii = Field(type=str, required=True, mutable=False)
    #: str: *Required* premiumServicesI
    premium_services_i = Field(type=str, required=True, mutable=False)
    #: str: *Required* premiumServicesII
    premium_services_ii = Field(type=str, required=True, mutable=False)
    #: str: *Required* casual
    casual = Field(type=str, required=True, mutable=False)
    #: str: *Required* urlDialing
    url_dialing = Field(type=str, required=True, mutable=False)
    #: str: *Required* unknown
    unknown = Field(type=str, required=True, mutable=False)


class OutgoingCallingPlanOriginatingPermissionsModify(OCIType):
    """
    Outgoing Calling Plan originating call permissions.

    """

    _ELEMENTS = (
        E("group", "group", str),
        E("local", "local", str),
        E("toll_free", "tollFree", str),
        E("toll", "toll", str),
        E("international", "international", str),
        E("operator_assisted", "operatorAssisted", str),
        E("chargeable_directory_assisted", "chargeableDirectoryAssisted", str),
        E("special_services_i", "specialServicesI", str),
        E("special_services_ii", "specialServicesII", str),
        E("premium_services_i", "premiumServicesI", str),
        E("premium_services_ii", "premiumServicesII", str),
        E("casual", "casual", str),
        E("url_dialing", "urlDialing", str),
        E("unknown", "unknown", str),
    )

    #: str: *Optional* group
    group = Field(type=str, required=False, mutable=False)
    #: str: *Optional* local
    local = Field(type=str, required=False, mutable=False)
    #: str: *Optional* tollFree
    toll_free = Field(type=str, required=False, mutable=False)
    #: str: *Optional* toll
    toll = Field(type=str, required=False, mutable=False)
    #: str: *Optional* international
    international = Field(type=str, required=False, mutable=False)
    #: str: *Optional* operatorAssisted
    operator_assisted = Field(type=str, required=False, mutable=False)
    #: str: *Optional* chargeableDirectoryAssisted
    chargeable_directory_assisted = Field(type=str, required=False, mutable=False)
    #: str: *Optional* specialServicesI
    special_services_i = Field(type=str, required=False, mutable=False)
    #: str: *Optional* specialServicesII
    special_services_ii = Field(type=str, required=False, mutable=False)
    #: str: *Optional* premiumServicesI
    premium_services_i = Field(type=str, required=False, mutable=False)
    #: str: *Optional* premiumServicesII
    premium_services_ii = Field(type=str, required=False, mutable=False)
    #: str: *Optional* casual
    casual = Field(type=str, required=False, mutable=False)
    #: str: *Optional* urlDialing
    url_dialing = Field(type=str, required=False, mutable=False)
    #: str: *Optional* unknown
    unknown = Field(type=str, required=False, mutable=False)


class OutgoingCallingPlanRedirectedPermissions(OCIType):
    """
    Outgoing Calling Plan being forwarded/transferred permissions.

    """

    _ELEMENTS = (
        E("outside_group", "outsideGroup", bool, is_required=True),
    )

    #: bool: *Required* outsideGroup
    outside_group = Field(type=bool, required=True, mutable=False)


class OutgoingCallingPlanRedirectedPermissionsModify(OCIType):
    """
    Outgoing Calling Plan being forwarded/transferred permissions.

    """

    _ELEMENTS = (
        E("outside_group", "outsideGroup", bool),
    )

    #: bool: *Optional* outsideGroup
    outside_group = Field(type=bool, required=False, mutable=False)


class OutgoingCallingPlanRedirectingPermissions(OCIType):
    """
    Outgoing Calling Plan initiating call forwards/transfer permissions.

    """

    _ELEMENTS = (
        E("group", "group", bool, is_required=True),
        E("local", "local", bool, is_required=True),
        E("toll_free", "tollFree", bool, is_required=True),
        E("toll", "toll", bool, is_required=True),
        E("international", "international", bool, is_required=True),
        E("operator_assisted", "operatorAssisted", bool, is_required=True),
        E(
            "chargeable_directory_assisted", "chargeableDirectoryAssisted", bool,
            is_required=True,
        ),
        E("special_services_i", "specialServicesI", bool, is_required=True),
        E("special_services_ii", "specialServicesII", bool, is_required=True),
        E("premium_services_i", "premiumServicesI", bool, is_required=True),
        E("premium_services_ii", "premiumServicesII", bool, is_required=True),
        E("casual", "casual", bool, is_required=True),
        E("url_dialing", "urlDialing", bool, is_required=True),
        E("unknown", "unknown", bool, is_required=True),
    )

    #: bool: *Required* group
    group = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* local
    local = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* tollFree
    toll_free = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* toll
    toll = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* international
    international = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* operatorAssisted
    operator_assisted = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* chargeableDirectoryAssisted
    chargeable_directory_assisted = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* specialServicesI
    special_services_i = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* specialServicesII
    special_services_ii = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* premiumServicesI
    premium_services_i = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* premiumServicesII
    premium_services_ii = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* casual
    casual = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* urlDialing
    url_dialing = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* unknown
    unknown = Field(type=bool, required=True, mutable=False)


class OutgoingCallingPlanRedirectingPermissionsModify(OCIType):
    """
    Outgoing Calling Plan initiating call forwards/transfer permissions.

    """

    _ELEMENTS = (
        E("group", "group", bool),
        E("local", "local", bool),
        E("toll_free", "tollFree", bool),
        E("toll", "toll", bool),
        E("international", "international", bool),
        E("operator_assisted", "operatorAssisted", bool),
        E("chargeable_directory_assisted", "chargeableDirectoryAssisted", bool),
        E("special_services_i", "specialServicesI", bool),
        E("special_services_ii", "specialServicesII", bool),
        E("premium_services_i", "premiumServicesI", bool),
        E("premium_services_ii", "premiumServicesII", bool),
        E("casual", "casual", bool),
        E("url_dialing", "urlDialing", bool),
        E("unknown", "unknown", bool),
    )

    #: bool: *Optional* group
    group = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* local
    local = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* tollFree
    toll_free = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* toll
    toll = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* international
    international = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* operatorAssisted
    operator_assisted = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* chargeableDirectoryAssisted
    chargeable_directory_assisted = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* specialServicesI
    special_services_i = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* specialServicesII
    special_services_ii = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* premiumServicesI
    premium_services_i = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* premiumServicesII
    premium_services_ii = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* casual
    casual = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* urlDialing
    url_dialing = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* unknown
    unknown = Field(type=bool, required=False, mutable=False)


class OutgoingCallingPlanTransferNumbers(OCIType):
    """
    Outgoing Calling Plan transfer numbers.

    """

    _ELEMENTS = (
        E("phone_number01", "phoneNumber01", str),
        E("phone_number02", "phoneNumber02", str),
        E("phone_number03", "phoneNumber03", str),
    )

    #: str: *Optional* phoneNumber01
    phone_number01 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber02
    phone_number02 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber03
    phone_number03 = Field(type=str, required=False, mutable=False)


class OutgoingCallingPlanTransferNumbersModify(OCIType):
    """
    Outgoing Calling Plan transfer numbers.

    """

    _ELEMENTS = (
        E("phone_number01", "phoneNumber01", str),
        E("phone_number02", "phoneNumber02", str),
        E("phone_number03", "phoneNumber03", str),
    )

    #: str: *Optional* phoneNumber01
    phone_number01 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber02
    phone_number02 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber03
    phone_number03 = Field(type=str, required=False, mutable=False)


class OutgoingPinholeDigitPlanDigitPatternCallMeNowPermission(OCIType):
    """
    Indicates whether Call Me Now calls using specified Pinhole digit patterns are
    permitted.

    """

    _ELEMENTS = (
        E("digit_pattern_name", "digitPatternName", str, is_required=True),
        E("permission", "permission", str, is_required=True),
    )

    #: str: *Required* digitPatternName
    digit_pattern_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* permission
    permission = Field(type=str, required=True, mutable=False)


class OutgoingPinholeDigitPlanDigitPatternOriginatingPermission(OCIType):
    """
    Indicates whether originating calls using specified Pinhole digit patterns are
    permitted.

    """

    _ELEMENTS = (
        E("digit_pattern_name", "digitPatternName", str, is_required=True),
        E("permission", "permission", str, is_required=True),
    )

    #: str: *Required* digitPatternName
    digit_pattern_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* permission
    permission = Field(type=str, required=True, mutable=False)


class OutgoingPinholeDigitPlanDigitPatternRedirectingPermission(OCIType):
    """
    Indicates whether redirecting calls using specified Pinhole digit patterns are
    permitted.

    """

    _ELEMENTS = (
        E("digit_pattern_name", "digitPatternName", str, is_required=True),
        E("permission", "permission", str, is_required=True),
    )

    #: str: *Required* digitPatternName
    digit_pattern_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* permission
    permission = Field(type=str, required=True, mutable=False)


class PhoneListEntry(OCIType):
    """
    Phone list entry.

    """

    _ELEMENTS = (
        E("entry_name", "entryName", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    #: str: *Required* entryName
    entry_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)


class PriorityAlertCriteriaFromDn(OCIType):
    """
    The from dn criteria used within an add/get request.

    """

    _ELEMENTS = (
        E("from_dn_criteria_selection", "fromDnCriteriaSelection", str, is_required=True),
        E("include_anonymous_callers", "includeAnonymousCallers", bool, is_required=True),
        E("include_unavailable_callers", "includeUnavailableCallers", bool, is_required=True),
        E("phone_number", "phoneNumber", str),
    )

    #: str: *Required* fromDnCriteriaSelection
    from_dn_criteria_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* includeAnonymousCallers
    include_anonymous_callers = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* includeUnavailableCallers
    include_unavailable_callers = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)


class PublicUserIdentity(OCIType):
    """
    Public User Identity
    """

    _ELEMENTS = (
        E("sip_uri", "sipURI", str),
        E("tel_uri", "telURI", str),
    )

    #: str: *Optional* sipURI
    sip_uri = Field(type=str, required=False, mutable=False)
    #: str: *Optional* telURI
    tel_uri = Field(type=str, required=False, mutable=False)


class RandomPort(OCIType):
    """
    Represents either a random port number, or a specific port number.

    """

    _ELEMENTS = (
        E("random", "random", str),
        E("port", "port", int),
    )

    #: str: *Optional* random
    random = Field(type=str, required=False, mutable=False)
    #: int: *Optional* port
    port = Field(type=int, required=False, mutable=False)


class Recurrence(OCIType):
    """
    Defines recurrence.

    """

    _ELEMENTS = (
        E("recur_daily", "recurDaily", str, is_complex=True),  # unknown
        E("recur_weekly", "recurWeekly", str, is_complex=True),  # unknown
        E("recur_monthly_by_day", "recurMonthlyByDay", str, is_complex=True),  # unknown
        E("recur_monthly_by_week", "recurMonthlyByWeek", str, is_complex=True),  # unknown
        E("recur_yearly_by_day", "recurYearlyByDay", str, is_complex=True),  # unknown
        E("recur_yearly_by_week", "recurYearlyByWeek", str, is_complex=True),  # unknown
        E("recur_for_ever", "recurForEver", bool),
        E("recur_end_date", "recurEndDate", str),
        E("recur_end_occurrence", "recurEndOccurrence", int),
    )

    #: str: *Optional* recurDaily
    recur_daily = Field(type=str, required=False, mutable=False)
    #: str: *Optional* recurWeekly
    recur_weekly = Field(type=str, required=False, mutable=False)
    #: str: *Optional* recurMonthlyByDay
    recur_monthly_by_day = Field(type=str, required=False, mutable=False)
    #: str: *Optional* recurMonthlyByWeek
    recur_monthly_by_week = Field(type=str, required=False, mutable=False)
    #: str: *Optional* recurYearlyByDay
    recur_yearly_by_day = Field(type=str, required=False, mutable=False)
    #: str: *Optional* recurYearlyByWeek
    recur_yearly_by_week = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* recurForEver
    recur_for_ever = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* recurEndDate
    recur_end_date = Field(type=str, required=False, mutable=False)
    #: int: *Optional* recurEndOccurrence
    recur_end_occurrence = Field(type=int, required=False, mutable=False)


class ReplacementCallProcessingPolicyProfileSubscriberTypeList(OCIType):
    """
    A list of CallProcessingPolicyProfileSubscriberType.

    The list replaces a previously configured list.
    """

    _ELEMENTS = (
        E("subscriber_type", "subscriberType", str, is_required=True),
    )

    #: str: *Required* subscriberType
    subscriber_type = Field(type=str, required=True, mutable=False)


class ReplacementCallProcessingPolicyProfileSubscriberTypeList20(OCIType):
    """
    A list of CallProcessingPolicyProfileSubscriberType20.

    The list replaces a previously configured list.
    """

    _ELEMENTS = (
        E("subscriber_type", "subscriberType", str, is_required=True),
    )

    #: str: *Required* subscriberType
    subscriber_type = Field(type=str, required=True, mutable=False)


class ReplacementCallProcessingPolicyProfileSubscriberTypeList21(OCIType):
    """
    A list of CallProcessingPolicyProfileSubscriberType21.

    The list replaces a previously configured list.
    """

    _ELEMENTS = (
        E("subscriber_type", "subscriberType", str, is_required=True),
    )

    #: str: *Required* subscriberType
    subscriber_type = Field(type=str, required=True, mutable=False)


class ReplacementCommunicationBarringAlternateCallIndicatorList(OCIType):
    """
    A list of Communication Barring Alternate Call Indicator that replaces a previously
    configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("alternate_call_indicator", "alternateCallIndicator", str, is_required=True),
    )

    #: str: *Required* alternateCallIndicator
    alternate_call_indicator = Field(type=str, required=True, mutable=False)


class ReplacementCommunicationBarringCallTypeList(OCIType):
    """
    A list of Communication Barring Call Types that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("call_type", "callType", str, is_required=True),
    )

    #: str: *Required* callType
    call_type = Field(type=str, required=True, mutable=False)


class ReplacementContactList(OCIType):
    """
    A list of SIP contacts that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("contact", "contact", str, is_required=True),
    )

    #: str: *Required* contact
    contact = Field(type=str, required=True, mutable=False)


class ReplacementDNList(OCIType):
    """
    A list of dns that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)


class ReplacementEnterpriseTrunkTrunkGroupList(OCIType):
    """
    A list of Group Trunk Krunk Group Names that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("trunk_group", "trunkGroup", str, is_required=True),
    )

    #: str: *Required* trunkGroup
    trunk_group = Field(type=str, required=True, mutable=False)


class ReplacementGroupEnterpriseTrunkTrunkGroupList(OCIType):
    """
    A list of Group Trunk Krunk Group Names that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("trunk_group", "trunkGroup", str, is_required=True),
    )

    #: str: *Required* trunkGroup
    trunk_group = Field(type=str, required=True, mutable=False)


class ReplacementMediaNameList(OCIType):
    """
    A list of media that replaces a previously configured list.

    """

    _ELEMENTS = (
        E("media_name", "mediaName", str, is_required=True),
    )

    #: str: *Required* mediaName
    media_name = Field(type=str, required=True, mutable=False)


class ReplacementNumberPortabilityStatusList(OCIType):
    """
    A list of Number Portability Query Statuses that replaces a previously configured
    list.

    By convention, an element of this type may be set to nill to clear the list.
    """

    _ELEMENTS = (
        E("status", "status", str, is_required=True),
    )

    #: str: *Required* status
    status = Field(type=str, required=True, mutable=False)


class ReplacementOCICallControlApplicationIdList(OCIType):
    """
    A list of applicationIds that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("application_id", "applicationId", str, is_required=True),
    )

    #: str: *Required* applicationId
    application_id = Field(type=str, required=True, mutable=False)


class ReplacementOutgoingDNList(OCIType):
    """
    A list of outgoing dns that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)


class ReplacementOutgoingDNorSIPURIList(OCIType):
    """
    A list of phone numbers or sipuris that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)


class ReplacementSIPAliasList(OCIType):
    """
    A list of SIP aliases that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("sip_alias", "sipAlias", str, is_required=True),
    )

    #: str: *Required* sipAlias
    sip_alias = Field(type=str, required=True, mutable=False)


class ReplacementServicePackNameList(OCIType):
    """
    A list of service packs that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("service_pack_name", "servicePackName", str, is_required=True),
    )

    #: str: *Required* servicePackName
    service_pack_name = Field(type=str, required=True, mutable=False)


class ReplacementUserIdList(OCIType):
    """
    A list of userIds that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class ReplacementUserServiceList(OCIType):
    """
    A list of user services that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("service_name", "serviceName", str, is_required=True),
    )

    #: str: *Required* serviceName
    service_name = Field(type=str, required=True, mutable=False)


class ReplacementVirtualOnNetCallTypeNameList(OCIType):
    """
    A list of Virtual On-Net Call Types that replaces a previously configured list.

    By convention, an element of this type may be set to nill to clear the list.
    """

    _ELEMENTS = (
        E("virtual_on_net_call_type_name", "virtualOnNetCallTypeName", str, is_required=True),
    )

    #: str: *Required* virtualOnNetCallTypeName
    virtual_on_net_call_type_name = Field(type=str, required=True, mutable=False)


class ReplacementZoneList(OCIType):
    """
    Contains an ordered list of zones to use to replace the current list of zones in an
    Office Zone.

    """

    _ELEMENTS = (
        E("zone_name", "zoneName", str, is_required=True),
    )

    #: str: *Required* zoneName
    zone_name = Field(type=str, required=True, mutable=False)


class ResponsePagingControl(OCIType):
    """
    Used in queries to restrict the set of result rows when making a request that can
    result in a large dataset.

    The client specifies the starting row and the number of rows requested.  The server
    only provides those rows in results, if available.
    """

    _ELEMENTS = (
        E("response_start_index", "responseStartIndex", int, is_required=True),
        E("response_page_size", "responsePageSize", int, is_required=True),
    )

    #: int: *Required* responseStartIndex
    response_start_index = Field(type=int, required=True, mutable=False)
    #: int: *Required* responsePageSize
    response_page_size = Field(type=int, required=True, mutable=False)


class ScheduleKey(OCIType):
    """
    Uniquely identifies Holiday and Time Schedules within a level(System, Service
    Provider, Group or User level).

    """

    _ELEMENTS = (
        E("schedule_name", "scheduleName", str, is_required=True),
        E("schedule_type", "scheduleType", str, is_required=True),
    )

    #: str: *Required* scheduleName
    schedule_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* scheduleType
    schedule_type = Field(type=str, required=True, mutable=False)


class SearchCriteria(OCIType):
    """
    Abstract base type for specifying search criteria.

    A search criteria is an optional element used to restrict the number of rows returned
    when requesting a potentially large set of data from the provisioning server.
    """

    _ELEMENTS = ()


class SearchCriteriaAccessDeviceEndpointPrivateIdentity(OCIType):
    """
    Criteria for searching for a private identity.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaAccessDeviceVersion(OCIType):
    """
    Criteria for searching for an Access Device Version.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaAgentThresholdProfile(OCIType):
    """
    Criteria for searching a Call Center Agent Threshold Profile.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaAlternateTrunkIdentity(OCIType):
    """
    Criteria for searching for a particular fully specified alternate trunk identity.

    In IMS mode, it only applies to the user part of alternate trunk identity.
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaAlternateTrunkIdentityDomain(OCIType):
    """
    Criteria for searching for alternate trunk identity domain part.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaAnnouncementFileName(OCIType):
    """
    Criteria for searching for an Announcement File Name.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaCallCenterName(OCIType):
    """
    Criteria for searching for a call center
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaCallCenterReportTemplateName(OCIType):
    """
    Criteria for searching for a particular call center enhanced reporting report
    template.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaCallCenterScheduledReportName(OCIType):
    """
    Criteria for searching for a call center enhanced reporting scheduled report name.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDepartmentName(OCIType):
    """
    Criteria for searching for a user's department.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDeviceMACAddress(OCIType):
    """
    Criteria for searching for device MAC address.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDeviceManagementEventAdditionalInfo(OCIType):
    """
    Criteria for searching for a particular additional info of a DeviceManagement event.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDeviceManagementEventLoginId(OCIType):
    """
    Criteria for searching for a particular login id.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDeviceName(OCIType):
    """
    Criteria for searching for device name.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDeviceNetAddress(OCIType):
    """
    Criteria for searching for device network address.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDeviceSerialNumber(OCIType):
    """
    Criteria for searching for device serial number.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDeviceType(OCIType):
    """
    Criteria for searching for device type.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDigitPattern(OCIType):
    """
    Criteria for searching for digit pattern.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDn(OCIType):
    """
    Criteria for searching for a DN.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaEmailAddress(OCIType):
    """
    Criteria for searching for a email address.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaEnterpriseCommonPhoneListName(OCIType):
    """
    Criteria for searching for a name in an enterprise common phone list.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaEnterpriseCommonPhoneListNumber(OCIType):
    """
    Criteria for searching for a phone number in an enterprise common phone list.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaEnterpriseTrunkName(OCIType):
    """
    Criteria for searching for an Enterprise Trunk name.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaExactCallCenterScheduledReportCreatedBySupervisor(OCIType):
    """
    Criteria for searching for call center scheduled report created by a supervisor or
    administrator.

    """

    _ELEMENTS = (
        E("created_by_supervisor", "createdBySupervisor", bool, is_required=True),
    )

    #: bool: *Required* createdBySupervisor
    created_by_supervisor = Field(type=bool, required=True, mutable=False)


class SearchCriteriaExactCallCenterScheduledReportGroup(OCIType):
    """
    Criteria for searching for a particular fully specified call center scheduled report's
    group.

    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactCallCenterScheduledReportServiceProvider(OCIType):
    """
    Criteria for searching for a particular call center scheduled report's service
    provider.

    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactCustomContactDirectory(OCIType):
    """
    Criteria for searching for a particular fully specified custom contact directory.

    """

    _ELEMENTS = (
        E(
            "custom_contact_directory_name", "customContactDirectoryName", str,
            is_required=True,
        ),
    )

    #: str: *Required* customContactDirectoryName
    custom_contact_directory_name = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDeviceLevel(OCIType):
    """
    Criteria for searching for a particular device level.

    """

    _ELEMENTS = (
        E("device_level", "deviceLevel", str, is_required=True),
    )

    #: str: *Required* deviceLevel
    device_level = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDeviceManagementEventAction(OCIType):
    """
    Criteria for searching for a particular fully specified DeviceManagement event action.

    """

    _ELEMENTS = (
        E("dm_event_action", "dmEventAction", str, is_required=True),
    )

    #: str: *Required* dmEventAction
    dm_event_action = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDeviceManagementEventLevel(OCIType):
    """
    Criteria for searching for a particular fully specified DeviceManagement event level.

    """

    _ELEMENTS = (
        E("dm_event_level", "dmEventLevel", str, is_required=True),
    )

    #: str: *Required* dmEventLevel
    dm_event_level = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDeviceManagementEventStatusCompleted(OCIType):
    """
    Criteria for searching for a particular fully specified Device Management completed
    event status.

    """

    _ELEMENTS = (
        E("dm_event_status_completed", "dmEventStatusCompleted", str, is_required=True),
    )

    #: str: *Required* dmEventStatusCompleted
    dm_event_status_completed = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDeviceManagementEventStatusInProgressOrPending(OCIType):
    """
    Criteria for searching for a particular fully specified Device Management event in
    progress or pending status.

    """

    _ELEMENTS = (
        E(
            "dm_event_status_in_progress_or_pending", "dmEventStatusInProgressOrPending",
            str, is_required=True,
        ),
    )

    #: str: *Required* dmEventStatusInProgressOrPending
    dm_event_status_in_progress_or_pending = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDeviceManagementEventType(OCIType):
    """
    Criteria for searching for a particular fully specified DeviceManagement event type.

    """

    _ELEMENTS = (
        E("dm_event_type", "dmEventType", str, is_required=True),
    )

    #: str: *Required* dmEventType
    dm_event_type = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDeviceServiceProvider(OCIType):
    """
    Criteria for searching for a particular fully specified service provider associated
    with a device.

    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDeviceType(OCIType):
    """
    Criteria for searching for a particular fully specified device type.

    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
    )

    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDnActivation(OCIType):
    """
    Criteria for searching for a particular Dn activation state.

    """

    _ELEMENTS = (
        E("activated", "activated", bool, is_required=True),
    )

    #: bool: *Required* activated
    activated = Field(type=bool, required=True, mutable=False)


class SearchCriteriaExactEndpointType(OCIType):
    """
    Criteria for searching for a particular endpoint type.

    """

    _ELEMENTS = (
        E("endpoint_type", "endpointType", str, is_required=True),
    )

    #: str: *Required* endpointType
    endpoint_type = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactMobileNetwork(OCIType):
    """
    Criteria for searching for a particular BroadWorks Mobility Mobile Network.

    """

    _ELEMENTS = (
        E("mobile_network_name", "mobileNetworkName", str, is_required=True),
    )

    #: str: *Required* mobileNetworkName
    mobile_network_name = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactOrganizationType(OCIType):
    """
    Criteria for searching for an organization type.

    """

    _ELEMENTS = (
        E("organization_type", "organizationType", str, is_required=True),
    )

    #: str: *Required* organizationType
    organization_type = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactPolicySelection(OCIType):
    """
    Criteria for searching for a particular Voice VPN policy selection.

    """

    _ELEMENTS = (
        E("policy_selection", "policySelection", str, is_required=True),
    )

    #: str: *Required* policySelection
    policy_selection = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactPortNumber(OCIType):
    """
    Criteria for searching for a port number.

    """

    _ELEMENTS = (
        E("port", "port", int, is_required=True),
    )

    #: int: *Required* port
    port = Field(type=int, required=True, mutable=False)


class SearchCriteriaExactServiceProvider(OCIType):
    """
    Criteria for searching for a particular fully specified service provider.

    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactServiceType(OCIType):
    """
    Criteria for searching for a particular fully specified service type.

    """

    _ELEMENTS = (
        E("service_type", "serviceType", str, is_required=True),
    )

    #: str: *Required* serviceType
    service_type = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactSignalingAddressType(OCIType):
    """
    Criteria for searching for a particular fully specified SignalingAddressType.

    """

    _ELEMENTS = (
        E("profile", "profile", str, is_required=True),
    )

    #: str: *Required* profile
    profile = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactSkillLevel(OCIType):
    """
    Criteria for searching for a skill Level.

    """

    _ELEMENTS = (
        E("skill_level", "skillLevel", int, is_required=True),
    )

    #: int: *Required* skillLevel
    skill_level = Field(type=int, required=True, mutable=False)


class SearchCriteriaExactUserGroup(OCIType):
    """
    Criteria for searching for a particular fully specified user's group.

    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactUserInTrunkGroup(OCIType):
    """
    Criteria for searching for user in/not in a trunk group.

    """

    _ELEMENTS = (
        E("user_in_trunk_group", "userInTrunkGroup", bool, is_required=True),
    )

    #: bool: *Required* userInTrunkGroup
    user_in_trunk_group = Field(type=bool, required=True, mutable=False)


class SearchCriteriaExactUserNetworkClassOfService(OCIType):
    """
    Criteria for searching for users with a specified network class of service.

    """

    _ELEMENTS = (
        E("network_class_of_service", "networkClassOfService", str, is_required=True),
    )

    #: str: *Required* networkClassOfService
    network_class_of_service = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactUserRouteListAssigned(OCIType):
    """
    Criteria for searching for users with/without Route List feature assigned.

    """

    _ELEMENTS = (
        E("route_list_assigned", "routeListAssigned", bool, is_required=True),
    )

    #: bool: *Required* routeListAssigned
    route_list_assigned = Field(type=bool, required=True, mutable=False)


class SearchCriteriaExactUserRouteListAssignment(OCIType):
    """
    Criteria for searching for users with Route List feature assignment.

    """

    _ELEMENTS = (
        E("assigned", "assigned", bool, is_required=True),
    )

    #: bool: *Required* assigned
    assigned = Field(type=bool, required=True, mutable=False)


class SearchCriteriaExactUserType(OCIType):
    """
    Criteria for searching for a particular User Type.

    """

    _ELEMENTS = (
        E("user_type", "userType", str, is_required=True),
    )

    #: str: *Required* userType
    user_type = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactVirtualOnNetCallTypeName(OCIType):
    """
    Criteria for searching for a particular fully specified Virtual On-Net Call Type Name.

    """

    _ELEMENTS = (
        E("virtual_on_net_call_type_name", "virtualOnNetCallTypeName", str, is_required=True),
    )

    #: str: *Required* virtualOnNetCallTypeName
    virtual_on_net_call_type_name = Field(type=str, required=True, mutable=False)


class SearchCriteriaExtension(OCIType):
    """
    Criteria for searching for an extension.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaGroupCommonPhoneListName(OCIType):
    """
    Criteria for searching for a name in a group common phone list.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaGroupCommonPhoneListNumber(OCIType):
    """
    Criteria for searching for a phone number in a group common phone list.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaGroupId(OCIType):
    """
    Criteria for searching for a group ID.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaGroupLocationCode(OCIType):
    """
    Criteria for searching for a group location dialing code.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaGroupName(OCIType):
    """
    Criteria for searching for a group name.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaHomeMscAddress(OCIType):
    """
    Criteria for searching for a system Home Network Msc Address.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaIMRN(OCIType):
    """
    Criteria for searching for an IMRN Number.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaImpId(OCIType):
    """
    Criteria for searching for a user's IMP Id.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaLinePortDomain(OCIType):
    """
    Criteria for searching for device line/port, or SIPURI domain part.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaLinePortUserPart(OCIType):
    """
    Criteria for searching for device line/port, or SIPURI user part.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaLoginId(OCIType):
    """
    Criteria for searching for a Login Id.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaMobilePhoneNumber(OCIType):
    """
    Criteria for searching for a user's mobile phone number.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaMobileSubscriberDirectoryNumber(OCIType):
    """
    Criteria for searching for a BroadWorks Mobility Mobile Subscriber Directory Number.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaNumberPortabilityQueryDigitPattern(OCIType):
    """
    Criteria for searching for digit pattern.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaNumberPortabilityStatus(OCIType):
    """
    Criteria for searching for number portability status.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaOutgoingDNorSIPURI(OCIType):
    """
    Criteria for searching for a phone number or SIPURI.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaPersonalAssistantExclusionNumber(OCIType):
    """
    Criteria for searching for Personal Assistant Exclusion Number.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaPersonalAssistantExclusionNumberDescription(OCIType):
    """
    Criteria for searching Personal Assistant Exclusion Number's Description.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaPhysicalLocation(OCIType):
    """
    Criteria for searching for a Physical Location.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaRegistrationURI(OCIType):
    """
    Criteria for searching for a RegistrationURI.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaRoamingMscAddress(OCIType):
    """
    Criteria for searching for a system Roaming Network Msc Address.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaRoutePointName(OCIType):
    """
    Criteria for searching for a route point
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaSIPContact(OCIType):
    """
    Criteria for searching for a SIP Contact.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaServiceCode(OCIType):
    """
    Criteria for searching for a Service Code.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaServiceCodeDescription(OCIType):
    """
    Criteria for searching for a Service Code description.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaServiceInstanceName(OCIType):
    """
    Criteria for searching for a service instance name.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaServiceProviderId(OCIType):
    """
    Criteria for searching for a service provider ID.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaServiceProviderName(OCIType):
    """
    Criteria for searching for a service provider name.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaServiceProviderNumberPortabilityQueryDigitPattern(OCIType):
    """
    Criteria for searching for digit pattern.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaSystemServiceDn(OCIType):
    """
    Criteria for searching for a system service DN.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaTrunkGroupName(OCIType):
    """
    Criteria for searching for a trunk group
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaUserFirstName(OCIType):
    """
    Criteria for searching for a user's first name.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaUserId(OCIType):
    """
    Criteria for searching for a user's userId.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaUserLastName(OCIType):
    """
    Criteria for searching for a user's last name.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaUserPersonalPhoneListName(OCIType):
    """
    Criteria for searching for a name in a user personal phone list.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaUserPersonalPhoneListNumber(OCIType):
    """
    Criteria for searching for a phone number in a user personal phone list.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaYahooId(OCIType):
    """
    Criteria for searching for a user's yahoo id.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SearchCriteriaZoneIPAddress(OCIType):
    """
    Criteria for searching for a system zone's IP Address.

    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    #: str: *Required* mode
    mode = Field(type=str, required=True, mutable=False)
    #: str: *Required* value
    value = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(type=bool, required=True, mutable=False)


class SelectiveCallRejectionCriteriaCallType(OCIType):
    """
    The call type criteria used within an add/get request.

    """

    _ELEMENTS = (
        E("from_dn_criteria_selection", "fromDnCriteriaSelection", str, is_required=True),
        E("include_anonymous_callers", "includeAnonymousCallers", bool, is_required=True),
        E("include_unavailable_callers", "includeUnavailableCallers", bool, is_required=True),
        E("phone_number", "phoneNumber", str),
    )

    #: str: *Required* fromDnCriteriaSelection
    from_dn_criteria_selection = Field(type=str, required=True, mutable=False)
    #: bool: *Required* includeAnonymousCallers
    include_anonymous_callers = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* includeUnavailableCallers
    include_unavailable_callers = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)


class SequentialRingLocation(OCIType):
    """
    Sequential Ring Location.

    Replaced By: SequentialRingLocation14sp4
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str),
        E("number_of_rings", "numberOfRings", int, is_required=True),
    )

    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: int: *Required* numberOfRings
    number_of_rings = Field(type=int, required=True, mutable=False)


class SequentialRingLocation14sp4(OCIType):
    """
    Sequential Ring Location.

    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str),
        E("number_of_rings", "numberOfRings", int, is_required=True),
        E(
            "answer_confirmation_required", "answerConfirmationRequired", bool,
            is_required=True,
        ),
    )

    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: int: *Required* numberOfRings
    number_of_rings = Field(type=int, required=True, mutable=False)
    #: bool: *Required* answerConfirmationRequired
    answer_confirmation_required = Field(type=bool, required=True, mutable=False)


class SequentialRingLocationModify(OCIType):
    """
    Sequential Ring Location.

    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str),
        E("number_of_rings", "numberOfRings", int),
        E("answer_confirmation_required", "answerConfirmationRequired", bool),
    )

    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: int: *Optional* numberOfRings
    number_of_rings = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* answerConfirmationRequired
    answer_confirmation_required = Field(type=bool, required=False, mutable=False)


class ServiceActivation(OCIType):
    """
    Service Instance active status indicator
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)


class ServiceProviderCommunicationBarringHierarchicalCallMeNowRule(OCIType):
    """
    Service Provider Communication Barring Hierarchical Call Me Now Rule
    """

    _ELEMENTS = (
        E("criteria", "criteria", str),
        E("digit_pattern_criteria", "digitPatternCriteria", str),
        E("action", "action", str, is_required=True),
        E("call_timeout_seconds", "callTimeoutSeconds", int),
        E("time_schedule", "timeSchedule", str),
        E("holiday_schedule", "holidaySchedule", str),
        E("priority", "priority", str, is_required=True),
    )

    #: str: *Optional* criteria
    criteria = Field(type=str, required=False, mutable=False)
    #: str: *Optional* digitPatternCriteria
    digit_pattern_criteria = Field(type=str, required=False, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: int: *Optional* callTimeoutSeconds
    call_timeout_seconds = Field(type=int, required=False, mutable=False)
    #: str: *Optional* timeSchedule
    time_schedule = Field(type=str, required=False, mutable=False)
    #: str: *Optional* holidaySchedule
    holiday_schedule = Field(type=str, required=False, mutable=False)
    #: str: *Required* priority
    priority = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringHierarchicalOriginatingRule(OCIType):
    """
    Service Provider Communication Barring Hierarchical Originating Rule
    """

    _ELEMENTS = (
        E("criteria", "criteria", str),
        E("digit_pattern_criteria", "digitPatternCriteria", str),
        E("action", "action", str, is_required=True),
        E("treatment_id", "treatmentId", str),
        E("transfer_number", "transferNumber", str),
        E("call_timeout_seconds", "callTimeoutSeconds", int),
        E("time_schedule", "timeSchedule", str),
        E("holiday_schedule", "holidaySchedule", str),
        E("priority", "priority", str, is_required=True),
    )

    #: str: *Optional* criteria
    criteria = Field(type=str, required=False, mutable=False)
    #: str: *Optional* digitPatternCriteria
    digit_pattern_criteria = Field(type=str, required=False, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* treatmentId
    treatment_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* transferNumber
    transfer_number = Field(type=str, required=False, mutable=False)
    #: int: *Optional* callTimeoutSeconds
    call_timeout_seconds = Field(type=int, required=False, mutable=False)
    #: str: *Optional* timeSchedule
    time_schedule = Field(type=str, required=False, mutable=False)
    #: str: *Optional* holidaySchedule
    holiday_schedule = Field(type=str, required=False, mutable=False)
    #: str: *Required* priority
    priority = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringHierarchicalRedirectingRule(OCIType):
    """
    Service Provider Communication Barring Hierarchical Redirecting Rule
    """

    _ELEMENTS = (
        E("criteria", "criteria", str),
        E("digit_pattern_criteria", "digitPatternCriteria", str),
        E("action", "action", str, is_required=True),
        E("call_timeout_seconds", "callTimeoutSeconds", int),
        E("time_schedule", "timeSchedule", str),
        E("holiday_schedule", "holidaySchedule", str),
        E("priority", "priority", str, is_required=True),
    )

    #: str: *Optional* criteria
    criteria = Field(type=str, required=False, mutable=False)
    #: str: *Optional* digitPatternCriteria
    digit_pattern_criteria = Field(type=str, required=False, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: int: *Optional* callTimeoutSeconds
    call_timeout_seconds = Field(type=int, required=False, mutable=False)
    #: str: *Optional* timeSchedule
    time_schedule = Field(type=str, required=False, mutable=False)
    #: str: *Optional* holidaySchedule
    holiday_schedule = Field(type=str, required=False, mutable=False)
    #: str: *Required* priority
    priority = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetRequest19sp1V2(OCIType):
    """
    Get an existing Communication Barring Profile.

    The response is either a ServiceProviderCommunicationBarringProfileGetResponse19sp1V2
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class ServiceScriptsFileResource(OCIType):
    """
    Service Scripts File Resource for uploading file content.

    """

    _ELEMENTS = (
        E("file_name", "fileName", str, is_required=True),
        E("script_content", "scriptContent", str, is_required=True),
    )

    #: str: *Required* fileName
    file_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* scriptContent
    script_content = Field(type=str, required=True, mutable=False)


class SimultaneousRingNumber(OCIType):
    """
    Simultaneous Ring number entry.

    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_required=True),
        E(
            "answer_confirmation_required", "answerConfirmationRequired", bool,
            is_required=True,
        ),
    )

    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)
    #: bool: *Required* answerConfirmationRequired
    answer_confirmation_required = Field(type=bool, required=True, mutable=False)


class SortByEnterpriseCommonPhoneListName(OCIType):
    """
    The sort criteria specifies the enterprise common phone list name as the column for
    the sort, whether sort is ascending or descending, and whether the sort is case
    sensitive.

    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    #: bool: *Required* isAscending
    is_ascending = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(type=bool, required=True, mutable=False)


class SortByEnterpriseCommonPhoneListNumber(OCIType):
    """
    The sort criteria specifies the enterprise common phone list number as as the column
    for the sort, whether sort is ascending or descending, and whether the sort is case
    sensitive.

    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    #: bool: *Required* isAscending
    is_ascending = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(type=bool, required=True, mutable=False)


class SortByGroupCommonPhoneListName(OCIType):
    """
    The sort criteria specifies the group common phone list name as the column for the
    sort, whether the sort is ascending or descending, and whether the sort is case
    sensitive.

    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    #: bool: *Required* isAscending
    is_ascending = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(type=bool, required=True, mutable=False)


class SortByGroupCommonPhoneListNumber(OCIType):
    """
    The sort criteria specifies the group common phone list number as the column for the
    sort, whether sort is ascending or descending, and whether the sort is case sensitive.

    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    #: bool: *Required* isAscending
    is_ascending = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(type=bool, required=True, mutable=False)


class SortByUserDepartment(OCIType):
    """
    The sort criteria specifies the user department name as the column for the sort,
    whether the sort is ascending or descending, and whether the sort is case sensitive.

    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    #: bool: *Required* isAscending
    is_ascending = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(type=bool, required=True, mutable=False)


class SortByUserFirstName(OCIType):
    """
    The sort criteria specifies the user first name as the column for the sort, whether
    the sort is ascending or descending, and whether the sort is case sensitive.

    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    #: bool: *Required* isAscending
    is_ascending = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(type=bool, required=True, mutable=False)


class SortByUserLastName(OCIType):
    """
    The sort criteria specifies the user last name as the column for the sort, whether the
    sort is ascending or descending, and whether the sort is case sensitive.

    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    #: bool: *Required* isAscending
    is_ascending = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(type=bool, required=True, mutable=False)


class SortByUserPersonalPhoneListName(OCIType):
    """
    The sort criteria specifies the user personal phone list name as the column for the
    sort, whether sort is ascending or descending, and whether the sort is case sensitive.

    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    #: bool: *Required* isAscending
    is_ascending = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(type=bool, required=True, mutable=False)


class SortByUserPersonalPhoneListNumber(OCIType):
    """
    The sort criteria specifies the user personal phone list number as the column for the
    sort, whether the sort is ascending or descending, and whether the sort is case
    sensitive.

    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    #: bool: *Required* isAscending
    is_ascending = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(type=bool, required=True, mutable=False)


class SortCriteria(OCIType):
    """
    The sort criteria specifies whether sort is ascending or descending, and whether the
    sort is case sensitive.

    Sort order defaults to ascending and case sensitive.
    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    #: bool: *Required* isAscending
    is_ascending = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(type=bool, required=True, mutable=False)


class SpeedDial100Entry(OCIType):
    """
    Modify the speed dial 100 prefix setting for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("speed_code", "speedCode", int, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
        E("description", "description", str),
    )

    #: int: *Required* speedCode
    speed_code = Field(type=int, required=True, mutable=False)
    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class SpeedDial100EntryModify(OCIType):
    """
    Modify the speed dial 100 prefix setting for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("speed_code", "speedCode", int, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("description", "description", str),
    )

    #: int: *Required* speedCode
    speed_code = Field(type=int, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class SpeedDial8Entry(OCIType):
    """
    Modify the speed dial 8 prefix setting for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("speed_code", "speedCode", int, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("description", "description", str),
    )

    #: int: *Required* speedCode
    speed_code = Field(type=int, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)


class StreetAddress(OCIType):
    """
    Street address information.

    """

    _ELEMENTS = (
        E("address_line1", "addressLine1", str),
        E("address_line2", "addressLine2", str),
        E("city", "city", str),
        E("state_or_province", "stateOrProvince", str),
        E("state_or_province_display_name", "stateOrProvinceDisplayName", str),
        E("zip_or_postal_code", "zipOrPostalCode", str),
        E("country", "country", str),
    )

    #: str: *Optional* addressLine1
    address_line1 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* addressLine2
    address_line2 = Field(type=str, required=False, mutable=False)
    #: str: *Optional* city
    city = Field(type=str, required=False, mutable=False)
    #: str: *Optional* stateOrProvince
    state_or_province = Field(type=str, required=False, mutable=False)
    #: str: *Optional* stateOrProvinceDisplayName
    state_or_province_display_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* zipOrPostalCode
    zip_or_postal_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* country
    country = Field(type=str, required=False, mutable=False)


class SystemCommunicationBarringProfileGetRequest19sp1V2(OCIType):
    """
    Get an existing Communication Barring Profile.

    The response is either a SystemCommunicationBarringProfileGetResponse19sp1V2 or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class SystemSIPDeviceTypeGetRequest18sp1V2(OCIType):
    """
    Request to get a sip device type.

    See Also: ``SystemDeviceTypeGetRequest()``

    The response is either ``SystemSIPDeviceTypeGetResponse19()`` or ``ErrorResponse()``.
    Replaced by: ``SystemSIPDeviceTypeGetRequest19()``.
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
    )

    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)


class TimeInterval(OCIType):
    """
    Time Interval.

    """

    _ELEMENTS = (
        E("start_day_of_week", "startDayOfWeek", str, is_required=True),
        E("start_hour", "startHour", int, is_required=True),
        E("start_minute", "startMinute", int, is_required=True),
        E("end_day_of_week", "endDayOfWeek", str, is_required=True),
        E("end_hour", "endHour", int, is_required=True),
        E("end_minute", "endMinute", int, is_required=True),
    )

    #: str: *Required* startDayOfWeek
    start_day_of_week = Field(type=str, required=True, mutable=False)
    #: int: *Required* startHour
    start_hour = Field(type=int, required=True, mutable=False)
    #: int: *Required* startMinute
    start_minute = Field(type=int, required=True, mutable=False)
    #: str: *Required* endDayOfWeek
    end_day_of_week = Field(type=str, required=True, mutable=False)
    #: int: *Required* endHour
    end_hour = Field(type=int, required=True, mutable=False)
    #: int: *Required* endMinute
    end_minute = Field(type=int, required=True, mutable=False)


class TimeSchedule(OCIType):
    """
    The from dn criteria.

    """

    _ELEMENTS = (
        E("type", "type", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* type
    type = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class TrunkGroupDeviceEndpointAdd(OCIType):
    """
    Trunk group device endpoint used in the context of modify.

    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)


class TrunkGroupDeviceEndpointModify(OCIType):
    """
    Trunk group device endpoint used in the context of modify.

    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)


class TrunkGroupDeviceEndpointRead(OCIType):
    """
    Trunk group device endpoint.

    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
    )

    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useDomain
    use_domain = Field(type=bool, required=True, mutable=False)


class TrunkGroupDeviceEndpointRead14sp4(OCIType):
    """
    Trunk group device endpoint.

    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
        E("is_pilot_user", "isPilotUser", bool, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useDomain
    use_domain = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isPilotUser
    is_pilot_user = Field(type=bool, required=True, mutable=False)


class TrunkGroupDeviceMultipleContactEndpointAdd(OCIType):
    """
    Trunk group device endpoint used in the context of modify that can have multiple
    contacts.

    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)


class TrunkGroupDeviceMultipleContactEndpointRead(OCIType):
    """
    Trunk group device endpoint that can have multiple contacts.

    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
        E("is_pilot_user", "isPilotUser", bool, is_required=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useDomain
    use_domain = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isPilotUser
    is_pilot_user = Field(type=bool, required=True, mutable=False)


class TrunkGroupKey(OCIType):
    """
    Uniquely identifies a Trunk Group system-wide.

    The trunkGroupName is unique within a group, but not unique system-wide.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)


class UnboundedNonNegativeInt(OCIType):
    """
    Unbounded Quantity.

    Can either be unlimited or a non-negative int quantity.
    """

    _ELEMENTS = (
        E("unlimited", "unlimited", bool),
        E("quantity", "quantity", int),
    )

    #: bool: *Optional* unlimited
    unlimited = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* quantity
    quantity = Field(type=int, required=False, mutable=False)


class UnboundedPositiveInt(OCIType):
    """
    Unbounded Quantity.

    Can either be unlimited or a positive int quantity.
    """

    _ELEMENTS = (
        E("unlimited", "unlimited", bool),
        E("quantity", "quantity", int),
    )

    #: bool: *Optional* unlimited
    unlimited = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* quantity
    quantity = Field(type=int, required=False, mutable=False)


class UserDisplayNames(OCIType):
    """
    The parts of a user's display name that a client can display in whatever way is
    appropriate for the client application.

    """

    _ELEMENTS = (
        E("last_name", "lastName", str, is_required=True),
        E("first_name", "firstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
    )

    #: str: *Required* lastName
    last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* firstName
    first_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(type=str, required=False, mutable=False)


class UserEndpointKey(OCIType):
    """
    Key to uniquely identify a user endpoint.

    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)


class UserEnhancedCallLogsGetListResponse17sp4V2(OCIType):
    """
    Response to UserEnhancedCallLogsGetListRequest17sp4V2.

    Total numbers of rows is: - the total number of retrievable logs of the call log type
    that was specified in the UserEnhancedCallLogsGetListRequest17sp4V2, if a call log
    type was specified in the request.  - the total number of retrievable logs, if no call
    log type was specified in the request.  A list of MixedCallLogsEntry will be returned
    if the call logs are stored on CDS A list of ExtendedMixedCallLogsEntry17sp4 will be
    returned if the call logs are stored on DBS The logs are sorted by date/time of the
    call.
    """

    _ELEMENTS = (
        E("total_number_of_rows", "totalNumberOfRows", int, is_required=True),
        E("legacy_entry", "legacyEntry", str, is_complex=True),  # unknown
        E("extended_entry", "extendedEntry", str, is_complex=True),  # unknown
    )

    #: int: *Required* totalNumberOfRows
    total_number_of_rows = Field(type=int, required=True, mutable=False)
    #: str: *Optional* legacyEntry
    legacy_entry = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extendedEntry
    extended_entry = Field(type=str, required=False, mutable=False)


class UserFeatureAccessCodeModifyEntry(OCIType):
    """
    Feature Access Code Entry to be used in all user modify command.

    """

    _ELEMENTS = (
        E("feature_access_code_name", "featureAccessCodeName", str, is_required=True),
        E("enable_fac", "enableFAC", bool),
    )

    #: str: *Required* featureAccessCodeName
    feature_access_code_name = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* enableFAC
    enable_fac = Field(type=bool, required=False, mutable=False)


class UserPreferredCarrierName(OCIType):
    """
    User can either use it's group's preferred carrier or use it's own.

    The user carrier name is exposed if it was previously configured.
    """

    _ELEMENTS = (
        E("use_group_preferred_carrier", "useGroupPreferredCarrier", bool, is_required=True),
        E("carrier", "carrier", str),
    )

    #: bool: *Required* useGroupPreferredCarrier
    use_group_preferred_carrier = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* carrier
    carrier = Field(type=str, required=False, mutable=False)


class UserPreferredCarrierNameModify(OCIType):
    """
    User can either use it's group's preferred carrier or use it's own.

    You can use the group's preferred carrier without clearing the user carrier name -- in
    this case, the user carrier name is retained.
    """

    _ELEMENTS = (
        E("use_group_preferred_carrier", "useGroupPreferredCarrier", bool, is_required=True),
        E("carrier", "carrier", str),
    )

    #: bool: *Required* useGroupPreferredCarrier
    use_group_preferred_carrier = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* carrier
    carrier = Field(type=str, required=False, mutable=False)


class UserTwoStageDialingGetRequest13Mp20(OCIType):
    """
    Request the user level data associated with Two Stage Dialing.

    The response is either a UserTwoStageDialingGetResponse13Mp20 or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)


class UserTwoStageDialingGetResponse13Mp20(OCIType):
    """
    Response to UserTwoStageDialingGetRequest13Mp20.

    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E(
            "allow_activation_with_user_addresses", "allowActivationWithUserAddresses",
            bool, is_required=True,
        ),
    )

    #: bool: *Required* isActive
    is_active = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowActivationWithUserAddresses
    allow_activation_with_user_addresses = Field(type=bool, required=True, mutable=False)


class VerifyTranslationAndRoutingOrigination(OCIType):
    """
    Verification Translation and Routing origination value.

    """

    _ELEMENTS = (
        E("line_port", "linePort", str),
        E("phone", "phone", str),
        E("user_id", "userId", str),
        E("url", "url", str),
    )

    #: str: *Optional* linePort
    line_port = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phone
    phone = Field(type=str, required=False, mutable=False)
    #: str: *Optional* userId
    user_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* url
    url = Field(type=str, required=False, mutable=False)


class VirtualOnNetUser(OCIType):
    """
    Virtual On-Net User.

    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_required=True),
        E("extension", "extension", str, is_required=True),
        E("first_name", "firstName", str, is_required=True),
        E("last_name", "lastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("virtual_on_net_call_type_name", "virtualOnNetCallTypeName", str, is_required=True),
    )

    #: str: *Required* phoneNumber
    phone_number = Field(type=str, required=True, mutable=False)
    #: str: *Required* extension
    extension = Field(type=str, required=True, mutable=False)
    #: str: *Required* firstName
    first_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* lastName
    last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* virtualOnNetCallTypeName
    virtual_on_net_call_type_name = Field(type=str, required=True, mutable=False)


class VoiceMessagingAlternateNoAnswerGreetingRead(OCIType):
    """
    The configuration of a alternate no answer greeting.

    It is used when geting a user's voice messaging greeting.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("audio_file", "audioFile", str),
        E("video_file", "videoFile", str),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFile
    audio_file = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFile
    video_file = Field(type=str, required=False, mutable=False)


class VoiceMessagingAlternateNoAnswerGreetingRead16(OCIType):
    """
    The configuration of a alternate no answer greeting.

    It is used when geting a user's voice messaging greeting.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("audio_file", "audioFile", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_file", "videoFile", str),
        E("video_media_type", "videoMediaType", str),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFile
    audio_file = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMediaType
    audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFile
    video_file = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMediaType
    video_media_type = Field(type=str, required=False, mutable=False)


class AccessDeviceEndpointAdd(OCIType):
    """
    Access device end point used in the context of add.

    Port numbers are only used by devices with static line ordering.
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("port_number", "portNumber", int),
    )

    #: AccessDevice: *Required* accessDevice
    access_device = Field(type=AccessDevice, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)
    #: int: *Optional* portNumber
    port_number = Field(type=int, required=False, mutable=False)


class AccessDeviceEndpointKey(OCIType):
    """
    Access device end point in the context of a modify or delete command.

    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
    )

    #: AccessDevice: *Required* accessDevice
    access_device = Field(type=AccessDevice, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)


class AccessDeviceEndpointModify(OCIType):
    """
    Access device end point used in the context of modify.

    Port numbers are only used by devices with static line ordering.
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("port_number", "portNumber", int),
    )

    #: AccessDevice: *Required* accessDevice
    access_device = Field(type=AccessDevice, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)
    #: int: *Optional* portNumber
    port_number = Field(type=int, required=False, mutable=False)


class AccessDeviceEndpointRead14(OCIType):
    """
    Access device end point.

    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
    )

    #: AccessDevice: *Required* accessDevice
    access_device = Field(type=AccessDevice, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useDomain
    use_domain = Field(type=bool, required=True, mutable=False)


class AccessDeviceEndpointWithPortNumberRead(OCIType):
    """
    Access device end point.

    Port numbers are only used by devices with static line ordering.
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
        E("port_number", "portNumber", int),
    )

    #: AccessDevice: *Required* accessDevice
    access_device = Field(type=AccessDevice, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useDomain
    use_domain = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* portNumber
    port_number = Field(type=int, required=False, mutable=False)


class AccessDeviceMultipleContactEndpointAdd(OCIType):
    """
    Access device end point used in the context of add that can have more than one contact
    defined.

    Only Static Registration capabable devices may have more than one contact defined.
    Port numbers are only used by devices with static line ordering.
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("port_number", "portNumber", int),
    )

    #: AccessDevice: *Required* accessDevice
    access_device = Field(type=AccessDevice, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)
    #: int: *Optional* portNumber
    port_number = Field(type=int, required=False, mutable=False)


class AccessDeviceMultipleContactEndpointModify(OCIType):
    """
    Access device end point used in the context of modify that can have more than one
    contact defined.

    Only Static Registration capabable devices may have more than one contact defined.
    Port numbers are only used by devices with static line ordering.
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True),
        E("line_port", "linePort", str),
        E("contact_list", "contactList", ReplacementContactList, is_complex=True),
        E("port_number", "portNumber", int),
    )

    #: AccessDevice: *Optional* accessDevice
    access_device = Field(type=AccessDevice, required=False, mutable=False)
    #: str: *Optional* linePort
    line_port = Field(type=str, required=False, mutable=False)
    #: ReplacementContactList: *Optional* contactList
    contact_list = Field(type=ReplacementContactList, required=False, mutable=False)
    #: int: *Optional* portNumber
    port_number = Field(type=int, required=False, mutable=False)


class AccessDeviceMultipleContactEndpointRead(OCIType):
    """
    Access device end point that can have multiple contacts.

    Replaced by AccessDeviceMultipleContactEndpointRead19.
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
    )

    #: AccessDevice: *Required* accessDevice
    access_device = Field(type=AccessDevice, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useDomain
    use_domain = Field(type=bool, required=True, mutable=False)


class AccessDeviceMultipleContactEndpointRead19(OCIType):
    """
    Access device end point that can have multiple contacts.

    Port numbers are only used by devices with static line ordering.  Replaced by
    AccessDeviceMultipleContactEndpointRead20.
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
        E("port_number", "portNumber", int),
    )

    #: AccessDevice: *Required* accessDevice
    access_device = Field(type=AccessDevice, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useDomain
    use_domain = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* portNumber
    port_number = Field(type=int, required=False, mutable=False)


class AccessDeviceMultipleContactEndpointRead20(OCIType):
    """
    Access device end point that can have multiple contacts.

    Port numbers are only used by devices with static line ordering.
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
        E("port_number", "portNumber", int),
        E(
            "support_visual_device_management", "supportVisualDeviceManagement", bool,
            is_required=True,
        ),
    )

    #: AccessDevice: *Required* accessDevice
    access_device = Field(type=AccessDevice, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useDomain
    use_domain = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* portNumber
    port_number = Field(type=int, required=False, mutable=False)
    #: bool: *Required* supportVisualDeviceManagement
    support_visual_device_management = Field(type=bool, required=True, mutable=False)


class AccessDeviceMultipleIdentityAndContactEndpointRead(OCIType):
    """
    Access device end point that can have multiple contacts.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Port numbers are only used by devices with static line ordering.  The
    following elements are only used in HSS data mode and not returned in AS data mode:
    privateIdentity The following elements are only used in AS data mode and a value false
    is returned in the HSS mode: supportVisualDeviceManagement
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("private_identity", "privateIdentity", str),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
        E("port_number", "portNumber", int),
        E(
            "support_visual_device_management", "supportVisualDeviceManagement", bool,
            is_required=True,
        ),
    )

    #: AccessDevice: *Required* accessDevice
    access_device = Field(type=AccessDevice, required=True, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* privateIdentity
    private_identity = Field(type=str, required=False, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useDomain
    use_domain = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* portNumber
    port_number = Field(type=int, required=False, mutable=False)
    #: bool: *Required* supportVisualDeviceManagement
    support_visual_device_management = Field(type=bool, required=True, mutable=False)


class AutoAttendantKeyConfigurationEntry(OCIType):
    """
    The configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: audioFile videoFile
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("action", "action", str, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("audio_file", "audioFile", LabeledMediaFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledMediaFileResource, is_complex=True),
    )

    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: LabeledMediaFileResource: *Optional* audioFile
    audio_file = Field(type=LabeledMediaFileResource, required=False, mutable=False)
    #: LabeledMediaFileResource: *Optional* videoFile
    video_file = Field(type=LabeledMediaFileResource, required=False, mutable=False)


class AutoAttendantKeyConfigurationEntry19(OCIType):
    """
    The configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: audioFile videoFile
    submenuId The following data elements are only valid for Standard Auto Attendants:
    submenuId
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("action", "action", str, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("audio_file", "audioFile", LabeledMediaFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledMediaFileResource, is_complex=True),
        E("submenu_id", "submenuId", str),
    )

    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: LabeledMediaFileResource: *Optional* audioFile
    audio_file = Field(type=LabeledMediaFileResource, required=False, mutable=False)
    #: LabeledMediaFileResource: *Optional* videoFile
    video_file = Field(type=LabeledMediaFileResource, required=False, mutable=False)
    #: str: *Optional* submenuId
    submenu_id = Field(type=str, required=False, mutable=False)


class AutoAttendantKeyConfigurationEntry20(OCIType):
    """
    The configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: audioFile videoFile
    submenuId The following data elements are only valid for Standard Auto Attendants:
    submenuId
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("action", "action", str, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("audio_file", "audioFile", AnnouncementFileLevelKey, is_complex=True),
        E("video_file", "videoFile", AnnouncementFileLevelKey, is_complex=True),
        E("submenu_id", "submenuId", str),
    )

    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* audioFile
    audio_file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* videoFile
    video_file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: str: *Optional* submenuId
    submenu_id = Field(type=str, required=False, mutable=False)


class AutoAttendantKeyConfigurationModifyEntry(OCIType):
    """
    The modify configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: audioFile videoFile
    submenuId The following data elements are only valid for Standard Auto Attendants:
    submenuId
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("action", "action", str, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("audio_file", "audioFile", LabeledMediaFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledMediaFileResource, is_complex=True),
        E("submenu_id", "submenuId", str),
    )

    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: LabeledMediaFileResource: *Optional* audioFile
    audio_file = Field(type=LabeledMediaFileResource, required=False, mutable=False)
    #: LabeledMediaFileResource: *Optional* videoFile
    video_file = Field(type=LabeledMediaFileResource, required=False, mutable=False)
    #: str: *Optional* submenuId
    submenu_id = Field(type=str, required=False, mutable=False)


class AutoAttendantKeyConfigurationModifyEntry20(OCIType):
    """
    The modify configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: audioFile videoFile
    submenuId The following data elements are only valid for Standard Auto Attendants:
    submenuId
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("action", "action", str, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("audio_file", "audioFile", AnnouncementFileLevelKey, is_complex=True),
        E("video_file", "videoFile", AnnouncementFileLevelKey, is_complex=True),
        E("submenu_id", "submenuId", str),
    )

    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* audioFile
    audio_file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* videoFile
    video_file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: str: *Optional* submenuId
    submenu_id = Field(type=str, required=False, mutable=False)


class AutoAttendantKeyConfigurationReadEntry20(OCIType):
    """
    The read configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: submenuId The following
    data elements are only valid for Standard Auto Attendants: submenuId
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("action", "action", str, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("audio_file", "audioFile", AnnouncementFileLevelKey, is_complex=True),
        E("video_file", "videoFile", AnnouncementFileLevelKey, is_complex=True),
        E("submenu_id", "submenuId", str),
    )

    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Required* action
    action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* audioFile
    audio_file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* videoFile
    video_file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: str: *Optional* submenuId
    submenu_id = Field(type=str, required=False, mutable=False)


class AutoAttendantKeyReadConfiguration(OCIType):
    """
    The read configuration of a key for Auto Attendant.

    """

    _ELEMENTS = (
        E("key", "key", str, is_required=True),
        E(
            "entry", "entry", AutoAttendantKeyConfigurationReadEntry, is_complex=True,
            is_required=True,
        ),
    )

    #: str: *Required* key
    key = Field(type=str, required=True, mutable=False)
    #: AutoAttendantKeyConfigurationReadEntry: *Required* entry
    entry = Field(type=AutoAttendantKeyConfigurationReadEntry, required=True, mutable=False)


class AutoAttendantKeyReadConfiguration19(OCIType):
    """
    The read configuration of a key for Auto Attendant.

    """

    _ELEMENTS = (
        E("key", "key", str, is_required=True),
        E(
            "entry", "entry", AutoAttendantKeyConfigurationReadEntry19, is_complex=True,
            is_required=True,
        ),
    )

    #: str: *Required* key
    key = Field(type=str, required=True, mutable=False)
    #: AutoAttendantKeyConfigurationReadEntry19: *Required* entry
    entry = Field(type=AutoAttendantKeyConfigurationReadEntry19, required=True, mutable=False)


class CPEDeviceOptionsRead(OCIType):
    """
    CPE device's options.

    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool, is_required=True),
        E("reset_event", "resetEvent", str),
        E("config_type", "configType", str, is_required=True),
        E("system_file_name", "systemFileName", str),
        E("device_file_format", "deviceFileFormat", str),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptionsRead, is_complex=True,
        ),
    )

    #: bool: *Required* enableMonitoring
    enable_monitoring = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* resetEvent
    reset_event = Field(type=str, required=False, mutable=False)
    #: str: *Required* configType
    config_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* systemFileName
    system_file_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* deviceFileFormat
    device_file_format = Field(type=str, required=False, mutable=False)
    #: DeviceManagementDeviceTypeOptionsRead: *Optional* deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeOptionsRead, required=False, mutable=False,
    )


class CPEDeviceOptionsRead16(OCIType):
    """
    CPE device's options.

    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool, is_required=True),
        E("reset_event", "resetEvent", str),
        E("config_type", "configType", str, is_required=True),
        E("system_file_name", "systemFileName", str),
        E("device_file_format", "deviceFileFormat", str),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptionsRead16, is_complex=True,
        ),
    )

    #: bool: *Required* enableMonitoring
    enable_monitoring = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* resetEvent
    reset_event = Field(type=str, required=False, mutable=False)
    #: str: *Required* configType
    config_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* systemFileName
    system_file_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* deviceFileFormat
    device_file_format = Field(type=str, required=False, mutable=False)
    #: DeviceManagementDeviceTypeOptionsRead16: *Optional*
    #: deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeOptionsRead16, required=False, mutable=False,
    )


class CPEDeviceOptionsRead16sp1(OCIType):
    """
    CPE device's options.

    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool, is_required=True),
        E("config_type", "configType", str),
        E("system_file_name", "systemFileName", str),
        E("device_file_format", "deviceFileFormat", str),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptionsRead16, is_complex=True,
        ),
    )

    #: bool: *Required* enableMonitoring
    enable_monitoring = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* configType
    config_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* systemFileName
    system_file_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* deviceFileFormat
    device_file_format = Field(type=str, required=False, mutable=False)
    #: DeviceManagementDeviceTypeOptionsRead16: *Optional*
    #: deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeOptionsRead16, required=False, mutable=False,
    )


class CallCenterAgentStatistics13mp8(OCIType):
    """
    Contains Call Center statistics for a specified agent.

    """

    _ELEMENTS = (
        E("agent_user_id", "agentUserId", str, is_required=True),
        E(
            "agent_display_names", "agentDisplayNames", UserDisplayNames, is_complex=True,
            is_required=True,
        ),
        E("available", "available", bool, is_required=True),
        E(
            "statistics_yesterday", "statisticsYesterday",
            CallCenterAgentDailyStatistics13mp8, is_complex=True, is_required=True,
        ),
        E(
            "statistics_today", "statisticsToday", CallCenterAgentDailyStatistics13mp8,
            is_complex=True, is_required=True,
        ),
    )

    #: str: *Required* agentUserId
    agent_user_id = Field(type=str, required=True, mutable=False)
    #: UserDisplayNames: *Required* agentDisplayNames
    agent_display_names = Field(type=UserDisplayNames, required=True, mutable=False)
    #: bool: *Required* available
    available = Field(type=bool, required=True, mutable=False)
    #: CallCenterAgentDailyStatistics13mp8: *Required* statisticsYesterday
    statistics_yesterday = Field(
        type=CallCenterAgentDailyStatistics13mp8, required=True, mutable=False,
    )
    #: CallCenterAgentDailyStatistics13mp8: *Required* statisticsToday
    statistics_today = Field(
        type=CallCenterAgentDailyStatistics13mp8, required=True, mutable=False,
    )


class CallCenterAgentStatistics14sp9(OCIType):
    """
    Contains Call Center statistics for a specified agent.

    """

    _ELEMENTS = (
        E("agent_user_id", "agentUserId", str, is_required=True),
        E(
            "agent_display_names", "agentDisplayNames", UserDisplayNames, is_complex=True,
            is_required=True,
        ),
        E("available", "available", bool, is_required=True),
        E("statistics", "statistics", AgentStatistics, is_complex=True, is_required=True),
    )

    #: str: *Required* agentUserId
    agent_user_id = Field(type=str, required=True, mutable=False)
    #: UserDisplayNames: *Required* agentDisplayNames
    agent_display_names = Field(type=UserDisplayNames, required=True, mutable=False)
    #: bool: *Required* available
    available = Field(type=bool, required=True, mutable=False)
    #: AgentStatistics: *Required* statistics
    statistics = Field(type=AgentStatistics, required=True, mutable=False)


class CallCenterAnnouncementFileListModify(OCIType):
    """
    Contains a list of audio or video files to modify.

    """

    _ELEMENTS = (
        E("file1", "file1", LabeledMediaFileResource, is_complex=True),
        E("file2", "file2", LabeledMediaFileResource, is_complex=True),
        E("file3", "file3", LabeledMediaFileResource, is_complex=True),
        E("file4", "file4", LabeledMediaFileResource, is_complex=True),
    )

    #: LabeledMediaFileResource: *Optional* file1
    file1 = Field(type=LabeledMediaFileResource, required=False, mutable=False)
    #: LabeledMediaFileResource: *Optional* file2
    file2 = Field(type=LabeledMediaFileResource, required=False, mutable=False)
    #: LabeledMediaFileResource: *Optional* file3
    file3 = Field(type=LabeledMediaFileResource, required=False, mutable=False)
    #: LabeledMediaFileResource: *Optional* file4
    file4 = Field(type=LabeledMediaFileResource, required=False, mutable=False)


class CallCenterAnnouncementFileListModify20(OCIType):
    """
    Contains a list of announcement repository files
    """

    _ELEMENTS = (
        E("file1", "file1", AnnouncementFileLevelKey, is_complex=True),
        E("file2", "file2", AnnouncementFileLevelKey, is_complex=True),
        E("file3", "file3", AnnouncementFileLevelKey, is_complex=True),
        E("file4", "file4", AnnouncementFileLevelKey, is_complex=True),
    )

    #: AnnouncementFileLevelKey: *Optional* file1
    file1 = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* file2
    file2 = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* file3
    file3 = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* file4
    file4 = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)


class CallCenterAnnouncementFileListRead20(OCIType):
    """
    Contains a list of announcement repository files
    """

    _ELEMENTS = (
        E("file1", "file1", AnnouncementFileLevelKey, is_complex=True),
        E("file2", "file2", AnnouncementFileLevelKey, is_complex=True),
        E("file3", "file3", AnnouncementFileLevelKey, is_complex=True),
        E("file4", "file4", AnnouncementFileLevelKey, is_complex=True),
    )

    #: AnnouncementFileLevelKey: *Optional* file1
    file1 = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* file2
    file2 = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* file3
    file3 = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* file4
    file4 = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)


class CallCenterReplacementSkilledAgents(OCIType):
    """
    A list of agents grouped by skill levels.

    """

    _ELEMENTS = (
        E("skill_level", "skillLevel", int, is_required=True),
        E("agents", "agents", ReplacementUserIdList, is_complex=True, is_required=True),
    )

    #: int: *Required* skillLevel
    skill_level = Field(type=int, required=True, mutable=False)
    #: ReplacementUserIdList: *Required* agents
    agents = Field(type=ReplacementUserIdList, required=True, mutable=False)


class CallCenterReportIntervalDates(OCIType):
    """
    The call center enhanced reporting report interval, using dates.

    """

    _ELEMENTS = (
        E("start_date", "startDate", str, is_required=True),
        E("start_time", "startTime", HourMinute, is_complex=True, is_required=True),
        E("end_date", "endDate", str, is_required=True),
        E("end_time", "endTime", HourMinute, is_complex=True, is_required=True),
    )

    #: str: *Required* startDate
    start_date = Field(type=str, required=True, mutable=False)
    #: HourMinute: *Required* startTime
    start_time = Field(type=HourMinute, required=True, mutable=False)
    #: str: *Required* endDate
    end_date = Field(type=str, required=True, mutable=False)
    #: HourMinute: *Required* endTime
    end_time = Field(type=HourMinute, required=True, mutable=False)


class CallCenterReportScheduleRecurrence(OCIType):
    """
    A recurring schedule for call center enhanced reporting scheduled report.

    """

    _ELEMENTS = (
        E("time_zone", "timeZone", str, is_required=True),
        E("start_date", "startDate", str, is_required=True),
        E("schedule_time", "scheduleTime", HourMinute, is_complex=True, is_required=True),
        E("recurrence", "recurrence", Recurrence, is_complex=True, is_required=True),
    )

    #: str: *Required* timeZone
    time_zone = Field(type=str, required=True, mutable=False)
    #: str: *Required* startDate
    start_date = Field(type=str, required=True, mutable=False)
    #: HourMinute: *Required* scheduleTime
    schedule_time = Field(type=HourMinute, required=True, mutable=False)
    #: Recurrence: *Required* recurrence
    recurrence = Field(type=Recurrence, required=True, mutable=False)


class CallCenterReportScheduleTime(OCIType):
    """
    A scheduled time for call center enhanced reporting scheduled report.

    """

    _ELEMENTS = (
        E("time_zone", "timeZone", str, is_required=True),
        E("schedule_date", "scheduleDate", str, is_required=True),
        E("schedule_time", "scheduleTime", HourMinute, is_complex=True, is_required=True),
    )

    #: str: *Required* timeZone
    time_zone = Field(type=str, required=True, mutable=False)
    #: str: *Required* scheduleDate
    schedule_date = Field(type=str, required=True, mutable=False)
    #: HourMinute: *Required* scheduleTime
    schedule_time = Field(type=HourMinute, required=True, mutable=False)


class CallMeNowToDnCriteriaModify(OCIType):
    """
    The To dn criteria used on the call me now external number to be modified.

    """

    _ELEMENTS = (
        E("to_dn_criteria_selection", "toDnCriteriaSelection", str),
        E("phone_number_list", "phoneNumberList", CriteriaReplacementDNList, is_complex=True),
    )

    #: str: *Optional* toDnCriteriaSelection
    to_dn_criteria_selection = Field(type=str, required=False, mutable=False)
    #: CriteriaReplacementDNList: *Optional* phoneNumberList
    phone_number_list = Field(type=CriteriaReplacementDNList, required=False, mutable=False)


class CommPilotExpressAvailableInOffice(OCIType):
    """
    CommPilot Express Available In Office Settings.

    """

    _ELEMENTS = (
        E("additional_phone_number_to_ring", "additionalPhoneNumberToRing", str),
        E(
            "busy_setting", "busySetting", CommPilotExpressRedirection, is_complex=True,
            is_required=True,
        ),
        E(
            "no_answer_setting", "noAnswerSetting", CommPilotExpressRedirection,
            is_complex=True, is_required=True,
        ),
    )

    #: str: *Optional* additionalPhoneNumberToRing
    additional_phone_number_to_ring = Field(type=str, required=False, mutable=False)
    #: CommPilotExpressRedirection: *Required* busySetting
    busy_setting = Field(type=CommPilotExpressRedirection, required=True, mutable=False)
    #: CommPilotExpressRedirection: *Required* noAnswerSetting
    no_answer_setting = Field(type=CommPilotExpressRedirection, required=True, mutable=False)


class CommPilotExpressAvailableInOfficeModify(OCIType):
    """
    CommPilot Express Available In Office Settings.

    """

    _ELEMENTS = (
        E("additional_phone_number_to_ring", "additionalPhoneNumberToRing", str),
        E("busy_setting", "busySetting", CommPilotExpressRedirectionModify, is_complex=True),
        E(
            "no_answer_setting", "noAnswerSetting", CommPilotExpressRedirectionModify,
            is_complex=True,
        ),
    )

    #: str: *Optional* additionalPhoneNumberToRing
    additional_phone_number_to_ring = Field(type=str, required=False, mutable=False)
    #: CommPilotExpressRedirectionModify: *Optional* busySetting
    busy_setting = Field(
        type=CommPilotExpressRedirectionModify, required=False, mutable=False,
    )
    #: CommPilotExpressRedirectionModify: *Optional* noAnswerSetting
    no_answer_setting = Field(
        type=CommPilotExpressRedirectionModify, required=False, mutable=False,
    )


class CommPilotExpressAvailableOutOfOffice(OCIType):
    """
    CommPilot Express Available Out Of Office Configuration used in the context of a get.

    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls", CommPilotExpressRedirection,
            is_complex=True, is_required=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify", CommPilotExpressEmailNotify,
            is_complex=True, is_required=True,
        ),
    )

    #: CommPilotExpressRedirection: *Required* incomingCalls
    incoming_calls = Field(type=CommPilotExpressRedirection, required=True, mutable=False)
    #: CommPilotExpressEmailNotify: *Required* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressEmailNotify, required=True, mutable=False,
    )


class CommPilotExpressAvailableOutOfOfficeModify(OCIType):
    """
    CommPilot Express Available Out Of Office Configuration used in the context of a
    modify.

    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls", CommPilotExpressRedirectionModify,
            is_complex=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify",
            CommPilotExpressEmailNotifyModify, is_complex=True,
        ),
    )

    #: CommPilotExpressRedirectionModify: *Optional* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressRedirectionModify, required=False, mutable=False,
    )
    #: CommPilotExpressEmailNotifyModify: *Optional* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressEmailNotifyModify, required=False, mutable=False,
    )


class CommPilotExpressBusy(OCIType):
    """
    CommPilot Express Available In Office Configuration used in the context of a get.

    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls", CommPilotExpressRedirectionWithException,
            is_complex=True, is_required=True,
        ),
        E(
            "voice_mail_notify", "voiceMailNotify", CommPilotExpressEmailNotify,
            is_complex=True, is_required=True,
        ),
    )

    #: CommPilotExpressRedirectionWithException: *Required* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressRedirectionWithException, required=True, mutable=False,
    )
    #: CommPilotExpressEmailNotify: *Required* voiceMailNotify
    voice_mail_notify = Field(type=CommPilotExpressEmailNotify, required=True, mutable=False)


class CommPilotExpressBusyModify(OCIType):
    """
    CommPilot Express Available In Office Configuration used in the context of a modify.

    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls",
            CommPilotExpressRedirectionWithExceptionModify, is_complex=True,
        ),
        E(
            "voice_mail_notify", "voiceMailNotify", CommPilotExpressEmailNotifyModify,
            is_complex=True,
        ),
    )

    #: CommPilotExpressRedirectionWithExceptionModify: *Optional* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressRedirectionWithExceptionModify, required=False, mutable=False,
    )
    #: CommPilotExpressEmailNotifyModify: *Optional* voiceMailNotify
    voice_mail_notify = Field(
        type=CommPilotExpressEmailNotifyModify, required=False, mutable=False,
    )


class CommPilotExpressSRBusy(OCIType):
    """
    CommPilot Express SR Available In Office Configuration used in the context of a get.

    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls", CommPilotExpressSRRedirectionWithException,
            is_complex=True, is_required=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify", CommPilotExpressSREmailNotify,
            is_complex=True, is_required=True,
        ),
    )

    #: CommPilotExpressSRRedirectionWithException: *Required* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressSRRedirectionWithException, required=True, mutable=False,
    )
    #: CommPilotExpressSREmailNotify: *Required* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressSREmailNotify, required=True, mutable=False,
    )


class CommPilotExpressSRBusyModify(OCIType):
    """
    CommPilot Express SR Available In Office Configuration used in the context of a
    modify.

    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls",
            CommPilotExpressSRRedirectionWithExceptionModify, is_complex=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify",
            CommPilotExpressSREmailNotifyModify, is_complex=True,
        ),
    )

    #: CommPilotExpressSRRedirectionWithExceptionModify: *Optional* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressSRRedirectionWithExceptionModify, required=False,
        mutable=False,
    )
    #: CommPilotExpressSREmailNotifyModify: *Optional* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressSREmailNotifyModify, required=False, mutable=False,
    )


class CommPilotExpressSRRedirectionWithRingList(OCIType):
    """
    CommPilot Express SR Forward Numbers with number of times to ring.

    """

    _ELEMENTS = (
        E(
            "number_entry", "numberEntry", CommPilotExpressSRRedirectionWithRing,
            is_complex=True,
        ),
    )

    #: CommPilotExpressSRRedirectionWithRing: *Optional* numberEntry
    number_entry = Field(
        type=CommPilotExpressSRRedirectionWithRing, required=False, mutable=False,
    )


class CommPilotExpressSRUnavailable(OCIType):
    """
    CommPilot Express SR Unavailable Configuration used in the context of a get.

    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls", CommPilotExpressSRRedirectionWithException,
            is_complex=True, is_required=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify", CommPilotExpressSREmailNotify,
            is_complex=True, is_required=True,
        ),
    )

    #: CommPilotExpressSRRedirectionWithException: *Required* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressSRRedirectionWithException, required=True, mutable=False,
    )
    #: CommPilotExpressSREmailNotify: *Required* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressSREmailNotify, required=True, mutable=False,
    )


class CommPilotExpressSRUnavailableModify(OCIType):
    """
    CommPilot Express SR Unavailable Configuration used in the context of a modify.

    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls",
            CommPilotExpressSRRedirectionWithExceptionModify, is_complex=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify",
            CommPilotExpressSREmailNotifyModify, is_complex=True,
        ),
    )

    #: CommPilotExpressSRRedirectionWithExceptionModify: *Optional* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressSRRedirectionWithExceptionModify, required=False,
        mutable=False,
    )
    #: CommPilotExpressSREmailNotifyModify: *Optional* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressSREmailNotifyModify, required=False, mutable=False,
    )


class CommPilotExpressUnavailable(OCIType):
    """
    CommPilot Express Unavailable Configuration used in the context of a get.

    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls", CommPilotExpressRedirectionWithException,
            is_complex=True, is_required=True,
        ),
        E("voice_mail_greeting", "voiceMailGreeting", str, is_required=True),
    )

    #: CommPilotExpressRedirectionWithException: *Required* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressRedirectionWithException, required=True, mutable=False,
    )
    #: str: *Required* voiceMailGreeting
    voice_mail_greeting = Field(type=str, required=True, mutable=False)


class CommPilotExpressUnavailableModify(OCIType):
    """
    CommPilot Express Unavailable Configuration used in the context of a modify.

    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls",
            CommPilotExpressRedirectionWithExceptionModify, is_complex=True,
        ),
        E("voice_mail_greeting", "voiceMailGreeting", str),
    )

    #: CommPilotExpressRedirectionWithExceptionModify: *Optional* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressRedirectionWithExceptionModify, required=False, mutable=False,
    )
    #: str: *Optional* voiceMailGreeting
    voice_mail_greeting = Field(type=str, required=False, mutable=False)


class CriteriaFromDnModify(OCIType):
    """
    The from dn criteria used within a modify request.

    """

    _ELEMENTS = (
        E("from_dn_criteria_selection", "fromDnCriteriaSelection", str),
        E("include_anonymous_callers", "includeAnonymousCallers", bool),
        E("include_unavailable_callers", "includeUnavailableCallers", bool),
        E("phone_number_list", "phoneNumberList", CriteriaReplacementDNList, is_complex=True),
    )

    #: str: *Optional* fromDnCriteriaSelection
    from_dn_criteria_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* includeAnonymousCallers
    include_anonymous_callers = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* includeUnavailableCallers
    include_unavailable_callers = Field(type=bool, required=False, mutable=False)
    #: CriteriaReplacementDNList: *Optional* phoneNumberList
    phone_number_list = Field(type=CriteriaReplacementDNList, required=False, mutable=False)


class DeviceManagementDeviceTypeModifyOptions(OCIType):
    """
    Device Management System device type options during a modify request.

    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str),
        E("tag_mode", "tagMode", str),
        E("tag_set", "tagSet", str),
        E("allow_device_profile_custom_tag_set", "allowDeviceProfileCustomTagSet", bool),
        E("allow_group_custom_tag_set", "allowGroupCustomTagSet", bool),
        E("send_email_upon_reset_failure", "sendEmailUponResetFailure", bool),
        E("device_access_net_address", "deviceAccessNetAddress", str),
        E("device_access_port", "deviceAccessPort", int),
        E("device_access_context", "deviceAccessContext", str),
        E("default_device_language", "defaultDeviceLanguage", str),
        E("default_device_encoding", "defaultDeviceEncoding", str),
        E(
            "access_device_credentials", "accessDeviceCredentials",
            DeviceManagementUserNamePassword, is_complex=True,
        ),
        E("use_http_digest_authentication", "useHttpDigestAuthentication", bool),
        E("mac_based_file_authentication", "macBasedFileAuthentication", bool),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool,
        ),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
    )

    #: str: *Optional* deviceAccessProtocol
    device_access_protocol = Field(type=str, required=False, mutable=False)
    #: str: *Optional* tagMode
    tag_mode = Field(type=str, required=False, mutable=False)
    #: str: *Optional* tagSet
    tag_set = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowDeviceProfileCustomTagSet
    allow_device_profile_custom_tag_set = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowGroupCustomTagSet
    allow_group_custom_tag_set = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* sendEmailUponResetFailure
    send_email_upon_reset_failure = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* deviceAccessNetAddress
    device_access_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* deviceAccessPort
    device_access_port = Field(type=int, required=False, mutable=False)
    #: str: *Optional* deviceAccessContext
    device_access_context = Field(type=str, required=False, mutable=False)
    #: str: *Optional* defaultDeviceLanguage
    default_device_language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* defaultDeviceEncoding
    default_device_encoding = Field(type=str, required=False, mutable=False)
    #: DeviceManagementUserNamePassword: *Optional* accessDeviceCredentials
    access_device_credentials = Field(
        type=DeviceManagementUserNamePassword, required=False, mutable=False,
    )
    #: bool: *Optional* useHttpDigestAuthentication
    use_http_digest_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* macBasedFileAuthentication
    mac_based_file_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* macInNonRequestURI
    mac_in_non_request_uri = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(type=str, required=False, mutable=False)


class DeviceManagementDeviceTypeModifyOptions16(OCIType):
    """
    Device Management System device type options during a modify request.

    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str),
        E("tag_mode", "tagMode", str),
        E("tag_set", "tagSet", str),
        E("allow_device_profile_custom_tag_set", "allowDeviceProfileCustomTagSet", bool),
        E("allow_group_custom_tag_set", "allowGroupCustomTagSet", bool),
        E("send_email_upon_reset_failure", "sendEmailUponResetFailure", bool),
        E("device_access_net_address", "deviceAccessNetAddress", str),
        E("device_access_port", "deviceAccessPort", int),
        E("device_access_context", "deviceAccessContext", str),
        E("default_device_language", "defaultDeviceLanguage", str),
        E("default_device_encoding", "defaultDeviceEncoding", str),
        E(
            "access_device_credentials", "accessDeviceCredentials",
            DeviceManagementUserNamePassword16, is_complex=True,
        ),
        E("use_http_digest_authentication", "useHttpDigestAuthentication", bool),
        E("mac_based_file_authentication", "macBasedFileAuthentication", bool),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool,
        ),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
    )

    #: str: *Optional* deviceAccessProtocol
    device_access_protocol = Field(type=str, required=False, mutable=False)
    #: str: *Optional* tagMode
    tag_mode = Field(type=str, required=False, mutable=False)
    #: str: *Optional* tagSet
    tag_set = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowDeviceProfileCustomTagSet
    allow_device_profile_custom_tag_set = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowGroupCustomTagSet
    allow_group_custom_tag_set = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* sendEmailUponResetFailure
    send_email_upon_reset_failure = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* deviceAccessNetAddress
    device_access_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* deviceAccessPort
    device_access_port = Field(type=int, required=False, mutable=False)
    #: str: *Optional* deviceAccessContext
    device_access_context = Field(type=str, required=False, mutable=False)
    #: str: *Optional* defaultDeviceLanguage
    default_device_language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* defaultDeviceEncoding
    default_device_encoding = Field(type=str, required=False, mutable=False)
    #: DeviceManagementUserNamePassword16: *Optional* accessDeviceCredentials
    access_device_credentials = Field(
        type=DeviceManagementUserNamePassword16, required=False, mutable=False,
    )
    #: bool: *Optional* useHttpDigestAuthentication
    use_http_digest_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* macBasedFileAuthentication
    mac_based_file_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* macInNonRequestURI
    mac_in_non_request_uri = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(type=str, required=False, mutable=False)


class DeviceManagementDeviceTypeOptions(OCIType):
    """
    Device Management System device type options.

    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str, is_required=True),
        E("tag_mode", "tagMode", str, is_required=True),
        E("tag_set", "tagSet", str),
        E(
            "allow_device_profile_custom_tag_set", "allowDeviceProfileCustomTagSet", bool,
            is_required=True,
        ),
        E("allow_group_custom_tag_set", "allowGroupCustomTagSet", bool, is_required=True),
        E(
            "send_email_upon_reset_failure", "sendEmailUponResetFailure", bool,
            is_required=True,
        ),
        E("device_access_net_address", "deviceAccessNetAddress", str),
        E("device_access_port", "deviceAccessPort", int),
        E("device_access_context", "deviceAccessContext", str),
        E("device_access_uri", "deviceAccessURI", str),
        E("default_device_language", "defaultDeviceLanguage", str),
        E("default_device_encoding", "defaultDeviceEncoding", str),
        E(
            "access_device_credentials", "accessDeviceCredentials",
            DeviceManagementUserNamePassword, is_complex=True,
        ),
        E(
            "use_http_digest_authentication", "useHttpDigestAuthentication", bool,
            is_required=True,
        ),
        E(
            "mac_based_file_authentication", "macBasedFileAuthentication", bool,
            is_required=True,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool, is_required=True,
        ),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool, is_required=True),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
    )

    #: str: *Required* deviceAccessProtocol
    device_access_protocol = Field(type=str, required=True, mutable=False)
    #: str: *Required* tagMode
    tag_mode = Field(type=str, required=True, mutable=False)
    #: str: *Optional* tagSet
    tag_set = Field(type=str, required=False, mutable=False)
    #: bool: *Required* allowDeviceProfileCustomTagSet
    allow_device_profile_custom_tag_set = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowGroupCustomTagSet
    allow_group_custom_tag_set = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* sendEmailUponResetFailure
    send_email_upon_reset_failure = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* deviceAccessNetAddress
    device_access_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* deviceAccessPort
    device_access_port = Field(type=int, required=False, mutable=False)
    #: str: *Optional* deviceAccessContext
    device_access_context = Field(type=str, required=False, mutable=False)
    #: str: *Optional* deviceAccessURI
    device_access_uri = Field(type=str, required=False, mutable=False)
    #: str: *Optional* defaultDeviceLanguage
    default_device_language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* defaultDeviceEncoding
    default_device_encoding = Field(type=str, required=False, mutable=False)
    #: DeviceManagementUserNamePassword: *Optional* accessDeviceCredentials
    access_device_credentials = Field(
        type=DeviceManagementUserNamePassword, required=False, mutable=False,
    )
    #: bool: *Required* useHttpDigestAuthentication
    use_http_digest_authentication = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* macBasedFileAuthentication
    mac_based_file_authentication = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* macInNonRequestURI
    mac_in_non_request_uri = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(type=str, required=False, mutable=False)


class DeviceManagementDeviceTypeOptions16(OCIType):
    """
    Device Management System device type options.

    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str, is_required=True),
        E("tag_mode", "tagMode", str, is_required=True),
        E("tag_set", "tagSet", str),
        E(
            "allow_device_profile_custom_tag_set", "allowDeviceProfileCustomTagSet", bool,
            is_required=True,
        ),
        E("allow_group_custom_tag_set", "allowGroupCustomTagSet", bool, is_required=True),
        E(
            "send_email_upon_reset_failure", "sendEmailUponResetFailure", bool,
            is_required=True,
        ),
        E("device_access_net_address", "deviceAccessNetAddress", str),
        E("device_access_port", "deviceAccessPort", int),
        E("device_access_context", "deviceAccessContext", str),
        E("device_access_uri", "deviceAccessURI", str),
        E("default_device_language", "defaultDeviceLanguage", str),
        E("default_device_encoding", "defaultDeviceEncoding", str),
        E(
            "access_device_credentials", "accessDeviceCredentials",
            DeviceManagementUserNamePassword16, is_complex=True,
        ),
        E(
            "use_http_digest_authentication", "useHttpDigestAuthentication", bool,
            is_required=True,
        ),
        E(
            "mac_based_file_authentication", "macBasedFileAuthentication", bool,
            is_required=True,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool, is_required=True,
        ),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool, is_required=True),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
    )

    #: str: *Required* deviceAccessProtocol
    device_access_protocol = Field(type=str, required=True, mutable=False)
    #: str: *Required* tagMode
    tag_mode = Field(type=str, required=True, mutable=False)
    #: str: *Optional* tagSet
    tag_set = Field(type=str, required=False, mutable=False)
    #: bool: *Required* allowDeviceProfileCustomTagSet
    allow_device_profile_custom_tag_set = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowGroupCustomTagSet
    allow_group_custom_tag_set = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* sendEmailUponResetFailure
    send_email_upon_reset_failure = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* deviceAccessNetAddress
    device_access_net_address = Field(type=str, required=False, mutable=False)
    #: int: *Optional* deviceAccessPort
    device_access_port = Field(type=int, required=False, mutable=False)
    #: str: *Optional* deviceAccessContext
    device_access_context = Field(type=str, required=False, mutable=False)
    #: str: *Optional* deviceAccessURI
    device_access_uri = Field(type=str, required=False, mutable=False)
    #: str: *Optional* defaultDeviceLanguage
    default_device_language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* defaultDeviceEncoding
    default_device_encoding = Field(type=str, required=False, mutable=False)
    #: DeviceManagementUserNamePassword16: *Optional* accessDeviceCredentials
    access_device_credentials = Field(
        type=DeviceManagementUserNamePassword16, required=False, mutable=False,
    )
    #: bool: *Required* useHttpDigestAuthentication
    use_http_digest_authentication = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* macBasedFileAuthentication
    mac_based_file_authentication = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* macInNonRequestURI
    mac_in_non_request_uri = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(type=str, required=False, mutable=False)


class EnhancedCallLogsNumberFilter(OCIType):
    """
    Filter criteria based on the called number or number called.

    """

    _ELEMENTS = (
        E("include_basic_call_type", "includeBasicCallType", str),
        E("include_call_category", "includeCallCategory", str),
        E("include_configurable_call_type", "includeConfigurableCallType", str),
        E(
            "search_criteria_dialed_number", "searchCriteriaDialedNumber",
            SearchCriteriaOutgoingDNorSIPURI, is_complex=True,
        ),
        E(
            "search_criteria_called_number", "searchCriteriaCalledNumber",
            SearchCriteriaOutgoingDNorSIPURI, is_complex=True,
        ),
        E(
            "search_criteria_network_translated_number",
            "searchCriteriaNetworkTranslatedNumber", SearchCriteriaOutgoingDNorSIPURI,
            is_complex=True,
        ),
        E(
            "search_criteria_calling_presentation_number",
            "searchCriteriaCallingPresentationNumber", SearchCriteriaOutgoingDNorSIPURI,
            is_complex=True,
        ),
    )

    #: str: *Optional* includeBasicCallType
    include_basic_call_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* includeCallCategory
    include_call_category = Field(type=str, required=False, mutable=False)
    #: str: *Optional* includeConfigurableCallType
    include_configurable_call_type = Field(type=str, required=False, mutable=False)
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional* searchCriteriaDialedNumber
    search_criteria_dialed_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional* searchCriteriaCalledNumber
    search_criteria_called_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional* searchCriteriaNetworkTranslatedNumber
    search_criteria_network_translated_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional*
    #: searchCriteriaCallingPresentationNumber
    search_criteria_calling_presentation_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )


class EnhancedCallLogsRedirectedNumberFilter(OCIType):
    """
    Filter criteria based on the transferred/forwarded number.

    """

    _ELEMENTS = (
        E(
            "redirected_call", "redirectedCall", EnhancedCallLogsRedirectedCallSelection,
            is_complex=True,
        ),
        E(
            "include_service_invocation_basic_call_type",
            "includeServiceInvocationBasicCallType", str,
        ),
        E(
            "include_service_invocation_call_category",
            "includeServiceInvocationCallCategory", str,
        ),
        E(
            "include_service_invocation_configurable_call_type",
            "includeServiceInvocationConfigurableCallType", str,
        ),
        E(
            "search_criteria_service_invocation_dialed_number",
            "searchCriteriaServiceInvocationDialedNumber",
            SearchCriteriaOutgoingDNorSIPURI, is_complex=True,
        ),
        E(
            "search_criteria_service_invocation_called_number",
            "searchCriteriaServiceInvocationCalledNumber",
            SearchCriteriaOutgoingDNorSIPURI, is_complex=True,
        ),
        E(
            "search_criteria_service_invocation_network_translated_number",
            "searchCriteriaServiceInvocationNetworkTranslatedNumber",
            SearchCriteriaOutgoingDNorSIPURI, is_complex=True,
        ),
    )

    #: EnhancedCallLogsRedirectedCallSelection: *Optional* redirectedCall
    redirected_call = Field(
        type=EnhancedCallLogsRedirectedCallSelection, required=False, mutable=False,
    )
    #: str: *Optional* includeServiceInvocationBasicCallType
    include_service_invocation_basic_call_type = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* includeServiceInvocationCallCategory
    include_service_invocation_call_category = Field(type=str, required=False, mutable=False)
    #: str: *Optional* includeServiceInvocationConfigurableCallType
    include_service_invocation_configurable_call_type = Field(
        type=str, required=False, mutable=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional*
    #: searchCriteriaServiceInvocationDialedNumber
    search_criteria_service_invocation_dialed_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional*
    #: searchCriteriaServiceInvocationCalledNumber
    search_criteria_service_invocation_called_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional*
    #: searchCriteriaServiceInvocationNetworkTranslatedNumber
    search_criteria_service_invocation_network_translated_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )


class EnhancedCallLogsRedirectedNumberFilter21(OCIType):
    """
    Filter criteria based on the transferred/forwarded number.

    """

    _ELEMENTS = (
        E(
            "redirected_call", "redirectedCall",
            EnhancedCallLogsRedirectedCallSelection21, is_complex=True,
        ),
        E(
            "include_service_invocation_basic_call_type",
            "includeServiceInvocationBasicCallType", str,
        ),
        E(
            "include_service_invocation_call_category",
            "includeServiceInvocationCallCategory", str,
        ),
        E(
            "include_service_invocation_configurable_call_type",
            "includeServiceInvocationConfigurableCallType", str,
        ),
        E(
            "search_criteria_service_invocation_dialed_number",
            "searchCriteriaServiceInvocationDialedNumber",
            SearchCriteriaOutgoingDNorSIPURI, is_complex=True,
        ),
        E(
            "search_criteria_service_invocation_called_number",
            "searchCriteriaServiceInvocationCalledNumber",
            SearchCriteriaOutgoingDNorSIPURI, is_complex=True,
        ),
        E(
            "search_criteria_service_invocation_network_translated_number",
            "searchCriteriaServiceInvocationNetworkTranslatedNumber",
            SearchCriteriaOutgoingDNorSIPURI, is_complex=True,
        ),
    )

    #: EnhancedCallLogsRedirectedCallSelection21: *Optional* redirectedCall
    redirected_call = Field(
        type=EnhancedCallLogsRedirectedCallSelection21, required=False, mutable=False,
    )
    #: str: *Optional* includeServiceInvocationBasicCallType
    include_service_invocation_basic_call_type = Field(
        type=str, required=False, mutable=False,
    )
    #: str: *Optional* includeServiceInvocationCallCategory
    include_service_invocation_call_category = Field(type=str, required=False, mutable=False)
    #: str: *Optional* includeServiceInvocationConfigurableCallType
    include_service_invocation_configurable_call_type = Field(
        type=str, required=False, mutable=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional*
    #: searchCriteriaServiceInvocationDialedNumber
    search_criteria_service_invocation_dialed_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional*
    #: searchCriteriaServiceInvocationCalledNumber
    search_criteria_service_invocation_called_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional*
    #: searchCriteriaServiceInvocationNetworkTranslatedNumber
    search_criteria_service_invocation_network_translated_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )


class EnterpriseAccessDevice(OCIType):
    """
    Uniquely identifies an access device accessible for an enterprise.

    It could be a system level device, an enterprise level device or a group level device.
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("group_id", "groupId", str),
    )

    #: AccessDevice: *Required* accessDevice
    access_device = Field(type=AccessDevice, required=True, mutable=False)
    #: str: *Optional* groupId
    group_id = Field(type=str, required=False, mutable=False)


class EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup(OCIType):
    """
    Trunk group details (order and weight) for each trunk group
    """

    _ELEMENTS = (
        E(
            "trunk_group", "trunkGroup", EnterpriseTrunkTrunkGroupKey, is_complex=True,
            is_required=True,
        ),
        E("priority", "priority", int, is_required=True),
        E("weight", "weight", int, is_required=True),
    )

    #: EnterpriseTrunkTrunkGroupKey: *Required* trunkGroup
    trunk_group = Field(type=EnterpriseTrunkTrunkGroupKey, required=True, mutable=False)
    #: int: *Required* priority
    priority = Field(type=int, required=True, mutable=False)
    #: int: *Required* weight
    weight = Field(type=int, required=True, mutable=False)


class EnterpriseTrunkPriorityWeightedTrunkGroup(OCIType):
    """
    Trunk group details (order and weight) for each trunk group
    """

    _ELEMENTS = (
        E(
            "trunk_group", "trunkGroup", EnterpriseTrunkTrunkGroupKey, is_complex=True,
            is_required=True,
        ),
        E("priority", "priority", int, is_required=True),
        E("weight", "weight", int, is_required=True),
    )

    #: EnterpriseTrunkTrunkGroupKey: *Required* trunkGroup
    trunk_group = Field(type=EnterpriseTrunkTrunkGroupKey, required=True, mutable=False)
    #: int: *Required* priority
    priority = Field(type=int, required=True, mutable=False)
    #: int: *Required* weight
    weight = Field(type=int, required=True, mutable=False)


class ExecutiveCallFilteringCriteriaFromDnModify(OCIType):
    """
    The from dn criteria used within an executive call filtering criteria modify request.

    """

    _ELEMENTS = (
        E("from_dn_criteria_selection", "fromDnCriteriaSelection", str),
        E("include_anonymous_callers", "includeAnonymousCallers", bool),
        E("include_unavailable_callers", "includeUnavailableCallers", bool),
        E("phone_number_list", "phoneNumberList", CriteriaReplacementDNList, is_complex=True),
    )

    #: str: *Optional* fromDnCriteriaSelection
    from_dn_criteria_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* includeAnonymousCallers
    include_anonymous_callers = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* includeUnavailableCallers
    include_unavailable_callers = Field(type=bool, required=False, mutable=False)
    #: CriteriaReplacementDNList: *Optional* phoneNumberList
    phone_number_list = Field(type=CriteriaReplacementDNList, required=False, mutable=False)


class ExtendedFileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer and an URL.

    """

    _ELEMENTS = (
        E("file", "file", LabeledFileResource, is_complex=True),
        E("url", "url", str),
    )

    #: LabeledFileResource: *Optional* file
    file = Field(type=LabeledFileResource, required=False, mutable=False)
    #: str: *Optional* url
    url = Field(type=str, required=False, mutable=False)


class ExtendedMediaFileLevelResource20(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer and an URL.

    """

    _ELEMENTS = (
        E("file", "file", AnnouncementFileLevelKey, is_complex=True),
        E("url", "url", str),
    )

    #: AnnouncementFileLevelKey: *Optional* file
    file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: str: *Optional* url
    url = Field(type=str, required=False, mutable=False)


class ExtendedMediaFileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer and an URL.

    """

    _ELEMENTS = (
        E("file", "file", LabeledMediaFileResource, is_complex=True),
        E("url", "url", str),
    )

    #: LabeledMediaFileResource: *Optional* file
    file = Field(type=LabeledMediaFileResource, required=False, mutable=False)
    #: str: *Optional* url
    url = Field(type=str, required=False, mutable=False)


class ExtendedMediaFileResource20(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer and an URL.

    """

    _ELEMENTS = (
        E("file", "file", AnnouncementFileKey, is_complex=True),
        E("url", "url", str),
    )

    #: AnnouncementFileKey: *Optional* file
    file = Field(type=AnnouncementFileKey, required=False, mutable=False)
    #: str: *Optional* url
    url = Field(type=str, required=False, mutable=False)


class GroupServiceAuthorization(OCIType):
    """
    Authorize (with quantity) or unauthorize a group service.

    """

    _ELEMENTS = (
        E("service_name", "serviceName", str, is_required=True),
        E("authorized_quantity", "authorizedQuantity", UnboundedPositiveInt, is_complex=True),
        E("unauthorized", "unauthorized", bool),
    )

    #: str: *Required* serviceName
    service_name = Field(type=str, required=True, mutable=False)
    #: UnboundedPositiveInt: *Optional* authorizedQuantity
    authorized_quantity = Field(type=UnboundedPositiveInt, required=False, mutable=False)
    #: bool: *Optional* unauthorized
    unauthorized = Field(type=bool, required=False, mutable=False)


class GroupTrunkGroupGetInstanceRequest14sp9A(OCIType):
    """
    Get a Trunk Group Instance's profile.

    The response is either a GroupTrunkGroupGetInstanceResponse14sp9A or an
    ``ErrorResponse()``. The response contains a hosted user table with column headings:
    "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name".
    """

    _ELEMENTS = (
        E(
            "trunk_group_key", "trunkGroupKey", TrunkGroupKey, is_complex=True,
            is_required=True,
        ),
    )

    #: TrunkGroupKey: *Required* trunkGroupKey
    trunk_group_key = Field(type=TrunkGroupKey, required=True, mutable=False)


class GroupTrunkGroupGetInstanceRequest17sp4V2(OCIType):
    """
    Get a Trunk Group Instance's profile.

    The response is either a GroupTrunkGroupGetInstanceResponse17sp4V2 or an
    ``ErrorResponse()``. The response contains a hosted user table with column headings:
    "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name".
    Replaced by: ``GroupTrunkGroupGetInstanceRequest19V2()``
    """

    _ELEMENTS = (
        E(
            "trunk_group_key", "trunkGroupKey", TrunkGroupKey, is_complex=True,
            is_required=True,
        ),
    )

    #: TrunkGroupKey: *Required* trunkGroupKey
    trunk_group_key = Field(type=TrunkGroupKey, required=True, mutable=False)


class GroupTrunkGroupGetInstanceRequest19sp1V2(OCIType):
    """
    Get a Trunk Group Instance's profile.

    The response is either a GroupTrunkGroupGetInstanceResponse19sp1V2 or an
    ``ErrorResponse()``. The response contains a hosted user table with column headings:
    "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address". Replaced by:
    ``GroupTrunkGroupGetInstanceRequest20sp1()``
    """

    _ELEMENTS = (
        E(
            "trunk_group_key", "trunkGroupKey", TrunkGroupKey, is_complex=True,
            is_required=True,
        ),
    )

    #: TrunkGroupKey: *Required* trunkGroupKey
    trunk_group_key = Field(type=TrunkGroupKey, required=True, mutable=False)


class GroupTrunkGroupGetInstanceResponse14sp9A(OCIType):
    """
    Response to GroupTrunkGroupGetInstanceRequest14sp9A.

    Returns the profile information for the Trunk Group.  Contains a hosted user table
    with column headings: "User Id", "Last Name", "First Name", "Hiragana Last Name",
    "Hiragana First Name".
    """

    _ELEMENTS = (
        E("pilot_user_id", "pilotUserId", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("access_device", "accessDevice", AccessDevice, is_complex=True),
        E("max_active_calls", "maxActiveCalls", int, is_required=True),
        E("max_incoming_calls", "maxIncomingCalls", int),
        E("max_outgoing_calls", "maxOutgoingCalls", int),
        E("enable_bursting", "enableBursting", bool, is_required=True),
        E("bursting_max_active_calls", "burstingMaxActiveCalls", int),
        E("bursting_max_incoming_calls", "burstingMaxIncomingCalls", int),
        E("bursting_max_outgoing_calls", "burstingMaxOutgoingCalls", int),
        E("capacity_exceeded_action", "capacityExceededAction", str),
        E("capacity_exceeded_forward_address", "capacityExceededForwardAddress", str),
        E(
            "capacity_exceeded_reroute_trunk_group_key",
            "capacityExceededRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E(
            "capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls",
            int, is_required=True,
        ),
        E(
            "capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int,
            is_required=True,
        ),
        E("unreachable_destination_action", "unreachableDestinationAction", str),
        E(
            "unreachable_destination_forward_address",
            "unreachableDestinationForwardAddress", str,
        ),
        E(
            "unreachable_destination_reroute_trunk_group_key",
            "unreachableDestinationRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E(
            "unreachable_destination_trap_initial_calls",
            "unreachableDestinationTrapInitialCalls", int, is_required=True,
        ),
        E(
            "unreachable_destination_trap_offset_calls",
            "unreachableDestinationTrapOffsetCalls", int, is_required=True,
        ),
        E("invitation_timeout", "invitationTimeout", int, is_required=True),
        E("require_authentication", "requireAuthentication", bool, is_required=True),
        E("sip_authentication_user_name", "sipAuthenticationUserName", str),
        E("hosted_user_table", "hostedUserTable", list, is_complex=True, is_table=True),
        E("trunk_group_identity", "trunkGroupIdentity", str),
        E("otg_dtg_identity", "otgDtgIdentity", str),
        E(
            "include_trunk_group_identity", "includeTrunkGroupIdentity", bool,
            is_required=True,
        ),
        E("include_dtg_identity", "includeDtgIdentity", bool, is_required=True),
        E(
            "enable_network_address_identity", "enableNetworkAddressIdentity", bool,
            is_required=True,
        ),
        E("allow_unscreened_calls", "allowUnscreenedCalls", bool, is_required=True),
        E(
            "allow_unscreened_emergency_calls", "allowUnscreenedEmergencyCalls", bool,
            is_required=True,
        ),
        E(
            "pilot_user_calling_line_identity_policy",
            "pilotUserCallingLineIdentityPolicy", str, is_required=True,
        ),
        E(
            "pilot_user_charge_number_policy", "pilotUserChargeNumberPolicy", str,
            is_required=True,
        ),
        E("call_forwarding_always_action", "callForwardingAlwaysAction", str),
        E(
            "call_forwarding_always_forward_address",
            "callForwardingAlwaysForwardAddress", str,
        ),
        E(
            "call_forwarding_always_reroute_trunk_group_key",
            "callForwardingAlwaysRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
    )

    #: str: *Optional* pilotUserId
    pilot_user_id = Field(type=str, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: AccessDevice: *Optional* accessDevice
    access_device = Field(type=AccessDevice, required=False, mutable=False)
    #: int: *Required* maxActiveCalls
    max_active_calls = Field(type=int, required=True, mutable=False)
    #: int: *Optional* maxIncomingCalls
    max_incoming_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxOutgoingCalls
    max_outgoing_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Required* enableBursting
    enable_bursting = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* burstingMaxActiveCalls
    bursting_max_active_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* burstingMaxIncomingCalls
    bursting_max_incoming_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* burstingMaxOutgoingCalls
    bursting_max_outgoing_calls = Field(type=int, required=False, mutable=False)
    #: str: *Optional* capacityExceededAction
    capacity_exceeded_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* capacityExceededForwardAddress
    capacity_exceeded_forward_address = Field(type=str, required=False, mutable=False)
    #: TrunkGroupKey: *Optional* capacityExceededRerouteTrunkGroupKey
    capacity_exceeded_reroute_trunk_group_key = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    #: int: *Required* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(type=int, required=True, mutable=False)
    #: int: *Required* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(type=int, required=True, mutable=False)
    #: str: *Optional* unreachableDestinationAction
    unreachable_destination_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* unreachableDestinationForwardAddress
    unreachable_destination_forward_address = Field(type=str, required=False, mutable=False)
    #: TrunkGroupKey: *Optional* unreachableDestinationRerouteTrunkGroupKey
    unreachable_destination_reroute_trunk_group_key = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    #: int: *Required* unreachableDestinationTrapInitialCalls
    unreachable_destination_trap_initial_calls = Field(type=int, required=True, mutable=False)
    #: int: *Required* unreachableDestinationTrapOffsetCalls
    unreachable_destination_trap_offset_calls = Field(type=int, required=True, mutable=False)
    #: int: *Required* invitationTimeout
    invitation_timeout = Field(type=int, required=True, mutable=False)
    #: bool: *Required* requireAuthentication
    require_authentication = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* sipAuthenticationUserName
    sip_authentication_user_name = Field(type=str, required=False, mutable=False)
    #: list: *Optional* hostedUserTable  *Tabular*
    hosted_user_table = Field(type=list, required=False, mutable=False)
    #: str: *Optional* trunkGroupIdentity
    trunk_group_identity = Field(type=str, required=False, mutable=False)
    #: str: *Optional* otgDtgIdentity
    otg_dtg_identity = Field(type=str, required=False, mutable=False)
    #: bool: *Required* includeTrunkGroupIdentity
    include_trunk_group_identity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* includeDtgIdentity
    include_dtg_identity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableNetworkAddressIdentity
    enable_network_address_identity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowUnscreenedCalls
    allow_unscreened_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowUnscreenedEmergencyCalls
    allow_unscreened_emergency_calls = Field(type=bool, required=True, mutable=False)
    #: str: *Required* pilotUserCallingLineIdentityPolicy
    pilot_user_calling_line_identity_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* pilotUserChargeNumberPolicy
    pilot_user_charge_number_policy = Field(type=str, required=True, mutable=False)
    #: str: *Optional* callForwardingAlwaysAction
    call_forwarding_always_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callForwardingAlwaysForwardAddress
    call_forwarding_always_forward_address = Field(type=str, required=False, mutable=False)
    #: TrunkGroupKey: *Optional* callForwardingAlwaysRerouteTrunkGroupKey
    call_forwarding_always_reroute_trunk_group_key = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )


class GroupTrunkGroupGetInstanceResponse17sp4V2(OCIType):
    """
    Response to GroupTrunkGroupGetInstanceRequest17sp4V2.

    Returns the profile information for the Trunk Group.  Contains a hosted user table
    with column headings: "User Id", "Last Name", "First Name", "Hiragana Last Name",
    "Hiragana First Name". Replaced by: ``GroupTrunkGroupGetInstanceResponse19V2()``
    """

    _ELEMENTS = (
        E("pilot_user_id", "pilotUserId", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("access_device", "accessDevice", AccessDevice, is_complex=True),
        E("max_active_calls", "maxActiveCalls", int, is_required=True),
        E("max_incoming_calls", "maxIncomingCalls", int),
        E("max_outgoing_calls", "maxOutgoingCalls", int),
        E("enable_bursting", "enableBursting", bool, is_required=True),
        E("bursting_max_active_calls", "burstingMaxActiveCalls", int),
        E("bursting_max_incoming_calls", "burstingMaxIncomingCalls", int),
        E("bursting_max_outgoing_calls", "burstingMaxOutgoingCalls", int),
        E("capacity_exceeded_action", "capacityExceededAction", str),
        E("capacity_exceeded_forward_address", "capacityExceededForwardAddress", str),
        E(
            "capacity_exceeded_reroute_trunk_group_key",
            "capacityExceededRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E(
            "capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls",
            int, is_required=True,
        ),
        E(
            "capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int,
            is_required=True,
        ),
        E("unreachable_destination_action", "unreachableDestinationAction", str),
        E(
            "unreachable_destination_forward_address",
            "unreachableDestinationForwardAddress", str,
        ),
        E(
            "unreachable_destination_reroute_trunk_group_key",
            "unreachableDestinationRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E("invitation_timeout", "invitationTimeout", int, is_required=True),
        E("require_authentication", "requireAuthentication", bool, is_required=True),
        E("sip_authentication_user_name", "sipAuthenticationUserName", str),
        E("hosted_user_table", "hostedUserTable", list, is_complex=True, is_table=True),
        E("trunk_group_identity", "trunkGroupIdentity", str),
        E("otg_dtg_identity", "otgDtgIdentity", str),
        E(
            "allow_termination_to_trunk_group_identity",
            "allowTerminationToTrunkGroupIdentity", bool, is_required=True,
        ),
        E(
            "allow_termination_to_dtg_identity", "allowTerminationToDtgIdentity", bool,
            is_required=True,
        ),
        E(
            "include_trunk_group_identity", "includeTrunkGroupIdentity", bool,
            is_required=True,
        ),
        E("include_dtg_identity", "includeDtgIdentity", bool, is_required=True),
        E(
            "include_trunk_group_identity_for_network_calls",
            "includeTrunkGroupIdentityForNetworkCalls", bool, is_required=True,
        ),
        E(
            "include_otg_identity_for_network_calls", "includeOtgIdentityForNetworkCalls",
            bool, is_required=True,
        ),
        E(
            "enable_network_address_identity", "enableNetworkAddressIdentity", bool,
            is_required=True,
        ),
        E("allow_unscreened_calls", "allowUnscreenedCalls", bool, is_required=True),
        E(
            "allow_unscreened_emergency_calls", "allowUnscreenedEmergencyCalls", bool,
            is_required=True,
        ),
        E(
            "pilot_user_calling_line_identity_policy",
            "pilotUserCallingLineIdentityPolicy", str, is_required=True,
        ),
        E(
            "pilot_user_charge_number_policy", "pilotUserChargeNumberPolicy", str,
            is_required=True,
        ),
        E("call_forwarding_always_action", "callForwardingAlwaysAction", str),
        E(
            "call_forwarding_always_forward_address",
            "callForwardingAlwaysForwardAddress", str,
        ),
        E(
            "call_forwarding_always_reroute_trunk_group_key",
            "callForwardingAlwaysRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E("peering_domain", "peeringDomain", str),
        E("route_to_peering_domain", "routeToPeeringDomain", bool, is_required=True),
        E("prefix_enabled", "prefixEnabled", bool, is_required=True),
        E("prefix", "prefix", str),
        E("stateful_rerouting_enabled", "statefulReroutingEnabled", bool, is_required=True),
        E(
            "send_continuous_options_message", "sendContinuousOptionsMessage", bool,
            is_required=True,
        ),
        E(
            "continuous_options_sending_interval_seconds",
            "continuousOptionsSendingIntervalSeconds", int, is_required=True,
        ),
        E(
            "failure_options_sending_interval_seconds",
            "failureOptionsSendingIntervalSeconds", int, is_required=True,
        ),
        E("failure_threshold_counter", "failureThresholdCounter", int, is_required=True),
        E("success_threshold_counter", "successThresholdCounter", int, is_required=True),
        E(
            "invite_failure_threshold_counter", "inviteFailureThresholdCounter", int,
            is_required=True,
        ),
        E(
            "invite_failure_threshold_window_seconds",
            "inviteFailureThresholdWindowSeconds", int, is_required=True,
        ),
        E("trunk_group_state", "trunkGroupState", str, is_required=True),
        E(
            "pilot_user_calling_line_asserted_identity_policy",
            "pilotUserCallingLineAssertedIdentityPolicy", str, is_required=True,
        ),
        E(
            "use_system_calling_line_asserted_identity_policy",
            "useSystemCallingLineAssertedIdentityPolicy", bool, is_required=True,
        ),
    )

    #: str: *Optional* pilotUserId
    pilot_user_id = Field(type=str, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: AccessDevice: *Optional* accessDevice
    access_device = Field(type=AccessDevice, required=False, mutable=False)
    #: int: *Required* maxActiveCalls
    max_active_calls = Field(type=int, required=True, mutable=False)
    #: int: *Optional* maxIncomingCalls
    max_incoming_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxOutgoingCalls
    max_outgoing_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Required* enableBursting
    enable_bursting = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* burstingMaxActiveCalls
    bursting_max_active_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* burstingMaxIncomingCalls
    bursting_max_incoming_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* burstingMaxOutgoingCalls
    bursting_max_outgoing_calls = Field(type=int, required=False, mutable=False)
    #: str: *Optional* capacityExceededAction
    capacity_exceeded_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* capacityExceededForwardAddress
    capacity_exceeded_forward_address = Field(type=str, required=False, mutable=False)
    #: TrunkGroupKey: *Optional* capacityExceededRerouteTrunkGroupKey
    capacity_exceeded_reroute_trunk_group_key = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    #: int: *Required* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(type=int, required=True, mutable=False)
    #: int: *Required* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(type=int, required=True, mutable=False)
    #: str: *Optional* unreachableDestinationAction
    unreachable_destination_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* unreachableDestinationForwardAddress
    unreachable_destination_forward_address = Field(type=str, required=False, mutable=False)
    #: TrunkGroupKey: *Optional* unreachableDestinationRerouteTrunkGroupKey
    unreachable_destination_reroute_trunk_group_key = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    #: int: *Required* invitationTimeout
    invitation_timeout = Field(type=int, required=True, mutable=False)
    #: bool: *Required* requireAuthentication
    require_authentication = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* sipAuthenticationUserName
    sip_authentication_user_name = Field(type=str, required=False, mutable=False)
    #: list: *Optional* hostedUserTable  *Tabular*
    hosted_user_table = Field(type=list, required=False, mutable=False)
    #: str: *Optional* trunkGroupIdentity
    trunk_group_identity = Field(type=str, required=False, mutable=False)
    #: str: *Optional* otgDtgIdentity
    otg_dtg_identity = Field(type=str, required=False, mutable=False)
    #: bool: *Required* allowTerminationToTrunkGroupIdentity
    allow_termination_to_trunk_group_identity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowTerminationToDtgIdentity
    allow_termination_to_dtg_identity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* includeTrunkGroupIdentity
    include_trunk_group_identity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* includeDtgIdentity
    include_dtg_identity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* includeTrunkGroupIdentityForNetworkCalls
    include_trunk_group_identity_for_network_calls = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* includeOtgIdentityForNetworkCalls
    include_otg_identity_for_network_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableNetworkAddressIdentity
    enable_network_address_identity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowUnscreenedCalls
    allow_unscreened_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowUnscreenedEmergencyCalls
    allow_unscreened_emergency_calls = Field(type=bool, required=True, mutable=False)
    #: str: *Required* pilotUserCallingLineIdentityPolicy
    pilot_user_calling_line_identity_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* pilotUserChargeNumberPolicy
    pilot_user_charge_number_policy = Field(type=str, required=True, mutable=False)
    #: str: *Optional* callForwardingAlwaysAction
    call_forwarding_always_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callForwardingAlwaysForwardAddress
    call_forwarding_always_forward_address = Field(type=str, required=False, mutable=False)
    #: TrunkGroupKey: *Optional* callForwardingAlwaysRerouteTrunkGroupKey
    call_forwarding_always_reroute_trunk_group_key = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    #: str: *Optional* peeringDomain
    peering_domain = Field(type=str, required=False, mutable=False)
    #: bool: *Required* routeToPeeringDomain
    route_to_peering_domain = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* prefixEnabled
    prefix_enabled = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* prefix
    prefix = Field(type=str, required=False, mutable=False)
    #: bool: *Required* statefulReroutingEnabled
    stateful_rerouting_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* sendContinuousOptionsMessage
    send_continuous_options_message = Field(type=bool, required=True, mutable=False)
    #: int: *Required* continuousOptionsSendingIntervalSeconds
    continuous_options_sending_interval_seconds = Field(
        type=int, required=True, mutable=False,
    )
    #: int: *Required* failureOptionsSendingIntervalSeconds
    failure_options_sending_interval_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* failureThresholdCounter
    failure_threshold_counter = Field(type=int, required=True, mutable=False)
    #: int: *Required* successThresholdCounter
    success_threshold_counter = Field(type=int, required=True, mutable=False)
    #: int: *Required* inviteFailureThresholdCounter
    invite_failure_threshold_counter = Field(type=int, required=True, mutable=False)
    #: int: *Required* inviteFailureThresholdWindowSeconds
    invite_failure_threshold_window_seconds = Field(type=int, required=True, mutable=False)
    #: str: *Required* trunkGroupState
    trunk_group_state = Field(type=str, required=True, mutable=False)
    #: str: *Required* pilotUserCallingLineAssertedIdentityPolicy
    pilot_user_calling_line_asserted_identity_policy = Field(
        type=str, required=True, mutable=False,
    )
    #: bool: *Required* useSystemCallingLineAssertedIdentityPolicy
    use_system_calling_line_asserted_identity_policy = Field(
        type=bool, required=True, mutable=False,
    )


class GroupTrunkGroupGetInstanceResponse19sp1V2(OCIType):
    """
    Response to GroupTrunkGroupGetInstanceRequest19sp1V2.

    Returns the profile information for the Trunk Group.  Contains a hosted user table
    with column headings: "User Id", "Last Name", "First Name", "Hiragana Last Name",
    "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address".
    Replaced by: ``GroupTrunkGroupGetInstanceResponse20sp1()``
    """

    _ELEMENTS = (
        E("pilot_user_id", "pilotUserId", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("access_device", "accessDevice", AccessDevice, is_complex=True),
        E("max_active_calls", "maxActiveCalls", int, is_required=True),
        E("max_incoming_calls", "maxIncomingCalls", int),
        E("max_outgoing_calls", "maxOutgoingCalls", int),
        E("enable_bursting", "enableBursting", bool, is_required=True),
        E("bursting_max_active_calls", "burstingMaxActiveCalls", int),
        E("bursting_max_incoming_calls", "burstingMaxIncomingCalls", int),
        E("bursting_max_outgoing_calls", "burstingMaxOutgoingCalls", int),
        E("capacity_exceeded_action", "capacityExceededAction", str),
        E("capacity_exceeded_forward_address", "capacityExceededForwardAddress", str),
        E(
            "capacity_exceeded_reroute_trunk_group_key",
            "capacityExceededRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E(
            "capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls",
            int, is_required=True,
        ),
        E(
            "capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int,
            is_required=True,
        ),
        E("unreachable_destination_action", "unreachableDestinationAction", str),
        E(
            "unreachable_destination_forward_address",
            "unreachableDestinationForwardAddress", str,
        ),
        E(
            "unreachable_destination_reroute_trunk_group_key",
            "unreachableDestinationRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E("invitation_timeout", "invitationTimeout", int, is_required=True),
        E("require_authentication", "requireAuthentication", bool, is_required=True),
        E("sip_authentication_user_name", "sipAuthenticationUserName", str),
        E("hosted_user_table", "hostedUserTable", list, is_complex=True, is_table=True),
        E("trunk_group_identity", "trunkGroupIdentity", str),
        E("otg_dtg_identity", "otgDtgIdentity", str),
        E(
            "allow_termination_to_trunk_group_identity",
            "allowTerminationToTrunkGroupIdentity", bool, is_required=True,
        ),
        E(
            "allow_termination_to_dtg_identity", "allowTerminationToDtgIdentity", bool,
            is_required=True,
        ),
        E(
            "include_trunk_group_identity", "includeTrunkGroupIdentity", bool,
            is_required=True,
        ),
        E("include_dtg_identity", "includeDtgIdentity", bool, is_required=True),
        E(
            "include_trunk_group_identity_for_network_calls",
            "includeTrunkGroupIdentityForNetworkCalls", bool, is_required=True,
        ),
        E(
            "include_otg_identity_for_network_calls", "includeOtgIdentityForNetworkCalls",
            bool, is_required=True,
        ),
        E(
            "enable_network_address_identity", "enableNetworkAddressIdentity", bool,
            is_required=True,
        ),
        E("allow_unscreened_calls", "allowUnscreenedCalls", bool, is_required=True),
        E(
            "allow_unscreened_emergency_calls", "allowUnscreenedEmergencyCalls", bool,
            is_required=True,
        ),
        E(
            "pilot_user_calling_line_identity_for_external_calls_policy",
            "pilotUserCallingLineIdentityForExternalCallsPolicy", str, is_required=True,
        ),
        E(
            "pilot_user_charge_number_policy", "pilotUserChargeNumberPolicy", str,
            is_required=True,
        ),
        E("call_forwarding_always_action", "callForwardingAlwaysAction", str),
        E(
            "call_forwarding_always_forward_address",
            "callForwardingAlwaysForwardAddress", str,
        ),
        E(
            "call_forwarding_always_reroute_trunk_group_key",
            "callForwardingAlwaysRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E("peering_domain", "peeringDomain", str),
        E("route_to_peering_domain", "routeToPeeringDomain", bool, is_required=True),
        E("prefix_enabled", "prefixEnabled", bool, is_required=True),
        E("prefix", "prefix", str),
        E("stateful_rerouting_enabled", "statefulReroutingEnabled", bool, is_required=True),
        E(
            "send_continuous_options_message", "sendContinuousOptionsMessage", bool,
            is_required=True,
        ),
        E(
            "continuous_options_sending_interval_seconds",
            "continuousOptionsSendingIntervalSeconds", int, is_required=True,
        ),
        E(
            "failure_options_sending_interval_seconds",
            "failureOptionsSendingIntervalSeconds", int, is_required=True,
        ),
        E("failure_threshold_counter", "failureThresholdCounter", int, is_required=True),
        E("success_threshold_counter", "successThresholdCounter", int, is_required=True),
        E(
            "invite_failure_threshold_counter", "inviteFailureThresholdCounter", int,
            is_required=True,
        ),
        E(
            "invite_failure_threshold_window_seconds",
            "inviteFailureThresholdWindowSeconds", int, is_required=True,
        ),
        E("trunk_group_state", "trunkGroupState", str, is_required=True),
        E(
            "pilot_user_calling_line_asserted_identity_policy",
            "pilotUserCallingLineAssertedIdentityPolicy", str, is_required=True,
        ),
        E(
            "use_system_calling_line_asserted_identity_policy",
            "useSystemCallingLineAssertedIdentityPolicy", bool, is_required=True,
        ),
        E("total_active_incoming_calls", "totalActiveIncomingCalls", int, is_required=True),
        E("total_active_outgoing_calls", "totalActiveOutgoingCalls", int, is_required=True),
        E(
            "pilot_user_call_optimization_policy", "pilotUserCallOptimizationPolicy", str,
            is_required=True,
        ),
        E(
            "clid_source_for_screened_calls_policy", "clidSourceForScreenedCallsPolicy",
            str, is_required=True,
        ),
        E(
            "use_system_clid_source_for_screened_calls_policy",
            "useSystemCLIDSourceForScreenedCallsPolicy", bool, is_required=True,
        ),
        E("user_lookup_policy", "userLookupPolicy", str, is_required=True),
        E(
            "use_system_user_lookup_policy", "useSystemUserLookupPolicy", bool,
            is_required=True,
        ),
        E(
            "pilot_user_calling_line_identity_for_emergency_calls_policy",
            "pilotUserCallingLineIdentityForEmergencyCallsPolicy", str, is_required=True,
        ),
    )

    #: str: *Optional* pilotUserId
    pilot_user_id = Field(type=str, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: AccessDevice: *Optional* accessDevice
    access_device = Field(type=AccessDevice, required=False, mutable=False)
    #: int: *Required* maxActiveCalls
    max_active_calls = Field(type=int, required=True, mutable=False)
    #: int: *Optional* maxIncomingCalls
    max_incoming_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxOutgoingCalls
    max_outgoing_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Required* enableBursting
    enable_bursting = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* burstingMaxActiveCalls
    bursting_max_active_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* burstingMaxIncomingCalls
    bursting_max_incoming_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* burstingMaxOutgoingCalls
    bursting_max_outgoing_calls = Field(type=int, required=False, mutable=False)
    #: str: *Optional* capacityExceededAction
    capacity_exceeded_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* capacityExceededForwardAddress
    capacity_exceeded_forward_address = Field(type=str, required=False, mutable=False)
    #: TrunkGroupKey: *Optional* capacityExceededRerouteTrunkGroupKey
    capacity_exceeded_reroute_trunk_group_key = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    #: int: *Required* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(type=int, required=True, mutable=False)
    #: int: *Required* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(type=int, required=True, mutable=False)
    #: str: *Optional* unreachableDestinationAction
    unreachable_destination_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* unreachableDestinationForwardAddress
    unreachable_destination_forward_address = Field(type=str, required=False, mutable=False)
    #: TrunkGroupKey: *Optional* unreachableDestinationRerouteTrunkGroupKey
    unreachable_destination_reroute_trunk_group_key = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    #: int: *Required* invitationTimeout
    invitation_timeout = Field(type=int, required=True, mutable=False)
    #: bool: *Required* requireAuthentication
    require_authentication = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* sipAuthenticationUserName
    sip_authentication_user_name = Field(type=str, required=False, mutable=False)
    #: list: *Optional* hostedUserTable  *Tabular*
    hosted_user_table = Field(type=list, required=False, mutable=False)
    #: str: *Optional* trunkGroupIdentity
    trunk_group_identity = Field(type=str, required=False, mutable=False)
    #: str: *Optional* otgDtgIdentity
    otg_dtg_identity = Field(type=str, required=False, mutable=False)
    #: bool: *Required* allowTerminationToTrunkGroupIdentity
    allow_termination_to_trunk_group_identity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowTerminationToDtgIdentity
    allow_termination_to_dtg_identity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* includeTrunkGroupIdentity
    include_trunk_group_identity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* includeDtgIdentity
    include_dtg_identity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* includeTrunkGroupIdentityForNetworkCalls
    include_trunk_group_identity_for_network_calls = Field(
        type=bool, required=True, mutable=False,
    )
    #: bool: *Required* includeOtgIdentityForNetworkCalls
    include_otg_identity_for_network_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableNetworkAddressIdentity
    enable_network_address_identity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowUnscreenedCalls
    allow_unscreened_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowUnscreenedEmergencyCalls
    allow_unscreened_emergency_calls = Field(type=bool, required=True, mutable=False)
    #: str: *Required* pilotUserCallingLineIdentityForExternalCallsPolicy
    pilot_user_calling_line_identity_for_external_calls_policy = Field(
        type=str, required=True, mutable=False,
    )
    #: str: *Required* pilotUserChargeNumberPolicy
    pilot_user_charge_number_policy = Field(type=str, required=True, mutable=False)
    #: str: *Optional* callForwardingAlwaysAction
    call_forwarding_always_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callForwardingAlwaysForwardAddress
    call_forwarding_always_forward_address = Field(type=str, required=False, mutable=False)
    #: TrunkGroupKey: *Optional* callForwardingAlwaysRerouteTrunkGroupKey
    call_forwarding_always_reroute_trunk_group_key = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    #: str: *Optional* peeringDomain
    peering_domain = Field(type=str, required=False, mutable=False)
    #: bool: *Required* routeToPeeringDomain
    route_to_peering_domain = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* prefixEnabled
    prefix_enabled = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* prefix
    prefix = Field(type=str, required=False, mutable=False)
    #: bool: *Required* statefulReroutingEnabled
    stateful_rerouting_enabled = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* sendContinuousOptionsMessage
    send_continuous_options_message = Field(type=bool, required=True, mutable=False)
    #: int: *Required* continuousOptionsSendingIntervalSeconds
    continuous_options_sending_interval_seconds = Field(
        type=int, required=True, mutable=False,
    )
    #: int: *Required* failureOptionsSendingIntervalSeconds
    failure_options_sending_interval_seconds = Field(type=int, required=True, mutable=False)
    #: int: *Required* failureThresholdCounter
    failure_threshold_counter = Field(type=int, required=True, mutable=False)
    #: int: *Required* successThresholdCounter
    success_threshold_counter = Field(type=int, required=True, mutable=False)
    #: int: *Required* inviteFailureThresholdCounter
    invite_failure_threshold_counter = Field(type=int, required=True, mutable=False)
    #: int: *Required* inviteFailureThresholdWindowSeconds
    invite_failure_threshold_window_seconds = Field(type=int, required=True, mutable=False)
    #: str: *Required* trunkGroupState
    trunk_group_state = Field(type=str, required=True, mutable=False)
    #: str: *Required* pilotUserCallingLineAssertedIdentityPolicy
    pilot_user_calling_line_asserted_identity_policy = Field(
        type=str, required=True, mutable=False,
    )
    #: bool: *Required* useSystemCallingLineAssertedIdentityPolicy
    use_system_calling_line_asserted_identity_policy = Field(
        type=bool, required=True, mutable=False,
    )
    #: int: *Required* totalActiveIncomingCalls
    total_active_incoming_calls = Field(type=int, required=True, mutable=False)
    #: int: *Required* totalActiveOutgoingCalls
    total_active_outgoing_calls = Field(type=int, required=True, mutable=False)
    #: str: *Required* pilotUserCallOptimizationPolicy
    pilot_user_call_optimization_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* clidSourceForScreenedCallsPolicy
    clid_source_for_screened_calls_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* useSystemCLIDSourceForScreenedCallsPolicy
    use_system_clid_source_for_screened_calls_policy = Field(
        type=bool, required=True, mutable=False,
    )
    #: str: *Required* userLookupPolicy
    user_lookup_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* useSystemUserLookupPolicy
    use_system_user_lookup_policy = Field(type=bool, required=True, mutable=False)
    #: str: *Required* pilotUserCallingLineIdentityForEmergencyCallsPolicy
    pilot_user_calling_line_identity_for_emergency_calls_policy = Field(
        type=str, required=True, mutable=False,
    )


class GroupTrunkGroupModifyInstanceRequest14sp9A(OCIType):
    """
    Modify a Trunk Group Instance in a group.

    The access device cannot be modified or cleared if there are any users assigned to the
    Trunk Group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "trunk_group_key", "trunkGroupKey", TrunkGroupKey, is_complex=True,
            is_required=True,
        ),
        E("new_name", "newName", str),
        E("pilot_user_id", "pilotUserId", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("access_device", "accessDevice", AccessDevice, is_complex=True),
        E("max_active_calls", "maxActiveCalls", int),
        E("max_incoming_calls", "maxIncomingCalls", int),
        E("max_outgoing_calls", "maxOutgoingCalls", int),
        E("enable_bursting", "enableBursting", bool),
        E("bursting_max_active_calls", "burstingMaxActiveCalls", int),
        E("bursting_max_incoming_calls", "burstingMaxIncomingCalls", int),
        E("bursting_max_outgoing_calls", "burstingMaxOutgoingCalls", int),
        E("capacity_exceeded_action", "capacityExceededAction", str),
        E("capacity_exceeded_forward_address", "capacityExceededForwardAddress", str),
        E(
            "capacity_exceeded_reroute_trunk_group_key",
            "capacityExceededRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E("capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls", int),
        E("capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int),
        E("unreachable_destination_action", "unreachableDestinationAction", str),
        E(
            "unreachable_destination_forward_address",
            "unreachableDestinationForwardAddress", str,
        ),
        E(
            "unreachable_destination_reroute_trunk_group_key",
            "unreachableDestinationRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E(
            "unreachable_destination_trap_initial_calls",
            "unreachableDestinationTrapInitialCalls", int,
        ),
        E(
            "unreachable_destination_trap_offset_calls",
            "unreachableDestinationTrapOffsetCalls", int,
        ),
        E("invitation_timeout", "invitationTimeout", int),
        E("require_authentication", "requireAuthentication", bool),
        E("sip_authentication_user_name", "sipAuthenticationUserName", str),
        E("sip_authentication_password", "sipAuthenticationPassword", str),
        E("hosted_user_id_list", "hostedUserIdList", ReplacementUserIdList, is_complex=True),
        E("trunk_group_identity", "trunkGroupIdentity", str),
        E("otg_dtg_identity", "otgDtgIdentity", str),
        E("include_trunk_group_identity", "includeTrunkGroupIdentity", bool),
        E("include_dtg_identity", "includeDtgIdentity", bool),
        E("enable_network_address_identity", "enableNetworkAddressIdentity", bool),
        E("allow_unscreened_calls", "allowUnscreenedCalls", bool),
        E("allow_unscreened_emergency_calls", "allowUnscreenedEmergencyCalls", bool),
        E(
            "pilot_user_calling_line_identity_policy",
            "pilotUserCallingLineIdentityPolicy", str,
        ),
        E("pilot_user_charge_number_policy", "pilotUserChargeNumberPolicy", str),
        E("call_forwarding_always_action", "callForwardingAlwaysAction", str),
        E(
            "call_forwarding_always_forward_address",
            "callForwardingAlwaysForwardAddress", str,
        ),
        E(
            "call_forwarding_always_reroute_trunk_group_key",
            "callForwardingAlwaysRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
    )

    #: TrunkGroupKey: *Required* trunkGroupKey
    trunk_group_key = Field(type=TrunkGroupKey, required=True, mutable=False)
    #: str: *Optional* newName
    new_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* pilotUserId
    pilot_user_id = Field(type=str, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: AccessDevice: *Optional* accessDevice
    access_device = Field(type=AccessDevice, required=False, mutable=False)
    #: int: *Optional* maxActiveCalls
    max_active_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxIncomingCalls
    max_incoming_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxOutgoingCalls
    max_outgoing_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* enableBursting
    enable_bursting = Field(type=bool, required=False, mutable=False)
    #: int: *Optional* burstingMaxActiveCalls
    bursting_max_active_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* burstingMaxIncomingCalls
    bursting_max_incoming_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* burstingMaxOutgoingCalls
    bursting_max_outgoing_calls = Field(type=int, required=False, mutable=False)
    #: str: *Optional* capacityExceededAction
    capacity_exceeded_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* capacityExceededForwardAddress
    capacity_exceeded_forward_address = Field(type=str, required=False, mutable=False)
    #: TrunkGroupKey: *Optional* capacityExceededRerouteTrunkGroupKey
    capacity_exceeded_reroute_trunk_group_key = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    #: int: *Optional* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(type=int, required=False, mutable=False)
    #: str: *Optional* unreachableDestinationAction
    unreachable_destination_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* unreachableDestinationForwardAddress
    unreachable_destination_forward_address = Field(type=str, required=False, mutable=False)
    #: TrunkGroupKey: *Optional* unreachableDestinationRerouteTrunkGroupKey
    unreachable_destination_reroute_trunk_group_key = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    #: int: *Optional* unreachableDestinationTrapInitialCalls
    unreachable_destination_trap_initial_calls = Field(
        type=int, required=False, mutable=False,
    )
    #: int: *Optional* unreachableDestinationTrapOffsetCalls
    unreachable_destination_trap_offset_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* invitationTimeout
    invitation_timeout = Field(type=int, required=False, mutable=False)
    #: bool: *Optional* requireAuthentication
    require_authentication = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* sipAuthenticationUserName
    sip_authentication_user_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* sipAuthenticationPassword
    sip_authentication_password = Field(type=str, required=False, mutable=False)
    #: ReplacementUserIdList: *Optional* hostedUserIdList
    hosted_user_id_list = Field(type=ReplacementUserIdList, required=False, mutable=False)
    #: str: *Optional* trunkGroupIdentity
    trunk_group_identity = Field(type=str, required=False, mutable=False)
    #: str: *Optional* otgDtgIdentity
    otg_dtg_identity = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* includeTrunkGroupIdentity
    include_trunk_group_identity = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* includeDtgIdentity
    include_dtg_identity = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* enableNetworkAddressIdentity
    enable_network_address_identity = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowUnscreenedCalls
    allow_unscreened_calls = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* allowUnscreenedEmergencyCalls
    allow_unscreened_emergency_calls = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* pilotUserCallingLineIdentityPolicy
    pilot_user_calling_line_identity_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* pilotUserChargeNumberPolicy
    pilot_user_charge_number_policy = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callForwardingAlwaysAction
    call_forwarding_always_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callForwardingAlwaysForwardAddress
    call_forwarding_always_forward_address = Field(type=str, required=False, mutable=False)
    #: TrunkGroupKey: *Optional* callForwardingAlwaysRerouteTrunkGroupKey
    call_forwarding_always_reroute_trunk_group_key = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )


class IncomingCallingPlanDepartmentPermissions(OCIType):
    """
    Allows or disallows various types of incoming calls for a specified department.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_full_path_name", "departmentFullPathName", str, is_required=True),
        E("allow_from_within_group", "allowFromWithinGroup", bool, is_required=True),
        E("allow_from_outside_group", "allowFromOutsideGroup", str, is_required=True),
        E("allow_collect_calls", "allowCollectCalls", bool, is_required=True),
        E(
            "digit_pattern_permission", "digitPatternPermission",
            IncomingCallingPlanDigitPatternPermission, is_complex=True, is_array=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: str: *Required* departmentFullPathName
    department_full_path_name = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowFromWithinGroup
    allow_from_within_group = Field(type=bool, required=True, mutable=False)
    #: str: *Required* allowFromOutsideGroup
    allow_from_outside_group = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowCollectCalls
    allow_collect_calls = Field(type=bool, required=True, mutable=False)
    #: list(IncomingCallingPlanDigitPatternPermission): *Optional* digitPatternPermission
    #: *Array*
    digit_pattern_permission = Field(type=list, required=False, mutable=False)


class IncomingCallingPlanDepartmentPermissionsModify(OCIType):
    """
    Allows or disallows various types of incoming calls for a specified department.

    For use when modifing settings.
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("allow_from_within_group", "allowFromWithinGroup", bool),
        E("allow_from_outside_group", "allowFromOutsideGroup", str),
        E("allow_collect_calls", "allowCollectCalls", bool),
        E(
            "digit_pattern_permission", "digitPatternPermission",
            IncomingCallingPlanDigitPatternPermission, is_complex=True, is_array=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: bool: *Optional* allowFromWithinGroup
    allow_from_within_group = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* allowFromOutsideGroup
    allow_from_outside_group = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowCollectCalls
    allow_collect_calls = Field(type=bool, required=False, mutable=False)
    #: list(IncomingCallingPlanDigitPatternPermission): *Optional* digitPatternPermission
    #: *Array*
    digit_pattern_permission = Field(type=list, required=False, mutable=False)


class IncomingCallingPlanPermissions(OCIType):
    """
    Allows or disallows various types of incoming calls for a user or group -- not any
    particular department.

    """

    _ELEMENTS = (
        E("allow_from_within_group", "allowFromWithinGroup", bool, is_required=True),
        E("allow_from_outside_group", "allowFromOutsideGroup", str, is_required=True),
        E("allow_collect_calls", "allowCollectCalls", bool, is_required=True),
        E(
            "digit_pattern_permission", "digitPatternPermission",
            IncomingCallingPlanDigitPatternPermission, is_complex=True, is_array=True,
        ),
    )

    #: bool: *Required* allowFromWithinGroup
    allow_from_within_group = Field(type=bool, required=True, mutable=False)
    #: str: *Required* allowFromOutsideGroup
    allow_from_outside_group = Field(type=str, required=True, mutable=False)
    #: bool: *Required* allowCollectCalls
    allow_collect_calls = Field(type=bool, required=True, mutable=False)
    #: list(IncomingCallingPlanDigitPatternPermission): *Optional* digitPatternPermission
    #: *Array*
    digit_pattern_permission = Field(type=list, required=False, mutable=False)


class IncomingCallingPlanPermissionsModify(OCIType):
    """
    Allows or disallows various types of incoming calls for a user or group -- not any
    particular department.

    For use when modifing settings.
    """

    _ELEMENTS = (
        E("allow_from_within_group", "allowFromWithinGroup", bool),
        E("allow_from_outside_group", "allowFromOutsideGroup", str),
        E("allow_collect_calls", "allowCollectCalls", bool),
        E(
            "digit_pattern_permission", "digitPatternPermission",
            IncomingCallingPlanDigitPatternPermission, is_complex=True, is_array=True,
        ),
    )

    #: bool: *Optional* allowFromWithinGroup
    allow_from_within_group = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* allowFromOutsideGroup
    allow_from_outside_group = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* allowCollectCalls
    allow_collect_calls = Field(type=bool, required=False, mutable=False)
    #: list(IncomingCallingPlanDigitPatternPermission): *Optional* digitPatternPermission
    #: *Array*
    digit_pattern_permission = Field(type=list, required=False, mutable=False)


class MWIDeliveryToMobileEndpointTemplateBody(OCIType):
    """
    MWI Delivery To Mobile Endpoint template body.

    """

    _ELEMENTS = (
        E(
            "line", "line", MWIDeliveryToMobileEndpointTemplateLine, is_complex=True,
            is_required=True,
        ),
    )

    #: MWIDeliveryToMobileEndpointTemplateLine: *Required* line
    line = Field(type=MWIDeliveryToMobileEndpointTemplateLine, required=True, mutable=False)


class OutgoingCallingPlanCallMeNowDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan for Call Me Now call permissions for a department.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "permissions", "permissions", OutgoingCallingPlanCallMeNowPermissions,
            is_complex=True, is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)
    #: OutgoingCallingPlanCallMeNowPermissions: *Required* permissions
    permissions = Field(
        type=OutgoingCallingPlanCallMeNowPermissions, required=True, mutable=False,
    )


class OutgoingCallingPlanCallMeNowDepartmentPermissionsModify(OCIType):
    """
    Modify outgoing Calling Plan for Call Me Now call permissions for a department.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "permissions", "permissions", OutgoingCallingPlanCallMeNowPermissionsModify,
            is_complex=True, is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: OutgoingCallingPlanCallMeNowPermissionsModify: *Required* permissions
    permissions = Field(
        type=OutgoingCallingPlanCallMeNowPermissionsModify, required=True, mutable=False,
    )


class OutgoingCallingPlanDepartmentAuthorizationCodes(OCIType):
    """
    Outgoing Calling Plan Authorization Code for a department.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "code_entry", "codeEntry", OutgoingCallingPlanAuthorizationCodeEntry,
            is_complex=True, is_array=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)
    #: list(OutgoingCallingPlanAuthorizationCodeEntry): *Optional* codeEntry  *Array*
    code_entry = Field(type=list, required=False, mutable=False)


class OutgoingCallingPlanDepartmentTransferNumbers(OCIType):
    """
    Outgoing Calling Plan transfer numbers for a department.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "transfer_numbers", "transferNumbers", OutgoingCallingPlanTransferNumbers,
            is_complex=True, is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)
    #: OutgoingCallingPlanTransferNumbers: *Required* transferNumbers
    transfer_numbers = Field(
        type=OutgoingCallingPlanTransferNumbers, required=True, mutable=False,
    )


class OutgoingCallingPlanDepartmentTransferNumbersModify(OCIType):
    """
    Outgoing Calling Plan transfer numbers for a department.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "transfer_numbers", "transferNumbers",
            OutgoingCallingPlanTransferNumbersModify, is_complex=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: OutgoingCallingPlanTransferNumbersModify: *Optional* transferNumbers
    transfer_numbers = Field(
        type=OutgoingCallingPlanTransferNumbersModify, required=False, mutable=False,
    )


class OutgoingCallingPlanDigitPatternCallMeNowPermissions(OCIType):
    """
    Outgoing Calling Plan Call Me Now call permissions for specified digit patterns.

    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternCallMeNowPermission, is_complex=True,
            is_required=True,
        ),
    )

    #: OutgoingCallingPlanDigitPatternCallMeNowPermission: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternCallMeNowPermission, required=True,
        mutable=False,
    )


class OutgoingCallingPlanDigitPatternOriginatingPermissions(OCIType):
    """
    Outgoing Calling Plan originating call permissions for specified digit patterns.

    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternOriginatingPermission, is_complex=True,
            is_required=True,
        ),
    )

    #: OutgoingCallingPlanDigitPatternOriginatingPermission: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternOriginatingPermission, required=True,
        mutable=False,
    )


class OutgoingCallingPlanDigitPatternRedirectingPermissions(OCIType):
    """
    Outgoing Calling Plan redirecting call permissions for specified digit patterns.

    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternRedirectingPermission, is_complex=True,
            is_required=True,
        ),
    )

    #: OutgoingCallingPlanDigitPatternRedirectingPermission: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternRedirectingPermission, required=True,
        mutable=False,
    )


class OutgoingCallingPlanGroupAuthorizationCodes(OCIType):
    """
    Outgoing Calling Plan Authorization Code for the group default.

    """

    _ELEMENTS = (
        E(
            "code_entry", "codeEntry", OutgoingCallingPlanAuthorizationCodeEntry,
            is_complex=True, is_array=True,
        ),
    )

    #: list(OutgoingCallingPlanAuthorizationCodeEntry): *Optional* codeEntry  *Array*
    code_entry = Field(type=list, required=False, mutable=False)


class OutgoingCallingPlanOriginatingDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan originating call permissions for a department.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "permissions", "permissions", OutgoingCallingPlanOriginatingPermissions,
            is_complex=True, is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)
    #: OutgoingCallingPlanOriginatingPermissions: *Required* permissions
    permissions = Field(
        type=OutgoingCallingPlanOriginatingPermissions, required=True, mutable=False,
    )


class OutgoingCallingPlanOriginatingDepartmentPermissionsModify(OCIType):
    """
    Outgoing Calling Plan originating call permissions for a department.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "permissions", "permissions", OutgoingCallingPlanOriginatingPermissionsModify,
            is_complex=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: OutgoingCallingPlanOriginatingPermissionsModify: *Optional* permissions
    permissions = Field(
        type=OutgoingCallingPlanOriginatingPermissionsModify, required=False,
        mutable=False,
    )


class OutgoingCallingPlanRedirectedDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan being forwarded/transferred permissions for a department.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "permissions", "permissions", OutgoingCallingPlanRedirectedPermissions,
            is_complex=True, is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)
    #: OutgoingCallingPlanRedirectedPermissions: *Required* permissions
    permissions = Field(
        type=OutgoingCallingPlanRedirectedPermissions, required=True, mutable=False,
    )


class OutgoingCallingPlanRedirectedDepartmentPermissionsModify(OCIType):
    """
    Outgoing Calling Plan being forwarded/transferred permissions for a department.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "permissions", "permissions", OutgoingCallingPlanRedirectedPermissionsModify,
            is_complex=True, is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: OutgoingCallingPlanRedirectedPermissionsModify: *Required* permissions
    permissions = Field(
        type=OutgoingCallingPlanRedirectedPermissionsModify, required=True, mutable=False,
    )


class OutgoingCallingPlanRedirectingDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan initiating call forwards/transfer permissions for a department.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "permissions", "permissions", OutgoingCallingPlanRedirectingPermissions,
            is_complex=True, is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)
    #: OutgoingCallingPlanRedirectingPermissions: *Required* permissions
    permissions = Field(
        type=OutgoingCallingPlanRedirectingPermissions, required=True, mutable=False,
    )


class OutgoingCallingPlanRedirectingDepartmentPermissionsModify(OCIType):
    """
    Outgoing Calling Plan initiating call forwards/transfer permissions for a department.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "permissions", "permissions", OutgoingCallingPlanRedirectingPermissionsModify,
            is_complex=True, is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: OutgoingCallingPlanRedirectingPermissionsModify: *Required* permissions
    permissions = Field(
        type=OutgoingCallingPlanRedirectingPermissionsModify, required=True, mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan Call Me Now call permissions for specified digit patterns.

    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternCallMeNowPermission, is_complex=True,
            is_required=True,
        ),
    )

    #: OutgoingPinholeDigitPlanDigitPatternCallMeNowPermission: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternCallMeNowPermission, required=True,
        mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan originating call permissions for specified digit patterns.

    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternOriginatingPermission, is_complex=True,
            is_required=True,
        ),
    )

    #: OutgoingPinholeDigitPlanDigitPatternOriginatingPermission: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternOriginatingPermission, required=True,
        mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan redirecting call permissions for specified digit patterns.

    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternRedirectingPermission, is_complex=True,
            is_required=True,
        ),
    )

    #: OutgoingPinholeDigitPlanDigitPatternRedirectingPermission: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternRedirectingPermission, required=True,
        mutable=False,
    )


class PriorityAlertCriteriaFromDnModify(OCIType):
    """
    The from dn criteria used within a modify request.

    """

    _ELEMENTS = (
        E("from_dn_criteria_selection", "fromDnCriteriaSelection", str),
        E("include_anonymous_callers", "includeAnonymousCallers", bool),
        E("include_unavailable_callers", "includeUnavailableCallers", bool),
        E("phone_number_list", "phoneNumberList", CriteriaReplacementDNList, is_complex=True),
    )

    #: str: *Optional* fromDnCriteriaSelection
    from_dn_criteria_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* includeAnonymousCallers
    include_anonymous_callers = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* includeUnavailableCallers
    include_unavailable_callers = Field(type=bool, required=False, mutable=False)
    #: CriteriaReplacementDNList: *Optional* phoneNumberList
    phone_number_list = Field(type=CriteriaReplacementDNList, required=False, mutable=False)


class ReplacementCallToNumberList(OCIType):
    """
    A list of Call to Numbers that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.  For the
    callToNumbers, the extension element is not used and the number element is only used
    when the type is BroadWorks Mobility.
    """

    _ELEMENTS = (
        E("call_to_number", "callToNumber", CallToNumber, is_complex=True, is_required=True),
    )

    #: CallToNumber: *Required* callToNumber
    call_to_number = Field(type=CallToNumber, required=True, mutable=False)


class ReplacementCommunicationBarringCallMeNowRuleList(OCIType):
    """
    A list of Communication Barring CallMeNow Rules that replaces a previously configured
    list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "rule", "rule", CommunicationBarringCallMeNowRule, is_complex=True,
            is_required=True,
        ),
    )

    #: CommunicationBarringCallMeNowRule: *Required* rule
    rule = Field(type=CommunicationBarringCallMeNowRule, required=True, mutable=False)


class ReplacementCommunicationBarringIncomingRuleList(OCIType):
    """
    A list of Communication Barring Incoming Rules that replaces a previously configured
    list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "rule", "rule", CommunicationBarringIncomingRule, is_complex=True,
            is_required=True,
        ),
    )

    #: CommunicationBarringIncomingRule: *Required* rule
    rule = Field(type=CommunicationBarringIncomingRule, required=True, mutable=False)


class ReplacementCommunicationBarringIncomingRuleList19sp1(OCIType):
    """
    A list of Communication Barring Incoming Rules that replaces a previously configured
    list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "rule", "rule", CommunicationBarringIncomingRule19sp1, is_complex=True,
            is_required=True,
        ),
    )

    #: CommunicationBarringIncomingRule19sp1: *Required* rule
    rule = Field(type=CommunicationBarringIncomingRule19sp1, required=True, mutable=False)


class ReplacementCommunicationBarringOriginatingRuleList(OCIType):
    """
    A list of Communication Barring Originating Rules that replaces a previously
    configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "rule", "rule", CommunicationBarringOriginatingRule, is_complex=True,
            is_required=True,
        ),
    )

    #: CommunicationBarringOriginatingRule: *Required* rule
    rule = Field(type=CommunicationBarringOriginatingRule, required=True, mutable=False)


class ReplacementCommunicationBarringRedirectingRuleList(OCIType):
    """
    A list of Communication Barring Redirecting Rules that replaces a previously
    configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "rule", "rule", CommunicationBarringRedirectingRule, is_complex=True,
            is_required=True,
        ),
    )

    #: CommunicationBarringRedirectingRule: *Required* rule
    rule = Field(type=CommunicationBarringRedirectingRule, required=True, mutable=False)


class ReplacementCustomContactDirectoryEntryList(OCIType):
    """
    A list of userIds and/or Virtual On-Net user DNs that replaces a previously configured
    list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("entry", "entry", CustomContactDirectoryEntry, is_complex=True, is_required=True),
    )

    #: CustomContactDirectoryEntry: *Required* entry
    entry = Field(type=CustomContactDirectoryEntry, required=True, mutable=False)


class ReplacementDeviceList(OCIType):
    """
    A list of devices that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("device", "device", AccessDevice, is_complex=True, is_required=True),
    )

    #: AccessDevice: *Required* device
    device = Field(type=AccessDevice, required=True, mutable=False)


class ReplacementEnterpriseEnterpriseTrunkTrunkGroupKeyList(OCIType):
    """
    A list of Enterprise Trunk Krunk Group Keys that replaces a previously configured
    list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "trunk_group", "trunkGroup", EnterpriseTrunkTrunkGroupKey, is_complex=True,
            is_required=True,
        ),
    )

    #: EnterpriseTrunkTrunkGroupKey: *Required* trunkGroup
    trunk_group = Field(type=EnterpriseTrunkTrunkGroupKey, required=True, mutable=False)


class ReplacementEnterpriseTrunkTrunkGroupKeyList(OCIType):
    """
    A list of Enterprise Trunk Krunk Group Keys that replaces a previously configured
    list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "trunk_group_list", "trunkGroupList", EnterpriseTrunkTrunkGroupKey,
            is_complex=True, is_required=True,
        ),
    )

    #: EnterpriseTrunkTrunkGroupKey: *Required* trunkGroupList
    trunk_group_list = Field(type=EnterpriseTrunkTrunkGroupKey, required=True, mutable=False)


class ReplacementGroupEnterpriseTrunkPriorityWeightedTrunkGroupList(OCIType):
    """
    A list of enterprise trunk priority weighted trunk groups in a group that replaces a
    previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "trunk_group", "trunkGroup", GroupEnterpriseTrunkPriorityWeightedTrunkGroup,
            is_complex=True, is_required=True,
        ),
    )

    #: GroupEnterpriseTrunkPriorityWeightedTrunkGroup: *Required* trunkGroup
    trunk_group = Field(
        type=GroupEnterpriseTrunkPriorityWeightedTrunkGroup, required=True, mutable=False,
    )


class ScheduleEvents(OCIType):
    """
    Retrives all Holiday or Time Event details for a given schedulel Level.

    """

    _ELEMENTS = (
        E("eventname", "eventname", str, is_required=True),
        E("start_date", "startDate", str, is_required=True),
        E("all_day_event", "allDayEvent", bool),
        E("start_time", "startTime", HourMinute, is_complex=True, is_required=True),
        E("end_time", "endTime", HourMinute, is_complex=True, is_required=True),
        E("end_date", "endDate", str, is_required=True),
        E("recurrence", "recurrence", Recurrence, is_complex=True),
    )

    #: str: *Required* eventname
    eventname = Field(type=str, required=True, mutable=False)
    #: str: *Required* startDate
    start_date = Field(type=str, required=True, mutable=False)
    #: bool: *Optional* allDayEvent
    all_day_event = Field(type=bool, required=False, mutable=False)
    #: HourMinute: *Required* startTime
    start_time = Field(type=HourMinute, required=True, mutable=False)
    #: HourMinute: *Required* endTime
    end_time = Field(type=HourMinute, required=True, mutable=False)
    #: str: *Required* endDate
    end_date = Field(type=str, required=True, mutable=False)
    #: Recurrence: *Optional* recurrence
    recurrence = Field(type=Recurrence, required=False, mutable=False)


class ScheduleGlobalKey(OCIType):
    """
    Uniquely identifies Holiday and Time Schedules throughout all System, Service
    Provider, Group and User level.

    """

    _ELEMENTS = (
        E("schedule_key", "scheduleKey", ScheduleKey, is_complex=True, is_required=True),
        E("schedule_level", "scheduleLevel", str, is_required=True),
    )

    #: ScheduleKey: *Required* scheduleKey
    schedule_key = Field(type=ScheduleKey, required=True, mutable=False)
    #: str: *Required* scheduleLevel
    schedule_level = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactCallCenterReportTemplateKey(OCIType):
    """
    Criteria for searching for a particular call center enhanced reporting report
    template.

    """

    _ELEMENTS = (
        E(
            "report_template", "reportTemplate", CallCenterReportTemplateKey,
            is_complex=True, is_required=True,
        ),
    )

    #: CallCenterReportTemplateKey: *Required* reportTemplate
    report_template = Field(type=CallCenterReportTemplateKey, required=True, mutable=False)


class SearchCriteriaExactDnDepartment(OCIType):
    """
    Criteria for searching for a particular fully specified DN's department.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)


class SearchCriteriaExactUserDepartment(OCIType):
    """
    Criteria for searching for a particular fully specified user's department.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)


class SelectiveCallRejectionCriteriaCallTypeModify(OCIType):
    """
    The call type criteria used within a modify request.

    """

    _ELEMENTS = (
        E("from_dn_criteria_selection", "fromDnCriteriaSelection", str),
        E("include_anonymous_callers", "includeAnonymousCallers", bool),
        E("include_unavailable_callers", "includeUnavailableCallers", bool),
        E("phone_number_list", "phoneNumberList", CriteriaReplacementDNList, is_complex=True),
    )

    #: str: *Optional* fromDnCriteriaSelection
    from_dn_criteria_selection = Field(type=str, required=False, mutable=False)
    #: bool: *Optional* includeAnonymousCallers
    include_anonymous_callers = Field(type=bool, required=False, mutable=False)
    #: bool: *Optional* includeUnavailableCallers
    include_unavailable_callers = Field(type=bool, required=False, mutable=False)
    #: CriteriaReplacementDNList: *Optional* phoneNumberList
    phone_number_list = Field(type=CriteriaReplacementDNList, required=False, mutable=False)


class ServiceInstanceAddProfile(OCIType):
    """
    Service Profile Information for group service.

    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("password", "password", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("alias", "alias", str),
        E("public_user_identity", "publicUserIdentity", str),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZone
    time_zone = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alias
    alias = Field(type=str, required=False, mutable=False)
    #: str: *Optional* publicUserIdentity
    public_user_identity = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(type=str, required=False, mutable=False)


class ServiceInstanceAddProfileCallCenter(OCIType):
    """
    Service Profile Information for a call center.

    Password is required.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("password", "password", str, is_required=True),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("alias", "alias", str),
        E("public_user_identity", "publicUserIdentity", str),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: str: *Required* password
    password = Field(type=str, required=True, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZone
    time_zone = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alias
    alias = Field(type=str, required=False, mutable=False)
    #: str: *Optional* publicUserIdentity
    public_user_identity = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(type=str, required=False, mutable=False)


class ServiceInstanceAddProfileFlexibleSeatingHost(OCIType):
    """
    Service Profile Information for a flexible seating host.

    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("password", "password", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZone
    time_zone = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(type=str, required=False, mutable=False)


class ServiceInstanceAddProfileTrunkGroup(OCIType):
    """
    Service Profile Information for a trunk group.

    The publicUserIdentity element is not part of ServiceInstanceAddProfileTrunkGroup.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("password", "password", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("alias", "alias", str),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZone
    time_zone = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alias
    alias = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(type=str, required=False, mutable=False)


class ServiceInstanceModifyProfile(OCIType):
    """
    Service Profile Information for group service used when modifying an existing service
    instance.

    """

    _ELEMENTS = (
        E("name", "name", str),
        E("calling_line_id_last_name", "callingLineIdLastName", str),
        E("calling_line_id_first_name", "callingLineIdFirstName", str),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("password", "password", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("sip_alias_list", "sipAliasList", ReplacementSIPAliasList, is_complex=True),
        E("public_user_identity", "publicUserIdentity", str),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    #: str: *Optional* name
    name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZone
    time_zone = Field(type=str, required=False, mutable=False)
    #: ReplacementSIPAliasList: *Optional* sipAliasList
    sip_alias_list = Field(type=ReplacementSIPAliasList, required=False, mutable=False)
    #: str: *Optional* publicUserIdentity
    public_user_identity = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(type=str, required=False, mutable=False)


class ServiceInstanceModifyProfileFlexibleSeatingHost(OCIType):
    """
    Service Profile Information for a flexible seating host
    """

    _ELEMENTS = (
        E("name", "name", str),
        E("calling_line_id_last_name", "callingLineIdLastName", str),
        E("calling_line_id_first_name", "callingLineIdFirstName", str),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("password", "password", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    #: str: *Optional* name
    name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZone
    time_zone = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(type=str, required=False, mutable=False)


class ServiceInstanceModifyProfileTrunkGroup(OCIType):
    """
    Service Profile Information for a trunk group used when modifying an existing service
    instance.

    """

    _ELEMENTS = (
        E("name", "name", str),
        E("calling_line_id_last_name", "callingLineIdLastName", str),
        E("calling_line_id_first_name", "callingLineIdFirstName", str),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("password", "password", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("sip_alias_list", "sipAliasList", ReplacementSIPAliasList, is_complex=True),
    )

    #: str: *Optional* name
    name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZone
    time_zone = Field(type=str, required=False, mutable=False)
    #: ReplacementSIPAliasList: *Optional* sipAliasList
    sip_alias_list = Field(type=ReplacementSIPAliasList, required=False, mutable=False)


class ServiceInstanceReadProfile(OCIType):
    """
    Service Profile Information for group service.

    It is identical to the ServiceInstanceAddProfile, but without the password.  Prior to
    release 14 this was called ServiceInstanceProfile.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("time_zone_display_name", "timeZoneDisplayName", str),
        E("alias", "alias", str),
        E("public_user_identity", "publicUserIdentity", str),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZone
    time_zone = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZoneDisplayName
    time_zone_display_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alias
    alias = Field(type=str, required=False, mutable=False)
    #: str: *Optional* publicUserIdentity
    public_user_identity = Field(type=str, required=False, mutable=False)


class ServiceInstanceReadProfile17(OCIType):
    """
    Service Profile Information for group service.

    It is identical to the ServiceInstanceAddProfile, but without the password.  Replaced
    by: ServiceInstanceReadProfile17sp4
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("time_zone_display_name", "timeZoneDisplayName", str),
        E("alias", "alias", str),
        E("public_user_identity", "publicUserIdentity", str),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZone
    time_zone = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZoneDisplayName
    time_zone_display_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alias
    alias = Field(type=str, required=False, mutable=False)
    #: str: *Optional* publicUserIdentity
    public_user_identity = Field(type=str, required=False, mutable=False)


class ServiceInstanceReadProfile17sp4(OCIType):
    """
    Service Profile Information for group service.

    Replaced by: ServiceInstanceReadProfile19sp1
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("country_code", "countryCode", str),
        E("national_prefix", "nationalPrefix", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("time_zone_display_name", "timeZoneDisplayName", str),
        E("alias", "alias", str),
        E("public_user_identity", "publicUserIdentity", str),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: str: *Optional* countryCode
    country_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* nationalPrefix
    national_prefix = Field(type=str, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZone
    time_zone = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZoneDisplayName
    time_zone_display_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alias
    alias = Field(type=str, required=False, mutable=False)
    #: str: *Optional* publicUserIdentity
    public_user_identity = Field(type=str, required=False, mutable=False)


class ServiceInstanceReadProfile19sp1(OCIType):
    """
    Service Profile Information for group service.

    The callingLineIdPhoneNumber is no longer being formatted for display purpose.  The
    value is returned exactly the same as being stored.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("country_code", "countryCode", str),
        E("national_prefix", "nationalPrefix", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("time_zone_display_name", "timeZoneDisplayName", str),
        E("alias", "alias", str),
        E("public_user_identity", "publicUserIdentity", str),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* phoneNumber
    phone_number = Field(type=str, required=False, mutable=False)
    #: str: *Optional* extension
    extension = Field(type=str, required=False, mutable=False)
    #: str: *Optional* countryCode
    country_code = Field(type=str, required=False, mutable=False)
    #: str: *Optional* nationalPrefix
    national_prefix = Field(type=str, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZone
    time_zone = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZoneDisplayName
    time_zone_display_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alias
    alias = Field(type=str, required=False, mutable=False)
    #: str: *Optional* publicUserIdentity
    public_user_identity = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(type=str, required=False, mutable=False)


class ServicePackAuthorization(OCIType):
    """
    Authorize (with quantity) or unauthorize a service pack.

    """

    _ELEMENTS = (
        E("service_pack_name", "servicePackName", str, is_required=True),
        E("authorized_quantity", "authorizedQuantity", UnboundedPositiveInt, is_complex=True),
        E("unauthorized", "unauthorized", bool),
    )

    #: str: *Required* servicePackName
    service_pack_name = Field(type=str, required=True, mutable=False)
    #: UnboundedPositiveInt: *Optional* authorizedQuantity
    authorized_quantity = Field(type=UnboundedPositiveInt, required=False, mutable=False)
    #: bool: *Optional* unauthorized
    unauthorized = Field(type=bool, required=False, mutable=False)


class ServiceProviderCommunicationBarringProfileGetResponse19sp1V2(OCIType):
    """
    Response to the ServiceProviderCommunicationBarringProfileGetRequest19sp1V2.

    The response contains the Communication Barring Profile information.  The incoming,
    originating, redirecting and call me now rules are returned in ascending priority
    order.  The following elements are only used in AS data mode: callMeNowDefaultAction
    callMeNowDefaultCallTimeout callMeNowRule applyToAttendedCallTransfers
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("originating_default_action", "originatingDefaultAction", str, is_required=True),
        E("originating_default_treatment_id", "originatingDefaultTreatmentId", str),
        E("originating_default_transfer_number", "originatingDefaultTransferNumber", str),
        E("originating_default_call_timeout", "originatingDefaultCallTimeout", int),
        E(
            "originating_rule", "originatingRule",
            ServiceProviderCommunicationBarringHierarchicalOriginatingRule,
            is_complex=True, is_array=True,
        ),
        E("redirecting_default_action", "redirectingDefaultAction", str, is_required=True),
        E("redirecting_default_call_timeout", "redirectingDefaultCallTimeout", int),
        E(
            "redirecting_rule", "redirectingRule",
            ServiceProviderCommunicationBarringHierarchicalRedirectingRule,
            is_complex=True, is_array=True,
        ),
        E("call_me_now_default_action", "callMeNowDefaultAction", str, is_required=True),
        E("call_me_now_default_call_timeout", "callMeNowDefaultCallTimeout", int),
        E(
            "call_me_now_rule", "callMeNowRule",
            ServiceProviderCommunicationBarringHierarchicalCallMeNowRule, is_complex=True,
            is_array=True,
        ),
        E("incoming_default_action", "incomingDefaultAction", str, is_required=True),
        E("incoming_default_call_timeout", "incomingDefaultCallTimeout", int),
        E(
            "incoming_rule", "incomingRule", CommunicationBarringIncomingRule19sp1,
            is_complex=True, is_array=True,
        ),
        E("is_default", "isDefault", bool, is_required=True),
        E(
            "apply_to_attended_call_transfers", "applyToAttendedCallTransfers", bool,
            is_required=True,
        ),
    )

    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Required* originatingDefaultAction
    originating_default_action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* originatingDefaultTreatmentId
    originating_default_treatment_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* originatingDefaultTransferNumber
    originating_default_transfer_number = Field(type=str, required=False, mutable=False)
    #: int: *Optional* originatingDefaultCallTimeout
    originating_default_call_timeout = Field(type=int, required=False, mutable=False)
    #: list(ServiceProviderCommunicationBarringHierarchicalOriginatingRule): *Optional*
    #: originatingRule  *Array*
    originating_rule = Field(type=list, required=False, mutable=False)
    #: str: *Required* redirectingDefaultAction
    redirecting_default_action = Field(type=str, required=True, mutable=False)
    #: int: *Optional* redirectingDefaultCallTimeout
    redirecting_default_call_timeout = Field(type=int, required=False, mutable=False)
    #: list(ServiceProviderCommunicationBarringHierarchicalRedirectingRule): *Optional*
    #: redirectingRule  *Array*
    redirecting_rule = Field(type=list, required=False, mutable=False)
    #: str: *Required* callMeNowDefaultAction
    call_me_now_default_action = Field(type=str, required=True, mutable=False)
    #: int: *Optional* callMeNowDefaultCallTimeout
    call_me_now_default_call_timeout = Field(type=int, required=False, mutable=False)
    #: list(ServiceProviderCommunicationBarringHierarchicalCallMeNowRule): *Optional*
    #: callMeNowRule  *Array*
    call_me_now_rule = Field(type=list, required=False, mutable=False)
    #: str: *Required* incomingDefaultAction
    incoming_default_action = Field(type=str, required=True, mutable=False)
    #: int: *Optional* incomingDefaultCallTimeout
    incoming_default_call_timeout = Field(type=int, required=False, mutable=False)
    #: list(CommunicationBarringIncomingRule19sp1): *Optional* incomingRule  *Array*
    incoming_rule = Field(type=list, required=False, mutable=False)
    #: bool: *Required* isDefault
    is_default = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* applyToAttendedCallTransfers
    apply_to_attended_call_transfers = Field(type=bool, required=True, mutable=False)


class ServiceProviderReplacementCommunicationBarringHierarchicalCallMeNowRuleList(OCIType):
    """
    A list of Service Provider Communication Barring Hierarchical Call Me Now Rules that
    replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "rule", "rule", ServiceProviderCommunicationBarringHierarchicalCallMeNowRule,
            is_complex=True, is_required=True,
        ),
    )

    #: ServiceProviderCommunicationBarringHierarchicalCallMeNowRule: *Required* rule
    rule = Field(
        type=ServiceProviderCommunicationBarringHierarchicalCallMeNowRule, required=True,
        mutable=False,
    )


class ServiceProviderReplacementCommunicationBarringHierarchicalOriginatingRuleList(OCIType):
    """
    A list of Service Provider Communication Barring Hierarchical Originating Rules that
    replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "rule", "rule",
            ServiceProviderCommunicationBarringHierarchicalOriginatingRule,
            is_complex=True, is_required=True,
        ),
    )

    #: ServiceProviderCommunicationBarringHierarchicalOriginatingRule: *Required* rule
    rule = Field(
        type=ServiceProviderCommunicationBarringHierarchicalOriginatingRule,
        required=True, mutable=False,
    )


class ServiceProviderReplacementCommunicationBarringHierarchicalRedirectingRuleList(OCIType):
    """
    A list of Service Provider Communication Barring Hierarchical Redirecting Rules that
    replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "rule", "rule",
            ServiceProviderCommunicationBarringHierarchicalRedirectingRule,
            is_complex=True, is_required=True,
        ),
    )

    #: ServiceProviderCommunicationBarringHierarchicalRedirectingRule: *Required* rule
    rule = Field(
        type=ServiceProviderCommunicationBarringHierarchicalRedirectingRule,
        required=True, mutable=False,
    )


class ShInterfaceUserIdDataEntry(OCIType):
    """
    ShInterface User Id Data Entry.

    """

    _ELEMENTS = (
        E("user_type", "userType", str, is_required=True),
        E(
            "public_user_identity", "publicUserIdentity", PublicUserIdentity,
            is_complex=True, is_required=True,
        ),
        E("endpoint_type", "endpointType", str, is_required=True),
        E("scscf_name", "SCSCFName", str),
        E("ims_user_state", "IMSUserState", str, is_required=True),
    )

    #: str: *Required* userType
    user_type = Field(type=str, required=True, mutable=False)
    #: PublicUserIdentity: *Required* publicUserIdentity
    public_user_identity = Field(type=PublicUserIdentity, required=True, mutable=False)
    #: str: *Required* endpointType
    endpoint_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* SCSCFName
    scscf_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* IMSUserState
    ims_user_state = Field(type=str, required=True, mutable=False)


class ShInterfaceUserListEntry(OCIType):
    """
    ShInterface User List Entry.

    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("user_type", "userType", str, is_required=True),
        E(
            "public_user_identity", "publicUserIdentity", PublicUserIdentity,
            is_complex=True, is_required=True,
        ),
        E("endpoint_type", "endpointType", str, is_required=True),
        E("scscf_name", "SCSCFName", str),
        E("ims_user_state", "IMSUserState", str, is_required=True),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* userType
    user_type = Field(type=str, required=True, mutable=False)
    #: PublicUserIdentity: *Required* publicUserIdentity
    public_user_identity = Field(type=PublicUserIdentity, required=True, mutable=False)
    #: str: *Required* endpointType
    endpoint_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* SCSCFName
    scscf_name = Field(type=str, required=False, mutable=False)
    #: str: *Required* IMSUserState
    ims_user_state = Field(type=str, required=True, mutable=False)


class SimultaneousRingReplacementNumberList(OCIType):
    """
    A list of Simultaneous Ring numbers that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "simultaneous_ring_number", "simultaneousRingNumber", SimultaneousRingNumber,
            is_complex=True, is_required=True,
        ),
    )

    #: SimultaneousRingNumber: *Required* simultaneousRingNumber
    simultaneous_ring_number = Field(
        type=SimultaneousRingNumber, required=True, mutable=False,
    )


class SystemCommunicationBarringProfileGetResponse19sp1V2(OCIType):
    """
    Response to the SystemCommunicationBarringProfileGetRequest19sp1V2.

    The response contains the Communication Barring Profile information.  The incoming
    rules are returned in ascending priority order.  The following elements are only used
    in AS data mode: callMeNowDefaultAction callMeNowDefaultCallTimeout callMeNowRule
    applyToAttendedCallTransfers
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("originating_default_action", "originatingDefaultAction", str, is_required=True),
        E("originating_default_treatment_id", "originatingDefaultTreatmentId", str),
        E("originating_default_transfer_number", "originatingDefaultTransferNumber", str),
        E("originating_default_call_timeout", "originatingDefaultCallTimeout", int),
        E(
            "originating_rule", "originatingRule", CommunicationBarringOriginatingRule,
            is_complex=True, is_array=True,
        ),
        E("redirecting_default_action", "redirectingDefaultAction", str, is_required=True),
        E("redirecting_default_call_timeout", "redirectingDefaultCallTimeout", int),
        E(
            "redirecting_rule", "redirectingRule", CommunicationBarringRedirectingRule,
            is_complex=True, is_array=True,
        ),
        E("incoming_default_action", "incomingDefaultAction", str, is_required=True),
        E("incoming_default_call_timeout", "incomingDefaultCallTimeout", int),
        E(
            "incoming_rule", "incomingRule", CommunicationBarringIncomingRule19sp1,
            is_complex=True, is_array=True,
        ),
        E("call_me_now_default_action", "callMeNowDefaultAction", str, is_required=True),
        E("call_me_now_default_call_timeout", "callMeNowDefaultCallTimeout", int),
        E(
            "call_me_now_rule", "callMeNowRule", CommunicationBarringCallMeNowRule,
            is_complex=True, is_array=True,
        ),
        E(
            "apply_to_attended_call_transfers", "applyToAttendedCallTransfers", bool,
            is_required=True,
        ),
    )

    #: str: *Optional* description
    description = Field(type=str, required=False, mutable=False)
    #: str: *Required* originatingDefaultAction
    originating_default_action = Field(type=str, required=True, mutable=False)
    #: str: *Optional* originatingDefaultTreatmentId
    originating_default_treatment_id = Field(type=str, required=False, mutable=False)
    #: str: *Optional* originatingDefaultTransferNumber
    originating_default_transfer_number = Field(type=str, required=False, mutable=False)
    #: int: *Optional* originatingDefaultCallTimeout
    originating_default_call_timeout = Field(type=int, required=False, mutable=False)
    #: list(CommunicationBarringOriginatingRule): *Optional* originatingRule  *Array*
    originating_rule = Field(type=list, required=False, mutable=False)
    #: str: *Required* redirectingDefaultAction
    redirecting_default_action = Field(type=str, required=True, mutable=False)
    #: int: *Optional* redirectingDefaultCallTimeout
    redirecting_default_call_timeout = Field(type=int, required=False, mutable=False)
    #: list(CommunicationBarringRedirectingRule): *Optional* redirectingRule  *Array*
    redirecting_rule = Field(type=list, required=False, mutable=False)
    #: str: *Required* incomingDefaultAction
    incoming_default_action = Field(type=str, required=True, mutable=False)
    #: int: *Optional* incomingDefaultCallTimeout
    incoming_default_call_timeout = Field(type=int, required=False, mutable=False)
    #: list(CommunicationBarringIncomingRule19sp1): *Optional* incomingRule  *Array*
    incoming_rule = Field(type=list, required=False, mutable=False)
    #: str: *Required* callMeNowDefaultAction
    call_me_now_default_action = Field(type=str, required=True, mutable=False)
    #: int: *Optional* callMeNowDefaultCallTimeout
    call_me_now_default_call_timeout = Field(type=int, required=False, mutable=False)
    #: list(CommunicationBarringCallMeNowRule): *Optional* callMeNowRule  *Array*
    call_me_now_rule = Field(type=list, required=False, mutable=False)
    #: bool: *Required* applyToAttendedCallTransfers
    apply_to_attended_call_transfers = Field(type=bool, required=True, mutable=False)


class TrunkAddressingAdd(OCIType):
    """
    Trunk group endpoint.

    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint", "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceEndpointAdd, is_complex=True,
        ),
        E("enterprise_trunk_name", "enterpriseTrunkName", str),
        E("alternate_trunk_identity", "alternateTrunkIdentity", str),
    )

    #: TrunkGroupDeviceEndpointAdd: *Optional* trunkGroupDeviceEndpoint
    trunk_group_device_endpoint = Field(
        type=TrunkGroupDeviceEndpointAdd, required=False, mutable=False,
    )
    #: str: *Optional* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateTrunkIdentity
    alternate_trunk_identity = Field(type=str, required=False, mutable=False)


class TrunkAddressingModify(OCIType):
    """
    Trunk group endpoint.

    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint", "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceEndpointModify, is_complex=True,
        ),
        E("enterprise_trunk_name", "enterpriseTrunkName", str),
        E("alternate_trunk_identity", "alternateTrunkIdentity", str),
    )

    #: TrunkGroupDeviceEndpointModify: *Optional* trunkGroupDeviceEndpoint
    trunk_group_device_endpoint = Field(
        type=TrunkGroupDeviceEndpointModify, required=False, mutable=False,
    )
    #: str: *Optional* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateTrunkIdentity
    alternate_trunk_identity = Field(type=str, required=False, mutable=False)


class TrunkAddressingMultipleContactAdd(OCIType):
    """
    Trunk group endpoint that can have multiple contacts.

    alternateTrunkIdentityDomain is only used in IMS mode.  Both alternateTrunkIdentity
    and AlternateTrunkIdentityDomain should be set at the same time if one is set in IMS
    mode.
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint", "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceMultipleContactEndpointAdd, is_complex=True,
        ),
        E("enterprise_trunk_name", "enterpriseTrunkName", str),
        E("alternate_trunk_identity", "alternateTrunkIdentity", str),
        E("alternate_trunk_identity_domain", "alternateTrunkIdentityDomain", str),
    )

    #: TrunkGroupDeviceMultipleContactEndpointAdd: *Optional* trunkGroupDeviceEndpoint
    trunk_group_device_endpoint = Field(
        type=TrunkGroupDeviceMultipleContactEndpointAdd, required=False, mutable=False,
    )
    #: str: *Optional* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateTrunkIdentity
    alternate_trunk_identity = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateTrunkIdentityDomain
    alternate_trunk_identity_domain = Field(type=str, required=False, mutable=False)


class TrunkAddressingMultipleContactRead(OCIType):
    """
    Trunk group endpoint that can have multiple contacts.

    Replaced by: TrunkAddressingMultipleContactRead21
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint", "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceMultipleContactEndpointRead, is_complex=True,
        ),
        E("enterprise_trunk_name", "enterpriseTrunkName", str),
        E("alternate_trunk_identity", "alternateTrunkIdentity", str),
    )

    #: TrunkGroupDeviceMultipleContactEndpointRead: *Optional* trunkGroupDeviceEndpoint
    trunk_group_device_endpoint = Field(
        type=TrunkGroupDeviceMultipleContactEndpointRead, required=False, mutable=False,
    )
    #: str: *Optional* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateTrunkIdentity
    alternate_trunk_identity = Field(type=str, required=False, mutable=False)


class TrunkAddressingMultipleContactRead21(OCIType):
    """
    Trunk group endpoint that can have multiple contacts.

    alternateTrunkIdentityDomain is only used in IMS mode.  The following elements are
    only used in AS data mode and ignored in HSS data mode: alternateTrunkIdentityDomain
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint", "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceMultipleContactEndpointRead, is_complex=True,
        ),
        E("enterprise_trunk_name", "enterpriseTrunkName", str),
        E("alternate_trunk_identity", "alternateTrunkIdentity", str),
        E("alternate_trunk_identity_domain", "alternateTrunkIdentityDomain", str),
    )

    #: TrunkGroupDeviceMultipleContactEndpointRead: *Optional* trunkGroupDeviceEndpoint
    trunk_group_device_endpoint = Field(
        type=TrunkGroupDeviceMultipleContactEndpointRead, required=False, mutable=False,
    )
    #: str: *Optional* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateTrunkIdentity
    alternate_trunk_identity = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateTrunkIdentityDomain
    alternate_trunk_identity_domain = Field(type=str, required=False, mutable=False)


class TrunkAddressingRead(OCIType):
    """
    Trunk group endpoint.

    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint", "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceEndpointRead14sp4, is_complex=True,
        ),
        E("enterprise_trunk_name", "enterpriseTrunkName", str),
        E("alternate_trunk_identity", "alternateTrunkIdentity", str),
    )

    #: TrunkGroupDeviceEndpointRead14sp4: *Optional* trunkGroupDeviceEndpoint
    trunk_group_device_endpoint = Field(
        type=TrunkGroupDeviceEndpointRead14sp4, required=False, mutable=False,
    )
    #: str: *Optional* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateTrunkIdentity
    alternate_trunk_identity = Field(type=str, required=False, mutable=False)


class TrunkGroupDeviceMultipleContactEndpointModify(OCIType):
    """
    Trunk group device endpoint used in the context of modify that can have multiple
    contacts.

    """

    _ELEMENTS = (
        E("name", "name", str),
        E("line_port", "linePort", str),
        E("contact_list", "contactList", ReplacementContactList, is_complex=True),
    )

    #: str: *Optional* name
    name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* linePort
    line_port = Field(type=str, required=False, mutable=False)
    #: ReplacementContactList: *Optional* contactList
    contact_list = Field(type=ReplacementContactList, required=False, mutable=False)


class TrunkGroupMultipleContactPilotUser(OCIType):
    """
    Trunk Group pilot user information used when adding a Trunk Group.

    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("last_name", "lastName", str, is_required=True),
        E("first_name", "firstName", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("password", "password", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* lastName
    last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* firstName
    first_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZone
    time_zone = Field(type=str, required=False, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(type=str, required=False, mutable=False)


class TrunkGroupPilotUser(OCIType):
    """
    Trunk Group pilot user information used when adding a Trunk Group.

    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("last_name", "lastName", str, is_required=True),
        E("first_name", "firstName", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("password", "password", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* lastName
    last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* firstName
    first_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=True, mutable=False)
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* password
    password = Field(type=str, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: str: *Optional* language
    language = Field(type=str, required=False, mutable=False)
    #: str: *Optional* timeZone
    time_zone = Field(type=str, required=False, mutable=False)
    #: str: *Required* linePort
    line_port = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)


class UserServiceAuthorization(OCIType):
    """
    Authorize (with quantity) or unauthorize a user service.

    """

    _ELEMENTS = (
        E("service_name", "serviceName", str, is_required=True),
        E("authorized_quantity", "authorizedQuantity", UnboundedPositiveInt, is_complex=True),
        E("unauthorized", "unauthorized", bool),
    )

    #: str: *Required* serviceName
    service_name = Field(type=str, required=True, mutable=False)
    #: UnboundedPositiveInt: *Optional* authorizedQuantity
    authorized_quantity = Field(type=UnboundedPositiveInt, required=False, mutable=False)
    #: bool: *Optional* unauthorized
    unauthorized = Field(type=bool, required=False, mutable=False)


class VerifyTranslationAndRoutingParameters(OCIType):
    """
    Verification Translation and Routing parameters for creating a Verify Translation and
    Routing request from parameters.

    """

    _ELEMENTS = (
        E(
            "origination", "origination", VerifyTranslationAndRoutingOrigination,
            is_complex=True, is_required=True,
        ),
        E("destination", "destination", str, is_required=True),
        E("contact", "contact", str),
        E("diversion", "diversion", str),
    )

    #: VerifyTranslationAndRoutingOrigination: *Required* origination
    origination = Field(
        type=VerifyTranslationAndRoutingOrigination, required=True, mutable=False,
    )
    #: str: *Required* destination
    destination = Field(type=str, required=True, mutable=False)
    #: str: *Optional* contact
    contact = Field(type=str, required=False, mutable=False)
    #: str: *Optional* diversion
    diversion = Field(type=str, required=False, mutable=False)


class VirtualOnNetUserRange(OCIType):
    """
    Virtual On-Net User Range.

    """

    _ELEMENTS = (
        E("dn_range", "dnRange", DNRange, is_complex=True, is_required=True),
        E(
            "extension_range", "extensionRange", ExtensionRange17, is_complex=True,
            is_required=True,
        ),
        E("first_name", "firstName", str, is_required=True),
        E("last_name", "lastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("virtual_on_net_call_type_name", "virtualOnNetCallTypeName", str, is_required=True),
    )

    #: DNRange: *Required* dnRange
    dn_range = Field(type=DNRange, required=True, mutable=False)
    #: ExtensionRange17: *Required* extensionRange
    extension_range = Field(type=ExtensionRange17, required=True, mutable=False)
    #: str: *Required* firstName
    first_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* lastName
    last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(type=str, required=True, mutable=False)
    #: str: *Required* virtualOnNetCallTypeName
    virtual_on_net_call_type_name = Field(type=str, required=True, mutable=False)


class VoiceMessagingAlternateNoAnswerGreetingModify(OCIType):
    """
    The configuration of a alternate no answer greeting.

    It is used when modifying a user's voice messaging greeting.
    """

    _ELEMENTS = (
        E("name", "name", str),
        E("audio_file", "audioFile", LabeledFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledFileResource, is_complex=True),
    )

    #: str: *Optional* name
    name = Field(type=str, required=False, mutable=False)
    #: LabeledFileResource: *Optional* audioFile
    audio_file = Field(type=LabeledFileResource, required=False, mutable=False)
    #: LabeledFileResource: *Optional* videoFile
    video_file = Field(type=LabeledFileResource, required=False, mutable=False)


class VoiceMessagingAlternateNoAnswerGreetingModify16(OCIType):
    """
    The configuration of a alternate no answer greeting.

    It is used when modifying a user's voice messaging greeting.
    """

    _ELEMENTS = (
        E("name", "name", str),
        E("audio_file", "audioFile", LabeledMediaFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledMediaFileResource, is_complex=True),
    )

    #: str: *Optional* name
    name = Field(type=str, required=False, mutable=False)
    #: LabeledMediaFileResource: *Optional* audioFile
    audio_file = Field(type=LabeledMediaFileResource, required=False, mutable=False)
    #: LabeledMediaFileResource: *Optional* videoFile
    video_file = Field(type=LabeledMediaFileResource, required=False, mutable=False)


class VoiceMessagingAlternateNoAnswerGreetingModify20(OCIType):
    """
    The configuration of a alternate no answer greeting.

    It is used when modifying a user's voice messaging greeting.
    """

    _ELEMENTS = (
        E("name", "name", str),
        E("audio_file", "audioFile", AnnouncementFileLevelKey, is_complex=True),
        E("video_file", "videoFile", AnnouncementFileLevelKey, is_complex=True),
    )

    #: str: *Optional* name
    name = Field(type=str, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* audioFile
    audio_file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* videoFile
    video_file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)


class VoiceMessagingAlternateNoAnswerGreetingRead20(OCIType):
    """
    The configuration of a alternate no answer greeting.

    It is used when geting a user's voice messaging greeting.
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("audio_file", "audioFile", AnnouncementFileLevelKey, is_complex=True),
        E("video_file", "videoFile", AnnouncementFileLevelKey, is_complex=True),
    )

    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* audioFile
    audio_file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* videoFile
    video_file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)


class AutoAttendantKeyConfiguration(OCIType):
    """
    The configuration of a key for Auto Attendant.

    """

    _ELEMENTS = (
        E("key", "key", str, is_required=True),
        E(
            "entry", "entry", AutoAttendantKeyConfigurationEntry, is_complex=True,
            is_required=True,
        ),
    )

    #: str: *Required* key
    key = Field(type=str, required=True, mutable=False)
    #: AutoAttendantKeyConfigurationEntry: *Required* entry
    entry = Field(type=AutoAttendantKeyConfigurationEntry, required=True, mutable=False)


class AutoAttendantKeyConfiguration19(OCIType):
    """
    The configuration of a key for Auto Attendant.

    """

    _ELEMENTS = (
        E("key", "key", str, is_required=True),
        E(
            "entry", "entry", AutoAttendantKeyConfigurationEntry19, is_complex=True,
            is_required=True,
        ),
    )

    #: str: *Required* key
    key = Field(type=str, required=True, mutable=False)
    #: AutoAttendantKeyConfigurationEntry19: *Required* entry
    entry = Field(type=AutoAttendantKeyConfigurationEntry19, required=True, mutable=False)


class AutoAttendantKeyConfiguration20(OCIType):
    """
    The configuration of a key for Auto Attendant.

    """

    _ELEMENTS = (
        E("key", "key", str, is_required=True),
        E(
            "entry", "entry", AutoAttendantKeyConfigurationEntry20, is_complex=True,
            is_required=True,
        ),
    )

    #: str: *Required* key
    key = Field(type=str, required=True, mutable=False)
    #: AutoAttendantKeyConfigurationEntry20: *Required* entry
    entry = Field(type=AutoAttendantKeyConfigurationEntry20, required=True, mutable=False)


class AutoAttendantKeyModifyConfiguration(OCIType):
    """
    The modify configuration of a key for Auto Attendant.

    """

    _ELEMENTS = (
        E("key", "key", str, is_required=True),
        E(
            "entry", "entry", AutoAttendantKeyConfigurationModifyEntry, is_complex=True,
            is_required=True,
        ),
    )

    #: str: *Required* key
    key = Field(type=str, required=True, mutable=False)
    #: AutoAttendantKeyConfigurationModifyEntry: *Required* entry
    entry = Field(type=AutoAttendantKeyConfigurationModifyEntry, required=True, mutable=False)


class AutoAttendantKeyModifyConfiguration20(OCIType):
    """
    The modify configuration of a key for Auto Attendant.

    """

    _ELEMENTS = (
        E("key", "key", str, is_required=True),
        E(
            "entry", "entry", AutoAttendantKeyConfigurationModifyEntry20, is_complex=True,
            is_required=True,
        ),
    )

    #: str: *Required* key
    key = Field(type=str, required=True, mutable=False)
    #: AutoAttendantKeyConfigurationModifyEntry20: *Required* entry
    entry = Field(
        type=AutoAttendantKeyConfigurationModifyEntry20, required=True, mutable=False,
    )


class AutoAttendantKeyReadConfiguration20(OCIType):
    """
    The read configuration of a key for Auto Attendant.

    """

    _ELEMENTS = (
        E("key", "key", str, is_required=True),
        E(
            "entry", "entry", AutoAttendantKeyConfigurationReadEntry20, is_complex=True,
            is_required=True,
        ),
    )

    #: str: *Required* key
    key = Field(type=str, required=True, mutable=False)
    #: AutoAttendantKeyConfigurationReadEntry20: *Required* entry
    entry = Field(type=AutoAttendantKeyConfigurationReadEntry20, required=True, mutable=False)


class AutoAttendantReadMenu19(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during after business hours.

    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool, is_required=True,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyReadConfiguration19,
            is_complex=True,
        ),
    )

    #: str: *Required* announcementSelection
    announcement_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMediaType
    audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMediaType
    video_media_type = Field(type=str, required=False, mutable=False)
    #: bool: *Required* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: AutoAttendantKeyReadConfiguration19: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyReadConfiguration19, required=False, mutable=False,
    )


class CPEDeviceModifyOptions(OCIType):
    """
    CPE device's options when used with a modify request.

    The following options are not changeable: configType systemFileName deviceFileFormat
    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool),
        E("reset_event", "resetEvent", str),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeModifyOptions, is_complex=True,
        ),
    )

    #: bool: *Optional* enableMonitoring
    enable_monitoring = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* resetEvent
    reset_event = Field(type=str, required=False, mutable=False)
    #: DeviceManagementDeviceTypeModifyOptions: *Optional*
    #: deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeModifyOptions, required=False, mutable=False,
    )


class CPEDeviceModifyOptions16(OCIType):
    """
    CPE device's options when used with a modify request.

    The following options are not changeable: configType systemFileName deviceFileFormat
    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool),
        E("reset_event", "resetEvent", str),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeModifyOptions16, is_complex=True,
        ),
    )

    #: bool: *Optional* enableMonitoring
    enable_monitoring = Field(type=bool, required=False, mutable=False)
    #: str: *Optional* resetEvent
    reset_event = Field(type=str, required=False, mutable=False)
    #: DeviceManagementDeviceTypeModifyOptions16: *Optional*
    #: deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeModifyOptions16, required=False, mutable=False,
    )


class CPEDeviceModifyOptions16sp1(OCIType):
    """
    CPE device's options when used with a modify request.

    The following options are not changeable: configType systemFileName deviceFileFormat
    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeModifyOptions16, is_complex=True,
        ),
    )

    #: bool: *Optional* enableMonitoring
    enable_monitoring = Field(type=bool, required=False, mutable=False)
    #: DeviceManagementDeviceTypeModifyOptions16: *Optional*
    #: deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeModifyOptions16, required=False, mutable=False,
    )


class CPEDeviceOptions14sp6(OCIType):
    """
    CPE device's options.

    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool, is_required=True),
        E("reset_event", "resetEvent", str),
        E("config_type", "configType", str, is_required=True),
        E("system_file_name", "systemFileName", str),
        E("device_file_format", "deviceFileFormat", str),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptions, is_complex=True,
        ),
    )

    #: bool: *Required* enableMonitoring
    enable_monitoring = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* resetEvent
    reset_event = Field(type=str, required=False, mutable=False)
    #: str: *Required* configType
    config_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* systemFileName
    system_file_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* deviceFileFormat
    device_file_format = Field(type=str, required=False, mutable=False)
    #: DeviceManagementDeviceTypeOptions: *Optional* deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeOptions, required=False, mutable=False,
    )


class CPEDeviceOptions16(OCIType):
    """
    CPE device's options.

    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool, is_required=True),
        E("reset_event", "resetEvent", str),
        E("config_type", "configType", str, is_required=True),
        E("system_file_name", "systemFileName", str),
        E("device_file_format", "deviceFileFormat", str),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptions16, is_complex=True,
        ),
    )

    #: bool: *Required* enableMonitoring
    enable_monitoring = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* resetEvent
    reset_event = Field(type=str, required=False, mutable=False)
    #: str: *Required* configType
    config_type = Field(type=str, required=True, mutable=False)
    #: str: *Optional* systemFileName
    system_file_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* deviceFileFormat
    device_file_format = Field(type=str, required=False, mutable=False)
    #: DeviceManagementDeviceTypeOptions16: *Optional* deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeOptions16, required=False, mutable=False,
    )


class CPEDeviceOptions16sp1(OCIType):
    """
    CPE device's options.

    The field configType is optional to allow the use of field enableMonitoring for all
    device types being managed or not ie.  device configuration option equals to
    DeviceManagement, or Legacy, or Not Supported). If the device configuration option is
    set to "Not Supported", the value of configType is forced set to "None" regardless of
    its current value.  It is not allowed to add a device type with device configuration
    option set to Device Management or Legacy when the configType is not set.
    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool, is_required=True),
        E("config_type", "configType", str),
        E("system_file_name", "systemFileName", str),
        E("device_file_format", "deviceFileFormat", str),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptions16, is_complex=True,
        ),
    )

    #: bool: *Required* enableMonitoring
    enable_monitoring = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* configType
    config_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* systemFileName
    system_file_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* deviceFileFormat
    device_file_format = Field(type=str, required=False, mutable=False)
    #: DeviceManagementDeviceTypeOptions16: *Optional* deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeOptions16, required=False, mutable=False,
    )


class CallCenterMediaOnHoldSourceModify16(OCIType):
    """
    Contains the call center media on hold source configuration.

    """

    _ELEMENTS = (
        E("audio_message_source_selection", "audioMessageSourceSelection", str),
        E("audio_file", "audioFile", ExtendedMediaFileResource, is_complex=True),
        E(
            "external_audio_source", "externalAudioSource", AccessDeviceEndpointModify,
            is_complex=True,
        ),
        E("video_message_source_selection", "videoMessageSourceSelection", str),
        E("video_file", "videoFile", ExtendedMediaFileResource, is_complex=True),
        E(
            "external_video_source", "externalVideoSource", AccessDeviceEndpointModify,
            is_complex=True,
        ),
    )

    #: str: *Optional* audioMessageSourceSelection
    audio_message_source_selection = Field(type=str, required=False, mutable=False)
    #: ExtendedMediaFileResource: *Optional* audioFile
    audio_file = Field(type=ExtendedMediaFileResource, required=False, mutable=False)
    #: AccessDeviceEndpointModify: *Optional* externalAudioSource
    external_audio_source = Field(
        type=AccessDeviceEndpointModify, required=False, mutable=False,
    )
    #: str: *Optional* videoMessageSourceSelection
    video_message_source_selection = Field(type=str, required=False, mutable=False)
    #: ExtendedMediaFileResource: *Optional* videoFile
    video_file = Field(type=ExtendedMediaFileResource, required=False, mutable=False)
    #: AccessDeviceEndpointModify: *Optional* externalVideoSource
    external_video_source = Field(
        type=AccessDeviceEndpointModify, required=False, mutable=False,
    )


class CallCenterMediaOnHoldSourceModify17(OCIType):
    """
    Contains the call center media on hold source configuration.

    """

    _ELEMENTS = (
        E("audio_message_source_selection", "audioMessageSourceSelection", str),
        E(
            "audio_url_list", "audioUrlList", CallCenterAnnouncementURLListModify,
            is_complex=True,
        ),
        E(
            "audio_file_list", "audioFileList", CallCenterAnnouncementFileListModify,
            is_complex=True,
        ),
        E(
            "external_audio_source", "externalAudioSource", AccessDeviceEndpointModify,
            is_complex=True,
        ),
        E("video_message_source_selection", "videoMessageSourceSelection", str),
        E(
            "video_url_list", "videoUrlList", CallCenterAnnouncementURLListModify,
            is_complex=True,
        ),
        E(
            "video_file_list", "videoFileList", CallCenterAnnouncementFileListModify,
            is_complex=True,
        ),
        E(
            "external_video_source", "externalVideoSource", AccessDeviceEndpointModify,
            is_complex=True,
        ),
    )

    #: str: *Optional* audioMessageSourceSelection
    audio_message_source_selection = Field(type=str, required=False, mutable=False)
    #: CallCenterAnnouncementURLListModify: *Optional* audioUrlList
    audio_url_list = Field(
        type=CallCenterAnnouncementURLListModify, required=False, mutable=False,
    )
    #: CallCenterAnnouncementFileListModify: *Optional* audioFileList
    audio_file_list = Field(
        type=CallCenterAnnouncementFileListModify, required=False, mutable=False,
    )
    #: AccessDeviceEndpointModify: *Optional* externalAudioSource
    external_audio_source = Field(
        type=AccessDeviceEndpointModify, required=False, mutable=False,
    )
    #: str: *Optional* videoMessageSourceSelection
    video_message_source_selection = Field(type=str, required=False, mutable=False)
    #: CallCenterAnnouncementURLListModify: *Optional* videoUrlList
    video_url_list = Field(
        type=CallCenterAnnouncementURLListModify, required=False, mutable=False,
    )
    #: CallCenterAnnouncementFileListModify: *Optional* videoFileList
    video_file_list = Field(
        type=CallCenterAnnouncementFileListModify, required=False, mutable=False,
    )
    #: AccessDeviceEndpointModify: *Optional* externalVideoSource
    external_video_source = Field(
        type=AccessDeviceEndpointModify, required=False, mutable=False,
    )


class CallCenterMediaOnHoldSourceModify20(OCIType):
    """
    Contains the call center media on hold source configuration.

    """

    _ELEMENTS = (
        E("audio_message_source_selection", "audioMessageSourceSelection", str),
        E(
            "audio_url_list", "audioUrlList", CallCenterAnnouncementURLListModify,
            is_complex=True,
        ),
        E(
            "audio_file_list", "audioFileList", CallCenterAnnouncementFileListModify20,
            is_complex=True,
        ),
        E(
            "external_audio_source", "externalAudioSource", AccessDeviceEndpointModify,
            is_complex=True,
        ),
        E("video_message_source_selection", "videoMessageSourceSelection", str),
        E(
            "video_url_list", "videoUrlList", CallCenterAnnouncementURLListModify,
            is_complex=True,
        ),
        E(
            "video_file_list", "videoFileList", CallCenterAnnouncementFileListModify20,
            is_complex=True,
        ),
        E(
            "external_video_source", "externalVideoSource", AccessDeviceEndpointModify,
            is_complex=True,
        ),
    )

    #: str: *Optional* audioMessageSourceSelection
    audio_message_source_selection = Field(type=str, required=False, mutable=False)
    #: CallCenterAnnouncementURLListModify: *Optional* audioUrlList
    audio_url_list = Field(
        type=CallCenterAnnouncementURLListModify, required=False, mutable=False,
    )
    #: CallCenterAnnouncementFileListModify20: *Optional* audioFileList
    audio_file_list = Field(
        type=CallCenterAnnouncementFileListModify20, required=False, mutable=False,
    )
    #: AccessDeviceEndpointModify: *Optional* externalAudioSource
    external_audio_source = Field(
        type=AccessDeviceEndpointModify, required=False, mutable=False,
    )
    #: str: *Optional* videoMessageSourceSelection
    video_message_source_selection = Field(type=str, required=False, mutable=False)
    #: CallCenterAnnouncementURLListModify: *Optional* videoUrlList
    video_url_list = Field(
        type=CallCenterAnnouncementURLListModify, required=False, mutable=False,
    )
    #: CallCenterAnnouncementFileListModify20: *Optional* videoFileList
    video_file_list = Field(
        type=CallCenterAnnouncementFileListModify20, required=False, mutable=False,
    )
    #: AccessDeviceEndpointModify: *Optional* externalVideoSource
    external_video_source = Field(
        type=AccessDeviceEndpointModify, required=False, mutable=False,
    )


class CallCenterMediaOnHoldSourceRead16(OCIType):
    """
    Contains the call center media on hold source configuration.

    """

    _ELEMENTS = (
        E(
            "audio_message_source_selection", "audioMessageSourceSelection", str,
            is_required=True,
        ),
        E("audio_file_url", "audioFileUrl", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_file_media_type", "audioFileMediaType", str),
        E(
            "external_audio_source", "externalAudioSource", AccessDeviceEndpointRead14,
            is_complex=True,
        ),
        E("video_message_source_selection", "videoMessageSourceSelection", str),
        E("video_file_url", "videoFileUrl", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_file_media_type", "videoFileMediaType", str),
        E(
            "external_video_source", "externalVideoSource", AccessDeviceEndpointRead14,
            is_complex=True,
        ),
    )

    #: str: *Required* audioMessageSourceSelection
    audio_message_source_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioFileMediaType
    audio_file_media_type = Field(type=str, required=False, mutable=False)
    #: AccessDeviceEndpointRead14: *Optional* externalAudioSource
    external_audio_source = Field(
        type=AccessDeviceEndpointRead14, required=False, mutable=False,
    )
    #: str: *Optional* videoMessageSourceSelection
    video_message_source_selection = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileUrl
    video_file_url = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileMediaType
    video_file_media_type = Field(type=str, required=False, mutable=False)
    #: AccessDeviceEndpointRead14: *Optional* externalVideoSource
    external_video_source = Field(
        type=AccessDeviceEndpointRead14, required=False, mutable=False,
    )


class CallCenterMediaOnHoldSourceRead17(OCIType):
    """
    Contains the call center media on hold source configuration.

    Replaced by: CallCenterMediaOnHoldSourceRead19.
    """

    _ELEMENTS = (
        E(
            "audio_message_source_selection", "audioMessageSourceSelection", str,
            is_required=True,
        ),
        E("audio_url_list", "audioUrlList", CallCenterAnnouncementURLList, is_complex=True),
        E(
            "audio_file_list", "audioFileList", CallCenterAnnouncementDescriptionList,
            is_complex=True,
        ),
        E(
            "audio_media_type_list", "audioMediaTypeList",
            CallCenterAnnouncementMediaFileTypeList, is_complex=True,
        ),
        E(
            "external_audio_source", "externalAudioSource", AccessDeviceEndpointRead14,
            is_complex=True,
        ),
        E("video_message_source_selection", "videoMessageSourceSelection", str),
        E("video_url_list", "videoUrlList", CallCenterAnnouncementURLList, is_complex=True),
        E(
            "video_file_list", "videoFileList", CallCenterAnnouncementDescriptionList,
            is_complex=True,
        ),
        E(
            "video_media_type_list", "videoMediaTypeList",
            CallCenterAnnouncementMediaFileTypeList, is_complex=True,
        ),
        E(
            "external_video_source", "externalVideoSource", AccessDeviceEndpointRead14,
            is_complex=True,
        ),
    )

    #: str: *Required* audioMessageSourceSelection
    audio_message_source_selection = Field(type=str, required=True, mutable=False)
    #: CallCenterAnnouncementURLList: *Optional* audioUrlList
    audio_url_list = Field(type=CallCenterAnnouncementURLList, required=False, mutable=False)
    #: CallCenterAnnouncementDescriptionList: *Optional* audioFileList
    audio_file_list = Field(
        type=CallCenterAnnouncementDescriptionList, required=False, mutable=False,
    )
    #: CallCenterAnnouncementMediaFileTypeList: *Optional* audioMediaTypeList
    audio_media_type_list = Field(
        type=CallCenterAnnouncementMediaFileTypeList, required=False, mutable=False,
    )
    #: AccessDeviceEndpointRead14: *Optional* externalAudioSource
    external_audio_source = Field(
        type=AccessDeviceEndpointRead14, required=False, mutable=False,
    )
    #: str: *Optional* videoMessageSourceSelection
    video_message_source_selection = Field(type=str, required=False, mutable=False)
    #: CallCenterAnnouncementURLList: *Optional* videoUrlList
    video_url_list = Field(type=CallCenterAnnouncementURLList, required=False, mutable=False)
    #: CallCenterAnnouncementDescriptionList: *Optional* videoFileList
    video_file_list = Field(
        type=CallCenterAnnouncementDescriptionList, required=False, mutable=False,
    )
    #: CallCenterAnnouncementMediaFileTypeList: *Optional* videoMediaTypeList
    video_media_type_list = Field(
        type=CallCenterAnnouncementMediaFileTypeList, required=False, mutable=False,
    )
    #: AccessDeviceEndpointRead14: *Optional* externalVideoSource
    external_video_source = Field(
        type=AccessDeviceEndpointRead14, required=False, mutable=False,
    )


class CallCenterMediaOnHoldSourceRead19(OCIType):
    """
    Contains the call center media on hold source configuration.

    """

    _ELEMENTS = (
        E(
            "audio_message_source_selection", "audioMessageSourceSelection", str,
            is_required=True,
        ),
        E("audio_url_list", "audioUrlList", CallCenterAnnouncementURLList, is_complex=True),
        E(
            "audio_file_list", "audioFileList", CallCenterAnnouncementDescriptionList,
            is_complex=True,
        ),
        E(
            "audio_media_type_list", "audioMediaTypeList",
            CallCenterAnnouncementMediaFileTypeList, is_complex=True,
        ),
        E(
            "external_audio_source", "externalAudioSource",
            AccessDeviceEndpointWithPortNumberRead, is_complex=True,
        ),
        E("video_message_source_selection", "videoMessageSourceSelection", str),
        E("video_url_list", "videoUrlList", CallCenterAnnouncementURLList, is_complex=True),
        E(
            "video_file_list", "videoFileList", CallCenterAnnouncementDescriptionList,
            is_complex=True,
        ),
        E(
            "video_media_type_list", "videoMediaTypeList",
            CallCenterAnnouncementMediaFileTypeList, is_complex=True,
        ),
        E(
            "external_video_source", "externalVideoSource",
            AccessDeviceEndpointWithPortNumberRead, is_complex=True,
        ),
    )

    #: str: *Required* audioMessageSourceSelection
    audio_message_source_selection = Field(type=str, required=True, mutable=False)
    #: CallCenterAnnouncementURLList: *Optional* audioUrlList
    audio_url_list = Field(type=CallCenterAnnouncementURLList, required=False, mutable=False)
    #: CallCenterAnnouncementDescriptionList: *Optional* audioFileList
    audio_file_list = Field(
        type=CallCenterAnnouncementDescriptionList, required=False, mutable=False,
    )
    #: CallCenterAnnouncementMediaFileTypeList: *Optional* audioMediaTypeList
    audio_media_type_list = Field(
        type=CallCenterAnnouncementMediaFileTypeList, required=False, mutable=False,
    )
    #: AccessDeviceEndpointWithPortNumberRead: *Optional* externalAudioSource
    external_audio_source = Field(
        type=AccessDeviceEndpointWithPortNumberRead, required=False, mutable=False,
    )
    #: str: *Optional* videoMessageSourceSelection
    video_message_source_selection = Field(type=str, required=False, mutable=False)
    #: CallCenterAnnouncementURLList: *Optional* videoUrlList
    video_url_list = Field(type=CallCenterAnnouncementURLList, required=False, mutable=False)
    #: CallCenterAnnouncementDescriptionList: *Optional* videoFileList
    video_file_list = Field(
        type=CallCenterAnnouncementDescriptionList, required=False, mutable=False,
    )
    #: CallCenterAnnouncementMediaFileTypeList: *Optional* videoMediaTypeList
    video_media_type_list = Field(
        type=CallCenterAnnouncementMediaFileTypeList, required=False, mutable=False,
    )
    #: AccessDeviceEndpointWithPortNumberRead: *Optional* externalVideoSource
    external_video_source = Field(
        type=AccessDeviceEndpointWithPortNumberRead, required=False, mutable=False,
    )


class CallCenterMediaOnHoldSourceRead20(OCIType):
    """
    Contains the call center media on hold source configuration.

    """

    _ELEMENTS = (
        E(
            "audio_message_source_selection", "audioMessageSourceSelection", str,
            is_required=True,
        ),
        E("audio_url_list", "audioUrlList", CallCenterAnnouncementURLList, is_complex=True),
        E(
            "audio_file_list", "audioFileList", CallCenterAnnouncementFileListRead20,
            is_complex=True,
        ),
        E(
            "external_audio_source", "externalAudioSource",
            AccessDeviceEndpointWithPortNumberRead, is_complex=True,
        ),
        E("video_message_source_selection", "videoMessageSourceSelection", str),
        E("video_url_list", "videoUrlList", CallCenterAnnouncementURLList, is_complex=True),
        E(
            "video_file_list", "videoFileList", CallCenterAnnouncementFileListRead20,
            is_complex=True,
        ),
        E(
            "external_video_source", "externalVideoSource",
            AccessDeviceEndpointWithPortNumberRead, is_complex=True,
        ),
    )

    #: str: *Required* audioMessageSourceSelection
    audio_message_source_selection = Field(type=str, required=True, mutable=False)
    #: CallCenterAnnouncementURLList: *Optional* audioUrlList
    audio_url_list = Field(type=CallCenterAnnouncementURLList, required=False, mutable=False)
    #: CallCenterAnnouncementFileListRead20: *Optional* audioFileList
    audio_file_list = Field(
        type=CallCenterAnnouncementFileListRead20, required=False, mutable=False,
    )
    #: AccessDeviceEndpointWithPortNumberRead: *Optional* externalAudioSource
    external_audio_source = Field(
        type=AccessDeviceEndpointWithPortNumberRead, required=False, mutable=False,
    )
    #: str: *Optional* videoMessageSourceSelection
    video_message_source_selection = Field(type=str, required=False, mutable=False)
    #: CallCenterAnnouncementURLList: *Optional* videoUrlList
    video_url_list = Field(type=CallCenterAnnouncementURLList, required=False, mutable=False)
    #: CallCenterAnnouncementFileListRead20: *Optional* videoFileList
    video_file_list = Field(
        type=CallCenterAnnouncementFileListRead20, required=False, mutable=False,
    )
    #: AccessDeviceEndpointWithPortNumberRead: *Optional* externalVideoSource
    external_video_source = Field(
        type=AccessDeviceEndpointWithPortNumberRead, required=False, mutable=False,
    )


class CallCenterReportInterval(OCIType):
    """
    Report interval for call center enhanced reporting scheduled reports.

    """

    _ELEMENTS = (
        E("dates", "dates", CallCenterReportIntervalDates, is_complex=True),
        E("current", "current", CallCenterReportCurrentInterval, is_complex=True),
        E("past", "past", CallCenterReportPastInterval, is_complex=True),
    )

    #: CallCenterReportIntervalDates: *Optional* dates
    dates = Field(type=CallCenterReportIntervalDates, required=False, mutable=False)
    #: CallCenterReportCurrentInterval: *Optional* current
    current = Field(type=CallCenterReportCurrentInterval, required=False, mutable=False)
    #: CallCenterReportPastInterval: *Optional* past
    past = Field(type=CallCenterReportPastInterval, required=False, mutable=False)


class CallCenterReportSchedule(OCIType):
    """
    A schedule for call center enhanced reporting scheduled report.

    It can either be a fixed time schedule or recurring schedule
    """

    _ELEMENTS = (
        E("schedule_time", "scheduleTime", CallCenterReportScheduleTime, is_complex=True),
        E("recurrence", "recurrence", CallCenterReportScheduleRecurrence, is_complex=True),
    )

    #: CallCenterReportScheduleTime: *Optional* scheduleTime
    schedule_time = Field(type=CallCenterReportScheduleTime, required=False, mutable=False)
    #: CallCenterReportScheduleRecurrence: *Optional* recurrence
    recurrence = Field(type=CallCenterReportScheduleRecurrence, required=False, mutable=False)


class CommPilotExpressSRNoAnswer(OCIType):
    """
    CommPilot Express SR No Answer Settings used in the context of a get.

    """

    _ELEMENTS = (
        E("ring_forward_numbers", "ringForwardNumbers", bool, is_required=True),
        E(
            "forwarding_number_list", "forwardingNumberList",
            CommPilotExpressSRRedirectionWithRingList, is_complex=True, is_required=True,
        ),
        E(
            "still_no_answer", "stillNoAnswer", CommPilotExpressSRRedirection,
            is_complex=True, is_required=True,
        ),
    )

    #: bool: *Required* ringForwardNumbers
    ring_forward_numbers = Field(type=bool, required=True, mutable=False)
    #: CommPilotExpressSRRedirectionWithRingList: *Required* forwardingNumberList
    forwarding_number_list = Field(
        type=CommPilotExpressSRRedirectionWithRingList, required=True, mutable=False,
    )
    #: CommPilotExpressSRRedirection: *Required* stillNoAnswer
    still_no_answer = Field(type=CommPilotExpressSRRedirection, required=True, mutable=False)


class CommPilotExpressSRNoAnswerModify(OCIType):
    """
    CommPilot Express SR No Answer Settings used in the context of a modify.

    """

    _ELEMENTS = (
        E("ring_foward_numbers", "ringFowardNumbers", bool),
        E(
            "forwarding_number_list", "forwardingNumberList",
            CommPilotExpressSRRedirectionWithRingList, is_complex=True,
        ),
        E(
            "still_no_answer", "stillNoAnswer", CommPilotExpressSRRedirectionModify,
            is_complex=True,
        ),
    )

    #: bool: *Optional* ringFowardNumbers
    ring_foward_numbers = Field(type=bool, required=False, mutable=False)
    #: CommPilotExpressSRRedirectionWithRingList: *Optional* forwardingNumberList
    forwarding_number_list = Field(
        type=CommPilotExpressSRRedirectionWithRingList, required=False, mutable=False,
    )
    #: CommPilotExpressSRRedirectionModify: *Optional* stillNoAnswer
    still_no_answer = Field(
        type=CommPilotExpressSRRedirectionModify, required=False, mutable=False,
    )


class GroupHuntGroupAddInstanceRequest17sp1V1(OCIType):
    """
    Add a Hunt Group instance to a group.

    The domain is required in the serviceUserId.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in HSS data mode: allowMembersToControlGroupBusy, use value
    "false" in AS data mode enableGroupBusy, use value "false" in AS data mode
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_user_id", "serviceUserId", str, is_required=True),
        E(
            "service_instance_profile", "serviceInstanceProfile",
            ServiceInstanceAddProfile, is_complex=True, is_required=True,
        ),
        E("policy", "policy", str, is_required=True),
        E("hunt_after_no_answer", "huntAfterNoAnswer", bool, is_required=True),
        E("no_answer_number_of_rings", "noAnswerNumberOfRings", int, is_required=True),
        E("forward_after_timeout", "forwardAfterTimeout", bool, is_required=True),
        E("forward_timeout_seconds", "forwardTimeoutSeconds", int, is_required=True),
        E("forward_to_phone_number", "forwardToPhoneNumber", str),
        E("agent_user_id", "agentUserId", str, is_array=True),
        E(
            "allow_call_waiting_for_agents", "allowCallWaitingForAgents", bool,
            is_required=True,
        ),
        E(
            "allow_members_to_control_group_busy", "allowMembersToControlGroupBusy", bool,
            is_required=True,
        ),
        E("enable_group_busy", "enableGroupBusy", bool, is_required=True),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* serviceUserId
    service_user_id = Field(type=str, required=True, mutable=False)
    #: ServiceInstanceAddProfile: *Required* serviceInstanceProfile
    service_instance_profile = Field(
        type=ServiceInstanceAddProfile, required=True, mutable=False,
    )
    #: str: *Required* policy
    policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* huntAfterNoAnswer
    hunt_after_no_answer = Field(type=bool, required=True, mutable=False)
    #: int: *Required* noAnswerNumberOfRings
    no_answer_number_of_rings = Field(type=int, required=True, mutable=False)
    #: bool: *Required* forwardAfterTimeout
    forward_after_timeout = Field(type=bool, required=True, mutable=False)
    #: int: *Required* forwardTimeoutSeconds
    forward_timeout_seconds = Field(type=int, required=True, mutable=False)
    #: str: *Optional* forwardToPhoneNumber
    forward_to_phone_number = Field(type=str, required=False, mutable=False)
    #: list(str): *Optional* agentUserId  *Array*
    agent_user_id = Field(type=list, required=False, mutable=False)
    #: bool: *Required* allowCallWaitingForAgents
    allow_call_waiting_for_agents = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowMembersToControlGroupBusy
    allow_members_to_control_group_busy = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableGroupBusy
    enable_group_busy = Field(type=bool, required=True, mutable=False)


class GroupHuntGroupGetInstanceResponse17sp1V1(OCIType):
    """
    Response to GroupHuntGroupGetInstanceRequest17sp1V1.

    Contains the service profile information and a table of assigned users.  The table has
    column headings: "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana
    First Name", "Weight". The following elements are only used in HSS data mode:
    allowMembersToControlGroupBusy enableGroupBusy
    """

    _ELEMENTS = (
        E(
            "service_instance_profile", "serviceInstanceProfile",
            ServiceInstanceReadProfile17, is_complex=True, is_required=True,
        ),
        E("policy", "policy", str, is_required=True),
        E("hunt_after_no_answer", "huntAfterNoAnswer", bool, is_required=True),
        E("no_answer_number_of_rings", "noAnswerNumberOfRings", int, is_required=True),
        E("forward_after_timeout", "forwardAfterTimeout", bool, is_required=True),
        E("forward_timeout_seconds", "forwardTimeoutSeconds", int, is_required=True),
        E("forward_to_phone_number", "forwardToPhoneNumber", str),
        E(
            "agent_user_table", "agentUserTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
        E(
            "allow_call_waiting_for_agents", "allowCallWaitingForAgents", bool,
            is_required=True,
        ),
        E(
            "allow_members_to_control_group_busy", "allowMembersToControlGroupBusy", bool,
            is_required=True,
        ),
        E("enable_group_busy", "enableGroupBusy", bool, is_required=True),
    )

    #: ServiceInstanceReadProfile17: *Required* serviceInstanceProfile
    service_instance_profile = Field(
        type=ServiceInstanceReadProfile17, required=True, mutable=False,
    )
    #: str: *Required* policy
    policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* huntAfterNoAnswer
    hunt_after_no_answer = Field(type=bool, required=True, mutable=False)
    #: int: *Required* noAnswerNumberOfRings
    no_answer_number_of_rings = Field(type=int, required=True, mutable=False)
    #: bool: *Required* forwardAfterTimeout
    forward_after_timeout = Field(type=bool, required=True, mutable=False)
    #: int: *Required* forwardTimeoutSeconds
    forward_timeout_seconds = Field(type=int, required=True, mutable=False)
    #: str: *Optional* forwardToPhoneNumber
    forward_to_phone_number = Field(type=str, required=False, mutable=False)
    #: list: *Required* agentUserTable  *Tabular*
    agent_user_table = Field(type=list, required=True, mutable=False)
    #: bool: *Required* allowCallWaitingForAgents
    allow_call_waiting_for_agents = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowMembersToControlGroupBusy
    allow_members_to_control_group_busy = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableGroupBusy
    enable_group_busy = Field(type=bool, required=True, mutable=False)


class GroupTrunkGroupAddInstanceRequest14sp9A(OCIType):
    """
    Add a Trunk Group instance to a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("pilot_user", "pilotUser", TrunkGroupPilotUser, is_complex=True),
        E("department", "department", DepartmentKey, is_complex=True),
        E("access_device", "accessDevice", AccessDevice, is_complex=True),
        E("max_active_calls", "maxActiveCalls", int, is_required=True),
        E("max_incoming_calls", "maxIncomingCalls", int),
        E("max_outgoing_calls", "maxOutgoingCalls", int),
        E("enable_bursting", "enableBursting", bool, is_required=True),
        E("bursting_max_active_calls", "burstingMaxActiveCalls", int),
        E("bursting_max_incoming_calls", "burstingMaxIncomingCalls", int),
        E("bursting_max_outgoing_calls", "burstingMaxOutgoingCalls", int),
        E("capacity_exceeded_action", "capacityExceededAction", str),
        E("capacity_exceeded_forward_address", "capacityExceededForwardAddress", str),
        E(
            "capacity_exceeded_reroute_trunk_group_key",
            "capacityExceededRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E(
            "capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls",
            int, is_required=True,
        ),
        E(
            "capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int,
            is_required=True,
        ),
        E("unreachable_destination_action", "unreachableDestinationAction", str),
        E(
            "unreachable_destination_forward_address",
            "unreachableDestinationForwardAddress", str,
        ),
        E(
            "unreachable_destination_reroute_trunk_group_key",
            "unreachableDestinationRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E(
            "unreachable_destination_trap_initial_calls",
            "unreachableDestinationTrapInitialCalls", int, is_required=True,
        ),
        E(
            "unreachable_destination_trap_offset_calls",
            "unreachableDestinationTrapOffsetCalls", int, is_required=True,
        ),
        E("invitation_timeout", "invitationTimeout", int, is_required=True),
        E("require_authentication", "requireAuthentication", bool, is_required=True),
        E("sip_authentication_user_name", "sipAuthenticationUserName", str),
        E("sip_authentication_password", "sipAuthenticationPassword", str),
        E("hosted_user_id", "hostedUserId", str, is_array=True),
        E("trunk_group_identity", "trunkGroupIdentity", str),
        E("otg_dtg_identity", "otgDtgIdentity", str),
        E(
            "include_trunk_group_identity", "includeTrunkGroupIdentity", bool,
            is_required=True,
        ),
        E("include_dtg_identity", "includeDtgIdentity", bool, is_required=True),
        E(
            "enable_network_address_identity", "enableNetworkAddressIdentity", bool,
            is_required=True,
        ),
        E("allow_unscreened_calls", "allowUnscreenedCalls", bool, is_required=True),
        E(
            "allow_unscreened_emergency_calls", "allowUnscreenedEmergencyCalls", bool,
            is_required=True,
        ),
        E(
            "pilot_user_calling_line_identity_policy",
            "pilotUserCallingLineIdentityPolicy", str, is_required=True,
        ),
        E(
            "pilot_user_charge_number_policy", "pilotUserChargeNumberPolicy", str,
            is_required=True,
        ),
        E("call_forwarding_always_action", "callForwardingAlwaysAction", str),
        E(
            "call_forwarding_always_forward_address",
            "callForwardingAlwaysForwardAddress", str,
        ),
        E(
            "call_forwarding_always_reroute_trunk_group_key",
            "callForwardingAlwaysRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
    )

    #: str: *Required* serviceProviderId
    service_provider_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* groupId
    group_id = Field(type=str, required=True, mutable=False)
    #: str: *Required* name
    name = Field(type=str, required=True, mutable=False)
    #: TrunkGroupPilotUser: *Optional* pilotUser
    pilot_user = Field(type=TrunkGroupPilotUser, required=False, mutable=False)
    #: DepartmentKey: *Optional* department
    department = Field(type=DepartmentKey, required=False, mutable=False)
    #: AccessDevice: *Optional* accessDevice
    access_device = Field(type=AccessDevice, required=False, mutable=False)
    #: int: *Required* maxActiveCalls
    max_active_calls = Field(type=int, required=True, mutable=False)
    #: int: *Optional* maxIncomingCalls
    max_incoming_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* maxOutgoingCalls
    max_outgoing_calls = Field(type=int, required=False, mutable=False)
    #: bool: *Required* enableBursting
    enable_bursting = Field(type=bool, required=True, mutable=False)
    #: int: *Optional* burstingMaxActiveCalls
    bursting_max_active_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* burstingMaxIncomingCalls
    bursting_max_incoming_calls = Field(type=int, required=False, mutable=False)
    #: int: *Optional* burstingMaxOutgoingCalls
    bursting_max_outgoing_calls = Field(type=int, required=False, mutable=False)
    #: str: *Optional* capacityExceededAction
    capacity_exceeded_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* capacityExceededForwardAddress
    capacity_exceeded_forward_address = Field(type=str, required=False, mutable=False)
    #: TrunkGroupKey: *Optional* capacityExceededRerouteTrunkGroupKey
    capacity_exceeded_reroute_trunk_group_key = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    #: int: *Required* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(type=int, required=True, mutable=False)
    #: int: *Required* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(type=int, required=True, mutable=False)
    #: str: *Optional* unreachableDestinationAction
    unreachable_destination_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* unreachableDestinationForwardAddress
    unreachable_destination_forward_address = Field(type=str, required=False, mutable=False)
    #: TrunkGroupKey: *Optional* unreachableDestinationRerouteTrunkGroupKey
    unreachable_destination_reroute_trunk_group_key = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    #: int: *Required* unreachableDestinationTrapInitialCalls
    unreachable_destination_trap_initial_calls = Field(type=int, required=True, mutable=False)
    #: int: *Required* unreachableDestinationTrapOffsetCalls
    unreachable_destination_trap_offset_calls = Field(type=int, required=True, mutable=False)
    #: int: *Required* invitationTimeout
    invitation_timeout = Field(type=int, required=True, mutable=False)
    #: bool: *Required* requireAuthentication
    require_authentication = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* sipAuthenticationUserName
    sip_authentication_user_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* sipAuthenticationPassword
    sip_authentication_password = Field(type=str, required=False, mutable=False)
    #: list(str): *Optional* hostedUserId  *Array*
    hosted_user_id = Field(type=list, required=False, mutable=False)
    #: str: *Optional* trunkGroupIdentity
    trunk_group_identity = Field(type=str, required=False, mutable=False)
    #: str: *Optional* otgDtgIdentity
    otg_dtg_identity = Field(type=str, required=False, mutable=False)
    #: bool: *Required* includeTrunkGroupIdentity
    include_trunk_group_identity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* includeDtgIdentity
    include_dtg_identity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* enableNetworkAddressIdentity
    enable_network_address_identity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowUnscreenedCalls
    allow_unscreened_calls = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* allowUnscreenedEmergencyCalls
    allow_unscreened_emergency_calls = Field(type=bool, required=True, mutable=False)
    #: str: *Required* pilotUserCallingLineIdentityPolicy
    pilot_user_calling_line_identity_policy = Field(type=str, required=True, mutable=False)
    #: str: *Required* pilotUserChargeNumberPolicy
    pilot_user_charge_number_policy = Field(type=str, required=True, mutable=False)
    #: str: *Optional* callForwardingAlwaysAction
    call_forwarding_always_action = Field(type=str, required=False, mutable=False)
    #: str: *Optional* callForwardingAlwaysForwardAddress
    call_forwarding_always_forward_address = Field(type=str, required=False, mutable=False)
    #: TrunkGroupKey: *Optional* callForwardingAlwaysRerouteTrunkGroupKey
    call_forwarding_always_reroute_trunk_group_key = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )


class OutgoingCallingPlanDigitPatternCallMeNowDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan Call Me Now call permissions for specified digit patterns.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternCallMeNowPermissions, is_complex=True,
            is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)
    #: OutgoingCallingPlanDigitPatternCallMeNowPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternCallMeNowPermissions, required=True,
        mutable=False,
    )


class OutgoingCallingPlanDigitPatternCallMeNowDepartmentPermissionsModify(OCIType):
    """
    Modify outgoing Calling Plan Call Me Now call permissions for specified digit
    patterns.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternCallMeNowPermissions, is_complex=True,
            is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: OutgoingCallingPlanDigitPatternCallMeNowPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternCallMeNowPermissions, required=True,
        mutable=False,
    )


class OutgoingCallingPlanDigitPatternOriginatingDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan originating call permissions for specified digit patterns.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternOriginatingPermissions, is_complex=True,
            is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)
    #: OutgoingCallingPlanDigitPatternOriginatingPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternOriginatingPermissions, required=True,
        mutable=False,
    )


class OutgoingCallingPlanDigitPatternOriginatingDepartmentPermissionsModify(OCIType):
    """
    Modify outgoing Calling Plan originating call permissions for specified digit
    patterns.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternOriginatingPermissions, is_complex=True,
            is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: OutgoingCallingPlanDigitPatternOriginatingPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternOriginatingPermissions, required=True,
        mutable=False,
    )


class OutgoingCallingPlanDigitPatternRedirectingDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan redirecting call permissions for specified digit patterns.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternRedirectingPermissions, is_complex=True,
            is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)
    #: OutgoingCallingPlanDigitPatternRedirectingPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternRedirectingPermissions, required=True,
        mutable=False,
    )


class OutgoingCallingPlanDigitPatternRedirectingDepartmentPermissionsModify(OCIType):
    """
    Modify outgoing Calling Plan redirecting call permissions for specified digit
    patterns.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternRedirectingPermissions, is_complex=True,
            is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: OutgoingCallingPlanDigitPatternRedirectingPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternRedirectingPermissions, required=True,
        mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternCallMeNowDepartmentPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan Call Me Now call permissions for a department.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "permissions", "permissions",
            OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions, is_complex=True,
            is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)
    #: OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions: *Required* permissions
    permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions, required=True,
        mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternCallMeNowDepartmentPermissionsModify(OCIType):
    """
    Modify Outgoing Pinhole Digit Plan Call Me Now call permissions for specified digit
    patterns.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions, is_complex=True,
            is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions, required=True,
        mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternOriginatingDepartmentPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan department originating call permissions for specified
    digit patterns.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions, is_complex=True,
            is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)
    #: OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions, required=True,
        mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternOriginatingDepartmentPermissionsModify(OCIType):
    """
    Modify Outgoing Pinhole Digit Plan originating call permissions for specified digit
    patterns.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions, is_complex=True,
            is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions, required=True,
        mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternRedirectingDepartmentPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan initiating call forwards/transfer permissions for a
    department.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "permissions", "permissions",
            OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions, is_complex=True,
            is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: str: *Required* departmentName
    department_name = Field(type=str, required=True, mutable=False)
    #: OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions: *Required* permissions
    permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions, required=True,
        mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternRedirectingDepartmentPermissionsModify(OCIType):
    """
    Modify Outgoing Pinhole Digit Plan redirecting call permissions for specified digit
    patterns.

    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions, is_complex=True,
            is_required=True,
        ),
    )

    #: DepartmentKey: *Required* departmentKey
    department_key = Field(type=DepartmentKey, required=True, mutable=False)
    #: OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions, required=True,
        mutable=False,
    )


class ReplacementEnterpriseDeviceList(OCIType):
    """
    A list of enterprise accessible devices that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E("device", "device", EnterpriseAccessDevice, is_complex=True, is_required=True),
    )

    #: EnterpriseAccessDevice: *Required* device
    device = Field(type=EnterpriseAccessDevice, required=True, mutable=False)


class ReplacementEnterpriseEnterpriseTrunkPriorityWeightedTrunkGroupList(OCIType):
    """
    A list of enterprise trunk priority weighted trunk groups that replaces a previously
    configured list.

    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "trunk_group", "trunkGroup",
            EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup, is_complex=True,
            is_required=True,
        ),
    )

    #: EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup: *Required* trunkGroup
    trunk_group = Field(
        type=EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup, required=True,
        mutable=False,
    )


class SystemSIPDeviceTypeGetResponse18sp1V2(OCIType):
    """
    Response to SystemSIPDeviceTypeGetRequest18sp1V2.

    The following elements are only used in AS data mode: holdAnnouncementMethod
    supportRFC3398 The following elements are only used in HSS data mode:
    enable3G4GContinuity The following element values are only applicable in AS data mode:
    holdNormalization=useRfc3264Hold
    """

    _ELEMENTS = (
        E("is_obsolete", "isObsolete", bool, is_required=True),
        E(
            "number_of_ports", "numberOfPorts", UnboundedPositiveInt, is_complex=True,
            is_required=True,
        ),
        E("profile", "profile", str, is_required=True),
        E("registration_capable", "registrationCapable", bool, is_required=True),
        E("is_conference_device", "isConferenceDevice", bool, is_required=True),
        E("is_mobility_manager_device", "isMobilityManagerDevice", bool, is_required=True),
        E("is_music_on_hold_device", "isMusicOnHoldDevice", bool, is_required=True),
        E("hold_normalization", "holdNormalization", str, is_required=True),
        E("hold_announcement_method", "holdAnnouncementMethod", str, is_required=True),
        E("is_trusted", "isTrusted", bool, is_required=True),
        E("e164_capable", "E164Capable", bool, is_required=True),
        E("route_advance", "routeAdvance", bool, is_required=True),
        E("forwarding_override", "forwardingOverride", bool, is_required=True),
        E("wireless_integration", "wirelessIntegration", bool, is_required=True),
        E("web_based_config_url", "webBasedConfigURL", str),
        E("is_video_capable", "isVideoCapable", bool, is_required=True),
        E("pbx_integration", "PBXIntegration", bool, is_required=True),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E(
            "cpe_device_options", "cpeDeviceOptions", CPEDeviceOptionsRead16sp1,
            is_complex=True,
        ),
        E("protocol_choice", "protocolChoice", str, is_required=True),
        E("early_media_support", "earlyMediaSupport", str, is_required=True),
        E("authenticate_refer", "authenticateRefer", bool, is_required=True),
        E("auto_config_soft_client", "autoConfigSoftClient", bool, is_required=True),
        E("authentication_mode", "authenticationMode", str, is_required=True),
        E(
            "requires_broad_works_digit_collection", "requiresBroadWorksDigitCollection",
            bool, is_required=True,
        ),
        E(
            "requires_broad_works_call_waiting_tone", "requiresBroadWorksCallWaitingTone",
            bool, is_required=True,
        ),
        E("requires_mwi_subscription", "requiresMWISubscription", bool, is_required=True),
        E(
            "use_history_info_header_on_access_side", "useHistoryInfoHeaderOnAccessSide",
            bool, is_required=True,
        ),
        E("advice_of_charge_capable", "adviceOfChargeCapable", bool, is_required=True),
        E("reset_event", "resetEvent", str),
        E(
            "support_call_center_mime_type", "supportCallCenterMIMEType", bool,
            is_required=True,
        ),
        E("trunk_mode", "trunkMode", str, is_required=True),
        E("add_p_called_party_id", "addPCalledPartyId", bool, is_required=True),
        E(
            "support_identity_in_update_and_re_invite",
            "supportIdentityInUpdateAndReInvite", bool, is_required=True,
        ),
        E(
            "unscreened_presentation_identity_policy",
            "unscreenedPresentationIdentityPolicy", str, is_required=True,
        ),
        E("enable3_g4_g_continuity", "enable3G4GContinuity", bool, is_required=True),
        E(
            "support_emergency_disconnect_control", "supportEmergencyDisconnectControl",
            bool, is_required=True,
        ),
        E(
            "device_type_configuration_option", "deviceTypeConfigurationOption", str,
            is_required=True,
        ),
        E("support_rfc3398", "supportRFC3398", bool, is_required=True),
    )

    #: bool: *Required* isObsolete
    is_obsolete = Field(type=bool, required=True, mutable=False)
    #: UnboundedPositiveInt: *Required* numberOfPorts
    number_of_ports = Field(type=UnboundedPositiveInt, required=True, mutable=False)
    #: str: *Required* profile
    profile = Field(type=str, required=True, mutable=False)
    #: bool: *Required* registrationCapable
    registration_capable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isConferenceDevice
    is_conference_device = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isMobilityManagerDevice
    is_mobility_manager_device = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isMusicOnHoldDevice
    is_music_on_hold_device = Field(type=bool, required=True, mutable=False)
    #: str: *Required* holdNormalization
    hold_normalization = Field(type=str, required=True, mutable=False)
    #: str: *Required* holdAnnouncementMethod
    hold_announcement_method = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isTrusted
    is_trusted = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* E164Capable
    e164_capable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* routeAdvance
    route_advance = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* forwardingOverride
    forwarding_override = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* wirelessIntegration
    wireless_integration = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* webBasedConfigURL
    web_based_config_url = Field(type=str, required=False, mutable=False)
    #: bool: *Required* isVideoCapable
    is_video_capable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* PBXIntegration
    pbx_integration = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(type=bool, required=True, mutable=False)
    #: CPEDeviceOptionsRead16sp1: *Optional* cpeDeviceOptions
    cpe_device_options = Field(type=CPEDeviceOptionsRead16sp1, required=False, mutable=False)
    #: str: *Required* protocolChoice
    protocol_choice = Field(type=str, required=True, mutable=False)
    #: str: *Required* earlyMediaSupport
    early_media_support = Field(type=str, required=True, mutable=False)
    #: bool: *Required* authenticateRefer
    authenticate_refer = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* autoConfigSoftClient
    auto_config_soft_client = Field(type=bool, required=True, mutable=False)
    #: str: *Required* authenticationMode
    authentication_mode = Field(type=str, required=True, mutable=False)
    #: bool: *Required* requiresBroadWorksDigitCollection
    requires_broad_works_digit_collection = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* requiresBroadWorksCallWaitingTone
    requires_broad_works_call_waiting_tone = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* requiresMWISubscription
    requires_mwi_subscription = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useHistoryInfoHeaderOnAccessSide
    use_history_info_header_on_access_side = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* adviceOfChargeCapable
    advice_of_charge_capable = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* resetEvent
    reset_event = Field(type=str, required=False, mutable=False)
    #: bool: *Required* supportCallCenterMIMEType
    support_call_center_mime_type = Field(type=bool, required=True, mutable=False)
    #: str: *Required* trunkMode
    trunk_mode = Field(type=str, required=True, mutable=False)
    #: bool: *Required* addPCalledPartyId
    add_p_called_party_id = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* supportIdentityInUpdateAndReInvite
    support_identity_in_update_and_re_invite = Field(type=bool, required=True, mutable=False)
    #: str: *Required* unscreenedPresentationIdentityPolicy
    unscreened_presentation_identity_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enable3G4GContinuity
    enable3_g4_g_continuity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* supportEmergencyDisconnectControl
    support_emergency_disconnect_control = Field(type=bool, required=True, mutable=False)
    #: str: *Required* deviceTypeConfigurationOption
    device_type_configuration_option = Field(type=str, required=True, mutable=False)
    #: bool: *Required* supportRFC3398
    support_rfc3398 = Field(type=bool, required=True, mutable=False)


class TrunkAddressingMultipleContactModify(OCIType):
    """
    Trunk group endpoint that can have multiple contacts.

    alternateTrunkIdentityDomainName is only used in IMS mode.  Setting
    alternateTrunkIdentity or alternateTrunkIdentityDomain to nil in IMS mode, the other
    one paremter should be set to nil at the same time.
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint", "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceMultipleContactEndpointModify, is_complex=True,
        ),
        E("enterprise_trunk_name", "enterpriseTrunkName", str),
        E("alternate_trunk_identity", "alternateTrunkIdentity", str),
        E("alternate_trunk_identity_domain", "alternateTrunkIdentityDomain", str),
    )

    #: TrunkGroupDeviceMultipleContactEndpointModify: *Optional* trunkGroupDeviceEndpoint
    trunk_group_device_endpoint = Field(
        type=TrunkGroupDeviceMultipleContactEndpointModify, required=False, mutable=False,
    )
    #: str: *Optional* enterpriseTrunkName
    enterprise_trunk_name = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateTrunkIdentity
    alternate_trunk_identity = Field(type=str, required=False, mutable=False)
    #: str: *Optional* alternateTrunkIdentityDomain
    alternate_trunk_identity_domain = Field(type=str, required=False, mutable=False)


class UserEnhancedCallLogsGetListRequest17sp4V2(OCIType):
    """
    Request user's call logs.

    If the callLogType is not specified, all types of calls logs (placed, received,
    missed) are returned.  The filters "dateTimeRange", "numberFilter",
    "redirectedNumberFilter", "accountAuthorizationCodeFilter"
    "callAuthorizationCodeFilter" and "subscriberType" are ignored if call logs are stored
    in CDS. When "ReceivedOrMissed" is specified as "callLogType" and call logs are stored
    in CDS, all call logs including placed will be returned.  It is possible to restrict
    the number of rows returned using responsePagingControl.  If responsePagingControl is
    not specified, the value of Enhanced Call Logs system parameter
    maxNonPagedResponseSize will control the maximum number of call logs can be returned.

    The response is either a UserEnhancedCallLogsGetListResponse17sp4V2 or an
    ``ErrorResponse()``. The following elements are only used in AS data mode:
    callAuthorizationCodeFilter
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("call_log_type", "callLogType", str),
        E(
            "date_time_range", "dateTimeRange", EnhancedCallLogsTimeRange,
            is_complex=True, is_required=True,
        ),
        E("number_filter", "numberFilter", EnhancedCallLogsNumberFilter, is_complex=True),
        E(
            "redirected_number_filter", "redirectedNumberFilter",
            EnhancedCallLogsRedirectedNumberFilter, is_complex=True,
        ),
        E(
            "account_authorization_code_filter", "accountAuthorizationCodeFilter",
            EnhancedCallLogsAccountAuthorizationCodeFilter, is_complex=True,
        ),
        E(
            "call_authorization_code_filter", "callAuthorizationCodeFilter",
            EnhancedCallLogsCallAuthorizationCodeFilter, is_complex=True,
        ),
        E("subscriber_type", "subscriberType", str),
        E(
            "response_paging_control", "responsePagingControl", ResponsePagingControl,
            is_complex=True,
        ),
    )

    #: str: *Required* userId
    user_id = Field(type=str, required=True, mutable=False)
    #: str: *Optional* callLogType
    call_log_type = Field(type=str, required=False, mutable=False)
    #: EnhancedCallLogsTimeRange: *Required* dateTimeRange
    date_time_range = Field(type=EnhancedCallLogsTimeRange, required=True, mutable=False)
    #: EnhancedCallLogsNumberFilter: *Optional* numberFilter
    number_filter = Field(type=EnhancedCallLogsNumberFilter, required=False, mutable=False)
    #: EnhancedCallLogsRedirectedNumberFilter: *Optional* redirectedNumberFilter
    redirected_number_filter = Field(
        type=EnhancedCallLogsRedirectedNumberFilter, required=False, mutable=False,
    )
    #: EnhancedCallLogsAccountAuthorizationCodeFilter: *Optional*
    #: accountAuthorizationCodeFilter
    account_authorization_code_filter = Field(
        type=EnhancedCallLogsAccountAuthorizationCodeFilter, required=False, mutable=False,
    )
    #: EnhancedCallLogsCallAuthorizationCodeFilter: *Optional* callAuthorizationCodeFilter
    call_authorization_code_filter = Field(
        type=EnhancedCallLogsCallAuthorizationCodeFilter, required=False, mutable=False,
    )
    #: str: *Optional* subscriberType
    subscriber_type = Field(type=str, required=False, mutable=False)
    #: ResponsePagingControl: *Optional* responsePagingControl
    response_paging_control = Field(type=ResponsePagingControl, required=False, mutable=False)


class AutoAttendantAddMenu(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during after business hours.

    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file", "audioFile", LabeledFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledFileResource, is_complex=True),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool, is_required=True,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyConfiguration,
            is_complex=True,
        ),
    )

    #: str: *Required* announcementSelection
    announcement_selection = Field(type=str, required=True, mutable=False)
    #: LabeledFileResource: *Optional* audioFile
    audio_file = Field(type=LabeledFileResource, required=False, mutable=False)
    #: LabeledFileResource: *Optional* videoFile
    video_file = Field(type=LabeledFileResource, required=False, mutable=False)
    #: bool: *Required* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: AutoAttendantKeyConfiguration: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyConfiguration, required=False, mutable=False,
    )


class AutoAttendantAddMenu16(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during after business hours.

    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file", "audioFile", LabeledMediaFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledMediaFileResource, is_complex=True),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool, is_required=True,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyConfiguration,
            is_complex=True,
        ),
    )

    #: str: *Required* announcementSelection
    announcement_selection = Field(type=str, required=True, mutable=False)
    #: LabeledMediaFileResource: *Optional* audioFile
    audio_file = Field(type=LabeledMediaFileResource, required=False, mutable=False)
    #: LabeledMediaFileResource: *Optional* videoFile
    video_file = Field(type=LabeledMediaFileResource, required=False, mutable=False)
    #: bool: *Required* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: AutoAttendantKeyConfiguration: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyConfiguration, required=False, mutable=False,
    )


class AutoAttendantAddMenu19(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during after business hours.

    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file", "audioFile", LabeledMediaFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledMediaFileResource, is_complex=True),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool, is_required=True,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyConfiguration19,
            is_complex=True,
        ),
    )

    #: str: *Required* announcementSelection
    announcement_selection = Field(type=str, required=True, mutable=False)
    #: LabeledMediaFileResource: *Optional* audioFile
    audio_file = Field(type=LabeledMediaFileResource, required=False, mutable=False)
    #: LabeledMediaFileResource: *Optional* videoFile
    video_file = Field(type=LabeledMediaFileResource, required=False, mutable=False)
    #: bool: *Required* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: AutoAttendantKeyConfiguration19: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyConfiguration19, required=False, mutable=False,
    )


class AutoAttendantAddMenu20(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during after business hours.

    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file", "audioFile", AnnouncementFileLevelKey, is_complex=True),
        E("video_file", "videoFile", AnnouncementFileLevelKey, is_complex=True),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool, is_required=True,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyConfiguration20,
            is_complex=True,
        ),
    )

    #: str: *Required* announcementSelection
    announcement_selection = Field(type=str, required=True, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* audioFile
    audio_file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* videoFile
    video_file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: bool: *Required* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: AutoAttendantKeyConfiguration20: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyConfiguration20, required=False, mutable=False,
    )


class AutoAttendantModifyMenu(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during business hours.

    It is used when modifying an Auto Attendant group.
    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str),
        E("audio_file", "audioFile", LabeledFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledFileResource, is_complex=True),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyModifyConfiguration,
            is_complex=True,
        ),
    )

    #: str: *Optional* announcementSelection
    announcement_selection = Field(type=str, required=False, mutable=False)
    #: LabeledFileResource: *Optional* audioFile
    audio_file = Field(type=LabeledFileResource, required=False, mutable=False)
    #: LabeledFileResource: *Optional* videoFile
    video_file = Field(type=LabeledFileResource, required=False, mutable=False)
    #: bool: *Optional* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(
        type=bool, required=False, mutable=False,
    )
    #: AutoAttendantKeyModifyConfiguration: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyModifyConfiguration, required=False, mutable=False,
    )


class AutoAttendantModifyMenu16(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during business hours.

    It is used when modifying an Auto Attendant group.
    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str),
        E("audio_file", "audioFile", LabeledMediaFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledMediaFileResource, is_complex=True),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyModifyConfiguration,
            is_complex=True,
        ),
    )

    #: str: *Optional* announcementSelection
    announcement_selection = Field(type=str, required=False, mutable=False)
    #: LabeledMediaFileResource: *Optional* audioFile
    audio_file = Field(type=LabeledMediaFileResource, required=False, mutable=False)
    #: LabeledMediaFileResource: *Optional* videoFile
    video_file = Field(type=LabeledMediaFileResource, required=False, mutable=False)
    #: bool: *Optional* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(
        type=bool, required=False, mutable=False,
    )
    #: AutoAttendantKeyModifyConfiguration: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyModifyConfiguration, required=False, mutable=False,
    )


class AutoAttendantModifyMenu20(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during business hours.

    It is used when modifying an Auto Attendant group.
    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str),
        E("audio_file", "audioFile", AnnouncementFileLevelKey, is_complex=True),
        E("video_file", "videoFile", AnnouncementFileLevelKey, is_complex=True),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool,
        ),
        E(
            "key_configuration", "keyConfiguration",
            AutoAttendantKeyModifyConfiguration20, is_complex=True,
        ),
    )

    #: str: *Optional* announcementSelection
    announcement_selection = Field(type=str, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* audioFile
    audio_file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* videoFile
    video_file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: bool: *Optional* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(
        type=bool, required=False, mutable=False,
    )
    #: AutoAttendantKeyModifyConfiguration20: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyModifyConfiguration20, required=False, mutable=False,
    )


class AutoAttendantReadMenu(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during after business hours.

    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("video_file_description", "videoFileDescription", str),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool, is_required=True,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyConfiguration,
            is_complex=True,
        ),
    )

    #: str: *Required* announcementSelection
    announcement_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: bool: *Required* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: AutoAttendantKeyConfiguration: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyConfiguration, required=False, mutable=False,
    )


class AutoAttendantReadMenu16(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during after business hours.

    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool, is_required=True,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyConfiguration,
            is_complex=True,
        ),
    )

    #: str: *Required* announcementSelection
    announcement_selection = Field(type=str, required=True, mutable=False)
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* audioMediaType
    audio_media_type = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoFileDescription
    video_file_description = Field(type=str, required=False, mutable=False)
    #: str: *Optional* videoMediaType
    video_media_type = Field(type=str, required=False, mutable=False)
    #: bool: *Required* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: AutoAttendantKeyConfiguration: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyConfiguration, required=False, mutable=False,
    )


class AutoAttendantReadMenu20(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during after business hours.

    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file", "audioFile", AnnouncementFileLevelKey, is_complex=True),
        E("video_file", "videoFile", AnnouncementFileLevelKey, is_complex=True),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool, is_required=True,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyReadConfiguration20,
            is_complex=True,
        ),
    )

    #: str: *Required* announcementSelection
    announcement_selection = Field(type=str, required=True, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* audioFile
    audio_file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: AnnouncementFileLevelKey: *Optional* videoFile
    video_file = Field(type=AnnouncementFileLevelKey, required=False, mutable=False)
    #: bool: *Required* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(type=bool, required=True, mutable=False)
    #: AutoAttendantKeyReadConfiguration20: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyReadConfiguration20, required=False, mutable=False,
    )


class CommPilotExpressSRAvailableInOffice(OCIType):
    """
    CommPilot Express SR Available In Office Settings used in the context of a get.

    """

    _ELEMENTS = (
        E(
            "busy_setting", "busySetting", CommPilotExpressSRRedirection, is_complex=True,
            is_required=True,
        ),
        E(
            "no_answer_setting", "noAnswerSetting", CommPilotExpressSRNoAnswer,
            is_complex=True, is_required=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify", CommPilotExpressSREmailNotify,
            is_complex=True, is_required=True,
        ),
    )

    #: CommPilotExpressSRRedirection: *Required* busySetting
    busy_setting = Field(type=CommPilotExpressSRRedirection, required=True, mutable=False)
    #: CommPilotExpressSRNoAnswer: *Required* noAnswerSetting
    no_answer_setting = Field(type=CommPilotExpressSRNoAnswer, required=True, mutable=False)
    #: CommPilotExpressSREmailNotify: *Required* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressSREmailNotify, required=True, mutable=False,
    )


class CommPilotExpressSRAvailableInOfficeModify(OCIType):
    """
    CommPilot Express SR Available In Office Settings used in the context of a modify.

    """

    _ELEMENTS = (
        E(
            "busy_setting", "busySetting", CommPilotExpressSRRedirectionModify,
            is_complex=True,
        ),
        E(
            "no_answer_setting", "noAnswerSetting", CommPilotExpressSRNoAnswerModify,
            is_complex=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify",
            CommPilotExpressSREmailNotifyModify, is_complex=True,
        ),
    )

    #: CommPilotExpressSRRedirectionModify: *Optional* busySetting
    busy_setting = Field(
        type=CommPilotExpressSRRedirectionModify, required=False, mutable=False,
    )
    #: CommPilotExpressSRNoAnswerModify: *Optional* noAnswerSetting
    no_answer_setting = Field(
        type=CommPilotExpressSRNoAnswerModify, required=False, mutable=False,
    )
    #: CommPilotExpressSREmailNotifyModify: *Optional* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressSREmailNotifyModify, required=False, mutable=False,
    )


class CommPilotExpressSRAvailableOutOfOffice(OCIType):
    """
    CommPilot Express SR Available Out Of Office Configuration used in the context of a
    get.

    """

    _ELEMENTS = (
        E("remote_phone_number", "remotePhoneNumber", str),
        E(
            "no_answer_setting", "noAnswerSetting", CommPilotExpressSRNoAnswer,
            is_complex=True, is_required=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify", CommPilotExpressSREmailNotify,
            is_complex=True, is_required=True,
        ),
    )

    #: str: *Optional* remotePhoneNumber
    remote_phone_number = Field(type=str, required=False, mutable=False)
    #: CommPilotExpressSRNoAnswer: *Required* noAnswerSetting
    no_answer_setting = Field(type=CommPilotExpressSRNoAnswer, required=True, mutable=False)
    #: CommPilotExpressSREmailNotify: *Required* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressSREmailNotify, required=True, mutable=False,
    )


class CommPilotExpressSRAvailableOutOfOfficeModify(OCIType):
    """
    CommPilot Express SR Available Out Of Office Configuration used in the context of a
    modify.

    """

    _ELEMENTS = (
        E("remote_phone_number", "remotePhoneNumber", str),
        E(
            "no_answer_setting", "noAnswerSetting", CommPilotExpressSRNoAnswerModify,
            is_complex=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify",
            CommPilotExpressSREmailNotifyModify, is_complex=True,
        ),
    )

    #: str: *Optional* remotePhoneNumber
    remote_phone_number = Field(type=str, required=False, mutable=False)
    #: CommPilotExpressSRNoAnswerModify: *Optional* noAnswerSetting
    no_answer_setting = Field(
        type=CommPilotExpressSRNoAnswerModify, required=False, mutable=False,
    )
    #: CommPilotExpressSREmailNotifyModify: *Optional* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressSREmailNotifyModify, required=False, mutable=False,
    )


class SystemSIPDeviceTypeAddRequest18sp1V2(OCIType):
    """
    Request to add a sip device type.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in HSS data mode: enable3G4GContinuity, use value "false" in AS
    data mode The following elements are only used in AS data mode:
    holdAnnouncementMethod, use value "useInactive" in HSS data mode supportRFC3398, use
    value "false" in HSS data mode The following element values are only applicable in AS
    data mode: holdNormalization=useRfc3264Hold will raise an error in HSS data mode
    Replaced by: ``SystemSIPDeviceTypeAddRequest19()``.
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
        E(
            "number_of_ports", "numberOfPorts", UnboundedPositiveInt, is_complex=True,
            is_required=True,
        ),
        E("profile", "profile", str, is_required=True),
        E("registration_capable", "registrationCapable", bool, is_required=True),
        E("is_conference_device", "isConferenceDevice", bool, is_required=True),
        E("is_mobility_manager_device", "isMobilityManagerDevice", bool, is_required=True),
        E("is_music_on_hold_device", "isMusicOnHoldDevice", bool, is_required=True),
        E("hold_normalization", "holdNormalization", str, is_required=True),
        E("hold_announcement_method", "holdAnnouncementMethod", str, is_required=True),
        E("is_trusted", "isTrusted", bool, is_required=True),
        E("e164_capable", "E164Capable", bool, is_required=True),
        E("route_advance", "routeAdvance", bool, is_required=True),
        E("forwarding_override", "forwardingOverride", bool, is_required=True),
        E("wireless_integration", "wirelessIntegration", bool, is_required=True),
        E("web_based_config_url", "webBasedConfigURL", str),
        E("is_video_capable", "isVideoCapable", bool, is_required=True),
        E("pbx_integration", "PBXIntegration", bool, is_required=True),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("cpe_device_options", "cpeDeviceOptions", CPEDeviceOptions16sp1, is_complex=True),
        E("early_media_support", "earlyMediaSupport", str, is_required=True),
        E("authenticate_refer", "authenticateRefer", bool, is_required=True),
        E("auto_config_soft_client", "autoConfigSoftClient", bool, is_required=True),
        E("authentication_mode", "authenticationMode", str, is_required=True),
        E(
            "requires_broad_works_digit_collection", "requiresBroadWorksDigitCollection",
            bool, is_required=True,
        ),
        E(
            "requires_broad_works_call_waiting_tone", "requiresBroadWorksCallWaitingTone",
            bool, is_required=True,
        ),
        E("requires_mwi_subscription", "requiresMWISubscription", bool, is_required=True),
        E(
            "use_history_info_header_on_access_side", "useHistoryInfoHeaderOnAccessSide",
            bool, is_required=True,
        ),
        E("advice_of_charge_capable", "adviceOfChargeCapable", bool, is_required=True),
        E("reset_event", "resetEvent", str),
        E(
            "support_call_center_mime_type", "supportCallCenterMIMEType", bool,
            is_required=True,
        ),
        E("trunk_mode", "trunkMode", str, is_required=True),
        E("add_p_called_party_id", "addPCalledPartyId", bool, is_required=True),
        E(
            "support_identity_in_update_and_re_invite",
            "supportIdentityInUpdateAndReInvite", bool, is_required=True,
        ),
        E(
            "unscreened_presentation_identity_policy",
            "unscreenedPresentationIdentityPolicy", str, is_required=True,
        ),
        E("enable3_g4_g_continuity", "enable3G4GContinuity", bool, is_required=True),
        E(
            "support_emergency_disconnect_control", "supportEmergencyDisconnectControl",
            bool, is_required=True,
        ),
        E(
            "device_type_configuration_option", "deviceTypeConfigurationOption", str,
            is_required=True,
        ),
        E("support_rfc3398", "supportRFC3398", bool, is_required=True),
    )

    #: str: *Required* deviceType
    device_type = Field(type=str, required=True, mutable=False)
    #: UnboundedPositiveInt: *Required* numberOfPorts
    number_of_ports = Field(type=UnboundedPositiveInt, required=True, mutable=False)
    #: str: *Required* profile
    profile = Field(type=str, required=True, mutable=False)
    #: bool: *Required* registrationCapable
    registration_capable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isConferenceDevice
    is_conference_device = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isMobilityManagerDevice
    is_mobility_manager_device = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* isMusicOnHoldDevice
    is_music_on_hold_device = Field(type=bool, required=True, mutable=False)
    #: str: *Required* holdNormalization
    hold_normalization = Field(type=str, required=True, mutable=False)
    #: str: *Required* holdAnnouncementMethod
    hold_announcement_method = Field(type=str, required=True, mutable=False)
    #: bool: *Required* isTrusted
    is_trusted = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* E164Capable
    e164_capable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* routeAdvance
    route_advance = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* forwardingOverride
    forwarding_override = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* wirelessIntegration
    wireless_integration = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* webBasedConfigURL
    web_based_config_url = Field(type=str, required=False, mutable=False)
    #: bool: *Required* isVideoCapable
    is_video_capable = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* PBXIntegration
    pbx_integration = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(type=bool, required=True, mutable=False)
    #: CPEDeviceOptions16sp1: *Optional* cpeDeviceOptions
    cpe_device_options = Field(type=CPEDeviceOptions16sp1, required=False, mutable=False)
    #: str: *Required* earlyMediaSupport
    early_media_support = Field(type=str, required=True, mutable=False)
    #: bool: *Required* authenticateRefer
    authenticate_refer = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* autoConfigSoftClient
    auto_config_soft_client = Field(type=bool, required=True, mutable=False)
    #: str: *Required* authenticationMode
    authentication_mode = Field(type=str, required=True, mutable=False)
    #: bool: *Required* requiresBroadWorksDigitCollection
    requires_broad_works_digit_collection = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* requiresBroadWorksCallWaitingTone
    requires_broad_works_call_waiting_tone = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* requiresMWISubscription
    requires_mwi_subscription = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* useHistoryInfoHeaderOnAccessSide
    use_history_info_header_on_access_side = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* adviceOfChargeCapable
    advice_of_charge_capable = Field(type=bool, required=True, mutable=False)
    #: str: *Optional* resetEvent
    reset_event = Field(type=str, required=False, mutable=False)
    #: bool: *Required* supportCallCenterMIMEType
    support_call_center_mime_type = Field(type=bool, required=True, mutable=False)
    #: str: *Required* trunkMode
    trunk_mode = Field(type=str, required=True, mutable=False)
    #: bool: *Required* addPCalledPartyId
    add_p_called_party_id = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* supportIdentityInUpdateAndReInvite
    support_identity_in_update_and_re_invite = Field(type=bool, required=True, mutable=False)
    #: str: *Required* unscreenedPresentationIdentityPolicy
    unscreened_presentation_identity_policy = Field(type=str, required=True, mutable=False)
    #: bool: *Required* enable3G4GContinuity
    enable3_g4_g_continuity = Field(type=bool, required=True, mutable=False)
    #: bool: *Required* supportEmergencyDisconnectControl
    support_emergency_disconnect_control = Field(type=bool, required=True, mutable=False)
    #: str: *Required* deviceTypeConfigurationOption
    device_type_configuration_option = Field(type=str, required=True, mutable=False)
    #: bool: *Required* supportRFC3398
    support_rfc3398 = Field(type=bool, required=True, mutable=False)


# fmt: on
# end
