"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Stack verification steps:
 * - Deploy with `--no-clean`
 * - Verify that the CloudFormation stack outputs have the following values:
 *   - Ref: "MyPhysicalReflectBack"
 *   - GetAtt.Attribute1: "foo"
 *   - GetAtt.Attribute2: 1234
 */
const core_1 = require("@aws-cdk/core");
class TestStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        const resourceType = 'Custom::Reflect';
        const serviceToken = core_1.CustomResourceProvider.getOrCreate(this, resourceType, {
            codeDirectory: `${__dirname}/core-custom-resource-provider-fixture`,
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_12,
        });
        const cr = new core_1.CustomResource(this, 'MyResource', {
            resourceType,
            serviceToken,
            properties: {
                physicalResourceId: 'MyPhysicalReflectBack',
                attributes: {
                    Attribute1: 'foo',
                    Attribute2: 1234,
                },
            },
        });
        new core_1.CfnOutput(this, 'Ref', { value: cr.ref });
        new core_1.CfnOutput(this, 'GetAtt.Attribute1', { value: core_1.Token.asString(cr.getAtt('Attribute1')) });
        new core_1.CfnOutput(this, 'GetAtt.Attribute2', { value: core_1.Token.asString(cr.getAtt('Attribute2')) });
    }
}
const app = new core_1.App();
new TestStack(app, 'custom-resource-test');
app.synth();
//# sourceMappingURL=data:application/json;base64,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