"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sns = require("@aws-cdk/aws-sns");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const top = new core_1.Stack(app, 'nested-stacks-multi-refs');
const level1 = new sns.Topic(top, 'Level1');
const nested1 = new lib_1.NestedStack(top, 'Nested1');
const nested2 = new lib_1.NestedStack(nested1, 'Nested2');
const nested3 = new lib_1.NestedStack(nested2, 'Nested3');
// WHEN
const level2 = new sns.Topic(nested2, 'Level2ReferencesLevel1', {
    displayName: shortName(level1.topicName),
});
new sns.Topic(nested3, 'Level3ReferencesLevel1', {
    displayName: shortName(level1.topicName),
});
new sns.Topic(nested3, 'Level3ReferencesLevel2', {
    displayName: shortName(level2.topicName),
});
app.synth();
// topicName is too long for displayName, so just take the second part:
// Stack1-NestedUnderStack1NestedStackNestedUnderStack1NestedStackResourceF616305B-EM64TEGA04J9-TopicInNestedUnderStack115E329C4-HEO7NLYC1AFL
function shortName(topicName) {
    return core_1.Fn.select(1, core_1.Fn.split('-', topicName));
}
//# sourceMappingURL=data:application/json;base64,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