"use strict";
/// !cdk-integ Stack1 Stack2
Object.defineProperty(exports, "__esModule", { value: true });
const sns = require("@aws-cdk/aws-sns");
const core_1 = require("@aws-cdk/core");
const cfn = require("../lib");
const app = new core_1.App();
const stack1 = new core_1.Stack(app, 'Stack1');
const stack2 = new core_1.Stack(app, 'Stack2');
const nestedUnderStack1 = new cfn.NestedStack(stack1, 'NestedUnderStack1');
const topicInNestedUnderStack1 = new sns.Topic(nestedUnderStack1, 'TopicInNestedUnderStack1');
new sns.Topic(stack2, 'TopicInStack2', {
    // topicName is too long for displayName, so just take the second part:
    // Stack1-NestedUnderStack1NestedStackNestedUnderStack1NestedStackResourceF616305B-EM64TEGA04J9-TopicInNestedUnderStack115E329C4-HEO7NLYC1AFL
    displayName: core_1.Fn.select(1, core_1.Fn.split('-', topicInNestedUnderStack1.topicName)),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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