"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
const fs = require("fs");
const lib_1 = require("../lib");
class DemoResource extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const resource = new lib_1.CustomResource(this, 'Resource', {
            provider: lib_1.CustomResourceProvider.fromLambda(new lambda.SingletonFunction(this, 'Singleton', {
                uuid: 'f7d4f730-4ee1-11e8-9c2d-fa7ae01bbebc',
                // This makes the demo only work as top-level TypeScript program, but that's fine for now
                code: new lambda.InlineCode(fs.readFileSync('integ.trivial-lambda-provider.py', { encoding: 'utf-8' })),
                handler: 'index.main',
                timeout: cdk.Duration.minutes(5),
                runtime: lambda.Runtime.PYTHON_2_7,
            })),
            properties: props,
        });
        this.response = resource.getAtt('Response').toString();
    }
}
/**
 * A stack that only sets up the CustomResource and shows how to get an attribute from it
 */
class SucceedingStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const resource = new DemoResource(this, 'DemoResource', {
            message: 'CustomResource says hello',
        });
        // Publish the custom resource output
        new cdk.CfnOutput(this, 'ResponseMessage', {
            description: 'The message that came back from the Custom Resource',
            value: resource.response,
        });
    }
}
const app = new cdk.App();
new SucceedingStack(app, 'SucceedingStack');
app.synth();
//# sourceMappingURL=data:application/json;base64,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