"""MeSH descriptors from raw/mesh/d2020.bin."""

__copyright__ = "Copyright (C) 2014-2020, DV Klopfenstein. all rights reserved."
__author__ = "DV Klopfenstein"

from collections import namedtuple

# 29,640 MeSH unique identifiers
# pylint: disable=too-many-lines
NtO = namedtuple('NtMhDesc', 'MH MS')
UI2NT = {
  'D000001': NtO(MH='Calcimycin', MS='An ionophorous, polyether antibiotic from Streptomyces chartreusensis. It binds and transports CALCIUM and other divalent cations across membranes and uncouples oxidative phosphorylation while inhibiting ATPase of rat liver mitochondria. The substance is used mostly as a biochemical tool to study the role of divalent cations in various biological systems.'),
  'D000002': NtO(MH='Temefos', MS='An organothiophosphate insecticide.'),
  'D000003': NtO(MH='Abattoirs', MS='Places where animals are slaughtered and dressed for market.'),
  'D000004': NtO(MH='Abbreviations as Topic', MS='Works about shortened forms of written words or phrases used for brevity.'),
  'D000005': NtO(MH='Abdomen', MS='That portion of the body that lies between the THORAX and the PELVIS.'),
  'D000006': NtO(MH='Abdomen, Acute', MS='A clinical syndrome with acute abdominal pain that is severe, localized, and rapid in onset. Acute abdomen may be caused by a variety of disorders, injuries, or diseases.'),
  'D000007': NtO(MH='Abdominal Injuries', MS='General or unspecified injuries involving organs in the abdominal cavity.'),
  'D000008': NtO(MH='Abdominal Neoplasms', MS='New abnormal growth of tissue in the ABDOMEN.'),
  'D000009': NtO(MH='Abdominal Muscles', MS='Muscles forming the ABDOMINAL WALL including RECTUS ABDOMINIS; ABDOMINAL OBLIQUE MUSCLES, transversus abdominis, pyramidalis muscles and quadratus abdominis.'),
  'D000010': NtO(MH='Abducens Nerve', MS='The 6th cranial nerve which originates in the ABDUCENS NUCLEUS of the PONS and sends motor fibers to the lateral rectus muscles of the EYE. Damage to the nerve or its nucleus disrupts horizontal eye movement control.'),
  'D000011': NtO(MH='Abelson murine leukemia virus', MS='A replication-defective strain of Murine leukemia virus (LEUKEMIA VIRUS, MURINE) capable of transforming lymphoid cells and producing a rapidly progressing lymphoid leukemia after superinfection with FRIEND MURINE LEUKEMIA VIRUS; MOLONEY MURINE LEUKEMIA VIRUS; or RAUSCHER VIRUS.'),
  'D000012': NtO(MH='Abetalipoproteinemia', MS='An autosomal recessive disorder of lipid metabolism. It is caused by mutation of the microsomal triglyceride transfer protein that catalyzes the transport of lipids (TRIGLYCERIDES; CHOLESTEROL ESTERS; PHOSPHOLIPIDS) and is required in the secretion of BETA-LIPOPROTEINS (low density lipoproteins or LDL). Features include defective intestinal lipid absorption, very low serum cholesterol level, and near absent LDL.'),
  'D000013': NtO(MH='Congenital Abnormalities', MS='Malformations of organs or body parts during development in utero.'),
  'D000014': NtO(MH='Abnormalities, Drug-Induced', MS='Congenital abnormalities caused by medicinal substances or drugs of abuse given to or taken by the mother, or to which she is inadvertently exposed during the manufacture of such substances. The concept excludes abnormalities resulting from exposure to non-medicinal chemicals in the environment.'),
  'D000015': NtO(MH='Abnormalities, Multiple', MS='Congenital abnormalities that affect more than one organ or body structure.'),
  'D000016': NtO(MH='Abnormalities, Radiation-Induced', MS='Congenital changes in the morphology of organs produced by exposure to ionizing or non-ionizing radiation.'),
  'D000017': NtO(MH='ABO Blood-Group System', MS='The major human blood type system which depends on the presence or absence of two antigens A and B. Type O occurs when neither A nor B is present and AB when both are present. A and B are genetic factors that determine the presence of enzymes for the synthesis of certain glycoproteins mainly in the red cell membrane.'),
  'D000018': NtO(MH='Abomasum', MS='The fourth stomach of ruminating animals. It is also called the "true" stomach. It is an elongated pear-shaped sac lying on the floor of the abdomen, on the right-hand side, and roughly between the seventh and twelfth ribs. It leads to the beginning of the small intestine. (From Black\'s Veterinary Dictionary, 17th ed)'),
  'D000019': NtO(MH='Abortifacient Agents', MS='Chemical substances that interrupt pregnancy after implantation.'),
  'D000020': NtO(MH='Abortifacient Agents, Nonsteroidal', MS='Non-steroidal chemical compounds with abortifacient activity.'),
  'D000021': NtO(MH='Abortifacient Agents, Steroidal', MS='Steroidal compounds with abortifacient activity.'),
  'D000022': NtO(MH='Abortion, Spontaneous', MS='Expulsion of the product of FERTILIZATION before completing the term of GESTATION and without deliberate interference.'),
  'D000023': NtO(MH='Abortion Applicants', MS='Individuals requesting induced abortions.'),
  'D000024': NtO(MH='Abortion, Criminal', MS='Illegal termination of pregnancy.'),
  'D000025': NtO(MH='Abortion, Eugenic', MS='Abortion performed because of possible fetal defects.'),
  'D000026': NtO(MH='Abortion, Habitual', MS='Three or more consecutive spontaneous abortions.'),
  'D000027': NtO(MH='Abortion, Incomplete', MS='Premature loss of PREGNANCY in which not all the products of CONCEPTION have been expelled.'),
  'D000028': NtO(MH='Abortion, Induced', MS='Intentional removal of a fetus from the uterus by any of a number of techniques. (POPLINE, 1978)'),
  'D000029': NtO(MH='Abortion, Legal', MS='Termination of pregnancy under conditions allowed under local laws. (POPLINE Thesaurus, 1991)'),
  'D000030': NtO(MH='Abortion, Missed', MS='The retention in the UTERUS of a dead FETUS two months or more after its DEATH.'),
  'D000031': NtO(MH='Abortion, Septic', MS='Any type of abortion, induced or spontaneous, that is associated with infection of the UTERUS and its appendages. It is characterized by FEVER, uterine tenderness, and foul discharge.'),
  'D000032': NtO(MH='Abortion, Therapeutic', MS='Abortion induced to save the life or health of a pregnant woman. (From Dorland, 28th ed)'),
  'D000033': NtO(MH='Abortion, Threatened', MS='UTERINE BLEEDING from a GESTATION of less than 20 weeks without any CERVICAL DILATATION. It is characterized by vaginal bleeding, lower back discomfort, or midline pelvic cramping and a risk factor for MISCARRIAGE.'),
  'D000034': NtO(MH='Abortion, Veterinary', MS='Premature expulsion of the FETUS in animals.'),
  'D000035': NtO(MH='Abreaction', MS='A process in psychotherapy in which the patient is "desensitized" to emotionally painful, often forgotten (repressed) memories by recalling and reacting to them in the "safety" of the treatment setting.'),
  'D000036': NtO(MH='Abrin', MS='A toxic lectin from the seeds of jequirity, Abrus precatorius L. Very active poison. Five different proteins have so far been isolated: Abrus agglutinin, the component responsible for: hemagglutinating activity, & abrins a-d, the toxic principals each consisting of two peptide chains are held together by disulfide bonds.'),
  'D000037': NtO(MH='Abruptio Placentae', MS='Premature separation of the normally implanted PLACENTA from the UTERUS. Signs of varying degree of severity include UTERINE BLEEDING, uterine MUSCLE HYPERTONIA, and FETAL DISTRESS or FETAL DEATH.'),
  'D000038': NtO(MH='Abscess', MS='Accumulation of purulent material in tissues, organs, or circumscribed spaces, usually associated with signs of infection.'),
  'D000039': NtO(MH='Peritonsillar Abscess', MS='An accumulation of purulent material in the area between the PALATINE TONSIL and its capsule.'),
  'D000040': NtO(MH='Abscisic Acid', MS='Abscission-accelerating plant growth substance isolated from young cotton fruit, leaves of sycamore, birch, and other plants, and from potatoes, lemons, avocados, and other fruits.'),
  'D000041': NtO(MH='Absenteeism', MS='Chronic absence from work or other duty.'),
  'D000042': NtO(MH='Absorption', MS='The physical or physiological processes by which substances, tissue, cells, etc. take up or take in other substances or energy.'),
  'D000043': NtO(MH='Abstracting and Indexing', MS='Works about activities performed to identify concepts and aspects of published information and research reports.'),
  'D000044': NtO(MH='Dental Abutments', MS='Natural teeth or teeth roots used as anchorage for a fixed or removable denture or other prosthesis (such as an implant) serving the same purpose.'),
  'D000045': NtO(MH='Acacia', MS='A plant genus of the family FABACEAE. The gums and tanning agents obtained from Acacia are called GUM ARABIC. The common name catechu is more often used for Areca catechu (ARECA).'),
  'D000046': NtO(MH='Academic Medical Centers', MS='Medical complexes consisting of medical school, hospitals, clinics, libraries, administrative facilities, etc.'),
  'D000047': NtO(MH='Academies and Institutes', MS='Organizations representing specialized fields which are accepted as authoritative; may be non-governmental, university or an independent research organization, e.g., National Academy of Sciences, Brookings Institution, etc.'),
  'D000048': NtO(MH='Acanthamoeba', MS='A genus of free-living soil amoebae that produces no flagellate stage. Its organisms are pathogens for several infections in humans and have been found in the eye, bone, brain, and respiratory tract.'),
  'D000049': NtO(MH='Acanthocephala', MS='A phylum of parasitic worms, closely related to tapeworms and containing two genera: Moniliformis, which sometimes infects man, and Macracanthorhynchus, which infects swine.'),
  'D000050': NtO(MH='Acanthocytes', MS='Erythrocytes with protoplasmic projections giving the cell a thorny appearance.'),
  'D000051': NtO(MH='Acantholysis', MS='Separation of the prickle cells of the stratum spinosum of the epidermis, resulting in atrophy of the prickle cell layer. It is seen in diseases such as pemphigus vulgaris (see PEMPHIGUS) and DARIER DISEASE.'),
  'D000052': NtO(MH='Acanthosis Nigricans', MS='A circumscribed melanosis consisting of a brown-pigmented, velvety verrucosity or fine papillomatosis appearing in the axillae and other body folds. It occurs in association with endocrine disorders, underlying malignancy, administration of certain drugs, or as in inherited disorder.'),
  'D000053': NtO(MH='Acari', MS='A large, subclass of arachnids comprising the MITES and TICKS, including parasites of plants, animals, and humans, as well as several important disease vectors.'),
  'D000054': NtO(MH='Acceleration', MS='An increase in the rate of speed.'),
  'D000055': NtO(MH='Accessory Nerve', MS='The 11th cranial nerve which originates from NEURONS in the MEDULLA and in the CERVICAL SPINAL CORD. It has a cranial root, which joins the VAGUS NERVE (10th cranial) and sends motor fibers to the muscles of the LARYNX, and a spinal root, which sends motor fibers to the TRAPEZIUS and the sternocleidomastoid muscles.'),
  'D000056': NtO(MH='Accident Prevention', MS='Efforts and designs to reduce the incidence of unexpected undesirable events in various environments and situations.'),
  'D000057': NtO(MH='Accident Proneness', MS='Tendency toward involvement in accidents. Implies certain personality characteristics which predispose to accidents.'),
  'D000058': NtO(MH='Accidental Falls', MS='Falls due to slipping or tripping which may result in injury.'),
  'D000059': NtO(MH='Accidents', MS='Unexpected and unintentional events, typically resulting in ACCIDENTAL INJURIES.'),
  'D000060': NtO(MH='Accidents, Aviation', MS='Unanticipated events associated with AIRCRAFT.'),
  'D000061': NtO(MH='Accidents, Home', MS='ACCIDENTS which occur within the home.'),
  'D000062': NtO(MH='Accidents, Occupational', MS='Unforeseen occurrences, especially injuries in the course of work-related activities.'),
  'D000063': NtO(MH='Accidents, Traffic', MS='Accidents on streets, roads, and highways involving drivers, passengers, pedestrians, or vehicles. Traffic accidents refer to AUTOMOBILES (passenger cars, buses, and trucks), BICYCLING, and MOTORCYCLES but not OFF-ROAD MOTOR VEHICLES; RAILROADS nor snowmobiles.'),
  'D000064': NtO(MH='Acclimatization', MS='Adaptation to a new environment or to a change in the old.'),
  'D000065': NtO(MH='Accommodation, Ocular', MS='The dioptric adjustment of the EYE (to attain maximal sharpness of retinal imagery for an object of regard) referring to the ability, to the mechanism, or to the process. Ocular accommodation is the effecting of refractive changes by changes in the shape of the CRYSTALLINE LENS. Loosely, it refers to ocular adjustments for VISION, OCULAR at various distances. (Cline et al., Dictionary of Visual Science, 4th ed)'),
  'D000066': NtO(MH='Accounting', MS='System of recording financial transactions.'),
  'D000066388': NtO(MH='Oil and Gas Industry', MS='INDUSTRY concerned with the extraction, processing, distribution, marketing and storage of PETROLEUM and NATURAL GAS.'),
  'D000066428': NtO(MH='Coal Industry', MS='Enterprise associated with the mining, processing, marketing and distribution of COAL.'),
  'D000066448': NtO(MH='Driving Under the Influence', MS='Operating a motor vehicle while impaired by alcohol or other drugs including those prescribed by physicians.'),
  'D000066449': NtO(MH='Human Embryonic Stem Cells', MS='A type of PLURIPOTENT STEM CELLS derived from early stage human embryos, up to and including the BLASTOCYST stage.'),
  'D000066450': NtO(MH='Mouse Embryonic Stem Cells', MS='PLURIPOTENT STEM CELLS derived from the BLASTOCYST INNER CELL MASS of day 3.5 mouse embryos.'),
  'D000066473': NtO(MH='Embryonic Germ Cells', MS='PLURIPOTENT STEM CELLS that are derived from early GERM CELLS.'),
  'D000066477': NtO(MH='Work Performance', MS='Measure of how well someone performs given tasks at their place of work.'),
  'D000066479': NtO(MH='Criminal Behavior', MS='Conduct leading to commission of unlawful acts.'),
  'D000066491': NtO(MH='Clinical Decision-Making', MS='Process of formulating a diagnosis based on medical history and physical or mental examinations, and/or choosing an appropriate intervention.'),
  'D000066492': NtO(MH='Cognitive Aging', MS='Phenomenon that occurs when learning and memory abilities decrease naturally due to age.'),
  'D000066494': NtO(MH='Cognitive Neuroscience', MS='Field of study concerning MENTAL PROCESSES; LEARNING; and the brain regions associated with them.'),
  'D000066498': NtO(MH='Emotional Adjustment', MS='Psychological process that occurs when an individual adapts to a significant emotional event or stimulus.'),
  'D000066499': NtO(MH='Facial Recognition', MS='Ability to identify an individual and interpret their feelings and emotions based on their facial expressions.'),
  'D000066502': NtO(MH='Grandparents', MS='Member of a family who has children and grandchildren.'),
  'D000066505': NtO(MH='Help-Seeking Behavior', MS='Form of social behavior in which assistance is sought from others.'),
  'D000066506': NtO(MH='Heuristics', MS='Experience-based techniques for problem-solving, learning, and discovery that find a solution which is not guaranteed to be optimal, but sufficient for a given set of goals.'),
  'D000066511': NtO(MH='Intimate Partner Violence', MS='A pattern of assaultive and coercive behavior by an individual against their partner or spouse that may include physical injury, psychological abuse, sexual assault, progressive isolation, stalking, deprivation, intimidation, and reproductive coercion.'),
  'D000066530': NtO(MH='Neurological Rehabilitation', MS='Physician-supervised programs designed to rehabilitate people with diseases, trauma, or disorders of the NERVOUS SYSTEM.'),
  'D000066550': NtO(MH='Physical Abuse', MS='Violence inflicted on an individual through physical contact.'),
  'D000066553': NtO(MH='Problem Behavior', MS='Troublesome or disruptive behavioral displays.'),
  'D000066608': NtO(MH='Underage Drinking', MS='Consumption of ALCOHOLIC BEVERAGES by persons under the legal drinking age.'),
  'D000066630': NtO(MH='Ectopic Gene Expression', MS='The expression of a gene in an abnormal place,  or at an abnormal  time in an organism. Ectopic Gene  Expression is often induced artificially by genetic techniques.'),
  'D000066670': NtO(MH='Cell Plasticity', MS='The ability of a cell to change its PHENOTYPE in response to changes in the environment.'),
  'D000066673': NtO(MH='Cell Self Renewal', MS='The ability of certain cell types, such as progenitor cells or tumor cells,  to go through numerous cycles of CELL DIVISION while still maintaining an undifferentiated or partially differentiated state.'),
  'D000066768': NtO(MH='Rehabilitation Research', MS='Studies and research concerning the psychological, educational, social, vocational, industrial, and economic aspects of REHABILITATION.'),
  'D000066792': NtO(MH='Orthodontists', MS='Dentists who specialize in the treatment of misaligned TEETH and MALOCCLUSION.'),
  'D000066794': NtO(MH='Oral and Maxillofacial Surgeons', MS='Dentists who specialize in the surgical treatment of injuries, diseases, and abnormalities of the oral and maxillofacial regions.'),
  'D000066829': NtO(MH='Neuroprotection', MS='The physiological processes and techniques used by the body to prevent neuronal injury and degeneration in the central nervous system following acute disorders or as a result of chronic neurodegenerative diseases.'),
  'D000066888': NtO(MH='Diet, Food, and Nutrition', MS='Concepts involved with nutritional physiology, including categories of substances eaten for sustenance, nutritional phenomena and processes, eating patterns and habits, and measurable nutritional parameters.'),
  'D000066889': NtO(MH='Triticale', MS='A CEREAL GRAIN plant resulting from a cross between TRITICUM and SECALE CEREALE.'),
  'D000066891': NtO(MH='Critical Care Outcomes', MS='A measure of the mortality and morbidity rates among patients who receive CRITICAL CARE and INTENSIVE CARE as determined from the date of hospital discharge or release.'),
  'D000066908': NtO(MH='Simulation Training', MS='A highly customized interactive medium or program that allows individuals to learn and practice real world activities in an accurate, realistic, safe and secure environment.'),
  'D000066928': NtO(MH='Millets', MS='An agronomic group especially of small-seeded grasses, mainly grown for human and animal consumption.'),
  'D000066949': NtO(MH='Biobehavioral Sciences', MS='An interdisciplinary scientific approach to the study of complex interactions among biological, social, behavioral and environmental factors.'),
  'D000066970': NtO(MH='Protein Corona', MS='A layer of protein coating adsorbed by NANOPARTICLES upon entry into PLASMA or other protein-containing biological fluids, which affects how nanoparticles are internalized by cells and cleared from the body.'),
  'D000066988': NtO(MH='Vegetarians', MS='Persons who do not eat MEAT.'),
  'D000066989': NtO(MH='Vegans', MS='Persons who avoid consuming animal products or animal-derived substances, such as MEAT; EGGS; or HONEY.  Some vegans also refrain from using animals or animal products in any form or for any purpose, such as in CLOTHING or household goods.'),
  'D000067': NtO(MH='Accounts Payable and Receivable', MS='Short-term debt obligations and assets occurring in the regular course of operational transactions.'),
  'D000067009': NtO(MH='Youth Sports', MS='SPORTS activities designed and/or organized for CHILDREN or YOUTH.'),
  'D000067010': NtO(MH='Literacy', MS='Ability to read and write.'),
  'D000067011': NtO(MH='Severe Acute Malnutrition', MS='Acute form of MALNUTRITION which usually affects children, characterized by a very low weight for height (below -3z scores of the median World Health Organization standards), visible severe wasting, or occurrence of nutritional EDEMA.  It can be a direct or indirect cause of fatality in children suffering from DIARRHEA and PNEUMONIA. Do not confuse with starvation, a condition in which the body is not getting enough food, usually for extended periods of time.'),
  'D000067012': NtO(MH='Banking, Personal', MS='A financial account set up between a financial institution (such as a commercial bank) and a customer (individual, group, or business), whereby the latter may deposit and withdraw money, and where applicable, be paid interest.'),
  'D000067013': NtO(MH='Evidence-Based Facility Design', MS='An approach, process, or methodology which emphasizes credible evidence and the best available scientific knowledge, judiciously integrated to achieve the best possible outcomes in structural design. For example, the design of a new OUTPATIENT CLINIC might incorporate a review of published research on outpatient clinic design, decisions on similar past projects, along with interviews with staff and consumers.'),
  'D000067029': NtO(MH='Physical Appearance, Body', MS='The superficial physical looks, characteristics or qualities of an individual as distinguished from the underlying unseen nature or attributes.'),
  'D000067030': NtO(MH='Fruit and Vegetable Juices', MS='The liquids extracted from plants.'),
  'D000067048': NtO(MH='Ghee', MS='The clarified portion of milk, cream, or butter obtained by the removal of the nonfat constituents. (from Dictionary of Food Ingredients, 4th ed., 2001)'),
  'D000067071': NtO(MH='Hydraulic Fracking', MS='A drilling technology in which NATURAL GAS is extracted from large deposits of impermeable rock formations known as shale, deep within the earth\xe2\x80\x99s crust. This drilling technique involves injecting large volumes of high-pressure fracturing fluid (a mixture of water, sand, and chemicals) several thousand feet underground, thereby creating cracks or fissures in the shale formation, and releasing trapped gas.'),
  'D000067073': NtO(MH='Psychological Trauma', MS='An emotionally painful, shocking, stressful, and sometimes life-threatening experience. It can result from witnessing distressing events such as natural disasters, physical or sexual abuse, and terrorism or other acts of violence. (https://www.nimh.nih.gov/health/)'),
  'D000067074': NtO(MH='Peer Influence', MS='The effect or sway that a PEER GROUP exerts on the beliefs, value systems and behavior of each member of a group. The social expectations for individuals to conform to peer group influence is known as peer pressure.'),
  'D000067075': NtO(MH='Vegetable Products', MS='Food that is manufactured from various parts of vegetables.'),
  'D000067088': NtO(MH='Direct-to-Consumer Advertising', MS='Advertising that directly targets consumers of certain products such as pharmaceuticals.'),
  'D000067108': NtO(MH='Direct-To-Consumer Screening and Testing', MS='Laboratory testing and diagnostic imaging services offered to consumers outside of the patient-physician relationship.'),
  'D000067128': NtO(MH='Extracellular Vesicles', MS='Membrane limited structures derived from cell membranes and cytoplasmic material, and released into EXTRACELLULAR SPACE. They circulate through the EXTRACELLULAR FLUID and through the peripheral blood in the MICROVASCULATURE where cells, much larger, cannot, thereby affecting a variety of intercellular communication processes.'),
  'D000067148': NtO(MH='Fungal Viruses', MS='Viruses infecting species of FUNGI.'),
  'D000067170': NtO(MH='Telocytes', MS='A type of interstitial cells that have very long and thin CELL SURFACE EXTENSIONS called TELOPODES.'),
  'D000067190': NtO(MH='Exoskeleton Device', MS='Device designed to wear externally to support muscular skeletal system in various movements such as RANGE OF MOTIONS; WEIGHT-BEARING; GAIT; and LOCOMOTION.'),
  'D000067208': NtO(MH='Shellfish Hypersensitivity', MS='Allergic reaction to SHELLFISH or shellfish products.'),
  'D000067248': NtO(MH='Failure to Rescue, Health Care', MS='Inability to prevent a clinical deterioration resulting from a complication of an underlying medical condition or a complication of medical care. It implies that common risk factors for such a complication were not recognized in a timely manner or treated appropriately.'),
  'D000067250': NtO(MH='Psychiatric Rehabilitation', MS='Specialty field that promotes recovery, community functioning, and increased well-being of individuals diagnosed with mental disorders that impair their ability to live meaningful lives.'),
  'D000067251': NtO(MH='Symptom Flare Up', MS='A transient exacerbation of symptoms of an existing disease or condition.'),
  'D000067268': NtO(MH='Isolated Heart Preparation', MS='Method of isolation and maintenance of a working heart for various cardiac measurements. The model allows for the separation of cardiac and systemic variables in the denervated heart.'),
  'D000067269': NtO(MH='Diet, Vegan', MS='Dietary practice of avoiding animal products in any form.'),
  'D000067289': NtO(MH='Behavior Observation Techniques', MS='A wide range of formal and informal techniques used to document behavior.'),
  'D000067290': NtO(MH='Behavior Rating Scale', MS='Instrument designed to assess human or animal behavior, using a standardized format.'),
  'D000067292': NtO(MH='Alcohol Drinking in College', MS='Alcohol consumption among college students.'),
  'D000067329': NtO(MH='Obesity, Metabolically Benign', MS='A sub-PHENOTYPE of obese individuals who have a risk for CARDIOVASCULAR DISEASES between that of healthy individuals with normal weight and unhealthy individuals with obesity.'),
  'D000067348': NtO(MH='Whole Grains', MS='Edible seeds which contain all components of the seed - germ, bran, and ENDOSPERM.'),
  'D000067368': NtO(MH='Transanal Endoscopic Surgery', MS='Surgical procedures performed through the anus using a PROCTOSCOPE.'),
  'D000067369': NtO(MH='Transanal Endoscopic Microsurgery', MS='A specialized form of transanal endoscopic surgery for microscopically controlled operations in the RECTUM.'),
  'D000067390': NtO(MH='Cold Injury', MS='A physical injury caused by exposure of the body to extremely low ambient temperatures that may lead to loss of body parts, or in extreme cases, death. Examples of cold injury are FROSTBITE and CHILBLAINS.'),
  'D000067393': NtO(MH='Personal Protective Equipment', MS='Specialized clothing or equipment worn for protection against health hazards. Personal Protective Equipment may include MASKS; RESPIRATORY PROTECTIVE DEVICES; HEAD PROTECTIVE DEVICES; EYE PROTECTIVE DEVICES; EAR PROTECTIVE DEVICES; PROTECTIVE CLOTHING; and protective footwear.'),
  'D000067397': NtO(MH='Nerve Agents', MS='A class of compounds that adversely affect the transmission of impulses through the NERVOUS SYSTEM.'),
  'D000067398': NtO(MH='War-Related Injuries', MS='WOUNDS and INJURIES and PSYCHOLOGICAL TRAUMA sustained during WAR.'),
  'D000067399': NtO(MH='Abnormal Involuntary Movement Scale', MS='A rating scale that measures INVOLUNTARY MOVEMENTS known as TARDIVE DYSKINESIA.'),
  'D000067401': NtO(MH='Blood Alcohol Content', MS='Mass of alcohol per unit of BLOOD volume.'),
  'D000067404': NtO(MH='Social Communication Disorder', MS='Persistent difficulties in the social uses of verbal and nonverbal communications. (DSM-V)'),
  'D000067408': NtO(MH='Legal Services', MS='Services provided by ATTORNEYS and paralegal staff.'),
  'D000067448': NtO(MH='Defamation', MS='Public false statements that are illegal and damaging to the reputation of a person, group, business, organization, or institution.'),
  'D000067449': NtO(MH='Anger Management Therapy', MS='System of psychological and/or therapeutic techniques used to control and or reduce the triggers, degrees, and effects of ANGER.'),
  'D000067450': NtO(MH='Psychology, Sports', MS='Field of research that studies mental factors influencing the attainment of athletic skills and athletic performance.'),
  'D000067453': NtO(MH='War Exposure', MS='The health and other ramifications of military and civilian exposure to WAR .'),
  'D000067454': NtO(MH='Childhood-Onset Fluency Disorder', MS="Disturbances in the normal fluency and time patterning of speech that are inappropriate for the individual's age and language skills. (DSM-V)"),
  'D000067455': NtO(MH='No-Show Patients', MS='PATIENTS who do not turn up for scheduled healthcare appointments. Do not confuse with PATIENT DROPOUTS.'),
  'D000067470': NtO(MH='Cellular Reprogramming Techniques', MS='Procedures used for the induction of CELLULAR REPROGRAMMING to change the terminal phenotype of a cell, such as the generation of INDUCED PLURIPOTENT STEM CELLS from differentiated adult cells by the forced expression of specific genes.'),
  'D000067489': NtO(MH='Metacognition', MS="Awareness and understanding of one's own thought processes."),
  'D000067490': NtO(MH='Prescription Drug Overuse', MS='The use of a medication in an amount more than as prescribed.'),
  'D000067491': NtO(MH='Near Miss, Healthcare', MS='Event that presented a risk but did not result in a patient harm.'),
  'D000067492': NtO(MH='RNAi Therapeutics', MS='A form of disease treatment which involves the silencing of genes that are associated with a disease by the process of RNA INTERFERENCE.'),
  'D000067493': NtO(MH='Dynamic Light Scattering', MS='An analytical technique for measuring particle size of molecules that are less than a micron in diameter dispersed or dissolved in a liquid.'),
  'D000067494': NtO(MH='Time Out, Healthcare', MS='A period of time away from normal workflow taken to ensure key procedural details have been reviewed for better PATIENT SAFETY and help prevent MEDICAL ERRORS.'),
  'D000067495': NtO(MH='Healthcare Failure Mode and Effect Analysis', MS='Prospective risk assessment tool aimed at identifying potential risks and their impact in healthcare settings.'),
  'D000067496': NtO(MH='Spirit Possession', MS='The idea that abnormal behavior or a medical condition is evidence that a person is under the control of a supernatural power or spirit. This belief was most commonly held in religion and medicine of the medieval period and is also held in many tribal cultures today.'),
  'D000067498': NtO(MH='Crew Resource Management, Healthcare', MS='A range of healthcare related training designed to reduce MEDICAL ERRORS and improve PATIENT SAFETY by emphasizing TEAMWORK and human factors (see HUMAN ENGINEERING).'),
  'D000067508': NtO(MH='Computer Heuristics', MS='Trial-and-error methods of problem-solving used when an algorithmic approach is impractical'),
  'D000067528': NtO(MH='Ataxins', MS='A family of predominantly nuclear proteins that regulate gene transcription and protein degradation. The expansion of CAG trinucleotide repeats in genes that encode Ataxins is associated with SPINOCEREBELLAR ATAXIAS (SCA). In SCA patients, the number of CAG repeats correlates with the severity of disease and inversely correlates with the age of disease onset.'),
  'D000067531': NtO(MH='Alarmins', MS='A structurally diverse group of endogenous molecules that are multifunctional, having physiological functions inside the cell, but when released from dying cells or from cells under stress or certain immune cells, they function to activate INNATE IMMUNITY. Uncontrolled and excessive release of alarmins may contribute to INFLAMMATION; CARCINOGENESIS, and NEOPLASM METASTASIS. Alarmins are also critical for heart and nerve tissue homeostasis.'),
  'D000067548': NtO(MH='Dermal Fillers', MS='Materials such as COLLAGEN or HYALURONIC ACID that are injected or deposited into the DERMIS for the purpose of skin augmentation.'),
  'D000067549': NtO(MH='Action Spectrum', MS='A technique used to measure the rate of physiological activity plotted against wavelength of light. An action spectrum depicts the most effective wavelength of light (also known as spectral sensitivity) that is required for each specific process.'),
  'D000067551': NtO(MH='Diplomacy', MS='The art and practice of conducting negotiations between people, nations or other parties such as organizations.'),
  'D000067552': NtO(MH='Mutation Accumulation', MS='Concept which describes the incremental effects of MUTATION in living organisms.'),
  'D000067556': NtO(MH='Internal Ribosome Entry Sites', MS="Sequences within MESSENGER RNA that enable PROTEIN TRANSLATION INITIATION independent of 5' CAPPED RNA."),
  'D000067558': NtO(MH='Biological Mimicry', MS='Resemblance in appearance, structure, function, sound, scent or behavior between related or unrelated species, occurring in the same geographic location.'),
  'D000067559': NtO(MH='Specific Learning Disorder', MS='Diagnosed when there are specific deficits in an individual\xe2\x80\x99s ability to perceive or process information efficiently and accurately. This  disorder first manifests during the years of formal schooling and is characterized by persistent and impairing difficulties with learning foundational academic skills in reading, writing, and/or math. The individual\xe2\x80\x99s performance of the affected academic skills is well below average for age, or acceptable performance levels are achieved only with extraordinary effort. Specific learning disorder may occur in individuals identified as intellectually gifted and manifest only when the learning demands or assessment procedures (e.g., timed tests) pose barriers that cannot be overcome by their innate intelligence and compensatory strategies. For all individuals, specific learning disorder can produce lifelong impairments in activities dependent on the skills, including occupational performance. (from DSM-V)'),
  'D000067561': NtO(MH='Potentially Inappropriate Medication List', MS="A list, criteria, or screening tool designed to improve PATIENT SAFETY by determining an individual's exposure to potentially inappropriate drugs. They are designed to prevent MEDICATION ERRORS by INAPPROPRIATE PRESCRIBING. Analysis for a list includes factors such as DOSE-RESPONSE RELATIONSHIP, DRUG; DRUG-RELATED SIDE EFFECTS AND ADVERSE REACTIONS; AGE FACTORS; GENDER; and existing medical conditions."),
  'D000067562': NtO(MH='Late Onset Disorders', MS='Pathological conditions (Disorder, SYNDROME, or DISEASE) whose SIGNS AND SYMPTOMS manifest late in the life of an individual.'),
  'D000067563': NtO(MH='Phakopsora pachyrhizi', MS='Fungal pathogen which causes Soybean Rust disease in Soybeans (Glycine max).'),
  'D000067565': NtO(MH='Farmers', MS='Persons who cultivate land or crops, or raise LIVESTOCK.'),
  'D000067568': NtO(MH='Culturally Appropriate Technology', MS='A SCIENCE or TECHNOLOGY that promotes self-sufficiency and is suitable to the cultural, environmental, economic and social conditions of the geographic area in which it is applied.'),
  'D000067570': NtO(MH='Social Learning', MS='The concept of new knowledge acquisition through observation and interaction with others.'),
  'D000067571': NtO(MH='Financial Statements', MS='Formal and structured record of financial activities of a business, person, or other entity.'),
  'D000067572': NtO(MH='Miners', MS='Persons who work in a mine to extract ore or MINERALS from the earth.'),
  'D000067573': NtO(MH='Chronopharmacokinetics', MS='Absorption, metabolism and elimination of drugs in relation to time of day at which they are administered, and the mechanisms responsible for time-dependent variations.'),
  'D000067575': NtO(MH='Administrative Claims, Healthcare', MS='Information relating to itemized coding of procedures and costs associated with healthcare delivery, used as a means for tracking healthcare utilization, patterns of care, and treatment outcomes.'),
  'D000067576': NtO(MH='Child Health', MS='The concept covering the physical and mental conditions of CHILDREN.'),
  'D000067596': NtO(MH='Interleukin-33', MS='A member of the INTERLEUKIN-1 protein  family involved in the maturation of TH2 CELLS and the activation of MAST CELLS; BASOPHILS; EOSINOPHILS and NK CELLS. It is also produced by ENDOTHELIAL CELLS; EPITHELIAL CELLS and FIBROBLASTS; where it can function as an alarmin to modulate immune and inflammatory responses to tissue damage.'),
  'D000067616': NtO(MH='S100A12 Protein', MS='A member of the S100 PROTEIN FAMILY that regulates INFLAMMATION and the immune response. It recruits LEUKOCYTES, promotes cytokine and chemokine production, and regulates leukocyte adhesion and migration. S100A12 can also function via binding to ADVANCED GLYCOSYLATION END PRODUCT-SPECIFIC RECEPTORS, to stimulate innate immune cells.'),
  'D000067617': NtO(MH='Telopodes', MS="The very long and thin extensions of telocytes' cell surface, that have alternating thick and thin sections called podoms and podomers."),
  'D000067636': NtO(MH='Drosophila simulans', MS='A species of fruit fly.'),
  'D000067656': NtO(MH='Optimism', MS='Mental attitude that interprets life events as generally being positive.'),
  'D000067657': NtO(MH='Pessimism', MS='Mental attitude that interprets life events as generally being negative.'),
  'D000067696': NtO(MH='Ataxin-1', MS='A chromatin-binding factor that represses Notch signaling and associates with RNA. Expansion of the polyglutamine tract by expanded CAG repeats in the ATXN1 gene coding region is associated with SPINOCEREBELLAR ATAXIA 1.'),
  'D000067697': NtO(MH='Adolescent Health', MS='The concept covering the physical and mental conditions of ADOLESCENTS.'),
  'D000067698': NtO(MH='Ataxin-2', MS='A Poly(A) RNA-binding protein that negatively regulates EGFR ENDOCYTOSIS. An increased risk for developing AMYOTROPHIC LATERAL SCLEROSIS 13 is observed in patients who have more than 23 CAG repeats in the ATXN2 gene coding sequence. Larger CAG expansions in the ATXN2 gene occur in SPINOCEREBELLAR ATAXIA 2 patients.'),
  'D000067699': NtO(MH='Ataxin-3', MS='A deubiquitinating enzyme of the ATAXINS family. It functions in protein homeostasis, GENETIC TRANSCRIPTION; CYTOSKELETON regulation, and MYOGENESIS. CAG TRINUCLEOTIDE REPEAT EXPANSION in the Ataxin-3 gene coding region is associated with spinocerebellar ataxia-3 (MACHADO-JOSEPH DISEASE).'),
  'D000067716': NtO(MH='Point-of-Care Testing', MS='Allows patient diagnoses in the physician\xe2\x80\x99s office, in other ambulatory setting or at bedside. The results of care are timely, and allow rapid treatment to the patient. (from NIH Fact Sheet Point-of-Care Diagnostic Testing, 2010.)'),
  'D000067719': NtO(MH='Ataxin-7', MS='A component of the STAGA transcription coactivator-HAT complex that functions in Cone Rod Homeobox Protein (CRX)-dependent gene activation. It also stabilizes MICROTUBULES. CAG repeat expansion in the ATXN-7 coding region is associated with the development of SPINOCEREBELLAR ATAXIA 7.'),
  'D000067736': NtO(MH='Ataxin-10', MS='An ataxin that is associated with the survival of cerebellar neurons. Expansion of the ATTCT pentanucleotide in the ATXN10 coding region is associated with SPINOCEREBELLAR ATAXIA 10.'),
  'D000067756': NtO(MH='Glucagon-Like Peptide Receptors', MS='G-PROTEIN COUPLED CELL SURFACE RECEPTORS that bind GLUCAGON-LIKE PEPTIDES and are expressed by cells in pancreatic, intestinal, and neural tissues. These receptors regulate cellular responses to BLOOD GLUCOSE, INSULIN, and INFLAMMATION signals.'),
  'D000067757': NtO(MH='Glucagon-Like Peptide-1 Receptor', MS='A receptor for GLUCAGON-LIKE PEPTIDE 1 (GLP-1) expressed primarily on the surface of beta and ductal exocrine cells of the pancreas, as well as cells of other tissues. GLP-1 acts through GLP-1R to potentiate signaling in pancreatic cells in response to glucose-stimulated insulin secretion (GSIS).'),
  'D000067758': NtO(MH='Glucagon-Like Peptide-2 Receptor', MS='A receptor for GLUCAGON-LIKE PEPTIDE 2 (GLP-2) that is expressed on the surface of intestinal cells as well as neural cells. GLP-2 and other peptides act through GLP-2R to regulate cellular responses to BLOOD GLUCOSE, INFLAMMATION, and FOOD INTAKE.'),
  'D000067759': NtO(MH='Receptor for Advanced Glycation End Products', MS='A single-pass transmembrane CELL SURFACE RECEPTOR that binds ADVANCED GLYCATION END PRODUCTS to mediate cellular responses to both acute and chronic vascular inflammation in conditions such as ATHEROSCLEROSIS and DIABETES MELLITUS, TYPE 2. It also binds AMYLOID BETA PEPTIDES and the ALARMINS - S100A12 and S100 CALCIUM BINDING PROTEIN BETA SUBUNIT.'),
  'D000067776': NtO(MH='RNA Recognition Motif Proteins', MS='A family of RNA-BINDING PROTEINS that contain an RNA RECOGNITION MOTIF and two ribonucleoprotein (RNP) domains which bind RNA, in addition to other domains that allow for high affinity binding, sequence specificity, and protein interactions. Examples of RNA recognition motif proteins include HETEROGENEOUS NUCLEAR RIBONUCLEARPROTEINS (hnRNP) and EMBRYONIC LETHAL ABNORMAL-VISION (ELAV) proteins.'),
  'D000067777': NtO(MH='ELAV-Like Protein 2', MS="A neural-specific RRM protein that binds to several 3'UTRs, including its own as well as that of PROTO-ONCOGENE PROTEINS C-FOS  and ID DNA BINDING PROTEIN INHIBITOR. It binds through the recognition of a GAAA motif in the RNAs."),
  'D000067778': NtO(MH='ELAV-Like Protein 3', MS='A neural-specific RRM protein which contains three RNP-type RNA recognition motifs (RRMs). Human ELAVL3 is recognized by the anti-Hu serum antibody from patients with paraneoplastic encephalomyelitis and sensory neuronopathy (PEM/PSN). It also functions in neurogenesis.'),
  'D000067779': NtO(MH='ELAV-Like Protein 4', MS="An RRM protein which binds AU-rich sequences in the 3' UNTRANSLATED REGIONS of mRNAs for PROTO-ONCOGENE PROTEINS C-FOS; CYCLIN-DEPENDENT KINASE INHIBITOR P21; and GAP-43 PROTEIN. It functions in neuron-specific RNA processing."),
  'D000067780': NtO(MH='ELAV-Like Protein 1', MS="An RRM protein that binds to the 3'-UTR region of mRNAs and increases their stability. In EMBRYONIC STEM CELLS, it binds to poly-U elements and AU-rich elements (AREs) in the 3'-UTR of target mRNAs and preferentially binds mRNAs that are not methylated by N6-methyladenosine (m6A), to stabilize them and promote differentiation."),
  'D000067796': NtO(MH='Whey', MS='The liquid components of milk that remain after the CASEIN, fat, and fat soluble components have been removed. It is also a byproduct of cheese production.'),
  'D000067816': NtO(MH='Whey Proteins', MS='The protein components of milk obtained from the whey.'),
  'D000067836': NtO(MH='Hoarding Disorder', MS='Disordered behavior associated with clinically significant distress or impairment in social, occupational or other important areas of functioning and persistent difficulty parting with possessions due to a perceived need to save the items and distress associated with discarding them. (from DSM-V) The quantity of collected items sets the behavior apart from normal collecting behaviors.'),
  'D000067856': NtO(MH='Poly(ADP-ribose) Polymerase Inhibitors', MS='Chemicals and drugs that inhibit the action of POLY(ADP-RIBOSE)POLYMERASES.'),
  'D000067877': NtO(MH='Autism Spectrum Disorder', MS='Wide continuum of associated cognitive and neurobehavioral disorders, including, but not limited to, three core-defining features: impairments in socialization, impairments in verbal and nonverbal communication, and restricted and repetitive patterns of behaviors. (from DSM-V)'),
  'D000067878': NtO(MH='CELF Proteins', MS='A family of RRM proteins which contain two N-terminal RNA RECOGNITION MOTIF (RRM) domains, one C-terminal RRM domain, and a divergent segment of 160-230 amino acids between the second and third RRM domains. They regulate pre-mRNA ALTERNATIVE SPLICING and also function in RNA EDITING and PROTEIN BIOSYNTHESIS.'),
  'D000067879': NtO(MH='CELF1 Protein', MS="A member of the CELF PROTEINS family which binds GU rich elements (GREs) and CUG-triplet repeats in the 3'UTR of mammalian mRNA transcripts that undergo rapid turnover. It also binds AU-rich elements (AREs or EDEN-like) in the 3'UTR of JUN and FOS mRNAs. Mutations in the human CELF1 gene are associated with MYOTONIC DYSTROPHY type 1."),
  'D000067896': NtO(MH='Industrial Development', MS='Activity concerned with the planning and building of industries through manufacturing, provision of specialized services, and COMMERCE.'),
  'D000067917': NtO(MH='Cloud Computing', MS='Storing and processing data on multiple servers that can be accessed through the Internet.'),
  'D000067936': NtO(MH='Natural Resources', MS='Materials or substances such as land, timber, fresh water, fossil fuels, or mineral deposits that occur in a natural state and have economic value or usefulness to humans.'),
  'D000067940': NtO(MH='Glycemic Load', MS='A quantitative value of a measured amount of a specific food that is equal to the GLYCEMIC INDEX of that food multiplied by the carbohydrate content of that food.'),
  'D000067956': NtO(MH='Adenylyl Cyclase Inhibitors', MS='Compounds that bind to and inhibit the action of ADENYLYL CYCLASES.'),
  'D000067996': NtO(MH='RAW 264.7 Cells', MS='A transformed macrophage cell line isolated from ASCITES of mice infected with ABELSON MURINE LEUKEMIA VIRUS.'),
  'D000068': NtO(MH='Accreditation', MS='Certification as complying with a standard set by non-governmental organizations, applied for by institutions, programs, and facilities on a voluntary basis.'),
  'D000068016': NtO(MH='Clostridiales', MS='An order of anaerobic bacteria that are predominantly GRAM POSITIVE within the phylum Firmicutes. It includes the Clostridium and Eubacterium genera.'),
  'D000068036': NtO(MH='Graphic Novel', MS='Book-length narratives told using a combination of words and sequential art, often presented in comic book style. from (Fletcher-Spear et al., ALA Review, Winter 2005)'),
  'D000068037': NtO(MH='South Sudan', MS='A nation located in East-Central Africa; south of Sudan, north of Uganda and Kenya, west of Ethiopia. Independence from SUDAN was attained on 9 July 2011. The capital is Juba. (from CIA. World Factbook, 2014.)'),
  'D000068079': NtO(MH='Motor Disorders', MS='Motor skills deficits that significantly and persistently interfere with ACTIVITIES OF DAILY LIVING appropriate to chronological age.  (from DSM-5)'),
  'D000068097': NtO(MH='Maternal Health', MS='The health of women during PREGNANCY; childbirth and the POSTPARTUM PERIOD.'),
  'D000068098': NtO(MH='Seed Bank', MS='A repository of seeds maintained under optimal conditions that ensure long term storage, intended for use as a source of replenishment of seed stock or plant genetic material.'),
  'D000068099': NtO(MH='Trauma and Stressor Related Disorders', MS='Disorders in which exposure to a traumatic or stressful event is explicitly a diagnostic criterion.'),
  'D000068101': NtO(MH='Maternal-Child Health Services', MS='Programs organized for the purpose of providing medical and social services for mothers and children.'),
  'D000068103': NtO(MH='Serine-Arginine Splicing Factors', MS='A family of regulatory factors essential for constitutive and alternative splicing in RNA metabolism.'),
  'D000068104': NtO(MH='Infant Health', MS='The concept covering the physical and mental conditions of INFANTS.'),
  'D000068105': NtO(MH='Bipolar and Related Disorders', MS='These disorders are related to both SCHIZOPHRENIA SPECTRUM AND OTHER PSYCHOTIC DISORDERS and DEPRESSIVE DISORDER in terms of symptomatology, family history, and genetics. (DSM-5).'),
  'D000068116': NtO(MH='Gender Dysphoria', MS='A marked difference between the individual\xe2\x80\x99s expressed/experienced gender and the gender others would assign him or her, and it must continue for at least six months. (from DSM-5)'),
  'D000068156': NtO(MH='Formative Feedback', MS='Information communicated to the learner that is intended to modify the learner\xe2\x80\x99s thinking or behavior for the purpose of improving learning.'),
  'D000068180': NtO(MH='Aripiprazole', MS='A piperazine and quinolone derivative that is used primarily as an antipsychotic agent. It is a partial agonist of SEROTONIN RECEPTOR, 5-HT1A and DOPAMINE D2 RECEPTORS, where it also functions as a post-synaptic antagonist, and an antagonist of SEROTONIN RECEPTOR, 5-HT2A. It is used for the treatment of SCHIZOPHRENIA and BIPOLAR DISORDER, and as an adjunct therapy for the treatment of depression.'),
  'D000068181': NtO(MH='Prunus dulcis', MS='A plant species in the family ROSACEAE, genus Prunus which produces edible seeds called almonds.'),
  'D000068196': NtO(MH='Albumin-Bound Paclitaxel', MS='An injectable formulation of albumin-bound paclitaxel NANOPARTICLES.'),
  'D000068216': NtO(MH='Child Protective Services', MS='Local governmental offices which investigate reports of abuse and neglect of children, and act to assure a safe environment for minors.'),
  'D000068217': NtO(MH='Social Workers', MS='Professionals who work with persons affected by social disadvantages such as POVERTY; mental and physical illness or disability, and social injustice.  Their focus is on both the individual and his or her environment, including violations of their civil liberties and human rights.'),
  'D000068218': NtO(MH='Prunus africana', MS='A plant species in the family ROSACEAE. The bark extract known as pygeum is an ingredient in FOLK REMEDIES.'),
  'D000068219': NtO(MH='Prunus armeniaca', MS='A plant species in the family ROSACEAE. It is the source of apricot fruit.'),
  'D000068220': NtO(MH='Prunus avium', MS='A plant species in the family ROSACEAE. It is the source of the sweet cherry fruit.'),
  'D000068236': NtO(MH='Refugium', MS='Area in an environment in which a population of organisms can survive through a period of unfavorable conditions.'),
  'D000068237': NtO(MH='Distance Counseling', MS='Counseling conducted via electronic or other non-face-to-face interactions.'),
  'D000068238': NtO(MH='Lubiprostone', MS='Member of a bicyclic fatty acid class of compounds derived from PROSTAGLANDIN E1 involved in chloride channel gating.'),
  'D000068239': NtO(MH='Prunus persica', MS='A plant species in the family ROSACEAE. It is a tree that produces peach fruit.'),
  'D000068240': NtO(MH='Data Anonymization', MS='Removal of personally identifiable information via encryption or other methods.'),
  'D000068241': NtO(MH='Personally Identifiable Information', MS='Information that can be used to distinguish or trace an individual\xe2\x80\x99s identity, either alone or when combined with other personal or identifying information that is linked or linkable to a specific individual.'),
  'D000068242': NtO(MH='Prunus domestica', MS='A plant species in the family ROSACEAE. It is a tree that produces fruits called plums.'),
  'D000068256': NtO(MH='Darbepoetin alfa', MS='A recombinant protein which stimulates ERYTHROPOIESIS used to treat ANEMIA.'),
  'D000068257': NtO(MH='Efavirenz, Emtricitabine, Tenofovir Disoproxil Fumarate Drug Combination', MS='Inhibitor of reverse transcriptases or of RNA-directed DNA polymerases.'),
  'D000068258': NtO(MH='Bevacizumab', MS='An anti-VEGF humanized murine monoclonal antibody. It inhibits VEGF RECEPTORS and helps to prevent PATHOLOGIC ANGIOGENESIS.'),
  'D000068276': NtO(MH='Giraffes', MS='Four-legged hoofed mammals with extremely long necks and legs belonging to the family Giraffidae.'),
  'D000068296': NtO(MH='Risedronic Acid', MS='A pyridine and diphosphonic acid derivative that acts as a CALCIUM CHANNEL BLOCKER and inhibits BONE RESORPTION.'),
  'D000068297': NtO(MH='Fluticasone-Salmeterol Drug Combination', MS='A drug combination of fluticasone and salmeterol that is used as an inhaler formulation to manage the symptoms of ASTHMA and CHRONIC OBSTRUCTIVE PULMONARY DISEASE.'),
  'D000068298': NtO(MH='Fluticasone', MS='A STEROID with GLUCOCORTICOID RECEPTOR activity that is used to manage the symptoms of ASTHMA; ALLERGIC RHINITIS, and ATOPIC DERMATITIS.'),
  'D000068299': NtO(MH='Salmeterol Xinafoate', MS='A selective ADRENERGIC BETA-2 RECEPTOR agonist that functions as a BRONCHODILATOR when administered by inhalation. It is used to manage the symptoms of ASTHMA and CHRONIC OBSTRUCTIVE PULMONARY DISEASE.'),
  'D000068316': NtO(MH='Parks, Recreational', MS='An area of land open to the public for enjoyment.'),
  'D000068336': NtO(MH='Warfare and Armed Conflicts', MS='Engaging in any type of conflict including war or military conflict against another nation or organized group.'),
  'D000068337': NtO(MH='Armed Conflicts', MS='Any differences arising between two nations or groups and leading to the intervention of armed forces.'),
  'D000068338': NtO(MH='Everolimus', MS='A derivative of sirolimus and an inhibitor of TOR SERINE-THREONINE KINASES. It is used to prevent GRAFT REJECTION in heart and kidney transplant patients by blocking cell proliferation signals. It is also an ANTINEOPLASTIC AGENT.'),
  'D000068342': NtO(MH='Aspirin, Dipyridamole Drug Combination', MS='A drug combination of aspirin and dipyridamole that functions as a PLATELET AGGREGATION INHIBITOR, used to prevent THROMBOSIS and STROKE in TRANSIENT ISCHEMIC ATTACK patients.'),
  'D000068356': NtO(MH='Self-Control', MS="An individual's ability to manage and monitor their emotions, behaviors, and desires in the face of external demands in order to function in society."),
  'D000068357': NtO(MH='Saline Waters', MS='Water from natural sources which contain significant concentrations of dissolved salts such as sodium chloride.'),
  'D000068376': NtO(MH='Compassion Fatigue', MS='Emotional distress caused by repeated or prolonged expression of compassion or empathy. It may occur in individuals working in care giving professions.'),
  'D000068377': NtO(MH='Plantaginaceae', MS='A plant family of order Lamiales. The Plantago genus is best known. Lesser known members include Hippuris, Littorella and Callitriche.'),
  'D000068378': NtO(MH='Lamiales', MS='An order of the Lamiidae clade. Lamiales is one of the largest orders of flowering plants and includes pot-herbs in the mint family (MINT; SAGE; OREGANO; BASIL); SESAME, foxgloves; SNAPDRAGONS; and the olive family.'),
  'D000068397': NtO(MH='Clinical Study', MS='A work that reports on the results of a research study to evaluate interventions or exposures on biomedical or health-related outcomes.  The two main types of clinical studies are interventional studies (clinical trials) and observational studies. While most clinical studies concern humans, this publication type may be used for clinical veterinary articles meeting the requisites for humans.'),
  'D000068436': NtO(MH='Surgical Clearance', MS='Process of evaluating the health of a patient and determining if they are healthy enough for surgery.'),
  'D000068437': NtO(MH='Pemetrexed', MS='A guanine-derived ANTINEOPLASTIC AGENT that functions as a NUCLEIC ACID SYNTHESIS INHIBITOR through its binding to, and inhibition of, THYMIDYLATE SYNTHASE.'),
  'D000068438': NtO(MH='Brimonidine Tartrate', MS='A quinoxaline derivative and ADRENERGIC ALHPA-2 RECEPTOR AGONIST that is used to manage INTRAOCULAR PRESSURE associated with OPEN-ANGLE GLAUCOMA and OCULAR HYPERTENSION.'),
  'D000068456': NtO(MH='Clinical Studies as Topic', MS='Works about research studies that evaluate interventions or exposures on biomedical or health-related outcomes.  The two main types of clinical studies are interventional studies (clinical trials) and observational studies.'),
  'D000068476': NtO(MH='Beijing', MS='Capital of CHINA.'),
  'D000068516': NtO(MH='African Union', MS='A geopolitical organization of African nations with a mission to integrate vital interests, promote international relations, political stability, and economic development among member states.'),
  'D000068536': NtO(MH='Firmicutes', MS='A phylum of predominantly GRAM-POSITIVE BACTERIA that includes the orders Bacillales and Clostridiales. Firmicutes and BACTEROIDETES are the two bacterial phyla that constitute the majority of the human gut MICROBIOTA.'),
  'D000068538': NtO(MH='Dutasteride', MS='A 5-ALPHA-REDUCTASE INHIBITOR that is reported to inhibit both type-1 and type2 isoforms of the enzyme and is used to treat BENIGN PROSTATIC HYPERPLASIA.'),
  'D000068543': NtO(MH='Calceolariaceae', MS='A family in the order Lamiales with several species that are used in TRADITIONAL MEDICINE.'),
  'D000068556': NtO(MH='Interferon beta-1a', MS='An interferon beta-1 subtype that has a methionine at position 1, a cysteine at position 17, and is glycosylated at position 80. It functions as an ANTI-VIRAL AGENT and IMMUNOMODULATOR and is used to manage the symptoms of RELAPSING-REMITTING MULTIPLE SCLEROSIS.'),
  'D000068557': NtO(MH='Olmesartan Medoxomil', MS='An ANGIOTENSIN II TYPE 1 RECEPTOR BLOCKER that is used to manage HYPERTENSION.'),
  'D000068558': NtO(MH='Amlodipine Besylate, Olmesartan Medoxomil Drug Combination', MS='A pharmaceutical preparation of amlodipine besylate and olmesartan medoxomil  that combines ANGIOTENSIN II TYPE I RECEPTOR ANTAGONIST and CALCIUM CHANNEL BLOCKER activities. It is used in the management of HYPERTENSION.'),
  'D000068576': NtO(MH='Interferon beta-1b', MS='A non-glycosylated form of interferon beta-1 that has a serine at position 17. It is used in the treatment of both RELAPSING-REMITTING MULTIPLE SCLEROSIS and CHRONIC PROGRESSIVE MULTIPLE SCLEROSIS.'),
  'D000068577': NtO(MH='Nebivolol', MS='A cardioselective ADRENERGIC BETA-1 RECEPTOR ANTAGONIST (beta-blocker) that functions as a VASODILATOR through the endothelial L-arginine/ NITRIC OXIDE system. It is used to manage HYPERTENSION and chronic HEART FAILURE in elderly patients.'),
  'D000068579': NtO(MH='Celecoxib', MS='A pyrazole derivative and selective CYCLOOXYGENASE 2 INHIBITOR that is used to treat symptoms associated with RHEUMATOID ARTHRITIS; OSTEOARTHRITIS and JUVENILE ARTHRITIS, as well as the management of ACUTE PAIN.'),
  'D000068580': NtO(MH='Varenicline', MS='A benzazepine derivative that functions as an ALPHA4-BETA2 NICOTINIC RECEPTOR partial agonist. It is used for SMOKING CESSATION.'),
  'D000068581': NtO(MH='Tadalafil', MS='A carboline derivative and PHOSPHODIESTERASE 5 INHIBITOR that is used primarily to treat ERECTILE DYSFUNCTION; BENIGN PROSTATIC HYPERPLASIA and PRIMARY PULMONARY HYPERTENSION.'),
  'D000068582': NtO(MH='Certolizumab Pegol', MS="A polyethylene-glycolated Fab' fragment of TUMOR NECROSIS FACTOR antibody that binds specifically to TNF-ALPHA and neutralises it in a dose-dependent manner. It also inhibits the production of lipopolysaccharide-induced TNF-ALPHA and IL-1 BETA and is used to treat RHEUMATOID ARTHRITIS and PSORIATIC ARTHRITIS."),
  'D000068597': NtO(MH='Censorship, Research', MS='The act or practice of scrutinizing the practice of scientific research for the purpose of preventing or suppressing the unethical applications as well knowledge derived from it.'),
  'D000068598': NtO(MH='Data Accuracy', MS='A measure of scientific precision, exactness, or correctness of quantitative or qualitative values, relative to the actual or true measurements.'),
  'D000068599': NtO(MH='Brimonidine Tartrate, Timolol Maleate Drug Combination', MS='A pharmaceutical preparation of brimonidine tartrate and timolol maleate. The combined ADRENERGIC ALPHA2 RECEPTOR AGONIST and ADRENERGIC BETA-ANTAGONIST activity of these drugs reduce INTRAOCULAR PRESSURE in GLAUCOMA patients.'),
  'D000068600': NtO(MH='Albuterol, Ipratropium Drug Combination', MS='A combined pharmaceutical preparation of Ipratropium Bromide and Albuterol Sulfate that is used to treat the symptoms of ASTHMA and CHRONIC OBSTRUCTIVE PULMONARY DISEASE.'),
  'D000068601': NtO(MH='Dual Use Research', MS='Concept relating to technologies and/or information emanating from research that holds the potential for both benevolent and malevolent applications to humanity and the environment.'),
  'D000068616': NtO(MH='Professionalism', MS='The level of skill, good judgment, and polite behavior expected from people trained to do their jobs well.'),
  'D000068617': NtO(MH='Genetic Background', MS='The entire genetic composition of a strain or individual that interacts with a gene of interest.'),
  'D000068618': NtO(MH='Selective Breeding', MS='A process in which offspring possessing desired genetic traits are produced.'),
  'D000068636': NtO(MH='Legendary Creatures', MS='An unverified animal or humanoid, sometimes supernatural, often believed to be real and described in MYTHOLOGY, FOLKLORE, or legends. Some legendary creatures, such as the unicorn, were documented in scholarly antiquarian accounts of natural history.'),
  'D000068656': NtO(MH='Mometasone Furoate', MS='A pregnadienediol derivative ANTI-ALLERGIC AGENT and ANTI-INFLAMMATORY AGENT that is used in the management of ASTHMA and ALLERGIC RHINITIS. It is also used as a topical treatment for skin disorders.'),
  'D000068676': NtO(MH='Fallopia multiflora', MS='A species of Fallopia in the buckwheat family (Polygonaceae). Its roots are used in TRADITIONAL CHINESE MEDICINE.'),
  'D000068677': NtO(MH='Sildenafil Citrate', MS='A PHOSPHODIESTERASE TYPE-5 INHIBITOR; VASODILATOR AGENT and UROLOGICAL AGENT  that is used in the treatment of ERECTILE DYSFUNCTION and PRIMARY PULMONARY HYPERTENSION.'),
  'D000068678': NtO(MH='Emtricitabine, Rilpivirine, Tenofovir Drug Combination', MS='A pharmaceutical preparation that contains emtricitabine, rilpivirine and tenofovir disoproxil fumarate. It is used to treat HIV INFECTIONS.'),
  'D000068679': NtO(MH='Emtricitabine', MS='A deoxycytidine analog and REVERSE TRANSCRIPTASE INHIBITOR with antiviral activity against HIV-1 and HEPATITIS B viruses. It is used to treat HIV INFECTIONS.'),
  'D000068696': NtO(MH='Rilpivirine', MS='A diarylpyrimidine derivative and REVERSE TRANSCRIPTASE INHIBITOR with antiviral activity against HIV-1 that is used in the treatment of HIV INFECTIONS. It is also used in combination with other ANTI-HIV AGENTS, since ANTIVIRAL DRUG RESISTANCE emerges rapidly when it is used alone.'),
  'D000068698': NtO(MH='Tenofovir', MS='An adenine analog REVERSE TRANSCRIPTASE INHIBITOR with antiviral activity against HIV-1 and HEPATITIS B. It is used to treat HIV INFECTIONS and CHRONIC HEPATITIS B, in combination with other ANTIVIRAL AGENTS, due to the emergence of ANTIVIRAL DRUG RESISTANCE when it is used alone.'),
  'D000068717': NtO(MH='Glatiramer Acetate', MS='A random polymer of L-ALANINE, L-GLUTAMIC ACID, L-LYSINE, and L-TYROSINE that structurally resembles MYELIN BASIC PROTEIN. It is used in the treatment of RELAPSING-REMITTING MULTIPLE SCLEROSIS.'),
  'D000068718': NtO(MH='Rosuvastatin Calcium', MS='A HYDROXYMETHYLGLUTARYL-COA-REDUCTASE INHIBITOR, or statin, that reduces the plasma concentrations of LDL-CHOLESTEROL; APOLIPOPROTEIN B, and TRIGLYCERIDES while increasing HDL-CHOLESTEROL levels in patients with HYPERCHOLESTEROLEMIA and those at risk for CARDIOVASCULAR DISEASES.'),
  'D000068736': NtO(MH='Duloxetine Hydrochloride', MS='A thiophene derivative and selective NEUROTRANSMITTER UPTAKE INHIBITOR for SEROTONIN and NORADRENALINE (SNRI). It is an ANTIDEPRESSIVE AGENT and ANXIOLYTIC, and is also used for the treatment of pain in patients with DIABETES MELLITUS and FIBROMYALGIA.'),
  'D000068737': NtO(MH='Tolterodine Tartrate', MS='An ANTIMUSCARINIC AGENT selective for the MUSCARINIC RECEPTORS of the BLADDER that is used in the treatment of URINARY INCONTINENCE and URINARY URGE INCONTINENCE.'),
  'D000068756': NtO(MH='Valsartan', MS='A tetrazole derivative and ANGIOTENSIN II TYPE 1 RECEPTOR BLOCKER that is used to treat HYPERTENSION.'),
  'D000068757': NtO(MH='Ononis', MS='A genus of the pea family (Fabaceae), native from Europe to Central Asia and used in TRADITIONAL MEDICINE.'),
  'D000068758': NtO(MH='Mometasone Furoate, Formoterol Fumarate Drug Combination', MS='A pharmaceutical preparation of mometasone furoate and formoterol fumarate that is used as an inhaled dosage form for the treatment of ASTHMA.'),
  'D000068759': NtO(MH='Formoterol Fumarate', MS='An ADRENERGIC BETA-2 RECEPTOR AGONIST with a prolonged duration of action. It is used to manage ASTHMA and in the treatment of CHRONIC OBSTRUCTIVE PULMONARY DISEASE.'),
  'D000068760': NtO(MH='Serotonin and Noradrenaline Reuptake Inhibitors', MS='Drugs that selectively block or suppress the plasma membrane transport of SEROTONIN and NORADRENALINE into axon terminals and are used as ANTIDEPRESSIVE AGENTS.'),
  'D000068776': NtO(MH='Sleep Aids, Pharmaceutical', MS='Drugs used to induce SLEEP, prevent SLEEPLESSNESS, or treat SLEEP INITIATION AND MAINTENANCE DISORDERS.'),
  'D000068796': NtO(MH='Orexin Receptor Antagonists', MS='Substances that bind to and inhibit the action of OREXIN RECEPTORS. Drugs in this class have been used as SLEEP AIDS, PHARMACEUTICAL.'),
  'D000068797': NtO(MH='Orexins', MS='Neuropeptide hormones that play a role in regulating a variety of behavioral and physiological processes in response to motivational stimuli.'),
  'D000068798': NtO(MH='Hoodia', MS='A genus in the dogbane family (Apocynaceae) used in TRADITIONAL MEDICINE for appetite-suppressant properties.'),
  'D000068799': NtO(MH='Prasugrel Hydrochloride', MS='A piperazine derivative and PLATELET AGGREGATION INHIBITOR that is used to prevent THROMBOSIS in patients with ACUTE CORONARY SYNDROME; UNSTABLE ANGINA and MYOCARDIAL INFARCTION, as well as in those undergoing PERCUTANEOUS CORONARY INTERVENTIONS.'),
  'D000068800': NtO(MH='Etanercept', MS='A recombinant version of soluble human TNF receptor fused to an IgG FC fragment that binds specifically to TUMOR NECROSIS FACTOR and inhibits its binding with endogenous TNF receptors. It prevents the inflammatory effect of TNF and is used to treat RHEUMATOID ARTHRITIS; PSORIATIC ARTHRITIS and ANKYLOSING SPONDYLITIS.'),
  'D000068801': NtO(MH='Adapalene, Benzoyl Peroxide Drug Combination', MS='A pharmaceutical preparation of adapalene and benzoyl peroxide that is used as a DERMATOLOGIC AGENT for the topical treatment of ACNE.'),
  'D000068816': NtO(MH='Adapalene', MS='A naphthalene derivative that has specificity for RETINOIC ACID RECEPTORS. It is used as a DERMATOLOGIC AGENT for the treatment of ACNE.'),
  'D000068817': NtO(MH='Epoetin Alfa', MS='A recombinant glycosylated form of erythropoietin which stimulates the differentiation and proliferation of erythroid precursors. It is used for the treatment of ANEMIA associated with CHRONIC RENAL FAILURE in dialysis and predialysis patients.'),
  'D000068818': NtO(MH='Cetuximab', MS='A chimeric monoclonal antibody that functions as an ANTINEOPLASTIC AGENT through its binding to the EPIDERMAL GROWTH FACTOR RECEPTOR, where it prevents the binding and signaling action of cell growth and survival factors.'),
  'D000068819': NtO(MH='Hyssopus Plant', MS='A genus in the mint family (Lamiaceae). Members contain thujone and PHENOL. Distinguished from AGASTACHE (giant hyssop) and BACOPA (water hyssop).  Also distinguished from the genus of WASPS with the same genus name Hyssopus.'),
  'D000068836': NtO(MH='Rivastigmine', MS='A carbamate-derived reversible CHOLINESTERASE INHIBITOR that is selective for the CENTRAL NERVOUS SYSTEM and is used for the treatment of DEMENTIA in ALZHEIMER DISEASE and PARKINSON DISEASE.'),
  'D000068837': NtO(MH='Parmeliaceae', MS='The largest family of lichen-forming fungi.'),
  'D000068838': NtO(MH='Amlodipine, Valsartan Drug Combination', MS='A pharmaceutical preparation of amlodipine and valsartan that is used for the treatment of HYPERTENSION.'),
  'D000068856': NtO(MH='Eugenia', MS='A genus in the family Myrtaceae sometimes known as "stoppers" in FOLK MEDICINE. Many species of the genus SYZYGIUM have synonymous names that begin with the Eugenia genus name.'),
  'D000068857': NtO(MH='Human Papillomavirus Recombinant Vaccine Quadrivalent, Types 6, 11, 16, 18', MS='A vaccine containing L1 capsid proteins from four types of HPV (ALPHAPAPILLOMAVIRUS), types 6, 11, 16 and 18 that is used to prevent infections from HUMAN PAPILLOMAVIRUSES of these subtypes.'),
  'D000068858': NtO(MH='Kombucha Tea', MS='A beverage made by FERMENTATION of black tea and/or green tea.'),
  'D000068876': NtO(MH='Fingolimod Hydrochloride', MS='A sphingosine-derivative and IMMUNOSUPPRESSIVE AGENT that blocks the migration and homing of LYMPHOCYTES to the CENTRAL NERVOUS SYSTEM through its action on SPHINGOSINE 1-PHOSPHATE RECEPTORS. It is used in the treatment of MULTIPLE SCLEROSIS.'),
  'D000068877': NtO(MH='Imatinib Mesylate', MS='A tyrosine kinase inhibitor and ANTINEOPLASTIC AGENT that inhibits the BCR-ABL kinase created by chromosome rearrangements in CHRONIC MYELOID LEUKEMIA and ACUTE LYMPHOBLASTIC LEUKEMIA, as well as PDG-derived tyrosine kinases that are overexpressed in gastrointestinal stromal tumors.'),
  'D000068878': NtO(MH='Trastuzumab', MS='A humanized monoclonal antibody against the ERBB-2 RECEPTOR (HER2). As an ANTINEOPLASTIC AGENT, it is used to treat BREAST CANCER where HER2 is overexpressed.'),
  'D000068879': NtO(MH='Adalimumab', MS="A humanized monoclonal antibody that binds specifically to TNF-ALPHA and blocks its interaction with endogenous TNF RECEPTORS to modulate INFLAMMATION. It is used in the treatment of RHEUMATOID ARTHRITIS; PSORIATIC ARTHRITIS; CROHN'S DISEASE and ULCERATIVE COLITIS."),
  'D000068880': NtO(MH='Isophane Insulin, Human', MS='Human isophane insulin that is used to manage BLOOD GLUCOSE levels in patients with DIABETES.'),
  'D000068881': NtO(MH='Animals, Exotic', MS='Animals native to a foreign country or of foreign origin or character, that are not native to the United States.'),
  'D000068882': NtO(MH='Paliperidone Palmitate', MS='A benzisoxazole derivative and active metabolite of RISPERIDONE that functions as a DOPAMINE D2 RECEPTOR ANTAGONIST and SEROTONIN 5-HT2 RECEPTOR ANTAGONIST. It is an ANTIPSYCHOTIC AGENT used in the treatment of SCHIZOPHRENIA.'),
  'D000068884': NtO(MH='Immunosenescence', MS='The decline in the function of the IMMUNE SYSTEM during aging.'),
  'D000068896': NtO(MH='Canagliflozin', MS='A glucoside-derived SODIUM-GLUCOSE TRANSPORTER 2 inhibitor that stimulates urinary excretion of glucose by suppressing renal glucose reabsorption. It is used to manage BLOOD GLUCOSE levels in patients with TYPE 2 DIABETES.'),
  'D000068897': NtO(MH='Iridescence', MS='The changing of the color of an object due to variations in the angle of illumination or observation.'),
  'D000068898': NtO(MH='Raltegravir Potassium', MS='A pyrrolidinone derivative and HIV INTEGRASE INHIBITOR that is used in combination with other ANTI-HIV AGENTS for the treatment of HIV INFECTION.'),
  'D000068899': NtO(MH='Sitagliptin Phosphate, Metformin Hydrochloride Drug Combination', MS='A pharmaceutical preparation of sitagliptin phosphate and metformin hydrochloride that is used in the treatment of TYPE 2 DIABETES.'),
  'D000068900': NtO(MH='Sitagliptin Phosphate', MS='A pyrazine-derived DIPEPTIDYL-PEPTIDASE IV INHIBITOR and HYPOGLYCEMIC AGENT that increases the levels of the INCRETIN hormones GLUCAGON-LIKE PEPTIDE-1 (GLP-1) and glucose-dependent insulinotropic polypeptide (GIP). It is used in the treatment of TYPE 2 DIABETES.'),
  'D000068916': NtO(MH='Spatial Regression', MS='Methods used to take into account and incorporate spatial autocorrelation and regional variation into regression analysis models of data that has spatial dependency, and also to provide information on the spatial relationships among the variables.'),
  'D000068936': NtO(MH='Theranostic Nanomedicine', MS='An integrated nano-scale approach to MEDICINE which involves concurrent diagnosis, drug delivery, therapy, and monitoring of therapeutic response.'),
  'D000068937': NtO(MH='Cosmeceuticals', MS='COSMETICS that are associated with therapeutic effects.'),
  'D000068956': NtO(MH='Prisoner Dilemma', MS='A scenario in decision analysis in which two individuals motivated entirely by self-preservation at the expense of the other, end up in a worse state than if they had cooperated with each other in the decision-making process.'),
  'D000068957': NtO(MH='Games, Recreational', MS='Activity typically involving several individuals for the purpose of leisure, amusement, entertainment or pleasure.'),
  'D000068958': NtO(MH='Return to Sport', MS='Resumption of sporting activity following a hiatus or period of absence due to injury or other reasons.'),
  'D000068959': NtO(MH='Body Weight Maintenance', MS='Sustaining BODY WEIGHT after BODY WEIGHT CHANGES have been achieved.'),
  'D000068977': NtO(MH='Concierge Medicine', MS='An arrangement in which a patient pays an annual fee to a physician in exchange for services over and beyond normal insurance-reimbursed services.'),
  'D000068997': NtO(MH='Smartphone', MS='A cellular phone with advanced computing and connectivity capability built on an operating system.'),
  'D000068998': NtO(MH='Humidifiers', MS='Machines that add moisture to the air.'),
  'D000069': NtO(MH='Acculturation', MS='Process of cultural change in which one group or members of a group assimilate various cultural patterns from another.'),
  'D000069036': NtO(MH='Insulin Glargine', MS='A recombinant LONG ACTING INSULIN and HYPOGLYCEMIC AGENT that is used to manage BLOOD GLUCOSE in patients with DIABETES MELLITUS.'),
  'D000069056': NtO(MH='Lurasidone Hydrochloride', MS='A thiazole derivative and atypical ANTIPSYCHOTIC AGENT that functions as a DOPAMINE D2 RECEPTOR ANTAGONIST; SEROTONIN 5-HT2 RECEPTOR ANTAGONIST, serotonin 5-HT7 receptor antagonist, and antagonist of the adrenergic \xce\xb12A and \xce\xb12C receptors, as well as a partial SEROTONIN 5-HT1A RECEPTOR AGONIST. It is used in the treatment of SCHIZOPHRENIA and BIPOLAR DISORDER.'),
  'D000069057': NtO(MH='Insulin Detemir', MS='A recombinant long-acting insulin and hypoglycemic agent in which a MYRISTIC ACID is conjugated to a LYSINE at position B29. It is used to manage BLOOD GLUCOSE levels in patients with DIABETES MELLITUS.'),
  'D000069058': NtO(MH='Vardenafil Dihydrochloride', MS='A piperazine derivative, PHOSPHODIESTERASE 5 INHIBITOR and VASODILATOR AGENT that is used as a UROLOGICAL AGENT in the treatment of ERECTILE DYSFUNCTION.'),
  'D000069059': NtO(MH='Atorvastatin', MS='A pyrrole and heptanoic acid derivative, HYDROXYMETHYLGLUTARYL-COA REDUCTASE INHIBITOR (statin), and ANTICHOLESTEREMIC AGENT that is used to reduce serum levels of LDL-CHOLESTEROL; APOLIPOPROTEIN B; and TRIGLYCERIDES. It is used to increase serum levels of HDL-CHOLESTEROL in the treatment of HYPERLIPIDEMIAS, and for the prevention of CARDIOVASCULAR DISEASES in patients with multiple risk factors.'),
  'D000069076': NtO(MH='Fractures, Multiple', MS='Injuries involving the breaking of either several bones or one bone in two or more places.'),
  'D000069077': NtO(MH='Memory Consolidation', MS='Neurological process involving the conversion of learned information into long-term memory.'),
  'D000069078': NtO(MH='Seroconversion', MS='The appearance of antibodies against causative agents in the blood of individuals during the course of an infection or following immunization.'),
  'D000069079': NtO(MH='Radiation Exposure', MS='Phenomenon in which organisms are subjected to radiation.'),
  'D000069098': NtO(MH='Health Smart Cards', MS="Hand-sized cards with built-in computer chips used for accessing, storing, and protecting patients' medical information."),
  'D000069177': NtO(MH='Type I Secretion Systems', MS='Gram-negative bacterial secretion systems which translocate effectors in a single step across the inner and outer membranes. The one-step secretion is carried out by a channel that passes from the CYTOPLASM, through the inner membrane, PERIPLASMIC SPACE, and outer membrane, to the EXTRACELLULAR SPACE. The specificity of type I secretions systems are determined by the specificity of the three subcomponents forming the channel - an ATP transporter (ATP-BINDING CASSETTE TRANSPORTERS); a membrane fusion protein (MEMBRANE FUSION PROTEINS); and an outer membrane protein (BACTERIAL OUTER MEMBRANE PROTEINS.)'),
  'D000069178': NtO(MH='Type II Secretion Systems', MS='Gram-negative bacterial secretion systems which carry out the secretion of folded proteins.T2SSs secrete folded proteins from the PERIPLASMIC SPACE that have been exported there by SEC TRANSLOCASE or TAT SECRETION SYSTEMS, or they secrete folded proteins directly from the CYTOPLASM. The T2SSs have four substructures, an ATPase, an inner membrane platform, a pseudopilin, and secretin, an outer membrane complex which is a channel for secretion. (This bacterial secretin is not the same as the mammalian hormone also named SECRETIN.)'),
  'D000069196': NtO(MH='Gastrointestinal Microbiome', MS='All of the microbial organisms that naturally exist within the GASTROINTESTINAL TRACT.'),
  'D000069216': NtO(MH='Contraceptive Prevalence Surveys', MS='Collections of data, obtained from voluntary subjects, that measure the usage rate of methods of CONTRACEPTION; CONTRACEPTIVE DEVICES; or CONTRACEPTIVE AGENTS.'),
  'D000069236': NtO(MH='Pericardial Fluid', MS='Watery fluid produced in the serous and visceral pericardium surrounding the surface of the HEART.'),
  'D000069237': NtO(MH='Arthrocentesis', MS='Puncture and aspiration of fluid (e.g., SYNOVIAL FLUID) from a joint cavity. It is used sometimes to irrigate or administer drugs into a joint cavity.'),
  'D000069258': NtO(MH='Thoracentesis', MS='Aspiration of fluid or air from the THORACIC CAVITY. It is coupled sometimes  with the administration of drugs into the PLEURAL CAVITY.'),
  'D000069259': NtO(MH='Superficial Musculoaponeurotic System', MS='Layer between the superficial fat compartment and superficial facial muscles in the head and the neck.'),
  'D000069261': NtO(MH='Podosomes', MS='Actin-rich adhesive structures found at the ventral surface of metazoan ENDOTHELIAL CELLS. When found  in cultured cancer cells they are referred to as invadopodia. These are matrix-degrading structures composed of an ACTIN CYTOSKELETON core and an INTEGRINS-containing ring complex.'),
  'D000069262': NtO(MH='Plantar Plate', MS='Fibrocartilaginous ligament at the metatarsophalangeal and the interphalangeal joint of the toe.'),
  'D000069263': NtO(MH='Fallopia', MS='Genus of flowering herbaceous perennial plants and vines in the family Polygonaceae.'),
  'D000069278': NtO(MH='Arterial Switch Operation', MS='Surgical procedure for anatomical correction of transposed great arteries (e.g., DOUBLE OUTLET RIGHT VENTRICLE).'),
  'D000069279': NtO(MH='Drug Resistant Epilepsy', MS='Epileptic condition in which adequate trials of two tolerated and appropriately chosen and used ANTIEPILEPTIC DRUGS schedules to achieve sustained seizure freedom failed.'),
  'D000069280': NtO(MH='Electrocorticography', MS='Recording of brain electrical activities in which the electrodes are placed directly on the CEREBRAL CORTEX.'),
  'D000069281': NtO(MH='Autoimmune Hypophysitis', MS='Immune-mediated inflammation of the PITUITARY GLAND often associated with other autoimmune diseases (e.g., HASHIMOTO DISEASE; GRAVES DISEASE; and ADDISON DISEASE).'),
  'D000069282': NtO(MH='Canaliculitis', MS='Inflammation and infection of the lacrimal canaliculus area in the LACRIMAL APPARATUS.'),
  'D000069283': NtO(MH='Rituximab', MS='A murine-derived monoclonal antibody and ANTINEOPLASTIC AGENT that binds specifically to the CD20 ANTIGEN and is used in the treatment of LEUKEMIA; LYMPHOMA and RHEUMATOID ARTHRITIS.'),
  'D000069284': NtO(MH='Protein Translocation Systems', MS='Multiprotein complexes that carry out PROTEIN TRANSPORT across CELL MEMBRANES.'),
  'D000069285': NtO(MH='Infliximab', MS="A chimeric monoclonal antibody to TNF-ALPHA that is used in the treatment of RHEUMATOID ARTHRITIS; ANKYLOSING SPONDYLITIS; PSORIATIC ARTHRITIS and CROHN'S DISEASE."),
  'D000069286': NtO(MH='Bortezomib', MS='A pyrazine and boronic acid derivative that functions as a reversible PROTEASOME INHIBITOR. It is used as an ANTINEOPLASTIC AGENT in the treatment of MULTIPLE MYELOMA and MANTLE CELL LYMPHOMA.'),
  'D000069287': NtO(MH='Capecitabine', MS='A deoxycytidine derivative and fluorouracil PRODRUG that is used as an ANTINEOPLASTIC ANTIMETABOLITE in the treatment of COLON CANCER; BREAST CANCER and GASTRIC CANCER.'),
  'D000069289': NtO(MH='Parasite Encystment', MS='Process by which certain parasites such as GIARDIA and ENTAMOEBA convert from the TROPHOZOITE to SCHIZONT when exposed to stress.'),
  'D000069290': NtO(MH='Incisional Hernia', MS='Protrusion of tissue at or near the site of an incision from a previous surgery.'),
  'D000069292': NtO(MH='Pyroptosis', MS='Type of programmed cell death associated with infection by intracellular pathogens. It is characterized by INFLAMMASOME formation; activation of CASPASE 1; and CYTOKINES mediated inflammation.'),
  'D000069293': NtO(MH='Plasmablastic Lymphoma', MS='Malignant lymphoma composed of large B lymphoid cells which have the immunophenotype of plasma cells and a predilection for the ORAL CAVITY.'),
  'D000069294': NtO(MH='Twin-Arginine-Translocation System', MS='Protein translocase in BACTERIA or CHLOROPLASTS that exports or secretes folded proteins. In GRAM-NEGATIVE BACTERIA, twin-arginine translocase (TAT) is involved in the export of folded proteins to the PERIPLASM. In chloroplasts, TAT is involved in transporting folded proteins across the membranes of THYLAKOIDS.'),
  'D000069295': NtO(MH='Mammary Analogue Secretory Carcinoma', MS='A malignant neoplasm of epithelial cells of the SALIVARY GLANDS, with microcystic architecture, low-grade nuclei, and granular vacuolated cytoplasm.'),
  'D000069296': NtO(MH='Type III Secretion Systems', MS='Multiprotein transmembrane complexes in GRAM-NEGATIVE BACTERIA involved in either the secretion of effector proteins from the bacterial cytoplasm into host cells, or the secretion and assembly of flagellar components. The major component of the T3SSs is called the injectosome or needle complex.'),
  'D000069316': NtO(MH='Acne Conglobata', MS='Severe and chronic form of acne characterized by large, burrowing abscesses associated with disfigurement.'),
  'D000069319': NtO(MH='Type IV Secretion Systems', MS='Multiprotein complexes that transport single proteins, multiprotein complexes, and nucleoprotein complexes from the CYTOPLASM into the EXTRACELLULAR SPACE or into recipient cells. T4SSs are found in GRAM-NEGATIVE BACTERIA, while homologous components to T4SSs are found in GRAM-POSTIVE BACTERIA.'),
  'D000069320': NtO(MH='Type V Secretion Systems', MS='Secretion systems of GRAM-NEGATIVE BACTERIA (single membrane proteins or multiprotein complexes) that carry out secretion of proteins from the PERIPLASMIC SPACE to the EXTRACELLULAR SPACE via a beta-barrel transmembrane pore. There are several T5SS subtypes: T5aSS monomeric autotransporters, T5bSS two-partner secretions systems (TPSS), T5cSS trimeric autotransporters, T5dSS fused two-partner secretion systems, and T5eSS autotransporters with inverted domains.'),
  'D000069321': NtO(MH='Mitochondrial Replacement Therapy', MS='In vitro fertilization technique that uses mitochondrial DNA from a healthy donor in order to prevent the transmission of MITOCHONDRIAL DISEASE.'),
  'D000069322': NtO(MH='Self Expandable Metallic Stents', MS='Cylindrical metallic tubes that are inserted to hold open a structure in order to treat vascular, bile duct, esophageal and other tubular organ constrictions.'),
  'D000069336': NtO(MH='Neurovascular Coupling', MS='Mechanism by which changes in neural activity are tightly associated with regional cortical HEMODYNAMICS and metabolism changes. The association is often inferred from NEUROIMAGING signals (e.g., fMRI; or NIR SPECTROSCOPY).'),
  'D000069337': NtO(MH='Fused Kidney', MS='Congenital fusion of two kidneys.'),
  'D000069338': NtO(MH='Neuropathology', MS='The branch of medicine and biomedical science concerned with diseases of the nervous system.'),
  'D000069339': NtO(MH='Trachelectomy', MS='Surgical removal or resection of the CERVIX UTERI.'),
  'D000069340': NtO(MH='Deprescriptions', MS='Directions written to discontinue use of PRESCRIPTION DRUGS in order to reduce unnecessary and/or excessive medications (see POLYPHARMACY), DRUG SIDE EFFECTS and ADVERSE DRUG REACTION.'),
  'D000069341': NtO(MH='Transitional Care', MS='Health care provided during a transition to a different mode of care (e.g., TRANSITION TO ADULT CARE).'),
  'D000069342': NtO(MH='Medical Overuse', MS='Excessive or unnecessary utilization of health services by patients or physicians.'),
  'D000069343': NtO(MH='Bone-Implant Interface', MS='Region of interaction between the bone and PROSTHESES AND IMPLANTS which becomes bonded through cellular and extracellular interactions similar to OSSEOINTEGRATION.'),
  'D000069347': NtO(MH='Erlotinib Hydrochloride', MS='A quinazoline derivative and ANTINEOPLASTIC AGENT that functions as a PROTEIN KINASE INHIBITOR for EGFR associated tyrosine kinase. It is used in the treatment of NON-SMALL CELL LUNG CANCER.'),
  'D000069348': NtO(MH='Quetiapine Fumarate', MS='A dibenzothiazepine and ANTIPSYCHOTIC AGENT that targets the SEROTONIN 5-HT2 RECEPTOR; HISTAMINE H1 RECEPTOR, adrenergic alpha1 and alpha2 receptors, as well as the DOPAMINE D1 RECEPTOR and DOPAMINE D2 RECEPTOR. It is used in the treatment of SCHIZOPHRENIA; BIPOLAR DISORDER and DEPRESSIVE DISORDER.'),
  'D000069349': NtO(MH='Linezolid', MS='An oxazolidinone and acetamide derived ANTI-BACTERIAL AGENT and PROTEIN SYNTHESIS INHIBITOR that is used in the treatment of GRAM-POSITIVE BACTERIAL INFECTIONS of the skin and respiratory tract.'),
  'D000069350': NtO(MH='Telerehabilitation', MS='Delivery of therapeutic rehabilitation at a distance or offsite using telecommunication technologies.'),
  'D000069356': NtO(MH='Tympanocentesis', MS='Needle aspiration of fluid from the MIDDLE EAR through a puncture in the TYMPANIC MEMBRANE.'),
  'D000069376': NtO(MH='Type VI Secretion Systems', MS='Multiprotein complexes in GRAM NEGATIVE BACTERIA that deliver effector proteins into eukaryotic or prokaryotic cells by a mechanism similar to the contractile tail of bacteriophages. They are composed of a cell envelope-spanning tube which is surrounded by a contractile sheath and tipped by a cell puncturing complex; a base plate structure that anchors the assembly to the cell envelope; and an ATPase involved in the sheath contraction and disassembly of the complex.'),
  'D000069377': NtO(MH='Type VII Secretion Systems', MS='Bacterial secretion systems found in bacteria that have a MYCOLIC ACID-containing outer membrane such as MYCOBACTERIACEAE; Corynebacteriaceae; and NOCARDIACEAE. These are also known as ESX secretion systems because the first to be discovered is involved in secreting major virulence factors EsxA and EsxB. There are several subtypes of T7SSs including ESX-1, ESX-2, ESX-3, ESX-4, and ESX-5 secretion systems. The subtypes share some core components including an inner membrane channel-forming ATPase complex, a membrane-anchored mycosin, and a second channel that spans the outer mycolic acid-containing membrane.'),
  'D000069396': NtO(MH='Mitochondrial Ribosomes', MS='Multicomponent ribonucleoprotein structures contained in MITOCHONDRIA that specialize in the PROTEIN BIOSYNTHESIS of a small number of proteins involved in energy production for the cell.'),
  'D000069416': NtO(MH='Intravital Microscopy', MS='Type of microscopy used to study biological systems at high resolution.'),
  'D000069436': NtO(MH='Toxicological Phenomena', MS='The nature and effects of chemical, physical or biological poisons on living organisms.'),
  'D000069437': NtO(MH='Pharmacological Phenomena', MS='Interactions that occur between a living organism and chemicals that affect normal or abnormal biochemical function.'),
  'D000069438': NtO(MH='Ezetimibe', MS='An azetidine derivative and ANTICHOLESTEREMIC AGENT that inhibits intestinal STEROL absorption. It is used to reduce total CHOLESTEROL; LDL CHOLESTEROL, and APOLIPOPROTEINS B in the treatment of HYPERLIPIDEMIAS.'),
  'D000069439': NtO(MH='Dasatinib', MS='A pyrimidine and thiazole derived ANTINEOPLASTIC AGENT and PROTEIN KINASE INHIBITOR of BCR-ABL KINASE. It is used in the treatment of patients with CHRONIC MYELOID LEUKEMIA who are resistant or intolerant to IMATINIB.'),
  'D000069442': NtO(MH='Natalizumab', MS="A humanized monoclonal immunoglobulin G4 antibody to human INTEGRIN ALPHA4 that binds to the alpha4 subunit of INTEGRIN ALPHA4BETA1 and integrin alpha4beta7. It is used as an IMMUNOLOGIC FACTOR in the treatment of RELAPSING-REMITTING MULTIPLE SCLEROSIS and CROHN'S DISEASE."),
  'D000069443': NtO(MH='Heptavalent Pneumococcal Conjugate Vaccine', MS='A pneumococcal vaccine which contains 7 pneumococcal serotypes (6B, 14, 19F, 23F, 18C, 4, 9V), each conjugated individually to the outer membrane protein complex of NEISSERIA MENINGITIDIS.'),
  'D000069444': NtO(MH='Omalizumab', MS='An anti-IgE, recombinant, humanized monoclonal antibody which specifically binds to the C epsilon3 domain of IMMUNOGLOBULIN E, the site of high-affinity IgE receptor binding. It inhibits the binding of IgE to MAST CELLS and BASOPHILS to reduce the severity of the allergic response and is used in the management of persistent allergic ASTHMA.'),
  'D000069445': NtO(MH='Atomoxetine Hydrochloride', MS='A propylamine derivative and selective ADRENERGIC UPTAKE INHIBITOR that is used in the treatment of ATTENTION DEFICIT HYPERACTIVITY DISORDER.'),
  'D000069446': NtO(MH='Atazanavir Sulfate', MS='An azapeptide and HIV-PROTEASE INHIBITOR that is used in the treatment of HIV INFECTIONS and AIDS in combination with other ANTI-HIV AGENTS.'),
  'D000069447': NtO(MH='Tiotropium Bromide', MS='A scopolamine derivative and CHOLINERGIC ANTAGONIST that functions as a BRONCHODILATOR AGENT. It is used in the treatment of CHRONIC OBSTRUCTIVE PULMONARY DISEASE.'),
  'D000069448': NtO(MH='Denosumab', MS='A humanized monoclonal antibody and an inhibitor of the RANK LIGAND, which regulates OSTEOCLAST differentiation and bone remodeling. It is used as a BONE DENSITY CONSERVATION AGENT in the treatment of OSTEOPOROSIS.'),
  'D000069449': NtO(MH='Cinacalcet', MS=None),
  'D000069450': NtO(MH='Liraglutide', MS='An analog of GLUCAGON-LIKE PEPTIDE 1 and agonist of the GLUCAGON-LIKE PEPTIDE 1 RECEPTOR that is used as a HYPOGLYCEMIC AGENT and supplemental therapy in the treatment of DIABETES MELLITUS by patients who do not respond to METFORMIN.'),
  'D000069451': NtO(MH='Long Term Adverse Effects', MS='Persistent detrimental effects from treatment for a condition. Included are effects from surgery such as POSTOPERATIVE COMPLICATIONS, and from DRUG THERAPY, such as CHEMICALLY INDUCED DISORDERS, or other THERAPEUTICS. Failure to attain a desired outcome from treatment for the condition is not considered an adverse effect.'),
  'D000069452': NtO(MH='Pathogen-Associated Molecular Pattern Molecules', MS="Pathogens' molecules with specific sequence patterns that are recognized by PATTERN RECOGNITION RECEPTORS. They include microbial DNA, double-stranded RNA, surface glycoproteins, lipopolysaccharides, peptidoglycans, and lipoteichoic acid."),
  'D000069453': NtO(MH='Ultrasonic Waves', MS='Oscillating sound wave with a frequency higher than the upper limit of the human hearing range.'),
  'D000069454': NtO(MH='Darunavir', MS='An HIV PROTEASE INHIBITOR that is used in the treatment of AIDS and HIV INFECTIONS. Due to the emergence of ANTIVIRAL DRUG RESISTANCE when used alone, it is administered in combination with other ANTI-HIV AGENTS.'),
  'D000069455': NtO(MH='Palivizumab', MS='A humanized monoclonal antibody and ANTIVIRAL AGENT  that is used to prevent RESPIRATORY SYNCYTIAL VIRUS INFECTIONS in high risk pediatric patients.'),
  'D000069456': NtO(MH='Silent Mutation', MS="A change to a DNA SEQUENCE that doesn't change the AMINO ACID SEQUENCE of the protein made."),
  'D000069457': NtO(MH='Population Forecast', MS='Estimates of projected population.'),
  'D000069458': NtO(MH='Ranolazine', MS='An acetanilide and piperazine derivative that functions as a SODIUM CHANNEL BLOCKER and prevents the release of enzymes during MYOCARDIAL ISCHEMIA. It is used in the treatment of ANGINA PECTORIS.'),
  'D000069459': NtO(MH='Teas, Herbal', MS='Beverages prepared from an infusion of plant tissues.'),
  'D000069460': NtO(MH='Teas, Medicinal', MS='Beverages used in TRADITIONAL MEDICINE that are prepared from the infusion of plant tissue (HERBAL TEA), and/or animal tissue or other organisms such as FUNGI.'),
  'D000069461': NtO(MH='Bendamustine Hydrochloride', MS="A nitrogen mustard compound that functions as an ALKYLATING ANTINEOPLASTIC AGENT and is used in the treatment of CHRONIC LYMPHOCYTIC LEUKEMIA and NON-HODGKIN'S LYMPHOMA."),
  'D000069462': NtO(MH='Dimethyl Fumarate', MS='A fumarate derivative that is used as a DERMATOLOGIC AGENT in the treatment of PSORIASIS and SKIN DISEASES. It also may be used as an IMMUNOSUPPRESSIVE AGENT in the treatment of MULTIPLE SCLEROSIS.'),
  'D000069463': NtO(MH='Olive Oil', MS='Oil extracted from fruit of the OLIVE TREE (genus Olea).'),
  'D000069464': NtO(MH='Solifenacin Succinate', MS='A quinuclidine and tetrahydroisoquinoline derivative and selective M3 MUSCARINIC ANTAGONIST. It is used as a UROLOGIC AGENT in the treatment of URINARY INCONTINENCE.'),
  'D000069465': NtO(MH='Febuxostat', MS='A thiazole derivative and inhibitor of XANTHINE OXIDASE that is used for the treatment of HYPERURICEMIA in patients with chronic GOUT.'),
  'D000069466': NtO(MH='Red Meat', MS='Meat such as beef, goat, pork, or lamb which contains more MYOGLOBIN than POULTRY or SEAFOOD.'),
  'D000069467': NtO(MH='Fecal Microbiota Transplantation', MS='Transfer of GASTROINTESTINAL MICROBIOTA from one individual to another by infusion of donor FECES to the upper or lower GASTROINTESTINAL TRACT of the recipient.'),
  'D000069468': NtO(MH='Desvenlafaxine Succinate', MS='A cyclohexanol and phenol derivative and metabolite of venlafaxine that functions as a SEROTONIN AND NORADRENALINE REUPTAKE INHIBITOR (SNRI) and is used as an ANTIDEPRESSIVE AGENT.'),
  'D000069469': NtO(MH='Medical-Surgical Nursing', MS='The area of nursing concerned with the needs and care of adult medical and surgical patients.'),
  'D000069470': NtO(MH='Venlafaxine Hydrochloride', MS='A cyclohexanol and phenylethylamine derivative that functions as a SEROTONIN AND NORADRENALINE REUPTAKE INHIBITOR (SNRI) and is used as an ANTIDEPRESSIVE AGENT.'),
  'D000069471': NtO(MH='Neurosurgeons', MS='Qualified medical professionals who specialize in surgical treatment of diseases of the BRAIN and other parts of the NERVOUS SYSTEM.'),
  'D000069472': NtO(MH='Colesevelam Hydrochloride', MS='An allylamine derivative that binds BILE ACIDS in the intestine and is used as an ANTICHOLESTEREMIC AGENT in the treatment of HYPERCHOLESTEROLEMIA and HYPERLIPIDEMIAS.'),
  'D000069473': NtO(MH='Radiation Dose Hypofractionation', MS='A treatment schedule in which the total dose of radiation is divided into large doses but fewer exposure times.'),
  'D000069474': NtO(MH='Sofosbuvir', MS='A uridine monophosphate analog inhibitor of HEPATITIS C VIRUS (HCV) polymerase NS5B that is used as an ANTIVIRAL AGENT in the treatment of CHRONIC HEPATITIS C.'),
  'D000069475': NtO(MH='Re-Irradiation', MS='Treatment in which a repeat course of RADIOTHERAPY is administered.'),
  'D000069476': NtO(MH='Linagliptin', MS='A purine and quinazoline derivative that functions as an INCRETIN and DIPEPTIDYL-PEPTIDASE IV INHIBTOR. It is used as a HYPOGLYCEMIC AGENT in the treatment of TYPE II DIABETES MELLITUS.'),
  'D000069478': NtO(MH='Lisdexamfetamine Dimesylate', MS='A dextroamphetamine drug precursor that also functions as a CENTRAL NERVOUS SYSTEM STIMULANT and DOPAMINE UPTAKE INHIBITOR and is used in the treatment of ATTENTION DEFICIT HYPERACTIVITY DISORDER.'),
  'D000069479': NtO(MH='Buprenorphine, Naloxone Drug Combination', MS='A pharmaceutical preparation that combines buprenorphine, an OPIOID ANALGESICS with naloxone, a NARCOTIC ANTAGONISTS to reduce the potential for NARCOTIC DEPENDENCE in the treatment of pain. It may also be used for OPIOID SUBSTITUTION THERAPY.'),
  'D000069480': NtO(MH='Emtricitabine, Tenofovir Disoproxil Fumarate Drug Combination', MS='A pharmaceutical preparation of emtricitabine and tenofovir that is used as an ANTI-HIV AGENT in the treatment and prevention of HIV INFECTIONS.'),
  'D000069497': NtO(MH='Origin of Life', MS='The process by which life began.'),
  'D000069499': NtO(MH='Ezetimibe, Simvastatin Drug Combination', MS='A pharmaceutical preparation of ezetimibe and simvastatin that is used in the treatment of HYPERCHOLESTEROLEMIA and HYPERLIPIDEMIAS.'),
  'D000069501': NtO(MH='Abiraterone Acetate', MS='An androstene derivative that inhibits STEROID 17-ALPHA-HYDROXYLASE and is used as an ANTINEOPLASTIC AGENT in the treatment of metastatic castration-resistant PROSTATE CANCER.'),
  'D000069502': NtO(MH='Budesonide, Formoterol Fumarate Drug Combination', MS='A pharmaceutical preparation of budesonide and formoterol fumarate that is used as an ANTI-ASTHMATIC AGENT and for the treatment of CHRONIC OBSTRUCTIVE PULMONARY DISEASE.'),
  'D000069503': NtO(MH='Vilazodone Hydrochloride', MS='A benzofuran, indole, and piperazine derivative that functions as a SEROTONIN UPTAKE INHIBITOR and partial SEROTONIN 5-HT1 RECEPTOR AGONIST. It is used as an ANTIDEPRESSIVE AGENT.'),
  'D000069516': NtO(MH='International Law', MS='The body of law that governs the legal relations between or among sovereign states or nations.'),
  'D000069520': NtO(MH='Blog', MS='A website that contains conversational personal reflections, comments and sometimes links to other sites; typically run by an individual or small group.'),
  'D000069537': NtO(MH='Adult Day Care Centers', MS='Non-residential facilities that are designed to provide care and companionship for seniors who need assistance or supervision during the day.'),
  'D000069544': NtO(MH='Infectious Encephalitis', MS='Brain inflammation caused by an infectious agent.'),
  'D000069545': NtO(MH='Elvitegravir, Cobicistat, Emtricitabine, Tenofovir Disoproxil Fumarate Drug Combination', MS='A pharmaceutical preparation of the ANTI-HIV AGENTS elvitegravir, cobicistat, emtricitabine, and tenofovir disoproxil fumarate that is used in the treatment of HIV INFECTIONS.'),
  'D000069547': NtO(MH='Cobicistat', MS='A carbamate and thiazole derivative that functions as a CYTOCHROME P450 CYP3A INHIBITOR to enhance the concentration of ANTI-HIV AGENTS, with which it is used in combination, for the treatment of HIV INFECTIONS.'),
  'D000069549': NtO(MH='Ustekinumab', MS='A humanized monoclonal antibody that binds to IL-12 and IL-23 and is used as a DERMATOLOGIC AGENT in the treatment of patients with plaque PSORIASIS who have not responded to other therapies.'),
  'D000069550': NtO(MH='Machine Learning', MS='A type of ARTIFICIAL INTELLIGENCE that enable COMPUTERS to independently initiate and execute LEARNING when exposed to new data.'),
  'D000069551': NtO(MH='Environmental Psychology', MS='The field that studies interactions between individuals and the built and natural environment. It includes investigating behaviors that inhibit or foster sustainable, climate-healthy, and nature-enhancing choices.'),
  'D000069552': NtO(MH='Rivaroxaban', MS='A morpholine and thiophene derivative that functions as a FACTOR XA INHIBITOR and is used in the treatment and prevention of DEEP-VEIN THROMBOSIS and PULMONARY EMBOLISM.  It is also used for the prevention of STROKE and systemic embolization in patients with non-valvular ATRIAL FIBRILLATION, and for the prevention of atherothrombotic events in patients after an ACUTE CORONARY SYNDROME.'),
  'D000069553': NtO(MH='Supervised Machine Learning', MS='A MACHINE LEARNING paradigm used to make predictions about future instances based on a given set of labeled paired input-output training (sample) data.'),
  'D000069555': NtO(MH='Injection, Intratympanic', MS='The administration of  liquid substances into the TYMPANIC CAVITY with a hypodermic syringe.'),
  'D000069557': NtO(MH='Travoprost', MS='A cloprostenol derivative that is used as an ANTIHYPERTENSIVE AGENT in the treatment of OPEN-ANGLE GLAUCOMA and OCULAR HYPERTENSION.'),
  'D000069558': NtO(MH='Unsupervised Machine Learning', MS='A MACHINE LEARNING paradigm used to make predictions about future instances based on a given set of unlabeled paired input-output training (sample) data.'),
  'D000069559': NtO(MH='Loteprednol Etabonate', MS='An androstadiene derivative corticosteroid that is used as an ANTI-ALLERGIC AGENT for the treatment of inflammatory and allergic eye conditions.'),
  'D000069576': NtO(MH='Health Equity', MS='Opportunity to attain full health potential and no one is disadvantaged from achieving this potential because of their social position or other socially determined circumstance.'),
  'D000069577': NtO(MH='Morcellation', MS='Use of a non-cautery\xe2\x80\x93dependent mechanical device that simultaneously cuts and aspirates polyp and/or myoma tissue.'),
  'D000069578': NtO(MH='Waterborne Diseases', MS='Illnesses due to micro-organisms and chemicals in drinking water, those caused by organisms having part of their lifecycle in water or those with water-related vectors, and others spread by aerosols containing pathogens.'),
  'D000069579': NtO(MH='Ranibizumab', MS='A recombinant humanized monoclonal antibody fragment that binds VEGF-A to prevent its binding to VEGFR-1 and VEGFR-2 receptors. This activity reduces vessel permeability and angiogenesis in the treatment of neovascular age-related MACULAR DEGENERATION.'),
  'D000069580': NtO(MH='Bimatoprost', MS='A cloprostenol-derived amide that is used as an ANTIHYPERTENSIVE AGENT in the treatment of OPEN-ANGLE GLAUCOMA and OCULAR HYPERTENSION.'),
  'D000069581': NtO(MH='Exposure to Violence', MS='Experience of and exposure to VIOLENCE.'),
  'D000069582': NtO(MH='Eszopiclone', MS='A pyridine, pyrazine, and piperazine derivative that is used as a HYPNOTIC AND SEDATIVE in the treatment of INSOMNIA.'),
  'D000069583': NtO(MH='Pregabalin', MS='A gamma-aminobutyric acid (GABA) derivative that functions as a CALCIUM CHANNEL BLOCKER and is used as an ANTICONVULSANT as well as an ANTI-ANXIETY AGENT. It is also used as an ANALGESIC in the treatment of NEUROPATHIC PAIN and FIBROMYALGIA.'),
  'D000069584': NtO(MH='Unilateral Breast Neoplasms', MS='Tumors or cancer found specifically in one human BREAST, but not in both.'),
  'D000069585': NtO(MH='Filgrastim', MS='A recombinant granulocyte colony-stimulating factor (G-CSF) that is used in the treatment and prevention of NEUTROPENIA, preparation and collection of blood progenitor cells, and for use in PERIPHERAL BLOOD STEM CELL TRANSPLANTATION.'),
  'D000069586': NtO(MH='Adult Survivors of Child Adverse Events', MS='Persons who experienced traumatic events during childhood.'),
  'D000069590': NtO(MH='Round Ligaments', MS='Cord-like fibrous tissue structure that connects two articular extremities of bones, ligaments and /or cartilages.'),
  'D000069592': NtO(MH='Round Ligament of Liver', MS='A cord-like remnant structure formed from the closed left fetal UMBILICAL VEIN. It is located along the lower edge of the falciform ligament.'),
  'D000069593': NtO(MH='Round Ligament of Femur', MS='Ligament that connects the fovea of the FEMUR HEAD and the ACETABULUM notch in the HIP JOINT.'),
  'D000069594': NtO(MH='Abatacept', MS='A fusion protein immunoconjugate of the extracellular domain of CTLA4 and the Fc domain of human IgG1. It functions as a T-cell co-stimulation blocker that inhibits TNF-ALPHA and prevents the activation of T-LYMPHOCYTES. It is used in the treatment of RHEUMATOID ARTHRITIS.'),
  'D000069597': NtO(MH='Presenteeism', MS='Reporting for work despite feeling ill.'),
  'D000069599': NtO(MH='Crop Production', MS='The science and practice of cultivating PLANTS that have economic value to man. It includes plant breeding, seed production, weeding, use of fertilizers, harvesting, storage, transportation, and marketing.'),
  'D000069600': NtO(MH='Plant Breeding', MS='The purposeful manipulation of plant species with the goal of creating desired genotypes and phenotypes, using techniques such as controlled pollination and or genetic engineering, followed by artificial selection of progeny.'),
  'D000069601': NtO(MH='Crop Protection', MS='The science and practice of preventing, minimizing, or eliminating damage to AGRICULTURAL CROPS by pest organisms, weeds, and disease-causing agents.'),
  'D000069602': NtO(MH='Working Poor', MS='People who are in the labor force either working or looking for work for 27 weeks or more in a year, but whose income fall below a given poverty line.'),
  'D000069603': NtO(MH='Sevelamer', MS='A polymeric amine that binds phosphate and is used to treat HYPERPHOSPHATEMIA in patients with kidney disease.'),
  'D000069604': NtO(MH='Dabigatran', MS='A THROMBIN inhibitor which acts by binding and blocking thrombogenic activity and the prevention of  thrombus formation. It is used to reduce the risk of stroke and systemic EMBOLISM in patients with nonvalvular atrial fibrillation.'),
  'D000069605': NtO(MH='Olopatadine Hydrochloride', MS='An antihistamine with mast-cell stabilizing properties used as eye drops in the treatment of ALLERGIC CONJUNCTIVITIS.'),
  'D000069616': NtO(MH='Simeprevir', MS='Oral HCV-PROTEASE INHIBITOR effective against hepatitis C virus (HCV) serine protease NS3/4A. It is used in the treatment of chronic hepatitis C (Antivirals) genotype 1 infection in adults with compensated liver disease, including CIRRHOSIS.'),
  'D000069636': NtO(MH='Pedestrians', MS='Persons traveling on foot.'),
  'D000069756': NtO(MH='Undocumented Immigrants', MS='Foreign nationals residing in a country without legal immigration status, or in violation of the immigration laws of that country.'),
  'D000069796': NtO(MH='Adipose Tissue, Beige', MS='Brown fat-like adipose tissue that develops in WHITE ADIPOSE TISSUE from non-MYOGENIC REGULATORY FACTOR 5 expressing cell lineage.'),
  'D000069797': NtO(MH='Adipocytes, Beige', MS='Brown fat-like cells that develop in the WHITE FAT from non-MYOGENIC REGULATORY FACTOR 5 expressing CELL LINEAGE.'),
  'D000069816': NtO(MH='SEC Translocation Channels', MS='Universally conserved multiprotein complexes that form the protein transport channel of the general secretory (SEC) pathway. The SEC translocase is present in all bacteria, archaea, and eukaryotes. It is in the ENDOPLASMIC RETICULUM membrane of eukaryotic cells, in the THYLAKOID MEMBRANE in CHLOROPLASTS and in some protozoa in the INNER MITOCHONDRIAL MEMBRANE.'),
  'D000069836': NtO(MH='Degloving Injuries', MS='Avulsions of the superficial tissues of SKIN and SUBCUTANEOUS TISSUE from the underlying FASCIA.'),
  'D000069856': NtO(MH='Staghorn Calculi', MS='Renal calculi with a characteristic shape like antlers of a deer, formed as it extends into multiple calices of the RENAL PELVIS. A large number of staghorn calculi as well as other URINARY CALCULI are composed of STRUVITE.'),
  'D000069877': NtO(MH='Struvite', MS='The mineral magnesium ammonium phosphate with the formula NH4MgPO4. It is associated with urea-splitting organisms in a high magnesium, high phosphate, alkaline environment. Accumulation of crystallized struvite is found in the urinary tract as struvite CALCULI and as scale on sewage system equipment and wastewater pipes.'),
  'D000069896': NtO(MH='Transcription Activator-Like Effector Nucleases', MS='Artificial nucleases that cleave DNA at a defined distance from specific DNA sequences recognized by TRANSCRIPTION ACTIVATOR-LIKE EFFECTORS. They are composed of an endodeoxyribonuclease fused to DNA-binding domains of the transcription activator-like effectors.'),
  'D000069916': NtO(MH='Endoscopic Mucosal Resection', MS='A method for removing lesions from gastrointestinal MUCOUS MEMBRANES. The mucosal  tissue with the lesion is elevated by injecting a solution into the submucosal layer underneath it. The elevated tissue with the lesion is then cut out.'),
  'D000069956': NtO(MH='Chocolate', MS='Food product prepared from fermenting, roasting, and grinding seeds of the COCOA plant.'),
  'D000069976': NtO(MH='Bacillus licheniformis', MS='A species of  Bacillus that occurs in soil and is frequently found on bird feathers. Some strains cause FOODBORNE DISEASE, whereas other strains produce ANTIFUNGAL AGENTS and ANTIBACTERIAL AGENTS and function as PROBIOTICS. This species can also produce enzymes for industrial applications.'),
  'D000069977': NtO(MH='Bacillus amyloliquefaciens', MS='A non-pathogenic species of Bacillus that occurs in soil as well as some fermented vegetables and FERMENTED DAIRY PRODUCTS. It produces BACTERIOCINS and ANTIFUNGAL AGENTS and is used in FOOD PRESERVATION as well as a PROBIOTIC.'),
  'D000069978': NtO(MH='Bifidobacterium longum', MS='A species of Bifidobacterium that occurs in the human GASTROINTESTINAL TRACT and VAGINA. It inhibits the growth of pathogenic bacteria, may modulate the immune response, and is used as a PROBIOTIC.'),
  'D000069979': NtO(MH='Bacillus pumilus', MS='A species of Bacillus that occurs in soil, especially around the roots of some plants where it has anti-fungal and anti-nematode activities. It can also produce enzymes for industrial applications.'),
  'D000069980': NtO(MH='Lactobacillus paracasei', MS='A species of Lactobacillus that occurs in the GUT MICROBIOTA of healthy humans as well as FERMENTED DAIRY PRODUCTS and fermented vegetables. It is used as a PROBIOTIC.'),
  'D000069981': NtO(MH='Escherichia coli O104', MS='An enterohemorrhagic Escherichia coli of the O subfamily that can cause severe FOODBORNE DISEASE. The H4 serotype strain produces SHIGA TOXINS and has been linked to human disease outbreaks, including some cases of HEMOLYTIC-UREMIC SYNDROME, resulting from contamination of foods by feces containing E. coli O104.'),
  'D000069982': NtO(MH='Bifidobacterium animalis', MS='A species of Bifidobacterium that occurs in the LARGE INTESTINE of humans and other mammals and in FERMENTED DAIRY PRODUCTS. It is used as a PROBIOTIC.'),
  'D000069983': NtO(MH='Saccharomyces boulardii', MS='A species of Saccharomyces that is used as a PROBIOTIC, such as in the treatment of DIARRHEA and PSEUDOMEMBRANOUS ENTEROCOLITIS associated with CLOSTRIDIUM INFECTIONS.'),
  'D000069984': NtO(MH='Bifidobacterium breve', MS='A species of Bifidobacterium present in the human GUT MICROBIOTA. It is used as a PROBIOTIC.'),
  'D000069985': NtO(MH='Bifidobacterium bifidum', MS='A species of Bifidobacterium that occurs in the human GASTROINTESTINAL TRACT, especially in infants, and in FERMENTED DAIRY PRODUCTS. It produces BACTERIOCINS and is used as a PROBIOTIC.'),
  'D000069996': NtO(MH='Lactobacillus salivarius', MS='A species of Lactobacillus that occurs in the human GASTROINTESTINAL TRACT and ORAL MUCOSA. It produces BACTERIOCINS and is used as a PROBIOTIC.'),
  'D000069997': NtO(MH='Mastic Resin', MS='Dried tree sap from the MASTIC TREE that is used in TRADITIONAL MEDICINE and chewed as gum.'),
  'D000069998': NtO(MH='Lactobacillus gasseri', MS='A species of Lactobacillus that occurs in the human ORAL MUCOSA; GASTROINTESTINAL TRACT; and VAGINA. It produces BACTERIOCINS, can modulate the immune response, and is used as a PROBIOTIC.'),
  'D000069999': NtO(MH='Lactobacillus johnsonii', MS='A species of Lactobacillus that occurs in the human GASTROINTESTINAL TRACT and VAGINA. It produces BACTERIOCINS and HYDROGEN PEROXIDE and is used as a PROBIOTIC.'),
  'D000070': NtO(MH='Acebutolol', MS='A cardioselective beta-1 adrenergic antagonist with little effect on the bronchial receptors. The drug has stabilizing and quinidine-like effects on cardiac rhythm, as well as weak inherent sympathomimetic action.'),
  'D000070000': NtO(MH='Bacillus coagulans', MS='A microaerophilic, LACTIC ACID producing species of Bacillus that occurs in FERMENTED FOODS AND BEVERAGES. It also produces ANTI-INFECTIVE AGENTS and is used as a PROBIOTIC.'),
  'D000070001': NtO(MH='Streptococcus salivarius', MS='A species of Streptococcus that occurs in the human oral cavity and upper respiratory tract. It is a constituent of DENTAL PLAQUE and some strains may be pathogenic if they enter the bloodstream. However, other strains such as Streptococcus salivarius K12 produce BACTERIOCINS and are used as PROBIOTICS.'),
  'D000070002': NtO(MH='Propionibacterium freudenreichii', MS='A species of Propionibacterium that occurs in raw milk and cheese. It produces ANTI-INFECTIVE AGENTS and ANTI-INFLAMMATORY AGENTS and is used as a PROBIOTIC.'),
  'D000070003': NtO(MH='Lactobacillus crispatus', MS='A species of Lactobacillus that occurs in the human GASTROINTESTINAL TRACT and the VAGINA of healthy women. It produces LACTIC ACID and HYDROGEN PEROXIDE, and is used as a PROBIOTIC. It is also used for the treatment and prevention of BACTERIAL VAGINOSIS.'),
  'D000070004': NtO(MH='Ocimum sanctum', MS='A plant species of the genus OCIMUM, family LAMIACEAE that has been used in TRADITIONAL MEDICINE.'),
  'D000070005': NtO(MH='Bifidobacterium adolescentis', MS='A species of Bifidobacterium that occurs in the GASTROINTESTINAL TRACT of mammals and healthy humans from birth until late adulthood. It produces ANTI-VIRAL AGENTS and ANTI-INFLAMMATORY AGENTS and is used as a PROBIOTIC.'),
  'D000070006': NtO(MH='Pediococcus pentosaceus', MS='A species of Pediococcus that occurs in FERMENTED FOODS AND BEVERAGES where its ability to produce LACTIC ACID and PEDIOCINS make it useful as a FOOD PRESERVATION agent. It is also used as a PROBIOTIC.'),
  'D000070007': NtO(MH='Leuconostoc mesenteroides', MS='A species of Leuconostoc that occurs on fruits and vegetables and in their fermented products, as well as FERMENTED DAIRY PRODUCTS. It produces LACTIC ACID and BACTERIOCINS and is used as a PROBIOTIC; however, it has also caused infections in immunocompromised patients.'),
  'D000070016': NtO(MH='Pediococcus acidilactici', MS='A species of Pediococcus that occurs in FERMENTED FOODS AND BEVERAGES where its ability to produce LACTIC ACID and PEDIOCINS makes it useful in FOOD PRESERVATION. It is also used as a PROBIOTIC.'),
  'D000070017': NtO(MH='Pediocins', MS='Bacteriocins produced by species of PEDIOCOCCUS. They range from 3.5-4.6 kDa in mass, contain a conserved YGNGVXCXK motif and beta sheet at their N-terminals, and a more diverse hydrophobic or amphiphilic C-terminal alpha helical domain. They function as antimicrobial peptides against several pathogenic species of GRAM POSITIVE BACTERIA, including LISTERIA MONOCYTOGENES and are useful as FOOD PRESERVATIVES.'),
  'D000070018': NtO(MH='Lactobacillus pentosus', MS='A species of Lactobacillus that occurs in FERMENTED FOODS AND BEVERAGES where its ability to produce LACTIC ACID; ANTI-INFECTIVE AGENTS; and BACTERIOCINS make it useful as a FOOD PRESERVATION agent. It is also used as a PROBIOTIC.'),
  'D000070019': NtO(MH='Bacillus clausii', MS='An alkalophilic species of Bacillus that occurs in soil. It produces ANTI-BACTERIAL AGENTS and is used as a PROBIOTIC.'),
  'D000070036': NtO(MH='Faecalibacterium', MS='A genus of Gram-negative, non-spore forming, anaerobic, rod shaped bacteria in the Ruminococcaceae family, order Clostridiales that occur in the human gut.'),
  'D000070037': NtO(MH='Faecalibacterium prausnitzii', MS='A species of FAECALIBACTERIUM, previously classified in the FUSOBACTERIUM genus, that is a major constituent of the GUT MICROBIOTA in healthy humans. It has anti-inflammatory activity and reduced numbers of this species occur in patients with INFLAMMATORY BOWEL DISEASES such as CROHN DISEASE.'),
  'D000070057': NtO(MH='Paenibacillus polymyxa', MS='A species of Paenibacillus formerly classified as Bacillus polymyxa that occurs in marine sediments and soil, especially around plant roots and RHIZOMES where it performs NITROGEN FIXATION. It has activity against several species of pathogenic bacteria and produces POLYMYXINS.'),
  'D000070058': NtO(MH='Streptococcus iniae', MS='A species of Streptococcus that is pathogenic in fish and may also cause disease in humans who routinely handle infected fish. Those who are of Asian descent, elderly, or have chronic diseases such as DIABETES MELLITUS; RHEUMATIC HEART DISEASE; or LIVER CIRRHOSIS are more susceptible to Streptococcus iniae infections.'),
  'D000070059': NtO(MH='Paenibacillus larvae', MS='A species of Paenibacillus that causes American Foulbrood, a fatal disease of honeybees (APIS) and honeybee colonies.'),
  'D000070060': NtO(MH='Bdellovibrio bacteriovorus', MS='A non-pathogenic, obligate aerobic, Gram-negative species of Bdellovibrio that occurs in water and soil, as well as the intestines of birds and mammals. It can infect and lyse pathogenic GRAM-NEGATIVE BACTERIA and can function as a PROBIOTIC and ANTI-BACTERIAL AGENT.'),
  'D000070076': NtO(MH='Enterococcus hirae', MS='A species of Enterococcus that occurs in the GASTROINTESTINAL TRACT of birds and mammals, and to a lesser extent humans. Some strains cause diseases including DIARRHEA; BACTEREMIA; and ENDOCARDITIS  in humans and animals.'),
  'D000070077': NtO(MH='Bacteroides thetaiotaomicron', MS='A species of Bacteroides that is a major constituent of the human GUT MICROBIOTA. It normally produces enzymes important for the digestion of vegetable matter. However, it can also cause OPPORTUNISTIC INFECTIONS that result in intra-abdominal SEPSIS; BACTEREMIA; and PERITONITIS.'),
  'D000070079': NtO(MH='Aeromonas veronii', MS='A species of Aeromonas that occurs mostly as single cells in soil and freshwater environments. It also inhabits the digestive tract of the leech HIRUDO MEDICINALIS, where it aids in the digestion of blood and prevents colonization by other bacteria. It is pathogenic in fish and potentially in humans who consume infected fish or immunocompromised patients receiving LEECH THERAPY.'),
  'D000070096': NtO(MH='Pseudomonas chlororaphis', MS='A non-pathogenic species of Pseudomonas that occurs in soil, especially in the RHIZOSPHERE surrounding plant roots, as well as on the leaves of plants. It has anti-fungal and anti-nematode activities and is used in agriculture as a biocontrol agent.'),
  'D000070097': NtO(MH='Butyrivibrio fibrisolvens', MS='A species of Butyrivibrio that occurs primarily in the RUMEN where it has important activities in LIPID METABOLISM and the production of BUTYRATES.'),
  'D000070098': NtO(MH='Bacillus firmus', MS='A species of Bacillus that occurs in soil and marine sediments. Many strains are alkalophilic and able to metabolize HEAVY METALS; it may therefore be a useful species for ENVIRONMENTAL BIODEGRADATION.'),
  'D000070099': NtO(MH='Streptococcus gallolyticus', MS='A species of Streptococcus that occurs in the GASTROINTESTINAL TRACT of birds, mammals and healthy humans.'),
  'D000070100': NtO(MH='Informal Sector', MS='A component of the private sector characterized by ease of entry; reliance on indigenous resources; family ownership; small scale operations;  skills acquired outside of the formal sector; and unregulated markets.'),
  'D000070101': NtO(MH='Megasphaera elsdenii', MS='A species of Megasphaera that occurs primarily in the RUMEN and is able to metabolize LACTIC ACID.'),
  'D000070116': NtO(MH='Lotus', MS='A genus of the PEA FAMILY. The genus Lotus, formerly known as Tetragonolobus, is unrelated to other plants with the common name of lotus (NELUMBO and NYMPHAEA).'),
  'D000070136': NtO(MH='Lipid Droplet Associated Proteins', MS='Proteins, such as PERILIPINS, that localize to LIPID DROPLETS either transiently or constitutively.'),
  'D000070137': NtO(MH='Perilipins', MS='A family of vertebrate and insect lipid droplet associated proteins. They consist of a conserved N-terminal PAT domain (an alpha-helical region of about 110 amino acids), an 11-mer repeat region, and lipid-binding hydrophobic regions or 4-helix bundles near their C-termini. Perilipins transiently or constitutively localize to LIPID DROPLETS in ADIPOCYTES and FOAM CELLS, especially in regions adjacent to the PLASMA MEMBRANE and ENDOPLASMIC RECTICULUM. They are critical for lipid droplet synthesis and homeostasis as well as the regulation of lipid metabolism. Genetic variations in perilipins are associated with ATHEROSCLEROSIS; OBESITY; and DIABETES MELLITUS.'),
  'D000070156': NtO(MH='Nogo Receptors', MS='GPI-linked proteins consisting of eight elongated leucine-rich repeats at their N-temini that are connected to the GPI  by a "stalk" region rich in prolines, serines and threonines. They bind to NOGO PROTEIN; however, some Nogo receptors also bind MYELIN ASSOCIATED GLYCOPROTEIN and other cell surface glycoproteins. Interactions between nogo receptors and their ligands modulate nerve growth and NEURONAL PLASTICITY.'),
  'D000070177': NtO(MH='Pogostemon', MS='Genus in the Lamiaceae family. VOLATILE OILS from several species of Pogostemon are used in PERFUME; INSECT REPELLENTS; and ALTERNATIVE THERAPIES.'),
  'D000070197': NtO(MH='Streptococcus gallolyticus subspecies gallolyticus', MS='A subspecies of Streptococcus gallolyticus. It and other subspecies have been reported to cause infections resulting in BACTEREMIA; ENDOCARDITIS; and neonatal MENINGITIS.'),
  'D000070216': NtO(MH='Psacalium', MS='A genus of the Asteraceae family. Several of its species are used in TRADITIONAL MEDICINE.'),
  'D000070236': NtO(MH='Bifidobacterium longum subspecies infantis', MS='A subspecies of Bifidobacterium longum that occurs in the GASTROINTESTINAL TRACT of human infants and is used as a PROBIOTIC. It may also be used in the treatment of IRRITABLE BOWEL SYNDROME.'),
  'D000070256': NtO(MH='Lactobacillus sakei', MS='A species of Lactobacillus that occurs in fermented meat and fish. It produces the BACTERIOCIN Sakacin P and is used for FOOD PRESERVATION and as a PROBIOTIC.'),
  'D000070257': NtO(MH='Bifidobacterium pseudocatenulatum', MS='A species of Bifidobacterium that occurs in the GASTROINTESTINAL TRACT of mammals and healthy humans. It has anti-inflammatory activity and is used as a PROBIOTIC.'),
  'D000070260': NtO(MH='Teacher Training', MS='A curriculum-centered process of equipping individuals with professional knowledge and skills required to become effective teachers.'),
  'D000070263': NtO(MH='Sleep Hygiene', MS="Habits and practices conducive to getting the right amount and quality of sleep, and include  responding to environmental factors that may influence one's sleep."),
  'D000070276': NtO(MH='Heart Rate Determination', MS='Methods, techniques, and processes by which HEART RATE is measured.'),
  'D000070297': NtO(MH='Orthodontic Friction', MS='Physical resistance to motion between dental surfaces.'),
  'D000070316': NtO(MH='Pediatric Emergency Medicine', MS='Branch of EMERGENCY MEDICINE dealing with the emergency care of children.'),
  'D000070318': NtO(MH='Strategic Planning', MS='A rigorous and systematic process which entails defining plans, decisions, and sequence of steps to be taken in the future.'),
  'D000070319': NtO(MH='Student Run Clinic', MS='Healthcare setting managed by medical personnel in training.'),
  'D000070337': NtO(MH='Expropriation', MS='Taking of goods, property, or right of use by GOVERNMENT or others.'),
  'D000070356': NtO(MH='Pilots', MS='Persons skilled and/or qualified to operate an aircraft or ship.'),
  'D000070357': NtO(MH='Asparagaceae', MS='A family of flowering subshrubs and shrubs in the class Magnoliopsida.'),
  'D000070376': NtO(MH='Value-Based Health Insurance', MS="Approach to improve the quality of care by selectively encouraging or discouraging the use of specific health care services, based on their potential benefit to patients' health, relative to their cost. One element is lowering beneficiary cost sharing or out-of-pocket spending to increase medication adherence."),
  'D000070377': NtO(MH='Anti-Vaccination Movement', MS='Group activities directed against VACCINATION.'),
  'D000070378': NtO(MH='Amaryllidaceae', MS='A family of herbaceous plants with bulbs or rhizomes in the order Asparagales.'),
  'D000070379': NtO(MH='Attentional Bias', MS='An increased focus or awareness of certain stimuli over others, which influence behavior.'),
  'D000070380': NtO(MH='Xanthorrhoeaceae', MS='A family of flowering plants in the order Asparagales.'),
  'D000070381': NtO(MH='Asparagales', MS='An order of monocotyledons plants in the superorder Lilianae of the class Magnoliopsida (Angiosperms).'),
  'D000070396': NtO(MH='Liliales', MS='An order of monocots that grow from bulbs or corms to become herbs or vines.'),
  'D000070416': NtO(MH='Antagomirs', MS='Chemically-engineered oligonucleotides used to selectively inhibit expression of target genes through sequence-specific binding of corresponding microRNA (miRNA) sites.'),
  'D000070436': NtO(MH='Tannerella forsythia', MS='A periodontal pathogen which is a gram-negative member of BACTEROIDETES. It is implicated in PERIODONTITIS.'),
  'D000070437': NtO(MH='Colchicaceae', MS='A family in the order Liliales.'),
  'D000070456': NtO(MH='Call Centers', MS='A facility set up for the purpose of handling large volumes of telephone calls. Call Centers typically utilize some form of computer automation for receiving, dispatching, screening, logging and forwarding telephone calls.'),
  'D000070476': NtO(MH='Hypoxidaceae', MS='A family of perennial herbaceous plants, in the order Asparagales, with the underground storage organs, rhizomes or corms.'),
  'D000070496': NtO(MH='Kinanthropometry', MS='A measure of human size, shape, proportion, composition, maturation, and gross function; in relation to body movement, physical exercise, fitness, and performance.'),
  'D000070497': NtO(MH='Healthy Lifestyle', MS='A pattern of behavior involving LIFE STYLE choices which ensure optimum health. Examples are eating right; maintaining physical, emotional, and spiritual wellness, and taking preemptive steps against communicable diseases.'),
  'D000070516': NtO(MH='Intersectoral Collaboration', MS='Cooperative actions and ventures among health and health-related groups and organizations intended to improve health outcomes.'),
  'D000070536': NtO(MH='Independent Medical Evaluation', MS='An assessment of HEALTH STATUS requested by third parties (e.g. insurers, adjudicating bodies, law enforcement, attorneys, etc) on a subject\xe2\x80\x99s functional ability. Such information may be used in optimizing treatment or making informed decisions on compensation.'),
  'D000070538': NtO(MH='C2 Domains', MS='Protein modules that function in the targeting of proteins to CELL MEMBRANES. They consist of an eight-stranded anti-parallel beta-sandwich composed of a pair of four-stranded beta-sheets. This structural unit forms a pocket on the membrane-interacting face of the protein and co-ordinates the binding of 2 to 3 calcium ions; however, not all C2 domains bind calcium. Examples of C2 domain-containing proteins include PROTEIN KINASE C and PTEN PHOSPHOHYDROLASE.'),
  'D000070539': NtO(MH='Pleckstrin Homology Domains', MS='Protein domains of approximately 120 amino acids that form two perpendicular anti-parallel beta sheets connected by a loop of variable length and a C-terminal amphipathic helix. PH domains occur in many INTRACELLULAR SIGNALING PROTEINS and CYTOSKELETAL PROTEINS where they bind PHOSPHATIDYLINOSITOLS within the CELL MEMBRANE and INTRACELLULAR MEMBRANES, as well as proteins that include the Betagamma-subunits of  HETEROTRIMERIC GTP-BINDING PROTEINS, and PROTEIN KINASE C. These interactions allow the targeting of proteins to different cellular compartments and SIGNAL TRANSDUCTION PATHWAYS.'),
  'D000070556': NtO(MH='Melanthiaceae', MS='A family in the order Liliales, of bulbous or rhizomatous woodland and alpine perennial herbs.'),
  'D000070557': NtO(MH='Immunoglobulin Domains', MS='Compact globular protein domains of about 80 to 110 amino acids.They are characterized by two antiparallel beta sheets stabilized by HYDROPHOBIC INTERACTIONS and disulfide bonds between opposing strands. Three major subtypes of Ig domains are recognized: variable (V), intermediate (I), and constant (C1 or C2). Members of the immunoglobulin superfamily include ANTIGEN RECEPTORS; CYTOKINE RECEPTORS; and CELL ADHESION MOLECULES which possess immunoglobulin domains.'),
  'D000070558': NtO(MH='Talipes', MS='Deformity in which the foot is misaligned with respect to the TALUS in the ANKLE JOINT. While mostly congenital, as in CLUBFOOT, acquired deformities are included. Acquired talipedes are often associated with other foot deformities such as SYNDACTYLY and POLYDACTYLY.'),
  'D000070559': NtO(MH='Gizzard, Non-avian', MS='A component of the gastrointestinal tract of some reptiles (ALLIGATORS AND CROCODILES), as well as certain fish, mollusks, and insects. It functions to mechanically grind food.'),
  'D000070576': NtO(MH='NLR Proteins', MS='Intracellular signaling proteins that are defined by the presence of a NUCLEOTIDE-binding region and LEUCINE-rich repeats. Their general structure consists of any of a variety of effector domains at their N-termini such as a caspase recruitment domain (CARD), a central nucleotide-binding domain, and a variable number of C-terminal leucine-rich repeats. They are important for pathogen recognition in the INNATE IMMUNE RESPONSE of animals and plants. Members of the NLR protein family include the NOD SIGNALING ADAPTOR PROTEINS.'),
  'D000070579': NtO(MH='Parkinson Disease Associated Proteins', MS='Proteins associated with sporadic or familial cases of PARKINSON DISEASE.'),
  'D000070580': NtO(MH='CYS2-HIS2 Zinc Fingers', MS='A zinc finger motif of approximately 30 amino acids with the general sequence X2-Cys-X2,4-Cys-X12-His-X3,4,5-His that forms a simple beta sheet-beta sheet-alpha helix fold stabilized by zinc ions. It recognizes and binds to a variety of eukaryotic DNA sequences and is very common among sequence-specific DNA BINDING PROTEINS and TRANSCRIPTION FACTORS.'),
  'D000070584': NtO(MH='Tripartite Motif Proteins', MS='A protein family defined by the presence of three ZINC FINGER domains, one of which is a RING FINGER DOMAIN, a coiled-coil region, and a highly variable C-terminal region. They function in many cellular processes including APOPTOSIS and CELL CYCLE regulation.'),
  'D000070585': NtO(MH='Cadherin Related Proteins', MS='Membrane proteins that contain at least two typical consecutive CADHERIN motifs but typically more than cadherin or protocadherin proteins. Their overall domain organization also differs from those of cadherins and protocadherins, and contains different and unique cytoplasmic domains.'),
  'D000070586': NtO(MH='Fiscal Policy', MS='Use of government spending and taxation to influence the economy.'),
  'D000070587': NtO(MH='Mental Navigation Tests', MS='Measures of spatial cognition and memory.'),
  'D000070589': NtO(MH='Talipes Cavus', MS='A foot deformity in which the arch of the foot is high and often the heel adducted.'),
  'D000070590': NtO(MH='Solute Carrier Proteins', MS='A large diverse group of membrane transport proteins whose families are generally classified according to function. Most SLCs localize to the CELL MEMBRANE; however, some families such as SLC25, localize to MITOCHONDRIAL MEMBRANES or other ORGANELLES.'),
  'D000070591': NtO(MH='Metatarsal Valgus', MS='A foot anomaly in which the forefoot is angled outward relative to the hindfoot.'),
  'D000070592': NtO(MH='Metatarsus Varus', MS='A foot anomaly in which the forefoot (METATARSUS) is angled inward relative to the heel.'),
  'D000070593': NtO(MH='Methyl CpG Binding Domain', MS='A protein domain of about 70 amino acids in length that folds into a sandwich structure consisting of a beta sheet, alpha helix, and C-terminal hairpin loop which forms a hydrophobic methylated-DNA binding patch. It binds to methylated CPG ISLANDS in eukaryotes and occurs with other DNA and CHROMATIN binding domains such as AT-HOOK MOTIFS in eukaryotic DNA BINDING PROTEINS.'),
  'D000070597': NtO(MH='Coracoid Process', MS='A beak-like bone projection located at the lateral end of the superior anterior border of the SCAPULA.'),
  'D000070598': NtO(MH='Anterior Cruciate Ligament Injuries', MS='Sprain or tear injuries to the ANTERIOR CRUCIATE LIGAMENT of the knee.'),
  'D000070599': NtO(MH='Shoulder Injuries', MS='Injuries involving the SHOULDERS.'),
  'D000070600': NtO(MH='Tibial Meniscus Injuries', MS='Injuries to the TIBIAL MENISCUS of the leg.'),
  'D000070601': NtO(MH='Diet, Carbohydrate Loading', MS='A diet rich in DIETARY CARBOHYDRATES.'),
  'D000070602': NtO(MH='Rib Cage', MS='The bony thoracic enclosure consisting of the vertebral column; the RIBS; the STERNUM; and the COSTAL CARTILAGE.'),
  'D000070603': NtO(MH='Coxa Magna', MS='Deformity of the hip characterized by enlargement and deformation of the FEMUR HEAD and FEMUR NECK, often with associated changes in the ACETABULUM. These changes may be secondary to other diseases (e.g.  LEGG-PERTHES DISEASE; ARTHRITIS; HIP DISLOCATION, CONGENITAL) or TRAUMA.'),
  'D000070604': NtO(MH='Tarsal Coalition', MS='Congenital, complete or partial fusion of the TARSAL BONES of the foot. PES PLANUS is usually a feature.'),
  'D000070606': NtO(MH='Aponeurosis', MS='The flattened and/or expanded \xe2\x80\x9ctendon-like\xe2\x80\x9d dense fibrous connective tissue that connects skeletal muscles to each other or to bone.'),
  'D000070607': NtO(MH='Morton Neuroma', MS='A nerve inflammation in the foot caused by chronic compression of the plantar nerve between the METATARSAL BONES.'),
  'D000070614': NtO(MH='Nucleus Pulposus', MS='Fibrocartilage inner core of the intervertebral disc. Prolapsed or bulged nucleus pulposus leads to INTERVERTEBRAL DISC DISPLACEMENT while proliferation of cells in the nucleus pulposus is associated with INTERVERTEBRAL DISC DEGENERATION.'),
  'D000070616': NtO(MH='Annulus Fibrosus', MS='Outer portion of the intervertebral disc that surrounds the NUCLEUS PULPOSUS.'),
  'D000070617': NtO(MH='Microtrauma, Physical', MS='Small injuries caused by external force applied to the body including bones, muscles, nerves and tendons.'),
  'D000070621': NtO(MH='Cystography', MS='Radiography of the URINARY BLADDER.'),
  'D000070624': NtO(MH='Brain Contusion', MS='A bruise of the brain from an impact of the skull.'),
  'D000070625': NtO(MH='Brain Injuries, Diffuse', MS='Brain injuries occurring over a wide area instead of specific focal area.'),
  'D000070627': NtO(MH='Chronic Traumatic Encephalopathy', MS='Degenerative brain disease linked to repetitive brain trauma. Progressive symptoms may include MEMORY LOSS; AGGRESSION; or DEPRESSION.'),
  'D000070628': NtO(MH='Closed Fracture Reduction', MS='A procedure in which normal alignment of a fractured bone is restored by ORTHOPEDIC MANIPULATION without incision.'),
  'D000070630': NtO(MH='Diastasis, Muscle', MS='Abnormal separation of muscles.'),
  'D000070631': NtO(MH='Diastasis, Bone', MS='Abnormal separation of bones, often from a LIGAMENT.'),
  'D000070632': NtO(MH='Hamstring Tendons', MS='A group of tendons that attach the HAMSTRING MUSCLES proximally to the PELVIS and to the TIBIA and FIBULA at the KNEE JOINT.'),
  'D000070633': NtO(MH='Hamstring Muscles', MS='A group of muscles in the posterior THIGH area that are involved in connecting the KNEE JOINT and the PELVIS.'),
  'D000070634': NtO(MH='Non-Neuronal Cholinergic System', MS='The system of ACETYLCHOLINE-synthesizing enzymes, transporters, receptors and degrading enzymes that characterize non-neuronal cholinergic cells such as airway and skin EPITHELIAL CELLS.'),
  'D000070635': NtO(MH='Punctal Plugs', MS='Small devices that are inserted into the tear ducts (NASOLACRIMAL DUCTS). They are used to block the drainage of TEARS for the treatment of DRY EYE SYNDROMES.'),
  'D000070636': NtO(MH='Rotator Cuff Injuries', MS='Injuries to the ROTATOR CUFF of the shoulder joint.'),
  'D000070637': NtO(MH='Collateral Ligament, Ulnar', MS='The internal lateral ligament that travels from the medial aspect of the ELBOW uniting the distal aspect of the HUMERUS to the proximal aspect of the ULNA.'),
  'D000070638': NtO(MH='Ulnar Collateral Ligament Reconstruction', MS='Surgical reconstruction of injured or insufficient ULNAR COLLATERAL LIGAMENT in the ELBOW JOINT.'),
  'D000070639': NtO(MH='Elbow Tendinopathy', MS='Inflammation (tendinitis) or degeneration (tendinosis) of the tendons of the elbow.'),
  'D000070642': NtO(MH='Brain Injuries, Traumatic', MS='A form of acquired brain injury which occurs when a sudden trauma causes damage to the brain.'),
  'D000070656': NtO(MH='Rotator Cuff Tear Arthropathy', MS='Rapidly destructive shoulder joint and bone disease found mainly in elderly, and predominantly in women. It is characterized by SHOULDER PAIN; JOINT INSTABILITY; and the presence of crystalline CALCIUM PHOSPHATES in the SYNOVIAL FLUID. It is associated with ROTATOR CUFF INJURIES.'),
  'D000070657': NtO(MH='Crystal Arthropathies', MS='Joint disorders that are characterized by accumulation of microcrystals in and around the joint including in the SYNOVIAL FLUID. They are classified according to the chemical nature of the crystals such as CALCIUM PYROPHOSPHATE; basic CALCIUM PHOSPHATES; and monosodium urate (see URIC ACID).'),
  'D000070658': NtO(MH='Vigna', MS='Plant genus in the pea family (Fabaceae).'),
  'D000070659': NtO(MH='Patient Comfort', MS='Patient care intended to prevent or relieve suffering in conditions that ensure optimal quality living.'),
  'D000070660': NtO(MH='Wolfiporia', MS='A genus of wood-decaying, edible fungi in the Polyporaceae family. Its type species is Wolfiporia extensa.'),
  'D000070676': NtO(MH='Enthesopathy', MS='A disorder occurring at the site of insertion of TENDONS or LIGAMENTS into bones or JOINT CAPSULES.'),
  'D000070677': NtO(MH='Gentianales', MS='An angiosperm plant order that includes the APOCYNACEAE; ASCLEPIADACEAE; GENTIANACEAE; LOGANIACEAE; and RUBIACEAE  families.'),
  'D000070696': NtO(MH='Buttermilk', MS="A beverage made from cow's milk fermented by LACTIC ACID-producing bacteria, especially LACTOCOCCUS LACTIS and LACTOBACILLUS BULGARICUS."),
  'D000070716': NtO(MH='Kefir', MS='A beverage made from milk fermented by a mixture of endogenous LACTIC ACID-producing yeast and bacteria (KEFIR GRAINS), many of which are PROBIOTICS. It should not be confused with KAFFIR LIME or KAFFIR CORN.'),
  'D000070736': NtO(MH='Koumiss', MS="A beverage made from horse's milk that is fermented by endogenous LACTIC ACID-producing bacteria and ETHANOL-producing yeast."),
  'D000070777': NtO(MH='School Teachers', MS='Members of staff responsible for TEACHING students in a school from pre-kindergarten through twelfth grade.'),
  'D000070778': NtO(MH='Perilipin-1', MS='A lipid droplet protein that is expressed primarily by ADIPOCYTES of WHITE ADIPOSE TISSUE and BROWN ADIPOSE TISSUE. It co-localizes with MACROPHAGES and FOAM CELLS of artherosclerotic lesions and stabilizes LIPID DROPLETS by inhibiting HORMONE SENSITIVE LIPASE. It may also protect TRIGLYCERIDES against hydrolysis within the PLASMA MEMBRANE and modulate CHOLESTEROL ESTER HYDROLASE activity.'),
  'D000070779': NtO(MH='Giant Cell Tumor of Tendon Sheath', MS='A tumor arising in the SYNOVIAL MEMBRANE; SYNOVIAL BURSA; or TENDON sheath. It is characterized by OSTEOCLAST-like GIANT CELLS; FOAM CELLS; pigmented HEMOSIDERIN-laden MACROPHAGES and inflammatory infiltrate. It is classified either as diffuse or localized tenosynovitis.'),
  'D000070780': NtO(MH='Perilipin-2', MS='A perilipin that is expressed by many different cell types. It binds FATTY ACIDS and CHOLESTEROL,  stabilizes TRIGLYCERIDES, and localizes to both the surface and hydrophobic core of LIPID DROPLETS, as well as the ENDOPLASMIC RECTICULUM and PLASMA MEMBRANE in MACROPHAGES. It also plays a central role in the biogenesis of lipid droplets and FOAM CELLS and is highly expressed by macrophages at atherosclerotic lesions in human arteries along with the INFLAMMATION markers TNF-ALPHA; MCP-1 RECEPTOR; and IL-6.'),
  'D000070796': NtO(MH='Perilipin-3', MS='A perilipin that localizes to LIPID DROPLETS; CYTOPLASM; ENDOSOMES; and PLASMA MEMBRANE, especially in MACROPHAGES. It functions as a transporter of free fatty acids to lipid droplets to promote their biogenesis and growth. It is also required for the transport of the MANNOSE-6-PHOSPHATE RECEPTOR from endosomes to the TRANS-GOLGI NETWORK. Its structure consists of four helix bundles that interact with the hydrophobic lipid droplet surface.'),
  'D000070797': NtO(MH='Perilipin-5', MS='A perilipin that functions in LIPOGENESIS; LIPOLYSIS; and fatty acid oxidation in BROWN ADIPOSE TISSUE; heart, liver, and skeletal muscle. It recruits MITOCHONDRIA to the surface of LIPID DROPLETS where it functions in both the storage of fatty acids as TRIGLYCERIDES, and their release for mitochondrial fatty acid oxidation in response to metabolic needs.'),
  'D000070798': NtO(MH='Nogo Proteins', MS='Myelin proteins that are expressed as three isoforms: Nogo-A, Nogo-B, and Nogo-C. These share a C-terminal reticulon homology domain (RHD), consisting of two hydrophobic membrane domains flanking a 66 amino acid (Nogo-66) hydrophilic region. A long transmembrane region allows conformations that either span the entire membrane or fold into a hairpin conformation. Nogo inhibits NEURITE outgrowth and modulates wiring and the restriction of SYNAPTIC PLASTICITY in the adult central nervous system. It also regulates neurite fasciculation, branching, and extension in the developing nervous system.'),
  'D000070799': NtO(MH='Open Fracture Reduction', MS='Restoration of normal alignment of a fractured bone via an OPERATIVE SURGICAL PROCEDURE.'),
  'D000070816': NtO(MH='Nogo Receptor 1', MS='A high affinity receptor for myelin-associated inhibitors (MAIs) that include NOGO-A PROTEIN; OLIGODENDROCYTE MYELIN GLYCOPROTEIN; and MYELIN-ASSOCIATED GLYCOPROTEIN. It is expressed primarily by neurons in the brain and OLFACTORY BULBS. During embryonic development, it is expressed in the PERIPHERAL NERVOUS SYSTEM.  It localizes to GROWTH CONES and may inhibit neurite outgrowth following SPINAL INJURY.'),
  'D000070817': NtO(MH='Nogo Receptor 2', MS='A Nogo receptor that binds to MYELIN-ASSOCIATED GLYCOPROTEIN. It localizes to the GROWTH CONES of neurons in the THALAMUS; CORTEX: AMYGDALA; OLFACTORY BULBS; and HYPOTHALAMUS.'),
  'D000070818': NtO(MH='Discoidin Domain Receptors', MS='Receptor tyrosine kinases that bind COLLAGENS. They are characterized by the presence of extracellular DISCOIDIN DOMAINS that activate SIGNAL TRANSDUCTION PATHWAYS in response to collagen binding. They may also be cleaved by MATRIX METALLOPROTEINASES to mediate cell interactions with the EXTRACELLULAR MATRIX.'),
  'D000070819': NtO(MH='Discoidin Domain Receptor 1', MS='A discoidin domain receptor for FIBRILLAR COLLAGEN that functions in a variety of cellular processes. For example, it regulates cell attachment to the EXTRACELLULAR MATRIX, remodeling of the extracellular matrix, CELL MIGRATION; CELL DIFFERENTIATION; CELL PROLIFERATION; and CELL SURVIVAL.'),
  'D000070820': NtO(MH='Discoidin Domain Receptor 2', MS='A discoidin domain receptor for FIBRILLAR COLLAGEN and non-fibrillar COLLAGEN TYPE X. It functions in many cellular and developmental processes that include remodeling of the EXTRACELLULAR MATRIX; CELL MIGRATION; CELL DIFFERENTIATION; and CELL PROLIFERATION; as well as OSTEOGENESIS and the maturation of CHONDROCYTES.'),
  'D000070821': NtO(MH='Discoidins', MS='Lectins that were identified in DICTYOSTELIUM DISCOIDEUM. They bind to GALACTOSE and are involved in cell-substratum adhesion, maintenance of morphology during aggregation, and spore formation.'),
  'D000070822': NtO(MH='Discoidin Domain', MS='A protein domain originally identified in DISCOIDINS. It occurs in a variety of unrelated proteins in multicellular organisms, where it recognizes different ligands with distinct biological functions. Structurally, it consists of two antiparallel beta sheets that form a "jellyroll" configuration stabilized by two intramolecular disulfide bonds. Sequence differences within this module determine ligand specificity; in DISCOIDIN DOMAIN RECEPTORS, it binds to FIBRILLAR COLLAGENS and NON-FIBRILLAR COLLAGENS.'),
  'D000070837': NtO(MH='Lysine Acetyltransferases', MS='Acetyltransferases that can transfer an acyl group  to specific LYSINE residues within HISTONES (HISTONE ACETYLTRANSFERASES) and/or non-histone proteins.'),
  'D000070838': NtO(MH='Pharmacy Research', MS='RESEARCH activity focused on PHARMACY.'),
  'D000070840': NtO(MH='Nuclear Pharmacy', MS='An application of PHARMACY involving the preparation and dispensing of radioactive materials for use in medications.'),
  'D000070856': NtO(MH='High Fidelity Simulation Training', MS='A controlled learning environment that closely represents reality.'),
  'D000070857': NtO(MH='Walk Test', MS='A measure of endurance tests that show how far and fast an individual can walk without stopping within a certain period of time.'),
  'D000070876': NtO(MH='Tensins', MS='A family of multidomain microfilament proteins that bind ACTIN FILAMENTS and INTEGRINS at FOCAL ADHESIONS. They generally consist of an N-terminal domain with homology to PHOSPHOTYROSINE PHOSPHATASE, a C2 DOMAIN; unique central regions rich in PROLINE; ALANINE; GLYCINE; and SERINE; an SH2 DOMAIN; and a C-terminal phosphotyrosine-binding region. They are involved in CELL MIGRATION; CELL ADHESION; SIGNAL TRANSDUCTION; and reorganization of the CYTOSKELETON.'),
  'D000070896': NtO(MH='Bankart Lesions', MS='An anterior capsulolabral injury associated with a tear of the anteroinferior GLENOID LABRUM.'),
  'D000070916': NtO(MH='Tenocytes', MS='Elongated FIBROBLASTS and fibrocytes that lie between the collagen fibers and form the TENDON proper.'),
  'D000070918': NtO(MH='Synoviocytes', MS='Cells on the luminal surface of the SYNOVIAL MEMBRANE. Type A synoviocytes are MACROPHAGES responsible for waste removal from the joint cavity. Fibroblast-like type B synoviocytes are involved in production of joint matrix constituents (e.g., HYALURONAN; COLLAGEN; and FIBRONECTIN).'),
  'D000070956': NtO(MH='MutL Proteins', MS='DNA repair proteins that include the bacterial MutL protein and its eukaryotic homologs. They consist of a conserved N-terminal region with weak ATPase activity, an endonuclease motif, and a C-terminal domain that forms MutL homodimers or heterodimers between MLH1 and the PMS1, MISMATCH REPAIR ENDONUCLEASE PMS2; or MLH3 proteins. These complexes function in DNA repair pathways, primarily DNA MISMATCH REPAIR, where MutL/MLH1 and the MUTS DNA MISMATCH-BINDING PROTEIN are targeted to damaged DNA.'),
  'D000070957': NtO(MH='MutL Protein Homolog 1', MS='Eukaryotic homolog of the bacterial MutL DNA MISMATCH REPAIR protein. It heterodimerizes with MISMATCH REPAIR ENDONUCLEASE PMS2 to form MutL alpha, which is recruited to DNA mismatch sites by the MUTS DNA MISMATCH-BINDING PROTEIN. Mutations in the human MLH1 gene are associated with COLORECTAL NEOPLASMS, HEREDITARY NONPOLYPOSIS.'),
  'D000070976': NtO(MH='Mismatch Repair Endonuclease PMS2', MS='A MutL protein and component of the DNA MISMATCH REPAIR system. Its ENDONUCLEASE activity introduces SINGLE-STRAND DNA BREAKS which create entry points for EXO1 exonuclease to remove the strand containing the mismatch. It may also function in DNA DAMAGE signaling.'),
  'D000070996': NtO(MH='ATP Binding Cassette Transporter, Subfamily G', MS='A subfamily of ATP binding cassette transporters that function primarily in the transport of lipids and STEROLS across the CELL MEMBRANE. They also export UREA and various drugs resulting in MULTIDRUG RESISTANCE. They are smaller than most other ATP binding cassette proteins, consisting of six transmembrane alpha helices and a distinct N-terminal cytoplasmic ATP-binding domain, and function as homo- or heterodimers with other ABCG transporters.'),
  'D000070997': NtO(MH='ATP Binding Cassette Transporter, Subfamily G, Member 2', MS='ATP-binding cassette transporter, sub-family G protein that functions as a high capacity UREA exporter, transporter of STEROLS, and in the absorption and efflux of many drugs. Its efflux activity for ANTINEOPLASTIC AGENTS contributes to DRUG RESISTANCE. It functions as a homodimer and is expressed by cells in a variety of organs, as well as by NEOPLASTIC STEM CELLS.'),
  'D000070998': NtO(MH='ATP Binding Cassette Transporter, Subfamily G, Member 1', MS='ATP binding cassette transporter that functions primarily as a lipid and CHOLESTEROL exporter in MACROPHAGES.  It may also function in intracellular lipid transport and homoeostasis.'),
  'D000071017': NtO(MH='Hyperekplexia', MS='A neurological disorder characterized by an excessive startle reaction with ABNORMAL REFLEX;  MYOCLONIC JERKS; and MUSCLE HYPERTONIA.'),
  'D000071018': NtO(MH='ATP Binding Cassette Transporter, Subfamily G, Member 5', MS='ATP BINDING CASSETTE TRANSPORTER, SUBFAMILY G protein that functions as a heterodimer with ATP BINDING CASSETTE TRANSPORTER, SUBFAMILY G, MEMBER 8 in the selective transport of DIETARY CHOLESTEROL and PHYTOSTEROLS into and export out of ENTEROCYTES. It also functions in selective sterol excretion by the liver into bile.'),
  'D000071019': NtO(MH='ATP Binding Cassette Transporter, Subfamily G, Member 8', MS='ATP-binding cassette transporter, sub-family G protein that functions as a heterodimer with ATP BINDING CASSETTE TRANSPORTER, SUBFAMILY G, MEMBER 5 in the selective transport of DIETARY CHOLESTEROL and PHYTOSTEROLS into and export out of ENTEROCYTES. It also functions in selective sterol excretion by the liver into bile.'),
  'D000071020': NtO(MH='Hemochromatosis Protein', MS='A membrane protein and MHC class I antigen. It contains an IMMUNOGLOBULIN C1-SET DOMAIN and interacts with BETA 2-MICROGLOBULIN. It may also regulate the interaction of TRANSFERRIN with the TRANSFERRIN RECEPTOR. Mutations in the HFE gene are associated with cases of FAMILIAL HEMOCHROMATOSIS.'),
  'D000071036': NtO(MH='Sentinel Lymph Node', MS='First lymph node to receive drainage from the primary tumor. SENTINEL LYMPH NODE BIOPSY is performed to determine early METASTASIS status because cancer cells may appear first in the sentinel node.'),
  'D000071037': NtO(MH='Place Cells', MS='Pyramidal neurons in the HIPPOCAMPUS that play a role in cognitive representation of a specific location within a space.'),
  'D000071038': NtO(MH='Grid Cells', MS='Neurons in the ENTORHINAL CORTEX that project to the HIPPOCAMPUS. Grid cells and PLACE CELLS play a role in cognitive representation of spatial memory and navigation.'),
  'D000071039': NtO(MH='Perirhinal Cortex', MS='An area in the temporal lobe that is important for memory encoding and retrieval. It is bordered caudally by the parahippocampal cortex (see HIPPOCAMPUS) and ventrally and medially by the ENTORHINAL CORTEX.'),
  'D000071040': NtO(MH='Axon Initial Segment', MS='First segment of axon that connects distal axon segments to the neuronal CELL BODY at the axon hillock region. The axon initial segment is not protected by the MYELIN SHEATH and has properties critical for axonal growth. The axon initial segment and the axon hillock form an axonal trigger zone.'),
  'D000071041': NtO(MH='Esophageal Mucosa', MS='Circular innermost layer of the ESOPHAGUS wall that mediates esophageal PERISTALSIS which pushes ingested food bolus toward the stomach.'),
  'D000071056': NtO(MH='Anorectal Malformations', MS='Congenital defects in the anus and the rectum often involving the urinary and genital tracts.'),
  'D000071057': NtO(MH='Tardive Dyskinesia', MS='Drug-related movement disorder characterized by uncontrollable movements in certain muscles. It is associated with a long-term exposure to certain neuroleptic medications (e.g., METOCLOPRAMIDE).'),
  'D000071058': NtO(MH='Huntingtin Protein', MS='A protein that is highly expressed in the nervous system as well as other tissues; its size and structure vary due to polymorphisms. Expanded CAG TRINUCLEOTIDE REPEATS have been identified in the Huntingtin (HD) Gene of patients with HUNTINGTON DISEASE and are associated with abnormal PROTEIN AGGREGATES. Huntingtin interacts with proteins involved in a variety of gene expression and cellular processes; it is also essential for embryonic development.'),
  'D000071059': NtO(MH='Phage Therapy', MS='Therapeutic use of BACTERIOPHAGES to treat diseases.'),
  'D000071060': NtO(MH='Breast Density', MS='Measurement of relative composition of different BREAST tissue types often determined from MAMMOGRAPHY; ULTRASONOGRAPHY; or MRI.'),
  'D000071061': NtO(MH='Traditional Pulse Diagnosis', MS='Technique used in AYURVEDIC MEDICINE, and EAST ASIAN TRADITIONAL MEDICINE, in which reading PULSE is used in the diagnosis of diseases.'),
  'D000071062': NtO(MH='Sutureless Surgical Procedures', MS='Surgical techniques in which SUTURES are not applied to surgical wounds.'),
  'D000071063': NtO(MH='Endoglin', MS='A membrane glycoprotein and ANGIOGENESIS FACTOR that is expressed by cells of the VASCULAR ENDOTHELIUM; VASCULAR SMOOTH MUSCLE; and MONOCYTES. It functions as a co-receptor for TRANSFORMING GROWTH FACTOR BETA and modulates CELL ADHESION. Mutations in the endoglin gene are associated with cases of HEREDITARY HEMORRHAGIC TELANGIECTASIA.'),
  'D000071064': NtO(MH='Alert Fatigue, Health Personnel', MS='Mental fatigue experienced by health care providers who encounter numerous alerts and reminders from the use of CLINICAL DECISION SUPPORT SYSTEMS. As the numbers of alerts and reminders designed to provide meaningful assistance to the patient care process increases, many health personnel may ignore them.'),
  'D000071065': NtO(MH='Standing Orders', MS='Medical procedures and prescriptions regarding treatment of a patient that can be exercised by other health care personnel when predetermined conditions have been met.'),
  'D000071066': NtO(MH='Patient Reported Outcome Measures', MS='Assessment of the quality and effectiveness of health care as measured and directly reported by the patient.'),
  'D000071067': NtO(MH='Pneumonia, Necrotizing', MS='Severe complication of pneumonia characterized by liquefaction of lung tissue.'),
  'D000071068': NtO(MH='Lipocalin-2', MS='A lipocalin of approximately 200 amino acids that functions as an iron transporter and is expressed by cells of BONE MARROW and many other cells with secretory functions. It is involved in APOPTOSIS and may function to limit pathogenic bacterial growth as part of the INNATE IMMUNE RESPONSE.'),
  'D000071069': NtO(MH='Multiple Chronic Conditions', MS='Two or more concurrent chronic physical, mental, or behavioral health problems in an individual.'),
  'D000071070': NtO(MH='Familial Multiple Lipomatosis', MS="A rare autosomal disorder characterized by numerous encapsulated lipomas on the trunk and extremities. The lipomas are usually not painful but can cause pain when growing. In rare cases, one lipoma can become painful and progress to multiple painful lipomas; it is then referred to as Dercum's Disease Type III"),
  'D000071071': NtO(MH='Microaneurysm', MS='Aneurysm of the MICROVASCULATURE. Charcot\xe2\x80\x93Bouchard aneurysms are aneurysms of the brain vasculature which is a common cause of CEREBRAL HEMORRHAGE. Retinal microaneurysm is an early diagnostic sign of DIABETIC RETINOPATHY.'),
  'D000071072': NtO(MH='Acute Febrile Encephalopathy', MS='Acute onset of fever accompanied by seizures, cerebral inflammation and a change in mental status (e.g., confusion, disorientation, and coma).'),
  'D000071074': NtO(MH='Neonatal Sepsis', MS='Blood infection that occurs in an infant younger than 90 days old. Early-onset sepsis is seen in the first week of life and most often appears within 24 hours of birth. Late-onset occurs after 1 week and before 3 months of age.'),
  'D000071075': NtO(MH='Small Fiber Neuropathy', MS='Disorder of the peripheral nerves that primarily impair small nerve fibers. The affected small nerve fibers include myelinated A-delta fibers (see A FIBERS) and unmyelinated C FIBERS. Because these small fibers innervate skin and help control autonomic function, their neuropathy presents with neuropathic pain, reduced thermal and pain sensitivity, and autonomic dysfunction (e.g. abnormal sweating or facial flushing). Small fiber neuropathy can be idiopathic or associated with underlying diseases (e.g., AMYLOIDOSIS; DIABETES MELLITUS; SARCOIDOSIS; or VASCULITIS).'),
  'D000071076': NtO(MH='Network Meta-Analysis', MS='Meta-analysis of randomized trials in which estimates of comparative treatment effects are visualized and interpreted from a network of interventions that may or may not have been evaluated directly against each other. Common considerations in network meta-analysis include conceptual and statistical heterogeneity and incoherence.'),
  'D000071077': NtO(MH='Surgical Oncology', MS='A surgical specialty concerned with management of cancer.'),
  'D000071078': NtO(MH='Stenosis, Pulmonary Vein', MS='Narrowing of the PULMONARY VEIN.'),
  'D000071079': NtO(MH='Stenosis, Pulmonary Artery', MS='Narrowing of the PULMONARY ARTERIES.'),
  'D000071080': NtO(MH='Cortical Excitability', MS='Measurable changes in activities in the CEREBRAL CORTEX upon a stimulation. A change in cortical excitability as measured by various techniques (e.g., TRANSCRANIAL MAGNETIC STIMULATION) is associated with brain disorders.'),
  'D000071081': NtO(MH='Minimal Clinically Important Difference', MS='A statistically significant minimum set of clinical outcomes that demonstrates a clinical benefit of an intervention or treatment.'),
  'D000071085': NtO(MH='Single-Balloon Enteroscopy', MS='A balloon-assisted enteroscopy utilizing a flexible endoscope with one overtube balloon control unit.'),
  'D000071087': NtO(MH='Balloon Enteroscopy', MS='An endoscopy of the small intestines accomplished while advancing the endoscope, which is assisted by one or two balloons'),
  'D000071096': NtO(MH='ADAMTS Proteins', MS='A subfamily of ADAM proteases that are distinguished by the presence of one or more THROMBOSPONDIN type-1 repeats (TSRs). These are three-strand motifs that contain characteristic TRYPTOPHAN, ARGININE, and CYSTEINE residues respectively. In contrast to ADAM proteins, which reside on CELL MEMBRANES, ADAMTS proteases are secreted and function in the EXTRACELLULAR MATRIX.'),
  'D000071097': NtO(MH='ADAMTS1 Protein', MS='An ADAMTS protease that contains two disintegrin loops and three C-terminal thrombospondin (TS) motifs. It functions as an ANGIOGENESIS INHIBITOR as well as in normal tissue growth and fertility.'),
  'D000071116': NtO(MH='ADAMTS5 Protein', MS='An ADAMTS protease that contains two C-terminal thrombospondin (TS) motifs. It functions primarily as an aggrecanase, cleaving AGGRECAN in CARTILAGE, and may be involved in the destruction of aggrecan in ARTHRITIS.'),
  'D000071117': NtO(MH='Laboratory Critical Values', MS='Test results which deviate substantially from normal ranges of REFERENCE VALUES or other qualitative results. They trigger CLINICAL LABORATORY SERVICES to place a special alert to ensure PATIENT SAFETY.'),
  'D000071118': NtO(MH='ADAMTS7 Protein', MS='An ADAMTS protease that contains four central and four C-terminal thrombospondin (TS) motifs. It binds to and degrades CARTILAGE OLIGOMERIC MATRIX PROTEIN.'),
  'D000071119': NtO(MH='ADAMTS9 Protein', MS='An ADAMTS protease that contains 15 THROMBOSPONDIN (TS) motifs. It cleaves the PROTEOGLYCANS AGGRECAN and VERSICAN and also functions in protein transport from the ENDOPLASMIC RETICULUM to the GOLGI APPARATUS.'),
  'D000071120': NtO(MH='ADAMTS13 Protein', MS='An ADAMTS protease that contains eight thrombospondin (TS) motifs. It cleaves VON WILLEBRAND FACTOR to control vWF-mediated THROMBOSIS. Mutations in the ADAMTS13 gene have been identified in familial cases of PURPURA, THROMBOTIC THROMBOCYTOPENIC and defects in ADAMTS13 activity are associated with MYOCARDIAL INFARCTION; BRAIN ISCHEMIA; PRE-ECLAMPSIA; and MALARIA.'),
  'D000071121': NtO(MH='ADAMTS4 Protein', MS='An ADAMTS protease similar to ADAMTS5 PROTEIN. It contains a single C-terminal thrombospondin (TS) motif and cleaves AGGRECAN in CARTILAGE. It may also be involved in the destruction of aggrecan in ARTHRITIS.'),
  'D000071137': NtO(MH='Poly (ADP-Ribose) Polymerase-1', MS='A poly(ADP-ribose) polymerase that contains two ZINC FINGERS in its N-terminal DNA-binding region. It modifies NUCLEAR PROTEINS involved in chromatin architecture and BASE EXCISION REPAIR with POLY ADENOSINE DIPHOSPHATE RIBOSE.'),
  'D000071156': NtO(MH='Promyelocytic Leukemia Protein', MS='A tripartite motif protein that contains three ZINC FINGERS, including a RING FINGER DOMAIN, at its N-terminal. Several nuclear and one cytoplasmic isoforms result from alternative splicing of the PML gene; most nuclear isoforms localize to subnuclear structures (PML nuclear bodies) that are disrupted in ACUTE PROMYELOCYTIC LEUKEMIA cells.'),
  'D000071158': NtO(MH='Leucine-Rich Repeat Serine-Threonine Protein Kinase-2', MS='A serine/threonine protein kinase with GTPase activity that contains 12 LEUCINE-rich repeats in its central region and 7 WD repeats C-terminal to its kinase and GTPase domains. It localizes to TRANSPORT VESICLES; the OUTER MITOCHONDRIAL MEMBRANE; and the GOLGI APPARATUS. It functions in PROTEIN TRANSPORT; regulates neuron morphology in the central nervous system, and also functions in the trafficking of SYNAPTIC VESICLES. Mutations in the LRRK2 gene have been identified in autosomal dominant cases of PARKINSON DISEASE (PARK8).'),
  'D000071161': NtO(MH='Forkhead Box Protein O1', MS='A forkhead box transcription factor that is a major target of INSULIN signaling and regulator of metabolic homeostasis in response to OXIDATIVE STRESS. It binds to the insulin RESPONSE ELEMENT (IRE) and the related Daf-16 family binding element (DBE). Its activity is suppressed by insulin and it also regulates OSTEOBLAST proliferation, controls bone mass, and skeletal regulation of GLUCOSE metabolism. It promotes GLUCONEOGENESIS in HEPATOCYTES and regulates gene expression in ADIPOSE TISSUE. It is also an important CELL DEATH regulator. Chromosomal aberrations involving the FOXO1 gene occur in RHABDOMYOSARCOMA.'),
  'D000071162': NtO(MH='Trefoil Factors', MS='A family of small peptides expressed primarily by MUCOUS MEMBRANE EPITHELIAL CELLS in vertebrates. Their structure is highly conserved and is defined by a three-leaved (trefoil) domain of 42 or 43 amino acids; it includes six cysteines that create the trefoil structure through disulfide bridges. Trefoil peptides may form dimers with each other, or associate with MUCINS and other factors. They are important for maintaining epithelial integrity and for protection from noxious agents.'),
  'D000071163': NtO(MH='Trefoil Factor-1', MS='A 60 amino acid (6.5 kDa) trefoil factor that contains a single trefoil domain. It is expressed primarily by surface EPITHELIAL CELLS of the GASTRIC MUCOSA, where it associates with MUCIN 5AC.'),
  'D000071164': NtO(MH='Trefoil Factor-2', MS='A 106 amino acid (12 kDa) trefoil factor that contains two trefoil domains and associates with MUCIN-6. It is expressed in the GASTROINTESTINAL TRACT by cells of BRUNNER GLANDS; PYLORIC GLANDS and mucous neck cells. It inhibits GASTROINTESTINAL MOTILITY and GASTRIC ACID secretion and may help maintain the structural integrity of gastric mucus.'),
  'D000071165': NtO(MH='Trefoil Factor-3', MS='A 59 amino acid (6.6 kDa) trefoil factor that contains a single trefoil domain. It is expressed in all tissues with MUCOUS MEMBRANES, including GOBLET CELLS of the SMALL INTESTINE and LARGE INTESTINE. It associates with MUCIN-2 in the small intestine and may regulate epithelial CELL MIGRATION and WOUND HEALING.'),
  'D000071176': NtO(MH='Signaling Lymphocytic Activation Molecule Family', MS='Type-I membrane glycoproteins that are expressed primarily on the surface of CD4 or CD8-positive T-CELLS; NATURAL KILLER CELLS; and some populations of B CELLS. They are characterized by an N-terminal, extracellular IMMUNOGLOBULIN-LIKE DOMAIN and a membrane-proximal IMMUNOGLOBULIN C2-SET DOMAIN. SLAMF receptors typically signal through homophilic interactions and are important for mediating the immune response and immune cell differentiation.'),
  'D000071177': NtO(MH='Signaling Lymphocytic Activation Molecule Family Member 1', MS='A 70-kDa SLAM family receptor that consists of an extracellular IMMUNOGLOBULIN-LIKE DOMAIN and an IMMUNOGLOBULIN C2-SET DOMAIN. It is expressed primarily by THYMOCYTES and activated T-LYMPHOCYTES, as well as by MACROPHAGES and DENDRITIC CELLS. It binds SLAMF1 receptors on other cells to mediate T-cell maturation and proliferation. It is also a receptor for the MEASLES VIRUS.'),
  'D000071178': NtO(MH='CD48 Antigen', MS='A 40-45 KDa GPI-linked protein in the SLAM family that consists of two IMMUNOGLOBULIN C2-SET DOMAINS. It is expressed on the surface of a variety of cells with immune functions, including THYMOCYTES; mature B-LYMPHOCYTES and T-LYMPHOCYTES; NATURAL KILLER CELLS; DENDRITIC CELLS; MAST CELLS; and EOSINOPHILS. It  binds to CD2 and 2B4 (CD244) receptors to activate and modulate the immunologic response.'),
  'D000071179': NtO(MH='Signaling Lymphocytic Activation Molecule Associated Protein', MS='A signal transducing adaptor protein that contains a single SH2 DOMAIN and is essential for the regulation of SLAM FAMILY RECEPTORS in the immune response. Mutations in the SLAM-associated protein gene have been identified in cases of X-LINKED LYMPHOPROLIFERATIVE DISEASE.'),
  'D000071181': NtO(MH='ATP Binding Cassette Transporter, Subfamily B, Member 2', MS='An ATP-binding cassette, sub-family B protein (ATP BINDING CASSETTE TRANSPORTER, SUBFAMILY B) that functions in the transport of ANTIGENS from the CYTOPLASM to the ENDOPLASMIC RETICULUM for association with HISTOCOMPATIBILITY ANTIGENS CLASS I peptides. It also acts as a molecular scaffold for the final stage of MHC class I PROTEIN FOLDING.'),
  'D000071182': NtO(MH='Autophagosomes', MS='Large spherical double-layered structures which function in AUTOPHAGY to engulf intracellular components such as ORGANELLES or pathogens. Their outer membrane then fuses with the LYSOSOME and the inner membrane and contents are digested by lysosomal HYDROLASES.'),
  'D000071183': NtO(MH='Autophagy-Related Proteins', MS='Proteins and enzymes that function, often as components of MULTIPROTEIN COMPLEXES, to assemble AUTOPHAGOSOMES and carry out AUTOPHAGY.'),
  'D000071184': NtO(MH='Pharmacogenomic Variants', MS='Naturally occurring genetic variations associated with drug response (e.g., dosage, extent and rate of metabolic processes). While these variants are not markers for GENETIC PREDISPOSITION TO DISEASE they influence PHARMACOKINETICS and pharmacodynamics and often occur on genes encoding drug metabolism enzymes and transporters (e.g., ANGIOTENSIN CONVERTING ENZYME; CYTOCHROME P-450 CYP2D6).'),
  'D000071185': NtO(MH='Pharmacogenomic Testing', MS='The detection of genetic variability (e.g., PHARMACOGENOMIC VARIANTS) relevant to PHARMACOGENETICS and PRECISION MEDICINE. The purpose of such genetic testing is to help determine the most effective treatment options and their optimum dosages with least potential risks for DRUG-RELATED SIDE EFFECTS AND ADVERSE REACTIONS.'),
  'D000071186': NtO(MH='Beclin-1', MS='An autophagy related protein which functions as a core subunit of PHOSPHATIDYLINOSITOL 3-KINASE MULTIPROTEIN COMPLEXES. It mediates the formation of  phosphatidylinositol 3-phosphate and functions in AUTOPHAGY, where it is required for maturation of the AUTOPHAGOSOME. It also functions in ENDOCYTOSIS and CYTOKINESIS as part of a separate complex. Beclin-1 associates with INTRACELLULAR MEMBRANES and interacts with the PROTO-ONCOGENE PROTEINS C-BCL-2 and BCL-X PROTEIN.'),
  'D000071187': NtO(MH='Autophagy-Related Protein 5', MS='An autophagy-related protein that functions in AUTOPHAGOSOME biogenesis. It is conjugated to the ATG12 PROTEIN via a process that is similar to UBIQUITINATION and involves the ATG7 PROTEIN and ATG10 enzyme. The ATG12-ATG5 conjugate acts as an E3 UBIQUITIN LIGASE-like enzyme and is required for the localization of ATG8 PROTEINS to AUTOPHAGOSOME vesicle membranes and modification of membrane lipids.'),
  'D000071189': NtO(MH='Autophagy-Related Protein-1 Homolog', MS='A serine/threonine-protein kinase that functions in AUTOPHAGY in response to starvation. It acts on the PHOSPHATIDYLINOSITOL 3-KINASE complex PIK3C3 to regulate AUTOPHAGOSOME formation. It also functions as both a downstream effector and negative regulator of mammalian target of rapamycin complex 1 (mTORC1) and is activated by AMPK, which it also negatively regulates.'),
  'D000071190': NtO(MH='Autophagy-Related Protein 8 Family', MS='UBIQUITIN-like modifier proteins that function in CYTOPLASM to VACUOLE transport (Cvt), vesicle transport within the GOLGI APPARATUS, and AUTOPHAGOSOME biogenesis. They are also required for selective autophagic degradation of the nucleus (nucleophagy) and MITOPHAGY.'),
  'D000071192': NtO(MH='Autophagy-Related Protein 12', MS='A UBIQUITIN-like modifier protein that functions in AUTOPHAGOSOME formation, CYTOPLASM to VACUOLE transport, MITOPHAGY, and nucleophagy. Conjugation with ATG5 PROTEIN or ATG10 is essential for its function. The ATG12-ATG5 conjugate acts as an E3 UBIQUITIN LIGASE-like enzyme for lipid modification of ATG8 FAMILY PROTEINS and their localization to vesicle membranes.'),
  'D000071193': NtO(MH='Autophagy-Related Protein 7', MS='An autophagy related protein  that is similar to UBIQUITIN-ACTIVATING ENZYME E1. It functions in CYTOPLASM to VACUOLE transport (Cvt) and AUTOPHAGY by activating ATG12 PROTEIN for its conjugation with ATG5 PROTEIN, as well as the conjugation of ATG8 FAMILY PROTEINS with phosphatidylethanolamine for ATG8 association to Cvt vesicles and AUTOPHAGOSOME membranes. It is also required for the nitrogen starvation response in yeast, MITOPHAGY; and autophagic cell death induced by CASPASE 8 inhibition.'),
  'D000071194': NtO(MH='Camelidae', MS='The only extant family of the suborder Tylopoda (order Artiodactyla). Currently living members include domesticated species, DROMEDARIES (with one-hump); BACTRIAN CAMELS (with two humps); LLAMAS; ALPACAS, and wild feral camels; VICUNAS; and GUANACOS. Although they get nutrients from plants by rumination, they evolved separately from the RUMINANTS which have four-chambered stomachs. Camelidae have three-chambered stomachs.'),
  'D000071195': NtO(MH='Educational Personnel', MS='Professionals responsible for teaching in an institution or place of learning such as a school, college, vocational institute, or university.'),
  'D000071196': NtO(MH='Pyrin Domain', MS='A protein interaction domain of the death domain superfamily. It is characterized by a 6-helix bundle similar to those that occur in DEATH DOMAIN RECEPTORS. Pyrin domains are present in a variety of proteins, especially those that function in INFLAMMASOMES; AUTOPHAGY; and APOPTOSIS. They form homodimers or heterodimers with death domain proteins to facilitate the assembly of signaling complexes.'),
  'D000071197': NtO(MH='B30.2-SPRY Domain', MS='A protein interaction domain that is characterized by a bent "beta-sandwich" consisting of two antiparallel beta-sheets. It occurs in eukaryotic proteins, including many TRIPARTITE MOTIF PROTEINS, which function in a variety of cellular processes.'),
  'D000071198': NtO(MH='Pyrin', MS='A tripartite motif protein that consists of an N-terminal pyrin domain, a central coiled-coil region and B-box type ZINC FINGER, and C-terminal regions that mediate homotrimerization and interactions with other proteins (the B30.2/SPRY DOMAIN). It is expressed primarily by mature GRANULOCYTES and associates with the cytoskeleton in the perinuclear area as well as AUTOPHAGOSOMES, where it co-ordinates the assembly of AUTOPHAGY-RELATED PROTEINS and degradation of INFLAMMASOME components. It functions in INNATE IMMUNITY and INFLAMMATION; mutations in the Pyrin protein (MEFV) gene are associated with FAMILIAL MEDITERRANEAN FEVER.'),
  'D000071199': NtO(MH='NLR Family, Pyrin Domain-Containing 3 Protein', MS='An NLR protein that contains an N-terminal PYRIN DOMAIN and ATP-binding site and 9 C-terminal LEUCINE-rich repeats; it is expressed primarily by MACROPHAGES. It is a core component of the INFLAMMASOME and directs its assembly in response to pathogen infection and damage-associated stimuli. Mutations in the NLRP3 gene are associated with FAMILIAL COLD AUTOINFLAMMATORY SYNDROME.'),
  'D000071216': NtO(MH='Faculty, Pharmacy', MS='Teaching and administrative staff having academic rank in a pharmacy school or department.'),
  'D000071217': NtO(MH='Infradian Rhythm', MS='A biological rhythm with a period longer than 24 hours.'),
  'D000071218': NtO(MH='Ultradian Rhythm', MS='A biological rhythm with a period shorter than 24 hours.'),
  'D000071219': NtO(MH='Global Burden of Disease', MS='Measure of the burden of disease using the disability-adjusted-life-year (DALY). This time-based measure combines years of life lost due to premature mortality and years of life lost due to time lived in states of less than full health. The metric was developed to assess the burden of disease consistently across diseases, risk factors and regions.'),
  'D000071220': NtO(MH='Pharmaceutical Research', MS='RESEARCH activity focused on pharmaceutical products and services.'),
  'D000071221': NtO(MH='Enhancer of Zeste Homolog 2 Protein', MS='A histone-lysine N-methyltransferase and catalytic subunit of Polycomb Repressive Complex 2.  It methylates LYSINE 9 (H3K9me) and LYSINE 27 (H3K27me) of HISTONE H3, leading to transcriptional repression of the affected target gene. EZH2 also methylates non-histone proteins such as GATA4 TRANSCRIPTION FACTOR and the nuclear receptor RORA. It regulates CIRCADIAN CLOCKS via histone methylation of circadian protein gene PROMOTER REGIONS, and its repressive activity is also important for the identity and differentiation of EMBRYONIC STEM CELLS.'),
  'D000071222': NtO(MH='Suppressor of Cytokine Signaling 1 Protein', MS='A suppressor of cytokine signaling protein that consists of an N-terminal kinase-inhibitory region, a central SH2 DOMAIN, a characteristic C-terminal SOCS box (a 40-amino acid motif, which functions to recruit E3 UBIQUITIN-PROTEIN LIGASE COMPLEXES). SOCS1 functions as a negative regulator of CYTOKINES that signal through the JANUS KINASES-STAT 3 TRANSCRIPTION FACTOR (JAK/STAT3) pathway by inhibiting the activity of JANUS KINASES.'),
  'D000071223': NtO(MH='Suppressor of Cytokine Signaling 3 Protein', MS='A suppressor of cytokine signaling protein that consists of an N-terminal kinase-inhibitory region, a central SH2 DOMAIN, a characteristic C-terminal SOCS box (a 40-amino acid motif, which functions to recruit E3 UBIQUITIN-PROTEIN LIGASE COMPLEXES). SOCS3 inhibits cytokine signaling by binding to RECEPTOR PROTEIN-TYROSINE KINASES as well as CYTOKINE RECEPTOR GP130; ERYTHROPOIETIN RECEPTORS; INSULIN RECEPTOR; and the LEPTIN RECEPTOR. Its functions include suppression of ERYTHROPOIESIS in the fetal liver.'),
  'D000071225': NtO(MH='Influenza A Virus, H5N8 Subtype', MS='A subtype of INFLUENZA A VIRUS that is highly virulent in poultry and wild birds, but shows varying degrees of pathogenicity in mice. The H5N8 virus subtype has a polybasic amino acid motif at the HA cleavage site which explains its pathogenicity in birds, and expresses surface proteins HEMAGGLUTININ 5 and NEURAMINIDASE 8 which are typical of Highly Pathogenic Avian Influenza viruses.'),
  'D000071228': NtO(MH='Polyelectrolytes', MS='Naturally-occurring or artificially made water-soluble POLYMERS whose repeating units are ionizable. Polyelectrolytes demonstrate attributes that are typical of salts, such as electrical conductivity, and typical of  polymers, such as viscosity.'),
  'D000071229': NtO(MH='Perilipin-4', MS='A perilipin protein characterized by an extensive 11-mer repeat region, which forms five adjacent alpha-helices. It is expressed primarily in WHITE ADIPOSE TISSUE and differentiating ADIPOCYTES, as well as skeletal muscle and heart.  It is soluble in the cytoplasm but re-localizes to the surface of LIPID DROPLETS under high lipid conditions.'),
  'D000071230': NtO(MH='Transcriptional Regulator ERG', MS="A trans-activator and member of the erythroblast transformation-specific family of transcriptions factors that contain a characteristic ETS MOTIF. It is required for PLATELET CELL ADHESION to the subendothelium and associates with CHIMERIC ONCOGENE PROTEINS in PROSTATE CANCER; EWING'S SARCOMA; and ACUTE MYELOID LEUKEMIA."),
  'D000071231': NtO(MH='Carbonic Anhydrase IX', MS='A carbonic anhydrase and transmembrane protein that consists of an N-terminal PROTEOGLYCAN-like domain, a catalytic region, a single-pass transmembrane domain, and a short intracellular tail. It functions as a dimer and is expressed primarily by cells of the GASTROINTESTINAL TRACT; BILE DUCT EPITHELIUM; and GALL BLADDER. It is expressed at high levels in many solid tumors, especially CLEAR CELL RENAL CARCINOMA, in response to CELL HYPOXIA.'),
  'D000071232': NtO(MH='Small Leucine-Rich Proteoglycans', MS='A proteoglycan family (SLRPs) that is defined by a central domain which consists of a variable number of repeats of the motif LXXLxLXXNxL, where L may be LEUCINE; ISOLEUCINE; VALINE; or other hydrophobic amino acids. The N-terminal contains four conserved CYSTEINE residues and may be modified depending on function. SLRPs provide structural support to the EXTRACELLULAR MATRIX and are critical for regulating its assembly and dynamics at CELL-MATRIX JUNCTIONS.'),
  'D000071234': NtO(MH='Lumican', MS='A small leucine-rich proteoglycan that contains 10 tandem leucine repeats and four N-linked sites within the leucine repeat region that may be substituted with KERATAN SULFATE. These properties and its horseshoe shape allow it to mediate interactions among COLLAGEN molecules within fibrils. It is expressed in most mesenchymal tissues as well as the CORNEA, where it functions to maintain transparency.'),
  'D000071235': NtO(MH='Fibromodulin', MS='A small leucine-rich proteoglycan that contains 4 KERATAN SULFATE chains within the leucine repeat region. It interacts with COLLAGEN TYPE I and COLLAGEN TYPE II fibrils and may function to control the rate of EXTRACELLULAR MATRIX assembly. It also sequesters TRANSFORMING GROWTH FACTOR BETA in the extracellular matrix.'),
  'D000071238': NtO(MH='Fibronectin Type III Domain', MS='A highly conserved immunoglobulin-like protein domain of about 100 amino acids that forms a beta sandwich structure.'),
  'D000071241': NtO(MH='Double-Stranded RNA Binding Motif', MS='An RNA-binding motif characterized by an alpha-beta-beta-beta-alpha fold that binds DOUBLE-STRANDED RNA. It occurs in many eukaryotic proteins as well as in bacterial and viral proteins.'),
  'D000071243': NtO(MH='Zika Virus Infection', MS='A viral disease transmitted by the bite of AEDES mosquitoes infected with ZIKA VIRUS. Its mild DENGUE-like symptoms include fever, rash, headaches and ARTHRALGIA. The viral infection during pregnancy, in rare cases, is associated with congenital brain and ocular abnormalities, called Congenital Zika Syndrome, including MICROCEPHALY and may also lead to GUILLAIN-BARRE SYNDROME.'),
  'D000071244': NtO(MH='Zika Virus', MS='An arbovirus in the FLAVIVIRUS genus of the family FLAVIVIRIDAE. Originally isolated in the Zika Forest of UGANDA it has been introduced to Asia and the Americas.'),
  'D000071245': NtO(MH='Mitochondrial Uncoupling Proteins', MS='Mitochondrial anion carrier proteins that function as dimers and form proton channels in the INNER MITOCHONDRIAL MEMBRANE which creates proton leaks and uncouples OXIDATIVE PHOSPHORYLATION from ATP synthesis, resulting in the generation of heat instead of ATP.'),
  'D000071246': NtO(MH='Uncoupling Protein 2', MS='A mitochondrial uncoupling protein that is expressed in many tissues and exhibits the greatest expression in SKELETAL MUSCLE. It regulates mitochondrial ATP production and the generation of REACTIVE OXYGEN SPECIES.'),
  'D000071247': NtO(MH='Uncoupling Protein 3', MS='A mitochondrial uncoupling protein that is expressed in heart and skeletal muscle tissues. It functions to regulate tissue respiration, energy balance, and THERMOGENESIS. Mutations in the UCP3 gene are associated with OBESITY.'),
  'D000071248': NtO(MH='Peroxisome Proliferator-Activated Receptor Gamma Coactivator 1-alpha', MS='A transcriptional co-activator for NUCLEAR RECEPTORS. It is characterized by an N-terminal LxxLL sequence, a region that interacts with PPAR GAMMA, and a C-terminal RNA RECOGNITION MOTIF. It increases expression of MITOCHONDRIAL UNCOUPLING PROTEIN to regulate genes involved in metabolic reprogramming in response to dietary restriction and the integration of CIRCADIAN RHYTHMS with ENERGY METABOLISM.'),
  'D000071250': NtO(MH='Snail Family Transcription Factors', MS='A transcription factor family characterized by the presence of several  C-terminal CYS2-HIS2 ZINC FINGERS. They function in many developmental processes including the induction of the EPITHELIAL-MESENCHYMAL TRANSITION; maintenance of embryonic MESODERM; growth arrest, CELL SURVIVAL; and CELL MIGRATION.'),
  'D000071251': NtO(MH='Extreme Environments', MS='An ENVIRONMENT which falls outside the range of tolerance for the survival of organisms that are not specifically adapted to survive or thrive in it. Examples of such environments are among the hottest and coldest places on earth.'),
  'D000071252': NtO(MH='Mentoring', MS='The art and practice of training, guiding, COUNSELING, and providing support to a less experienced, trained, or knowledgeable person.'),
  'D000071253': NtO(MH='Metadata', MS='Structured data elements used to describe other data.'),
  'D000071256': NtO(MH='Uncoupling Protein 1', MS='A mitochondrial uncoupling protein that is expressed in BROWN ADIPOSE TISSUE. It is critical for NONSHIVERING THERMOGENESIS to prevent heat loss in NEONATES.'),
  'D000071257': NtO(MH='Emergence Delirium', MS='A form of DELIRIUM which occurs after GENERAL ANESTHESIA.'),
  'D000071277': NtO(MH='Harassment, Non-Sexual', MS='The act of systematic and/or continuous unwanted and irritating actions of a non-sexual nature, by a party or group against another. This behavior may include threats, BULLYING, taunts, blackmail, and demands.'),
  'D000071278': NtO(MH='Domestication', MS='A systematic process of adapting wild species of animals and plants into new environments often in close association or proximity to humans.'),
  'D000071296': NtO(MH='Government Employees', MS='Persons employed by the GOVERNMENT.'),
  'D000071297': NtO(MH='Acute Retroviral Syndrome', MS='Early stage of HIV infection. Symptoms resemble INFLUENZA or INFECTIOUS MONONUCLEOSIS.'),
  'D000071298': NtO(MH='Body Remains', MS='The physical entity of a deceased human or animal.'),
  'D000071316': NtO(MH='Forkhead Box Protein O3', MS="A forkhead box transcription factor and transcriptional activator which triggers type 1 programmed cell death (APOPTOSIS) in the absence of APOPTOSIS INHIBITING PROTEINS, including neuronal cell death induced by OXIDATIVE STRESS. It recognizes and binds to the DNA sequence 5'-(AG)TAAA(TC)A-3' and also functions in post-transcriptional regulation of the c-MYC PROTO-ONCOGENE."),
  'D000071317': NtO(MH='Nanog Homeobox Protein', MS='A homeodomain protein and transcription regulator that functions in BLASTOCYST INNER CELL MASS and EMBRYONIC STEM CELL proliferation and CELL SELF RENEWAL. It confers pluripotency on embryonic stem cells and prevents their differentiation towards extraembryonic ENDODERM and trophectoderm (TROPHOBLAST) CELL LINEAGES.'),
  'D000071336': NtO(MH='Transcription Activator-Like Effectors', MS='Virulence factors of pathogenic plant bacteria, such as XANTHOMONAS species, that bind to specific sequences in the PROMOTER REGIONS of host DNA to induce transcription of specific host genes.  Variations in the DNA binding domain of TALE family members account for the variations in DNA specificity. The TALE DNA-binding domains are used in various GENETIC TECHNIQUES by fusing them with various DNA modifying enzymes to detect and manipulate sequence-specific targeted DNA sites.'),
  'D000071376': NtO(MH='RNA-Binding Motifs', MS='Amino acid motifs that bind RNA.'),
  'D000071377': NtO(MH='RNA Recognition Motif', MS='An approximately 80 amino acid RNA binding motif that consists of four anti-parallel surface beta sheets and two alpha helices arranged in a beta-alpha-beta-beta-alpha-beta configuration. One of the surface beta sheets interacts with two or three specific RNA bases. Interactions between additional sequences and the RNA, as well as within the RNA recognition motif increase the affinity and specificity of the protein-RNA interaction.'),
  'D000071378': NtO(MH='Bunion', MS='Abnormal swelling of the inner aspect of the first metatarsal head affecting the first METATARSOPHALANGEAL JOINT.'),
  'D000071380': NtO(MH='Fibromatosis, Plantar', MS='A fibromatosis of the plantar fascia characterized by thickening of the fibrous bands on the plantar aponeurosis in the sole of the foot and toes.'),
  'D000071396': NtO(MH='Aldehyde Dehydrogenase, Mitochondrial', MS='An aldehyde dehydrogenase expressed in the mitochondrial matrix that is essential for the metabolism of ETHANOL.'),
  'D000071416': NtO(MH='Twist Transcription Factors', MS='A  highly-conserved family of basic helix-loop-helix (bHLH) transcription factors.  They function as dimers with other bHLH proteins and bind E-BOX ELEMENTS to control gene expression during EMBRYOGENESIS and the EPITHELIAL-MESENCHYMAL TRANSITION.'),
  'D000071417': NtO(MH='Twist-Related Protein 2', MS='A twist family transcription factor that is expressed in MESODERM as well as the DERMIS during mammalian EMBRYOGENESIS. It is structurally and functionally similar to TWIST-RELATED PROTEIN 1; it also regulates OSTEOGENESIS and the expression of CYTOKINES in response to INFLAMMATION.'),
  'D000071419': NtO(MH='ETS Motif', MS='A helix-turn-helix motif characterized by three alpha-helices and four-stranded beta-sheets arranged in the order alpha1-beta1-beta2-alpha2-alpha3-beta3-beta4. The third alpha-helix contacts the major groove of DNA. The ETS motif and the flanking amino acid sequences of Ets proteins influence the binding affinity, and the alteration of a single amino acid in the Ets domain can change its DNA binding specificity.'),
  'D000071421': NtO(MH='Life History Traits', MS='Morphological or behavioral traits influenced by various living conditions that a population encounters especially as it pertains to REPRODUCTION and survival of the population (see POPULATION DYNAMICS) such as age at first reproductive event, number and size of offspring, and lifespan.'),
  'D000071422': NtO(MH='Inbreeding Depression', MS='A reduced GENETIC VARIATION and GENETIC FITNESS due to INBREEDING.'),
  'D000071425': NtO(MH='Src Homology 2 Domain-Containing, Transforming Protein 1', MS='An SHC-signaling adaptor protein that transduces PHOSPHOTYROSINE-dependent signals downstream of RECEPTOR PROTEIN-TYROSINE KINASES and non-receptor tyrosine kinases. It is required for TGF-BETA-induced CELL MIGRATION; NEOLPASM INVASION; and METASTASIS of BREAST NEOPLASMS; its SH2 DOMAIN is essential for tumor survival. It also functions in signaling downstream of  ANGIOPOIETIN RECEPTOR TIE-2, regulating the migration of ENDOTHELIAL CELLS; and PHYSIOLOGIC NEOVASCULARIZATION.'),
  'D000071426': NtO(MH='Src Homology 2 Domain-Containing, Transforming Protein 2', MS='An SHC-signaling adaptor protein that links GROWTH FACTOR RECEPTORS to SIGNAL TRANSDUCTION PATHWAYS in neurons.'),
  'D000071427': NtO(MH='Src Homology 2 Domain-Containing, Transforming Protein 3', MS='An SHC-signaling adaptor protein that links GROWTH FACTOR RECEPTORS to SIGNAL TRANSDUCTION PATHWAYS in neurons, including NEUROTROPHINS signaling in the CENTRAL NERVOUS SYSTEM.'),
  'D000071436': NtO(MH='Thermotolerance', MS='The ability of an organism to reduce susceptibility to heat shock, and adapt to HOT TEMPERATURE.'),
  'D000071437': NtO(MH='Axon Guidance', MS='The mechanism by which a neuronal process outgrows toward a target led by the GROWTH CONE. Local guidance cues are provided by cell surface proteins that act on the growing axon.'),
  'D000071438': NtO(MH='Fatty Acid-Binding Protein 7', MS='A fatty acid-binding protein expressed by ASTROCYTES during CENTRAL NERVOUS SYSTEM development, and by MALIGNANT GLIOMA cells. It is also expressed by ASTROCYTES in response to injury or ISCHEMIA, and may function in repair of the MYELIN SHEATH.'),
  'D000071439': NtO(MH='Pseudoautosomal Regions', MS="Homologous chromosomal regions at either end of the X CHROMOSOME or Y CHROMOSOME. These two regions pair regularly at male MEIOSIS and undergo RECOMBINATION. Pseudoautosomal region 1 (PAR1) is located  at the tip of the short 'p' arms (Xp22 and Yp11) and Pseudoautosomal region 2 (PAR2) is located at the tip of the long 'q' arms (Xq28 and Yq12)."),
  'D000071441': NtO(MH='Emotion-Focused Therapy', MS='Intervention that relies on free expression of emotions with coaching to enhance awareness of emotional experiences.'),
  'D000071442': NtO(MH='Taxis Response', MS='A behavior in free-moving organism that results in motion or orientation toward or away from an external stimulus.'),
  'D000071443': NtO(MH='12E7 Antigen', MS='A cell adhesion molecule that, in humans, is encoded by a gene on the PSEUDOAUTOSOMAL REGION of SEX CHROMOSOMES. It functions in CELL ADHESION of T-LYMPHOCYTES and ROSETTE FORMATION by ERYTHROCYTES. It is also involved in the migration of LEUKOCYTES through the ENDOTHELIUM BASEMENT MEMBRANE. The 12E7 antigen co-localizes with, but functions independently of PECAM-1.'),
  'D000071444': NtO(MH='Phototaxis', MS='A behavioral change that results in an organism moving or orienting toward or away from the light source.'),
  'D000071446': NtO(MH='Neuronal Outgrowth', MS='Formation of neuronal processes (AXONS; NEURITES) toward a target cell.'),
  'D000071447': NtO(MH='N-Myc Proto-Oncogene Protein', MS='A basic helix-loop-helix leucine zipper (bHLHZ) transcription factor and proto-oncogene protein that functions in cell growth and proliferation. In mammals, it is highly expressed in the brain during embryogenesis and is essential for brain development; it is not expressed in adult tissues. Amplification or overexpression of N-Myc occurs in at least 20% of tumors and is associated with a poor prognosis in cases of NEUROBLASTOMA; ALVEOLAR RHABDOMYOSARCOMA; SMALL CELL LUNG CARCINOMA; and neuroendocrine prostate cancer.'),
  'D000071448': NtO(MH='Axon Fasciculation', MS='Process of organizing neighboring AXONS into a bundle or a fascicle during neurite outgrowth mediated by CELL ADHESION MOLECULES.'),
  'D000071449': NtO(MH='Proprotein Convertase 9', MS='A proprotein convertase that is essential for CHOLESTEROL homeostasis. It binds to and is required for the lysosomal degradation of the LDL RECEPTOR (LDLR); the VLDL receptor, and the APOLIPOPROTEIN E RECEPTOR. It also regulates neuronal APOPTOSIS.'),
  'D000071450': NtO(MH='ATP Binding Cassette Transporter, Subfamily B, Member 3', MS='ATP-binding cassette, subfamily B, protein that functions in the transport of ANTIGENS from the CYTOPLASM to the ENDOPLASMIC RETICULUM for association with HISTOCOMPATIBILITY ANTIGENS CLASS I peptides. It functions as a heterodimer with ATP BINDING CASSETTE TRANSPORTER, SUBFAMILY B, MEMBER 2.'),
  'D000071451': NtO(MH='Chitinase-3-Like Protein 1', MS='A lectin that binds CHITIN, but lacks chitinase activity. It may be involved in tissue remodeling and cellular responses to the environment, including the response of type 2 HELPER T-CELLS to INFLAMMATION and sensitization to ALLERGENS. Mutations in the CHI3L1 gene are associated with ASTHMA.'),
  'D000071456': NtO(MH='Sequestosome-1 Protein', MS='A multidomain protein that is highly conserved among multicellular organisms. It contains a ZZ-type ZINC FINGER domain, C-terminal UBIQUITIN - associated (UBA) domain, and interacts with many other signaling proteins and enzymes including, atypical PROTEIN KINASE C; TNF RECEPTOR-ASSOCIATED FACTOR 6; subunits of the mTORC1 complex, and CASPASE-8. It functions in AUTOPHAGY as a receptor for the degradation of ubiquitinated substrates, and to co-ordinate signaling in response to OXIDATIVE STRESS.'),
  'D000071457': NtO(MH='DEAD Box Protein 58', MS="A DEAD-box RNA helicase that contains an N-terminal DEATH-LIKE DOMAIN, AAA+ ATPase domain, and C-terminal RNA HELICASE activity. It functions as an innate immune receptor through its recognition of viral nucleic acids. It also induces the expression of INTERFERON TYPE I and proinflammatory CYTOKINES. Its ligands include: 5'-triphosphorylated SINGLE-STRANDED RNA, DOUBLE-STRANDED RNA (dsRNA), and short dsRNA (less than 1 kb in length)."),
  'D000071458': NtO(MH='Death Domain Superfamily', MS='A family of structurally-related protein interaction domains characterized by 6-helical closed bundle fold, with Greek key topology and an internal pseudo two-fold symmetry. Death-like domains occur in many proteins that are essential for APOPTOSIS, including CASPASE RECRUITMENT DOMAIN CONTAINING PROTEINS and DEATH DOMAIN RECEPTORS.'),
  'D000071459': NtO(MH='Death Domain', MS='A conserved protein interaction domain of the death domain superfamily that is structurally similar to the DEATH EFFECTOR DOMAIN and CASPASE RECRUITMENT DOMAIN. Death domains bind each other to form oligomers and occur on DEATH DOMAIN RECEPTORS, where they are required for APOPTOSIS signaling and non-apoptotic functions.'),
  'D000071461': NtO(MH='Death Effector Domain', MS='A homotypic protein interaction module of the death domain superfamily that is composed of a bundle of six alpha-helices. The death effector domain shares sequence and structural similarities with the DEATH DOMAIN and CASPASE RECRUITMENT DOMAIN. It occurs in many proteins with essential functions in APOPTOSIS.'),
  'D000071476': NtO(MH='Caspase Activation and Recruitment Domain', MS='A homotypic protein interaction module of the death domain superfamily. It is composed of a bundle of six alpha-helices that is related in sequence and structure to the DEATH DOMAIN and DEATH EFFECTOR DOMAIN. The Caspase Activation and Recruitment Domain (CARD domain) typically associates with other CARD-containing proteins, forming either dimers or trimers. CARD domains may occur in isolation, or in combination with other domains in CARD signaling adaptor proteins and initiator CASPASES that function in APOPTOSIS.'),
  'D000071477': NtO(MH='Gubernaculum', MS='An embryonic structure that helps guide proper descent of gonads into their final positions. It attaches the caudal end of the fetal GONADS to the developing SCROTUM in male and the labium majorum in female. It gives rise to the caudal ligaments of the gonad: the scrotal ligament in male and the uterine round and proper ovarian ligaments in female. It includes morphofunctional equivalent structures in non-mammals.'),
  'D000071478': NtO(MH='APOBEC Deaminases', MS='A family of conserved cytidine deaminases that catalyze the DEAMINATION of CYTIDINE to URIDINE. They are characterized by N and C-terminal zinc-dependent catalytic domains and have important functions in RNA EDITING; EPIGENTIC PROCESSES; and the INNATE IMMUNE RESPONSE against viruses.'),
  'D000071479': NtO(MH='APOBEC-1 Deaminase', MS='An APOBEC deaminase catalytic subunit of the apolipoprotein B (APOB) MESSENGER RNA (mRNA) editing enzyme complex that is involved in post-transcriptional editing of a CAA codon for GLYCINE to a UAA STOP CODON in the ApoB mRNA. It also functions in CGA (ARGININE) to UGA STOP CODON editing of NEUROFIBROMIN 1 mRNA and EPIGENETIC PROCESSES.'),
  'D000071480': NtO(MH='APOBEC-3G Deaminase', MS='An APOBEC deaminase that functions as an inhibitor of RETROVIRIDAE replication and inhibits the mobility of RETROTRANSPOSONS via deaminase-dependent and independent mechanisms. It is selective for SINGLE-STRANDED DNA and does not deaminate double-stranded DNA or single or DOUBLE-STRANDED RNA. It exhibits potent antiviral activity against VIF PROTEIN deficient HIV-1 through the creation of hypermutations in the VIRAL DNA. It also has anti-viral activity against SIMIAN IMMUNODEFICIENCY VIRUSES and HEPATITIS B VIRUS.'),
  'D000071496': NtO(MH='AlkB Enzymes', MS='A family of alpha- KETOGLUTARIC ACID and Fe(II)-dependent dioxygenases that are homologous to AlkB, an enzyme that repairs alkylated nucleic acids in E. coli. The mammalian homologs have diverse substrate specificities and functions that include DNA REPAIR, generating unique wobble modifications in URIDINE tRNA, demethylation of nucleotides in DNA and RNA, and demethylation of LYSINE residues on certain proteins, including ACTIN and histones (HISTONE CODE).'),
  'D000071497': NtO(MH='Immunogenicity, Vaccine', MS='The capacity of VACCINES to stimulate the ADAPTIVE IMMUNE RESPONSE to produce antibodies and antigen-specific T-CELL responses.'),
  'D000071498': NtO(MH='AlkB Homolog 1, Histone H2a Dioxygenase', MS='A dioxygenase and alkylation repair homolog that functions by oxidative demethylation in RNA and DNA REPAIR of substrates which contain 3-methylcytosine. It also functions as one of the HISTONE DEMETHYLASES involved in embryonic development and maintaining the pluripotency of EMBRYONIC STEM CELLS.'),
  'D000071499': NtO(MH='AlkB Homolog 2, Alpha-Ketoglutarate-Dependent Dioxygenase', MS='A dioxygenase and alkylation repair homolog that repairs alkylated DNA and RNA containing 1-methyladenine and 3-methylcytosine by oxidative demethylation. It can also repair alkylated DNA containing 1-ethenoadenine in vitro. It has highest affinity for double-stranded DNA.'),
  'D000071500': NtO(MH='AlkB Homolog 3, Alpha-Ketoglutarate-Dependent Dioxygenase', MS='A dioxygenase and alkylation repair homolog that repairs alkylated DNA containing 1-methyladenine (1meA) and 3-methylcytosine (3meC) by oxidative demethylation. It has a strong preference for SINGLE-STRANDED DNA and may also act on RNA.'),
  'D000071501': NtO(MH='AlkB Homolog 4, Lysine Demethylase', MS="A dioxygenase and alkylation repair homolog that mediates demethylation of ACTIN monomethylated at 'Lys-84' (K84me1).  Demethylation of actin LYSINE 84 (K84me1) is required for maintaining actin and MYOSIN dynamics to support normal cleavage furrow ingression during CYTOKINESIS and CELL MIGRATION. It may also be involved in transcription regulation."),
  'D000071502': NtO(MH='AlkB Homolog 5, RNA Demethylase', MS='A dioxygenase and alkylation repair homolog  that demethylates RNA by oxidative demethylation. It specifically demethylates N(6)-methyladenosine (m6A) RNA, the most common internal modification of MESSENGER RNA in higher eukaryotes.  It can also demethylate N(6)-methyladenosine in SINGLE-STRANDED DNA.'),
  'D000071503': NtO(MH='AlkB Homolog 8, tRNA Methyltransferase', MS='A dioxygenase and alkylation repair homolog that catalyzes the methylation of 5-carboxymethyl URIDINE to 5-methylcarboxymethyl uridine at the wobble position of the ANTICODON loop in TRANSFER RNA (tRNA) via its methyltransferase domain. It has a preference for tRNA (ARGININE) and tRNA (GLUTAMATE), and does not bind tRNA (LYSINE).'),
  'D000071516': NtO(MH='Alpha-Ketoglutarate-Dependent Dioxygenase FTO', MS='A dioxygenase that repairs alkylated DNA and RNA by oxidative demethylation. It has highest activity towards single-stranded RNA containing 3-methyluracil, followed by SINGLE-STRANDED DNA containing 3-methylthymine and specifically demethylates N(6)-methyladenosine (m6A) RNA, the most common internal modification of MESSENGER RNA (mRNA) in higher EUKARYOTES. It contributes to the regulation of the global metabolic rate, energy HOMEOSTASIS, as well as body fat accumulation by regulating the differentiation of ADIPOCYTES into BROWN FAT CELLS or WHITE FAT CELLS.'),
  'D000071518': NtO(MH='Liver X Receptors', MS='Nuclear receptors that bind OXYSTEROLS and function as heterodimers with RETINOID X RECEPTORS. They have important functions in regulating cholesterol homeostasis, ENERGY METABOLISM; INFLAMMATION; and the immune response.'),
  'D000071538': NtO(MH='Cortical Bone', MS='A type of osseous tissue which makes up the outer layer of bone. It is dense, rigid, strong, and forms concentric lamellar OSTEONS.'),
  'D000071556': NtO(MH='Cancellous Bone', MS='A type of osseous tissue which makes up the inner part of bone.  It has a spongy, honeycomb-like structure with struts or trabecula and contains the BONE MARROW. It has higher rate of BONE REMODELING turnover than CORTICAL BONE.'),
  'D000071557': NtO(MH='beta-Arrestins', MS='Non-visual system arrestins that negatively regulate G-PROTEIN-COUPLED RECEPTORS (GPCRs) and may also function independently of GPCR signaling. They bind and recruit many different signaling factors, including MITOGEN-ACTIVATED PROTEIN KINASES; SRC-FAMILY-KINASES; and FILAMIN to GPCRs and may recognize different phosphorylation states of the receptors to determine the specificity of the cellular response to signaling.'),
  'D000071559': NtO(MH='beta-Arrestin 1', MS='A beta-arrestin that functions in the down-regulation of signaling by G-PROTEIN-COUPLED RECEPTORS. It is also a major regulator of INSULIN signaling via the ERK 1-2 PATHWAY, and many other signaling processes, especially in NEURONS and LEUKOCYTES.'),
  'D000071560': NtO(MH='beta-Arrestin 2', MS='A beta-arrestin that functions similarly to BETA-ARRESTIN 1 in regulating signaling by G-PROTEIN-COUPLED RECEPTORS. It is expressed at high levels in the central nervous system where it may regulate signaling by SYNAPTIC RECEPTORS.'),
  'D000071562': NtO(MH='Fractures, Avulsion', MS='Tearing away of the CORTICAL BONE fragment at the location of a strong ligament or tendon attachment. The bone fragment detachment site often occurs near a soft site (e.g., GROWTH PLATE) at the base where LIGAMENTS; TENDONS; or JOINT CAPSULES attach. In younger patients it is most often caused by a sudden forceful pull on a tendon in the opposite direction of the bone movement. In the elderly it is associated with osteoporotic INSUFFICIENCY FRACTURES.'),
  'D000071576': NtO(MH='Crush Injuries', MS='Excessive compression of parts of the body that causes muscle swelling, fracture, and/or neurological disturbances in the affected areas. Crush injury with systemic manifestations is referred to as CRUSH SYNDROME.'),
  'D000071596': NtO(MH='Abdominal Oblique Muscles', MS='Muscles of the anterolateral abdominal wall consisting of the external oblique and the internal oblique muscles. The external abdominal oblique muscle fibers extend from lower thoracic ribs to the linea alba and the iliac crest. The internal abdominal oblique extend superomedially beneath the external oblique muscles.'),
  'D000071616': NtO(MH='CDX2 Transcription Factor', MS='An antennapedia-like homeodomain transcription factor that regulates the expression of multiple genes in the INTESTINAL MUCOSA. It plays a critical role in many processes from early differentiation to maintenance of the intestinal epithelial lining of both the small and large intestine.'),
  'D000071617': NtO(MH='Protein Deglycase DJ-1', MS='A protein deglycase that repairs methylglyoxal- and glyoxal-glycated amino acids and proteins, releasing repaired proteins and lactate or glycolate. It deglycates CYSTEINE, ARGININE and LYSINE residues to reactivate proteins by reversing glycation and prevent the formation of ADVANCED GLYCATION END PRODUCTS. It protects cells against OXIDATIVE STRESS and CELL DEATH by functioning as an oxidative stress sensor and redox-sensitive MOLECULAR CHAPERONE and PROTEASE. Mutations in the PARK7 gene are associated with autosomal-recessive, early-onset PARKINSON DISEASE.'),
  'D000071636': NtO(MH='Protein Phosphatase 2C', MS='One of four major classes of mammalian serine/threonine specific protein phosphatases. Protein phosphatase 2C is a monomeric enzyme about 42 kDa in size. It shows broad substrate specificity dependent on divalent cations (mainly manganese and magnesium). Three isozymes are known in mammals: PP2C -alpha, -beta and -gamma. In yeast, there are four PP2C homologues: phosphatase PTC1 that have weak tyrosine phosphatase activity, phosphatase PTC2, phosphatase PTC3, and PTC4. Isozymes of PP2C also occur in Arabidopsis thaliana where the kinase-associated protein phosphatase (KAPP) containing a C-terminal PP2C domain, dephosphorylates Ser/Thr receptor-like kinase RLK5.'),
  'D000071656': NtO(MH='Receptor, Notch3', MS='A notch receptor characterized by a large extracellular domain containing 34 EPIDERMAL GROWTH FACTOR-like repeats. It functions to regulate CELL DIFFERENTIATION; APOPTOSIS; and CELL PROLIFERATION. Mutations in the EGF repeats of Notch-3 are associated with CADASIL.'),
  'D000071657': NtO(MH='Werner Syndrome Helicase', MS="A DNA-dependent helicase and 3'-5' exonuclease. It has  3'->5' exonuclease activity towards double-stranded DNA with a 5'-overhang and binds preferentially to DNA substrates containing alternate secondary structures, such as replication forks and HOLLIDAY JUNCTIONS. Mutations in the WRN gene are associated with WERNER SYNDROME."),
  'D000071676': NtO(MH='Zinc Finger Protein GLI1', MS='A transcriptional activator and oncogene protein that contains two CYS2-HIS2 ZINC FINGERS. Two isoforms are expressed; both regulate the expression of specific genes during development of craniofacial features, digits, the CENTRAL NERVOUS SYSTEM; and the GASTROINTESTINAL TRACT. They also regulate SONIC HEDGEHOG PROTEIN signaling and cell proliferation.'),
  'D000071677': NtO(MH='Histidine Kinase', MS='A member of the transferase superfamily of proteins. In the activated state, protein-histidine kinase autophosphorylates at a histidine residue, subsequently transferring high-energy phosphoryl groups to an aspartate residue of the response-regulator domain, which results in a conformational shift in the effector domain. Histidine kinases mediate signal transduction in a wide range of processes involving cellular adaptation to environmental stress.'),
  'D000071678': NtO(MH='WD40 Repeats', MS='Protein interaction motifs of approximately 40 amino acids that usually terminate in TRYPTOPHAN and ASPARTIC ACID. They form characteristic beta-propeller structures and occur in many eukaryotic proteins that function in a variety of cellular processes. Proteins that contain WD40 repeats often function as assembly platforms for MULTIPROTEIN COMPLEXES.'),
  'D000071679': NtO(MH='Glycogen Synthase Kinase 3 beta', MS='A glycogen synthase kinase-3 type enzyme that functions in ENERGY METABOLISM; EMBRYONIC DEVELOPMENT; and NEUROGENESIS. It is also involved in PROTEIN BIOSYNTHESIS and regulates cell growth and proliferation as a component of the WNT SIGNALING PATHWAY and other signaling pathways. Certain polymorphisms in the GSK3B gene have been associated with PARKINSON DISEASE; ALZHEIMER DISEASE; and BIPOLAR DISORDER.'),
  'D000071681': NtO(MH='Tartrate-Resistant Acid Phosphatase', MS='One of several acid phosphatases in humans, other mammals, plants, and a few prokaryotes. The protein fold of tartrate-resistant acid phosphatase (TRAP) resembles that of the catalytic domain of plant purple acid phosphatase and other serine/threonine-protein phosphatases that also contain a metallophosphoesterase domain. One gene produces the various forms which include purple acid phosphatases from spleen and other tissues. Tartrate-resistant acid phosphatase is a biomarker for pathological states in which it is over-expressed. Such conditions include GAUCHER DISEASE; HODGKIN DISEASE; BONE RESORPTION; and NEOPLASM METASTASIS.'),
  'D000071682': NtO(MH='Sterile Alpha Motif', MS='A putative protein interaction module, approximately 70 amino acids long, that forms a small five-helix bundle with two large interfaces which may homo- and hetero-oligomerize, or bind non-sterile-alpha motif targets. The sterile alpha motif is present in a wide variety of eukaryotic proteins that function in diverse biological processes.'),
  'D000071696': NtO(MH='Proteogenomics', MS='The systematic study of annotated genomic information to global protein expression in order to determine the relationship between genomic sequences and both expressed proteins and predicted protein sequences.'),
  'D000071697': NtO(MH='Cellulite', MS='Skin lumpiness or skin surface dimpling often seen on the thighs, buttocks and abdomen. It is due to protrusion of SUBCUTANEOUS FAT into the DERMIS layer of skin.'),
  'D000071698': NtO(MH='Latent Autoimmune Diabetes in Adults', MS='Autoimmune diabetes in adults with slowly progressive PANCREATIC BETA CELL failure and the presence of circulating autoantibodies to PANCREATIC ISLETS cell antigens.'),
  'D000071699': NtO(MH='Bilateral Vestibulopathy', MS='Impairment of the vestibular function of both inner ears which can cause difficulties with balance, gait, VERTIGO, and visual blurring.'),
  'D000071700': NtO(MH='Cone-Rod Dystrophies', MS='Genetically heterogeneous and sometimes syndromic (e.g., BARDET BIEDL SYNDROME; and SPINOCEREBELLAR ATAXIA TYPE 7) retinopathies with initial RETINAL CONE involvement. They are characterized by decreased VISUAL ACUITY; COLOR VISION DEFECTS; progressive loss of peripheral vision and night blindness.'),
  'D000071701': NtO(MH='Regulatory Factor X Transcription Factors', MS='A family of eukaryotic transcription factors that recognize and bind to a highly-conserved cis-regulatory sequence (X-box) within the promoter region of MHC CLASS II GENES. They contain a conserved winged-helix DNA binding domain and function as homo or heterodimers.'),
  'D000071716': NtO(MH='Regulatory Factor X1', MS='A regulatory factor X transcription factor that is required for the expression of MHC CLASS II GENES. It also binds to inverted repeats of HEPATITIS B VIRUS DNA and is required for viral gene expression. RFX1 functions as a monomer or heterodimer with other RFX transcription factors.'),
  'D000071717': NtO(MH='X-Box Binding Protein 1', MS='A basic leucine zipper transcription factor that regulates expression of MHC CLASS II GENES through its binding to a conserved X-box DNA sequence in the promoter region. It regulates the expression of genes involved in the UNFOLDED PROTEIN RESPONSE.'),
  'D000071736': NtO(MH='Stromal Interaction Molecules', MS='Membrane-associated calcium-binding proteins that are characterized by N-terminal EF HAND MOTIFS and a STERILE ALPHA MOTIF. They function as sensors of ENDOPLASMIC RETICULUM calcium levels and translocate from the ER to the plasma membrane to activate CALCIUM CHANNELS in response to intracellular calcium depletion.'),
  'D000071737': NtO(MH='Stromal Interaction Molecule 1', MS='A stromal interaction molecule that functions in the regulation of calcium influx following depletion of intracellular calcium in the ENDOPLASMIC RETICULUM. It translocates to the plasma membrane upon calcium depletion where it activates the CALCIUM RELEASE ACTIVATED CALCIUM CHANNEL ORAI1.'),
  'D000071738': NtO(MH='Stromal Interaction Molecule 2', MS='A stromal interaction molecule that functions as a highly sensitive calcium sensor in the ENDOPLAMSIC RETICULUM and CYTOSOL. It can regulate CALCIUM RELEASE ACTIVATED CALCIUM CHANNELS in response to minor variations in intracellular calcium.'),
  'D000071739': NtO(MH='Calcium Release Activated Calcium Channels', MS='Specialized calcium channels that localize to the ENDOPLAMSIC RETICULUM and PLASMA MEMBRANE. They contain the pore subunit ORAI1 PROTEIN which is activated by STROMAL INTERACTION MOLECULES upon intracellular calcium depletion.'),
  'D000071740': NtO(MH='ORAI1 Protein', MS='The pore-forming subunit of calcium release activated calcium channels. It is activated by STROMAL INTERACTION MOLECULE 1 upon intracellular calcium depletion.'),
  'D000071741': NtO(MH='ORAI2 Protein', MS='A calcium release-activated calcium-like (CRAC-like) channel subunit which functions with STROMAL INTERACTION MOLECULE 1 to regulate cell calcium influx and increase (Ca2+)-selective current.'),
  'D000071756': NtO(MH='Soluble Guanylyl Cyclase', MS='A mammalian enzyme composed of a heterodimer of alpha and beta subunits. Each subunit consists of four domains; N-terminal HNOX domain, PAS-like domain, a coiled-coil domain, and a C-terminal catalytic domain. All four domains are homologous proteins with a similar conformation of functional domains. Soluble guanylate cyclase catalyzes the formation of cyclic GMP from GTP, and is a key enzyme of the nitric oxide signaling pathway involved in the regulation of a variety of biological and physiological processes in mammals.'),
  'D000071757': NtO(MH='BTB-POZ Domain', MS='A homodimerization protein interaction domain occurring at the N terminus of proteins that contain multiple copies of either CYS2-HIS2 ZINC FINGERS or KELCH REPEATS. It is characterized by a tightly intertwined dimer with an extensive hydrophobic interface. A surface-exposed groove lined with conserved amino acids is formed at the dimer interface, suggesting a peptide-binding site. Many BTB proteins are transcriptional regulators that are thought to regulate CHROMATIN structure.'),
  'D000071776': NtO(MH='Kelch Repeat', MS='An amino acid sequence of about 50 residues long that is composed of X n-long repeats which form a four-stranded anti-parallel BETA-SHEET as a structural component, or blade, of a beta-propeller.'),
  'D000071796': NtO(MH='SMARCB1 Protein', MS='A component of the SWI-SNF CHROMATIN REMODELING complex that functions  as a PROTEIN PHOSPHATASE 1 regulator and to stabilize CHROMATIN at PROMOTER REGIONS. It is important for regulating CELL PROLIFERATION and CELL DIFFERENTIATION. Mutations in the SMARCB1 gene are associated with malignant RHABDOID TUMORS.'),
  'D000071797': NtO(MH='Butyrophilins', MS='A family of mammalian membrane glycoproteins characterized by extracellular IMMUNOGLOBULIN DOMAINS. Some members also have an intracellular B30.2-SPRY DOMAIN or SPRY DOMAIN. The butyrophilin protein (BTN) is expressed by MAMMARY GLAND EPITHELIUM during LACTATION; whereas other members are widely expressed in other tissues, including skeletal muscle, intestine, ERYTHROID CELLS (ERMAP protein); and nerve tissue (MYELIN-OLIGODENDROCYTE GLYCOPROTEIN).'),
  'D000071799': NtO(MH='Zinc Finger E-box-Binding Homeobox 1', MS='A transcription factor characterized by N-terminal and C-terminal CYS2-HIS2 ZINC FINGERS separated by a homeobox. It represses the expression of E-CADHERIN to induce the EPITHELIAL-MESENCHYMAL TRANSITION. It also represses PROTO-ONCOGENE PROTEINS C-BCL-6; regulates the cell type-specific expression of SODIUM-POTASSIUM-EXCHANGING ATPASE; and promotes neuronal differentiation.'),
  'D000071816': NtO(MH='Glycodelin', MS='A lipocalin that is the most abundant protein synthesized and secreted by the ENDOMETRIUM from mid-LUTEAL PHASE of the MENSTRUAL CYCLE through early PREGNANCY.'),
  'D000071818': NtO(MH='Wnt-5a Protein', MS='A Wnt protein and ligand for FRIZZLED RECEPTORS that may function as an inhibitor or activator of the WNT SIGNALING PATHWAY. For example, it activates signaling in the presence of Frizzled-4 but is inhibitory when coupled with ROR2 TYROSINE KINASE. It is required for axis formation during EMBRYOGENESIS and inhibits the proliferation, migration, and invasiveness of cancer cells.'),
  'D000071819': NtO(MH='Virophages', MS='Circular, double-stranded DNA viruses that invade giant DNA viruses (GIANT VIRUSES) which infect eukaryotes.'),
  'D000071820': NtO(MH='Emergency Medical Dispatch', MS='The mobilization of EMERGENCY CARE to the locations and people that need them.'),
  'D000071821': NtO(MH='Dystonin', MS='A plakin characterized by repeat sequences homologous to SPECTRIN and PLECTIN and C-terminal EF HAND MOTIFS. It functions as an integrator of INTERMEDIATE FILAMENTS, ACTIN and MICROTUBULES in cytoskeleton networks. It is required for anchoring intermediate filaments to the actin cytoskeleton in neural and muscle cells as well as anchoring KERATIN-containing intermediate filaments to HEMIDESMOSOMES in EPITHELIAL CELLS.'),
  'D000071822': NtO(MH='Emergency Medical Dispatcher', MS='Professionals responsible for relaying calls for the deployment of EMERGENCY MEDICAL SERVICES.'),
  'D000071825': NtO(MH='Extremophiles', MS='Organisms specifically adapted to live in EXTREME ENVIRONMENTS.'),
  'D000071826': NtO(MH='Distracted Driving', MS='Behavior which detracts from the focus necessary to operate an automobile safely.'),
  'D000071836': NtO(MH='Professional Practice Gaps', MS='Difference between observed and ideal DELIVERY OF HEALTH CARE and healthcare outcomes that reflect the current state of knowledge.'),
  'D000071837': NtO(MH='Fibrillins', MS='A family of extracellular matrix glycoproteins that is structurally similar to  LATENT TGF-BETA BINDING PROTEINS, but contain additional TGF-beta binding domains, in addition to unique domains at their N and C-terminals. Fibrillins assemble into 10-12 nm MICROFIBRILS that function in a variety of cell interactions with the EXTRACELLULAR MATRIX and developmental processes such as ELASTIC TISSUE maintenance and assembly, and the targeting of growth factors to the extracellular matrix.'),
  'D000071838': NtO(MH='Fibrillin-1', MS='A fibrillin (FBN1) that functions as a structural support protein for MICROFIBRILS. It also regulates the maturation of OSTEOBLASTS by controlling the availability and concentration of TGF-BETA and BONE MORPHOGENETIC PROTEINS. Mutations in the FBN1 gene are associated with MARFAN SYNDROME.'),
  'D000071840': NtO(MH='Fibrillin-2', MS='A fibrillin (FBN2) that functions to regulate the assembly of ELASTIC FIBERS. Mutations in the FBN2 gene are associated with congenital contractural ARACHNODACTYLY.'),
  'D000071841': NtO(MH='PAX6 Transcription Factor', MS='A paired box transcription factor that has important functions in the development of the eye, nose, central nervous system and pancreas. Mutations in the PAX6 gene are associated with ocular disorders such as ANIRIDIA.'),
  'D000071856': NtO(MH='Tudor Domain', MS='A conserved, approximately 50 amino acid, protein sequence that adopts a characteristic strongly bent, five stranded anti-parallel beta-sheet barrel-like fold. The Tudor domain recognizes dimethylated ARGININE through its negatively-charged surface and occurs in many proteins that co-localize with RNA; RIBONUCLEOPROTEINS or SINGLE-STRANDED DNA complexes in the CELL NUCLEUS; MITOCHONDRIA; or KINETOCHORES.'),
  'D000071857': NtO(MH='Tumor Suppressor p53-Binding Protein 1', MS='A nuclear and cytoplasmic protein that associates with KINETOCHORES and contains a C-terminal TUDOR DOMAIN. It plays a critical role in the cellular response to DNA DAMAGE and localizes to DOUBLE-STRAND DNA BREAKS. It may also function in M PHASE CELL CYCLE CHECKPOINTS and as an enhancer of TUMOR SUPPRESSOR PROTEIN P53-mediated transcriptional activation.'),
  'D000071858': NtO(MH='Epithelial Cell Adhesion Molecule', MS='A cell adhesion molecule that is expressed on the membranes of nearly all EPITHELIAL CELLS, especially at the junctions between intestinal epithelial cells and intraepithelial LYMPHOCYTES. It also is expressed on the surface of ADENOCARCINOMA and epithelial tumor cells.  It may function in the MUCOSA through homophilic interactions to provide a barrier against infection. It also regulates the proliferation and differentiation of EMBRYONIC STEM CELLS.'),
  'D000071876': NtO(MH='Prostaglandin-E Synthases', MS='Oxidoreductases that catalyze the GLUTATHIONE-dependent oxidoreduction of PROSTAGLANDIN H2 to PROSTAGLANDIN E2.'),
  'D000071877': NtO(MH='Checkpoint Kinase 1', MS='A serine/threonine-specific protein kinase which is encoded by the CHEK1 gene in humans. Checkpoint kinase 1 (also known as Chk1) coordinates DNA damage response and cell cycle checkpoint response. Under these conditions, activation of Chk1 results in the initiation of cell cycle checkpoints, cell cycle arrest, DNA repair and cell death, to prevent damaged cells from progressing through the cell cycle.'),
  'D000071896': NtO(MH='Medically Unexplained Symptoms', MS='Persistent health symptoms which remain unexplained after a complete medical evaluation. A cluster of symptoms that consistently appear together but without a known cause are referred to as a MEDICALLY UNEXPLAINED SYNDROME (MUS).'),
  'D000071916': NtO(MH='AC133 Antigen', MS='A member of the prominin family, AC133 Antigen is a 5-transmembrane antigen occurring as several isoforms produced by alternative splicing which are processed into mature forms. In humans, it is expressed as a subset of CD34 (bright) human hematopoietic stem cells and CD34 positive leukemias. Functionally, it is associated with roles in cell differentiation, proliferation, and apoptosis. Specifically, it regulates the organization of apical plasma membrane in epithelial cells, disk morphogenesis during early retinal development, MAPK and Akt signaling pathways, and in cholesterol metabolism.'),
  'D000071936': NtO(MH='Nipple Discharge', MS='Fluid that seeps out of one or both nipples of the breast.'),
  'D000071937': NtO(MH='Cerebral Blood Volume', MS='Volume of circulating blood in a region of the brain. It is a functional measure of the brain perfusion status which relates changes in this to changes in CEREBROVASULAR CIRCULATION that are often seen in brain diseases.'),
  'D000071938': NtO(MH='Fasciotomy', MS="Surgical incision on the FASCIA. It is used to decompress compartment pressure (e.g. in COMPARTMENT SYNDROMES; circumferential burns and extremity injuries) or to release contractures (e.g. in DUPUYTREN'S CONTRACTURE)."),
  'D000071939': NtO(MH='Stroke Rehabilitation', MS='Restoration of functions to the maximum degree possible in a person or persons suffering from a stroke.'),
  'D000071940': NtO(MH='Nucleons', MS='Subatomic particles that are either protons or neutrons.'),
  'D000071941': NtO(MH='Barium Enema', MS='X-RAY examination of LOWER GASTROINTESTINAL TRACT. Imaging is done while a BARIUM COMPOUND (e.g., BARIUM SULFATE) fills the large intestine via the rectum as a CONTRAST MATERIAL.'),
  'D000071956': NtO(MH='Myocardial Contusions', MS='Bruise to the heart muscle due to blunt thoracic trauma.'),
  'D000071959': NtO(MH='Case Managers', MS='Professionals who are in charge of assessment, planning, facilitation, care coordination, evaluation, and advocacy for options and services to meet a patient\xe2\x80\x99s and family\xe2\x80\x99s comprehensive health needs.'),
  'D000071960': NtO(MH='Breast Carcinoma In Situ', MS='A condition in which abnormal cells have not spread outside the duct, lobule, or nipple to other tissues of the breast. There are 3 types of breast carcinoma in situ: DUCTAL CARCINOMA IN SITU; LOBULAR CARCINOMA IN SITU; and PAGET DISEASE OF THE NIPPLE.'),
  'D000071976': NtO(MH='Gracilis Muscle', MS='A slender and most superficial muscle in the inner THIGH which originates at the ramus of the PUBIC BONE near the PUBIC SYMPHYSIS and inserts at the proximal medial TIBIA. Its function is to abduct thigh, flex knee, and rotate leg medially. It is a common  source of a MYOCUTANEOUS FLAP.'),
  'D000071997': NtO(MH='Blood Culture', MS='Test to determine the presence of blood infection (e.g. SEPSIS; BACTEREMIA).'),
  'D000071999': NtO(MH='S100 Calcium-Binding Protein A4', MS='An S100 protein characterized by four helix bundles that form N- and C-terminal EF HAND MOTIFS. It functions as a homodimer and interacts with both intracellular and extracellular signaling proteins. Aberrant S100A4 activity is associated with NEOPLASM METASTASIS; FIBROSIS; and RHEUMATOID ARTHRITIS.'),
  'D000072': NtO(MH='Acedapsone', MS='Acetylated sulfone that is slowly metabolized to give long-term, low blood levels of DAPSONE. It has antimicrobial and antimalarial action, but is mainly used as a depot leprostatic agent.'),
  'D000072000': NtO(MH='NF-KappaB Inhibitor alpha', MS='An I-kappa B protein that inhibits the activity of dimeric NF-KAPPA B P50-REL complexes, sequesters transcription factor NF-kappaB as an inactive complex in the cytoplasm; and prevents NF-kappaB nuclear translocation and DNA binding.'),
  'D000072001': NtO(MH='Diet, Healthy', MS='Dietary patterns which have been found to be important in reducing disease risk.'),
  'D000072002': NtO(MH='Prion Proteins', MS='Membrane glycosylphosphatidylinositol-anchored glycoproteins that may aggregate into rod-like structures. The prion protein (PRNP) gene is characterized by five TANDEM REPEAT SEQUENCES that encode a highly unstable protein region of five octapeptide repeats. Mutations in the repeat region and elsewhere in this gene are associated with CREUTZFELDT-JAKOB DISEASE; FATAL FAMILIAL INSOMNIA; GERSTMANN-STRAUSSLER DISEASE; Huntington disease-like 1, and KURU.'),
  'D000072017': NtO(MH='Deubiquitinating Enzymes', MS='Enzymes that remove UBIQUITIN from a protein substrate, including POLYUBIQUITIN, or from other molecules.'),
  'D000072018': NtO(MH='Audiologists', MS='Professionals skilled at diagnostic testing of hearing, HEARING IMPAIRMENT, and CORRECTION OF HEARING IMPAIRMENT by non-medical or non-surgical means.'),
  'D000072019': NtO(MH='Kelch-Like ECH-Associated Protein 1', MS='An adaptor protein characterized by an N-terminal BTB-POZ DOMAIN and six KELCH REPEATS that functions as a substrate for the E3 UBIQUITIN LIGASE complex. It negatively-regulates NF-E2-RELATED FACTOR 2 by targeting it for ubiquitination and degradation by the PROTEASOME. It also represses genes regulated by ANTIOXIDANT RESPONSE ELEMENTS.'),
  'D000072020': NtO(MH='Synthetic Lethal Mutations', MS='Mutations in genes which lead to cell or organism death when occurring in combination with mutations in one or more other genes.'),
  'D000072036': NtO(MH='Prophylactic Mastectomy', MS='Surgical removal of one or both breasts to prevent or reduce the risk of developing breast cancer in persons who may be predisposed.'),
  'D000072038': NtO(MH='Cardiac Rehabilitation', MS='Restoration of functions to the maximum degree possible in a person or persons suffering from a CARDIOVASCULAR DISEASE. It also includes cardiac conditioning and SECONDARY PREVENTION in patients with elevated cardiovascular risk profile.'),
  'D000072039': NtO(MH='Fracture Dislocation', MS='Fracture of a bone near an articulation with concomitant dislocation of that joint.'),
  'D000072040': NtO(MH='Apolipoprotein A-V', MS='A minor apolipoprotein that associates with HIGH-DENSITY LIPOPROTEINS (HDL), VERY-LOW-DENSITY LIPOPROTEINS (VLDL), and CHYLOMICRONS. It regulates levels of plasma TRIGLYCERIDES by activating APOLIPOPROTEIN C-II LIPOPROTEIN LIPASE and inhibiting hepatic VLDL triglyceride hydrolysis.'),
  'D000072041': NtO(MH='PAX3 Transcription Factor', MS='A paired box transcription factor that functions in CELL PROLIFERATION; CELL MIGRATION; and APOPTOSIS. It also is involved in MYOGENESIS and neural development. Mutations in the PAX3 gene are associated with WAARDENBURG SYNDROME TYPE 1.'),
  'D000072042': NtO(MH='Salter-Harris Fractures', MS='Fractures involving a GROWTH PLATE.'),
  'D000072056': NtO(MH='Transcription Factor HES-1', MS='A basic-helix-loop-helix transcription factor that functions as a transcriptional repressor for genes transcribed by bHLH proteins. For example, it may negatively regulate MYOGENESIS by inhibiting MyoD1 and ASH1 proteins. It is also required for the stability of FANCONI ANEMIA COMPLEMENTATION GROUP PROTEINS and their localization to the cell nucleus in response to DNA DAMAGE.'),
  'D000072077': NtO(MH='Anesthetists', MS='Persons trained and certified to administer ANESTHETICS.'),
  'D000072078': NtO(MH='Positron Emission Tomography Computed Tomography', MS='An imaging technique that combines a POSITRON-EMISSION TOMOGRAPHY (PET) scanner and a CT X RAY scanner. This establishes a precise anatomic localization in the same session.'),
  'D000072079': NtO(MH='Patched Receptors', MS='A family of 12-pass transmembrane proteins originally identified in Drosophila that are receptors for HEDGEHOG PROTEINS. They have important roles in regulating CELL PROLIFERATION; CELL DIFFERENTIAION; and BODY PATTERNING and may also function as TUMOR SUPPRESSOR PROTEINS.'),
  'D000072080': NtO(MH='Anesthesiologists', MS='Physicians specializing in ANESTHESIOLOGY.'),
  'D000072081': NtO(MH='Patched-1 Receptor', MS='A patched receptor for several HEDGEHOG PROTEINS that associates with the SMOOTHENED RECEPTOR to modulate hedgehog signaling. It is also a TUMOR SUPPRESSOR PROTEIN; mutations in the patched-1 gene are associated with BASAL CELL NEVUS SYNDROME; SQUAMOUS CELL CARCNIOMA of the ESOPHAGUS; trichoepitheliomas, and CARCINOMA, TRANSITIONAL CELL of the URINARY BLADDER.'),
  'D000072082': NtO(MH='Patched-2 Receptor', MS='A patched receptor that may function redundantly with the PATCHED-1 RECEPTOR to modulate hedgehog signaling. It may also play a role in epidermal development and as a TUMOR SUPPRESSOR PROTEIN. Mutations in the patched-2 gene are associated with BASAL CELL NEVUS SYNDROME; CARCINOMA, BASAL CELL; and MEDULLOBLASTOMA.'),
  'D000072085': NtO(MH='Dermatologists', MS='Physicians who specialize in treating disorders of the skin.'),
  'D000072086': NtO(MH='Smoothened Receptor', MS='A frizzled-like, G-protein-coupled receptor that associates with PATCHED RECEPTORS to transduce signals from HEDGEHOG PROTEINS and initiate hedgehog signaling to ZINC FINGER PROTEIN GLI1. It may normally inhibit signaling in the absence of SONIC HEDGEHOG PROTEIN binding to PATCHED RECEPTOR-1.'),
  'D000072087': NtO(MH='Occupational Therapists', MS='Professionals trained to help individuals develop or regain skills needed to achieve independence in their lives.'),
  'D000072096': NtO(MH='Cardiologists', MS='Qualified medical professionals who specialize in preventing and treating disorders of the heart and CARDIOVASCULAR SYSTEM.'),
  'D000072097': NtO(MH='Endocrinologists', MS='Physicians who specialize in treating ENDOCRINE SYSTEM DISEASES.'),
  'D000072098': NtO(MH='Single Photon Emission Computed Tomography Computed Tomography', MS='An imaging technique using a device which combines TOMOGRAPHY, EMISSION-COMPUTED, SINGLE-PHOTON and TOMOGRAPHY, X-RAY COMPUTED in the same session.'),
  'D000072099': NtO(MH='Serrate-Jagged Proteins', MS='Cell surface proteins that consist of multiple extracellular EPIDERMAL GROWTH FACTOR - like repeat sequences (EGF repeats), including calcium-binding EGF repeats. They function as transmembrane ligands for NOTCH RECEPTORS to control CELL DIFFERENTIATION during development.'),
  'D000072100': NtO(MH='Jagged-1 Protein', MS='A serrate-jagged protein that functions as a ligand for NOTCH RECEPTORS. It may regulate CELL DIFFERENTIATION in HEMATOPOIESIS and PHYSIOLOGIC ANGIOGENESIS. Mutations in the Jagged-1 gene are associated with ALAGILLE SYNDROME 1.'),
  'D000072101': NtO(MH='Jagged-2 Protein', MS='A serrate-jagged protein that functions to modulate signal transduction from NOTCH RECEPTORS in CELL DIFFERENTIATION. It may also regulate the expression of CYTOKINES.'),
  'D000072102': NtO(MH='Gastroenterologists', MS='Physicians who specialize in treating diseases of the DIGESTIVE SYSTEM.'),
  'D000072103': NtO(MH='Oncologists', MS='Physicians specializing in MEDICAL ONCOLOGY or its sub-specialties of RADIATION ONCOLOGY or SURGICAL ONCOLOGY.'),
  'D000072104': NtO(MH='Nephrologists', MS='Qualified medical professionals who specialize in treating KIDNEY DISEASES.'),
  'D000072105': NtO(MH='Superoxide Dismutase-1', MS='A superoxide dismutase (SOD1) that requires copper and zinc ions for its activity to destroy SUPEROXIDE FREE RADICALS within the CYTOPLASM. Mutations in the SOD1 gene are associated with AMYOTROPHIC LATERAL SCLEROSIS-1.'),
  'D000072106': NtO(MH='Pulmonologists', MS='Physicians who specialize in treating disorders of the RESPIRATORY SYSTEM, especially diagnosing and treating diseases and defects of the lungs and bronchial tree.'),
  'D000072117': NtO(MH='Counselors', MS='Professionals trained in providing information, guidance, and recommendations to individual clients or families to support their decision making and development of coping skills.'),
  'D000072137': NtO(MH='Vaping', MS='SMOKING from ELECTRONIC NICOTINE DELIVERY SYSTEMS such as E-CIGARETTES.'),
  'D000072138': NtO(MH='Mosquito Vectors', MS='Mosquitoes (members of the family CULICIDAE) that transmit pathogens or their intermediate forms from one host to another.'),
  'D000072139': NtO(MH='Giant Viruses', MS='DNA viruses that have genomes up to several megabases in length and infect primarily single-celled EUKARYOTES.'),
  'D000072140': NtO(MH='Rheumatologists', MS='Physicians who specialize in treating RHEUMATIC DISEASES.'),
  'D000072141': NtO(MH='Neurologists', MS='Qualified medical professionals who specialize in treating NERVOUS SYSTEM DISEASES.'),
  'D000072142': NtO(MH='Pathologists', MS='Physicians who assess changes in cellular or tissue structure and function to diagnose disease processes.'),
  'D000072143': NtO(MH='Pediatricians', MS='Qualified medical professionals specializing in maintaining health and providing medical care to children from birth through adolescence.'),
  'D000072156': NtO(MH='Neonatologists', MS='Physicians who specialize in providing medical care to newborn infants.'),
  'D000072157': NtO(MH='Physiatrists', MS='Physicians specializing in treating physical disorders and injuries affecting the brain, spinal cord, nerves, bones, joints, ligaments, muscles, and tendons.'),
  'D000072158': NtO(MH='Epidemiologists', MS='Qualified medical professionals who study the causes, incidence, and characteristic behavior of disease outbreaks or other health-related conditions and determine the interrelationships of hosts, agents, and environment related to the distribution and control of diseases.'),
  'D000072159': NtO(MH='Dynactin Complex', MS='A multi-subunit protein of EUKARYOTIC CELLS. It functions in bidirectional intracellular transport of ORGANELLES and CYTOPLASMIC VESICLES by linking them to DYNEIN and KINESIN.'),
  'D000072160': NtO(MH='Tumor Protein p73', MS='A homolog of p53 TUMOR SUPPRESSOR PROTEIN that encodes full-length trans-activating and N-terminally-truncated (DeltaN) isoforms. Detection of splice variants and isoforms in the nervous system (human TELENCEPHALON, CHOROID PLEXUS; CEREBROSPINAL FLUID), embryonic tissue, human BREAST CANCER; OVARIAN CANCER, suggest roles in cellular differentiation.'),
  'D000072161': NtO(MH='Orthopedic Surgeons', MS='Physicians specializing in medical, surgical, and physical methods used to treat and correct deformities, diseases, and injuries to the skeletal system, its articulations, and associated structures.'),
  'D000072162': NtO(MH='Optometrists', MS='Qualified professionals trained in primary eye and vision care, including measurement of visual abilities, diagnosing disorders of the visual system and provision of treatment such as prescriptions for correction of visual defects with lenses or glasses and vision therapy.'),
  'D000072163': NtO(MH='Ophthalmologists', MS='Qualified medical professionals specializing in medical and surgical treatment of defects and diseases of the eye.'),
  'D000072176': NtO(MH='Superconductivity', MS='The ability of an element or metallic alloy to allow the passage of ELECTRONS without ELECTRICAL RESISTANCE and expel MAGNETIC FIELDS below a certain threshold temperature called superconducting transition temperature.'),
  'D000072177': NtO(MH='Radiologists', MS='Physicians specializing in the use of x-ray and other forms of radiant energy to diagnosis and treatment of disease.'),
  'D000072178': NtO(MH='Urologists', MS='Physicians specializing in the diagnosis, and treatment of diseases of the urinary tract in both sexes, and the genital tract in the male.'),
  'D000072179': NtO(MH='Interleukin-1 Receptor-Like 1 Protein', MS='A receptor for INTERLEUKIN-33 that is related structurally to the interleukin-1 receptor. It  contains three extracellular IMMUNOGLOBULIN-LIKE DOMAIN regions and associates with INTERLEUKIN-1 RECEPTOR ACCESSORY PROTEIN upon binding IL-33 to initiate signaling. It may function in the response of HELPER T CELLS to INFLAMMATION.'),
  'D000072180': NtO(MH='Phosphoinositide Phosphatases', MS='Phosphatases that catalyze the hydrolysis of phosphate groups on PHOSPHATIDYLINOSITOLS.'),
  'D000072181': NtO(MH='Inositol Polyphosphate 5-Phosphatases', MS="Phosphoinositide phosphatases that catalyze the removal of the 5' phosphate from INOSITOL 1,4,5-TRISPHOSPHATE  or myo-inositol 1,3,4,5-tetrakisphosphate, resulting in inositol 1,4-bisphosphate and phosphate. They have important functions in the metabolism of INOSITOL PHOSPHATES and inositol 1,4,5-trisphosphate signaling pathways such as CALCIUM SIGNALING."),
  'D000072182': NtO(MH='Non-Medical Public and Private Facilities', MS='Spaces and needed equipment provided for a specific, non-medical  function or service used by the public or specific group of persons.'),
  'D000072183': NtO(MH='Phosphatidylinositol-3,4,5-Trisphosphate 5-Phosphatases', MS='Phosphoinositide phosphatases that catalyze the dephosphorylation (hydrolysis) of  phosphatidylinositol-3,4,5-trisphosphate (PtdIns(3,4,5)P(3)) to produce PtdIns(3,4)P(2), which negatively regulates the PI3K ( 3-PHOSPHOINOSITIDE-DEPENDENT PROTEIN KINASES) pathways. They contain an SH2 DOMAIN and STERILE ALPHA MOTIF and have important functions in regulating the immune response and other cellular processes in vertebrates.'),
  'D000072184': NtO(MH='Nurse Specialists', MS='Nursing professionals whose practice is limited to A particular area or discipline of medicine.'),
  'D000072196': NtO(MH='Fertilins', MS='Sperm surface proteins involved in sperm-egg fusion. They consist of two subunits, fertilin alpha (ADAM1a) and beta (ADAM2), both of which belong to the metalloprotease-disintegrin protein family. The beta subunit does not have catalytic activity.'),
  'D000072197': NtO(MH='ADAM10 Protein', MS='A disintegrin and metalloproteinase domain-containing protein. It cleaves the membrane-bound precursor of TUMOR NECROSIS FACTOR-ALPHA between ALANINE 76 and VALINE 77 to its functional form, as well as several other CELL SURFACE PROTEINS to their soluble forms, including AMYLOID BETA-PROTEIN PRECURSOR and PRION PROTEIN.'),
  'D000072198': NtO(MH='ADAM17 Protein', MS='A disintegrin and metalloproteinase domain-containing protein that cleaves the membrane-bound precursor of TUMOR NECROSIS FACTOR-ALPHA to its mature form. It cleaves several other CELL SURFACE PROTEINS, including INTERLEUKIN-1 RECEPTOR TYPE II; TRANSFORMING GROWTH FACTOR ALPHA; L-SELECTIN; MUCIN-1; and AMYLOID BETA-PROTEIN PRECURSOR. It can also function as an activator of the Notch signaling pathway by mediating the cleavage of NOTCH RECEPTORS.'),
  'D000072199': NtO(MH='ADAM12 Protein', MS='A disintegrin and metalloproteinase domain-containing protein that is expressed as two alternatively-spliced forms: a long transmembrane form (ADAM12-L) and a short soluble form  (ADAM12-S). It modulates the cleavage of INSULIN-LIKE GROWTH FACTOR BINDING PROTEINS and may also regulate CELL FUSION during MYOGENESIS.'),
  'D000072200': NtO(MH='Ku Autoantigen', MS='An ATP-dependent DNA HELICASE that preferentially binds SINGLE-STRANDED DNA. It is a heterodimer consisting of an 80 kDa subunit (XRCC5) and 70 kDa subunit (XRCC6) that functions with DNA LIGASE IV in the repair of DOUBLE-STRANDED DNA BREAKS and V(D)J RECOMBINATION.'),
  'D000072216': NtO(MH='Zona Pellucida Glycoproteins', MS='Membrane glycoproteins that constitute the ZONA PELLUCIDA in mammals and function in the recognition and binding of SPERMATOZOA.'),
  'D000072218': NtO(MH='Endodontists', MS='Dentists specializing in the treatment of injuries and diseases of the DENTAL PULP.'),
  'D000072219': NtO(MH='Geriatricians', MS='Physicians specializing in physiological and pathological aspects of aging and the aged, including the clinical problems of senescence and senility.'),
  'D000072220': NtO(MH='Otolaryngologists', MS='Physicians specializing in the treatment of disorders of the ear, nose, and throat.'),
  'D000072221': NtO(MH='Nurses, Neonatal', MS='Qualified nursing professionals specializing in care of newborn infants.'),
  'D000072222': NtO(MH='Nurses, Pediatric', MS='Qualified nursing professionals specializing in the care of children from birth to adolescence.'),
  'D000072223': NtO(MH='Allergists', MS='Physicians specializing in treating individuals with hypersensitivity to ALLERGENS.'),
  'D000072224': NtO(MH='Bcl-2-Like Protein 11', MS='A BCL-2-like protein that has a C-terminal BCL-2 homology (BH3) domain and forms heterodimers with other BCL-2 FAMILY PROTEINS. It is a strong inducer of APOPTOSIS and ANOIKIS; several isoforms are expressed (BimEL, Bim L, Bim-alpha, Bim-s; and Bim-gamma) that have different potencies for inducing apoptosis.'),
  'D000072226': NtO(MH='Computed Tomography Angiography', MS='A non-invasive method that uses a CT scanner for capturing images of blood vessels and tissues. A CONTRAST MATERIAL is injected, which helps produce detailed images that aid in diagnosing VASCULAR DISEASES.'),
  'D000072227': NtO(MH='Shoulder Prosthesis', MS='Replacement for a SHOULDER JOINT.'),
  'D000072228': NtO(MH='Arthroplasty, Replacement, Shoulder', MS='Replacement of the SHOULDER JOINT.'),
  'D000072229': NtO(MH='Posterior Cruciate Ligament Reconstruction', MS='Rebuilding of the POSTERIOR CRUCIATE LIGAMENT to restore functional stability of the knee.'),
  'D000072230': NtO(MH='Sustained Virologic Response', MS='The continuous, long-term suppression of VIRAL LOAD, generally to undetectable levels, as the result of treatment with ANTIVIRAL AGENTS.'),
  'D000072231': NtO(MH='In Vivo Dosimetry', MS='A procedure to measure the amount of radiation absorbed by the body during RADIOTHERAPY by DOSIMETERS in the patient\xe2\x80\x99s skin or natural cavities.'),
  'D000072232': NtO(MH='Radiation Dosimeters', MS='Devices that measure exposure to IONIZING RADIATION.'),
  'D000072233': NtO(MH='Homer Scaffolding Proteins', MS='Homer proteins belong to a family of adaptor and scaffold proteins which include Homer1, Homer2 and Homer3. Homer1 and Homer2 play a role in the regulation of calcium homeostasis, whereas Homer3 functions in stimulating changes in actin dynamics in neurons and T-cells. Homer proteins are best known as scaffold proteins at the post-synaptic density where they facilitate synaptic signaling. They function as a molecular switch in metabotropic glutamate receptor (MGluR) signaling, and are associated with human Fragile X syndrome.'),
  'D000072234': NtO(MH='Donor Conception', MS='Assisted reproductive techniques where eggs, sperm, both eggs and sperm (double donation), or embryos from donors are used.'),
  'D000072235': NtO(MH='Mating Factor', MS='A protein also known as pheromone mating factor that occurs on the surfaces of organisms such as yeast and fungi.'),
  'D000072236': NtO(MH='Methyl-Accepting Chemotaxis Proteins', MS='Transmembrane sensor receptor proteins that are central components of the chemotactic systems of a number of motile bacterial species which include ESCHERICHIA COLI and SALMONELLA TYPHIMURIUM. Methyl-accepting chemotaxis proteins derive their name from a sensory adaptation process which involves methylation at several glutamyl residues in their cytoplasmic domain. Methyl-accepting chemotaxis proteins trigger chemotactic responses across spatial chemical gradients, causing organisms to move either toward favorable stimuli or away from toxic ones.'),
  'D000072237': NtO(MH='ERG1 Potassium Channel', MS='One of three members of the ether-a-go-go (EAG) POTASSIUM CHANNELS gene family comprising ether-a-go-go (eag), eag-like (elk) and eag-related (erg) subfamilies. Ether-a-go-go-related gene 1 (ERG1) also known as KCNH2, encodes the pore-forming subunit of a rapidly activating-delayed rectifier potassium channel that plays an essential role in the final repolarization of ventricular action potential. Loss-of-function mutations in human hERG1 is associated with life-threatening ARRHYTHMIA.'),
  'D000072257': NtO(MH='Oxygen Radical Absorbance Capacity', MS='A measure of the ability of a substance, such as a food, to quench oxygen free radicals in vitro.'),
  'D000072258': NtO(MH='Tumor Hypoxia', MS='Hypoxic conditions in tumor cells due to the tumor outgrowing its blood supply. It is associated with increased METASTASIS and resistance to RADIOTHERAPY and DRUG THERAPY.'),
  'D000072259': NtO(MH='Connexin 26', MS='A gap junction protein encoded by the Gap Junction Beta 2 or GJB2 gene. In the cochlea and epidermis, its hexamers form channels between cells that open to allow cell-to-cell diffusion of small molecules as well as recycling of potassium. Mutations in Connexin 26 are associated with congenital SENSORINEURAL HEARING LOSS.'),
  'D000072260': NtO(MH='RNA Splicing Factors', MS='RNA-binding proteins that facilitate or inhibit RNA SPLICING.'),
  'D000072261': NtO(MH='Dishevelled Proteins', MS='A family of proteins that are key components of the WNT SIGNALING PATHWAY, where they function downstream of FRIZZLED RECEPTORS. They contain an N-terminal dishevelled-AXIN PROTEIN (DIX) domain, which mediates oligomerization; a central PDZ DOMAIN which binds to the frizzled receptor; and a C-terminal DEP domain which facilitates binding to the CELL MEMBRANE. Dishevelled proteins have important functions in CELL DIFFERENTIATION and establishing CELL POLARITY.'),
  'D000072263': NtO(MH='Private Facilities', MS='Places designed, built, or installed to provide for a specific, non-medical function or service used by a specific, restricted group of persons.'),
  'D000072264': NtO(MH='Sports and Recreational Facilities', MS='Places designed, built, or installed for LEISURE ACTIVITIES outside of the home.'),
  'D000072277': NtO(MH='Maximal Respiratory Pressures', MS="A respiratory function test that includes the maximal inspiratory pressure and maximal expiratory pressure. It is determined by SPIROMETRY that measures the patient's RESIDUAL VOLUME and TOTAL LUNG CAPACITY and assesses the strength of RESPIRATORY MUSCLES."),
  'D000072278': NtO(MH='Forkhead Box Protein M1', MS='A forkhead box transcription factor that is expressed primarily in adult organs which contain proliferating cells such as the thymus, testis, ovary, and small intestine. It controls the expression of CELL CYCLE genes essential for DNA REPLICATION and MITOSIS, and also functions in DNA REPAIR.'),
  'D000072280': NtO(MH='Bacteria, Thermoduric', MS='Bacteria resistant to high temperatures, as in PASTEURIZATION.'),
  'D000072281': NtO(MH='Lymphadenopathy', MS='Disease of LYMPH NODES which are abnormal in size, number or consistency.'),
  'D000072282': NtO(MH='Extraintestinal Pathogenic Escherichia coli', MS='Strains of Escherichia coli that possess virulence traits which allow them to invade, colonize, and induce disease in tissues outside of the GASTROINTESTINAL TRACT. They are a cause of URINARY TRACT INFECTIONS (UROPATHOGENIC ESCHERICHIA COLI); neonatal MENINGITIS; SEPSIS; PNEUMONIA; and SURGICAL WOUND INFECTION.'),
  'D000072283': NtO(MH='A549 Cells', MS='An immortalized cell line derived from human ADENOCARCINOMA, ALVEOLAR basal epithelial cells isolated from the lungs of a male patient in 1972. The cell line is positive for KERATIN, can synthesize LECITHIN, and contains high levels of POLYUNSATURATED FATTY ACIDS in its PLASMA MEMBRANE. It is used as a model for PULMONARY ALVEOLI function and virus infections, as a TRANSFECTION host, and for PRECLINICAL DRUG EVALUATION.'),
  'D000072296': NtO(MH='Bathroom Equipment', MS='Receptacles used for collection of human excrement.'),
  'D000072316': NtO(MH='Dioxins and Dioxin-like Compounds', MS='A group of toxic chemical compounds that share chemical structures and biological characteristics that are related to the potent carcinogen 2,3,7,8-tetrachlorodibenzo-p-dioxin.'),
  'D000072317': NtO(MH='Polychlorinated Dibenzodioxins', MS='Dibenzodioxin derivatives that contain multiple chloride atoms bound to the benzene ring structures.'),
  'D000072318': NtO(MH='Dibenzofurans', MS='Compounds that include the structure of dibenzofuran.'),
  'D000072336': NtO(MH='Mucosal-Associated Invariant T Cells', MS='A subset of T-lymphocytes that are present in large numbers at MUCOUS MEMBRANES and respond to INFECTIONS. They express a conserved invariant T-CELL RECEPTOR ALPHA-CHAIN that enables them to respond to infections by sensing RIBOFLAVIN metabolites of pathogens.'),
  'D000072338': NtO(MH='Dibenzofurans, Polychlorinated', MS='Dibenzofurans that contain chloride atoms bound to the aromatic rings of the structure.'),
  'D000072339': NtO(MH='Sexual and Gender Minorities', MS='Individuals including lesbian, gay, bisexual, transgender, queer, intersex, gender non-conforming people, and other populations whose sexual orientation or GENDER IDENTITY and reproductive development is considered outside cultural, societal, or physiological norms.'),
  'D000072340': NtO(MH='NIMA-Interacting Peptidylprolyl Isomerase', MS='A highly-conserved peptidyl-prolyl cis/trans isomerase (PPIase) that binds to and isomerizes specific phosphorylated SERINE- or THREONINE-PROLINE (pSer/Thr-Pro) motifs and causes conformational changes in certain proteins associated with the CELL CYCLE. It displays a preference for an acidic residue N-terminal to the isomerized proline bond and regulates MITOSIS, possibly by attenuating the mitosis-promoting activity of NIMA-RELATED KINASE 1.'),
  'D000072356': NtO(MH='Parenchymal Tissue', MS='The tissue that constitutes the essential or functional part of an organ (e.g., parenchyma of lung, parenchyma of liver, or parenchyma of kidney).'),
  'D000072357': NtO(MH='Applied Behavior Analysis', MS='Behavioral science applied with the aim of improving socially important issues such as behavior problems and learning. For individuals diagnosed with intellectual and developmental disabilities including AUTISM, techniques can be categorized as comprehensive or focused.'),
  'D000072358': NtO(MH='Work-Life Balance', MS='The optimal arrangement of an individual\xe2\x80\x99s on-the-job and private time to facilitate health and personal satisfaction without negatively impacting productivity and professional success.'),
  'D000072359': NtO(MH='Trichodesmium', MS='A nitrogen-fixing genus of filamentous cyanobacteria that occurs in tropical and subtropical oceans.'),
  'D000072376': NtO(MH='Oxysterols', MS='Oxygenated derivatives of cholesterol or its sterol precursors. They are generated from sterol metabolism and the interaction of cholesterol with REACTIVE OXYGEN SPECIES.'),
  'D000072377': NtO(MH='Syk Kinase', MS='An SH2 domain-containing non-receptor tyrosine kinase that regulates signal transduction downstream of a variety of receptors including B-CELL ANTIGEN RECEPTORS. It functions in both INNATE IMMUNITY and ADAPTIVE IMMUNITY and also mediates signaling in CELL ADHESION; OSTEOGENESIS; PLATELET ACTIVATION; and vascular development.'),
  'D000072378': NtO(MH='Radiation Oncologists', MS='Physicians specializing in the treatment of cancer by RADIOTHERAPY.'),
  'D000072379': NtO(MH='NIMA-Related Kinases', MS='A highly-conserved family of protein serine-threonine kinases that regulate the CELL CYCLE; MITOSIS; and the response to DNA DAMAGE. They are also involved in the assembly and function of microtubule-based structures such as CILIA and CENTRIOLES.'),
  'D000072380': NtO(MH='NIMA-Related Kinase 1', MS='A NIMA-related kinase that functions in CELL CYCLE regulation, the control of CILIA assembly, and CENTROSOME duplication. It is activated at G2 PHASE CELL CYCLE CHECKPOINTS in response to DNA DAMAGE.'),
  'D000072396': NtO(MH='Endothelin-Converting Enzymes', MS='Metalloendopeptidases which convert BIG ENDOTHELIN to ENDOTHELIN-1.'),
  'D000072416': NtO(MH='Protein Structural Elements', MS='Distinguishing three-dimensional structures characteristically formed by homologous protein sequences.'),
  'D000072417': NtO(MH='Protein Domains', MS='Discrete protein structural units that may fold independently of the rest of the protein and have their own functions.'),
  'D000072436': NtO(MH='Transportation Facilities', MS='Places such as AIRPORTS, bus stations, and train stations that are used for managing arriving and departing transport vehicles, and included facilities for handling passengers.'),
  'D000072437': NtO(MH='Calendars as Topic', MS='Works about documents or charts that show days, weeks, and months of a year.'),
  'D000072438': NtO(MH='Calendar', MS='Document or chart that shows days, weeks, and months of a year.'),
  'D000072439': NtO(MH='Postcards as Topic', MS='Works about cards on which a message may be written or printed for mailing without an envelope.'),
  'D000072440': NtO(MH='Public Health Systems Research', MS='A field of study that examines the organization, financing, and delivery of public health services within communities, and the impact of these services on public health.'),
  'D000072441': NtO(MH='DNA, Ancient', MS='DNA isolated from fossils or other ancient specimens.'),
  'D000072458': NtO(MH='Orientation, Spatial', MS='Change in position or alignment in response to an external stimulus.'),
  'D000072461': NtO(MH='Cytochrome P450 Family 1', MS='A cytochrome P450 enzyme family whose members function primarily in the metabolism of XENOBIOTICS, including drugs and POLYCYCLIC AROMATIC HYDROCARBONS.'),
  'D000072466': NtO(MH='Cognitive Remediation', MS='Behavioral treatment that uses drill and practice, compensatory and adaptive strategies to facilitate improvement in targeted learning areas.'),
  'D000072467': NtO(MH='Cytochrome P450 Family 2', MS='A cytochrome P450 enzyme family that includes members which function in the metabolism of STEROIDS; COUMARINS; and NICOTINE.'),
  'D000072469': NtO(MH='Cytochrome P450 Family 3', MS='A cytochrome P450 enzyme family that includes members with critical functions in the metabolism of drugs and SEX HORMONES.'),
  'D000072470': NtO(MH='Cytochrome P450 Family 4', MS='A cytochrome P450 enzyme family that includes members which function in the metabolism of FATTY ACIDS, especially ARACHIDONIC ACIDS and their derivatives.'),
  'D000072471': NtO(MH='Heterocyclic Compounds, Fused-Ring', MS='Multiple ring heterocyclic compounds containing two or more rings that share two atoms and one bond in common.'),
  'D000072472': NtO(MH='Cytochrome P450 Family 6', MS='A cytochrome P450 enzyme family that occurs in insects. Its members function in the metabolism of XENOBIOTICS.'),
  'D000072473': NtO(MH='Fused-Ring Compounds', MS='Polycyclic compounds with adjacent rings that share the same two adjacent atoms.'),
  'D000072474': NtO(MH='Cytochrome P450 Family 7', MS='A cytochrome P450 enzyme family whose members function as steroid 7-alpha hydroxylases.'),
  'D000072475': NtO(MH='Cytochrome P450 Family 8', MS='A cytochrome P450 enzyme family whose members include prostacyclin synthase and STEROID 12-ALPHA-HYDROXYLASE, which function in the biosynthesis of BILE ACIDS.'),
  'D000072476': NtO(MH='Cytochrome P450 Family 11', MS='A cytochrome P450 enzyme family whose members localize to the INNER MITOCHONDRIAL MEMBRANE where they function in the biosynthesis of STEROIDS.'),
  'D000072477': NtO(MH='Cytochrome P450 Family 12', MS='A cytochrome P450 enzyme family that occurs in insects and is expressed in MITOCHONDRIA.'),
  'D000072478': NtO(MH='Cytochrome P450 Family 17', MS='A cytochrome P450 enzyme family that functions in the biosynthesis of STEROIDS and includes STEROID 17-ALPHA-HYDROXYLASE.'),
  'D000072480': NtO(MH='Farms', MS='Areas of land set aside to grow crops or raise LIVESTOCK.'),
  'D000072481': NtO(MH='DNA Ligase ATP', MS='ATP-dependent cellular enzyme which catalyzes DNA replication, repair and recombination through formation of internucleotide ester bonds between phosphate and deoxyribose moieties. Vertebrate cells encode three well-characterized DNA ligases, DNA ligase I, III and IV, all of which are related in structure and sequence. DNA ligases either require ATP or NAD. However, archaebacterial, viral, and some eubacterial DNA ligases are ATP-dependent.'),
  'D000072482': NtO(MH='Retinoic Acid Receptor alpha', MS='A nuclear receptor protein which belongs to a family of transcription regulators of ligand-responsive regulatory proteins which include steroid hormone receptors. In addition to a C-terminal ligand-binding domain, these nuclear receptors contain a highly-conserved N-terminal zinc-finger domain that mediates binding ligand-responsive elements.'),
  'D000072483': NtO(MH='Placenta Growth Factor', MS='An angiogenic protein belonging to the Vascular Endothelial Growth Factor family of growth factors originally isolated and cloned from human placental cDNA library. There are four isoforms of PLGF 1-4 which result from alternative splicing. Placenta Growth Factor is secreted as a glycosylated homodimer which acts as a mitogen for endothelial cells, and its expression is markedly upregulated during hypoxia and in tissue inflammation and cancer.'),
  'D000072496': NtO(MH='Cytochrome P450 Family 19', MS='A cytochrome P450 enzyme family that includes AROMATASE, which functions in the biosynthesis of ESTROGENS.'),
  'D000072497': NtO(MH='Cytochrome P450 Family 21', MS='A cytochrome P450 enzyme family that includes STEROID 21-HYDROXYLASE, which functions in the biosynthesis of STEROIDS.'),
  'D000072498': NtO(MH='Cytochrome P450 Family 24', MS='A cytochrome P450 enzyme family that includes VITAMIN D3 24-HYDROXYLASE.'),
  'D000072499': NtO(MH='Manufacturing and Industrial Facilities', MS='Places provided for the processing, fabrication, assembly, and production of a line of products, services, commodities, or merchandise.'),
  'D000072500': NtO(MH='Cytochrome P450 Family 26', MS='A cytochrome P450 enzyme family whose members function in the metabolism of RETINOIC ACID. It includes RETINOIC ACID 4-HYDROXYLASE.'),
  'D000072501': NtO(MH='Cytochrome P450 Family 27', MS='A cytochrome P450 enzyme family whose members function in VITAMIN D metabolism and the biosynthesis of BILE ACIDS.'),
  'D000072503': NtO(MH='Cytochrome P450 Family 46', MS='A cytochrome P450 enzyme family that includes CHOLESTEROL 24-HYDROXYLASE, which is expressed primarily in the brain and functions in CHOLESTEROL metabolism.'),
  'D000072505': NtO(MH='Cytochrome P450 Family 51', MS='A cytochrome P450 family that occurs in all EUKARYOTES. Its members function in the biosynthesis of STEROIDS and some are targets of ANTIFUNGAL AGENTS.'),
  'D000072506': NtO(MH='Gardens', MS='Places provided for the cultivation and/or display of PLANTS.'),
  'D000072516': NtO(MH='Retinoic Acid 4-Hydroxylase', MS='A cytochrome P450 enzyme that resides in the ENDOPLASMIC RETICULUM. It catalyzes the conversion of trans-RETINOIC ACID to 4-hydroxyretinoic acid.'),
  'D000072556': NtO(MH='Cholesterol 24-Hydroxylase', MS='A steroid hydroxylase that functions in CHOLESTEROL homeostasis in the brain. It converts cholesterol into 24S-hydroxycholesterol, which is transported over the BLOOD-BRAIN BARRIER more rapidly than unmetabolized cholesterol.'),
  'D000072576': NtO(MH='Homeobox Protein Nkx-2.5', MS='A homeobox-containing transcription factor that functions in heart development. Mutations in the NKX2-5 gene are associated with ATRIAL SEPTAL DEFECTS and TETRALOGY OF FALLOT.'),
  'D000072577': NtO(MH='Moral Status', MS='A philosophical description of intrinsic self-worth and dignity which bestows basic rights of life, liberty, and freedom from harm.'),
  'D000072596': NtO(MH='Hepatitis A Virus Cellular Receptor 1', MS='An Ig domain-containing membrane receptor for HEPATITIS A VIRUS; EBOLA VIRUS; MARBURG VIRUS; and DENGUE VIRUS. It may also function to modulate ASTHMA and HYPERSENSITIVITY.'),
  'D000072597': NtO(MH='Hepatitis A Virus Cellular Receptor 2', MS='An Ig domain-containing membrane receptor that is expressed by TH1 CELLS. It regulates the activation of MACROPHAGES and inhibits TH1-mediated auto- and alloimmune responses to promote IMMUNE TOLERANCE.'),
  'D000072598': NtO(MH='Tumor Necrosis Factor alpha-Induced Protein 3', MS='A UBIQUITIN editing enzyme that functions as both a ubiquitin ligase and deubiquitinase. It contains several ZINC FINGERS and functions in the immune response and INFLAMMATION by modulating signals from TNF-ALPHA; IL1-BETA; or pathogens via TOLL-LIKE RECEPTORS to terminate NF-KAPPA B activity.'),
  'D000072599': NtO(MH='Cardiorespiratory Fitness', MS='A measure of the functional capabilities of the heart, lungs and muscles, relative to the demands of specific exercise routines such as running or cycling.'),
  'D000072600': NtO(MH='Meniscus', MS='Crescent-shaped cartilaginous tissue interposed between two articulating bones.'),
  'D000072601': NtO(MH='Cannula', MS='Short, hollow cylinders or tubes for insertion into a canal, vessel, or body cavity.'),
  'D000072621': NtO(MH='Peptidyl-Prolyl Cis-Trans Isomerase NIMA-Interacting 4', MS='A NIMA-interacting peptidylprolyl isomerase. It binds to double-stranded DNA and functions in the biogenesis of RIBOSOMES.'),
  'D000072622': NtO(MH='Cyclophilin C', MS='A peptidyl-prolyl cis-trans isomerase and member of the cyclophilin family. It catalyzes the cis-trans isomerization of imide-like peptide bonds that occur between PROLINE and other amino acids to facilitate PROTEIN FOLDING.'),
  'D000072636': NtO(MH='PAX8 Transcription Factor', MS='A paired box transcription factor that functions in the development of THYROCYTES and the control of thyroid-specific gene expression. Mutations in the PAX8 gene are associated with THYROID DYSGENESIS and THYROID NEOPLASMS.'),
  'D000072637': NtO(MH='Thyroid Epithelial Cells', MS='Epithelial cells of the THYROID GLAND that produce and secrete THYROXINE and TRIIODOTHYRONINE.'),
  'D000072638': NtO(MH='Patient Portals', MS='A secure online website that provides patients convenient 24-hour access to personal health information via an Internet connection.'),
  'D000072639': NtO(MH='Perfectionism', MS="A personality trait characterized by a person's striving for flawlessness and setting excessively high performance standards, accompanied by overly critical self-evaluations and concerns regarding others' evaluations."),
  'D000072640': NtO(MH='Interferon-Induced Helicase, IFIH1', MS='A DEAD box RNA helicase that contains two N-terminal CASPASE ACTIVATION AND RECRUITMENT DOMAINS. It functions as a sensor of viral NUCLEIC ACIDS such as DOUBLE-STRANDED RNA and activates the INNATE IMMUNE RESPONSE by inducing the expression of INTERFERON-ALPHA and INTERFERON-BETA. It may also regulate cell growth and APOPTOSIS.'),
  'D000072641': NtO(MH='Medicare Access and CHIP Reauthorization Act of 2015', MS="An Act that amends Title XVIII of the Social Security Act to repeal the Medicare sustainable growth rate, that strengthens Medicare access by improving  physician payments, and that reauthorizes the Children's Health Insurance Program (CHIP)."),
  'D000072643': NtO(MH='Study Guide', MS='Tool used to help facilitate learning and comprehension of a topic or to help prepare for an examination.'),
  'D000072644': NtO(MH='Study Guides as Topic', MS='Works about use of aids to help facilitate learning and comprehension of a topic or to help prepare for an examination.'),
  'D000072645': NtO(MH='Cancer-Associated Fibroblasts', MS='Subpopulation of heterogeneous fibroblasts within the TUMOR MICROENVIRONMENT that support NEOPLASTIC CELL TRANSFORMATION and NEOPLASTIC PROCESSES.'),
  'D000072656': NtO(MH='Breast Cancer Lymphedema', MS='Abnormal accumulation of lymph in the arm, shoulder and breast area associated with surgical treatment (e.g., MASTECTOMY) or radiation treatment of breast cancer.'),
  'D000072657': NtO(MH='ST Elevation Myocardial Infarction', MS='A clinical syndrome defined by MYOCARDIAL ISCHEMIA symptoms; persistent elevation in the ST segments of the ELECTROCARDIOGRAM; and release of BIOMARKERS of myocardial NECROSIS (e.g., elevated TROPONIN levels). ST segment elevation in the ECG is often used in determining the treatment protocol (see also NON-ST ELEVATION MYOCARDIAL INFARCTION).'),
  'D000072658': NtO(MH='Non-ST Elevated Myocardial Infarction', MS='A myocardial infarction that does not produce elevations in the ST segments of the ELECTROCARDIOGRAM. ST segment elevation of the ECG is often used in determining the treatment protocol (see also ST Elevation Myocardial Infarction).'),
  'D000072659': NtO(MH='Hypophysitis', MS='Inflammation of the PITUITARY GLAND.'),
  'D000072660': NtO(MH='Teratozoospermia', MS='Conditions in which sperm show abnormal morphology.'),
  'D000072661': NtO(MH='Ciliopathies', MS='Genetic disorders caused by defects in genes related to the primary CILIUM; BASAL BODY; or CENTROSOME. Primary features may include obesity, SKELETAL DYSPLASIA; POLYDACTYLY and malformations that primarily involve the liver, eye or kidneys.'),
  'D000072662': NtO(MH='Margins of Excision', MS='The edges of tissue removed in a surgery for assessment of the effectiveness of a surgical procedure in achieving the local control of a neoplasm and the adequacy of tumor removal. When the margin is negative or not involved by tumor (e.g., CANCER) it suggests all of the tumor has been removed by the surgery.'),
  'D000072663': NtO(MH='Spontaneous Perforation', MS='A pathological hole in an organ, blood vessel or other soft part of the body, occurring in the absence of external force.'),
  'D000072664': NtO(MH='Provitamins', MS='Precursor forms of vitamins.'),
  'D000072666': NtO(MH='National Center for Advancing Translational Sciences (U.S.)', MS='A unit of the National Institutes of Health that seeks to catalyze the generation of innovative methods and technologies that will enhance the development, testing, and implementation of diagnostics and therapeutics across a wide range of human diseases and conditions. The Center was established in 2011.'),
  'D000072667': NtO(MH='National Center for Complementary and Integrative Health (U.S.)', MS='The mission of NCCIH is to define, through rigorous scientific investigation, the usefulness and safety of complementary and integrative health interventions and their roles in improving health and health care. The Center was established in 1999 and was known as NCCAM National Center of Complementary and Alternative Medicine until 2015.'),
  'D000072668': NtO(MH='Splicing Factor U2AF', MS="An RNA splicing factor that performs a critical function in both constitutive and enhancer-dependent RNA SPLICING. It recruits RIBONUCLEOPROTEIN, U2 SMALL NUCLEAR to the splice site and mediates interactions between it, the RNA molecule, and other splicing factors for accurate 3'-splice site selection."),
  'D000072669': NtO(MH='Gene Editing', MS="Genetic engineering or molecular biology techniques that involve DNA REPAIR mechanisms for incorporating site-specific modifications into a cell's genome."),
  'D000072670': NtO(MH='PTB-Associated Splicing Factor', MS='An RNA splicing factor that also binds DNA. It is essential for pre-mRNA spicing in the formation of early SPLICEOSOMES and catalytic step II. It binds specifically to polypyrimidine tracts in INTRONS and is involved in the regulation of ALTERNATIVE SPLICING by SIGNAL TRANSDUCTION PATHWAYS.'),
  'D000072676': NtO(MH='Ankyloglossia', MS='A severe congenital restriction of TONGUE movement, resulting from fusion or adherence of the tongue to the floor of the mouth. In partial ankyloglossia (tongue-tie) the LINGUAL FRENUM is abnormally short, or is attached too close to the tip of the tongue. OMIM: 106280'),
  'D000072696': NtO(MH='High-Intensity Interval Training', MS='A cardiovascular exercise strategy with alternating short periods of intense anaerobic exercise with less-intense recovery periods.'),
  'D000072697': NtO(MH='Desegregation', MS='Ending segregation (separation) of different groups of people, usually based on race, in schools, housing, organizations, etc.'),
  'D000072698': NtO(MH='Apartheid', MS='A former political system in SOUTH AFRICA which enforced segregation in all forms, including physical, political, legal and economic discrimination, against all non-white, non-European racial groups.'),
  'D000072699': NtO(MH='Social Segregation', MS='Barriers based on group membership.'),
  'D000072700': NtO(MH='Conservative Treatment', MS='Therapeutic approaches that are limited, gradual, or well-established as opposed to radical methods.'),
  'D000072716': NtO(MH='Cancer Pain', MS='Pain that may be caused by or related to cellular, tissue, and systemic changes that occur during NEOPLASM growth, tissue invasion, and METASTASIS.'),
  'D000072717': NtO(MH='Tertiary Lymphoid Structures', MS='Aggregates of immune cells formed near the sites of chronically inflamed, infected, or tumorous tissues.'),
  'D000072736': NtO(MH='Propofol Infusion Syndrome', MS='Rare and often fatal drug complication which affects patients undergoing long-term treatment with high doses of PROPOFOL. It is characterized by METABOLIC ACIDOSIS; HYPERLIPIDEMIA; RHABDOMYOLYSIS; cardiovascular CIRCULATORY COLLAPSE; CARDIAC FAILURE; and KIDNEY FAILURE.'),
  'D000072737': NtO(MH='Myeloid-Derived Suppressor Cells', MS='A heterogeneous, immature population of myeloid cells that can suppress the activity of T-CELLS and NATURAL KILLER CELLS in the INNATE IMMUNE RESPONSE and ADAPTIVE IMMUNE RESPONSE. They play important roles in ONCOGENESIS; INFLAMMATION; and INFECTION.'),
  'D000072738': NtO(MH='Nitrogen-Fixing Bacteria', MS='Bacteria that are capable of NITROGEN FIXATION.'),
  'D000072739': NtO(MH='Sentinel Species', MS='Organisms used to determine measurable environmental risks or hazards to human health and or well-being, thereby serving as advance or early warning signs of impending danger to humans. Examples of sentinel species are monkeys, guinea pigs, and the fabled canary in the coal mine.'),
  'D000072740': NtO(MH='Paternal Inheritance', MS='A form of inheritance where the traits of the offspring are paternal in origin due to the expression of extra-nuclear genetic material such as MITOCHONDRIAL DNA or Y chromosome genes. CENTRIOLES are also paternally inherited.'),
  'D000072741': NtO(MH='Maternal Inheritance', MS='Transmission of genetic characters, qualities, and traits, solely from maternal extra-nuclear elements such as MITOCHONDRIAL DNA or MATERNAL MESSENGER RNA.'),
  'D000072742': NtO(MH='Invasive Fungal Infections', MS='Mycoses which manifest as infections of deep tissue or blood.'),
  'D000072743': NtO(MH='Beta-Cryptoxanthin', MS='A mono-hydroxylated xanthophyll that is a provitamin A precursor.'),
  'D000072756': NtO(MH='Protein Conformation, alpha-Helical', MS='A secondary structure of proteins that is a right-handed helix or coil, where each amino (N-H) group of the peptide backbone contributes a hydrogen bond to the carbonyl(C=O) group of the amino acid four residues N-terminal to it (n-4). It is the most common type of secondary structure.'),
  'D000072757': NtO(MH='Protein Conformation, beta-Strand', MS='A secondary structure of proteins where the amino (N-H) groups of a polypeptide backbone, three to ten amino acids in length, establish hydrogen bonds with the carbonyl (C=O) groups in the backbone of adjacent strands.  These may form a beta-sheet, where the side chains of the adjacent strands point in the same direction.'),
  'D000072758': NtO(MH='Vaccination Refusal', MS='Refusal to receive VACCINATION.'),
  'D000072759': NtO(MH='Biofortification', MS="Improving the NUTRITIONAL VALUE of plant foods by augmenting the plant's environment, by using PLANT BREEDING, or by GENETIC ENGINEERING plants to increase their ability to synthesize VITAMINS or uptake essential NUTRIENTS from the soil."),
  'D000072760': NtO(MH='Single Molecule Imaging', MS='High resolution imaging techniques that allow visualization of individual molecules of proteins, lipids, or nucleic acids within cells or tissues.'),
  'D000072761': NtO(MH='Mycobiome', MS='The full spectrum of FUNGI that exist within a particular biological niche such as an organism, soil, a body of water, etc.'),
  'D000072776': NtO(MH='Slit Lamp Microscopy', MS='A procedure that uses a SLIT LAMP to examine structures in the front of the EYE, such as the CONJUNCTIVA; CORNEA; IRIS; and AQUEOUS HUMOR.'),
  'D000072777': NtO(MH='Host-Seeking Behavior', MS='Searching behavior by parasitic or commensal organisms, to find animals or plants that are a source of nourishment and habitation.'),
  'D000072797': NtO(MH='Walking Speed', MS='The rate at which steps are made while walking.'),
  'D000072799': NtO(MH='Stair Climbing', MS='Ascending or descending stairs.'),
  'D000072817': NtO(MH='Eryptosis', MS='Suicidal death of ERYTHROCYTES which results in features typical of apoptotic nucleated cells such as cell shrinkage, membrane blebbing, and scrambling of cell membrane to expose membrane PHOSPHATIDYLSERINES, which triggers engulfment and degradation by MACROPHAGES.'),
  'D000072836': NtO(MH='Surgical Wound', MS='An incision made during a surgical procedure.'),
  'D000072837': NtO(MH='Chromothripsis', MS='Massive number of chromosomal rearrangements and shattering that occurs in cancer cells. The breakpoints are located within one chromosome or chromosome arm.'),
  'D000072856': NtO(MH='Radiologic and Imaging Nursing', MS='A nursing specialty that deals specifically with the care of patients undergoing diagnostic, neurological, cardiovascular, interventional, ultrasonography, computerized tomography, nuclear medicine, magnetic resonance, radiation oncology or other related procedures .'),
  'D000072858': NtO(MH='Psychosocial Support Systems', MS='Organized efforts to address ongoing psychological and social problems of individuals, their partners, families and caregivers.'),
  'D000072860': NtO(MH='Ecological Momentary Assessment', MS="Repeated reports by a research participant of symptoms, affect, behavior, and cognition close in time to experience and in the participant's natural environment."),
  'D000072861': NtO(MH='Phobia, Social', MS='Anxiety disorder characterized by the persistent and irrational fear, anxiety, or avoidance of social or performance situations.'),
  'D000072878': NtO(MH='Simplified Acute Physiology Score', MS='A severity of disease classification system designed to measure the severity of disease for patients aged 15 and over admitted to intensive care units.'),
  'D000072896': NtO(MH='Morgue', MS='Location where dead bodies are kept until they are buried or cremated.'),
  'D000072916': NtO(MH='Peripheral Blood Stem Cells', MS='Hematopoietic stem cells found in peripheral blood circulation.'),
  'D000072917': NtO(MH='Standardized Nursing Terminology', MS='Standardized terms used in the nursing field (e.g., NURSING INFORMATICS).'),
  'D000072936': NtO(MH='Fitness Trackers', MS='Devices used for measuring physical activity as an indication of HEALTH STATUS.'),
  'D000072956': NtO(MH='Adult Germline Stem Cells', MS='Progenitor stem cells found in the testicles.'),
  'D000072957': NtO(MH='Alaska Natives', MS='Persons having origins in any indigenous people of ALASKA and their descendants and who maintain tribal affiliation, or community or cultural attachment.'),
  'D000072977': NtO(MH='Oogonial Stem Cells', MS='Primordial germ cells found in embryonic OOGONIA and postnatal OVARIES.'),
  'D000073': NtO(MH='Acenaphthenes', MS='Tricyclic ethylene-bridged naphthalene derivatives. They are found in petroleum residues and coal tar and used as dye intermediates, in the manufacture of plastics, and in insecticides and fungicides.'),
  'D000073017': NtO(MH='Refugee Camps', MS='Areas of shelter and protection for people who leave their own country or habitual residence to escape danger, persecution, or disaster.'),
  'D000073038': NtO(MH='Mental Health Recovery', MS='Recovery from mental disorders and/or substance abuse. The process of change in which individuals improve their MENTAL HEALTH and wellness, live a self-directed life, and work to achieve their full potential.'),
  'D000073039': NtO(MH='Nitrosative Stress', MS='A metabolic excess of REACTIVE NITROGEN SPECIES, including NITRIC OXIDE and PEROXYNITRITE, that leads to damaging effects of oxidation and nitration.'),
  'D000073056': NtO(MH='Transactinide Series Elements', MS='A series of radioactive elements with atomic numbers greater than 103. Current members include Rutherfordium, atomic number 104, to and including Ununoctium, atomic number 118. All members are synthetic with short half-lives.'),
  'D000073076': NtO(MH='Aruba', MS='Island in the Caribbean Sea, north of Venezuela. In 1986 it became a separate, autonomous member of the Kingdom of the Netherlands.'),
  'D000073096': NtO(MH='Curacao', MS='Constituent country within the Kingdom of the Netherlands. Full autonomy in internal affairs was granted in 2010. It is an island located in the Caribbean Sea - north of Venezuela. (from CIA World Factbook)'),
  'D000073097': NtO(MH='Sint Maarten', MS='Dutch part of the island of Saint Martin in the Caribbean Sea; Sint Maarten lies east of the US Virgin Islands.'),
  'D000073116': NtO(MH='Cancer Survivors', MS='Persons who have experienced prolonged survival with or following malignant neoplastic disease.'),
  'D000073136': NtO(MH='Sao Tome and Principe', MS='Islands in the Gulf of Guinea, just north of the Equator, and west of Gabon.'),
  'D000073137': NtO(MH='Caribbean Netherlands', MS='A group Caribbean islands including Bonaire, Sint Eustatius, and Saba.'),
  'D000073156': NtO(MH='Naja', MS='A genus of elapid snakes, also known as cobras, that are indigenous to Africa, Central and Southern Asia, and adjacent islands such as Taiwan and the Philippines.'),
  'D000073176': NtO(MH='Naja naja', MS='Species of cobra (Naja) indigenous to the Indian Subcontinent, Southern Asia, and adjacent islands.'),
  'D000073177': NtO(MH='Naja haje', MS='A species of cobra (Naja) that is indigenous primarily to Northern Africa.'),
  'D000073178': NtO(MH='Dendroaspis', MS='A genus of highly venomous elapid snake indigenous to sub-Saharan Africa.'),
  'D000073179': NtO(MH='Hemachatus', MS='A genus of elapid snake indigenous to Southern Africa. It is closely related to the cobras (Naja) and is capable of spitting its venom.'),
  'D000073180': NtO(MH='Hydrophiidae', MS='A subfamily of marine elapid snakes comprising about 50 species with flattened oar-like tails used as sculls. They are found mostly in the coastal waters of south Asia and Australia. The largest reach a length of almost 9 feet but most species are only about a third as long. They are all venomous. (Goin, Goin, and Zug, Introduction to Herpetology, 3d ed, pp331-3; Moore: Poisonous Snakes of the World, 1980, p159)'),
  'D000073181': NtO(MH='Coral Snakes', MS='Elapid snakes indigenous to the Southern United States, Central, and South America. They are generally less than 1 meter in length and have colored ring patterns.'),
  'D000073182': NtO(MH='Carbapenem-Resistant Enterobacteriaceae', MS='Strains of Enterobacteriaceae that are resistant to CARBAPENEMS, primarily due to the acquisition of carbapenemase (BETA-LACTAMASE) genes.'),
  'D000073183': NtO(MH='Platelet-Rich Fibrin', MS='A fibrin matrix derived from platelet-rich plasma that contains high concentration of BLOOD PLATELETS; LEUKOCYTES; CYTOKINES; and GROWTH FACTORS. It is used in a variety of clinical and TISSUE ENGINEERING applications.'),
  'D000073196': NtO(MH='Integrative Oncology', MS='These evidence-based therapies to reduce symptoms associated with treatment of cancer.'),
  'D000073197': NtO(MH='Ophiophagus hannah', MS='The longest of all venomous snakes and largest Elapid. It is not a member of the Naja genus, although its hood resembles the hood of Naja species. Its bite can deliver large quantities of neurotoxic and cardiotoxic venom, consisting primarily of ALPHA-NEUROTOXINS. King cobras are indigenous to forests of India and Southeast Asia.'),
  'D000073216': NtO(MH='Mental Status and Dementia Tests', MS='Tests designed to assess various aspects of neurocognitive function or dementia.'),
  'D000073218': NtO(MH='Wisconsin Card Sorting Test', MS='A neuropsychological test designed to assess EXECUTIVE FUNCTION typically assigned to the FRONTAL LOBE (e.g., abstract thinking, and strategic planning). The subjects are asked to sort numbered response cards according to different principles and to alter their approach during testing.'),
  'D000073219': NtO(MH='Memory and Learning Tests', MS='Tests designed to evaluate general and specific areas of behaviors and abilities associated with memory and/or learning.'),
  'D000073220': NtO(MH='Wechsler Memory Scale', MS='A neuropsychological test designed to assess different memory functions. It may incorporate an optional cognitive exam (Brief Cognitive Status Exam) that helps to assess memory related cognitive function.'),
  'D000073222': NtO(MH='Patient Health Questionnaire', MS='A self-administered version of the Primary Care Evaluation of Mental Disorders (PRIME-MD), a diagnostic tool containing modules on multiple mental health disorders including anxiety, alcohol, eating, and somatoform modules. The Patient Health Questionnaire (PHQ-9) is designed specifically for mood/depression scoring each of the 9 DSM-IV criteria based on the mood module from the original PRIME-MD. The Generalized Anxiety Disorder scale (GAD-7) scores 7 common anxiety symptoms.'),
  'D000073256': NtO(MH='Information Technology', MS='Interconnected system that is used in the automatic acquisition, storage, manipulation, movement, control, display, interchange, transmission, routing or reception of data or information, including computers, ancillary equipment, system software, support services, and related resources. (NAL Agricultural Thesaurus)'),
  'D000073276': NtO(MH='Models, Spatial Interaction', MS='Estimates of the flow of people, material or information between locations in geographic space.'),
  'D000073278': NtO(MH='Self-Management', MS="Individual's ability to manage the symptoms, treatment, physical and psychosocial consequences and lifestyle changes inherent in living with a chronic condition. Efficacious self-management encompasses ability to monitor one's condition and to affect the cognitive, behavioral, and emotional responses necessary to maintain a satisfactory quality of life."),
  'D000073296': NtO(MH='Noncommunicable Diseases', MS='Diseases which are typically non-infectious in origin and do not transmit from an affected individual to others. The four main types of noncommunicable diseases are CARDIOVASCULAR DISEASES (e.g., heart attacks and stroke), CANCER, chronic respiratory diseases (e.g., CHRONIC OBSTRUCTIVE PULMONARY DISEASE and ASTHMA) and DIABETES MELLITUS.'),
  'D000073297': NtO(MH='Manual Lymphatic Drainage', MS='The application of massage to control EDEMA and improve circulation by manually moving excess lymph out of a tissue.'),
  'D000073316': NtO(MH='Addiction Medicine', MS='A medical specialty focused on the diagnosis and treatment of ADDICTIVE BEHAVIOR disorders, including SUBSTANCE-RELATED DISORDERS and IMPULSE CONTROL DISORDERS; and the management of co-occurring medical and psychiatric conditions'),
  'D000073319': NtO(MH='Obesity Management', MS='An integrated professional approach to screening, evaluation, control, and reduction of abnormal WEIGHT GAIN.'),
  'D000073320': NtO(MH='Psycho-Oncology', MS='A specialty which deals with the interrelationship of physical, psychological, social, behavioral, and ethical aspects of cancer. Psycho-oncology examines the behavioral and psychosocial factors that may influence the course of the disease, cancer risk, prevention, and detection.'),
  'D000073336': NtO(MH='Whole Genome Sequencing', MS='Techniques to determine the entire sequence of the GENOME of an organism or individual.'),
  'D000073356': NtO(MH='Pictorial Works as Topic', MS='Works that discuss pictures but not technical drawings.'),
  'D000073358': NtO(MH='Mycobacterium abscessus', MS='A rapidly growing non-tuberculous environmental mycobacterium causing OPPORTUNISTIC INFECTION that infects the skin and subcutaneous tissues. It is associated with HEALTH CARE ASSOCIATED INFECTION and causes serious lung infections in persons with various chronic lung diseases.'),
  'D000073359': NtO(MH='Whole Exome Sequencing', MS='Techniques to determine the complete complement of sequences of all EXONS of an organism or individual.'),
  'D000073376': NtO(MH='Epileptic Syndromes', MS='EPILEPTIC SEIZURES that are of similar type and age of onset and have other similar features (e.g., clinical course, EEG findings, genetic association and neuropathology).'),
  'D000073396': NtO(MH='Metal-Organic Frameworks', MS='Supramolecular networks that consist of ordered arrangements of organic electron donor linkers (usually ditopic or polytopic organic carboxylates) and metal cations. They can have an extremely high surface area and adjustable pore size that allows for the insertion of other molecules capable of various functions such as catalysis, capture of carbon dioxide, and drug delivery.'),
  'D000073397': NtO(MH='Occupational Stress', MS='Adverse psychological and behavioral reactions caused by the pressures and demands of employers or clients or other factors, such as the physical environment of the workplace, WORKPLACE VIOLENCE; or WORKPLACE BULLYING.'),
  'D000073398': NtO(MH='Demethylation', MS='Removal of one or more methyl groups from a chemical compound.'),
  'D000073399': NtO(MH='DNA Demethylation', MS='Removal of methyl groups from DNA by enzymes (such as DIOXYGENASES and N-DEMETHYLASES) or by chemical reagents.'),
  'D000073417': NtO(MH='Dietary Sugars', MS='MONOSACCHARIDES and DISACCHARIDES present in food, such as those present in fruits and vegetables and milk products, or those added to food such as DIETARY SUCROSE (table sugar) or HIGH FRUCTOSE CORN SYRUP.'),
  'D000073436': NtO(MH='Microvascular Rarefaction', MS='The reduction in density of the MICROVASCULATURE.'),
  'D000073456': NtO(MH='Multitasking Behavior', MS='Simultaneous task performance, or switching between tasks in a concentrated period of time.'),
  'D000073458': NtO(MH='Data Warehousing', MS='A system for storing electronic data derived from various sources.'),
  'D000073476': NtO(MH='Laticauda', MS='A genus of semi-aquatic elapid snake that inhabits coastal waters of the tropical Indian and Western Pacific Oceans.'),
  'D000073496': NtO(MH='Frailty', MS='A state of increased vulnerability to stressors, following declines in function and reserves across multiple physiologic systems, characterized by MUSCLE WEAKNESS; FATIGUE; slowed motor performance; low physical activity; and unintentional weight loss.'),
  'D000073516': NtO(MH='Contraceptive Effectiveness', MS='The rate of success or failure of a method of CONTRACEPTION; CONTRACEPTIVE AGENTS; or CONTRACEPTIVE DEVICES.'),
  'D000073537': NtO(MH='Biological Variation, Population', MS='Differences in measurable biological values, characteristics, or traits, among individuals of a population or between population groups.'),
  'D000073556': NtO(MH='Burkholderiales', MS='An order of gram-negative bacteria of the class BETAPROTEOBACTERIA which include highly pathogenic species such as BURKHOLDERIA; BORDETELLA; and RALSTONIA.'),
  'D000073557': NtO(MH='Campylobacteraceae', MS='A large and diverse group in the order CAMPYLOBACTERALES, individual species of which grow in aerobic and anaerobic conditions as free-living, commensal, or pathogenic forms.'),
  'D000073559': NtO(MH='Caryophyllales', MS='Diverse and ecologically specialized dicotyledonous flowering plants that include trees, annuals, shrubs, lianas, mangroves, stem or leaf succulents, and insectivores; acting as important food sources in many cases.'),
  'D000073560': NtO(MH='Chromadorea', MS='A class of invertebrate freshwater roundworms of the phylum NEMATODA. Most members are parasites with well-adapted body surfaces and sophisticated esophageal glands and pharynx.'),
  'D000073561': NtO(MH='Clostridiaceae', MS='A non-sulfate spore-forming anaerobic family of Gram-positive bacteria, of the class clostridia.'),
  'D000073562': NtO(MH='Crotalinae', MS='A subfamily of snakes commonly known as pit vipers, crotaline snakes, or pit adders in the family VIPERIDAE. They are distinguished by a deep pit called a fossa or loreal, which functions as a heat-sensing organ located between the eye and nostril on either side of the head.'),
  'D000073563': NtO(MH='Culicomorpha', MS='Insects of the order DIPTERA, suborder NEMATOCERA. They include mosquitoes, gnats, black flies, and true flies.'),
  'D000073564': NtO(MH='Desulfovibrionaceae', MS='A family of obligately anaerobic Gram-negative bacteria of the order Desulfovibrionales, class DELTAPROTEOBACTERIA. Majority are sulfate-reducing.'),
  'D000073566': NtO(MH='Eutheria', MS='Mammals which nourish their young in utero by means of a complex placenta, and give birth to their young alive. They include PRIMATES; CARNIVORA, WHALES; RUMINANTS; BATS; and RODENTS.'),
  'D000073567': NtO(MH='Fagales', MS='Order of dicotyledonous flowering plants in the superorder ROSANAE, and class MAGNOLIOPSIDA. They include birch, beech, bayberry, and walnut species.'),
  'D000073568': NtO(MH='Feliformia', MS='A suborder of cat-like mammals in the order CARNIVORA. Examples include HYENAS; MONGOOSES; CIVETS; and related species. They are distinguishable from dog-like carnivores.'),
  'D000073569': NtO(MH='Helicobacteraceae', MS='A family of Gram-negative bacteria of the order CAMPYLOBACTERALES that have a helical shape, and occur in the mammalian digestive track.'),
  'D000073571': NtO(MH='Laurales', MS='Order of flowering plants in the superorder Magnolianae. Common examples are bay laurel, AVOCADO; sassafras and CINNAMON.'),
  'D000073576': NtO(MH='Faith-Based Organizations', MS='Organizations such as (1) congregations; (2) national networks, which include national denominations, their social service arms (for example, Catholic Charities, Lutheran Social Services), and networks of related organizations (such as YMCA and YWCA); and (3) freestanding religious organizations, which are incorporated separately from congregations and national networks. http://www.huduser.gov/portal/publications/faithbased.pdf'),
  'D000073577': NtO(MH='Shift Work Schedule', MS='Job schedule in which working hours deviate from the standard hours (e.g., evening shift, night shift or rotating shift).'),
  'D000073597': NtO(MH='Stakeholder Participation', MS='A process between an entity and those groups or individuals potentially or actually impacted by the actions of that entity over a range of activities and approaches.'),
  'D000073599': NtO(MH='Health Risk Behaviors', MS='Pattern of behavior which predisposes certain individuals to increased risk for contracting disease or sustaining personal injury. These behaviors may cluster into a risky lifestyle.'),
  'D000073600': NtO(MH='Diet, High-Protein', MS='A diet that includes foods with a high protein content.'),
  'D000073601': NtO(MH='Dietary Approaches To Stop Hypertension', MS='Dietary recommendations that promote reduction in or prevention of high blood pressure. Recommendations include increasing intake of fruits and vegetables, and high-fiber, low-fat foods and reducing the intake of DIETARY SODIUM and high fat foods.'),
  'D000073602': NtO(MH='Antimicrobial Stewardship', MS='Programs and guidelines for selecting optimal ANTI-INFECTIVE AGENTS regimens in an effort to maintain antibiotic efficacy, reduce CROSS INFECTION related to ANTIBIOTIC RESISTANCE while managing satisfactory clinical and economic outcomes.'),
  'D000073605': NtO(MH='Spotted Fever Group Rickettsiosis', MS='A group of arthropod-borne diseases caused by spotted fever bio-group members of RICKETTSIA. They are characterized by fever, headache, and petechial (spotted) rash.'),
  'D000073617': NtO(MH='Transfusion-Related Acute Lung Injury', MS='A rare but serious transfusion-related reaction in which fluid builds up in the lungs unrelated to excessively high infusion rate and/or volume (TRANSFUSION-ASSOCIATED CIRCULATORY OVERLOAD). Signs of Transfusion-Related Acute Lung Injury include pulmonary secretions; hypotension; fever; DYSPNEA; TACHYPNEA; TACHYCARDIA; and CYANOSIS.'),
  'D000073618': NtO(MH='Varicella Zoster Virus Infection', MS='Infection caused by HUMAN HERPES VIRUS 3 (e.g., CHICKENPOX and HERPES ZOSTER).'),
  'D000073623': NtO(MH='Pre-Analytical Phase', MS='Laboratory processes prior to specimen analysis. These processes include study design, compliance of the subjects investigated, compliance in adherence to protocols, choice of specimens utilized and sample collection.'),
  'D000073624': NtO(MH='Symbolic Interactionism', MS='Theoretical approach to social processes with a fundamental concern with power phenomena. There is a focus on the analysis of culture, the influence of Foucault, and the development of feminist perspectives.'),
  'D000073637': NtO(MH='Oligodendrocyte Precursor Cells', MS='Neuroglial cells that first appear during mid-embryogenesis in the central nervous system of mammals and give rise to OLIGODENDROCYTES. Mitotically-active populations remain through late adulthood and are capable of regenerating MYELIN lost to disease or injury.'),
  'D000073638': NtO(MH='Alphacoronavirus', MS='A genus of the family CORONAVIRIDAE which causes respiratory or gastrointestinal disease in a variety of mammals. Human alphacoronaviruses include Human coronavirus 229E and NL63. All members share the identical core transcription regulatory sequences of 5\xe2\x80\x99-CUAAAC-3\xe2\x80\x99 and most have 1 to 2 ORFs downstream to the N protein gene.'),
  'D000073639': NtO(MH='Alphacoronavirus 1', MS='The type species of ALPHACORONAVIRUS genus causing gastroenteritis, peritonitis and respiratory diseases in dogs, cats and swine. Previously separate species TRANSMISSIBLE GASTROENTERITIS VIRUS; PORCINE RESPIRATORY CORONAVIRUS; CANINE CORONAVIRUS AND FELINE CORONAVIRUS merged into this species on the basis of similar genome nucleotide sequence and genome organization.'),
  'D000073640': NtO(MH='Betacoronavirus', MS='A genus of the family CORONAVIRIDAE which causes respiratory or gastrointestinal disease in a variety of mostly mammals. Human betacoronaviruses include HUMAN ENTERIC CORONAVIRUS; HUMAN CORONAVIRUS OC43; MERS VIRUS; and SARS VIRUS. Members have either core transcription regulatory sequences of 5\xe2\x80\x99-CUAAAC-3\xe2\x80\x99 or 5\xe2\x80\x99-CUAAAC-3\xe2\x80\x99 and mostly have no ORF downstream to the N protein gene.'),
  'D000073641': NtO(MH='Betacoronavirus 1', MS='The type species of BETACORONAVIRUS genus causing gastroenteritis respiratory diseases in mammals. Previously separate species HUMAN CORONAVIRUS OC43; BOVINE CORONAVIRUS; Human enteric coronavirus; Equine coronavirus; and Porcine hemagglutinating encephalomyelitis virus merged into this species on the basis of similar genome nucleotide sequence and genome organization.'),
  'D000073642': NtO(MH='Gammacoronavirus', MS='A genus of the family CORONAVIRIDAE that causes respiratory or gastrointestinal disease in avian species (or birds). The type species, AVIAN CORONAVIRUS, includes the previously separate species TURKEY CORONAVIRUS; and INFECTIOUS BRONCHITIS VIRUS.'),
  'D000073656': NtO(MH='Healthy Aging', MS='The development and maintenance of optimal physical, mental, spiritual, and social well-being and function with advancing age.'),
  'D000073658': NtO(MH='Loss of Function Mutation', MS="A mutation that causes a decrease in or elimination of a gene product's activity."),
  'D000073659': NtO(MH='Gain of Function Mutation', MS="A mutation that results in an increase in a gene's activity or in acquiring a new molecular function or a new pattern of gene expression."),
  'D000073678': NtO(MH='Water Sports', MS='Activities or games performed in a body of water.'),
  'D000073718': NtO(MH='Pancreatitis-Associated Proteins', MS='C-type lectins that restrict growth of bacteria in the intestinal epithelia and have bactericidal activity against gram-positive and gram-negative bacteria. They also regulate proliferation and differentiation of KERATINOCYTES following injury. Human pancreatitis-associated protein-1 (Reg3a) is overexpressed by pancreatic ACINAR CELLS in patients with CHRONIC PANCREATITIS. It is also highly expressed by pancreatic, bladder, and gastrointestinal cancer cells and may serve as a diagnostic biomarker.'),
  'D000073738': NtO(MH='2-Hydroxypropyl-beta-cyclodextrin', MS='Derivative of beta-cyclodextrin that is used as an excipient for steroid drugs and as a lipid chelator.'),
  'D000073739': NtO(MH='Strobilurins', MS='Benzene or pyrimidine derivatives of methacrylic acid that block the Qo site of CYTOCHROME B. They are widely used as agricultural fungicides.'),
  'D000073758': NtO(MH='Nonlinear Optical Microscopy', MS='Microscopic imaging techniques that utilize nonlinear responses of light-matter interactions which occur with high-intensity illumination, such as from LASERS, and specialized light signal detection instrumentation to produce images without the need for dyes or fluorescent labels.'),
  'D000073779': NtO(MH='P-type ATPases', MS='A highly conserved family of ATPases that facilitate the transport of lipids and cations across the plasma membrane. Structurally, they are elongated ALPHA-HELICES constituting five functionally distinct domains: three cytoplasmic domains A, N, and P which contain the catalytic sites, and two transmembrane domains. The N domain phosphorylates the P-domain at an invariant ASPARTATE residue, which, in turn, is dephosphorylated by the A domain.  The phosphorylation and dephosphorylation cycles drive conformational changes in the protein between two states (E1 and E2), which allow the substrate to access the other side of the membrane.'),
  'D000073798': NtO(MH='Second Harmonic Generation Microscopy', MS='A microscopic imaging technique that takes advantage of the process of harmonic generation that occurs when photons interact to generate new photons of a different wavelength. In second harmonic generation, two photons of the same wavelength and frequency, such as from a LASER, interact inside a medium and are converted to a photon of twice the frequency and half of the wavelength of the two incident photons. The light signals captured are used to produce images that are dependent on the unique optical properties of the material.'),
  'D000073818': NtO(MH='Pain, Procedural', MS='Pain associated with examination, treatment or procedures.'),
  'D000073819': NtO(MH='Self-Directed Learning as Topic', MS='Process in which individuals take the initiative, in diagnosing their learning needs, formulating learning goals, identifying resources for learning, choosing and implementing learning strategies and evaluating learning outcomes (Knowles, 1975)'),
  'D000073820': NtO(MH='Scholarly Communication', MS='System through which research and other scholarly writings are created, evaluated for quality, disseminated to the scholarly community, and preserved for future use. It includes both formal means of communication, such as publication in peer-reviewed journals, and informal channels, such as electronic listservs. (from Association of College & Research Libraries, \xe2\x80\x9cPrinciples and Strategies for the Reform of Scholarly Communication 1,\xe2\x80\x9d 2003)'),
  'D000073839': NtO(MH='Trisomy 13 Syndrome', MS='A chromosome disorder associated with TRISOMY of all or part of CHROMOSOME 13. Clinical manifestations include CONGENITAL HEART DEFECTS (e.g., PATENT DUCTUS ARTERIOSUS), facial malformations (e.g., CLEFT LIP; CLEFT PALATE; COLOBOMA; MICROPHTHALMIA); HYPOTONIA, digit malformations (e.g., POLYDACTYLY or SYNDACTYLY), and SEIZURES and severe INTELLECTUAL DISABILITY associated with NERVOUS SYSTEM MALFORMATIONS.'),
  'D000073840': NtO(MH='Copper-Transporting ATPases', MS='P-type ATPases which transport copper ions across membranes in prokaryotic and eukaryotic cells. They possess a conserved CYSTEINE-HISTIDINE-SERINE (CPx) amino acid motif within their transmembrane helices that functions in cation translocation and catalytic activation, and an N-terminal copper-binding CxxC motif that regulates enzyme activity. They play essential roles in intracellular copper homeostasis through regulating the uptake, efflux and storage of copper ions, and in cuproprotein biosynthesis.'),
  'D000073842': NtO(MH='Trisomy 18 Syndrome', MS='A chromosome disorder associated with TRISOMY of all or part of CHROMOSOME 18. Clinical manifestations include INTRAUTERINE GROWTH RETARDATION; CLEFT PALATE; CONGENITAL HEART DEFECTS; MICROCEPHALY; MICROGNATHIA and clenched fists with overlapping fingers. Most affected fetuses do not survive to birth. Those who survive through their first year often have severe INTELLECTUAL DISABILITY.'),
  'D000073843': NtO(MH='Equivalence Trial', MS='Trial that aims to show a new treatment is no better and no worse than the standard treatment.'),
  'D000073846': NtO(MH='Tobacco, Waterpipe', MS='Flavored tobacco whose vapor or smoke is passed through a water basin before inhalation.'),
  'D000073847': NtO(MH='Smoking, Non-Tobacco Products', MS='SMOKING of non-TOBACCO (or NICOTINE-containing) substances.'),
  'D000073859': NtO(MH='Survivorship', MS='Functional, psychosocial, emotional and spiritual domains and needs of patients and families following life-threatening disease or events.'),
  'D000073860': NtO(MH='Immune Privilege', MS='Phenomenon which occurs in certain tissue sites and organs (e.g., the ANTERIOR CHAMBER and CORNEA of the eye, brain PARENCHYMAL TISSUE and fetus) to tolerate a known antigen, thereby suppressing the inflammatory immune response. Foreign tissue grafts survive for prolonged periods when placed within such immune privileged sites and organs.'),
  'D000073861': NtO(MH='Apelin', MS='A 77 amino acid secreted endogenous ligand for the angiotensin II receptor-like 1 protein (APELIN RECEPTOR) that is proteolytically cleaved into four smaller peptides: Apelin-36, Apelin-31, Apelin-28, and Apelin-13. It inhibits entry of HIV into cells that express both APJ and CD4 ANTIGEN and is highly expressed in breast milk, where it may modulate the neonatal immune response.'),
  'D000073863': NtO(MH='Cigar Smoking', MS='The SMOKING of CIGARS.'),
  'D000073864': NtO(MH='Histone Deacetylase 6', MS='A class II histone deacetylase that removes acetyl groups from N-terminal LYSINES of HISTONE H2A; HISTONE H2B; HISTONE H3; and HISTONE H4. It plays a critical role in EPIGENETIC REPRESSION and regulation of GENETIC TRANSCRIPTION, as well as CELL MOTILITY through deacetylation of TUBULIN. It also targets misfolded proteins for clearance by AUTOPHAGY when MOLECULAR CHAPERONE-mediated folding is overwhelmed.'),
  'D000073865': NtO(MH='Cigarette Smoking', MS='The SMOKING of CIGARETTES.'),
  'D000073867': NtO(MH='Water Pipe Smoking', MS='A process by which SMOKE produced from burning substance is mixed with flavor-altering substances and drawn through water or other liquid into the mouth.'),
  'D000073868': NtO(MH='Pipe Smoking', MS='SMOKING by use of a narrow conveying tube which feeds from an open cavity where smoked product is loaded and burned.'),
  'D000073869': NtO(MH='Tobacco Smoking', MS='The process of SMOKING specific to TOBACCO.'),
  'D000073871': NtO(MH='Triggering Receptor Expressed on Myeloid Cells-1', MS='An approximately 230 amino acid membrane glycoprotein characterized by an IMMUNOGLOBULIN V-SET DOMAIN in its N-terminal half. It is expressed by MONOCYTES and NEUTROPHILS in response to INFLAMMATION related to bacterial and fungal infections. It triggers the release of pro-inflammatory CHEMOKINES; CYTOKINES, and expression of cell activation markers and is a critical regulator of SEPTIC SHOCK.'),
  'D000073872': NtO(MH='Vascular Ring', MS='Congenital vascular malformation in which the AORTA arch and its branches encircle the TRACHEA and ESOPHAGUS. Signs and symptoms include DYSPNEA; RESPIRATORY SOUNDS, especially with eating, DYSPHAGIA, persistent cough, and GASTROESOPHAGEAL REFLUX or may be asymptomatic. Two most common types are double aortic arch and right aortic arch. It may be associated with other anomalies (e.g., DIGEORGE SYNDROME).'),
  'D000073874': NtO(MH='ATP Binding Cassette Transporter, Subfamily A', MS='A large, highly conserved, subfamily of ATP binding cassette transporters structurally characterized by a membrane-spanning domain composed of six ALPHA-HELICES, a large extracellular loop, nucleotide-binding domain, and a conserved cytoplasmic 80 amino acid sequence. In humans, it includes ABCA1(ATP BINDING CASSETTE TRANSPORTER 1) through ABCA10, as well as ABCA12 and ABCA13.'),
  'D000073878': NtO(MH='Palm Oil', MS='Nutritive oil extracted from the fleshy mesocarp of the fruit of the African palm tree, Elaeis guineensis.'),
  'D000073879': NtO(MH='Rice Bran Oil', MS='OIL extracted from the hard outer brown layer of rice bran after the husk has been removed.'),
  'D000073880': NtO(MH='Body Contouring', MS='Plastic surgery to shape many areas of the body simultaneously. This may include LIPECTOMY or RHYTIDOPLASTY or both.'),
  'D000073882': NtO(MH='ATP Binding Cassette Transporter, Subfamily A, Member 4', MS='An ATP binding cassette sub-family A transporter that translocates 11-cis and all-trans isomers of N-retinylidene-phosphatidylethanolamine (RETINOIDS) from the extracellular surface to the cytoplasmic membrane surface of RETINAL ROD CELLS and RETINAL CONE CELLS. Mutations in the ABCA4 gene are associated with Stargardt Disease 1, a hereditary juvenile form of MACULAR DEGENERATION.'),
  'D000073883': NtO(MH='CX3C Chemokine Receptor 1', MS='Receptor for CHEMOKINE CX3CL1 expressed by lymphocytes, neurons, and GLIAL CELLS. Its interaction with CX3CL1 mediates CELL ADHESION and CELL MIGRATION. It also functions as a co-receptor with the CD4 ANTIGEN for HIV-1 in vitro.'),
  'D000073885': NtO(MH='C9orf72 Protein', MS='A widely-expressed protein of approximately 400 to 500 amino acids. Its N-terminal region (DENN domain) interacts with RAB GTP-BINDING PROTEINS and may regulate AUTOPHAGY, as well as PROTEIN TRANSPORT to ENDOSOMES. Expansion of the GGGGCC hexanucleotide repeat in the first intron of the C9orf72 gene is associated with FRONTOTEMPORAL DEMENTIA with AMYOTROPHIC LATERAL SCLEROSIS (FTDALS1).'),
  'D000073886': NtO(MH='Scientific Experimental Error', MS='Deviation or aberration in the practical implementation of standard empirical procedures, distinct from MEDICAL ERRORS and SCIENTIFIC MISCONDUCT.'),
  'D000073887': NtO(MH='Vaccination Coverage', MS='Rate of VACCINATION as defined by GEOGRAPHY and or DEMOGRAPHY.'),
  'D000073888': NtO(MH='Cell-Free Nucleic Acids', MS='Nucleic acids (DNA or RNA) found circulating in SERUM; PLASMA; or other BODY FLUIDS.'),
  'D000073890': NtO(MH='Liquid Biopsy', MS='Obtaining material for pathological examination and analysis, from bodily fluids. Material retrieved includes CELL-FREE NUCLEIC ACIDS; CELL-DERIVED MICROPARTICLES; EXOSOMES; CIRCULATING NEOPLASM CELLS; and other circulating cells and CELLULAR STRUCTURES.'),
  'D000073892': NtO(MH='Health Information Interoperability', MS='Automatic and seamless exchange or cross-talk across HEALTH INFORMATION SYSTEMS.'),
  'D000073893': NtO(MH='Sugars', MS='Short chain carbohydrate molecules that have hydroxyl groups attached to each carbon atom unit with the exception of one carbon that has a doubly-bond aldehyde or ketone oxygen. Cyclical sugar molecules are formed when the aldehyde or ketone groups respectively form a hemiacetal or hemiketal bond with one of the hydroxyl carbons. The three dimensional structure of the sugar molecule occurs in a vast array of biological and synthetic classes of specialized compounds including AMINO SUGARS; CARBASUGARS; DEOXY SUGARS; SUGAR ACIDS; SUGAR ALCOHOLS; and SUGAR PHOSPHATES.'),
  'D000073919': NtO(MH='Interdisciplinary Placement', MS='Teaching strategy of shared learning based cross-discipline experiences and placements.'),
  'D000073920': NtO(MH='Cryobiology', MS='The study of biological materials or systems subjected to temperatures below their normal range.'),
  'D000073921': NtO(MH='Child, Foster', MS='Individual who is unable to live safely with his or her family, usually due to abuse or neglect in the family home.'),
  'D000073922': NtO(MH='Child, Adopted', MS='Individual who becomes a child of a family by means of legal action.'),
  'D000073923': NtO(MH='Food Intolerance', MS='Digestive system disorder where a particular food irritates the digestive tract or cannot be properly digested (i.e., due to a lack of a digestive enzyme). It differs from FOOD HYPERSENSITIVITY which is an immune system disorder, usually due to specific proteins in food.  http://my.clevelandclinic.org/health/articles/problem-foods-is-it-an-allergy-or-intolerance.'),
  'D000073924': NtO(MH='Graphic Novels as Topic', MS='Works about book-length narratives told using a combination of words and sequential art, often presented in comic book style.'),
  'D000073930': NtO(MH='Biological Coevolution', MS='The process of reciprocal evolutionary change occurring between pairs of species or among groups of species as they interact.'),
  'D000073931': NtO(MH='Adverse Outcome Pathways', MS='Models connecting initiating events at the cellular and molecular level to population-wide impacts. Computational models may be at levels relating toxicology to adverse effects.'),
  'D000073932': NtO(MH='Food Addiction', MS='A cluster of chemical dependencies to specific foods or food in general in which there develops a physical craving for these foods.'),
  'D000073935': NtO(MH='Narrative Medicine', MS="NARRATION as a tool to collect and interpret information on a patient's experience of illness"),
  'D000073938': NtO(MH='Risk Evaluation and Mitigation', MS='Strategies required by the US Food and Drug Administration (FDA) Amendments Act of 2007 when a question exists as to whether the benefits of a drug outweigh its risks. These constitute a safety plan with several potential components, including a medication guide, a communication plan, elements to ensure safe use and an implementation system to help guide the prescribers, pharmacists and patients.'),
  'D000073939': NtO(MH='Dysferlin', MS='A membrane protein that contains multiple C2 DOMAINS. It is highly expressed in skeletal muscle and functions as a calcium ion sensor in SYNAPTIC VESICLE-PLASMA MEMBRANE fusion, as well as in SARCOLEMMA repair following mechanical stress. Mutations in the dysferlin (DYSF) gene are associated with several hereditary MUSCULAR DYSTROPHIES.'),
  'D000073940': NtO(MH='Transcription Factor 4', MS="A basic helix-loop-helix leucine zipper transcription factor that functions in neuronal CELL DIFFERENTIATION. It dimerizes with other bHLH transcription factors and activates transcription through binding to E-BOX ELEMENTS containing 5'-ACANNTGT-3' or 5'-CCANNTGG-3' sequences. Mutations in the TCF-4 gene are associated with Pitt-Hopkins Syndrome, a severe developmental disorder."),
  'D000073942': NtO(MH='T-Cell Acute Lymphocytic Leukemia Protein 1', MS='A basic helix-loop-helix transcription factor that plays a critical role in HEMATOPOIESIS and as a positive regulator in the differentiation of ERYTHROID CELLS. Chromosome translocations involving the TAL-1 gene are associated with T-CELL ACUTE LYMPHOCYTIC LEUKEMIA.'),
  'D000073943': NtO(MH='Neonicotinoids', MS='A class of insecticides that are structurally similar to NICOTINE and have physiologically similar effects as agonists of NICOTINIC ACETYLCHOLINE RECEPTORS, but are less toxic to vertebrates. They are widely used in agriculture.'),
  'D000073958': NtO(MH='Prescription Drug Monitoring Programs', MS='Programs, usually run by state governments, that require pharmacists to collect and distribute data on the prescription and dispensation of CONTROLLED SUBSTANCES. They are intended to prevent the abuse of such substances by the patient, or their transfer to recreational users and drug dealers.'),
  'D000073978': NtO(MH='Academic Performance', MS='A quantitative or qualitative measure of intellectual, scholarly, or scholastic accomplishment.'),
  'D000073979': NtO(MH='F-Box-WD Repeat-Containing Protein 7', MS='A component of SCF(FBW7) UBIQUITIN LIGASE that contains an F-box motif and multiple WD REPEATS. It recognizes and binds phosphorylated signals in several proteins involved in CELL PROLIFERATION and targets them to the SCF complex for UBIQUITINATION. Targets include CYCLIN E; PROTO-ONCOGENE PROTEINS C-JUN; PROTO-ONCOGENE PROTEINS C-MYC; and JNK MITOGEN-ACTIVATED PROTEIN KINASES.'),
  'D000073999': NtO(MH='Triose Sugar Alcohols', MS='Sugar alcohol molecules that contain three carbons.'),
  'D000074': NtO(MH='Acenocoumarol', MS='A coumarin that is used as an anticoagulant. Its actions and uses are similar to those of WARFARIN. (From Martindale, The Extra Pharmacopoeia, 30th ed, p233)'),
  'D000074001': NtO(MH='Intercellular Adhesion Molecule-3', MS='A membrane glycoprotein and cell adhesion molecule expressed by LEUKOCYTES that contains multiple Ig-like domains. It is a ligand for LFA-1 (integrin alphaLbeta2) and integrin alpha-D/beta-2. Its interaction with LFA-1 may play a role in the PHAGOCYTOSIS of NEUTROPHILS by MACROPHAGES following APOPTOSIS.'),
  'D000074002': NtO(MH='DNA Polymerase gamma', MS='A DNA-directed DNA polymerase that functions in the replication of MITOCHONDRIAL DNA. Mutations in the gene that encodes this enzyme (POLG) are associated with some forms of OPHTHALMOPLEGIA, CHRONIC EXTERNAL PROGRESSIVE.'),
  'D000074008': NtO(MH='MDS1 and EVI1 Complex Locus Protein', MS='A DNA binding protein, transcriptional regulator, and proto-oncogene protein that contains 10 CYS2-HIS2 ZINC FINGERS. It functions as a positive or negative regulator of expression for target genes involved in organism development.'),
  'D000074009': NtO(MH='Tubular Sweat Gland Adenomas', MS='Various tubular forms of benign tumors of the SWEAT GLAND with glandular differentiation. Common types include syringocystadenoma papilliferum of the head and neck, and hidradenoma papilliferum of the vulva area. Hidradenoma papilliferum may be derived from mammary-like glands of the vulva.'),
  'D000074010': NtO(MH='Bone Marrow Stromal Antigen 2', MS='A GPI-linked membrane glycoprotein and antiviral factor that functions as a homodimer. It is induced by INTERFERON-GAMMA and blocks the release of enveloped mammalian viruses by directly tethering nascent VIRAL PARTICLES to the membranes of infected cells.'),
  'D000074011': NtO(MH='Peptide Transporter 1', MS='A proton-coupled symporter that transports OLIGOPEPTIDES and DIPEPTIDES. It localizes to the brush-border membrane of the INTESTINAL EPITHELIUM and plays a critical role in the assimilation of dietary proteins.'),
  'D000074018': NtO(MH='B-Cell CLL-Lymphoma 10 Protein', MS='A signal transducing adaptor protein that contains an N-terminal CARD DOMAIN and functions in the ADAPTIVE IMMUNE RESPONSE. It promotes PRO-CASPASE-9 maturation and APOPTOSIS, activation of NF-KAPPA B, and is a substrate for MALT1 PARACASPASE.'),
  'D000074019': NtO(MH='T-Cell Intracellular Antigen-1', MS="An RNA-binding protein characterized by three RNA RECOGNITION MOTIFS. It binds to AU RICH ELEMENTS in the 3'-untranslated regions of mRNA and regulates alternative pre-RNA splicing and mRNA translation; it may also function in APOPTOSIS. Mutations in the TIA-1 gene are associated with WELANDER DISTAL MYOPATHY."),
  'D000074020': NtO(MH='ATP Binding Cassette Transporter, Subfamily B, Member 11', MS='ATP-binding cassette, subfamily B, protein (P-glycoproteins) that functions in the ATP-dependent secretion of BILE SALTS into the BILE CANALICULI of HEPATOCYTES. Mutations in the ABCB11 gene are associated with progressive familial intrahepatic cholestasis 2 (see CHOLESTASIS, INTRAHEPATIC).'),
  'D000074021': NtO(MH='Interatrial Block', MS="Impaired or delayed impulse conduction between the right and left HEART ATRIA. Advanced interatrial blocks are often associated with arrhythmias (e.g., ATRIAL FLUTTER; and ATRIAL FIBRILLATION), direct conduction block via the Bachmann's bundle and concomitant left atrial enlargement. Syndrome of advanced interatrial block associated with SUPRAVENTRICULAR TACHYCARDIA is referred to as Bayes syndrome."),
  'D000074022': NtO(MH='Anesthesia, Cardiac Procedures', MS='A range of methods used to induce UNCONSCIOUSNESS; ANALGESIA; and MUSCLE RELAXATION during cardiac procedures.'),
  'D000074024': NtO(MH='Immunoturbidimetry', MS='Immunochemical analysis which measures specific target antigen bound to antibody complex. Antibodies in assay form insoluble light scattering immune-aggregates which cause changes in the measured turbidity proportional to the concentration of the antigen.'),
  'D000074025': NtO(MH='TRPA1 Cation Channel', MS='A highly conserved, non-selective TRP cation channel  that contains 14-17 ANKYRIN REPEATS. It functions in cold sensation and NOCICEPTION of endogenous inflammatory factors and volatile irritants. TRPA1 is also activated by CANNABINOIDS and may play a role in sound perception by hair cells of the inner ear.'),
  'D000074026': NtO(MH='Fatty Acid Binding Protein 3', MS='A small cytosolic fatty-acid binding protein that forms a lipid-binding beta-barrel structure and is expressed by CARDIOMYOCYTES and at lower levels in brain tissue. It is released into plasma immediately following cardiac injury and may therefore serve as a useful biomarker for the early detection of MYOCARDIAL INFARCTION.'),
  'D000074039': NtO(MH='Staphylococcus capitis', MS='A COAGULASE-negative species of STAPHYLOCOCCUS found on the skin and MUCOUS MEMBRANE of warm-blooded animals. Similar to STAPHYLOCOCCUS EPIDERMIDIS and STAPHYLOCOCCUS HAEMOLYTICUS, it is a nosocomial pathogen in NICU settings. Subspecies include generally antibiotic susceptible and BIOFILM negative capitis and antibiotic resistant and biofilm positive urealyticus isolates.'),
  'D000074040': NtO(MH='Receptors, Histamine H4', MS='G-Protein-coupled histamine receptors that are expressed primarily in BONE MARROW as well as in peripheral tissues and organs. They are expressed by immune cells that include EOSINOPHILS; T-CELLS; DENDRITIC CELLS; and MAST CELLS.'),
  'D000074041': NtO(MH='Microorganisms, Genetically-Modified', MS='Microorganisms whose GENOME has been altered by GENETIC ENGINEERING.'),
  'D000074042': NtO(MH='Cerebral Intraventricular Hemorrhage', MS='Bleeding within the CEREBRAL VENTRICLES. It is associated with intraventricular trauma, aneurysm, vascular malformations, hypertension and in VERY LOW BIRTH WEIGHT infants.'),
  'D000074043': NtO(MH='Night Eating Syndrome', MS='Little or no appetite for breakfast due to eating more food after dinner than during the meal and eating more than half of daily food intake after dinner hour.'),
  'D000074049': NtO(MH='Cytokine TWEAK', MS='A proteolytically-cleaved membrane glycoprotein and member of the TNF superfamily that is highly expressed in a variety of tissues including heart, pancreas, brain, and peripheral blood lymphocytes. The secreted extracellular form is a weak inducer of APOPTOSIS for some cell types and a ligand for the FN14 RECEPTOR. It mediates activation of NF-KAPPA-B and promotes ANGIOGENESIS and proliferation of ENDOTHELIAL CELLS, as well as expression of cytokines involved in INFLAMMATION.'),
  'D000074050': NtO(MH='TWEAK Receptor', MS='A receptor for TWEAK cytokine that is highly expressed by cells in the heart, placenta, and kidney. It plays a role in ANGIOGENESIS and the proliferation of endothelial cells; it may also modulate cellular adhesion to the extracellular matrix.'),
  'D000074058': NtO(MH='Solute Carrier Family 22 Member 5', MS='A high-affinity, ATP-binding, co-transporter for CARNITINE that is highly expressed in kidney, skeletal muscle, heart, and placental tissues. It transports one sodium ion with one carnitine molecule. It has a lower affinity for other organic cations and transports them independently of sodium. Mutations in the SLC22A5 gene are associated with systemic carnitine deficiency.'),
  'D000074059': NtO(MH='Extracorporeal Shockwave Therapy', MS='A nonsurgical treatment that uses either HIGH-ENERGY SHOCK WAVES or low energy ACOUSTIC WAVES to treat various musculoskeletal conditions (e.g., PLANTAR FASCIITIS; TENNIS ELBOW). A probe placed on the skin conducts the shock waves thereby delivering a mechanical force to the body\xe2\x80\x99s tissues.'),
  'D000074060': NtO(MH='Bronchial Thermoplasty', MS='Thermal destruction of the excess bronchial SMOOTH MUSCLE tissue with heat delivered through a catheter assembly attached to a BRONCHOSCOPE. It is often used to control BRONCHIAL HYPERREACTIVITY in severe ASTHMA for better AIRWAY MANAGEMENT.'),
  'D000074061': NtO(MH='ATP Binding Cassette Transporter, Subfamily D', MS='A sub-family of ATP-binding cassette transporters that localize to the membranes of PEROXISOMES; ENDOPLASMIC RETICULUM; and LYSOSOMES. Members contain a transmembrane domain in their N-terminal half and generally function as homodimers in the transport of LIPIDS; BILE ACIDS; and VITAMIN B12. Mutations in some ABCD transporter genes are associated with PEROXISOMAL DISORDERS.'),
  'D000074062': NtO(MH='Environmental Biomarkers', MS='A factor associated with the well-being of living organisms that is used as a measure of environmental change and or influence. For example, aldehyde dehydrogenase expression in earthworm tissue is used as an indication of heavy metal pollution in soils. Distinguish from BIOMARKERS.'),
  'D000074063': NtO(MH='ATP Binding Cassette Transporter, Subfamily D, Member 1', MS='ATP-binding cassette transporter that functions in the import of long chain (13-21 carbons) and very long chain fatty acids (> 22 carbons), or their acyl-CoA-derivatives, into PEROXISOMES. Mutations in the ABCD1 gene are associated with the X-linked form of ADRENOLEUKODYSTROPHY.'),
  'D000074067': NtO(MH='Conservation of Water Resources', MS='Preservation and or management of WATER RESOURCES especially under conditions of scarce supply.'),
  'D000074079': NtO(MH='Undifferentiated Connective Tissue Diseases', MS='Diseases that exhibit signs and symptoms suggestive of a connective tissue disease that do not fulfill clinical or diagnostic criteria for any one defined disease but overlap with criteria of multiple such diseases. Commonly overlapping diseases include systemic autoimmune connective tissue diseases such as RHEUMATOID ARTHRITIS; SYSTEMIC LUPUS ERYTHEMATOSUS; and SYSTEMIC SCLEROSIS.'),
  'D000074080': NtO(MH='MutS Proteins', MS='DNA repair proteins that include the bacterial MutS DNA mismatch-binding protein and its eukaryotic homologs that function in DNA MISMATCH REPAIR and recombination of DNA during MEIOSIS. MutS has a conserved mismatch recognition domain characterized by GxFxE, or similar AMINO ACID MOTIFS that also occur in eukaryotic homologs such as MSH1, MSH6, and MSH8. All MutS proteins also contain a highly-conserved ATP-binding domain and most have weak ATPase activity.'),
  'D000074081': NtO(MH='MutS Homolog 3 Protein', MS='A MutS homolog protein and component of post-replicative DNA MISMATCH REPAIR. It forms a heterodimer with MUTS HOMOLOG 2 PROTEIN (MSH2) and recognizes large insertion-deletion loops up to 13 nucleotides in length. This directs downstream events such as strand discrimination, excision, and resynthesis.'),
  'D000074082': NtO(MH='Sodium-Hydrogen Exchanger 1', MS='A sodium-hydrogen antiporter expressed by many cell types, especially on the basolateral surfaces of EPITHELIAL CELLS. It functions through an inward sodium ion chemical gradient to eliminate acids (protons) generated by metabolism and regulate intracellular pH. It is highly sensitive to AMILORIDE.'),
  'D000074083': NtO(MH='Sodium-Hydrogen Exchanger 3', MS='A sodium-hydrogen antiporter expressed primarily by EPITHELIAL CELLS in the kidneys, it localizes to the apical membrane of the PROXIMAL KIDNEY TUBULE, where it functions in sodium and water reabsorption and possibly calcium homeostasis.  It also is expressed in heart, brain, and lung tissues and is resistant to AMILORIDE inhibition.'),
  'D000074084': NtO(MH='THP-1 Cells', MS='A human leukemia monocytic cell line derived from a patient with LEUKEMIA, MONOCYTIC, ACUTE. It is used as a model to study the function of MONOCYTES and MACROPHAGES, their signaling pathways, nutrient and drug transport.'),
  'D000074085': NtO(MH='Mice, Knockout, ApoE', MS='Strains of mice that contain genetic disruptions (knockout) of APOLIPOPROTEINS E genes. They are used as models for ATHEROSCLEROSIS research.'),
  'D000074099': NtO(MH='Equivalence Trials as Topic', MS='Works about trials that aim to show a new treatment is no better and no worse than the standard treatment.'),
  'D000074100': NtO(MH='Funeral Homes', MS='Facilities for the preparation of the dead for burial or cremation, for the viewing of the body, and for funeral services.'),
  'D000074101': NtO(MH='Cocaine Smoking', MS='SMOKING of COCAINE.'),
  'D000074121': NtO(MH='Protein Kinase C-theta', MS='A calcium-independent, phospholipid- and diacylglycerol-dependent, protein kinase C subtype that contains an N-terminal C2 DOMAIN and two diacylglycerol-binding ZINC FINGERS. It is expressed primarily by T-LYMPHOCYTES and localizes to IMMUNOLOGICAL SYNAPSES where it regulates downstream signaling for the activation, proliferation, and survival of mature T-cells. It plays a critical role in allergic, autoimmune, and alloimmune responses of TH2 CELLS and TH17 CELLS.'),
  'D000074122': NtO(MH='Short Stature Homeobox Protein', MS='A homeodomain protein that is highly expressed in the nuclei of skeletal muscle, bone marrow, and osteogenic cells and has critical roles in growth and development. Its gene resides within PSEUDOAUTOSOMAL REGION 1 of X and Y chromosomes and mutations are associated with several growth disorders including LERI-WEIL SYNDROME; LANGER MESOMELIC DYSPLASIA; and SHORT STATURE, IDIOPATHIC, X-LINKED.'),
  'D000074141': NtO(MH='Circulating Tumor DNA', MS='DNA released from tumor cells that is found circulating in PLASMA; SERUM; or other BODY FLUIDS.'),
  'D000074161': NtO(MH='Kazal Motifs', MS='Highly conserved protein domains characteristic of SERINE PROTEASE INHIBITORS, KAZAL TYPE. They generally occur as tandem repeats, with each domain consisting of approximately 60 amino acids that form a large extended amino acid chain, two short ALPHA-HELICES, and a three-stranded anti-parallel BETA-SHEET. Kazal-like domains also occur in the extracellular portions of AGRIN.'),
  'D000074162': NtO(MH='Serine Peptidase Inhibitors, Kazal Type', MS='A family of serine peptidase inhibitors that occur in animals, some single-cell eukaryotes, and higher plants. They contain variable numbers of KAZAL MOTIFS and inhibit SERINE ENDOPEPTIDASES such as ACROSIN and TRYPSIN.'),
  'D000074163': NtO(MH='Serine Peptidase Inhibitor Kazal-Type 5', MS='A secreted serine peptidase inhibitor that consists of 15 KAZAL MOTIFS and inhibits KALLIKREINS KLK5, KLK7, and KLK14 as well as TRYPSIN. It plays important roles in protecting MUCOSA against infection and inflammation, and in maintaining the integrity of the skin. Mutations in the SPINK5 gene are associated with NETHERTON SYNDROME.'),
  'D000074164': NtO(MH='Nicotine Chewing Gum', MS='Chewing gum which contains NICOTINE.'),
  'D000074165': NtO(MH='Zinc Finger E-box Binding Homeobox 2', MS="A transcription factor that consists of 8 CYS2-HIS2 ZINC FINGERS flanking a central HOMEOBOX. It binds to the 5'-CACCT-3' DNA sequence located within E-BOX ELEMENTS of many genes essential for embryonic growth and development and regulates their activity; it represses transcription of the E-CADHERIN gene. Mutations in the ZEB2 gene are associated with MOWAT-WILSON SYNDROME."),
  'D000074166': NtO(MH='Circulating MicroRNA', MS='MicroRNAs found in cell-free BODY FLUIDS such as SERUM; PLASMA; SALIVA; OR URINE.'),
  'D000074181': NtO(MH='Spastin', MS='An AAA ATPase that binds and severs MICROTUBULES. It specifically recognizes and cuts polyglutamylated microtubules with short polyglutamate tails to promote reorganization of cellular microtubule arrays and the release of microtubules from the CENTROSOME following nucleation. It is critical for the biogenesis and maintenance of complex microtubule arrays in AXONS; SPINDLE APPARATUS; and CILIA. Mutations in the spastin gene (SPAST) are associated with type 4 of HEREDITARY SPASTIC PARAPLEGIA.'),
  'D000074182': NtO(MH='AAA Domain', MS='An approximately 250 amino acid domain common to AAA ATPases and AAA Proteins. It consists of a highly conserved N-terminal P-Loop ATPase subdomain with an alpha-beta-alpha conformation, and a less-conserved C-terminal subdomain with an all alpha conformation. The N-terminal subdomain includes Walker A and Walker B motifs which function in ATP binding and hydrolysis.'),
  'D000074183': NtO(MH='ATPases Associated with Diverse Cellular Activities', MS='A large highly-conserved family of ATPases with diverse functions in cells that are characterized by the presence of a P-LOOP and a ring shape. They couple the energy generated by ATP hydrolysis to remodeling or mechanical translocation of their target molecules.'),
  'D000074201': NtO(MH='Katanin', MS='An enzyme (AAA ATPase) consisting of the 60 kDa ATPase subunit (p60 subunit A1) which severs MICROTUBULES, and an 80 kDa accessory protein (p80 subunit B1), which targets the enzyme to the CENTROSOME. It releases microtubules from the mitotic SPINDLE POLES to allow depolymerization and poleward motion of chromosomes. It is also a regulator of microtubule dynamics in NEURONAL OUTGROWTH.'),
  'D000074221': NtO(MH='Rumination, Digestive', MS='Regurgitation and re-chewing of previously swallowed food in RUMINANTS.'),
  'D000074222': NtO(MH='Rumination, Cognitive', MS='Obsessive thinking about an idea, situation, or choice.'),
  'D000074241': NtO(MH='Peanut Oil', MS='Oil derived from PEANUTS.'),
  'D000074242': NtO(MH='Sunflower Oil', MS='Oil derived from the seeds of SUNFLOWER plant, Helianthus.'),
  'D000074243': NtO(MH='Immune Reconstitution', MS='Regeneration of normal immune function after immune depleting procedures or infections (e.g., HEMATOPOIETIC STEM CELL TRANSPLANTATION). Delayed and incomplete reconstitution of the ADAPTIVE IMMUNE system in particular involving T-CELLS is associated with increase or relapse of infection.'),
  'D000074261': NtO(MH='Receptors, Enterotoxin', MS='Guanylate cyclase-coupled receptors that bind bacterial ENTEROTOXINS, as well as the endogenous peptides guanylin and uroguanylin. Ligand binding stimulates production of CYCLIC GMP by EPITHELIAL CELLS of the intestinal lumen, altering barrier permeability and mucus secretion. Mutations in the gene (GUCY2C) encoding this receptor are associated with some cases of hereditary diarrhea (Diarrhea 6) and MECONIUM ILEUS.'),
  'D000074262': NtO(MH='Rapeseed Oil', MS='PLANT OILS derived from RAPESEED species known as BRASSICA RAPA.'),
  'D000074263': NtO(MH='Coconut Oil', MS='Oil derived from fruits of the coconut plant, COCOS NUCIFERA.'),
  'D000074264': NtO(MH='Smoking Reduction', MS='A decrease in the incidence and frequency of SMOKING. Smoking reduction differs from SMOKING CESSATION in that the smoker continues to smoke albeit at a lesser frequency without quitting.'),
  'D000074266': NtO(MH='Materials Science', MS='An interdisciplinary study of the microstructure and composition of various materials such as metals, semiconductors, ceramics, and polymers, in relation to their macromolecular physical and chemical properties. Materials science enables the custom creation of new materials with specific properties and uses.'),
  'D000074267': NtO(MH='Organism Hydration Status', MS='Quantitative measure of water or fluids contained in the body of a living organism.'),
  'D000074268': NtO(MH='Guanylyl Cyclase C Agonists', MS='Compunds that bind to and activate GUANYLYL CYCLASE-C RECEPTORS.'),
  'D000074269': NtO(MH='Resonance Frequency Analysis', MS='A non-invasive assessment of the stability of tissue-embedded prosthetic devices such as dental implants.'),
  'D000074270': NtO(MH='Meconium Ileus', MS='Intestinal obstruction caused by congealed MECONIUM in the distal ILEUM and CECUM. It presents shortly after birth as a failure to pass meconium and frequently occurs in infants with CYSTIC FIBROSIS.'),
  'D000074283': NtO(MH='Endothelial Protein C Receptor', MS='A glycosylated transmembrane receptor for PROTEIN C that is highly expressed by endothelial cells on the surface of large blood vessels in the heart and lungs.  It facilitates protein C activation by the THROMBIN and THROMBOMODULIN complex in blood coagulation.'),
  'D000074284': NtO(MH='Periphyton', MS='A complex mixture of organisms (algae, cyanobacteria, heterotrophic microbes, detritus, etc.) clinging on the surfaces of plants and other objects projecting from the bottom sediments of aquatic ecosystems.'),
  'D000074285': NtO(MH='Smokers', MS='Persons with a history or habit of SMOKING.'),
  'D000074286': NtO(MH='Preliminary Data', MS='First-released version of study results in a series of data collection efforts used for the purpose of generating further interest in and or funding of a research study.'),
  'D000074287': NtO(MH='TRPC6 Cation Channel', MS='A non-selective, calcium permeant TRPC cation channel that contains four ANKYRIN REPEATS and is activated by DIACYLGLYCEROL independently of PROTEIN KINASE C. It is expressed in placenta, lung, spleen, ovary and the small intestine, as well as by PODOCYTES in the kidney glomerulus. Mutations in the TRPC6 gene are associated with FOCAL SEGMENTAL GLOMERULOSCLEROSIS type 2.'),
  'D000074288': NtO(MH='Discs Large Homolog 1 Protein', MS='A signaling adaptor protein that contains three PDZ DOMAINS; an SH3 DOMAIN; and a GUANYLATE KINASE-like C-terminal region. It has an essential role in animal development and recruits ion channels, receptors, and signaling molecules to discrete plasma membrane regions of polarized cells in the HEART ATRIA MYOCARDIUM. It functions in the assembly of ADHERENS JUNCTIONS and regulation of CELL PROLIFERATION; synaptogenesis, LYMPHOCYTE ACTIVATION; and controls expression of KV4 POTASSIUM CHANNELS to regulate excitability of CARDIAC MYOCYTES.'),
  'D000074289': NtO(MH='High-Temperature Requirement A Serine Peptidase 1', MS='A secreted serine protease that contains a Kazal domain-like region and a C-terminal PDZ domain. It has a broad range of targets that include EXTRACELLULAR MATRIX PROTEINS; PROTEOGLYCANS; and INSULIN-LIKE GROWTH FACTOR BINDING PROTEINS. Mutations in the HTRA1 gene are associated with AGE-RELATED MACULAR DEGENERATION 7 and Cerebral Autosomal Recessive Arteriopathy with Subcortical Infarcts and Leukoencephalopathy (CARASIL).'),
  'D000074290': NtO(MH='Zinc Finger Protein Gli3', MS="A zinc finger transcription factor that contains five CYS2-HIS2 ZINC FINGERS and binds to the GLI consensus sequence 5'-GGGTGGTC-3'. The full-length protein functions as a transcriptional activator whereas the truncated C-terminal form functions as a transcriptional repressor of the Sonic Hedgehog (Shh) signaling pathway; a balance between these two forms is critical for limb and digit development. GLI3 also plays a critical role in the differentiation and proliferation of CHONDROCYTES."),
  'D000074301': NtO(MH='CD52 Antigen', MS='A small GPI-linked glycoprotein expressed on the surface of normal and malignant B-CELLS; T-CELLS; MONOCYTES; MACROPHAGES; NK CELLS; and GRANULOCYTES. It is expressed densely and without modulation in many malignant T-cell neoplasms and therefore a target for antibody therapies (e.g., ALEMTUZUMAB).'),
  'D000074322': NtO(MH='Antineoplastic Agents, Immunological', MS='Antineoplastic agents containing immunological agents (e.g. MAbs). These pharmacologic preparations inhibit or prevent the proliferation of NEOPLASMS.'),
  'D000074323': NtO(MH='Alemtuzumab', MS='An anti-CD52 ANTIGEN monoclonal antibody used for the treatment of certain types of CD52-positive lymphomas (e.g., CHRONIC LYMPHOCYTIC LEUKEMIA; CUTANEOUS T-CELL LYMPHOMA; and T-CELL LYMPHOMA). Its mode of actions include ANTIBODY-DEPENDENT CELL CYTOTOXICITY.'),
  'D000074324': NtO(MH='Ipilimumab', MS='An anti-CTLA-4 ANTIGEN monoclonal antibody initially indicated for the treatment of certain types of metastatic MELANOMA. Its mode of actions may include blocking of CTLA-4 mediated inhibition of CYTOTOXIC T LYMPHOCYTES, allowing for more efficient destruction of target tumor cells.'),
  'D000074341': NtO(MH='Dietary Exposure', MS='The exposure to potentially harmful factors such as trace heavy metals, chemicals, radiation, or toxins due to FOOD CONTAMINATION including DRINKING WATER contamination.'),
  'D000074361': NtO(MH='Sleep Latency', MS='The time it takes to reach REM SLEEP. It is typically measured by POLYSOMNOGRAPHY or EEG as a part of various sleep pattern tests (e.g., multiple sleep latency test).'),
  'D000074381': NtO(MH='Mass Drug Administration', MS='Administration of a medication to at-risk individuals in a population without individual diagnosis. It is often used in order to treat, control, and/or prevent spread of often endemic DISEASE OUTBREAKS such as NEGLECTED DISEASES in high disease burden areas.'),
  'D000074382': NtO(MH='Greenhouse Gases', MS='Gaseous elements, chemicals that are in the atmosphere that may contribute to GREENHOUSE EFFECT.'),
  'D000074384': NtO(MH='Sexual Health', MS='A state of physical, emotional, mental and social well-being in relation to SEXUALITY, according to the World Health Organization.'),
  'D000074385': NtO(MH='Food Ingredients', MS='Substances included in prepared foods and beverages.'),
  'D000074386': NtO(MH='Gender-Based Violence', MS='Violence based on gender that results in, or is likely to result in, physical, sexual or mental harm or suffering, including threats of such acts, coercion or arbitrary deprivation of liberty, whether occurring in public or in private life. (From www.who.int/topics/gender_based_violence/en/)'),
  'D000074388': NtO(MH='Early Goal-Directed Therapy', MS='Critical care treatment using intensive monitoring and aggressive management of perioperative hemodynamics in high risk patients,'),
  'D000074389': NtO(MH='Therapeutic Index, Drug', MS='The ratio of the dose that produces toxicity to the dose that produces a clinically desired or effective response.'),
  'D000074401': NtO(MH='Peroxins', MS='Proteins that are essential for the assembly of PEROXISOMES. They recognize and transport cytoplasmic proteins that contain PEROXISOMAL TARGETING SIGNALS (PTS) to the peroxisome. Mutations in peroxin (PEX) genes are associated with several PEROXISOMAL DISORDERS.'),
  'D000074402': NtO(MH='Synovectomy', MS='Surgical removal of the SYNOVIAL MEMBRANE.'),
  'D000074403': NtO(MH='Meniscectomy', MS='Surgical incision of a torn MENISCUS.'),
  'D000074404': NtO(MH='Peroxisomal Targeting Signals', MS='Protein sorting signals that target proteins to PEROXISOMES.'),
  'D000074405': NtO(MH='Valosin Containing Protein', MS='A highly-conserved AAA ATPase that functions in the biogenesis of the transitional ENDOPLASMIC RETICULUM and fragmentation and reassembly of the GOLGI APPARATUS during MITOSIS. It also functions in a complex with UFD1L and NPLOC4 proteins to export misfolded ubiquitinated proteins from the endoplasmic reticulum and outer mitochondrial membrane to the cytoplasm for degradation by the PROTEASOME and also plays a role in AUTOPHAGY of ubiquitinated proteins. It occurs in neuronal INCLUSION BODIES from patients with AMYOTROPHIC LATERAL SCLEROSIS and LEWY BODIES from PARKINSON DISEASE patients.'),
  'D000074406': NtO(MH='Mastoidectomy', MS='Surgical removal of the diseased cells from the MASTOID PROCESS. It often involves simultaneous resection and/or repair of the MIDDLE EAR and EAR DRUM in MIDDLE EAR CHOLESTEATOMAS and MASTOIDITIS.'),
  'D000074407': NtO(MH='SAP90-PSD95 Associated Proteins', MS='Proteins expressed at SYNAPSES throughout the brain where they interact with different scaffolding proteins, cytoskeletal proteins, and signaling factors to assemble functional multiprotein complexes.'),
  'D000074408': NtO(MH='Aldo-Keto Reductases', MS='A family of NADPH-dependent oxidoreductases that reduce carbonyl substrates including sugar-aldehydes, KETOSTEROIDS; keto-prostaglandins, and QUINONES. They are monomers of approximately 37 KDa and are characterized by a parallel beta-8 (BETA SHEET)-alpha 8 (ALPHA HELICES)-barrel structure that contains the NADP binding site. This conformation favors aromatic and apolar substrates.'),
  'D000074409': NtO(MH='Carbonyl Reductase (NADPH)', MS='NADPH-dependent reductase that catalyzes the reduction of many carbonyl compounds including QUINONES; PROSTAGLANDINS; and XENOBIOTICS.'),
  'D000074421': NtO(MH='Fermented Foods and Beverages', MS='Foods and beverages that are prepared by using microorganisms to convert their components into various FERMENTATION end products. Some pickled foods are considered fermented foods as their pickling results from the microbial production of LACTIC ACID.'),
  'D000074422': NtO(MH='Aldo-Keto Reductase Family 1 Member C2', MS='Aldo-keto reductase that functions with 5-alpha and 5-beta-steroid reductases to convert steroid hormones into the 3-alpha or 5-alpha and 3-alpha or 5-beta-tetrahydrosteroid, including 5-ALPHA-DIHYDROTESTOSTERONE  to ANDROSTANE-3,17-DIOL. It also binds to BILE ACIDS. Mutations in the AKR1C2 gene are associated with Type 8 DISORDER OF SEX DEVELOPMENT, 46,XY (SRXY8).'),
  'D000074423': NtO(MH='Celastrales', MS='A taxonomic order of plants within the class MAGNOLIOPSIDA, which includes the staff vine.'),
  'D000074424': NtO(MH='Rosanae', MS='A suborder of flowering plants of the class MAGNOLIOPSIDA which comprises two major groups, Eurosids I and II.'),
  'D000074425': NtO(MH='Aldo-Keto Reductase Family 1 Member C3', MS='Aldo-keto reductase that functions as a bi-directional  17 BETA, 20 ALPHA-HYDROXYSTEROID DEHYDROGENASE. It catalyzes the reduction of PROSTAGLANDIN D2 and PROSTAGLANDIN H2, as well as the oxidation of  9alpha,11beta-PGF2 to prostaglandin D2. It can also interconvert estrogens, ANDROGENS; and PROGESTINS between their active forms and inactive metabolites.'),
  'D000074426': NtO(MH='Aldo-Keto Reductase Family 1 member B10', MS='Aldo-keto reductase that functions as an all-trans-retinaldehyde reductase. It also reduces aromatic and aliphatic ALDEHYDES.'),
  'D000074427': NtO(MH='Caryophyllanae', MS='Superorder of dicot plants in the class MAGNOLIOPSIDA.'),
  'D000074428': NtO(MH='Peroxisomal Biogenesis Factor 2', MS='A multi-pass transmembrane protein that contains a C-terminal RING finger domain. It localizes to the PEROXISOME membrane and is essential for peroxisome biogenesis. Mutations in the PEX2 gene are associated with ZELLWEGER SYNDROME and INFANTILE REFSUM DISEASE.'),
  'D000074429': NtO(MH='Candida parapsilosis', MS='A species of MITOSPORIC FUNGI and opportunistic pathogen associated with its ability to form BIOFILMS in catheters and parenteral nutrition IV lines. C. parapsilosis complex includes closely related species C. orthopsilosis; and C. metapsilosis.'),
  'D000074431': NtO(MH='Keratectomy', MS='Surgical excision of a part of the CORNEA.'),
  'D000074432': NtO(MH='Sphincterotomy', MS='Surgical incision of a sphincter.'),
  'D000074433': NtO(MH='Myotomy', MS='Surgical incision of the muscle.'),
  'D000074434': NtO(MH='Heller Myotomy', MS='Surgical incision of the lower esophageal sphincter near the CARDIA often used to treat ESOPHAGEAL ACHALASIA.'),
  'D000074435': NtO(MH='Peroxisome-Targeting Signal 1 Receptor', MS='A cytoplasmic receptor and peroxin that contains a series of TETRATRICOPEPTIDE REPEATS and binds to PEROXISOME TARGETING SIGNAL 1 (SKL-type). It is essential for protein import into PEROXISOMES; mutations in the PEX5 gene are associated with PEROXISOMAL DISORDERS such as ZELLWEGER SYNDROME.'),
  'D000074436': NtO(MH='Tetratricopeptide Repeat', MS='A structural motif present in a variety of proteins that mediates protein-protein interactions and assembly of multiprotein complexes. It consists of 3 to 16 tandem repeats of 34 amino acids, mostly of small and large hydrophobic residues, that form ALPHA-HELIX pairs.'),
  'D000074437': NtO(MH='Peroxisomal Targeting Signal 2 Receptor', MS='A cytoplasmic receptor and peroxin that contains a series of WD40 REPEATS and binds to PEROXISOME TARGETING SIGNAL 2. It is essential for protein import into PEROXISOMES; mutations in the human PEX7 gene are associated with PEROXISOMAL DISORDERS such as Type 1 CHONDRODYSPLASIA PUNCTATA, RHIZOMELIC.'),
  'D000074439': NtO(MH='Political Activism', MS='Active involvement in the political process including promoting, impeding or raising awareness of a certain issue or set of issues.'),
  'D000074440': NtO(MH='Fascism', MS='Political movement which combines nationalism with demands for political and social renewal. Characteristics include militaristic nationalism, belief in a natural social hierarchy and the rule of elites, and the desire to create a \xe2\x80\x9cpeople\xe2\x80\x99s community\xe2\x80\x9d, in which individual interests would be subordinated to the good of the nation. (From www.britannica.com/topic/fascism)'),
  'D000074441': NtO(MH='Involuntary Treatment', MS='Procedures, surgery, or other treatment without consent of person or persons receiving treatment.'),
  'D000074443': NtO(MH='Lysine Acetyltransferase 5', MS='A catalytic subunit of the NuA4 histone acetyltransferase complex that functions in transcriptional activation of genes by acetylation of nucleosomal HISTONES H4 and H2A, altering nucleosome-DNA interactions and interaction of the modified histones with other activating transcription factors. It may control gene expression changes associated with oncogene and proto-oncogene mediated growth induction, tumor suppressor mediated growth arrest; CELL AGING; APOPTOSIS; and DNA REPAIR. It is polyubiquitinated and degraded during HIV-1 infection through its interaction with the viral TAT PROTEIN.'),
  'D000074462': NtO(MH='Positive Regulatory Domain I-Binding Factor 1', MS='A transcriptional repressor protein that contains an N-terminal PR-SET domain, four C-terminal CYS2-HIS2 ZINC FINGERS, and binds the PRDI element in the INTERFERON-BETA gene. It has methyltransferase activity and mediates gene transcription in tissue-specific innate and adaptive immune lymphocyte T-CELLS, repressing expression of proteins that promote exit of these tissue-specific T-cell populations from non-lymphoid organs.'),
  'D000074463': NtO(MH='PR-SET Domains', MS='Highly conserved protein domains of approximately 130 to 140 amino acids. The SET domain was first identified in the Drosophila proteins (S)u(var)3-9, (E)nhancer-of-zeste and (T)rithorax and occurs in other proteins with a variety of functions, including histone-lysine N-methyltransferases. Structurally, it consists of BETA-SHEETS interspersed among loops and turns that result in an "L" shape. The most conserved motifs are a stretch at the C-terminal that contains a strictly conserved tyrosine residue and an adjacent loop that the C-terminal segment passes through to form a "knot". These motifs and especially the tyrosine residue are essential for S-ADENOSYLMETHIONINE binding and catalysis. The PR domain has high homology to the catalytic region of the SET domain and occurs at the N-terminal of PRDM proteins such as PRDM1 PROTEIN.'),
  'D000074482': NtO(MH='Thyroid Nuclear Factor 1', MS='A homeobox protein and transcription factor that localizes to the cell nucleus where it activates expression of thyroid specific genes such as THYROGLOBULIN and the THYROTROPIN RECEPTOR. It is critical for maintaining thyroid tissue in a differentiated state and also plays a role in lung development. Mutations in the NKX2-1 gene are associated with CHOREA, BENIGN HEREDITARY.'),
  'D000074502': NtO(MH='Receptors, Kisspeptin-1', MS='G protein coupled receptors for the C-terminally amidated peptide of KISSPEPTIN-1. KISS1R plays an essential role in sexual development during puberty through its regulation of GONADOTROPIN-released hormones.'),
  'D000074522': NtO(MH='Consumer Health Informatics', MS='The field devoted in Informatics from multiple consumer or patient views.'),
  'D000074523': NtO(MH='Suprachiasmatic Nucleus Neurons', MS='Neurons of the SUPRACHIASMATIC NUCLEUS.'),
  'D000074542': NtO(MH='Solute Carrier Organic Anion Transporter Family Member 1B3', MS='A sodium-independent organic anion transporter that functions in the uptake of various drugs and endogenous compounds including ESTRADIOL; TAUROCHOLATE; LEUKOTRIENE C4; and METHOTREXATE. It also functions in clearing BILE ACIDS and organic anions from the liver. Mutations in the SLCO1B3 gene are associated with Rotor Type HYPERBILIRUBINEMIA.'),
  'D000074562': NtO(MH='Receptor, Notch4', MS='A notch receptor and proto-oncogene protein characterized by a large extracellular domain that consists of 29 EPIDERMAL GROWTH FACTOR  - like repeat sequences (EGF repeats) and five ANKYRIN REPEATS. It functions as a receptor for SERRATE-JAGGED PROTEINS and Delta1 (DLK1) protein to control cell fate determination.'),
  'D000074582': NtO(MH='AAA Proteins', MS='A large, highly conserved and functionally diverse superfamily of NTPases and nucleotide-binding proteins that are characterized by a conserved 200 to 250 amino acid nucleotide-binding and catalytic domain, the AAA+ module. They assemble into hexameric ring complexes that function in the energy-dependent remodeling of macromolecules. Members include ATPASES ASSOCIATED WITH DIVERSE CELLULAR ACTIVITIES.'),
  'D000074583': NtO(MH='Short Chain Dehydrogenase-Reductases', MS='A large family of oxidoreductases that are predominantly NAD- or NADP-dependent and 250 to 350 amino acids in length. They generally consist of two PROTEIN DOMAINS: A catalytic N-terminal domain that binds the substrate, and a C-terminal coenzyme-binding domain.'),
  'D000074584': NtO(MH='WW Domain-Containing Oxidoreductase', MS='A short chain oxidoreductase that contains two N-terminal WW DOMAINS and functions as a tumor suppressor and in APOPTOSIS. It is also required for bone development.'),
  'D000074585': NtO(MH='WW Domains', MS='An approximately 40 amino acid protein domain that occurs in a variety of unrelated proteins and may be repeated up to four times in some proteins. It is characterized by two TRYPTOPHAN residues (WW) about 20 amino acids apart and folds into a stable triple-stranded BETA-SHEET. It binds PROLINE-RICH PROTEIN DOMAINS and PHOSPHOSERINE or PHOSPHOTHREONINE-containing protein domains that occur in many signal-transducing and cytoskeletal proteins such as DYSTROPHIN.'),
  'D000074586': NtO(MH='Remyelination', MS='The reforming of the MYELIN SHEATH around AXONS following loss due to injury or DEMYELINATING DISEASES.'),
  'D000074602': NtO(MH='Smoking Devices', MS='Gadgets, utensils, apparatuses or instruments used for SMOKING.'),
  'D000074604': NtO(MH='Smoking Pipes', MS='Devices used for SMOKING which convey SMOKE directly into the mouth.'),
  'D000074606': NtO(MH='Smoking Prevention', MS='Efforts directed at preventing SMOKING of TOBACCO and non-tobacco products.'),
  'D000074607': NtO(MH='Opium Dependence', MS='Strong physiological and emotional dependence on OPIUM.'),
  'D000074608': NtO(MH='MYND Domains', MS='Zinc finger domains (named for myeloid, Nervy and DEAF-1) that occur in a variety of eukaryotic proteins, including RUNT-RELATED TRANSCRIPTION FACTOR 1 . They are characterized by a cluster of cysteine and histidine residues with conserved spacing that forms the zinc-binding motif and have beta-beta-alpha (see BETA-SHEET and ALPHA-HELIX) topology, similar to LIM domains (see LIM DOMAIN PROTEINS) and RING FINGER DOMAINS. MYND domains function as protein interaction motifs and have affinity for PROLINE-RICH PROTEIN DOMAINS.'),
  'D000074609': NtO(MH='Marijuana Use', MS='Medicinal or recreational utilization of MARIJUANA.'),
  'D000074623': NtO(MH='Dual Oxidases', MS='NADPH oxidases that contain two additional EF HAND MOTIFS and an N-terminal PEROXIDASE domain. They are expressed by THYROCYTES and EPITHELIAL CELLS of the kidney, liver, trachea, lung, and glandular tissues such as the testis, pancreas, and prostate. They are critical for the activity of THYROID PEROXIDASE and play a role in the production of thyroid hormones; they may also have antimicrobial activity through the generation of REACTIVE OXYGEN SPECIES.'),
  'D000074624': NtO(MH='NADPH Oxidase 1', MS='An NADPH oxidase that functions as a voltage-gated proton channel expressed by PHAGOCYTES, especially in the colon. It regulates intracellular pH, generates SUPEROXIDES upon activation by PHAGOCYTOSIS, and may play a role in INNATE IMMUNITY.'),
  'D000074642': NtO(MH='Nephrolithotomy, Percutaneous', MS="Surgical removal of large KIDNEY CALCULI by means of a percutaneous nephroscope which is passed into the KIDNEY PELVIS through a track created in the patient's back."),
  'D000074643': NtO(MH='Nephrotomy', MS='Surgical incision into any part of the kidney.'),
  'D000074662': NtO(MH='NADPH Oxidase 2', MS='An NADPH oxidase that is expressed by PHAGOCYTES where it transfers electrons across the plasma membrane from cytosolic NADPH to molecular oxygen on the exterior. It regulates proton (H+) flux into resting phagocytes to control intracellular pH. Mutations in the CYBB gene are associated with X-LINKED CHRONIC GRANULOMATOUS DISEASE.'),
  'D000074663': NtO(MH='NADPH Oxidase 4', MS='An NADPH oxidase that is strongly expressed in the kidney. It forms a complex with CYBA-P22PHOX and produces intracellular SUPEROXIDES that may regulate cellular signaling in APOPTOSIS; BONE RESORPTION; and NF-KAPPA B activation.'),
  'D000074664': NtO(MH='NADPH Oxidase 5', MS='An NADPH oxidase that contains four EF HANDS and is expressed primarily by SPERMATOCYTES and LYMPHOCYTES, as well as by endothelial cells. It functions as a calcium-dependent proton channel to generate SUPEROXIDES that regulate cell growth, APOPTOSIS; and PHYSIOLOGIC ANGIOGENESIS.'),
  'D000074682': NtO(MH='Nephroureterectomy', MS='Surgical removal of a kidney and adjoining ureter.'),
  'D000074702': NtO(MH='Proteostasis', MS='Regulation of the concentration, folding, interactions, and cellular localization of each of the proteins that comprise the PROTEOME.'),
  'D000074703': NtO(MH='Nematocera', MS='A suborder of insects which belong to the order DIPTERA. They include mosca, mosquito, gnats, black flies, true flies and long-horned flies.'),
  'D000074704': NtO(MH='Quasispecies', MS='Variations among a population of a given species due to errors in replication of the genome that result in a distribution of non-identical members.'),
  'D000074705': NtO(MH='Human Genetics', MS='The scientific study of inherited human variation.'),
  'D000074706': NtO(MH='Sublimation, Chemical', MS='The process of solids transforming into a gaseous state or vice versa, without passing through a liquid state.'),
  'D000074707': NtO(MH='Campylobacterales', MS='Gram negative microaerophilic bacteria of the phylum PROTEOBACTERIA, class  EPSILONPROTEOBACTERIA.'),
  'D000074722': NtO(MH='Lateral Internal Sphincterotomy', MS='Surgical incision of the INTERNAL ANAL SPHINCTER typically in the treatment of FISSURE IN ANO; chronic ANAL FISSURE and FECAL INCONTINENCE.'),
  'D000074723': NtO(MH='Oncogene Addiction', MS='The dependence of tumor cells on a single oncogenic pathway or protein for their continued proliferation and survival.'),
  'D000074742': NtO(MH='Median Arcuate Ligament Syndrome', MS='Compression of the CELIAC ARTERY by the median arcuate ligament, a fibrous band of the DIAPHRAGM, causing abdominal pain after eating and weight loss. OMIM: 116870'),
  'D000074743': NtO(MH='Hemodynamic Monitoring', MS='Continuous measurement of the movement and forces of blood in the CARDIOVASCULAR SYSTEM.'),
  'D000074744': NtO(MH='ADP-Ribosylation', MS='Post-translational modification of proteins with ADENOSINE DIPHOSPHATE RIBOSE.'),
  'D000074745': NtO(MH='Pterygota', MS='A subclass of winged insects belonging to the class Insecta.'),
  'D000074746': NtO(MH='Neoptera', MS='Modern insects belonging to the subclass PTERYGOTA, Many have the ability to fold their wings with exceptions being butterflies, moths, and a few others within the group.'),
  'D000074747': NtO(MH='Poly ADP Ribosylation', MS='Post-translational modification of proteins with POLY ADENOSINE DIPHOSPHATE RIBOSE.'),
  'D000074748': NtO(MH='Holometabola', MS='A superorder of insects within the NEOPTERA that go through metamorphosis from egg to larva, pupa, and adult stages. Orders of MOSQUITOES; BEES; BUTTERFLIES; and FLEAS belong to this group.'),
  'D000074749': NtO(MH='Deubiquitinating Enzyme CYLD', MS='A deubiquitinase and tumor-suppressor protein that specifically cleaves LYSINE-63-linked polyubiquitin chains and also has endodeubiquitinase activity. It functions to regulate NF-KAPPA B and WNT SIGNALING PATHWAY activity, contributing to cell survival, proliferation, and differentiation. Mutations in the CYLD gene are associated with cases of FAMILIAL CYLINDROMATOSIS.'),
  'D000074762': NtO(MH='Aeromonadales', MS='An order of Gram-negative bacteria in the class GAMMAPROTEOBACTERIA, phylum PROTEOBACTERIA, which include important pathogens.'),
  'D000074764': NtO(MH='Alethinophidia', MS='An infraorder of snakes in the order Serpentes that includes all snakes except blind snakes and thread snakes.'),
  'D000074765': NtO(MH='Dysbindin', MS='A dystrophin-associated protein and component of the Biogenesis of Lysosomal Organelles Complex-1 (BLOC-1 complex) which is essential for the formation of LYSOSOME - derived organelles such as platelet dense granules and MELANOSOMES. DTNBP1 is expressed primarily in the brain and neurons, where it functions with ADAPTOR PROTEIN COMPLEX 3 to transport membrane proteins to NEURITES and nerve terminals. It also regulates the release of neurotransmitters, transport of synaptic vesicles, and localization of DOPAMINE D2 RECEPTORS. Mutations in the DTNBP1 gene are associated with Type 7 HERMANSKY-PUDLAK SYNDROME and SCHIZOPHRENIA.'),
  'D000074766': NtO(MH='Dipsacales', MS='An order of dicotyledonous flowering plants which includes six families. It is best known for its ornamental plants such as LONICERA (honeysuckle), VIBURNUM (arrowwood and guelder rose), and SCABIOSA (scabious, or pincushion flower).'),
  'D000074767': NtO(MH='Diapause', MS='A period of arrested growth or development in animals that is triggered by external conditions, such as length of day, extreme temperatures, or reduced food availability. It can occur at the embryonic, larval, pupal, or adult stage, depending on the species.'),
  'D000074822': NtO(MH='Treatment Adherence and Compliance', MS='Extent to which the patient follows prescribed treatment such as keeping APPOINTMENTS AND SCHEDULES and MEDICATION ADHERENCE for desired therapeutic outcome. It implies active responsibility shared by patient and health care providers.'),
  'D000074823': NtO(MH='One Health', MS='An integrative effort of multiple disciplines working collaboratively and locally, nationally, and globally in all aspects of health care for humans, animals, and the environment.'),
  'D000074824': NtO(MH='Work Engagement', MS='Extent to which members of a workplace perceive their emotional commitment to and involvement in the organization and its goals.'),
  'D000074842': NtO(MH='Forkhead Box Protein L2', MS='A forkhead box transcription factor that is expressed in the developing eyelid and during very early development of the gonad, prior to sex determination. It is essential for development of the ovary and inhibits SOX9 TRANSCRIPTION FACTOR to prevent differentiation to testes. It also induces APOPTOSIS in ovarian cells. Mutations in the FOXL2 gene are associated with BLEPHAROPHIMOSIS; Ptosis, and Epicanthus inversus (BPES with ovarian failure).'),
  'D000074868': NtO(MH='Salpingo-oophorectomy', MS='Combined surgical resection of the fallopian tube and the ovary.'),
  'D000074882': NtO(MH='Pyloromyotomy', MS='Surgical incision of the PYLORUS used to treat pyloric stenoses (e.g. INFANTILE HYPERTROPHIC PYLORIC STENOSIS).'),
  'D000074883': NtO(MH='Vulvectomy', MS='Surgical resection of the VULVA.'),
  'D000074884': NtO(MH='Mucosa-Associated Lymphoid Tissue Lymphoma Translocation 1 Protein', MS='A caspase-like cysteine endopeptidase that also exhibits ubiquitin ligase activity. It contains an N-terminal DEATH DOMAIN, two IMMUNOGLOBULIN-LIKE DOMAINS, and localizes to the perinuclear region of MONOCYTES, where it functions in activation of NF-KAPPA B; it also binds to and activates TRAF6. Chromosomal translocations involving the MALT1 and BIRC2 genes are associated with MALT LYMPHOMA, and mutations in the MALT1 gene are associated with Type 12 IMMUNODEFICIENCY SYNDROMES.'),
  'D000074885': NtO(MH='Amniotomy', MS='A method of inducing labor by deliberate rupture of the AMNION to cause the release of amniotic fluid.'),
  'D000074923': NtO(MH='High-Temperature Requirement A Serine Peptidase 2', MS='A serine peptidase that contains a C-terminal PDZ domain. It localizes to the mitochondrial membrane and intermembrane space, translocating to the cytoplasm following APOPTOSIS stimuli, such as UV irradiation; it promotes cell death by binding to and inhibiting INHIBITOR OF APOPTOSIS PROTEINS, resulting in an increase in activity of CASPASES. Mutations in the HTRA2 gene are associated with Type 13 PARKINSON DISEASE.'),
  'D000074924': NtO(MH='Nut and Peanut Hypersensitivity', MS='Allergic reaction to tree nuts and peanuts, including other LEGUMES, that is triggered by the immune system. It includes co-sensitization to other food (e.g., sesame seed).'),
  'D000074962': NtO(MH='Kounis Syndrome', MS='A disorder of cardiac function secondary to hypersensitivity reactions. It is characterized by coexistence of acute coronary syndromes and cardiac MAST CELL and PLATELET ACTIVATION. It may be induced by exposure to drugs (e.g., antibiotics, anesthetics, contrast media), food, and environmental triggers (e.g., insect bites and stings, poison ivy).'),
  'D000074982': NtO(MH='Palaeoptera', MS='Infraclass of ancient winged insects belonging to the subclass PTERYGOTA.'),
  'D000075': NtO(MH='Acepromazine', MS='A phenothiazine that is used in the treatment of PSYCHOSES.'),
  'D000075002': NtO(MH='Bestrophins', MS='A protein family characterized by a highly conserved N-terminus and four to six transmembrane helices; they function as bicarbonate permeable, calcium-activated chloride channels. Bestrophin-1 (BEST-1) and bestrophin-2 are highly expressed in human RETINAL PIGMENT EPITHELIUM cells and mutations in the BEST-1 gene are associated with VITELLIFORM MACULAR DYSTROPHY, TYPE 2.'),
  'D000075022': NtO(MH='Academic Failure', MS='Student\xe2\x80\x99s unsuccessful attempt at academic achievement or a marked inadequacy in the areas of scholarship or study. This is not underachievement which is performance, usually in school work, poorer than that predicted from aptitude and/or intelligence testing.'),
  'D000075023': NtO(MH='S100 Calcium Binding Protein A7', MS='An S100 calcium binding protein that contains two EF HAND MOTIFS and also binds zinc. It is secreted via a non-classical secretory pathway and expressed by KERATINOCYTES and epithelial cells of the tongue. It has antimicrobial and immunomodulatory activities and is highly expressed in the skin of patients with PSORIASIS, as well as in bladder and skin epithelial carcinomas.'),
  'D000075024': NtO(MH='rhoC GTP-Binding Protein', MS='A rho GTP-binding protein that is prenylated (see PROTEIN PRENYLATION) at its C-terminus and cycles between the cytoplasm and plasma membrane, linking receptor signaling pathways with assembly of FOCAL ADHESIONS; STRESS FIBERS; and contractile ring formation during CYTOKINESIS. It is overexpressed in proliferating and metastatic tumor cells.'),
  'D000075042': NtO(MH='Sustainable Growth', MS='Achievement of an economic system that can continue to grow for the foreseeable future.'),
  'D000075062': NtO(MH='Pre-B-Cell Leukemia Transcription Factor 1', MS="A TALE-type homeodomain protein and transcription factor that binds the DNA sequence 5'-ATCAATCAA-3'. It forms a heterodimer with MEIS1 TRANSCRIPTION FACTOR and functions as a transcriptional activator of HOMEOBOX PROTEIN NKX-2.5 and ELONGIN A, and as a transcriptional repressor of CDKN2B PROTEIN, in the regulation of developmental and morphogenetic processes such as spleen and limb development. Chromosome translocations involving the PBX1 and TCF3 genes occur in cases of pre-B-cell ACUTE LYMPHOID LEUKEMIA."),
  'D000075063': NtO(MH='Lilianae', MS='A superorder of flowering plants (Angiosperms) which includes monocotyledonous plants.'),
  'D000075064': NtO(MH='Myeloid Ecotropic Viral Integration Site 1 Protein', MS='A TALE-type homeodomain protein and transcription factor that functions as a regulator of PAX6 PROTEIN expression and as an activator of PLATELET FACTOR 4 gene expression. It is essential for hematopoiesis, differentiation of MEGAKARYOCYTES, and vascular patterning. It may also have a role in the induction of myeloid leukemias.'),
  'D000075065': NtO(MH='Elongin', MS='A heterotrimeric protein complex composed of 110 kDa elongin A, 18 kDa elongin B, and 15 kDa elongin C subunits. It functions as a positive regulator of RNA POLYMERASE II, increasing its rate of transcriptional elongation by suppressing transient pausing along the DNA template. Elongin A is the transcriptionally active component; elongins B and C enhance its activity.'),
  'D000075066': NtO(MH='Body Packing', MS='Concealing of drugs within the gastrointestinal tract or other body orifice for purposes of DRUG SMUGGLING or to avoid detection by law enforcement. Contraband other than drugs is also sometimes smuggled this way.'),
  'D000075067': NtO(MH='Substance Abuse, Oral', MS='Abuse, overuse, or misuse of a substance by ingestion.'),
  'D000075082': NtO(MH='Proof of Concept Study', MS='An empirical investigation which pertains to the development of prototypes or models that demonstrate the feasibility of novel concepts, ideas, principles, schema or their practical application.'),
  'D000075102': NtO(MH='Organic Cation Transporter 2', MS='Organic cation transporter consisting of twelve transmembrane domains and expressed primarily in the kidney. It transports a wide range of metabolites, drugs, and neurotransmitters from the blood to the KIDNEY TUBULES, including DOPAMINE; SEROTONIN; CHOLINE; and CISPLATIN.'),
  'D000075122': NtO(MH='Smoldering Multiple Myeloma', MS='An asymptomatic and slow-growing PLASMA CELL dyscrasia characterized by presence of MYELOMA PROTEINS and clonal bone marrow plasma cells without end-organ damage (e.g., renal impairment). It is distinguished from MONOCLONAL GAMMOPATHY OF UNDETERMINED SIGNIFICANCE by a much higher risk of progression to symptomatic MULTIPLE MYELOMA.'),
  'D000075142': NtO(MH='RUNX1 Translocation Partner 1 Protein', MS='A transcriptional co-repressor that contains a MYND-type zinc finger (MYND DOMAIN) at its C-terminal and functions as a homo-oligomer. It associates with DNA-binding transcription factors, other repressor proteins, and HISTONE ACETYLTRANSFERASES to repress expression of genes involved in cell growth and differentiation such as MATRIX METALLOPROTEINASE 7 and TCF12. A CHROMOSOMAL TRANSLOCATION involving the RUNX1T1 and CORE BINDING FACTOR ALPHA 2 SUBUNIT (RUNX1) genes frequently occurs in cells of leukemia patients; the resulting fusion protein (AML1-ETO or RUNX1-RUNX1T1) plays a critical role in leukemogenesis.'),
  'D000075162': NtO(MH='Abuse-Deterrent Formulations', MS='Drug formulations or delivery systems intended to discourage the abuse of CONTROLLED SUBSTANCES. These may include physical barriers to prevent chewing or crushing the drug; chemical barriers that prevent extraction of psychoactive ingredients; agonist-antagonist combinations to reduce euphoria associated with abuse; aversion, where controlled substances are combined with others that will produce an unpleasant effect if the patient manipulates the dosage form or exceeds the recommended dose; delivery systems that are resistant to abuse such as implants; or combinations of these methods.'),
  'D000075163': NtO(MH='Metallocenes', MS='Organometallic compounds that generally consist of two cylcopentadiene ANIONS joined in their centers by a metallic cation such as NICKEL; IRON; or TITANIUM.'),
  'D000075182': NtO(MH='Agent Orange', MS='A herbicide that contains equal parts of 2,4-dichlorophenoxyacetic acid (2,4-D) and 2,4,5-trichlorophenoxyacetic acid (2,4,5-T), as well as traces of the contaminant 2,3,7,8-tetrachlorodibenzo-p-dioxin.'),
  'D000075202': NtO(MH='Contraindications', MS='A condition or factor associated with a recipient that makes the use of a drug, procedure, or physical agent improper or inadvisable.  Contraindications may be absolute (life threatening) or relative (higher risk of complications in which benefits may outweigh risks).'),
  'D000075203': NtO(MH='Contraindications, Drug', MS='A condition or factor associated with a recipient that makes the use of a specific drug improper or inadvisable.'),
  'D000075204': NtO(MH='Contraindications, Procedure', MS='A condition or factor associated with a recipient that makes the use of a procedure improper or inadvisable.'),
  'D000075222': NtO(MH='Essential Hypertension', MS='Hypertension that occurs without known cause, or preexisting renal disease. Associated polymorphisms for a number of genes have been identified, including AGT, GNB3, and ECE1. OMIM: 145500'),
  'D000075223': NtO(MH='Poly-ADP-Ribose Binding Proteins', MS='Proteins that contain POLY-ADP RIBOSE BINDING MOTIFS. They include HISTONES and other proteins that function in DNA REPAIR, replication, gene transcription, and APOPTOSIS.'),
  'D000075224': NtO(MH='Cardiac Conduction System Disease', MS='Diseases characterized by pathological irregularities in the HEART CONDUCTION SYSTEM. They may be associated with other heart diseases and syndromes (e.g., BRUGADA SYNDROME; NEUROMUSCULAR DISEASE, HEART BLOCKS), isolated or may result from injuries. You can have a conduction disorder without having an arrhythmia, but some arrhythmias arise from conduction disorders. OMIM: 601144.'),
  'D000075225': NtO(MH='Poly-ADP-Ribose Binding Motif', MS='A protein motif 22 to 26 amino acids in length that binds POLY(ADP RIBOSE) polymers through non-covalent interactions. It is characterized by basic and hydrophobic residues that frequently include ALANINE; VALINE; ISOLEUCINE; or LEUCINE and flank LYSINE and ARGININE amino acids.'),
  'D000075242': NtO(MH='Janus Kinase Inhibitors', MS='Agents that inhibit JANUS KINASES.'),
  'D000075243': NtO(MH='Apolipoproteins M', MS='Apolipoproteins and lipocalins that occur in HIGH-DENSITY LIPOPROTEINS. They bind or transport lipids in the blood including sphingosine-1-phosphate, MYRISTIC ACID; STEARIC ACIDS; and ALL-TRANS-RETINOIC ACID.'),
  'D000075244': NtO(MH='Apelin Receptors', MS='G-protein coupled receptors for APELIN that function in a broad range of physiologic processes including blood pressure regulation and heart contractility. They also have an essential role in early embryo development for GASTRULATION and heart morphogenesis, and can also function as a CD4 co-receptor for HIV-1.'),
  'D000075262': NtO(MH='Hypoadrenocorticism, Familial', MS='Hereditary forms of Addison disease that may exhibit autosomal recessive or X-linked  inheritance. They are characterized by severe neurological symptoms, APNEA;  and death in infancy. OMIM: 240200'),
  'D000075282': NtO(MH='Incivility', MS='Low-intensity deviant behavior with ambiguous intent to harm the target, in violation of norms for mutual respect.'),
  'D000075302': NtO(MH='Connexin 30', MS="A gap junction beta subunit that forms heteromeric hemichannels when paired with alpha subunits such as connexin-40 or CONNEXIN 43. Mutations in the connexin 30 gene (GJ6B) are associated with CLOUSTON'S SYNDROME and some hereditary forms of deafness."),
  'D000075322': NtO(MH='Heavy Metal Poisoning', MS='Poisoning that results from chronic or acute ingestion, injection, inhalation, or skin absorption of HEAVY METALS. Acute and chronic exposures can cause ANEMIA; KIDNEY and LIVER damage; PULMONARY EDEMA; MEMORY LOSS and behavioral changes; bone deformities in children; and MISCARRIAGE or PREMATURE LABOR in pregnant women.'),
  'D000075342': NtO(MH='Animal Scales', MS='Tough, horny, brittle, smooth, striated or plate-like extensions of the stratum corneum or outer layer of the skin. It serves as a protective layer in fishes, reptiles, birds, and mammals.'),
  'D000075362': NtO(MH='Leukocyte Immunoglobulin-like Receptor B1', MS='A receptor for HISTOCOMPATIBILITY ANTIGENS CLASS I that also functions as a receptor for the UL18 protein, an MHC class I homolog expressed by human CYTOMEGALOVIRUS. It consists of four Ig-like C2 domains and is expressed primarily by B-cells and MONOCYTES, as well as DENDRITIC CELLS; its interaction with MHC1 functions to down-regulate the immune response.'),
  'D000075363': NtO(MH='Immunoglobulin Light-chain Amyloidosis', MS='A nonproliferative disorder of the PLASMA CELL characterized by excessive production and misfolding of IMMUNOGLOBULIN LIGHT CHAINS that form insoluble amyloid fibrils (see AMYLOID DEPOSITS) in various tissues. Clinical features include LIVER FAILURE; MULTIPLE MYELOMA; NEPHROTIC SYNDROME; RESTRICTIVE CARDIOMYOPATHY, and neuropathies.'),
  'D000075364': NtO(MH='Deleted in Azoospermia 1 Protein', MS='An RNA recognition motif protein that is essential for SPERMATOGENESIS. It promotes entry of male GERM CELLS to MEIOSIS, possibly by regulating the translation of mRNAs. DAZ1 occurs within a cluster of similar genes on the Y CHROMOSOME that is prone to genetic deletions and duplications. Deletions in these genes, including DAZ1, are associated with AZOOSPERMIA and OLIGOSPERMIA.'),
  'D000075366': NtO(MH='Chemokine CCL18', MS='A CC-type chemokine highly expressed in the lungs, lymph nodes, placenta, and bone marrow; it is also expressed by DENDRITIC CELLS in the GERMINAL CENTER, and peripheral blood MACROPHAGES. It functions as a chemotactic factor that specifically attracts LYMPHOCYTES, especially B-Cells, into lymph node follicles, and naive T-cells towards dendritic cells and activated T-cells. It does not attract MONOCYTES or GRANULOCYTES.'),
  'D000075368': NtO(MH='Anoctamins', MS='A family of transmembrane proteins that function primarily as calcium-activated chloride channels. Structurally, they form a homodimer where each subunit consists of eight transmembrane helices with the N and C terminals exposed to the cytosol. The regions between helices 5 and 7 may be important for ion pore formation and calcium ion binding.'),
  'D000075369': NtO(MH='Anoctamin-1', MS='An anoctamin chloride channel expressed at high levels in the liver, skeletal muscle, and gastrointestinal muscles that functions in transepithelial anion transport and smooth muscle contraction. It is essential for the function of the INTERSTITIAL CELLS OF CAJAL and plays a major role in chloride conduction by airway epithelial cells and in tracheal cartilage development.'),
  'D000075370': NtO(MH='Receptors for Activated C Kinase', MS='Receptors for PROTEIN KINASE C that consist of seven WD40 REPEATS. They function in a wide variety of cellular and physiologic processes including the assembly of signaling complexes, protein translation, cell growth and proliferation, APOPTOSIS, and MUSCARINIC RECEPTOR transport. RACK1 depends on protein kinase C activity to translocate from the perinuclear region to the cell periphery and associates with the plasma membrane through interactions with KERATIN-1 and INTEGRIN BETA-1.'),
  'D000075383': NtO(MH='S100 Calcium Binding Protein A6', MS='An S100 calcium binding protein that contains two EF HAND MOTIFS and plays a role as a calcium sensor and modulator for many cellular processes such as CELL CYCLE progression; CELL MOTILITY and reorganization of the ACTIN CYTOSKELETON. Its expression is induced by growth factors and it is overexpressed in patients with ACUTE MYELOID LEUKEMIA.'),
  'D000075384': NtO(MH='Neuroticism', MS='Personality trait related to tendency to respond to threat, frustration or a loss with negative emotions (e.g., ANGER; ANXIETY; FRUSTRATION; embarrassment and sadness).'),
  'D000075385': NtO(MH='Netrins', MS='A family of extracellular proteins that are related structurally to LAMININ. They function as CHEMOTACTIC FACTORS for CELL MIGRATION and AXON GUIDANCE, acting as chemoattractants for some cell types, and as chemorepellents for others.'),
  'D000075386': NtO(MH='Netrin Receptors', MS='Cell surface receptors that bind NETRINS. They typically contain both IMMUNOGLOBULIN DOMAINS and FIBRONECTIN TYPE III DOMAINS and function to mediate CELL MIGRATION and AXON GUIDANCE.'),
  'D000075387': NtO(MH='Smoking Water Pipes', MS='Pipes for smoking tobacco, cannabis, and other substances, in which smoke is drawn through water. Do not confuse with SMOKING PIPES.'),
  'D000075388': NtO(MH='Netrin-1', MS='A netrin that binds the DCC RECEPTOR or UNC5 receptors, resulting respectively in axon attraction or repulsion. Its interaction with these receptors also prevents APOPTOSIS; it may function as a tumor suppressor protein.'),
  'D000075389': NtO(MH='DCC Receptor', MS='A receptor for NETRIN-1 that contains four membrane distal (N-terminal) Ig-like C2 domains and six membrane proximal (C-terminal) fibronectin type III domains. It is expressed primarily in the nerve axons and differentiated intestinal cells and is required for AXON GUIDANCE, mediating axon attraction of neuronal GROWTH CONES; however, it may also trigger axon repulsion through association with the UNC5 netrin-1 receptor. DCC also induces APOPTOSIS when it is unbound from netrin-1.  Deletions of the DCC gene are observed in tumor metastases and the protein is not expressed in undifferentiated COLORECTAL CARCINOMA cells.'),
  'D000075402': NtO(MH='Channelrhodopsins', MS='A subfamily of rhodopsin proteins that function as light-gated ion channels in GREEN ALGAE.'),
  'D000075403': NtO(MH='Semantic Web', MS='A framework for development and promotion of common data formats and exchange protocols linked in a way that can be read directly by computers. Semantic Web is a platform for sharing and reusing data across application, enterprise, and community boundaries, by linking concepts rather than just documents.'),
  'D000075422': NtO(MH='Anti-Citrullinated Protein Antibodies', MS='Autoantibodies to citrullinated-peptides and proteins.'),
  'D000075423': NtO(MH='Gene Drive Technology', MS='The techniques involved in creating and inserting synthetic selfish genetic elements called gene drives. Gene drives carry a "payload gene" and are designed to increase in frequency in the population over time, eventually to all members of the population.'),
  'D000075442': NtO(MH='Transplantation, Haploidentical', MS='Transplantation between individuals who share a partial haplotype match.'),
  'D000075462': NtO(MH='Serum Albumin, Human', MS='Serum albumin from humans. It is an essential carrier of both endogenous substances, such as fatty acids and BILIRUBIN, and of XENOBITOICS in the blood.'),
  'D000075482': NtO(MH='Bedridden Persons', MS='Persons unable or unwilling, or otherwise incapacitated and not able to leave the bed due to physical or mental conditions.'),
  'D000075485': NtO(MH='Population Health', MS='The health outcomes of a group of individuals, including the distribution of such outcomes within the group. These populations are often geographic regions, such as nations or communities, but they can also be other groups. (From Am J Public Health. 2003 March; 93(3): 380\xe2\x80\x93383)'),
  'D000075522': NtO(MH='Adaptive Clinical Trials as Topic', MS='Works about clinical studies in which a prospectively planned opportunity is included to modify trial designs and hypotheses based on analysis of data from subjects in the study.'),
  'D000075523': NtO(MH='Long-Acting Reversible Contraception', MS='Prevention of CONCEPTION by devices, chemical substances or agents with contraceptive activity in females which last for years and can be removed.'),
  'D000075527': NtO(MH='Prolotherapy', MS='Treatment of MUSCULOSKELETAL PAIN by injecting a substance into a joint space, ligament, or tendon to promote the growth of new tissue.'),
  'D000075528': NtO(MH='Aversive Agents', MS='Chemicals added to pharmacologic preparations, poisonous household goods, and other chemicals to discourage their abuse or consumption.'),
  'D000075529': NtO(MH='Solitary Kidney', MS='Either a single or a single functioning kidney due to NEPHRECTOMY, birth defects or other kidney diseases.'),
  'D000075530': NtO(MH='Organ Motion', MS='Movement of internal organs due to physiological processes.'),
  'D000075542': NtO(MH='Multifocal Intraocular Lenses', MS='Artificially implanted lenses that direct light toward distant and near focal points allowing clear vision for a range of distances.'),
  'D000075562': NtO(MH='Charles Bonnet Syndrome', MS='Repetitive visual hallucinations experienced mostly by elderly with diminished visual acuity or visual field loss, with awareness of the fictional nature of their hallucinations. It is not associated with delusions and other sensory hallucinations.'),
  'D000075563': NtO(MH='Vasopeptidase Inhibitors', MS='A class of cardiovascular drugs indicated for hypertension and congestive heart failure that simultaneously inhibit both NEUTRAL ENDOPEPTIDASE and ANGIOTENSIN CONVERTING ENZYME. They increase the availability of NATRIURETIC PEPTIDES and BRADYKININ and inhibit production of ANGIOTENSIN II.'),
  'D000075602': NtO(MH='Non-Point Source Pollution', MS='Water pollution from a variety of diffuse sources carried over or through the ground and into water sources such as LAKES; RIVERS; WETLANDS; coastal waters; and GROUNDWATER. Such diffuse sources include roadways and parking lots (GASOLINE; HEAVY METALS; and motor oil), lawns or agricultural land (excess FERTILIZERS, livestock excrement, and PESTICIDES), landfill seepage, and construction sites (chemicals and trash used in construction processes).'),
  'D000075662': NtO(MH='Injection Site Reaction', MS='Adverse reactions that occur initially at the site of injection or infusion. Milder type is confined to a local allergic flare reaction. A more severe reaction is caused by extravasation of VESICANTS from the blood vessel at the site of injection and can cause damage to the surrounding tissue. In tumor flare reaction symptoms involve well beyond the injection site such as an increase in the tumor size and tumor markers levels, bone pain, and HYPERCALCEMIA.'),
  'D000075663': NtO(MH='Ion Mobility Spectrometry', MS='Techniques for separation and identification of ionized molecules based on their drift through a gas phase after being accelerated by an electric field. Their mobilities will be effected by their shape, size, and charge.'),
  'D000075665': NtO(MH='Recidivism', MS='Repeated criminal behavior.'),
  'D000075682': NtO(MH='Procrastination', MS='The deferment of actions or tasks to a later time, or to infinity.'),
  'D000075684': NtO(MH='T-Lymphoma Invasion and Metastasis-inducing Protein 1', MS='A Rho guanine nucleotide exchange factor that consists of two pleckstrin homology domains flanking central Ras-binding, Dbl-homology (DH) and PDZ domains. It stimulates GTP-GDP exchange of rho-like GTPases such as RAC1 PROTEIN; CDC42 PROTEIN; and RHOA PROTEIN, and functions to link extracellular signals to remodeling of the CYTOSKELETON for CELL ADHESION and CELL MOVEMENT.'),
  'D000075686': NtO(MH='COP9 Signalosome Complex', MS='A multiprotein complex that functions as a peptide hydrolase, or isopeptidase to cleave NEDD8 PROTEIN from the CULLIN and UBIQUITIN-PROTEIN LIGASES, controlling the activity of the ligases. It is highly conserved in eukaryotes and typically consists of 8 subunits (CSN 1-8 proteins). The COP9 signalosome was originally identified in plants, where it controls gene transcription in response to light.'),
  'D000075687': NtO(MH='NEDD8 Protein', MS='A ubiquitin-like protein that functions in CELL CYCLE regulation and embryogenesis. It is attached covalently to its substrates following activation by the UBIQUITIN-ACTIVATING ENZYME E1-UBA3 enzyme complex. NEDD8 attaches to CULLINS, activating their E3 UBIQUITIN LIGASE activity, to promote polyubiquitination and degradation of CYCLINS and regulatory proteins'),
  'D000075702': NtO(MH='Nedd4 Ubiquitin Protein Ligases', MS='E3 ubiquitin ligases that consist of four WW DOMAINS. They accept UBIQUITIN from E2 UBIQUITIN-CONJUGATING ENZYME as a thioester via their C-terminal HECT domains and transfer it specifically to the 63rd LYSINE residue (Lys-63) of target proteins. NEDD4 targets include many proteins and receptors with important functions for cell growth and homeostasis such as VEGFR-2; FGFR1 TYROSINE KINASE; and ERBB-4 RECEPTOR. They play a critical role in the internalization of these receptors, their degradation by LYSOSOMES, and also function as part of the ESCRT complex in VIRUS RELEASE.'),
  'D000075703': NtO(MH='Zinc Transporter 8', MS='A zinc efflux transporter highly expressed by ISLET CELLS of the pancreas. It functions in the accumulation of zinc in intracellular vesicles and may be involved in INSULIN maturation and storage processes. Variations in the SLC30A8 gene are associated with susceptibility to DIABETES MELLITUS, TYPE 2.'),
  'D000075704': NtO(MH='Toxin-Antitoxin Systems', MS='Mechanisms that allow bacteria and archaea to rapidly adapt to changing environmental conditions via a toxin, produced during adverse conditions, that inhibits a specific vital process, and a partner antitoxin that blocks the effects of the toxin, under normal growth conditions.'),
  'D000075722': NtO(MH='Promyelocytic Leukemia Zinc Finger Protein', MS='A Kruppel-type transcription factor consisting of an N-terminal BTB DOMAIN and nine CYS2-HIS2 ZINC FINGERS. It localizes to the nucleus and regulates cell cycle progression and gene expression for tissue development and homeostasis; it may also function as an epigenetic regulator through its interactions with HISTONE DEACETYLASE. Genetic rearrangements involving the ZBTB16 gene are associated with ACUTE PROMYELOCYTIC LEUKEMIA.'),
  'D000075723': NtO(MH='Kruppel-Like Factor 6', MS='A Kruppel-like transcription factor that contains three C-terminal CYS2-HIS2 ZINC FINGERS and binds to GC RICH SEQUENCE (GC box) in upstream gene promoters. It functions as a transcriptional activator, tumor suppressor, and may regulate growth and development of B-cells.'),
  'D000075742': NtO(MH='Expression of Concern', MS='A notification about the integrity of a published article that is typically written by an editor and should be labelled prominently in the item title. It is the responsibility of the editor to initiate appropriate investigative procedures, discover the outcome of the investigation, and notify readers of that outcome in a subsequent published item. The outcome may require the publication of a retraction notice.'),
  'D000075743': NtO(MH='Chemokine CXCL16', MS='A CXCR6 receptor-binding chemokine that functions as a scavenger receptor for oxidized low density lipoprotein (OxLDL) when expressed by MACROPHAGES. Its secreted, or cytokine form induces a strong chemotactic response for MONOCYTES when it is expressed by DENDRITIC CELLS.'),
  'D000075744': NtO(MH='Receptors, CXCR6', MS='CXCR receptors that are specific for CHEMOKINE CXCL16. They are expressed by lymphoid tissues, activated T-cells, and also function as co-receptors for SIMIAN IMMUNODEFICIENCY VIRUSES; HIV-2; and HIV-1 infection of MACROPHAGES.'),
  'D000075745': NtO(MH='rab27 GTP-Binding Proteins', MS='GTP-binding proteins associated with membranes, MELANOSOMES; LYSOSOMES; and late ENDOSOMES. They play a role in the release of cytotoxic SECRETORY GRANULES from lymphocytes and are required for granule maturation, as well as granule docking and priming at IMMUNOLOGICAL SYNAPSES.'),
  'D000075746': NtO(MH='Zinc Finger Protein Gli2', MS='A transcriptional activator that contains five adjacent CYS2-HIS2 ZINC FINGERS. It functions in the hedgehog signaling pathway and is required for normal embryonic development. Mutations in the GLI2 gene are associated with type 9 HOLOPROSENCEPHALY and type 2 PALLISTER-HALL SYNDROME.'),
  'D000075747': NtO(MH='Baculoviral IAP Repeat-Containing 3 Protein', MS='A regulator of APOPTOSIS that functions as an E3 ubiquitin protein ligase. It contains three baculoviral IAP repeats in its N-terminal half, a CARD DOMAIN, and a RING finger domain at its C-terminus. It is highly expressed in fetal lung and kidney, and adult lymphoid tissues such as spleen, thymus, and peripheral blood lymphocytes. It functions in INFLAMMATION signaling, the INNATE IMMUNE RESPONSE, cell growth and proliferation, and metastasis of tumor cells.'),
  'D000075762': NtO(MH='Interdisciplinary Research', MS='Research combining mastery in distinct fields or disciplines that apply and exchange tools, concepts, ideas, data methods, or results around a common project.'),
  'D000075764': NtO(MH='Involuntary Fertility Control', MS="Behavior that interferes with a woman's autonomous reproductive decision-making."),
  'D000075782': NtO(MH='Cell Phone Use', MS='Utilization of wireless phones for communication.'),
  'D000075802': NtO(MH='Angiopoietin-like Proteins', MS='A family of proteins that is structurally similar to ANGIOPOIETINS but do not bind angiopoietin receptors. They are characterized by an amino-terminal coiled-coil domain, a linker region, and a carboxy-terminal FIBRINOGEN-like domain with the exception of ANGPTL8, which lacks the fibrinogen-like domain. They function in a variety of developmental and physiological processes, including INFLAMMATION, lipid metabolism, hematopoietic stem cell activity, and cancer metastasis.'),
  'D000075803': NtO(MH='Angiopoietin-like 4 Protein', MS='A secreted angiopoietin-like protein expressed under hypoxic conditions by ENDOTHELIAL CELLS. It inhibits cell proliferation, cell migration, and tubule formation; the inactive form accumulates in the endothelial EXTRACELLULAR MATRIX, reducing vascular leakage. ANGPTL4 has direct roles in regulating glucose and lipid metabolism, as well as INSULIN SENSITIVITY, and may also function as a regulator of angiogenesis and tumorigenesis.'),
  'D000075804': NtO(MH='Zinc Finger Nucleases', MS='Genetically engineered nucleases that cleave DNA at a defined distance from specific DNA sequences recognized by ZINC FINGER DNA-BINDING DOMAINS. They are composed of a DNA cleaving domain adapted from DNA endonucleases fused to a zinc finger DNA-binding domain.'),
  'D000075862': NtO(MH='Science in the Arts', MS='Depiction of scientific issues or themes via the arts including visual, oral, or written forms of expression.'),
  'D000075863': NtO(MH='Science in Literature', MS='Literary works whose subject matter is science or about the profession of science and related areas.'),
  'D000075884': NtO(MH='Indochina', MS='Area in Southeastern Asia that comprises CAMBODIA, LAOS, and VIETNAM.'),
  'D000075902': NtO(MH='Clinical Deterioration', MS='A critical disease progression, often measured by a set of clinical parameters, which activates HOSPITAL RAPID RESPONSE TEAM.'),
  'D000075906': NtO(MH='Chemokine CCL26', MS='A C-C chemokine expressed by all tissues that functions as a chemoattractant for EOSINOPHILS and BASOPHILS. It binds to the CCR3 RECEPTOR.'),
  'D000075923': NtO(MH='Wildfires', MS='Fires that occur outdoors in the natural environment caused by natural forces or human activity.'),
  'D000075924': NtO(MH='X-linked Nuclear Protein', MS='ATP-dependent DNA helicase that contains two N-terminal ZINC FINGERS and C-terminal ATP-binding and helicase domains. It functions in the regulation of gene transcription and CHROMATIN REMODELING. ATRX undergoes cell-cycle dependent phosphorylation, which causes it to translocate from the NUCLEAR MATRIX to CHROMATIN; thus, it may change its role from gene regulation during INTERPHASE to ensuring proper chromosome segregation at MITOSIS. Mutations in the ATRX gene are associated with cases of X-LINKED MENTAL RETARDATION co-morbid with ALPHA-THALASSEMIA (ATRX syndrome).'),
  'D000075925': NtO(MH='PHD Zinc Fingers', MS='Zinc finger domains of approximately 50 to 80 amino acids in length that are characterized by a conserved Cysteine(3)-Histidine-Cysteine(4) amino acid motif which coordinates binding of two zinc ions. They are similar structurally to RING FINGER DOMAINS, with a globular fold topology of two BETA-SHEETS and an ALPHA-HELIX. PHD fingers occur in many proteins that function in chromatin-mediated gene expression and EPIGENETICS such as POLYCOMB-GROUP PROTEINS.'),
  'D000075926': NtO(MH='FERM Domains', MS='Widely occuring protein domains that function to link signaling and CYTOSKELETAL PROTEINS to the PLASMA MEMBRANE. They occur mostly at the N-terminal region of proteins that contain them.'),
  'D000075927': NtO(MH='KRIT1 Protein', MS='A microtubule-associated protein consisting of four ANKYRIN REPEATS and a C-terminal FERM DOMAIN. It links the CYTOSKELETON to CELL JUNCTIONS via integrin cytoplasmic domain-associated protein-1 and plays an important role in regulating cell proliferation and integrity of endothelial cell junctions. It is also involved in REACTIVE OXYGEN SPECIES metabolism. Mutations in the KRIT1 gene are associated with type I CEREBRAL CAVERNOUS MALFORMATIONS.'),
  'D000075942': NtO(MH='Intraepithelial Lymphocytes', MS='T Lymphocytes with limited diversity of receptors (e.g., ALPHA E INTEGRINS) in the epidermis of the skin and the mucosal linings. They recognize common microbes via T-CELL RECEPTORS and PATHOGEN-ASSOCIATED MOLECULAR PATTERN MOLECULES and function as effector cells for INNATE IMMUNITY. Activation of intraepithelial lymphocytes is a marker for various gastrointestinal diseases (e.g., CELIAC DISEASE; HAIRY CELL LEUKEMIA; and ENTEROPATHY-ASSOCIATED T-CELL LYMPHOMA).'),
  'D000075943': NtO(MH='Apolipoproteins L', MS='A family of apolipoproteins occurring in humans that are structurally similar to B-CELL LEUKEMIA 2 FAMILY PROTEINS. In addition to their roles in cholesterol and lipid transport, they are expressed by MYELOID CELLS and ENDOTHELIAL CELLS during INFLAMMATION and may function to promote CELL DEATH.'),
  'D000075944': NtO(MH='Apolipoprotein L1', MS='An ApoL protein highly expressed by the liver. It has anti-trypanosomal activity through its ability to permeabilize TRYPANOSOMA membranes. Mutations in the APOL1 gene are associated with type 4 FOCAL SEGMENTAL GLOMERULOSCLEROSIS .'),
  'D000075982': NtO(MH='Cell Adhesion Molecule-1', MS='A cell adhesion molecule that contains extracellular immunoglobulin V and C2 domains. It mediates homophilic and heterophilic cell-cell adhesion independently of calcium, and acts as a tumor suppressor in NON-SMALL-CELL LUNG CANCER (NSCLC) cells. Its interaction with NATURAL KILLER CELLS is important for their cytotoxicity and its expression by MAST CELLS plays a role in their interaction with neurons; it may also function in synapse assembly, nerve growth and differentiation.'),
  'D000075983': NtO(MH='Nectins', MS='A family of calcium-independent cell adhesion molecules of the immunoglobulin superfamily. They are expressed by most cell types and mediate both homotypic and heterotypic cell-cell adhesion. Nectins function in a variety of morphogenetic and developmental processes that include organogenesis of the eye, ear, tooth, and cerebral cortex; they also play roles in viral infection and cell proliferation.'),
  'D000076': NtO(MH='Acetabularia', MS='A genus of green algae found in the Mediterranean and other warm seas.'),
  'D000076002': NtO(MH='Hyaluronan Synthases', MS='Membrane-associated glucuronosyltransferases that catalyze the reaction of UDP-N-acetyl-D-glucosamine and UDP-D-glucuronate to produce HYALURONAN. HYALURONAN SYNTHASE 2 (HAS2) is essential for embryogenesis and its expression by tumor cells is associated with metastasis.'),
  'D000076023': NtO(MH='Inhibitor of Growth Protein 1', MS='A nuclear protein and tumor suppressor that contains a C-terminal PHD ZINC FINGER. It is expressed in different isoforms in various tissues and interacts with TUMOR SUPPRESSOR PROTEIN P53 to negatively regulate cell growth. Reduced expression and chromosomal rearrangements of the ING1 gene are associated with different cancers including HEAD AND NECK NEOPLASMS.'),
  'D000076042': NtO(MH='Alcoholic Korsakoff Syndrome', MS='A neurological disorder characterized by inattentiveness and the inability to form short term memories. It is caused by THIAMINE DEFICIENCY due to chronic ALCOHOLISM.'),
  'D000076064': NtO(MH='Drug Misuse', MS='Use of a drug for a purpose not consistent with legal or medical guidelines.'),
  'D000076082': NtO(MH='Travel-Related Illness', MS='Health problems associated with TRAVEL.'),
  'D000076083': NtO(MH='Involuntary Treatment, Psychiatric', MS="Treatment of persons with MENTAL DISORDERS without the persons' consent."),
  'D000076084': NtO(MH='Ubiquitin-Specific Peptidase 7', MS='A ubiquitinyl hydrolase that deubiquitinates several proteins with critical roles in DNA REPAIR, cell growth, and survival, including TUMOR SUPPRESSOR PROTEIN P53; MDM-2 PROTEIN; and PTEN PHOSPHOHYDROLASE. It also stabilizes herpesvirus 1 trans-acting transcriptional protein VMW110 during HSV-1 infection, contributing to its function as a TRANS-ACTIVATOR.'),
  'D000076103': NtO(MH='Biological Variation, Individual', MS='Differences in measurable biological values, characteristics, or traits, within one individual under different conditions for the individual such as fasting, season of the year, age, or state of wellness.'),
  'D000076104': NtO(MH='Oligodendrocyte Transcription Factor 2', MS='A basic helix-loop-helix transcription factor that is required for differentiation of OLIGODENDROCYTES and motor neurons in the spinal cord, and development of somatic motor neurons in the hindbrain.'),
  'D000076105': NtO(MH='X-ray Repair Cross Complementing Protein 1', MS='A poly(ADP)-ribose-binding protein that functions in the rejoining of DNA single-strand breaks that arise following treatment with alkylating agents or ionizing radiation. It interacts with DNA LIGASE III and POLY ADP RIBOSE POLYMERASE in BASE EXCISION REPAIR, and may also function in DNA processing and chromosome recombination in GERM CELLS.'),
  'D000076106': NtO(MH='SAM Domain and HD Domain-Containing Protein 1', MS='A host restriction triphosphorylhydrolase and dNTPase that contains an N-terminal STERILE ALPHA MOTIF and central, conserved ASPARTATE and HISTIDINE (HD) domain. It acts on single-stranded RNA, yielding deoxynucleosides and triphosphate, and functions in anti-viral defense through its dNTPase activity, reducing cellular dNTP levels below what is required for retroviral reverse transcription in DENDRITIC CELLS and MYELOID CELLS. It also has RIBONUCLEASE activity which blocks early replication of retroviruses such as HIV-1. Mutations in the SAMHD1 gene are associated with type 5 Aicardi-Goutieres syndrome (AGS5) and type 2 chilblain LUPUS (CHBL2).'),
  'D000076107': NtO(MH='Diet, High-Protein Low-Carbohydrate', MS='A diet that consists mainly of foods with a high content of protein and limited amounts of CARBOHYDRATES.'),
  'D000076122': NtO(MH='Disks Large Homolog 4 Protein', MS='A neuronal protein consisting of three PDZ DOMAINS, an SH3 DOMAIN, and a C-terminal guanylate kinase-like region (see MAGUK PROTEINS). It localizes to the POST-SYNAPTIC DENSITY and associates with the cytoplasmic tail of NMDA RECEPTORS and SHAKER POTASSIUM CHANNELS, playing a critical role in NMDA receptor-mediated SYNAPTIC PLASTICITY.'),
  'D000076123': NtO(MH='DNA (Cytosine-5-)-Methyltransferase 1', MS='A DNA (cytosine-5-)-methyltransferase that contains a central CxxC type zinc finger motif. It binds poly(ADP)-ribose and its expression is regulated by POLY (ADP-RIBOSE) POLYMERASE-1. DNMT1 methylates CpG residues, with a preference for hemimethylated DNA, and associates with DNA replication sites in S PHASE to maintain the methylation pattern in the newly synthesized strand, which is essential for EPIGENETIC PROCESSES. It also associates with CHROMATIN during G2 PHASE and MITOSIS to maintain DNA methylation independently of replication. It is responsible for maintaining methylation patterns established in development; mutations in the DNMT1 gene are associated with HEREDITARY SENSORY NEUROPATHY TYPE 1 class E.'),
  'D000076142': NtO(MH='Virtual Reality', MS="Using computer technology to create and maintain an environment and project a user's physical presence in that environment allowing the user to interact with it."),
  'D000076144': NtO(MH='Egypt, Ancient', MS='A civilization of ancient Northeastern Africa, concentrated along the lower reaches of the Nile River in the area of Egypt. It was active from 3100 B.C. until its conquest by Alexander the Great in 332 B.C.'),
  'D000076145': NtO(MH='Greece, Ancient', MS='A civilization extant from about 1200 BC. to the death of Alexander the Great, in 323 B.C. It extended from the Greek city states to North Africa and eastward to the Indus River.'),
  'D000076162': NtO(MH='Therapeutic Index', MS='An indicator of the benefits and risks of treatment.'),
  'D000076164': NtO(MH='Fanconi Anemia Complementation Group N Protein', MS='A Fanconi anemia complementation group protein that contains an N-terminal DNA-binding region and seven, C-terminal, WD REPEATS. It is an essential factor in HOMOLOGOUS RECOMBINATION DNA REPAIR through its interactions with BRCA2 PROTEIN; RAD51 RECOMBINASE; and BRCA1 PROTEIN. It functions as a molecular scaffold to localize and stabilize these proteins at homologous recombination sites. Mutations in the PALB2 gene are associated with FANCONI ANEMIA complementation group N; type 3 PANCREATIC NEOPLASMS; and susceptibility to BREAST CANCER.'),
  'D000076182': NtO(MH='Sp7 Transcription Factor', MS='An Sp transcription factor that contains three CYS2-HIS2 ZINC FINGERS. It binds to GC RICH SEQUENCES and performs an essential function in regulating gene expression for differentiation of OSTEOBLASTS. Mutations in the SP7 gene are associated with type 12 OSTEOGENESIS IMPERFECTA.'),
  'D000076183': NtO(MH='Tripartite Motif-Containing Protein 28', MS='A tripartite motif protein consisting of an N-terminal RING finger, two B-box type ZINC FINGERS, and C-terminal PHD domain.  It functions as a transcriptional repressor by associating with Kruppel-association box domain (KRAB domain) transcription factors and has E3-SUMO-ligase activity towards itself and also sumoylates INTERFERON REGULATORY FACTOR-7 to reduce its activity as a transcriptional activator. It can also function as a ubiquitin protein ligase towards TUMOR SUPPRESSOR PROTEIN P53.'),
  'D000076202': NtO(MH='c-Mer Tyrosine Kinase', MS='A receptor tyrosine kinase that transduces signals from EXTRACELLULAR MATRIX to the CYTOPLASM by binding ligands such as GALECTIN 3. It regulates many physiologic processes that include cell survival, migration, differentiation, and PHAGOCYTOSIS of apoptotic cells and ROD PHOTORECEPTORS in the RETINAL PIGMENT EPITHELIUM. Mutations in the MERTK gene are associated with type 38 RETINITIS PIGMENTOSA; it also plays a critical role as an inhibitor of TOLL-LIKE RECEPTORS signaling.'),
  'D000076203': NtO(MH='Animal Fur', MS='Usually densely-packed hairs on the skin of MAMMALS.'),
  'D000076204': NtO(MH='WNK Lysine-Deficient Protein Kinase 1', MS='A serine-threonine kinase which plays an important role in the regulation of electrolyte homeostasis, cell signaling, survival, and proliferation. It functions as an activator and inhibitor of sodium-coupled chloride co-transporters and as an inhibitor of potassium-coupled chloride co-transporters. Mutations in the WNK1 gene are associated with type 2C PSEUDOHYPOALDOSTERONISM and type 2A HEREDITARY SENSORY AND AUTONOMIC NEUROPATHIES.'),
  'D000076205': NtO(MH='Ras Homolog Enriched in Brain Protein', MS='A GTP-binding protein with low intrinsic GTPase activity that activates MTORC1 protein kinase activity.'),
  'D000076206': NtO(MH='Patient Generated Health Data', MS='Health-related data created, recorded, or gathered by patients, family members, or caregivers, to help address a health concern. Distinct from data generated in clinical settings and through encounters with providers.'),
  'D000076207': NtO(MH='Popular Culture', MS='Choices and ways of doing things that predominate or are fashionable among ordinary people in a society during a point in time.'),
  'D000076222': NtO(MH='Mechanistic Target of Rapamycin Complex 1', MS='An evolutionarily conserved multiprotein complex that functions as a cellular energy sensor and regulator of protein synthesis for cell growth and proliferation. It consists of TOR SERINE-THREONINE KINASES; REGULATORY-ASSOCIATED PROTEIN OF MTOR (RAPTOR); MLST8 PROTEIN; and AKT1 substrate 1 protein. The activity of the complex is regulated by SIROLIMUS; INSULIN; GROWTH FACTORS; PHOSPHATIDIC ACIDS; some amino acids or amino acid derivatives, and OXIDATIVE STRESS.'),
  'D000076223': NtO(MH='Regulatory-Associated Protein of mTOR', MS='An adaptor protein component of the MECHANISTIC TARGET OF RAPAMYCIN COMPLEX 1 that forms stoichiometric complexes with TOR KINASES, which it negatively regulates. It functions as a positive regulator of RIBOSOMAL PROTEIN S6 KINASES.'),
  'D000076225': NtO(MH='Mechanistic Target of Rapamycin Complex 2', MS='A multiprotein complex consisting of mTOR KINASE; MLST8 PROTEIN;  rapamycin-insensitive companion of mTOR protein (RICTOR PROTEIN); and PRR5 (proline-rich protein 5). Like mTORC1, it also regulates cell growth and proliferation in response to growth factors but may not be as sensitive to nutrient availability and is insensitive to SIROLIMUS. In contrast to mTORC1, it can regulate the ACTIN CYTOSKELETON through RHO GTPASES to promote the formation of STRESS FIBERS. The mTORC2 complex also plays a critical role in AKT1 PROTEIN KINASE phosphorylation and activation.'),
  'D000076226': NtO(MH='Rapamycin-Insensitive Companion of mTOR Protein', MS='An adaptor protein subunit of MTORC2 COMPLEX. It functions as a structural component and is phosphorylated by RIBOSOMAL PROTEIN S6 KINASES, integrating signals for cell growth and proliferation, especially during embryonic development.'),
  'D000076227': NtO(MH='Stereolithography', MS='A 3D printing technology where a computer-controlled moving laser beam is used to build up the required structure, layer by layer, from liquid POLYMERS that harden on contact with laser light (photopolymerization).'),
  'D000076228': NtO(MH='MRE11 Homologue Protein', MS="A component of the MRN complex along with Rad50 and Nibrin. Together, these perform a critical function in the repair of DOUBLE-STRANDED DNA BREAKS; RECOMBINATIONAL DNA REPAIR; maintenance of TELOMERE integrity and MEIOSIS. MRE11, which contains a poly(ADP)-ribose binding motif and associates with PARP1, possesses single-strand endonuclease activity and double-strand-specific 3'-5' exonuclease activity. Mutations in the MRE11 gene are associated with ATAXIA-TELANGIECTASIA-like disorder 1."),
  'D000076242': NtO(MH='mTOR Associated Protein, LST8 Homolog', MS='An adaptor protein, consisting of seven WD REPEATS along its length, that functions as a component of the MECHANISTIC TARGET OF RAPAMYCIN COMPLEX 1 and mTORC2 COMPLEX. It interacts directly with mTOR to enhance its kinase activity and stabilizes the mTOR-RPTOR PROTEIN interaction in nutrient-poor conditions, favoring RPTOR inhibition of mTOR activity.'),
  'D000076244': NtO(MH='Lepisma', MS='A small nocturnal wingless insect with tapering physical outline.'),
  'D000076245': NtO(MH='Heterogeneous Nuclear Ribonucleoprotein A1', MS='A heterogeneous ribonucleoprotein that contains an RNA-BINDING MOTIF and has poly(ADP)ribose-binding capability. It functions in the packaging of pre-mRNA into hnRNP particles for export to the cytoplasm and may play a role in RNA SPLICING site selection.'),
  'D000076246': NtO(MH='CCCTC-Binding Factor', MS='A repressor protein with poly(ADP)-ribose binding activity that binds CHROMATIN and DNA; its structure consisting of 11 CYS2-HIS2 ZINC FINGERS allows it to recognize many different DNA target sites. It functions as a repressor by binding to INSULATOR ELEMENTS and preventing interaction between promoters and nearby enhancers and silencers. It plays a critical role in EPIGENETIC PROCESSES, including GENOMIC IMPRINTING.'),
  'D000076247': NtO(MH='Centromere Protein A', MS='A 17 kDa, centromeric, poly(ADP)-ribose binding protein that is structurally similar to HISTONE H3 and localizes to NUCLEOSOMES within the CENTROMERE; specifically within the region that binds KINETOCHORES, where it replaces histone H3. It plays a critical role in recruiting kinetochore proteins and progression through MITOSIS, chromosome segregation, and CYTOKINESIS. It also binds sera from patients with some scleroderma-like AUTOIMMUNE DISEASES.'),
  'D000076248': NtO(MH='Sida Plant', MS='A genus of flowering plants in the family of mallows (MALVACEAE). Their common name is fanpetals.'),
  'D000076249': NtO(MH='Heat Shock Transcription Factors', MS="Heat and cold stress-inducible, transcription factors that bind to inverted 5'-NGAAN-3' pentamer DNA sequences and are regulated by poly(ADP) ribosylation. They play essential roles as transcriptional activators of the HEAT-SHOCK RESPONSE by inducing expression of large classes of MOLECULAR CHAPERONES and heat-shock proteins. They also function in DNA REPAIR; transcriptional reactivation of latent HIV-1; and pre-mRNA processing and nuclear export of HSP70 HEAT-SHOCK PROTEINS during heat stress."),
  'D000076250': NtO(MH='Myristoylated Alanine-Rich C Kinase Substrate', MS='A membrane and ACTIN CYTOSKELETON associated, N-terminal myristoylated protein that binds CALMODULIN and is a prominent substrate for PROTEIN KINASE C. Both phosphorylation and poly(ADP)-ribosylation inhibit its F-ACTIN crosslinking activity; phosphorylation also causes MARCKS to relocate from the membrane to cytoplasm.'),
  'D000076251': NtO(MH='Wearable Electronic Devices', MS='Electronic implements worn on  the body as an implant or as an accessory. Examples include wearable diagnostic devices, wearable ACTIVITY TRACKERS, wearable INFUSION PUMPS, wearable computing devices, SENSORY AIDS, and electronic pest repellents.'),
  'D000076263': NtO(MH='Communicable Diseases, Imported', MS='Infectious diseases originating in one geographically delineated ecosystem that are carried (by travel or immigration) to another geographically delineated ecosystem by an infected individual, animal, or disease vector.'),
  'D000076282': NtO(MH='Composting', MS='A process of waste disposal involving the conversion of green waste (i.e. leaves, organic matter, food waste, manure) into soil-enhancing matter.'),
  'D000076302': NtO(MH='Citrullination', MS='Conversion of ARGININE residues in proteins into CITRULLINE residues by PROTEIN-ARGININE DEIMINASES.'),
  'D000076322': NtO(MH='Multimorbidity', MS='The complex interactions of several co-existing diseases.'),
  'D000076342': NtO(MH='Protein-Arginine Deiminases', MS='A family of ENZYMES that, in the presence of calcium ion, converts ARGININE to CITRULLINE in proteins. There are five PAD isotypes in mammals.  In humans: they include PAD1, 2, 3, 4 and 6. They are encoded by five paralogous genes named PADI and clustered on human chromosome 1.'),
  'D000076362': NtO(MH='Adaptive Clinical Trial', MS='Clinical study in which a prospectively planned opportunity is included to modify trial designs and hypotheses based on analysis of data from subjects in the study.'),
  'D000076363': NtO(MH='Academic Success', MS='Level of engagement in educationally purposeful activities, satisfaction, acquisition of desired knowledge, skills, and competencies, persistence and attainment of educational outcomes.'),
  'D000076385': NtO(MH='Diverticular Diseases', MS='Diseases of the DIVERTICULUM often due to infection and/or inflammation (DIVERTICULITIS).'),
  'D000076482': NtO(MH='Daphniphyllum', MS='Broad-leaved evergreen shrub or small tree comprising several species. It is the only genus of the family DAPHNIPHYLLACEAE, class MAGNOLIOPSIDA.'),
  'D000076502': NtO(MH='Sustainable Development', MS='A process of change in which the exploitation of resources, the direction of investments, the orientation of technological development; and institutional change are all in harmony and enhance both current and future potential to meet human needs and aspirations. (http://www.un-documents.net/ocf-02.htm#I)'),
  'D000076522': NtO(MH='Retention in Care', MS="Patient's regular engagement with medical care after initial entry into the system."),
  'D000076542': NtO(MH='Clinical Observation Units', MS='A hospital unit that serves as a dedicated observation area for emergency room patients when a decision to admit or not is unclear. Also known as clinical decision units or short-stay observation units.'),
  'D000076562': NtO(MH='Nurses Improving Care for Health System Elders', MS='Nonprofit programs designed to address the complex needs of older adults and improve outcomes. They provide the principles, education and tools to support healthcare systems in transforming and achieving patient-centered care.'),
  'D000076563': NtO(MH='Mentalization', MS='The mental process by which an individual implicitly and explicitly interprets the actions of self and others as meaningful on the basis of intentional mental states such as personal desires, needs, feelings, beliefs, and reasons.'),
  'D000076602': NtO(MH='Population Health Management', MS='Community engagement, facility management, and organization, access to care that is timely and affordable; the availability of effective services, and high-quality primary health care. (World Health Organization)'),
  'D000076603': NtO(MH='Syndemic', MS='Synergistically-interacting health conditions producing excess disease occurrence in a population.'),
  'D000076604': NtO(MH='Physical Functional Performance', MS=None),
  'D000076605': NtO(MH='Disenfranchised Grief', MS='Expression of grief that society limits or may not allow a person to express. Examples include the grief of parents for stillborn babies, of teachers for the death of students, of nurses for the death of patients, or for the loss of an animal companion. (from APA Dictionary of Psychology, 2nd ed.)'),
  'D000076607': NtO(MH='Saxifragales', MS='Order of dicotyledonous flowering plants consisting of 16 families, 112 genera, and nearly 2,500 species.'),
  'D000076608': NtO(MH='Daphniphyllaceae', MS='Vascular plants of the order SAXIFRAGALES, class MAGNOLIOPSIDA, of which the sole genus is DAPHNIPHYLLUM.'),
  'D000076609': NtO(MH='Brugmansia', MS='A genus of solanaceae that refers to small to mid-size trees with large, strong-smelling, trumpet-shaped flowers hanging downward. Most parts of the plant contain ATROPINE, SCOPOLAMINE HYDROBROMIDE and HYOSCYAMINE.'),
  'D000076610': NtO(MH='Genetic Profile', MS='A set of characteristics unique to the DNA of an individual organism or population obtained by analyzing small samples of biological material such as body tissues or fluids, used especially in the context of predicting susceptibility to a particular disease. For example, some populations have identifiable genetic profiles which put them at higher risk for cancer. Distinguish from GENETIC BACKGROUND and GENETIC VARIATION.'),
  'D000076622': NtO(MH='Malpighiales', MS='Order of flowering plants which includes many tropical species. Well-characterized members include SALICACEAE (willow family), VIOLACEAE (violet family), PASSIFLORACEAE (passion-flower family), EUPHORBIACEAE (spurge or croton family), RHIZOPHORACEAE (mangrove family), and ERYTHROXYLACEAE (coca family).'),
  'D000076623': NtO(MH='Flacourtia', MS='A genus of flowering plants in the family SALICACEAE, order MALPHIGIALES. An example is the willow, also known as salix or saules (French).'),
  'D000076624': NtO(MH='Built Environment', MS="The man-made physical elements of the environment (e.g., homes, buildings, streets, open spaces, and infrastructure). The built environment influences a person's level of physical activity and may have other impacts on health in a community."),
  'D000076625': NtO(MH='Dicentra', MS='A genus of herbaceous plants with asymmetrically-shaped flowers and finely divided leaves, native to east Asia and North America.'),
  'D000076642': NtO(MH='Desulfovibrionales', MS='An order of bacteria within the class DELTAPROTEOBACTERIA, of the phylum PROTEOBACTERIA, which comprises four families.'),
  'D000076643': NtO(MH='Maesa', MS='A genus of flowering plants in the family PRIMULACEAE, order ERICALES.'),
  'D000076644': NtO(MH='Myrsine', MS='A genus of flowering plants in the family PRIMULACEAE, found worldwide but primarily in tropical and subtropical regions.'),
  'D000076662': NtO(MH='Host Microbial Interactions', MS='Interactions between a host and microbe or microbiota.'),
  'D000076663': NtO(MH='Endurance Training', MS='Exercise programs of relatively long duration and moderate intensity, which enhance maximal oxygen uptake, increasing PHYSICAL STAMINA.'),
  'D000076664': NtO(MH='Ranunculales', MS='An order of flowering plants also known as the buttercup family.'),
  'D000076665': NtO(MH='Ventilation-Perfusion Scan', MS='A two-part radionuclide imaging that measures VENTILATION-PERFUSION RATIO of the lungs often used to investigate PULMONARY EMBOLISM. Image acquisitions may be performed using various combinations of gamma camera, PET and SPECT scanning techniques.'),
  'D000076666': NtO(MH='Solanales', MS='An order of flowering plants comprising tropical and temperate species, major crop plants such as potatoes, tomatoes, bell peppers, eggplants, tobacco, and the garden petunia. Its largest family is the SOLANACEAE.'),
  'D000076667': NtO(MH='Austrobaileyales', MS='Order of woody flowering plants which grow as trees and shrubs that include the genera, Illicium and Schisandra.'),
  'D000076682': NtO(MH='Preprints as Topic', MS='Works about scientific manuscripts made available prior to PEER REVIEW.'),
  'D000076702': NtO(MH='International Health Regulations', MS='Regulations to prevent, protect against, control and provide a public health response to the international spread of disease in ways that are commensurate with and restricted to public health risks. (www.who.int/features/qa/39/en)'),
  'D000076722': NtO(MH='Drug Development', MS='The entire process of bringing a new drug to the market. It includes both preclinical and clinical testing, and regulatory approval.'),
  'D000076723': NtO(MH='Negative Results', MS='Subject matter related to research studies in which the data do not demonstrate any clear evidence of effect, especially if an effect was expected.'),
  'D000076724': NtO(MH='Collaborative Cross Mice', MS='Recombinant inbred strains of mice derived from an eight-way cross of eight genetically diverse, founder inbred strains, as a reference population for analyzing MULTIFACTORIAL INHERITANCE.'),
  'D000076742': NtO(MH='Synthetic Drugs', MS='Legal or illegal drugs created using SYNTHETIC CHEMISTRY TECHNIQUES.'),
  'D000076764': NtO(MH='Traffic-Related Pollution', MS='Contamination of the ENVIRONMENT by VEHICLE EMISSIONS.'),
  'D000076782': NtO(MH='Race Factors', MS='A constituent element or influence that could be used in studies for racial disparities as variables such as those related to risk factors and disease and or differential access to services.'),
  'D000076783': NtO(MH='Adverse Childhood Experiences', MS='Deleterious experiences in first 18 years of life.'),
  'D000076822': NtO(MH='Pinealectomy', MS='Surgical removal of the PINEAL GLAND including resection of pineal tumor (PINEALOMA) and CYSTS.'),
  'D000076862': NtO(MH='Diagnostic Screening Programs', MS='Services for the presumptive identification of unrecognized disease in an apparently healthy, asymptomatic population by means of tests, examinations or other procedures that can be applied rapidly and easily to the target population. (from World Health Organization http://www.who.int/cancer/prevention/diagnosis-screening/screening/en/ Oct. 24,2017)'),
  'D000076889': NtO(MH='Gray Literature', MS='Works that include publications such as reports, theses, conference papers, translations and limited circulation government documents which are not normally available through commercial publication sources. (LCSH)'),
  'D000076892': NtO(MH='UNESCO', MS='An operating body of the UNITED NATIONS, responsible for coordinating international cooperation in education, science, culture and communication.'),
  'D000076942': NtO(MH='Preprint', MS='Scientific manuscript made available prior to PEER REVIEW.'),
  'D000076944': NtO(MH='Rickettsiales', MS='Order in class ALPHAPROTEOBACTERIA that are endosymbionts in eukaryotic cells. High morbidity and mortality are frequently associated with Rickettsiales transmitted by INSECT VECTORS.'),
  'D000076962': NtO(MH='Receptors, Chimeric Antigen', MS='Synthetic cellular receptors that reprogram T-LYMPHOCYTES to selectively bind antigens.'),
  'D000076983': NtO(MH='Histone Methyltransferases', MS='Enzymes that catalyze the transfer of methyl groups to LYSINE or ARGININE residues of HISTONES, especially histone H3 and histone H4 proteins. They play a critical role in EPIGENETIC PROCESSES.'),
  'D000076984': NtO(MH='Neonatal Brachial Plexus Palsy', MS='Perinatal nerve injury involving the BRACHIAL PLEXUS involving a weak or paralyzed upper extremity.'),
  'D000076985': NtO(MH='Saporins', MS='Type 1 ribosome-inactivating proteins derived from SAPONARIA OFFICINALIS that function through endohydrolysis of the N-glycosidic bond at single ADENOSINE residues of 28S RIBOSOMAL RNA. They are used as IMMUNOTOXINS.'),
  'D000076987': NtO(MH='CRISPR-Associated Protein 9', MS='An RNA-guided endodeoxyribonuclease that associates with CRISPR SEQUENCES in STREPTOCOCCUS PYOGENES and other bacteria where it participates in an adaptive immune function to cleave foreign DNA complimentary to small GUIDE RNA (sgRNAs). Structurally, Cas9 consists of an ALPHA-HELIX module and a nuclease module connected by a single helix. The nuclease module contains two enzymatic domains: RuvC, which cleaves non-target DNA strand, and an HNH nuclease domain, which cleaves the target strand. Specificity for the DNA target depends on the presence of a protospacer adjacent motif (PAM) sequence, a 2-6 nucleotide DNA sequence immediately following the sequence targeted by Cas9.'),
  'D000076988': NtO(MH='Sulfate Transporters', MS='Highly conserved families of transmembrane anion transporters that occur in both prokaryotes and eukaryotes. In humans, they are expressed by epithelial cells in a variety of tissues and participate in diverse physiologic functions such as cell motility and regulating the composition and acidity of body fluids. Some Slc13 family proteins function as sodium ion-coupled co-transporters of sulfate and other anions.'),
  'D000077': NtO(MH='Acetabulum', MS='The part of the pelvis that comprises the pelvic socket where the head of FEMUR joins to form HIP JOINT (acetabulofemoral joint).'),
  'D000077002': NtO(MH='GRADE Approach', MS='A common, sensible, structured  and transparent approach to grading quality (or certainty) of evidence and strength of recommendations developed by the Grading of Recommendations Assessment, Development and Evaluation (short GRADE) working group.'),
  'D000077003': NtO(MH='Sodium Sulfate Cotransporter', MS='A multi-pass protein that consists of 13 transmembrane helices. It is expressed primarily by renal epithelial cells and functions as a co-transporter of sodium and sulfate, to mediate sulfate reabsorption in the kidney.'),
  'D000077004': NtO(MH='Tuberous Sclerosis Complex 1 Protein', MS='An intracellular signaling and tumor suppressor protein that forms a complex with TUBEROUS SCLEROSIS COMPLEX 2 PROTEIN (TSC2) and other signaling factors to negatively regulate MTORC1 signaling and affect cell growth and proliferation. Structurally, it interacts with TSC2 through its N-terminal, which also contains GSK-3BETA phosphorylation sites and a RHO-KINASE activation domain. It also contains a C-terminal coiled-coil domain and ezrin-radixin-moesin (ERM) domain. Mutations in the TSC1 gene are associated with TUBEROUS SCLEROSIS.'),
  'D000077005': NtO(MH='Tuberous Sclerosis Complex 2 Protein', MS='An intracellular signaling and tumor suppressor protein that forms a complex with TUBEROUS SCLEROSIS COMPLEX 1 PROTEIN (TSC1) and other signaling factors to negatively regulate MTORC1 and affect cell growth and proliferation. It can also function as GTPASE-ACTIVATING PROTEIN (GAP) for RHEB GTPASE to activate mTORC1 independent of its role in the complex. Structurally, it interacts with TSC1 through its N-terminus, which also contains a leucine zipper and coiled-coil region. It also has multiple phosphorylation sites for different cell signaling kinases, a central coiled-coil region, a C-terminal GAP domain and CALMODULIN binding domain. Mutations in the TSC2 gene are associated with TUBEROUS SCLEROSIS.'),
  'D000077022': NtO(MH='Survivin', MS='An apoptosis inhibitory protein that contains a single baculoviral IAP repeat (BIR) domain. It associates with MICROTUBULES and functions to regulate cell proliferation as a component of the chromosome passage protein complex (CPC), performing essential roles for localization of the complex, chromosome alignment, segregation during MITOSIS and CYTOKINESIS, and assembly of the MITOTIC SPINDLE. It is expressed by fetal kidney and liver cells and highly expressed in ADENOCARCINOMA and high-grade LYMPHOMA.'),
  'D000077062': NtO(MH='Burnout, Psychological', MS="An excessive reaction to stress caused by one's environment that may be characterized by feelings of emotional and physical exhaustion, coupled with a sense of frustration and failure."),
  'D000077085': NtO(MH='Birth Setting', MS='Physical setting or location of birth.'),
  'D000077102': NtO(MH='Apium', MS='A genus comprising several species of flowering plants with global distribution in the family APIACEAE.'),
  'D000077105': NtO(MH='Chlorophyceae', MS='A class of green algae in the subdivision CHLOROPHYTINA distinguished by its ultrastructural morphology. Some species have distinct arrangement of flagella.'),
  'D000077107': NtO(MH='Gait Analysis', MS='Determination of the level of functional limitation that may be due to pathology, and evaluating rehabilitative intervention of the way in which the body moves from one point to another. Most often, this is done by walking.'),
  'D000077108': NtO(MH='Public Expenditures', MS='Expenses of public funds incurred by government bodies:  state, regional and local.'),
  'D000077109': NtO(MH='Disability Studies', MS='Interdisciplinary programs of academic study that de-stigmatize disease, illness, and impairment.'),
  'D000077122': NtO(MH='Sugammadex', MS='A gamma-cyclodextrin that functions as a reversal agent for the neuromuscular blocker ROCURONIUM BROMIDE.'),
  'D000077123': NtO(MH='Rocuronium', MS='An androstanol non-depolarizing neuromuscular blocking agent. It has a mono-quaternary structure and is a weaker nicotinic antagonist than PANCURONIUM.'),
  'D000077142': NtO(MH='Malvales', MS='An order of mostly woody plants in the superorder ROSANAE. Members of the MALVALES grow in various habitats around the world.'),
  'D000077143': NtO(MH='Docetaxel', MS='A semisynthetic analog of PACLITAXEL used in the treatment of locally advanced or metastatic BREAST NEOPLASMS and NON-SMALL CELL LUNG CANCER.'),
  'D000077144': NtO(MH='Clopidogrel', MS='A ticlopidine analog and platelet purinergic P2Y receptor antagonist that inhibits adenosine diphosphate-mediated PLATELET AGGREGATION. It is used to prevent THROMBOEMBOLISM in patients with ARTERIAL OCCLUSIVE DISEASES; MYOCARDIAL INFARCTION; STROKE; or ATRIAL FIBRILLATION.'),
  'D000077145': NtO(MH='Sulfanilamide', MS='A short-acting sulfonamide used as an anti-infective agent. It has lower anti-bacterial activity than SULFAMETHOXAZOLE.'),
  'D000077146': NtO(MH='Irinotecan', MS='A semisynthetic camptothecin derivative that inhibits DNA TOPOISOMERASE I to prevent nucleic acid synthesis during S PHASE. It is used as an antineoplastic agent for the treatment of COLORECTAL NEOPLASMS and PANCREATIC NEOPLASMS.'),
  'D000077148': NtO(MH='Myrtales', MS='Order of flowering plants distributed throughout the tropics and warmer regions of the world. The majority of these species belong to two families, Melastomataceae and Myrtaceae. Myrtales includes many trees (notably Eucalyptus), shrubs, such as the classic myrtle, several food, spices, and ornamental plants.'),
  'D000077149': NtO(MH='Sevoflurane', MS='A non-explosive inhalation anesthetic used in the induction and maintenance of general anesthesia. It does not cause respiratory irritation and may also prevent PLATELET AGGREGATION.'),
  'D000077150': NtO(MH='Oxaliplatin', MS='An organoplatinum complex in which the platinum atom is complexed with 1,2-diaminocyclohexane, and with an oxalate ligand which is displaced to yield active oxaliplatin derivatives. These derivatives form inter- and intra-strand DNA crosslinks that inhibit DNA replication and transcription. Oxaliplatin is an antineoplastic agent that is often administered with FLUOROURACIL and FOLINIC ACID in the treatment of metastatic COLORECTAL NEOPLASMS.'),
  'D000077152': NtO(MH='Olanzapine', MS='A benzodiazepine derivative that binds SEROTONIN RECEPTORS; MUSCARINIC RECEPTORS; HISTAMINE H1 RECEPTORS; ADRENERGIC ALPHA-1 RECEPTORS; and DOPAMINE RECEPTORS. It is an antipsychotic agent used in the treatment of SCHIZOPHRENIA; BIPOLAR DISORDER; and MAJOR DEPRESSIVE DISORDER; it may also reduce nausea and vomiting in patients undergoing chemotherapy.'),
  'D000077153': NtO(MH='Progranulins', MS='Cysteine-rich, precursor glycoproteins encoded by the granulin gene (GRN). They contain granulin-repeats separated by linker sequences that are cleaved by a variety of proteases to release the individual GRANULIN PEPTIDES. The mammalian progranulin is composed of a half-granulin repeat followed by 7 granulin repeats. The mammalian GRANULINS are named PARAGRANULIN and granulin 1-7 for their order in the progranulin propeptide. Progranulin has growth-factor like effects and is expressed over a broad range of tissues. Under-expression of progranulin is linked to neurodegenerative diseases including FRONTOTEMPORAL DEMENTIA and NEURONAL CEROID LIPOFUSCINOSIS, while over-expression is linked to metabolic diseases including OBESITY, and INSULIN RESISTANCE.'),
  'D000077154': NtO(MH='Rosiglitazone', MS='A thiazolidinedione that functions as a selective agonist for PPAR GAMMA. It improves INSULIN SENSITIVITY in adipose tissue, skeletal muscle, and the liver of patients with TYPE 2 DIABETES MELLITUS.'),
  'D000077155': NtO(MH='Granulins', MS='Small, cysteine-rich peptides generated by the proteolytic cleavage of progranulin. Granulin peptides are each composed of a granulin-motif, while paragranulin is composed of a half-granulin motif. The mammalian granulins are named granulin 1-7 for their sequence order in the progranulin propeptide, and are alternately named granulin G, F, B, A, C, D, and E; or epithelin 7, 6, 2, 1, 3, 4, and 5, i.e. granulin 1 aka granulin G aka epithelin 7, etc.'),
  'D000077156': NtO(MH='Gefitinib', MS='A selective tyrosine kinase inhibitor for the EPIDERMAL GROWTH FACTOR RECEPTOR (EGFR) that is used for the treatment of locally advanced or metastatic NON-SMALL CELL LUNG CANCER.'),
  'D000077157': NtO(MH='Sorafenib', MS='A niacinamide and phenylurea derivative that inhibits multiple intracellular and cell surface kinases thought to be involved in ANGIOGENESIS, including RAF KINASES and VEGF RECEPTORS. It is used in the treatment of advanced RENAL CELL CARCINOMA and HEPATOCELLULAR CARCINOMA, and for treatment of THYROID CARCINOMA refractory to radioactive iodine therapy.'),
  'D000077162': NtO(MH='Neurolymphomatosis', MS='Infiltration of the nervous system by malignant lymphoma cells.'),
  'D000077182': NtO(MH='Polylactic Acid-Polyglycolic Acid Copolymer', MS='A co-polymer that consists of varying ratios of polylactic acid and polyglycolic acid. It is used as a matrix for drug delivery and for BONE REGENERATION.'),
  'D000077183': NtO(MH='Occlusion Body Matrix Proteins', MS='Proteins that assemble into a crystalline polyhedral or ovicylindrical shape around insect viruses, including BACULOVIRIDAE and CYPOVIRUS.'),
  'D000077185': NtO(MH='Resveratrol', MS='A stilbene and non-flavonoid polyphenol produced by various plants including grapes and blueberries. It has anti-oxidant, anti-inflammatory, cardioprotective, anti-mutagenic, and anti-carcinogenic properties. It also inhibits platelet aggregation and the activity of several DNA HELICASES in vitro.'),
  'D000077190': NtO(MH='Interferon alpha-2', MS='Alpha interferon encoded by the human IFNA2 gene. Recombinant forms are used in the treatment of CHRONIC HEPATITIS B; CHRONIC HEPATITIS C; KAPOSI SARCOMA; MELANOMA; and HAIRY CELL LEUKEMIA.'),
  'D000077191': NtO(MH='Wortmannin', MS='An androstadiene metabolite produced by the fungi PENICILLIUM funiculosum that inhibits PHOSPHATIDYLINOSITOL-3-KINASES and alloantigen-specific activation of T-LYMPHOCYTES in human tumor cell lines. It is widely used in CELL BIOLOGY research and has broad therapeutic potential.'),
  'D000077192': NtO(MH='Adenocarcinoma of Lung', MS='A carcinoma originating in the lung and the most common lung cancer type in never-smokers. Malignant cells exhibit distinct features such as glandular epithelial, or tubular morphology. Mutations in KRAS, EGFR, BRAF, and ERBB2 genes are associated with this cancer.'),
  'D000077194': NtO(MH='Chlorophyll A', MS='A form of chlorophyll that absorbs light in the violet to red spectrum (approximately 400-700 nm wavelength range) and reflects green light (500-570 nm wavelength), which imparts the characteristic green color to land plants. It is essential for oxygenic PHOTOSYNTHESIS.'),
  'D000077195': NtO(MH='Squamous Cell Carcinoma of Head and Neck', MS='The most common type of head and neck carcinoma that originates from cells on the surface of the NASAL CAVITY; MOUTH; PARANASAL SINUSES, SALIVARY GLANDS, and LARYNX. Mutations in TNFRSF10B, PTEN, and ING1 genes are associated with this cancer.'),
  'D000077202': NtO(MH='Dispensatory', MS='Systematic description of the drugs and preparations used generally or in a specific setting.'),
  'D000077203': NtO(MH='Sodium-Glucose Transporter 2 Inhibitors', MS='Compounds that inhibit SODIUM-GLUCOSE TRANSPORTER 2. They lower blood sugar by preventing the reabsorption of glucose by the kidney, and are used in the treatment of TYPE 2 DIABETES MELLITUS.'),
  'D000077204': NtO(MH='Temozolomide', MS='A dacarbazine derivative that is used as an alkylating antineoplastic agent for the treatment of MALIGNANT GLIOMA and MALIGNANT MELANOMA.'),
  'D000077205': NtO(MH='Pioglitazone', MS='A thiazolidinedione and PPAR GAMMA agonist that is used in the treatment of TYPE 2 DIABETES MELLITUS.'),
  'D000077206': NtO(MH='Gabapentin', MS='A cyclohexane-gamma-aminobutyric acid derivative that is used for the treatment of PARTIAL SEIZURES; NEURALGIA; and RESTLESS LEGS SYNDROME.'),
  'D000077207': NtO(MH='Chondrosarcoma, Clear Cell', MS='A chondrosarcoma of adolescence to old age of the proximal EPIPHYSES of long bones. It has variably clear cytoplasm of the mostly neoplastic CHONDROCYTES with little intervening matrix.'),
  'D000077208': NtO(MH='Remifentanil', MS='A piperidine-propionate derivative and opioid analgesic structurally related to FENTANYL. It functions as a short-acting MU OPIOID RECEPTOR agonist, and is used as an analgesic during induction or maintenance of general anesthesia, following surgery, during childbirth, and in mechanically ventilated patients under intensive care.'),
  'D000077209': NtO(MH='Decitabine', MS='An azacitidine derivative and antineoplastic antimetabolite. It inhibits DNA methyltransferase to re-activate silent genes, limiting METASTASIS and NEOPLASM DRUG RESISTANCE. Decitabine is used in the treatment of MYELODISPLASTIC SYNDROMES, and ACUTE MYELOID LEUKEMIA.'),
  'D000077210': NtO(MH='Sunitinib', MS='An indole and pyrrole derivative that inhibits VEGFR-2 and PDGFR BETA RECEPTOR TYROSINE KINASES. It is used as an antineoplastic agent for the treatment of GASTROINTESTINAL STROMAL TUMORS, and for treatment of advanced or metastatic RENAL CELL CARCINOMA.'),
  'D000077211': NtO(MH='Zoledronic Acid', MS='An imidobisphosphonate inhibitor of BONE RESORPTION that is used for the treatment of malignancy-related HYPERCALCEMIA; OSTEITIS DEFORMANS; and OSTEOPOROSIS.'),
  'D000077212': NtO(MH='Ropivacaine', MS='An anilide used as a long-acting local anesthetic. It has a differential blocking effect on sensory and motor neurons.'),
  'D000077213': NtO(MH='Lamotrigine', MS='A phenyltriazine compound, sodium and calcium channel blocker that is used for the treatment of SEIZURES and BIPOLAR DISORDER.'),
  'D000077214': NtO(MH='Becaplermin', MS='A recombinant human platelet-derived growth factor B-chain dimer used to promote WOUND HEALING by stimulating PHYSIOLOGIC ANGIOGENESIS.'),
  'D000077215': NtO(MH='Clay', MS='A naturally-occurring rock or soil constituent characterized by particles with a diameter of less than 0.005 mm. It is composed primarily of hydrous aluminum silicates, trace amounts of metal OXIDES, and organic matter.'),
  'D000077216': NtO(MH='Carcinoma, Ovarian Epithelial', MS='A malignant neoplasm that originates in cells on the surface EPITHELIUM of the ovary and is the most common form of ovarian cancer. There are five histologic subtypes: papillary serous, endometrioid, mucinous, clear cell, and transitional cell. Mutations in BRCA1, OPCML, PRKN, PIK3CA, AKT1, CTNNB1, RRAS2, and CDH1 genes are associated with this cancer.'),
  'D000077221': NtO(MH='Calcitonin Gene-Related Peptide Receptor Antagonists', MS='Pharmacologic agents that block NOCICEPTIVE PAIN signaling from CALCITONIN GENE-RELATED PEPTIDE RECEPTORS. They may be useful for the treatment of pain associated with MIGRAINE DISORDERS and OSTEOARTHRITIS.'),
  'D000077222': NtO(MH='Limonene', MS='A naturally-occurring class of MONOTERPENES which occur as a clear colorless liquid at room temperature. Limonene is the major component in the oil of oranges which has many uses, including as flavor and fragrance. It is recognized as safe in food by the Food and Drug Administration (FDA).'),
  'D000077224': NtO(MH='Cyberbullying', MS='Bullying that takes place over digital devices like cell phones and computers. It includes sending, posting, or sharing negative, harmful, false, or mean content about someone else. It can include sharing personal or private information about someone else causing embarrassment or humiliation. (from https://www.stopbullying.gov)'),
  'D000077228': NtO(MH='Caspian Sea', MS='The largest inland body of water, located between ASIA and EUROPE.'),
  'D000077230': NtO(MH='Internet Access', MS='Ability to connect to the INTERNET and access services available there.'),
  'D000077235': NtO(MH='Vinorelbine', MS='A vinca alkaloid related to VINBLASTINE that is used as a first-line treatment for NON-SMALL CELL LUNG CANCER, or for advanced or metastatic BREAST CANCER refractory to treatment with ANTHRACYCLINES.'),
  'D000077236': NtO(MH='Topiramate', MS='A sulfamate-substituted fructose analog that was originally identified as a hypoglycemic agent. It is used for the treatment of EPILEPSY and MIGRAINE DISORDERS, and may also promote weight loss.'),
  'D000077237': NtO(MH='Arsenic Trioxide', MS='An inorganic compound with the chemical formula As2O3 that is used for the treatment of ACUTE PROMYELOCYTIC LEUKEMIA in patients who have relapsed from, or are resistant to, conventional drug therapy.'),
  'D000077239': NtO(MH='Meloxicam', MS='A benzothiazine and thiazole derivative that acts as a NSAID and cyclooxygenase-2 (COX-2) inhibitor. It is used in the treatment of RHEUMATOID ARTHRITIS; OSTEOARTHRITIS; and ANKYLOSING SPONDYLITIS.'),
  'D000077250': NtO(MH='Calcium Aluminosilicate', MS='Aluminosilicate salts of calcium, the most common of which are CaAl2Si2O8 and Ca2Al2SiO7; a naturally occurring form in CLAY may be used to treat DIARRHEA.'),
  'D000077252': NtO(MH='Dialectical Behavior Therapy', MS='A flexible, stage-based therapy that combines principles of behavior therapy, cognitive behavior therapy, and MINDFULNESS. It concurrently promotes acceptance and change, especially with difficult-to-treat patients.'),
  'D000077253': NtO(MH='Online Social Networking', MS='Connectivity facilitated by computer-based communications among persons with family, work, or other common interests.'),
  'D000077260': NtO(MH='Sleepiness', MS='Compelling urge to sleep.'),
  'D000077261': NtO(MH='Carvedilol', MS='A carbazole and propanol derivative that acts as a non-cardioselective beta blocker and vasodilator. It has blocking activity for ALPHA 1 ADRENERGIC RECEPTORS and, at higher doses, may function as a blocker of CALCIUM CHANNELS; it also has antioxidant properties. Carvedilol is used in the treatment of HYPERTENSION; ANGINA PECTORIS; and HEART FAILURE. It can also reduce the risk of death following MYOCARDIAL INFARCTION.'),
  'D000077262': NtO(MH='Ciona', MS='A genus of SEA SQUIRTS in the family Cionidae.'),
  'D000077264': NtO(MH='Calcium-Regulating Hormones and Agents', MS='Hormones and molecules with calcium-regulating hormone-like actions that modulate OSTEOLYSIS and other extra-skeletal activities to maintain calcium homeostasis.'),
  'D000077265': NtO(MH='Donepezil', MS='An indan and piperidine derivative that acts as a selective and reversible inhibitor of ACETYLCHOLINESTERASE. Donepezil is highly selective for the central nervous system and is used in the management of mild to moderate DEMENTIA in ALZHEIMER DISEASE.'),
  'D000077266': NtO(MH='Moxifloxacin', MS='A fluoroquinolone that acts as an inhibitor of DNA TOPOISOMERASE II and is used as a broad-spectrum antibacterial agent.'),
  'D000077267': NtO(MH='Fulvestrant', MS='An estradiol derivative and estrogen receptor antagonist that is used for the treatment of estrogen receptor-positive, locally advanced or metastatic breast cancer.'),
  'D000077268': NtO(MH='Pamidronate', MS='An aminobisphosphonate that inhibits BONE RESORPTION and is used for the treatment of osteolytic lesions, bone pain, and severe HYPERCALCEMIA associated with malignancies.'),
  'D000077269': NtO(MH='Lenalidomide', MS='A phthalimide and piperidone derivative that has immunomodulatory and antiangiogenic properties. It is used for the treatment of transfusion-dependent anemia in MYELODYSPLASTIC SYNDROMES, and for the treatment of MULTIPLE MYELOMA, and relapsed or refractory MANTLE CELL LYMPHOMA.'),
  'D000077270': NtO(MH='Exenatide', MS='A synthetic form of exendin-4, a 39-amino acid peptide isolated from the venom of the Gila monster lizard (Heloderma suspectum). Exenatide increases CYCLIC AMP levels in pancreatic acinar cells and acts as a GLUCAGON-LIKE PEPTIDE-1 RECEPTOR (GLP-1) agonist and incretin mimetic, enhancing insulin secretion in response to increased glucose levels; it also suppresses inappropriate glucagon secretion and slows gastric emptying. It is used an anti-diabetic and anti-obesity agent.'),
  'D000077271': NtO(MH='Imiquimod', MS='A topically-applied aminoquinoline immune modulator that induces interferon production. It is used in the treatment of external genital and perianal warts, superficial CARCINOMA, BASAL CELL; and ACTINIC KERATOSIS.'),
  'D000077272': NtO(MH='Latent Class Analysis', MS='A statistical algorithm used to analyze clusters of observed variables by constructing categorical unobserved or latent segment based on weighted analysis and the average probabilities. Such latent classes are used to infer variables whose relationships are not directly observed. In biomedical research, it is often used to categorize data that allows the determination of symptom clusters.'),
  'D000077273': NtO(MH='Thyroid Cancer, Papillary', MS='An ADENOCARCINOMA that originates from follicular cells of the THYROID GLAND and accounts for the majority of THYROID CANCER cases. Cells exhibit enlarged, oval, or elongated morphologies with clear, round, nuclei. Fusions of RET, NTRK1, TPM3, and PCM1 genes are associated with this cancer.'),
  'D000077274': NtO(MH='Nasopharyngeal Carcinoma', MS='A carcinoma that originates in the EPITHELIUM of the NASOPHARYNX and includes four subtypes: keratinizing squamous cell, non-keratinizing, basaloid squamous cell, and PAPILLARY ADENOCARCINOMA. It is most prevalent in Southeast Asian populations and is associated with EPSTEIN-BARR VIRUS INFECTIONS. Somatic mutations associated with this cancer have been identified in NPCR, BAP1, UBAP1, ERBB2, ERBB3, MLL2, PIK3CA, KRAS, NRAS, and ARID1A genes.'),
  'D000077275': NtO(MH='Craniofacial Fibrous Dysplasia', MS='Mostly benign fibro-osseous proliferation of the facial bones and skull. It can be either monostotic (localized to a single bone) or polyostotic (localized to more than one bone) type.'),
  'D000077276': NtO(MH='Lycopene', MS='A carotenoid and red pigment produced by tomatoes, other red fruits and vegetables, and photosynthetic algae. It is a key intermediate in the biosynthesis of other carotenoids, and has antioxidant, anti-carcinogenic, radioprotective, and anti-inflammatory properties.'),
  'D000077277': NtO(MH='Esophageal Squamous Cell Carcinoma', MS='A carcinoma that originates usually from cells on the surface of the middle and lower third of the ESOPHAGUS. Tumor cells exhibit typical squamous morphology and form large polypoid lesions. Mutations in RNF6, LZTS1, TGFBR2, DEC1, and WWOX1 genes are associated with this cancer.'),
  'D000077278': NtO(MH='RNA, Mitochondrial', MS='RNA molecules encoded by the MITOCHONDRIAL GENOME.'),
  'D000077279': NtO(MH='Protein Carbamylation', MS='Non-enzymatic addition of carbamoyl (-CONH2) on protein or amino acid functional groups from isocyanic acid or CARBAMOYL-PHOSPHATE. Carbamylation may induce a structural change that results in a functional loss and serves as a biomarker for protein aging and disease pathophysiology.'),
  'D000077280': NtO(MH='Bone-Anchored Prosthesis', MS='A prosthesis designed to attach directly to the bone via fixtures implanted into the bone rather than a socket.'),
  'D000077283': NtO(MH='Forensic Psychology', MS='A specialty in professional psychology characterized by activities primarily intended to provide professional psychological expertise within the judicial and legal systems.'),
  'D000077284': NtO(MH='Abciximab', MS='A Fab fragment of the chimeric monoclonal antibody 7E3 that binds to the glycoprotein IIb-IIIa receptor of human platelets, and blocks PLATELET GLYCOPROTEIN GPIIB-IIIA COMPLEX, potently inhibiting PLATELET AGGREGATION. It is used in treatment of refractory unstable angina, and for prevention of ischemic complications in patients undergoing percutaneous coronary procedures such as ANGIOPLASTY; ATHERECTOMY; or stenting.'),
  'D000077285': NtO(MH='Rimonabant', MS='A pyrazole and piperidine derivative that acts as a selective cannabinoid type-1 receptor (CB1 RECEPTOR) antagonist. It inhibits the proliferation and maturation of ADIPOCYTES, improves lipid and glucose metabolism, and regulates food intake and energy balance. It is used in the management of OBESITY.'),
  'D000077286': NtO(MH='Cetrimonium', MS='Cetyltrimethylammonium compound whose salts and derivatives are used primarily as topical antiseptics.'),
  'D000077287': NtO(MH='Levetiracetam', MS='A pyrrolidinone and acetamide derivative that is used primarily for the treatment of SEIZURES and some movement disorders, and as a nootropic agent.'),
  'D000077288': NtO(MH='Troglitazone', MS='A chroman and thiazolidinedione derivative that acts as a PEROXISOME PROLIFERATOR-ACTIVATED RECEPTORS (PPAR) agonist. It was formerly used in the treatment of TYPE 2 DIABETES MELLITUS, but has been withdrawn due to hepatotoxicity.'),
  'D000077289': NtO(MH='Letrozole', MS='A triazole and benzonitrile derivative that is a selective non-steroidal aromatase inhibitor, similar to ANASTROZOLE. It is used in the treatment of metastatic or locally advanced breast cancer in postmenopausal women.'),
  'D000077290': NtO(MH='Harmala Alkaloids', MS='Structurally-related ALKALOIDS derived from the seeds of PEGANUM HARMALA and other plant sources. They are associated with various pharmacologic and therapeutic effects.'),
  'D000077291': NtO(MH='Terbinafine', MS='A naphthalene derivative that inhibits fungal SQUALENE EPOXIDASE and is used to treat DERMATOMYCOSES of the skin and nails.'),
  'D000077293': NtO(MH='Receptor, Transforming Growth Factor-beta Type I', MS='A transmembrane serine-threonine kinase that forms a heteromeric complex with TYPE II TGF-BETA RECEPTORS to bind TGF-BETA and regulate a variety of physiological and pathological processes including CELL CYCLE ARREST; CELL PROLIFERATION; CELL DIFFERENTIATION; WOUND HEALING; EXTRACELLULAR MATRIX production, immunosuppression and ONCOGENESIS.'),
  'D000077294': NtO(MH='Receptor, Transforming Growth Factor-beta Type II', MS='A transmembrane serine-threonine kinase that forms a heteromeric complex with TYPE I TGF-BETA RECEPTORS when bound to TGF-BETA. This receptor complex regulates a variety of physiological and pathological processes including CELL CYCLE ARREST; CELL PROLIFERATION; CELL DIFFERENTIATION; WOUND HEALING; EXTRACELLULAR MATRIX production, immunosuppression and ONCOGENESIS.'),
  'D000077295': NtO(MH='Urinary Bladder, Underactive', MS='Symptom of underactive detrusor muscle of the URINARY BLADDER that contracts with abnormally reduced strength or duration resulting in an incomplete and/or prolonged bladder emptying.'),
  'D000077296': NtO(MH='Niemann-Pick C1 Protein', MS='A transmembrane intracellular lipid transporter that helps trafficking lipids, particularly cholesterol, from late endosome/lysosome to the ER and plasma membrane. It may also play a role in other cellular cholesterol homeostasis and is an endosomal entry receptor for filoviruses including EBOLAVIRUS. Mutations in the NPC1 are associated with type C NIEMANN-PICK DISEASE.'),
  'D000077297': NtO(MH='Pregnane X Receptor', MS='Steroid receptor that binds and is activated by variety of endogenous compounds and XENOBIOTICS. It binds the response element in promoters of  genes that encode CYTOCHROME P450 3A4 and ATP BINDING CASSETTE TRANSPORTER, SUBFAMILY B, MEMBER 1 proteins, and also activates the transcription of multiple genes involved in the metabolism and secretion of potentially harmful xenobiotics, drugs, and endogenous compounds. It is activated by the antibiotic RIFAMPICIN and various plant metabolites, such as hyperforin, guggulipid, colupulone, and ISOFLAVONES.'),
  'D000077298': NtO(MH='Flexural Strength', MS='The maximum MECHANICAL STRESS that a heterogeneous material, subject to a bending load or flexure, can withstand before fracturing.'),
  'D000077299': NtO(MH='Healthcare-Associated Pneumonia', MS='Infection of the lung often accompanied by inflammation that is acquired through an interaction within a healthcare institution often through a therapeutic experience (e.g., use of catheters or ventilators).'),
  'D000077300': NtO(MH='Bosentan', MS='A sulfonamide and pyrimidine derivative that acts as a dual endothelin receptor antagonist used to manage PULMONARY HYPERTENSION and SYSTEMIC SCLEROSIS.'),
  'D000077310': NtO(MH='Sleep, Slow-Wave', MS='A stage of sleep characterized by synchronized wave activity as observed in the ELECTROENCEPHALOGRAM; the waves exhibit a frequency of 0.5 to 2 Hz, and a peak-to-peak amplitude greater than 75 microvolts.'),
  'D000077314': NtO(MH='Aggressive Driving', MS='Combination of moving traffic offenses so as to endanger other persons or property. (https://nhtsa.gov/Driving-Safety/Aggressive-Driving)'),
  'D000077315': NtO(MH='Road Rage', MS='Extreme anger generated from a traffic incident or accident that leads to an assault with a motor vehicle or other dangerous weapon by the operator or passenger(s) of one motor vehicle on the operator or passenger(s) of another motor vehicle.'),
  'D000077317': NtO(MH='Extracellular Polymeric Substance Matrix', MS='Extracellular matrix formed by secreted polymeric organic compounds by microorganisms. This secreted compound is mostly polysaccharides but may include proteins, lipids, and nucleic acids. The matrix facilitates attachment of microbes to form various BIOFILM communities.'),
  'D000077318': NtO(MH='Density Functional Theory', MS='Density functional theory is an approach to describe the electronic ground state properties of matter.  It is a method of obtaining a solution to the Schrodinger equation for a many-body system, and is used to investigate the structural, magnetic, and electronic properties of molecules and materials.'),
  'D000077319': NtO(MH='Pyrolysis', MS='High temperature decomposition without addition of extra air or oxygen. It yields syngas, bio-oil and bio-char.'),
  'D000077320': NtO(MH='Biomineralization', MS='Process by which living organisms produce MINERALS that accumulate into hardened tissues (e.g., bones, teeth and shells), and cellular nanostructures that sequester away into macromolecules. Biosynthesized minerals include CALCIUM CARBONATE; FLUOROAPATITE; HYDROXYAPATITE; and MAGNETITE.'),
  'D000077321': NtO(MH='Deep Learning', MS='Supervised or unsupervised machine learning methods that use multiple layers of data representations generated by nonlinear transformations, instead of individual task-specific ALGORITHMS, to build and train neural network models.'),
  'D000077322': NtO(MH='Alginic Acid', MS='A polysaccharide and linear copolymer, consisting mainly of beta-1,4-linked D-mannuronic acid and alpha-1,4-linked L-glucuronic acid, that occurs in marine algae such as LAMINARIA, and in BIOFILMS produced by PSEUDOMONAS AERUGINOSA.'),
  'D000077323': NtO(MH='Salt Stress', MS='The condition that results from ion toxicity due to ion imbalances (e.g., excessive Na+ and deficiency in Mg++).'),
  'D000077324': NtO(MH='Crystalloid Solutions', MS="Isotonic solutions of mineral salts, such as RINGER'S LACTATE and SODIUM CHLORIDE (SALINE SOLUTION), used in FLUID THERAPY to rehydrate BLOOD VOLUME."),
  'D000077325': NtO(MH="Ringer's Lactate", MS='A crystalloid solution that contains SODIUM CHLORIDE; SODIUM LACTATE; POTASSIUM CHLORIDE; and CALCIUM CHLORIDE. It is used for FLUID THERAPY.'),
  'D000077329': NtO(MH='Agammaglobulinaemia Tyrosine Kinase', MS='A non-receptor tyrosine kinase that is essential for the development, maturation, and signaling of B-LYMPHOCYTES. It contains an N-terminal zinc finger motif and localizes primarily to the PLASMA MEMBRANE and nucleus of B-lymphocytes. Mutations in the gene that encode this kinase are associated with X-LINKED AGAMMAGLOBULINEMIA.'),
  'D000077330': NtO(MH='Saline Solution', MS='A crystalloid solution that contains 9.0g of SODIUM CHLORIDE per liter of water. It has a variety of uses, including: as a CONTACT LENS SOLUTION, in OPHTHALMIC SOLUTIONS and NASAL LAVAGE, in wound irrigation, and for FLUID THERAPY.'),
  'D000077331': NtO(MH="Ringer's Solution", MS='An isotonic solution; the base contains SODIUM CHLORIDE; POTASSIUM CHLORIDE; and CALCIUM CHLORIDE. Other chemicals, such as SODIUM BICARBONATE or acetate salts may be added, as needed for pH buffering, or as an energy source.'),
  'D000077332': NtO(MH='Artesunate', MS='A water-soluble, semi-synthetic derivative of the sesquiterpene lactone artemisinin with anti-malarial, anti-schistosomiasis, antiviral, and potential anti-neoplastic activities'),
  'D000077333': NtO(MH='Telmisartan', MS='A biphenyl compound and benzimidazole derivative that acts as an angiotensin II type 1 receptor antagonist. It is used in the management of HYPERTENSION.'),
  'D000077334': NtO(MH='Zolpidem', MS='An imidazopyridine derivative and short-acting GABA-A receptor agonist that is used for the treatment of INSOMNIA.'),
  'D000077335': NtO(MH='Desflurane', MS='A fluorinated ether that is used as a volatile anesthetic for maintenance of general anesthesia.'),
  'D000077336': NtO(MH='Caspofungin', MS='A cyclic lipopeptide echinocandin and beta-(1,3)-D-glucan synthase inhibitor that is used to treat internal or systemic MYCOSES.'),
  'D000077337': NtO(MH='Vorinostat', MS='A hydroxamic acid and anilide derivative that acts as a HISTONE DEACETYLASE inhibitor. It is used in the treatment of CUTANEOUS T-CELL LYMPHOMA and SEZARY SYNDROME.'),
  'D000077338': NtO(MH='Latanoprost', MS='A prostaglandin F analog used to treat OCULAR HYPERTENSION in patients with GLAUCOMA.'),
  'D000077339': NtO(MH='Leflunomide', MS='An isoxazole derivative that inhibits dihydroorotate dehydrogenase, the fourth enzyme in the pyrimidine biosynthetic pathway. It is used an immunosuppressive agent in the treatment of RHEUMATOID ARTHRITIS and PSORIATIC ARTHRITIS.'),
  'D000077340': NtO(MH='Fluvastatin', MS='An indole-heptanoic acid derivative that inhibits HMG COA REDUCTASE and is used to treat HYPERCHOLESTEROLEMIA. In contrast to other statins, it does not appear to interact with other drugs that inhibit CYP3A4.'),
  'D000077341': NtO(MH='Lapatinib', MS='A quinazoline derivative that inhibits EPIDERMAL GROWTH FACTOR RECEPTOR and HER2 (RECEPTOR, ERBB-2) tyrosine kinases. It is used for the treatment of advanced or metastatic breast cancer, where tumors overexpress HER2.'),
  'D000077342': NtO(MH='Post-Lyme Disease Syndrome', MS='A condition caused by long-lasting and ongoing infection with the spirochete Borrelia burgdorferi resulting in progressive inflammatory neurologic, neuromuscular, and dermatologic manifestations including ENCEPHALITIS; MYELITIS; acrodermatitis chronica atrophicans; and ARTHRITIS.'),
  'D000077362': NtO(MH='Verteporfin', MS='A benzoporphyrin derivative that is used in PHOTOCHEMOTHERAPY to treat wet type MACULAR DEGENERATION.'),
  'D000077384': NtO(MH='Anastrozole', MS='A nitrile and triazole derivative that acts as a selective nonsteroidal aromatase inhibitor. It is used in the treatment of ESTROGEN NUCLEAR RECEPTOR-positive breast cancer in postmenopausal women.'),
  'D000077385': NtO(MH='Silybin', MS='The major active component of silymarin flavonoids extracted from seeds of the MILK THISTLE, Silybum marianum; it is used in the treatment of HEPATITIS; LIVER CIRRHOSIS; and CHEMICAL AND DRUG INDUCED LIVER INJURY, and has antineoplastic activity; silybins A and B are diastereomers.'),
  'D000077402': NtO(MH='Pantoprazole', MS='2-pyridinylmethylsulfinylbenzimidazole proton pump inhibitor that is used in the treatment of GASTROESOPHAGEAL REFLUX and PEPTIC ULCER.'),
  'D000077403': NtO(MH='Orlistat', MS='A lactone derivative of LEUCINE that acts as a pancreatic lipase inhibitor to limit the absorption of dietary fat; it is used in the management of obesity.'),
  'D000077404': NtO(MH='Cidofovir', MS='An acyclic nucleoside phosphonate that acts as a competitive inhibitor of viral DNA polymerases. It is used in the treatment of RETINITIS caused by CYTOMEGALOVIRUS INFECTIONS and may also be useful for treating HERPESVIRUS INFECTIONS.'),
  'D000077405': NtO(MH='Irbesartan', MS='A spiro compound, biphenyl and tetrazole derivative that acts as an angiotensin II type 1 receptor antagonist. It is used in the management of HYPERTENSION, and in the treatment of kidney disease.'),
  'D000077406': NtO(MH='History of Pharmacy', MS='Study of the origins and development of the field of PHARMACY.'),
  'D000077407': NtO(MH='Cilostazol', MS='A quinoline and tetrazole derivative that acts as a phosphodiesterase type 3 inhibitor, with anti-platelet and vasodilating activity. It is used in the treatment of PERIPHERAL VASCULAR DISEASES; ISCHEMIC HEART DISEASE; and in the prevention of stroke.'),
  'D000077408': NtO(MH='Modafinil', MS='A benzhydryl acetamide compound, central nervous system stimulant, and CYP3A4 inducing agent that is used in the treatment of NARCOLEPSY and SLEEP WAKE DISORDERS.'),
  'D000077409': NtO(MH='Tamsulosin', MS='A sulfonamide derivative and adrenergic alpha-1 receptor antagonist that is used to relieve symptoms of urinary obstruction caused by BENIGN PROSTATIC HYPERPLASIA.'),
  'D000077410': NtO(MH='Aluminum Chloride', MS='A compound with the chemical formula AlCl3; the anhydrous salt is used as a catalyst in organic chemical synthesis, and hydrated salts are used topically as antiperspirants, and for the management of HYPERHYDROSIS.'),
  'D000077422': NtO(MH='Enrofloxacin', MS='A fluoroquinolone antibacterial and antimycoplasma agent that is used in veterinary practice.'),
  'D000077423': NtO(MH='Polidocanol', MS='An alkyl polyglycol ether of LAURYL ALCOHOL, chemically defined as an alcohol ethoxylate having an average alkyl chain of 12\xe2\x80\x9314 carbon atoms, and an ethylene oxide chain of 9 ethylene oxide units. It is used as a detergent, and medically as a local anesthetic, and as a sclerosing agent for the treatment of ESOPHAGEAL AND GASTRIC VARICES and VARICOSE VEINS.'),
  'D000077425': NtO(MH='Fondaparinux', MS='Synthetic pentasaccharide that mediates the interaction of HEPARIN with ANTITHROMBINS and inhibits FACTOR Xa; it is used for prevention of VENOUS THROMBOEMBOLISM after surgery.'),
  'D000077426': NtO(MH='Gastric Artery', MS='Any of several branches of the SPLENIC ARTERY distributed to the greater curvature of the stomach.'),
  'D000077427': NtO(MH='Lipoglycopeptides', MS='Glycopeptides that have an additional lipophilic side chains. Several semisynthetic lipoglycopeptide antibiotics are derived from naturally occurring lipoglycopeptide and glycopeptide antibiotics.'),
  'D000077428': NtO(MH='GATA2 Deficiency', MS='A rare disorder of the immune system with wide-ranging effects which include GATA2 Transcription Factor dysfunction, immunodeficiency, myelodysplastic syndrome (ineffective blood cell production), lung disease, and problems of the vascular and lymphatic system.'),
  'D000077430': NtO(MH='Nabumetone', MS='A butanone non-steroidal anti-inflammatory drug and cyclooxygenase-2 (COX2) inhibitor that is used in the management of pain associated with OSTEOARTHRITIS and RHEUMATOID ARTHRITIS.'),
  'D000077431': NtO(MH='Oxaprozin', MS='An oxazole-propionic acid derivative, cyclooxygenase inhibitor, and non-steroidal anti-inflammatory drug that is used in the treatment of pain and inflammation associated with of OSTEOARTHRITIS; RHEUMATOID ARTHRITIS; and ARTHRITIS, JUVENILE.'),
  'D000077432': NtO(MH='Tapentadol', MS='An opioid analgesic, MU OPIOID RECEPTOR agonist, and noradrenaline reuptake inhibitor that is used in the treatment of moderate to severe pain, and of pain associated with DIABETIC NEUROPATHIES.'),
  'D000077442': NtO(MH='Lidocaine, Prilocaine Drug Combination', MS='A topical local anesthetic preparation that is composed of a mixture of lidocaine and prilocaine. It is used to provide anesthesia during minor surgery and for the treatment of PREMATURE EJACULATION.'),
  'D000077443': NtO(MH='Acamprosate', MS='Structural analog of taurine that is used for the prevention of relapse in individuals with ALCOHOLISM.'),
  'D000077444': NtO(MH='Smoking Cessation Agents', MS='Substances that facilitate the cessation of tobacco smoking.'),
  'D000077463': NtO(MH='Carbamide Peroxide', MS='A urea peroxide compound that is commonly used in tooth whitening agents; topical anti-infective agents, and earwax remover.'),
  'D000077464': NtO(MH='Simendan', MS='A hydrazone and pyridazine derivative; the levo-form is a phosphodiesterase III inhibitor, calcium-sensitizing agent, and inotropic agent that is used in the treatment of HEART FAILURE.'),
  'D000077465': NtO(MH='Cabergoline', MS='An ergoline derivative and dopamine D2-agonist that inhibits PROLACTIN secretion. It is used in the management of HYPERPROLACTINEMIA, and to suppress lactation following childbirth for medical reasons. Cabergoline is also used in the management of PARKINSON DISEASE.'),
  'D000077466': NtO(MH='Tirofiban', MS='Tyrosine analog and PLATELET GLYCOPROTEIN GPIIB-IIIA COMPLEX antagonist that inhibits PLATELET AGGREGATION and is used in the treatment of ACUTE CORONARY SYNDROME.'),
  'D000077482': NtO(MH='Carbon Fiber', MS='Fiber with a diameter of approximately 5 to 10 micrometers that is composed mostly of carbon atoms. It has a variety of applications.'),
  'D000077483': NtO(MH='Valacyclovir', MS='A prodrug of acyclovir that is used in the treatment of HERPES ZOSTER and HERPES SIMPLEX VIRUS INFECTION of the skin and mucous membranes, including GENITAL HERPES.'),
  'D000077484': NtO(MH='Vemurafenib', MS='An indole sulfonamide compound and inhibitor of BRAF KINASES that is used for the treatment of unresectable or metastatic MELANOMA.'),
  'D000077485': NtO(MH='Meglumine Antimoniate', MS='ANTIMONY salt of meglumine that is used in the treatment of LEISHMANIASIS.'),
  'D000077486': NtO(MH='Ticagrelor', MS='An adenosine triphosphate analogue and reversible P2Y12 PURINORECEPTOR antagonist that inhibits ADP-mediated PLATELET AGGREGATION. It is used for the prevention of THROMBOEMBOLISM by patients with ACUTE CORONARY SYNDROME or a history of MYOCARDIAL INFARCTION.'),
  'D000077487': NtO(MH='Pramipexole', MS='A benzothiazole derivative and dopamine agonist with antioxidant properties that is used in the treatment of PARKINSON DISEASE and RESTLESS LEGS SYNDROME.'),
  'D000077488': NtO(MH='Data Science', MS='An interdisciplinary field involving processes, theories, concepts, tools, and technologies, that enable the review, analysis, and extraction of valuable knowledge and information from structured and unstructured (raw) data.'),
  'D000077489': NtO(MH='Piperazine', MS='An anti-nematodal agent effective against the intestinal nematodes ASCARIS LUMBRICOIDES (roundworm) and ENTEROBIUS VERMICULARIS (pinworm, threadworm).  It produces a neuromuscular block leading to flaccid muscle paralysis in susceptible worms, which are then dislodged from the gut and expelled in feces.'),
  'D000077502': NtO(MH='Glymphatic System', MS='A vascular waste clearance system in the brain analogous to the lymphatic system that facilitates transporting of solutes and waste products from CEREBROSPINAL FLUID (CSF) and brain INTERSTITIAL FLUID (ISF). CSF from the SUBARACHNOID SPACE enters the brain periarterial spaces, into the interstitium via channels (e.g., AQUAPORIN 4 PROTEIN) on astrocytic endfeet and exchanges with brain ISF before perivenous drainage of solutes and waste.'),
  'D000077522': NtO(MH='Clinical Trial, Veterinary', MS='A work that is a veterinary clinical study in which animal participants are assigned to receive one or more interventions so that researchers can evaluate the interventions on biomedical or health-related outcomes. The assignments are determined by the study protocol. Animal participants may receive diagnostic, therapeutic, or other types of interventions.'),
  'D000077525': NtO(MH='Cefdinir', MS='A third-generation oral cephalosporin antibacterial agent that is used to treat bacterial infections of the respiratory tract and skin.'),
  'D000077526': NtO(MH='Tropisetron', MS='An indole derivative and 5-HT3 RECEPTOR antagonist that is used for the prevention of nausea and vomiting.'),
  'D000077542': NtO(MH='Eptifibatide', MS='Cyclic peptide that acts as a platelet glycoprotein IIB-IIIA antagonist, reversibly inhibiting the binding of FIBRINOGEN; VON WILLEBRAND FACTOR; and other adhesive molecules to the GPIIB-IIIA RECEPTORS of platelets. It is used in the management of UNSTABLE ANGINA and in patients undergoing coronary ANGIOPLASTY and stenting procedures.'),
  'D000077543': NtO(MH='Deferiprone', MS='A pyridone derivative and iron chelator that is used in the treatment of IRON OVERLOAD in patients with THALASSEMIA.'),
  'D000077544': NtO(MH='Panitumumab', MS='Recombinant human monoclonal antibody that binds to and inhibits the function of the EPIDERMAL GROWTH FACTOR RECEPTOR. It is used in the treatment of EGFR-expressing metastatic colorectal cancer that expresses wild-type ras gene (see GENES, RAS).'),
  'D000077545': NtO(MH='Eplerenone', MS='A spironolactone derivative and selective ALDOSTERONE RECEPTOR antagonist that is used in the management of HYPERTENSION and CONGESTIVE HEART FAILURE, post-MYOCARDIAL INFARCTION.'),
  'D000077546': NtO(MH='Roscovitine', MS='A purine derivative and competitive inhibitor of CYCLIN-DEPENDENT KINASES that has therapeutic potential as an antineoplastic and antiviral agent.'),
  'D000077547': NtO(MH='Crizotinib', MS='A piperidine and aminopyridine derivative that acts as an inhibitor of RECEPTOR PROTEIN-TYROSINE KINASES, including ANAPLASTIC LYMPHOMA KINASE (ALK) and HEPATOCYTE GROWTH FACTOR RECEPTOR (HGFR; c-Met). It is used in the treatment of NON-SMALL CELL LUNG CANCER.'),
  'D000077548': NtO(MH='Anaplastic Lymphoma Kinase', MS='A receptor tyrosine kinase that is essential for development and differentiation of the nervous system in response to secreted growth factors. It phosphorylates the first tyrosine of the Y-x-x-x-Y-Y motif of targets that include PROTO-ONCOGENE PROTEINS C-CBL; INSULIN RECEPTOR SUBSTRATE-1; and MITOGEN-ACTIVATED PROTEIN KINASES, leading to activation of the MAPK signaling pathway and cell proliferation. A chromosomal aberration involving the ALK gene results in its constitutive expression in some cases of NON-HODGKIN LYMPHOMA.'),
  'D000077549': NtO(MH='Artemether', MS='An artemisinin derivative that is used in the treatment of MALARIA.'),
  'D000077550': NtO(MH='Ivabradine', MS='A benzazepine derivative and selective HYPERPOLARIZATION-ACTIVATED CYCLIC NUCLEOTIDE-GATED CHANNELS inhibitor that lowers the heart rate. It is used in the treatment of CHRONIC STABLE ANGINA in patients unable to take BETA-ADRENERGIC BLOCKERS, and in the treatment of HEART FAILURE.'),
  'D000077551': NtO(MH='Micafungin', MS='A cyclic lipo-hexapeptide echinocandin antifungal agent that is used for the treatment and prevention of CANDIDIASIS.'),
  'D000077552': NtO(MH='Basiliximab', MS='A chimeric murine-human monoclonal antibody that functions as an INTERLEUKIN 2 RECEPTOR antagonist by binding to the alpha chain (CD25 ANTIGEN) of the interleukin-2 receptor on the surface of activated T-LYMPHOCYTES. It is used in the prevention of acute graft rejection episodes in patients undergoing renal transplantation.'),
  'D000077553': NtO(MH='Edaravone', MS='An antipyrine derivative that functions as a free radical scavenger and neuroprotective agent. It is used in the treatment of AMYOTROPHIC LATERAL SCLEROSIS and STROKE.'),
  'D000077554': NtO(MH='Levobupivacaine', MS='S-enantiomer of bupivacaine that is used as a local anesthetic and for regional nerve blocks, including EPIDURAL ANESTHESIA.'),
  'D000077555': NtO(MH='Methylprednisolone Acetate', MS='Methylprednisolone derivative that is used as an anti-inflammatory agent for the treatment of ALLERGY and ALLERGIC RHINITIS; ASTHMA; and BURSITIS; and for the treatment of ADRENAL INSUFFICIENCY.'),
  'D000077556': NtO(MH='Alitretinoin', MS='A retinoid that is used for the treatment of chronic hand ECZEMA unresponsive to topical CORTICOSTEROIDS. It is also used to treat cutaneous lesions associated with AIDS-related KAPOSI SARCOMA.'),
  'D000077557': NtO(MH='Ibandronic Acid', MS='Aminobisphosphonate that is a potent inhibitor of BONE RESORPTION. It is used in the treatment of HYPERCALCEMIA associated with malignancy, for the prevention of fracture and bone complications in patients with breast cancer and bone metastases, and for the treatment and prevention of POSTMENOPAUSAL OSTEOPOROSIS.'),
  'D000077558': NtO(MH='Big Data', MS='Extremely large amounts of data which require rapid and often complex computational analyses to reveal patterns, trends, and associations, relating to various facets of human and non-human entities.'),
  'D000077559': NtO(MH='Sodium Citrate', MS='Sodium salts of citric acid that are used as buffers and food preservatives. They are used medically as anticoagulants in stored blood, and for urine alkalization in the prevention of KIDNEY STONES.'),
  'D000077560': NtO(MH='Enfuvirtide', MS='A synthetic 36-amino acid peptide that corresponds to the heptad repeat sequence of HIV-1 gp41. It blocks HIV cell fusion and viral entry and is used with other anti-retrovirals for combination therapy of HIV INFECTIONS and AIDS.'),
  'D000077561': NtO(MH='Daclizumab', MS='An anti-TAC (INTERLEUKIN-2 RECEPTOR ALPHA SUBUNIT) humanized monoclonal antibody (immunoglobulin G1 disulfide with human-mouse monoclonal clone 1H4 light chain, dimer) that is used in the treatment of ACUTE RELAPSING MULTIPLE SCLEROSIS.'),
  'D000077562': NtO(MH='Valganciclovir', MS='A ganciclovir prodrug and antiviral agent that is used to treat CYTOMEGALOVIRUS RETINITIS in patients with AIDS, and for the prevention of CYTOMEGALOVIRUS INFECTIONS in organ transplant recipients who have received an organ from a CMV-positive donor.'),
  'D000077563': NtO(MH='Norethindrone Acetate', MS='Acetate ester of norethindrone that is used as a long-term contraceptive (CONTRACEPTIVE AGENTS).'),
  'D000077564': NtO(MH='Focused Assessment with Sonography for Trauma', MS='Rapid bedside ultrasound examination performed by medical personnel (surgeons, emergency physicians, paramedics and others), as a screening test for blood around the heart (PERICARDIAL EFFUSION) or abdominal organs (HEMOPERITONEUM) after trauma.'),
  'D000077582': NtO(MH='Amisulpride', MS='A benzamide derivative that is used as an antipsychotic agent for the treatment of schizophrenia. It is also used as an antidepressive agent.'),
  'D000077583': NtO(MH='Quinapril', MS='A tetrahydroisoquinoline derivative and ANGIOTENSIN CONVERTING ENZYME inhibitor that is used in the treatment of HYPERTENSION and HEART FAILURE.'),
  'D000077584': NtO(MH='2-Methoxyestradiol', MS='A metabolite of estradiol that lacks estrogenic activity and inhibits TUBULIN polymerization. It has antineoplastic properties, including inhibition of angiogenesis and induction of APOPTOSIS.'),
  'D000077585': NtO(MH='Terlipressin', MS='An inactive peptide prodrug that is slowly converted in the body to lypressin. It is used to control bleeding of ESOPHAGEAL VARICES and for the treatment of HEPATORENAL SYNDROME.'),
  'D000077587': NtO(MH='Natural Disasters', MS='Disasters linked to natural hazards including widespread fires, floods, storms, earthquakes and drought.These events may result in significant damage and loss of lives.'),
  'D000077588': NtO(MH='Deferasirox', MS='A triazole and benzoate derivative that acts as a selective iron chelator. It is used in the management of chronic IRON OVERLOAD due to blood transfusion or non-transfusion dependent THALASSEMIA.'),
  'D000077589': NtO(MH='Sulfathiazole', MS='A sulfathiazole compound that is used as a short-acting anti-infective agent. It is no longer commonly used systemically due to its toxicity, but may still be applied topically in combination with other drugs for the treatment of vaginal and skin infections, and is still used in veterinary medicine.'),
  'D000077590': NtO(MH='Mivacurium', MS='An isoquinoline derivative that is used as a short-acting non-depolarizing agent.'),
  'D000077591': NtO(MH='Eucalyptol', MS='A monoterpene and cyclohexanol derivative that is the major component of EUCALYPTUS OIL. It is used in mouthwash, insect repellent, and as a cough suppressant, and also is widely used as a flavoring agent and solvent. It has antimicrobial properties.'),
  'D000077592': NtO(MH='Maraviroc', MS='A cyclohexane and triazole derivative that acts as an antagonist of the CCR5 RECEPTOR. It prevents infection by HIV-1 virus strains which use CCR5 as a co-receptor for membrane fusion and cellular entry.'),
  'D000077593': NtO(MH='Reboxetine', MS='A morpholine derivative that is a selective and potent noradrenaline reuptake inhibitor; it is used in the treatment of DEPRESSIVE DISORDER.'),
  'D000077594': NtO(MH='Nivolumab', MS="A genetically engineered, fully humanized immunoglobulin G4 monoclonal antibody that binds to the PD-1 RECEPTOR, activating an immune response to tumor cells. It is used as monotherapy or in combination with IPILIMUMAB for the treatment of advanced malignant MELANOMA. It is also used in the treatment of advanced or recurring NON-SMALL CELL LUNG CANCER; RENAL CELL CARCINOMA; and HODGKIN'S LYMPHOMA."),
  'D000077595': NtO(MH='Famciclovir', MS='An aminopurine derivative and prodrug of penciclovir which is a competitive inhibitor of herpes simplex 2 DNA polymerase. It is used to treat HERPES SIMPLEX VIRUS INFECTION.'),
  'D000077596': NtO(MH='Thymalfasin', MS='A thymus hormone polypeptide found in thymosin fraction 5 (a crude thymus gland extract) but now produced by synthesis. It is used alone or with interferon as an immunomodulator for the treatment of CHRONIC HEPATITIS B and HEPATITIS C. Thymalfasin is also used for the treatment of chemotherapy-induced immunosuppression, and to enhance the efficacy of influenza and hepatitis B vaccines in immunocompromised patients.'),
  'D000077597': NtO(MH='Vildagliptin', MS='A pyrrolidine-carbonitrile derivative and potent inhibitor of DIPEPTIDYL PEPTIDASE 4 that is used in the treatment of TYPE 2 DIABETES MELLITUS.'),
  'D000077602': NtO(MH='Tolvaptan', MS='A benzazepine derivative and selective VASOPRESSIN V2 RECEPTOR antagonist that is used to treat euvolemic and hypervolemic HYPONATREMIA. It is also used in the treatment of rapidly progressing AUTOSOMAL DOMINANT POLYCYSTIC KIDNEY DISEASE to slow the rate of cyst development and renal insufficiency.'),
  'D000077603': NtO(MH='Nandrolone Decanoate', MS='Decanoic acid ester of nandrolone that is used as an anabolic agent to prevent or treat WASTING SYNDROME associated with severe chronic illness or HIV infection (HIV WASTING SYNDROME). It may also be used in the treatment of POSTMENOPAUSAL OSTEOPOROSIS.'),
  'D000077604': NtO(MH='Fomepizole', MS='A pyrazole and competitive inhibitor of ALCOHOL DEHYDROGENASE that is used for the treatment of poisoning by ETHYLENE GLYCOL or METHANOL.'),
  'D000077605': NtO(MH='Ferric Oxide, Saccharated', MS='A glucaric acid-iron conjugate that is used in the treatment of IRON-DEFICIENCY ANEMIA, including in patients with chronic kidney disease, when oral iron therapy is ineffective or impractical.'),
  'D000077606': NtO(MH='Trabectedin', MS='A complex structure that includes isoquinolines joined by a cyclic ester; it is a DNA-binding agent and guanine N2 alkylator derived from the marine tunicate, Ecteinascidia turbinata. Trabectedin is used for the treatment of advanced soft-tissue SARCOMA, after failure of ANTHRACYCLINES or IFOSFAMIDE drug therapy.'),
  'D000077607': NtO(MH='Icodextrin', MS='A glucan that is structurally related to maltodextrin, with more than 85% of its molecules having molecular weights between 1640 and 45 000 Daltons (Da), and a weight-average molecular weight of about 20 000 Da; it is used in dialysis fluids as an alternative to glucose-based solutions, and to reduce adhesions after gynecological or abdominal surgery. It has also been used as a vehicle for drugs given via the peritoneal cavity.'),
  'D000077608': NtO(MH='Aprepitant', MS='A morpholine neurokinin-1 (NK1) receptor antagonist that is used in the management of nausea and vomiting caused by DRUG THERAPY, and for the prevention of POSTOPERATIVE NAUSEA AND VOMITING.'),
  'D000077609': NtO(MH='O-(Chloroacetylcarbamoyl)fumagillol', MS='Semisynthetic analog of fumagillin (a cyclohexane-sesquiterpene antibiotic isolated from ASPERGILLUS FUMIGATUS) that inhibits angiogenesis.'),
  'D000077610': NtO(MH='Bexarotene', MS='A tetrahydronaphthalene derivative and RETINOID X RECEPTOR antagonist that is used in the treatment of CUTANEOUS T-CELL LYMPHOMA.'),
  'D000077611': NtO(MH='Artemether, Lumefantrine Drug Combination', MS='Drug combination of artemether and lumefantrine that is used to treat PLASMODIUM FALCIPARUM MALARIA.'),
  'D000077612': NtO(MH='Anidulafungin', MS='Echinocandin antifungal agent that is used in the treatment of CANDIDEMIA and CANDIDIASIS.'),
  'D000077613': NtO(MH='Etoricoxib', MS='A sulfone and pyridine derivative that acts as a cyclooxygenase-2 inhibitor. It is used as a NSAID for the treatment of pain associated with RHEUMATOID ARTHRITIS and ANKYLOSING SPONDYLITIS. It is also used for the short-term treatment of moderate postoperative dental pain.'),
  'D000077614': NtO(MH='Golgi Matrix Proteins', MS='Proteins on the cytoplasmic side of the GOLGI APPARATUS cisternae that tether the cisternae to each other or to the transport vesicles of the TRANS-GOLGI NETWORK to maintain the Golgi structure and function.'),
  'D000077626': NtO(MH='Implementation Science', MS='The study of methods to promote the adoption and integration of evidence-based practices, interventions and policies into routine health care and public health settings.'),
  'D000077642': NtO(MH='Family Separation', MS='Geographic separation of members of a family.'),
  'D000077682': NtO(MH='Triclabendazole', MS='Benzimidazole antiplatyhelmintic agent that is used for the treatment of FASCIOLIASIS and PARAGONIMIASIS.'),
  'D000077684': NtO(MH='Cauda Equina Syndrome', MS='Compressive lesion affecting the nerve roots of the CAUDA EQUINA (e.g., compression, herniation, inflammation, rupture, or stenosis), which controls the function of the bladder and bowel. Symptoms may include neurological dysfunction of bladder or bowels, loss of sexual sensation and altered sensation or paralysis in the lower extremities.'),
  'D000077704': NtO(MH='Tirapazamine', MS='A triazine derivative that introduces breaks into DNA strands in hypoxic cells, sensitizing tumor cells to the cytotoxic activity of other drugs and radiation.'),
  'D000077705': NtO(MH='Screen Time', MS='Period of activities done in front of an electronic screen, such as watching TV, working on a computer, or playing video games.'),
  'D000077708': NtO(MH='Sitting Position', MS=None),
  'D000077711': NtO(MH='Self-Neglect', MS='Profound inattention by individuals to their own health and hygiene.'),
  'D000077712': NtO(MH='Telbivudine', MS='A thymidine derivative and antiviral agent that inhibits DNA synthesis by HEPATITIS B VIRUS and is used for the treatment of CHRONIC HEPATITIS B.'),
  'D000077713': NtO(MH='17 alpha-Hydroxyprogesterone Caproate', MS='Hydroxyprogesterone derivative that acts as a PROGESTIN and is used to reduce the risk of recurrent MISCARRIAGE and of PREMATURE BIRTH. It is also used in combination with ESTROGEN in the management of MENSTRUATION DISORDERS.'),
  'D000077715': NtO(MH='Nateglinide', MS='A phenylalanine and cyclohexane derivative that acts as a hypoglycemic agent by stimulating the release of insulin from the pancreas. It is used in the treatment of TYPE 2 DIABETES.'),
  'D000077716': NtO(MH='Afatinib', MS='A quinazoline and butenamide derivative that acts as a tyrosine kinase inhibitor of epidermal growth factor receptors (ERBB RECEPTORS) and is used in the treatment of metastatic NON-SMALL CELL LUNG CANCER.'),
  'D000077722': NtO(MH='Ceftibuten', MS='A cephalosporin antibacterial agent that is used in the treatment of infections, including urinary-tract and respiratory-tract infections.'),
  'D000077723': NtO(MH='Cefepime', MS='A fourth-generation cephalosporin antibacterial agent that is used in the treatment of infections, including those of the abdomen, urinary tract, respiratory tract, and skin. It is effective against PSEUDOMONAS AERUGINOSA and may also be used in the empiric treatment of FEBRILE NEUTROPENIA.'),
  'D000077725': NtO(MH='Piperacillin, Tazobactam Drug Combination', MS='An antibiotic combination product of piperacillin and tazobactam, a penicillanic acid derivative with enhanced beta-lactamase inhibitory activity, that is used for the intravenous treatment of intra-abdominal, pelvic, and skin infections and for community-acquired pneumonia of moderate severity. It is also used for the treatment of PSEUDOMONAS AERUGINOSA INFECTIONS.'),
  'D000077726': NtO(MH='Doripenem', MS='A carbapenem derivative antibacterial agent that is more stable to renal dehydropeptidase I than IMIPENEM, but does not need to be given with an enzyme inhibitor such as CILASTATIN. It is used in the treatment of infections such as HOSPITAL-ACQUIRED PNEUMONIA, and complicated intra-abdominal or urinary-tract infections, including PYELONEPHRITIS.'),
  'D000077727': NtO(MH='Ertapenem', MS='A carbapenem derivative antibacterial agent that is more stable to renal dehydropeptidase I than IMIPENEM, but does not need to be given with an enzyme inhibitor such as CILASTATIN. It is used in the treatment of Gram-positive and Gram-negative bacterial infections including intra-abdominal infections, acute gynecological infections, complicated urinary tract infections, skin infections, and respiratory tract infections. It is also used to prevent infection in colorectal surgery.'),
  'D000077728': NtO(MH='Cilastatin, Imipenem Drug Combination', MS='Combination of imipenem and cilastatin that is used in the treatment of bacterial infections; cilastatin inhibits renal dehydropeptidase I to prolong the half-life and increase the tissue penetration of imipenem, enhancing its efficacy as an anti-bacterial agent.'),
  'D000077731': NtO(MH='Meropenem', MS='A thienamycin derivative antibacterial agent that is more stable to renal dehydropeptidase I than IMIPENEM, but does not need to be given with an enzyme inhibitor such as CILASTATIN. It is used in the treatment of bacterial infections, including infections in immunocompromised patients.'),
  'D000077732': NtO(MH='Fidaxomicin', MS='A narrow-spectrum macrolide antibacterial agent that is used in the treatment of diarrhea associated with CLOSTRIDIUM DIFFICILE INFECTION.'),
  'D000077733': NtO(MH='Immunoglobulin G4-Related Disease', MS='A spectrum of systemic autoimmune diseases in which IMMUNOGLOBULIN G4 plays a pathophysiologic role. It can affect multiple organs in highly variable presentations, characterized by inflammatory lesions composed of IgG4-positive PLASMA CELLS, further infiltrated by T helper cells (T-LYMPHOCYTES, HELPER-INDUCER) when linked to progressive FIBROSIS and eventual organ damage.'),
  'D000077734': NtO(MH='Gatifloxacin', MS='A fluoroquinolone antibacterial agent and DNA TOPOISOMERASE II inhibitor that is used as an ophthalmic solution for the treatment of BACTERIAL CONJUNCTIVITIS.'),
  'D000077735': NtO(MH='Gemifloxacin', MS='A naphthyridine and fluoroquinolone derivative antibacterial agent and DNA TOPOISOMERASE II inhibitor that is used for the treatment of community-acquired pneumonia and acute bacterial infections associated with chronic bronchitis.'),
  'D000077740': NtO(MH='Procalcitonin', MS='A peptide prohormone precursor of CALCITONIN. It is normally present at low levels in serum, but is released into the bloodstream, primarily from neuroendocrine cells in the lungs and intestines, in response to INFLAMMATION and BACTERIAL INFECTIONS. It is a diagnostic marker for BACTEREMIA.'),
  'D000077743': NtO(MH='Diterpene Alkaloids', MS='Alkaloids derived from diterpenes (e.g., KAURANES; CLERODANES) often containing the nitrogen bridge structures. These alkaloids may be divided into C18-, C19-, C20- and bis-diterpene types depending on the number of carbon atoms in their central framework. They are found most often in RANUNCULACEAE (e.g., ACONITUM and DELPHINIUM) and may possess analgesic, antiarrhythmic and anti-inflammatory activities. Some are cardiotoxic by blocking L-TYPE CALCIUM CHANNELS.'),
  'D000077744': NtO(MH='Orthodontic Appliances, Fixed', MS='ORTHODONTIC APPLIANCES attached to the teeth by adhesive material which cannot be removed from the mouth by the patient. These devices apply force to the teeth and supporting structures, thereby producing changes which control their growth and development.'),
  'D000077764': NtO(MH='Dronedarone', MS='A non-iodinated derivative of amiodarone that is used for the treatment of ARRHYTHMIA.'),
  'D000077765': NtO(MH='Cone Dystrophy', MS='A general term which describes a group of rare eye disorders that affect the cone cells of the RETINA. Cone dystrophy can cause a variety of symptoms including decreased visual clarity or acuity when looking straight ahead (central vision), a reduced ability to see colors, and an increased sensitivity to light (PHOTOPHOBIA).'),
  'D000077767': NtO(MH='Panobinostat', MS='An indole and hydroxamic acid derivative that acts as a HISTONE DEACETYLASE inhibitor. It is used as an antineoplastic agent in combination with BORTEZOMIB and DEXAMETHASONE for the treatment of MULTIPLE MYELOMA.'),
  'D000077768': NtO(MH='Ciclopirox', MS='A cyclohexane and pyridinone derivative that is used for the treatment of fungal infections of the skin and nails, and for treatment of VAGINAL YEAST INFECTIONS.'),
  'D000077769': NtO(MH='Rilmenidine', MS='Oxazole derivative that acts as an agonist for ALPHA-2 ADRENERGIC RECEPTORS and IMIDAZOLINE RECEPTORS. It is used in the treatment of HYPERTENSION.'),
  'D000077770': NtO(MH='Amifampridine', MS='4-Aminopyridine derivative that acts as a POTASSIUM CHANNEL blocker to increase release of ACETYLCHOLINE from nerve terminals. It is used in the treatment of CONGENITAL MYASTHENIC SYNDROMES.'),
  'D000077771': NtO(MH='Methantheline', MS='A quaternary ammonium compound that acts as an antimuscarinic agent. It has been used in the treatment of PEPTIC ULCER, in gastrointestinal disorders associated with smooth muscle spasm, and in the management of urinary incontinence, and may also be used for the treatment of HYPERHIDROSIS.'),
  'D000077772': NtO(MH='Shared Governance, Nursing', MS='Model of nursing practice with shared decision processes designed to integrate core values and beliefs that professional practice embraces, as a means of achieving quality care.'),
  'D000077773': NtO(MH='Hospitals, Rehabilitation', MS='Free standing rehabilitation hospitals and rehabilitation units in acute care hospitals.  They provide an intensive inpatient rehabilitation program.'),
  'D000077776': NtO(MH='Insurance, Vision', MS='Insurance providing coverage for vision care.'),
  'D000077777': NtO(MH='Myopericytoma', MS='Rare myofibroma-like perivascular soft tissue tumor, usually benign, characterized by concentric perivascular proliferation.'),
  'D000077779': NtO(MH='Pancreatic Intraductal Neoplasms', MS='EPITHELIAL NEOPLASMS with pancreatic ductal differentiation that arise from the EXOCRINE PANCREAS and grow mostly within the PANCREATIC DUCTS. They are characterized by the presence of intraductal masses with mostly papillary growth pattern. Overt production of MUCIN within the pancreatic duct is associated with pancreatic intraductal papillary-mucinous neoplasm but not intraductal tubulopapillary neoplasm.'),
  'D000077780': NtO(MH='Plastination', MS='Preservation technique in which epoxy polymers are used to preserve tissue or an organ resulting in anatomically authentic dry specimens often used in teaching of anatomy.'),
  'D000077784': NtO(MH='Axitinib', MS='A benzamide and indazole derivative that acts as a TYROSINE KINASE inhibitor of the VASCULAR ENDOTHELIAL GROWTH FACTOR RECEPTOR. It is used in the treatment of advanced RENAL CELL CARCINOMA.'),
  'D000077785': NtO(MH='Tenecteplase', MS='A tissue plasminogen activator enzyme that acts as a fibrinolytic agent; it is used for the dissolution of blood clots, such as those that occur in acute MYOCARDIAL INFARCTION.'),
  'D000077786': NtO(MH='Torsemide', MS='A pyridine and sulfonamide derivative that acts as a sodium-potassium chloride symporter inhibitor (loop diuretic). It is used for the treatment of EDEMA associated with CONGESTIVE HEART FAILURE; CHRONIC RENAL INSUFFICIENCY; and LIVER DISEASES. It is also used for the management of HYPERTENSION.'),
  'D000077803': NtO(MH='Dictionary, Classical', MS='A reference work containing a list of words related to the Greco-Roman World giving information about form, pronunciation, etymology, grammar, and meaning.'),
  'D000077823': NtO(MH='Dictionary, Medical', MS='A reference book containing a list of words related to medicine-usually in alphabetic order-giving information about form, pronunciation, etymology, grammar, and meaning.'),
  'D000077824': NtO(MH='Dictionary, Dental', MS='A reference book containing a list of words related to dentistry-usually in alphabetic order-giving information about form, pronunciation, etymology, grammar, and meaning.'),
  'D000077825': NtO(MH='Dictionary, Pharmaceutic', MS='A reference book containing a list of words related to pharmacy-usually in alphabetic order-giving information about form, pronunciation, etymology, grammar, and meaning.'),
  'D000077844': NtO(MH='Dictionary, Chemical', MS='A reference book containing a list of words related to chemistry-usually in alphabetic order-giving information about form, pronunciation, etymology, grammar, and meaning.'),
  'D000077845': NtO(MH='Lipoabdominoplasty', MS='Aesthetic surgical treatment of the abdominal region using LIPOSUCTION associated with ABDOMINOPLASTY.'),
  'D000077862': NtO(MH='Manuscript, Medical', MS='Medical works prepared by hand including handwritten or typescript drafts of pre-publication papers or works not otherwise reproduced in multiple copies.'),
  'D000077863': NtO(MH='Homoharringtonine', MS='Semisynthetic derivative of harringtonine that acts as a protein synthesis inhibitor and induces APOPTOSIS in tumor cells. It is used in the treatment of MYELOID LEUKEMIA, CHRONIC.'),
  'D000077866': NtO(MH='Clofarabine', MS='An adenine arabinonucleoside derivative that acts as an antineoplastic antimetabolite. It is used in the treatment of ACUTE LYMPHOID LEUKEMIA in pediatric patients who have relapsed.'),
  'D000077867': NtO(MH='Tolcapone', MS='A benzophenone and nitrophenol compound that acts as an inhibitor of CATECHOL O-METHYLTRANSFERASE, an enzyme involved in the metabolism of DOPAMINE and LEVODOPA. It is used in the treatment of PARKINSON DISEASE in patients for whom levodopa is ineffective or contraindicated.'),
  'D000077868': NtO(MH='Atrasentan', MS='A pyrrolidine and benzodioxole derivative that acts a RECEPTOR, ENDOTHELIN A antagonist. It has therapeutic potential as an antineoplastic agent and for the treatment of DIABETIC NEPHROPATHIES.'),
  'D000077922': NtO(MH='Thiamethoxam', MS='A nitro-oxazine and thiazole derivative that is used as a broad spectrum neonicotinoid insecticide.'),
  'D000077923': NtO(MH='Societies, Veterinary', MS='Organizations having institutional membership limited to veterinarians and veterinary institutions.'),
  'D000077924': NtO(MH='Palonosetron', MS='Isoquinoline and quinuclidine derivative that acts as a 5-HT3 RECEPTOR antagonist. It is used in the prevention of nausea and vomiting induced by cytotoxic chemotherapy, and for the prevention of post-operative nausea and vomiting.'),
  'D000077944': NtO(MH='Alefacept', MS='A recombinant human fusion protein of LFA-3 antigen and immunoglobulin IGG1 that binds to CD2 ANTIGENS on memory T-LYMPHOCYTES, preventing their activation and proliferation. It is used in the management of moderate to severe chronic plaque PSORIASIS.'),
  'D000077962': NtO(MH='Body-Weight Trajectory', MS='A general pattern of body weight gain or loss over many years. Weight change trajectory is influenced by several determinants in children and adults.'),
  'D000077982': NtO(MH='Progression-Free Survival', MS='Length of time during and after the treatment of a disease, such as cancer, that a patient lives with the disease but the disease does not get worse.'),
  'D000078002': NtO(MH='Posttraumatic Growth, Psychological', MS='Positive change experienced as a result of the struggle with a major life crisis or a traumatic event.'),
  'D000078003': NtO(MH='Change Management', MS='Processes, tools, and techniques involved in the management of ORGANIZATIONAL INNOVATION, the purpose of which is to help individuals and work groups make successful personal transitions which ensure overall successful outcomes.'),
  'D000078022': NtO(MH='Economic Status', MS='Personal or family variables such as household income, assets such as inherited wealth, savings, employment benefits, or ownership of homes or other property.'),
  'D000078062': NtO(MH='Leucanthemum', MS='A genus of flowering plants in the family ASTERACEAE, mainly distributed in southern and central Europe, and on other continents as introduced species. Leucanthemum species include annuals and perennials grown for their daisy flowers, which are usually gleaming white with yellow centers.'),
  'D000078064': NtO(MH='Gestational Weight Gain', MS='Increase in body weight of the mother during the course of her PREGNANCY.'),
  'D000078065': NtO(MH='Aegilops', MS='A genus of grasses known generally as goatgrasses, presumed to be wild ancestors of domestic WHEAT. They belong to the grass family, POACEAE, and are distributed widely in Eurasia and North America.'),
  'D000078102': NtO(MH='Lumefantrine', MS='A fluorene derivative that is used in combination with ARTEMETHER for the treatment of MALARIA (see ARTEMETHER-LUMEFANTRINE DRUG COMBINATION).'),
  'D000078122': NtO(MH='Eucalyptus Oil', MS='An oily liquid that is extracted from the leaves of EUCALYPTUS trees.'),
  'D000078142': NtO(MH='Tazobactam', MS='A penicillanic acid and sulfone derivative and potent BETA-LACTAMASE inhibitor that enhances the activity of other anti-bacterial agents against beta-lactamase producing bacteria.'),
  'D000078162': NtO(MH='Tobramycin, Dexamethasone Drug Combination', MS='A topical preparation of tobramycin and dexamethasone that is used for treating or preventing superficial bacterial infections of the eye.'),
  'D000078182': NtO(MH='Systematic Review', MS='A review of primary literature in health and health policy that attempts to identify, appraise, and synthesize all the empirical evidence that meets specified eligibility criteria to answer a given research question.  Its conduct uses explicit methods aimed at minimizing bias in order to produce more reliable findings regarding the effects of interventions for prevention, treatment, and rehabilitation that can be used to inform decision making.'),
  'D000078183': NtO(MH='Oxindoles', MS='Benzopyrroles with the nitrogen at the number one carbon adjacent to the benzyl and a carbonyl at the pyrrole ring typically at the 2-position.'),
  'D000078202': NtO(MH='Systematic Reviews as Topic', MS='Works about a review of primary literature in health and health policy that attempt to identify, appraise, and synthesize all the empirical evidence that meets specified eligibility criteria to answer a given research question. Its conduct uses explicit methods aimed at minimizing bias in order to produce more reliable findings regarding the effects of interventions for prevention, treatment, and rehabilitation that can be used to inform decision making.'),
  'D000078222': NtO(MH='Tinzaparin', MS='A low-molecular-weight heparin with anticoagulant properties that is used in the prevention and treatment of VENOUS THROMBOEMBOLISM, and to prevent clotting during EXTRACORPOREAL CIRCULATION.'),
  'D000078223': NtO(MH='5-Methoxypsoralen', MS='A linear furanocoumarin that has phototoxic and anti-inflammatory properties, with effects similar to METHOXSALEN. It is used in PUVA THERAPY for the treatment of PSORIASIS.'),
  'D000078224': NtO(MH='Lenograstim', MS='A recombinant granulocyte colony-stimulating factor that is used to treat or prevent NEUTROPENIA in patients receiving myelosuppressive cancer chemotherapy, for the preparation and collection of blood progenitor cells in PERIPHERAL BLOOD STEM CELL TRANSPLANTATION; and in the treatment of severe congenital neutropenia. Component 1 and Component 2 differ by absence or presence of Neu5Ac in 2-6 linkage to GalNAc side chain.'),
  'D000078262': NtO(MH='Rifaximin', MS='A synthetic rifamycin derivative and anti-bacterial agent that is used for the treatment of GASTROENTERITIS caused by ESCHERICHIA COLI INFECTIONS. It may also be used in the treatment of HEPATIC ENCEPHALOPATHY.'),
  'D000078303': NtO(MH='Data Aggregation', MS='Process of searching, gathering, and presenting data in a summarized format.'),
  'D000078304': NtO(MH='Tigecycline', MS='A tetracycline derivative that acts as a protein synthesis inhibitor. It is used as an antibacterial agent for the systemic treatment of complicated skin and intra-abdominal infections. It is also used for the treatment of community-acquired pneumonia.'),
  'D000078305': NtO(MH='Zonisamide', MS='A benzisoxazole and sulfonamide derivative that acts as a CALCIUM CHANNEL blocker. It is used primarily as an adjunctive antiepileptic agent for the treatment of PARTIAL SEIZURES, with or without secondary generalization.'),
  'D000078306': NtO(MH='Clobazam', MS='A benzodiazepine derivative that is a long-acting GABA-A RECEPTOR agonist. It is used as an antiepileptic in the treatment of SEIZURES, including seizures associated with LENNOX-GASTAUT SYNDROME.  It is also used as an anxiolytic, for the short-term treatment of acute ANXIETY.'),
  'D000078308': NtO(MH='Tiagabine', MS='A nipecotic acid derivative that acts as a GABA uptake inhibitor and anticonvulsant agent. It is used in the treatment of EPILEPSY, for refractory PARTIAL SEIZURES.'),
  'D000078323': NtO(MH='Observational Study, Veterinary', MS='Reports on studies of the results of a clinical study in which animal subjects may receive diagnostic, therapeutic, or other types of interventions, where the investigator does not assign participants to specific interventions.'),
  'D000078325': NtO(MH='Clinical Trial Protocol', MS="The written description of a clinical study. It contains the study's objectives, design, and methods including subject target and/or enrollment criteria. It may also present relevant scientific background and statistical information."),
  'D000078326': NtO(MH='Data Visualization', MS='Facilitating understanding of the significance of data by placing it in a visual context. Patterns, trends and correlations that might go undetected in text-based data may be exposed and recognized easier.'),
  'D000078327': NtO(MH='Data Systems', MS='Organized collection of symbols and symbol-manipulating processes used to operate on such symbols.'),
  'D000078328': NtO(MH='Felbamate', MS='A PEGylated phenylcarbamate derivative that acts as an antagonist of NMDA RECEPTORS. It is used as an anticonvulsant, primarily for the treatment of SEIZURES in severe refractory EPILEPSY.'),
  'D000078329': NtO(MH='Workforce', MS='The number of people working or available for work or service.'),
  'D000078330': NtO(MH='Oxcarbazepine', MS='A carbamazepine derivative that acts as a voltage-gated sodium channel blocker. It is used for the treatment of PARTIAL SEIZURES with or without secondary generalization. It is also an inducer of CYTOCHROME P-450 CYP3A4.'),
  'D000078331': NtO(MH='Correlation of Data', MS='Determination of whether or not two variables are correlated. This means to study whether an increase or decrease in one variable corresponds to an increase or decrease in the other variable.'),
  'D000078332': NtO(MH='Data Analysis', MS='Process of systematically applying statistical and/or logical techniques to describe and illustrate, condense and recap, and evaluate data (https://ori.hhs.gov/education).'),
  'D000078334': NtO(MH='Lacosamide', MS='An acetamide derivative that acts as a blocker of VOLTAGE-GATED SODIUM CHANNELS. It is used as an anticonvulsant, for adjunctive or monotherapy, in the treatment of PARTIAL SEIZURES.'),
  'D000078336': NtO(MH='Facilities and Services Utilization', MS='Extent of use of facilities or services. It includes overuse and underuse.'),
  'D000078337': NtO(MH='Procedures and Techniques Utilization', MS='Extent of use of procedures or techniques. It includes overuse and underuse.'),
  'D000078338': NtO(MH='Equipment and Supplies Utilization', MS='Extent of use of equipment or supplies. It includes overuse and underuse.'),
  'D000078382': NtO(MH='Disgust', MS='A feeling of revulsion or strong disapproval aroused by something unpleasant or offensive.'),
  'D000078383': NtO(MH='Conscientious Refusal to Treat', MS='Refusal of health professionals to provide medical services on the basis of moral or religious beliefs.'),
  'D000078385': NtO(MH='Embarrassment', MS='A feeling of self-consciousness, shame, or awkwardness.'),
  'D000078402': NtO(MH='Gun Violence', MS='Violence using any type of firearm.'),
  'D000078404': NtO(MH='Epidermal Cells', MS='Cells from the outermost, non-vascular layer (EPIDERMIS) of the skin.'),
  'D000078405': NtO(MH='Non-Smokers', MS='Persons without a history of SMOKING.'),
  'D000078422': NtO(MH='Allogeneic Cells', MS='Cells from genetically different individuals of the same species to be used for CELL- AND TISSUE-BASED THERAPY; ADOPTIVE CELL TRANSFER; or ADOPTIVE IMMUNOTHERAPY.'),
  'D000078462': NtO(MH='Therapeutic Alliance', MS='A relational factor in counseling that includes three dimensions: goal consensus between counselor and client, collaboration on counseling-related tasks, and emotional bonding.  It is referred to as the working alliance between a therapist and a client in psychotherapy and closely correlated with positive client outcomes.'),
  'D000078463': NtO(MH='Child Labor', MS='Employment of MINORS in work that deprives children of their childhood, potential, dignity, and is harmful to their physical and mental development. (International Labor Organization, UN)'),
  'D000078482': NtO(MH='Prior Authorization', MS='A decision by a health insurer or plan that a health care service, treatment plan, prescription drug or durable medical equipment is medically necessary.'),
  'D000078483': NtO(MH='Regenerative Endodontics', MS='A dental specialty concerned with biologically-based procedures designed to physiologically replace damaged tooth structures, including dentin and root structures, as well as cells of the pulp-dentin complex.'),
  'D000078502': NtO(MH='Meat Proteins', MS='Dietary proteins from MEAT.'),
  'D000078503': NtO(MH='Poultry Proteins', MS='Dietary proteins from POULTRY.'),
  'D000078504': NtO(MH='Fish Proteins, Dietary', MS='Dietary protein from FISH.'),
  'D000078522': NtO(MH='Grain Proteins', MS='Dietary protein from EDIBLE GRAINS.'),
  'D000078542': NtO(MH='Proctectomy', MS='Surgical resection of the RECTUM.'),
  'D000078562': NtO(MH='Fruit Proteins', MS='Proteins found in FRUIT.'),
  'D000078563': NtO(MH='Nut Proteins', MS='Proteins from NUTS.'),
  'D000078582': NtO(MH='Shellfish Proteins', MS='Proteins found in SHELLFISH.'),
  'D000078602': NtO(MH='Sadness', MS='Feeling or showing sorrow; the sense of being unhappy. It is related to DEPRESSION but is not synonymous.'),
  'D000078604': NtO(MH='Secretagogues', MS='Substances that stimulate the secretion of another substance.'),
  'D000078622': NtO(MH='Nutrients', MS='Various components of food that are required for nourishment.'),
  'D000078623': NtO(MH='Wool Fiber', MS='Filament, thread, or yarn produced from WOOL.'),
  'D000078625': NtO(MH='Euthanasia, Involuntary', MS='The act or practice of killing or withholding life-sustaining treatment from a person with a medical condition, especially DISABLED PERSONS, without INFORMED CONSENT, despite the MENTAL COMPETENCY of the person to give consent.'),
  'D000078642': NtO(MH='Medical Countermeasures', MS='Regulated products (biologics, drugs, devices) that may be used in the event of a potential public health emergency stemming from a terrorist attack with a biological, chemical, or radiological/nuclear material, or a naturally occurring emerging disease.'),
  'D000078646': NtO(MH='Diaries as Topic', MS="Works on or about records, usually private, of writers' experiences, observations, feelings, attitudes, etc. They may also be works marked in calendar order in which to note appointments and the like."),
  'D000078662': NtO(MH='Collections as Topic', MS='Works about items gathered and assembled in some order to facilitate access or use.'),
  'D000078663': NtO(MH='Egocentrism', MS="Self-centered preoccupation or concern regarding one's own needs, abilities, wishes, desires, or preferences."),
  'D000078665': NtO(MH='Clinical Trials, Veterinary as Topic', MS='Works about clinical studies in which animal participants are assigned to receive one or more interventions so that researchers can evaluate the interventions on biomedical or health-related outcomes. The assignments are determined by the study protocol. Animal participants may receive diagnostic, therapeutic, or other types of interventions.'),
  'D000078682': NtO(MH='Respect', MS='A feeling of deep admiration for someone or something elicited by their abilities, qualities, or achievements and regard for the feelings, wishes, or rights of others.'),
  'D000078702': NtO(MH='Radiofrequency Therapy', MS='The use of RADIO WAVES to conduct therapeutic procedures. The specific frequency, dosage, and intensity used vary depending on the desired effects which include heating, electrical stimulation, or ablation of tissues.'),
  'D000078703': NtO(MH='Radiofrequency Ablation', MS='Removal of tissue using heat generated from electrodes delivering an alternating electrical current in the frequency of RADIO WAVES.'),
  'D000078704': NtO(MH='Quantitative Light-Induced Fluorescence', MS='A FLUORESCENCE technique used in DENTISTRY for the analysis of mineral changes in DENTAL ENAMEL to detect early DENTAL CARIES, or for the evaluation other normal or pathological processes or lesions of the dental enamel.'),
  'D000078722': NtO(MH='PC-3 Cells', MS='An epithelial cell line initiated from a human bone metastasis of a grade IV prostatic ADENOCARCINOMA.'),
  'D000078723': NtO(MH='Nuclear Receptor Interacting Protein 1', MS='A nuclear protein, characterized by multiple LXXLL motifs, that modulates activation of gene transcription by STEROID RECEPTORS, and transcriptional repression by NUCLEAR HORMONE RECEPTORS. It positively regulates gene expression of CIRCADIAN CLOCK PROTEINS AND PEPTIDES, including ARNTL TRANSCRIPTION FACTORS and CRYPTOCHROMES.'),
  'D000078724': NtO(MH='Pea Proteins', MS='Dietary proteins that are present in or isolated from the seeds of PISUM SATIVUM.'),
  'D000078742': NtO(MH='Substandard Drugs', MS='Drugs formulations that do not meet established standards.'),
  'D000078763': NtO(MH='Forms as Topic', MS='Works about documents used for acquiring particular information or for presenting particular information in a prescribed sequence and format, often with blank spaces or lines or other methods to prompt for insertion of the requested information.'),
  'D000078764': NtO(MH='Milnacipran', MS='A cyclopropanecarboxamide serotonin and norepinephrine reuptake inhibitor (SNRI) that is used in the treatment of FIBROMYALGIA.'),
  'D000078782': NtO(MH='Vaccinology', MS='Branch of medicine concerned with the development of vaccines to control disease by identifying genetic and other mechanisms and pathways that determine immune responses, and thereby provide new candidate vaccine approaches.'),
  'D000078783': NtO(MH='Standing Position', MS='Human position in which the body is held in an upright orthostatic position and supported only by the feet.'),
  'D000078784': NtO(MH='Vortioxetine', MS='A piperazine derivative that acts as a serotonin reuptake inhibitor, as a 5-HT3 receptor antagonist, and 5-HT1A receptor agonist. It is used for the treatment of anxiety and depression.'),
  'D000078785': NtO(MH='Mirtazapine', MS='A piperazinoazepine tetracyclic compound that enhances the release of NOREPINEPHRINE and SEROTONIN through blockage of presynaptic ALPHA-2 ADRENERGIC RECEPTORS. It also blocks both 5-HT2 and 5-HT3 serotonin receptors and is a potent HISTAMINE H1 RECEPTOR antagonist. It is used for the treatment of depression, and may also be useful for the treatment of anxiety disorders.'),
  'D000078787': NtO(MH='Neuroglobin', MS='A vertebrate globin that is expressed predominantly in the brain where it is involved in oxygen transport. It protects neurons from APOPTOSIS during OXIDATIVE STRESS.'),
  'D000078789': NtO(MH='Polyacetylene Polymer', MS='A polyene polymer that consists of alternating single and double bonds.'),
  'D000078790': NtO(MH='Insulin Secretion', MS='Production and release of insulin from PANCREATIC BETA CELLS that primarily occurs in response to elevated BLOOD GLUCOSE levels.'),
  'D000078791': NtO(MH='Tandem Affinity Purification', MS='A technique used to isolate specific interacting partners of MACROMOLECULAR COMPLEXES that have been assembled with a tagged component (bait) that interacts with other partners in the complex. The interacting bait component is labeled with a dual-affinity tag that allows for capture of the complex by IMMUNOPRECIPITATION, followed by purification of only the partners of the complex interacting with the bait by affinity chromatography.'),
  'D000078792': NtO(MH='Midkine', MS='A developmentally regulated, HEPARIN-binding secreted growth factor homologous to pleiotrophin (PTN). It regulates cell proliferation through its interaction with ANAPLASTIC LYMPHOMA KINASE (ALK) and is involved in the formation of NEOINTIMA following arterial injury.'),
  'D000078822': NtO(MH='Ex-Smokers', MS='Persons who do not smoke but that have a history of SMOKING.'),
  'D000078842': NtO(MH='Cytoglobin', MS='A globin protein that may protect cells from OXIDATIVE STRESS and function in intracellular oxygen storage and transfer.'),
  'D000078862': NtO(MH='Levomilnacipran', MS='The (1S,2R)-isomer of milnacipran that is used for the treatment of MAJOR DEPRESSIVE DISORDER.'),
  'D000078882': NtO(MH='Web Archives as Topic', MS='Works about collections of preserved web pages.'),
  'D000078903': NtO(MH='Catalog, Drug', MS='Lists of drugs for sale.'),
  'D000078922': NtO(MH='Catalog, Union', MS='Lists of books and other information sources held among a cooperating group of LIBRARIES.'),
  'D000078925': NtO(MH='Catalog, Commercial', MS='Lists of merchandise for sale.'),
  'D000078928': NtO(MH='Formulary, Homeopathic', MS='Work about Formulary concerned with HOMEOPATHIC REMEDIES.'),
  'D000078929': NtO(MH='Formulary, Hospital', MS='Formulary concerned with PHARMACEUTICAL PREPARATIONS prescribed in hospitals.'),
  'D000078930': NtO(MH='Pharmacopoeia, Homeopathic', MS='Authoritative resource describing the composition, properties, manufacture, and quality control of HOMEOPATHIC REMEDIES.'),
  'D000078942': NtO(MH='Web Archive', MS='Collection of preserved web pages.'),
  'D000078984': NtO(MH='Formulary, Dental', MS='Works on or about reference lists of descriptions and uses of drugs related to oral medicine and dentistry.'),
  'D000078985': NtO(MH='Clinical Trial Protocols as Topic', MS="Works about the written descriptions of a clinical study. It contains the study's objectives, design, and methods including subject target and/or enrollment criteria. It may also present relevant scientific background and statistical information."),
  'D000079': NtO(MH='Acetaldehyde', MS='A colorless, flammable liquid used in the manufacture of acetic acid, perfumes, and flavors. It is also an intermediate in the metabolism of alcohol. It has a general narcotic action and also causes irritation of mucous membranes. Large doses may cause death from respiratory paralysis.'),
  'D000079042': NtO(MH='Maze Procedure', MS='A surgical treatment in which heart tissue is scarred (cut-and-sew method), excised or otherwise destroyed in an open chest approach to direct electrical signals through a more controlled path via the ATRIOVENTRICULAR NODE. It is often used to restore normal rhythms in ATRIAL FIBRILLATION.'),
  'D000079062': NtO(MH='Interpersonal Psychotherapy', MS='Interpersonal modification of psychodynamic psychotherapy. Therapy is present-focused and seeks to resolve problems in interpersonal relations. Aspects of attachment theory are used to analyze how past relationships affect current relationships.'),
  'D000079102': NtO(MH='Empowerment', MS='Process of increasing the capacity of individuals or groups to make choices and to transform those choices into desired actions as deigned by the individuals or groups.'),
  'D000079103': NtO(MH='Scope of Practice', MS='The services that licensed professionals are deemed competent to perform, and permitted to undertake in keeping with the terms of their professional license.'),
  'D000079142': NtO(MH='Shared Medical Appointments', MS='Clinical encounters in which patients receive healthcare from one or more health professionals, in a group setting. These may include patient education and counseling, physical examination, and clinical support. Patients usually share a mutual attribute such as a medical condition.'),
  'D000079182': NtO(MH='Body Dissatisfaction', MS="Person\xe2\x80\x99s negative thoughts about his or her own body.  This includes judgements about size and shape, muscle tone and generally involves a discrepancy between one's own body type and an ideal body type. (Grogan, 2008)"),
  'D000079203': NtO(MH='Disruptive Technology', MS='A process by which a product or service takes root initially in simple applications at the bottom of a market and then relentlessly moves up market, eventually displacing established competitors. (http://www.claytonchristensen.com/key-concepts)'),
  'D000079204': NtO(MH='Public Reporting of Healthcare Data', MS='Required public availability of quality indicators data from health facilities.'),
  'D000079223': NtO(MH='Observational Studies, Veterinary as Topic', MS='Works about clinical studies in which animal subjects may receive diagnostic, therapeutic, or other types of interventions and where the investigator does not assign subjects  to specific interventions.'),
  'D000079224': NtO(MH='Demoralization', MS='Weakening of hope, courage, or confidence.'),
  'D000079225': NtO(MH='Psychological Distress', MS='Negative emotional state characterized by physical and/or emotional discomfort, pain, or anguish.'),
  'D000079243': NtO(MH='Involuntary Commitment', MS='Non-voluntary institutionalization or isolation following refusal or failure to take medication, to complete treatment, or to adhere to infection control precautions, or behavior that may or does endanger self or others.'),
  'D000079245': NtO(MH='Dry Needling', MS='Intervention that uses a thin filiform needle to penetrate the skin and stimulate underlying myofascial trigger points, muscular, and connective tissues for the management of neuromusculoskeletal pain and movement impairments.'),
  'D000079262': NtO(MH='Obesity, Maternal', MS='BODY MASS INDEX in PREGNANT WOMEN that is excessively above the recommended cut-off.'),
  'D000079263': NtO(MH='Vaccine-Preventable Diseases', MS='Diseases for which vaccines exist that can confer partial or complete protection. (World Health Organization vaccine-safety-training.org)'),
  'D000079264': NtO(MH='Environmental Indicators', MS='Data related to climate change, ozone layer depletion, eutrophication, acidification, toxic contamination, urban environmental quality, biodiversity, cultural landscapes, waste, water resources, forest resources, fish resources, and soil degradation including desertification and erosion. (from https://www.oecd.org/env/indicators-modelling-outlooks/37551205.pdfc).'),
  'D000079265': NtO(MH='Environmental Science', MS='Scientific discipline that studies external factors, both biotic (living) and abiotic (nonliving), to which an organism is exposed.'),
  'D000079282': NtO(MH='Vaccine Excipients', MS='Media added to a vaccine for a specific purpose. These include: preservatives to prevent contamination, adjuvants to stimulate a stronger immune response, and stabilizers. (From https://www.cdc.gov/vaccines pubs/pinkbook/downloads/appendices/b/excipient-table-2.pdf)'),
  'D000079302': NtO(MH='Necroptosis', MS='A form of regulated cell death initiated by perturbations of extracellular or intracellular homeostasis that trigger a specific cell death pathway involving the activation of RIPK3 and MLKL (mixed lineage kinase domain like pseudokinase). Morphological changes include cytoplasmic and organellar swelling, rupture of the PLASMA MEMBRANE, and CHROMATIN CONDENSATION.'),
  'D000079322': NtO(MH='Weight Prejudice', MS='Negative attitudes towards and beliefs about others because of their weight. These negative attitudes are manifested by stereotypes and/or prejudice towards people with weight over or under a cultural norm.'),
  'D000079323': NtO(MH='Parthanatos', MS='A type of regulated cell death initiated by hyperactivation of POLY (ADP-RIBOSE) POLYMERASE-1 (PARP-1) as a consequence of DNA DAMAGE; OXIDATIVE STRESS; HYPOXIA; HYPOGLYCEMIA; or INFLAMMATION. This leads to DNA FRAGMENTATION and CHROMATIN condensation.'),
  'D000079382': NtO(MH='Internet-Based Intervention', MS='Use of the INTERNET to facilitate the dissemination of health-related information and to connect patients to support.'),
  'D000079402': NtO(MH='National Program of Cancer Registries', MS='A unit of the United States Centers for Disease Control and Prevention that supports the collection of high-quality data on cancer occurrence (including the type, extent, and location of the cancer), the type of initial treatment, and outcomes.'),
  'D000079403': NtO(MH='Ferroptosis', MS='A form of REGULATED CELL DEATH initiated by oxidative perturbations of the intracellular microenvironment that is under constitutive control by glutathione peroxidase 4 and can be inhibited by iron chelators and lipophilic antioxidants.'),
  'D000079404': NtO(MH='Regulated Cell Death', MS='Genetically encoded mechanisms in multicellular and unicellular eukaryotes that function to eliminate cells that are superfluous either during development, or to maintain tissue and organism homeostasis; and cells that are irreversibly damaged, abnormal, and/or potentially harmful.'),
  'D000079424': NtO(MH='Tumor Necrosis Factor Inhibitors', MS='Compounds or agents that bind to and inhibit the synthesis or activity of TUMOR NECROSIS FACTOR-alpha. Such agents are used to treat inflammatory bowel diseases and other inflammatory diseases.'),
  'D000079425': NtO(MH='Genetic Introgression', MS='The transfer of genetic material from one species to another by inter-species hybridization and repeated backcrossing.'),
  'D000079426': NtO(MH='Vector Borne Diseases', MS='Infectious diseases transmitted by DISEASE VECTORS.'),
  'D000079482': NtO(MH='Claustrum', MS='A gray matter lamina located underneath the inner NEOCORTEX lateral to the PUTAMEN and medial to the INSULAR CORTEX. It is considered to be a part of the basal ganglia. Extensive claustral projections exist to most cortices and subcortical structures including the AMYGDALA, the CAUDATE NUCLEUS, the HIPPOCAMPUS and the THALAMUS.'),
  'D000079522': NtO(MH='E-Cigarette Vapor', MS='Complex mixture of vaporized chemicals emitted during SMOKING of E-CIGARETTES.'),
  'D000079524': NtO(MH='Narcotic-Related Disorders', MS='Disorders related to or resulting from abuse or misuse of NARCOTICS.'),
  'D000079527': NtO(MH='Immunogenic Cell Death', MS='A form of regulated cell death that results in release of specific DAMAGE ASSOCIATED MOLECULAR PATTERN MOLECULES which activate an ADAPTIVE IMMUNE RESPONSE. It can be initiated in any type of cell by a restricted set of stimuli, including viral infection, some chemotherapeutics or immunogenic radiation therapy.'),
  'D000079530': NtO(MH='Mitochondrial Transmembrane Permeability-Driven Necrosis', MS='A form of regulated cell death that is initiated by specific perturbations of the intracellular microenvironment such as severe OXIDATIVE STRESS and cytosolic CALCIUM overload, which result in osmotic breakdown of the MITOCHONDRIAL MEMBRANES.'),
  'D000079542': NtO(MH='Tithonia', MS='A genus of flowering plants in the ASTERACEAE family. It is found in MEXICO; CENTRAL AMERICA; and SOUTHWESTERN UNITED STATES.'),
  'D000079543': NtO(MH='Ligularia', MS='A genus of ornamental plants in the family ASTERACEAE, often found near water.'),
  'D000079562': NtO(MH='Rumination Syndrome', MS='A gastrointestinal disorder characterized by repetitive and effortless regurgitation of ingested food from the stomach to the oral cavity in the early POSTPRANDIAL PERIOD. It is associated with functional gastrointestinal pathology (e.g., increased intra-gastric pressure) and psychiatric disorders (e.g., anxiety, depression). It is not limited to infants and distinct from GERD and VOMITING.'),
  'D000079564': NtO(MH='Globus Sensation', MS='A feeling of a lump in the throat that occurs between meals in the absence of other gastrointestinal and motility disorders (e.g., DYSPHAGIA; GASTROESOPHAGEAL REFLUX).'),
  'D000079584': NtO(MH='Actinoplanes', MS='A genus of zoospore-forming bacteria in the Micromonosporaceae family that is a source of many clinically important natural products.'),
  'D000079585': NtO(MH='Cell Encapsulation', MS='The encapsulation of cells into semi-permeable microcapsules or MICROSPHERES that permits protection of encapsulated cells and allows passage of essential nutrients and release of a therapeutic product (e.g. INSULIN).'),
  'D000079602': NtO(MH='Sino-Nasal Outcome Test', MS='Patient-reported measure of outcome in sino-nasal disorders such as rhinosinusitis and nasal polyposis.'),
  'D000079603': NtO(MH='Rapid Sequence Induction and Intubation', MS='A method of maintaining airway patency and administering anesthesia during emergency situations when it cannot be determined if the patient is fasting or not; or in other instances where there is a risk of aspiration. The method includes a series of events that involve the administration of SEDATIVES to induce unconsciousness, followed by NEUROMUSCULAR BLOCK AGENTS to improve the intubating conditions, followed by endotracheal intubation.'),
  'D000079644': NtO(MH='Military Health', MS='The physical and mental conditions of MILITARY PERSONNEL, active duty and retired U.S. Military personnel and their dependents.'),
  'D000079645': NtO(MH='Perioperative Medicine', MS='A medical specialty concerned with the patient before and after surgical procedures.'),
  'D000079662': NtO(MH='Chronic Disease Indicators', MS='A set of surveillance indicators of disease developed by consensus among the CDC, the Council of State and Territorial Epidemiologists, and the National Association of Chronic Disease Directors. It enables public health professionals and policymakers to retrieve uniformly defined state and selected metropolitan-level data for CHRONIC DISEASES and RISK FACTORS that impact public health.(https://www.cdc.gov/socialdeterminants/data/index.htm)'),
  'D000079664': NtO(MH='Continuous Renal Replacement Therapy', MS='Procedures with continuous blood purification (e.g., dialysis, filtration or perfusion) via vascular access designed to mimic kidney function in kidney diseases (e.g., ACUTE RENAL FAILURE and poisoning).'),
  'D000079685': NtO(MH='Famine', MS='The conditions when at least 20 per cent of households in an area face extreme food shortages with a limited ability to cope; acute malnutrition rates exceed 30 per cent; and the death rate exceeds two persons per day per 10,000 persons. (From news.un.org/en/story/2011/07/382342-when-food-security-crisis-becomes-famine)'),
  'D000079686': NtO(MH='Wastewater-Based Epidemiological Monitoring', MS='Sampling of the liquids generated from industrial processes, sanitary fixtures and appliances, food handling, etc., to collect and analyze epidemiological information (such as pathogen levels, or concentrations of pesticides, pharmaceuticals, or other substances) from metabolic excretion products, household liquid wastes, and industrial wastes.'),
  'D000079687': NtO(MH='Biological Monitoring', MS='Monitoring of the level of toxins, chemical pollutants, microbial contaminants, or other harmful substances in the bodies of living organisms, by DIAGNOSTIC IMAGING or by analyzing BLOOD; URINE; BREAST MILK; SALIVA, etc.'),
  'D000079689': NtO(MH='Opioid-Induced Constipation', MS='CONSTIPATION associated with the use of OPIOIDS.'),
  'D000079690': NtO(MH='Postoperative Cognitive Complications', MS='COGNITIVE IMPAIRMENT or functional decline after a surgical procedure.'),
  'D000079691': NtO(MH='School Mental Health Services', MS='Services which focus on the mental well-being of pre-college and pre-university students that include COUNSELING and therapy.'),
  'D000079702': NtO(MH='Pomegranate', MS='A deciduous shrub or small tree in the family Lythraceae, order Myrtales, superorder Rosanae. It bears edible reddish-purple fruit berries with seeds and pulp produced from the ovary of a single flower.'),
  'D000079742': NtO(MH='Cupping Therapy', MS='A traditional practice, most notably in traditional medicine, which involves placing cups on the skin to create suction believed to help increase blood flow and promote healing associated with chronic neck and low back pain in the short term (From National Center for Complementary and Integrative Health, https://nccih.nih.gov/news/cupping (Accessed 11/5/2018)).'),
  'D000079763': NtO(MH='Intermittent Renal Replacement Therapy', MS='Procedures with non-continuous blood purification (e.g., dialysis, filtration and/or perfusion) via vascular access by increasing blood flow rate compared to CONTINUOUS RRT.'),
  'D000079782': NtO(MH='Hybrid Renal Replacement Therapy', MS='Procedures involving non-continuous blood purification (e.g., dialysis, filtration or perfusion) via vascular access with settings for dialysate and blood flow rates and treatment duration settings hybrid between CRRT TECHNIQUE and IRRT TECHNIQUE.'),
  'D000079803': NtO(MH='Data Management', MS='Processes that include acquiring, validating, storing, protecting, and processing data to ensure accessibility, reliability, and timeliness for users.'),
  'D000079822': NtO(MH='Extranodal Extension', MS='A penetration of LYMPH NODE metastatic cells through the nodal capsule into the perinodal fatty tissue used in a TUMOR STAGING system (the TNM staging system).'),
  'D000079883': NtO(MH='Securinega', MS='A plant genus of the family EUPHORBIACEAE, order MALPIGHIALES. Members contain securinine and virosecurinine compounds.'),
  'D000079922': NtO(MH='Copper Transport Proteins', MS='Membrane proteins that facilitate the transport of copper cations across biological membranes.'),
  'D000079923': NtO(MH='Copper Transporter 1', MS='A high-affinity, saturable copper transporter of the PLASMA MEMBRANE that functions in the absorption of dietary copper.'),
  'D000079962': NtO(MH='RNA, Circular', MS="RNA molecules in which the 3' and 5' ends are covalently joined to form a closed continuous loop. They are resistant to digestion by EXORIBONUCLEASES."),
  'D000079963': NtO(MH='Brentuximab Vedotin', MS='Immunoconjugate that consists of the chimeric monoclonal anti - CD30 ANTIGEN antibody cAC-10 conjugated to monomethyl auristatin E. It is used for the treatment of LYMPHOMA.'),
  'D000079982': NtO(MH='Gemtuzumab', MS='Immunotoxin that consists of an anti-CD33 (CD33 ANTIGEN) monoclonal antibody conjugated to CALICHEAMICIN. It is used for the treatment of ACUTE MYELOID LEUKEMIA.'),
  'D000080': NtO(MH='Acetals', MS="Diethers with the structure -C(OR'')(OR'''), where R'' and  R''' are not hydrogen. Mixed acetals have R'' and R''' groups which differ."),
  'D000080002': NtO(MH='Protein-Arginine Deiminase Type 4', MS='A histone modification enzyme, which converts both ARGININE and monomethyl-arginine to CITRULLINE. It is one of several protein-arginine deiminase isoenzymes. It is a gene regulator involved in APOPTOSIS and CELL DIFFERENTIATION and a potential therapeutic target for the treatment of a variety of diseases.'),
  'D000080027': NtO(MH='Cyclams', MS='Compounds made of fourteen-member tetraamine macrocycles which bind strongly to a wide range of metal ions.'),
  'D000080029': NtO(MH='Citizen Science', MS='Voluntary public participation in the scientific process, addressing real-world problems in ways that may include formulating research questions, conducting scientific experiments, collecting and analyzing data, interpreting results, making new discoveries, developing technologies and applications, for solving complex problems. (From https://www.citizenscience.gov/)'),
  'D000080030': NtO(MH='Legal Epidemiology', MS='Scientific study of law as a factor in the cause, distribution, and prevention of disease and injury.  (From https://read.dukeupress.edu/jhppl/article/41/6/1151/40084/Policy-Surveillance-A-Vital-Public-Health-Practice).'),
  'D000080031': NtO(MH='Limited English Proficiency', MS='Limited ability to communicate with or understand English.'),
  'D000080032': NtO(MH='Psychology, Positive', MS='The scientific study of the strengths that enable individuals and communities to thrive. It is founded on the belief that people want to lead meaningful and fulfilling lives, to cultivate what is best within themselves, and to enhance their experiences of love, work, and play. (https://ppc.sas.upenn.edu/)'),
  'D000080033': NtO(MH='Public Nondiscrimination Policies', MS='Policies that include the existence of a body responsible for the articulation and implementation of a platform based on an equality perspective that requires the integration of race-ethnicity, differences in sexual orientation, as well as the demands and needs arising from differences within the executive. Its objective is to translate a programmatic vision into action and action axes that reflects the struggle for egalitarian social relations. (From http://bit.ly/28WAaYO)'),
  'D000080037': NtO(MH='Historical Trauma', MS='Clinical distress among descendants of survivors of mass trauma, as if they had suffered through the same extreme historic circumstances. Symptoms may persist through generations.'),
  'D000080038': NtO(MH='Anomalous Left Coronary Artery', MS='Malformations of left CORONARY ARTERY where it is connected to the PULMONARY ARTERY instead of the AORTA.'),
  'D000080039': NtO(MH='Univentricular Heart', MS='Rare congenital heart malformation with a single ventricle (HEART VENTRICLES) instead of the usual two.'),
  'D000080041': NtO(MH='Congenitally Corrected Transposition of the Great Arteries', MS='A rare heart defect that occurs when the HEART VENTRICLES and attached valves, the MITRAL VALVE and the TRICUSPID VALVE are reversed so that the AORTA and the PULMONARY ARTERY are connected to the wrong ventricle. Although the heart valves and the two great arteries, the PULMONARY ARTERY and the AORTA are transposed, the blood flows to the correct place because the ventricles are also reversed and therefore corrects the transposition. It often occurs with other structural heart abnormalities.'),
  'D000080044': NtO(MH='Ado-Trastuzumab Emtansine', MS='Immunotoxin that consists of humanized monoclonal anti-HER2 antibody TRASTUZUMAB covalently linked to anti-microtubule agent MAYTANSINOID DM1 for treatment of metastatic breast cancer in patients who previously received trastuzumab and a TAXANES, separately or in combination.'),
  'D000080045': NtO(MH='Inotuzumab Ozogamicin', MS='Immunotoxin that consists of anti-CD22 (CD22 ANTIGEN) humanized monoclonal antibody covalently linked to the antineoplastic antibiotic CALICHEAMICIN. It is used for the treatment of adults with relapsed or refractory B-cell precursor acute lymphoblastic leukemia (LEUKEMIA, ACUTE LYMPHOBLASTIC).'),
  'D000080048': NtO(MH='Hot Melt Extrusion Technology', MS='Solvent-free method for preparing numerous types of drug delivery systems and dosage forms for active pharmaceutical ingredients that have solubility issues. It involves pumping polymeric materials at temperatures above their glass transition temperature to mix in active pharmaceutical ingredients with or without binders thus forming an amorphous product with an  increase in the dissolution profile for the active pharmaceutical ingredients.'),
  'D000080050': NtO(MH='Para-Athletes', MS='Physically disabled individuals who have developed skills, physical stamina and strength to participate in SPORTS or other physical activities.'),
  'D000080051': NtO(MH='Community-Based Health Insurance', MS='Low-cost HEALTH INSURANCE in which community, cooperative, mutual, and/or self-help resources are pooled to mitigate health risks and cover health care services in full or in part.'),
  'D000080052': NtO(MH='Opioid Epidemic', MS='Widespread use of OPIOIDS by disproportionately large numbers of individuals within a population, community, or region occurring within a relatively narrow window of time.'),
  'D000080054': NtO(MH='Pinales', MS='Order of Conifers of the class Pinopsida, subdivision Spermatophytina, and division Tracheophyta. The distinguishing attribute of the Pinales is the reproductive structure known as a cone.'),
  'D000080056': NtO(MH='Araucariaceae', MS='A family of dioecious or monoecious evergreen trees belonging to the order Pinales, subclass Pinidaes, with spirally arranged, narrow or broad leaves often with parallel veins.'),
  'D000080057': NtO(MH='Araucaria', MS='A genus of evergreen conifer of the family Araucariaceae, order Pinales, that includes the monkey puzzle (Araucaria Araucana).'),
  'D000080059': NtO(MH='Araucaria araucana', MS='An evergreen tree commonly known as the monkey-puzzle tree. It grows to 1-1.5 m in diameter and 30-40 m in height, and is native to central and southern Chile, and western Argentina. Araucaria araucana is the hardiest among the conifers, and due to its longevity, is often described as a living fossil.'),
  'D000080062': NtO(MH='Protein-Arginine Deiminase Type 1', MS='A peptidylarginine deiminase isoenzyme. It is a post-translational modification enzyme that catalyzes the conversion of protein-bound ARGININE residues to CITRULLINE residues in a CALCIUM ion-dependent manner. It functions within the epidermis, targeting INTERMEDIATE FILAMENTS; KERATINS; and filaggrin for CITRULLINATION to promote epidermal cornification.'),
  'D000080063': NtO(MH='Protein-Arginine Deiminase Type 3', MS='A post-translational enzyme that catalyzes the conversion of protein bound arginine residues to CITRULLINE residues in a CALCIUM ion-dependent manner. PADI3 is a peptidylarginine deiminase isoenzyme expressed in epidermal tissue.'),
  'D000080064': NtO(MH='Protein-Arginine Deiminase Type 2', MS='A widely expressed isoenzyme of peptidylarginine deiminase, a post-translational modification enzyme that catalyzes the conversion of protein-bound ARGININE residues to CITRULLINE residues in a CALCIUM ion-dependent manner.'),
  'D000080065': NtO(MH='Protein-Arginine Deiminase Type 6', MS='A peptidylarginine deiminase isoenzyme mainly expressed in egg and embryo tissues. It is a post-translational modification enzyme that catalyzes the conversion of protein-bound ARGININE residues to CITRULLINE residues in a CALCIUM ion-dependent manner.'),
  'D000080066': NtO(MH='Contraceptive Agents, Hormonal', MS='Contraceptive agents that act on the ENDOCRINE SYSTEM.'),
  'D000080083': NtO(MH='SLC31 Proteins', MS='Eukaryotic copper transport proteins that function primarily in the transport of dietary or environmental COPPER.'),
  'D000080084': NtO(MH='Calicheamicins', MS='Enediyne aminoglycosides derived from the bacterium MICROMONOSPORA ECHINOSPORA that are used as antineoplastic antibiotics. They bind to DNA in both healthy and tumor cells, resulting in strand scission and cell death.'),
  'D000080103': NtO(MH='Emotional Regulation', MS='The manifestation of an emotional response by which individuals influence the intensity, duration, valence, or manifestation of their response. Emotion regulation either precedes (avoidance, interpretation) or follows an emotion (suppression, reappraisal). Emotion regulation is distinct from coping (focuses primarily on decreasing a negative emotional experience), and can include increasing or decreasing both positive and negative emotions consciously or unconsciously.'),
  'D000080104': NtO(MH='Fertility Clinics', MS='Health clinics offering fertility treatment services.'),
  'D000080105': NtO(MH='Relational Autonomy', MS='The social context within which all individuals exist and acknowledge the emotional and embodied aspects of decision-makers. The approach acknowledges the central role of others in decision-making, including clinicians, who have a responsibility to engage patients\xe2\x80\x99 and surrogates\xe2\x80\x99 emotional experiences.'),
  'D000080122': NtO(MH='Edible Films', MS='Packaging materials that can be directly consumed. They provide barrier and protection, while enhancing quality and safety of food products. (Bourtoom, 2008).'),
  'D000080146': NtO(MH='Avoidant Restrictive Food Intake Disorder', MS='An eating or feeding disturbance (e.g., apparent lack of interest in eating or food; avoidance based on the sensory characteristics of food; concern about aversive consequences of eating) as manifested by persistent failure to meet appropriate nutritional and/or energy needs associated with one (or more) of the following: significant weight loss (or failure to achieve expected weight gain or faltering growth in children); significant nutritional deficiency; dependence on enteral feeding or oral nutritional supplements; or marked interference with psychosocial functioning. (from DSM-V)'),
  'D000080162': NtO(MH='Early Warning Score', MS='Tool for bedside evaluation based on five physiological parameters: SYSTOLIC PRESSURE, PULSE, RESPIRATORY RATE, BODY TEMPERATURE and AVPU (alert, voice, pain, unresponsive) score.'),
  'D000080165': NtO(MH='Extreme Weather', MS='Events that have extreme values of important meteorological variables. Extreme is generally defined as either taking maximum values or exceedance above pre-existing high thresholds. Such events are generally rare; for example, extreme wind speeds exceeding the 100-year return value, which have a probability of only 0.01 of occurring in any particular year. (Stephenson, 2008)'),
  'D000080183': NtO(MH='Intersex Persons', MS='Those individuals with INTERSEX CONDITIONS, with or without a desire to undergo SEX REASSIGNMENT PROCEDURES.'),
  'D000080203': NtO(MH='Hamman-Rich Syndrome', MS='Acute idiopathic interstitial pneumonitis characterized by diffuse PULMONARY ALVEOLI damage with uniform edematous connective tissue proliferation. It is often associated with extensive fibroblastic distortion of the lung parenchyma and leads to ADULT RESPIRATORY DISTRESS SYNDROME in later stages.'),
  'D000080222': NtO(MH='Pancreaticobiliary Maljunction', MS='A group of anatomical variations in which the COMMON BILE DUCT and MAIN PANCREATIC DUCT are joined outside the duodenal wall often with abnormally long common channel rather than at the SPHINCTER OF ODDI.'),
  'D000080223': NtO(MH='Chronic Urticaria', MS='Wheals and/or angioedema presented with daily symptoms lasting for more than 6 weeks. It may be classified into chronic spontaneous and chronic inducible urticaria depending on whether a specific trigger can be linked to the development of vascular reaction.'),
  'D000080224': NtO(MH='Animal Proteins, Dietary', MS='DIETARY PROTEINS derived from ANIMALS.'),
  'D000080242': NtO(MH="8-Hydroxy-2'-Deoxyguanosine", MS='Common oxidized form of deoxyguanosine in which C-8 position of guanine base has a carbonyl group.'),
  'D000080282': NtO(MH='Hormonal Contraception', MS='Contraceptive methods that utilize HORMONAL CONTRACEPTIVE AGENTS.'),
  'D000080304': NtO(MH='Cricket Sport', MS='A competitive sport played with a bat and ball between two teams of eleven players.'),
  'D000080305': NtO(MH='Pork Meat', MS='MEAT or flesh of a pig (Sus scrofa) used as food.'),
  'D000080307': NtO(MH='Hydrogen Deuterium Exchange-Mass Spectrometry', MS='A mass spectrometry method utilizing hydrogen-deuterium exchange kinetics to study conformational and dynamic changes especially of proteins, such as interactions during ligand binding and allosteric effects during catalysis.'),
  'D000080308': NtO(MH='Cardio Ankle Vascular Index', MS='An index of ARTERIAL STIFFNESS obtained from PULSE WAVE VELOCITY measurements between the heart and the ankle.'),
  'D000080309': NtO(MH='Environmental DNA', MS='DNA found in the ENVIRONMENT that is from the residual biological materials of the organisms in the environment.'),
  'D000080310': NtO(MH='Smart Glasses', MS='Computerized eyewear with multiple technological applications for advanced computing and interoperability. Smart glasses are optimized to facilitate information and data access, capture, display, transfer, and manipulation.'),
  'D000080311': NtO(MH='Synesthesia', MS='The experience of involuntary sensory cross activation where the presentation of a particular stimulus elicits a secondary sensory-perceptual experience. It most commonly occurs in the association of color with linguistic stimuli such as letters, numbers, words, or music, but can also occur between other senses. Although synesthesia can be acquired or transient due to trauma or drug use, there is also a strong genetic component, with a prevalence of about 1 in 2,000 individuals and a female to male ratio of 6:1.'),
  'D000080322': NtO(MH='Cyclodialysis Clefts', MS='Finding of a separation of the CILIARY BODY in the SCLERAL SPUR region, creating aqueous outflow from the ANTERIOR CHAMBER into suprachoroidal space between the CHOROID and the SCLERA. Persistent cyclodialysis clefts may be associated with OCULAR HYPOTENSION and OPTIC DISC EDEMA.'),
  'D000080323': NtO(MH='Uveal Effusion Syndrome', MS='Rare disease characterized by suprachoroidal fluid accumulation between the CHOROID and the SCLERA, annular detachment of the CHOROID, often with secondary RETINAL DETACHMENT; OPTIC DISK EDEMA, and minimal signs of UVEITIS and INTRAOCULAR PRESSURE changes.'),
  'D000080324': NtO(MH='Choroidal Effusions', MS='Finding of fluid accumulation between the CHOROID and the SCLERA.'),
  'D000080343': NtO(MH='Meibomian Gland Dysfunction', MS='A chronic dysfunction of MEIBOMIAN GLANDS characterized by altered tear film stability and function due to a decrease or alteration in lipid quality/content in meibum. It is often associated with evaporative-type DRY EYE SYNDROME.'),
  'D000080344': NtO(MH='Optic Nerve Hypoplasia', MS='A group of rare genetic disorders characterized by underdeveloped OPTIC NERVES, resulting in increased incidences of vision impairment, CONGENITAL NYSTAGMUS and STRABISMUS. It may be syndromic, and is often associated with CNS malformations.'),
  'D000080345': NtO(MH='Familial Exudative Vitreoretinopathies', MS='A group of inherited disorders characterized by incomplete development of the retinal vasculature. Its severity can vary from complete blindness in infancy, to mild or no visual problems, where small areas of vascular defects are observable only by FLUORESCEIN ANGIOGRAPHY. Exudative vitreoretinopathy 1 is associated with mutations in the FZD4 gene.'),
  'D000080346': NtO(MH='Retinal Arterial Macroaneurysm', MS='An acquired dilation of the retinal artery often associated with systemic HYPERTENSION.'),
  'D000080362': NtO(MH='Stargardt Disease', MS='A juvenile-onset macular dystrophy characterized by progressive loss of VISUAL ACUITY with normal acuity in peripheral VISUAL FIELDS. Other associated clinical features may include LIPOFUSCIN fundus autofluorescence, atrophy of the RETINAL PIGMENT EPITHELIUM, loss of color vision, PHOTOPHOBIA and PARACENTRAL SCOTOMA. Germline mutations in the ABCA4 gene have been identified in recessive and dominant diseases.'),
  'D000080363': NtO(MH='White Dot Syndromes', MS='A group of idiopathic multifocal posterior uveitis syndromes involving the CHOROID; RETINAL PIGMENT EPITHELIUM; and RETINA. They are characterized by multiple lesions of hypoautofluorescent dots in the FUNDUS OCULI and reduced VISUAL ACUITY. Several entities including BIRDSHOT CHORIORETINOPATHY are HLA-A ANTIGENS serotype A29 positive.'),
  'D000080364': NtO(MH='Multifocal Choroiditis', MS='A multifocal uveitis syndrome involving the RETINAL PIGMENT EPITHELIUM and capillary layer of the CHOROID. It is characterized by chronic UVEITIS and multiple CHOROID lesions referred to as white dots, blurry vision, floaters, sensitivity to light, blind spots, and eye discomfort.'),
  'D000080365': NtO(MH='Birdshot Chorioretinopathy', MS='A form of chorioretinitis characterized by multiple small, cream-colored LESIONS, symmetrically scattered mainly around the OPTIC DISK. These lesions are the most distinctive sign and often appear at the level of the RETINAL PIGMENT EPITHELIUM but, on occasion, suggest an even deeper infiltration and may ultimately lead to visual loss. An association with HLA-A29 antigen (see HLA-A ANTIGENS) has been observed in nearly all patients.'),
  'D000080383': NtO(MH='Mental Foramen', MS='An opening on the anterolateral aspect of the MANDIBLE through which the mental nerve bundle and vessels exit.'),
  'D000080384': NtO(MH='Allergoids', MS='Extracts of allergens, or purified allergens that have been chemically modified to reduce their ability to induce IGE-MEDIATED HYPERSENSITIVITY (allergenicity) while increasing their ability to induce IMMUNE TOLERANCE.'),
  'D000080385': NtO(MH='Nanogels', MS='Three-dimensional biocompatible materials formed by cross-linking a hydrophilic polymeric component (e.g., HYDROGELS). They are typically spherical particles in a size range of 20-250 nm when used for drug delivery applications.'),
  'D000080386': NtO(MH='Microgels', MS='Three-dimensional biocompatible polymers in micrometer size range. They are typically spherical particles in a size range of 1-350 micrometers when used for drug delivery and 3D cell culture applications.'),
  'D000080422': NtO(MH='Locked-In Syndrome', MS='Acquired neuromuscular disorder characterized by complete paralysis of voluntary muscles and lower CRANIAL NERVES except for limited voluntary eye movements. It is due to various cerebrospinal disconnections at or near the PONS and the POSTERIOR CRANIAL FOSSA, typically secondary to pontine hemorrhage or infarct. Because cognitive function is intact it is sometimes referred to as a pseudocoma state.'),
  'D000080423': NtO(MH='Universal Health Care', MS='Access for all people to needed health services (including prevention, promotion, treatment, rehabilitation and palliation) of sufficient quality to be effective while also ensuring that the use of these services does not expose the user to financial hardship. (From https://www.who.int/healthsystems/universal_health_coverage/en/)'),
  'D000080424': NtO(MH='Cytokine Release Syndrome', MS='A systemic inflammatory response triggered by a variety of factors used in IMMUNOTHERAPY. It is characterized by marked elevations of various inflammatory CYTOKINES and by the following associated conditions: DYSPNEA; FEVER; HEADACHE; HYPOTENSION; NAUSEA; RASH; TACHYCARDIA and/or HYPOXIA.'),
  'D000080442': NtO(MH='Social Integration', MS='A dynamic and principled process where all members participate in dialogue to achieve and maintain peaceful social relations. It does not include coerced assimilation or forced integration. (from https://www.un.org/esa/socdev/sib/peacedialogue/soc_integration.htm)'),
  'D000080443': NtO(MH='Diffuse Intrinsic Pontine Glioma', MS='A rare, aggressive brain tumor that forms in the GLIAL CELLS in the PONS.'),
  'D000080444': NtO(MH='Phenomics', MS='The systematic study of how genetic information or GENOMICS translates into biochemical, metabolic and morphological traits of an organism.'),
  'D000080445': NtO(MH='Asthma-Chronic Obstructive Pulmonary Disease Overlap Syndrome', MS='Syndrome with clinical features of both ASTHMA and COPD.'),
  'D000080462': NtO(MH='Acyclic Monoterpenes', MS='Linear compounds that contain a single monoterpene unit.'),
  'D000080463': NtO(MH='Sand', MS='A hard granular material that is a component of soil. It is composed of very small pieces (between 0.06 and 2.0 millimeters in diameter) of disintegrating rock.'),
  'D000080482': NtO(MH='Enhanced Recovery After Surgery', MS='A protocol of components related to preadmission, preoperative, intraoperative, and postoperative care. The protocol is implemented with the goal of improving patient recovery, facilitating earlier discharge from the hospital, and potentially reducing health care costs without increasing complications or hospital readmissions. The protocol components may contribute to minimizing, and/or improving the response to, physiological stress associated with surgery.'),
  'D000080483': NtO(MH='Atomic Bomb Survivors', MS='Persons who survived exposure to RADIATION due to ATOMIC BOMBS.'),
  'D000080485': NtO(MH='Sudden Unexpected Death in Epilepsy', MS='Sudden death in a patient with EPILEPSY associated with SEIZURES and seizure-related symptoms (e.g., APNEA; HYPOXEMIA) without other identifiable accidental causes (e.g., DROWNING; WOUNDS AND INJURIES).'),
  'D000080486': NtO(MH='Computational Chemistry', MS='A branch of chemistry that utilizes computers as well as principles of chemistry and mathematics to generate data and solve problems related to the properties, structures, and reactions of molecules and materials.'),
  'D000080487': NtO(MH='Internet of Things', MS='Networking capability which facilitates information flow to and from objects and devices using the INTERNET.'),
  'D000080503': NtO(MH='Fictional Works as Topic', MS='Works about creative writing, not presented as factual.'),
  'D000080505': NtO(MH='Trichothecenes, Type A', MS='A subclass of Trichothecene derivatives that include the 12,13-epoxytrichothec-9-ene structure of the molecule with the C-8 position containing either no oxygen substitution, a hydroxyl group at C-8, or an ester function at C-8.'),
  'D000080506': NtO(MH='Sialyl Lewis X Antigen', MS='A sialylated version of Lewis X antigen expressed on cell surfaces. It is a ligand for SELECTINS.'),
  'D000080522': NtO(MH='Sapajus apella', MS='A species of the genus SAPAJUS, subfamily CEBINAE, family CEBIDAE, consisting of tufted capuchin monkeys with characteristic black head cap and sideburn coloration with tufts of dark fur above the ears. S. apella was known as Cebus apella and C. a. apella.'),
  'D000080523': NtO(MH='Sapajus', MS='A genus of the family CEBIDAE, subfamily CEBINAE, consisting of capuchin monkeys with characteristic tufts of hair over the eyes and sides of the head. Many were formerly classified under genus CEBUS. Sapajus inhabits the forests of Central and South America.'),
  'D000080526': NtO(MH='Cebus capucinus', MS='A species of the genus CEBUS, family CEBIDAE, consisting of capuchin monkeys with white markings over most of frontal areas of the face, chest and upper arms.'),
  'D000080527': NtO(MH='Macaca fuscata', MS='A species of the genus MACACA characterized by red naked face. M. fuscata is primarily ground-dwelling in forest and mountains often near hot springs in Japan.'),
  'D000080530': NtO(MH='Twinning, Embryonic', MS='The development of two EMBRYOS in a single UTERUS at the same time.'),
  'D000080531': NtO(MH='Macaca arctoides', MS='A species of the genus MACACA inhabiting India, China, and other parts of southern Asia. The species is characterized by its thick brown fur covering most of its body except the face and short tail.'),
  'D000080532': NtO(MH='Alouatta caraya', MS='A species of the genus ALOUATTA, family ATELIDAE, inhabiting the forests of South America. Although sometimes known as black howler only adult males have black hair and adult females and juveniles are gold in color. Closely related A. pigra in Central America and A. nigerrima in the Amazon are also called black howlers.'),
  'D000080534': NtO(MH='Twinning, Dizygotic', MS='The development of two genetically distinct EMBRYOS in a single UTERUS at the same time, from two separate OVA fertilized by two separate SPERMATOZOA.'),
  'D000080536': NtO(MH='Decision Making, Shared', MS='Collaborative process of reaching a decision.'),
  'D000080542': NtO(MH='Presbytini', MS='The tribe of subfamily COLOBINAE, family CERCOPITHECIDAE. They are found in India, Indonesia, Malaysia, and Thailand.'),
  'D000080544': NtO(MH='Indriidae', MS='A family of primates of the superfamily LEMUROIDEA, suborder STREPSIRRHINI containing genera AVAHI (woolly lemurs); INDRI; and PROPITHECUS (sifakas). The family is distributed in Madagascar.'),
  'D000080545': NtO(MH='Microplastics', MS='Plastic particles, less than 5 millimeters in diameter, that are generated from the degradation of larger pieces or are manufactured to be microstructures or smaller.'),
  'D000080546': NtO(MH='Space Research', MS='Studies of interactions between living organisms and characteristics of the extraterrestrial environment. These studies specifically address the structure and function of living organisms in an extraterrestrial environment and interdependent relationships of organisms with each other and/or the extraterrestrial environment while also touching on the origin, evolution and potential for extraterrestrial life. (From www.nasa.gov/audience/foreducators/spacelife/)'),
  'D000080549': NtO(MH='Autophagic Cell Death', MS='A major activation of the autophagic pathway, characterized by massive accumulation of AUTOPHAGOSOMES and CELL DEATH.'),
  'D000080550': NtO(MH='Macroautophagy', MS='The segregation of large parts of the cytoplasm, including ORGANELLES and PROTEIN AGGREGATES, into AUTOPHAGOSOMES and lysosomal degradation after fusion with LYSOSOMES.'),
  'D000080551': NtO(MH='Microautophagy', MS='A type of autophagy in which the cytoplasmic entities, such as parts of CELL NUCLEI; damaged MITOCHONDRIA; and lipid droplets, are taken up by small vesicles such as VACUOLES or MULTIVESICULAR BODIES, and degraded by lysosomal digestion.'),
  'D000080562': NtO(MH='Universal Design', MS='The design of products and environments to be usable by all people, to the greatest extent possible, without the need for adaption or specialized design.'),
  'D000080564': NtO(MH='Right to Health', MS='Right to accessible health services physically within reach for all sections of the population, including children, adolescents, older persons, persons with disabilities and other vulnerable groups as well as financially and on the basis of non-discrimination. Accessibility also implies the right to seek, receive and impart health-related information in an accessible format for all, including persons with disabilities, but does not impair the right to have personal health data treated confidentially.'),
  'D000080583': NtO(MH='Ateles geoffroyi', MS="A species in the genus ATELES, subfamily ATELINAE, comprising several Mesoamerican spider monkeys including Geoffroy's spider monkey (Ateles geoffroyi geoffroyi). Sometimes referred to as Central American spider monkey, it inhibits rainforest from Mexico to Colombia."),
  'D000080602': NtO(MH='Callicebus', MS='A genus of the subfamily CALLICEBINAE, family PITHECIIDAE, generally comprising of five species: C. barbarabrownae; C. coimbrai; C. melanochir; C. nigrifrons; C. personatus. Titi monkeys inhibit lower levels of the forest in South America.'),
  'D000080623': NtO(MH='Galagidae', MS='A family of Primates of the suborder Strepsirhini containing six genera. The family is widely distributed in Africa near Subsaharan region. The six genera are: Euoticus (needle-clawed galagos), GALAGO (bush babies), Galagoides (dwarf galagos), Otolemur (greater galagos), Paragalago and Sciurocheirus (squirrel galagos). All are primarily arboreal and nocturnal.'),
  'D000080642': NtO(MH='Chaperone-Mediated Autophagy', MS='A selective type of autophagy in which a specific set of cytosolic proteins are moved across the membrane of the LYSOSOMES by protein translocation, rather than by invagination of the lysosomal membrane. The proteins that will be degraded by chaperone-mediated autophagy (CMA) contain a CMA-targeting motif that, when exposed, is recognized by the cytosolic chaperone HSPA8 (aka Hsc70) and cochaperones which deliver the protein to LAMP2A monomers on the lysosome cell surface for translocation via the LAMP2A translocation complex. CMA is distinguished from CHAPERONE-ASSISTED-SELECTIVE AUTOPHAGY - a type of selective MACROAUTOPHAGY.'),
  'D000080662': NtO(MH='Phospholipid Hydroperoxide Glutathione Peroxidase', MS='A selenoenzyme that converts GLUTATHIONE plus FATTY ACID HYDROPEROXIDES to GLUTATHIONE DISULFIDE plus hydroxy fatty acids and water.'),
  'D000080682': NtO(MH='Salads', MS='A prepared mixture of cooked and/or raw vegetables, FRUIT, or other foods, garnished with a dressing CONDIMENT, and eaten as a MEAL or side dish.'),
  'D000080702': NtO(MH='Edible Insects', MS='Organisms of the INSECTA class that are used as food or are suitable as a nutritional source, especially by humans.'),
  'D000080743': NtO(MH='Shape Memory Alloys', MS='ALLOYS designed to recover their original shape upon heating.'),
  'D000080745': NtO(MH='Smart Materials', MS='Materials designed to change properties in response to changes in their environment adopting various predetermined shapes and/or functionalities.'),
  'D000080762': NtO(MH='Stimuli Responsive Polymers', MS='Polymeric materials designed to change properties in response to a stimulus.'),
  'D000080763': NtO(MH='Sea Level Rise', MS='An increase in the volume of the oceans and seas causing an elevation of the air-sea interface.'),
  'D000080802': NtO(MH='Horticulture', MS='Branch of agriculture which involves the cultivation of vegetables, flowers, or ornamental plants for food, industrial, medicinal, or aesthetic purposes. It does not include CROP PRODUCTION on a large scale.'),
  'D000080803': NtO(MH='Biosolids', MS='Wastewater SLUDGE treated by processes such as COMPOSTING, anaerobic digestion, aerobic digestion, alkaline treatment, and PASTEURIZATION to remove HAZARDOUS CHEMICALS and pathogens.'),
  'D000080822': NtO(MH='Relative Energy Deficiency in Sport', MS='Health disorders associated with low caloric intake of individuals involved in high-activity SPORTS.'),
  'D000080842': NtO(MH='Undiagnosed Diseases', MS='Rare and common diseases lacking a diagnosis.'),
  'D000080843': NtO(MH='Brain Regeneration', MS=None),
  'D000080845': NtO(MH='Sugar-Sweetened Beverages', MS='Liquids or drinks sweetened with added sugars of various forms.'),
  'D000080864': NtO(MH='Lactate Dehydrogenase 5', MS='A member of the LACTATE DEHYDROGENASES isozyme family, Lactate Dehydrogenase 5 is localized to liver and skeletal muscle cells where its expression increases in liver disease and striated muscle trauma respectively.'),
  'D000080865': NtO(MH='Formins', MS='A family of multidomain microfilament proteins associated with ACTIN FILAMENTS. They generally have multiple Formin-Homology domains (e.g., FH2 domain) and additionally have a RhoGTPase-binding domain and a diaphanous inhibitory domain. Formins and homologs are involved in actin reorganization.'),
  'D000080866': NtO(MH='Nucleobindins', MS='A DNA and calcium binding protein which plays a role in calcium homeostasis.'),
  'D000080867': NtO(MH='Gingipain Cysteine Endopeptidases', MS='Cysteine endoproteinases, from periodontal pathogen PORPHYROMONAS GINGIVALIS, acting as virulence factors associated with PERIODONTITIS. They are produced as pre-proproteins which mature into ARGININE and LYSINE specific endopeptidases.'),
  'D000080868': NtO(MH='Water Decolorization', MS='The removal of DYES; STAINS; or other COLORING AGENTS, natural or synthetic, from water sources by various processes such as ADSORPTION; BIOREMEDIATION; enzymatic digestion; and ELECTROLYSIS.'),
  'D000080869': NtO(MH='Jugular Foramina', MS='A pair of openings from the posterior cranial fossa through which the GLOSSOPHARYNGEAL NERVE; VAGUS NERVE; ACCESSORY NERVE and the internal JUGULAR VEINS pass.'),
  'D000080870': NtO(MH='R-Loop Structures', MS='An RNA-DNA hybrid structure formed when newly transcribed RNA remains bound to its DNA template. Stability of R-loops may play a role in GENETIC INSTABILITY.'),
  'D000080871': NtO(MH='Movable Books', MS='Books having mechanisms or parts that move, or are moved by the reader.'),
  'D000080872': NtO(MH='Open Abdomen Techniques', MS='Abdominal wound closure techniques in which the opening from a laparoscopic abdominal incision is left open, but covered, to reduce or prevent INTRA-ABDOMINAL HYPERTENSION.'),
  'D000080873': NtO(MH='Multifunctional Nanoparticles', MS='Nanoparticles that are engineered to have two or more physical properties.'),
  'D000080874': NtO(MH='Synucleinopathies', MS='Neurodegenerative disorders involving deposition of abnormal ALPHA-SYNUCLEIN in dopaminergic neurons and glial cells in the brain. Pathological aggregations of alpha-synuclein proteins results in LEWY BODIES and Lewy neurites; melanin granules in the SUBSTANTIA NIGRA and LOCUS COERULEUS; and glial cytoplasmic inclusions. Synucleinopathies are associated with mutation in the ALPHA-SYNUCLEIN (SNCA) gene on chromosome 4. PARKINSON DISEASE; LEWY BODY DISEASE with dementia; and MULTIPLE SYSTEM ATROPHY are prominent examples of synucleinopathy.'),
  'D000080882': NtO(MH='Ribosomal Protein L10', MS='A RIBOSOMAL PROTEIN which plays a crucial role in protein synthesis and embryonic brain development. Diseases associated with RPL10 mutations include Mental Retardation, X-Linked, Syndromic, 35 and Autism X-Linked 5.'),
  'D000080883': NtO(MH='Shoulder Dystocia', MS='Obstetric complication during OBSTETRIC DELIVERY in which exit of the fetus is delayed due to physical obstruction involving fetal shoulder(s).'),
  'D000080884': NtO(MH='Infratemporal Fossa', MS='The compartment that lies posterior to the MAXILLA and inferior to the side wall of the SKULL deep to the ramus of the MANDIBLE. It contains several FACIAL NERVES and the CAROTID ARTERIES and the JUGULAR VEINS.'),
  'D000080886': NtO(MH='Parapharyngeal Space', MS='The deep neck space near the PHARYNX located anterior to the ptyergomandibular raphe,  posterior to the prevertebral fascia, inferior to the SKULL BASE, and superior to the HYOID BONE. Prestyloid parapharyngeal space contains cranial nerves IX, X, XI, XII and internal JUGULAR VEIN and internal CAROTID ARTERY.  Poststyloid parapharyngeal space contains AURICULARTEMPORAL NERVE and MAXILLARY ARTERY and ascending pharyngeal artery.'),
  'D000080887': NtO(MH='Diabulimia', MS='Eating disorder occurring typically in patients with Diabetes Mellitus, Type 1 who restrict insulin intake in order to lost weight.'),
  'D000080888': NtO(MH='Specific Language Disorder', MS='Language disorder that delays the mastery of oral language skills or  in children who have no hearing loss or other developmental delays.'),
  'D000080890': NtO(MH='Duocarmycins', MS='A group of pyrroloindole compounds often with additional spirocyclic unit(s) and their analogs originally isolated from STREPTOMYCES. They bind DNA minor grooves with adenine-N3 alkylation activity.'),
  'D000080891': NtO(MH='Learning Health System', MS='A system in which internal data and experience are systematically integrated with external evidence and that knowledge is put into practice. As a result, patients get higher quality, safer, more efficient care, and health care delivery organizations become better places to work. (https://healthit.ahrq.gov/health-care-theme/learning-health-system)'),
  'D000080902': NtO(MH='Mandibular Nerve Injuries', MS='Traumatic injuries to the MANDIBULAR NERVE and its branches. Note that marginal mandibular nerve injury is a type of FACIAL NERVE INJURIES. Injuries to LINGUAL NERVE branch of mandibular nerve is LINGUAL NERVE INJURIES.'),
  'D000080903': NtO(MH='Dual Anti-Platelet Therapy', MS='Treatment with a combination of two types of antiplatelet agents to prevent blood clotting - usually ASPIRIN and another of the PLATELET AGGREGATION INHIBITORS.'),
  'D000080905': NtO(MH='Homeobox A10 Proteins', MS="Sequence-specific transcription factor which is part of a developmental regulatory system that provides cells with specific positional identities on the anterior-posterior axis of tissues. They bind to the DNA sequence 5'-AA[AT]TTTTATTAC-3'."),
  'D000080906': NtO(MH='Cerebellar Golgi Cells', MS='Inhibitory interneurons embedded in the granular layer of the CEREBELLAR CORTEX.'),
  'D000080907': NtO(MH='Single-Case Studies as Topic', MS='Trials that consider an individual patient as the sole unit of observation in a study investigating the efficacy or side-effects of different interventions to determine the optimal intervention for an individual patient using objective data-driven criteria.'),
  'D000080908': NtO(MH='Broadly Neutralizing Antibodies', MS='Neutralizing antibodies that reduce or abolish some biological activity of a soluble antigen or infectious agent (e.g., HIV) by targeting several epitopes.'),
  'D000080909': NtO(MH='Carotid-Femoral Pulse Wave Velocity', MS='The transit time of an AORTIC PRESSURE wave between the COMMON CAROTID ARTERY and the COMMON FEMORAL ARTERY. It is a standard measure of ARTERIAL STIFFNESS.'),
  'D000080910': NtO(MH='Ambient Intelligence', MS='An emerging paradigm in which people are empowered through intelligent (digital) tools embedded in the surrounding environment. These tools proactively support human existence by being sensitive, adaptive, and responsive to the needs, habits, gestures, and emotions of individuals.'),
  'D000080911': NtO(MH='Cheminformatics', MS='The use of computational and data retrieval techniques in understanding problems of chemistry. Cheminformatics strategies are useful in high throughput drug discovery.'),
  'D000080924': NtO(MH='Aldehyde Dehydrogenase 1', MS='A member of the Aldehyde Dehydrogenase family of enzymes involved in the synthesis of acetate from ethanol. It is also a tumor marker.'),
  'D000080925': NtO(MH='Microwave Imaging', MS='Use of MICROWAVES as a diagnostic tool.'),
  'D000080942': NtO(MH='Post-Cardiac Arrest Syndrome', MS='A reperfusion syndrome characterized by various pathophysiological processes after CARDIAC ARREST.  It may include post-cardiac arrest brain injury (HYPOXIA-ISCHEMIA, BRAIN), cardiocirculatory dysfunction, (e.g., systemic ISCHEMIA), HYPERGLYCEMIA; MULTIPLE ORGAN FAILURE and delayed death.'),
  'D000080943': NtO(MH='Bacterial Outer Membrane', MS='The outermost cell envelope of GRAM-NEGATIVE BACTERIA composed of PHOSPHOLIPIDS; LIPOPOLYSACCHARIDES (LPS), and BACTERIAL OUTER MEMBRANE PROTEINS. The bacterial outer membrane LPS demonstrates cytotoxicity (see LIPID A and BACTERIAL O ANTIGEN).'),
  'D000080944': NtO(MH='Interosseous Membrane', MS='A sheet of fibrous connective tissue rich in COLLAGEN often linking two parallel bony structures forming a syndesmosis type joint. It provides longitudinal stability, TENSILE STRENGTH, and weight distribution/transfer and may allow limited movement in syndesmoses.'),
  'D000080945': NtO(MH='Lymph Node Ratio', MS='The ratio of metastatic to total examined LYMPH NODES.'),
  'D000080983': NtO(MH='Bone Marrow Failure Disorders', MS='Inherited or acquired diseases characterized by insufficient and/or dysplastic blood cells.'),
  'D000080984': NtO(MH='Congenital Bone Marrow Failure Syndromes', MS='Inherited syndromes characterized by deficiency or absence of various blood cells due to mutations that affect HEMATOPOIETIC STEM CELLS development and proliferation.'),
  'D000081': NtO(MH='Acetamides', MS='Derivatives of acetamide that are used as solvents, as mild irritants, and in organic synthesis.'),
  'D000081002': NtO(MH='Sino-Japanese War', MS='Military conflict involving China and Japan 1937 - 1945.'),
  'D000081003': NtO(MH='Shwachman-Diamond Syndrome', MS='An inherited syndrome characterized by EXOCRINE PANCREATIC INSUFFICIENCY; hematologic abnormalities (e.g., bone marrow hypoplasia), and skeletal abnormalities (e.g., metaphyseal chondroplasia). GERMLINE MUTATIONS in the SBDS gene are associated with Shwachman-Diamond Syndrome.'),
  'D000081004': NtO(MH='Cyclopentane Monoterpenes', MS='Monoterpenes that include a cyclopentane ring in their structure.'),
  'D000081005': NtO(MH='Cyclohexane Monoterpenes', MS='Monoterpenes that include a cyclohexane ring in their structure.'),
  'D000081006': NtO(MH='Missed Diagnosis', MS='Failure to identify or diagnose a medical condition at the time a health professional is acquainted with the symptoms.'),
  'D000081007': NtO(MH='Cymenes', MS='A subclass of monoterpenes that contain a single benzene ring structure with an isopropyl group and one or more methyl groups.'),
  'D000081008': NtO(MH='Bicyclic Monoterpenes', MS='Monoterpenes containing two ring structures that are joined either by bridgehead carbon atoms or fused ring structure.'),
  'D000081010': NtO(MH='Food Fussiness', MS='Patterns associated with eating including modes of feeding, rhythmic patterns of eating, and time intervals.'),
  'D000081011': NtO(MH='Hepatic Infarction', MS='Formation of infarct resulting from obstruction of HEPATIC ARTERY and/or PORTAL VEIN most often after LIVER TRANSPLANTATION or hepatobiliary surgery.'),
  'D000081012': NtO(MH='Autoimmune Pancreatitis', MS='Chronic pancreatitis associated with autoimmune diseases.'),
  'D000081013': NtO(MH='Suicide, Completed', MS='The successful attempt to kill oneself.'),
  'D000081014': NtO(MH='Dihydrostilbenoids', MS='Organic compounds characterized by the functional group 1,2-dihydrostilbene.'),
  'D000081015': NtO(MH='Ototoxicity', MS='Damage to the EAR or its function secondary to exposure to toxic substances such as drugs used in CHEMOTHERAPY; IMMUNOTHERAPY; or RADIATION.'),
  'D000081022': NtO(MH='Sphingosine Phosphorylcholine Receptors', MS='A subfamily of lysophospholipid receptors with specificity for lysophosphatidic acid.'),
  'D000081025': NtO(MH='Sphingosine-1-Phosphate Receptors', MS='A subfamily of lysophospholipid receptors with specificity for sphingosine-1-phosphate (e.g., FINGOLIMOD), sphinganine 1-phosphate, 4-hydroxysphinganine 1-phosphate.'),
  'D000081026': NtO(MH='Polyprenols', MS='Long chain isoprene compounds that include a hydroxyl group at the terminal carbon atom.'),
  'D000081027': NtO(MH='Extreme Hot Weather', MS=None),
  'D000081028': NtO(MH='Toxic Optic Neuropathy', MS='Damage to the eye or its function (e.g., VISUAL IMPAIRMENT) due to OPTIC NERVE damage secondary to toxic substances such as drugs used in CHEMOTHERAPY; IMMUNOTHERAPY; or RADIATION.'),
  'D000081029': NtO(MH='Pulmonary Arterial Hypertension', MS='A progressive rare pulmonary disease characterized by high blood pressure in the PULMONARY ARTERY.'),
  'D000081030': NtO(MH='Myotoxicity', MS='Damage to the muscle or its function secondary to toxic substances such as drugs used in CHEMOTHERAPY; IMMUNOTHERAPY; or RADIATION.'),
  'D000081031': NtO(MH='Fatty Acid Elongases', MS='Enzymes conserved from yeast to mammals which mediate elongation of FATTY ACIDS into very-long-chain fatty acids.'),
  'D000081032': NtO(MH='Pancreatitis, Acute Hemorrhagic', MS='An acute INFLAMMATION of the PANCREAS in which the initial edematous pancreatitis evolved into necrosis accompanied by HEMORRHAGE.'),
  'D000081033': NtO(MH='Potassium Channels, Sodium-Activated', MS='Potassium channels whose activation is dependent on intracellular sodium concentrations.'),
  'D000081034': NtO(MH='Indigenous Peoples', MS='Descendants who self-identify as members of a group who inhabited a country or region at the time when people of different cultures or ethnic origins arrived. They often maintain their distinct language, culture, and beliefs.'),
  'D000081035': NtO(MH='Heterogeneous Nuclear Ribonucleoprotein D0', MS="Member of a subfamily of ubiquitously expressed heterogeneous nuclear ribonucleoproteins (hnRNPs), heterogeneous nuclear ribonucleoprotein D0 (hnRNP D0) specifically binds RNA molecules that contain AU RICH ELEMENTS found within the 3'-UTR of many PROTO-ONCOGENES and CYTOKINES mRNAs. It functions as a transcription factor, binds to double- and single-stranded DNA sequences in a specific manner."),
  'D000081042': NtO(MH='Body Integrity Identity Disorder', MS='Condition in which individuals desire the amputation of one or more healthy limbs or who desire a paralysis.'),
  'D000081062': NtO(MH='Heme-Binding Proteins', MS='Metalloproteins that contain a HEME ligand as the prosthetic group.'),
  'D000081082': NtO(MH='Phosphoinositide-3 Kinase Inhibitors', MS='Agents that inhibit PHOSPHOINOSITIDE-3 KINASE activity.'),
  'D000081084': NtO(MH='Accidental Injuries', MS='Injuries resulting from events or circumstances that are unforeseen, unplanned, unanticipated, and without premeditation.'),
  'D000081102': NtO(MH='WAP Four-Disulfide Core Domain Protein 2', MS='A secreted 25-kDa glycoprotein member of the Whey-acidic-protein (WAP) four-disulfide core (WFDC) domain family with tissue specific expression in the EPIDIDYMIS. It is also expressed in a limited number of other organs which include female reproductive tract, breast tissue, kidney, regions of the respiratory tract and nasopharynx. The protein is a biomarker for epithelial ovarian cancer.'),
  'D000081122': NtO(MH='Epigenome', MS='A network of chemical compounds surrounding DNA that modify the genome without altering the DNA sequences and have a role in determining which genes are active in a cell.'),
  'D000081142': NtO(MH='Evidence-Based Pharmacy Practice', MS="The practice of pharmacy in which the pharmacist makes decisions, taking into account the best available current research evidence, the pharmacist's expertise, and the needs and preferences of the patient."),
  'D000081163': NtO(MH='Cell Line Authentication', MS='Techniques used to characterize and confirm the identity of a CELL LINE. Characterization involves authentication to verify that it matches the original description of the cells and ensures that they are not cross-contaminated with another cell line. This is done to avoid attributing data incorrectly to the wrong cell line.'),
  'D000081164': NtO(MH='Drug Collateral Sensitivity', MS='Increase in sensitivity of an organism, disease, or tissue to one drug that develops following the loss of sensitivity (i.e. resistance) to another drug.'),
  'D000081182': NtO(MH='Noninvasive Prenatal Testing', MS='The analysis of cell-free fetal DNA or the DNA from fetal cells that are biopsied from a pregnant woman\xe2\x80\x99s blood, to screen for genetically-determined traits and genetic abnormalities.'),
  'D000081183': NtO(MH='Codon Usage', MS="The frequency of occurrence, in a specific organism's DNA sequence, of one of several potential synonymous codons that code for a particular amino acid. Frequently, there is a nonrandom pattern (bias) in the usage of a particular codon or codons over other synonymous codons."),
  'D000081186': NtO(MH='Blockchain', MS='Decentralized transaction and data management technology providing security, anonymity and data integrity without any third party control of transactions. Related research is focused on improving aspects  regarding privacy and security. (From PLoS One. 2016 Oct 3;11(10):e0163477)'),
  'D000081202': NtO(MH='Right to Work', MS='The right of individuals to work, to free choice of employment, to just and favorable conditions of work and to protection against unemployment.'),
  'D000081203': NtO(MH='Monoterpene Aldehydes and Ketones', MS='Monoterpene compounds that include a double bonded oxygen attached to the one or more of the carbon atoms.'),
  'D000081204': NtO(MH='Chromatin Immunoprecipitation Sequencing', MS='A technique for identifying the BINDING SITES on nucleic acid sequences that are associated with binding proteins.'),
  'D000081205': NtO(MH='Hair Analysis', MS='Examination of hair by chemical, physical, or microscopic means.'),
  'D000081206': NtO(MH='Duration of Therapy', MS='Planned or actual duration of various treatments or preventive measures.'),
  'D000081207': NtO(MH='Primary Immunodeficiency Diseases', MS='Genetic immunologic deficiency diseases and syndromes due to mutations in genes involved in IMMUNITY generally characterized by an increased susceptibility to infectious diseases. They are often associated with AUTOIMMUNE DISEASE manifestations.'),
  'D000081208': NtO(MH='Hereditary Complement Deficiency Diseases', MS='Genetic disorders due to mutations in genes involved in COMPLEMENT SYSTEM PROTEINS. They are often classified into distinct pathway of complement activation where causative mutations are found (e.g., classical pathway, lectin pathway, alternative pathway, and terminal complement pathway).'),
  'D000081222': NtO(MH='Monocyclic Sesquiterpenes', MS='Sesquiterpene compounds that contain a single ring structure.'),
  'D000081223': NtO(MH='Polycyclic Sesquiterpenes', MS='Sesquiterpenes that contain two or more ring structures'),
  'D000081225': NtO(MH='Stilbestrols', MS='Stilbene derivatives the contain one or more hydroxyl groups attached to the benzene ring structures.'),
  'D000081226': NtO(MH='Sennosides', MS='Medications derived from SENNA EXTRACT that are used to treat CONSTIPATION.'),
  'D000081227': NtO(MH='Neurosteroids', MS='Endogenous compounds or drugs that affect neuronal excitability through modulation of specific ionotropic receptors (e.g., GABA-A RECEPTORS). Endogenous neurosteroids are steroid hormones de novo synthesized by neurons and glial cells from steroid metabolite precursors (e.g., PREGNENOLONE).'),
  'D000081229': NtO(MH='Artificially Sweetened Beverages', MS='Beverages sweetened with SWEETENING AGENTS that are synthetic or artificial as opposed to naturally-occurring. Examples of sweetening agents include ASPARTAME, sucralose, and saccharin.'),
  'D000081230': NtO(MH='Forensic Entomology', MS='The use of insects and related arthropods that inhabit decomposing corpses or remains in the conduct of medico-legal or medico-criminal investigations.'),
  'D000081242': NtO(MH='B-Cell Lymphoma 3 Protein', MS='A member of the I kappa B family, B-cell lymphoma 3-encoded (bcl-3) protein is involved in the regulation of TRANSCRIPTIONAL ACTIVATION of NF-KAPPA B target genes.'),
  'D000081243': NtO(MH='Sphingosine 1 Phosphate Receptor Modulators', MS='Agents that affect the function of G-protein coupled SPHINGOSINE 1-PHOSPHATE RECEPTORS. Their binding to the receptors blocks lymphocyte migration and are often used as IMMUNOSUPPRESSANTS.'),
  'D000081246': NtO(MH='RNA-Seq', MS='High-throughput nucleotide sequencing techniques developed for determining and analyzing the composition of the TRANSCRIPTOME of a sample.'),
  'D000081247': NtO(MH='CSK Tyrosine-Protein Kinase', MS='Protein tyrosine kinases that phosphorylate tyrosine residues located in the C-terminal tails of SRC-FAMILY KINASES.'),
  'D000081248': NtO(MH='Allylbenzene Derivatives', MS='Compounds that include a single 1-phenyl-2-propene moiety in their structure.'),
  'D000081262': NtO(MH='Randomized Controlled Trial, Veterinary', MS='A work that reports on a clinical trial with animal subjects that involves at least one test treatment and one control treatment, concurrent enrollment and follow-up of the test- and control-treated groups, and in which the treatments to be administered are selected by a random process, such as the use of a random-numbers table.'),
  'D000081282': NtO(MH='Perfusion Index', MS='The ratio of arterial blood flow (PULSATILE FLOW) to venous, capillary, and tissue blood flow  (non-pulsatile blood flow) - as measured regionally or peripherally.'),
  'D000081322': NtO(MH='Military Health Services', MS='Services organized for the diagnosis and treatment of disease and the maintenance of health primarily of MILITARY PERSONNEL.'),
  'D000081324': NtO(MH='Veterans Health Services', MS='Services organized for the diagnosis and treatment of diseases and maintenance of health primarily of VETERANS.'),
  'D000081342': NtO(MH='Nudiviridae', MS='A family of ARTHROPOD viruses, including INSECT VIRUSES and crustacean viruses. They are rod-shaped, enveloped, and circular dsDNA viruses that share structural and replication characteristics with BACULOVIRIDAE. Genera include Alphanudivirus and Betanudivirus.'),
  'D000081362': NtO(MH='Lipidomics', MS='A branch of metabolomics concerned with the study of global LIPIDS profiles in physiological systems.'),
  'D000081363': NtO(MH='Occlusion Bodies, Viral', MS='A polyhedral or ovocylindrical shaped matrix composed of a single crystalline protein (OCCLUSION BODY MATRIX PROTEINS) in which VIRIONS are embedded. It is distinguished from the area of the CYTOPLASM or CELL NUCLEUS in which virus components are being synthesized and assembled, known as VIRAL INCLUSION BODIES.'),
  'D000081364': NtO(MH='Multiparametric Magnetic Resonance Imaging', MS='Magnetic Resonance Imaging technique that combines functional imaging techniques such as diffusion-weighted imaging (DWI), dynamic contrast-enhanced imaging and magnetic spectroscopy. This technique is widely used for active surveillance in prostate cancer imaging.'),
  'D000081382': NtO(MH='Pyruvate Dehydrogenase (Acetyl-Transferring) Kinase', MS='A pyruvate dehydrogenase kinase isozyme located in the mitochondria which converts PYRUVATE to ACETYL CoA in the CITRIC ACID CYCLE, phosphorylates SERINE residues on pyruvate dehydrogenase using ATP, and plays a key role in the regulation of GLUCOSE and fatty acid metabolism.'),
  'D000081404': NtO(MH='Quaternary Prevention', MS='Actions taken to protect individuals (i.e. persons/patients) from unnecessary medical interventions that are likely to cause more harm than good.'),
  'D000081406': NtO(MH='Cyclophilin D', MS='A member of the cyclophilins family of isomerases which plays a role in the regulation of the permeability transition pore in mitochondria.'),
  'D000081410': NtO(MH='Germinal Center Kinases', MS='Serine-threonine kinases characterized by an N-terminal STE20 kinase domain.'),
  'D000081411': NtO(MH='Augmented Reality', MS='Technology in which images of virtual objects and/or other digital information are superimposed over the real time view of the physical objects providing a composite view with guides for carrying out a task with or on the physical objects.'),
  'D000081412': NtO(MH='Myosin VIIa', MS='Also referred to as unconventional myosin VIIa, these are actin-based motor molecules with ATPase activity that function in intracellular movements (e.g., HAIR CELLS, AUDITORY).'),
  'D000081413': NtO(MH='Exposome', MS='The measure of all the exposures of an individual from all sources, including environmental and occupational sources, in a lifetime and how those exposures relate to health. (from https://www.cdc.gov/niosh/topics/exposome/ on 06/06/2019)'),
  'D000081414': NtO(MH='Nanopore Sequencing', MS='A sequencing protocol that drives nucleic acids (DNA or RNA) in an electric field through NANOPORES allowing single molecule sequence analysis.'),
  'D000081415': NtO(MH='Clinical Decision Rules', MS='Scores or algorithms that correlate with clinically significant findings and that are used to predict an outcome, or suggest a diagnostic or therapeutic action.'),
  'D000081416': NtO(MH='SecA Proteins', MS='ATPases that provide energy for the translocation of proteins across bacterial PLASMA MEMBRANES and THYLAKOID membranes, by the SEC TRANSLOCATION CHANNELS. SecA is a component of the bacterial preprotein translocase which is comprised of SecA, the SECYEG TRANSLOCON, and the accessory domain proteins SecD, SecF, YajC, and YidC.'),
  'D000081442': NtO(MH='Trichothecenes, Type B', MS='A subclass of Trichothecene derivatives that include the 12,13-epoxytrichothec-9-ene structure with a keto (carbonyl) function at C-8.'),
  'D000081443': NtO(MH='Trichothecenes, Type C', MS='A subclass of Trichothecene derivatives that includes the 12,13-epoxytrichothec-9-ene structure with an epoxide oxygen bond to the C7 and C8 carbon atoms.'),
  'D000081482': NtO(MH='Bioaccumulation', MS='An increase in the concentration of an exogenous substance in the tissues of organisms higher than surrounding ENVIRONMENT. Accumulation of such XENOBIOTICS at successively higher levels up the FOOD CHAIN is called biomagnification. Bioaccumulation of toxic chemicals (e.g., Lead and DDT) may result in CHEMICALLY-INDUCED DISORDERS.'),
  'D000081483': NtO(MH='Squamous Intraepithelial Lesions', MS='A cytological test finding that shows abnormal lesions of SQUAMOUS EPITHELIAL cells.'),
  'D000081503': NtO(MH='Organoiron Compounds', MS='Organic compounds that contain iron in carbon-to-iron chemical bond.'),
  'D000082': NtO(MH='Acetaminophen', MS='Analgesic antipyretic derivative of acetanilide. It has weak anti-inflammatory properties and is used as a common analgesic, but may cause liver, blood cell, and kidney damage.'),
  'D000083': NtO(MH='Acetanilides', MS='Compounds based on N-phenylacetamide, that are similar in structure to 2-PHENYLACETAMIDES. They are precursors of many other compounds. They were formerly used as ANALGESICS and ANTIPYRETICS, but often caused lethal METHEMOGLOBINEMIA.'),
  'D000084': NtO(MH='Acetate Kinase', MS='An enzyme that catalyzes reversibly the phosphorylation of acetate in the presence of a divalent cation and ATP with the formation of acetylphosphate and ADP. It is important in the glycolysis process. EC 2.7.2.1.'),
  'D000085': NtO(MH='Acetates', MS='Derivatives of ACETIC ACID. Included under this heading are a broad variety of acid forms, salts, esters, and amides that contain the carboxymethane structure.'),
  'D000086': NtO(MH='Acetazolamide', MS='One of the CARBONIC ANHYDRASE INHIBITORS that is sometimes effective against absence seizures. It is sometimes useful also as an adjunct in the treatment of tonic-clonic, myoclonic, and atonic seizures, particularly in women whose seizures occur or are exacerbated at specific times in the menstrual cycle. However, its usefulness is transient often because of rapid development of tolerance. Its antiepileptic effect may be due to its inhibitory effect on brain carbonic anhydrase, which leads to an increased transneuronal chloride gradient, increased chloride current, and increased inhibition. (From Smith and Reynard, Textbook of Pharmacology, 1991, p337)'),
  'D000089': NtO(MH='Acetic Anhydrides', MS='Compounds used extensively as acetylation, oxidation and dehydrating agents and in the modification of proteins and enzymes.'),
  'D000090': NtO(MH='Acetoacetates', MS='Salts and derivatives of acetoacetic acid.'),
  'D000091': NtO(MH='Acetobacter', MS='A species of gram-negative bacteria of the family ACETOBACTERACEAE found in FLOWERS and FRUIT. Cells are ellipsoidal to rod-shaped and straight or slightly curved.'),
  'D000092': NtO(MH='Acetohexamide', MS='A sulfonylurea hypoglycemic agent that is metabolized in the liver to 1-hydrohexamide.'),
  'D000093': NtO(MH='Acetoin', MS='A product of fermentation. It is a component of the butanediol cycle in microorganisms. In mammals it is oxidized to carbon dioxide.'),
  'D000094': NtO(MH='Acetoin Dehydrogenase', MS='An enzyme that catalyzes the conversion of acetoin to diacetyl in the presence of NAD.'),
  'D000095': NtO(MH='Acetolactate Synthase', MS='A flavoprotein enzyme that catalyzes the formation of acetolactate from 2 moles of PYRUVATE in the biosynthesis of VALINE and the formation of acetohydroxybutyrate from pyruvate and alpha-ketobutyrate in the biosynthesis of ISOLEUCINE. This enzyme was formerly listed as EC 4.1.3.18.'),
  'D000096': NtO(MH='Acetone', MS='A colorless liquid used as a solvent and an antiseptic. It is one of the ketone bodies produced during ketoacidosis.'),
  'D000097': NtO(MH='Acetonitriles', MS='Compounds in which a methyl group is attached to the cyano moiety.'),
  'D000098': NtO(MH='Acetophenones', MS='Derivatives of the simplest aromatic ketone acetophenone (of general formula C6H5C(O)CH3).'),
  'D000099': NtO(MH='Acetoxyacetylaminofluorene', MS='An alkylating agent that forms DNA ADDUCTS at the C-8 position in GUANINE, resulting in single strand breaks. It has demonstrated carcinogenic action.'),
  'D000100': NtO(MH='Acetrizoic Acid', MS='An iodinated radiographic contrast medium used as acetrizoate sodium in HYSTEROSALPINGOGRAPHY.'),
  'D000101': NtO(MH='Acetyl-CoA C-Acetyltransferase', MS='An enzyme that catalyzes the formation of acetoacetyl-CoA from two molecules of ACETYL COA. Some enzymes called thiolase or thiolase-I have referred to this activity or to the activity of ACETYL-COA C-ACYLTRANSFERASE.'),
  'D000102': NtO(MH='Acetyl-CoA C-Acyltransferase', MS='Enzyme that catalyzes the final step of fatty acid oxidation in which ACETYL COA is released and the CoA ester of a fatty acid two carbons shorter is formed.'),
  'D000103': NtO(MH='Acetyl-CoA Carboxylase', MS='A carboxylating enzyme that catalyzes the conversion of ATP, acetyl-CoA, and HCO3- to ADP, orthophosphate, and malonyl-CoA. It is a biotinyl-protein that also catalyzes transcarboxylation. The plant enzyme also carboxylates propanoyl-CoA and butanoyl-CoA (From Enzyme Nomenclature, 1992) EC 6.4.1.2.'),
  'D000104': NtO(MH='Acetyl-CoA Hydrolase', MS='An enzyme that catalyzes reversibly the hydrolysis of acetyl-CoA to yield CoA and acetate. The enzyme is involved in the oxidation of fatty acids. EC 3.1.2.1.'),
  'D000105': NtO(MH='Acetyl Coenzyme A', MS='Acetyl CoA participates in the biosynthesis of fatty acids and sterols, in the oxidation of fatty acids and in the metabolism of many amino acids. It also acts as a biological acetylating agent.'),
  'D000106': NtO(MH='Acetate-CoA Ligase', MS='An enzyme that catalyzes the formation of CoA derivatives from ATP, acetate, and CoA to form AMP, pyrophosphate, and acetyl CoA. It acts also on propionates and acrylates. EC 6.2.1.1.'),
  'D000107': NtO(MH='Acetylation', MS='Formation of an acetyl derivative. (Stedman, 25th ed)'),
  'D000108': NtO(MH='Acetylcarnitine', MS='An acetic acid ester of CARNITINE that facilitates movement of ACETYL COA into the matrices of mammalian MITOCHONDRIA during the oxidation of FATTY ACIDS.'),
  'D000109': NtO(MH='Acetylcholine', MS='A neurotransmitter found at neuromuscular junctions, autonomic ganglia, parasympathetic effector junctions, a subset of sympathetic effector junctions, and at many sites in the central nervous system.'),
  'D000110': NtO(MH='Acetylcholinesterase', MS='An enzyme that catalyzes the hydrolysis of ACETYLCHOLINE to CHOLINE and acetate. In the CNS, this enzyme plays a role in the function of peripheral neuromuscular junctions. EC 3.1.1.7.'),
  'D000111': NtO(MH='Acetylcysteine', MS='The N-acetyl derivative of CYSTEINE. It is used as a mucolytic agent to reduce the viscosity of mucous secretions. It has also been shown to have antiviral effects in patients with HIV due to inhibition of viral stimulation by reactive oxygen intermediates.'),
  'D000112': NtO(MH='Acetyldigitoxins', MS='Cardioactive derivatives of lanatoside A or of DIGITOXIN. They are used for fast digitalization in congestive heart failure.'),
  'D000113': NtO(MH='Acetyldigoxins', MS='Alpha- or beta-acetyl derivatives of DIGOXIN or lanatoside C from Digitalis lanata. They are better absorbed and longer acting than digoxin and are used in congestive heart failure.'),
  'D000114': NtO(MH='Acetylene', MS='The simplest two carbon alkyne with the formula HCCH.'),
  'D000115': NtO(MH='Acetylesterase', MS='An enzyme that catalyzes the conversion of acetate esters and water to alcohols and acetate. EC 3.1.1.6.'),
  'D000116': NtO(MH='Acetylgalactosamine', MS='The N-acetyl derivative of galactosamine.'),
  'D000117': NtO(MH='Acetylglucosamine', MS='The N-acetyl derivative of glucosamine.'),
  'D000118': NtO(MH='Acetylglucosaminidase', MS='A beta-N-Acetylhexosaminidase that catalyzes the hydrolysis of terminal, non-reducing 2-acetamido-2-deoxy-beta-glucose residues in chitobiose and higher analogs as well as in glycoproteins. Has been used widely in structural studies on bacterial cell walls and in the study of diseases such as MUCOLIPIDOSIS and various inflammatory disorders of muscle and connective tissue.'),
  'D000119': NtO(MH='Acetylmuramyl-Alanyl-Isoglutamine', MS='Peptidoglycan immunoadjuvant originally isolated from bacterial cell wall fragments; also acts as pyrogen and may cause arthritis; stimulates both humoral and cellular immunity.'),
  'D000120': NtO(MH='Acecainide', MS='A major metabolite of PROCAINAMIDE. Its anti-arrhythmic action may cause cardiac toxicity in kidney failure.'),
  'D000121': NtO(MH='Acetylserotonin O-Methyltransferase', MS='An enzyme that catalyzes the transfer of a methyl group from S-adenosylmethionine to N-acetylserotonin to form N-acetyl-5-methoxytryptamine (MELATONIN).'),
  'D000122': NtO(MH='Acetylthiocholine', MS='An agent used as a substrate in assays for cholinesterases, especially to discriminate among enzyme types.'),
  'D000123': NtO(MH='Acetyltransferases', MS='Enzymes catalyzing the transfer of an acetyl group, usually from acetyl coenzyme A, to another compound. EC 2.3.1.'),
  'D000124': NtO(MH='Achievement', MS='Success in bringing an effort to the desired end; the degree or level of success attained in some specified area (esp. scholastic) or in general.'),
  'D000125': NtO(MH='Achilles Tendon', MS='Tendon that connects the muscles in the back of the calf to the HEEL BONE.'),
  'D000126': NtO(MH='Achlorhydria', MS='A lack of HYDROCHLORIC ACID in GASTRIC JUICE despite stimulation of gastric secretion.'),
  'D000127': NtO(MH='Acholeplasma', MS='A genus of gram-negative organisms including saprophytic and parasitic or pathogenic species.'),
  'D000128': NtO(MH='Acholeplasma laidlawii', MS='An organism originally isolated from sewage, manure, humus, and soil, but recently found as a parasite in mammals and birds.'),
  'D000129': NtO(MH='Acholeplasmataceae', MS='Gram-negative organisms including apparently free-living saphrophytes as well as mammalian and avian parasites, and possibly pathogens.'),
  'D000130': NtO(MH='Achondroplasia', MS='An autosomal dominant disorder that is the most frequent form of short-limb dwarfism. Affected individuals exhibit short stature caused by rhizomelic shortening of the limbs, characteristic facies with frontal bossing and mid-face hypoplasia, exaggerated lumbar lordosis, limitation of elbow extension, GENU VARUM, and trident hand. (Online Mendelian Inheritance in Man, http://www.ncbi.nlm.nih.gov/Omim, MIM#100800, April 20, 2001)'),
  'D000134': NtO(MH='Acid Etching, Dental', MS='Preparation of TOOTH surfaces and DENTAL MATERIALS with etching agents, usually phosphoric acid, to roughen the surface to increase adhesion or osteointegration.'),
  'D000135': NtO(MH='Acid Phosphatase', MS='An enzyme that catalyzes the conversion of an orthophosphoric monoester and water to an alcohol and orthophosphate. EC 3.1.3.2.'),
  'D000136': NtO(MH='Acid-Base Equilibrium', MS='The balance between acids and bases in the BODY FLUIDS. The pH (HYDROGEN-ION CONCENTRATION) of the arterial BLOOD provides an index for the total body acid-base balance.'),
  'D000137': NtO(MH='Acid-Base Imbalance', MS='Disturbances in the ACID-BASE EQUILIBRIUM of the body.'),
  'D000138': NtO(MH='Acidosis', MS='A pathologic condition of acid accumulation or depletion of base in the body. The two main types are RESPIRATORY ACIDOSIS and metabolic acidosis, due to metabolic acid build up.'),
  'D000140': NtO(MH='Acidosis, Lactic', MS='Acidosis caused by accumulation of lactic acid more rapidly than it can be metabolized. It may occur spontaneously or in association with diseases such as DIABETES MELLITUS; LEUKEMIA; or LIVER FAILURE.'),
  'D000141': NtO(MH='Acidosis, Renal Tubular', MS='A group of genetic disorders of the KIDNEY TUBULES characterized by the accumulation of metabolically produced acids with elevated plasma chloride, hyperchloremic metabolic ACIDOSIS. Defective renal acidification of URINE (proximal tubules) or low renal acid excretion (distal tubules) can lead to complications such as HYPOKALEMIA, hypercalcinuria with NEPHROLITHIASIS and NEPHROCALCINOSIS, and RICKETS.'),
  'D000142': NtO(MH='Acidosis, Respiratory', MS='Respiratory retention of carbon dioxide. It may be chronic or acute.'),
  'D000143': NtO(MH='Acids', MS="Chemical compounds which yield hydrogen ions or protons when dissolved in water, whose hydrogen can be replaced by metals or basic radicals, or which react with bases to form salts and water (neutralization). An extension of the term includes substances dissolved in media other than water. (Grant & Hackh's Chemical Dictionary, 5th ed)"),
  'D000144': NtO(MH='Acids, Acyclic', MS='Carboxylic acids that have open-chain molecular structures as opposed to ring-shaped structures.'),
  'D000145': NtO(MH='Acids, Aldehydic', MS='Dicarboxylic acids in which one of the carboxyl groups (-COOH) has been replaced by an aldehyde group (-CHO).'),
  'D000146': NtO(MH='Acids, Carbocyclic', MS='Carboxylic acids that have a homocyclic ring structure in which all the ring atoms are carbon.'),
  'D000147': NtO(MH='Acids, Heterocyclic', MS='A class of acids containing a ring structure in which at least one atom other than CARBON is incorporated.'),
  'D000148': NtO(MH='Acids, Noncarboxylic', MS='Inorganic acids with a non metal, other than carbon, attached to hydrogen, or an acid radical containing no carbon.'),
  'D000149': NtO(MH='Acidulated Phosphate Fluoride', MS='A sodium fluoride solution, paste or powder, which has been acidulated to pH 3 to 4 and buffered with a phosphate. It is used in the prevention of dental caries.'),
  'D000150': NtO(MH='Acinetobacter', MS='A genus of gram-negative bacteria of the family MORAXELLACEAE, found in soil and water and of uncertain pathogenicity.'),
  'D000151': NtO(MH='Acinetobacter Infections', MS='Infections with bacteria of the genus ACINETOBACTER.'),
  'D000152': NtO(MH='Acne Vulgaris', MS='A chronic disorder of the pilosebaceous apparatus associated with an increase in sebum secretion. It is characterized by open comedones (blackheads), closed comedones (whiteheads), and pustular nodules. The cause is unknown, but heredity and age are predisposing factors.'),
  'D000153': NtO(MH='Acne Keloid', MS='A type of acneiform disorder in which secondary pyogenic infection in and around pilosebaceous structures ends in keloidal scarring. It manifests as persistent folliculitis of the back of the neck associated with occlusion of the follicular orifices. It is most often encountered in black or Asian men.'),
  'D000154': NtO(MH='Aconitate Hydratase', MS='An enzyme that catalyzes the reversible hydration of cis-aconitate to yield citrate or isocitrate. It is one of the citric acid cycle enzymes. EC 4.2.1.3.'),
  'D000156': NtO(MH='Aconitic Acid', MS='A tricarboxylic acid with the formula (COOH)-CH2-C(COOH)=CH-COOH.'),
  'D000157': NtO(MH='Aconitine', MS='A C19 norditerpenoid alkaloid (DITERPENES) from the root of ACONITUM; DELPHINIUM and larkspurs. It activates VOLTAGE-GATED SODIUM CHANNELS. It has been used to induce ARRHYTHMIAS in experimental animals and it has anti-inflammatory and anti-neuralgic properties.'),
  'D000158': NtO(MH='Acoustic Impedance Tests', MS='Objective tests of middle ear function based on the difficulty (impedance) or ease (admittance) of sound flow through the middle ear. These include static impedance and dynamic impedance (i.e., tympanometry and impedance tests in conjunction with intra-aural muscle reflex elicitation). This term is used also for various components of impedance and admittance (e.g., compliance, conductance, reactance, resistance, susceptance).'),
  'D000159': NtO(MH='Vestibulocochlear Nerve', MS="The 8th cranial nerve. The vestibulocochlear nerve has a cochlear part (COCHLEAR NERVE) which is concerned with hearing and a vestibular part (VESTIBULAR NERVE) which mediates the sense of balance and head position. The fibers of the cochlear nerve originate from neurons of the SPIRAL GANGLION and project to the cochlear nuclei (COCHLEAR NUCLEUS). The fibers of the vestibular nerve arise from neurons of Scarpa's ganglion and project to the VESTIBULAR NUCLEI."),
  'D000160': NtO(MH='Vestibulocochlear Nerve Diseases', MS='Pathological processes of the VESTIBULOCOCHLEAR NERVE, including the branches of COCHLEAR NERVE and VESTIBULAR NERVE. Common examples are VESTIBULAR NEURITIS, cochlear neuritis, and ACOUSTIC NEUROMA. Clinical signs are varying degree of HEARING LOSS; VERTIGO; and TINNITUS.'),
  'D000161': NtO(MH='Acoustic Stimulation', MS='Use of sound to elicit a response in the nervous system.'),
  'D000162': NtO(MH='Acoustics', MS='The branch of physics that deals with sound and sound waves. In medicine it is often applied in procedures in speech and hearing studies. With regard to the environment, it refers to the characteristics of a room, auditorium, theatre, building, etc. that determines the audibility or fidelity of sounds in it. (From Random House Unabridged Dictionary, 2d ed)'),
  'D000163': NtO(MH='Acquired Immunodeficiency Syndrome', MS='An acquired defect of cellular immunity associated with infection by the human immunodeficiency virus (HIV), a CD4-positive T-lymphocyte count under 200 cells/microliter or less than 14% of total lymphocytes, and increased susceptibility to opportunistic infections and malignant neoplasms. Clinical manifestations also include emaciation (wasting) and dementia. These elements reflect criteria for AIDS as defined by the CDC in 1993.'),
  'D000164': NtO(MH='Acremonium', MS='A mitosporic fungal genus with many reported ascomycetous teleomorphs. Cephalosporin antibiotics are derived from this genus.'),
  'D000165': NtO(MH='Acridine Orange', MS='A cationic cytochemical stain specific for cell nuclei, especially DNA. It is used as a supravital stain and in fluorescence cytochemistry. It may cause mutations in microorganisms.'),
  'D000166': NtO(MH='Acridines', MS='Compounds that include the structure of acridine.'),
  'D000167': NtO(MH='Acriflavine', MS='3,6-Diamino-10-methylacridinium chloride mixt. with 3,6-acridinediamine. Fluorescent dye used as a local antiseptic and also as a biological stain. It intercalates into nucleic acids thereby inhibiting bacterial and viral replication.'),
  'D000168': NtO(MH='Acrocephalosyndactylia', MS='Congenital craniostenosis with syndactyly.'),
  'D000169': NtO(MH='Acrodermatitis', MS='Inflammation involving the skin of the extremities, especially the hands and feet. Several forms are known, some idiopathic and some hereditary. The infantile form is called Gianotti-Crosti syndrome.'),
  'D000170': NtO(MH='Acrodynia', MS='A condition seen primarily in childhood, most often resulting from chronic exposure to MERCURY COMPOUNDS which may result in encephalopathy and POLYNEUROPATHY. Clinical features include pain, swelling and pinkish discoloration of the fingers and toes, weakness in the extremities, extreme irritability, HYPERESTHESIA, and alterations in level of consciousness. (From Menkes, Textbook of Child Neurology, 5th ed, p603)'),
  'D000171': NtO(MH='Acrolein', MS='Unsaturated three-carbon aldehyde.'),
  'D000172': NtO(MH='Acromegaly', MS='A condition caused by prolonged exposure to excessive HUMAN GROWTH HORMONE in adults. It is characterized by bony enlargement of the FACE; lower jaw (PROGNATHISM); hands; FEET; HEAD; and THORAX. The most common etiology is a GROWTH HORMONE-SECRETING PITUITARY ADENOMA. (From Joynt, Clinical Neurology, 1992, Ch36, pp79-80)'),
  'D000173': NtO(MH='Acromioclavicular Joint', MS='The gliding joint formed by the outer extremity of the CLAVICLE and the inner margin of the ACROMION PROCESS of the SCAPULA.'),
  'D000174': NtO(MH='Acromion', MS='The lateral extension of the spine of the SCAPULA and the highest point of the SHOULDER.'),
  'D000175': NtO(MH='Acronine', MS='A pyrano-acridone alkaloid found in RUTACEAE plants.'),
  'D000176': NtO(MH='Acrosin', MS='A trypsin-like enzyme of spermatozoa which is not inhibited by alpha 1 antitrypsin.'),
  'D000177': NtO(MH='Acrosome', MS='The cap-like structure covering the anterior portion of SPERM HEAD. Acrosome, derived from LYSOSOMES, is a membrane-bound organelle that contains the required hydrolytic and proteolytic enzymes necessary for sperm penetration of the egg in FERTILIZATION.'),
  'D000178': NtO(MH='Acrylamides', MS='Colorless, odorless crystals that are used extensively in research laboratories for the preparation of polyacrylamide gels for electrophoresis and in organic synthesis, and polymerization. Some of its polymers are used in sewage and wastewater treatment, permanent press fabrics, and as soil conditioning agents.'),
  'D000179': NtO(MH='Acrylates', MS='Derivatives of acrylic acid (the structural formula CH2=CHCO2H), including its salts and esters.'),
  'D000180': NtO(MH='Acrylic Resins', MS=None),
  'D000181': NtO(MH='Acrylonitrile', MS='A highly poisonous compound used widely in the manufacture of plastics, adhesives and synthetic rubber.'),
  'D000182': NtO(MH='ACTH Syndrome, Ectopic', MS='Symptom complex due to ACTH production by non-pituitary neoplasms.'),
  'D000183': NtO(MH='Actihaemyl', MS='An extract from calf blood containing inorganic salts, amino acids, polypeptides and purines, but no proteins nor antigenic substances or blood group characteristics. Its exact composition is unknown. It has been proposed as a radiation-protective agent.'),
  'D000184': NtO(MH='Acting Out', MS='Expressing unconscious emotional conflicts or feelings, often of hostility or love, through overt behavior.'),
  'D000185': NtO(MH='Actinin', MS='A protein factor that regulates the length of R-actin. It is chemically similar, but immunochemically distinguishable from actin.'),
  'D000186': NtO(MH='Actinium', MS='A trivalent radioactive element and the prototypical member of the actinide family. It has the atomic symbol Ac, and atomic number 89. Its principal isotope is 227 and it decays primarily by beta-emission.'),
  'D000187': NtO(MH='Actinobacillosis', MS='A disease characterized by suppurative and granulomatous lesions in the respiratory tract, upper alimentary tract, skin, kidneys, joints, and other tissues. Actinobacillus lignieresii infects cattle and sheep while A. equuli infects horses and pigs.'),
  'D000188': NtO(MH='Actinobacillus', MS='A genus of PASTEURELLACEAE described as gram-negative, nonsporeforming, nonmotile, facultative anaerobes. Most members are found both as pathogens and commensal organisms in the respiratory, alimentary, and genital tracts of animals.'),
  'D000189': NtO(MH='Actinobacillus Infections', MS='Infections with bacteria of the genus ACTINOBACILLUS.'),
  'D000190': NtO(MH='Actinomyces', MS='A genus of gram-positive, rod-shaped bacteria whose organisms are nonmotile. Filaments that may be present in certain species are either straight or wavy and may have swollen or clubbed heads.'),
  'D000191': NtO(MH='Actinomycetaceae', MS='A family of bacteria including numerous parasitic and pathogenic forms.'),
  'D000192': NtO(MH='Actinomycetales', MS='An order of gram-positive, primarily aerobic BACTERIA that tend to form branching filaments.'),
  'D000193': NtO(MH='Actinomycetales Infections', MS='Infections with bacteria of the order ACTINOMYCETALES.'),
  'D000196': NtO(MH='Actinomycosis', MS='Infections with bacteria of the genus ACTINOMYCES.'),
  'D000197': NtO(MH='Actinomycosis, Cervicofacial', MS='A form of ACTINOMYCOSIS characterized by slow-growing inflammatory lesions of the lymph nodes that drain the mouth (lumpy jaw), reddening of the overlying skin, and intraperitoneal abscesses.'),
  'D000198': NtO(MH='Spectinomycin', MS='An antibiotic produced by Streptomyces spectabilis. It is active against gram-negative bacteria and used for the treatment of GONORRHEA.'),
  'D000199': NtO(MH='Actins', MS='Filamentous proteins that are the main constituent of the thin filaments of muscle fibers. The filaments (known also as filamentous or F-actin) can be dissociated into their globular subunits; each subunit is composed of a single polypeptide 375 amino acids long. This is known as globular or G-actin. In conjunction with MYOSINS, actin is responsible for the contraction and relaxation of muscle.'),
  'D000200': NtO(MH='Action Potentials', MS='Abrupt changes in the membrane potential that sweep along the CELL MEMBRANE of excitable cells in response to excitation stimuli.'),
  'D000201': NtO(MH='Activation Analysis', MS='A method of chemical analysis based on the detection of characteristic radionuclides following a nuclear bombardment. It is also known as radioactivity analysis. (McGraw-Hill Dictionary of Scientific and Technical Terms, 4th ed)'),
  'D000202': NtO(MH='Activator Appliances', MS='Loose-fitting removable orthodontic appliances which redirect the pressures of the facial and masticatory muscles onto the teeth and their supporting structures to produce improvements in tooth arrangements and occlusal relations.'),
  'D000203': NtO(MH='Activities of Daily Living', MS='The performance of the basic activities of self care, such as dressing, ambulation, or eating.'),
  'D000204': NtO(MH='Activity Cycles', MS='Bouts of physical irritability or movement alternating with periods of quiescence. It includes biochemical activity and hormonal activity which may be cellular. These cycles are shorter than 24 hours and include sleep-wakefulness cycles and the periodic activation of the digestive system.'),
  'D000205': NtO(MH='Actomyosin', MS='A protein complex of actin and MYOSINS occurring in muscle. It is the essential contractile substance of muscle.'),
  'D000206': NtO(MH='Actuarial Analysis', MS='The application of probability and statistical methods to calculate the risk of occurrence of any event, such as onset of illness, recurrent disease, hospitalization, disability, or death. It may include calculation of the anticipated money costs of such events and of the premiums necessary to provide for payment of such costs.'),
  'D000208': NtO(MH='Acute Disease', MS='Disease having a short and relatively severe course.'),
  'D000209': NtO(MH='Acute-Phase Proteins', MS='Proteins that are secreted into the blood in increased or decreased quantities by hepatocytes in response to trauma, inflammation, or disease. These proteins can serve as inhibitors or mediators of the inflammatory processes. Certain acute-phase proteins have been used to diagnose and follow the course of diseases or as tumor markers.'),
  'D000210': NtO(MH='Acute-Phase Reaction', MS='An early local inflammatory reaction to insult or injury that consists of fever, an increase in inflammatory humoral factors, and an increased synthesis by hepatocytes of a number of proteins or glycoproteins usually found in the plasma.'),
  'D000212': NtO(MH='Acyclovir', MS='A GUANOSINE analog that acts as an antimetabolite. Viruses are especially susceptible. Used especially against herpes.'),
  'D000213': NtO(MH='Acyl Carrier Protein', MS="Consists of a polypeptide chain and 4'-phosphopantetheine linked to a serine residue by a phosphodiester bond. Acyl groups are bound as thiol esters to the pantothenyl group. Acyl carrier protein is involved in every step of fatty acid synthesis by the cytoplasmic system."),
  'D000214': NtO(MH='Acyl Coenzyme A', MS='S-Acyl coenzyme A. Fatty acid coenzyme A derivatives that are involved in the biosynthesis and oxidation of fatty acids as well as in ceramide formation.'),
  'D000215': NtO(MH='Acylation', MS='The addition of an organic acid radical into a molecule.'),
  'D000216': NtO(MH='N-Acylneuraminate Cytidylyltransferase', MS='An enzyme that forms CMP-acylneuraminic acids, which donate the N-acylneuraminic acid residues to the terminal sugar residue of a ganglioside or glycoprotein. EC 2.7.7.43.'),
  'D000217': NtO(MH='Acyltransferases', MS='Enzymes from the transferase class that catalyze the transfer of acyl groups from donor to acceptor, forming either esters or amides. (From Enzyme Nomenclature 1992) EC 2.3.'),
  'D000218': NtO(MH='Adamantane', MS='A tricyclo bridged hydrocarbon.'),
  'D000219': NtO(MH='Adams-Stokes Syndrome', MS='A condition of fainting spells caused by heart block, often an atrioventricular block, that leads to BRADYCARDIA and drop in CARDIAC OUTPUT. When the cardiac output becomes too low, the patient faints (SYNCOPE). In some cases, the syncope attacks are transient and in others cases repetitive and persistent.'),
  'D000220': NtO(MH='Adaptation, Biological', MS='Changes in biological features that help an organism cope with its ENVIRONMENT. These changes include physiological (ADAPTATION, PHYSIOLOGICAL), phenotypic and genetic changes.'),
  'D000221': NtO(MH='Adaptation, Ocular', MS='The adjustment of the eye to variations in the intensity of light. Light adaptation is the adjustment of the eye when the light threshold is increased; DARK ADAPTATION when the light is greatly reduced. (From Cline et al., Dictionary of Visual Science, 4th ed)'),
  'D000222': NtO(MH='Adaptation, Physiological', MS='The non-genetic biological changes of an organism in response to challenges in its ENVIRONMENT.'),
  'D000223': NtO(MH='Adaptation, Psychological', MS='A state of harmony between internal needs and external demands and the processes used in achieving this condition. (From APA Thesaurus of Psychological Index Terms, 8th ed)'),
  'D000224': NtO(MH='Addison Disease', MS='An adrenal disease characterized by the progressive destruction of the ADRENAL CORTEX, resulting in insufficient production of ALDOSTERONE and HYDROCORTISONE. Clinical symptoms include ANOREXIA; NAUSEA; WEIGHT LOSS; MUSCLE WEAKNESS; and HYPERPIGMENTATION of the SKIN due to increase in circulating levels of ACTH precursor hormone which stimulates MELANOCYTES.'),
  'D000225': NtO(MH='Adenine', MS='A purine base and a fundamental unit of ADENINE NUCLEOTIDES.'),
  'D000226': NtO(MH='Mitochondrial ADP, ATP Translocases', MS='A class of nucleotide translocases found abundantly in mitochondria that function as integral components of the inner mitochondrial membrane. They facilitate the exchange of ADP and ATP between the cytosol and the mitochondria, thereby linking the subcellular compartments of ATP production to those of ATP utilization.'),
  'D000227': NtO(MH='Adenine Nucleotides', MS=None),
  'D000228': NtO(MH='Adenine Phosphoribosyltransferase', MS='An enzyme catalyzing the formation of AMP from adenine and phosphoribosylpyrophosphate. It can act as a salvage enzyme for recycling of adenine into nucleic acids. EC 2.4.2.7.'),
  'D000229': NtO(MH='Dependovirus', MS='A genus of the family PARVOVIRIDAE, subfamily PARVOVIRINAE, which are dependent on a coinfection with helper adenoviruses or herpesviruses for their efficient replication. The type species is Adeno-associated virus 2.'),
  'D000230': NtO(MH='Adenocarcinoma', MS='A malignant epithelial tumor with a glandular organization.'),
  'D000231': NtO(MH='Adenocarcinoma, Papillary', MS='An adenocarcinoma containing finger-like processes of vascular connective tissue covered by neoplastic epithelium, projecting into cysts or the cavity of glands or follicles. It occurs most frequently in the ovary and thyroid gland. (Stedman, 25th ed)'),
  'D000232': NtO(MH='Adenofibroma', MS='A benign neoplasm composed of glandular and fibrous tissues, with a relatively large proportion of glands. (Stedman, 25th ed)'),
  'D000233': NtO(MH='Adenoidectomy', MS='Excision of the adenoids. (Dorland, 28th ed)'),
  'D000234': NtO(MH='Adenoids', MS='A collection of lymphoid nodules on the posterior wall and roof of the NASOPHARYNX.'),
  'D000235': NtO(MH='Adenolymphoma', MS='A benign tumor characterized histologically by tall columnar epithelium within a lymphoid tissue stroma. It is usually found in the salivary glands, especially the parotid.'),
  'D000236': NtO(MH='Adenoma', MS='A benign epithelial tumor with a glandular organization.'),
  'D000237': NtO(MH='Adenoma, Basophil', MS='A small tumor of the anterior lobe of the pituitary gland whose cells stain with basic dyes. It may give rise to excessive secretion of ACTH, resulting in CUSHING SYNDROME. (Dorland, 27th ed)'),
  'D000238': NtO(MH='Adenoma, Chromophobe', MS='A benign tumor of the anterior pituitary in which the cells do not stain with acidic or basic dyes.'),
  'D000239': NtO(MH='Adenoma, Acidophil', MS='A benign tumor, usually found in the anterior lobe of the pituitary gland, whose cells stain with acid dyes. Such pituitary tumors may give rise to excessive secretion of growth hormone, resulting in gigantism or acromegaly. A specific type of acidophil adenoma may give rise to nonpuerperal galactorrhea. (Dorland, 27th ed)'),
  'D000241': NtO(MH='Adenosine', MS='A nucleoside that is composed of ADENINE and D-RIBOSE. Adenosine or adenosine derivatives play many important biological roles in addition to being components of DNA and RNA. Adenosine itself is a neurotransmitter.'),
  'D000242': NtO(MH='Cyclic AMP', MS="An adenine nucleotide containing one phosphate group which is esterified to both the 3'- and 5'-positions of the sugar moiety. It is a second messenger and a key intracellular regulator, functioning as a mediator of activity for a number of hormones, including epinephrine, glucagon, and ACTH."),
  'D000243': NtO(MH='Adenosine Deaminase', MS='An enzyme that catalyzes the hydrolysis of ADENOSINE to INOSINE with the elimination of AMMONIA.'),
  'D000244': NtO(MH='Adenosine Diphosphate', MS="Adenosine 5'-(trihydrogen diphosphate). An adenine nucleotide containing two phosphate groups esterified to the sugar moiety at the 5'-position."),
  'D000245': NtO(MH='Adenosine Diphosphate Glucose', MS='Serves as the glycosyl donor for formation of bacterial glycogen, amylose in green algae, and amylopectin in higher plants.'),
  'D000246': NtO(MH='Adenosine Diphosphate Ribose', MS='An ester formed between the aldehydic carbon of RIBOSE and the terminal phosphate of ADENOSINE DIPHOSPHATE. It is produced by the hydrolysis of nicotinamide-adenine dinucleotide (NAD) by a variety of enzymes, some of which transfer an ADP-ribosyl group to target proteins.'),
  'D000247': NtO(MH='Adenosine Diphosphate Sugars', MS='Esters formed between the aldehydic carbon of sugars and the terminal phosphate of adenosine diphosphate.'),
  'D000248': NtO(MH='Adenosine Kinase', MS='An enzyme that catalyzes the formation of ADP plus AMP from adenosine plus ATP. It can serve as a salvage mechanism for returning adenosine to nucleic acids. EC 2.7.1.20.'),
  'D000249': NtO(MH='Adenosine Monophosphate', MS="Adenine nucleotide containing one phosphate group esterified to the sugar moiety in the 2'-, 3'-, or 5'-position."),
  'D000250': NtO(MH='Adenosine Phosphosulfate', MS="5'-Adenylic acid, monoanhydride with sulfuric acid. The initial compound formed by the action of ATP sulfurylase on sulfate ions after sulfate uptake. Synonyms: adenosine sulfatophosphate; APS."),
  'D000251': NtO(MH='Adenosine Triphosphatases', MS='A group of enzymes which catalyze the hydrolysis of ATP. The hydrolysis reaction is usually coupled with another function such as transporting Ca(2+) across a membrane. These enzymes may be dependent on Ca(2+), Mg(2+), anions, H+, or DNA.'),
  'D000252': NtO(MH='Calcium-Transporting ATPases', MS='Cation-transporting proteins that utilize the energy of ATP hydrolysis for the transport of CALCIUM. They differ from CALCIUM CHANNELS which allow calcium to pass through a membrane without the use of energy.'),
  'D000254': NtO(MH='Sodium-Potassium-Exchanging ATPase', MS='An enzyme that catalyzes the active transport system of sodium and potassium ions across the cell wall. Sodium and potassium ions are closely coupled with membrane ATPase which undergoes phosphorylation and dephosphorylation, thereby providing energy for transport of these ions against concentration gradients.'),
  'D000255': NtO(MH='Adenosine Triphosphate', MS='An adenine nucleotide containing three phosphate groups esterified to the sugar moiety. In addition to its crucial roles in metabolism adenosine triphosphate is a neurotransmitter.'),
  'D000256': NtO(MH='Adenoviridae', MS='A family of non-enveloped viruses infecting mammals (MASTADENOVIRUS) and birds (AVIADENOVIRUS) or both (ATADENOVIRUS). Infections may be asymptomatic or result in a variety of diseases.'),
  'D000257': NtO(MH='Adenoviridae Infections', MS='Virus diseases caused by the ADENOVIRIDAE.'),
  'D000258': NtO(MH='Adenovirus Infections, Human', MS='Respiratory and conjunctival infections caused by 33 identified serotypes of human adenoviruses.'),
  'D000259': NtO(MH='Aviadenovirus', MS='A genus of ADENOVIRIDAE that infects birds. The type species is FOWL ADENOVIRUS A.'),
  'D000260': NtO(MH='Adenoviruses, Human', MS='Species of the genus MASTADENOVIRUS, causing a wide range of diseases in humans. Infections are mostly asymptomatic, but can be associated with diseases of the respiratory, ocular, and gastrointestinal systems. Serotypes (named with Arabic numbers) have been grouped into species designated Human adenovirus A-G.'),
  'D000261': NtO(MH='Adenoviruses, Simian', MS='Species of the genus MASTADENOVIRUS associated with respiratory and enteric infections in primate hosts.'),
  'D000262': NtO(MH='Adenylyl Cyclases', MS='Enzymes of the lyase class that catalyze the formation of CYCLIC AMP and pyrophosphate from ATP.'),
  'D000263': NtO(MH='Adenylate Kinase', MS='An enzyme that catalyzes the phosphorylation of AMP to ADP in the presence of ATP or inorganic triphosphate. EC 2.7.4.3.'),
  'D000264': NtO(MH='Adenylosuccinate Lyase', MS="An enzyme that, in the course of purine ribonucleotide biosynthesis, catalyzes the conversion of 5'-phosphoribosyl-4-(N-succinocarboxamide)-5-aminoimidazole to 5'-phosphoribosyl-4-carboxamide-5-aminoimidazole and the conversion of adenylosuccinic acid to AMP. EC 4.3.2.2."),
  'D000265': NtO(MH='Adenylosuccinate Synthase', MS='A carbon-nitrogen ligase. During purine ribonucleotide biosynthesis, this enzyme catalyzes the synthesis of adenylosuccinate from GTP; IMP; and aspartate with the formation of orthophosphate and GDP. EC 6.3.4.4.'),
  'D000266': NtO(MH='Adenylyl Imidodiphosphate', MS="5'-Adenylic acid, monoanhydride with imidodiphosphoric acid. An analog of ATP, in which the oxygen atom bridging the beta to the gamma phosphate is replaced by a nitrogen atom. It is a potent competitive inhibitor of soluble and membrane-bound mitochondrial ATPase and also inhibits ATP-dependent reactions of oxidative phosphorylation."),
  'D000267': NtO(MH='Tissue Adhesions', MS='Pathological processes consisting of the union of the opposing surfaces of a wound.'),
  'D000268': NtO(MH='Adhesiveness', MS='A property of the surface of an object that makes it stick to another surface.'),
  'D000269': NtO(MH='Adhesives', MS='Substances that cause the adherence of two surfaces. They include glues (properly collagen-derived adhesives), mucilages, sticky pastes, gums, resins, or latex.'),
  'D000270': NtO(MH='Adie Syndrome', MS='A syndrome characterized by a TONIC PUPIL that occurs in combination with decreased lower extremity reflexes. The affected pupil will respond more briskly to accommodation than to light (light-near dissociation) and is supersensitive to dilute pilocarpine eye drops, which induce pupillary constriction. Pathologic features include degeneration of the ciliary ganglion and postganglionic parasympathetic fibers that innervate the pupillary constrictor muscle. (From Adams et al., Principles of Neurology, 6th ed, p279)'),
  'D000272': NtO(MH='Adipates', MS='Derivatives of adipic acid. Included under this heading are a broad variety of acid forms, salts, esters, and amides that contain a 1,6-carboxy terminated aliphatic structure.'),
  'D000273': NtO(MH='Adipose Tissue', MS='Specialized connective tissue composed of fat cells (ADIPOCYTES). It is the site of stored FATS, usually in the form of TRIGLYCERIDES. In mammals, there are two types of adipose tissue, the WHITE FAT and the BROWN FAT. Their relative distributions vary in different species with most adipose tissue being white.'),
  'D000274': NtO(MH='Adiposis Dolorosa', MS='A rare disease characterized by multiple tumor-like fatty deposits that press on nerves in various sites causing pain and weakness. Often these lipoma-like structures are located on the trunk and limbs but not on the face and hands.'),
  'D000275': NtO(MH='Adjustment Disorders', MS='Maladaptive reactions to identifiable psychosocial stressors occurring within a short time after onset of the stressor. They are manifested by either impairment in social or occupational functioning or by symptoms (depression, anxiety, etc.) that are in excess of a normal and expected reaction to the stressor.'),
  'D000276': NtO(MH='Adjuvants, Immunologic', MS="Substances that augment, stimulate, activate, potentiate, or modulate the immune response at either the cellular or humoral level. The classical agents (Freund's adjuvant, BCG, Corynebacterium parvum, et al.) contain bacterial antigens. Some are endogenous (e.g., histamine, interferon, transfer factor, tuftsin, interleukin-1). Their mode of action is either non-specific, resulting in increased immune responsiveness to a wide variety of antigens, or antigen-specific, i.e., affecting a restricted type of immune response to a narrow group of antigens. The therapeutic efficacy of many biological response modifiers is related to their antigen-specific immunoadjuvanticity."),
  'D000277': NtO(MH='Adjuvants, Pharmaceutic', MS='Agents that aid or increase the action of the principle drug (DRUG SYNERGISM) or that affect the absorption, mechanism of action, metabolism, or excretion of the primary drug (PHARMACOKINETICS) in such a way as to enhance its effects.'),
  'D000278': NtO(MH='Administration, Buccal', MS='Administration of a soluble dosage form between the cheek and gingiva. It may involve direct application of a drug onto the buccal mucosa, as by painting or spraying.'),
  'D000279': NtO(MH='Administration, Cutaneous', MS='The application of suitable drug dosage forms to the skin for either local or systemic effects.'),
  'D000280': NtO(MH='Administration, Inhalation', MS='The administration of drugs by the respiratory route. It includes insufflation into the respiratory tract.'),
  'D000281': NtO(MH='Administration, Intranasal', MS='Delivery of medications through the nasal mucosa.'),
  'D000282': NtO(MH='Administration, Intravaginal', MS='The insertion of drugs into the vagina to treat local infections, neoplasms, or to induce labor. The dosage forms may include medicated pessaries, irrigation fluids, and suppositories.'),
  'D000283': NtO(MH='Administration, Intravesical', MS='The instillation or other administration of drugs into the bladder, usually to treat local disease, including neoplasms.'),
  'D000284': NtO(MH='Administration, Oral', MS='The giving of drugs, chemicals, or other substances by mouth.'),
  'D000285': NtO(MH='Administration, Rectal', MS='The insertion of drugs into the rectum, usually for confused or incompetent patients, like children, infants, and the very old or comatose.'),
  'D000286': NtO(MH='Administration, Sublingual', MS='Administration of a soluble dosage form by placement under the tongue.'),
  'D000287': NtO(MH='Administration, Topical', MS='The application of drug preparations to the surfaces of the body, especially the skin (ADMINISTRATION, CUTANEOUS) or mucous membranes. This method of treatment is used to avoid systemic side effects when high doses are required at a localized area or as an alternative systemic administration route, to avoid hepatic processing for example.'),
  'D000288': NtO(MH='Administrative Personnel', MS='Individuals responsible for the development of policy and supervision of the execution of plans and functional operations.'),
  'D000289': NtO(MH='Admitting Department, Hospital', MS="Hospital department responsible for the flow of patients and the processing of admissions, discharges, transfers, and also most procedures to be carried out in the event of a patient's death."),
  'D000290': NtO(MH='Adnexa Uteri', MS='Appendages of the UTERUS which include the FALLOPIAN TUBES, the OVARY, and the supporting ligaments of the uterus (BROAD LIGAMENT; ROUND LIGAMENT).'),
  'D000291': NtO(MH='Adnexal Diseases', MS='Diseases of the uterine appendages (ADNEXA UTERI) including diseases involving the OVARY, the FALLOPIAN TUBES, and ligaments of the uterus (BROAD LIGAMENT; ROUND LIGAMENT).'),
  'D000292': NtO(MH='Pelvic Inflammatory Disease', MS='A spectrum of inflammation involving the female upper genital tract and the supporting tissues. It is usually caused by an ascending infection of organisms from the endocervix. Infection may be confined to the uterus (ENDOMETRITIS), the FALLOPIAN TUBES; (SALPINGITIS); the ovaries (OOPHORITIS), the supporting ligaments (PARAMETRITIS), or may involve several of the above uterine appendages. Such inflammation can lead to functional impairment and infertility.'),
  'D000293': NtO(MH='Adolescent', MS='A person 13 to 18 years of age.'),
  'D000294': NtO(MH='Adolescent Behavior', MS='Any observable response or action of an adolescent.'),
  'D000295': NtO(MH='Adolescent Medicine', MS='A branch of medicine pertaining to the diagnosis and treatment of diseases occurring during the period of ADOLESCENCE.'),
  'D000296': NtO(MH='Adolescent Psychiatry', MS='The medical science that deals with the origin, diagnosis, prevention, and treatment of mental disorders in individuals 13-18 years.'),
  'D000297': NtO(MH='Psychology, Adolescent', MS='Field of psychology involving the study of normal and abnormal behavior of adolescents. It includes mental processes as well as observable responses.'),
  'D000298': NtO(MH='Adolescent, Hospitalized', MS='Adolescent hospitalized for short term care.'),
  'D000299': NtO(MH='Adolescent, Institutionalized', MS='An adolescent who is receiving long-term in-patient services or who resides in an institutional setting.'),
  'D000300': NtO(MH='Adoption', MS="Voluntary acceptance of a child of other parents to be as one's own child, usually with legal confirmation."),
  'D000301': NtO(MH='Adosterol', MS='A sterol usually substituted with radioactive iodine. It is an adrenal cortex scanning agent with demonstrated high adrenal concentration and superior adrenal imaging.'),
  'D000302': NtO(MH='Adrenal Cortex', MS='The outer layer of the adrenal gland. It is derived from MESODERM and comprised of three zones (outer ZONA GLOMERULOSA, middle ZONA FASCICULATA, and inner ZONA RETICULARIS) with each producing various steroids preferentially, such as ALDOSTERONE; HYDROCORTISONE; DEHYDROEPIANDROSTERONE; and ANDROSTENEDIONE. Adrenal cortex function is regulated by pituitary ADRENOCORTICOTROPIN.'),
  'D000303': NtO(MH='Adrenal Cortex Diseases', MS='Pathological processes of the ADRENAL CORTEX.'),
  'D000304': NtO(MH='Adrenal Cortex Function Tests', MS='Examinations that evaluate and monitor hormone production in the adrenal cortex.'),
  'D000305': NtO(MH='Adrenal Cortex Hormones', MS=None),
  'D000306': NtO(MH='Adrenal Cortex Neoplasms', MS='Tumors or cancers of the ADRENAL CORTEX.'),
  'D000307': NtO(MH='Adrenal Gland Diseases', MS='Pathological processes of the ADRENAL GLANDS.'),
  'D000308': NtO(MH='Adrenocortical Hyperfunction', MS='Excess production of ADRENAL CORTEX HORMONES such as ALDOSTERONE; HYDROCORTISONE; DEHYDROEPIANDROSTERONE; and/or ANDROSTENEDIONE. Hyperadrenal syndromes include CUSHING SYNDROME; HYPERALDOSTERONISM; and VIRILISM.'),
  'D000309': NtO(MH='Adrenal Insufficiency', MS='Conditions in which the production of adrenal CORTICOSTEROIDS falls below the requirement of the body. Adrenal insufficiency can be caused by defects in the ADRENAL GLANDS, the PITUITARY GLAND, or the HYPOTHALAMUS.'),
  'D000310': NtO(MH='Adrenal Gland Neoplasms', MS='Tumors or cancer of the ADRENAL GLANDS.'),
  'D000311': NtO(MH='Adrenal Glands', MS='A pair of glands located at the cranial pole of each of the two KIDNEYS. Each adrenal gland is composed of two distinct endocrine tissues with separate embryonic origins, the ADRENAL CORTEX producing STEROIDS and the ADRENAL MEDULLA producing NEUROTRANSMITTERS.'),
  'D000312': NtO(MH='Adrenal Hyperplasia, Congenital', MS='A group of inherited disorders of the ADRENAL GLANDS, caused by enzyme defects in the synthesis of cortisol (HYDROCORTISONE) and/or ALDOSTERONE leading to accumulation of precursors for ANDROGENS. Depending on the hormone imbalance, congenital adrenal hyperplasia can be classified as salt-wasting, hypertensive, virilizing, or feminizing. Defects in STEROID 21-HYDROXYLASE; STEROID 11-BETA-HYDROXYLASE; STEROID 17-ALPHA-HYDROXYLASE; 3-beta-hydroxysteroid dehydrogenase (3-HYDROXYSTEROID DEHYDROGENASES); TESTOSTERONE 5-ALPHA-REDUCTASE; or steroidogenic acute regulatory protein; among others, underlie these disorders.'),
  'D000313': NtO(MH='Adrenal Medulla', MS='The inner portion of the adrenal gland. Derived from ECTODERM, adrenal medulla consists mainly of CHROMAFFIN CELLS that produces and stores a number of NEUROTRANSMITTERS, mainly adrenaline (EPINEPHRINE) and NOREPINEPHRINE. The activity of the adrenal medulla is regulated by the SYMPATHETIC NERVOUS SYSTEM.'),
  'D000314': NtO(MH='Adrenal Rest Tumor', MS='Neoplasm derived from displaced cells (rest cells) of the primordial ADRENAL GLANDS, generally in patients with CONGENITAL ADRENAL HYPERPLASIA. Adrenal rest tumors have been identified in TESTES; LIVER; and other tissues. They are dependent on ADRENOCORTICOTROPIN for growth and adrenal steroid secretion.'),
  'D000315': NtO(MH='Adrenalectomy', MS='Excision of one or both adrenal glands. (From Dorland, 28th ed)'),
  'D000316': NtO(MH='Adrenergic alpha-Agonists', MS='Drugs that selectively bind to and activate alpha adrenergic receptors.'),
  'D000317': NtO(MH='Adrenergic alpha-Antagonists', MS='Drugs that bind to but do not activate alpha-adrenergic receptors thereby blocking the actions of endogenous or exogenous adrenergic agonists. Adrenergic alpha-antagonists are used in the treatment of hypertension, vasospasm, peripheral vascular disease, shock, and pheochromocytoma.'),
  'D000318': NtO(MH='Adrenergic beta-Agonists', MS='Drugs that selectively bind to and activate beta-adrenergic receptors.'),
  'D000319': NtO(MH='Adrenergic beta-Antagonists', MS='Drugs that bind to but do not activate beta-adrenergic receptors thereby blocking the actions of beta-adrenergic agonists. Adrenergic beta-antagonists are used for treatment of hypertension, cardiac arrhythmias, angina pectoris, glaucoma, migraine headaches, and anxiety.'),
  'D000320': NtO(MH='Adrenergic Fibers', MS='Nerve fibers liberating catecholamines at a synapse after an impulse.'),
  'D000322': NtO(MH='Adrenergic Agonists', MS='Drugs that bind to and activate adrenergic receptors.'),
  'D000323': NtO(MH='Adrenochrome', MS='Pigment obtained by the oxidation of epinephrine.'),
  'D000324': NtO(MH='Adrenocorticotropic Hormone', MS='An anterior pituitary hormone that stimulates the ADRENAL CORTEX and its production of CORTICOSTEROIDS. ACTH is a 39-amino acid polypeptide of which the N-terminal 24-amino acid segment is identical in all species and contains the adrenocorticotrophic activity. Upon further tissue-specific processing, ACTH can yield ALPHA-MSH and corticotrophin-like intermediate lobe peptide (CLIP).'),
  'D000325': NtO(MH='Adrenodoxin', MS='An iron-sulfur protein which serves as an electron carrier in enzymatic steroid hydroxylation reactions in adrenal cortex mitochondria. The electron transport system which catalyzes this reaction consists of adrenodoxin reductase, NADP, adrenodoxin, and cytochrome P-450.'),
  'D000326': NtO(MH='Adrenoleukodystrophy', MS='An X-linked recessive disorder characterized by the accumulation of saturated very long chain fatty acids in the LYSOSOMES of ADRENAL CORTEX and the white matter of CENTRAL NERVOUS SYSTEM. This disease occurs almost exclusively in the males. Clinical features include the childhood onset of ATAXIA; NEUROBEHAVIORAL MANIFESTATIONS; HYPERPIGMENTATION; ADRENAL INSUFFICIENCY; SEIZURES; MUSCLE SPASTICITY; and DEMENTIA. The slowly progressive adult form is called adrenomyeloneuropathy. The defective gene ABCD1 is located at Xq28, and encodes the adrenoleukodystrophy protein (ATP-BINDING CASSETTE TRANSPORTERS).'),
  'D000327': NtO(MH='Adsorption', MS='The adhesion of gases, liquids, or dissolved solids onto a surface. It includes adsorptive phenomena of bacteria and viruses onto surfaces as well. ABSORPTION into the substance may follow but not necessarily.'),
  'D000328': NtO(MH='Adult', MS='A person having attained full growth or maturity. Adults are of 19 through 44 years of age. For a person between 19 and 24 years of age, YOUNG ADULT is available.'),
  'D000329': NtO(MH='Advertising', MS='Works about the act or practice of calling public attention to a product, service, need, etc., especially by paid announcements in newspapers, magazines, on radio, or on television. (Random House Unabridged Dictionary, 2d ed)'),
  'D000330': NtO(MH='Aedes', MS='A genus of mosquitoes (CULICIDAE) frequently found in tropical and subtropical regions. YELLOW FEVER and DENGUE are two of the diseases that can be transmitted by species of this genus.'),
  'D000331': NtO(MH='Aequorin', MS='A photoprotein isolated from the bioluminescent jellyfish Aequorea. It emits visible light by an intramolecular reaction when a trace amount of calcium ion is added. The light-emitting moiety in the bioluminescence reaction is believed to be 2-amino-3-benzyl-5-(p-hydroxyphenyl)pyrazine (AF-350).'),
  'D000332': NtO(MH='Aerobiosis', MS='Life or metabolic reactions occurring in an environment containing oxygen.'),
  'D000333': NtO(MH='Aeromonas', MS='A genus of gram-negative, facultatively anaerobic, rod-shaped bacteria that occurs singly, in pairs, or in short chains. Its organisms are found in fresh water and sewage and are pathogenic to humans, frogs, and fish.'),
  'D000334': NtO(MH='Aerophagy', MS='Spasmodic swallowing of air.'),
  'D000335': NtO(MH='Aerosol Propellants', MS='Compressed gases or vapors in a container which, upon release of pressure and expansion through a valve, carry another substance from the container. They are used for cosmetics, household cleaners, and so on. Examples are BUTANES; CARBON DIOXIDE; FLUOROCARBONS; NITROGEN; and PROPANE. (McGraw-Hill Dictionary of Scientific and Technical Terms, 4th ed)'),
  'D000336': NtO(MH='Aerosols', MS='Colloids with a gaseous dispersing phase and either liquid (fog) or solid (smoke) dispersed phase; used in fumigation or in inhalation therapy; may contain propellant agents.'),
  'D000337': NtO(MH='Aerospace Medicine', MS='That branch of medicine dealing with the studies and effects of flight through the atmosphere or in space upon the human body and with the prevention or cure of physiological or psychological malfunctions arising from these effects. (from NASA Thesaurus)'),
  'D000338': NtO(MH='beta-Aminoethyl Isothiourea', MS='A radiation-protective agent that can inhibit DNA damage by binding to the DNA. It also increases the susceptibility of blood cells to complement-mediated lysis.'),
  'D000339': NtO(MH='Affect', MS='The feeling-tone accompaniment of an idea or mental representation. It is the most direct psychic derivative of instinct and the psychic representative of the various bodily changes by means of which instincts manifest themselves.'),
  'D000341': NtO(MH='Affective Disorders, Psychotic', MS='Disorders in which the essential feature is a severe disturbance in mood (depression, anxiety, elation, and excitement) accompanied by psychotic symptoms such as delusions, hallucinations, gross impairment in reality testing, etc.'),
  'D000342': NtO(MH='Affective Symptoms', MS='Mood or emotional responses dissonant with or inappropriate to the behavior and/or stimulus.'),
  'D000343': NtO(MH='Afferent Loop Syndrome', MS='A complication of gastrojejunostomy (BILLROTH II PROCEDURE), a reconstructive GASTROENTEROSTOMY. It is caused by acute (complete) or chronic (intermittent) obstruction of the afferent jejunal loop due to HERNIA, intussusception, kinking, VOLVULUS, etc. It is characterized by PAIN and VOMITING of BILE-stained fluid.'),
  'D000344': NtO(MH='Afferent Pathways', MS='Nerve structures through which impulses are conducted from a peripheral part toward a nerve center.'),
  'D000345': NtO(MH='Affinity Labels', MS='Analogs of those substrates or compounds which bind naturally at the active sites of proteins, enzymes, antibodies, steroids, or physiological receptors. These analogs form a stable covalent bond at the binding site, thereby acting as inhibitors of the proteins or steroids.'),
  'D000346': NtO(MH='Afghanistan', MS='Country located north and west of Pakistan, and east of Iran. The capital is Kabul.'),
  'D000347': NtO(MH='Afibrinogenemia', MS='A deficiency or absence of FIBRINOGEN in the blood.'),
  'D000348': NtO(MH='Aflatoxins', MS='Furano-furano-benzopyrans that are produced by ASPERGILLUS from STERIGMATOCYSTIN. They are structurally related to COUMARINS and easily oxidized to an epoxide form to become ALKYLATING AGENTS. Members of the group include AFLATOXIN B1; aflatoxin B2, aflatoxin G1, aflatoxin G2; AFLATOXIN M1; and aflatoxin M2.'),
  'D000349': NtO(MH='Africa', MS='The continent south of EUROPE, east of the ATLANTIC OCEAN and west of the INDIAN OCEAN.'),
  'D000350': NtO(MH='Africa, Central', MS='The geographical area of Africa comprising CAMEROON; CENTRAL AFRICAN REPUBLIC; CHAD; CONGO; EQUATORIAL GUINEA; GABON; and DEMOCRATIC REPUBLIC OF THE CONGO.'),
  'D000351': NtO(MH='Africa, Eastern', MS='The geographical area of Africa comprising BURUNDI, DJIBOUTI, ERITREA, ETHIOPIA, KENYA, RWANDA, SOMALIA, SOUTH SUDAN, SUDAN, TANZANIA, and UGANDA.'),
  'D000352': NtO(MH='Africa, Northern', MS='The geographical area of Africa comprising ALGERIA; EGYPT; LIBYA; MOROCCO and TUNISIA. It includes also the vast deserts and oases of the Sahara. It is often referred to as North Africa or the Maghreb.'),
  'D000353': NtO(MH='Africa, Southern', MS='The geographical area of Africa comprising ANGOLA; BOTSWANA; LESOTHO; MALAWI; MOZAMBIQUE; NAMIBIA; SOUTH AFRICA; SWAZILAND; ZAMBIA; and ZIMBABWE.'),
  'D000354': NtO(MH='Africa, Western', MS="The geographical area of Africa comprising BENIN; BURKINA FASO; CAPO VERDE, COTE D'IVOIRE; GAMBIA; GHANA; GUINEA; GUINEA-BISSAU; LIBERIA; MALI; MAURITANIA; NIGER; NIGERIA; SENEGAL; SIERRA LEONE; and TOGO."),
  'D000355': NtO(MH='African Horse Sickness', MS='An insect-borne reovirus infection of horses, mules and donkeys in Africa and the Middle East; characterized by pulmonary edema, cardiac involvement, and edema of the head and neck.'),
  'D000356': NtO(MH='African Horse Sickness Virus', MS='A species of ORBIVIRUS that causes disease in horses, mules, and donkeys. Via its principal vector CULICOIDES, it can also infect dogs, elephants, camels, cattle, sheep, goats, and, in special circumstances, humans.'),
  'D000357': NtO(MH='African Swine Fever', MS='A sometimes fatal ASFIVIRUS infection of pigs, characterized by fever, cough, diarrhea, hemorrhagic lymph nodes, and edema of the gallbladder. It is transmitted between domestic swine by direct contact, ingestion of infected meat, or fomites, or mechanically by biting flies or soft ticks (genus Ornithodoros).'),
  'D000358': NtO(MH='African Swine Fever Virus', MS='The lone species of the genus Asfivirus. It infects domestic and wild pigs, warthogs, and bushpigs. Disease is endemic in domestic swine in many African countries and Sardinia. Soft ticks of the genus Ornithodoros are also infected and act as vectors.'),
  'D000359': NtO(MH='Aftercare', MS='The care and treatment of a convalescent patient, especially that of a patient after surgery.'),
  'D000360': NtO(MH='Afterimage', MS='Continuation of visual impression after cessation of stimuli causing the original image.'),
  'D000361': NtO(MH='Agammaglobulinemia', MS='An immunologic deficiency state characterized by an extremely low level of generally all classes of gamma-globulin in the blood.'),
  'D000362': NtO(MH='Agar', MS='A complex sulfated polymer of galactose units, extracted from Gelidium cartilagineum, Gracilaria confervoides, and related red algae. It is used as a gel in the preparation of solid culture media for microorganisms, as a bulk laxative, in making emulsions, and as a supporting medium for immunodiffusion and immunoelectrophoresis.'),
  'D000363': NtO(MH='Agaricales', MS='An extensive order of basidiomycetous fungi whose fruiting bodies are commonly called mushrooms.'),
  'D000364': NtO(MH='Agaricus', MS='A basidiomycetous fungal genus of the family Agaricaceae, order Agaricales, which includes the field mushroom (A. campestris) and the commercial mushroom (A. bisporus).'),
  'D000365': NtO(MH='Age Determination by Skeleton', MS='Establishment of the age of an individual by examination of their skeletal structure.'),
  'D000366': NtO(MH='Age Determination by Teeth', MS='A means of identifying the age of an animal or human through tooth examination.'),
  'D000367': NtO(MH='Age Factors', MS='Age as a constituent element or influence contributing to the production of a result. It may be applicable to the cause or the effect of a circumstance. It is used with human or animal concepts but should be differentiated from AGING, a physiological process, and TIME FACTORS which refers only to the passage of time.'),
  'D000368': NtO(MH='Aged', MS='A person 65 through 79 years of age. For a person older than 79 years, AGED, 80 AND OVER is available.'),
  'D000369': NtO(MH='Aged, 80 and over', MS='A person 80 years of age and older.'),
  'D000370': NtO(MH='Ageusia', MS='Complete or severe loss of the subjective sense of taste, frequently accompanied by OLFACTION DISORDERS.'),
  'D000371': NtO(MH='Agglutination', MS='The clumping together of suspended material resulting from the action of AGGLUTININS.'),
  'D000372': NtO(MH='Agglutination Tests', MS='Tests that are dependent on the clumping of cells, microorganisms, or particles when mixed with specific antiserum. (From Stedman, 26th ed)'),
  'D000373': NtO(MH='Agglutinins', MS='A substance that makes particles (such as bacteria or cells) stick together to form a clump or a mass.'),
  'D000374': NtO(MH='Aggression', MS='Behavior which may be manifested by destructive and attacking action which is verbal or physical, by covert attitudes of hostility or by obstructionism.'),
  'D000375': NtO(MH='Aging', MS='The gradual irreversible changes in structure and function of an organism that occur as a result of the passage of time.'),
  'D000376': NtO(MH='Agmatine', MS='Decarboxylated arginine, isolated from several plant and animal sources, e.g., pollen, ergot, herring sperm, octopus muscle.'),
  'D000377': NtO(MH='Agnosia', MS='Loss of the ability to comprehend the meaning or recognize the importance of various forms of stimulation that cannot be attributed to impairment of a primary sensory modality. Tactile agnosia is characterized by an inability to perceive the shape and nature of an object by touch alone, despite unimpaired sensation to light touch, position, and other primary sensory modalities.'),
  'D000378': NtO(MH='Agonistic Behavior', MS='Any behavior associated with conflict between two individuals.'),
  'D000379': NtO(MH='Agoraphobia', MS='Obsessive, persistent, intense fear of open places.'),
  'D000380': NtO(MH='Agranulocytosis', MS='A decrease in the number of GRANULOCYTES; (BASOPHILS; EOSINOPHILS; and NEUTROPHILS).'),
  'D000381': NtO(MH='Agraphia', MS='Loss or impairment of the ability to write (letters, syllables, words, or phrases) due to an injury to a specific cerebral area or occasionally due to emotional factors. This condition rarely occurs in isolation, and often accompanies APHASIA. (From Adams et al., Principles of Neurology, 6th ed, p485; APA, Thesaurus of Psychological Index Terms, 1994)'),
  'D000382': NtO(MH="Agricultural Workers' Diseases", MS='Diseases in persons engaged in cultivating and tilling soil, growing plants, harvesting crops, raising livestock, or otherwise engaged in husbandry and farming. The diseases are not restricted to farmers in the sense of those who perform conventional farm chores: the heading applies also to those engaged in the individual activities named above, as in those only gathering harvest or in those only dusting crops.'),
  'D000383': NtO(MH='Agriculture', MS='The science, art or practice of cultivating soil, producing crops, and raising livestock.'),
  'D000385': NtO(MH='Aid to Families with Dependent Children', MS='Financial assistance provided by the government to indigent families with dependent children who meet certain requirements as defined by the Social Security Act, Title IV, in the U.S.'),
  'D000386': NtO(MH='AIDS-Related Complex', MS="A prodromal phase of infection with the human immunodeficiency virus (HIV). Laboratory criteria separating AIDS-related complex (ARC) from AIDS include elevated or hyperactive B-cell humoral immune responses, compared to depressed or normal antibody reactivity in AIDS; follicular or mixed hyperplasia in ARC lymph nodes, leading to lymphocyte degeneration and depletion more typical of AIDS; evolving succession of histopathological lesions such as localization of Kaposi's sarcoma, signaling the transition to the full-blown AIDS."),
  'D000387': NtO(MH='Ainhum', MS='Spontaneous autoamputation of the fourth or fifth toe.'),
  'D000388': NtO(MH='Air', MS="The mixture of gases present in the earth's atmosphere consisting of oxygen, nitrogen, carbon dioxide, and small amounts of other gases."),
  'D000389': NtO(MH='Air Conditioning', MS='The maintenance of certain aspects of the environment within a defined space to facilitate the function of that space; aspects controlled include air temperature and motion, radiant heat level, moisture, and concentration of pollutants such as dust, microorganisms, and gases. (McGraw-Hill Dictionary of Scientific and Technical Terms, 4th ed)'),
  'D000390': NtO(MH='Air Ionization', MS='The dissociation of molecules in the air into positive and negative ions under the influence of an electric field.'),
  'D000391': NtO(MH='Air Microbiology', MS='The presence of bacteria, viruses, and fungi in the air. This term is not restricted to pathogenic organisms.'),
  'D000392': NtO(MH='Air Movements', MS='The motion of air currents.'),
  'D000393': NtO(MH='Air Pollutants', MS='Any substance in the air which could, if present in high enough concentration, harm humans, animals, vegetation or materials. Substances include GASES; PARTICULATE MATTER; and volatile ORGANIC CHEMICALS.'),
  'D000395': NtO(MH='Air Pollutants, Occupational', MS='Toxic air-borne matter related to work performed They are usually produced by the specific nature of the occupation.'),
  'D000396': NtO(MH='Air Pollutants, Radioactive', MS='Pollutants present in air which exhibit radioactivity.'),
  'D000397': NtO(MH='Air Pollution', MS='The presence of contaminants or pollutant substances in the air (AIR POLLUTANTS) that interfere with human health or welfare, or produce other harmful environmental effects. The substances may include GASES; PARTICULATE MATTER; or volatile ORGANIC CHEMICALS.'),
  'D000398': NtO(MH='Air Pollution, Radioactive', MS='Contamination of air with radioactive substances.'),
  'D000399': NtO(MH='Air Pressure', MS='The force per unit area that the air exerts on any surface in contact with it. Primarily used for articles pertaining to air pressure within a closed environment.'),
  'D000400': NtO(MH='Air Sacs', MS='Thin-walled sacs or spaces which function as a part of the respiratory system in birds, fishes, insects, and mammals.'),
  'D000401': NtO(MH='Aircraft', MS='A weight-carrying structure for navigation of the air that is supported either by its own buoyancy or by the dynamic action of the air against its surfaces. (Webster, 1973)'),
  'D000402': NtO(MH='Airway Obstruction', MS='Any hindrance to the passage of air into and out of the lungs.'),
  'D000403': NtO(MH='Airway Resistance', MS='Physiologically, the opposition to flow of air caused by the forces of friction. As a part of pulmonary function testing, it is the ratio of driving pressure to the rate of air flow.'),
  'D000404': NtO(MH='Ajmaline', MS='An alkaloid found in the root of RAUWOLFIA SERPENTINA, among other plant sources. It is a class Ia antiarrhythmic agent that apparently acts by changing the shape and threshold of cardiac action potentials.'),
  'D000405': NtO(MH='Akinetic Mutism', MS='A syndrome characterized by a silent and inert state without voluntary motor activity despite preserved sensorimotor pathways and vigilance. Bilateral FRONTAL LOBE dysfunction involving the anterior cingulate gyrus and related brain injuries are associated with this condition. This may result in impaired abilities to communicate and initiate motor activities. (From Adams et al., Principles of Neurology, 6th ed, p348; Fortschr Neurol Psychiatr 1995 Feb;63(2):59-67)'),
  'D000406': NtO(MH='AKR murine leukemia virus', MS='A strain of Murine leukemia virus (LEUKEMIA VIRUS, MURINE) isolated from spontaneous leukemia in AKR strain mice.'),
  'D000407': NtO(MH='Alabama', MS='A state in the southeastern region of the United States. The capital is Montgomery.'),
  'D000408': NtO(MH='Alamethicin', MS='A cyclic nonadecapeptide antibiotic that can act as an ionophore and is produced by strains of Trichoderma viride. (From Singleton & Sainsbury, Dictionary of Microbiology and Molecular Biology, 2d ed)'),
  'D000409': NtO(MH='Alanine', MS='A non-essential amino acid that occurs in high levels in its free state in plasma. It is produced from pyruvate by transamination. It is involved in sugar and acid metabolism, increases IMMUNITY, and provides energy for muscle tissue, BRAIN, and the CENTRAL NERVOUS SYSTEM.'),
  'D000410': NtO(MH='Alanine Transaminase', MS='An enzyme that catalyzes the conversion of L-alanine and 2-oxoglutarate to pyruvate and L-glutamate. (From Enzyme Nomenclature, 1992) EC 2.6.1.2.'),
  'D000411': NtO(MH='Alanine Racemase', MS='A pyridoxal-phosphate protein that reversibly catalyzes the conversion of L-alanine to D-alanine. EC 5.1.1.1.'),
  'D000412': NtO(MH='Alanine-tRNA Ligase', MS='An enzyme that activates alanine with its specific transfer RNA. EC 6.1.1.7.'),
  'D000413': NtO(MH='Alaska', MS='State of the UNITED STATES OF AMERICA bounded on the east by Canada and on the north, west, and south by the Pacific Ocean and the Bering Sea.'),
  'D000415': NtO(MH='Albania', MS='A country in Europe, on the Adriatic Sea. The capital is Tirana'),
  'D000416': NtO(MH='Alberta', MS="A province of western Canada, lying between the provinces of British Columbia and Saskatchewan. Its capital is Edmonton. It was named in honor of Princess Louise Caroline Alberta, the fourth daughter of Queen Victoria. (From Webster's New Geographical Dictionary, 1988, p26 & Room, Brewer's Dictionary of Names, 1992, p12)"),
  'D000417': NtO(MH='Albinism', MS='General term for a number of inherited defects of amino acid metabolism in which there is a deficiency or absence of pigment in the eyes, skin, or hair.'),
  'D000418': NtO(MH='Albumins', MS='Water-soluble proteins found in egg whites, blood, lymph, and other tissues and fluids. They coagulate upon heating.'),
  'D000419': NtO(MH='Albuminuria', MS='The presence of albumin in the urine, an indicator of KIDNEY DISEASES.'),
  'D000420': NtO(MH='Albuterol', MS='A short-acting beta-2 adrenergic agonist that is primarily used as a bronchodilator agent to treat ASTHMA. Albuterol is prepared as a racemic mixture of R(-) and S(+) stereoisomers. The stereospecific preparation of R(-) isomer of albuterol is referred to as levalbuterol.'),
  'D000421': NtO(MH='Alcaligenes', MS='A genus of gram-negative, aerobic, motile bacteria that occur in water and soil. Some are common inhabitants of the intestinal tract of vertebrates. These bacteria occasionally cause opportunistic infections in humans.'),
  'D000422': NtO(MH='Alchemy', MS='Form of chemistry concerned with discovering methods for transmuting base metals into gold and with finding an elixir for eternal youth.'),
  'D000423': NtO(MH='Alcian Blue', MS='A copper-containing dye used as a gelling agent for lubricants, for staining of bacteria and for the dyeing of histiocytes and fibroblasts in vivo.'),
  'D000425': NtO(MH='Alcohol Amnestic Disorder', MS='A mental disorder associated with chronic ethanol abuse (ALCOHOLISM) and nutritional deficiencies characterized by short term memory loss, confabulations, and disturbances of attention. (Adams et al., Principles of Neurology, 6th ed, p1139)'),
  'D000426': NtO(MH='Alcohol Dehydrogenase', MS='A zinc-containing enzyme which oxidizes primary and secondary alcohols or hemiacetals in the presence of NAD. In alcoholic fermentation, it catalyzes the final step of reducing an aldehyde to an alcohol in the presence of NADH and hydrogen.'),
  'D000427': NtO(MH='Alcohol Deterrents', MS='Substances interfering with the metabolism of ethyl alcohol, causing unpleasant side effects thought to discourage the drinking of alcoholic beverages. Alcohol deterrents are used in the treatment of alcoholism.'),
  'D000428': NtO(MH='Alcohol Drinking', MS='Behaviors associated with the ingesting of ALCOHOLIC BEVERAGES, including social drinking.'),
  'D000429': NtO(MH='Alcohol Oxidoreductases', MS='A subclass of enzymes which includes all dehydrogenases acting on primary and secondary alcohols as well as hemiacetals. They are further classified according to the acceptor which can be NAD+ or NADP+ (subclass 1.1.1), cytochrome (1.1.2), oxygen (1.1.3), quinone (1.1.5), or another acceptor (1.1.99).'),
  'D000430': NtO(MH='Alcohol Withdrawal Delirium', MS='An acute organic mental disorder induced by cessation or reduction in chronic alcohol consumption. Clinical characteristics include CONFUSION; DELUSIONS; vivid HALLUCINATIONS; TREMOR; agitation; insomnia; and signs of autonomic hyperactivity (e.g., elevated blood pressure and heart rate, dilated pupils, and diaphoresis). This condition may occasionally be fatal. It was formerly called delirium tremens. (From Adams et al., Principles of Neurology, 6th ed, p1175)'),
  'D000431': NtO(MH='Ethanol', MS='A clear, colorless liquid rapidly absorbed from the gastrointestinal tract and distributed throughout the body. It has bactericidal activity and is used often as a topical disinfectant. It is widely used as a solvent and preservative in pharmaceutical preparations as well as serving as the primary ingredient in ALCOHOLIC BEVERAGES.'),
  'D000432': NtO(MH='Methanol', MS='A colorless, flammable liquid used in the manufacture of FORMALDEHYDE and ACETIC ACID, in chemical synthesis, antifreeze, and as a solvent. Ingestion of methanol is toxic and may cause blindness.'),
  'D000433': NtO(MH='1-Propanol', MS='A colorless liquid made by oxidation of aliphatic hydrocarbons that is used as a solvent and chemical intermediate.'),
  'D000434': NtO(MH='Alcoholic Beverages', MS='Drinkable liquids containing ETHANOL.'),
  'D000435': NtO(MH='Alcoholic Intoxication', MS='An acute brain syndrome which results from the excessive ingestion of ETHANOL or ALCOHOLIC BEVERAGES.'),
  'D000436': NtO(MH='Alcoholics Anonymous', MS='An organization of self-proclaimed alcoholics who meet frequently to reinforce their practice of abstinence.'),
  'D000437': NtO(MH='Alcoholism', MS='A primary, chronic disease with genetic, psychosocial, and environmental factors influencing its development and manifestations. The disease is often progressive and fatal. It is characterized by impaired control over drinking, preoccupation with the drug alcohol, use of alcohol despite adverse consequences, and distortions in thinking, most notably denial. Each of these symptoms may be continuous or periodic. (Morse & Flavin for the Joint Commission of the National Council on Alcoholism and Drug Dependence and the American Society of Addiction Medicine to Study the Definition and Criteria for the Diagnosis of Alcoholism: in JAMA 1992;268:1012-4)'),
  'D000438': NtO(MH='Alcohols', MS="Alkyl compounds containing a hydroxyl group. They are classified according to relation of the carbon atom: primary alcohols, R-CH2OH; secondary alcohols, R2-CHOH; tertiary alcohols, R3-COH. (From Grant & Hackh's Chemical Dictionary, 5th ed)"),
  'D000439': NtO(MH='Pentanols', MS='Isomeric forms and derivatives of pentanol (C5H11OH).'),
  'D000440': NtO(MH='Butanols', MS='Isomeric forms and derivatives of butanol (C4H9OH).'),
  'D000441': NtO(MH='Hexanols', MS='Isomeric forms and derivatives of hexanol (C6H11OH).'),
  'D000442': NtO(MH='Octanols', MS='Isomeric forms and derivatives of octanol (C8H17OH).'),
  'D000443': NtO(MH='Alcuronium', MS='A non-depolarizing skeletal muscle relaxant similar to TUBOCURARINE. It is used as an anesthesia adjuvant.'),
  'D000444': NtO(MH='Aldehyde Dehydrogenase', MS='An enzyme that oxidizes an aldehyde in the presence of NAD+ and water to an acid and NADH. This enzyme was formerly classified as EC 1.1.1.70.'),
  'D000445': NtO(MH='Aldehyde Oxidoreductases', MS='Oxidoreductases that are specific for ALDEHYDES.'),
  'D000446': NtO(MH='Aldehyde-Lyases', MS='Enzymes that catalyze a reverse aldol condensation. A molecule containing a hydroxyl group and a carbonyl group is cleaved at a C-C bond to produce two smaller molecules (ALDEHYDES or KETONES). EC 4.1.2.'),
  'D000447': NtO(MH='Aldehydes', MS='Organic compounds containing a carbonyl group in the form -CHO.'),
  'D000448': NtO(MH='Aldicarb', MS='Carbamate derivative used as an insecticide, acaricide, and nematocide.'),
  'D000449': NtO(MH='Aldehyde Reductase', MS='An enzyme that catalyzes reversibly the oxidation of an aldose to an alditol. It possesses broad specificity for many aldoses. EC 1.1.1.21.'),
  'D000450': NtO(MH='Aldosterone', MS='A hormone secreted by the ADRENAL CORTEX that regulates electrolyte and water balance by increasing the renal retention of sodium and the excretion of potassium.'),
  'D000451': NtO(MH='Mineralocorticoid Receptor Antagonists', MS='Drugs that bind to and block the activation of MINERALOCORTICOID RECEPTORS by MINERALOCORTICOIDS such as ALDOSTERONE.'),
  'D000452': NtO(MH='Aldrin', MS='A highly poisonous substance that was formerly used as an insecticide. The manufacture and use has been discontinued in the U.S. (From Merck Index, 11th ed)'),
  'D000453': NtO(MH='Aleutian Mink Disease', MS='A slow progressive disease of mink caused by the ALEUTIAN MINK DISEASE VIRUS. It is characterized by poor reproduction, weight loss, autoimmunity, hypergammaglobulinemia, increased susceptibility to bacterial infections, and death from renal failure. The disease occurs in all color types, but mink which are homozygous recessive for the Aleutian gene for light coat color are particularly susceptible.'),
  'D000454': NtO(MH='Aleutian Mink Disease Virus', MS='A species of PARVOVIRUS that causes a disease in mink, mainly those homozygous for the recessive Aleutian gene which determines a desirable coat color.'),
  'D000455': NtO(MH='Medicago sativa', MS='A plant species of the family FABACEAE widely cultivated for ANIMAL FEED.'),
  'D000458': NtO(MH='Cyanobacteria', MS='A phylum of oxygenic photosynthetic bacteria comprised of unicellular to multicellular bacteria possessing CHLOROPHYLL a and carrying out oxygenic PHOTOSYNTHESIS. Cyanobacteria are the only known organisms capable of fixing both CARBON DIOXIDE (in the presence of light) and NITROGEN. Cell morphology can include nitrogen-fixing heterocysts and/or resting cells called akinetes. Formerly called blue-green algae, cyanobacteria were traditionally treated as ALGAE.'),
  'D000459': NtO(MH='Phaeophyta', MS='A division of predominantly marine EUKARYOTA, commonly known as brown algae, having CHROMATOPHORES containing carotenoid PIGMENTS, BIOLOGICAL. ALGINATES and phlorotannins occur widely in all major orders. They are considered the most highly evolved algae because of their well-developed multicellular organization and structural complexity.'),
  'D000460': NtO(MH='Chlorophyta', MS='A phylum of photosynthetic EUKARYOTA bearing double membrane-bound plastids containing chlorophyll a and b. They comprise the classical green algae, and represent over 7000 species that live in a variety of primarily aquatic habitats. Only about ten percent are marine species, most live in freshwater.'),
  'D000461': NtO(MH='Rhodophyta', MS='Plants of the division Rhodophyta, commonly known as red algae, in which the red pigment (PHYCOERYTHRIN) predominates. However, if this pigment is destroyed, the algae can appear purple, brown, green, or yellow. Two important substances found in the cell walls of red algae are AGAR and CARRAGEENAN. Some rhodophyta are notable SEAWEED (macroalgae).'),
  'D000462': NtO(MH='Algeria', MS='A country in northern Africa bordering the Mediterranean Sea, between MOROCCO and TUNISIA. Its capital is Algiers.'),
  'D000463': NtO(MH='Algestone Acetophenide', MS='A progesterone that has been used in ESTRUS SYNCHRONIZATION and has been evaluated as an injectable contraceptive in combination with estradiol enanthate. It is also applied topically as an anti-inflammatory and in the treatment of ACNE.'),
  'D000464': NtO(MH='Alginates', MS='Salts and esters of ALGINIC ACID that are used as HYDROGELS; DENTAL IMPRESSION MATERIALS, and as absorbent materials for surgical dressings (BANDAGES, HYDROCOLLOID). They are also used to manufacture MICROSPHERES and NANOPARTICLES for DIAGNOSTIC REAGENT KITS and DRUG DELIVERY SYSTEMS.'),
  'D000465': NtO(MH='Algorithms', MS='A procedure consisting of a sequence of algebraic formulas and/or logical steps to calculate or determine a given task.'),
  'D000466': NtO(MH='Alkadienes', MS='Acyclic branched or unbranched hydrocarbons having two carbon-carbon double bonds.'),
  'D000468': NtO(MH='Alkalies', MS="Usually a hydroxide of lithium, sodium, potassium, rubidium or cesium, but also the carbonates of these metals, ammonia, and the amines. (Grant & Hackh's Chemical Dictionary, 5th ed)"),
  'D000469': NtO(MH='Alkaline Phosphatase', MS='An enzyme that catalyzes the conversion of an orthophosphoric monoester and water to an alcohol and orthophosphate. EC 3.1.3.1.'),
  'D000470': NtO(MH='Alkaloids', MS="Organic nitrogenous bases. Many alkaloids of medical importance occur in the animal and vegetable kingdoms, and some have been synthesized. (Grant & Hackh's Chemical Dictionary, 5th ed)"),
  'D000471': NtO(MH='Alkalosis', MS='A pathological condition that removes acid or adds base to the body fluids.'),
  'D000472': NtO(MH='Alkalosis, Respiratory', MS='A state due to excess loss of carbon dioxide from the body. (Dorland, 27th ed)'),
  'D000473': NtO(MH='Alkanes', MS="The generic name for the group of aliphatic hydrocarbons Cn-H2n+2. They are denoted by the suffix -ane. (Grant & Hackh's Chemical Dictionary, 5th ed)"),
  'D000474': NtO(MH='Alkaptonuria', MS='An inborn error of amino acid metabolism resulting from a defect in the enzyme HOMOGENTISATE 1,2-DIOXYGENASE, an enzyme involved in the breakdown of PHENYLALANINE and TYROSINE. It is characterized by accumulation of HOMOGENTISIC ACID in the urine, OCHRONOSIS in various tissues, and ARTHRITIS.'),
  'D000475': NtO(MH='Alkenes', MS="Unsaturated hydrocarbons of the type Cn-H2n, indicated by the suffix -ene. (Grant & Hackh's Chemical Dictionary, 5th ed, p408)"),
  'D000476': NtO(MH='Alkanesulfonates', MS='Organic esters or salts of sulfonic acid derivatives containing an aliphatic hydrocarbon radical.'),
  'D000477': NtO(MH='Alkylating Agents', MS='Highly reactive chemicals that introduce alkyl radicals into biologically active molecules and thereby prevent their proper functioning. Many are used as antineoplastic agents, but most are very toxic, with carcinogenic, mutagenic, teratogenic, and immunosuppressant actions. They have also been used as components in poison gases.'),
  'D000478': NtO(MH='Alkylation', MS='The covalent bonding of an alkyl group to an organic compound. It can occur by a simple addition reaction or by substitution of another functional group.'),
  'D000479': NtO(MH='Alkylmercury Compounds', MS='Organic mercury compounds in which the mercury is attached to an alkyl group.'),
  'D000480': NtO(MH='Alkynes', MS='Hydrocarbons with at least one triple bond in the linear portion, of the general formula Cn-H2n-2.'),
  'D000481': NtO(MH='Allantoin', MS='A urea hydantoin that is found in URINE and PLANTS and is used in dermatological preparations.'),
  'D000482': NtO(MH='Allantois', MS='An extra-embryonic membranous sac derived from the YOLK SAC of REPTILES; BIRDS; and MAMMALS. It lies between two other extra-embryonic membranes, the AMNION and the CHORION. The allantois serves to store urinary wastes and mediate exchange of gas and nutrients for the developing embryo.'),
  'D000483': NtO(MH='Alleles', MS='Variant forms of the same gene, occupying the same locus on homologous CHROMOSOMES, and governing the variants in production of the same gene product.'),
  'D000485': NtO(MH='Allergens', MS='Antigen-type substances that produce immediate hypersensitivity (HYPERSENSITIVITY, IMMEDIATE).'),
  'D000486': NtO(MH='Allergy and Immunology', MS='A medical specialty concerned with the hypersensitivity of the individual to foreign substances and protection from the resultant infection or disorder.'),
  'D000487': NtO(MH='Allethrins', MS='Synthetic analogs of the naturally occurring insecticides cinerin, jasmolin, and pyrethrin. (From Merck Index, 11th ed)'),
  'D000488': NtO(MH='Allied Health Personnel', MS='Health care workers specially trained and licensed to assist and support the work of health professionals. Often used synonymously with paramedical personnel, the term generally refers to all health care workers who perform tasks which must otherwise be performed by a physician or other health professional.'),
  'D000489': NtO(MH='Alligators and Crocodiles', MS='Large, long-tailed reptiles, including caimans, of the order Loricata.'),
  'D000490': NtO(MH='Allium', MS='A genus of the plant family Amaryllidaceae. Many produce pungent, often bacteriostatic and physiologically active compounds and are used as VEGETABLES; CONDIMENTS; and medicament, the latter in traditional medicine.'),
  'D000492': NtO(MH='Allophanate Hydrolase', MS='An enzyme that catalyzes the hydrolysis of allophanic acid to two molecules of ammonia plus two molecules of "active carbon dioxide". EC 3.5.1.54.'),
  'D000493': NtO(MH='Allopurinol', MS='A XANTHINE OXIDASE inhibitor that decreases URIC ACID production. It also acts as an antimetabolite on some simpler organisms.'),
  'D000494': NtO(MH='Allosteric Regulation', MS='The modification of the reactivity of ENZYMES by the binding of effectors to sites (ALLOSTERIC SITES) on the enzymes other than the substrate BINDING SITES.'),
  'D000495': NtO(MH='Allosteric Site', MS='A site on an enzyme which upon binding of a modulator, causes the enzyme to undergo a conformational change that may alter its catalytic or binding properties.'),
  'D000496': NtO(MH='Alloxan', MS='Acidic compound formed by oxidation of URIC ACID. It is isolated as an efflorescent crystalline hydrate.'),
  'D000497': NtO(MH='Alloys', MS='A mixture of metallic elements or compounds with other metallic or metalloid elements in varying proportions.'),
  'D000498': NtO(MH='Allyl Compounds', MS='Alkenes with the general formula H2C=CH-CH2-R.'),
  'D000499': NtO(MH='Allylamine', MS='Possesses an unusual and selective cytotoxicity for VASCULAR SMOOTH MUSCLE cells in dogs and rats. Useful for experiments dealing with arterial injury, myocardial fibrosis or cardiac decompensation.'),
  'D000500': NtO(MH='Allylestrenol', MS='A synthetic steroid with progestational activity.'),
  'D000501': NtO(MH='Allylglycine', MS='An inhibitor of glutamate decarboxylase and an antagonist of GAMMA-AMINOBUTYRIC ACID. It is used to induce convulsions in experimental animals.'),
  'D000502': NtO(MH='Allylisopropylacetamide', MS='An allylic compound that acts as a suicide inactivator of CYTOCHROME P450 by covalently binding to its heme moiety or surrounding protein.'),
  'D000503': NtO(MH='Almanacs as Topic', MS='Works on publications, usually annual, containing a calendar for the coming year, the times of such events and phenomena as anniversaries, sunrises, sunsets, phases of the moon, tides, meteorological, and other statistical information and related topics or useful and interesting facts relating to countries of the world, sports, entertainment, population groups, etc.'),
  'D000504': NtO(MH='Aloe', MS='A plant genus of the family Xanthorrhoeaceae which is used medicinally. It contains anthraquinone glycosides such as aloin-emodin or aloe-emodin (EMODIN).'),
  'D000505': NtO(MH='Alopecia', MS='Absence of hair from areas where it is normally present.'),
  'D000506': NtO(MH='Alopecia Areata', MS='Loss of scalp and body hair involving microscopically inflammatory patchy areas.'),
  'D000507': NtO(MH='Mucinosis, Follicular', MS='A disease of the pilosebaceous unit, presenting clinically as grouped follicular papules or plaques with associated hair loss. It is caused by mucinous infiltration of tissues, and usually involving the scalp, face, and neck. It may be primary (idiopathic) or secondary to mycosis fungoides or reticulosis.'),
  'D000508': NtO(MH='Alouatta', MS='A genus of the subfamily ALOUATTINAE, family ATELIDAE, inhabiting the forests of Central and South America. Howlers travel in groups and define their territories by howling accompanied by vigorously shaking and breaking branches.'),
  'D000509': NtO(MH='alpha-Fetoproteins', MS='The first alpha-globulins to appear in mammalian sera during FETAL DEVELOPMENT and the dominant serum proteins in early embryonic life.'),
  'D000510': NtO(MH='Alpha-Globulins', MS='Serum proteins that have the most rapid migration during ELECTROPHORESIS. This subgroup of globulins is divided into faster and slower alpha(1)- and alpha(2)-globulins.'),
  'D000511': NtO(MH='alpha-Macroglobulins', MS='Glycoproteins with a molecular weight of approximately 620,000 to 680,000. Precipitation by electrophoresis is in the alpha region. They include alpha 1-macroglobulins and alpha 2-macroglobulins. These proteins exhibit trypsin-, chymotrypsin-, thrombin-, and plasmin-binding activity and function as hormonal transporters.'),
  'D000512': NtO(MH='Alpha Particles', MS='Positively charged particles composed of two protons and two NEUTRONS, i.e. equivalent to HELIUM nuclei, which are emitted during disintegration of heavy ISOTOPES. Alpha rays have very strong ionizing power, but weak penetrability.'),
  'D000513': NtO(MH='Alpha Rhythm', MS='Brain waves characterized by a relatively high voltage or amplitude and a frequency of 8-13 Hz. They constitute the majority of waves recorded by EEG registering the activity of the parietal and occipital lobes when the individual is awake, but relaxed with the eyes closed.'),
  'D000514': NtO(MH='alpha 1-Antichymotrypsin', MS='Glycoprotein found in alpha(1)-globulin region in human serum. It inhibits chymotrypsin-like proteinases in vivo and has cytotoxic killer-cell activity in vitro. The protein also has a role as an acute-phase protein and is active in the control of immunologic and inflammatory processes, and as a tumor marker. It is a member of the serpin superfamily.'),
  'D000515': NtO(MH='alpha 1-Antitrypsin', MS='Plasma glycoprotein member of the serpin superfamily which inhibits TRYPSIN; NEUTROPHIL ELASTASE; and other PROTEOLYTIC ENZYMES.'),
  'D000516': NtO(MH='alpha-Amylases', MS='Enzymes that catalyze the endohydrolysis of 1,4-alpha-glycosidic linkages in STARCH; GLYCOGEN; and related POLYSACCHARIDES and OLIGOSACCHARIDES containing 3 or more 1,4-alpha-linked D-glucose units.'),
  'D000517': NtO(MH='alpha-Chlorohydrin', MS='A chlorinated PROPANEDIOL with antifertility activity in males used as a chemosterilant in rodents.'),
  'D000518': NtO(MH='Eflornithine', MS='An inhibitor of ORNITHINE DECARBOXYLASE, the rate limiting enzyme of the polyamine biosynthetic pathway.'),
  'D000519': NtO(MH='alpha-Galactosidase', MS='An enzyme that catalyzes the hydrolysis of terminal, non-reducing alpha-D-galactose residues in alpha-galactosides including galactose oligosaccharides, galactomannans, and galactolipids.'),
  'D000520': NtO(MH='alpha-Glucosidases', MS='Enzymes that catalyze the exohydrolysis of 1,4-alpha-glucosidic linkages with release of alpha-glucose. Deficiency of alpha-1,4-glucosidase may cause GLYCOGEN STORAGE DISEASE TYPE II.'),
  'D000521': NtO(MH='alpha-MSH', MS='A 13-amino acid peptide derived from proteolytic cleavage of ADRENOCORTICOTROPIC HORMONE, the N-terminal segment of ACTH. ACTH (1-13) is amidated at the C-terminal to form ACTH (1-13)NH2 which in turn is acetylated to form alpha-MSH in the secretory granules. Alpha-MSH stimulates the synthesis and distribution of MELANIN in MELANOCYTES in mammals and MELANOPHORES in lower vertebrates.'),
  'D000522': NtO(MH='Alphaprodine', MS='An opioid analgesic chemically related to and with an action resembling that of MEPERIDINE, but more rapid in onset and of shorter duration. It has been used in obstetrics, as pre-operative medication, for minor surgical procedures, and for dental procedures. (From Martindale, The Extra Pharmacopoeia, 30th ed, p1067)'),
  'D000523': NtO(MH='Algestone', MS='A synthetic progestational dihydroxy derivative of PROGESTERONE. Its acetonide possesses anti-inflammatory properties.'),
  'D000524': NtO(MH='Alphavirus', MS='A genus of TOGAVIRIDAE, also known as Group A arboviruses, serologically related to each other but not to other Togaviridae. The viruses are transmitted by mosquitoes. The type species is the SINDBIS VIRUS.'),
  'D000525': NtO(MH='Alprazolam', MS='A triazolobenzodiazepine compound with antianxiety and sedative-hypnotic actions, that is efficacious in the treatment of PANIC DISORDERS, with or without AGORAPHOBIA, and in generalized ANXIETY DISORDERS. (From AMA Drug Evaluations Annual, 1994, p238)'),
  'D000526': NtO(MH='Alprenolol', MS='One of the ADRENERGIC BETA-ANTAGONISTS used as an antihypertensive, anti-anginal, and anti-arrhythmic agent.'),
  'D000527': NtO(MH='Alprostadil', MS='A potent vasodilator agent that increases peripheral blood flow.'),
  'D000528': NtO(MH='Alternaria', MS='A mitosporic Loculoascomycetes fungal genus including several plant pathogens and at least one species which produces a highly phytotoxic antibiotic. Its teleomorph is Lewia.'),
  'D000529': NtO(MH='Complementary Therapies', MS='Therapeutic practices which are not currently considered an integral part of conventional allopathic medical practice. They may lack biomedical explanations but as they become better researched some (PHYSICAL THERAPY MODALITIES; DIET; ACUPUNCTURE) become widely accepted whereas others (humors, radium therapy) quietly fade away, yet are important historical footnotes. Therapies are termed as Complementary when used in addition to conventional treatments and as Alternative when used instead of conventional treatment.'),
  'D000530': NtO(MH='Alfaxalone Alfadolone Mixture', MS='A 3:1 mixture of alfaxalone with alfadolone acetate that previously had been used as a general anesthetic. It is no longer actively marketed. (From Martindale, The Extra Pharmacopoeia, 30th ed, p1445)'),
  'D000531': NtO(MH='Altitude', MS='A vertical distance measured from a known level on the surface of a planet or other celestial body.'),
  'D000532': NtO(MH='Altitude Sickness', MS='Multiple symptoms associated with reduced oxygen at high ALTITUDE.'),
  'D000533': NtO(MH='Altruism', MS='Consideration and concern for others, as opposed to self-love or egoism, which can be a motivating influence.'),
  'D000534': NtO(MH='Alum Compounds', MS='Aluminum metal sulfate compounds used medically as astringents and for many industrial purposes. They are used in veterinary medicine for the treatment of ulcerative stomatitis, leukorrhea, conjunctivitis, pharyngitis, metritis, and minor wounds.'),
  'D000535': NtO(MH='Aluminum', MS='A metallic element that has the atomic number 13, atomic symbol Al, and atomic weight 26.98.'),
  'D000536': NtO(MH='Aluminum Hydroxide', MS='A compound with many biomedical applications: as a gastric antacid, an antiperspirant, in dentifrices, as an emulsifier, as an adjuvant in bacterins and vaccines, in water purification, etc.'),
  'D000537': NtO(MH='Aluminum Oxide', MS='An oxide of aluminum, occurring in nature as various minerals such as bauxite, corundum, etc. It is used as an adsorbent, desiccating agent, and catalyst, and in the manufacture of dental cements and refractories.'),
  'D000538': NtO(MH='Aluminum Silicates', MS="Any of the numerous types of clay which contain varying proportions of Al2O3 and SiO2. They are made synthetically by heating aluminum fluoride at 1000-2000 degrees C with silica and water vapor. (From Hawley's Condensed Chemical Dictionary, 11th ed)"),
  'D000539': NtO(MH='Alveolar Process', MS='The thickest and spongiest part of the maxilla and mandible hollowed out into deep cavities for the teeth.'),
  'D000540': NtO(MH='Alveolar Ridge Augmentation', MS='Preprosthetic surgery involving rib, cartilage, or iliac crest bone grafts, usually autologous, or synthetic implants for rebuilding the alveolar ridge.'),
  'D000541': NtO(MH='Alveolectomy', MS='Subtotal or complete excision of the alveolar process of the maxilla or mandible. (Dorland, 28th ed)'),
  'D000542': NtO(MH='Alveolitis, Extrinsic Allergic', MS='A common interstitial lung disease caused by hypersensitivity reactions of PULMONARY ALVEOLI after inhalation of and sensitization to environmental antigens of microbial, animal, or chemical sources. The disease is characterized by lymphocytic alveolitis and granulomatous pneumonitis.'),
  'D000543': NtO(MH='Alveoloplasty', MS='Conservative contouring of the alveolar process, in preparation for immediate or future denture construction. (Dorland, 28th ed)'),
  'D000544': NtO(MH='Alzheimer Disease', MS='A degenerative disease of the BRAIN characterized by the insidious onset of DEMENTIA. Impairment of MEMORY, judgment, attention span, and problem solving skills are followed by severe APRAXIAS and a global loss of cognitive abilities. The condition primarily occurs after age 60, and is marked pathologically by severe cortical atrophy and the triad of SENILE PLAQUES; NEUROFIBRILLARY TANGLES; and NEUROPIL THREADS. (From Adams et al., Principles of Neurology, 6th ed, pp1049-57)'),
  'D000545': NtO(MH='Amanita', MS='A genus of fungi of the family Agaricaceae, order Agaricales; most species are poisonous.'),
  'D000546': NtO(MH='Amanitins', MS='Cyclic peptides extracted from carpophores of various mushroom species. They are potent inhibitors of RNA polymerases in most eukaryotic species, blocking the production of mRNA and protein synthesis. These peptides are important in the study of transcription. Alpha-amanitin is the main toxin from the species Amanitia phalloides, poisonous if ingested by humans or animals.'),
  'D000547': NtO(MH='Amantadine', MS='An antiviral that is used in the prophylactic or symptomatic treatment of influenza A. It is also used as an antiparkinsonian agent, to treat extrapyramidal reactions, and for postherpetic neuralgia. The mechanisms of its effects in movement disorders are not well understood but probably reflect an increase in synthesis and release of dopamine, with perhaps some inhibition of dopamine uptake.'),
  'D000548': NtO(MH='Amaranth Dye', MS='A sulfonic acid-based naphthylazo dye used as a coloring agent for foodstuffs and medicines and as a dye and chemical indicator. It was banned by the FDA in 1976 for use in foods, drugs, and cosmetics. (From Merck Index, 11th ed)'),
  'D000549': NtO(MH='Ambenonium Chloride', MS='A quaternary ammonium compound that is an inhibitor of cholinesterase activity with actions similar to those of NEOSTIGMINE, but of longer duration. Ambenonium is given by mouth in the treatment of myasthenia gravis. (From Martindale, The Extra Pharmacopoeia, 30th ed, p1112)'),
  'D000550': NtO(MH='Amblyopia', MS='A nonspecific term referring to impaired vision. Major subcategories include stimulus deprivation-induced amblyopia and toxic amblyopia. Stimulus deprivation-induced amblyopia is a developmental disorder of the visual cortex. A discrepancy between visual information received by the visual cortex from each eye results in abnormal cortical development. STRABISMUS and REFRACTIVE ERRORS may cause this condition. Toxic amblyopia is a disorder of the OPTIC NERVE which is associated with ALCOHOLISM, tobacco SMOKING, and other toxins and as an adverse effect of the use of some medications.'),
  'D000551': NtO(MH='Ambroxol', MS='A metabolite of BROMHEXINE that stimulates mucociliary action and clears the air passages in the respiratory tract. It is usually administered as the hydrochloride.'),
  'D000552': NtO(MH='Ambulances', MS='A vehicle equipped for transporting patients in need of emergency care.'),
  'D000553': NtO(MH='Ambulatory Care', MS='Health care services provided to patients on an ambulatory basis, rather than by admission to a hospital or other health care facility. The services may be a part of a hospital, augmenting its inpatient services, or may be provided at a free-standing facility.'),
  'D000554': NtO(MH='Ambulatory Care Facilities', MS='Those facilities which administer health services to individuals who do not require hospitalization or institutionalization.'),
  'D000555': NtO(MH='Ambulatory Care Information Systems', MS='Information systems, usually computer-assisted, designed to store, manipulate, and retrieve information for planning, organizing, directing, and controlling administrative activities associated with the provision and utilization of ambulatory care services and facilities.'),
  'D000556': NtO(MH='Ambulatory Surgical Procedures', MS='Surgery performed on an outpatient basis. It may be hospital-based or performed in an office or surgicenter.'),
  'D000557': NtO(MH='Ambystoma', MS='A genus of the Ambystomatidae family. The best known species are the axolotl AMBYSTOMA MEXICANUM and the closely related tiger salamander Ambystoma tigrinum. They may retain gills and remain aquatic without developing all of the adult characteristics. However, under proper changes in the environment they metamorphose.'),
  'D000558': NtO(MH='Ambystoma mexicanum', MS='A salamander found in Mexican mountain lakes and accounting for about 30 percent of the urodeles used in research. The axolotl remains in larval form throughout its life, a phenomenon known as neoteny.'),
  'D000559': NtO(MH='Ambystomatidae', MS='A family of the class Urodela which includes 4 living genera, about 33 species, and occurs only in North America. Adults are usually terrestrial, but the larval forms are aquatic.'),
  'D000560': NtO(MH='Amdinocillin', MS='An amidinopenicillanic acid derivative with broad spectrum antibacterial action.'),
  'D000561': NtO(MH='Amdinocillin Pivoxil', MS='Pivaloyloxymethyl ester of amdinocillin that is well absorbed orally, but broken down to amdinocillin in the intestinal mucosa. It is active against gram-negative organisms and used as for amdinocillin.'),
  'D000562': NtO(MH='Amebiasis', MS='Infection with any of various amebae. It is an asymptomatic carrier state in most individuals, but diseases ranging from chronic, mild diarrhea to fulminant dysentery may occur.'),
  'D000563': NtO(MH='Amebicides', MS='Agents which are destructive to amebae, especially the parasitic species causing AMEBIASIS in man and animal.'),
  'D000564': NtO(MH='Ameloblastoma', MS='An immature epithelial tumor of the JAW originating from the epithelial rests of Malassez or from other epithelial remnants of the ENAMEL from the developmental period. It is a slowly growing tumor, usually benign, but displays a marked propensity for invasive growth.'),
  'D000565': NtO(MH='Ameloblasts', MS="Cylindrical epithelial cells in the innermost layer of the ENAMEL ORGAN. Their functions include contribution to the development of the dentinoenamel junction by the deposition of a layer of the matrix, thus producing the foundation for the prisms (the structural units of the DENTAL ENAMEL), and production of the matrix for the enamel prisms and interprismatic substance. (From Jablonski's Dictionary of Dentistry, 1992)"),
  'D000566': NtO(MH='Amelogenesis', MS='The elaboration of dental enamel by ameloblasts, beginning with its participation in the formation of the dentino-enamel junction to the production of the matrix for the enamel prisms and interprismatic substance. (Jablonski, Dictionary of Dentistry, 1992).'),
  'D000567': NtO(MH='Amelogenesis Imperfecta', MS='A clinically and genetically heterogeneous group of hereditary conditions characterized by malformed DENTAL ENAMEL, usually involving DENTAL ENAMEL HYPOPLASIA and/or TOOTH HYPOMINERALIZATION.'),
  'D000568': NtO(MH='Amenorrhea', MS='Absence of menstruation.'),
  'D000569': NtO(MH='Americas', MS='The general name for NORTH AMERICA; CENTRAL AMERICA; and SOUTH AMERICA unspecified or combined.'),
  'D000570': NtO(MH='American Cancer Society', MS='A voluntary organization concerned with the prevention and treatment of cancer through education and research.'),
  'D000571': NtO(MH='American Dental Association', MS='Professional society representing the field of dentistry.'),
  'D000572': NtO(MH='American Heart Association', MS='A voluntary organization concerned with the prevention and treatment of heart and vascular diseases.'),
  'D000573': NtO(MH='American Hospital Association', MS='A professional society in the United States whose membership is composed of hospitals.'),
  'D000574': NtO(MH='American Medical Association', MS='Professional society representing the field of medicine.'),
  'D000575': NtO(MH="American Nurses' Association", MS='Professional society representing the field of nursing.'),
  'D000576': NtO(MH='Americium', MS='A completely man-made radioactive actinide with atomic symbol Am, and atomic number 95. Its valence can range from +3 to +6. Because of its nonmagnetic ground state, it is an excellent superconductor. It is also used in bone mineral analysis and as a radiation source for radiotherapy.'),
  'D000577': NtO(MH='Amides', MS="Organic compounds containing the -CO-NH2 radical. Amides are derived from acids by replacement of -OH by -NH2 or from ammonia by the replacement of H by an acyl group. (From Grant & Hackh's Chemical Dictionary, 5th ed)"),
  'D000578': NtO(MH='Amidines', MS='Derivatives of oxoacids RnE(=O)OH in which the hydroxy group is replaced by an amino group and the oxo group is replaced by =NR. Amidines include carboxamidines, sulfinamidines and phosphinamidines.'),
  'D000579': NtO(MH='Amidinotransferases', MS='Enzymes of a subclass of TRANSFERASES that catalyze the transfer of an amidino group from donor to acceptor. EC 2.1.4.'),
  'D000580': NtO(MH='Amido Black', MS='A dye used to stain proteins in electrophoretic techniques. It is used interchangeably with its acid form.'),
  'D000581': NtO(MH='Amidohydrolases', MS=None),
  'D000582': NtO(MH='Amidophosphoribosyltransferase', MS='An enzyme, involved in the early steps of purine nucleotide biosynthesis, that catalyzes the formation of 5-phosphoribosylamine from glutamine and phosphoribosylpyrophosphate. EC 2.4.2.14.'),
  'D000583': NtO(MH='Amikacin', MS='A broad-spectrum antibiotic derived from KANAMYCIN. It is reno- and oto-toxic like the other aminoglycoside antibiotics.'),
  'D000584': NtO(MH='Amiloride', MS="A pyrazine compound inhibiting SODIUM reabsorption through SODIUM CHANNELS in renal EPITHELIAL CELLS. This inhibition creates a negative potential in the luminal membranes of principal cells, located in the distal convoluted tubule and collecting duct. Negative potential reduces secretion of potassium and hydrogen ions. Amiloride is used in conjunction with DIURETICS to spare POTASSIUM loss. (From Gilman et al., Goodman and Gilman's The Pharmacological Basis of Therapeutics, 9th ed, p705)"),
  'D000585': NtO(MH='Aminacrine', MS='A highly fluorescent anti-infective dye used clinically as a topical antiseptic and experimentally as a mutagen, due to its interaction with DNA. It is also used as an intracellular pH indicator.'),
  'D000586': NtO(MH='Amination', MS='The creation of an amine. It can be produced by the addition of an amino group to an organic compound or reduction of a nitro group.'),
  'D000587': NtO(MH='Oxidoreductases Acting on CH-NH Group Donors', MS='Enzymes catalyzing the dehydrogenation of secondary amines, introducing a C=N double bond as the primary reaction. In some cases this is later hydrolyzed.'),
  'D000588': NtO(MH='Amines', MS="A group of compounds derived from ammonia by substituting organic radicals for the hydrogens. (From Grant & Hackh's Chemical Dictionary, 5th ed)"),
  'D000590': NtO(MH='Amino Acid Chloromethyl Ketones', MS='Inhibitors of SERINE ENDOPEPTIDASES and sulfhydryl group-containing enzymes. They act as alkylating agents and are known to interfere in the translation process.'),
  'D000591': NtO(MH='Amino Acid Isomerases', MS='Enzymes that catalyze either the racemization or epimerization of chiral centers within amino acids or derivatives. EC 5.1.1.'),
  'D000592': NtO(MH='Amino Acid Metabolism, Inborn Errors', MS='Disorders affecting amino acid metabolism. The majority of these disorders are inherited and present in the neonatal period with metabolic disturbances (e.g., ACIDOSIS) and neurologic manifestations. They are present at birth, although they may not become symptomatic until later in life.'),
  'D000594': NtO(MH='Amino Acid Oxidoreductases', MS='A class of enzymes that catalyze oxidation-reduction reactions of amino acids.'),
  'D000595': NtO(MH='Amino Acid Sequence', MS='The order of amino acids as they occur in a polypeptide chain. This is referred to as the primary structure of proteins. It is of fundamental importance in determining PROTEIN CONFORMATION.'),
  'D000596': NtO(MH='Amino Acids', MS='Organic compounds that generally contain an amino (-NH2) and a carboxyl (-COOH) group. Twenty alpha-amino acids are the subunits which are polymerized to form proteins.'),
  'D000597': NtO(MH='Amino Acids, Branched-Chain', MS='Amino acids which have a branched carbon chain.'),
  'D000598': NtO(MH='Amino Acids, Cyclic', MS='A class of amino acids characterized by a closed ring structure.'),
  'D000599': NtO(MH='Amino Acids, Diamino', MS=None),
  'D000600': NtO(MH='Amino Acids, Dicarboxylic', MS=None),
  'D000601': NtO(MH='Amino Acids, Essential', MS='Amino acids that are not synthesized by the human body in amounts sufficient to carry out physiological functions. They are obtained from dietary foodstuffs.'),
  'D000602': NtO(MH='Amino Acids, Peptides, and Proteins', MS='Amino acids and chains of amino acids connected by peptide linkages.'),
  'D000603': NtO(MH='Amino Acids, Sulfur', MS=None),
  'D000604': NtO(MH='Amino Acyl-tRNA Synthetases', MS='A subclass of enzymes that aminoacylate AMINO ACID-SPECIFIC TRANSFER RNA with their corresponding AMINO ACIDS.'),
  'D000605': NtO(MH='Amino Alcohols', MS='Compounds possessing both a hydroxyl (-OH) and an amino group (-NH2).'),
  'D000606': NtO(MH='Amino Sugars', MS='SUGARS containing an amino group. GLYCOSYLATION of other compounds with these amino sugars results in AMINOGLYCOSIDES.'),
  'D000607': NtO(MH='Aminoacetonitrile', MS='Cyanomethylamine.'),
  'D000608': NtO(MH='Renal Aminoacidurias', MS='A group of inherited kidney disorders characterized by the abnormally elevated levels of AMINO ACIDS in URINE. Genetic mutations of transport proteins result in the defective reabsorption of free amino acids at the PROXIMAL RENAL TUBULES. Renal aminoaciduria are classified by the specific amino acid or acids involved.'),
  'D000609': NtO(MH='Aminoacridines', MS='Acridines which are substituted in any position by one or more amino groups or substituted amino groups.'),
  'D000611': NtO(MH='Aminobiphenyl Compounds', MS='Biphenyl compounds substituted in any position by one or more amino groups. Permitted are any substituents except fused rings.'),
  'D000612': NtO(MH='4-Aminobutyrate Transaminase', MS='An enzyme that converts brain gamma-aminobutyric acid (GAMMA-AMINOBUTYRIC ACID) into succinate semialdehyde, which can be converted to succinic acid and enter the citric acid cycle. It also acts on beta-alanine. EC 2.6.1.19.'),
  'D000613': NtO(MH='Aminobutyrates', MS='Derivatives of BUTYRIC ACID that contain one or more amino groups attached to the aliphatic structure. Included under this heading are a broad variety of acid forms, salts, esters, and amides that include the aminobutryrate structure.'),
  'D000614': NtO(MH='Aminocaproates', MS='Amino derivatives of caproic acid. Included under this heading are a broad variety of acid forms, salts, esters, and amides that contain the amino caproic acid structure.'),
  'D000615': NtO(MH='Aminoethylphosphonic Acid', MS='An organophosphorus compound isolated from human and animal tissues.'),
  'D000616': NtO(MH='Aminoglutethimide', MS='An aromatase inhibitor that is used in the treatment of advanced BREAST CANCER.'),
  'D000617': NtO(MH='Aminoglycosides', MS='Glycosylated compounds in which there is an amino substituent on the glycoside. Some of them are clinically important ANTIBIOTICS.'),
  'D000618': NtO(MH='Aminohippuric Acids', MS='A group of glycine amides of aminobenzoic acids.'),
  'D000619': NtO(MH='Aminohydrolases', MS=None),
  'D000620': NtO(MH='Aminoimidazole Carboxamide', MS='An imidazole derivative which is a metabolite of the antineoplastic agents BIC and DIC. By itself, or as the ribonucleotide, it is used as a condensation agent in the preparation of nucleosides and nucleotides. Compounded with orotic acid, it is used to treat liver diseases.'),
  'D000621': NtO(MH='Aminoisobutyric Acids', MS='A group of compounds that are derivatives of the amino acid 2-amino-2-methylpropanoic acid.'),
  'D000622': NtO(MH='Aminolevulinic Acid', MS='A compound produced from succinyl-CoA and GLYCINE as an intermediate in heme synthesis. It is used as a PHOTOCHEMOTHERAPY for actinic KERATOSIS.'),
  'D000623': NtO(MH='Porphobilinogen Synthase', MS='An enzyme that catalyzes the formation of porphobilinogen from two molecules of 5-aminolevulinic acid. EC 4.2.1.24.'),
  'D000624': NtO(MH='5-Aminolevulinate Synthetase', MS='An enzyme of the transferase class that catalyzes condensation of the succinyl group from succinyl coenzyme A with glycine to form delta-aminolevulinate. It is a pyridoxyal phosphate protein and the reaction occurs in mitochondria as the first step of the heme biosynthetic pathway. The enzyme is a key regulatory enzyme in heme biosynthesis. In liver feedback is inhibited by heme. EC 2.3.1.37.'),
  'D000625': NtO(MH='Aminooxyacetic Acid', MS='A compound that inhibits aminobutyrate aminotransferase activity in vivo, thereby raising the level of gamma-aminobutyric acid in tissues.'),
  'D000626': NtO(MH='Aminopeptidases', MS='A subclass of EXOPEPTIDASES that act on the free N terminus end of a polypeptide liberating a single amino acid residue. EC 3.4.11.'),
  'D000627': NtO(MH='Aminophenols', MS='Phenols substituted in any position by an amino group.'),
  'D000628': NtO(MH='Aminophylline', MS="A drug combination that contains THEOPHYLLINE and ethylenediamine. It is more soluble in water than theophylline but has similar pharmacologic actions. It's most common use is in bronchial asthma, but it has been investigated for several other applications."),
  'D000629': NtO(MH='Aminopropionitrile', MS='Reagent used as an intermediate in the manufacture of beta-alanine and pantothenic acid.'),
  'D000630': NtO(MH='Aminopterin', MS='A folic acid derivative used as a rodenticide that has been shown to be teratogenic.'),
  'D000631': NtO(MH='Aminopyridines', MS='Pyridines substituted in any position with an amino group. May be hydrogenated, but must retain at least one double bond.'),
  'D000632': NtO(MH='Aminopyrine', MS='A pyrazolone with analgesic, anti-inflammatory, and antipyretic properties but has risk of AGRANULOCYTOSIS. A breath test with 13C-labeled aminopyrine has been used as a non-invasive measure of CYTOCHROME P-450 metabolic activity in LIVER FUNCTION TESTS.'),
  'D000633': NtO(MH='Aminopyrine N-Demethylase', MS=None),
  'D000634': NtO(MH='Aminoquinolines', MS='Quinolines substituted in any position by one or more amino groups.'),
  'D000635': NtO(MH='Aminorex', MS='An amphetamine-like anorectic agent. It may cause pulmonary hypertension.'),
  'D000636': NtO(MH='Aminosalicylic Acids', MS='A group of 2-hydroxybenzoic acids that can be substituted by amino groups at any of the 3-, 4-, 5-, or 6-positions.'),
  'D000637': NtO(MH='Transaminases', MS='A subclass of enzymes of the transferase class that catalyze the transfer of an amino group from a donor (generally an amino acid) to an acceptor (generally a 2-keto acid). Most of these enzymes are pyridoxyl phosphate proteins. (Dorland, 28th ed) EC 2.6.1.'),
  'D000638': NtO(MH='Amiodarone', MS='An antianginal and class III antiarrhythmic drug. It increases the duration of ventricular and atrial muscle action by inhibiting POTASSIUM CHANNELS and VOLTAGE-GATED SODIUM CHANNELS. There is a resulting decrease in heart rate and in vascular resistance.'),
  'D000639': NtO(MH='Amitriptyline', MS='Tricyclic antidepressant with anticholinergic and sedative properties. It appears to prevent the re-uptake of norepinephrine and serotonin at nerve terminals, thus potentiating the action of these neurotransmitters. Amitriptyline also appears to antagonize cholinergic and alpha-1 adrenergic responses to bioactive amines.'),
  'D000640': NtO(MH='Amitrole', MS='A non-selective post-emergence, translocated herbicide. According to the Seventh Annual Report on Carcinogens (PB95-109781, 1994) this substance may reasonably be anticipated to be a carcinogen. (From Merck Index, 12th ed) It is an irreversible inhibitor of CATALASE, and thus impairs activity of peroxisomes.'),
  'D000641': NtO(MH='Ammonia', MS='A colorless alkaline gas. It is formed in the body during decomposition of organic materials during a large number of metabolically important reactions. Note that the aqueous form of ammonia is referred to as AMMONIUM HYDROXIDE.'),
  'D000642': NtO(MH='Ammonia-Lyases', MS='Enzymes that catalyze the formation of a carbon-carbon double bond by the elimination of AMMONIA. EC 4.3.1.'),
  'D000643': NtO(MH='Ammonium Chloride', MS='An acidifying agent that has expectorant and diuretic effects. Also used in etching and batteries and as a flux in electroplating.'),
  'D000644': NtO(MH='Quaternary Ammonium Compounds', MS='Derivatives of ammonium compounds, NH4+ Y-, in which all four of the hydrogens bonded to nitrogen have been replaced with hydrocarbyl groups. These are distinguished from IMINES which are RN=CR2.'),
  'D000645': NtO(MH='Ammonium Sulfate', MS='Sulfuric acid diammonium salt. It is used in CHEMICAL FRACTIONATION of proteins.'),
  'D000646': NtO(MH='Ammotherapy', MS='Treatment by application of hot sand.'),
  'D000647': NtO(MH='Amnesia', MS='Pathologic partial or complete loss of the ability to recall past experiences (AMNESIA, RETROGRADE) or to form new memories (AMNESIA, ANTEROGRADE). This condition may be of organic or psychologic origin. Organic forms of amnesia are usually associated with dysfunction of the DIENCEPHALON or HIPPOCAMPUS. (From Adams et al., Principles of Neurology, 6th ed, pp426-7)'),
  'D000648': NtO(MH='Amnesia, Retrograde', MS='Loss of the ability to recall information that had been previously encoded in memory prior to a specified or approximate point in time. This process may be organic or psychogenic in origin. Organic forms may be associated with CRANIOCEREBRAL TRAUMA; CEREBROVASCULAR ACCIDENTS; SEIZURES; DEMENTIA; and a wide variety of other conditions that impair cerebral function. (From Adams et al., Principles of Neurology, 6th ed, pp426-9)'),
  'D000649': NtO(MH='Amniocentesis', MS='Percutaneous transabdominal puncture of the uterus during pregnancy to obtain amniotic fluid. It is commonly used for fetal karyotype determination in order to diagnose abnormal fetal conditions.'),
  'D000650': NtO(MH='Amnion', MS='The innermost membranous sac that surrounds and protects the developing embryo which is bathed in the AMNIOTIC FLUID. Amnion cells are secretory EPITHELIAL CELLS and contribute to the amniotic fluid.'),
  'D000652': NtO(MH='Amniotic Band Syndrome', MS='A disorder present in the newborn infant in which constriction rings or bands, causing soft tissue depressions, encircle digits, extremities, or limbs and sometimes the neck, thorax, or abdomen. They may be associated with intrauterine amputations.'),
  'D000653': NtO(MH='Amniotic Fluid', MS='A clear, yellowish liquid that envelopes the FETUS inside the sac of AMNION. In the first trimester, it is likely a transudate of maternal or fetal plasma. In the second trimester, amniotic fluid derives primarily from fetal lung and kidney. Cells or substances in this fluid can be removed for prenatal diagnostic tests (AMNIOCENTESIS).'),
  'D000654': NtO(MH='Amobarbital', MS='A barbiturate with hypnotic and sedative properties (but not antianxiety). Adverse effects are mainly a consequence of dose-related CNS depression and the risk of dependence with continued use is high. (From Martindale, The Extra Pharmacopoeia, 30th ed, p565)'),
  'D000655': NtO(MH='Amodiaquine', MS='A 4-aminoquinoline compound with anti-inflammatory properties.'),
  'D000656': NtO(MH='Amoeba', MS='A genus of ameboid protozoa. Characteristics include a vesicular nucleus and the formation of several PSEUDOPODIA, one of which is dominant at a given time. Reproduction occurs asexually by binary fission.'),
  'D000657': NtO(MH='Amoxapine', MS='The N-demethylated derivative of the antipsychotic agent LOXAPINE that works by blocking the reuptake of norepinephrine, serotonin, or both; it also blocks dopamine receptors. Amoxapine is used for the treatment of depression.'),
  'D000658': NtO(MH='Amoxicillin', MS='A broad-spectrum semisynthetic antibiotic similar to AMPICILLIN except that its resistance to gastric acid permits higher serum levels with oral administration.'),
  'D000659': NtO(MH='AMP Deaminase', MS='An enzyme that catalyzes the deamination of AMP to IMP. EC 3.5.4.6.'),
  'D000661': NtO(MH='Amphetamine', MS='A powerful central nervous system stimulant and sympathomimetic. Amphetamine has multiple mechanisms of action including blocking uptake of adrenergics and dopamine, stimulation of release of monamines, and inhibiting monoamine oxidase. Amphetamine is also a drug of abuse and a psychotomimetic. The l- and the d,l-forms are included here. The l-form has less central nervous system activity but stronger cardiovascular effects. The d-form is DEXTROAMPHETAMINE.'),
  'D000662': NtO(MH='Amphetamines', MS='Analogs or derivatives of AMPHETAMINE. Many are sympathomimetics and central nervous system stimulators causing excitation, vasopressin, bronchodilation, and to varying degrees, anorexia, analepsis, nasal decongestion, and some smooth muscle relaxation.'),
  'D000663': NtO(MH='Amphibians', MS='VERTEBRATES belonging to the class amphibia such as frogs, toads, newts and salamanders that live in a semiaquatic environment.'),
  'D000664': NtO(MH='Amphibian Venoms', MS='Venoms produced by frogs, toads, salamanders, etc. The venom glands are usually on the skin of the back and contain cardiotoxic glycosides, cholinolytics, and a number of other bioactive materials, many of which have been characterized. The venoms have been used as arrow poisons and include bufogenin, bufotoxin, bufagin, bufotalin, histrionicotoxins, and pumiliotoxin.'),
  'D000665': NtO(MH='Ampholyte Mixtures', MS='Such mixtures of amphoteric electrolytes or buffers that provide a continuous range of pH in an electric field; used for separating proteins by their isoelectric points, i.e., by isoelectric focusing.'),
  'D000666': NtO(MH='Amphotericin B', MS='Macrolide antifungal antibiotic produced by Streptomyces nodosus obtained from soil of the Orinoco river region of Venezuela.'),
  'D000667': NtO(MH='Ampicillin', MS='Semi-synthetic derivative of penicillin that functions as an orally active broad-spectrum antibiotic.'),
  'D000668': NtO(MH='Ampicillin Resistance', MS='Nonsusceptibility of a microbe to the action of ampicillin, a penicillin derivative that interferes with cell wall synthesis.'),
  'D000669': NtO(MH='Amplifiers, Electronic', MS="Electronic devices that increase the magnitude of a signal's power level or current."),
  'D000670': NtO(MH='Amprolium', MS='A veterinary coccidiostat that interferes with THIAMINE metabolism.'),
  'D000671': NtO(MH='Amputation', MS='The removal of a limb or other appendage or outgrowth of the body. (Dorland, 28th ed)'),
  'D000672': NtO(MH='Amputation Stumps', MS='The part of a limb or tail following amputation that is proximal to the amputated section.'),
  'D000673': NtO(MH='Amputation, Traumatic', MS='Loss of a limb or other bodily appendage by accidental injury.'),
  'D000674': NtO(MH='Amputees', MS=None),
  'D000675': NtO(MH='Ampyrone', MS='A metabolite of AMINOPYRINE with analgesic and anti-inflammatory properties. It is used as a reagent for biochemical reactions producing peroxides or phenols. Ampyrone stimulates LIVER MICROSOMES and is also used to measure extracellular water.'),
  'D000676': NtO(MH='Amrinone', MS='A positive inotropic cardiotonic (CARDIOTONIC AGENTS) with vasodilator properties, phosphodiesterase 3 inhibitory activity, and the ability to stimulate calcium ion influx into the cardiac cell.'),
  'D000677': NtO(MH='Amsacrine', MS='An aminoacridine derivative that intercalates into DNA and is used as an antineoplastic agent.'),
  'D000678': NtO(MH='Amygdalin', MS='A cyanogenic glycoside found in the seeds of Rosaceae.'),
  'D000679': NtO(MH='Amygdala', MS='Almond-shaped group of basal nuclei anterior to the INFERIOR HORN OF THE LATERAL VENTRICLE of the TEMPORAL LOBE. The amygdala is part of the limbic system.'),
  'D000680': NtO(MH='Amyl Nitrite', MS='A vasodilator that is administered by inhalation. It is also used recreationally due to its supposed ability to induce euphoria and act as an aphrodisiac.'),
  'D000681': NtO(MH='Amylases', MS='A group of amylolytic enzymes that cleave starch, glycogen, and related alpha-1,4-glucans. (Stedman, 25th ed) EC 3.2.1.-.'),
  'D000682': NtO(MH='Amyloid', MS='A fibrous protein complex that consists of proteins folded into a specific cross beta-pleated sheet structure. This fibrillar structure has been found as an alternative folding pattern for a variety of functional proteins. Deposits of amyloid in the form of AMYLOID PLAQUES are associated with a variety of degenerative diseases. The amyloid structure has also been found in a number of functional proteins that are unrelated to disease.'),
  'D000683': NtO(MH='Serum Amyloid P-Component', MS='Amyloid P component is a small, non-fibrillar glycoprotein found in normal serum and in all amyloid deposits. It has a pentagonal (pentaxin) structure. It is an acute phase protein, modulates immunologic responses, inhibits ELASTASE, and has been suggested as an indicator of LIVER DISEASE.'),
  'D000685': NtO(MH='Serum Amyloid A Protein', MS='An ACUTE PHASE REACTION protein present in low concentrations in normal sera, but found at higher concentrations in sera of older persons and in patients with AMYLOIDOSIS. It is the circulating precusor of amyloid A protein, which is found deposited in AA type AMYLOID FIBRILS.'),
  'D000686': NtO(MH='Amyloidosis', MS='A group of sporadic, familial and/or inherited, degenerative, and infectious disease processes, linked by the common theme of abnormal protein folding and deposition of AMYLOID. As the amyloid deposits enlarge they displace normal tissue structures, causing disruption of function. Various signs and symptoms depend on the location and size of the deposits.'),
  'D000687': NtO(MH='Amylopectin', MS='A highly branched glucan in starch.'),
  'D000688': NtO(MH='Amylose', MS='An unbranched glucan in starch.'),
  'D000690': NtO(MH='Amyotrophic Lateral Sclerosis', MS='A degenerative disorder affecting upper MOTOR NEURONS in the brain and lower motor neurons in the brain stem and SPINAL CORD. Disease onset is usually after the age of 50 and the process is usually fatal within 3 to 6 years. Clinical manifestations include progressive weakness, atrophy, FASCICULATION, hyperreflexia, DYSARTHRIA, dysphagia, and eventual paralysis of respiratory function. Pathologic features include the replacement of motor neurons with fibrous ASTROCYTES and atrophy of anterior SPINAL NERVE ROOTS and corticospinal tracts. (From Adams et al., Principles of Neurology, 6th ed, pp1089-94)'),
  'D000691': NtO(MH='Anabasine', MS='A piperidine botanical insecticide.'),
  'D000693': NtO(MH='Anaerobiosis', MS='The complete absence, or (loosely) the paucity, of gaseous or dissolved elemental oxygen in a given place or environment. (From Singleton & Sainsbury, Dictionary of Microbiology and Molecular Biology, 2d ed)'),
  'D000694': NtO(MH='Anal Gland Neoplasms', MS='Tumors or cancer of the anal gland.'),
  'D000695': NtO(MH='Anal Sacs', MS='A pair of anal glands or sacs, located on either side of the ANUS, that produce and store a dark, foul-smelling fluid in carnivorous animals such as MEPHITIDAE and DOGS. The expelled fluid is used as a defensive repellent (in skunks) or a material to mark territory (in dogs).'),
  'D000697': NtO(MH='Central Nervous System Stimulants', MS='A loosely defined group of drugs that tend to increase behavioral alertness, agitation, or excitation. They work by a variety of mechanisms, but usually not by direct excitation of neurons. The many drugs that have such actions as side effects to their main therapeutic use are not included here.'),
  'D000698': NtO(MH='Analgesia', MS='Methods of PAIN relief that may be used with or in place of ANALGESICS.'),
  'D000699': NtO(MH='Pain Insensitivity, Congenital', MS='A syndrome characterized by indifference to PAIN despite the ability to distinguish noxious from non-noxious stimuli. Absent corneal reflexes and INTELLECTUAL DISABILITY may be associated. Familial forms with autosomal recessive and autosomal dominant patterns of inheritance have been described. (Adams et al., Principles of Neurology, 6th ed, p1343)'),
  'D000700': NtO(MH='Analgesics', MS='Compounds capable of relieving pain without the loss of CONSCIOUSNESS.'),
  'D000701': NtO(MH='Analgesics, Opioid', MS='Compounds with activity like OPIATE ALKALOIDS, acting at OPIOID RECEPTORS. Properties include induction of ANALGESIA or NARCOSIS.'),
  'D000703': NtO(MH='Analog-Digital Conversion', MS='The process of converting analog data such as continually measured voltage to discrete, digital form.'),
  'D000704': NtO(MH='Analysis of Variance', MS='A statistical technique that isolates and assesses the contributions of categorical independent variables to variation in the mean of a continuous dependent variable.'),
  'D000705': NtO(MH='Anaphase', MS='The phase of cell nucleus division following METAPHASE, in which the CHROMATIDS separate and migrate to opposite poles of the spindle.'),
  'D000706': NtO(MH='Anaphylatoxins', MS='Serum peptides derived from certain cleaved COMPLEMENT PROTEINS during COMPLEMENT ACTIVATION. They induce smooth MUSCLE CONTRACTION; mast cell HISTAMINE RELEASE; PLATELET AGGREGATION; and act as mediators of the local inflammatory process. The order of anaphylatoxin activity from the strongest to the weakest is C5a, C3a, C4a, and C5a des-arginine.'),
  'D000707': NtO(MH='Anaphylaxis', MS='An acute hypersensitivity reaction due to exposure to a previously encountered ANTIGEN. The reaction may include rapidly progressing URTICARIA, respiratory distress, vascular collapse, systemic SHOCK, and death.'),
  'D000708': NtO(MH='Anaplasia', MS='Loss of structural differentiation and useful function of neoplastic cells.'),
  'D000709': NtO(MH='Anaplasma', MS='A genus of gram-negative bacteria whose organisms are obligate parasites of vertebrates. Species are transmitted by arthropod vectors with the host range limited to ruminants. Anaplasma marginale is the most pathogenic species and is the causative agent of severe bovine anaplasmosis.'),
  'D000710': NtO(MH='Anaplasmataceae', MS='A family of bacteria in the order RICKETTSIALES which inhabit RED BLOOD CELLS and other types of cells, causing disease in both animals and humans.'),
  'D000711': NtO(MH='Anaplasmataceae Infections', MS='Infections with bacteria of the family ANAPLASMATACEAE.'),
  'D000712': NtO(MH='Anaplasmosis', MS='A disease usually in cattle caused by parasitization of the red blood cells by bacteria of the genus ANAPLASMA.'),
  'D000713': NtO(MH='Anastomosis, Roux-en-Y', MS='A Y-shaped surgical anastomosis of any part of the digestive system which includes the small intestine as the eventual drainage site.'),
  'D000714': NtO(MH='Anastomosis, Surgical', MS='Surgical union or shunt between ducts, tubes or vessels. It may be end-to-end, end-to-side, side-to-end, or side-to-side.'),
  'D000715': NtO(MH='Anatomy', MS='A branch of biology dealing with the structure of organisms.'),
  'D000716': NtO(MH='Anatomy, Artistic', MS='The study of the structures of organisms for applications in art: drawing, painting, sculpture, illustration, etc.'),
  'D000717': NtO(MH='Anatomy, Comparative', MS='The comparative study of animal structure with regard to homologous organs or parts. (Stedman, 25th ed)'),
  'D000718': NtO(MH='Anatomy, Regional', MS='The anatomical study of specific regions or parts of organisms, emphasizing the relationship between the various structures (e.g. muscles, nerves, skeletal, cardiovascular, etc.).'),
  'D000719': NtO(MH='Anatomy, Veterinary', MS='The study of the anatomical structures of animals.'),
  'D000720': NtO(MH='Ancillary Services, Hospital', MS='Those support services other than room, board, and medical and nursing services that are provided to hospital patients in the course of care. They include such services as laboratory, radiology, pharmacy, and physical therapy services.'),
  'D000721': NtO(MH='Ancrod', MS='An enzyme fraction from the venom of the Malayan pit viper, Agkistrodon rhodostoma. It catalyzes the hydrolysis of a number of amino acid esters and a limited proteolysis of fibrinogen. It is used clinically to produce controlled defibrination in patients requiring anticoagulant therapy. EC 3.4.21.-.'),
  'D000722': NtO(MH='Ancylostoma', MS='A genus of nematode intestinal parasites that consists of several species. A. duodenale is the common hookworm in humans. A. braziliense, A. ceylonicum, and A. caninum occur primarily in cats and dogs, but all have been known to occur in humans.'),
  'D000723': NtO(MH='Ancylostomatoidea', MS='A superfamily of nematode parasitic hookworms consisting of four genera: ANCYLOSTOMA; NECATOR; Bunostomum; and Uncinaria. ANCYLOSTOMA and NECATOR occur in humans and other mammals. Bunostomum is common in ruminants and Uncinaria in wolves, foxes, and dogs.'),
  'D000724': NtO(MH='Ancylostomiasis', MS='Infection of humans or animals with hookworms of the genus ANCYLOSTOMA. Characteristics include anemia, dyspepsia, eosinophilia, and abdominal swelling.'),
  'D000725': NtO(MH='Andorra', MS="A principality in the Pyrenees between France and Spain. Its capital is also called Andorra. (From Webster's New Geographical Dictionary, 1988, p50)"),
  'D000726': NtO(MH='Androgen Antagonists', MS='Compounds which inhibit or antagonize the biosynthesis or actions of androgens.'),
  'D000727': NtO(MH='Androgen-Binding Protein', MS='Carrier proteins produced in the Sertoli cells of the testis, secreted into the seminiferous tubules, and transported via the efferent ducts to the epididymis. They participate in the transport of androgens. Androgen-binding protein has the same amino acid sequence as SEX HORMONE-BINDING GLOBULIN. They differ by their sites of synthesis and post-translational oligosaccharide modifications.'),
  'D000728': NtO(MH='Androgens', MS='Compounds that interact with ANDROGEN RECEPTORS in target tissues to bring about the effects similar to those of TESTOSTERONE. Depending on the target tissues, androgenic effects can be on SEX DIFFERENTIATION; male reproductive organs, SPERMATOGENESIS; secondary male SEX CHARACTERISTICS; LIBIDO; development of muscle mass, strength, and power.'),
  'D000730': NtO(MH='Androstadienes', MS='Derivatives of the steroid androstane having two double bonds at any site in any of the rings.'),
  'D000731': NtO(MH='Androstanes', MS='The family of steroids from which the androgens are derived.'),
  'D000732': NtO(MH='Androstanols', MS='Androstanes and androstane derivatives which are substituted in any position with one or more hydroxyl groups.'),
  'D000733': NtO(MH='Androstatrienes', MS='Derivatives of the steroid androstane having three double bonds at any site in any of the rings.'),
  'D000734': NtO(MH='Androstenediols', MS='Unsaturated androstane derivatives which are substituted with two hydroxy groups in any position in the ring system.'),
  'D000735': NtO(MH='Androstenedione', MS='A delta-4 C19 steroid that is produced not only in the TESTIS, but also in the OVARY and the ADRENAL CORTEX. Depending on the tissue type, androstenedione can serve as a precursor to TESTOSTERONE as well as ESTRONE and ESTRADIOL.'),
  'D000736': NtO(MH='Androstenes', MS='Unsaturated derivatives of the steroid androstane containing at least one double bond at any site in any of the rings.'),
  'D000737': NtO(MH='Androstenols', MS='Unsaturated androstanes which are substituted with one or more hydroxyl groups in any position in the ring system.'),
  'D000738': NtO(MH='Androsterone', MS='A metabolite of TESTOSTERONE or ANDROSTENEDIONE with a 3-alpha-hydroxyl group and without the double bond. The 3-beta hydroxyl isomer is epiandrosterone.'),
  'D000739': NtO(MH='Anecdotes as Topic', MS='Works about brief accounts or narratives of an incident or event.'),
  'D000740': NtO(MH='Anemia', MS='A reduction in the number of circulating ERYTHROCYTES or in the quantity of HEMOGLOBIN.'),
  'D000741': NtO(MH='Anemia, Aplastic', MS='A form of anemia in which the bone marrow fails to produce adequate numbers of peripheral blood elements.'),
  'D000742': NtO(MH='Anemia, Dyserythropoietic, Congenital', MS='A familial disorder characterized by ANEMIA with multinuclear ERYTHROBLASTS, karyorrhexis, asynchrony of nuclear and cytoplasmic maturation, and various nuclear abnormalities of bone marrow erythrocyte precursors (ERYTHROID PRECURSOR CELLS). Type II is the most common of the 3 types; it is often referred to as HEMPAS, based on the Hereditary Erythroblast Multinuclearity with Positive Acidified Serum test.'),
  'D000743': NtO(MH='Anemia, Hemolytic', MS='A condition of inadequate circulating red blood cells (ANEMIA) or insufficient HEMOGLOBIN due to premature destruction of red blood cells (ERYTHROCYTES).'),
  'D000744': NtO(MH='Anemia, Hemolytic, Autoimmune', MS="Acquired hemolytic anemia due to the presence of AUTOANTIBODIES which agglutinate or lyse the patient's own RED BLOOD CELLS."),
  'D000745': NtO(MH='Anemia, Hemolytic, Congenital', MS='Hemolytic anemia due to various intrinsic defects of the erythrocyte.'),
  'D000746': NtO(MH='Anemia, Hemolytic, Congenital Nonspherocytic', MS='Any one of a group of congenital hemolytic anemias in which there is no abnormal hemoglobin or spherocytosis and in which there is a defect of glycolysis in the erythrocyte. Common causes include deficiencies in GLUCOSE-6-PHOSPHATE ISOMERASE; PYRUVATE KINASE; and GLUCOSE-6-PHOSPHATE DEHYDROGENASE.'),
  'D000747': NtO(MH='Anemia, Hypochromic', MS='Anemia characterized by a decrease in the ratio of the weight of hemoglobin to the volume of the erythrocyte, i.e., the mean corpuscular hemoglobin concentration is less than normal. The individual cells contain less hemoglobin than they could have under optimal conditions. Hypochromic anemia may be caused by iron deficiency from a low iron intake, diminished iron absorption, or excessive iron loss. It can also be caused by infections or other diseases, therapeutic drugs, lead poisoning, and other conditions. (Stedman, 25th ed; from Miale, Laboratory Medicine: Hematology, 6th ed, p393)'),
  'D000748': NtO(MH='Anemia, Macrocytic', MS='Anemia characterized by larger than normal erythrocytes, increased mean corpuscular volume (MCV) and increased mean corpuscular hemoglobin (MCH).'),
  'D000749': NtO(MH='Anemia, Megaloblastic', MS='A disorder characterized by the presence of ANEMIA, abnormally large red blood cells (megalocytes or macrocytes), and MEGALOBLASTS.'),
  'D000750': NtO(MH='Anemia, Myelophthisic', MS='Anemia characterized by appearance of immature myeloid and nucleated erythrocytes in the peripheral blood, resulting from infiltration of the bone marrow by foreign or abnormal tissue.'),
  'D000751': NtO(MH='Anemia, Neonatal', MS='The mildest form of erythroblastosis fetalis in which anemia is the chief manifestation.'),
  'D000752': NtO(MH='Anemia, Pernicious', MS='A megaloblastic anemia occurring in children but more commonly in later life, characterized by histamine-fast achlorhydria, in which the laboratory and clinical manifestations are based on malabsorption of vitamin B 12 due to a failure of the gastric mucosa to secrete adequate and potent intrinsic factor. (Dorland, 27th ed)'),
  'D000753': NtO(MH='Anemia, Refractory', MS='A severe sometimes chronic anemia, usually macrocytic in type, that does not respond to ordinary antianemic therapy.'),
  'D000754': NtO(MH='Anemia, Refractory, with Excess of Blasts', MS='Chronic refractory anemia with granulocytopenia, and/or thrombocytopenia. Myeloblasts and progranulocytes constitute 5 to 40 percent of the nucleated marrow cells.'),
  'D000755': NtO(MH='Anemia, Sickle Cell', MS='A disease characterized by chronic hemolytic anemia, episodic painful crises, and pathologic involvement of many organs. It is the clinical expression of homozygosity for hemoglobin S.'),
  'D000756': NtO(MH='Anemia, Sideroblastic', MS='Anemia characterized by the presence of erythroblasts containing excessive deposits of iron in the marrow.'),
  'D000757': NtO(MH='Anencephaly', MS='A malformation of the nervous system caused by failure of the anterior neuropore to close. Infants are born with intact spinal cords, cerebellums, and brainstems, but lack formation of neural structures above this level. The skull is only partially formed but the eyes are usually normal. This condition may be associated with folate deficiency. Affected infants are only capable of primitive (brain stem) reflexes and usually do not survive for more than two weeks. (From Menkes, Textbook of Child Neurology, 5th ed, p247)'),
  'D000758': NtO(MH='Anesthesia', MS='A state characterized by loss of feeling or sensation. This depression of nerve function is usually the result of pharmacologic action and is induced to allow performance of surgery or other painful procedures.'),
  'D000759': NtO(MH='Adjuvants, Anesthesia', MS='Agents that are administered in association with anesthetics to increase effectiveness, improve delivery, or decrease required dosage.'),
  'D000760': NtO(MH='Anesthesia and Analgesia', MS='Medical methods of either relieving pain caused by a particular condition or removing the sensation of pain during a surgery or other medical procedure.'),
  'D000761': NtO(MH='Anesthesia Department, Hospital', MS='Hospital department responsible for the administration of functions and activities pertaining to the delivery of anesthetics.'),
  'D000762': NtO(MH='Anesthesia Recovery Period', MS='The period of emergence from general anesthesia, where different elements of consciousness return at different rates.'),
  'D000763': NtO(MH='Anesthesia, Caudal', MS='Epidural anesthesia administered via the sacral canal.'),
  'D000764': NtO(MH='Anesthesia, Closed-Circuit', MS='Inhalation anesthesia where the gases exhaled by the patient are rebreathed as some carbon dioxide is simultaneously removed and anesthetic gas and oxygen are added so that no anesthetic escapes into the room. Closed-circuit anesthesia is used especially with explosive anesthetics to prevent fires where electrical sparking from instruments is possible.'),
  'D000765': NtO(MH='Anesthesia, Conduction', MS='Injection of an anesthetic into the nerves to inhibit nerve transmission in a specific part of the body.'),
  'D000766': NtO(MH='Anesthesia, Dental', MS='A range of methods used to reduce pain and anxiety during dental procedures.'),
  'D000767': NtO(MH='Anesthesia, Epidural', MS='Procedure in which an anesthetic is injected into the epidural space.'),
  'D000768': NtO(MH='Anesthesia, General', MS='Procedure in which patients are induced into an unconscious state through use of various medications so that they do not feel pain during surgery.'),
  'D000769': NtO(MH='Anesthesia, Inhalation', MS='Anesthesia caused by the breathing of anesthetic gases or vapors or by insufflating anesthetic gases or vapors into the respiratory tract.'),
  'D000770': NtO(MH='Anesthesia, Endotracheal', MS='Procedure in which an anesthetic such as a gas or mixture of gases is inhaled through a tube into the lungs.'),
  'D000771': NtO(MH='Anesthesia, Intravenous', MS='Process of administering an anesthetic through injection directly into the bloodstream.'),
  'D000772': NtO(MH='Anesthesia, Local', MS='A blocking of nerve conduction to a specific area by an injection of an anesthetic agent.'),
  'D000773': NtO(MH='Anesthesia, Obstetrical', MS='A variety of anesthetic methods such as EPIDURAL ANESTHESIA used to control the pain of childbirth.'),
  'D000774': NtO(MH='Anesthesia, Rectal', MS='Procedure involving the instillation of an anesthetic into the rectum.'),
  'D000775': NtO(MH='Anesthesia, Spinal', MS='Procedure in which an anesthetic is injected directly into the spinal cord.'),
  'D000776': NtO(MH='Anesthesiology', MS='A specialty concerned with the study of anesthetics and anesthesia.'),
  'D000777': NtO(MH='Anesthetics', MS='Agents that are capable of inducing a total or partial loss of sensation, especially tactile sensation and pain. They may act to induce general ANESTHESIA, in which an unconscious state is achieved, or may act locally to induce numbness or lack of sensation at a targeted site.'),
  'D000778': NtO(MH='Anesthetics, Dissociative', MS="Intravenous anesthetics that induce a state of sedation, immobility, amnesia, and marked analgesia. Subjects may experience a strong feeling of dissociation from the environment. The condition produced is similar to NEUROLEPTANALGESIA, but is brought about by the administration of a single drug. (From Gilman et al., Goodman and Gilman's The Pharmacological Basis of Therapeutics, 8th ed)"),
  'D000779': NtO(MH='Anesthetics, Local', MS="Drugs that block nerve conduction when applied locally to nerve tissue in appropriate concentrations. They act on any part of the nervous system and on every type of nerve fiber. In contact with a nerve trunk, these anesthetics can cause both sensory and motor paralysis in the innervated area. Their action is completely reversible. (From Gilman AG, et. al., Goodman and Gilman's The Pharmacological Basis of Therapeutics, 8th ed) Nearly all local anesthetics act by reducing the tendency of voltage-dependent sodium channels to activate."),
  'D000780': NtO(MH='Anestrus', MS='A state of sexual inactivity in female animals exhibiting no ESTROUS CYCLE. Causes of anestrus include pregnancy, presence of offspring, season, stress, and pathology.'),
  'D000781': NtO(MH='Anethole Trithione', MS='Choleretic used to allay dry mouth and constipation due to tranquilizers.'),
  'D000782': NtO(MH='Aneuploidy', MS='The chromosomal constitution of cells which deviate from the normal by the addition or subtraction of CHROMOSOMES, chromosome pairs, or chromosome fragments. In a normally diploid cell (DIPLOIDY) the loss of a chromosome pair is termed nullisomy (symbol: 2N-2), the loss of a single chromosome is MONOSOMY (symbol: 2N-1), the addition of a chromosome pair is tetrasomy (symbol: 2N+2), the addition of a single chromosome is TRISOMY (symbol: 2N+1).'),
  'D000783': NtO(MH='Aneurysm', MS='Pathological outpouching or sac-like dilatation in the wall of any blood vessel (ARTERIES or VEINS) or the heart (HEART ANEURYSM). It indicates a thin and weakened area in the wall which may later rupture. Aneurysms are classified by location, etiology, or other characteristics.'),
  'D000784': NtO(MH='Aneurysm, Dissecting', MS='An aneurysm caused by a tear in the TUNICA INTIMA of a blood vessel leading to interstitial HEMORRHAGE, and splitting (dissecting) of the vessel wall, often involving the AORTA. Dissection between the tunica intima and TUNICA MEDIA causes luminal occlusion. Dissection at the media, or between the media and the outer ADVENTITIA causes aneurismal dilation.'),
  'D000785': NtO(MH='Aneurysm, Infected', MS='Aneurysm due to growth of microorganisms in the arterial wall, or infection arising within preexisting arteriosclerotic aneurysms.'),
  'D000786': NtO(MH='Anger', MS='A strong emotional feeling of displeasure aroused by being interfered with, injured or threatened.'),
  'D000787': NtO(MH='Angina Pectoris', MS='The symptom of paroxysmal pain consequent to MYOCARDIAL ISCHEMIA usually of distinctive character, location and radiation. It is thought to be provoked by a transient stressful situation during which the oxygen requirements of the MYOCARDIUM exceed that supplied by the CORONARY CIRCULATION.'),
  'D000788': NtO(MH='Angina Pectoris, Variant', MS='A clinical syndrome characterized by the development of CHEST PAIN at rest with concomitant transient ST segment elevation in the ELECTROCARDIOGRAM, but with preserved exercise capacity.'),
  'D000789': NtO(MH='Angina, Unstable', MS='Precordial pain at rest, which may precede a MYOCARDIAL INFARCTION.'),
  'D000790': NtO(MH='Angiocardiography', MS='Radiography of the heart and great vessels after injection of a contrast medium.'),
  'D000792': NtO(MH='Angiography', MS='Radiography of blood vessels after injection of a contrast medium.'),
  'D000793': NtO(MH='Angioid Streaks', MS='Small breaks in the elastin-filled tissue of the retina.'),
  'D000794': NtO(MH='Angiokeratoma', MS='A vascular, horny neoplasm of the skin characterized by TELANGIECTASIS and secondary epithelial changes including acanthosis and hyperkeratosis.'),
  'D000795': NtO(MH='Fabry Disease', MS='An X-linked inherited metabolic disease caused by a deficiency of lysosomal ALPHA-GALACTOSIDASE A. It is characterized by intralysosomal accumulation of globotriaosylceramide and other GLYCOSPHINGOLIPIDS in blood vessels throughout the body leading to multi-system complications including renal, cardiac, cerebrovascular, and skin disorders.'),
  'D000796': NtO(MH='Angiolymphoid Hyperplasia with Eosinophilia', MS='Solitary or multiple benign cutaneous nodules comprised of immature and mature vascular structures intermingled with endothelial cells and a varied infiltrate of eosinophils, histiocytes, lymphocytes, and mast cells.'),
  'D000798': NtO(MH='Angiomatosis', MS='A condition with multiple tumor-like lesions caused either by congenital or developmental malformations of BLOOD VESSELS, or reactive vascular proliferations, such as in bacillary angiomatosis. Angiomatosis is considered non-neoplastic.'),
  'D000799': NtO(MH='Angioedema', MS='Swelling involving the deep DERMIS, subcutaneous, or submucosal tissues, representing localized EDEMA. Angioedema often occurs in the face, lips, tongue, and larynx.'),
  'D000800': NtO(MH='Angioplasty, Balloon', MS='Use of a balloon catheter for dilation of an occluded artery. It is used in treatment of arterial occlusive diseases, including renal artery stenosis and arterial occlusions in the leg. For the specific technique of BALLOON DILATION in coronary arteries, ANGIOPLASTY, BALLOON, CORONARY is available.'),
  'D000801': NtO(MH='Angiostrongylus', MS='A genus of parasitic nematodes of the superfamily METASTRONGYLOIDEA. Two species, ANGIOSTRONGYLUS CANTONENSIS and A. vasorum, infest the lungs of rats and dogs, respectively. A. cantonensis is transmissible to man where it causes frequently fatal infection of the central nervous system.'),
  'D000802': NtO(MH='Angiotensin Amide', MS='The octapeptide amide of bovine angiotensin II used to increase blood pressure by vasoconstriction.'),
  'D000803': NtO(MH='Angiotensin I', MS='A decapeptide that is cleaved from precursor angiotensinogen by RENIN. Angiotensin I has limited biological activity. It is converted to angiotensin II, a potent vasoconstrictor, after the removal of two amino acids at the C-terminal by ANGIOTENSIN CONVERTING ENZYME.'),
  'D000804': NtO(MH='Angiotensin II', MS='An octapeptide that is a potent but labile vasoconstrictor. It is produced from angiotensin I after the removal of two amino acids at the C-terminal by ANGIOTENSIN CONVERTING ENZYME. The amino acid in position 5 varies in different species. To block VASOCONSTRICTION and HYPERTENSION effect of angiotensin II, patients are often treated with ACE INHIBITORS or with ANGIOTENSIN II TYPE 1 RECEPTOR BLOCKERS.'),
  'D000805': NtO(MH='Angiotensin III', MS='A heptapeptide formed from ANGIOTENSIN II after the removal of an amino acid at the N-terminal by AMINOPEPTIDASE A. Angiotensin III has the same efficacy as ANGIOTENSIN II in promoting ALDOSTERONE secretion and modifying renal blood flow, but less vasopressor activity (about 40%).'),
  'D000806': NtO(MH='Angiotensin-Converting Enzyme Inhibitors', MS='A class of drugs whose main indications are the treatment of hypertension and heart failure. They exert their hemodynamic effect mainly by inhibiting the renin-angiotensin system. They also modulate sympathetic nervous system activity and increase prostaglandin synthesis. They cause mainly vasodilation and mild natriuresis without affecting heart rate and contractility.'),
  'D000808': NtO(MH='Angiotensinogen', MS='An alpha-globulin of about 453 amino acids, depending on the species. It is produced by the liver and secreted into blood circulation. Angiotensinogen is the inactive precursor of natural angiotensins. Upon successive enzyme cleavages, angiotensinogen yields angiotensin I, II, and III with amino acids numbered at 10, 8, and 7, respectively.'),
  'D000809': NtO(MH='Angiotensins', MS='Oligopeptides which are important in the regulation of blood pressure (VASOCONSTRICTION) and fluid homeostasis via the RENIN-ANGIOTENSIN SYSTEM. These include angiotensins derived naturally from precursor ANGIOTENSINOGEN, and those synthesized.'),
  'D000810': NtO(MH='Angola', MS='A republic in southern Africa, southwest of DEMOCRATIC REPUBLIC OF THE CONGO and west of ZAMBIA. Its capital is Luanda.'),
  'D000811': NtO(MH='Anguilla', MS='A genus in the Family Anguillidae, Order Anguilliformes, that includes fresh water eels.'),
  'D000812': NtO(MH='Anhydrides', MS='Chemical compounds derived from acids by the elimination of a molecule of water.'),
  'D000813': NtO(MH='Anilides', MS='Any aromatic amide obtained by acylation of aniline.'),
  'D000814': NtO(MH='Aniline Compounds', MS='Compounds that include the aminobenzene structure.'),
  'D000815': NtO(MH='Aniline Hydroxylase', MS='A drug-metabolizing, cytochrome P-450 enzyme which catalyzes the hydroxylation of aniline to hydroxyaniline in the presence of reduced flavoprotein and molecular oxygen. EC 1.14.14.-.'),
  'D000816': NtO(MH='Aniline Mustard', MS='Alkylating anti-neoplastic agent.'),
  'D000817': NtO(MH='Anilino Naphthalenesulfonates', MS='A class of organic compounds which contain an anilino (phenylamino) group linked to a salt or ester of naphthalenesulfonic acid. They are frequently used as fluorescent dyes and sulfhydryl reagents.'),
  'D000818': NtO(MH='Animals', MS='Unicellular or multicellular, heterotrophic organisms, that have sensation and the power of voluntary movement. Under the older five kingdom paradigm, Animalia was one of the kingdoms. Under the modern three domain model, Animalia represents one of the many groups in the domain EUKARYOTA.'),
  'D000819': NtO(MH='Animal Communication', MS='Communication between animals involving the giving off by one individual of some chemical or physical signal, that, on being received by another, influences its behavior.'),
  'D000820': NtO(MH='Animal Diseases', MS='Diseases that occur in VERTEBRATE animals.'),
  'D000821': NtO(MH='Animal Feed', MS='Foodstuff used especially for domestic and laboratory animals, or livestock.'),
  'D000822': NtO(MH='Animal Husbandry', MS='The science of breeding, feeding and care of domestic animals; includes housing and nutrition.'),
  'D000823': NtO(MH='Animal Identification Systems', MS='Procedures for recognizing individual animals and certain identifiable characteristics pertaining to them; includes computerized methods, ear tags, etc.'),
  'D000824': NtO(MH='Animal Nutritional Physiological Phenomena', MS='Nutritional physiology of animals.'),
  'D000825': NtO(MH='Animal Structures', MS='Organs and other anatomical structures of non-human vertebrate and invertebrate animals.'),
  'D000826': NtO(MH='Animal Testing Alternatives', MS='Procedures, such as TISSUE CULTURE TECHNIQUES; mathematical models; etc., when used or advocated for use in place of the use of animals in research or diagnostic laboratories.'),
  'D000827': NtO(MH='Animal Welfare', MS='The protection of animals in laboratories or other specific environments by promoting their health through better nutrition, housing, and care.'),
  'D000828': NtO(MH='Animal Population Groups', MS='Animals grouped according to ecological, morphological or genetic populations.'),
  'D000829': NtO(MH='Animals, Domestic', MS='Animals which have become adapted through breeding in captivity to a life intimately associated with humans. They include animals domesticated by humans to live and breed in a tame condition on farms or ranches for economic reasons, including LIVESTOCK (specifically CATTLE; SHEEP; HORSES; etc.), POULTRY; and those raised or kept for pleasure and companionship, e.g., PETS; or specifically DOGS; CATS; etc.'),
  'D000830': NtO(MH='Animals, Laboratory', MS='Animals used or intended for use in research, testing, or teaching.'),
  'D000831': NtO(MH='Animals, Newborn', MS='Refers to animals in the period of time just after birth.'),
  'D000832': NtO(MH='Animals, Poisonous', MS='Animal population groups that produce BIOLOGICAL TOXINS.'),
  'D000833': NtO(MH='Animals, Suckling', MS='Young, unweaned mammals. Refers to nursing animals whether nourished by their biological mother, foster mother, or bottle fed.'),
  'D000835': NtO(MH='Animals, Wild', MS='Animals considered to be wild or feral or not adapted for domestic use. It does not include wild animals in zoos for which ANIMALS, ZOO is available.'),
  'D000836': NtO(MH='Animals, Zoo', MS='Animal population groups or individual animals that reside in captivity at a zoological park.'),
  'D000837': NtO(MH='Anion Exchange Resins', MS='High-molecular-weight insoluble polymers that contain functional cationic groups capable of undergoing exchange reactions with anions.'),
  'D000838': NtO(MH='Anions', MS='Negatively charged atoms, radicals or groups of atoms which travel to the anode or positive pole during electrolysis.'),
  'D000839': NtO(MH='Aniseikonia', MS='A condition in which the ocular image of an object as seen by one eye differs in size and shape from that seen by the other.'),
  'D000840': NtO(MH='Anisoles', MS='A group of compounds that are derivatives of methoxybenzene and contain the general formula R-C7H7O.'),
  'D000841': NtO(MH='Anisomycin', MS='An antibiotic isolated from various Streptomyces species. It interferes with protein and DNA synthesis by inhibiting peptidyl transferase or the 80S ribosome system.'),
  'D000842': NtO(MH='Ankle', MS='The region of the lower limb between the FOOT and the LEG.'),
  'D000843': NtO(MH='Ankle Joint', MS='The joint that is formed by the inferior articular and malleolar articular surfaces of the TIBIA; the malleolar articular surface of the FIBULA; and the medial malleolar, lateral malleolar, and superior surfaces of the TALUS.'),
  'D000844': NtO(MH='Ankylosis', MS='Fixation and immobility of a joint.'),
  'D000845': NtO(MH='Annelida', MS='A phylum of metazoan invertebrates comprising the segmented worms, and including marine annelids (POLYCHAETA), freshwater annelids, earthworms (OLIGOCHAETA), and LEECHES. Only the leeches are of medical interest. (Dorland, 27th ed)'),
  'D000846': NtO(MH='Anniversaries and Special Events', MS='Occasions to commemorate an event or occasions designated for a specific purpose.'),
  'D000847': NtO(MH='Annual Reports as Topic', MS='Works on annual statements reviewing the status of the administrative and operational functions and accomplishments of an institution or organization.'),
  'D000848': NtO(MH='Anodontia', MS='Congenital absence of the teeth; it may involve all (total anodontia) or only some of the teeth (partial anodontia, hypodontia), and both the deciduous and the permanent dentition, or only teeth of the permanent dentition. (Dorland, 27th ed)'),
  'D000849': NtO(MH='Anomia', MS='A language dysfunction characterized by the inability to name people and objects that are correctly perceived. The individual is able to describe the object in question, but cannot provide the name. This condition is associated with lesions of the dominant hemisphere involving the language areas, in particular the TEMPORAL LOBE. (From Adams et al., Principles of Neurology, 6th ed, p484)'),
  'D000850': NtO(MH='Anomie', MS='A state of social disorganization and demoralization in society which is largely the result of disharmony between cultural goals and the means for attaining them. This may be reflected in the behavior of the individual in many ways - non-conformity, social withdrawal, deviant behavior, etc.'),
  'D000851': NtO(MH='Anonyms and Pseudonyms', MS='Designations for persons whose names are not known or who wish to remain anonymous (anonyms) and for persons who wish to conceal or obscure their identity by assuming a fictitious name (pseudonyms).'),
  'D000852': NtO(MH='Anopheles', MS='A genus of mosquitoes (CULICIDAE) that are known vectors of MALARIA.'),
  'D000853': NtO(MH='Anophthalmos', MS='Congenital absence of the eye or eyes.'),
  'D000854': NtO(MH='Anoplura', MS='An order of insects comprising the sucking lice, which are blood-sucking ectoparasites of mammals. Recognized families include: Echinphthiriidae, Haematopinidae, and Pediculidae. The latter contains the medically important genera affecting humans: PEDICULUS and PHTHIRUS.'),
  'D000855': NtO(MH='Anorexia', MS='The lack or loss of APPETITE accompanied by an aversion to food and the inability to eat. It is the defining characteristic of the disorder ANOREXIA NERVOSA.'),
  'D000856': NtO(MH='Anorexia Nervosa', MS='An eating disorder that is characterized by the lack or loss of APPETITE, known as ANOREXIA. Other features include excess fear of becoming OVERWEIGHT; BODY IMAGE disturbance; significant WEIGHT LOSS; refusal to maintain minimal normal weight; and AMENORRHEA. This disorder occurs most frequently in adolescent females. (APA, Thesaurus of Psychological Index Terms, 1994)'),
  'D000857': NtO(MH='Olfaction Disorders', MS='Loss of or impaired ability to smell. This may be caused by OLFACTORY NERVE DISEASES; PARANASAL SINUS DISEASES; viral RESPIRATORY TRACT INFECTIONS; CRANIOCEREBRAL TRAUMA; SMOKING; and other conditions.'),
  'D000858': NtO(MH='Anovulation', MS='Suspension or cessation of OVULATION in animals or humans with follicle-containing ovaries (OVARIAN FOLLICLE). Depending on the etiology, OVULATION may be induced with appropriate therapy.'),
  'D000860': NtO(MH='Hypoxia', MS='Sub-optimal OXYGEN levels in the ambient air of living organisms.'),
  'D000861': NtO(MH='Anserine', MS='A dipeptide containing BETA-ALANINE.'),
  'D000862': NtO(MH='Ant Venoms', MS='Venoms from the superfamily Formicoidea, Ants. They may contain protein factors and toxins, histamine, enzymes, and alkaloids and are often allergenic or immunogenic.'),
  'D000863': NtO(MH='Antacids', MS='Substances that counteract or neutralize acidity of the GASTROINTESTINAL TRACT.'),
  'D000864': NtO(MH='Antarctic Regions', MS="The continent lying around the South Pole and the southern waters of the Atlantic, Pacific, and Indian Oceans. It includes the Falkland Islands Dependencies. (From Webster's New Geographical Dictionary, 1988, p55)"),
  'D000865': NtO(MH='Antazoline', MS='An antagonist of histamine H1 receptors.'),
  'D000866': NtO(MH='Antelopes', MS='Any of various ruminant mammals of the order Bovidae. They include numerous species in Africa and the American pronghorn.'),
  'D000867': NtO(MH='Anterior Chamber', MS='The space in the eye, filled with aqueous humor, bounded anteriorly by the cornea and a small portion of the sclera and posteriorly by a small portion of the ciliary body, the iris, and that part of the crystalline lens which presents through the pupil. (Cline et al., Dictionary of Visual Science, 4th ed, p109)'),
  'D000868': NtO(MH='Anterior Compartment Syndrome', MS='Rapid swelling, increased tension, pain, and ischemic necrosis of the muscles of the anterior tibial compartment of the leg, often following excessive PHYSICAL EXERTION.'),
  'D000869': NtO(MH='Anterior Eye Segment', MS='The front third of the eyeball that includes the structures between the front surface of the cornea and the front of the VITREOUS BODY.'),
  'D000870': NtO(MH='Anterior Horn Cells', MS='MOTOR NEURONS in the anterior (ventral) horn of the SPINAL CORD which project to SKELETAL MUSCLES.'),
  'D000871': NtO(MH='Anthelmintics', MS='Agents that kill parasitic worms. They are used therapeutically in the treatment of HELMINTHIASIS in man and animal.'),
  'D000872': NtO(MH='Anthocyanins', MS='A group of FLAVONOIDS derived from FLAVONOLS, which lack the ketone oxygen at the 4-position. They are glycosylated versions of cyanidin, pelargonidin or delphinidin. The conjugated bonds result in blue, red, and purple colors in flowers of plants.'),
  'D000873': NtO(MH='Anthracenes', MS='A group of compounds with three aromatic rings joined in linear arrangement.'),
  'D000874': NtO(MH='Anthracosilicosis', MS='A form of pneumoconiosis caused by inhalation of dust that contains both CARBON and crystalline SILICON DIOXIDE. These foreign matters induce fibrous nodule formation in the lung.'),
  'D000875': NtO(MH='Anthralin', MS='An anthracene derivative that disrupts MITOCHONDRIA function and structure and is used for the treatment of DERMATOSES, especially PSORIASIS. It may cause FOLLICULITIS.'),
  'D000876': NtO(MH='Anthramycin', MS='A broad-spectrum spectrum antineoplastic antibiotic isolated from Streptomyces refuineus var. thermotolerans. It has low toxicity, some activity against Trichomonas and Endamoeba, and inhibits RNA and DNA synthesis. It binds irreversibly to DNA.'),
  'D000877': NtO(MH='Anthranilate Phosphoribosyltransferase', MS="An enzyme that catalyzes the formation of N-5'-phosphoribosylanthranilic acid from anthranilate and phosphoribosylpyrophosphate, the first step in tryptophan synthesis in E. coli. It exists in a complex with ANTHRANILATE SYNTHASE in bacteria. EC 2.4.2.18."),
  'D000878': NtO(MH='Anthranilate Synthase', MS='An enzyme that catalyzes the formation of anthranilate (o-aminobenzoate) and pyruvic acid from chorismate and glutamine. Anthranilate is the biosynthetic precursor of tryptophan and numerous secondary metabolites, including inducible plant defense compounds. EC 4.1.3.27.'),
  'D000880': NtO(MH='Anthraquinones', MS='Compounds based on ANTHRACENES which contain two KETONES in any position. Substitutions can be in any position except on the ketone groups.'),
  'D000881': NtO(MH='Anthrax', MS='An acute infection caused by the spore-forming bacteria BACILLUS ANTHRACIS. It commonly affects hoofed animals such as sheep and goats. Infection in humans often involves the skin (cutaneous anthrax), the lungs (inhalation anthrax), or the gastrointestinal tract. Anthrax is not contagious and can be treated with antibiotics.'),
  'D000882': NtO(MH='Haplorhini', MS='A suborder of PRIMATES consisting of six families: CEBIDAE (some New World monkeys), ATELIDAE (some New World monkeys), CERCOPITHECIDAE (Old World monkeys), HYLOBATIDAE (gibbons and siamangs), CALLITRICHINAE (marmosets and tamarins), and HOMINIDAE (humans and great apes).'),
  'D000883': NtO(MH='Anthropology', MS='The science devoted to the comparative study of man.'),
  'D000884': NtO(MH='Anthropology, Cultural', MS='Study of social phenomena which characterize the learned, shared, and transmitted social activities of particular ethnic groups with focus on the causes, consequences, and complexities of human social and cultural variability.'),
  'D000885': NtO(MH='Anthropology, Physical', MS='The comparative science dealing with the physical characteristics of humans as related to their origin, evolution, and development in the total environment.'),
  'D000886': NtO(MH='Anthropometry', MS='The technique that deals with the measurement of the size, weight, and proportions of the human or other primate body.'),
  'D000887': NtO(MH='Anthroposophy', MS='Knowledge of the nature of man. A spiritual and mystical doctrine that grew out of theosophy and derives mainly from the philosophy of Rudolph Steiner, Austrian social philosopher (1861-1925). (Webster, 3d ed)'),
  'D000888': NtO(MH='Antibodies, Anti-Idiotypic', MS='Antibodies which react with the individual structural determinants (idiotopes) on the variable region of other antibodies.'),
  'D000889': NtO(MH='Anti-Arrhythmia Agents', MS='Agents used for the treatment or prevention of cardiac arrhythmias. They may affect the polarization-repolarization phase of the action potential, its excitability or refractoriness, or impulse conduction or membrane responsiveness within cardiac fibers. Anti-arrhythmia agents are often classed into four main groups according to their mechanism of action: sodium channel blockade, beta-adrenergic blockade, repolarization prolongation, or calcium channel blockade.'),
  'D000890': NtO(MH='Anti-Infective Agents', MS='Substances that prevent infectious agents or organisms from spreading or kill infectious agents in order to prevent the spread of infection.'),
  'D000891': NtO(MH='Anti-Infective Agents, Local', MS='Substances used on humans and other animals that destroy harmful microorganisms or inhibit their activity. They are distinguished from DISINFECTANTS, which are used on inanimate objects.'),
  'D000892': NtO(MH='Anti-Infective Agents, Urinary', MS='Substances capable of killing agents causing urinary tract infections or of preventing them from spreading.'),
  'D000893': NtO(MH='Anti-Inflammatory Agents', MS='Substances that reduce or suppress INFLAMMATION.'),
  'D000894': NtO(MH='Anti-Inflammatory Agents, Non-Steroidal', MS='Anti-inflammatory agents that are non-steroidal in nature. In addition to anti-inflammatory actions, they have analgesic, antipyretic, and platelet-inhibitory actions.They act by blocking the synthesis of prostaglandins by inhibiting cyclooxygenase, which converts arachidonic acid to cyclic endoperoxides, precursors of prostaglandins. Inhibition of prostaglandin synthesis accounts for their analgesic, antipyretic, and platelet-inhibitory actions; other mechanisms may contribute to their anti-inflammatory effects.'),
  'D000897': NtO(MH='Anti-Ulcer Agents', MS='Various agents with different action mechanisms used to treat or ameliorate PEPTIC ULCER or irritation of the gastrointestinal tract. This has included ANTIBIOTICS to treat HELICOBACTER INFECTIONS; HISTAMINE H2 ANTAGONISTS to reduce GASTRIC ACID secretion; and ANTACIDS for symptomatic relief.'),
  'D000898': NtO(MH='Antibiosis', MS='A natural association between organisms that is detrimental to at least one of them. This often refers to the production of chemicals by one microorganism that is harmful to another.'),
  'D000899': NtO(MH='Aurodox', MS='Antibiotic obtained from a Streptomyces variant considered as possibly effective against Streptococcus pyogenes infections. It may promote growth in poultry.'),
  'D000900': NtO(MH='Anti-Bacterial Agents', MS='Substances that inhibit the growth or reproduction of BACTERIA.'),
  'D000903': NtO(MH='Antibiotics, Antineoplastic', MS='Chemical substances, produced by microorganisms, inhibiting or preventing the proliferation of neoplasms.'),
  'D000904': NtO(MH='Antibiotics, Antitubercular', MS='Substances obtained from various species of microorganisms that are, alone or in combination with other agents, of use in treating various forms of tuberculosis; most of these agents are merely bacteriostatic, induce resistance in the organisms, and may be toxic.'),
  'D000906': NtO(MH='Antibodies', MS='Immunoglobulin molecules having a specific amino acid sequence by virtue of which they interact only with the ANTIGEN (or a very similar shape) that induced their synthesis in cells of the lymphoid series (especially PLASMA CELLS).'),
  'D000907': NtO(MH='Antibodies, Bacterial', MS='Immunoglobulins produced in a response to BACTERIAL ANTIGENS.'),
  'D000908': NtO(MH='Antibodies, Fungal', MS='Immunoglobulins produced in a response to FUNGAL ANTIGENS.'),
  'D000909': NtO(MH='Antibodies, Helminth', MS='Immunoglobulins produced in a response to HELMINTH ANTIGENS.'),
  'D000910': NtO(MH='Antibodies, Heterophile', MS='Antibodies elicited in a different species from which the antigen originated. These antibodies are directed against a wide variety of interspecies-specific antigens, the best known of which are Forssman, Hanganutziu-Deicher (H-D), and Paul-Bunnell (P-B). Incidence of antibodies to these antigens--i.e., the phenomenon of heterophile antibody response--is useful in the serodiagnosis, pathogenesis, and prognosis of infection and latent infectious states as well as in cancer classification.'),
  'D000911': NtO(MH='Antibodies, Monoclonal', MS='Antibodies produced by a single clone of cells.'),
  'D000912': NtO(MH='Antibodies, Neoplasm', MS='Immunoglobulins induced by antigens specific for tumors other than the normally occurring HISTOCOMPATIBILITY ANTIGENS.'),
  'D000913': NtO(MH='Antibodies, Protozoan', MS='Immunoglobulins produced in a response to PROTOZOAN ANTIGENS.'),
  'D000914': NtO(MH='Antibodies, Viral', MS='Immunoglobulins produced in response to VIRAL ANTIGENS.'),
  'D000915': NtO(MH='Antibody Affinity', MS='A measure of the binding strength between antibody and a simple hapten or antigen determinant. It depends on the closeness of stereochemical fit between antibody combining sites and antigen determinants, on the size of the area of contact between them, and on the distribution of charged and hydrophobic groups. It includes the concept of "avidity," which refers to the strength of the antigen-antibody bond after formation of reversible complexes.'),
  'D000916': NtO(MH='Antibody Diversity', MS='The phenomenon of immense variability characteristic of ANTIBODIES. It enables the IMMUNE SYSTEM to react specifically against the essentially unlimited kinds of ANTIGENS it encounters. Antibody diversity is accounted for by three main theories: (1) the Germ Line Theory, which holds that each antibody-producing cell has genes coding for all possible antibody specificities, but expresses only the one stimulated by antigen; (2) the Somatic Mutation Theory, which holds that antibody-producing cells contain only a few genes, which produce antibody diversity by mutation; and (3) the Gene Rearrangement Theory, which holds that antibody diversity is generated by the rearrangement of IMMUNOGLOBULIN VARIABLE REGION gene segments during the differentiation of the ANTIBODY-PRODUCING CELLS.'),
  'D000917': NtO(MH='Antibody Formation', MS='The production of ANTIBODIES by proliferating and differentiated B-LYMPHOCYTES under stimulation by ANTIGENS.'),
  'D000918': NtO(MH='Antibody Specificity', MS='The property of antibodies which enables them to react with some ANTIGENIC DETERMINANTS and not with others. Specificity is dependent on chemical composition, physical forces, and molecular structure at the binding site.'),
  'D000919': NtO(MH='Antibody-Coated Bacteria Test, Urinary', MS='Fluorescent antibody technique for visualizing antibody-bacteria complexes in urine. The presence or absence of antibody-coated bacteria in urine correlates with localization of urinary tract infection in the kidney or bladder, respectively.'),
  'D000920': NtO(MH='Antibody-Dependent Cell Cytotoxicity', MS='The phenomenon of antibody-mediated target cell destruction by non-sensitized effector cells. The identity of the target cell varies, but it must possess surface IMMUNOGLOBULIN G whose Fc portion is intact. The effector cell is a "killer" cell possessing Fc receptors. It may be a lymphocyte lacking conventional B- or T-cell markers, or a monocyte, macrophage, or polynuclear leukocyte, depending on the identity of the target cell. The reaction is complement-independent.'),
  'D000921': NtO(MH='Antibody-Producing Cells', MS='Cells of the lymphoid series that can react with antigen to produce specific cell products called antibodies. Various cell subpopulations, often B-lymphocytes, can be defined, based on the different classes of immunoglobulins that they synthesize.'),
  'D000922': NtO(MH='Immunotoxins', MS='Semisynthetic conjugates of various toxic molecules, including RADIOACTIVE ISOTOPES and bacterial or plant toxins, with specific immune substances such as IMMUNOGLOBULINS; MONOCLONAL ANTIBODIES; and ANTIGENS. The antitumor or antiviral immune substance carries the toxin to the tumor or infected cell where the toxin exerts its poisonous effect.'),
  'D000923': NtO(MH='Anticestodal Agents', MS='Agents used to treat tapeworm infestations in man or animals.'),
  'D000924': NtO(MH='Anticholesteremic Agents', MS='Substances used to lower plasma CHOLESTEROL levels.'),
  'D000925': NtO(MH='Anticoagulants', MS='Agents that prevent BLOOD CLOTTING.'),
  'D000926': NtO(MH='Anticodon', MS='The sequential set of three nucleotides in TRANSFER RNA that interacts with its complement in MESSENGER RNA, the CODON, during translation in the ribosome.'),
  'D000927': NtO(MH='Anticonvulsants', MS='Drugs used to prevent SEIZURES or reduce their severity.'),
  'D000928': NtO(MH='Antidepressive Agents', MS='Mood-stimulating drugs used primarily in the treatment of affective disorders and related conditions. Several MONOAMINE OXIDASE INHIBITORS are useful as antidepressants apparently as a long-term consequence of their modulation of catecholamine levels. The tricyclic compounds useful as antidepressive agents (ANTIDEPRESSIVE AGENTS, TRICYCLIC) also appear to act through brain catecholamine systems. A third group (ANTIDEPRESSIVE AGENTS, SECOND-GENERATION) is a diverse group of drugs including some that act specifically on serotonergic systems.'),
  'D000929': NtO(MH='Antidepressive Agents, Tricyclic', MS='Substances that contain a fused three-ring moiety and are used in the treatment of depression. These drugs block the uptake of norepinephrine and serotonin into axon terminals and may block some subtypes of serotonin, adrenergic, and histamine receptors. However the mechanism of their antidepressant effects is not clear because the therapeutic effects usually take weeks to develop and may reflect compensatory changes in the central nervous system.'),
  'D000930': NtO(MH='Antidiarrheals', MS='Miscellaneous agents found useful in the symptomatic treatment of diarrhea. They have no effect on the agent(s) that cause diarrhea, but merely alleviate the condition.'),
  'D000931': NtO(MH='Antidotes', MS='Agents counteracting or neutralizing the action of POISONS.'),
  'D000932': NtO(MH='Antiemetics', MS='Drugs used to prevent NAUSEA or VOMITING.'),
  'D000933': NtO(MH='Antifibrinolytic Agents', MS='Agents that prevent fibrinolysis or lysis of a blood clot or thrombus. Several endogenous antiplasmins are known. The drugs are used to control massive hemorrhage and in other coagulation disorders.'),
  'D000934': NtO(MH='Antifoaming Agents', MS='Agents used to prevent the formation of foam or to treat flatulence or bloat.'),
  'D000935': NtO(MH='Antifungal Agents', MS='Substances that destroy fungi by suppressing their ability to grow or reproduce. They differ from FUNGICIDES, INDUSTRIAL because they defend against fungi present in human or animal tissues.'),
  'D000936': NtO(MH='Antigen-Antibody Complex', MS='The complex formed by the binding of antigen and antibody molecules. The deposition of large antigen-antibody complexes leading to tissue damage causes IMMUNE COMPLEX DISEASES.'),
  'D000937': NtO(MH='Antigen-Antibody Reactions', MS='The processes triggered by interactions of ANTIBODIES with their ANTIGENS.'),
  'D000938': NtO(MH='Antigen-Presenting Cells', MS='A heterogeneous group of immunocompetent cells that mediate the cellular immune response by processing and presenting antigens to the T-cells. Traditional antigen-presenting cells include MACROPHAGES; DENDRITIC CELLS; LANGERHANS CELLS; and B-LYMPHOCYTES. FOLLICULAR DENDRITIC CELLS are not traditional antigen-presenting cells, but because they hold antigen on their cell surface in the form of IMMUNE COMPLEXES for B-cell recognition they are considered so by some authors.'),
  'D000939': NtO(MH='Epitopes', MS='Sites on an antigen that interact with specific antibodies.'),
  'D000940': NtO(MH='Antigenic Variation', MS='Change in the surface ANTIGEN of a microorganism. There are two different types. One is a phenomenon, especially associated with INFLUENZA VIRUSES, where they undergo spontaneous variation both as slow antigenic drift and sudden emergence of new strains (antigenic shift). The second type is when certain PARASITES, especially trypanosomes, PLASMODIUM, and BORRELIA, survive the immune response of the host by changing the surface coat (antigen switching). (From Herbert et al., The Dictionary of Immunology, 4th ed)'),
  'D000941': NtO(MH='Antigens', MS='Substances that are recognized by the immune system and induce an immune reaction.'),
  'D000942': NtO(MH='Antigens, Bacterial', MS='Substances elaborated by bacteria that have antigenic activity.'),
  'D000943': NtO(MH='Antigens, Differentiation', MS='Antigens expressed primarily on the membranes of living cells during sequential stages of maturation and differentiation. As immunologic markers they have high organ and tissue specificity and are useful as probes in studies of normal cell development as well as neoplastic transformation.'),
  'D000944': NtO(MH='Antigens, Differentiation, B-Lymphocyte', MS='Membrane antigens associated with maturation stages of B-lymphocytes, often expressed in tumors of B-cell origin.'),
  'D000945': NtO(MH='Antigens, Differentiation, T-Lymphocyte', MS='Antigens expressed on the cell membrane of T-lymphocytes during differentiation, activation, and normal and neoplastic transformation. Their phenotypic characterization is important in differential diagnosis and studies of thymic ontogeny and T-cell function.'),
  'D000946': NtO(MH='Antigens, Fungal', MS='Substances of fungal origin that have antigenic activity.'),
  'D000947': NtO(MH='Antigens, Helminth', MS='Any part or derivative of a helminth that elicits an immune reaction. The most commonly seen helminth antigens are those of the schistosomes.'),
  'D000949': NtO(MH='Histocompatibility Antigens Class II', MS='Large, transmembrane, non-covalently linked glycoproteins (alpha and beta). Both chains can be polymorphic although there is more structural variation in the beta chains. The class II antigens in humans are called HLA-D ANTIGENS and are coded by a gene on chromosome 6. In mice, two genes named IA and IE on chromosome 17 code for the H-2 antigens. The antigens are found on B-lymphocytes, macrophages, epidermal cells, and sperm and are thought to mediate the competence of and cellular cooperation in the immune response. The term IA antigens used to refer only to the proteins encoded by the IA genes in the mouse, but is now used as a generic term for any class II histocompatibility antigen.'),
  'D000950': NtO(MH='Antigens, Ly', MS='A group of lymphocyte surface antigens located on mouse LYMPHOCYTES. Specific Ly antigens are useful markers for distinguishing subpopulations of lymphocytes.'),
  'D000951': NtO(MH='Antigens, Neoplasm', MS='Proteins, glycoprotein, or lipoprotein moieties on surfaces of tumor cells that are usually identified by monoclonal antibodies. Many of these are of either embryonic or viral origin.'),
  'D000952': NtO(MH='Antigens, Polyomavirus Transforming', MS='Polyomavirus antigens which cause infection and cellular transformation. The large T antigen is necessary for the initiation of viral DNA synthesis, repression of transcription of the early region and is responsible in conjunction with the middle T antigen for the transformation of primary cells. Small T antigen is necessary for the completion of the productive infection cycle.'),
  'D000953': NtO(MH='Antigens, Protozoan', MS='Any part or derivative of any protozoan that elicits immunity; malaria (Plasmodium) and trypanosome antigens are presently the most frequently encountered.'),
  'D000954': NtO(MH='Antigens, Surface', MS='Antigens on surfaces of cells, including infectious or foreign cells or viruses. They are usually protein-containing groups on cell membranes or walls and may be isolated.'),
  'D000955': NtO(MH='Antigens, T-Independent', MS='Antigens which may directly stimulate B lymphocytes without the cooperation of T lymphocytes.'),
  'D000956': NtO(MH='Antigens, Viral', MS='Substances elaborated by viruses that have antigenic activity.'),
  'D000957': NtO(MH='Antigens, Viral, Tumor', MS='Those proteins recognized by antibodies from serum of animals bearing tumors induced by viruses; these proteins are presumably coded for by the nucleic acids of the same viruses that caused the neoplastic transformation.'),
  'D000958': NtO(MH='Antigua and Barbuda', MS='Islands in the Lesser Antilles, within the Leeward Islands. ANTIGUA, BARBUDA, and Redonda, an uninhabited island, constitute the independent state of ANTIGUA AND BARBUDA. The capital is St. Johns.'),
  'D000959': NtO(MH='Antihypertensive Agents', MS='Drugs used in the treatment of acute or chronic vascular HYPERTENSION regardless of pharmacological mechanism. Among the antihypertensive agents are DIURETICS; (especially DIURETICS, THIAZIDE); ADRENERGIC BETA-ANTAGONISTS; ADRENERGIC ALPHA-ANTAGONISTS; ANGIOTENSIN-CONVERTING ENZYME INHIBITORS; CALCIUM CHANNEL BLOCKERS; GANGLIONIC BLOCKERS; and VASODILATOR AGENTS.'),
  'D000960': NtO(MH='Hypolipidemic Agents', MS='Substances that lower the levels of certain LIPIDS in the BLOOD. They are used to treat HYPERLIPIDEMIAS.'),
  'D000961': NtO(MH='Antilymphocyte Serum', MS='Serum containing GAMMA-GLOBULINS which are antibodies for lymphocyte ANTIGENS. It is used both as a test for HISTOCOMPATIBILITY and therapeutically in TRANSPLANTATION.'),
  'D000962': NtO(MH='Antimalarials', MS='Agents used in the treatment of malaria. They are usually classified on the basis of their action against plasmodia at different stages in their life cycle in the human. (From AMA, Drug Evaluations Annual, 1992, p1585)'),
  'D000963': NtO(MH='Antimetabolites', MS='Drugs that are chemically similar to naturally occurring metabolites, but differ enough to interfere with normal metabolic pathways. (From AMA Drug Evaluations Annual, 1994, p2033)'),
  'D000964': NtO(MH='Antimetabolites, Antineoplastic', MS='Antimetabolites that are useful in cancer chemotherapy.'),
  'D000965': NtO(MH='Antimony', MS='A metallic element that has the atomic symbol Sb, atomic number 51, and atomic weight 121.75. It is used as a metal alloy and as medicinal and poisonous salts. It is toxic and an irritant to the skin and the mucous membranes.'),
  'D000966': NtO(MH='Antimony Potassium Tartrate', MS='A schistosomicide possibly useful against other parasites. It has irritant emetic properties and may cause lethal cardiac toxicity among other adverse effects.'),
  'D000967': NtO(MH='Antimony Sodium Gluconate', MS='Antimony complex where the metal may exist in either the pentavalent or trivalent states. The pentavalent gluconate is used in leishmaniasis. The trivalent gluconate is most frequently used in schistosomiasis.'),
  'D000968': NtO(MH='Antimycin A', MS='An antibiotic substance produced by Streptomyces species. It inhibits mitochondrial respiration and may deplete cellular levels of ATP. Antimycin A1 has been used as a fungicide, insecticide, and miticide. (From Merck Index, 12th ed)'),
  'D000969': NtO(MH='Antinematodal Agents', MS='Substances used in the treatment or control of nematode infestations. They are used also in veterinary practice.'),
  'D000970': NtO(MH='Antineoplastic Agents', MS='Substances that inhibit or prevent the proliferation of NEOPLASMS.'),
  'D000971': NtO(MH='Antineoplastic Combined Chemotherapy Protocols', MS='The use of two or more chemicals simultaneously or sequentially in the drug therapy of neoplasms. The drugs need not be in the same dosage form.'),
  'D000972': NtO(MH='Antineoplastic Agents, Phytogenic', MS='Agents obtained from higher plants that have demonstrable cytostatic or antineoplastic activity.'),
  'D000974': NtO(MH='Antibodies, Antinuclear', MS="Autoantibodies directed against various nuclear antigens including DNA, RNA, histones, acidic nuclear proteins, or complexes of these molecular elements. Antinuclear antibodies are found in systemic autoimmune diseases including systemic lupus erythematosus, Sjogren's syndrome, scleroderma, polymyositis, and mixed connective tissue disease."),
  'D000975': NtO(MH='Antioxidants', MS='Naturally occurring or synthetic substances that inhibit or retard oxidation reactions. They counteract the damaging effects of oxidation in animal tissues.'),
  'D000976': NtO(MH='Antipain', MS='An oligopeptide produced by various bacteria which acts as a protease inhibitor.'),
  'D000977': NtO(MH='Antiparasitic Agents', MS='Drugs used to treat or prevent parasitic infections.'),
  'D000978': NtO(MH='Antiparkinson Agents', MS="Agents used in the treatment of Parkinson's disease. The most commonly used drugs act on the dopaminergic system in the striatum and basal ganglia or are centrally acting muscarinic antagonists."),
  'D000979': NtO(MH='alpha-2-Antiplasmin', MS='A member of the serpin superfamily found in plasma that inhibits the lysis of fibrin clots which are induced by plasminogen activator. It is a glycoprotein, molecular weight approximately 70,000 that migrates in the alpha 2 region in immunoelectrophoresis. It is the principal plasmin inactivator in blood, rapidly forming a very stable complex with plasmin.'),
  'D000980': NtO(MH='Antiplatyhelmintic Agents', MS='Agents used to treat cestode, trematode, or other flatworm infestations in man or animals.'),
  'D000981': NtO(MH='Antiprotozoal Agents', MS='Substances that are destructive to protozoans.'),
  'D000982': NtO(MH='Antipruritics', MS='Agents, usually topical, that relieve itching (pruritus).'),
  'D000983': NtO(MH='Antipyrine', MS='An analgesic and antipyretic that has been given by mouth and as ear drops. Antipyrine is often used in testing the effects of other drugs or diseases on drug-metabolizing enzymes in the liver. (From Martindale, The Extra Pharmacopoeia, 30th ed, p29)'),
  'D000985': NtO(MH='Antisepsis', MS='The destruction of germs causing disease.'),
  'D000986': NtO(MH='Antisickling Agents', MS='Agents used to prevent or reverse the pathological events leading to sickling of erythrocytes in sickle cell conditions.'),
  'D000987': NtO(MH='Antisocial Personality Disorder', MS='A personality disorder whose essential feature is a pervasive pattern of disregard for, and violation of, the rights of others that begins in childhood or early adolescence and continues into adulthood. The individual must be at least age 18 and must have a history of some symptoms of CONDUCT DISORDER before age 15. (From DSM-IV, 1994)'),
  'D000988': NtO(MH='Antispermatogenic Agents', MS='Agents, either mechanical or chemical, which destroy spermatozoa in the male genitalia and block spermatogenesis.'),
  'D000989': NtO(MH='Antistreptolysin', MS='Antibodies specific to STREPTOLYSINS which indicate STREPTOCOCCAL INFECTIONS.'),
  'D000990': NtO(MH='Antithrombin III', MS='A plasma alpha 2 glycoprotein that accounts for the major antithrombin activity of normal plasma and also inhibits several other enzymes. It is a member of the serpin superfamily.'),
  'D000991': NtO(MH='Antithrombins', MS='Endogenous factors and drugs that directly inhibit the action of THROMBIN, usually by blocking its enzymatic activity. They are distinguished from INDIRECT THROMBIN INHIBITORS, such as HEPARIN, which act by enhancing the inhibitory effects of antithrombins.'),
  'D000992': NtO(MH='Antitoxins', MS='Antisera from immunized animals that is purified and used as a passive immunizing agent against specific BACTERIAL TOXINS.'),
  'D000993': NtO(MH='Antitreponemal Agents', MS='Agents used to treat infections with bacteria of the genus TREPONEMA. This includes SYPHILIS & YAWS.'),
  'D000994': NtO(MH='Antitrichomonal Agents', MS='Agents used to treat trichomonas infections.'),
  'D000995': NtO(MH='Antitubercular Agents', MS='Drugs used in the treatment of tuberculosis. They are divided into two main classes: "first-line" agents, those with the greatest efficacy and acceptable degrees of toxicity used successfully in the great majority of cases; and "second-line" drugs used in drug-resistant cases or those in which some other patient-related condition has compromised the effectiveness of primary therapy.'),
  'D000996': NtO(MH='Antitussive Agents', MS='Agents that suppress cough. They act centrally on the medullary cough center. EXPECTORANTS, also used in the treatment of cough, act locally.'),
  'D000997': NtO(MH='Antivenins', MS='Antisera used to counteract poisoning by animal VENOMS, especially SNAKE VENOMS.'),
  'D000998': NtO(MH='Antiviral Agents', MS='Agents used in the prophylaxis or therapy of VIRUS DISEASES. Some of the ways they may act include preventing viral replication by inhibiting viral DNA polymerase; binding to specific cell-surface receptors and inhibiting viral penetration or uncoating; inhibiting viral protein synthesis; or blocking late stages of virus assembly.'),
  'D000999': NtO(MH='Antlers', MS='The horn of an animal of the deer family, typically present only in the male. It differs from the HORNS of other animals in being a solid, generally branched bony outgrowth that is shed and renewed annually. The word antler comes from the Latin anteocularis, ante (before) + oculus (eye). (From Webster, 3d ed)'),
  'D001000': NtO(MH='Ants', MS='Insects of the family Formicidae, very common and widespread, probably the most successful of all the insect groups. All ants are social insects, and most colonies contain three castes, queens, males, and workers. Their habits are often very elaborate and a great many studies have been made of ant behavior. Ants produce a number of secretions that function in offense, defense, and communication. (From Borror, et al., An Introduction to the Study of Insects, 4th ed, p676)'),
  'D001001': NtO(MH='Anura', MS='An order of the class Amphibia, which includes several families of frogs and toads. They are characterized by well developed hind limbs adapted for jumping, fused head and trunk and webbed toes. The term "toad" is ambiguous and is properly applied only to the family Bufonidae.'),
  'D001002': NtO(MH='Anuria', MS='Absence of urine formation. It is usually associated with complete bilateral ureteral (URETER) obstruction, complete lower urinary tract obstruction, or unilateral ureteral obstruction when a solitary kidney is present.'),
  'D001003': NtO(MH='Anal Canal', MS='The terminal segment of the LARGE INTESTINE, beginning from the ampulla of the RECTUM and ending at the anus.'),
  'D001004': NtO(MH='Anus Diseases', MS='Diseases involving the ANUS.'),
  'D001005': NtO(MH='Anus Neoplasms', MS='Tumors or cancer of the ANAL CANAL.'),
  'D001006': NtO(MH='Anus, Imperforate', MS='A congenital abnormality characterized by the persistence of the anal membrane, resulting in a thin membrane covering the normal ANAL CANAL. Imperforation is not always complete and is treated by surgery in infancy. This defect is often associated with NEURAL TUBE DEFECTS; MENTAL RETARDATION; and DOWN SYNDROME.'),
  'D001007': NtO(MH='Anxiety', MS='Feelings or emotions of dread, apprehension, and impending disaster but not disabling as with ANXIETY DISORDERS.'),
  'D001008': NtO(MH='Anxiety Disorders', MS='Persistent and disabling ANXIETY.'),
  'D001009': NtO(MH='Anxiety, Castration', MS='Anxiety due to fantasized injuries to or loss of the genitals.'),
  'D001010': NtO(MH='Anxiety, Separation', MS='Anxiety experienced by an individual upon separation from a person or object of particular significance to the individual.'),
  'D001011': NtO(MH='Aorta', MS='The main trunk of the systemic arteries.'),
  'D001012': NtO(MH='Aorta, Abdominal', MS='The aorta from the DIAPHRAGM to the bifurcation into the right and left common iliac arteries.'),
  'D001013': NtO(MH='Aorta, Thoracic', MS='The portion of the descending aorta proceeding from the arch of the aorta and extending to the DIAPHRAGM, eventually connecting to the ABDOMINAL AORTA.'),
  'D001014': NtO(MH='Aortic Aneurysm', MS='An abnormal balloon- or sac-like dilatation in the wall of AORTA.'),
  'D001015': NtO(MH='Aortic Arch Syndromes', MS='Conditions resulting from abnormalities in the arteries branching from the ASCENDING AORTA, the curved portion of the aorta. These syndromes are results of occlusion or abnormal blood flow to the head-neck or arm region leading to neurological defects and weakness in an arm. These syndromes are associated with vascular malformations; ATHEROSCLEROSIS; TRAUMA; and blood clots.'),
  'D001016': NtO(MH='Aortic Bodies', MS='Small clusters of chemoreceptive and supporting cells located near the ARCH OF THE AORTA; the PULMONARY ARTERIES; and the CORONARY ARTERIES. The aortic bodies sense PH; CARBON DIOXIDE; and OXYGEN concentrations in the BLOOD and participate in the control of RESPIRATION. The aortic bodies should not be confused with the PARA-AORTIC BODIES in the abdomen (which are sometimes also called aortic bodies).'),
  'D001017': NtO(MH='Aortic Coarctation', MS='A birth defect characterized by the narrowing of the AORTA that can be of varying degree and at any point from the transverse arch to the iliac bifurcation. Aortic coarctation causes arterial HYPERTENSION before the point of narrowing and arterial HYPOTENSION beyond the narrowed portion.'),
  'D001018': NtO(MH='Aortic Diseases', MS='Pathological processes involving any part of the AORTA.'),
  'D001019': NtO(MH='Aortic Rupture', MS='The tearing or bursting of the wall along any portion of the AORTA, such as thoracic or abdominal. It may result from the rupture of an aneurysm or it may be due to TRAUMA.'),
  'D001020': NtO(MH='Aortic Stenosis, Subvalvular', MS='A pathological constriction occurring in the region below the AORTIC VALVE. It is characterized by restricted outflow from the LEFT VENTRICLE into the AORTA.'),
  'D001021': NtO(MH='Aortic Valve', MS='The valve between the left ventricle and the ascending aorta which prevents backflow into the left ventricle.'),
  'D001022': NtO(MH='Aortic Valve Insufficiency', MS='Pathological condition characterized by the backflow of blood from the ASCENDING AORTA back into the LEFT VENTRICLE, leading to regurgitation. It is caused by diseases of the AORTIC VALVE or its surrounding tissue (aortic root).'),
  'D001023': NtO(MH='Aortic Valve Prolapse', MS='The downward displacement of the cuspal or pointed end of the trileaflet AORTIC VALVE causing misalignment of the cusps. Severe valve distortion can cause leakage and allow the backflow of blood from the ASCENDING AORTA back into the LEFT VENTRICLE, leading to aortic regurgitation.'),
  'D001024': NtO(MH='Aortic Valve Stenosis', MS='A pathological constriction that can occur above (supravalvular stenosis), below (subvalvular stenosis), or at the AORTIC VALVE. It is characterized by restricted outflow from the LEFT VENTRICLE into the AORTA.'),
  'D001025': NtO(MH='Aortitis', MS='Inflammation of the wall of the AORTA.'),
  'D001026': NtO(MH='Coronary Artery Bypass', MS='Surgical therapy of ischemic coronary artery disease achieved by grafting a section of saphenous vein, internal mammary artery, or other substitute between the aorta and the obstructed coronary artery distal to the obstructive lesion.'),
  'D001027': NtO(MH='Aortography', MS='Radiographic visualization of the aorta and its branches by injection of contrast media, using percutaneous puncture or catheterization procedures.'),
  'D001028': NtO(MH='Aortopulmonary Septal Defect', MS='A developmental abnormality in which the spiral (aortopulmonary) septum failed to completely divide the TRUNCUS ARTERIOSUS into ASCENDING AORTA and PULMONARY ARTERY. This abnormal communication between the two major vessels usually lies above their respective valves (AORTIC VALVE; PULMONARY VALVE).'),
  'D001029': NtO(MH='Aotus trivirgatus', MS='A species in the family AOTIDAE, inhabiting the forested regions of Central and South America (from Panama to the Amazon). Vocalizations occur primarily at night when they are active, thus they are also known as Northern night monkeys.'),
  'D001030': NtO(MH='Apamin', MS='A highly neurotoxic polypeptide from the venom of the honey bee (Apis mellifera). It consists of 18 amino acids with two disulfide bridges and causes hyperexcitability resulting in convulsions and respiratory paralysis.'),
  'D001031': NtO(MH='Apatites', MS='A group of phosphate minerals that includes ten mineral species and has the general formula X5(YO4)3Z, where X is usually calcium or lead, Y is phosphorus or arsenic, and Z is chlorine, fluorine, or OH-. (McGraw-Hill Dictionary of Scientific and Technical Terms, 4th ed)'),
  'D001032': NtO(MH='Apazone', MS='An anti-inflammatory agent used in the treatment of rheumatoid arthritis. It also has uricosuric properties and has been used to treat gout.'),
  'D001034': NtO(MH='Apgar Score', MS="A method, developed by Dr. Virginia Apgar, to evaluate a newborn's adjustment to extrauterine life. Five items - heart rate, respiratory effort, muscle tone, reflex irritability, and color - are evaluated 60 seconds after birth and again five minutes later on a scale from 0-2, 0 being the lowest, 2 being normal. The five numbers are added for the Apgar score. A score of 0-3 represents severe distress, 4-7 indicates moderate distress, and a score of 7-10 predicts an absence of difficulty in adjusting to extrauterine life."),
  'D001035': NtO(MH='Aphakia', MS='Absence of crystalline lens totally or partially from field of vision, from any cause except after cataract extraction. Aphakia is mainly congenital or as result of LENS DISLOCATION AND SUBLUXATION.'),
  'D001036': NtO(MH='Aphakia, Postcataract', MS='Absence of the crystalline lens resulting from cataract extraction.'),
  'D001037': NtO(MH='Aphasia', MS='A cognitive disorder marked by an impaired ability to comprehend or express language in its written or spoken form. This condition is caused by diseases which affect the language areas of the dominant hemisphere. Clinical features are used to classify the various subtypes of this condition. General categories include receptive, expressive, and mixed forms of aphasia.'),
  'D001039': NtO(MH='Aphasia, Broca', MS='An aphasia characterized by impairment of expressive LANGUAGE (speech, writing, signs) and relative preservation of receptive language abilities (i.e., comprehension). This condition is caused by lesions of the motor association cortex in the FRONTAL LOBE (BROCA AREA and adjacent cortical and white matter regions).'),
  'D001041': NtO(MH='Aphasia, Wernicke', MS="Impairment in the comprehension of speech and meaning of words, both spoken and written, and of the meanings conveyed by their grammatical relationships in sentences. It is caused by lesions that primarily affect Wernicke's area, which lies in the posterior perisylvian region of the temporal lobe of the dominant hemisphere. (From Brain & Bannister, Clinical Neurology, 7th ed, p141; Kandel et al., Principles of Neural Science, 3d ed, p846)"),
  'D001042': NtO(MH='Aphids', MS='A family (Aphididae) of small insects, in the suborder Sternorrhyncha, that suck the juices of plants. Important genera include Schizaphis and Myzus. The latter is known to carry more than 100 virus diseases between plants.'),
  'D001044': NtO(MH='Aphonia', MS='Complete loss of phonation due to organic disease of the larynx or to nonorganic (i.e., psychogenic) causes.'),
  'D001045': NtO(MH='Aphorisms and Proverbs as Topic', MS='Works about short popular sayings effectively expressing or astutely professing general truths or useful thoughts.'),
  'D001046': NtO(MH='Aphrodisiacs', MS='Chemical agents or ODORANTS that stimulate sexual desires. (McGraw-Hill Dictionary of Scientific and Technical Terms, 4th ed)'),
  'D001047': NtO(MH='Apicoectomy', MS='Excision of the apical portion of a tooth through an opening made in the overlying labial, buccal, or palatal alveolar bone. (Dorland, 28th ed)'),
  'D001048': NtO(MH='Aplysia', MS='An opisthobranch mollusk of the order Anaspidea. It is used frequently in studies of nervous system development because of its large identifiable neurons. Aplysiatoxin and its derivatives are not biosynthesized by Aplysia, but acquired by ingestion of Lyngbya (seaweed) species.'),
  'D001049': NtO(MH='Apnea', MS='A transient absence of spontaneous respiration.'),
  'D001050': NtO(MH='Apocrine Glands', MS='Large, branched, specialized sweat glands that empty into the upper portion of a HAIR FOLLICLE instead of directly onto the SKIN.'),
  'D001051': NtO(MH='Apoenzymes', MS='The protein components of enzyme complexes (HOLOENZYMES). An apoenzyme is the holoenzyme minus any cofactors (ENZYME COFACTORS) or prosthetic groups required for the enzymatic function.'),
  'D001052': NtO(MH='Apoferritins', MS='The protein components of ferritins. Apoferritins are shell-like structures containing nanocavities and ferroxidase activities. Apoferritin shells are composed of 24 subunits, heteropolymers in vertebrates and homopolymers in bacteria. In vertebrates, there are two types of subunits, light chain and heavy chain. The heavy chain contains the ferroxidase activity.'),
  'D001053': NtO(MH='Apolipoproteins', MS='Protein components on the surface of LIPOPROTEINS. They form a layer surrounding the hydrophobic lipid core. There are several classes of apolipoproteins with each playing a different role in lipid transport and LIPID METABOLISM. These proteins are synthesized mainly in the LIVER and the INTESTINES.'),
  'D001054': NtO(MH='Apolipoproteins A', MS='Structural proteins of the alpha-lipoproteins (HIGH DENSITY LIPOPROTEINS), including APOLIPOPROTEIN A-I and APOLIPOPROTEIN A-II. They can modulate the activity of LECITHIN CHOLESTEROL ACYLTRANSFERASE. These apolipoproteins are low in atherosclerotic patients. They are either absent or present in extremely low plasma concentration in TANGIER DISEASE.'),
  'D001055': NtO(MH='Apolipoproteins B', MS='Major structural proteins of triacylglycerol-rich LIPOPROTEINS. There are two forms, apolipoprotein B-100 and apolipoprotein B-48, both derived from a single gene. ApoB-100 expressed in the liver is found in low-density lipoproteins (LIPOPROTEINS, LDL; LIPOPROTEINS, VLDL). ApoB-48 expressed in the intestine is found in CHYLOMICRONS. They are important in the biosynthesis, transport, and metabolism of triacylglycerol-rich lipoproteins. Plasma Apo-B levels are high in atherosclerotic patients but non-detectable in ABETALIPOPROTEINEMIA.'),
  'D001056': NtO(MH='Apolipoproteins C', MS='A group of apolipoproteins that can readily exchange among the various classes of lipoproteins (HDL; VLDL; CHYLOMICRONS). After lipolysis of TRIGLYCERIDES on VLDL and chylomicrons, Apo-C proteins are normally transferred to HDL. The subtypes can modulate remnant binding to receptors, LECITHIN CHOLESTEROL ACYLTRANSFERASE, or LIPOPROTEIN LIPASE.'),
  'D001057': NtO(MH='Apolipoproteins E', MS='A class of protein components which can be found in several lipoproteins including HIGH-DENSITY LIPOPROTEINS; VERY-LOW-DENSITY LIPOPROTEINS; and CHYLOMICRONS. Synthesized in most organs, Apo E is important in the global transport of lipids and cholesterol throughout the body. Apo E is also a ligand for LDL receptors (RECEPTORS, LDL) that mediates the binding, internalization, and catabolism of lipoprotein particles in cells. There are several allelic isoforms (such as E2, E3, and E4). Deficiency or defects in Apo E are causes of HYPERLIPOPROTEINEMIA TYPE III.'),
  'D001058': NtO(MH='Apomorphine', MS='A derivative of morphine that is a dopamine D2 agonist. It is a powerful emetic and has been used for that effect in acute poisoning. It has also been used in the diagnosis and treatment of parkinsonism, but its adverse effects limit its use.'),
  'D001059': NtO(MH='Apoproteins', MS='The protein components of a number of complexes, such as enzymes (APOENZYMES), ferritin (APOFERRITINS), or lipoproteins (APOLIPOPROTEINS).'),
  'D001060': NtO(MH='Aporphines', MS='Dibenzoquinolines derived in plants from (S)-reticuline (BENZYLISOQUINOLINES).'),
  'D001061': NtO(MH='Appalachian Region', MS='A geographical area of the United States with no definite boundaries but comprising northeastern Alabama, northwestern Georgia, northwestern South Carolina, western North Carolina, eastern Kentucky, eastern Tennessee, western Virginia, West Virginia, western Maryland, southwestern Pennsylvania, southern Ohio, and southern New York.'),
  'D001062': NtO(MH='Appendectomy', MS='Surgical removal of the vermiform appendix. (Dorland, 28th ed)'),
  'D001063': NtO(MH='Appendiceal Neoplasms', MS='Tumors or cancer of the APPENDIX.'),
  'D001064': NtO(MH='Appendicitis', MS='Acute inflammation of the APPENDIX. Acute appendicitis is classified as simple, gangrenous, or perforated.'),
  'D001065': NtO(MH='Appendix', MS='A worm-like blind tube extension from the CECUM.'),
  'D001066': NtO(MH='Appetite', MS='Natural recurring desire for food. Alterations may be induced by APPETITE DEPRESSANTS or APPETITE STIMULANTS.'),
  'D001067': NtO(MH='Appetite Depressants', MS='Agents that are used to suppress appetite.'),
  'D001068': NtO(MH='Feeding and Eating Disorders', MS='A group of disorders characterized by physiological and psychological disturbances in appetite or food intake.'),
  'D001069': NtO(MH='Appetite Regulation', MS='Physiologic mechanisms which regulate or control the appetite and food intake.'),
  'D001070': NtO(MH='Appetitive Behavior', MS='Animal searching behavior. The variable introductory phase of an instinctive behavior pattern or sequence, e.g., looking for food, or sequential courtship patterns prior to mating.'),
  'D001071': NtO(MH='Appointments and Schedules', MS='The different methods of scheduling patient visits, appointment systems, individual or group appointments, waiting times, waiting lists for hospitals, walk-in clinics, etc.'),
  'D001072': NtO(MH='Apraxias', MS='A group of cognitive disorders characterized by the inability to perform previously learned skills that cannot be attributed to deficits of motor or sensory function. The two major subtypes of this condition are ideomotor (see APRAXIA, IDEOMOTOR) and ideational apraxia, which refers to loss of the ability to mentally formulate the processes involved with performing an action. For example, dressing apraxia may result from an inability to mentally formulate the act of placing clothes on the body. Apraxias are generally associated with lesions of the dominant PARIETAL LOBE and supramarginal gyrus. (From Adams et al., Principles of Neurology, 6th ed, pp56-7)'),
  'D001073': NtO(MH='Aprindine', MS='A class Ib anti-arrhythmia agent used to manage ventricular and supraventricular arrhythmias.'),
  'D001074': NtO(MH='Propoxur', MS='A carbamate insecticide.'),
  'D001076': NtO(MH='Aptitude', MS='The ability to acquire general or special types of knowledge or skill.'),
  'D001077': NtO(MH='Aptitude Tests', MS="Primarily non-verbal tests designed to predict an individual's future learning ability or performance."),
  'D001078': NtO(MH='APUD Cells', MS='Cells with the capacity to take up and decarboxylate the amine precursors DIHYDROXYPHENYLALANINE or 5-HYDROXYTRYPTOPHAN. This is a property of endocrine cells of neural and non-neural origin. APUDOMA is a general term collectively applied to tumors associated with APUD cells.'),
  'D001079': NtO(MH='Apudoma', MS='A general term collectively applied to tumors associated with the APUD CELLS series, irrespective of their specific identification.'),
  'D001080': NtO(MH='Apurinic Acid', MS='Hydrolysate of DNA in which purine bases have been removed.'),
  'D001081': NtO(MH='Apyrase', MS='A calcium-activated enzyme that catalyzes the hydrolysis of ATP to yield AMP and orthophosphate. It can also act on ADP and other nucleoside triphosphates and diphosphates. EC 3.6.1.5.'),
  'D001082': NtO(MH='Aqueous Humor', MS='The clear, watery fluid which fills the anterior and posterior chambers of the eye. It has a refractive index lower than the crystalline lens, which it surrounds, and is involved in the metabolism of the cornea and the crystalline lens. (Cline et al., Dictionary of Visual Science, 4th ed, p319)'),
  'D001083': NtO(MH='Arabia', MS="The great peninsula of southwest Asia comprising most of the present countries of the Middle East. It has been known since the first millennium B.C. In early times it was divided into Arabia Petraea, the northwest part, the only part ever conquered, becoming a Roman province; Arabia Deserta, the northern part between Syria and Mesopotamia; and Arabia Felix, the main part of the peninsula but by some geographers restricted to modern Yemen. (From Webster's New Geographical Dictionary, 1988, p63)"),
  'D001084': NtO(MH='Vidarabine Phosphate', MS='An adenosine monophosphate analog in which ribose is replaced by an arabinose moiety. It is the monophosphate ester of VIDARABINE with antiviral and possibly antineoplastic properties.'),
  'D001085': NtO(MH='Arabinofuranosylcytosine Triphosphate', MS='A triphosphate nucleotide analog which is the biologically active form of CYTARABINE. It inhibits nuclear DNA synthesis.'),
  'D001086': NtO(MH='Arabinofuranosyluracil', MS='A pyrimidine nucleoside formed in the body by the deamination of CYTARABINE.'),
  'D001087': NtO(MH='Arabinonucleosides', MS='Nucleosides containing arabinose as their sugar moiety.'),
  'D001088': NtO(MH='Arabinonucleotides', MS='Nucleotides containing arabinose as their sugar moiety.'),
  'D001089': NtO(MH='Arabinose', MS=None),
  'D001091': NtO(MH='Arachidonate Lipoxygenases', MS='Enzymes catalyzing the oxidation of arachidonic acid to hydroperoxyarachidonates. These products are then rapidly converted by a peroxidase to hydroxyeicosatetraenoic acids. The positional specificity of the enzyme reaction varies from tissue to tissue. The final lipoxygenase pathway leads to the leukotrienes. EC 1.13.11.- .'),
  'D001092': NtO(MH='Arachidonate 12-Lipoxygenase', MS='An enzyme that catalyzes the oxidation of arachidonic acid to yield 12-hydroperoxyarachidonate (12-HPETE) which is itself rapidly converted by a peroxidase to 12-hydroxy-5,8,10,14-eicosatetraenoate (12-HETE). The 12-hydroperoxides are preferentially formed in PLATELETS.'),
  'D001093': NtO(MH='Arachidonate 15-Lipoxygenase', MS='An enzyme that catalyzes the oxidation of arachidonic acid to yield 15-hydroperoxyarachidonate (15-HPETE) which is rapidly converted to 15-hydroxy-5,8,11,13-eicosatetraenoate (15-HETE). The 15-hydroperoxides are preferentially formed in NEUTROPHILS and LYMPHOCYTES.'),
  'D001094': NtO(MH='Arachidonate 5-Lipoxygenase', MS='An enzyme that catalyzes the oxidation of arachidonic acid to yield 5-hydroperoxyarachidonate (5-HPETE) which is rapidly converted by a peroxidase to 5-hydroxy-6,8,11,14-eicosatetraenoate (5-HETE). The 5-hydroperoxides are preferentially formed in leukocytes.'),
  'D001095': NtO(MH='Arachidonic Acids', MS=None),
  'D001096': NtO(MH='Arachnid Vectors', MS='Members of the class Arachnida, especially SPIDERS; SCORPIONS; MITES; and TICKS; which transmit infective organisms from one host to another or from an inanimate reservoir to an animate host.'),
  'D001097': NtO(MH='Arachnida', MS='A class of Arthropoda that includes SPIDERS; TICKS; MITES; and SCORPIONS.'),
  'D001098': NtO(MH='Spider Bites', MS='The effects, both local and systemic, caused by the bites of SPIDERS.'),
  'D001099': NtO(MH='Arachnoid', MS='A delicate membrane enveloping the brain and spinal cord. It lies between the PIA MATER and the DURA MATER. It is separated from the pia mater by the subarachnoid cavity which is filled with CEREBROSPINAL FLUID.'),
  'D001100': NtO(MH='Arachnoiditis', MS='Acute or chronic inflammation of the arachnoid membrane of the meninges most often involving the spinal cord or base of the brain. This term generally refers to a persistent inflammatory process characterized by thickening of the ARACHNOID membrane and dural adhesions. Associated conditions include prior surgery, infections, trauma, SUBARACHNOID HEMORRHAGE, and chemical irritation. Clinical features vary with the site of inflammation, but include cranial neuropathies, radiculopathies, and myelopathies. (From Joynt, Clinical Neurology, 1997, Ch48, p25)'),
  'D001101': NtO(MH='Arbaprostil', MS='A synthetic prostaglandin E analog that protects the gastric mucosa, prevents ulceration, and promotes healing of peptic ulcers. The protective effect is independent of acid inhibition. It is also a potent inhibitor of pancreatic function and can inhibit the growth of experimental tumors.'),
  'D001102': NtO(MH='Arbovirus Infections', MS='Infections caused by arthropod-borne viruses, general or unspecified.'),
  'D001103': NtO(MH='Arboviruses', MS='Arthropod-borne viruses. A non-taxonomic designation for viruses that can replicate in both vertebrate hosts and arthropod vectors. Included are some members of the following families: ARENAVIRIDAE; BUNYAVIRIDAE; REOVIRIDAE; TOGAVIRIDAE; and FLAVIVIRIDAE. (From Dictionary of Microbiology and Molecular Biology, 2nd ed)'),
  'D001104': NtO(MH='Arbutin', MS=None),
  'D001105': NtO(MH='Archaea', MS='One of the three domains of life (the others being BACTERIA and Eukarya), formerly called Archaebacteria under the taxon Bacteria, but now considered separate and distinct. They are characterized by: (1) the presence of characteristic tRNAs and ribosomal RNAs; (2) the absence of peptidoglycan cell walls; (3) the presence of ether-linked lipids built from branched-chain subunits; and (4) their occurrence in unusual habitats. While archaea resemble bacteria in morphology and genomic organization, they resemble eukarya in their method of genomic replication. The domain contains at least four kingdoms: CRENARCHAEOTA; EURYARCHAEOTA; NANOARCHAEOTA; and KORARCHAEOTA.'),
  'D001106': NtO(MH='Archaeology', MS='Study of the ancient and recent human or animal past through material remains. It analyzes the physical remains of the past in pursuit of a broad and comprehensive understanding of human culture.'),
  'D001107': NtO(MH='Architectural Accessibility', MS='Designs for approaching areas inside or outside facilities.'),
  'D001108': NtO(MH='Architecture', MS='Works on the art and science of designing buildings and structures, design of the total built environment, including town planning, urban design, and landscape architecture.'),
  'D001109': NtO(MH='Archives', MS='A collection of historical documents or records providing information about places, institutions, or groups of people; also the place where such records are kept.'),
  'D001110': NtO(MH='Arctic Regions', MS="The Arctic Ocean and the lands in it and adjacent to it. It includes Point Barrow, Alaska, most of the Franklin District in Canada, two thirds of Greenland, Svalbard, Franz Josef Land, Lapland, Novaya Zemlya, and Northern Siberia. (Webster's New Geographical Dictionary, 1988, p66)"),
  'D001111': NtO(MH='Arcuate Nucleus of Hypothalamus', MS='A nucleus located in the middle hypothalamus in the most ventral part of the THIRD VENTRICLE near the entrance of the infundibular recess. Its small cells are in close contact with the EPENDYMA.'),
  'D001112': NtO(MH='Arcus Senilis', MS='A corneal disease in which there is a deposition of phospholipid and cholesterol in the corneal stroma and anterior sclera.'),
  'D001113': NtO(MH='Area Health Education Centers', MS='Education centers authorized by the Comprehensive Health Manpower Training Act, 1971, for the training of health personnel in areas where health needs are the greatest. May be used for centers other than those established by the United States act.'),
  'D001114': NtO(MH='Areca', MS='A plant genus of the family ARECACEAE. Members contain ARECOLINE and CATECHIN. The leaves and nuts have been used as masticatories, stimulants, and astringents in traditional medicine. The common name of betel is also used for PIPER BETLE. The common name of catechu is sometimes used for ACACIA CATECHU.'),
  'D001115': NtO(MH='Arecoline', MS='An alkaloid obtained from the betel nut (Areca catechu), fruit of a palm tree. It is an agonist at both muscarinic and nicotinic acetylcholine receptors. It is used in the form of various salts as a ganglionic stimulant, a parasympathomimetic, and a vermifuge, especially in veterinary practice. It has been used as a euphoriant in the Pacific Islands.'),
  'D001116': NtO(MH='Arenaviridae', MS='A family of RNA viruses naturally infecting rodents and consisting of one genus (ARENAVIRUS) with two groups: Old World Arenaviruses (ARENAVIRUSES, OLD WORLD) and New World Arenaviruses (ARENAVIRUSES, NEW WORLD). Infection in rodents is persistent and silent. Vertical transmission is through milk-, saliva-, or urine-borne routes. Horizontal transmission to humans, monkeys, and other animals is important.'),
  'D001117': NtO(MH='Arenaviridae Infections', MS='Virus diseases caused by the ARENAVIRIDAE.'),
  'D001118': NtO(MH='Argentina', MS='Country located in southern South America, bordering the South Atlantic Ocean, between Chile and Uruguay.'),
  'D001119': NtO(MH='Arginase', MS='A ureahydrolase that catalyzes the hydrolysis of arginine or canavanine to yield L-ornithine (ORNITHINE) and urea. Deficiency of this enzyme causes HYPERARGININEMIA. EC 3.5.3.1.'),
  'D001120': NtO(MH='Arginine', MS='An essential amino acid that is physiologically active in the L-form.'),
  'D001121': NtO(MH='Lysine Carboxypeptidase', MS='A metallocarboxypeptidase that removes C-terminal basic amino acid from peptides and proteins, with preference shown for lysine over arginine. It is a plasma zinc enzyme that inactivates bradykinin and anaphylatoxins.'),
  'D001122': NtO(MH='Arginine Kinase', MS='An enzyme that catalyzes the phosphorylation of the guanidine nitrogen of arginine in the presence of ATP and a divalent cation with formation of phosphorylarginine and ADP. EC 2.7.3.3.'),
  'D001123': NtO(MH='Argininosuccinate Lyase', MS='An enzyme of the urea cycle which splits argininosuccinate to fumarate plus arginine. Its absence leads to the metabolic disease ARGININOSUCCINIC ACIDURIA in man. EC 4.3.2.1.'),
  'D001124': NtO(MH='Argininosuccinate Synthase', MS='An enzyme of the urea cycle that catalyzes the formation of argininosuccinic acid from citrulline and aspartic acid in the presence of ATP. Absence or deficiency of this enzyme causes the metabolic disease CITRULLINEMIA in humans. EC 6.3.4.5.'),
  'D001125': NtO(MH='Argininosuccinic Acid', MS='This amino acid is formed during the urea cycle from citrulline, aspartate and ATP. This reaction is catalyzed by argininosuccinic acid synthetase.'),
  'D001126': NtO(MH='Arginine-tRNA Ligase', MS='An enzyme that activates arginine with its specific transfer RNA. EC 6.1.1.19.'),
  'D001127': NtO(MH='Arginine Vasopressin', MS='The predominant form of mammalian antidiuretic hormone. It is a nonapeptide containing an ARGININE at residue 8 and two disulfide-linked cysteines at residues of 1 and 6. Arg-vasopressin is used to treat DIABETES INSIPIDUS or to improve vasomotor tone and BLOOD PRESSURE.'),
  'D001128': NtO(MH='Argon', MS='A noble gas with the atomic symbol Ar, atomic number 18, and atomic weight 39.948. It is used in fluorescent tubes and wherever an inert atmosphere is desired and nitrogen cannot be used.'),
  'D001129': NtO(MH='Argyria', MS='A permanent ashen-gray discoloration of the skin, conjunctiva, and internal organs resulting from long-continued use of silver salts. (Dorland, 27th ed)'),
  'D001130': NtO(MH='Arizona', MS='State of the UNITED STATES OF AMERICA bounded on the east by New Mexico, on the north by Utah, on the west by Nevada and California, and on the south by Mexico.'),
  'D001131': NtO(MH='Arkansas', MS='State of the UNITED STATES OF AMERICA bounded on the north by Missouri, on the east by Tennessee and Mississippi, on the south by Louisiana, and on the west by Oklahoma and Texas.'),
  'D001132': NtO(MH='Arm', MS='The superior part of the upper extremity between the SHOULDER and the ELBOW.'),
  'D001133': NtO(MH='Bones of Upper Extremity', MS='The bones of the upper and lower ARM. They include the CLAVICLE and SCAPULA.'),
  'D001134': NtO(MH='Arm Injuries', MS='General or unspecified injuries involving the UPPER ARM and the FOREARM.'),
  'D001135': NtO(MH='Armadillos', MS='Burrowing, chiefly nocturnal mammals of the family Dasypodidae having bodies and heads encased in small bony plates. They are widely distributed in the warmer parts of the Americas.'),
  'D001136': NtO(MH='Armenia', MS="An ancient country in western Asia, by the twentieth century divided among the former USSR, Turkey, and Iran. It was attacked at various times from before the 7th century B.C. to 69 B.C. by Assyrians, Medes, Persians, the Greeks under Alexander, and the Romans. It changed hands frequently in wars between Neo-Persian and Roman Empires from the 3d to 7th centuries and later under Arabs, Seljuks, Byzantines, and Mongols. In the 19th century Armenian nationalism arose but suffered during Russo-Turkish hostilities. It became part of the Soviet Republic in 1921, with part remaining under Turkey. (Webster's New Geographical Dictionary, 1988)"),
  'D001138': NtO(MH='Armin', MS='A reversible organophosphorus cholinesterase inhibitor. It also affects the presynaptic membrane and inhibits membrane postsynaptic cholinergic receptors. The compound had former use as a miotic.'),
  'D001139': NtO(MH='Arnold-Chiari Malformation', MS='A group of congenital malformations involving the brainstem, cerebellum, upper spinal cord, and surrounding bony structures. Type II is the most common, and features compression of the medulla and cerebellar tonsils into the upper cervical spinal canal and an associated MENINGOMYELOCELE. Type I features similar, but less severe malformations and is without an associated meningomyelocele. Type III has the features of type II with an additional herniation of the entire cerebellum through the bony defect involving the foramen magnum, forming an ENCEPHALOCELE. Type IV is a form a cerebellar hypoplasia. Clinical manifestations of types I-III include TORTICOLLIS; opisthotonus; HEADACHE; VERTIGO; VOCAL CORD PARALYSIS; APNEA; NYSTAGMUS, CONGENITAL; swallowing difficulties; and ATAXIA. (From Menkes, Textbook of Child Neurology, 5th ed, p261; Davis, Textbook of Neuropathology, 2nd ed, pp236-46)'),
  'D001140': NtO(MH='Aroclors', MS='Industrial chemicals which have become widespread environmental pollutants. Each aroclor is a mixture of chlorinated biphenyls (1200 series) or chlorinated terphenyls (5400 series) or a combination of both (4400 series).'),
  'D001141': NtO(MH='Aromatase', MS='An enzyme that catalyzes the desaturation (aromatization) of the ring A of C19 androgens and converts them to C18 estrogens. In this process, the 19-methyl is removed. This enzyme is membrane-bound, located in the endoplasmic reticulum of estrogen-producing cells of ovaries, placenta, testes, adipose, and brain tissues. Aromatase is encoded by the CYP19 gene, and functions in complex with NADPH-FERRIHEMOPROTEIN REDUCTASE in the cytochrome P-450 system.'),
  'D001142': NtO(MH='Aromatic-L-Amino-Acid Decarboxylases', MS='An enzyme group with broad specificity. The enzymes decarboxylate a range of aromatic amino acids including dihydroxyphenylalanine (DOPA DECARBOXYLASE); TRYPTOPHAN; and HYDROXYTRYPTOPHAN.'),
  'D001143': NtO(MH='Arousal', MS='Cortical vigilance or readiness of tone, presumed to be in response to sensory stimulation via the reticular activating system.'),
  'D001145': NtO(MH='Arrhythmias, Cardiac', MS='Any disturbances of the normal rhythmic beating of the heart or MYOCARDIAL CONTRACTION. Cardiac arrhythmias can be classified by the abnormalities in HEART RATE, disorders of electrical impulse generation, or impulse conduction.'),
  'D001146': NtO(MH='Arrhythmia, Sinus', MS='Irregular HEART RATE caused by abnormal function of the SINOATRIAL NODE. It is characterized by a greater than 10% change between the maximum and the minimum sinus cycle length or 120 milliseconds.'),
  'D001147': NtO(MH='Arsanilic Acid', MS='An arsenical which has been used as a feed additive for enteric conditions in pigs and poultry. It causes blindness and is ototoxic and nephrotoxic in animals.'),
  'D001148': NtO(MH='Arsenamide', MS='Proposed chemotherapeutic agent against filaria and trichomonas.'),
  'D001149': NtO(MH='Arsenates', MS='Inorganic or organic salts and esters of arsenic acid.'),
  'D001150': NtO(MH='Arsenazo III', MS='Metallochrome indicator that changes color when complexed to the calcium ion under physiological conditions. It is used to measure local calcium ion concentrations in vivo.'),
  'D001151': NtO(MH='Arsenic', MS='A shiny gray element with atomic symbol As, atomic number 33, and atomic weight 75. It occurs throughout the universe, mostly in the form of metallic arsenides. Most forms are toxic. According to the Fourth Annual Report on Carcinogens (NTP 85-002, 1985), arsenic and certain arsenic compounds have been listed as known carcinogens. (From Merck Index, 11th ed)'),
  'D001152': NtO(MH='Arsenicals', MS='Inorganic or organic compounds that contain arsenic.'),
  'D001153': NtO(MH='Arsphenamine', MS='An organoarsenic compound that was commonly used for treating SYPHILIS and other diseases.'),
  'D001154': NtO(MH='Art', MS='Processes and results of aesthetic expression.'),
  'D001155': NtO(MH='Art Therapy', MS='The use of art as an adjunctive therapy in the treatment of neurological, mental, or behavioral disorders.'),
  'D001156': NtO(MH='Artemia', MS='A genus of CRUSTACEA of the order ANOSTRACA, found in briny pools and lakes and often cultured for fish food. It has 168 chromosomes and differs from most crustaceans in that its blood contains hemoglobin.'),
  'D001157': NtO(MH='Arterial Occlusive Diseases', MS='Pathological processes which result in the partial or complete obstruction of ARTERIES. They are characterized by greatly reduced or absence of blood flow through these vessels. They are also known as arterial insufficiency.'),
  'D001158': NtO(MH='Arteries', MS='The vessels carrying blood away from the heart.'),
  'D001159': NtO(MH='Arterio-Arterial Fistula', MS='Abnormal communication between two ARTERIES that may result from injury or occur as a congenital abnormality.'),
  'D001160': NtO(MH='Arterioles', MS='The smallest divisions of the arteries located between the muscular arteries and the capillaries.'),
  'D001161': NtO(MH='Arteriosclerosis', MS='Thickening and loss of elasticity of the walls of ARTERIES of all sizes. There are many forms classified by the types of lesions and arteries involved, such as ATHEROSCLEROSIS with fatty lesions in the ARTERIAL INTIMA of medium and large muscular arteries.'),
  'D001162': NtO(MH='Arteriosclerosis Obliterans', MS='Common occlusive arterial disease which is caused by ATHEROSCLEROSIS. It is characterized by lesions in the innermost layer (ARTERIAL INTIMA) of arteries including the AORTA and its branches to the extremities. Risk factors include smoking, HYPERLIPIDEMIA, and HYPERTENSION.'),
  'D001163': NtO(MH='Arteriovenous Anastomosis', MS='A vessel that directly interconnects an artery and a vein, and that acts as a shunt to bypass the CAPILLARY BEDS. Not to be confused with SURGICAL ANASTOMOSIS or ARTERIOVENOUS FISTULA.'),
  'D001164': NtO(MH='Arteriovenous Fistula', MS='An abnormal direct communication between an artery and a vein without passing through the CAPILLARIES. An A-V fistula usually leads to the formation of a dilated sac-like connection, arteriovenous aneurysm. The locations and size of the shunts determine the degree of effects on the cardiovascular functions such as BLOOD PRESSURE and HEART RATE.'),
  'D001165': NtO(MH='Arteriovenous Malformations', MS='Abnormal formation of blood vessels that shunt arterial blood directly into veins without passing through the CAPILLARIES. They usually are crooked, dilated, and with thick vessel walls. A common type is the congenital arteriovenous fistula. The lack of blood flow and oxygen in the capillaries can lead to tissue damage in the affected areas.'),
  'D001166': NtO(MH='Arteriovenous Shunt, Surgical', MS='Surgical shunt allowing direct passage of blood from an artery to a vein. (From Dorland, 28th ed)'),
  'D001167': NtO(MH='Arteritis', MS='INFLAMMATION of any ARTERIES.'),
  'D001168': NtO(MH='Arthritis', MS='Acute or chronic inflammation of JOINTS.'),
  'D001169': NtO(MH='Arthritis, Experimental', MS='ARTHRITIS that is induced in experimental animals. Immunological methods and infectious agents can be used to develop experimental arthritis models. These methods include injections of stimulators of the immune response, such as an adjuvant (ADJUVANTS, IMMUNOLOGIC) or COLLAGEN.'),
  'D001170': NtO(MH='Arthritis, Infectious', MS='Arthritis caused by BACTERIA; RICKETTSIA; MYCOPLASMA; VIRUSES; FUNGI; or PARASITES.'),
  'D001171': NtO(MH='Arthritis, Juvenile', MS='Arthritis in children, with onset before 16 years of age. The terms juvenile rheumatoid arthritis (JRA) and juvenile idiopathic arthritis (JIA) refer to classification systems for chronic arthritis in children. Only one subtype of juvenile arthritis (polyarticular-onset, rheumatoid factor-positive) clinically resembles adult rheumatoid arthritis and is considered its childhood equivalent.'),
  'D001172': NtO(MH='Arthritis, Rheumatoid', MS='A chronic systemic disease, primarily of the joints, marked by inflammatory changes in the synovial membranes and articular structures, widespread fibrinoid degeneration of the collagen fibers in mesenchymal tissues, and by atrophy and rarefaction of bony structures. Etiology is unknown, but autoimmune mechanisms have been implicated.'),
  'D001173': NtO(MH='Arthrobacter', MS='A genus of asporogenous bacteria isolated from soil that displays a distinctive rod-coccus growth cycle.'),
  'D001174': NtO(MH='Arthrodesis', MS='The surgical fixation of a joint by a procedure designed to accomplish fusion of the joint surfaces by promoting the proliferation of bone cells. (Dorland, 28th ed)'),
  'D001175': NtO(MH='Arthrography', MS='Roentgenography of a joint, usually after injection of either positive or negative contrast medium.'),
  'D001176': NtO(MH='Arthrogryposis', MS='Persistent flexure or contracture of a joint.'),
  'D001177': NtO(MH='Arthropathy, Neurogenic', MS='Chronic progressive degeneration of the stress-bearing portion of a joint, with bizarre hypertrophic changes at the periphery. It is probably a complication of a variety of neurologic disorders, particularly TABES DORSALIS, involving loss of sensation, which leads to relaxation of supporting structures and chronic instability of the joint. (Dorland, 27th ed)'),
  'D001178': NtO(MH='Arthroplasty', MS='Surgical reconstruction of a joint to relieve pain or restore motion.'),
  'D001179': NtO(MH='Arthropod Vectors', MS='Arthropods, other than insects and arachnids, which transmit infective organisms from one host to another or from an inanimate reservoir to an animate host.'),
  'D001180': NtO(MH='Arthropod Venoms', MS='Venoms from animals of the phylum Arthropoda. Those most investigated are from scorpions and spiders of the class Arachnidae and from ant, bee, and wasp families of the Insecta order Hymenoptera. The venoms contain protein toxins, enzymes, and other bioactive substances and may be lethal to man.'),
  'D001181': NtO(MH='Arthropods', MS='Members of the phylum Arthropoda, composed of organisms having a hard, jointed exoskeleton and paired jointed legs. It includes the class INSECTS and the subclass ARACHNIDA, many species of which are important medically as parasites or as vectors of organisms capable of causing disease in man.'),
  'D001182': NtO(MH='Arthroscopy', MS='Endoscopic examination, therapy and surgery of the joint.'),
  'D001183': NtO(MH='Arthus Reaction', MS='A dermal inflammatory reaction produced under conditions of antibody excess, when a second injection of antigen produces intravascular antigen-antibody complexes which bind complement, causing cell clumping, endothelial damage, and vascular necrosis.'),
  'D001184': NtO(MH='Articulation Disorders', MS='Disorders of the quality of speech characterized by the substitution, omission, distortion, and addition of phonemes.'),
  'D001185': NtO(MH='Artificial Intelligence', MS='Theory and development of COMPUTER SYSTEMS which perform tasks that normally require human intelligence. Such tasks may include speech recognition, LEARNING; VISUAL PERCEPTION; MATHEMATICAL COMPUTING; reasoning, PROBLEM SOLVING, DECISION-MAKING, and translation of language.'),
  'D001186': NtO(MH='Artificial Limbs', MS='Prosthetic replacements for arms, legs, and parts thereof.'),
  'D001187': NtO(MH='Artificial Organs', MS='Devices intended to replace non-functioning organs. They may be temporary or permanent. Since they are intended always to function as the natural organs they are replacing, they should be differentiated from PROSTHESES AND IMPLANTS and specific types of prostheses which, though also replacements for body parts, are frequently cosmetic (EYE, ARTIFICIAL) as well as functional (ARTIFICIAL LIMBS).'),
  'D001188': NtO(MH='Artiodactyla', MS='An order of mammals which consists of the even-toed ungulates and includes both RUMINANTS and SWINE.'),
  'D001189': NtO(MH='Aryl Hydrocarbon Hydroxylases', MS='A large group of cytochrome P-450 (heme-thiolate) monooxygenases that complex with NAD(P)H-FLAVIN OXIDOREDUCTASE in numerous mixed-function oxidations of aromatic compounds. They catalyze hydroxylation of a broad spectrum of substrates and are important in the metabolism of steroids, drugs, and toxins such as PHENOBARBITAL, carcinogens, and insecticides.'),
  'D001190': NtO(MH='Arylsulfonates', MS='Organic sulfonic acid esters or salts which contain an aromatic hydrocarbon radical.'),
  'D001191': NtO(MH='Arylamine N-Acetyltransferase', MS='An enzyme that catalyzes the transfer of acetyl groups from ACETYL-COA to arylamines. It can also catalyze acetyl transfer between arylamines without COENZYME A and has a wide specificity for aromatic amines, including SEROTONIN. However, arylamine N-acetyltransferase should not be confused with the enzyme ARYLALKYLAMINE N-ACETYLTRANSFERASE which is also referred to as SEROTONIN ACETYLTRANSFERASE.'),
  'D001192': NtO(MH='Arylsulfatases', MS='Enzymes that catalyze the hydrolysis of a phenol sulfate to yield a phenol and sulfate. Arylsulfatase A, B, and C have been separated. A deficiency of arylsulfatases is one of the causes of metachromatic leukodystrophy (LEUKODYSTROPHY, METACHROMATIC). EC 3.1.6.1.'),
  'D001193': NtO(MH='Arytenoid Cartilage', MS='One of a pair of small pyramidal cartilages that articulate with the lamina of the CRICOID CARTILAGE. The corresponding VOCAL LIGAMENT and several muscles are attached to it.'),
  'D001194': NtO(MH='Asbestos', MS='Asbestos. Fibrous incombustible mineral composed of magnesium and calcium silicates with or without other elements. It is relatively inert chemically and used in thermal insulation and fireproofing. Inhalation of dust causes asbestosis and later lung and gastrointestinal neoplasms.'),
  'D001195': NtO(MH='Asbestosis', MS='A form of pneumoconiosis caused by inhalation of asbestos fibers which elicit potent inflammatory responses in the parenchyma of the lung. The disease is characterized by interstitial fibrosis of the lung, varying from scattered sites to extensive scarring of the alveolar interstitium.'),
  'D001196': NtO(MH='Ascariasis', MS='Infection by nematodes of the genus ASCARIS. Ingestion of infective eggs causes diarrhea and pneumonitis. Its distribution is more prevalent in areas of poor sanitation and where human feces are used for fertilizer.'),
  'D001197': NtO(MH='Ascaridia', MS='A genus of nematode worms in the superfamily Heterakoidea. A. galli and A. lineata are important intestinal parasites of domestic fowl.'),
  'D001198': NtO(MH='Ascaridiasis', MS='Infection with nematodes of the genus ASCARIDIA. This condition usually occurs in fowl, often manifesting diarrhea.'),
  'D001199': NtO(MH='Ascaridoidea', MS='A superfamily of polymyarian nematode worms. An important characteristic of this group is the presence of three prominent lips around the mouth of the organism.'),
  'D001200': NtO(MH='Ascaris', MS='A genus of nematodes of the superfamily ASCARIDOIDEA whose species usually inhabit the intestine.'),
  'D001201': NtO(MH='Ascites', MS='Accumulation or retention of free fluid within the peritoneal cavity.'),
  'D001202': NtO(MH='Ascitic Fluid', MS='The serous fluid of ASCITES, the accumulation of fluids in the PERITONEAL CAVITY.'),
  'D001203': NtO(MH='Ascomycota', MS='A phylum of fungi which have cross-walls or septa in the mycelium. The perfect state is characterized by the formation of a saclike cell (ascus) containing ascospores. Most pathogenic fungi with a known perfect state belong to this phylum.'),
  'D001204': NtO(MH='Ascorbate Oxidase', MS='An enzyme that converts ascorbic acid to dehydroascorbic acid. EC 1.10.3.3.'),
  'D001205': NtO(MH='Ascorbic Acid', MS='A six carbon compound related to glucose. It is found naturally in citrus fruits and many vegetables. Ascorbic acid is an essential nutrient in human diets, and necessary to maintain connective tissue and bone. Its biologically active form, vitamin C, functions as a reducing agent and coenzyme in several metabolic pathways. Vitamin C is considered an antioxidant.'),
  'D001206': NtO(MH='Ascorbic Acid Deficiency', MS="A condition due to a dietary deficiency of ascorbic acid (vitamin C), characterized by malaise, lethargy, and weakness. As the disease progresses, joints, muscles, and subcutaneous tissues may become the sites of hemorrhage. Ascorbic acid deficiency frequently develops into SCURVY in young children fed unsupplemented cow's milk exclusively during their first year. It develops also commonly in chronic alcoholism. (Cecil Textbook of Medicine, 19th ed, p1177)"),
  'D001207': NtO(MH='Asepsis', MS='The prevention of access by infecting organisms to the locus of potential infection.'),
  'D001208': NtO(MH='Asia', MS="The largest of the continents. It was known to the Romans more specifically as what we know today as Asia Minor. The name comes from at least two possible sources: from the Assyrian asu (to rise) or from the Sanskrit usa (dawn), both with reference to its being the land of the rising sun, i.e., eastern as opposed to Europe, to the west. (From Webster's New Geographical Dictionary, 1988, p82 & Room, Brewer's Dictionary of Names, 1992, p34)"),
  'D001209': NtO(MH='Asia, Central', MS="The geographical area of Asia comprising KAZAKHSTAN; KYRGYZSTAN; TAJIKISTAN; TURKMENISTAN; and UZBEKISTAN. The desert region of Kara Kum (Qara Qum) is largely in Turkmenistan and the desert region of Kyzyl Kum (Kizil Kum or Qizil Qum), is in Uzbekistan and Kazakhstan. (From Webster's New Geographical Dictionary, 1988, p233, 590, 636)"),
  'D001210': NtO(MH='Asia, Southeastern', MS='The geographical area of Asia comprising BORNEO; BRUNEI; CAMBODIA; INDONESIA; LAOS; MALAYSIA; the MEKONG VALLEY; MYANMAR (formerly Burma), the PHILIPPINES; SINGAPORE; THAILAND; and VIETNAM.'),
  'D001211': NtO(MH='Asia, Western', MS="The geographical designation for the countries of the MIDDLE EAST and the countries BANGLADESH; BHUTAN; INDIA; NEPAL; PAKISTAN; and SRI LANKA. (From Random House Unabridged Dictionary, 2d ed, 1993 & Webster's New Geographical Dictionary, 1988)"),
  'D001212': NtO(MH='Asialoglycoproteins', MS='Endogenous glycoproteins from which SIALIC ACID has been removed by the action of sialidases. They bind tightly to the ASIALOGLYCOPROTEIN RECEPTOR which is located on hepatocyte plasma membranes. After internalization by adsorptive ENDOCYTOSIS they are delivered to LYSOSOMES for degradation. Therefore receptor-mediated clearance of asialoglycoproteins is an important aspect of the turnover of plasma glycoproteins. They are elevated in serum of patients with HEPATIC CIRRHOSIS or HEPATITIS.'),
  'D001213': NtO(MH='Asian Americans', MS='Persons living in the United States having origins in any of the original peoples of the Far East, Southeast Asia, or the Indian subcontinent.'),
  'D001215': NtO(MH='Asparaginase', MS='A hydrolase enzyme that converts L-asparagine and water to L-aspartate and NH3. EC 3.5.1.1.'),
  'D001216': NtO(MH='Asparagine', MS='A non-essential amino acid that is involved in the metabolic control of cell functions in nerve and brain tissue. It is biosynthesized from ASPARTIC ACID and AMMONIA by asparagine synthetase. (From Concise Encyclopedia Biochemistry and Molecular Biology, 3rd ed)'),
  'D001217': NtO(MH='Aspartate-Ammonia Ligase', MS='An enzyme that catalyzes the formation of asparagine from ammonia and aspartic acid, in the presence of ATP. EC 6.3.1.1.'),
  'D001218': NtO(MH='Aspartame', MS='Flavoring agent sweeter than sugar, metabolized as PHENYLALANINE and ASPARTIC ACID.'),
  'D001219': NtO(MH='Aspartate Aminotransferases', MS='Enzymes of the transferase class that catalyze the conversion of L-aspartate and 2-ketoglutarate to oxaloacetate and L-glutamate. EC 2.6.1.1.'),
  'D001220': NtO(MH='Aspartate Ammonia-Lyase', MS='An enzyme that catalyzes the conversion of aspartic acid to ammonia and fumaric acid in plants and some microorganisms. EC 4.3.1.1.'),
  'D001221': NtO(MH='Aspartate Carbamoyltransferase', MS='An enzyme that catalyzes the conversion of carbamoyl phosphate and L-aspartate to yield orthophosphate and N-carbamoyl-L-aspartate. (From Enzyme Nomenclature, 1992) EC 2.1.3.2.'),
  'D001222': NtO(MH='Aspartate Kinase', MS='An enzyme that catalyzes the formation of beta-aspartyl phosphate from aspartic acid and ATP. Threonine serves as an allosteric regulator of this enzyme to control the biosynthetic pathway from aspartic acid to threonine. EC 2.7.2.4.'),
  'D001223': NtO(MH='Aspartate-Semialdehyde Dehydrogenase', MS='An enzyme that catalyzes the conversion of L-aspartate 4-semialdehyde, orthophosphate, and NADP+ to yield L-4-aspartyl phosphate and NADPH. EC 1.2.1.11.'),
  'D001224': NtO(MH='Aspartic Acid', MS='One of the non-essential amino acids commonly occurring in the L-form. It is found in animals and plants, especially in sugar cane and sugar beets. It may be a neurotransmitter.'),
  'D001225': NtO(MH='Aspartokinase Homoserine Dehydrogenase', MS='A bifunctional protein consisting of aspartokinase, and homoserine dehydrogenase activities. It is found primarily in BACTERIA and in PLANTS.'),
  'D001226': NtO(MH='Aspartate-tRNA Ligase', MS='An enzyme that activates aspartic acid with its specific transfer RNA. EC 6.1.1.12.'),
  'D001227': NtO(MH='Aspartylglucosylaminase', MS='An enzyme that catalyzes the conversion of N(4)-(beta-N-acetyl-D-glucosaminyl)-L-asparagine and water to N-acetyl-beta-D-glucosaminylamine and L-aspartate. It acts only on asparagine-oligosaccharides containing one amino acid, i.e. the ASPARAGINE has free alpha-amino and alpha-carboxyl groups. (From Enzyme Nomenclature, 1992)'),
  'D001228': NtO(MH='Aspergillosis', MS='Infections with fungi of the genus ASPERGILLUS.'),
  'D001229': NtO(MH='Aspergillosis, Allergic Bronchopulmonary', MS='Hypersensitivity reaction (ALLERGIC REACTION) to fungus ASPERGILLUS in an individual with long-standing BRONCHIAL ASTHMA. It is characterized by pulmonary infiltrates, EOSINOPHILIA, elevated serum IMMUNOGLOBULIN E, and skin reactivity to Aspergillus antigen.'),
  'D001230': NtO(MH='Aspergillus', MS='A genus of mitosporic fungi containing about 100 species and eleven different teleomorphs in the family Trichocomaceae.'),
  'D001231': NtO(MH='Aspergillus flavus', MS='A species of imperfect fungi which grows on peanuts and other plants and produces the carcinogenic substance aflatoxin. It is also used in the production of the antibiotic flavicin.'),
  'D001232': NtO(MH='Aspergillus fumigatus', MS='A species of imperfect fungi from which the antibiotic fumigatin is obtained. Its spores may cause respiratory infection in birds and mammals.'),
  'D001233': NtO(MH='Aspergillus nidulans', MS='A species of imperfect fungi from which the antibiotic nidulin is obtained. Its teleomorph is Emericella nidulans.'),
  'D001234': NtO(MH='Aspergillus niger', MS='An imperfect fungus causing smut or black mold of several fruits, vegetables, etc.'),
  'D001235': NtO(MH='Aspergillus ochraceus', MS='An imperfect fungus that produces ochratoxins and contaminates EDIBLE GRAIN and coffee beans.'),
  'D001236': NtO(MH='Aspergillus oryzae', MS='An imperfect fungus present on most agricultural seeds and often responsible for the spoilage of seeds in bulk storage. It is also used in the production of fermented food or drink, especially in Japan.'),
  'D001237': NtO(MH='Asphyxia', MS='A pathological condition caused by lack of oxygen, manifested in impending or actual cessation of life.'),
  'D001238': NtO(MH='Asphyxia Neonatorum', MS='Respiratory failure in the newborn. (Dorland, 27th ed)'),
  'D001239': NtO(MH='Inhalation', MS='The act of BREATHING in.'),
  'D001240': NtO(MH='Aspirations, Psychological', MS='Strong desires to accomplish something. This usually pertains to greater values or high ideals.'),
  'D001241': NtO(MH='Aspirin', MS='The prototypical analgesic used in the treatment of mild to moderate pain. It has anti-inflammatory and antipyretic properties and acts as an inhibitor of cyclooxygenase which results in the inhibition of the biosynthesis of prostaglandins. Aspirin also inhibits platelet aggregation and is used in the prevention of arterial and venous thrombosis. (From Martindale, The Extra Pharmacopoeia, 30th ed, p5)'),
  'D001242': NtO(MH='Assertiveness', MS='Strongly insistent, self-assured, and demanding behavior.'),
  'D001243': NtO(MH='Assisted Circulation', MS='Pumping that aids the natural activity of the heart. (Dorland, 27th ed)'),
  'D001244': NtO(MH='Association', MS='A functional relationship between psychological phenomena of such nature that the presence of one tends to evoke the other; also, the process by which such a relationship is established.'),
  'D001245': NtO(MH='Association Learning', MS='The principle that items experienced together enter into a connection, so that one tends to reinstate the other.'),
  'D001246': NtO(MH='Astatine', MS='Astatine. A radioactive halogen with the atomic symbol At, and atomic number 85. Its isotopes range in mass number from 200 to 219 and all have an extremely short half-life. Astatine may be of use in the treatment of hyperthyroidism because it emits ALPHA PARTICLES.'),
  'D001247': NtO(MH='Asthenia', MS='Clinical sign or symptom manifested as debility, or lack or loss of strength and energy.'),
  'D001248': NtO(MH='Asthenopia', MS='Term generally used to describe complaints related to refractive error, ocular muscle imbalance, including pain or aching around the eyes, burning and itchiness of the eyelids, ocular fatigue, and headaches.'),
  'D001249': NtO(MH='Asthma', MS='A form of bronchial disorder with three distinct components: airway hyper-responsiveness (RESPIRATORY HYPERSENSITIVITY), airway INFLAMMATION, and intermittent AIRWAY OBSTRUCTION. It is characterized by spasmodic contraction of airway smooth muscle, WHEEZING, and dyspnea (DYSPNEA, PAROXYSMAL).'),
  'D001250': NtO(MH='Asthma, Exercise-Induced', MS='Asthma attacks following a period of exercise. Usually the induced attack is short-lived and regresses spontaneously. The magnitude of postexertional airway obstruction is strongly influenced by the environment in which exercise is performed (i.e. inhalation of cold air during physical exertion markedly augments the severity of the airway obstruction; conversely, warm humid air blunts or abolishes it).'),
  'D001251': NtO(MH='Astigmatism', MS='Unequal curvature of the refractive surfaces of the eye. Thus a point source of light cannot be brought to a point focus on the retina but is spread over a more or less diffuse area. This results from the radius of curvature in one plane being longer or shorter than the radius at right angles to it. (Dorland, 27th ed)'),
  'D001252': NtO(MH='Astringents', MS='Agents, usually topical, that cause the contraction of tissues for the control of bleeding or secretions.'),
  'D001253': NtO(MH='Astrocytes', MS='A class of large neuroglial (macroglial) cells in the central nervous system - the largest and most numerous neuroglial cells in the brain and spinal cord. Astrocytes (from "star" cells) are irregularly shaped with many long processes, including those with "end feet" which form the glial (limiting) membrane and directly and indirectly contribute to the BLOOD-BRAIN BARRIER. They regulate the extracellular ionic and chemical environment, and "reactive astrocytes" (along with MICROGLIA) respond to injury.'),
  'D001254': NtO(MH='Astrocytoma', MS='Neoplasms of the brain and spinal cord derived from glial cells which vary from histologically benign forms to highly anaplastic and malignant tumors. Fibrillary astrocytomas are the most common type and may be classified in order of increasing malignancy (grades I through IV). In the first two decades of life, astrocytomas tend to originate in the cerebellar hemispheres; in adults, they most frequently arise in the cerebrum and frequently undergo malignant transformation. (From Devita et al., Cancer: Principles and Practice of Oncology, 5th ed, pp2013-7; Holland et al., Cancer Medicine, 3d ed, p1082)'),
  'D001255': NtO(MH='Astrology', MS='System of thought regarding forecasting of earthly and human events through the observation and interpretation of the fixed stars and planetary bodies.'),
  'D001256': NtO(MH='Astronomy', MS='The science concerned with celestial bodies and the observation and interpretation of the radiation received in the vicinity of the earth from the component parts of the universe (McGraw Hill Dictionary of Scientific and Technical Terms, 5th ed)'),
  'D001257': NtO(MH='Mamastrovirus', MS='A genus of small, circular RNA viruses in the family ASTROVIRIDAE. They cause GASTROENTERITIS and are found in the stools of several vertebrates including humans. Transmission is by the fecal-oral route and there are at least eight human serotypes. The type species is Human astrovirus.'),
  'D001259': NtO(MH='Ataxia', MS='Impairment of the ability to perform smoothly coordinated voluntary movements. This condition may affect the limbs, trunk, eyes, pharynx, larynx, and other structures. Ataxia may result from impaired sensory or motor function. Sensory ataxia may result from posterior column injury or PERIPHERAL NERVE DISEASES. Motor ataxia may be associated with CEREBELLAR DISEASES; CEREBRAL CORTEX diseases; THALAMIC DISEASES; BASAL GANGLIA DISEASES; injury to the RED NUCLEUS; and other conditions.'),
  'D001260': NtO(MH='Ataxia Telangiectasia', MS='An autosomal recessive inherited disorder characterized by choreoathetosis beginning in childhood, progressive CEREBELLAR ATAXIA; TELANGIECTASIS of CONJUNCTIVA and SKIN; DYSARTHRIA; B- and T-cell immunodeficiency, and RADIOSENSITIVITY to IONIZING RADIATION. Affected individuals are prone to recurrent sinobronchopulmonary infections, lymphoreticular neoplasms, and other malignancies. Serum ALPHA-FETOPROTEINS are usually elevated. (Menkes, Textbook of Child Neurology, 5th ed, p688) The gene for this disorder (ATM) encodes a cell cycle checkpoint protein kinase and has been mapped to chromosome 11 (11q22-q23).'),
  'D001261': NtO(MH='Pulmonary Atelectasis', MS='Absence of air in the entire or part of a lung, such as an incompletely inflated neonate lung or a collapsed adult lung. Pulmonary atelectasis can be caused by airway obstruction, lung compression, fibrotic contraction, or other factors.'),
  'D001262': NtO(MH='Atenolol', MS='A cardioselective beta-1 adrenergic blocker possessing properties and potency similar to PROPRANOLOL, but without a negative inotropic effect.'),
  'D001264': NtO(MH='Athetosis', MS='A dyskinesia characterized by an inability to maintain the fingers, toes, tongue, or other body parts in a stable position, resulting in continuous slow, sinusoidal, and flowing involuntary movements. This condition is frequently accompanied by CHOREA, where it is referred to as choreoathetosis. Athetosis may occur as a manifestation of BASAL GANGLIA DISEASES or DRUG TOXICITY. (From Adams et al., Principles of Neurology, 6th ed, p76)'),
  'D001265': NtO(MH='Athletic Injuries', MS='Injuries incurred during participation in competitive or non-competitive sports.'),
  'D001266': NtO(MH='Atlantic Islands', MS='Widely scattered islands in the Atlantic Ocean as far north as the AZORES and as far south as the South Sandwich Islands, with the greatest concentration found in the CARIBBEAN REGION. They include Annobon Island, Ascension, Canary Islands, Falkland Islands, Fernando Po (also called Isla de Bioko and Bioko), Gough Island, Madeira, Sao Tome and Principe, Saint Helena, and Tristan da Cunha.'),
  'D001267': NtO(MH='Atlantic Ocean', MS='Body of water separating North and South America from Africa and Europe.'),
  'D001268': NtO(MH='Atlanto-Axial Joint', MS='The joint involving the CERVICAL ATLAS and axis bones.'),
  'D001269': NtO(MH='Atlanto-Occipital Joint', MS='The point of articulation between the OCCIPITAL BONE and the CERVICAL ATLAS.'),
  'D001270': NtO(MH='Cervical Atlas', MS='The first cervical vertebra.'),
  'D001271': NtO(MH='Atlases as Topic', MS='Works about collections of illustrative plates and charts..'),
  'D001272': NtO(MH='Atmosphere', MS='The gaseous envelope surrounding a planet or similar body. (From Random House Unabridged Dictionary, 2d ed)'),
  'D001273': NtO(MH='Atmosphere Exposure Chambers', MS='Experimental devices used in inhalation studies in which a person or animal is either partially or completely immersed in a chemically controlled atmosphere.'),
  'D001274': NtO(MH='Atmospheric Pressure', MS='The pressure at any point in an atmosphere due solely to the weight of the atmospheric gases above the point concerned.'),
  'D001275': NtO(MH='ATP Citrate (pro-S)-Lyase', MS='An enzyme that, in the presence of ATP and COENZYME A, catalyzes the cleavage of citrate to yield acetyl CoA, oxaloacetate, ADP, and ORTHOPHOSPHATE. This reaction represents an important step in fatty acid biosynthesis. This enzyme was formerly listed as EC 4.1.3.8.'),
  'D001276': NtO(MH='ATP Phosphoribosyltransferase', MS="An enzyme that catalyzes the first step of the pathway for histidine biosynthesis in Salmonella typhimurium. ATP reacts reversibly with 5-phosphoribosyl-1-pyrophosphate to yield N-1-(5'-phosphoribosyl)-ATP and pyrophosphate. EC 2.4.2.17."),
  'D001277': NtO(MH='GTP Pyrophosphokinase', MS="An enzyme that catalyzes reversibly the transfer of a pyrophosphate group from ATP to the 3'-OH group of GDP or GTP with the formation of guanosine 3'-diphosphate 5'-diphosphate or guanosine 3'-diphosphate 5'-triphosphate and AMP. The enzyme, also called stringent factor, is located in the relA gene in stringent strains of bacteria. The above synthesis is induced by mRNA and uncharged tRNA which is bound to the aminoacyl-t-RNA binding site of the ribosome by a codon-specific association. EC 2.7.6.5."),
  'D001278': NtO(MH='Atractyloside', MS='A glycoside of a kaurene type diterpene that is found in some plants including Atractylis gummifera (ATRACTYLIS); COFFEE; XANTHIUM, and CALLILEPIS. Toxicity is due to inhibition of ADENINE NUCLEOTIDE TRANSLOCASE.'),
  'D001279': NtO(MH='Atracurium', MS='A non-depolarizing neuromuscular blocking agent with short duration of action. Its lack of significant cardiovascular effects and its lack of dependence on good kidney function for elimination provide clinical advantage over alternate non-depolarizing neuromuscular blocking agents.'),
  'D001280': NtO(MH='Atrazine', MS='A selective triazine herbicide. Inhalation hazard is low and there are no apparent skin manifestations or other toxicity in humans. Acutely poisoned sheep and cattle may show muscular spasms, fasciculations, stiff gait, increased respiratory rates, adrenal degeneration, and congestion of the lungs, liver, and kidneys. (From The Merck Index, 11th ed)'),
  'D001281': NtO(MH='Atrial Fibrillation', MS='Abnormal cardiac rhythm that is characterized by rapid, uncoordinated firing of electrical impulses in the upper chambers of the heart (HEART ATRIA). In such case, blood cannot be effectively pumped into the lower chambers of the heart (HEART VENTRICLES). It is caused by abnormal impulse generation.'),
  'D001282': NtO(MH='Atrial Flutter', MS='Rapid, irregular atrial contractions caused by a block of electrical impulse conduction in the right atrium and a reentrant wave front traveling up the inter-atrial septum and down the right atrial free wall or vice versa. Unlike ATRIAL FIBRILLATION which is caused by abnormal impulse generation, typical atrial flutter is caused by abnormal impulse conduction. As in atrial fibrillation, patients with atrial flutter cannot effectively pump blood into the lower chambers of the heart (HEART VENTRICLES).'),
  'D001283': NtO(MH='Atrioventricular Node', MS='A small nodular mass of specialized muscle fibers located in the interatrial septum near the opening of the coronary sinus. It gives rise to the atrioventricular bundle of the conduction system of the heart.'),
  'D001284': NtO(MH='Atrophy', MS='Decrease in the size of a cell, tissue, organ, or multiple organs, associated with a variety of pathological conditions such as abnormal cellular changes, ischemia, malnutrition, or hormonal changes.'),
  'D001285': NtO(MH='Atropine', MS='An alkaloid, originally from Atropa belladonna, but found in other plants, mainly SOLANACEAE. Hyoscyamine is the 3(S)-endo isomer of atropine.'),
  'D001286': NtO(MH='Atropine Derivatives', MS='Analogs and derivatives of atropine.'),
  'D001287': NtO(MH='Attachment Sites, Microbiological', MS='Specific loci on both the bacterial DNA (attB) and the phage DNA (attP) which delineate the sites where recombination takes place between them, as the phage DNA becomes integrated (inserted) into the BACTERIAL DNA during LYSOGENY.'),
  'D001288': NtO(MH='Attention', MS='Focusing on certain aspects of current experience to the exclusion of others. It is the act of heeding or taking notice or concentrating.'),
  'D001289': NtO(MH='Attention Deficit Disorder with Hyperactivity', MS='A behavior disorder originating in childhood in which the essential features are signs of developmentally inappropriate inattention, impulsivity, and hyperactivity. Although most individuals have symptoms of both inattention and hyperactivity-impulsivity, one or the other pattern may be predominant. The disorder is more frequent in males than females. Onset is in childhood. Symptoms often attenuate during late   adolescence although a minority experience the full complement of symptoms into mid-adulthood. (From DSM-V)'),
  'D001290': NtO(MH='Attitude', MS='An enduring, learned predisposition to behave in a consistent way toward a given class of objects, or a persistent mental and/or neural state of readiness to react to a certain class of objects, not as they are but as they are conceived to be.'),
  'D001291': NtO(MH='Attitude of Health Personnel', MS='Attitudes of personnel toward their patients, other professionals, toward the medical care system, etc.'),
  'D001292': NtO(MH='Attitude to Computers', MS='The attitude and behavior associated with an individual using the computer.'),
  'D001293': NtO(MH='Attitude to Death', MS='Conceptual response of the person to the various aspects of death, which are based on individual psychosocial and cultural experience.'),
  'D001294': NtO(MH='Attitude to Health', MS='Public attitudes toward health, disease, and the medical care system.'),
  'D001295': NtO(MH='Atypical Bacterial Forms', MS='Microorganisms that have undergone greater changes than normal in morphology, physiology, or cultural characteristics.'),
  'D001296': NtO(MH='Audiovisual Aids', MS='Auditory and visual instructional materials.'),
  'D001297': NtO(MH='Audioanalgesia', MS='Method of pain control in which auditory stimulation including music, white noise, and environmental sounds are used.'),
  'D001298': NtO(MH='Audiology', MS='Allied medical specialty that studies hearing and hearing impairment.'),
  'D001299': NtO(MH='Audiometry', MS='The testing of the acuity of the sense of hearing to determine the thresholds of the lowest intensity levels at which an individual can hear a set of tones. The frequencies between 125 and 8000 Hz are used to test air conduction thresholds and the frequencies between 250 and 4000 Hz are used to test bone conduction thresholds.'),
  'D001300': NtO(MH='Audiometry, Evoked Response', MS='A form of electrophysiologic audiometry in which an analog computer is included in the circuit to average out ongoing or spontaneous brain wave activity. A characteristic pattern of response to a sound stimulus may then become evident. Evoked response audiometry is known also as electric response audiometry.'),
  'D001301': NtO(MH='Audiometry, Pure-Tone', MS='Measurement of hearing based on the use of pure tones of various frequencies and intensities as auditory stimuli.'),
  'D001302': NtO(MH='Audiometry, Speech', MS='Measurement of the ability to hear speech under various conditions of intensity and noise interference using sound-field as well as earphones and bone oscillators.'),
  'D001303': NtO(MH='Auditory Cortex', MS='The region of the cerebral cortex that receives the auditory radiation from the MEDIAL GENICULATE BODY.'),
  'D001304': NtO(MH='Auditory Diseases, Central', MS='Disorders of hearing or auditory perception due to pathological processes of the AUDITORY PATHWAYS in the CENTRAL NERVOUS SYSTEM. These include CENTRAL HEARING LOSS and AUDITORY PERCEPTUAL DISORDERS.'),
  'D001305': NtO(MH='Auditory Fatigue', MS='Loss of sensitivity to sounds as a result of auditory stimulation, manifesting as a temporary shift in auditory threshold. The temporary threshold shift, TTS, is expressed in decibels.'),
  'D001306': NtO(MH='Auditory Pathways', MS='NEURAL PATHWAYS and connections within the CENTRAL NERVOUS SYSTEM, beginning at the hair cells of the ORGAN OF CORTI, continuing along the eighth cranial nerve, and terminating at the AUDITORY CORTEX.'),
  'D001307': NtO(MH='Auditory Perception', MS='The process whereby auditory stimuli are selected, organized, and interpreted by the organism.'),
  'D001308': NtO(MH='Auditory Perceptual Disorders', MS='Acquired or developmental cognitive disorders of AUDITORY PERCEPTION characterized by a reduced ability to perceive information contained in auditory stimuli despite intact auditory pathways. Affected individuals have difficulty with speech perception, sound localization, and comprehending the meaning of inflections of speech.'),
  'D001309': NtO(MH='Auditory Threshold', MS='The audibility limit of discriminating sound intensity and pitch.'),
  'D001310': NtO(MH='Auranofin', MS='An oral chrysotherapeutic agent for the treatment of rheumatoid arthritis. Its exact mechanism of action is unknown, but it is believed to act via immunological mechanisms and alteration of lysosomal enzyme activity. Its efficacy is slightly less than that of injected gold salts, but it is better tolerated, and side effects which occur are potentially less serious.'),
  'D001312': NtO(MH='Aurintricarboxylic Acid', MS='A dye which inhibits protein biosynthesis at the initial stages. The ammonium salt (aluminon) is a reagent for the colorimetric estimation of aluminum in water, foods, and tissues.'),
  'D001313': NtO(MH='Aurovertins', MS='Very toxic and complex pyrone derivatives from the fungus Calcarisporium arbuscula. They bind to and inhibit mitochondrial ATPase, thereby uncoupling oxidative phosphorylation. They are used as biochemical tools.'),
  'D001314': NtO(MH='Auscultation', MS='Act of listening for sounds within the body.'),
  'D001315': NtO(MH='Australia', MS='The smallest continent and an independent country, comprising six states and two territories. Its capital is Canberra.'),
  'D001317': NtO(MH='Austria', MS='A country located in Central Europe, north of Italy and Slovenia. The capital is Vienna.'),
  'D001318': NtO(MH='Authoritarianism', MS='The personality pattern or syndrome consisting of behavioral and attitudinal characteristics reflecting a preoccupation with the factors of power and authority in interpersonal relationships.'),
  'D001319': NtO(MH='Authorship', MS='The profession of writing. Also the identity of the writer as the creator of a literary production.'),
  'D001321': NtO(MH='Autistic Disorder', MS='A disorder beginning in childhood. It is marked by the presence of markedly abnormal or impaired development in social interaction and communication and a markedly restricted repertoire of activity and interest. Manifestations of the disorder vary greatly depending on the developmental level and chronological age of the individual. (DSM-V)'),
  'D001322': NtO(MH='Autoanalysis', MS='Method of analyzing chemicals using automation.'),
  'D001323': NtO(MH='Autoantibodies', MS='Antibodies that react with self-antigens (AUTOANTIGENS) of the organism that produced them.'),
  'D001324': NtO(MH='Autoantigens', MS='Endogenous tissue constituents that have the ability to interact with AUTOANTIBODIES and cause an immune response.'),
  'D001325': NtO(MH='Autobiographies as Topic', MS="Works about self-described narratives of a person's life."),
  'D001326': NtO(MH='Autogenic Training', MS='Technique based on muscle relaxation during self-hypnotic exercises. It is used in conjunction with psychotherapy.'),
  'D001327': NtO(MH='Autoimmune Diseases', MS='Disorders that are characterized by the production of antibodies that react with host tissues or immune effector cells that are autoreactive to endogenous peptides.'),
  'D001329': NtO(MH='Autolysis', MS='The spontaneous disintegration of tissues or cells by the action of their own autogenous enzymes.'),
  'D001330': NtO(MH='Electronic Data Processing', MS='Applications that store and process large quantities of data.'),
  'D001331': NtO(MH='Automation', MS="Controlled operation of an apparatus, process, or system by mechanical or electronic devices that take the place of human organs of observation, effort, and decision. (From Webster's Collegiate Dictionary, 1993)"),
  'D001332': NtO(MH='Automatism', MS='Automatic, mechanical, and apparently undirected behavior which is outside of conscious control.'),
  'D001333': NtO(MH='Automobile Driver Examination', MS="Government required written and driving test given to individuals prior to obtaining an operator's license."),
  'D001334': NtO(MH='Automobile Driving', MS='The effect of environmental or physiological factors on the driver and driving ability. Included are driving fatigue, and the effect of drugs, disease, and physical disabilities on driving.'),
  'D001335': NtO(MH='Vehicle Emissions', MS='Gases, fumes, vapors, and ODORANTS escaping from the cylinders of a gasoline or diesel internal-combustion engine. (From McGraw-Hill Dictionary of Scientific and Technical Terms, 4th ed & Random House Unabridged Dictionary, 2d ed)'),
  'D001336': NtO(MH='Automobiles', MS='A usually four-wheeled automotive vehicle designed for passenger transportation.'),
  'D001337': NtO(MH='Autonomic Agents', MS='Agents affecting the function of, or mimicking the actions of, the autonomic nervous system and thereby having an effect on such processes as respiration, circulation, digestion, body temperature regulation, certain endocrine gland secretions, etc.'),
  'D001338': NtO(MH='Autonomic Fibers, Postganglionic', MS='Nerve fibers which project from cell bodies of AUTONOMIC GANGLIA to SYNAPSES on target organs.'),
  'D001339': NtO(MH='Autonomic Fibers, Preganglionic', MS='NERVE FIBERS which project from the central nervous system to AUTONOMIC GANGLIA. In the sympathetic division most preganglionic fibers originate with neurons in the intermediolateral column of the SPINAL CORD, exit via ventral roots from upper thoracic through lower lumbar segments, and project to the paravertebral ganglia; there they either terminate in SYNAPSES or continue through the SPLANCHNIC NERVES to the prevertebral ganglia. In the parasympathetic division the fibers originate in neurons of the BRAIN STEM and sacral spinal cord. In both divisions the principal transmitter is ACETYLCHOLINE but peptide cotransmitters may also be released.'),
  'D001340': NtO(MH='Autonomic Nerve Block', MS='Interruption of sympathetic pathways, by local injection of an anesthetic agent, at any of four levels: peripheral nerve block, sympathetic ganglion block, extradural block, and subarachnoid block.'),
  'D001341': NtO(MH='Autonomic Nervous System', MS='The ENTERIC NERVOUS SYSTEM; PARASYMPATHETIC NERVOUS SYSTEM; and SYMPATHETIC NERVOUS SYSTEM taken together. Generally speaking, the autonomic nervous system regulates the internal environment during both peaceful activity and physical or emotional stress. Autonomic activity is controlled and integrated by the CENTRAL NERVOUS SYSTEM, especially the HYPOTHALAMUS and the SOLITARY NUCLEUS, which receive information relayed from VISCERAL AFFERENTS.'),
  'D001342': NtO(MH='Autonomic Nervous System Diseases', MS='Diseases of the parasympathetic or sympathetic divisions of the AUTONOMIC NERVOUS SYSTEM; which has components located in the CENTRAL NERVOUS SYSTEM and PERIPHERAL NERVOUS SYSTEM. Autonomic dysfunction may be associated with HYPOTHALAMIC DISEASES; BRAIN STEM disorders; SPINAL CORD DISEASES; and PERIPHERAL NERVOUS SYSTEM DISEASES. Manifestations include impairments of vegetative functions including the maintenance of BLOOD PRESSURE; HEART RATE; pupil function; SWEATING; REPRODUCTIVE AND URINARY PHYSIOLOGY; and DIGESTION.'),
  'D001343': NtO(MH='Autophagy', MS='The segregation and degradation of various cytoplasmic constituents via engulfment by MULTIVESICULAR BODIES; VACUOLES; or AUTOPHAGOSOMES and their digestion by LYSOSOMES. It plays an important role in BIOLOGICAL METAMORPHOSIS and in the removal of bone by OSTEOCLASTS. Defective autophagy is associated with various diseases, including NEURODEGENERATIVE DISEASES and cancer.'),
  'D001344': NtO(MH='Autopsy', MS='Postmortem examination of the body.'),
  'D001345': NtO(MH='Autoradiography', MS='The making of a radiograph of an object or tissue by recording on a photographic plate the radiation emitted by radioactive material within the object. (Dorland, 27th ed)'),
  'D001346': NtO(MH='Autosuggestion', MS='Suggestion coming from the subject himself.'),
  'D001348': NtO(MH='Aversive Therapy', MS='A treatment that suppresses undesirable behavior by simultaneously exposing the subject to unpleasant consequences.'),
  'D001350': NtO(MH='Encephalomyelitis Virus, Avian', MS='A tentative species in the genus HEPATOVIRUS infecting primarily young chicks, but also found in turkeys, pheasants, and guinea fowl. It causes a fatal neuronal degeneration and is transmitted by mechanical contact.'),
  'D001351': NtO(MH='Infectious bronchitis virus', MS='A species of CORONAVIRUS causing infections in chickens and possibly pheasants. Chicks up to four weeks old are the most severely affected.'),
  'D001352': NtO(MH='Herpesvirus 1, Gallid', MS='The type species of the genus ILTOVIRUS found on every continent and affecting mainly chickens and occasionally pheasants.'),
  'D001353': NtO(MH='Avian Leukosis', MS='A group of transmissible viral diseases of chickens and turkeys. Liver tumors are found in most forms, but tumors can be found elsewhere.'),
  'D001354': NtO(MH='Avian Leukosis Virus', MS='The type species of ALPHARETROVIRUS producing latent or manifest lymphoid leukosis in fowl.'),
  'D001355': NtO(MH='Alpharetrovirus', MS='A genus of the family RETROVIRIDAE with type C morphology, that causes malignant and other diseases in wild birds and domestic fowl.'),
  'D001356': NtO(MH='Reticuloendotheliosis virus', MS='A species in the group RETICULOENDOTHELIOSIS VIRUSES, AVIAN of the genus GAMMARETROVIRUS that causes a chronic neoplastic and a more acute immunosuppressive disease in fowl.'),
  'D001357': NtO(MH='Sarcoma, Avian', MS='Connective tissue tumors, affecting primarily fowl, that are usually caused by avian sarcoma viruses.'),
  'D001358': NtO(MH='Avian Sarcoma Viruses', MS='Group of alpharetroviruses (ALPHARETROVIRUS) producing sarcomata and other tumors in chickens and other fowl and also in pigeons, ducks, and RATS.'),
  'D001359': NtO(MH='Aviation', MS='Design, development, manufacture, and operation of heavier-than-air AIRCRAFT.'),
  'D001360': NtO(MH='Avidin', MS='A specific protein in egg albumin that interacts with BIOTIN to render it unavailable to mammals, thereby producing biotin deficiency.'),
  'D001361': NtO(MH='Avitaminosis', MS='A condition due to a deficiency of one or more essential vitamins. (Dorland, 27th ed)'),
  'D001362': NtO(MH='Avoidance Learning', MS='A response to a cue that is instrumental in avoiding a noxious experience.'),
  'D001363': NtO(MH='Awards and Prizes', MS=None),
  'D001364': NtO(MH='Awareness', MS='The act of "taking account" of an object or state of affairs. It does not imply assessment of, nor attention to the qualities or nature of the object.'),
  'D001365': NtO(MH='Axilla', MS='Area of the human body underneath the SHOULDER JOINT, also known as the armpit or underarm.'),
  'D001366': NtO(MH='Axillary Artery', MS='The continuation of the subclavian artery; it distributes over the upper limb, axilla, chest and shoulder.'),
  'D001367': NtO(MH='Axillary Vein', MS='The venous trunk of the upper limb; a continuation of the basilar and brachial veins running from the lower border of the teres major muscle to the outer border of the first rib where it becomes the subclavian vein.'),
  'D001368': NtO(MH='Axis, Cervical Vertebra', MS='The second cervical vertebra.'),
  'D001369': NtO(MH='Axons', MS='Nerve fibers that are capable of rapidly conducting impulses away from the neuron cell body.'),
  'D001370': NtO(MH='Axonal Transport', MS='The directed transport of ORGANELLES and molecules along nerve cell AXONS. Transport can be anterograde (from the cell body) or retrograde (toward the cell body). (Alberts et al., Molecular Biology of the Cell, 3d ed, pG3)'),
  'D001371': NtO(MH='trans-1,4-Bis(2-chlorobenzaminomethyl)cyclohexane Dihydrochloride', MS='An anti-cholesteremic agent that inhibits delta 7-reductase, delta 14 reductase, and sterol biosynthesis.'),
  'D001372': NtO(MH='Aza Compounds', MS='Organic chemicals where carbon atoms have been replaced by nitrogen atoms.'),
  'D001373': NtO(MH='Azacosterol', MS='Diaza derivative of cholesterol which acts as a hypocholesteremic agent by blocking delta-24-reductase, which causes the accumulation of desmosterol.'),
  'D001374': NtO(MH='Azacitidine', MS='A pyrimidine analogue that inhibits DNA methyltransferase, impairing DNA methylation. It is also an antimetabolite of cytidine, incorporated primarily into RNA. Azacytidine has been used as an antineoplastic agent.'),
  'D001375': NtO(MH='Azaguanine', MS='One of the early purine analogs showing antineoplastic activity. It functions as an antimetabolite and is easily incorporated into ribonucleic acids.'),
  'D001376': NtO(MH='Azaperone', MS='A butyrophenone used in the treatment of PSYCHOSES.'),
  'D001377': NtO(MH='Azaserine', MS='Antibiotic substance produced by various Streptomyces species. It is an inhibitor of enzymatic activities that involve glutamine and is used as an antineoplastic and immunosuppressive agent.'),
  'D001378': NtO(MH='Azasteroids', MS='Steroidal compounds in which one or more carbon atoms in the steroid ring system have been substituted with nitrogen atoms.'),
  'D001379': NtO(MH='Azathioprine', MS='An immunosuppressive agent used in combination with cyclophosphamide and hydroxychloroquine in the treatment of rheumatoid arthritis. According to the Fourth Annual Report on Carcinogens (NTP 85-002, 1985), this substance has been listed as a known carcinogen. (Merck Index, 11th ed)'),
  'D001380': NtO(MH='Azauridine', MS='A triazine nucleoside used as an antineoplastic antimetabolite. It interferes with pyrimidine biosynthesis thereby preventing formation of cellular nucleic acids. As the triacetate, it is also effective as an antipsoriatic.'),
  'D001381': NtO(MH='Azepines', MS='Seven membered heterocyclic rings containing a NITROGEN atom.'),
  'D001382': NtO(MH='Azerbaijan', MS='A country located in Southwestern Asia, bordering the Caspian Sea, between Iran and Russia, with a small European portion north of the Caucasus range. The capital is Baku.'),
  'D001383': NtO(MH='Azetidinecarboxylic Acid', MS='A proline analog that acts as a stoichiometric replacement of proline. It causes the production of abnormal proteins with impaired biological activity.'),
  'D001384': NtO(MH='Azetidines', MS=None),
  'D001385': NtO(MH='Azetines', MS=None),
  'D001386': NtO(MH='Azides', MS='Organic or inorganic compounds that contain the -N3 group.'),
  'D001387': NtO(MH='Azinphosmethyl', MS='An organothiophosphorus cholinesterase inhibitor. It has been used as an acaricide and as an insecticide.'),
  'D001388': NtO(MH='Aziridines', MS='Saturated azacyclopropane compounds. They include compounds with substitutions on CARBON or NITROGEN atoms.'),
  'D001389': NtO(MH='Azirines', MS='Unsaturated azacyclopropane compounds that are three-membered heterocycles of a nitrogen and two carbon atoms.'),
  'D001390': NtO(MH='Azlocillin', MS='A semisynthetic ampicillin-derived acylureido penicillin.'),
  'D001391': NtO(MH='Azo Compounds', MS="Organic chemicals where aryl or alkyl groups are joined by two nitrogen atoms through a double bond (R-N=N-R'; R and R' may be either aryl or alkyl). They may be used as DYES."),
  'D001392': NtO(MH='Azocines', MS=None),
  'D001393': NtO(MH='Azoles', MS='Five membered rings containing a NITROGEN atom.'),
  'D001394': NtO(MH='Azores', MS="A group of nine islands and several islets belonging to Portugal in the north Atlantic Ocean off the coast of Portugal. The islands are named after the acores, the Portuguese for goshawks, living there in abundance. (Webster's New Geographical Dictionary, 1988, p102 & Room, Brewer's Dictionary of Names, 1992, p42)"),
  'D001395': NtO(MH='Azotobacter', MS='A genus of gram-negative, aerobic bacteria found in soil and water. Its organisms occur singly, in pairs or irregular clumps, and sometimes in chains of varying lengths.'),
  'D001397': NtO(MH='Azoxymethane', MS='A potent carcinogen and neurotoxic compound. It is particularly effective in inducing colon carcinomas.'),
  'D001398': NtO(MH='Aztreonam', MS='A monocyclic beta-lactam antibiotic originally isolated from Chromobacterium violaceum. It is resistant to beta-lactamases and is used in gram-negative infections, especially of the meninges, bladder, and kidneys. It may cause a superinfection with gram-positive organisms.'),
  'D001399': NtO(MH='Azure Stains', MS='PHENOTHIAZINES with an amino group at the 3-position that are green crystals or powder. They are used as biological stains.'),
  'D001400': NtO(MH='Azurin', MS='A bacterial protein from Pseudomonas, Bordetella, or Alcaligenes which operates as an electron transfer unit associated with the cytochrome chain. The protein has a molecular weight of approximately 16,000, contains a single copper atom, is intensively blue, and has a fluorescence emission band centered at 308nm.'),
  'D001401': NtO(MH='Azygos Vein', MS='A vein which arises from the right ascending lumbar vein or the vena cava, enters the thorax through the aortic orifice in the diaphragm, and terminates in the superior vena cava.'),
  'D001402': NtO(MH='B-Lymphocytes', MS='Lymphoid cells concerned with humoral immunity. They are short-lived cells resembling bursa-derived lymphocytes of birds in their production of immunoglobulin upon appropriate stimulation.'),
  'D001403': NtO(MH='Babesia', MS='A genus of tick-borne protozoan parasites that infests the red blood cells of mammals, including humans. There are many recognized species, and the distribution is world-wide.'),
  'D001404': NtO(MH='Babesiosis', MS="A group of tick-borne diseases of mammals including ZOONOSES in humans. They are caused by protozoa of the genus BABESIA, which parasitize erythrocytes, producing hemolysis. In the U.S., the organism's natural host is mice and transmission is by the deer tick IXODES SCAPULARIS."),
  'D001405': NtO(MH='Reflex, Babinski', MS='A reflex found in normal infants consisting of dorsiflexion of the HALLUX and abduction of the other TOES in response to cutaneous stimulation of the plantar surface of the FOOT. In adults, it is used as a diagnostic criterion, and if present is a NEUROLOGIC MANIFESTATION of dysfunction in the CENTRAL NERVOUS SYSTEM.'),
  'D001406': NtO(MH='Bacillaceae', MS='A family of bacteria which produce endospores. They are mostly saprophytes from soil, but a few are insect or animal parasites or pathogens.'),
  'D001407': NtO(MH='Bacillus', MS='A genus of BACILLACEAE that are spore-forming, rod-shaped cells. Most species are saprophytic soil forms with only a few species being pathogenic.'),
  'D001408': NtO(MH='Bacillus anthracis', MS='A species of bacteria that causes ANTHRAX in humans and animals.'),
  'D001409': NtO(MH='Bacillus cereus', MS='A species of rod-shaped bacteria that is a common soil saprophyte. Its spores are widespread and multiplication has been observed chiefly in foods. Contamination may lead to food poisoning.'),
  'D001410': NtO(MH='Bacillus megaterium', MS='A species of bacteria whose spores vary from round to elongate. It is a common soil saprophyte.'),
  'D001411': NtO(MH='Geobacillus stearothermophilus', MS='A species of GRAM-POSITIVE ENDOSPORE-FORMING BACTERIA in the family BACILLACEAE, found in soil, hot springs, Arctic waters, ocean sediments, and spoiled food products.'),
  'D001412': NtO(MH='Bacillus subtilis', MS='A species of gram-positive bacteria that is a common soil and water saprophyte.'),
  'D001413': NtO(MH='Bacillus thuringiensis', MS='A species of gram-positive bacteria which may be pathogenic for certain insects. It is used for the biological control of the Gypsy moth.'),
  'D001414': NtO(MH='Bacitracin', MS='A complex of cyclic peptide antibiotics produced by the Tracy-I strain of Bacillus subtilis. The commercial preparation is a mixture of at least nine bacitracins with bacitracin A as the major constituent. It is used topically to treat open infections such as infected eczema and infected dermal ulcers. (From Goodman and Gilman, The Pharmacological Basis of Therapeutics, 8th ed, p1140)'),
  'D001415': NtO(MH='Back', MS='The rear surface of an upright primate from the shoulders to the hip, or the dorsal surface of tetrapods.'),
  'D001416': NtO(MH='Back Pain', MS='Acute or chronic pain located in the posterior regions of the THORAX; LUMBOSACRAL REGION; or the adjacent regions.'),
  'D001417': NtO(MH='Background Radiation', MS='Radiation from sources other than the source of interest. It is due to cosmic rays and natural radioactivity in the environment.'),
  'D001418': NtO(MH='Baclofen', MS='A GAMMA-AMINOBUTYRIC ACID derivative that is a specific agonist of GABA-B RECEPTORS. It is used in the treatment of MUSCLE SPASTICITY, especially that due to SPINAL CORD INJURIES. Its therapeutic effects result from actions at spinal and supraspinal sites, generally the reduction of excitatory transmission.'),
  'D001419': NtO(MH='Bacteria', MS='One of the three domains of life (the others being Eukarya and ARCHAEA), also called Eubacteria. They are unicellular prokaryotic microorganisms which generally possess rigid cell walls, multiply by cell division, and exhibit three principal forms: round or coccal, rodlike or bacillary, and spiral or spirochetal. Bacteria can be classified by their response to OXYGEN: aerobic, anaerobic, or facultatively anaerobic; by the mode by which they obtain their energy: chemotrophy (via chemical reaction) or PHOTOTROPHY (via light reaction); for chemotrophs by their source of chemical energy: CHEMOLITHOTROPHY (from inorganic compounds) or chemoorganotrophy (from organic compounds); and by their source for CARBON; NITROGEN; etc.; HETEROTROPHY (from organic sources) or AUTOTROPHY (from CARBON DIOXIDE). They can also be classified by whether or not they stain (based on the structure of their CELL WALLS) with CRYSTAL VIOLET dye: gram-negative or gram-positive.'),
  'D001420': NtO(MH='Bacteria, Aerobic', MS='Bacteria which require oxygen in order to grow and survive.'),
  'D001421': NtO(MH='Bacteria, Anaerobic', MS='Bacteria that can survive and grow in the complete, or nearly complete absence of oxygen.'),
  'D001422': NtO(MH='Bacterial Adhesion', MS='Physicochemical property of fimbriated (FIMBRIAE, BACTERIAL) and non-fimbriated bacteria of attaching to cells, tissue, and nonbiological surfaces. It is a factor in bacterial colonization and pathogenicity.'),
  'D001423': NtO(MH='Bacterial Infections and Mycoses', MS='Infections caused by bacteria and fungi, general, specified, or unspecified.'),
  'D001424': NtO(MH='Bacterial Infections', MS='Infections by bacteria, general or unspecified.'),
  'D001425': NtO(MH='Bacterial Outer Membrane Proteins', MS='Proteins isolated from the outer membrane of Gram-negative bacteria.'),
  'D001426': NtO(MH='Bacterial Proteins', MS='Proteins found in any species of bacterium.'),
  'D001427': NtO(MH='Bacterial Toxins', MS='Toxic substances formed in or elaborated by bacteria; they are usually proteins with high molecular weight and antigenicity; some are used as antibiotics and some to skin test for the presence of or susceptibility to certain diseases.'),
  'D001428': NtO(MH='Bacterial Vaccines', MS='Suspensions of attenuated or killed bacteria administered for the prevention or treatment of infectious bacterial disease.'),
  'D001429': NtO(MH='Bacteriochlorophylls', MS='Pyrrole containing pigments found in photosynthetic bacteria.'),
  'D001430': NtO(MH='Bacteriocins', MS='Substances elaborated by specific strains of bacteria that are lethal against other strains of the same or related species. They are protein or lipopolysaccharide-protein complexes used in taxonomy studies of bacteria.'),
  'D001431': NtO(MH='Bacteriological Techniques', MS='Techniques used in studying bacteria.'),
  'D001432': NtO(MH='Bacteriology', MS='The study of the structure, growth, function, genetics, and reproduction of bacteria, and BACTERIAL INFECTIONS.'),
  'D001433': NtO(MH='Bacteriolysis', MS='Rupture of bacterial cells due to mechanical force, chemical action, or the lytic growth of BACTERIOPHAGES.'),
  'D001434': NtO(MH='Bacteriophage Typing', MS='A technique of bacterial typing which differentiates between bacteria or strains of bacteria by their susceptibility to one or more bacteriophages.'),
  'D001435': NtO(MH='Bacteriophages', MS='Viruses whose hosts are bacterial cells.'),
  'D001436': NtO(MH='Bacteriorhodopsins', MS='Rhodopsins found in the PURPLE MEMBRANE of halophilic archaea such as HALOBACTERIUM HALOBIUM. Bacteriorhodopsins function as an energy transducers, converting light energy into electrochemical energy via PROTON PUMPS.'),
  'D001437': NtO(MH='Bacteriuria', MS='The presence of bacteria in the urine which is normally bacteria-free. These bacteria are from the URINARY TRACT and are not contaminants of the surrounding tissues. Bacteriuria can be symptomatic or asymptomatic. Significant bacteriuria is an indicator of urinary tract infection.'),
  'D001438': NtO(MH='Bacteroidaceae', MS='A family of gram-negative bacteria found primarily in the intestinal tracts and mucous membranes of warm-blooded animals. Its organisms are sometimes pathogenic.'),
  'D001439': NtO(MH='Bacteroides', MS='A genus of gram-negative, anaerobic, rod-shaped bacteria. Its organisms are normal inhabitants of the oral, respiratory, intestinal, and urogenital cavities of humans, animals, and insects. Some species may be pathogenic.'),
  'D001441': NtO(MH='Bacteroides fragilis', MS='Gram-negative bacteria occurring in the lower intestinal tracts of man and other animals. It is the most common species of anaerobic bacteria isolated from human soft tissue infections.'),
  'D001442': NtO(MH='Bacteroides Infections', MS='Infections with bacteria of the genus BACTEROIDES.'),
  'D001443': NtO(MH='Prevotella melaninogenica', MS='A species of gram-negative, anaerobic, rod-shaped bacteria originally classified within the BACTEROIDES genus. This bacterium has been isolated from the mouth, urine, feces, and infections of the mouth, soft tissue, respiratory tract, urogenital tract, and intestinal tract. It is pathogenic, but usually in association with other kinds of organisms.'),
  'D001444': NtO(MH='Bahamas', MS="A chain of islands, cays, and reefs in the West Indies, lying southeast of Florida and north of Cuba. It is an independent state, called also the Commonwealth of the Bahamas or the Bahama Islands. The name likely represents the local name Guanahani, itself of uncertain origin. (From Webster's New Geographical Dictionary, 1988, p106 & Room, Brewer's Dictionary of Names, 1992, p45)"),
  'D001445': NtO(MH='Bahrain', MS='An independent state, an archipelago in the western Persian Gulf, northwest of Qatar. It comprises low-lying islands of Bahrain (the largest), Muharraq, Sitra, and several islets. It has extensive oil fields. The name comes from the Arabic al-bahrayn, "the two seas", with reference to its lying in the middle of a bay with its "two seas" east and west of it. (From Webster\'s New Geographical Dictionary, 1988, p107 & Room, Brewer\'s Dictionary of Names, 1992, p45)'),
  'D001446': NtO(MH='Balanitis', MS='Inflammation of the head of the PENIS, glans penis.'),
  'D001447': NtO(MH='Balantidiasis', MS='Infection by parasites of the genus BALANTIDIUM. The presence of Balantidium in the LARGE INTESTINE leads to DIARRHEA; DYSENTERY; and occasionally ULCER.'),
  'D001448': NtO(MH='Balantidium', MS='A genus of protozoa parasitic in the digestive tract of vertebrate or invertebrate hosts. Asexual multiplication is accomplished by transverse binary fission. Its organisms are ovoidal in shape and have a ciliated covering over the entire body.'),
  'D001449': NtO(MH='Balkan Nephropathy', MS='A form of chronic interstitial nephritis that is endemic to limited areas of BULGARIA, the former YUGOSLAVIA, and ROMANIA. It is characterized by a progressive shrinking of the KIDNEYS that is often associated with uroepithelial tumors.'),
  'D001450': NtO(MH='Ballistocardiography', MS='Technique of graphic representation of the movements of the body imparted by the ballistic forces (recoil and impact) associated with cardiac contraction and ejection of blood and with the deceleration of blood flow through the large blood vessels. These movements, quantitatively very minute, are translated by a pickup device (transducer) into an electrical potential which is suitably amplified and recorded on a conventional electrocardiograph or other recording machine.'),
  'D001452': NtO(MH='Balneology', MS='Therapy by various hot or warm baths in natural mineral waters, spas, or "cures". It includes not only bathing in, but also drinking the waters, but it does not include whirlpool baths (HYDROTHERAPY).'),
  'D001453': NtO(MH='Balsams', MS='Resinous substances which most commonly originate from trees. In addition to resins, they contain oils, cinnamic acid and BENZOIC ACID.'),
  'D001454': NtO(MH='Baltic States', MS="The collective name for the republics of ESTONIA; LATVIA; and LITHUANIA on the eastern shore of the Baltic Sea. (Webster's New Geographical Dictionary, 1988, p111)"),
  'D001455': NtO(MH='Bambermycins', MS='Antibiotic complex obtained from Streptomyces bambergiensis containing mainly Moenomycins A and C. They are used as feed additives and growth promoters for poultry, swine, and cattle.'),
  'D001457': NtO(MH='Anion Exchange Protein 1, Erythrocyte', MS='A major integral transmembrane protein of the ERYTHROCYTE MEMBRANE. It is the anion exchanger responsible for electroneutral transporting in CHLORIDE IONS in exchange of BICARBONATE IONS allowing CO2 uptake and transport from tissues to lungs by the red blood cells. Genetic mutations that result in a loss of the protein function have been associated with type 4 HEREDITARY SPHEROCYTOSIS.'),
  'D001458': NtO(MH='Bandages', MS='Material used for wrapping or binding any part of the body.'),
  'D001459': NtO(MH='Bangladesh', MS='A country in Southern Asia, bordering the Bay of Bengal, between Burma and India. The capital is Dhaka.'),
  'D001460': NtO(MH='Barbados', MS='An island in the Lesser Antilles in the West Indies. It is chiefly of coral formation with no good harbors and only small streams. It was probably discovered by the Portuguese in the sixteenth century. The name was given by 16th-century Spanish explorers from barbados, the plural for "bearded", with reference to the beard-like leaves or trails of moss on the trees that grew there in abundance. (From Webster\'s New Geographical Dictionary, 1988, p116 & Room, Brewer\'s Dictionary of Names, 1992, p49)'),
  'D001461': NtO(MH='Barbering', MS='The occupation concerned with the cutting and dressing of the hair of customers and, of men, the shaving and trimming of the beard and mustache. (From Random House Unabridged Dictionary, 2d ed)'),
  'D001462': NtO(MH='Barbital', MS='A long-acting barbiturate that depresses most metabolic processes at high doses. It is used as a hypnotic and sedative and may induce dependence. Barbital is also used in veterinary practice for central nervous system depression.'),
  'D001463': NtO(MH='Barbiturates', MS='A class of chemicals derived from barbituric acid or thiobarbituric acid. Many of these are GABA MODULATORS used as HYPNOTICS AND SEDATIVES, as ANESTHETICS, or as ANTICONVULSANTS.'),
  'D001464': NtO(MH='Barium', MS='An element of the alkaline earth group of metals. It has an atomic symbol Ba, atomic number 56, and atomic weight 138. All of its acid-soluble salts are poisonous.'),
  'D001465': NtO(MH='Barium Radioisotopes', MS='Unstable isotopes of barium that decay or disintegrate emitting radiation. Ba atoms with atomic weights 126-129, 131, 133, and 139-143 are radioactive barium isotopes.'),
  'D001466': NtO(MH='Barium Sulfate', MS='A compound used as an x-ray contrast medium that occurs in nature as the mineral barite. It is also used in various manufacturing applications and mixed into heavy concrete to serve as a radiation shield.'),
  'D001467': NtO(MH='Hordeum', MS='A plant genus of the family POACEAE. The EDIBLE GRAIN, barley, is widely used as food.'),
  'D001468': NtO(MH='Thoracica', MS='A superorder of marine CRUSTACEA, free swimming in the larval state, but permanently fixed as adults. There are some 800 described species, grouped in several genera, and comprising of two major orders of barnacles: stalked (Pedunculata) and sessile (Sessilia).'),
  'D001469': NtO(MH='Barotrauma', MS='Injury following pressure changes; includes injury to the eustachian tube, ear drum, lung and stomach.'),
  'D001471': NtO(MH='Barrett Esophagus', MS="A condition with damage to the lining of the lower ESOPHAGUS resulting from chronic acid reflux (ESOPHAGITIS, REFLUX). Through the process of metaplasia, the squamous cells are replaced by a columnar epithelium with cells resembling those of the INTESTINE or the salmon-pink mucosa of the STOMACH. Barrett's columnar epithelium is a marker for severe reflux and precursor to ADENOCARCINOMA of the esophagus."),
  'D001472': NtO(MH="Bartholin's Glands", MS='Mucus-secreting glands situated on the posterior and lateral aspect of the vestibule of the vagina.'),
  'D001473': NtO(MH='Bartonella', MS='A genus of gram-negative bacteria characteristically appearing in chains of several segmenting organisms. It occurs in man and arthropod vectors and is found only in the Andes region of South America. This genus is the etiologic agent of human bartonellosis. The genus Rochalimaea, once considered a separate genus, has recently been combined with the genus Bartonella as a result of high levels of relatedness in 16S rRNA sequence data and DNA hybridization data.'),
  'D001474': NtO(MH='Bartonella Infections', MS='Infections by the genus BARTONELLA. Bartonella bacilliformis can cause acute febrile anemia, designated Oroya fever, and a benign skin eruption, called verruga peruana. BARTONELLA QUINTANA causes TRENCH FEVER, while BARTONELLA HENSELAE is the etiologic agent of bacillary angiomatosis (ANGIOMATOSIS, BACILLARY) and is also one of the causes of CAT-SCRATCH DISEASE.'),
  'D001475': NtO(MH='Bartonellaceae', MS='A family of small gram-negative bacteria whose organisms are parasites of erythrocytes in man and other vertebrates and the etiologic agents of several diseases.'),
  'D001476': NtO(MH='Bartonellaceae Infections', MS='Infections with bacteria of the family BARTONELLACEAE.'),
  'D001477': NtO(MH='Bartter Syndrome', MS='A group of disorders caused by defective salt reabsorption in the ascending LOOP OF HENLE. It is characterized by severe salt-wasting, HYPOKALEMIA; HYPERCALCIURIA; metabolic ALKALOSIS, and hyper-reninemic HYPERALDOSTERONISM without HYPERTENSION. There are several subtypes including ones due to mutations in the renal specific SODIUM-POTASSIUM-CHLORIDE SYMPORTERS.'),
  'D001478': NtO(MH='Basal Cell Nevus Syndrome', MS='Hereditary disorder consisting of multiple basal cell carcinomas, odontogenic keratocysts, and multiple skeletal defects, e.g., frontal and temporoparietal bossing, bifurcated and splayed ribs, kyphoscoliosis, fusion of vertebrae, and cervicothoracic spina bifida. Genetic transmission is autosomal dominant.'),
  'D001479': NtO(MH='Basal Ganglia', MS='Large subcortical nuclear masses derived from the telencephalon and located in the basal regions of the cerebral hemispheres.'),
  'D001480': NtO(MH='Basal Ganglia Diseases', MS='Diseases of the BASAL GANGLIA including the PUTAMEN; GLOBUS PALLIDUS; claustrum; AMYGDALA; and CAUDATE NUCLEUS. DYSKINESIAS (most notably involuntary movements and alterations of the rate of movement) represent the primary clinical manifestations of these disorders. Common etiologies include CEREBROVASCULAR DISORDERS; NEURODEGENERATIVE DISEASES; and CRANIOCEREBRAL TRAUMA.'),
  'D001481': NtO(MH='Basal Metabolism', MS='Metabolism (e.g., heat production) of an organism in an inactive, awake, fasting state. It may be determined directly by means of a calorimeter or indirectly by calculating the end products of oxidation within the organism or from the amount of oxygen utilized.'),
  'D001482': NtO(MH='Base Composition', MS='The relative amounts of the PURINES and PYRIMIDINES in a nucleic acid.'),
  'D001483': NtO(MH='Base Sequence', MS='The sequence of PURINES and PYRIMIDINES in nucleic acids and polynucleotides. It is also called nucleotide sequence.'),
  'D001484': NtO(MH='Baseball', MS='A competitive nine-member team sport including softball.'),
  'D001485': NtO(MH='Basement Membrane', MS='A darkly stained mat-like EXTRACELLULAR MATRIX (ECM) that separates cell layers, such as EPITHELIUM from ENDOTHELIUM or a layer of CONNECTIVE TISSUE. The ECM layer that supports an overlying EPITHELIUM or ENDOTHELIUM is called basal lamina. Basement membrane (BM) can be formed by the fusion of either two adjacent basal laminae or a basal lamina with an adjacent reticular lamina of connective tissue. BM, composed mainly of TYPE IV COLLAGEN; glycoprotein LAMININ; and PROTEOGLYCAN, provides barriers as well as channels between interacting cell layers.'),
  'D001486': NtO(MH='Bashkiria', MS="A political subdivision of eastern RUSSIA located within Europe. It consists of a plateau and mountainous area of the Southern Urals. (From Webster's New Geographical Dictionary, 1997)"),
  'D001487': NtO(MH='Basidiomycota', MS="A phylum of fungi that produce their sexual spores (basidiospores) on the outside of the basidium. It includes forms commonly known as mushrooms, boletes, puffballs, earthstars, stinkhorns, bird's-nest fungi, jelly fungi, bracket or shelf fungi, and rust and smut fungi."),
  'D001488': NtO(MH='Basilar Artery', MS='The artery formed by the union of the right and left vertebral arteries; it runs from the lower to the upper border of the pons, where it bifurcates into the two posterior cerebral arteries.'),
  'D001489': NtO(MH='Basilar Membrane', MS='A basement membrane in the cochlea that supports the hair cells of the ORGAN OF CORTI, consisting keratin-like fibrils. It stretches from the SPIRAL LAMINA to the basilar crest. The movement of fluid in the cochlea, induced by sound, causes displacement of the basilar membrane and subsequent stimulation of the attached hair cells which transform the mechanical signal into neural activity.'),
  'D001490': NtO(MH='Basketball', MS='A competitive team sport played on a rectangular court having a raised basket at each end.'),
  'D001491': NtO(MH='Basophils', MS='Granular leukocytes characterized by a relatively pale-staining, lobate nucleus and cytoplasm containing coarse dark-staining granules of variable size and stainable by basic dyes.'),
  'D001492': NtO(MH='Bass', MS='Common name for FISHES belonging to the order Perciformes and occurring in three different families.'),
  'D001493': NtO(MH='Bathing Beaches', MS='Beaches, both natural and man-made, used for bathing and other activities.'),
  'D001494': NtO(MH='Baths', MS='The immersion or washing of the body or any of its parts in water or other medium for cleansing or medical treatment. It includes bathing for personal hygiene as well as for medical purposes with the addition of therapeutic agents, such as alkalines, antiseptics, oil, etc.'),
  'D001496': NtO(MH='Batrachotoxins', MS='Batrachotoxin is the 20-alpha-bromobenzoate of batrachotoxin A; they are toxins from the venom of a small Colombian frog, Phyllobates aurotaenia, cause release of acetylcholine, destruction of synaptic vesicles and depolarization of nerve and muscle fibers.'),
  'D001497': NtO(MH='Battered Child Syndrome', MS='A clinical condition resulting from repeated physical and psychological injuries inflicted on a child by the parents or caregivers.'),
  'D001498': NtO(MH='3-Pyridinecarboxylic acid, 1,4-dihydro-2,6-dimethyl-5-nitro-4-(2-(trifluoromethyl)phenyl)-, Methyl ester', MS='A dihydropyridine derivative, which, in contrast to NIFEDIPINE, functions as a calcium channel agonist. The compound facilitates Ca2+ influx through partially activated voltage-dependent Ca2+ channels, thereby causing vasoconstrictor and positive inotropic effects. It is used primarily as a research tool.'),
  'D001499': NtO(MH='Bayes Theorem', MS='A theorem in probability theory named for Thomas Bayes (1702-1761). In epidemiology, it is used to obtain the probability of disease in a group of people with some characteristic on the basis of the overall rate of that disease and of the likelihood of that characteristic in healthy and diseased individuals. The most familiar application is in clinical decision analysis where it is used for estimating the probability of a particular diagnosis given the appearance of some symptoms or test result.'),
  'D001500': NtO(MH='BCG Vaccine', MS='An active immunizing agent and a viable avirulent attenuated strain of Mycobacterium tuberculosis, var. bovis, which confers immunity to mycobacterial infections. It is used also in immunotherapy of neoplasms due to its stimulation of antibodies and non-specific immunity.'),
  'D001501': NtO(MH='Bdellovibrio', MS='A genus of bacteria capable of developing within other bacteria.'),
  'D001502': NtO(MH='Beak', MS='In some animals, the jaws together with their horny covering. The beak usually refers to the bill of birds in which the whole varies greatly in form according of the food and habits of the bird. While the beak refers most commonly to birds, the anatomical counterpart is found also in the turtle, squid, and octopus. (From Webster, 3d ed & Storer, et al., General Zoology, 6th ed, p491, 755)'),
  'D001503': NtO(MH='Ursidae', MS='The family of carnivorous or omnivorous bears, having massive bodies, coarse heavy fur, relatively short limbs, and almost rudimentary tails.'),
  'D001504': NtO(MH='Beauty', MS='Characteristics or attributes of persons or things which elicit pleasurable feelings.'),
  'D001505': NtO(MH='Beauty Culture', MS='An industry that creates products and procedures designed to enhance physical appearance and aesthetic appeal.'),
  'D001506': NtO(MH='Beckwith-Wiedemann Syndrome', MS='A syndrome of multiple defects characterized primarily by umbilical hernia (HERNIA, UMBILICAL); MACROGLOSSIA; and GIGANTISM; and secondarily by visceromegaly; HYPOGLYCEMIA; and ear abnormalities.'),
  'D001507': NtO(MH='Beclomethasone', MS='An anti-inflammatory, synthetic glucocorticoid. It is used topically as an anti-inflammatory agent and in aerosol form for the treatment of ASTHMA.'),
  'D001508': NtO(MH='Bed Conversion', MS='The reallocation of beds from one type of care service to another, as in converting acute care beds to long term care beds.'),
  'D001509': NtO(MH='Bed Occupancy', MS='A measure of inpatient health facility use based upon the average number or proportion of beds occupied for a given period of time.'),
  'D001510': NtO(MH='Bed Rest', MS='Confinement of an individual to bed for therapeutic or experimental reasons.'),
  'D001511': NtO(MH='Bedbugs', MS='Parasitic bugs of the family CIMICIDAE. Female bed bugs lay eggs in a sheltered locations such as in mattress seams. Adults and nymphal instars of Cimex feed on warm-blooded hosts. Cimex lectularius and Cimex hemipterus are implicated in human infestations.'),
  'D001512': NtO(MH='Bedding and Linens', MS="Articles of cloth, usually cotton or rayon and other synthetic or cotton-blend fabrics, used in households, hospitals, physicians' examining rooms, nursing homes, etc., for sheets, pillow cases, toweling, gowns, drapes, and the like."),
  'D001513': NtO(MH='Beds', MS='Equipment on which one may lie and sleep, especially as used to care for the hospital patient.'),
  'D001514': NtO(MH='Bee Venoms', MS='Toxins obtained from Apis mellifera (honey bee) and related species. They contain various enzymes, polypeptide toxins, and other substances, some of which are allergenic or immunogenic or both. These venoms were formerly used in rheumatism to stimulate the pituitary-adrenal system.'),
  'D001515': NtO(MH='Beer', MS='An alcoholic beverage usually made from malted cereal grain (as barley), flavored with hops, and brewed by slow fermentation.'),
  'D001516': NtO(MH='Bees', MS='Insect members of the superfamily Apoidea, found almost everywhere, particularly on flowers. About 3500 species occur in North America. They differ from most WASPS in that their young are fed honey and pollen rather than animal food.'),
  'D001517': NtO(MH='Coleoptera', MS='Order of winged insects also known as beetles comprising over 350,000 species in 150 families. They possess hard bodies with mouthparts adapted for chewing.'),
  'D001519': NtO(MH='Behavior', MS='The observable response of a man or animal to a situation.'),
  'D001520': NtO(MH='Behavior and Behavior Mechanisms', MS='The observable response made to a situation and the unconscious processes underlying it.'),
  'D001521': NtO(MH='Behavior Therapy', MS='The application of modern theories of learning and conditioning in the treatment of behavior disorders.'),
  'D001522': NtO(MH='Behavior, Animal', MS='The observable response an animal makes to any situation.'),
  'D001523': NtO(MH='Mental Disorders', MS='Psychiatric illness or diseases manifested by breakdowns in the adaptational process expressed primarily as abnormalities of thought, feeling, and behavior producing either distress or impairment of function.'),
  'D001524': NtO(MH='Behavioral Medicine', MS='The interdisciplinary field concerned with the development and integration of behavioral and biomedical science, knowledge, and techniques relevant to health and illness and the application of this knowledge and these techniques to prevention, diagnosis, treatment, and rehabilitation.'),
  'D001525': NtO(MH='Behavioral Sciences', MS='Disciplines concerned with the study of human and animal behavior.'),
  'D001526': NtO(MH='Behavioral Symptoms', MS='Observable manifestations of impaired psychological functioning.'),
  'D001527': NtO(MH='Behaviorism', MS='A psychologic theory, developed by John Broadus Watson, concerned with studying and measuring behaviors that are observable.'),
  'D001528': NtO(MH='Behcet Syndrome', MS='Rare chronic inflammatory disease involving the small blood vessels. It is of unknown etiology and characterized by mucocutaneous ulceration in the mouth and genital region and uveitis with hypopyon. The neuro-ocular form may cause blindness and death. SYNOVITIS; THROMBOPHLEBITIS; gastrointestinal ulcerations; RETINAL VASCULITIS; and OPTIC ATROPHY may occur as well.'),
  'D001530': NtO(MH='Belgium', MS='A country in Western Europe, bordering the North Sea, between France and the Netherlands. The capital is Brussels.'),
  'D001531': NtO(MH='Belize', MS='A country in CENTRAL AMERICA, bordering the Caribbean Sea, between GUATEMALA and MEXICO.'),
  'D001532': NtO(MH='Atropa belladonna', MS='A plant species of the genus ATROPA, family SOLANACEAE that contains ATROPINE; SCOPOLAMINE; BELLADONNA ALKALOIDS and other SOLANACEOUS ALKALOIDS. Some species in this genus are called deadly nightshade which is also a common name for SOLANUM.'),
  'D001533': NtO(MH='Belladonna Alkaloids', MS='Alkaloids obtained from various plants, especially the deadly nightshade (Atropa belladonna), variety acuminata; atropine, hyoscyamine and scopolamine are classical, specific antimuscarinic agents with many pharmacologic actions; used mainly as antispasmodics.'),
  'D001534': NtO(MH='Bemegride', MS='A CNS stimulant that is used to induce convulsions in experimental animals. It has also been used as a respiratory stimulant and in the treatment of barbiturate overdose.'),
  'D001535': NtO(MH='Benactyzine', MS='A centrally acting muscarinic antagonist. Benactyzine has been used in the treatment of depression and is used in research to investigate the role of cholinergic systems on behavior.'),
  'D001536': NtO(MH='Bence Jones Protein', MS='An abnormal protein with unusual thermosolubility characteristics that is found in the urine of patients with MULTIPLE MYELOMA.'),
  'D001537': NtO(MH='Bencyclane', MS='A vasodilator agent found to be effective in a variety of peripheral circulation disorders. It has various other potentially useful pharmacological effects. Its mechanism may involve block of calcium channels.'),
  'D001538': NtO(MH='Bender-Gestalt Test', MS='A psychological test consisting of nine geometric designs on cards. The subject is asked to redraw them from memory after each one is presented individually.'),
  'D001539': NtO(MH='Bendroflumethiazide', MS='A thiazide diuretic with actions and uses similar to those of HYDROCHLOROTHIAZIDE. It has been used in the treatment of familial hyperkalemia, hypertension, edema, and urinary tract disorders. (From Martindale, The Extra Pharmacopoeia, 30th ed, p810)'),
  'D001541': NtO(MH='Benin', MS='A country in western Africa, south of NIGER and between TOGO and NIGERIA. Its capital is Porto-Novo.'),
  'D001542': NtO(MH='Benomyl', MS='A systemic agricultural fungicide used for control of certain fungal diseases of stone fruit.'),
  'D001544': NtO(MH='Benperidol', MS='A butyrophenone with general properties similar to those of HALOPERIDOL. It has been used in the treatment of aberrant sexual behavior. (From Martindale, The Extra Pharmacopoeia, 30th ed, p567)'),
  'D001545': NtO(MH='Benserazide', MS='An inhibitor of DOPA DECARBOXYLASE that does not enter the central nervous system. It is often given with LEVODOPA in the treatment of parkinsonism to prevent the conversion of levodopa to dopamine in the periphery, thereby increasing the amount that reaches the central nervous system and reducing the required dose. It has no antiparkinson actions when given alone.'),
  'D001546': NtO(MH='Bentonite', MS='A colloidal, hydrated aluminum silicate that swells 12 times its dry size when added to water.'),
  'D001547': NtO(MH='Benzaldehydes', MS='Compounds that consist of a benzene ring with a formyl group. They occur naturally in the seeds of many fruits and are used as FLAVORING AGENTS and fragrances, as well as precursors in pharmaceutical and plastics manufacturing.'),
  'D001548': NtO(MH='Benzalkonium Compounds', MS='A mixture of alkylbenzyldimethylammonium compounds. It is a bactericidal quaternary ammonium detergent used topically in medicaments, deodorants, mouthwashes, as a surgical antiseptic, and as a as preservative and emulsifier in drugs and cosmetics.'),
  'D001549': NtO(MH='Benzamides', MS='BENZOIC ACID amides.'),
  'D001550': NtO(MH='Benzamidines', MS='Amidines substituted with a benzene group. Benzamidine and its derivatives are known as peptidase inhibitors.'),
  'D001551': NtO(MH='Benz(a)Anthracenes', MS='Four fused benzyl rings with three linear and one angular, that can be viewed as a benzyl-phenanthrenes. Compare with NAPHTHACENES which are four linear rings.'),
  'D001552': NtO(MH='Benzazepines', MS='Compounds with BENZENE fused to AZEPINES.'),
  'D001553': NtO(MH='Benzbromarone', MS='Uricosuric that acts by increasing uric acid clearance. It is used in the treatment of gout.'),
  'D001554': NtO(MH='Benzene', MS='Toxic, volatile, flammable liquid hydrocarbon byproduct of coal distillation. It is used as an industrial solvent in paints, varnishes, lacquer thinners, gasoline, etc. Benzene causes central nervous system damage acutely and bone marrow damage chronically and is carcinogenic. It was formerly used as parasiticide.'),
  'D001555': NtO(MH='Benzene Derivatives', MS='Organic compounds derived from BENZENE.'),
  'D001556': NtO(MH='Hexachlorocyclohexane', MS='Any of several polyhalogenated organic compounds consisting of a six-carbon ring with one chlorine and one hydrogen attached to each carbon.'),
  'D001557': NtO(MH='Benzenesulfonates', MS='Organic salts and esters of benzenesulfonic acid.'),
  'D001558': NtO(MH='Benzethonium', MS='Bactericidal cationic quaternary ammonium surfactant used as a topical anti-infective agent. It is an ingredient in medicaments, deodorants, mouthwashes, etc., and is used to disinfect apparatus, etc., in the food processing and pharmaceutical industries, in surgery, and also as a preservative. The compound is toxic orally as a result of neuromuscular blockade.'),
  'D001559': NtO(MH='Benzhydryl Compounds', MS='Compounds which contain the methyl radical substituted with two benzene rings. Permitted are any substituents, but ring fusion to any of the benzene rings is not allowed.'),
  'D001560': NtO(MH='Benzidines', MS='Very toxic industrial chemicals. They are absorbed through the skin, causing lethal blood, bladder, liver, and kidney damage and are potent, broad-spectrum carcinogens in most species.'),
  'D001561': NtO(MH='Benzilates', MS='Derivatives of benzylic acid, including its salts and esters,'),
  'D001562': NtO(MH='Benzimidazoles', MS='Compounds with a BENZENE fused to IMIDAZOLES.'),
  'D001564': NtO(MH='Benzo(a)pyrene', MS='A potent mutagen and carcinogen. It is a public health concern because of its possible effects on industrial workers, as an environmental pollutant, an as a component of tobacco smoke.'),
  'D001565': NtO(MH='Benzoates', MS='Derivatives of BENZOIC ACID. Included under this heading are a broad variety of acid forms, salts, esters, and amides that contain the carboxybenzene structure.'),
  'D001566': NtO(MH='Benzocaine', MS='A surface anesthetic that acts by preventing transmission of impulses along NERVE FIBERS and at NERVE ENDINGS.'),
  'D001567': NtO(MH='Benzocycloheptenes', MS='Compounds consisting of the cycloheptene ring with one or two BENZENE rings fused to it.'),
  'D001569': NtO(MH='Benzodiazepines', MS='A group of two-ring heterocyclic compounds consisting of a benzene ring fused to a diazepine ring.'),
  'D001570': NtO(MH='Benzodiazepinones', MS=None),
  'D001571': NtO(MH='Benzoflavones', MS='Organic compounds containing a BENZENE ring attached to a flavone group. Some of these are potent arylhydrocarbon hydroxylase inhibitors. They may also inhibit the binding of NUCLEIC ACIDS to BENZOPYRENES and related compounds. The designation includes all isomers; the 7,8-isomer is most frequently encountered.'),
  'D001572': NtO(MH='Benzofurans', MS='Compounds that contain a BENZENE ring fused to a furan ring.'),
  'D001573': NtO(MH='Benzoin', MS='A white crystalline compound prepared by condensation of benzaldehyde in potassium cyanide and used in organic syntheses. This should not be confused with benzoin gum from STYRAX.'),
  'D001574': NtO(MH='Benzolamide', MS='Selective renal carbonic anhydrase inhibitor. It may also be of use in certain cases of respiratory failure.'),
  'D001575': NtO(MH='Benzomorphans', MS='Morphine derivatives of the methanobenzazocine family that act as potent analgesics.'),
  'D001576': NtO(MH='Benzophenoneidum', MS='An aniline dye used as a disinfectant and an antiseptic agent. It is weakly fluorescing and binds specifically to certain proteins.'),
  'D001577': NtO(MH='Benzophenones', MS='Derivatives of benzophenone (with the structural formula phenyl-(C=O)-phenyl).'),
  'D001578': NtO(MH='Benzopyrans', MS='Compounds with a core of fused benzo-pyran rings.'),
  'D001579': NtO(MH='Benzopyrene Hydroxylase', MS='A drug-metabolizing, cytochrome P-448 (P-450) enzyme which catalyzes the hydroxylation of benzopyrene to 3-hydroxybenzopyrene in the presence of reduced flavoprotein and molecular oxygen. Also acts on certain anthracene derivatives. An aspect of EC 1.14.14.1.'),
  'D001580': NtO(MH='Benzopyrenes', MS='A class of chemicals that contain an anthracene ring with a naphthalene ring attached to it.'),
  'D001581': NtO(MH='Benzothiadiazines', MS='Heterocyclic compounds of a ring with SULFUR and two NITROGEN atoms fused to a BENZENE ring. Members inhibit SODIUM-POTASSIUM-CHLORIDE SYMPORTERS and are used as DIURETICS.'),
  'D001582': NtO(MH='Benzothiepins', MS=None),
  'D001583': NtO(MH='Benzoxazoles', MS=None),
  'D001584': NtO(MH='Benzoxepins', MS=None),
  'D001585': NtO(MH='Benzoyl Peroxide', MS='A peroxide derivative that has been used topically for BURNS and as a dermatologic agent in the treatment of ACNE and POISON IVY DERMATITIS. It is used also as a bleach in the food industry.'),
  'D001586': NtO(MH='Benzoylarginine Nitroanilide', MS='A chromogenic substrate that permits direct measurement of peptide hydrolase activity, e.g., papain and trypsin, by colorimetry. The substrate liberates p-nitroaniline as a chromogenic product.'),
  'D001587': NtO(MH='Benzoylarginine-2-Naphthylamide', MS='An enzyme substrate which permits the measurement of peptide hydrolase activity, e.g. trypsin and thrombin. The enzymes liberate 2-naphthylamine, which is measured by colorimetric procedures.'),
  'D001588': NtO(MH='Benzoylcholine', MS='The benzoic acid ester of choline.'),
  'D001589': NtO(MH='Benzphetamine', MS='A sympathomimetic agent with properties similar to DEXTROAMPHETAMINE. It is used in the treatment of obesity. (From Martindale, The Extra Pharmacopoeia, 30th ed, p1222)'),
  'D001590': NtO(MH='Benztropine', MS='A centrally active muscarinic antagonist that has been used in the symptomatic treatment of PARKINSON DISEASE. Benztropine also inhibits the uptake of dopamine.'),
  'D001591': NtO(MH='Benzydamine', MS='A benzyl-indazole having analgesic, antipyretic, and anti-inflammatory effects. It is used to reduce post-surgical and post-traumatic pain and edema and to promote healing. It is also used topically in treatment of RHEUMATIC DISEASES and INFLAMMATION of the mouth and throat.'),
  'D001592': NtO(MH='Benzyl Alcohols', MS='Alcohols derived from the aryl radical (C6H5CH2-) and defined by C6H5CHOH. The concept includes derivatives with any substituents on the benzene ring.'),
  'D001593': NtO(MH='Benzyl Compounds', MS='Benzene derivatives that contain a benzyl group with the general formula Phenyl-CH2-R.'),
  'D001594': NtO(MH='Benzyl Viologen', MS="1,1'-Bis(phenylmethyl)4,4'-bipyridinium dichloride. Oxidation-reduction indicator."),
  'D001595': NtO(MH='Benzylamine Oxidase', MS='An aspect of monoamine oxidase, EC 1.4.3.4. Catalyzes the oxidation of benzylamine to form benzaldehyde, ammonia and hydrogen peroxide.'),
  'D001596': NtO(MH='Benzylamines', MS='Toluenes in which one hydrogen of the methyl group is substituted by an amino group. Permitted are any substituents on the benzene ring or the amino group.'),
  'D001597': NtO(MH='Benzylidene Compounds', MS='Compounds which include a double-bonded carbon atom that is directly attached to a benzene ring. While this category is named after the highly-reactive compound benzylidene, the compounds listed under it occur through a variety of synthetic pathways.'),
  'D001598': NtO(MH='Bephenium Compounds', MS='Analogs or derivatives of bephenium (N,N-dimethyl-N-(2-phenoxyethyl)benzenemethanaminium).'),
  'D001599': NtO(MH='Berberine', MS='An alkaloid from Hydrastis canadensis L., Berberidaceae. It is also found in many other plants. It is relatively toxic parenterally, but has been used orally for various parasitic and fungal infections and as antidiarrheal.'),
  'D001600': NtO(MH='Berberine Alkaloids', MS='A group of related plant alkaloids that contain the BERBERINE heterocyclic ring structure.'),
  'D001601': NtO(MH='Bereavement', MS='Refers to the whole process of grieving and mourning and is associated with a deep sense of loss and sadness.'),
  'D001602': NtO(MH='Beriberi', MS='A disease caused by a deficiency of thiamine (vitamin B1) and characterized by polyneuritis, cardiac pathology, and edema. The epidemic form is found primarily in areas in which white (polished) rice is the staple food, as in Japan, China, the Philippines, India, and other countries of southeast Asia. (Dorland, 27th ed)'),
  'D001603': NtO(MH='Berkelium', MS='A man-made radioactive actinide with atomic symbol Bk, atomic number 97, and atomic weight 247. Its valence can be +3 or +4. Twelve isotopes have been produced with mass numbers 240-251.'),
  'D001604': NtO(MH='Berlin', MS='The capital of Germany.'),
  'D001605': NtO(MH='Bermuda', MS="A British colony in the western North Atlantic Ocean about 640 miles east southeast of Cape Hatteras, North Carolina. It comprises a group of about 300 islands of which only about 20 are inhabited. It is called also the Bermuda Islands or the Bermudas. It was named for the Spanish explorer Juan Bermudez who visited the islands in 1515. (From Webster's New Geographical Dictionary, 1988, p140 & Room, Brewer's Dictionary of Names, 1992, p61)"),
  'D001606': NtO(MH='Bernard-Soulier Syndrome', MS='A familial coagulation disorder characterized by a prolonged bleeding time, unusually large platelets, and impaired prothrombin consumption.'),
  'D001607': NtO(MH='Berylliosis', MS='A form of pneumoconiosis caused by inhaled rare metal BERYLLIUM or its soluble salts which are used in a wide variety of industry including alloys, ceramics, radiographic equipment, and vacuum tubes. Berylliosis is characterized by an acute inflammatory reaction in the upper airway leading to BRONCHIOLITIS; PULMONARY EDEMA; and pneumonia.'),
  'D001608': NtO(MH='Beryllium', MS='An element with the atomic symbol Be, atomic number 4, and atomic weight 9.01218. Short exposure to this element can lead to a type of poisoning known as BERYLLIOSIS.'),
  'D001609': NtO(MH='Beta-Globulins', MS='Serum proteins with an electrophoretic mobility that falls between ALPHA-GLOBULINS and GAMMA-GLOBULINS.'),
  'D001610': NtO(MH='Beta Particles', MS='High energy POSITRONS or ELECTRONS ejected from a disintegrating atomic nucleus.'),
  'D001611': NtO(MH='Beta Rhythm', MS='Brain waves with frequency between 15-30 Hz seen on EEG during wakefulness and mental activity.'),
  'D001613': NtO(MH='beta 2-Microglobulin', MS='An 11-kDa protein associated with the outer membrane of many cells including LYMPHOCYTES. It is the small subunit of MHC CLASS I MOLECULES. Association with beta 2-microglobulin is generally required for the transport of class I heavy chains from the endoplasmic reticulum to the cell surface. Beta 2-microglobulin is present in small amounts in serum, CEREBROSPINAL FLUID, and urine of healthy individuals, and to a much greater degree in the urine and plasma of patients with tubular PROTEINURIA, renal failure, or kidney transplants.'),
  'D001614': NtO(MH='beta-Amylase', MS='An enzyme that catalyzes the hydrolysis of 1,4-alpha-glycosidic linkages in starch, glycogen, and related polysaccharides and oligosaccharides so as to remove successive beta-maltose units from the non-reducing ends of the chains. EC 3.2.1.2.'),
  'D001615': NtO(MH='beta-Endorphin', MS='A 31-amino acid peptide that is the C-terminal fragment of BETA-LIPOTROPIN. It acts on OPIOID RECEPTORS and is an analgesic. Its first four amino acids at the N-terminal are identical to the tetrapeptide sequence of METHIONINE ENKEPHALIN and LEUCINE ENKEPHALIN.'),
  'D001616': NtO(MH='beta-Galactosidase', MS='A group of enzymes that catalyzes the hydrolysis of terminal, non-reducing beta-D-galactose residues in beta-galactosides. Deficiency of beta-Galactosidase A1 may cause GANGLIOSIDOSIS, GM1.'),
  'D001617': NtO(MH='beta-Glucosidase', MS='An exocellulase with specificity for a variety of beta-D-glycoside substrates. It catalyzes the hydrolysis of terminal non-reducing residues in beta-D-glucosides with release of GLUCOSE.'),
  'D001618': NtO(MH='beta-Lactamases', MS='Enzymes found in many bacteria which catalyze the hydrolysis of the amide bond in the beta-lactam ring. Well known antibiotics destroyed by these enzymes are penicillins and cephalosporins.'),
  'D001619': NtO(MH='beta-N-Acetylhexosaminidases', MS='A hexosaminidase specific for non-reducing N-acetyl-D-hexosamine residues in N-acetyl-beta-D-hexosaminides. It acts on GLUCOSIDES; GALACTOSIDES; and several OLIGOSACCHARIDES. Two specific mammalian isoenzymes of beta-N-acetylhexoaminidase are referred to as HEXOSAMINIDASE A and HEXOSAMINIDASE B. Deficiency of the type A isoenzyme causes TAY-SACHS DISEASE, while deficiency of both A and B isozymes causes SANDHOFF DISEASE. The enzyme has also been used as a tumor marker to distinguish between malignant and benign disease.'),
  'D001620': NtO(MH='beta-Thromboglobulin', MS='A platelet-specific protein which is released when platelets aggregate. Elevated plasma levels have been reported after deep venous thrombosis, pre-eclampsia, myocardial infarction with mural thrombosis, and myeloproliferative disorders. Measurement of beta-thromboglobulin in biological fluids by radioimmunoassay is used for the diagnosis and assessment of progress of thromboembolic disorders.'),
  'D001621': NtO(MH='Betahistine', MS='A histamine analog and H1 receptor agonist that serves as a vasodilator. It is used in MENIERE DISEASE and in vascular headaches but may exacerbate bronchial asthma and peptic ulcers.'),
  'D001622': NtO(MH='Betaine', MS='A naturally occurring compound that has been of interest for its role in osmoregulation. As a drug, betaine hydrochloride has been used as a source of hydrochloric acid in the treatment of hypochlorhydria. Betaine has also been used in the treatment of liver disorders, for hyperkalemia, for homocystinuria, and for gastrointestinal disturbances. (From Martindale, The Extra Pharmacopoeia, 30th ed, p1341)'),
  'D001623': NtO(MH='Betamethasone', MS='A glucocorticoid given orally, parenterally, by local injection, by inhalation, or applied topically in the management of various disorders in which corticosteroids are indicated. Its lack of mineralocorticoid properties makes betamethasone particularly suitable for treating cerebral edema and congenital adrenal hyperplasia. (From Martindale, The Extra Pharmacopoeia, 30th ed, p724)'),
  'D001624': NtO(MH='Betamethasone Valerate', MS='The 17-valerate derivative of BETAMETHASONE. It has substantial topical anti-inflammatory activity and relatively low systemic anti-inflammatory activity.'),
  'D001625': NtO(MH='Betazole', MS='A histamine H2 agonist used clinically to test gastric secretory function.'),
  'D001626': NtO(MH='Bethanechol Compounds', MS='Quaternary ammonium compounds that include BETHANECHOL.'),
  'D001627': NtO(MH='Bethanidine', MS='A guanidinium antihypertensive agent that acts by blocking adrenergic transmission. The precise mode of action is not clear.'),
  'D001628': NtO(MH='Beverages', MS='Liquids that are suitable for drinking. (From Merriam Webster Collegiate Dictionary, 10th ed)'),
  'D001629': NtO(MH='Bezafibrate', MS='An antilipemic agent that lowers CHOLESTEROL and TRIGLYCERIDES. It decreases LOW DENSITY LIPOPROTEINS and increases HIGH DENSITY LIPOPROTEINS.'),
  'D001630': NtO(MH='Bezoars', MS='Concretions of swallowed hair, fruit or vegetable fibers, or similar substances found in the alimentary canal.'),
  'D001631': NtO(MH='Bhutan', MS="A kingdom in the eastern Himalayas on the northeast border of India, bounded on the north by Tibet, on the east by Assam, on the south by Assam and West Bengal, and on the west by Sikkim and Tibet. From 1720 to 1970 it was under Chinese or Indian domination. In 1971 it became a member of the United Nations. The name comes from the Sanskrit bhota, the name for Tibet, + anta, end, with reference to its location at the southern extremity of Tibet. (From Webster's New Geographical Dictionary, 1988, p144 & Room, Brewer's Dictionary of Names, 1992, p64)"),
  'D001632': NtO(MH='Bibenzyls', MS='Compounds that include 1,2-diphenylethane in their structure.'),
  'D001633': NtO(MH='Bible', MS='The book composed of writings generally accepted by Christians as inspired by God and of divine authority. (Webster, 3d ed)'),
  'D001634': NtO(MH='Bibliographies as Topic', MS='Works about lists of books, articles, and other publications.'),
  'D001635': NtO(MH='Bibliography of Medicine', MS='A list of works, documents, and other publications on medical subjects and topics of interest to the field of medicine.'),
  'D001636': NtO(MH='Bibliography, Descriptive', MS="The area of bibliography which makes known precisely the material conditions of books, i.e., the full name of the author, the exact title of the work, the date and place of publication, the publisher's and printer's names, the format, the pagination, typographical particulars, illustrations, and the price, and for old books, other characteristics such as the kind of paper, binding, etc. It is also called analytical bibliography and physical bibliography. (Harrod's Librarians' Glossary, 7th ed)"),
  'D001637': NtO(MH='Bibliography, National', MS="A bibliography which lists all the books and other publications published, or distributed in significant quantity, in a particular country. Sometimes the term is used with respect to the new publications published within a specific period, and sometimes with respect to all those published within a lengthy period of many years. It is also used to indicate a bibliography of publications about a country (whether written by its nationals or not) and those written in the language of the country as well as those published in it. (Harrod's Librarians' Glossary, 7th ed)"),
  'D001638': NtO(MH='Bibliotherapy', MS='A form of supportive psychotherapy in which the patient is given carefully selected material to read.'),
  'D001639': NtO(MH='Bicarbonates', MS='Inorganic salts that contain the -HCO3 radical. They are an important factor in determining the pH of the blood and the concentration of bicarbonate ions is regulated by the kidney. Levels in the blood are an index of the alkali reserve or buffering capacity.'),
  'D001640': NtO(MH='Bicuculline', MS='An isoquinoline alkaloid obtained from Dicentra cucullaria and other plants. It is a competitive antagonist for GABA-A receptors.'),
  'D001641': NtO(MH='Bicuspid', MS='One of the eight permanent teeth, two on either side in each jaw, between the canines (CUSPID) and the molars (MOLAR), serving for grinding and crushing food. The upper have two cusps (bicuspid) but the lower have one to three. (Jablonski, Dictionary of Dentistry, 1992, p822)'),
  'D001642': NtO(MH='Bicycling', MS="The use of a bicycle for transportation or recreation. It does not include the use of a bicycle in studying the body's response to physical exertion (BICYCLE ERGOMETRY TEST see EXERCISE TEST)."),
  'D001643': NtO(MH='Bridged Bicyclo Compounds', MS='Saturated alicyclic hydrocarbon molecules consisting of two rings that have two non-adjacent atoms in common.'),
  'D001644': NtO(MH='Bifidobacterium', MS='A rod-shaped, gram-positive, non-acid-fast, non-spore-forming, non-motile bacterium that is a genus of the family Bifidobacteriaceae, order Bifidobacteriales, class ACTINOBACTERIA. It inhabits the intestines and feces of humans as well as the human vagina.'),
  'D001645': NtO(MH='Biguanides', MS='Derivatives of biguanide (the structure formula HN(C(NH)NH2)2) that are primarily used as oral HYPOGLYCEMIC AGENTS for the treatment of DIABETES MELLITUS, TYPE 2 and PREDIABETES.'),
  'D001646': NtO(MH='Bile', MS='An emulsifying agent produced in the LIVER and secreted into the DUODENUM. Its composition includes BILE ACIDS AND SALTS; CHOLESTEROL; and ELECTROLYTES. It aids DIGESTION of fats in the duodenum.'),
  'D001647': NtO(MH='Bile Acids and Salts', MS='Steroid acids and salts. The primary bile acids are derived from cholesterol in the liver and usually conjugated with glycine or taurine. The secondary bile acids are further modified by bacteria in the intestine. They play an important role in the digestion and absorption of fat. They have also been used pharmacologically, especially in the treatment of gallstones.'),
  'D001648': NtO(MH='Bile Canaliculi', MS='Minute intercellular channels that occur between liver cells and carry bile towards interlobar bile ducts. Also called bile capillaries.'),
  'D001649': NtO(MH='Bile Duct Diseases', MS='Diseases in any part of the ductal system of the BILIARY TRACT from the smallest BILE CANALICULI to the largest COMMON BILE DUCT.'),
  'D001650': NtO(MH='Bile Duct Neoplasms', MS='Tumors or cancer of the BILE DUCTS.'),
  'D001651': NtO(MH='Cholestasis, Extrahepatic', MS='Impairment of bile flow in the large BILE DUCTS by mechanical obstruction or stricture due to benign or malignant processes.'),
  'D001652': NtO(MH='Bile Ducts', MS='The channels that collect and transport the bile secretion from the BILE CANALICULI, the smallest branch of the BILIARY TRACT in the LIVER, through the bile ductules, the bile ducts out the liver, and to the GALLBLADDER for storage.'),
  'D001653': NtO(MH='Bile Ducts, Intrahepatic', MS='Passages within the liver for the conveyance of bile. Includes right and left hepatic ducts even though these may join outside the liver to form the common hepatic duct.'),
  'D001654': NtO(MH='Bile Pigments', MS='Linear TETRAPYRROLES that give a characteristic color to BILE including: BILIRUBIN; BILIVERDIN; and bilicyanin.'),
  'D001655': NtO(MH='Bile Reflux', MS='Retrograde bile flow. Reflux of bile can be from the duodenum to the stomach (DUODENOGASTRIC REFLUX); to the esophagus (GASTROESOPHAGEAL REFLUX); or to the PANCREAS.'),
  'D001656': NtO(MH='Biliary Atresia', MS='Progressive destruction or the absence of all or part of the extrahepatic BILE DUCTS, resulting in the complete obstruction of BILE flow. Usually, biliary atresia is found in infants and accounts for one third of the neonatal cholestatic JAUNDICE.'),
  'D001657': NtO(MH='Biliary Dyskinesia', MS='A motility disorder characterized by biliary COLIC, absence of GALLSTONES, and an abnormal GALLBLADDER ejection fraction. It is caused by gallbladder dyskinesia and/or SPHINCTER OF ODDI DYSFUNCTION.'),
  'D001658': NtO(MH='Biliary Fistula', MS='Abnormal passage in any organ of the biliary tract or between biliary organs and other organs.'),
  'D001659': NtO(MH='Biliary Tract', MS='The BILE DUCTS and the GALLBLADDER.'),
  'D001660': NtO(MH='Biliary Tract Diseases', MS='Diseases in any part of the BILIARY TRACT including the BILE DUCTS and the GALLBLADDER.'),
  'D001661': NtO(MH='Biliary Tract Neoplasms', MS='Tumors or cancer in the BILIARY TRACT including the BILE DUCTS and the GALLBLADDER.'),
  'D001662': NtO(MH='Biliary Tract Surgical Procedures', MS='Any surgical procedure performed on the biliary tract.'),
  'D001663': NtO(MH='Bilirubin', MS='A bile pigment that is a degradation product of HEME.'),
  'D001664': NtO(MH='Biliverdine', MS='1,3,6,7-Tetramethyl-4,5-dicarboxyethyl-2,8-divinylbilenone. Biosynthesized from hemoglobin as a precursor of bilirubin. Occurs in the bile of AMPHIBIANS and of birds, but not in normal human bile or serum.'),
  'D001665': NtO(MH='Binding Sites', MS='The parts of a macromolecule that directly participate in its specific combination with another molecule.'),
  'D001666': NtO(MH='Binding Sites, Antibody', MS='Local surface sites on antibodies which react with antigen determinant sites on antigens (EPITOPES.) They are formed from parts of the variable regions of FAB FRAGMENTS.'),
  'D001667': NtO(MH='Binding, Competitive', MS='The interaction of two or more substrates or ligands with the same binding site. The displacement of one by the other is used in quantitative and selective affinity measurements.'),
  'D001669': NtO(MH='Biochemical Phenomena', MS='The chemical processes, enzymatic activities, and pathways of living things and related temporal, dimensional, qualitative, and quantitative concepts.'),
  'D001671': NtO(MH='Biochemistry', MS='The study of the composition, chemical structures, and chemical reactions of living things.'),
  'D001672': NtO(MH='Biocompatible Materials', MS='Synthetic or natural materials, other than DRUGS, that are used to replace or repair any body TISSUES or bodily function.'),
  'D001673': NtO(MH='Biodegradation, Environmental', MS='Elimination of ENVIRONMENTAL POLLUTANTS; PESTICIDES and other waste using living organisms, usually involving intervention of environmental or sanitation engineers.'),
  'D001674': NtO(MH='Bioelectric Energy Sources', MS='Electric power supply devices which convert biological energy, such as chemical energy of metabolism or mechanical energy of periodic movements, into electrical energy.'),
  'D001675': NtO(MH='Bioethics', MS='A branch of applied ethics that studies the value implications of practices and developments in life sciences, medicine, and health care.'),
  'D001676': NtO(MH='Biofeedback, Psychology', MS="The therapy technique of providing the status of one's own AUTONOMIC NERVOUS SYSTEM function (e.g., skin temperature, heartbeats, brain waves) as visual or auditory feedback in order to self-control related conditions (e.g., hypertension, migraine headaches)."),
  'D001678': NtO(MH='Organelle Biogenesis', MS='The natural growth and development within living CELLS.'),
  'D001679': NtO(MH='Biogenic Amines', MS='A group of naturally occurring amines derived by enzymatic decarboxylation of the natural amino acids. Many have powerful physiological effects (e.g., histamine, serotonin, epinephrine, tyramine). Those derived from aromatic amino acids, and also their synthetic analogs (e.g., amphetamine), are of use in pharmacology.'),
  'D001680': NtO(MH='Biographies as Topic', MS="Works about a written account of a person's life and the branch of literature concerned with the lives of people."),
  'D001681': NtO(MH='Biological Assay', MS='A method of measuring the effects of a biologically active substance using an intermediate in vivo or in vitro tissue or cell model under controlled conditions. It includes virulence studies in animal fetuses in utero, mouse convulsion bioassay of insulin, quantitation of tumor-initiator systems in mouse skin, calculation of potentiating effects of a hormonal factor in an isolated strip of contracting stomach muscle, etc.'),
  'D001682': NtO(MH='Biological Availability', MS='The extent to which the active ingredient of a drug dosage form becomes available at the site of drug action or in a biological medium believed to reflect accessibility to a site of action.'),
  'D001683': NtO(MH='Biological Clocks', MS='The physiological mechanisms that govern the rhythmic occurrence of certain biochemical, physiological, and behavioral phenomena.'),
  'D001684': NtO(MH='Biological Dressings', MS='Human or animal tissue used as temporary wound coverings.'),
  'D001685': NtO(MH='Biological Factors', MS='Endogenously-synthesized compounds that influence biological processes not otherwise classified under ENZYMES; HORMONES or HORMONE ANTAGONISTS.'),
  'D001686': NtO(MH='Biological Phenomena', MS='Biological processes, properties, and characteristics of the whole organism in human, animal, microorganisms, and plants, and of the biosphere.'),
  'D001688': NtO(MH='Biological Products', MS='Complex pharmaceutical substances, preparations, or matter derived from organisms usually obtained by biological methods or assay.'),
  'D001689': NtO(MH='Biological Psychiatry', MS='An interdisciplinary science concerned with studies of the biological bases of behavior - biochemical, genetic, physiological, and neurological - and applying these to the understanding and treatment of mental illness.'),
  'D001690': NtO(MH='Biological Science Disciplines', MS='All of the divisions of the natural sciences dealing with the various aspects of the phenomena of life and vital processes. The concept includes anatomy and physiology, biochemistry and biophysics, and the biology of animals, plants, and microorganisms. It should be differentiated from BIOLOGY, one of its subdivisions, concerned specifically with the origin and life processes of living organisms.'),
  'D001691': NtO(MH='Biological Therapy', MS='Treatment of diseases with biological materials or biological response modifiers, such as the use of GENES; CELLS; TISSUES; organs; SERUM; VACCINES; and humoral agents.'),
  'D001692': NtO(MH='Biological Transport', MS='The movement of materials (including biochemical substances and drugs) through a biological system at the cellular level. The transport can be across cell membranes and epithelial layers. It also can occur within intracellular compartments and extracellular compartments.'),
  'D001693': NtO(MH='Biological Transport, Active', MS='The movement of materials across cell membranes and epithelial layers against an electrochemical gradient, requiring the expenditure of metabolic energy.'),
  'D001694': NtO(MH='Biological Warfare', MS='Warfare involving the use of living organisms or their products as disease etiologic agents against people, animals, or plants.'),
  'D001695': NtO(MH='Biology', MS='One of the BIOLOGICAL SCIENCE DISCIPLINES concerned with the origin, structure, development, growth, function, genetics, and reproduction of animals, plants, and microorganisms.'),
  'D001696': NtO(MH='Biomechanical Phenomena', MS='The properties, processes, and behavior of biological systems under the action of mechanical forces.'),
  'D001697': NtO(MH='Biomedical and Dental Materials', MS='Substances used in biomedicine or dentistry predominantly for their physical, as opposed to chemical, properties.'),
  'D001698': NtO(MH='Biomedical Engineering', MS='Application of principles and practices of engineering science to biomedical research and health care.'),
  'D001699': NtO(MH='Biometry', MS='The use of statistical and mathematical methods to analyze biological observations and phenomena.'),
  'D001700': NtO(MH='Biomphalaria', MS='A genus of planorbid freshwater snails, species of which are intermediate hosts of Schistosoma mansoni.'),
  'D001701': NtO(MH='Bionics', MS='The study of systems, particularly electronic systems, which function after the manner of, in a manner characteristic of, or resembling living systems. Also, the science of applying biological techniques and principles to the design of electronic systems.'),
  'D001702': NtO(MH='Biopharmaceutics', MS='The study of the physical and chemical properties of a drug and its dosage form as related to the onset, duration, and intensity of its action.'),
  'D001703': NtO(MH='Biophysics', MS='The study of PHYSICAL PHENOMENA and PHYSICAL PROCESSES as applied to living things.'),
  'D001704': NtO(MH='Biopolymers', MS='Polymers synthesized by living organisms. They play a role in the formation of macromolecular structures and are synthesized via the covalent linkage of biological molecules, especially AMINO ACIDS; NUCLEOTIDES; and CARBOHYDRATES.'),
  'D001705': NtO(MH='Bioprosthesis', MS='Prosthesis, usually heart valve, composed of biological material and whose durability depends upon the stability of the material after pretreatment, rather than regeneration by host cell ingrowth. Durability is achieved 1, mechanically by the interposition of a cloth, usually polytetrafluoroethylene, between the host and the graft, and 2, chemically by stabilization of the tissue by intermolecular linking, usually with glutaraldehyde, after removal of antigenic components, or the use of reconstituted and restructured biopolymers.'),
  'D001706': NtO(MH='Biopsy', MS='Removal and pathologic examination of specimens from the living body.'),
  'D001707': NtO(MH='Biopsy, Needle', MS='Removal and examination of tissue obtained through a transdermal needle inserted into the specific region, organ, or tissue being analyzed.'),
  'D001708': NtO(MH='Biopterin', MS='A natural product that has been considered as a growth factor for some insects.'),
  'D001709': NtO(MH='Biotechnology', MS='Body of knowledge related to the use of organisms, cells or cell-derived constituents for the purpose of developing products which are technically, scientifically and clinically useful. Alteration of biologic function at the molecular level (i.e., GENETIC ENGINEERING) is a central focus; laboratory methods used include TRANSFECTION and CLONING technologies, sequence and structure analysis algorithms, computer databases, and gene and protein structure function analysis and prediction.'),
  'D001710': NtO(MH='Biotin', MS='A water-soluble, enzyme co-factor present in minute amounts in every living cell. It occurs mainly bound to proteins or polypeptides and is abundant in liver, kidney, pancreas, yeast, and milk.'),
  'D001711': NtO(MH='Biotransformation', MS='The chemical alteration of an exogenous substance by or in a biological system. The alteration may inactivate the compound or it may result in the production of an active metabolite of an inactive parent compound. The alterations may be divided into METABOLIC DETOXICATION, PHASE I and METABOLIC DETOXICATION, PHASE II.'),
  'D001712': NtO(MH='Biperiden', MS='A muscarinic antagonist that has effects in both the central and peripheral nervous systems. It has been used in the treatment of arteriosclerotic, idiopathic, and postencephalitic parkinsonism. It has also been used to alleviate extrapyramidal symptoms induced by phenothiazine derivatives and reserpine.'),
  'D001713': NtO(MH='Biphenyl Compounds', MS='Whitish aromatic crystalline organic compounds made up of two conjoined BENZENE rings.'),
  'D001714': NtO(MH='Bipolar Disorder', MS='A major affective disorder marked by severe mood swings (manic or major depressive episodes) and a tendency to remission and recurrence.'),
  'D001715': NtO(MH='Bird Diseases', MS='Diseases of birds not considered poultry, therefore usually found in zoos, parks, and the wild. The concept is differentiated from POULTRY DISEASES which is for birds raised as a source of meat or eggs for human consumption, and usually found in barnyards, hatcheries, etc.'),
  'D001716': NtO(MH="Bird Fancier's Lung", MS='A form of alveolitis or pneumonitis due to an acquired hypersensitivity to inhaled avian antigens, usually proteins in the dust of bird feathers and droppings.'),
  'D001717': NtO(MH='Birds', MS='Warm-blooded VERTEBRATES possessing FEATHERS and belonging to the class Aves.'),
  'D001718': NtO(MH='Birefringence', MS='The property of nonisotropic media, such as crystals, whereby a single incident beam of light traverses the medium as two beams, each plane-polarized, the planes being at right angles to each other. (Cline et al., Dictionary of Visual Science, 4th ed)'),
  'D001719': NtO(MH='Birth Certificates', MS="Official certifications by a physician recording the individual's birth date, place of birth, parentage and other required identifying data which are filed with the local registrar of vital statistics."),
  'D001720': NtO(MH='Birth Injuries', MS='Mechanical or anoxic trauma incurred by the infant during labor or delivery.'),
  'D001721': NtO(MH='Birth Intervals', MS='The lengths of intervals between births to women in the population.'),
  'D001722': NtO(MH='Birth Order', MS='The sequence in which children are born into the family.'),
  'D001723': NtO(MH='Birth Rate', MS='The number of births in a given population per year or other unit of time.'),
  'D001724': NtO(MH='Birth Weight', MS='The mass or quantity of heaviness of an individual at BIRTH. It is expressed by units of pounds or kilograms.'),
  'D001725': NtO(MH='Bis(Chloromethyl) Ether', MS='A substance that is an irritant to the eyes and respiratory tract and may be carcinogenic.'),
  'D001726': NtO(MH='Bisacodyl', MS='A diphenylmethane stimulant laxative used for the treatment of CONSTIPATION and for bowel evacuation. (From Martindale, The Extra Pharmacopoeia, 30th ed, p871)'),
  'D001727': NtO(MH='Bisexuality', MS='The sexual attraction or relationship between members of both the same and the opposite SEX.'),
  'D001728': NtO(MH='Dicumarol', MS='An oral anticoagulant that interferes with the metabolism of vitamin K. It is also used in biochemical experiments as an inhibitor of reductases.'),
  'D001729': NtO(MH='Bismuth', MS='A metallic element that has the atomic symbol Bi, and atomic number 83. Its principal isotope is Bismuth 209.'),
  'D001731': NtO(MH='Bisphosphoglycerate Mutase', MS='An enzyme that catalyzes the transfer of phosphate from C-3 of 1,3-diphosphoglycerate to C-2 of 3-phosphoglycerate, forming 2,3-diphosphoglycerate. EC 5.4.2.4.'),
  'D001732': NtO(MH='Bite Force', MS='The force applied by the masticatory muscles in dental occlusion.'),
  'D001733': NtO(MH='Bites and Stings', MS='Injuries inflicted by the TEETH or poisoning caused by VENOMS of animals.'),
  'D001734': NtO(MH='Bites, Human', MS='Bites inflicted by humans.'),
  'D001735': NtO(MH='Bithionol', MS='Halogenated anti-infective agent that is used against trematode and cestode infestations.'),
  'D001736': NtO(MH='Biureas', MS=None),
  'D001737': NtO(MH='Biuret', MS='Used as feed supplement for sheep and cattle since it is a good non-protein nitrogen source. In strongly alkaline solution biuret gives a violet color with copper sulfate.'),
  'D001738': NtO(MH='Biuret Reaction', MS='A reaction characterized by a violet color upon the addition of copper sulfate to all compounds with two amide or peptide bonds linked directly or through an intermediate carbon atom. Used in the detection and estimation of proteins and peptides having more than two amino acids.'),
  'D001739': NtO(MH='BK Virus', MS='A species of POLYOMAVIRUS apparently infecting over 90% of children but not clearly associated with any clinical illness in childhood. The virus remains latent in the body throughout life and can be reactivated under certain circumstances.'),
  'D001740': NtO(MH='Black Widow Spider', MS='A venomous New World spider with an hourglass-shaped red mark on the abdomen.'),
  'D001741': NtO(MH='African Americans', MS='Persons living in the United States having origins in any of the black groups of Africa.'),
  'D001742': NtO(MH='Blackwater Fever', MS='A complication of MALARIA, FALCIPARUM characterized by the passage of dark red to black urine.'),
  'D001743': NtO(MH='Urinary Bladder', MS='A musculomembranous sac along the URINARY TRACT. URINE flows from the KIDNEYS into the bladder via the ureters (URETER), and is held there until URINATION.'),
  'D001744': NtO(MH='Urinary Bladder Calculi', MS='Stones in the URINARY BLADDER; also known as vesical calculi, bladder stones, or cystoliths.'),
  'D001745': NtO(MH='Urinary Bladder Diseases', MS='Pathological processes of the URINARY BLADDER.'),
  'D001746': NtO(MH='Bladder Exstrophy', MS='A birth defect in which the URINARY BLADDER is malformed and exposed, inside out, and protruded through the ABDOMINAL WALL. It is caused by closure defects involving the top front surface of the bladder, as well as the lower abdominal wall; SKIN; MUSCLES; and the pubic bone.'),
  'D001747': NtO(MH='Urinary Bladder Fistula', MS='An abnormal passage in the URINARY BLADDER or between the bladder and any surrounding organ.'),
  'D001748': NtO(MH='Urinary Bladder Neck Obstruction', MS='Blocked urine flow through the bladder neck, the narrow internal urethral opening at the base of the URINARY BLADDER. Narrowing or strictures of the URETHRA can be congenital or acquired. It is often observed in males with enlarged PROSTATE glands.'),
  'D001749': NtO(MH='Urinary Bladder Neoplasms', MS='Tumors or cancer of the URINARY BLADDER.'),
  'D001750': NtO(MH='Urinary Bladder, Neurogenic', MS='Dysfunction of the URINARY BLADDER due to disease of the central or peripheral nervous system pathways involved in the control of URINATION. This is often associated with SPINAL CORD DISEASES, but may also be caused by BRAIN DISEASES or PERIPHERAL NERVE DISEASES.'),
  'D001751': NtO(MH='Blade Implantation', MS='Insertion of an endosseous implant with a narrow wedge-shaped infrastructure extending through the oral mucosa into the mouth and bearing openings or vents through which tissue grows to obtain retention.'),
  'D001752': NtO(MH='Blast Crisis', MS='An advanced phase of chronic myelogenous leukemia, characterized by a rapid increase in the proportion of immature white blood cells (blasts) in the blood and bone marrow to greater than 30%.'),
  'D001753': NtO(MH='Blast Injuries', MS='Injuries resulting when a person is struck by particles impelled with violent force from an explosion. Blast causes pulmonary concussion and hemorrhage, laceration of other thoracic and abdominal viscera, ruptured ear drums, and minor effects in the central nervous system. (From Dorland, 27th ed)'),
  'D001754': NtO(MH='Blastocladiella', MS='A genus of aquatic fungi of the family Blastocladiaceae, order Blastocladiales, used in the study of zoospore formation.'),
  'D001755': NtO(MH='Blastocyst', MS='A post-MORULA preimplantation mammalian embryo that develops from a 32-cell stage into a fluid-filled hollow ball of over a hundred cells. A blastocyst has two distinctive tissues. The outer layer of trophoblasts gives rise to extra-embryonic tissues. The inner cell mass gives rise to the embryonic disc and eventual embryo proper.'),
  'D001756': NtO(MH='Blastoderm', MS='A layer of cells lining the fluid-filled cavity (blastocele) of a BLASTULA, usually developed from a fertilized insect, reptilian, or avian egg.'),
  'D001757': NtO(MH='Blastomeres', MS='Undifferentiated cells resulting from cleavage of a fertilized egg (ZYGOTE). Inside the intact ZONA PELLUCIDA, each cleavage yields two blastomeres of about half size of the parent cell. Up to the 8-cell stage, all of the blastomeres are totipotent. The 16-cell MORULA contains outer cells and inner cells.'),
  'D001758': NtO(MH='Blastomyces', MS='A genus of onygenacetous mitosporic fungi whose perfect state is Ajellomyces (see ONYGENALES). The species Blastomyces dermatitidis (perfect state Ajellomyces dermatitidis) causes blastomycosis.'),
  'D001759': NtO(MH='Blastomycosis', MS='A fungal infection that may appear in two forms: 1, a primary lesion characterized by the formation of a small cutaneous nodule and small nodules along the lymphatics that may heal within several months; and 2, chronic granulomatous lesions characterized by thick crusts, warty growths, and unusual vascularity and infection in the middle or upper lobes of the lung.'),
  'D001760': NtO(MH='Bleeding Time', MS='Duration of blood flow after skin puncture. This test is used as a measure of capillary and platelet function.'),
  'D001761': NtO(MH='Bleomycin', MS='A complex of related glycopeptide antibiotics from Streptomyces verticillus consisting of bleomycin A2 and B2. It inhibits DNA metabolism and is used as an antineoplastic, especially for solid tumors.'),
  'D001762': NtO(MH='Blepharitis', MS='Inflammation of the eyelids.'),
  'D001763': NtO(MH='Blepharoptosis', MS='Drooping of the upper lid due to deficient development or paralysis of the levator palpebrae muscle.'),
  'D001764': NtO(MH='Blepharospasm', MS='Excessive winking; tonic or clonic spasm of the orbicularis oculi muscle.'),
  'D001765': NtO(MH='Blind Loop Syndrome', MS='A malabsorption syndrome that is associated with a blind loop in the upper SMALL INTESTINE that is characterized by the lack of peristaltic movement, stasis of INTESTINAL CONTENTS, and the overgrowth of BACTERIA. Such bacterial overgrowth interferes with BILE SALTS action, FATTY ACIDS processing, MICROVILLI integrity, and the ABSORPTION of nutrients such as VITAMIN B12 and FOLIC ACID.'),
  'D001766': NtO(MH='Blindness', MS='The inability to see or the loss or absence of perception of visual stimuli. This condition may be the result of EYE DISEASES; OPTIC NERVE DISEASES; OPTIC CHIASM diseases; or BRAIN DISEASES affecting the VISUAL PATHWAYS or OCCIPITAL LOBE.'),
  'D001767': NtO(MH='Blinking', MS='Brief closing of the eyelids by involuntary normal periodic closing, as a protective measure, or by voluntary action.'),
  'D001768': NtO(MH='Blister', MS='Visible accumulations of fluid within or beneath the epidermis.'),
  'D001769': NtO(MH='Blood', MS='The body fluid that circulates in the vascular system (BLOOD VESSELS). Whole blood includes PLASMA and BLOOD CELLS.'),
  'D001770': NtO(MH='Blood Bactericidal Activity', MS="The natural bactericidal property of BLOOD due to normally occurring antibacterial substances such as beta lysin, leukin, etc. This activity needs to be distinguished from the bactericidal activity contained in a patient's serum as a result of antimicrobial therapy, which is measured by a SERUM BACTERICIDAL TEST."),
  'D001771': NtO(MH='Blood Banks', MS='Centers for collecting, characterizing and storing blood or plasma.'),
  'D001772': NtO(MH='Blood Cell Count', MS='The number of LEUKOCYTES and ERYTHROCYTES per unit volume in a sample of venous BLOOD. A complete blood count (CBC) also includes measurement of the HEMOGLOBIN; HEMATOCRIT; and ERYTHROCYTE INDICES.'),
  'D001773': NtO(MH='Blood Cells', MS='The cells found in the body fluid circulating throughout the CARDIOVASCULAR SYSTEM.'),
  'D001774': NtO(MH='Blood Chemical Analysis', MS='An examination of chemicals in the blood.'),
  'D001775': NtO(MH='Blood Circulation', MS='The movement of the BLOOD as it is pumped through the CARDIOVASCULAR SYSTEM.'),
  'D001776': NtO(MH='Blood Circulation Time', MS='Determination of the shortest time interval between the injection of a substance in the vein and its arrival at some distant site in sufficient concentration to produce a recognizable end result. It represents approximately the inverse of the average velocity of blood flow between two points.'),
  'D001777': NtO(MH='Blood Coagulation', MS='The process of the interaction of BLOOD COAGULATION FACTORS that results in an insoluble FIBRIN clot.'),
  'D001778': NtO(MH='Blood Coagulation Disorders', MS='Hemorrhagic and thrombotic disorders that occur as a consequence of abnormalities in blood coagulation due to a variety of factors such as COAGULATION PROTEIN DISORDERS; BLOOD PLATELET DISORDERS; BLOOD PROTEIN DISORDERS or nutritional conditions.'),
  'D001779': NtO(MH='Blood Coagulation Factors', MS='Endogenous substances, usually proteins, that are involved in the blood coagulation process.'),
  'D001780': NtO(MH='Blood Coagulation Tests', MS="Laboratory tests for evaluating the individual's clotting mechanism."),
  'D001781': NtO(MH='Blood Component Removal', MS='Any procedure in which blood is withdrawn from a donor, a portion is separated and retained, at the same time the remainder is returned to the donor.'),
  'D001782': NtO(MH='Blood Donors', MS=None),
  'D001783': NtO(MH='Blood Flow Velocity', MS='A value equal to the total volume flow divided by the cross-sectional area of the vascular bed.'),
  'D001784': NtO(MH='Blood Gas Analysis', MS='Measurement of oxygen and carbon dioxide in the blood.'),
  'D001785': NtO(MH='Blood Gas Monitoring, Transcutaneous', MS='The noninvasive measurement or determination of the partial pressure (tension) of oxygen and/or carbon dioxide locally in the capillaries of a tissue by the application to the skin of a special set of electrodes. These electrodes contain photoelectric sensors capable of picking up the specific wavelengths of radiation emitted by oxygenated versus reduced hemoglobin.'),
  'D001786': NtO(MH='Blood Glucose', MS='Glucose in blood.'),
  'D001787': NtO(MH='Blood Group Incompatibility', MS="An antigenic mismatch between donor and recipient blood. Antibodies present in the recipient's serum may be directed against antigens in the donor product. Such a mismatch may result in a transfusion reaction in which, for example, donor blood is hemolyzed. (From Saunders Dictionary & Encyclopedia of Laboratory Medicine and Technology, 1984)."),
  'D001788': NtO(MH='Blood Grouping and Crossmatching', MS='Testing erythrocytes to determine presence or absence of blood-group antigens, testing of serum to determine the presence or absence of antibodies to these antigens, and selecting biocompatible blood by crossmatching samples from the donor against samples from the recipient. Crossmatching is performed prior to transfusion.'),
  'D001789': NtO(MH='Blood Group Antigens', MS='Sets of cell surface antigens located on BLOOD CELLS. They are usually membrane GLYCOPROTEINS or GLYCOLIPIDS that are antigenically distinguished by their carbohydrate moieties.'),
  'D001790': NtO(MH='Blood Physiological Phenomena', MS='Physiological processes and properties of the BLOOD.'),
  'D001791': NtO(MH='Blood Platelet Disorders', MS='Disorders caused by abnormalities in platelet count or function.'),
  'D001792': NtO(MH='Blood Platelets', MS='Non-nucleated disk-shaped cells formed in the megakaryocyte and found in the blood of all mammals. They are mainly involved in blood coagulation.'),
  'D001793': NtO(MH='Blood Preservation', MS='The process by which blood or its components are kept viable outside of the organism from which they are derived (i.e., kept from decay by means of a chemical agent, cooling, or a fluid substitute that mimics the natural state within the organism).'),
  'D001794': NtO(MH='Blood Pressure', MS='PRESSURE of the BLOOD on the ARTERIES and other BLOOD VESSELS.'),
  'D001795': NtO(MH='Blood Pressure Determination', MS='Techniques used for measuring BLOOD PRESSURE.'),
  'D001796': NtO(MH='Blood Protein Disorders', MS='Hematologic diseases caused by structural or functional defects of BLOOD PROTEINS.'),
  'D001797': NtO(MH='Blood Protein Electrophoresis', MS='Electrophoresis applied to BLOOD PROTEINS.'),
  'D001798': NtO(MH='Blood Proteins', MS='Proteins that are present in blood serum, including SERUM ALBUMIN; BLOOD COAGULATION FACTORS; and many other types of proteins.'),
  'D001799': NtO(MH='Blood Sedimentation', MS='Measurement of rate of settling of erythrocytes in anticoagulated blood.'),
  'D001800': NtO(MH='Blood Specimen Collection', MS='The taking of a blood sample to determine its character as a whole, to identify levels of its component cells, chemicals, gases, or other constituents, to perform pathological examination, etc.'),
  'D001801': NtO(MH='Blood Stains', MS='Antigenic characteristics and DNA fingerprint patterns identified from blood stains. Their primary value is in criminal cases.'),
  'D001802': NtO(MH='Blood Substitutes', MS='Substances that are used in place of blood, for example, as an alternative to BLOOD TRANSFUSIONS after blood loss to restore BLOOD VOLUME and oxygen-carrying capacity to the blood circulation, or to perfuse isolated organs.'),
  'D001803': NtO(MH='Blood Transfusion', MS='The introduction of whole blood or blood component directly into the blood stream. (Dorland, 27th ed)'),
  'D001804': NtO(MH='Blood Transfusion, Autologous', MS="Reinfusion of blood or blood products derived from the patient's own circulation. (Dorland, 27th ed)"),
  'D001805': NtO(MH='Blood Transfusion, Intrauterine', MS='In utero transfusion of BLOOD into the FETUS for the treatment of FETAL DISEASES, such as fetal erythroblastosis (ERYTHROBLASTOSIS, FETAL).'),
  'D001806': NtO(MH='Blood Urea Nitrogen', MS='The urea concentration of the blood stated in terms of nitrogen content. Serum (plasma) urea nitrogen is approximately 12% higher than blood urea nitrogen concentration because of the greater protein content of red blood cells. Increases in blood or serum urea nitrogen are referred to as azotemia and may have prerenal, renal, or postrenal causes. (From Saunders Dictionary & Encyclopedia of Laboratory Medicine and Technology, 1984)'),
  'D001807': NtO(MH='Blood Vessel Prosthesis', MS='Device constructed of either synthetic or biological material that is used for the repair of injured or diseased blood vessels.'),
  'D001808': NtO(MH='Blood Vessels', MS='Any of the tubular vessels conveying the blood (arteries, arterioles, capillaries, venules, and veins).'),
  'D001809': NtO(MH='Blood Viscosity', MS='The internal resistance of the BLOOD to shear forces. The in vitro measure of whole blood viscosity is of limited clinical utility because it bears little relationship to the actual viscosity within the circulation, but an increase in the viscosity of circulating blood can contribute to morbidity in patients suffering from disorders such as SICKLE CELL ANEMIA and POLYCYTHEMIA.'),
  'D001810': NtO(MH='Blood Volume', MS='Volume of circulating BLOOD. It is the sum of the PLASMA VOLUME and ERYTHROCYTE VOLUME.'),
  'D001811': NtO(MH='Blood Volume Determination', MS='Method for determining the circulating blood volume by introducing a known quantity of foreign substance into the blood and determining its concentration some minutes later when thorough mixing has occurred. From these two values the blood volume can be calculated by dividing the quantity of injected material by its concentration in the blood at the time of uniform mixing. Generally expressed as cubic centimeters or liters per kilogram of body weight.'),
  'D001812': NtO(MH='Blood-Brain Barrier', MS='Specialized non-fenestrated tightly-joined ENDOTHELIAL CELLS with TIGHT JUNCTIONS that form a transport barrier for certain substances between the cerebral capillaries and the BRAIN tissue.'),
  'D001813': NtO(MH='Blood-Retinal Barrier', MS='A specialized transport barrier, in the EYE, formed by the retinal pigment EPITHELIUM, and the ENDOTHELIUM of the BLOOD VESSELS of the RETINA. TIGHT JUNCTIONS joining adjacent cells keep the barrier between cells continuous.'),
  'D001814': NtO(MH='Blood-Testis Barrier', MS='A specialized barrier, in the TESTIS, between the interstitial BLOOD compartment and the adluminal compartment of the SEMINIFEROUS TUBULES. The barrier is formed by layers of cells from the VASCULAR ENDOTHELIUM of the capillary BLOOD VESSELS, to the SEMINIFEROUS EPITHELIUM of the seminiferous tubules. TIGHT JUNCTIONS form between adjacent SERTOLI CELLS, as well as between the ENDOTHELIAL CELLS.'),
  'D001815': NtO(MH='Bloodletting', MS='Puncture of a vein to draw blood for therapeutic purposes. Bloodletting therapy has been used in Talmudic and Indian medicine since the medieval time, and was still practiced widely in the 18th and 19th centuries. Its modern counterpart is PHLEBOTOMY.'),
  'D001816': NtO(MH='Bloom Syndrome', MS='An autosomal recessive disorder characterized by telangiectatic ERYTHEMA of the face, photosensitivity, DWARFISM and other abnormalities, and a predisposition toward developing cancer. The Bloom syndrome gene (BLM) encodes a RecQ-like DNA helicase.'),
  'D001819': NtO(MH='Bluetongue', MS='A reovirus infection, chiefly of sheep, characterized by a swollen blue tongue, catarrhal inflammation of upper respiratory and gastrointestinal tracts, and often by inflammation of sensitive laminae of the feet and coronet.'),
  'D001820': NtO(MH='Bluetongue virus', MS='The type species of ORBIVIRUS causing a serious disease in sheep, especially lambs. It may also infect wild ruminants and other domestic animals.'),
  'D001821': NtO(MH='Blushing', MS='Involuntary reddening, especially of the face, associated with feelings of embarrassment, confusion or shame.'),
  'D001822': NtO(MH='Body Burden', MS='The total amount of a chemical, metal or radioactive substance present at any time after absorption in the body of man or animal.'),
  'D001823': NtO(MH='Body Composition', MS='The relative amounts of various components in the body, such as percentage of body fat.'),
  'D001824': NtO(MH='Body Constitution', MS='The physical characteristics of the body, including the mode of performance of functions, the activity of metabolic processes, the manner and degree of reactions to stimuli, and power of resistance to the attack of pathogenic organisms.'),
  'D001825': NtO(MH='Body Fluid Compartments', MS='The two types of spaces between which water and other body fluids are distributed: extracellular and intracellular.'),
  'D001826': NtO(MH='Body Fluids', MS='Liquid components of living organisms.'),
  'D001827': NtO(MH='Body Height', MS='The distance from the sole to the crown of the head with body standing on a flat surface and fully extended.'),
  'D001828': NtO(MH='Body Image', MS="Individuals' concept of their own bodies."),
  'D001829': NtO(MH='Body Regions', MS='Anatomical areas of the body.'),
  'D001830': NtO(MH='Body Surface Area', MS='The two dimensional measure of the outer layer of the body.'),
  'D001831': NtO(MH='Body Temperature', MS='The measure of the level of heat of a human or animal.'),
  'D001832': NtO(MH='Body Temperature Changes', MS='Significant alterations in temperature of the human body, above or below 98.6 degrees F. or 37 degrees C. when taken orally.'),
  'D001833': NtO(MH='Body Temperature Regulation', MS='The processes of heating and cooling that an organism uses to control its temperature.'),
  'D001834': NtO(MH='Body Water', MS='Fluids composed mainly of water found within the body.'),
  'D001835': NtO(MH='Body Weight', MS='The mass or quantity of heaviness of an individual. It is expressed by units of pounds or kilograms.'),
  'D001836': NtO(MH='Body Weight Changes', MS="A clinical manifestation consisting of alterations in an individual's weight from his or her norm."),
  'D001837': NtO(MH='Body Weights and Measures', MS='Measurements of the height, weight, length, area, etc., of the human and animal body or its parts.'),
  'D001838': NtO(MH='Bolivia', MS='A country in central South America, located southwest of Brazil.'),
  'D001839': NtO(MH='Bombesin', MS='A tetradecapeptide originally obtained from the skins of toads Bombina bombina and B. variegata. It is also an endogenous neurotransmitter in many animals including mammals. Bombesin affects vascular and other smooth muscle, gastric secretion, and renal circulation and function.'),
  'D001840': NtO(MH='Dental Bonding', MS='An adhesion procedure for orthodontic attachments, such as plastic DENTAL CROWNS. This process usually includes the application of an adhesive material (DENTAL CEMENTS) and letting it harden in-place by light or chemical curing.'),
  'D001841': NtO(MH='Bonding, Human-Pet', MS='The emotional attachment of individuals to PETS.'),
  'D001842': NtO(MH='Bone and Bones', MS='A specialized CONNECTIVE TISSUE that is the main constituent of the SKELETON. The principal cellular component of bone is comprised of OSTEOBLASTS; OSTEOCYTES; and OSTEOCLASTS, while FIBRILLAR COLLAGENS and hydroxyapatite crystals form the BONE MATRIX.'),
  'D001843': NtO(MH='Bone Cements', MS='Adhesives used to fix prosthetic devices to bones and to cement bone to bone in difficult fractures. Synthetic resins are commonly used as cements. A mixture of monocalcium phosphate, monohydrate, alpha-tricalcium phosphate, and calcium carbonate with a sodium phosphate solution is also a useful bone paste.'),
  'D001844': NtO(MH='Bone Conduction', MS='Transmission of sound waves through vibration of bones in the SKULL to the inner ear (COCHLEA). By using bone conduction stimulation and by bypassing any OUTER EAR or MIDDLE EAR abnormalities, hearing thresholds of the cochlea can be determined. Bone conduction hearing differs from normal hearing which is based on air conduction stimulation via the EAR CANAL and the TYMPANIC MEMBRANE.'),
  'D001845': NtO(MH='Bone Cysts', MS='Benign unilocular lytic areas in the proximal end of a long bone with well defined and narrow endosteal margins. The cysts contain fluid and the cyst walls may contain some giant cells. Bone cysts usually occur in males between the ages 3-15 years.'),
  'D001846': NtO(MH='Bone Development', MS='The growth and development of bones from fetus to adult. It includes two principal mechanisms of bone growth: growth in length of long bones at the epiphyseal cartilages and growth in thickness by depositing new bone (OSTEOGENESIS) with the actions of OSTEOBLASTS and OSTEOCLASTS.'),
  'D001847': NtO(MH='Bone Diseases', MS='Diseases of BONES.'),
  'D001848': NtO(MH='Bone Diseases, Developmental', MS='Diseases resulting in abnormal GROWTH or abnormal MORPHOGENESIS of BONES.'),
  'D001849': NtO(MH='Bone Diseases, Endocrine', MS='Diseases of the bones related to hyperfunction or hypofunction of the endocrine glands.'),
  'D001850': NtO(MH='Bone Diseases, Infectious', MS='Bone diseases caused by pathogenic microorganisms.'),
  'D001851': NtO(MH='Bone Diseases, Metabolic', MS='Diseases that affect the METABOLIC PROCESSES of BONE TISSUE.'),
  'D001852': NtO(MH='Bone Lengthening', MS='Increase in the longest dimension of a bone to correct anatomical deficiencies, congenital, traumatic, or as a result of disease. The lengthening is not restricted to long bones. The usual surgical methods are internal fixation and distraction.'),
  'D001853': NtO(MH='Bone Marrow', MS='The soft tissue filling the cavities of bones. Bone marrow exists in two types, yellow and red. Yellow marrow is found in the large cavities of large bones and consists mostly of fat cells and a few primitive blood cells. Red marrow is a hematopoietic tissue and is the site of production of erythrocytes and granular leukocytes. Bone marrow is made up of a framework of connective tissue containing branching fibers with the frame being filled with marrow cells.'),
  'D001854': NtO(MH='Bone Marrow Cells', MS='Cells contained in the bone marrow including fat cells (see ADIPOCYTES); STROMAL CELLS; MEGAKARYOCYTES; and the immediate precursors of most blood cells.'),
  'D001855': NtO(MH='Bone Marrow Diseases', MS='Diseases involving the BONE MARROW.'),
  'D001856': NtO(MH='Bone Marrow Examination', MS='Removal of bone marrow and evaluation of its histologic picture.'),
  'D001857': NtO(MH='Bone Matrix', MS='Extracellular substance of bone tissue consisting of COLLAGEN fibers, ground substance, and inorganic crystalline minerals and salts.'),
  'D001858': NtO(MH='Bone Nails', MS='Rods of bone, metal, or other material used for fixation of the fragments or ends of fractured bones.'),
  'D001859': NtO(MH='Bone Neoplasms', MS='Tumors or cancer located in bone tissue or specific BONES.'),
  'D001860': NtO(MH='Bone Plates', MS='Implantable fracture fixation devices attached to bone fragments with screws to bridge the fracture gap and shield the fracture site from stress as bone heals. (UMDNS, 1999)'),
  'D001861': NtO(MH='Bone Regeneration', MS='Renewal or repair of lost bone tissue. It excludes BONY CALLUS formed after BONE FRACTURES but not yet replaced by hard bone.'),
  'D001862': NtO(MH='Bone Resorption', MS='Bone loss due to osteoclastic activity.'),
  'D001863': NtO(MH='Bone Screws', MS='Specialized devices used in ORTHOPEDIC SURGERY to repair bone fractures.'),
  'D001864': NtO(MH='Bone Wires', MS='Steel wires, often threaded through the skin, soft tissues, and bone, used to fix broken bones. Kirschner wires or apparatus also includes the application of traction to the healing bones through the wires.'),
  'D001865': NtO(MH='Bongkrekic Acid', MS='An antibiotic produced by Pseudomonas cocovenenans. It is an inhibitor of MITOCHONDRIAL ADP, ATP TRANSLOCASES. Specifically, it blocks adenine nucleotide efflux from mitochondria by enhancing membrane binding.'),
  'D001867': NtO(MH='Book Classification', MS="A general term covering bibliographical and bibliothecal classifications. It mostly refers to library CLASSIFICATION for arrangement of books and documents on the shelves. (Harrod's Librarians' Glossary, 7th ed, p85)"),
  'D001868': NtO(MH='Book Collecting', MS='Seeking, locating, acquiring, organizing, cataloging, displaying, storing, and maintaining whatever books are of interest to a given individual collector.'),
  'D001869': NtO(MH='Book Imprints', MS='Information relating to the publication, printing, distribution, issue, release, or production of a book.'),
  'D001870': NtO(MH='Book Industry', MS='The aggregate enterprise of manufacturing and technically producing books. (From Random House Unabridged Dictionary, 2d ed)'),
  'D001871': NtO(MH='Book Ornamentation', MS=None),
  'D001872': NtO(MH='Book Prices', MS='Amount paid to purchase individual volumes or set from a bookseller.'),
  'D001873': NtO(MH='Book Reviews as Topic', MS='Works about critical analyses of books or other monographic works.'),
  'D001874': NtO(MH='Book Selection', MS=None),
  'D001875': NtO(MH='Bookbinding', MS='Joining together of a number of leaves or folios (most frequently of paper, parchment, or vellum) within covers to form a codex or book.'),
  'D001876': NtO(MH='Bookplates as Topic', MS='Works about labels pasted in books to mark their ownership and sometimes to indicate their location in a library.'),
  'D001877': NtO(MH='Books', MS='Non-periodical written or printed works consisting of sheets of pages fastened or bound together within covers.'),
  'D001878': NtO(MH='Books, Illustrated', MS='Books containing photographs, prints, drawings, portraits, plates, diagrams, facsimiles, maps, tables, or other representations or systematic arrangement of data designed to elucidate or decorate its contents. (From The ALA Glossary of Library and Information Science, 1983, p114)'),
  'D001879': NtO(MH='Bookselling', MS='Making books available for purchase.'),
  'D001880': NtO(MH='Boranes', MS="The collective name for the boron hydrides, which are analogous to the alkanes and silanes. Numerous boranes are known. Some have high calorific values and are used in high-energy fuels. (From Grant & Hackh's Chemical Dictionary, 5th ed)"),
  'D001881': NtO(MH='Borates', MS='Inorganic or organic salts and esters of boric acid.'),
  'D001882': NtO(MH='Border Disease', MS='Congenital disorder of lambs caused by a virus closely related to or identical with certain strains of bovine viral diarrhea virus.'),
  'D001883': NtO(MH='Borderline Personality Disorder', MS='A personality disorder marked by a pattern of instability of interpersonal relationships, self-image, and affects, and marked impulsivity beginning by early adulthood and present in a variety of contexts. (DSM-IV)'),
  'D001884': NtO(MH='Bordetella', MS='A genus of gram-negative aerobic bacteria whose cells are minute coccobacilli. It consists of both parasitic and pathogenic species.'),
  'D001885': NtO(MH='Bordetella Infections', MS='Infections with bacteria of the genus BORDETELLA.'),
  'D001886': NtO(MH='Bordetella pertussis', MS='A species of gram-negative, aerobic bacteria that is the causative agent of WHOOPING COUGH. Its cells are minute coccobacilli that are surrounded by a slime sheath.'),
  'D001887': NtO(MH='Boredom', MS='A psychological state resulting from any activity that lacks motivation, or from enforced continuance in an uninteresting situation.'),
  'D001888': NtO(MH='Boric Acids', MS='Inorganic and organic derivatives of boric acid either B(OH)3 or, preferably H3BO3.'),
  'D001889': NtO(MH='Borinic Acids', MS='Inorganic or organic compounds that contain the general structure R2B(OH).'),
  'D001890': NtO(MH='Borna Disease', MS='An encephalomyelitis of horses, sheep and cattle caused by BORNA DISEASE VIRUS.'),
  'D001891': NtO(MH='Borna disease virus', MS='A species in the genus Bornavirus, family BORNAVIRIDAE, causing a rare and usually fatal encephalitic disease in horses and other domestic animals and possibly deer. Its name derives from the city in Saxony where the condition was first described in 1894, but the disease occurs in Europe, N. Africa, and the Near East.'),
  'D001892': NtO(MH='Camphanes', MS='Crystalline saturated MONOTERPENES, precursors of borneols and CAMPHENE.'),
  'D001893': NtO(MH='Borneo', MS="An island in the Malay Archipelago, east of Sumatra, north of Java, and west of Celebes. It is the third largest island in the world. Its name is a Portuguese alteration of BRUNEI, located on it. (From Webster's New Geographical Dictionary, 1988, p163; Room, Brewer's Dictionary of Names, 1992, p73)"),
  'D001894': NtO(MH='Borohydrides', MS='A class of inorganic or organic compounds that contain the borohydride (BH4-) anion.'),
  'D001895': NtO(MH='Boron', MS='A trace element with the atomic symbol B, atomic number 5, and atomic weight [10.806; 10.821]. Boron-10, an isotope of boron, is used as a neutron absorber in BORON NEUTRON CAPTURE THERAPY.'),
  'D001896': NtO(MH='Boron Compounds', MS='Inorganic or organic compounds that contain boron as an integral part of the molecule.'),
  'D001897': NtO(MH='Boronic Acids', MS='Inorganic or organic compounds that contain the basic structure RB(OH)2.'),
  'D001898': NtO(MH='Borrelia', MS='A genus of gram-negative, anaerobic, helical bacteria, various species of which produce RELAPSING FEVER in humans and other animals.'),
  'D001899': NtO(MH='Borrelia Infections', MS='Infections with bacteria of the genus BORRELIA.'),
  'D001900': NtO(MH='Boston', MS='City located in Massachusetts.'),
  'D001901': NtO(MH='Botany', MS='The study of the origin, structure, development, growth, function, genetics, and reproduction of plants.'),
  'D001902': NtO(MH='Botswana', MS='A republic in southern Africa, between NAMIBIA and ZAMBIA. It was formerly called Bechuanaland. Its capital is Gaborone. The Kalahari Desert is in the west and southwest.'),
  'D001903': NtO(MH='Bottle Feeding', MS='Use of nursing bottles for feeding. Applies to humans and animals.'),
  'D001904': NtO(MH='Botulinum Antitoxin', MS='Antiserum given therapeutically in BOTULISM.'),
  'D001905': NtO(MH='Botulinum Toxins', MS='Toxic proteins produced from the species CLOSTRIDIUM BOTULINUM. The toxins are synthesized as a single peptide chain which is processed into a mature protein consisting of a heavy chain and light chain joined via a disulfide bond. The botulinum toxin light chain is a zinc-dependent protease which is released from the heavy chain upon ENDOCYTOSIS into PRESYNAPTIC NERVE ENDINGS. Once inside the cell the botulinum toxin light chain cleaves specific SNARE proteins which are essential for secretion of ACETYLCHOLINE by SYNAPTIC VESICLES. This inhibition of acetylcholine release results in muscular PARALYSIS.'),
  'D001906': NtO(MH='Botulism', MS='A disease caused by potent protein NEUROTOXINS produced by CLOSTRIDIUM BOTULINUM which interfere with the presynaptic release of ACETYLCHOLINE at the NEUROMUSCULAR JUNCTION. Clinical features include abdominal pain, vomiting, acute PARALYSIS (including respiratory paralysis), blurred vision, and DIPLOPIA. Botulism may be classified into several subtypes (e.g., food-borne, infant, wound, and others). (From Adams et al., Principles of Neurology, 6th ed, p1208)'),
  'D001907': NtO(MH='Boutonneuse Fever', MS='A febrile disease of the Mediterranean area, the Crimea, Africa, and India, caused by infection with RICKETTSIA CONORII.'),
  'D001908': NtO(MH='Diarrhea Viruses, Bovine Viral', MS='A group of viruses in the genus PESTIVIRUS, causing diarrhea, fever, oral ulcerations, hemorrhagic syndrome, and various necrotic lesions among cattle and other domestic animals. The two species (genotypes), BVDV-1 and BVDV-2 , exhibit antigenic and pathological differences. The historical designation, BVDV, consisted of both (then unrecognized) genotypes.'),
  'D001909': NtO(MH='Leukemia Virus, Bovine', MS='The type species of DELTARETROVIRUS that causes a form of bovine lymphosarcoma (ENZOOTIC BOVINE LEUKOSIS) or persistent lymphocytosis.'),
  'D001911': NtO(MH='Herpesvirus 2, Bovine', MS='A species of SIMPLEXVIRUS causing mammillitis in cattle in Great Britain and South Africa.'),
  'D001912': NtO(MH='Bovine Virus Diarrhea-Mucosal Disease', MS='Acute disease of cattle caused by the bovine viral diarrhea viruses (DIARRHEA VIRUSES, BOVINE VIRAL). Often mouth ulcerations are the only sign but fever, diarrhea, drop in milk yield, and loss of appetite are also seen. Severity of clinical disease varies and is strain dependent. Outbreaks are characterized by low morbidity and high mortality.'),
  'D001913': NtO(MH="Bowen's Disease", MS='A persistent progressive non-elevated red scaly or crusted plaque which is due to an intradermal carcinoma and is potentially malignant. Atypical squamous cells proliferate through the whole thickness of the epidermis. The lesions may occur anywhere on the skin surface or on mucosal surfaces. The cause most frequently found is trivalent arsenic compounds. Freezing, cauterization or diathermy coagulation is often effective. (From Rook et al., Textbook of Dermatology, 4th ed, pp2428-9)'),
  'D001914': NtO(MH='Boxing', MS='A two-person sport in which the fists are skillfully used to attack and defend.'),
  'D001915': NtO(MH='Braces', MS='Orthopedic appliances used to support, align, or hold parts of the body in correct position. (Dorland, 28th ed)'),
  'D001916': NtO(MH='Brachial Artery', MS='The continuation of the axillary artery; it branches into the radial and ulnar arteries.'),
  'D001917': NtO(MH='Brachial Plexus', MS='The large network of nerve fibers which distributes the innervation of the upper extremity. The brachial plexus extends from the neck into the axilla. In humans, the nerves of the plexus usually originate from the lower cervical and the first thoracic spinal cord segments (C5-C8 and T1), but variations are not uncommon.'),
  'D001918': NtO(MH='Brachytherapy', MS='A collective term for interstitial, intracavity, and surface radiotherapy. It uses small sealed or partly-sealed sources that may be placed on or near the body surface or within a natural body cavity or implanted directly into the tissues.'),
  'D001919': NtO(MH='Bradycardia', MS='Cardiac arrhythmias that are characterized by excessively slow HEART RATE, usually below 50 beats per minute in human adults. They can be classified broadly into SINOATRIAL NODE dysfunction and ATRIOVENTRICULAR BLOCK.'),
  'D001920': NtO(MH='Bradykinin', MS='A nonapeptide messenger that is enzymatically produced from KALLIDIN in the blood where it is a potent but short-lived agent of arteriolar dilation and increased capillary permeability. Bradykinin is also released from MAST CELLS during asthma attacks, from gut walls as a gastrointestinal vasodilator, from damaged tissues as a pain signal, and may be a neurotransmitter.'),
  'D001921': NtO(MH='Brain', MS='The part of CENTRAL NERVOUS SYSTEM that is contained within the skull (CRANIUM). Arising from the NEURAL TUBE, the embryonic brain is comprised of three major parts including PROSENCEPHALON (the forebrain); MESENCEPHALON (the midbrain); and RHOMBENCEPHALON (the hindbrain). The developed brain consists of CEREBRUM; CEREBELLUM; and other structures in the BRAIN STEM.'),
  'D001922': NtO(MH='Brain Abscess', MS='A circumscribed collection of purulent exudate in the brain, due to bacterial and other infections. The majority are caused by spread of infected material from a focus of suppuration elsewhere in the body, notably the PARANASAL SINUSES, middle ear (see EAR, MIDDLE); HEART (see also ENDOCARDITIS, BACTERIAL), and LUNG. Penetrating CRANIOCEREBRAL TRAUMA and NEUROSURGICAL PROCEDURES may also be associated with this condition. Clinical manifestations include HEADACHE; SEIZURES; focal neurologic deficits; and alterations of consciousness. (Adams et al., Principles of Neurology, 6th ed, pp712-6)'),
  'D001923': NtO(MH='Brain Chemistry', MS='Changes in the amounts of various chemicals (neurotransmitters, receptors, enzymes, and other metabolites) specific to the area of the central nervous system contained within the head. These are monitored over time, during sensory stimulation, or under different disease states.'),
  'D001924': NtO(MH='Brain Concussion', MS="A nonspecific term used to describe transient alterations or loss of consciousness following closed head injuries. The duration of UNCONSCIOUSNESS generally lasts a few seconds, but may persist for several hours. Concussions may be classified as mild, intermediate, and severe. Prolonged periods of unconsciousness (often defined as greater than 6 hours in duration) may be referred to as post-traumatic coma (COMA, POST-HEAD INJURY). (From Rowland, Merritt's Textbook of Neurology, 9th ed, p418)"),
  'D001925': NtO(MH='Brain Damage, Chronic', MS='A condition characterized by long-standing brain dysfunction or damage, usually of three months duration or longer. Potential etiologies include BRAIN INFARCTION; certain NEURODEGENERATIVE DISORDERS; CRANIOCEREBRAL TRAUMA; ANOXIA, BRAIN; ENCEPHALITIS; certain NEUROTOXICITY SYNDROMES; metabolic disorders (see BRAIN DISEASES, METABOLIC); and other conditions.'),
  'D001926': NtO(MH='Brain Death', MS='A state of prolonged irreversible cessation of all brain activity, including lower brain stem function with the complete absence of voluntary movements, responses to stimuli, brain stem reflexes, and spontaneous respirations. Reversible conditions which mimic this clinical state (e.g., sedative overdose, hypothermia, etc.) are excluded prior to making the determination of brain death. (From Adams et al., Principles of Neurology, 6th ed, pp348-9)'),
  'D001927': NtO(MH='Brain Diseases', MS='Pathologic conditions affecting the BRAIN, which is composed of the intracranial components of the CENTRAL NERVOUS SYSTEM. This includes (but is not limited to) the CEREBRAL CORTEX; intracranial white matter; BASAL GANGLIA; THALAMUS; HYPOTHALAMUS; BRAIN STEM; and CEREBELLUM.'),
  'D001928': NtO(MH='Brain Diseases, Metabolic', MS='Acquired or inborn metabolic diseases that produce brain dysfunction or damage. These include primary (i.e., disorders intrinsic to the brain) and secondary (i.e., extracranial) metabolic conditions that adversely affect cerebral function.'),
  'D001929': NtO(MH='Brain Edema', MS='Increased intracellular or extracellular fluid in brain tissue. Cytotoxic brain edema (swelling due to increased intracellular fluid) is indicative of a disturbance in cell metabolism, and is commonly associated with hypoxic or ischemic injuries (see HYPOXIA, BRAIN). An increase in extracellular fluid may be caused by increased brain capillary permeability (vasogenic edema), an osmotic gradient, local blockages in interstitial fluid pathways, or by obstruction of CSF flow (e.g., obstructive HYDROCEPHALUS). (From Childs Nerv Syst 1992 Sep; 8(6):301-6)'),
  'D001930': NtO(MH='Brain Injuries', MS='Acute and chronic (see also BRAIN INJURIES, CHRONIC) injuries to the brain, including the cerebral hemispheres, CEREBELLUM, and BRAIN STEM. Clinical manifestations depend on the nature of injury. Diffuse trauma to the brain is frequently associated with DIFFUSE AXONAL INJURY or COMA, POST-TRAUMATIC. Localized injuries may be associated with NEUROBEHAVIORAL MANIFESTATIONS; HEMIPARESIS, or other focal neurologic deficits.'),
  'D001931': NtO(MH='Brain Mapping', MS='Imaging techniques used to colocalize sites of brain functions or physiological activity with brain structures.'),
  'D001932': NtO(MH='Brain Neoplasms', MS='Neoplasms of the intracranial components of the central nervous system, including the cerebral hemispheres, basal ganglia, hypothalamus, thalamus, brain stem, and cerebellum. Brain neoplasms are subdivided into primary (originating from brain tissue) and secondary (i.e., metastatic) forms. Primary neoplasms are subdivided into benign and malignant forms. In general, brain tumors may also be classified by age of onset, histologic type, or presenting location in the brain.'),
  'D001933': NtO(MH='Brain Stem', MS='The part of the brain that connects the CEREBRAL HEMISPHERES with the SPINAL CORD. It consists of the MESENCEPHALON; PONS; and MEDULLA OBLONGATA.'),
  'D001934': NtO(MH='Branchial Region', MS='A region, of SOMITE development period, that contains a number of paired arches, each with a mesodermal core lined by ectoderm and endoderm on the two sides. In lower aquatic vertebrates, branchial arches develop into GILLS. In higher vertebrates, the arches forms outpouchings and develop into structures of the head and neck. Separating the arches are the branchial clefts or grooves.'),
  'D001935': NtO(MH='Branchioma', MS='A tumor derived from branchial epithelium or branchial rests. (Dorland, 27th ed)'),
  'D001936': NtO(MH='Moraxella catarrhalis', MS='Gram-negative aerobic cocci of low virulence that colonize the nasopharynx and occasionally cause MENINGITIS; BACTEREMIA; EMPYEMA; PERICARDITIS; and PNEUMONIA.'),
  'D001937': NtO(MH='Brassica', MS='A plant genus of the family Cruciferae. It contains many species and cultivars used as food including cabbage, cauliflower, broccoli, Brussel sprouts, kale, collard greens, MUSTARD PLANT; (B. alba, B. junica, and B. nigra), turnips (BRASSICA NAPUS) and rapeseed (BRASSICA RAPA).'),
  'D001938': NtO(MH='Brazil', MS='A country located on the eastern coast of South America, located between Colombia and Peru, that borders the Atlantic Ocean. It is bordered on the north by Venezuela, Guyana, Suriname, and French Guiana, on the south by Uruguay, and on the west by Argentina. The capital is Brasilia.'),
  'D001939': NtO(MH='Bread', MS='Baked food product made of flour or meal that is moistened, kneaded, and sometimes fermented. A major food since prehistoric times, it has been made in various forms using a variety of ingredients and methods.'),
  'D001940': NtO(MH='Breast', MS='In humans, one of the paired regions in the anterior portion of the THORAX. The breasts consist of the MAMMARY GLANDS, the SKIN, the MUSCLES, the ADIPOSE TISSUE, and the CONNECTIVE TISSUES.'),
  'D001941': NtO(MH='Breast Diseases', MS='Pathological processes of the BREAST.'),
  'D001942': NtO(MH='Breast Feeding', MS='The nursing of an infant at the breast.'),
  'D001943': NtO(MH='Breast Neoplasms', MS='Tumors or cancer of the human BREAST.'),
  'D001944': NtO(MH='Breath Tests', MS='Any tests done on exhaled air.'),
  'D001945': NtO(MH='Breathing Exercises', MS='Therapeutic exercises aimed to deepen inspiration or expiration or even to alter the rate and rhythm of respiration.'),
  'D001946': NtO(MH='Breech Presentation', MS='A malpresentation of the FETUS at near term or during OBSTETRIC LABOR with the fetal cephalic pole in the fundus of the UTERUS. There are three types of breech: the complete breech with flexed hips and knees; the incomplete breech with one or both hips partially or fully extended; the frank breech with flexed hips and extended knees.'),
  'D001947': NtO(MH='Breeding', MS='The production of offspring by selective mating or HYBRIDIZATION, GENETIC in animals or plants.'),
  'D001948': NtO(MH='Brenner Tumor', MS='A smooth, solid or cystic fibroepithelial (FIBROEPITHELIAL NEOPLASMS) tumor, usually found in the OVARIES but can also be found in the adnexal region and the KIDNEYS. It consists of a fibrous stroma with nests of epithelial cells that sometimes resemble the transitional cells lining the urinary bladder. Brenner tumors generally are benign and asymptomatic. Malignant Brenner tumors have been reported.'),
  'D001949': NtO(MH='Bretylium Compounds', MS='Benzylammonium compounds with the formula Br-phenyl-CN+R3 that include BRETYLIUM TOSYLATE.'),
  'D001950': NtO(MH='Bretylium Tosylate', MS='An agent that blocks the release of adrenergic transmitters and may have other actions. It was formerly used as an antihypertensive agent, but is now proposed as an anti-arrhythmic.'),
  'D001951': NtO(MH='Brevibacterium', MS='A gram-positive organism found in dairy products, fresh and salt water, marine organisms, insects, and decaying organic matter.'),
  'D001952': NtO(MH='Bridged-Ring Compounds', MS='Cyclic hydrocarbons that contain multiple rings which share one or more bridgehead connections.'),
  'D001954': NtO(MH='Brinolase', MS='A fibrinolytic and thrombolytic enzyme from Aspergillus oryzae. EC 3.4.99.-.'),
  'D001955': NtO(MH='British Columbia', MS="A province of Canada on the Pacific coast. Its capital is Victoria. The name given in 1858 derives from the Columbia River which was named by the American captain Robert Gray for his ship Columbia which in turn was named for Columbus. (From Webster's New Geographical Dictionary, 1988, p178 & Room, Brewer's Dictionary of Names, 1992, p81-2)"),
  'D001956': NtO(MH='Broad Ligament', MS='A broad fold of peritoneum that extends from the side of the uterus to the wall of the pelvis.'),
  'D001957': NtO(MH='Broadsides as Topic', MS='Works about published pieces of paper or other material, usually printed on one side and intended to be read unfolded and usually intended to be posted, publicly distributed, or sold, e.g., proclamations, handbills, newssheets, etc.'),
  'D001958': NtO(MH='Brocresine', MS='A histidine decarboxylase inhibitor.'),
  'D001959': NtO(MH='Bromates', MS='Negative ions or salts derived from bromic acid, HBrO3.'),
  'D001960': NtO(MH='Bromazepam', MS='One of the BENZODIAZEPINES that is used in the treatment of ANXIETY DISORDERS.'),
  'D001961': NtO(MH='Bromcresol Green', MS='An indicator and reagent. It has been used in serum albumin determinations and as a pH indicator.'),
  'D001962': NtO(MH='Bromcresol Purple', MS='An indicator and reagent. It has been used for several purposes including the determination of serum albumin concentrations'),
  'D001963': NtO(MH='Bromelains', MS='Protein-digesting and milk-clotting enzymes found in PINEAPPLE fruit juice and stem tissue. Enzymes from the two sources are distinguished as fruit bromelain and stem bromelain. This enzyme was formerly listed as EC 3.4.22.4.'),
  'D001964': NtO(MH='Bromhexine', MS='A mucolytic agent used in the treatment of respiratory disorders associated with viscid or excessive mucus. (From Martindale, The Extra Pharmacopoeia, 30th ed, p744)'),
  'D001965': NtO(MH='Bromides', MS='Salts of hydrobromic acid, HBr, with the bromine atom in the 1- oxidation state. (From McGraw-Hill Dictionary of Scientific and Technical Terms, 4th ed)'),
  'D001966': NtO(MH='Bromine', MS='A halogen with the atomic symbol Br, atomic number 35, and atomic weight 79.904. It is a volatile reddish-brown liquid that gives off suffocating vapors, is corrosive to the skin, and may cause severe gastroenteritis if ingested.'),
  'D001967': NtO(MH='Bromine Radioisotopes', MS='Unstable isotopes of bromine that decay or disintegrate emitting radiation. Br atoms with atomic weights 74-78, 80, and 82-90 are radioactive bromine isotopes.'),
  'D001968': NtO(MH='Bromisovalum', MS='A sedative and mild hypnotic with potentially toxic effects.'),
  'D001969': NtO(MH='Bromobenzenes', MS='Derivatives of benzene in which one or more hydrogen atoms on the benzene ring are replaced by bromine atoms.'),
  'D001970': NtO(MH='Bromobenzoates', MS='Benzoic acid or benzoic acid esters substituted with one or more bromine atoms.'),
  'D001971': NtO(MH='Bromocriptine', MS='A semisynthetic ergotamine alkaloid that is a dopamine D2 agonist. It suppresses prolactin secretion.'),
  'D001972': NtO(MH='Bromodeoxycytidine', MS="5-Bromo-2'-deoxycytidine. Can be incorporated into DNA in the presence of DNA polymerase, replacing dCTP."),
  'D001973': NtO(MH='Bromodeoxyuridine', MS='A nucleoside that substitutes for thymidine in DNA and thus acts as an antimetabolite. It causes breaks in chromosomes and has been proposed as an antiviral and antineoplastic agent. It has been given orphan drug status for use in the treatment of primary brain tumors.'),
  'D001974': NtO(MH='Bromosuccinimide', MS="A brominating agent that replaces hydrogen atoms in benzylic or allylic positions. It is used in the oxidation of secondary alcohols to ketones and in controlled low-energy brominations. (From Miall's Dictionary of Chemistry, 5th ed; Hawley's Condensed Chemical Dictionary, 12th ed,)."),
  'D001975': NtO(MH='Bromotrichloromethane', MS='A potent liver poison. In rats, bromotrichloromethane produces about three times the degree of liver microsomal lipid peroxidation as does carbon tetrachloride.'),
  'D001976': NtO(MH='Bromouracil', MS='5-Bromo-2,4(1H,3H)-pyrimidinedione. Brominated derivative of uracil that acts as an antimetabolite, substituting for thymine in DNA. It is used mainly as an experimental mutagen, but its deoxyriboside (BROMODEOXYURIDINE) is used to treat neoplasms.'),
  'D001977': NtO(MH='Brompheniramine', MS='Histamine H1 antagonist used in treatment of allergies, rhinitis, and urticaria.'),
  'D001978': NtO(MH='Bromphenol Blue', MS='A dye that has been used as an industrial dye, a laboratory indicator, and a biological stain.'),
  'D001979': NtO(MH='Bromthymol Blue', MS='A pH sensitive dye that has been used as an indicator in many laboratory reactions.'),
  'D001980': NtO(MH='Bronchi', MS='The larger air passages of the lungs arising from the terminal bifurcation of the TRACHEA. They include the largest two primary bronchi which branch out into secondary bronchi, and tertiary bronchi which extend into BRONCHIOLES and PULMONARY ALVEOLI.'),
  'D001981': NtO(MH='Bronchial Arteries', MS='Left bronchial arteries arise from the thoracic aorta, the right from the first aortic intercostal or the upper left bronchial artery; they supply the bronchi and the lower trachea.'),
  'D001982': NtO(MH='Bronchial Diseases', MS='Diseases involving the BRONCHI.'),
  'D001983': NtO(MH='Bronchial Fistula', MS='An abnormal passage or communication between a bronchus and another part of the body.'),
  'D001984': NtO(MH='Bronchial Neoplasms', MS='Tumors or cancer of the BRONCHI.