# mypy-boto3-ds

[![PyPI - mypy-boto3-ds](https://img.shields.io/pypi/v/mypy-boto3-ds.svg?color=blue)](https://pypi.org/project/mypy-boto3-ds)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ds.svg?color=blue)](https://pypi.org/project/mypy-boto3-ds)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-ds?color=blue)](https://pypistats.org/packages/mypy-boto3-ds)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.DirectoryService 1.17.66](https://boto3.amazonaws.com/v1/documentation/api/1.17.66/reference/services/ds.html#DirectoryService)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.10.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-ds docs](https://github.com/vemel/mypy_boto3_builder/service_docs/mypy_boto3_ds/README.md)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-ds](#mypy-boto3-ds)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)

## How to install

Install `boto3-stubs` for `DirectoryService` service.

```bash
python -m pip install boto3-stubs[ds]
```

## Usage

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[ds]` in your environment:
  `python -m pip install 'boto3-stubs[ds]'`

Both type checking and auto-complete should work for `DirectoryService`
service. No explicit type annotations required, write your `boto3` code as
usual.

### PyCharm

- Install `boto-stubs[ds]` in your environment:
  `python -m pip install 'boto3-stubs[ds]'`

Both type checking and auto-complete should work for `DirectoryService`
service. No explicit type annotations required, write your `boto3` code as
usual. Auto-complete can be slow on big projects or if you have a lot of
installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[ds]` in your environment:
  `python -m pip install 'boto3-stubs[ds]'`
- Run `mypy` as usual

Type checking should work for `DirectoryService` service. No explicit type
annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[ds]` in your environment:
  `python -m pip install 'boto3-stubs[ds]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `DirectoryService` service. No explicit type
annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`DirectoryServiceClient` provides annotations for `boto3.client("ds")`.

```python
import boto3

from mypy_boto3_ds import DirectoryServiceClient

client: DirectoryServiceClient = boto3.client("ds")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DirectoryServiceClient = session.client("ds")
```

### Paginators annotations

`mypy_boto3_ds.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_ds import DirectoryServiceClient
from mypy_boto3_ds.paginator import (
    DescribeDirectoriesPaginator,
    DescribeDomainControllersPaginator,
    DescribeSharedDirectoriesPaginator,
    DescribeSnapshotsPaginator,
    DescribeTrustsPaginator,
    ListIpRoutesPaginator,
    ListLogSubscriptionsPaginator,
    ListSchemaExtensionsPaginator,
    ListTagsForResourcePaginator,
)

client: DirectoryServiceClient = boto3.client("ds")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_directories_paginator: DescribeDirectoriesPaginator = client.get_paginator("describe_directories")
describe_domain_controllers_paginator: DescribeDomainControllersPaginator = client.get_paginator("describe_domain_controllers")
describe_shared_directories_paginator: DescribeSharedDirectoriesPaginator = client.get_paginator("describe_shared_directories")
describe_snapshots_paginator: DescribeSnapshotsPaginator = client.get_paginator("describe_snapshots")
describe_trusts_paginator: DescribeTrustsPaginator = client.get_paginator("describe_trusts")
list_ip_routes_paginator: ListIpRoutesPaginator = client.get_paginator("list_ip_routes")
list_log_subscriptions_paginator: ListLogSubscriptionsPaginator = client.get_paginator("list_log_subscriptions")
list_schema_extensions_paginator: ListSchemaExtensionsPaginator = client.get_paginator("list_schema_extensions")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
```

### Literals

`mypy_boto3_ds.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_ds.literals import (
    CertificateState,
    CertificateType,
    ClientAuthenticationType,
    DescribeDirectoriesPaginatorName,
    DescribeDomainControllersPaginatorName,
    DescribeSharedDirectoriesPaginatorName,
    DescribeSnapshotsPaginatorName,
    DescribeTrustsPaginatorName,
    DirectoryEdition,
    DirectorySize,
    DirectoryStage,
    DirectoryType,
    DomainControllerStatus,
    IpRouteStatusMsg,
    LDAPSStatus,
    LDAPSType,
    ListIpRoutesPaginatorName,
    ListLogSubscriptionsPaginatorName,
    ListSchemaExtensionsPaginatorName,
    ListTagsForResourcePaginatorName,
    RadiusAuthenticationProtocol,
    RadiusStatus,
    RegionType,
    ReplicationScope,
    SchemaExtensionStatus,
    SelectiveAuth,
    ShareMethod,
    ShareStatus,
    SnapshotStatus,
    SnapshotType,
    TargetType,
    TopicStatus,
    TrustDirection,
    TrustState,
    TrustType,
)

def check_value(value: CertificateState) -> bool:
    ...
```

### Typed dictionaries

`mypy_boto3_ds.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_ds.type_defs import (
    AcceptSharedDirectoryResultTypeDef,
    AttributeTypeDef,
    CertificateInfoTypeDef,
    CertificateTypeDef,
    ClientCertAuthSettingsTypeDef,
    ComputerTypeDef,
    ConditionalForwarderTypeDef,
    ConnectDirectoryResultTypeDef,
    CreateAliasResultTypeDef,
    CreateComputerResultTypeDef,
    CreateDirectoryResultTypeDef,
    CreateMicrosoftADResultTypeDef,
    CreateSnapshotResultTypeDef,
    CreateTrustResultTypeDef,
    DeleteDirectoryResultTypeDef,
    DeleteSnapshotResultTypeDef,
    DeleteTrustResultTypeDef,
    DescribeCertificateResultTypeDef,
    DescribeConditionalForwardersResultTypeDef,
    DescribeDirectoriesResultTypeDef,
    DescribeDomainControllersResultTypeDef,
    DescribeEventTopicsResultTypeDef,
    DescribeLDAPSSettingsResultTypeDef,
    DescribeRegionsResultTypeDef,
    DescribeSharedDirectoriesResultTypeDef,
    DescribeSnapshotsResultTypeDef,
    DescribeTrustsResultTypeDef,
    DirectoryConnectSettingsDescriptionTypeDef,
    DirectoryConnectSettingsTypeDef,
    DirectoryDescriptionTypeDef,
    DirectoryLimitsTypeDef,
    DirectoryVpcSettingsDescriptionTypeDef,
    DirectoryVpcSettingsTypeDef,
    DomainControllerTypeDef,
    EventTopicTypeDef,
    GetDirectoryLimitsResultTypeDef,
    GetSnapshotLimitsResultTypeDef,
    IpRouteInfoTypeDef,
    IpRouteTypeDef,
    LDAPSSettingInfoTypeDef,
    ListCertificatesResultTypeDef,
    ListIpRoutesResultTypeDef,
    ListLogSubscriptionsResultTypeDef,
    ListSchemaExtensionsResultTypeDef,
    ListTagsForResourceResultTypeDef,
    LogSubscriptionTypeDef,
    OwnerDirectoryDescriptionTypeDef,
    PaginatorConfigTypeDef,
    RadiusSettingsTypeDef,
    RegionDescriptionTypeDef,
    RegionsInfoTypeDef,
    RegisterCertificateResultTypeDef,
    RejectSharedDirectoryResultTypeDef,
    SchemaExtensionInfoTypeDef,
    ShareDirectoryResultTypeDef,
    ShareTargetTypeDef,
    SharedDirectoryTypeDef,
    SnapshotLimitsTypeDef,
    SnapshotTypeDef,
    StartSchemaExtensionResultTypeDef,
    TagTypeDef,
    TrustTypeDef,
    UnshareDirectoryResultTypeDef,
    UnshareTargetTypeDef,
    UpdateTrustResultTypeDef,
    VerifyTrustResultTypeDef,
)

def get_structure() -> AcceptSharedDirectoryResultTypeDef:
    return {
      ...
    }
```
