test_schema = {
    'collections': [
        {'name': 'tests_topic', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'question_set', 'type': ['Number'],'is_primary_key': False, 'is_filterable': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'tests_question.id', 'inverse_of': 'topic', 'relationship': 'HasMany',
             'widget': None},
            {'field': 'id', 'type': 'Number', 'is_filterable': True,'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'name', 'type': 'String', 'is_filterable': True,'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 200 characters', 'value': 200},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]}]},
        {'name': 'tests_question', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'choice_set', 'type': ['Number'],'is_primary_key': False, 'is_filterable': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'tests_choice.id', 'inverse_of': 'question', 'relationship': 'HasMany',
             'widget': None},
            {'field': 'id', 'type': 'Number','is_primary_key': True, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'question_text', 'type': 'String','is_primary_key': False, 'is_filterable': True, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': 'how are you?',
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None,
             'validations': [
                 {'type': 'is longer than', 'message': 'Ensure this value has at least 1 characters', 'value': 1},
                 {'type': 'is shorter than', 'message': 'Ensure this value has at most 200 characters', 'value': 200}]},
            {'field': 'pub_date', 'type': 'Date', 'is_filterable': True,'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': '2020-05-17 00:00:00', 'integration': None,
             'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'topic', 'type': 'Number','is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'tests_topic.id', 'inverse_of': 'question_set', 'relationship': 'BelongsTo',
             'widget': None}]},
        {'name': 'tests_choice', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'type': 'Number','is_primary_key': True, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'question', 'type': 'Number','is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'tests_question.id', 'inverse_of': 'choice_set', 'relationship': 'BelongsTo', 'widget': None},
            {'field': 'choice_text', 'type': 'String','is_primary_key': False, 'is_filterable': True, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None,
             'validations': [
                 {'type': 'is shorter than', 'message': 'Ensure this value has at most 200 characters', 'value': 200},
                 {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'votes', 'type': 'Number','is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': 0, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [{'type': 'is greater than',
                                                                                        'message': 'Ensure this value is greater than or equal to -2147483648 characters',
                                                                                        'value': -2147483648},
                                                                                       {'type': 'is less than',
                                                                                        'message': 'Ensure this value is less than or equal to 2147483647 characters',
                                                                                        'value': 2147483647}]}]},
        {'name': 'tests_car', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'wheels','is_primary_key': False, 'type': ['Number'], 'is_filterable': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'tests_wheel.id', 'inverse_of': 'car', 'relationship': 'HasMany', 'widget': None},
            {'field': 'id','is_primary_key': True, 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'brand','is_primary_key': False, 'type': 'String', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 200 characters', 'value': 200},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]}]},
        {'name': 'tests_wheel', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'is_primary_key': True,'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'car', 'is_primary_key': False, 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'tests_car.brand', 'inverse_of': 'wheels', 'relationship': 'BelongsTo', 'widget': None}]},
        {'name': 'tests_session', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'session_key', 'is_primary_key': True, 'type': 'String', 'is_filterable': True, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None,
             'validations': [
                 {'type': 'is shorter than', 'message': 'Ensure this value has at most 40 characters', 'value': 40},
                 {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'session_data', 'is_primary_key': False, 'type': 'String', 'is_filterable': True, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None,
             'validations': [{'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'expire_date', 'is_primary_key': False, 'type': 'Date', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None,
             'validations': [{'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]}]},
        {'name': 'tests_publication', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'article_set', 'is_primary_key': False, 'type': ['Number'], 'is_filterable': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'tests_article.id', 'inverse_of': 'publications',
             'relationship': 'HasMany', 'widget': None},
            {'field': 'id', 'is_primary_key': True, 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'title', 'is_primary_key': False, 'type': 'String', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 30 characters', 'value': 30},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]}]},
        {'name': 'tests_article_publications', 'is_virtual': False, 'icon': None, 'is_read_only': False,
         'is_searchable': True, 'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None,
         'actions': [], 'segments': [], 'fields': [
            {'field': 'id', 'is_primary_key': True, 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'article', 'is_primary_key': False, 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'tests_article.id', 'inverse_of': 'Article_publications+', 'relationship': 'BelongsTo',
             'widget': None}, {'field': 'publication', 'is_primary_key': False, 'type': 'Number', 'is_filterable': True, 'is_sortable': True,
                               'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
                               'integration': None, 'reference': 'tests_publication.id',
                               'inverse_of': 'Article_publications+', 'relationship': 'BelongsTo', 'widget': None}]},
        {'name': 'tests_article', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'type': 'Number','is_primary_key': True, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'headline', 'is_primary_key': False, 'type': 'String', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 100 characters', 'value': 100},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'publications', 'is_primary_key': False, 'type': ['Number'], 'is_filterable': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'tests_publication.id', 'inverse_of': 'article_set',
             'relationship': 'HasMany', 'widget': None}]},
        {'name': 'tests_place', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'restaurant', 'is_primary_key': False, 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'tests_restaurant.place_id', 'inverse_of': 'place', 'relationship': 'HasOne', 'widget': None},
            {'field': 'id', 'is_primary_key': True, 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'name', 'is_primary_key': False, 'type': 'String', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 50 characters', 'value': 50},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'address', 'is_primary_key': False, 'type': 'String', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 80 characters', 'value': 80},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]}]},
        {'name': 'tests_restaurant', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'waiter_set', 'is_primary_key': False, 'type': ['Number'], 'is_filterable': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'tests_waiter.id', 'inverse_of': 'restaurant', 'relationship': 'HasMany',
             'widget': None},
            {'field': 'place', 'is_primary_key': True, 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'tests_place.id', 'inverse_of': 'restaurant', 'relationship': 'HasOne', 'widget': None},
            {'field': 'serves_hot_dogs', 'is_primary_key': False, 'type': 'Boolean', 'is_filterable': True, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': False,
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'serves_pizza', 'is_primary_key': False, 'type': 'Boolean', 'is_filterable': True, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': False,
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None}]},
        {'name': 'tests_waiter', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'is_primary_key': True, 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'restaurant', 'is_primary_key': False, 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'tests_restaurant.place_id', 'inverse_of': 'waiter_set', 'relationship': 'BelongsTo',
             'widget': None},
            {'field': 'name', 'is_primary_key': False, 'type': 'String', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 50 characters', 'value': 50},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]}]},
        {'name': 'tests_student', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'is_primary_key': True, 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'year_in_school', 'is_primary_key': False, 'type': 'Enum', 'is_filterable': True, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': 'FR',
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None,
             'validations': [
                 {'type': 'is shorter than', 'message': 'Ensure this value has at most 2 characters', 'value': 2}],
             'enums': ['FR', 'SO', 'JR', 'SR', 'GR']}]},
        {'name': 'tests_chessboard', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'is_primary_key': True, 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'board', 'is_primary_key': False, 'type': ['String'], 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None}]},
        {'name': 'tests_serial', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'uuid', 'is_primary_key': True, 'type': 'String', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None}]},
        {'name': 'auth_permission', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'group_set', 'is_primary_key': False, 'type': ['Number'], 'is_filterable': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'auth_group.id', 'inverse_of': 'permissions', 'relationship': 'HasMany',
             'widget': None}, {'field': 'user_set', 'is_primary_key': False, 'type': ['Number'], 'is_filterable': False, 'is_sortable': True,
                               'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
                               'integration': None, 'reference': 'auth_user.id', 'inverse_of': 'user_permissions',
                               'relationship': 'HasMany', 'widget': None},
            {'field': 'id', 'type': 'String', 'is_primary_key': True, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'name', 'type': 'String', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 255 characters', 'value': 255},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'content_type', 'type': 'Number', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'django_content_type.id', 'inverse_of': 'permission_set',
             'relationship': 'BelongsTo', 'widget': None},
            {'field': 'codename', 'type': 'String', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 100 characters', 'value': 100},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]}]},
        {'name': 'auth_group_permissions', 'is_virtual': False, 'icon': None, 'is_read_only': False,
         'is_searchable': True, 'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None,
         'actions': [], 'segments': [], 'fields': [
            {'field': 'id', 'is_primary_key': True, 'type': 'String', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'group', 'type': 'Number', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'auth_group.id', 'inverse_of': 'Group_permissions+', 'relationship': 'BelongsTo',
             'widget': None},
            {'field': 'permission', 'type': 'Number', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'auth_permission.id', 'inverse_of': 'Group_permissions+', 'relationship': 'BelongsTo',
             'widget': None}]},
        {'name': 'auth_group', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'user_set', 'is_primary_key': False, 'type': ['Number'], 'is_filterable': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'auth_user.id', 'inverse_of': 'groups', 'relationship': 'HasMany',
             'widget': None},
            {'field': 'id', 'is_primary_key': True, 'type': 'String', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'name', 'is_primary_key': False, 'type': 'String', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 150 characters', 'value': 150},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'permissions', 'is_primary_key': False, 'type': ['Number'], 'is_filterable': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'auth_permission.id', 'inverse_of': 'group_set',
             'relationship': 'HasMany', 'widget': None}]},
        {'name': 'auth_user_groups', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'is_primary_key': True, 'type': 'String', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'user', 'type': 'Number', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'auth_user.id', 'inverse_of': 'User_groups+', 'relationship': 'BelongsTo', 'widget': None},
            {'field': 'group', 'type': 'Number', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'auth_group.id', 'inverse_of': 'User_groups+', 'relationship': 'BelongsTo', 'widget': None}]},
        {'name': 'auth_user_user_permissions', 'is_virtual': False, 'icon': None, 'is_read_only': False,
         'is_searchable': True, 'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None,
         'actions': [], 'segments': [], 'fields': [
            {'field': 'id', 'type': 'String', 'is_primary_key': True, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'user', 'type': 'Number', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'auth_user.id', 'inverse_of': 'User_user_permissions+', 'relationship': 'BelongsTo',
             'widget': None},
            {'field': 'permission', 'type': 'Number', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'auth_permission.id', 'inverse_of': 'User_user_permissions+', 'relationship': 'BelongsTo',
             'widget': None}]},
        {'name': 'auth_user', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'type': 'String', 'is_primary_key': True, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'password', 'type': 'String', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 128 characters', 'value': 128},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'last_login', 'type': 'Date', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'is_superuser', 'type': 'Boolean', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': False,
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'username', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is like', 'message': 'Ensure this value match your pattern', 'value': '^[\\w.@+-]+\\Z'},
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 150 characters', 'value': 150},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'first_name', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 150 characters', 'value': 150},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'last_name', 'type': 'String', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 150 characters', 'value': 150},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'email', 'type': 'String', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 254 characters', 'value': 254},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'is_staff', 'type': 'Boolean', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': False, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'is_active', 'type': 'Boolean', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': True, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'date_joined', 'type': 'Date', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'groups', 'type': ['Number'], 'is_primary_key': False, 'is_filterable': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'auth_group.id', 'inverse_of': 'user_set', 'relationship': 'HasMany', 'widget': None},
            {'field': 'user_permissions', 'type': ['Number'], 'is_primary_key': False, 'is_filterable': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'auth_permission.id', 'inverse_of': 'user_set',
             'relationship': 'HasMany', 'widget': None}]},
        {'name': 'django_content_type', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'permission_set', 'is_primary_key': False, 'type': ['Number'], 'is_filterable': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'auth_permission.id', 'inverse_of': 'content_type',
             'relationship': 'HasMany', 'widget': None},
            {'field': 'id', 'type': 'String', 'is_primary_key': True, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'app_label', 'type': 'String', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 100 characters', 'value': 100},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'model', 'type': 'String', 'is_primary_key': False, 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 100 characters', 'value': 100},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]}]}],
    'meta': {'liana': 'django-forestadmin', 'liana_version': '0.0.0',
             'stack': {'database_type': 'sqlite', 'orm_version': '9.9.9'}}}

test_choice_schema = {
    'collections': [
        {'name': 'tests_choice', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'type': 'Number', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'choice_text', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None,
             'validations': [
                 {'type': 'is shorter than', 'message': 'Ensure this value has at most 200 characters', 'value': 200},
                 {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'votes', 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_primary_key': False, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': 0, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [{'type': 'is greater than',
                                                                                        'message': 'Ensure this value is greater than or equal to -2147483648 characters',
                                                                                        'value': -2147483648},
                                                                                       {'type': 'is less than',
                                                                                        'message': 'Ensure this value is less than or equal to 2147483647 characters',
                                                                                        'value': 2147483647}]}]}],
    'meta': {'liana': 'django-forestadmin', 'liana_version': '0.0.0',
             'stack': {'database_type': 'sqlite', 'orm_version': '9.9.9'}}}

test_question_schema_data = {'collections': [
    {
        'name': 'tests_question', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
        'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None,
        'actions': [
            {'name': 'Send invoice', 'type': 'single', 'fields': [
                {'field': 'country', 'type': 'Enum', 'enums': ['FR', 'US'], 'isReadOnly': False, 'isRequired': False,
                 'defaultValue': None, 'integration': None, 'reference': None, 'description': None, 'widget': None,
                 'position': 0},
                {'field': 'city', 'type': 'String', 'isReadOnly': False, 'isRequired': False, 'defaultValue': None,
                 'integration': None, 'reference': None, 'description': None, 'widget': None,
                 'hook': 'cityChange',
                 'position': 1},
                {'field': 'zip code', 'type': 'String', 'is_read_only': False, 'is_required': False,
                 'default_value': None,
                 'integration': None, 'reference': None, 'description': None, 'widget': None,
                 'hook': 'zipCodeChange',
                 'position': 2}], 'hooks': {'load': True, 'change': ['cityChange', 'zipCodeChange']},
             'endpoint': '/forest/actions/send-invoice', 'baseUrl': None, 'httpMethod': 'POST', 'redirect': None,
             'download': False}],
        'segments': [{'name': 'Best questions'}],
        'fields': [
            {'field': 'id', 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'question_text', 'type': 'String', 'is_filterable': True, 'is_sortable': True,
             'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is longer than', 'message': 'Ensure this value has at least 1 characters', 'value': 1},
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 200 characters', 'value': 200},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'pub_date', 'type': 'Date', 'is_filterable': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'foo', 'is_virtual': True, 'type': '', 'is_filterable': True, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'bar', 'is_virtual': True, 'type': '', 'is_filterable': True, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None}]}],
    'meta': {
        'liana': 'django-forestadmin',
        'liana_version': '0.0.0',
        'stack': {
            'database_type': 'sqlite',
            'orm_version': '9.9.9'
        },
    }}

test_exclude_django_contrib_schema = {
    'collections': [
        {'name': 'tests_topic', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'question_set', 'type': ['Number'],'is_primary_key': False, 'is_filterable': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'tests_question.id', 'inverse_of': 'topic', 'relationship': 'HasMany',
             'widget': None},
            {'field': 'id', 'type': 'Number', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'name', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 200 characters', 'value': 200},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]}]},
        {'name': 'tests_question', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'choice_set', 'type': ['Number'], 'is_filterable': False, 'is_primary_key': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'tests_choice.id', 'inverse_of': 'question', 'relationship': 'HasMany',
             'widget': None},
            {'field': 'id', 'type': 'Number', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'question_text', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': 'how are you?',
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None,
             'validations': [
                 {'type': 'is longer than', 'message': 'Ensure this value has at least 1 characters', 'value': 1},
                 {'type': 'is shorter than', 'message': 'Ensure this value has at most 200 characters', 'value': 200}]},
            {'field': 'pub_date', 'type': 'Date', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': '2020-05-17 00:00:00', 'integration': None,
             'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'topic', 'type': 'Number', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'tests_topic.id', 'inverse_of': 'question_set', 'relationship': 'BelongsTo',
             'widget': None}]},
        {'name': 'tests_choice', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'type': 'Number', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'question', 'type': 'Number', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'tests_question.id', 'inverse_of': 'choice_set', 'relationship': 'BelongsTo', 'widget': None},
            {'field': 'choice_text', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None,
             'validations': [
                 {'type': 'is shorter than', 'message': 'Ensure this value has at most 200 characters', 'value': 200},
                 {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'votes', 'type': 'Number', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': 0, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [{'type': 'is greater than',
                                                                                        'message': 'Ensure this value is greater than or equal to -2147483648 characters',
                                                                                        'value': -2147483648},
                                                                                       {'type': 'is less than',
                                                                                        'message': 'Ensure this value is less than or equal to 2147483647 characters',
                                                                                        'value': 2147483647}]}]},
        {'name': 'tests_car', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'wheels', 'type': ['Number'], 'is_filterable': False, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'tests_wheel.id', 'inverse_of': 'car', 'relationship': 'HasMany', 'widget': None},
            {'field': 'id', 'type': 'Number', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'brand', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 200 characters', 'value': 200},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]}]},
        {'name': 'tests_wheel', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'type': 'Number', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'car', 'type': 'Number', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'tests_car.brand', 'inverse_of': 'wheels', 'relationship': 'BelongsTo', 'widget': None}]},
        {'name': 'tests_session', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'session_key', 'type': 'String', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None,
             'validations': [
                 {'type': 'is shorter than', 'message': 'Ensure this value has at most 40 characters', 'value': 40},
                 {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'session_data', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None,
             'validations': [{'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'expire_date', 'type': 'Date', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None,
             'validations': [{'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]}]},
        {'name': 'tests_publication', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'article_set', 'type': ['Number'], 'is_filterable': False, 'is_primary_key': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'tests_article.id', 'inverse_of': 'publications',
             'relationship': 'HasMany', 'widget': None},
            {'field': 'id', 'type': 'Number', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'title', 'type': 'String', 'is_filterable': True, 'is_sortable': True, 'is_primary_key': False, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 30 characters', 'value': 30},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]}]},
        {'name': 'tests_article_publications', 'is_virtual': False, 'icon': None, 'is_read_only': False,
         'is_searchable': True, 'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None,
         'actions': [], 'segments': [], 'fields': [
            {'field': 'id', 'type': 'Number', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'article', 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_primary_key': False, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'tests_article.id', 'inverse_of': 'Article_publications+', 'relationship': 'BelongsTo',
             'widget': None}, {'field': 'publication', 'type': 'Number', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True,
                               'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
                               'integration': None, 'reference': 'tests_publication.id',
                               'inverse_of': 'Article_publications+', 'relationship': 'BelongsTo', 'widget': None}]},
        {'name': 'tests_article', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_primary_key': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'headline', 'type': 'String', 'is_filterable': True, 'is_sortable': True, 'is_primary_key': False, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 100 characters', 'value': 100},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'publications', 'type': ['Number'], 'is_filterable': False, 'is_primary_key': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'tests_publication.id', 'inverse_of': 'article_set',
             'relationship': 'HasMany', 'widget': None}]},
        {'name': 'tests_place', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'restaurant', 'type': 'Number', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'tests_restaurant.place_id', 'inverse_of': 'place', 'relationship': 'HasOne', 'widget': None},
            {'field': 'id', 'type': 'Number', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'name', 'type': 'String', 'is_filterable': True, 'is_sortable': True, 'is_primary_key': False, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 50 characters', 'value': 50},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'address', 'type': 'String', 'is_filterable': True, 'is_sortable': True, 'is_primary_key': False, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 80 characters', 'value': 80},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]}]},
        {'name': 'tests_restaurant', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'waiter_set', 'type': ['Number'], 'is_filterable': False, 'is_sortable': True, 'is_primary_key': False,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'tests_waiter.id', 'inverse_of': 'restaurant', 'relationship': 'HasMany',
             'widget': None},
            {'field': 'place', 'type': 'Number', 'is_filterable': True, 'is_sortable': True, 'is_primary_key': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'tests_place.id', 'inverse_of': 'restaurant', 'relationship': 'HasOne', 'widget': None},
            {'field': 'serves_hot_dogs', 'type': 'Boolean', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': False,
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'serves_pizza', 'type': 'Boolean', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': False,
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None}]},
        {'name': 'tests_waiter', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'type': 'Number', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'restaurant', 'type': 'Number', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'tests_restaurant.place_id', 'inverse_of': 'waiter_set', 'relationship': 'BelongsTo',
             'widget': None},
            {'field': 'name', 'type': 'String', 'is_filterable': True, 'is_sortable': True, 'is_primary_key': False, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 50 characters', 'value': 50},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]}]},
        {'name': 'tests_student', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'type': 'Number', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'year_in_school', 'type': 'Enum', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': 'FR',
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None,
             'validations': [
                 {'type': 'is shorter than', 'message': 'Ensure this value has at most 2 characters', 'value': 2}],
             'enums': ['FR', 'SO', 'JR', 'SR', 'GR']}]},
        {'name': 'tests_chessboard', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'type': 'Number', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'board', 'type': ['String'], 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None}]},
        {'name': 'tests_serial', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'uuid', 'type': 'String', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None}]},
        {'name': 'auth_permission', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'group_set', 'type': ['Number'], 'is_filterable': False, 'is_primary_key': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'auth_group.id', 'inverse_of': 'permissions', 'relationship': 'HasMany',
             'widget': None}, {'field': 'user_set', 'type': ['Number'], 'is_primary_key': False, 'is_filterable': False, 'is_sortable': True,
                               'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
                               'integration': None, 'reference': 'auth_user.id', 'inverse_of': 'user_permissions',
                               'relationship': 'HasMany', 'widget': None},
            {'field': 'id', 'type': 'String', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'name', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 255 characters', 'value': 255},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'content_type', 'type': 'Number', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'django_content_type.id', 'inverse_of': 'permission_set',
             'relationship': 'BelongsTo', 'widget': None},
            {'field': 'codename', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 100 characters', 'value': 100},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]}]},
        {'name': 'auth_group_permissions', 'is_virtual': False, 'icon': None, 'is_read_only': False,
         'is_searchable': True, 'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None,
         'actions': [], 'segments': [], 'fields': [
            {'field': 'id', 'type': 'String', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'group', 'type': 'Number', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'auth_group.id', 'inverse_of': 'Group_permissions+', 'relationship': 'BelongsTo',
             'widget': None},
            {'field': 'permission', 'type': 'Number', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'auth_permission.id', 'inverse_of': 'Group_permissions+', 'relationship': 'BelongsTo',
             'widget': None}]},
        {'name': 'auth_group', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'user_set', 'type': ['Number'], 'is_filterable': False, 'is_primary_key': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'auth_user.id', 'inverse_of': 'groups', 'relationship': 'HasMany',
             'widget': None},
            {'field': 'id', 'type': 'String', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'name', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 150 characters', 'value': 150},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'permissions', 'type': ['Number'], 'is_filterable': False, 'is_primary_key': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'auth_permission.id', 'inverse_of': 'group_set',
             'relationship': 'HasMany', 'widget': None}]},
        {'name': 'auth_user_groups', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'type': 'String', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'user', 'type': 'Number', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'auth_user.id', 'inverse_of': 'User_groups+', 'relationship': 'BelongsTo', 'widget': None},
            {'field': 'group', 'type': 'Number', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'auth_group.id', 'inverse_of': 'User_groups+', 'relationship': 'BelongsTo', 'widget': None}]},
        {'name': 'auth_user_user_permissions', 'is_virtual': False, 'icon': None, 'is_read_only': False,
         'is_searchable': True, 'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None,
         'actions': [], 'segments': [], 'fields': [
            {'field': 'id', 'type': 'String', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'user', 'type': 'Number', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'auth_user.id', 'inverse_of': 'User_user_permissions+', 'relationship': 'BelongsTo',
             'widget': None},
            {'field': 'permission', 'type': 'Number', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'auth_permission.id', 'inverse_of': 'User_user_permissions+', 'relationship': 'BelongsTo',
             'widget': None}]},
        {'name': 'auth_user', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'id', 'type': 'String', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'password', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 128 characters', 'value': 128},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'last_login', 'type': 'Date', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'is_superuser', 'type': 'Boolean', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': False,
             'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'username', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is like', 'message': 'Ensure this value match your pattern', 'value': '^[\\w.@+-]+\\Z'},
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 150 characters', 'value': 150},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'first_name', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 150 characters', 'value': 150},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'last_name', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 150 characters', 'value': 150},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'email', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 254 characters', 'value': 254},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'is_staff', 'type': 'Boolean', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': False, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'is_active', 'type': 'Boolean', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': True, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'date_joined', 'type': 'Date', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'groups', 'type': ['Number'], 'is_filterable': False, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None,
             'reference': 'auth_group.id', 'inverse_of': 'user_set', 'relationship': 'HasMany', 'widget': None},
            {'field': 'user_permissions', 'type': ['Number'], 'is_filterable': False, 'is_primary_key': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'auth_permission.id', 'inverse_of': 'user_set',
             'relationship': 'HasMany', 'widget': None}]},
        {'name': 'django_content_type', 'is_virtual': False, 'icon': None, 'is_read_only': False, 'is_searchable': True,
         'only_for_relationships': False, 'pagination_type': 'page', 'search_fields': None, 'actions': [],
         'segments': [], 'fields': [
            {'field': 'permission_set', 'type': ['Number'], 'is_primary_key': False, 'is_filterable': False, 'is_sortable': True,
             'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
             'integration': None, 'reference': 'auth_permission.id', 'inverse_of': 'content_type',
             'relationship': 'HasMany', 'widget': None},
            {'field': 'id', 'type': 'String', 'is_filterable': True, 'is_primary_key': True, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None},
            {'field': 'app_label', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 100 characters', 'value': 100},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
            {'field': 'model', 'type': 'String', 'is_filterable': True, 'is_primary_key': False, 'is_sortable': True, 'is_read_only': False,
             'is_required': False, 'is_virtual': False, 'default_value': None, 'integration': None, 'reference': None,
             'inverse_of': None, 'relationship': None, 'widget': None, 'validations': [
                {'type': 'is shorter than', 'message': 'Ensure this value has at most 100 characters', 'value': 100},
                {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]}]}],
    'meta': {'liana': 'django-forestadmin', 'liana_version': '0.0.0',
             'stack': {'database_type': 'sqlite', 'orm_version': '9.9.9'}}}

test_serialized_schema = {
    'data': [{'id': 'tests_question', 'type': 'collections',
              'attributes': {'name': 'tests_question', 'is_virtual': False, 'icon': None, 'is_read_only': False,
                             'is_searchable': True, 'only_for_relationships': False, 'pagination_type': 'page',
                             'search_fields': None, 'actions': [{'name': 'Send invoice', 'type': 'single', 'fields': [
                      {'field': 'country', 'type': 'Enum', 'enums': ['FR', 'US'], 'isReadOnly': False,
                       'isRequired': False, 'defaultValue': None, 'integration': None, 'reference': None,
                       'description': None, 'widget': None, 'position': 0},
                      {'field': 'city', 'type': 'String', 'isReadOnly': False, 'isRequired': False,
                       'defaultValue': None, 'integration': None, 'reference': None, 'description': None,
                       'widget': None, 'hook': 'cityChange', 'position': 1},
                      {'field': 'zip code', 'type': 'String', 'is_read_only': False, 'is_required': False,
                       'default_value': None, 'integration': None, 'reference': None, 'description': None,
                       'widget': None, 'hook': 'zipCodeChange', 'position': 2}], 'hooks': {'load': True,
                                                                                           'change': ['cityChange',
                                                                                                      'zipCodeChange']},
                                                                 'endpoint': '/forest/actions/send-invoice',
                                                                 'baseUrl': None, 'httpMethod': 'POST',
                                                                 'redirect': None, 'download': False}],
                             'segments': [{'name': 'Best questions'}], 'fields': [
                      {'field': 'id', 'type': 'Number', 'is_filterable': True, 'is_sortable': True,
                       'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
                       'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None,
                       'widget': None},
                      {'field': 'question_text', 'type': 'String', 'is_filterable': True, 'is_sortable': True,
                       'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
                       'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None,
                       'validations': [
                           {'type': 'is longer than', 'message': 'Ensure this value has at least 1 characters',
                            'value': 1},
                           {'type': 'is shorter than', 'message': 'Ensure this value has at most 200 characters',
                            'value': 200},
                           {'type': 'is present', 'message': 'Ensure this value is not null or not empty'}]},
                      {'field': 'pub_date', 'type': 'Date', 'is_filterable': True, 'is_sortable': True,
                       'is_read_only': False, 'is_required': False, 'is_virtual': False, 'default_value': None,
                       'integration': None, 'reference': None, 'inverse_of': None, 'relationship': None,
                       'widget': None},
                      {'field': 'foo', 'is_virtual': True, 'type': '', 'is_filterable': True, 'is_sortable': True,
                       'is_read_only': False, 'is_required': False, 'default_value': None, 'integration': None,
                       'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None},
                      {'field': 'bar', 'is_virtual': True, 'type': '', 'is_filterable': True, 'is_sortable': True,
                       'is_read_only': False, 'is_required': False, 'default_value': None, 'integration': None,
                       'reference': None, 'inverse_of': None, 'relationship': None, 'widget': None}]},
              'relationships': {'actions': {'data': [{'id': 'tests_question.Send invoice', 'type': 'actions'}]},
                                'segments': {'data': [{'id': 'tests_question.Best questions', 'type': 'segments'}]}}}],
    'included': [{'id': 'tests_question.Send invoice', 'type': 'actions',
                  'attributes': {'name': 'Send invoice', 'type': 'single', 'fields': [
                      {'field': 'country', 'type': 'Enum', 'enums': ['FR', 'US'], 'isReadOnly': False,
                       'isRequired': False, 'defaultValue': None, 'integration': None, 'reference': None,
                       'description': None, 'widget': None, 'position': 0},
                      {'field': 'city', 'type': 'String', 'isReadOnly': False, 'isRequired': False,
                       'defaultValue': None, 'integration': None, 'reference': None, 'description': None,
                       'widget': None, 'hook': 'cityChange', 'position': 1},
                      {'field': 'zip code', 'type': 'String', 'is_read_only': False, 'is_required': False,
                       'default_value': None, 'integration': None, 'reference': None, 'description': None,
                       'widget': None, 'hook': 'zipCodeChange', 'position': 2}],
                                 'hooks': {'load': True, 'change': ['cityChange', 'zipCodeChange']},
                                 'endpoint': '/forest/actions/send-invoice', 'baseUrl': None, 'httpMethod': 'POST',
                                 'redirect': None, 'download': False}},
                 {'id': 'tests_question.Best questions', 'type': 'segments', 'attributes': {'name': 'Best questions'}}],
    'meta': {'liana': 'django-forestadmin', 'liana_version': '0.0.0',
             'stack': {'database_type': 'sqlite', 'orm_version': '9.9.9'}}}
