# -*- coding: utf-8 -*-

import os
from functools import partial


# gbk <-> big5 mappings from Mafan + Jianfan
# https://github.com/hermanschaaf/mafan
# https://code.google.com/archive/p/python-jianfan/
simplified_chinese = gbk = u"\u9515\u7691\u853c\u788d\u7231\u55f3\u5ad2\u7477\u66a7\u972d\u8c19\u94f5\u9e4c\u80ae\u8884\u5965\u5aaa\u9a9c\u9ccc\u575d\u7f62\u94af\u6446\u8d25\u5457\u9881\u529e\u7eca\u94a3\u5e2e\u7ed1\u9551\u8c24\u5265\u9971\u5b9d\u62a5\u9c8d\u9e28\u9f85\u8f88\u8d1d\u94a1\u72c8\u5907\u60eb\u9e4e\u8d32\u951b\u7ef7\u7b14\u6bd5\u6bd9\u5e01\u95ed\u835c\u54d4\u6ed7\u94cb\u7b5a\u8df8\u8fb9\u7f16\u8d2c\u53d8\u8fa9\u8fab\u82c4\u7f0f\u7b3e\u6807\u9aa0\u98d1\u98d9\u9556\u9573\u9cd4\u9cd6\u522b\u762a\u6fd2\u6ee8\u5bbe\u6448\u50a7\u7f24\u69df\u6ba1\u8191\u9554\u9acc\u9b13\u997c\u7980\u62e8\u94b5\u94c2\u9a73\u997d\u94b9\u9e41\u8865\u94b8\u8d22\u53c2\u8695\u6b8b\u60ed\u60e8\u707f\u9a96\u9eea\u82cd\u8231\u4ed3\u6ca7\u5395\u4fa7\u518c\u6d4b\u607b\u5c42\u8be7\u9538\u4faa\u9497\u6400\u63ba\u8749\u998b\u8c17\u7f20\u94f2\u4ea7\u9610\u98a4\u5181\u8c04\u8c36\u8487\u5fcf\u5a75\u9aa3\u89c7\u7985\u9561\u573a\u5c1d\u957f\u507f\u80a0\u5382\u7545\u4f25\u82cc\u6005\u960a\u9cb3\u949e\u8f66\u5f7b\u7817\u5c18\u9648\u886c\u4f27\u8c0c\u6987\u789c\u9f80\u6491\u79f0\u60e9\u8bda\u9a8b\u67a8\u67fd\u94d6\u94db\u75f4\u8fdf\u9a70\u803b\u9f7f\u70bd\u996c\u9e31\u51b2\u51b2\u866b\u5ba0\u94f3\u7574\u8e0c\u7b79\u7ef8\u4fe6\u5e31\u96e0\u6a71\u53a8\u9504\u96cf\u7840\u50a8\u89e6\u5904\u520d\u7ecc\u8e70\u4f20\u948f\u75ae\u95ef\u521b\u6006\u9524\u7f0d\u7eaf\u9e51\u7ef0\u8f8d\u9f8a\u8f9e\u8bcd\u8d50\u9e5a\u806a\u8471\u56f1\u4ece\u4e1b\u82c1\u9aa2\u679e\u51d1\u8f8f\u8e7f\u7a9c\u64ba\u9519\u9509\u9e7e\u8fbe\u54d2\u9791\u5e26\u8d37\u9a80\u7ed0\u62c5\u5355\u90f8\u63b8\u80c6\u60ee\u8bde\u5f39\u6b9a\u8d55\u7605\u7baa\u5f53\u6321\u515a\u8361\u6863\u8c20\u7800\u88c6\u6363\u5c9b\u7977\u5bfc\u76d7\u7118\u706f\u9093\u956b\u654c\u6da4\u9012\u7f14\u7c74\u8bcb\u8c1b\u7ee8\u89cc\u955d\u98a0\u70b9\u57ab\u7535\u5dc5\u94bf\u766b\u9493\u8c03\u94eb\u9cb7\u8c0d\u53e0\u9cbd\u9489\u9876\u952d\u8ba2\u94e4\u4e22\u94e5\u4e1c\u52a8\u680b\u51bb\u5cbd\u9e2b\u7aa6\u728a\u72ec\u8bfb\u8d4c\u9540\u6e0e\u691f\u724d\u7b03\u9ee9\u953b\u65ad\u7f0e\u7c16\u5151\u961f\u5bf9\u603c\u9566\u5428\u987f\u949d\u7096\u8db8\u593a\u5815\u94ce\u9e45\u989d\u8bb9\u6076\u997f\u8c14\u57a9\u960f\u8f6d\u9507\u9537\u9e57\u989a\u989b\u9cc4\u8bf6\u513f\u5c14\u9975\u8d30\u8fe9\u94d2\u9e38\u9c95\u53d1\u7f5a\u9600\u73d0\u77fe\u9492\u70e6\u8d29\u996d\u8bbf\u7eba\u94ab\u9c82\u98de\u8bfd\u5e9f\u8d39\u7eef\u9544\u9cb1\u7eb7\u575f\u594b\u6124\u7caa\u507e\u4e30\u67ab\u950b\u98ce\u75af\u51af\u7f1d\u8bbd\u51e4\u6ca3\u80a4\u8f90\u629a\u8f85\u8d4b\u590d\u8d1f\u8ba3\u5987\u7f1a\u51eb\u9a78\u7ec2\u7ecb\u8d59\u9eb8\u9c8b\u9cc6\u9486\u8be5\u9499\u76d6\u8d45\u6746\u8d76\u79c6\u8d63\u5c34\u64c0\u7ec0\u5188\u521a\u94a2\u7eb2\u5c97\u6206\u9550\u777e\u8bf0\u7f1f\u9506\u6401\u9e3d\u9601\u94ec\u4e2a\u7ea5\u9549\u988d\u7ed9\u4e98\u8d53\u7ee0\u9ca0\u9f9a\u5bab\u5de9\u8d21\u94a9\u6c9f\u82df\u6784\u8d2d\u591f\u8bdf\u7f11\u89cf\u86ca\u987e\u8bc2\u6bc2\u94b4\u9522\u9e2a\u9e44\u9e58\u5250\u6302\u9e39\u63b4\u5173\u89c2\u9986\u60ef\u8d2f\u8bd6\u63bc\u9e73\u9ccf\u5e7f\u72b7\u89c4\u5f52\u9f9f\u95fa\u8f68\u8be1\u8d35\u523d\u5326\u523f\u59ab\u6867\u9c91\u9cdc\u8f8a\u6eda\u886e\u7ef2\u9ca7\u9505\u56fd\u8fc7\u57da\u5459\u5e3c\u6901\u8748\u94ea\u9a87\u97e9\u6c49\u961a\u7ed7\u9889\u53f7\u704f\u98a2\u9602\u9e64\u8d3a\u8bc3\u9616\u86ce\u6a2a\u8f70\u9e3f\u7ea2\u9ec9\u8ba7\u836d\u95f3\u9c8e\u58f6\u62a4\u6caa\u6237\u6d52\u9e55\u54d7\u534e\u753b\u5212\u8bdd\u9a85\u6866\u94e7\u6000\u574f\u6b22\u73af\u8fd8\u7f13\u6362\u5524\u75ea\u7115\u6da3\u5942\u7f33\u953e\u9ca9\u9ec4\u8c0e\u9cc7\u6325\u8f89\u6bc1\u8d3f\u79fd\u4f1a\u70e9\u6c47\u8bb3\u8bf2\u7ed8\u8bd9\u835f\u54d5\u6d4d\u7f0b\u73f2\u6656\u8364\u6d51\u8be8\u9984\u960d\u83b7\u8d27\u7978\u94ac\u956c\u51fb\u673a\u79ef\u9965\u8ff9\u8ba5\u9e21\u7ee9\u7f09\u6781\u8f91\u7ea7\u6324\u51e0\u84df\u5242\u6d4e\u8ba1\u8bb0\u9645\u7ee7\u7eaa\u8ba6\u8bd8\u8360\u53fd\u54dc\u9aa5\u7391\u89ca\u9f51\u77f6\u7f81\u867f\u8dfb\u9701\u9c9a\u9cab\u5939\u835a\u988a\u8d3e\u94be\u4ef7\u9a7e\u90cf\u6d43\u94d7\u9553\u86f2\u6b7c\u76d1\u575a\u7b3a\u95f4\u8270\u7f04\u8327\u68c0\u78b1\u7877\u62e3\u6361\u7b80\u4fed\u51cf\u8350\u69db\u9274\u8df5\u8d31\u89c1\u952e\u8230\u5251\u996f\u6e10\u6e85\u6da7\u8c0f\u7f23\u620b\u622c\u7751\u9e63\u7b15\u9ca3\u97af\u5c06\u6d46\u848b\u6868\u5956\u8bb2\u9171\u7edb\u7f30\u80f6\u6d47\u9a84\u5a07\u6405\u94f0\u77eb\u4fa5\u811a\u997a\u7f34\u7ede\u8f7f\u8f83\u6322\u5ce4\u9e6a\u9c9b\u9636\u8282\u6d01\u7ed3\u8beb\u5c4a\u7596\u988c\u9c92\u7d27\u9526\u4ec5\u8c28\u8fdb\u664b\u70ec\u5c3d\u52b2\u8346\u830e\u537a\u8369\u9991\u7f19\u8d46\u89d0\u9cb8\u60ca\u7ecf\u9888\u9759\u955c\u5f84\u75c9\u7ade\u51c0\u522d\u6cfe\u8ff3\u5f2a\u80eb\u9753\u7ea0\u53a9\u65e7\u9604\u9e20\u9e6b\u9a79\u4e3e\u636e\u952f\u60e7\u5267\u8bb5\u5c66\u6989\u98d3\u949c\u9514\u7aad\u9f83\u9e43\u7ee2\u9529\u954c\u96bd\u89c9\u51b3\u7edd\u8c32\u73cf\u94a7\u519b\u9a8f\u76b2\u5f00\u51ef\u5240\u57b2\u5ffe\u607a\u94e0\u9534\u9f9b\u95f6\u94aa\u94d0\u9897\u58f3\u8bfe\u9a92\u7f02\u8f72\u94b6\u951e\u9894\u57a6\u6073\u9f88\u94ff\u62a0\u5e93\u88e4\u55be\u5757\u4fa9\u90d0\u54d9\u810d\u5bbd\u72ef\u9acb\u77ff\u65f7\u51b5\u8bd3\u8bf3\u909d\u5739\u7ea9\u8d36\u4e8f\u5cbf\u7aa5\u9988\u6e83\u532e\u8489\u6126\u8069\u7bd1\u9603\u951f\u9cb2\u6269\u9614\u86f4\u8721\u814a\u83b1\u6765\u8d56\u5d03\u5f95\u6d9e\u6fd1\u8d49\u7750\u94fc\u765e\u7c41\u84dd\u680f\u62e6\u7bee\u9611\u5170\u6f9c\u8c30\u63fd\u89c8\u61d2\u7f06\u70c2\u6ee5\u5c9a\u6984\u6593\u9567\u8934\u7405\u9606\u9512\u635e\u52b3\u6d9d\u5520\u5d02\u94d1\u94f9\u75e8\u4e50\u9cd3\u956d\u5792\u7c7b\u6cea\u8bd4\u7f27\u7bf1\u72f8\u79bb\u9ca4\u793c\u4e3d\u5389\u52b1\u783e\u5386\u6ca5\u96b6\u4fea\u90e6\u575c\u82c8\u8385\u84e0\u5456\u9026\u9a8a\u7f21\u67a5\u680e\u8f79\u783a\u9502\u9e42\u75a0\u7c9d\u8dde\u96f3\u9ca1\u9ce2\u4fe9\u8054\u83b2\u8fde\u9570\u601c\u6d9f\u5e18\u655b\u8138\u94fe\u604b\u70bc\u7ec3\u8539\u5941\u6f4b\u740f\u6b93\u88e2\u88e3\u9ca2\u7cae\u51c9\u4e24\u8f86\u8c05\u9b49\u7597\u8fbd\u9563\u7f2d\u948c\u9e69\u730e\u4e34\u90bb\u9cde\u51db\u8d41\u853a\u5eea\u6aa9\u8f9a\u8e8f\u9f84\u94c3\u7075\u5cad\u9886\u7eeb\u68c2\u86cf\u9cae\u998f\u5218\u6d4f\u9a9d\u7efa\u954f\u9e68\u9f99\u804b\u5499\u7b3c\u5784\u62e2\u9647\u830f\u6cf7\u73d1\u680a\u80e7\u783b\u697c\u5a04\u6402\u7bd3\u507b\u848c\u55bd\u5d5d\u9542\u7618\u8027\u877c\u9ac5\u82a6\u5362\u9885\u5e90\u7089\u63b3\u5364\u864f\u9c81\u8d42\u7984\u5f55\u9646\u5786\u64b8\u565c\u95fe\u6cf8\u6e0c\u680c\u6a79\u8f73\u8f82\u8f98\u6c07\u80ea\u9e2c\u9e6d\u823b\u9c88\u5ce6\u631b\u5b6a\u6ee6\u4e71\u8114\u5a08\u683e\u9e3e\u92ae\u62a1\u8f6e\u4f26\u4ed1\u6ca6\u7eb6\u8bba\u56f5\u841d\u7f57\u903b\u9523\u7ba9\u9aa1\u9a86\u7edc\u8366\u7321\u6cfa\u6924\u8136\u9559\u9a74\u5415\u94dd\u4fa3\u5c61\u7f15\u8651\u6ee4\u7eff\u6988\u891b\u950a\u5452\u5988\u739b\u7801\u8682\u9a6c\u9a82\u5417\u551b\u5b37\u6769\u4e70\u9ea6\u5356\u8fc8\u8109\u52a2\u7792\u9992\u86ee\u6ee1\u8c29\u7f26\u9558\u98a1\u9cd7\u732b\u951a\u94c6\u8d38\u9ebd\u6ca1\u9541\u95e8\u95f7\u4eec\u626a\u7116\u61d1\u9494\u9530\u68a6\u772f\u8c1c\u5f25\u89c5\u5e42\u8288\u8c27\u7315\u7962\u7ef5\u7f05\u6e11\u817c\u9efe\u5e99\u7f08\u7f2a\u706d\u60af\u95fd\u95f5\u7f17\u9e23\u94ed\u8c2c\u8c1f\u84e6\u998d\u6b81\u9546\u8c0b\u4ea9\u94bc\u5450\u94a0\u7eb3\u96be\u6320\u8111\u607c\u95f9\u94d9\u8bb7\u9981\u5185\u62df\u817b\u94cc\u9cb5\u64b5\u8f87\u9cb6\u917f\u9e1f\u8311\u8885\u8042\u556e\u954a\u954d\u9667\u8616\u55eb\u989f\u8e51\u67e0\u72de\u5b81\u62e7\u6cde\u82ce\u549b\u804d\u94ae\u7ebd\u8113\u6d53\u519c\u4fac\u54dd\u9a7d\u9495\u8bfa\u50a9\u759f\u6b27\u9e25\u6bb4\u5455\u6ca4\u8bb4\u6004\u74ef\u76d8\u8e52\u5e9e\u629b\u75b1\u8d54\u8f94\u55b7\u9e4f\u7eb0\u7f74\u94cd\u9a97\u8c1d\u9a88\u98d8\u7f25\u9891\u8d2b\u5ad4\u82f9\u51ed\u8bc4\u6cfc\u9887\u948b\u6251\u94fa\u6734\u8c31\u9564\u9568\u6816\u8110\u9f50\u9a91\u5c82\u542f\u6c14\u5f03\u8bab\u8572\u9a90\u7eee\u6864\u789b\u9880\u9883\u9ccd\u7275\u948e\u94c5\u8fc1\u7b7e\u8c26\u94b1\u94b3\u6f5c\u6d45\u8c34\u5811\u4f65\u8368\u60ad\u9a9e\u7f31\u6920\u94a4\u67aa\u545b\u5899\u8537\u5f3a\u62a2\u5af1\u6a2f\u6217\u709d\u9516\u9535\u956a\u7f9f\u8dc4\u9539\u6865\u4e54\u4fa8\u7fd8\u7a8d\u8bee\u8c2f\u835e\u7f32\u7857\u8df7\u7a83\u60ec\u9532\u7ba7\u94a6\u4eb2\u5bdd\u9513\u8f7b\u6c22\u503e\u9877\u8bf7\u5e86\u63ff\u9cad\u743c\u7a77\u8315\u86f1\u5def\u8d47\u866e\u9cc5\u8d8b\u533a\u8eaf\u9a71\u9f8b\u8bce\u5c96\u9612\u89d1\u9e32\u98a7\u6743\u529d\u8be0\u7efb\u8f81\u94e8\u5374\u9e4a\u786e\u9615\u9619\u60ab\u8ba9\u9976\u6270\u7ed5\u835b\u5a06\u6861\u70ed\u97e7\u8ba4\u7eab\u996a\u8f6b\u8363\u7ed2\u5d58\u877e\u7f1b\u94f7\u98a6\u8f6f\u9510\u86ac\u95f0\u6da6\u6d12\u8428\u98d2\u9cc3\u8d5b\u4f1e\u6bf5\u7cc1\u4e27\u9a9a\u626b\u7f2b\u6da9\u556c\u94ef\u7a51\u6740\u5239\u7eb1\u94e9\u9ca8\u7b5b\u6652\u917e\u5220\u95ea\u9655\u8d61\u7f2e\u8baa\u59d7\u9a9f\u9490\u9cdd\u5892\u4f24\u8d4f\u57a7\u6b87\u89de\u70e7\u7ecd\u8d4a\u6444\u6151\u8bbe\u538d\u6ee0\u7572\u7ec5\u5ba1\u5a76\u80be\u6e17\u8bdc\u8c02\u6e16\u58f0\u7ef3\u80dc\u5e08\u72ee\u6e7f\u8bd7\u65f6\u8680\u5b9e\u8bc6\u9a76\u52bf\u9002\u91ca\u9970\u89c6\u8bd5\u8c25\u57d8\u83b3\u5f11\u8f7c\u8d33\u94c8\u9ca5\u5bff\u517d\u7ef6\u67a2\u8f93\u4e66\u8d4e\u5c5e\u672f\u6811\u7ad6\u6570\u6445\u7ebe\u5e05\u95e9\u53cc\u8c01\u7a0e\u987a\u8bf4\u7855\u70c1\u94c4\u4e1d\u9972\u53ae\u9a77\u7f0c\u9536\u9e36\u8038\u6002\u9882\u8bbc\u8bf5\u64de\u85ae\u998a\u98d5\u953c\u82cf\u8bc9\u8083\u8c21\u7a23\u867d\u968f\u7ee5\u5c81\u8c07\u5b59\u635f\u7b0b\u836a\u72f2\u7f29\u7410\u9501\u5522\u7743\u736d\u631e\u95fc\u94ca\u9cce\u53f0\u6001\u949b\u9c90\u644a\u8d2a\u762b\u6ee9\u575b\u8c2d\u8c08\u53f9\u6619\u94bd\u952c\u9878\u6c64\u70eb\u50a5\u9967\u94f4\u9557\u6d9b\u7ee6\u8ba8\u97ec\u94fd\u817e\u8a8a\u9511\u9898\u4f53\u5c49\u7f07\u9e48\u9617\u6761\u7c9c\u9f86\u9ca6\u8d34\u94c1\u5385\u542c\u70c3\u94dc\u7edf\u6078\u5934\u94ad\u79c3\u56fe\u948d\u56e2\u629f\u9893\u8715\u9968\u8131\u9e35\u9a6e\u9a7c\u692d\u7ba8\u9f0d\u889c\u5a32\u817d\u5f2f\u6e7e\u987d\u4e07\u7ea8\u7efe\u7f51\u8f8b\u97e6\u8fdd\u56f4\u4e3a\u6f4d\u7ef4\u82c7\u4f1f\u4f2a\u7eac\u8c13\u536b\u8bff\u5e0f\u95f1\u6ca9\u6da0\u73ae\u97ea\u709c\u9c94\u6e29\u95fb\u7eb9\u7a33\u95ee\u960c\u74ee\u631d\u8717\u6da1\u7a9d\u5367\u83b4\u9f8c\u545c\u94a8\u4e4c\u8bec\u65e0\u829c\u5434\u575e\u96fe\u52a1\u8bef\u90ac\u5e91\u6003\u59a9\u9a9b\u9e49\u9e5c\u9521\u727a\u88ad\u4e60\u94e3\u620f\u7ec6\u9969\u960b\u73ba\u89cb\u867e\u8f96\u5ce1\u4fa0\u72ed\u53a6\u5413\u7856\u9c9c\u7ea4\u8d24\u8854\u95f2\u663e\u9669\u73b0\u732e\u53bf\u9985\u7fa1\u5baa\u7ebf\u82cb\u83b6\u85d3\u5c98\u7303\u5a34\u9e47\u75eb\u869d\u7c7c\u8df9\u53a2\u9576\u4e61\u8be6\u54cd\u9879\u8297\u9977\u9aa7\u7f03\u98e8\u8427\u56a3\u9500\u6653\u5578\u54d3\u6f47\u9a81\u7ee1\u67ad\u7bab\u534f\u631f\u643a\u80c1\u8c10\u5199\u6cfb\u8c22\u4eb5\u64b7\u7ec1\u7f2c\u950c\u8845\u5174\u9649\u8365\u51f6\u6c79\u9508\u7ee3\u9990\u9e3a\u865a\u5618\u987b\u8bb8\u53d9\u7eea\u7eed\u8be9\u987c\u8f69\u60ac\u9009\u7663\u7eda\u8c16\u94c9\u955f\u5b66\u8c11\u6cf6\u9cd5\u52cb\u8be2\u5bfb\u9a6f\u8bad\u8baf\u900a\u57d9\u6d54\u9c9f\u538b\u9e26\u9e2d\u54d1\u4e9a\u8bb6\u57ad\u5a05\u6860\u6c29\u9609\u70df\u76d0\u4e25\u5ca9\u989c\u960e\u8273\u538c\u781a\u5f66\u8c1a\u9a8c\u53a3\u8d5d\u4fe8\u5156\u8c33\u6079\u95eb\u917d\u9b47\u990d\u9f39\u9e2f\u6768\u626c\u75a1\u9633\u75d2\u517b\u6837\u7080\u7476\u6447\u5c27\u9065\u7a91\u8c23\u836f\u8f7a\u9e5e\u9cd0\u7237\u9875\u4e1a\u53f6\u9765\u8c12\u90ba\u6654\u70e8\u533b\u94f1\u9890\u9057\u4eea\u8681\u827a\u4ebf\u5fc6\u4e49\u8be3\u8bae\u8c0a\u8bd1\u5f02\u7ece\u8bd2\u5453\u5cc4\u9974\u603f\u9a7f\u7f22\u8f76\u8d3b\u9487\u9552\u9571\u7617\u8223\u836b\u9634\u94f6\u996e\u9690\u94df\u763e\u6a31\u5a74\u9e70\u5e94\u7f28\u83b9\u8424\u8425\u8367\u8747\u8d62\u9896\u8314\u83ba\u8426\u84e5\u6484\u5624\u6ee2\u6f46\u748e\u9e66\u763f\u988f\u7f42\u54df\u62e5\u4f63\u75c8\u8e0a\u548f\u955b\u4f18\u5fe7\u90ae\u94c0\u72b9\u8bf1\u83b8\u94d5\u9c7f\u8206\u9c7c\u6e14\u5a31\u4e0e\u5c7f\u8bed\u72f1\u8a89\u9884\u9a6d\u4f1b\u4fe3\u8c00\u8c15\u84e3\u5d5b\u996b\u9608\u59aa\u7ea1\u89ce\u6b24\u94b0\u9e46\u9e6c\u9f89\u9e33\u6e0a\u8f95\u56ed\u5458\u5706\u7f18\u8fdc\u6a7c\u9e22\u9f0b\u7ea6\u8dc3\u94a5\u7ca4\u60a6\u9605\u94ba\u90e7\u5300\u9668\u8fd0\u8574\u915d\u6655\u97f5\u90d3\u82b8\u607d\u6120\u7ead\u97eb\u6b92\u6c32\u6742\u707e\u8f7d\u6512\u6682\u8d5e\u74d2\u8db1\u933e\u8d43\u810f\u9a75\u51ff\u67a3\u8d23\u62e9\u5219\u6cfd\u8d5c\u5567\u5e3b\u7ba6\u8d3c\u8c2e\u8d60\u7efc\u7f2f\u8f67\u94e1\u95f8\u6805\u8bc8\u658b\u503a\u6be1\u76cf\u65a9\u8f97\u5d2d\u6808\u6218\u7efd\u8c35\u5f20\u6da8\u5e10\u8d26\u80c0\u8d75\u8bcf\u948a\u86f0\u8f99\u9517\u8fd9\u8c2a\u8f84\u9e67\u8d1e\u9488\u4fa6\u8bca\u9547\u9635\u6d48\u7f1c\u6862\u8f78\u8d48\u796f\u9e29\u6323\u7741\u72f0\u4e89\u5e27\u75c7\u90d1\u8bc1\u8be4\u5ce5\u94b2\u94ee\u7b5d\u7ec7\u804c\u6267\u7eb8\u631a\u63b7\u5e1c\u8d28\u6ede\u9a98\u6809\u6800\u8f75\u8f7e\u8d3d\u9e37\u86f3\u7d77\u8e2c\u8e2f\u89ef\u949f\u7ec8\u79cd\u80bf\u4f17\u953a\u8bcc\u8f74\u76b1\u663c\u9aa4\u7ea3\u7ec9\u732a\u8bf8\u8bdb\u70db\u77a9\u5631\u8d2e\u94f8\u9a7b\u4f2b\u69e0\u94e2\u4e13\u7816\u8f6c\u8d5a\u556d\u9994\u989e\u6869\u5e84\u88c5\u5986\u58ee\u72b6\u9525\u8d58\u5760\u7f00\u9a93\u7f12\u8c06\u51c6\u7740\u6d4a\u8bfc\u956f\u5179\u8d44\u6e0d\u8c18\u7f01\u8f8e\u8d40\u7726\u9531\u9f87\u9cbb\u8e2a\u603b\u7eb5\u506c\u90b9\u8bf9\u9a7a\u9cb0\u8bc5\u7ec4\u955e\u94bb\u7f35\u8e9c\u9cdf\u7ff1\u5e76\u535c\u6c89\u4e11\u6dc0\u8fed\u6597\u8303\u5e72\u768b\u7845\u67dc\u540e\u4f19\u79f8\u6770\u8bc0\u5938\u91cc\u51cc\u4e48\u9709\u637b\u51c4\u6266\u5723\u5c38\u62ac\u6d82\u6d3c\u5582\u6c61\u9528\u54b8\u874e\u5f5d\u6d8c\u6e38\u5401\u5fa1\u613f\u5cb3\u4e91\u7076\u624e\u672d\u7b51\u4e8e\u5fd7\u6ce8\u51cb\u8ba0\u8c2b\u90c4\u52d0\u51fc\u5742\u5785\u57b4\u57ef\u57dd\u82d8\u836c\u836e\u839c\u83bc\u83f0\u85c1\u63f8\u5412\u5423\u5494\u549d\u54b4\u5658\u567c\u56af\u5e5e\u5c99\u5d74\u5f77\u5fbc\u72b8\u72cd\u9980\u9987\u9993\u9995\u6123\u61b7\u61d4\u4e2c\u6e86\u6edf\u6eb7\u6f24\u6f74\u6fb9\u752f\u7e9f\u7ed4\u7ef1\u73c9\u67a7\u684a\u6849\u69d4\u6a65\u8f71\u8f77\u8d4d\u80b7\u80e8\u98da\u7173\u7145\u7198\u610d\u6dfc\u781c\u78d9\u770d\u949a\u94b7\u94d8\u94de\u9503\u950d\u950e\u950f\u9518\u951d\u952a\u952b\u953f\u9545\u954e\u9562\u9565\u9569\u9572\u7a06\u9e4b\u9e5b\u9e71\u75ac\u75b4\u75d6\u766f\u88e5\u8941\u8022\u98a5\u87a8\u9eb4\u9c85\u9c86\u9c87\u9c9e\u9cb4\u9cba\u9cbc\u9cca\u9ccb\u9cd8\u9cd9\u9792\u97b4\u9f44"

traditional_chinese = big5 = u"\u9312\u769a\u85f9\u7919\u611b\u566f\u5b21\u74a6\u66d6\u9744\u8af3\u92a8\u9d6a\u9aaf\u8956\u5967\u5abc\u9a41\u9c32\u58e9\u7f77\u9200\u64fa\u6557\u5504\u9812\u8fa6\u7d46\u9211\u5e6b\u7d81\u938a\u8b17\u525d\u98fd\u5bf6\u5831\u9b91\u9d07\u9f59\u8f29\u8c9d\u92c7\u72fd\u5099\u618a\u9d6f\u8cc1\u931b\u7e43\u7b46\u7562\u6583\u5e63\u9589\u84fd\u55f6\u6f77\u924d\u7bf3\u8e55\u908a\u7de8\u8cb6\u8b8a\u8faf\u8fae\u8290\u7df6\u7c69\u6a19\u9a43\u98ae\u98c6\u93e2\u9463\u9c3e\u9c49\u5225\u765f\u7015\u6ff1\u8cd3\u64ef\u5110\u7e7d\u6ab3\u6baf\u81cf\u944c\u9ad5\u9b22\u9905\u7a1f\u64a5\u7f3d\u9251\u99c1\u9911\u9238\u9d53\u88dc\u923d\u8ca1\u53c3\u8836\u6b98\u615a\u6158\u71e6\u9a42\u9ef2\u84bc\u8259\u5009\u6ec4\u5ec1\u5074\u518a\u6e2c\u60fb\u5c64\u8a6b\u9364\u5115\u91f5\u6519\u647b\u87ec\u995e\u8b92\u7e8f\u93df\u7522\u95e1\u986b\u56c5\u8ac2\u8b96\u8546\u61fa\u5b0b\u9a4f\u8998\u79aa\u9414\u5834\u5617\u9577\u511f\u8178\u5ee0\u66a2\u5000\u8407\u60b5\u95b6\u9be7\u9214\u8eca\u5fb9\u7868\u5875\u9673\u896f\u5096\u8af6\u6aec\u78e3\u9f54\u6490\u7a31\u61f2\u8aa0\u9a01\u68d6\u6a89\u92ee\u943a\u7661\u9072\u99b3\u6065\u9f52\u71be\u98ed\u9d1f\u6c96\u885d\u87f2\u5bf5\u9283\u7587\u8e8a\u7c4c\u7da2\u5114\u5e6c\u8b8e\u6ae5\u5eda\u92e4\u96db\u790e\u5132\u89f8\u8655\u82bb\u7d40\u8e95\u50b3\u91e7\u7621\u95d6\u5275\u6134\u9318\u7d9e\u7d14\u9d89\u7dbd\u8f1f\u9f6a\u8fad\u8a5e\u8cdc\u9dbf\u8070\u8525\u56ea\u5f9e\u53e2\u84ef\u9a44\u6a05\u6e4a\u8f33\u8ea5\u7ac4\u651b\u932f\u92bc\u9e7a\u9054\u5660\u97c3\u5e36\u8cb8\u99d8\u7d3f\u64d4\u55ae\u9132\u64a3\u81bd\u619a\u8a95\u5f48\u6bab\u8ce7\u7649\u7c1e\u7576\u64cb\u9ee8\u8569\u6a94\u8b9c\u78ad\u8960\u6417\u5cf6\u79b1\u5c0e\u76dc\u71fe\u71c8\u9127\u9419\u6575\u6ecc\u905e\u7de0\u7cf4\u8a46\u8ae6\u7d88\u89bf\u93d1\u985b\u9ede\u588a\u96fb\u5dd4\u923f\u7672\u91e3\u8abf\u929a\u9bdb\u8adc\u758a\u9c08\u91d8\u9802\u9320\u8a02\u92cc\u4e1f\u92a9\u6771\u52d5\u68df\u51cd\u5d20\u9d87\u7ac7\u72a2\u7368\u8b80\u8ced\u934d\u7006\u6add\u7258\u7be4\u9ef7\u935b\u65b7\u7dde\u7c6a\u514c\u968a\u5c0d\u61df\u9413\u5678\u9813\u920d\u71c9\u8e89\u596a\u58ae\u9438\u9d5d\u984d\u8a1b\u60e1\u9913\u8ae4\u580a\u95bc\u8edb\u92e8\u9354\u9d9a\u984e\u9853\u9c77\u8a92\u5152\u723e\u990c\u8cb3\u9087\u927a\u9d2f\u9b9e\u767c\u7f70\u95a5\u743a\u792c\u91e9\u7169\u8ca9\u98ef\u8a2a\u7d21\u9201\u9b74\u98db\u8ab9\u5ee2\u8cbb\u7dcb\u9428\u9be1\u7d1b\u58b3\u596e\u61a4\u7cde\u50e8\u8c50\u6953\u92d2\u98a8\u760b\u99ae\u7e2b\u8af7\u9cf3\u7043\u819a\u8f3b\u64ab\u8f14\u8ce6\u5fa9\u8ca0\u8a03\u5a66\u7e1b\u9ce7\u99d9\u7d31\u7d3c\u8cfb\u9ea9\u9b92\u9c12\u91d3\u8a72\u9223\u84cb\u8cc5\u687f\u8d95\u7a08\u8d1b\u5c37\u641f\u7d3a\u5ca1\u525b\u92fc\u7db1\u5d17\u6207\u93ac\u776a\u8aa5\u7e1e\u92ef\u64f1\u9d3f\u95a3\u927b\u500b\u7d07\u9398\u6f41\u7d66\u4e99\u8ce1\u7d86\u9bc1\u9f94\u5bae\u978f\u8ca2\u9264\u6e9d\u830d\u69cb\u8cfc\u5920\u8a6c\u7df1\u89af\u8831\u9867\u8a41\u8f42\u9237\u932e\u9d23\u9d60\u9dbb\u526e\u639b\u9d30\u6451\u95dc\u89c0\u9928\u6163\u8cab\u8a7f\u645c\u9e1b\u9c25\u5ee3\u7377\u898f\u6b78\u9f9c\u95a8\u8ecc\u8a6d\u8cb4\u528a\u532d\u528c\u5aaf\u6a9c\u9bad\u9c56\u8f25\u6efe\u889e\u7dc4\u9bc0\u934b\u570b\u904e\u581d\u54bc\u5e57\u69e8\u87c8\u927f\u99ed\u97d3\u6f22\u95de\u7d4e\u9821\u865f\u705d\u9865\u95a1\u9db4\u8cc0\u8a36\u95d4\u8823\u6a6b\u8f5f\u9d3b\u7d05\u9ecc\u8a0c\u8452\u958e\u9c5f\u58fa\u8b77\u6eec\u6236\u6ef8\u9d98\u5629\u83ef\u756b\u5283\u8a71\u9a4a\u6a3a\u93f5\u61f7\u58de\u6b61\u74b0\u9084\u7de9\u63db\u559a\u7613\u7165\u6e19\u5950\u7e6f\u9370\u9bc7\u9ec3\u8b0a\u9c09\u63ee\u8f1d\u6bc0\u8cc4\u7a62\u6703\u71f4\u532f\u8af1\u8aa8\u7e6a\u8a7c\u8588\u5666\u6fae\u7e62\u743f\u6689\u8477\u6e3e\u8ae2\u991b\u95bd\u7372\u8ca8\u798d\u9225\u944a\u64ca\u6a5f\u7a4d\u9951\u8de1\u8b4f\u96de\u7e3e\u7ddd\u6975\u8f2f\u7d1a\u64e0\u5e7e\u858a\u5291\u6fdf\u8a08\u8a18\u969b\u7e7c\u7d00\u8a10\u8a70\u85ba\u5630\u568c\u9a65\u74a3\u89ac\u9f4f\u78ef\u7f88\u8806\u8e8b\u973d\u9c6d\u9bfd\u593e\u83a2\u9830\u8cc8\u9240\u50f9\u99d5\u90df\u6d79\u92cf\u93b5\u87ef\u6bb2\u76e3\u5805\u7b8b\u9593\u8271\u7dd8\u7e6d\u6aa2\u583f\u9e7c\u63c0\u64bf\u7c21\u5109\u6e1b\u85a6\u6abb\u9452\u8e10\u8ce4\u898b\u9375\u8266\u528d\u991e\u6f38\u6ffa\u6f97\u8aeb\u7e11\u6214\u6229\u77bc\u9dbc\u7b67\u9c39\u97c9\u5c07\u6f3f\u8523\u69f3\u734e\u8b1b\u91ac\u7d73\u97c1\u81a0\u6f86\u9a55\u5b0c\u652a\u9278\u77ef\u50e5\u8173\u9903\u7e73\u7d5e\u8f4e\u8f03\u649f\u5da0\u9de6\u9bab\u968e\u7bc0\u6f54\u7d50\u8aa1\u5c46\u7664\u981c\u9b9a\u7dca\u9326\u50c5\u8b39\u9032\u6649\u71fc\u76e1\u52c1\u834a\u8396\u5df9\u85ce\u9949\u7e09\u8d10\u89b2\u9be8\u9a5a\u7d93\u9838\u975c\u93e1\u5f91\u75d9\u7af6\u51c8\u5244\u6d87\u9015\u5f33\u811b\u975a\u7cfe\u5ec4\u820a\u9b2e\u9ce9\u9df2\u99d2\u8209\u64da\u92f8\u61fc\u5287\u8a4e\u5c68\u6af8\u98b6\u9245\u92e6\u7ab6\u9f5f\u9d51\u7d79\u9308\u942b\u96cb\u89ba\u6c7a\u7d55\u8b4e\u73a8\u921e\u8ecd\u99ff\u76b8\u958b\u51f1\u5274\u584f\u613e\u6137\u93a7\u9347\u9f95\u958c\u9227\u92ac\u9846\u6bbc\u8ab2\u9a0d\u7dd9\u8efb\u9233\u9301\u9837\u58be\u61c7\u9f66\u93d7\u6473\u5eab\u8932\u56b3\u584a\u5108\u9136\u5672\u81be\u5bec\u736a\u9ad6\u7926\u66e0\u6cc1\u8a86\u8a91\u913a\u58d9\u7e8a\u8cba\u8667\u5dcb\u7aba\u994b\u6f70\u5331\u8562\u6192\u8075\u7c23\u95ab\u9315\u9be4\u64f4\u95ca\u8810\u881f\u81d8\u840a\u4f86\u8cf4\u5d0d\u5fa0\u6df6\u7028\u8cda\u775e\u9338\u7669\u7c5f\u85cd\u6b04\u6514\u7c43\u95cc\u862d\u703e\u8b95\u652c\u89bd\u61f6\u7e9c\u721b\u6feb\u5d50\u6b16\u6595\u946d\u8964\u746f\u95ac\u92c3\u6488\u52de\u6f87\u562e\u5d97\u92a0\u9412\u7646\u6a02\u9c33\u9433\u58d8\u985e\u6dda\u8a84\u7e32\u7c6c\u8c8d\u96e2\u9bc9\u79ae\u9e97\u53b2\u52f5\u792b\u6b77\u701d\u96b8\u5137\u9148\u58e2\u85f6\u849e\u863a\u56a6\u9090\u9a6a\u7e2d\u6aea\u6adf\u8f62\u792a\u92f0\u9e1d\u7658\u7cf2\u8e92\u9742\u9c7a\u9c67\u5006\u806f\u84ee\u9023\u942e\u6190\u6f23\u7c3e\u6582\u81c9\u93c8\u6200\u7149\u7df4\u861e\u5969\u7032\u7489\u6bae\u8933\u895d\u9c31\u7ce7\u6dbc\u5169\u8f1b\u8ad2\u9b4e\u7642\u907c\u9410\u7e5a\u91d5\u9def\u7375\u81e8\u9130\u9c57\u51dc\u8cc3\u85fa\u5ee9\u6a81\u8f54\u8eaa\u9f61\u9234\u9748\u5dba\u9818\u7dbe\u6b1e\u87f6\u9bea\u993e\u5289\u700f\u9a2e\u7db9\u93a6\u9dda\u9f8d\u807e\u56a8\u7c60\u58df\u650f\u96b4\u8622\u7027\u74cf\u6af3\u6727\u7931\u6a13\u5a41\u645f\u7c0d\u50c2\u851e\u560d\u5d81\u93e4\u763a\u802c\u87bb\u9acf\u8606\u76e7\u9871\u5eec\u7210\u64c4\u9e75\u865c\u9b6f\u8cc2\u797f\u9304\u9678\u58da\u64fc\u5695\u95ad\u7018\u6de5\u6ae8\u6ad3\u8f64\u8f05\u8f46\u6c0c\u81da\u9e15\u9dfa\u826b\u9c78\u5dd2\u6523\u5b7f\u7064\u4e82\u81e0\u5b4c\u6b12\u9e1e\u947e\u6384\u8f2a\u502b\u4f96\u6dea\u7db8\u8ad6\u5707\u863f\u7f85\u908f\u947c\u7c6e\u9a3e\u99f1\u7d61\u7296\u7380\u6ffc\u6b0f\u8161\u93cd\u9a62\u5442\u92c1\u4fb6\u5c62\u7e37\u616e\u6ffe\u7da0\u6ada\u8938\u92dd\u5638\u5abd\u746a\u78bc\u879e\u99ac\u7f75\u55ce\u561c\u5b24\u69aa\u8cb7\u9ea5\u8ce3\u9081\u8108\u52f1\u779e\u9945\u883b\u6eff\u8b3e\u7e35\u93dd\u9859\u9c3b\u8c93\u9328\u925a\u8cbf\u9ebc\u6c92\u9382\u9580\u60b6\u5011\u636b\u71dc\u61e3\u9346\u9333\u5922\u7787\u8b0e\u5f4c\u8993\u51aa\u7f8b\u8b10\u737c\u79b0\u7dbf\u7dec\u6fa0\u9766\u9efd\u5edf\u7df2\u7e46\u6ec5\u61ab\u95a9\u9594\u7de1\u9cf4\u9298\u8b2c\u8b28\u9a40\u9943\u6b7f\u93cc\u8b00\u755d\u926c\u5436\u9209\u7d0d\u96e3\u6493\u8166\u60f1\u9b27\u9403\u8a25\u9912\u5167\u64ec\u81a9\u922e\u9be2\u6506\u8f26\u9bf0\u91c0\u9ce5\u8526\u88ca\u8076\u5699\u9477\u93b3\u9689\u8617\u56c1\u9862\u8ea1\u6ab8\u7370\u5be7\u64f0\u6fd8\u82e7\u5680\u8079\u9215\u7d10\u81bf\u6fc3\u8fb2\u5102\u5665\u99d1\u91f9\u8afe\u513a\u7627\u6b50\u9dd7\u6bc6\u5614\u6f1a\u8b33\u616a\u750c\u76e4\u8e63\u9f90\u62cb\u76b0\u8ce0\u8f61\u5674\u9d6c\u7d15\u7f86\u9239\u9a19\u8ade\u99e2\u98c4\u7e39\u983b\u8ca7\u5b2a\u860b\u6191\u8a55\u6f51\u9817\u91d9\u64b2\u92ea\u6a38\u8b5c\u93f7\u9420\u68f2\u81cd\u9f4a\u9a0e\u8c48\u555f\u6c23\u68c4\u8a16\u8604\u9a0f\u7dba\u69bf\u78e7\u980e\u980f\u9c2d\u727d\u91ec\u925b\u9077\u7c3d\u8b19\u9322\u9257\u6f5b\u6dfa\u8b74\u5879\u50c9\u8541\u6173\u9a2b\u7e7e\u69e7\u9210\u69cd\u55c6\u58bb\u8594\u5f37\u6436\u5b19\u6aa3\u6227\u7197\u9306\u93d8\u93f9\u7fa5\u8e4c\u936c\u6a4b\u55ac\u50d1\u7ff9\u7ac5\u8a9a\u8b59\u854e\u7e70\u78fd\u8e7a\u7aca\u611c\u9365\u7bcb\u6b3d\u89aa\u5be2\u92df\u8f15\u6c2b\u50be\u9803\u8acb\u6176\u64b3\u9bd6\u74ca\u7aae\u7162\u86fa\u5df0\u8cd5\u87e3\u9c0d\u8da8\u5340\u8ec0\u9a45\u9f72\u8a58\u5d87\u95c3\u89b7\u9d1d\u9874\u6b0a\u52f8\u8a6e\u7da3\u8f07\u9293\u537b\u9d72\u78ba\u95cb\u95d5\u6128\u8b93\u9952\u64fe\u7e5e\u8558\u5b08\u6a48\u71b1\u97cc\u8a8d\u7d09\u98ea\u8ed4\u69ae\u7d68\u5db8\u8811\u7e1f\u92a3\u9870\u8edf\u92b3\u8706\u958f\u6f64\u7051\u85a9\u98af\u9c13\u8cfd\u5098\u6bff\u7cdd\u55aa\u9a37\u6383\u7e45\u6f80\u55c7\u92ab\u7a61\u6bba\u524e\u7d17\u93a9\u9bca\u7be9\u66ec\u91c3\u522a\u9583\u965c\u8d0d\u7e55\u8a15\u59cd\u9a38\u91e4\u9c54\u5891\u50b7\u8cde\u5770\u6ba4\u89f4\u71d2\u7d39\u8cd2\u651d\u61fe\u8a2d\u5399\u7044\u756c\u7d33\u5be9\u5b38\u814e\u6ef2\u8a75\u8ad7\u700b\u8072\u7e69\u52dd\u5e2b\u7345\u6fd5\u8a69\u6642\u8755\u5be6\u8b58\u99db\u52e2\u9069\u91cb\u98fe\u8996\u8a66\u8b1a\u5852\u8494\u5f12\u8efe\u8cb0\u9230\u9c23\u58fd\u7378\u7dac\u6a1e\u8f38\u66f8\u8d16\u5c6c\u8853\u6a39\u8c4e\u6578\u6504\u7d13\u5e25\u9582\u96d9\u8ab0\u7a05\u9806\u8aaa\u78a9\u720d\u9460\u7d72\u98fc\u5edd\u99df\u7de6\u9376\u9de5\u8073\u616b\u980c\u8a1f\u8aa6\u64fb\u85ea\u993f\u98bc\u93aa\u8607\u8a34\u8085\u8b16\u7a4c\u96d6\u96a8\u7d8f\u6b72\u8ab6\u5b6b\u640d\u7b4d\u84c0\u733b\u7e2e\u7463\u9396\u55e9\u8127\u737a\u64bb\u95e5\u9248\u9c28\u81fa\u614b\u9226\u9b90\u6524\u8caa\u7671\u7058\u58c7\u8b5a\u8ac7\u5606\u66c7\u926d\u931f\u9807\u6e6f\u71d9\u513b\u9933\u940b\u93dc\u6fe4\u7d73\u8a0e\u97dc\u92f1\u9a30\u8b04\u92bb\u984c\u9ad4\u5c5c\u7df9\u9d5c\u95d0\u689d\u7cf6\u9f60\u9c37\u8cbc\u9435\u5ef3\u807d\u70f4\u9285\u7d71\u615f\u982d\u9204\u79bf\u5716\u91f7\u5718\u6476\u9839\u86fb\u98e9\u812b\u9d15\u99b1\u99dd\u6a62\u7c5c\u9f09\u896a\u5aa7\u8183\u5f4e\u7063\u9811\u842c\u7d08\u7db0\u7db2\u8f1e\u97cb\u9055\u570d\u70ba\u6ff0\u7dad\u8466\u5049\u507d\u7def\u8b02\u885b\u8ac9\u5e43\u95c8\u6e88\u6f7f\u744b\u97d9\u7152\u9baa\u6eab\u805e\u7d0b\u7a69\u554f\u95bf\u7515\u64be\u8778\u6e26\u7aa9\u81e5\u8435\u9f77\u55da\u93a2\u70cf\u8aa3\u7121\u856a\u5433\u5862\u9727\u52d9\u8aa4\u9114\u5ee1\u61ae\u5af5\u9a16\u9d61\u9da9\u932b\u72a7\u8972\u7fd2\u9291\u6232\u7d30\u993c\u9b29\u74bd\u89a1\u8766\u8f44\u5cfd\u4fe0\u72f9\u5ec8\u5687\u7864\u9bae\u7e96\u8ce2\u929c\u9591\u986f\u96aa\u73fe\u737b\u7e23\u9921\u7fa8\u61b2\u7dda\u83a7\u859f\u861a\u5cf4\u736b\u5afb\u9df4\u7647\u8814\u79c8\u8e9a\u5ec2\u9472\u9109\u8a73\u97ff\u9805\u858c\u9909\u9a64\u7dd7\u9957\u856d\u56c2\u92b7\u66c9\u562f\u5635\u701f\u9a4d\u7d83\u689f\u7c2b\u5354\u633e\u651c\u8105\u8ae7\u5beb\u7009\u8b1d\u893b\u64f7\u7d32\u7e88\u92c5\u91c1\u8208\u9658\u6ece\u5147\u6d36\u92b9\u7e61\u9948\u9d42\u865b\u5653\u9808\u8a31\u6558\u7dd2\u7e8c\u8a61\u980a\u8ed2\u61f8\u9078\u766c\u7d62\u8afc\u9249\u93c7\u5b78\u8b14\u6fa9\u9c48\u52db\u8a62\u5c0b\u99b4\u8a13\u8a0a\u905c\u5864\u6f6f\u9c58\u58d3\u9d09\u9d28\u555e\u4e9e\u8a1d\u57e1\u5a6d\u690f\u6c2c\u95b9\u7159\u9e7d\u56b4\u5dd6\u984f\u95bb\u8277\u53ad\u786f\u5f65\u8afa\u9a57\u53b4\u8d17\u513c\u5157\u8b9e\u61e8\u9586\u91c5\u9b58\u995c\u9f34\u9d26\u694a\u63da\u760d\u967d\u7662\u990a\u6a23\u716c\u7464\u6416\u582f\u9059\u7aaf\u8b20\u85e5\u8efa\u9dc2\u9c29\u723a\u9801\u696d\u8449\u9768\u8b01\u9134\u66c4\u71c1\u91ab\u92a5\u9824\u907a\u5100\u87fb\u85dd\u5104\u61b6\u7fa9\u8a63\u8b70\u8abc\u8b6f\u7570\u7e79\u8a52\u56c8\u5da7\u98f4\u61cc\u9a5b\u7e0a\u8efc\u8cbd\u91d4\u93b0\u943f\u761e\u8264\u852d\u9670\u9280\u98f2\u96b1\u92a6\u766e\u6afb\u5b30\u9df9\u61c9\u7e93\u7469\u87a2\u71df\u7192\u8805\u8d0f\u7a4e\u584b\u9daf\u7e08\u93a3\u6516\u56b6\u7005\u7020\u74d4\u9e1a\u766d\u9826\u7f4c\u55b2\u64c1\u50ad\u7670\u8e34\u8a60\u93de\u512a\u6182\u90f5\u923e\u7336\u8a98\u8555\u92aa\u9b77\u8f3f\u9b5a\u6f01\u5a1b\u8207\u5dbc\u8a9e\u7344\u8b7d\u9810\u99ad\u50b4\u4fc1\u8adb\u8aed\u8577\u5d33\u98eb\u95be\u5ad7\u7d06\u89a6\u6b5f\u923a\u9d52\u9df8\u9f6c\u9d1b\u6df5\u8f45\u5712\u54e1\u5713\u7de3\u9060\u6ade\u9cf6\u9eff\u7d04\u8e8d\u9470\u7cb5\u6085\u95b1\u925e\u9116\u52fb\u9695\u904b\u860a\u919e\u6688\u97fb\u9106\u8553\u60f2\u614d\u7d1c\u97de\u6b9e\u6c33\u96dc\u707d\u8f09\u6522\u66ab\u8d0a\u74da\u8db2\u93e8\u8d13\u81df\u99d4\u947f\u68d7\u8cac\u64c7\u5247\u6fa4\u8cfe\u5616\u5e58\u7c00\u8cca\u8b56\u8d08\u7d9c\u7e52\u8ecb\u9358\u9598\u67f5\u8a50\u9f4b\u50b5\u6c08\u76de\u65ac\u8f3e\u5d84\u68e7\u6230\u7dbb\u8b6b\u5f35\u6f32\u5e33\u8cec\u8139\u8d99\u8a54\u91d7\u87c4\u8f4d\u937a\u9019\u8b2b\u8f12\u9dd3\u8c9e\u91dd\u5075\u8a3a\u93ae\u9663\u6e5e\u7e1d\u6968\u8eeb\u8cd1\u798e\u9d06\u6399\u775c\u7319\u722d\u5e40\u7665\u912d\u8b49\u8acd\u5d22\u9266\u931a\u7b8f\u7e54\u8077\u57f7\u7d19\u646f\u64f2\u5e5f\u8cea\u6eef\u9a2d\u6adb\u6894\u8ef9\u8f0a\u8d04\u9dd9\u8784\u7e36\u8e93\u8e91\u89f6\u9418\u7d42\u7a2e\u816b\u773e\u937e\u8b05\u8ef8\u76ba\u665d\u9a5f\u7d02\u7e10\u8c6c\u8af8\u8a85\u71ed\u77da\u56d1\u8caf\u9444\u99d0\u4f47\u6ae7\u9296\u5c08\u78da\u8f49\u8cfa\u56c0\u994c\u9873\u6a01\u838a\u88dd\u599d\u58ef\u72c0\u9310\u8d05\u589c\u7db4\u9a05\u7e0b\u8ac4\u6e96\u8457\u6fc1\u8ad1\u9432\u8332\u8cc7\u6f2c\u8aee\u7dc7\u8f1c\u8cb2\u7725\u9319\u9f5c\u9bd4\u8e64\u7e3d\u7e31\u50af\u9112\u8acf\u9a36\u9beb\u8a5b\u7d44\u93c3\u9246\u7e98\u8ea6\u9c52\u7ffa\u4e26\u8514\u6c88\u919c\u6fb1\u53e0\u9b25\u7bc4\u5e79\u81ef\u77fd\u6ac3\u5f8c\u5925\u7a2d\u5091\u8a23\u8a87\u88cf\u6de9\u9ebc\u9ef4\u649a\u6dd2\u6261\u8056\u5c4d\u64e1\u5857\u7aaa\u9935\u6c59\u9341\u9e79\u880d\u5f5c\u6e67\u904a\u7c72\u79a6\u9858\u5dbd\u96f2\u7ac8\u7d2e\u5284\u7bc9\u65bc\u8a8c\u8a3b\u96d5\u8a01\u8b7e\u90e4\u731b\u6c39\u962a\u58df\u5816\u57b5\u588a\u6abe\u8552\u8464\u84e7\u8493\u83c7\u69c1\u6463\u54a4\u551a\u54e2\u565d\u5645\u6485\u5288\u8b14\u8946\u5db4\u810a\u4eff\u50e5\u7341\u9e85\u9918\u9937\u994a\u9962\u695e\u6035\u61cd\u723f\u6f35\u7069\u6df7\u6feb\u7026\u6de1\u5be7\u7cf8\u7d5d\u7dd4\u7449\u6898\u68ec\u6848\u6a70\u6aeb\u8ef2\u8ee4\u8ceb\u8181\u8156\u98c8\u7cca\u7146\u6e9c\u6e63\u6e3a\u78b8\u6efe\u7798\u9208\u9255\u92e3\u92b1\u92e5\u92f6\u9426\u9427\u9369\u9340\u9343\u9307\u9384\u9387\u93bf\u941d\u9465\u9479\u9454\u7a6d\u9d93\u9da5\u9e0c\u7667\u5c59\u7602\u81d2\u8947\u7e48\u802e\u986c\u87ce\u9eaf\u9b81\u9b83\u9b8e\u9bd7\u9bdd\u9bf4\u9c5d\u9bff\u9c20\u9c35\u9c45\u97bd\u97dd\u9f47"

def convert_chinese(text, from_charset, to_charset):
    output_text = ''
    for ch in text:
        idx = from_charset.find(ch)
        output_text += ch if idx < 0 else to_charset[idx]
    return output_text

simplify = partial(convert_chinese, from_charset=big5, to_charset=gbk)
tradify = partial(convert_chinese, from_charset=gbk, to_charset=big5)
