import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SnowflakeProviderConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#account SnowflakeProvider#account}
    */
    readonly account: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#browser_auth SnowflakeProvider#browser_auth}
    */
    readonly browserAuth?: boolean | cdktf.IResolvable;
    /**
    * Supports passing in a custom host value to the snowflake go driver for use with privatelink
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#host SnowflakeProvider#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_access_token SnowflakeProvider#oauth_access_token}
    */
    readonly oauthAccessToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_client_id SnowflakeProvider#oauth_client_id}
    */
    readonly oauthClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_client_secret SnowflakeProvider#oauth_client_secret}
    */
    readonly oauthClientSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_endpoint SnowflakeProvider#oauth_endpoint}
    */
    readonly oauthEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_redirect_url SnowflakeProvider#oauth_redirect_url}
    */
    readonly oauthRedirectUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_refresh_token SnowflakeProvider#oauth_refresh_token}
    */
    readonly oauthRefreshToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#password SnowflakeProvider#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#private_key SnowflakeProvider#private_key}
    */
    readonly privateKey?: string;
    /**
    * Supports the encryption ciphers aes-128-cbc, aes-128-gcm, aes-192-cbc, aes-192-gcm, aes-256-cbc, aes-256-gcm, and des-ede3-cbc
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#private_key_passphrase SnowflakeProvider#private_key_passphrase}
    */
    readonly privateKeyPassphrase?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#private_key_path SnowflakeProvider#private_key_path}
    */
    readonly privateKeyPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#region SnowflakeProvider#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#role SnowflakeProvider#role}
    */
    readonly role?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#username SnowflakeProvider#username}
    */
    readonly username: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#alias SnowflakeProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake snowflake}
*/
export declare class SnowflakeProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "snowflake";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake snowflake} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SnowflakeProviderConfig
    */
    constructor(scope: Construct, id: string, config: SnowflakeProviderConfig);
    private _account?;
    get account(): string | undefined;
    set account(value: string | undefined);
    get accountInput(): string | undefined;
    private _browserAuth?;
    get browserAuth(): boolean | cdktf.IResolvable | undefined;
    set browserAuth(value: boolean | cdktf.IResolvable | undefined);
    resetBrowserAuth(): void;
    get browserAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _host?;
    get host(): string | undefined;
    set host(value: string | undefined);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _oauthAccessToken?;
    get oauthAccessToken(): string | undefined;
    set oauthAccessToken(value: string | undefined);
    resetOauthAccessToken(): void;
    get oauthAccessTokenInput(): string | undefined;
    private _oauthClientId?;
    get oauthClientId(): string | undefined;
    set oauthClientId(value: string | undefined);
    resetOauthClientId(): void;
    get oauthClientIdInput(): string | undefined;
    private _oauthClientSecret?;
    get oauthClientSecret(): string | undefined;
    set oauthClientSecret(value: string | undefined);
    resetOauthClientSecret(): void;
    get oauthClientSecretInput(): string | undefined;
    private _oauthEndpoint?;
    get oauthEndpoint(): string | undefined;
    set oauthEndpoint(value: string | undefined);
    resetOauthEndpoint(): void;
    get oauthEndpointInput(): string | undefined;
    private _oauthRedirectUrl?;
    get oauthRedirectUrl(): string | undefined;
    set oauthRedirectUrl(value: string | undefined);
    resetOauthRedirectUrl(): void;
    get oauthRedirectUrlInput(): string | undefined;
    private _oauthRefreshToken?;
    get oauthRefreshToken(): string | undefined;
    set oauthRefreshToken(value: string | undefined);
    resetOauthRefreshToken(): void;
    get oauthRefreshTokenInput(): string | undefined;
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string | undefined;
    set privateKey(value: string | undefined);
    resetPrivateKey(): void;
    get privateKeyInput(): string | undefined;
    private _privateKeyPassphrase?;
    get privateKeyPassphrase(): string | undefined;
    set privateKeyPassphrase(value: string | undefined);
    resetPrivateKeyPassphrase(): void;
    get privateKeyPassphraseInput(): string | undefined;
    private _privateKeyPath?;
    get privateKeyPath(): string | undefined;
    set privateKeyPath(value: string | undefined);
    resetPrivateKeyPath(): void;
    get privateKeyPathInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _role?;
    get role(): string | undefined;
    set role(value: string | undefined);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _username?;
    get username(): string | undefined;
    set username(value: string | undefined);
    get usernameInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
