"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkConstructLibrary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const projen_1 = require("projen");
/**
 * @stability stable
 */
class AwsCdkConstructLibrary extends projen_1.awscdk.AwsCdkConstructLibrary {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e;
        super({
            ...options,
            authorOrganization: true,
            license: "MIT",
            copyrightOwner: "Pepperize UG (haftungsbeschränkt)",
            autoApproveUpgrades: true,
            autoApproveOptions: {
                ...options.autoApproveOptions,
                allowedUsernames: ["unerty", "pflorek", "acfo", "dependabot[bot]"],
                label: "auto-approve",
                secret: "GITHUB_TOKEN",
            },
            depsUpgradeOptions: {
                ...options.depsUpgradeOptions,
                workflowOptions: {
                    ...(_b = options.depsUpgradeOptions) === null || _b === void 0 ? void 0 : _b.workflowOptions,
                    secret: "PROJEN_GITHUB_TOKEN",
                },
            },
            dependabot: true,
            dependabotOptions: {
                labels: ["auto-approve"],
            },
            eslint: true,
            prettier: true,
            prettierOptions: {
                ...options.prettierOptions,
                settings: {
                    ...(_c = options.prettierOptions) === null || _c === void 0 ? void 0 : _c.settings,
                    printWidth: 120,
                },
            },
            defaultReleaseBranch: "main",
            npmAccess: projen_1.javascript.NpmAccess.PUBLIC,
            release: true,
            gitignore: [...(options.gitignore || [])],
        });
        this.gitignore.exclude(".idea/", "*.iml");
        (_d = this.prettier) === null || _d === void 0 ? void 0 : _d.addIgnorePattern("API.md");
        this.formatTask = this.addTask("format", {
            description: "Format with prettier",
            exec: "prettier --write src/{**/,}*.ts test/{**/,}*.ts .projenrc.js README.md",
        });
        (_e = this.jest) === null || _e === void 0 ? void 0 : _e.addTestMatch("<rootDir>/**/?(*.)@(spec|test).[tj]s?(x)");
    }
}
exports.AwsCdkConstructLibrary = AwsCdkConstructLibrary;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkConstructLibrary[_a] = { fqn: "@pepperize/projen-awscdk-construct.AwsCdkConstructLibrary", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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