# -*- coding: utf-8 -*-

from ..enums import IntEnum

__all__ = ("EMsg",)


# fmt: off

class EMsg(IntEnum):
    Invalid                                                  = 0
    Multi                                                    = 1
    ProtobufWrapped                                          = 2

    GenericReply                                             = 100
    BaseGeneral                                              = 100
    DestJobFailed                                            = 113
    Alert                                                    = 115
    SCIDRequest                                              = 120
    SCIDResponse                                             = 121
    JobHeartbeat                                             = 123
    HubConnect                                               = 124
    Subscribe                                                = 126
    RouteMessage                                             = 127
    WGRequest                                                = 130
    WGResponse                                               = 131
    KeepAlive                                                = 132
    WebAPIJobRequest                                         = 133
    WebAPIJobResponse                                        = 134
    ClientSessionStart                                       = 135
    ClientSessionEnd                                         = 136
    ClientSessionUpdate                                      = 137
    Ping                                                     = 139
    PingResponse                                             = 140
    Stats                                                    = 141
    RequestFullStatsBlock                                    = 142
    LoadDBOCacheItem                                         = 143
    LoadDBOCacheItemResponse                                 = 144
    InvalidateDBOCacheItems                                  = 145
    ServiceMethod                                            = 146
    ServiceMethodResponse                                    = 147
    ClientPackageVersions                                    = 148
    TimestampRequest                                         = 149
    TimestampResponse                                        = 150
    ServiceMethodCallFromClient                              = 151
    ServiceMethodSendToClient                                = 152

    AssignSysID                                              = 200
    BaseShell                                                = 200
    Exit                                                     = 201
    DirRequest                                               = 202
    DirResponse                                              = 203
    ZipRequest                                               = 204
    ZipResponse                                              = 205
    UpdateRecordResponse                                     = 215
    UpdateCreditCardRequest                                  = 221
    UpdateUserBanResponse                                    = 225
    PrepareToExit                                            = 226
    ContentDescriptionUpdate                                 = 227
    TestResetServer                                          = 228
    UniverseChanged                                          = 229
    ShellConfigInfoUpdate                                    = 230
    RequestWindowsEventLogEntries                            = 233
    ProvideWindowsEventLogEntries                            = 234
    ShellSearchLogs                                          = 235
    ShellSearchLogsResponse                                  = 236
    ShellCheckWindowsUpdates                                 = 237
    ShellCheckWindowsUpdatesResponse                         = 238
    TestFlushDelayedSQL                                      = 240
    TestFlushDelayedSQLResponse                              = 241
    ContentDescriptionDeltaUpdate                            = 246

    Heartbeat                                                = 300
    BaseGM                                                   = 300
    ShellFailed                                              = 301
    ExitShells                                               = 307
    ExitShell                                                = 308
    GracefulExitShell                                        = 309
    LicenseProcessingComplete                                = 316
    SetTestFlag                                              = 317
    QueuedEmailsComplete                                     = 318
    GMReportPHPError                                         = 319
    GMDRMSync                                                = 320
    PhysicalBoxInventory                                     = 321
    UpdateConfigFile                                         = 322
    TestInitDB                                               = 323
    GMWriteConfigToSQL                                       = 324
    GMLoadActivationCodes                                    = 325
    GMQueueForFBS                                            = 326
    GMSchemaConversionResults                                = 327
    GMWriteShellFailureToSQL                                 = 329
    GMWriteStatsToSOS                                        = 330
    GMGetServiceMethodRouting                                = 331
    GMGetServiceMethodRoutingResponse                        = 332

    GMTestNextBuildSchemaConversion                          = 334
    GMTestNextBuildSchemaConversionResponse                  = 335
    ExpectShellRestart                                       = 336
    HotFixProgress                                           = 337

    BaseAIS                                                  = 400
    AISRequestContentDescription                             = 402
    AISUpdateAppInfo                                         = 403
    AISGetPackageChangeNumber                                = 405
    AISGetPackageChangeNumberResponse                        = 406
    AIGetAppGCFlags                                          = 423
    AIGetAppGCFlagsResponse                                  = 424
    AIGetAppList                                             = 425
    AIGetAppListResponse                                     = 426
    AISGetCouponDefinition                                   = 429
    AISGetCouponDefinitionResponse                           = 430
    AISUpdateSlaveContentDescription                         = 431
    AISUpdateSlaveContentDescriptionResponse                 = 432
    AISTestEnableGC                                          = 433

    BaseAM                                                   = 500
    AMUpdateUserBanRequest                                   = 504
    AMAddLicense                                             = 505
    AMSendSystemIMToUser                                     = 508
    AMExtendLicense                                          = 509
    AMAddMinutesToLicense                                    = 510
    AMCancelLicense                                          = 511
    AMInitPurchase                                           = 512
    AMPurchaseResponse                                       = 513
    AMGetFinalPrice                                          = 514
    AMGetFinalPriceResponse                                  = 515
    AMGetLegacyGameKey                                       = 516
    AMGetLegacyGameKeyResponse                               = 517
    AMFindHungTransactions                                   = 518
    AMSetAccountTrustedRequest                               = 519
    AMCancelPurchase                                         = 522
    AMNewChallenge                                           = 523
    AMLoadOEMTickets                                         = 524
    AMFixPendingPurchase                                     = 525
    AMFixPendingPurchaseResponse                             = 526
    AMIsUserBanned                                           = 527
    AMRegisterKey                                            = 528
    AMLoadActivationCodes                                    = 529
    AMLoadActivationCodesResponse                            = 530
    AMLookupKeyResponse                                      = 531
    AMLookupKey                                              = 532
    AMChatCleanup                                            = 533
    AMClanCleanup                                            = 534
    AMFixPendingRefund                                       = 535
    AMReverseChargeback                                      = 536
    AMReverseChargebackResponse                              = 537
    AMClanCleanupList                                        = 538
    AMGetLicenses                                            = 539
    AMGetLicensesResponse                                    = 540
    AMSendCartRepurchase                                     = 541
    AMSendCartRepurchaseResponse                             = 542
    AllowUserToPlayQuery                                     = 550
    AllowUserToPlayResponse                                  = 551
    AMVerfiyUser                                             = 552
    AMClientNotPlaying                                       = 553
    AMClientRequestFriendship                                = 554
    AMRelayPublishStatus                                     = 555
    AMInitPurchaseResponse                                   = 560
    AMRevokePurchaseResponse                                 = 561
    AMRefreshGuestPasses                                     = 563
    AMGrantGuestPasses                                       = 566
    AMClanDataUpdated                                        = 567
    AMReloadAccount                                          = 568
    AMClientChatMsgRelay                                     = 569
    AMChatMulti                                              = 570
    AMClientChatInviteRelay                                  = 571
    AMChatInvite                                             = 572
    AMClientJoinChatRelay                                    = 573
    AMClientChatMemberInfoRelay                              = 574
    AMPublishChatMemberInfo                                  = 575
    AMClientAcceptFriendInvite                               = 576
    AMChatEnter                                              = 577
    AMClientPublishRemovalFromSource                         = 578
    AMChatActionResult                                       = 579
    AMFindAccounts                                           = 580
    AMFindAccountsResponse                                   = 581
    AMRequestAccountData                                     = 582
    AMRequestAccountDataResponse                             = 583
    AMSetAccountFlags                                        = 584
    AMCreateClan                                             = 586
    AMCreateClanResponse                                     = 587
    AMGetClanDetails                                         = 588
    AMGetClanDetailsResponse                                 = 589
    AMSetPersonaName                                         = 590
    AMSetAvatar                                              = 591
    AMAuthenticateUser                                       = 592
    AMAuthenticateUserResponse                               = 593
    AMP2PIntroducerMessage                                   = 596
    ClientChatAction                                         = 597
    AMClientChatActionRelay                                  = 598

    ReqChallenge                                             = 600
    BaseVS                                                   = 600
    VACResponse                                              = 601
    ReqChallengeTest                                         = 602
    VSMarkCheat                                              = 604
    VSAddCheat                                               = 605
    VSPurgeCodeModDB                                         = 606
    VSGetChallengeResults                                    = 607
    VSChallengeResultText                                    = 608
    VSReportLingerer                                         = 609
    VSRequestManagedChallenge                                = 610
    VSLoadDBFinished                                         = 611

    BaseDRMS                                                 = 625
    DRMBuildBlobRequest                                      = 628
    DRMBuildBlobResponse                                     = 629
    DRMResolveGuidRequest                                    = 630
    DRMResolveGuidResponse                                   = 631
    DRMVariabilityReport                                     = 633
    DRMVariabilityReportResponse                             = 634
    DRMStabilityReport                                       = 635
    DRMStabilityReportResponse                               = 636
    DRMDetailsReportRequest                                  = 637
    DRMDetailsReportResponse                                 = 638
    DRMProcessFile                                           = 639
    DRMAdminUpdate                                           = 640
    DRMAdminUpdateResponse                                   = 641
    DRMSync                                                  = 642
    DRMSyncResponse                                          = 643
    DRMProcessFileResponse                                   = 644
    DRMEmptyGuidCache                                        = 645
    DRMEmptyGuidCacheResponse                                = 646

    BaseCS                                                   = 650

    BaseClient                                               = 700
    ClientHeartBeat                                          = 703
    ClientVACResponse                                        = 704
    ClientLogOff                                             = 706
    ClientNoUDPConnectivity                                  = 707
    ClientConnectionStats                                    = 710
    ClientPingResponse                                       = 712
    ClientRemoveFriend                                       = 714
    ClientGamesPlayedNoDataBlob                              = 715
    ClientChangeStatus                                       = 716
    ClientVacStatusResponse                                  = 717
    ClientFriendMsg                                          = 718
    ClientSystemIM                                           = 726
    ClientSystemIMAck                                        = 727
    ClientGetLicenses                                        = 728
    ClientGetLegacyGameKey                                   = 730
    ClientAckVACBan2                                         = 732
    ClientGetPurchaseReceipts                                = 736
    ClientAckGuestPass                                       = 740
    ClientRedeemGuestPass                                    = 741
    ClientGamesPlayed                                        = 742
    ClientRegisterKey                                        = 743
    ClientInviteUserToClan                                   = 744
    ClientAcknowledgeClanInvite                              = 745
    ClientPurchaseWithMachineID                              = 746
    ClientAppUsageEvent                                      = 747
    ClientLogOnResponse                                      = 751
    ClientSetHeartbeatRate                                   = 755
    ClientLoggedOff                                          = 757
    GSApprove                                                = 758
    GSDeny                                                   = 759
    GSKick                                                   = 760
    ClientCreateAcctResponse                                 = 761
    ClientPurchaseResponse                                   = 763
    ClientPing                                               = 764
    ClientNOP                                                = 765
    ClientPersonaState                                       = 766
    ClientFriendsList                                        = 767
    ClientAccountInfo                                        = 768
    ClientNewsUpdate                                         = 771
    ClientGameConnectDeny                                    = 773
    GSStatusReply                                            = 774
    ClientGameConnectTokens                                  = 779
    ClientLicenseList                                        = 780
    ClientVACBanStatus                                       = 782
    ClientCMList                                             = 783
    ClientEncryptPct                                         = 784
    ClientGetLegacyGameKeyResponse                           = 785
    ClientAddFriend                                          = 791
    ClientAddFriendResponse                                  = 792
    ClientAckGuestPassResponse                               = 796
    ClientRedeemGuestPassResponse                            = 797
    ClientUpdateGuestPassesList                              = 798
    ClientChatMsg                                            = 799
    ClientChatInvite                                         = 800
    ClientJoinChat                                           = 801
    ClientChatMemberInfo                                     = 802
    ClientPasswordChangeResponse                             = 805
    ClientChatEnter                                          = 807
    ClientFriendRemovedFromSource                            = 808
    ClientCreateChat                                         = 809
    ClientCreateChatResponse                                 = 810
    ClientP2PIntroducerMessage                               = 813
    ClientChatActionResult                                   = 814
    ClientRequestFriendData                                  = 815
    ClientGetUserStats                                       = 818
    ClientGetUserStatsResponse                               = 819
    ClientStoreUserStats                                     = 820
    ClientStoreUserStatsResponse                             = 821
    ClientClanState                                          = 822
    ClientServiceModule                                      = 830
    ClientServiceCall                                        = 831
    ClientServiceCallResponse                                = 832
    ClientNatTraversalStatEvent                              = 839
    ClientSteamUsageEvent                                    = 842
    ClientCheckPassword                                      = 845
    ClientResetPassword                                      = 846
    ClientCheckPasswordResponse                              = 848
    ClientResetPasswordResponse                              = 849
    ClientSessionToken                                       = 850
    ClientDRMProblemReport                                   = 851
    ClientSetIgnoreFriend                                    = 855
    ClientSetIgnoreFriendResponse                            = 856
    ClientGetAppOwnershipTicket                              = 857
    ClientGetAppOwnershipTicketResponse                      = 858
    ClientGetLobbyListResponse                               = 860
    ClientServerList                                         = 880
    ClientDRMBlobRequest                                     = 896
    ClientDRMBlobResponse                                    = 897

    BaseGameServer                                           = 900
    GSDisconnectNotice                                       = 901
    GSStatus                                                 = 903
    GSUserPlaying                                            = 905
    GSStatus2                                                = 906
    GSServerType                                             = 908
    GSPlayerList                                             = 909
    GSGetUserAchievementStatus                               = 910
    GSGetUserAchievementStatusResponse                       = 911
    GSGetPlayStats                                           = 918
    GSGetPlayStatsResponse                                   = 919
    GSGetUserGroupStatus                                     = 920
    AMGetUserGroupStatus                                     = 921
    AMGetUserGroupStatusResponse                             = 922
    GSGetUserGroupStatusResponse                             = 923
    GSGetReputation                                          = 936
    GSGetReputationResponse                                  = 937
    GSAssociateWithClan                                      = 938
    GSAssociateWithClanResponse                              = 939
    GSComputeNewPlayerCompatibility                          = 940
    GSComputeNewPlayerCompatibilityResponse                  = 941

    AdminCmd                                                 = 1000
    BaseAdmin                                                = 1000
    AdminCmdResponse                                         = 1004
    AdminLogListenRequest                                    = 1005
    AdminLogEvent                                            = 1006
    UniverseData                                             = 1010
    AdminSpew                                                = 1019
    AdminConsoleTitle                                        = 1020
    AdminGCSpew                                              = 1023
    AdminGCCommand                                           = 1024
    AdminGCGetCommandList                                    = 1025
    AdminGCGetCommandListResponse                            = 1026
    FBSConnectionData                                        = 1027
    AdminMsgSpew                                             = 1028

    FBSReqVersion                                            = 1100
    BaseFBS                                                  = 1100
    FBSVersionInfo                                           = 1101
    FBSForceRefresh                                          = 1102
    FBSForceBounce                                           = 1103
    FBSDeployPackage                                         = 1104
    FBSDeployResponse                                        = 1105
    FBSUpdateBootstrapper                                    = 1106
    FBSSetState                                              = 1107
    FBSApplyOSUpdates                                        = 1108
    FBSRunCMDScript                                          = 1109
    FBSRebootBox                                             = 1110
    FBSSetBigBrotherMode                                     = 1111
    FBSMinidumpServer                                        = 1112
    FBSDeployHotFixPackage                                   = 1114
    FBSDeployHotFixResponse                                  = 1115
    FBSDownloadHotFix                                        = 1116
    FBSDownloadHotFixResponse                                = 1117
    FBSUpdateTargetConfigFile                                = 1118
    FBSApplyAccountCred                                      = 1119
    FBSApplyAccountCredResponse                              = 1120
    FBSSetShellCount                                         = 1121
    FBSTerminateShell                                        = 1122
    FBSQueryGMForRequest                                     = 1123
    FBSQueryGMResponse                                       = 1124
    FBSTerminateZombies                                      = 1125
    FBSInfoFromBootstrapper                                  = 1126
    FBSRebootBoxResponse                                     = 1127
    FBSBootstrapperPackageRequest                            = 1128
    FBSBootstrapperPackageResponse                           = 1129
    FBSBootstrapperGetPackageChunk                           = 1130
    FBSBootstrapperGetPackageChunkResponse                   = 1131
    FBSBootstrapperPackageTransferProgress                   = 1132
    FBSRestartBootstrapper                                   = 1133
    FBSPauseFrozenDumps                                      = 1134

    FileXferRequest                                          = 1200
    BaseFileXfer                                             = 1200
    FileXferResponse                                         = 1201
    FileXferData                                             = 1202
    FileXferEnd                                              = 1203
    FileXferDataAck                                          = 1204

    ChannelAuthChallenge                                     = 1300
    BaseChannelAuth                                          = 1300
    ChannelAuthResponse                                      = 1301
    ChannelAuthResult                                        = 1302
    ChannelEncryptRequest                                    = 1303
    ChannelEncryptResponse                                   = 1304
    ChannelEncryptResult                                     = 1305

    BaseBS                                                   = 1400
    BSPurchaseStart                                          = 1401
    BSPurchaseResponse                                       = 1402
    BSAuthenticateCCTrans                                    = 1403
    BSAuthenticateCCTransResponse                            = 1404
    BSSettleComplete                                         = 1406
    BSInitPayPalTxn                                          = 1408
    BSInitPayPalTxnResponse                                  = 1409
    BSGetPayPalUserInfo                                      = 1410
    BSGetPayPalUserInfoResponse                              = 1411
    BSPaymentInstrBan                                        = 1417
    BSPaymentInstrBanResponse                                = 1418
    BSInitGCBankXferTxn                                      = 1421
    BSInitGCBankXferTxnResponse                              = 1422
    BSCommitGCTxn                                            = 1425
    BSQueryTransactionStatus                                 = 1426
    BSQueryTransactionStatusResponse                         = 1427
    BSQueryPaymentInstUsage                                  = 1431
    BSQueryPaymentInstResponse                               = 1432
    BSQueryTxnExtendedInfo                                   = 1433
    BSQueryTxnExtendedInfoResponse                           = 1434
    BSUpdateConversionRates                                  = 1435
    BSPurchaseRunFraudChecks                                 = 1437
    BSPurchaseRunFraudChecksResponse                         = 1438
    BSQueryBankInformation                                   = 1440
    BSQueryBankInformationResponse                           = 1441
    BSValidateXsollaSignature                                = 1445
    BSValidateXsollaSignatureResponse                        = 1446
    BSQiwiWalletInvoice                                      = 1448
    BSQiwiWalletInvoiceResponse                              = 1449
    BSUpdateInventoryFromProPack                             = 1450
    BSUpdateInventoryFromProPackResponse                     = 1451
    BSSendShippingRequest                                    = 1452
    BSSendShippingRequestResponse                            = 1453
    BSGetProPackOrderStatus                                  = 1454
    BSGetProPackOrderStatusResponse                          = 1455
    BSCheckJobRunning                                        = 1456
    BSCheckJobRunningResponse                                = 1457
    BSResetPackagePurchaseRateLimit                          = 1458
    BSResetPackagePurchaseRateLimitResponse                  = 1459
    BSUpdatePaymentData                                      = 1460
    BSUpdatePaymentDataResponse                              = 1461
    BSGetBillingAddress                                      = 1462
    BSGetBillingAddressResponse                              = 1463
    BSGetCreditCardInfo                                      = 1464
    BSGetCreditCardInfoResponse                              = 1465
    BSRemoveExpiredPaymentData                               = 1468
    BSRemoveExpiredPaymentDataResponse                       = 1469
    BSConvertToCurrentKeys                                   = 1470
    BSConvertToCurrentKeysResponse                           = 1471
    BSInitPurchase                                           = 1472
    BSInitPurchaseResponse                                   = 1473
    BSCompletePurchase                                       = 1474
    BSCompletePurchaseResponse                               = 1475
    BSPruneCardUsageStats                                    = 1476
    BSPruneCardUsageStatsResponse                            = 1477
    BSStoreBankInformation                                   = 1478
    BSStoreBankInformationResponse                           = 1479
    BSVerifyPOSAKey                                          = 1480
    BSVerifyPOSAKeyResponse                                  = 1481
    BSReverseRedeemPOSAKey                                   = 1482
    BSReverseRedeemPOSAKeyResponse                           = 1483
    BSQueryFindCreditCard                                    = 1484
    BSQueryFindCreditCardResponse                            = 1485
    BSStatusInquiryPOSAKey                                   = 1486
    BSStatusInquiryPOSAKeyResponse                           = 1487
    BSBoaCompraConfirmProductDelivery                        = 1494
    BSBoaCompraConfirmProductDeliveryResponse                = 1495
    BSGenerateBoaCompraMD5                                   = 1496
    BSGenerateBoaCompraMD5Response                           = 1497
    BSCommitWPTxn                                            = 1498
    BSCommitAdyenTxn                                         = 1499
    BaseATS                                                  = 1500
    ATSStartStressTest                                       = 1501
    ATSStopStressTest                                        = 1502
    ATSRunFailServerTest                                     = 1503
    ATSUFSPerfTestTask                                       = 1504
    ATSUFSPerfTestResponse                                   = 1505
    ATSCycleTCM                                              = 1506
    ATSInitDRMSStressTest                                    = 1507
    ATSCallTest                                              = 1508
    ATSCallTestReply                                         = 1509
    ATSStartExternalStress                                   = 1510
    ATSExternalStressJobStart                                = 1511
    ATSExternalStressJobQueued                               = 1512
    ATSExternalStressJobRunning                              = 1513
    ATSExternalStressJobStopped                              = 1514
    ATSExternalStressJobStopAll                              = 1515
    ATSExternalStressActionResult                            = 1516
    ATSStarted                                               = 1517
    ATSCSPerfTestTask                                        = 1518
    ATSCSPerfTestResponse                                    = 1519

    BaseDP                                                   = 1600
    DPSetPublishingState                                     = 1601
    DPUniquePlayersStat                                      = 1603
    DPStreamingUniquePlayersStat                             = 1604
    DPBlockingStats                                          = 1607
    DPNatTraversalStats                                      = 1608
    DPCloudStats                                             = 1612
    DPAchievementStats                                       = 1613
    DPGetPlayerCount                                         = 1615
    DPGetPlayerCountResponse                                 = 1616
    DPGameServersPlayersStats                                = 1617
    ClientDPCheckSpecialSurvey                               = 1620
    ClientDPCheckSpecialSurveyResponse                       = 1621
    ClientDPSendSpecialSurveyResponse                        = 1622
    ClientDPSendSpecialSurveyResponseReply                   = 1623
    DPStoreSaleStatistics                                    = 1624
    ClientDPUpdateAppJobReport                               = 1625
    DPUpdateContentEvent                                     = 1626
    ClientDPUnsignedInstallScript                            = 1627
    DPPartnerMicroTxns                                       = 1628
    DPPartnerMicroTxnsResponse                               = 1629
    ClientDPContentStatsReport                               = 1630
    DPVRUniquePlayersStat                                    = 1631

    BaseCM                                                   = 1700
    CMSetAllowState                                          = 1701
    CMSpewAllowState                                         = 1702
    CMSessionRejected                                        = 1703
    CMSetSecrets                                             = 1704
    CMGetSecrets                                             = 1705

    BaseGC                                                   = 2200
    GCCmdRevive                                              = 2203
    GCCmdDown                                                = 2206
    GCCmdDeploy                                              = 2207
    GCCmdDeployResponse                                      = 2208
    GCCmdSwitch                                              = 2209
    AMRefreshSessions                                        = 2210
    GCAchievementAwarded                                     = 2212
    GCSystemMessage                                          = 2213
    GCCmdStatus                                              = 2216
    GCInterAppMessage                                        = 2219
    GCGetEmailTemplate                                       = 2220
    GCGetEmailTemplateResponse                               = 2221
    GCHRelay                                                 = 2222
    GCHRelayToClient                                         = 2223
    GCHUpdateSession                                         = 2224
    GCHRequestUpdateSession                                  = 2225
    GCHRequestStatus                                         = 2226
    GCHRequestStatusResponse                                 = 2227
    GCHAccountVacStatusChange                                = 2228
    GCHSpawnGC                                               = 2229
    GCHSpawnGCResponse                                       = 2230
    GCHKillGC                                                = 2231
    GCHKillGCResponse                                        = 2232
    GCHAccountTradeBanStatusChange                           = 2233
    GCHAccountLockStatusChange                               = 2234
    GCHVacVerificationChange                                 = 2235
    GCHAccountPhoneNumberChange                              = 2236
    GCHAccountTwoFactorChange                                = 2237
    GCHInviteUserToLobby                                     = 2238

    BaseP2P                                                  = 2500
    P2PIntroducerMessage                                     = 2502

    BaseSM                                                   = 2900
    SMExpensiveReport                                        = 2902
    SMHourlyReport                                           = 2903
    SMPartitionRenames                                       = 2905
    SMMonitorSpace                                           = 2906
    SMTestNextBuildSchemaConversion                          = 2907
    SMTestNextBuildSchemaConversionResponse                  = 2908

    BaseTest                                                 = 3000
    FailServer                                               = 3000
    JobHeartbeatTest                                         = 3001
    JobHeartbeatTestResponse                                 = 3002

    BaseFTSRange                                             = 3100

    BaseCCSRange                                             = 3150
    CCSDeleteAllCommentsByAuthor                             = 3161
    CCSDeleteAllCommentsByAuthorResponse                     = 3162

    BaseLBSRange                                             = 3200
    LBSSetScore                                              = 3201
    LBSSetScoreResponse                                      = 3202
    LBSFindOrCreateLB                                        = 3203
    LBSFindOrCreateLBResponse                                = 3204
    LBSGetLBEntries                                          = 3205
    LBSGetLBEntriesResponse                                  = 3206
    LBSGetLBList                                             = 3207
    LBSGetLBListResponse                                     = 3208
    LBSSetLBDetails                                          = 3209
    LBSDeleteLB                                              = 3210
    LBSDeleteLBEntry                                         = 3211
    LBSResetLB                                               = 3212
    LBSResetLBResponse                                       = 3213
    LBSDeleteLBResponse                                      = 3214

    BaseOGS                                                  = 3400
    OGSBeginSession                                          = 3401
    OGSBeginSessionResponse                                  = 3402
    OGSEndSession                                            = 3403
    OGSEndSessionResponse                                    = 3404
    OGSWriteAppSessionRow                                    = 3406

    BaseBRP                                                  = 3600
    BRPStartShippingJobs                                     = 3601
    BRPProcessUSBankReports                                  = 3602
    BRPProcessGCReports                                      = 3603
    BRPProcessPPReports                                      = 3604
    BRPCommitGC                                              = 3607
    BRPCommitGCResponse                                      = 3608
    BRPFindHungTransactions                                  = 3609
    BRPCheckFinanceCloseOutDate                              = 3610
    BRPProcessLicenses                                       = 3611
    BRPProcessLicensesResponse                               = 3612
    BRPRemoveExpiredPaymentData                              = 3613
    BRPRemoveExpiredPaymentDataResponse                      = 3614
    BRPConvertToCurrentKeys                                  = 3615
    BRPConvertToCurrentKeysResponse                          = 3616
    BRPPruneCardUsageStats                                   = 3617
    BRPPruneCardUsageStatsResponse                           = 3618
    BRPCheckActivationCodes                                  = 3619
    BRPCheckActivationCodesResponse                          = 3620
    BRPCommitWP                                              = 3621
    BRPCommitWPResponse                                      = 3622
    BRPProcessWPReports                                      = 3623
    BRPProcessPaymentRules                                   = 3624
    BRPProcessPartnerPayments                                = 3625
    BRPCheckSettlementReports                                = 3626
    BRPPostTaxToAvalara                                      = 3628
    BRPPostTransactionTax                                    = 3629
    BRPPostTransactionTaxResponse                            = 3630
    BRPProcessIMReports                                      = 3631

    BaseAMRange2                                             = 4000
    AMCreateChat                                             = 4001
    AMCreateChatResponse                                     = 4002
    AMSetProfileURL                                          = 4005
    AMGetAccountEmailAddress                                 = 4006
    AMGetAccountEmailAddressResponse                         = 4007
    AMRequestClanData                                        = 4008
    AMRouteToClients                                         = 4009
    AMLeaveClan                                              = 4010
    AMClanPermissions                                        = 4011
    AMClanPermissionsResponse                                = 4012
    AMCreateClanEventDummyForRateLimiting                    = 4013
    AMUpdateClanEventDummyForRateLimiting                    = 4015
    AMCreateClanEventResponse                                = 4014
    AMUpdateClanEvent                                        = 4015
    AMUpdateClanEventResponse                                = 4016
    AMGetClanEvents                                          = 4017
    AMGetClanEventsResponse                                  = 4018
    AMDeleteClanEvent                                        = 4019
    AMDeleteClanEventResponse                                = 4020
    AMSetClanPermissionSettings                              = 4021
    AMSetClanPermissionSettingsResponse                      = 4022
    AMGetClanPermissionSettings                              = 4023
    AMGetClanPermissionSettingsResponse                      = 4024
    AMPublishChatRoomInfo                                    = 4025
    ClientChatRoomInfo                                       = 4026
    AMGetClanHistory                                         = 4039
    AMGetClanHistoryResponse                                 = 4040
    AMGetClanPermissionBits                                  = 4041
    AMGetClanPermissionBitsResponse                          = 4042
    AMSetClanPermissionBits                                  = 4043
    AMSetClanPermissionBitsResponse                          = 4044
    AMSessionInfoRequest                                     = 4045
    AMSessionInfoResponse                                    = 4046
    AMValidateWGToken                                        = 4047
    AMGetSingleClanEvent                                     = 4048
    AMGetSingleClanEventResponse                             = 4049
    AMGetClanRank                                            = 4050
    AMGetClanRankResponse                                    = 4051
    AMSetClanRank                                            = 4052
    AMSetClanRankResponse                                    = 4053
    AMGetClanPOTW                                            = 4054
    AMGetClanPOTWResponse                                    = 4055
    AMSetClanPOTW                                            = 4056
    AMSetClanPOTWResponse                                    = 4057
    AMDumpUser                                               = 4059
    AMKickUserFromClan                                       = 4060
    AMAddFounderToClan                                       = 4061
    AMValidateWGTokenResponse                                = 4062
    AMSetCommunityState                                      = 4063
    AMSetAccountDetails                                      = 4064
    AMGetChatBanList                                         = 4065
    AMGetChatBanListResponse                                 = 4066
    AMUnBanFromChat                                          = 4067
    AMSetClanDetails                                         = 4068
    AMGetAccountLinks                                        = 4069
    AMGetAccountLinksResponse                                = 4070
    AMSetAccountLinks                                        = 4071
    AMSetAccountLinksResponse                                = 4072
    UGSGetUserGameStats                                      = 4073
    UGSGetUserGameStatsResponse                              = 4074
    AMCheckClanMembership                                    = 4075
    AMGetClanMembers                                         = 4076
    AMGetClanMembersResponse                                 = 4077
    AMJoinPublicClan                                         = 4078
    AMNotifyChatOfClanChange                                 = 4079
    AMResubmitPurchase                                       = 4080
    AMAddFriend                                              = 4081
    AMAddFriendResponse                                      = 4082
    AMRemoveFriend                                           = 4083
    AMDumpClan                                               = 4084
    AMChangeClanOwner                                        = 4085
    AMCancelEasyCollect                                      = 4086
    AMCancelEasyCollectResponse                              = 4087
    AMClansInCommon                                          = 4090
    AMClansInCommonResponse                                  = 4091
    AMIsValidAccountID                                       = 4092
    AMConvertClan                                            = 4093
    AMWipeFriendsList                                        = 4095
    AMSetIgnored                                             = 4096
    AMClansInCommonCountResponse                             = 4097
    AMFriendsList                                            = 4098
    AMFriendsListResponse                                    = 4099
    AMFriendsInCommon                                        = 4100
    AMFriendsInCommonResponse                                = 4101
    AMFriendsInCommonCountResponse                           = 4102
    AMClansInCommonCount                                     = 4103
    AMChallengeVerdict                                       = 4104
    AMChallengeNotification                                  = 4105
    AMFindGSByIP                                             = 4106
    AMFoundGSByIP                                            = 4107
    AMGiftRevoked                                            = 4108
    AMCreateAccountRecord                                    = 4109
    AMUserClanList                                           = 4110
    AMUserClanListResponse                                   = 4111
    AMGetAccountDetails2                                     = 4112
    AMGetAccountDetailsResponse2                             = 4113
    AMSetCommunityProfileSettings                            = 4114
    AMSetCommunityProfileSettingsResponse                    = 4115
    AMGetCommunityPrivacyState                               = 4116
    AMGetCommunityPrivacyStateResponse                       = 4117
    AMCheckClanInviteRateLimiting                            = 4118
    UGSGetUserAchievementStatus                              = 4119
    AMGetIgnored                                             = 4120
    AMGetIgnoredResponse                                     = 4121
    AMSetIgnoredResponse                                     = 4122
    AMSetFriendRelationshipNone                              = 4123
    AMGetFriendRelationship                                  = 4124
    AMGetFriendRelationshipResponse                          = 4125
    AMServiceModulesCache                                    = 4126
    AMServiceModulesCall                                     = 4127
    AMServiceModulesCallResponse                             = 4128
    AMGetCaptchaDataForIP                                    = 4129
    AMGetCaptchaDataForIPResponse                            = 4130
    AMValidateCaptchaDataForIP                               = 4131
    AMValidateCaptchaDataForIPResponse                       = 4132
    AMTrackFailedAuthByIP                                    = 4133
    AMGetCaptchaDataByGID                                    = 4134
    AMGetCaptchaDataByGIDResponse                            = 4135
    CommunityAddFriendNews                                   = 4140
    AMFindClanUser                                           = 4143
    AMFindClanUserResponse                                   = 4144
    AMBanFromChat                                            = 4145
    AMGetUserNewsSubscriptions                               = 4147
    AMGetUserNewsSubscriptionsResponse                       = 4148
    AMSetUserNewsSubscriptions                               = 4149
    AMSendQueuedEmails                                       = 4152
    AMSetLicenseFlags                                        = 4153
    CommunityDeleteUserNews                                  = 4155
    AMAllowUserFilesRequest                                  = 4156
    AMAllowUserFilesResponse                                 = 4157
    AMGetAccountStatus                                       = 4158
    AMGetAccountStatusResponse                               = 4159
    AMEditBanReason                                          = 4160
    AMCheckClanMembershipResponse                            = 4161
    AMProbeClanMembershipList                                = 4162
    AMProbeClanMembershipListResponse                        = 4163
    UGSGetUserAchievementStatusResponse                      = 4164
    AMGetFriendsLobbies                                      = 4165
    AMGetFriendsLobbiesResponse                              = 4166
    AMGetUserFriendNewsResponse                              = 4172
    CommunityGetUserFriendNews                               = 4173
    AMGetUserClansNewsResponse                               = 4174
    AMGetUserClansNews                                       = 4175
    AMGetPreviousCBAccount                                   = 4184
    AMGetPreviousCBAccountResponse                           = 4185
    AMGetUserLicenseHistory                                  = 4190
    AMGetUserLicenseHistoryResponse                          = 4191
    AMSupportChangePassword                                  = 4194
    AMSupportChangeEmail                                     = 4195
    AMResetUserVerificationGSByIP                            = 4197
    AMUpdateGSPlayStats                                      = 4198
    AMSupportEnableOrDisable                                 = 4199
    AMGetPurchaseStatus                                      = 4206
    AMSupportIsAccountEnabled                                = 4209
    AMSupportIsAccountEnabledResponse                        = 4210
    UGSGetUserStats                                          = 4211
    AMSupportKickSession                                     = 4212
    AMGSSearch                                               = 4213
    MarketingMessageUpdate                                   = 4216
    ChatServerRouteFriendMsg                                 = 4219
    AMTicketAuthRequestOrResponse                            = 4220
    AMVerifyDepotManagementRights                            = 4222
    AMVerifyDepotManagementRightsResponse                    = 4223
    AMAddFreeLicense                                         = 4224
    AMValidateEmailLink                                      = 4231
    AMValidateEmailLinkResponse                              = 4232
    UGSStoreUserStats                                        = 4236
    AMDeleteStoredCard                                       = 4241
    AMRevokeLegacyGameKeys                                   = 4242
    AMGetWalletDetails                                       = 4244
    AMGetWalletDetailsResponse                               = 4245
    AMDeleteStoredPaymentInfo                                = 4246
    AMGetStoredPaymentSummary                                = 4247
    AMGetStoredPaymentSummaryResponse                        = 4248
    AMGetWalletConversionRate                                = 4249
    AMGetWalletConversionRateResponse                        = 4250
    AMConvertWallet                                          = 4251
    AMConvertWalletResponse                                  = 4252
    AMSetPreApproval                                         = 4255
    AMSetPreApprovalResponse                                 = 4256
    AMCreateRefund                                           = 4258
    AMCreateRefundResponse                                   = 4259
    AMCreateChargeback                                       = 4260
    AMCreateChargebackResponse                               = 4261
    AMCreateDispute                                          = 4262
    AMCreateDisputeResponse                                  = 4263
    AMClearDispute                                           = 4264
    AMCreateFinancialAdjustment                              = 4265
    AMPlayerNicknameList                                     = 4266
    AMPlayerNicknameListResponse                             = 4267
    AMSetDRMTestConfig                                       = 4268
    AMGetUserCurrentGameInfo                                 = 4269
    AMGetUserCurrentGameInfoResponse                         = 4270
    AMGetGSPlayerList                                        = 4271
    AMGetGSPlayerListResponse                                = 4272
    AMGetGameMembers                                         = 4276
    AMGetGameMembersResponse                                 = 4277
    AMGetSteamIDForMicroTxn                                  = 4278
    AMGetSteamIDForMicroTxnResponse                          = 4279
    AMSetPartnerMember                                       = 4280
    AMRemovePublisherUser                                    = 4281
    AMGetUserLicenseList                                     = 4282
    AMGetUserLicenseListResponse                             = 4283
    AMReloadGameGroupPolicy                                  = 4284
    AMAddFreeLicenseResponse                                 = 4285
    AMVACStatusUpdate                                        = 4286
    AMGetAccountDetails                                      = 4287
    AMGetAccountDetailsResponse                              = 4288
    AMGetPlayerLinkDetails                                   = 4289
    AMGetPlayerLinkDetailsResponse                           = 4290
    AMGetAccountFlagsForWGSpoofing                           = 4294
    AMGetAccountFlagsForWGSpoofingResponse                   = 4295
    AMGetClanOfficers                                        = 4298
    AMGetClanOfficersResponse                                = 4299
    AMNameChange                                             = 4300
    AMGetNameHistory                                         = 4301
    AMGetNameHistoryResponse                                 = 4302
    AMUpdateProviderStatus                                   = 4305
    AMSupportRemoveAccountSecurity                           = 4307
    AMIsAccountInCaptchaGracePeriod                          = 4308
    AMIsAccountInCaptchaGracePeriodResponse                  = 4309
    AMAccountPS3Unlink                                       = 4310
    AMAccountPS3UnlinkResponse                               = 4311
    UGSStoreUserStatsResponse                                = 4312
    AMGetAccountPSNInfo                                      = 4313
    AMGetAccountPSNInfoResponse                              = 4314
    AMAuthenticatedPlayerList                                = 4315
    AMGetUserGifts                                           = 4316
    AMGetUserGiftsResponse                                   = 4317
    AMTransferLockedGifts                                    = 4320
    AMTransferLockedGiftsResponse                            = 4321
    AMPlayerHostedOnGameServer                               = 4322
    AMGetAccountBanInfo                                      = 4323
    AMGetAccountBanInfoResponse                              = 4324
    AMRecordBanEnforcement                                   = 4325
    AMRollbackGiftTransfer                                   = 4326
    AMRollbackGiftTransferResponse                           = 4327
    AMHandlePendingTransaction                               = 4328
    AMRequestClanDetails                                     = 4329
    AMDeleteStoredPaypalAgreement                            = 4330
    AMGameServerUpdate                                       = 4331
    AMGameServerRemove                                       = 4332
    AMGetPaypalAgreements                                    = 4333
    AMGetPaypalAgreementsResponse                            = 4334
    AMGameServerPlayerCompatibilityCheck                     = 4335
    AMGameServerPlayerCompatibilityCheckResponse             = 4336
    AMRenewLicense                                           = 4337
    AMGetAccountCommunityBanInfo                             = 4338
    AMGetAccountCommunityBanInfoResponse                     = 4339
    AMGameServerAccountChangePassword                        = 4340
    AMGameServerAccountDeleteAccount                         = 4341
    AMRenewAgreement                                         = 4342
    AMXsollaPayment                                          = 4344
    AMXsollaPaymentResponse                                  = 4345
    AMAcctAllowedToPurchase                                  = 4346
    AMAcctAllowedToPurchaseResponse                          = 4347
    AMSwapKioskDeposit                                       = 4348
    AMSwapKioskDepositResponse                               = 4349
    AMSetUserGiftUnowned                                     = 4350
    AMSetUserGiftUnownedResponse                             = 4351
    AMClaimUnownedUserGift                                   = 4352
    AMClaimUnownedUserGiftResponse                           = 4353
    AMSetClanName                                            = 4354
    AMSetClanNameResponse                                    = 4355
    AMGrantCoupon                                            = 4356
    AMGrantCouponResponse                                    = 4357
    AMIsPackageRestrictedInUserCountry                       = 4358
    AMIsPackageRestrictedInUserCountryResponse               = 4359
    AMHandlePendingTransactionResponse                       = 4360
    AMGrantGuestPasses2                                      = 4361
    AMGrantGuestPasses2Response                              = 4362
    AMSessionQuery                                           = 4363
    AMSessionQueryResponse                                   = 4364
    AMGetPlayerBanDetails                                    = 4365
    AMGetPlayerBanDetailsResponse                            = 4366
    AMFinalizePurchase                                       = 4367
    AMFinalizePurchaseResponse                               = 4368
    AMPersonaChangeResponse                                  = 4372
    AMGetClanDetailsForForumCreation                         = 4373
    AMGetClanDetailsForForumCreationResponse                 = 4374
    AMGetPendingNotificationCount                            = 4375
    AMGetPendingNotificationCountResponse                    = 4376
    AMPasswordHashUpgrade                                    = 4377
    AMMoPayPayment                                           = 4378
    AMMoPayPaymentResponse                                   = 4379
    AMBoaCompraPayment                                       = 4380
    AMBoaCompraPaymentResponse                               = 4381
    AMExpireCaptchaByGID                                     = 4382
    AMCompleteExternalPurchase                               = 4383
    AMCompleteExternalPurchaseResponse                       = 4384
    AMResolveNegativeWalletCredits                           = 4385
    AMResolveNegativeWalletCreditsResponse                   = 4386
    AMPayelpPayment                                          = 4387
    AMPayelpPaymentResponse                                  = 4388
    AMPlayerGetClanBasicDetails                              = 4389
    AMPlayerGetClanBasicDetailsResponse                      = 4390
    AMMOLPayment                                             = 4391
    AMMOLPaymentResponse                                     = 4392
    GetUserIPCountry                                         = 4393
    GetUserIPCountryResponse                                 = 4394
    NotificationOfSuspiciousActivity                         = 4395
    AMDegicaPayment                                          = 4396
    AMDegicaPaymentResponse                                  = 4397
    AMEClubPayment                                           = 4398
    AMEClubPaymentResponse                                   = 4399
    AMPayPalPaymentsHubPayment                               = 4400
    AMPayPalPaymentsHubPaymentResponse                       = 4401
    AMTwoFactorRecoverAuthenticatorRequest                   = 4402
    AMTwoFactorRecoverAuthenticatorResponse                  = 4403
    AMSmart2PayPayment                                       = 4404
    AMSmart2PayPaymentResponse                               = 4405
    AMValidatePasswordResetCodeAndSendSmsRequest             = 4406
    AMValidatePasswordResetCodeAndSendSmsResponse            = 4407
    AMGetAccountResetDetailsRequest                          = 4408
    AMGetAccountResetDetailsResponse                         = 4409
    AMBitPayPayment                                          = 4410
    AMBitPayPaymentResponse                                  = 4411
    AMSendAccountInfoUpdate                                  = 4412
    AMSendScheduledGift                                      = 4413
    AMNodwinPayment                                          = 4414
    AMNodwinPaymentResponse                                  = 4415
    AMResolveWalletRevoke                                    = 4416
    AMResolveWalletReverseRevoke                             = 4417
    AMFundedPayment                                          = 4418
    AMFundedPaymentResponse                                  = 4419
    AMRequestPersonaUpdateForChatServer                      = 4420
    AMPerfectWorldPayment                                    = 4421
    AMPerfectWorldPaymentResponse                            = 4422

    BasePSRange                                              = 5000
    PSCreateShoppingCart                                     = 5001
    PSCreateShoppingCartResponse                             = 5002
    PSIsValidShoppingCart                                    = 5003
    PSIsValidShoppingCartResponse                            = 5004
    PSAddPackageToShoppingCart                               = 5005
    PSAddPackageToShoppingCartResponse                       = 5006
    PSRemoveLineItemFromShoppingCart                         = 5007
    PSRemoveLineItemFromShoppingCartResponse                 = 5008
    PSGetShoppingCartContents                                = 5009
    PSGetShoppingCartContentsResponse                        = 5010
    PSAddWalletCreditToShoppingCart                          = 5011
    PSAddWalletCreditToShoppingCartResponse                  = 5012

    BaseUFSRange                                             = 5200
    ClientUFSUploadFileRequest                               = 5202
    ClientUFSUploadFileResponse                              = 5203
    ClientUFSUploadFileChunk                                 = 5204
    ClientUFSUploadFileFinished                              = 5205
    ClientUFSGetFileListForApp                               = 5206
    ClientUFSGetFileListForAppResponse                       = 5207
    ClientUFSDownloadRequest                                 = 5210
    ClientUFSDownloadResponse                                = 5211
    ClientUFSDownloadChunk                                   = 5212
    ClientUFSLoginRequest                                    = 5213
    ClientUFSLoginResponse                                   = 5214
    UFSReloadPartitionInfo                                   = 5215
    ClientUFSTransferHeartbeat                               = 5216
    UFSSynchronizeFile                                       = 5217
    UFSSynchronizeFileResponse                               = 5218
    ClientUFSDeleteFileRequest                               = 5219
    ClientUFSDeleteFileResponse                              = 5220
    UFSDownloadRequest                                       = 5221
    UFSDownloadResponse                                      = 5222
    UFSDownloadChunk                                         = 5223
    ClientUFSGetUGCDetails                                   = 5226
    ClientUFSGetUGCDetailsResponse                           = 5227
    UFSUpdateFileFlags                                       = 5228
    UFSUpdateFileFlagsResponse                               = 5229
    ClientUFSGetSingleFileInfo                               = 5230
    ClientUFSGetSingleFileInfoResponse                       = 5231
    ClientUFSShareFile                                       = 5232
    ClientUFSShareFileResponse                               = 5233
    UFSReloadAccount                                         = 5234
    UFSReloadAccountResponse                                 = 5235
    UFSUpdateRecordBatched                                   = 5236
    UFSUpdateRecordBatchedResponse                           = 5237
    UFSMigrateFile                                           = 5238
    UFSMigrateFileResponse                                   = 5239
    UFSGetUGCURLs                                            = 5240
    UFSGetUGCURLsResponse                                    = 5241
    UFSHttpUploadFileFinishRequest                           = 5242
    UFSHttpUploadFileFinishResponse                          = 5243
    UFSDownloadStartRequest                                  = 5244
    UFSDownloadStartResponse                                 = 5245
    UFSDownloadChunkRequest                                  = 5246
    UFSDownloadChunkResponse                                 = 5247
    UFSDownloadFinishRequest                                 = 5248
    UFSDownloadFinishResponse                                = 5249
    UFSFlushURLCache                                         = 5250
    ClientUFSUploadCommit                                    = 5251
    ClientUFSUploadCommitResponse                            = 5252
    UFSMigrateFileAppID                                      = 5253
    UFSMigrateFileAppIDResponse                              = 5254

    BaseClient2                                              = 5400
    ClientRequestForgottenPasswordEmail                      = 5401
    ClientRequestForgottenPasswordEmailResponse              = 5402
    ClientCreateAccountResponse                              = 5403
    ClientResetForgottenPassword                             = 5404
    ClientResetForgottenPasswordResponse                     = 5405
    ClientCreateAccount2                                     = 5406
    ClientInformOfResetForgottenPassword                     = 5407
    ClientInformOfResetForgottenPasswordResponse             = 5408
    ClientGamesPlayedWithDataBlob                            = 5410
    ClientUpdateUserGameInfo                                 = 5411
    ClientFileToDownload                                     = 5412
    ClientFileToDownloadResponse                             = 5413
    ClientLBSSetScore                                        = 5414
    ClientLBSSetScoreResponse                                = 5415
    ClientLBSFindOrCreateLB                                  = 5416
    ClientLBSFindOrCreateLBResponse                          = 5417
    ClientLBSGetLBEntries                                    = 5418
    ClientLBSGetLBEntriesResponse                            = 5419
    ClientChatDeclined                                       = 5426
    ClientFriendMsgIncoming                                  = 5427
    ClientTicketAuthComplete                                 = 5429
    ClientIsLimitedAccount                                   = 5430
    ClientRequestAuthList                                    = 5431
    ClientAuthList                                           = 5432
    ClientStat                                               = 5433
    ClientP2PConnectionInfo                                  = 5434
    ClientP2PConnectionFailInfo                              = 5435
    ClientGetDepotDecryptionKey                              = 5438
    ClientGetDepotDecryptionKeyResponse                      = 5439
    GSPerformHardwareSurvey                                  = 5440
    ClientEnableTestLicense                                  = 5443
    ClientEnableTestLicenseResponse                          = 5444
    ClientDisableTestLicense                                 = 5445
    ClientDisableTestLicenseResponse                         = 5446
    ClientRequestValidationMail                              = 5448
    ClientRequestValidationMailResponse                      = 5449
    ClientCheckAppBetaPassword                               = 5450
    ClientCheckAppBetaPasswordResponse                       = 5451
    ClientToGC                                               = 5452
    ClientFromGC                                             = 5453
    ClientRequestChangeMail                                  = 5454
    ClientRequestChangeMailResponse                          = 5455
    ClientEmailAddrInfo                                      = 5456
    ClientPasswordChange3                                    = 5457
    ClientEmailChange3                                       = 5458
    ClientPersonalQAChange3                                  = 5459
    ClientResetForgottenPassword3                            = 5460
    ClientRequestForgottenPasswordEmail3                     = 5461
    ClientNewLoginKey                                        = 5463
    ClientNewLoginKeyAccepted                                = 5464
    ClientStoreUserStats2                                    = 5466
    ClientStatsUpdated                                       = 5467
    ClientActivateOEMLicense                                 = 5468
    ClientRegisterOEMMachine                                 = 5469
    ClientRegisterOEMMachineResponse                         = 5470
    ClientRequestedClientStats                               = 5480
    ClientStat2Int32                                         = 5481
    ClientStat2                                              = 5482
    ClientVerifyPassword                                     = 5483
    ClientVerifyPasswordResponse                             = 5484
    ClientDRMDownloadRequest                                 = 5485
    ClientDRMDownloadResponse                                = 5486
    ClientDRMFinalResult                                     = 5487
    ClientGetFriendsWhoPlayGame                              = 5488
    ClientGetFriendsWhoPlayGameResponse                      = 5489
    ClientOGSBeginSession                                    = 5490
    ClientOGSBeginSessionResponse                            = 5491
    ClientOGSEndSession                                      = 5492
    ClientOGSEndSessionResponse                              = 5493
    ClientOGSWriteRow                                        = 5494
    ClientDRMTest                                            = 5495
    ClientDRMTestResult                                      = 5496
    ClientServerUnavailable                                  = 5500
    ClientServersAvailable                                   = 5501
    ClientRegisterAuthTicketWithCM                           = 5502
    ClientGCMsgFailed                                        = 5503
    ClientMicroTxnAuthRequest                                = 5504
    ClientMicroTxnAuthorize                                  = 5505
    ClientMicroTxnAuthorizeResponse                          = 5506
    ClientAppMinutesPlayedData                               = 5507
    ClientGetMicroTxnInfo                                    = 5508
    ClientGetMicroTxnInfoResponse                            = 5509
    ClientMarketingMessageUpdate2                            = 5510
    ClientDeregisterWithServer                               = 5511
    ClientSubscribeToPersonaFeed                             = 5512
    ClientLogon                                              = 5514
    ClientGetClientDetails                                   = 5515
    ClientGetClientDetailsResponse                           = 5516
    ClientReportOverlayDetourFailure                         = 5517
    ClientGetClientAppList                                   = 5518
    ClientGetClientAppListResponse                           = 5519
    ClientInstallClientApp                                   = 5520
    ClientInstallClientAppResponse                           = 5521
    ClientUninstallClientApp                                 = 5522
    ClientUninstallClientAppResponse                         = 5523
    ClientSetClientAppUpdateState                            = 5524
    ClientSetClientAppUpdateStateResponse                    = 5525
    ClientRequestEncryptedAppTicket                          = 5526
    ClientRequestEncryptedAppTicketResponse                  = 5527
    ClientWalletInfoUpdate                                   = 5528
    ClientLBSSetUGC                                          = 5529
    ClientLBSSetUGCResponse                                  = 5530
    ClientAMGetClanOfficers                                  = 5531
    ClientAMGetClanOfficersResponse                          = 5532
    ClientFriendProfileInfo                                  = 5535
    ClientFriendProfileInfoResponse                          = 5536
    ClientUpdateMachineAuth                                  = 5537
    ClientUpdateMachineAuthResponse                          = 5538
    ClientReadMachineAuth                                    = 5539
    ClientReadMachineAuthResponse                            = 5540
    ClientRequestMachineAuth                                 = 5541
    ClientRequestMachineAuthResponse                         = 5542
    ClientScreenshotsChanged                                 = 5543
    ClientEmailChange4                                       = 5544
    ClientEmailChangeResponse4                               = 5545
    ClientGetCDNAuthToken                                    = 5546
    ClientGetCDNAuthTokenResponse                            = 5547
    ClientDownloadRateStatistics                             = 5548
    ClientRequestAccountData                                 = 5549
    ClientRequestAccountDataResponse                         = 5550
    ClientResetForgottenPassword4                            = 5551
    ClientHideFriend                                         = 5552
    ClientFriendsGroupsList                                  = 5553
    ClientGetClanActivityCounts                              = 5554
    ClientGetClanActivityCountsResponse                      = 5555
    ClientOGSReportString                                    = 5556
    ClientOGSReportBug                                       = 5557
    ClientSentLogs                                           = 5558
    ClientLogonGameServer                                    = 5559
    AMClientCreateFriendsGroup                               = 5560
    AMClientCreateFriendsGroupResponse                       = 5561
    AMClientDeleteFriendsGroup                               = 5562
    AMClientDeleteFriendsGroupResponse                       = 5563
    AMClientManageFriendsGroup                               = 5564
    AMClientManageFriendsGroupResponse                       = 5565
    AMClientAddFriendToGroup                                 = 5566
    AMClientAddFriendToGroupResponse                         = 5567
    AMClientRemoveFriendFromGroup                            = 5568
    AMClientRemoveFriendFromGroupResponse                    = 5569
    ClientAMGetPersonaNameHistory                            = 5570
    ClientAMGetPersonaNameHistoryResponse                    = 5571
    ClientRequestFreeLicense                                 = 5572
    ClientRequestFreeLicenseResponse                         = 5573
    ClientDRMDownloadRequestWithCrashData                    = 5574
    ClientAuthListAck                                        = 5575
    ClientItemAnnouncements                                  = 5576
    ClientRequestItemAnnouncements                           = 5577
    ClientFriendMsgEchoToSender                              = 5578
    ClientOGSGameServerPingSample                            = 5581
    ClientCommentNotifications                               = 5582
    ClientRequestCommentNotifications                        = 5583
    ClientPersonaChangeResponse                              = 5584
    ClientRequestWebAPIAuthenticateUserNonce                 = 5585
    ClientRequestWebAPIAuthenticateUserNonceResponse         = 5586
    ClientPlayerNicknameList                                 = 5587
    AMClientSetPlayerNickname                                = 5588
    AMClientSetPlayerNicknameResponse                        = 5589
    ClientCreateAccountProto                                 = 5590
    ClientCreateAccountProtoResponse                         = 5591
    ClientGetNumberOfCurrentPlayersDP                        = 5592
    ClientGetNumberOfCurrentPlayersDPResponse                = 5593
    ClientServiceMethodLegacy                                = 5594
    ClientServiceMethodLegacyResponse                        = 5595
    ClientFriendUserStatusPublished                          = 5596
    ClientCurrentUIMode                                      = 5597
    ClientVanityURLChangedNotification                       = 5598
    ClientUserNotifications                                  = 5599

    BaseDFS                                                  = 5600
    DFSGetFile                                               = 5601
    DFSInstallLocalFile                                      = 5602
    DFSConnection                                            = 5603
    DFSConnectionReply                                       = 5604
    ClientDFSAuthenticateRequest                             = 5605
    ClientDFSAuthenticateResponse                            = 5606
    ClientDFSEndSession                                      = 5607
    DFSPurgeFile                                             = 5608
    DFSRouteFile                                             = 5609
    DFSGetFileFromServer                                     = 5610
    DFSAcceptedResponse                                      = 5611
    DFSRequestPingback                                       = 5612
    DFSRecvTransmitFile                                      = 5613
    DFSSendTransmitFile                                      = 5614
    DFSRequestPingback2                                      = 5615
    DFSResponsePingback2                                     = 5616
    ClientDFSDownloadStatus                                  = 5617
    DFSStartTransfer                                         = 5618
    DFSTransferComplete                                      = 5619
    DFSRouteFileResponse                                     = 5620
    ClientNetworkingCertRequest                              = 5621
    ClientNetworkingCertRequestResponse                      = 5622
    ClientChallengeRequest                                   = 5623
    ClientChallengeResponse                                  = 5624
    BadgeCraftedNotification                                 = 5625
    ClientNetworkingMobileCertRequest                        = 5626
    ClientNetworkingMobileCertRequestResponse                = 5627

    BaseMDS                                                  = 5800
    AMToMDSGetDepotDecryptionKey                             = 5812
    MDSToAMGetDepotDecryptionKeyResponse                     = 5813
    MDSContentServerConfigRequest                            = 5827
    MDSContentServerConfig                                   = 5828
    MDSGetDepotManifest                                      = 5829
    MDSGetDepotManifestResponse                              = 5830
    MDSGetDepotManifestChunk                                 = 5831
    MDSGetDepotChunk                                         = 5832
    MDSGetDepotChunkResponse                                 = 5833
    MDSGetDepotChunkChunk                                    = 5834
    MDSGetServerListForUser                                  = 5836
    MDSGetServerListForUserResponse                          = 5837
    MDSToCSFlushChunk                                        = 5844
    MDSMigrateChunk                                          = 5847
    MDSMigrateChunkResponse                                  = 5848
    MDSToCSFlushManifest                                     = 5849
    CSBase                                                   = 6200
    CSPing                                                   = 6201
    CSPingResponse                                           = 6202

    GMSBase                                                  = 6400
    GMSGameServerReplicate                                   = 6401
    ClientGMSServerQuery                                     = 6403
    GMSClientServerQueryResponse                             = 6404
    AMGMSGameServerUpdate                                    = 6405
    AMGMSGameServerRemove                                    = 6406
    GameServerOutOfDate                                      = 6407

    DeviceAuthorizationBase                                  = 6500
    ClientAuthorizeLocalDeviceRequest                        = 6501
    ClientAuthorizeLocalDeviceResponse                       = 6502
    ClientDeauthorizeDeviceRequest                           = 6503
    ClientDeauthorizeDevice                                  = 6504
    ClientUseLocalDeviceAuthorizations                       = 6505
    ClientGetAuthorizedDevices                               = 6506
    ClientGetAuthorizedDevicesResponse                       = 6507
    AMNotifySessionDeviceAuthorized                          = 6508
    ClientAuthorizeLocalDeviceNotification                   = 6509

    MMSBase                                                  = 6600
    ClientMMSCreateLobby                                     = 6601
    ClientMMSCreateLobbyResponse                             = 6602
    ClientMMSJoinLobby                                       = 6603
    ClientMMSJoinLobbyResponse                               = 6604
    ClientMMSLeaveLobby                                      = 6605
    ClientMMSLeaveLobbyResponse                              = 6606
    ClientMMSGetLobbyList                                    = 6607
    ClientMMSGetLobbyListResponse                            = 6608
    ClientMMSSetLobbyData                                    = 6609
    ClientMMSSetLobbyDataResponse                            = 6610
    ClientMMSGetLobbyData                                    = 6611
    ClientMMSLobbyData                                       = 6612
    ClientMMSSendLobbyChatMsg                                = 6613
    ClientMMSLobbyChatMsg                                    = 6614
    ClientMMSSetLobbyOwner                                   = 6615
    ClientMMSSetLobbyOwnerResponse                           = 6616
    ClientMMSSetLobbyGameServer                              = 6617
    ClientMMSLobbyGameServerSet                              = 6618
    ClientMMSUserJoinedLobby                                 = 6619
    ClientMMSUserLeftLobby                                   = 6620
    ClientMMSInviteToLobby                                   = 6621
    ClientMMSFlushFrenemyListCache                           = 6622
    ClientMMSFlushFrenemyListCacheResponse                   = 6623
    ClientMMSSetLobbyLinked                                  = 6624
    ClientMMSSetRatelimitPolicyOnClient                      = 6625
    ClientMMSGetLobbyStatus                                  = 6626
    ClientMMSGetLobbyStatusResponse                          = 6627
    MMSGetLobbyList                                          = 6628
    MMSGetLobbyListResponse                                  = 6629
    NonStdMsgBase                                            = 6800
    NonStdMsgMemcached                                       = 6801
    NonStdMsgHTTPServer                                      = 6802
    NonStdMsgHTTPClient                                      = 6803
    NonStdMsgWGResponse                                      = 6804
    NonStdMsgPHPSimulator                                    = 6805
    NonStdMsgChase                                           = 6806
    NonStdMsgDFSTransfer                                     = 6807
    NonStdMsgTests                                           = 6808
    NonStdMsgUMQpipeAAPL                                     = 6809
    NonStdMsgSyslog                                          = 6810
    NonStdMsgLogsink                                         = 6811
    NonStdMsgSteam2Emulator                                  = 6812
    NonStdMsgRTMPServer                                      = 6813
    NonStdMsgWebSocket                                       = 6814
    NonStdMsgRedis                                           = 6815

    UDSBase                                                  = 7000
    ClientUDSP2PSessionStarted                               = 7001
    ClientUDSP2PSessionEnded                                 = 7002
    UDSRenderUserAuth                                        = 7003
    UDSRenderUserAuthResponse                                = 7004
    ClientInviteToGame                                       = 7005
    UDSHasSession                                            = 7006
    UDSHasSessionResponse                                    = 7007

    MPASBase                                                 = 7100
    MPASVacBanReset                                          = 7101

    KGSBase                                                  = 7200

    UCMBase                                                  = 7300
    ClientUCMAddScreenshot                                   = 7301
    ClientUCMAddScreenshotResponse                           = 7302
    UCMResetCommunityContent                                 = 7307
    UCMResetCommunityContentResponse                         = 7308
    ClientUCMDeleteScreenshot                                = 7309
    ClientUCMDeleteScreenshotResponse                        = 7310
    ClientUCMPublishFile                                     = 7311
    ClientUCMPublishFileResponse                             = 7312
    ClientUCMDeletePublishedFile                             = 7315
    ClientUCMDeletePublishedFileResponse                     = 7316
    ClientUCMEnumerateUserPublishedFiles                     = 7317
    ClientUCMEnumerateUserPublishedFilesResponse             = 7318
    ClientUCMEnumerateUserSubscribedFiles                    = 7321
    ClientUCMEnumerateUserSubscribedFilesResponse            = 7322
    ClientUCMUpdatePublishedFile                             = 7325
    ClientUCMUpdatePublishedFileResponse                     = 7326
    UCMUpdatePublishedFile                                   = 7327
    UCMUpdatePublishedFileResponse                           = 7328
    UCMDeletePublishedFile                                   = 7329
    UCMDeletePublishedFileResponse                           = 7330
    UCMUpdatePublishedFileStat                               = 7331
    UCMUpdatePublishedFileBan                                = 7332
    UCMUpdatePublishedFileBanResponse                        = 7333
    UCMReloadPublishedFile                                   = 7337
    UCMReloadUserFileListCaches                              = 7338
    UCMPublishedFileReported                                 = 7339
    UCMPublishedFilePreviewAdd                               = 7341
    UCMPublishedFilePreviewAddResponse                       = 7342
    UCMPublishedFilePreviewRemove                            = 7343
    UCMPublishedFilePreviewRemoveResponse                    = 7344
    ClientUCMPublishedFileSubscribed                         = 7347
    ClientUCMPublishedFileUnsubscribed                       = 7348
    UCMPublishedFileSubscribed                               = 7349
    UCMPublishedFileUnsubscribed                             = 7350
    UCMPublishFile                                           = 7351
    UCMPublishFileResponse                                   = 7352
    UCMPublishedFileChildAdd                                 = 7353
    UCMPublishedFileChildAddResponse                         = 7354
    UCMPublishedFileChildRemove                              = 7355
    UCMPublishedFileChildRemoveResponse                      = 7356
    UCMPublishedFileParentChanged                            = 7359
    ClientUCMGetPublishedFilesForUser                        = 7360
    ClientUCMGetPublishedFilesForUserResponse                = 7361
    ClientUCMSetUserPublishedFileAction                      = 7364
    ClientUCMSetUserPublishedFileActionResponse              = 7365
    ClientUCMEnumeratePublishedFilesByUserAction             = 7366
    ClientUCMEnumeratePublishedFilesByUserActionResponse     = 7367
    ClientUCMPublishedFileDeleted                            = 7368
    UCMGetUserSubscribedFiles                                = 7369
    UCMGetUserSubscribedFilesResponse                        = 7370
    UCMFixStatsPublishedFile                                 = 7371
    ClientUCMEnumerateUserSubscribedFilesWithUpdates         = 7378
    ClientUCMEnumerateUserSubscribedFilesWithUpdatesResponse = 7379
    UCMPublishedFileContentUpdated                           = 7380
    ClientUCMPublishedFileUpdated                            = 7381
    ClientWorkshopItemChangesRequest                         = 7382
    ClientWorkshopItemChangesResponse                        = 7383
    ClientWorkshopItemInfoRequest                            = 7384
    ClientWorkshopItemInfoResponse                           = 7385

    FSBase                                                   = 7500
    ClientRichPresenceUpload                                 = 7501
    ClientRichPresenceRequest                                = 7502
    ClientRichPresenceInfo                                   = 7503
    FSRichPresenceRequest                                    = 7504
    FSRichPresenceResponse                                   = 7505
    FSComputeFrenematrix                                     = 7506
    FSComputeFrenematrixResponse                             = 7507
    FSPlayStatusNotification                                 = 7508
    FSAddOrRemoveFollower                                    = 7510
    FSAddOrRemoveFollowerResponse                            = 7511
    FSUpdateFollowingList                                    = 7512
    FSCommentNotification                                    = 7513
    FSCommentNotificationViewed                              = 7514
    ClientFSGetFollowerCount                                 = 7515
    ClientFSGetFollowerCountResponse                         = 7516
    ClientFSGetIsFollowing                                   = 7517
    ClientFSGetIsFollowingResponse                           = 7518
    ClientFSEnumerateFollowingList                           = 7519
    ClientFSEnumerateFollowingListResponse                   = 7520
    FSGetPendingNotificationCount                            = 7521
    FSGetPendingNotificationCountResponse                    = 7522
    ClientChatOfflineMessageNotification                     = 7523
    ClientChatRequestOfflineMessageCount                     = 7524
    ClientChatGetFriendMessageHistory                        = 7525
    ClientChatGetFriendMessageHistoryResponse                = 7526
    ClientChatGetFriendMessageHistoryForOfflineMessages      = 7527
    ClientFSGetFriendsSteamLevels                            = 7528
    ClientFSGetFriendsSteamLevelsResponse                    = 7529
    AMRequestFriendData                                      = 7530

    CEGVersionSetEnableDisableRequest                        = 7600
    DRMRange2                                                = 7600
    CEGVersionSetEnableDisableResponse                       = 7601
    CEGPropStatusDRMSRequest                                 = 7602
    CEGPropStatusDRMSResponse                                = 7603
    CEGWhackFailureReportRequest                             = 7604
    CEGWhackFailureReportResponse                            = 7605
    DRMSFetchVersionSet                                      = 7606
    DRMSFetchVersionSetResponse                              = 7607

    EconBase                                                 = 7700
    EconTradingInitiateTradeRequest                          = 7701
    EconTradingInitiateTradeProposed                         = 7702
    EconTradingInitiateTradeResponse                         = 7703
    EconTradingInitiateTradeResult                           = 7704
    EconTradingStartSession                                  = 7705
    EconTradingCancelTradeRequest                            = 7706
    EconFlushInventoryCache                                  = 7707
    EconFlushInventoryCacheResponse                          = 7708
    EconCDKeyProcessTransaction                              = 7711
    EconCDKeyProcessTransactionResponse                      = 7712
    EconGetErrorLogs                                         = 7713
    EconGetErrorLogsResponse                                 = 7714

    RMRange                                                  = 7800
    RMTestVerisignOTP                                        = 7800
    RMTestVerisignOTPResponse                                = 7801
    RMDeleteMemcachedKeys                                    = 7803
    RMRemoteInvoke                                           = 7804
    BadLoginIPList                                           = 7805
    RMMsgTraceAddTrigger                                     = 7806
    RMMsgTraceRemoveTrigger                                  = 7807
    RMMsgTraceEvent                                          = 7808

    UGSUpdateGlobalStats                                     = 7900
    UGSBase                                                  = 7900
    ClientUGSGetGlobalStats                                  = 7901
    ClientUGSGetGlobalStatsResponse                          = 7902

    StoreBase                                                = 8000

    UMQLogonRequest                                          = 8100
    UMQBase                                                  = 8100
    UMQLogonResponse                                         = 8101
    UMQLogoffRequest                                         = 8102
    UMQLogoffResponse                                        = 8103
    UMQSendChatMessage                                       = 8104
    UMQIncomingChatMessage                                   = 8105
    UMQPoll                                                  = 8106
    UMQPollResults                                           = 8107
    UMQ2AM_ClientMsgBatch                                    = 8108

    WorkshopBase                                             = 8200

    WebAPIValidateOAuth2Token                                = 8300
    WebAPIBase                                               = 8300
    WebAPIValidateOAuth2TokenResponse                        = 8301
    WebAPIRegisterGCInterfaces                               = 8303
    WebAPIInvalidateOAuthClientCache                         = 8304
    WebAPIInvalidateOAuthTokenCache                          = 8305
    WebAPISetSecrets                                         = 8306

    BackpackBase                                             = 8400
    BackpackAddToCurrency                                    = 8401
    BackpackAddToCurrencyResponse                            = 8402

    CREBase                                                  = 8500
    CREItemVoteSummary                                       = 8503
    CREItemVoteSummaryResponse                               = 8504
    CREUpdateUserPublishedItemVote                           = 8507
    CREUpdateUserPublishedItemVoteResponse                   = 8508
    CREGetUserPublishedItemVoteDetails                       = 8509
    CREGetUserPublishedItemVoteDetailsResponse               = 8510
    CREEnumeratePublishedFiles                               = 8511
    CREEnumeratePublishedFilesResponse                       = 8512
    CREPublishedFileVoteAdded                                = 8513

    SecretsRequestCredentialPair                             = 8600
    SecretsBase                                              = 8600
    SecretsCredentialPairResponse                            = 8601

    BoxMonitorReportRequest                                  = 8700
    BoxMonitorBase                                           = 8700
    BoxMonitorReportResponse                                 = 8701

    LogsinkWriteReport                                       = 8800
    LogsinkBase                                              = 8800

    PICSBase                                                 = 8900
    ClientPICSChangesSinceRequest                            = 8901
    ClientPICSChangesSinceResponse                           = 8902
    ClientPICSProductInfoRequest                             = 8903
    ClientPICSProductInfoResponse                            = 8904
    ClientPICSAccessTokenRequest                             = 8905
    ClientPICSAccessTokenResponse                            = 8906

    WorkerProcess                                            = 9000
    WorkerProcessPingRequest                                 = 9000
    WorkerProcessPingResponse                                = 9001
    WorkerProcessShutdown                                    = 9002

    DRMWorkerProcess                                         = 9100
    DRMWorkerProcessDRMAndSign                               = 9100
    DRMWorkerProcessDRMAndSignResponse                       = 9101
    DRMWorkerProcessSteamworksInfoRequest                    = 9102
    DRMWorkerProcessSteamworksInfoResponse                   = 9103
    DRMWorkerProcessInstallDRMDLLRequest                     = 9104
    DRMWorkerProcessInstallDRMDLLResponse                    = 9105
    DRMWorkerProcessSecretIdStringRequest                    = 9106
    DRMWorkerProcessSecretIdStringResponse                   = 9107
    DRMWorkerProcessInstallProcessedFilesRequest             = 9110
    DRMWorkerProcessInstallProcessedFilesResponse            = 9111
    DRMWorkerProcessExamineBlobRequest                       = 9112
    DRMWorkerProcessExamineBlobResponse                      = 9113
    DRMWorkerProcessDescribeSecretRequest                    = 9114
    DRMWorkerProcessDescribeSecretResponse                   = 9115
    DRMWorkerProcessBackfillOriginalRequest                  = 9116
    DRMWorkerProcessBackfillOriginalResponse                 = 9117
    DRMWorkerProcessValidateDRMDLLRequest                    = 9118
    DRMWorkerProcessValidateDRMDLLResponse                   = 9119
    DRMWorkerProcessValidateFileRequest                      = 9120
    DRMWorkerProcessValidateFileResponse                     = 9121
    DRMWorkerProcessSplitAndInstallRequest                   = 9122
    DRMWorkerProcessSplitAndInstallResponse                  = 9123
    DRMWorkerProcessGetBlobRequest                           = 9124
    DRMWorkerProcessGetBlobResponse                          = 9125
    DRMWorkerProcessEvaluateCrashRequest                     = 9126
    DRMWorkerProcessEvaluateCrashResponse                    = 9127
    DRMWorkerProcessAnalyzeFileRequest                       = 9128
    DRMWorkerProcessAnalyzeFileResponse                      = 9129
    DRMWorkerProcessUnpackBlobRequest                        = 9130
    DRMWorkerProcessUnpackBlobResponse                       = 9131
    DRMWorkerProcessInstallAllRequest                        = 9132
    DRMWorkerProcessInstallAllResponse                       = 9133

    TestWorkerProcess                                        = 9200
    TestWorkerProcessLoadUnloadModuleRequest                 = 9200
    TestWorkerProcessLoadUnloadModuleResponse                = 9201
    TestWorkerProcessServiceModuleCallRequest                = 9202
    TestWorkerProcessServiceModuleCallResponse               = 9203

    QuestServerBase                                          = 9300

    ClientGetEmoticonList                                    = 9330
    ClientEmoticonList                                       = 9331

    SLCUserSessionStatus                                     = 9400
    SLCBase                                                  = 9400
    SLCRequestUserSessionStatus                              = 9401
    SLCSharedLicensesLockStatus                              = 9402
    ClientSharedLibraryLockStatus                            = 9405
    ClientSharedLibraryStopPlaying                           = 9406
    SLCOwnerLibraryChanged                                   = 9407
    SLCSharedLibraryChanged                                  = 9408

    RemoteClientBase                                         = 9500
    RemoteClientAppStatus                                    = 9502
    RemoteClientStartStream                                  = 9503
    RemoteClientStartStreamResponse                          = 9504
    RemoteClientPing                                         = 9505
    RemoteClientPingResponse                                 = 9506
    ClientUnlockStreaming                                    = 9507
    ClientUnlockStreamingResponse                            = 9508
    RemoteClientAcceptEULA                                   = 9509
    RemoteClientGetControllerConfig                          = 9510
    RemoteClientGetControllerConfigResponse                  = 9511
    RemoteClientStreamingEnabled                             = 9512
    ClientUnlockHEVC                                         = 9513
    ClientUnlockHEVCResponse                                 = 9514
    RemoteClientStatusRequest                                = 9515
    RemoteClientStatusResponse                               = 9516

    ClientPlayingSessionState                                = 9600
    ClientConcurrentSessionsBase                             = 9600
    ClientKickPlayingSession                                 = 9601

    ClientBroadcastBase                                      = 9700
    ClientBroadcastFrames                                    = 9701
    ClientBroadcastDisconnect                                = 9702
    ClientBroadcastScreenshot                                = 9703
    ClientBroadcastUploadConfig                              = 9704

    BaseClient3                                              = 9800
    ClientVoiceCallPreAuthorizeResponse                      = 9801
    ClientServerTimestampRequest                             = 9802
    ClientServerTimestampResponse                            = 9803

    ClientLANP2PRequestChunk                                 = 9900
    ClientLANP2PBase                                         = 9900
    ClientLANP2PRequestChunkResponse                         = 9901
    ClientLANP2PMax                                          = 9999

    NotifyWatchdog                                           = 10000

    ClientSiteLicenseSiteInfoNotification                    = 10100
    ClientSiteLicenseBase                                    = 10100
    ClientSiteLicenseCheckout                                = 10101
    ClientSiteLicenseCheckoutResponse                        = 10102
    ClientSiteLicenseGetAvailableSeats                       = 10103
    ClientSiteLicenseGetAvailableSeatsResponse               = 10104
    ClientSiteLicenseGetContentCacheInfo                     = 10105
    ClientSiteLicenseGetContentCacheInfoResponse             = 10106

    ChatServerGetPendingNotificationCount                    = 12000
    BaseChatServer                                           = 12000
    ChatServerGetPendingNotificationCountResponse            = 12001

    ServerSecretChanged                                      = 12100
    BaseSecretServer                                         = 12100
