from ingenialink.register import REG_DTYPE


DIST_FRAME_SIZE_BYTES = 128
DIST_FRAME_SIZE = 512
SINGLE_AXIS_MINIMUM_SUBNODES = 2

DEFAULT_MESSAGE_RETRIES = 7
DEFAULT_MESSAGE_TIMEOUT = 200

DEFAULT_ETH_CONNECTION_TIMEOUT = 1
DEFAULT_PDS_TIMEOUT = 1000

DEFAULT_DRIVE_NAME = "Drive"

MCB_CMD_READ = 1
MCB_CMD_WRITE = 2
MCB_CMD_ACK = 3

PASSWORD_STORE_ALL = 0x65766173
PASSWORD_RESTORE_ALL = 0x64616F6C
PASSWORD_STORE_RESTORE_TCP_IP = 0x636F6D73
PASSWORD_STORE_RESTORE_SUB_0 = 0x73756230

CAN_MONITORING_MAPPED_REGISTERS_START_ADD = 0x58D000

MONITORING_BUFFER_SIZE = 512

data_type_size = {
    REG_DTYPE.U8: 1,
    REG_DTYPE.S8: 1,
    REG_DTYPE.U16: 2,
    REG_DTYPE.S16: 2,
    REG_DTYPE.U32: 4,
    REG_DTYPE.S32: 4,
    REG_DTYPE.U64: 8,
    REG_DTYPE.S64: 8,
    REG_DTYPE.FLOAT: 4,
}

CAN_MAX_WRITE_SIZE = 512
ETH_MAX_WRITE_SIZE = 512
ETH_BUF_SIZE = 1024
