"""
    Snap Conversions API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""

import unittest
from snap_business_sdk.capi_utils import norm_and_hash_string, norm_and_soundex_string, norm_and_hash_phone_number, normalize_phone_num


class TestCapiHash(unittest.TestCase):
    """CapiEvent unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testNormAndHash(self):
        """Test norm and hash"""
        test_hashed_email = norm_and_hash_string("    test123@example.com  ")
        self.assertEqual("20b82517b67108ed3a171539dc5dd1da605660249b02f38dd70f572a545c7d18", test_hashed_email)

        test_hashed_ip = norm_and_hash_string("   0.0.0.0  ")
        self.assertEqual("19e36255972107d42b8cecb77ef5622e842e8a50778a6ed8dd1ce94732daca9e", test_hashed_ip)
        pass

    def testNormAndHashPhoneNum(self):
        """Test norm and hash phone number"""
        self.assertEqual("444472342344", normalize_phone_num("+44-447-234-2344"))
        self.assertEqual("444472342344", normalize_phone_num("0044-447-234-2344"))
        self.assertEqual("444472342344", normalize_phone_num("+44-0447-234-2344"))
        self.assertEqual("444472342344", normalize_phone_num("+44 0447 234 2344"))
        self.assertEqual("14472342344", normalize_phone_num("447-234-2344"))
        self.assertEqual("14472342344", normalize_phone_num("4472342344"))
        self.assertEqual("14472342344", normalize_phone_num("+1-447-234-2344"))
        self.assertEqual("14472342344", normalize_phone_num("(447)-234-2344"))
        self.assertEqual("14472342344", normalize_phone_num("447 234-2344"))
        self.assertEqual("14472342344", normalize_phone_num("+1-(447) 234 2344"))

        self.assertEqual("19f25a18866af88fc60189c3af85010a0b971cf976053787fe21e004538c20a0",
                         norm_and_hash_phone_number("+44-447-234-2344"))
        self.assertEqual("19f25a18866af88fc60189c3af85010a0b971cf976053787fe21e004538c20a0",
                         norm_and_hash_phone_number("0044-447-234-2344"))
        self.assertEqual("19f25a18866af88fc60189c3af85010a0b971cf976053787fe21e004538c20a0",
                         norm_and_hash_phone_number("+44-0447-234-2344"))
        self.assertEqual("19f25a18866af88fc60189c3af85010a0b971cf976053787fe21e004538c20a0",
                         norm_and_hash_phone_number("+44 0447 234 2344"))
        self.assertEqual("34053b331d29734f081bf74160cd33bc2f621b3b6f8ec991500bebf49f14e014",
                         norm_and_hash_phone_number("447-234-2344"))
        self.assertEqual("34053b331d29734f081bf74160cd33bc2f621b3b6f8ec991500bebf49f14e014",
                         norm_and_hash_phone_number("4472342344"))
        self.assertEqual("34053b331d29734f081bf74160cd33bc2f621b3b6f8ec991500bebf49f14e014",
                         norm_and_hash_phone_number("+1-447-234-2344"))
        self.assertEqual("34053b331d29734f081bf74160cd33bc2f621b3b6f8ec991500bebf49f14e014",
                         norm_and_hash_phone_number("(447)-234-2344"))
        self.assertEqual("34053b331d29734f081bf74160cd33bc2f621b3b6f8ec991500bebf49f14e014",
                         norm_and_hash_phone_number("447 234-2344"))
        self.assertEqual("34053b331d29734f081bf74160cd33bc2f621b3b6f8ec991500bebf49f14e014",
                         norm_and_hash_phone_number("+1-(447) 234 2344"))
        pass

    def testNormAndHashInSoundex(self):
        """Test norm and hash string in soundex"""
        self.assertEqual("H464", norm_and_soundex_string("Hello world"))
        self.assertEqual("T230", norm_and_soundex_string("test"))
        self.assertEqual("B252", norm_and_soundex_string("business sdk"))
        self.assertEqual("C516", norm_and_soundex_string("conversion api"))
        self.assertEqual("T235", norm_and_soundex_string("testing"))


if __name__ == '__main__':
    unittest.main()
