from setuptools import setup, find_packages
import os

def read_file(filename):
    with open(filename, 'r', encoding='utf-8') as f:
        return f.read()

setup(
    name="AI-Jarvis-DA",
    version="0.2.3",  # Обновили версию
    author="David_Yudin",
    author_email="dyudin1204@gmail.com",
    description="Jarvis AI - Персональный AI ассистент с Яндекс GPT",
    long_description=read_file('README.md') if os.path.exists('README.md') else "Jarvis AI - умный ассистент с доступом к файловой системе и базе знаний, интегрированный с Яндекс GPT",
    long_description_content_type="text/markdown",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License", 
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
    ],
    python_requires=">=3.8",
    install_requires=[
        "requests>=2.25.0",
        "pyautogui>=0.9.53",
        "pillow>=9.0.0",
    ],
    entry_points={
        "console_scripts": [
            "jarvis=jarvis_ai.cli:main",
        ],
    },
    include_package_data=True,
    package_data={
        'jarvis_ai': [
            '../docs/*.md',
            '../LICENSE', 
            '../README.md',
        ],
    },
)