from django.template.base import FilterExpression, kwarg_re

from markdown import markdown as _markdown


def markdown(text, **kwargs):
    return _markdown(text, **kwargs)


def parse_tag(parser, token):
    bits = token.split_contents()
    tag_name = bits.pop(0)
    args = []
    kwargs = {}
    for bit in bits:
        match = kwarg_re.match(bit)
        kwarg_format = match and match.group(1)
        if kwarg_format:
            key, value = match.groups()
            kwargs[key] = FilterExpression(value, parser)
        else:
            args.append(FilterExpression(bit, parser))

    return (tag_name, args, kwargs)
