import { Stack } from 'aws-cdk-lib';
import * as codebuild from 'aws-cdk-lib/aws-codebuild';
import * as logs from 'aws-cdk-lib/aws-logs';
import { IBucket } from 'aws-cdk-lib/aws-s3';
import { Asset } from 'aws-cdk-lib/aws-s3-assets';
import { Construct } from 'constructs';
export interface ProwlerAuditProps {
    /**
     * Specifies the service name used within component naming
     * @default: prowler
     */
    readonly serviceName?: string;
    /**
     * Specifies the number of days you want to retain CodeBuild run log events in the specified log group. Junit reports are kept for 30 days, HTML reports in S3 are not deleted
     * @default: 3
     */
    readonly logsRetentionInDays?: logs.RetentionDays;
    /**
     * Options to pass to Prowler command, make sure at least -M junit-xml is used for CodeBuild reports. Use -r for the region to send API queries, -f to filter only one region, -M output formats, -c for comma separated checks, for all checks do not use -c or -g, for more options see -h. For a complete assessment use  "-M text,junit-xml,html,csv,json", for SecurityHub integration use "-r region -f region -M text,junit-xml,html,csv,json,json-asff -S -q"
     * @default '-M text,junit-xml,html,csv,json'
     */
    readonly prowlerOptions?: string;
    /**
     * enables the scheduler for running prowler periodically. Together with prowlerScheduler.
     * @default false
     */
    readonly enableScheduler?: boolean;
    /**
     * The time when Prowler will run in cron format. Default is daily at 22:00h or 10PM 'cron(0 22 * * ? *)', for every 5 hours also works 'rate(5 hours)'. More info here https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html.
     * @default 'cron(0 22 * * ? *)'
     */
    readonly prowlerScheduler?: string;
    /**
     * Specifies the concrete Prowler version
     * @default 2.10.0
     */
    readonly prowlerVersion?: string;
    /**
     * An optional S3 bucket to store the Prowler reports
     */
    readonly reportBucket?: IBucket;
    /**
     * An optional prefix for the report bucket objects
     */
    readonly reportBucketPrefix?: string;
    /**
     * An optional parameter to add to the S3 bucket copy command.
     *
     * @example --acl bucket-owner-full-control
     */
    readonly additionalS3CopyArgs?: string;
    /**
     * An Prowler-specific Allowlist file. If a value is provided then this is passed to Prowler on runs using the '-w' flag.
     * If no value is provided, the -w parameter is not used. If you provide an asset that is zipped, it must contain
     * an 'allowlist.txt' file which will be passed to Prowler.
     *
     * @example new Asset(this, 'AllowList', { path: path.join(__dirname, 'allowlist.txt') })
     * @default undefined
     */
    readonly allowlist?: Asset;
}
/**
 * Creates a CodeBuild project to audit an AWS account with Prowler and stores the html report in a S3 bucket. This will run onece at the beginning and on a schedule afterwards. Partial contribution from https://github.com/stevecjones
 */
export declare class ProwlerAudit extends Construct {
    serviceName: string;
    logsRetentionInDays: logs.RetentionDays;
    enableScheduler: boolean;
    prowlerScheduler: string;
    prowlerOptions: string;
    prowlerVersion: string;
    codebuildProject: codebuild.Project;
    constructor(parent: Stack, id: string, props?: ProwlerAuditProps);
}
