# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables


class Provider(pulumi.ProviderResource):
    def __init__(__self__, resource_name, opts=None, kong_admin_password=None, kong_admin_token=None, kong_admin_uri=None, kong_admin_username=None, kong_api_key=None, strict_plugins_match=None, tls_skip_verify=None, __props__=None, __name__=None, __opts__=None):
        """
        The provider type for the kong package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] kong_admin_password: An basic auth password for kong admin
        :param pulumi.Input[str] kong_admin_token: API key for the kong api (Enterprise Edition)
        :param pulumi.Input[str] kong_admin_uri: The address of the kong admin url e.g. http://localhost:8001
        :param pulumi.Input[str] kong_admin_username: An basic auth user for kong admin
        :param pulumi.Input[str] kong_api_key: API key for the kong api (if you have locked it down)
        :param pulumi.Input[bool] strict_plugins_match: Should plugins `config_json` field strictly match plugin configuration
        :param pulumi.Input[bool] tls_skip_verify: Whether to skip tls verify for https kong api endpoint using self signed or untrusted certs
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if kong_admin_password is None:
                kong_admin_password = utilities.get_env('KONG_ADMIN_PASSWORD')
            __props__['kong_admin_password'] = kong_admin_password
            if kong_admin_token is None:
                kong_admin_token = utilities.get_env('KONG_ADMIN_TOKEN')
            __props__['kong_admin_token'] = kong_admin_token
            if kong_admin_uri is None:
                kong_admin_uri = (utilities.get_env('KONG_ADMIN_ADDR') or 'http://localhost:8001')
            __props__['kong_admin_uri'] = kong_admin_uri
            if kong_admin_username is None:
                kong_admin_username = utilities.get_env('KONG_ADMIN_USERNAME')
            __props__['kong_admin_username'] = kong_admin_username
            if kong_api_key is None:
                kong_api_key = utilities.get_env('KONG_API_KEY')
            __props__['kong_api_key'] = kong_api_key
            if strict_plugins_match is None:
                strict_plugins_match = utilities.get_env_bool('STRICT_PLUGINS_MATCH')
            __props__['strict_plugins_match'] = pulumi.Output.from_input(strict_plugins_match).apply(json.dumps) if strict_plugins_match is not None else None
            if tls_skip_verify is None:
                tls_skip_verify = (utilities.get_env_bool('TLS_SKIP_VERIFY') or False)
            __props__['tls_skip_verify'] = pulumi.Output.from_input(tls_skip_verify).apply(json.dumps) if tls_skip_verify is not None else None
        super(Provider, __self__).__init__(
            'kong',
            resource_name,
            __props__,
            opts)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
