"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Topic = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const sns_generated_1 = require("./sns.generated");
const topic_base_1 = require("./topic-base");
/**
 * A new SNS topic.
 *
 * @stability stable
 */
class Topic extends topic_base_1.TopicBase {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.topicName,
        });
        /**
         * Controls automatic creation of policy objects.
         *
         * Set by subclasses.
         *
         * @stability stable
         */
        this.autoCreatePolicy = true;
        if (props.fifo && !props.topicName) {
            // NOTE: Workaround for CloudFormation problem reported in CDK issue 12386
            // see https://github.com/aws/aws-cdk/issues/12386
            throw new Error('FIFO SNS topics must be given a topic name.');
        }
        if (props.contentBasedDeduplication && !props.fifo) {
            throw new Error('Content based deduplication can only be enabled for FIFO SNS topics.');
        }
        let cfnTopicName;
        if (props.fifo && props.topicName && !props.topicName.endsWith('.fifo')) {
            cfnTopicName = this.physicalName + '.fifo';
        }
        else {
            cfnTopicName = this.physicalName;
        }
        const resource = new sns_generated_1.CfnTopic(this, 'Resource', {
            displayName: props.displayName,
            topicName: cfnTopicName,
            kmsMasterKeyId: props.masterKey && props.masterKey.keyArn,
            contentBasedDeduplication: props.contentBasedDeduplication,
            fifoTopic: props.fifo,
        });
        this.topicArn = this.getResourceArnAttribute(resource.ref, {
            service: 'sns',
            resource: this.physicalName,
        });
        this.topicName = this.getResourceNameAttribute(resource.attrTopicName);
    }
    /**
     * Import an existing SNS topic provided an ARN.
     *
     * @param scope The parent creating construct.
     * @param id The construct's name.
     * @param topicArn topic ARN (i.e. arn:aws:sns:us-east-2:444455556666:MyTopic).
     * @stability stable
     */
    static fromTopicArn(scope, id, topicArn) {
        class Import extends topic_base_1.TopicBase {
            constructor() {
                super(...arguments);
                this.topicArn = topicArn;
                this.topicName = core_1.Stack.of(scope).parseArn(topicArn).resource;
                this.autoCreatePolicy = false;
            }
        }
        return new Import(scope, id);
    }
}
exports.Topic = Topic;
_a = JSII_RTTI_SYMBOL_1;
Topic[_a] = { fqn: "@aws-cdk/aws-sns.Topic", version: "1.132.0" };
//# sourceMappingURL=data:application/json;base64,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