from enum import IntEnum


class ArmorFacing(IntEnum):
    FRONT = 0
    RIGHT = 1
    TOP = 2
    REAR = 3
    LEFT = 4
    BOTTOM = 5
    ALL = 6


class FacilityType(IntEnum):
    AMP_STATION = 2
    BIO_LAB = 3
    TECH_PLANT = 4
    LARGE_OUTPOST = 5
    SMALL_OUTPOST = 6
    WARPGATE = 7
    INTERLINK_FACILITY = 8
    CONSTRUCTION_OUTPOST = 9
    RELIC_OUTPOST = 10


class Faction(IntEnum):
    VANU_SOVEREIGNTY = 1
    NEW_CONGLOMERATE = 2
    TERRAN_REPUBLIC = 3
    NS_OPERATIVES = 4


class FireModeType(IntEnum):
    PROJECTILE = 0
    IRON_SIGHT = 1
    MELEE = 3
    TRIGGER_ITEM_ABILITY = 8
    THROWN = 12


class ItemType(IntEnum):
    GENERIC = 1
    MINIGAME = 2
    CREATE_RECIPE = 3
    REWARD_SET = 4
    EXTERNAL_VENTOR_ITEM = 5
    GIVE_QUEST = 6
    CREATE_VEHICLE = 11
    STYLE_CARD = 12
    UNLOCK_PLAYER_TITLE = 13
    GIVE_CURRENCY = 14
    GIVE_PROFILE = 15
    CUSTOMIZATION = 17
    GIVE_MOUNT = 19
    WEAPON = 26
    ATTACHMENT = 27
    BOOST = 28
    AMMO = 29
    GIVE_CERT_POINT = 30
    LOADOUT_TAB = 31
    EXECUTE_SCRIPT = 32
    VEHICLE_EQUIPMENT = 33
    NAME_CHANGE = 34
    SERVER_TRANSFER = 35
    INFANTRY_EQUIPMENT = 36
    CHARACTER_SLOT_TOKEN = 37
    VEHICLE_COSMETIC = 38
    INVANTRY_COSMETIC = 39
    SPEECH_PACK = 40
    RESOURCE_CHARGER = 41
    ADD_RESOURCE_VALUE = 42
    IMAGE_SET = 43
    TERMINAL_PROXY = 44
    IMPLANT = 45
    LEGACY_IMPLANT = 46


class ItemCategory(IntEnum):
    KNIFE = 2
    PISTOL = 3
    SHOTGUN = 4
    SMG = 5
    LMG = 6
    ASSAULT_RIFLE = 7
    CARBINE = 8
    AV_MAX_LEFT = 9
    AI_MAX_LEFT = 10
    SNIPER_RIFLE = 11
    SCOUT_RIFLE = 12
    ROCKET_LAUNCHER = 13
    HEAVY_WEAPON = 14
    FLAMETHROWER_MAX = 15
    FLAK_MAX = 16
    GRENADE = 17
    EXPLOSIVE = 18
    BATTLE_RIFLE = 19
    AA_MAX_RIGHT = 20
    AV_MAX_RIGHT = 21
    AI_MAX_RIGHT = 22
    AA_MAX_LEFT = 23
    CROSSBOW = 24
    CAMO = 99
    INFANTRY = 100
    VEHIVLES = 101
    INFANTRY_WEAPONS = 102
    INFANTRY_GEAR = 103
    VEHICLE_WEAPONS = 104
    VEHICLE_GEAR = 105
    ARMOR_CAMO = 106
    WEAPON_CAMO = 107
    VEHICLE_CAMO = 108
    FLASH_PRIMARY_WEAPON = 109
    GALAXY_LEFT_WEAPON = 110
    GALAXY_TAIL_WEAPON = 111
    GALAXY_RIGHT_WEAPON = 112
    GALAXY_TOP_WEAPON = 113
    HARASSER_TOP_GUNNER = 114
    LIBERATOR_BELLY_WEAPON = 115
    LIBERATOR_NOSE_CANNON = 116
    LIBERATOR_TAIL_WEAPON = 117
    LIGHTNING_PRIMARY_WEAPON = 118
    MAGRIDER_GUNNER_WEAPON = 119
    MAGRIDER_PRIMARY_WEAPON = 120
    MOSQUITO_NOSE_CANNON = 121
    MOSQUITO_WING_MOUNT = 122
    PROWLER_GUNNER_WEAPON = 123
    PROWLER_PRIMARY_WEAPON = 124
    REAVER_NOSE_CANNON = 125
    REAVER_WING_MOUNT = 126
    SCYTHE_NOSE_CANNON = 127
    SCYTHE_WING_MOUNT = 128
    SUNDERER_FRONT_GUNNER = 129
    SUNDERER_REAR_GUNNER = 130
    VANGUARD_GUNNER_WEAPON = 131
    VANGUARD_PRIMARY_WEAPON = 132
    IMPLANTS = 133
    CONSOLIDATED_CAMO = 134
    VO_PACKS = 135
    MALE_VO_PACK = 136
    FEMALE_VO_PACK = 137
    VALKYRIE_NOSE_GUNNER = 138
    INFANTRY_ABILITIES = 139
    VEHIVLE_ABILITIES = 140
    BOOST_AND_UTILITIES = 141
    CONSOLIDATED_DECAL = 142
    ATTACHMENTS = 143
    ANT_TOP_TURRET = 144
    ANT_UTILITY = 145
    AERIAL_COMBAT_WEAPON = 147
    ANT_HARVESTING_TOOL = 148
    HYBRID_RIFLE = 157
    BASTION_POINT_DEFENSE = 208
    BASTION_BOMBARD = 209
    BASTION_WEAPON_SYSTEM = 210


class MetagameEventState(IntEnum):
    STARTED = 135
    RESTARTED = 136
    CANCELED = 137
    ENDED = 138
    XP_BONUS_CHANGED = 139


class PlayerState(IntEnum):
    STANDING = 0
    CROUCHING = 1
    RUNNING = 2
    SPRINTING = 3
    FALLINH_LONG = 4
    CROUCH_WALKING = 5


class ProjectileFlightType(IntEnum):
    BALLISTIC = 1
    TRUE_BALLISTIC = 3
    DYNAMIC = 9
    PROXIMITY_DETONATE = 10


class ResistType(IntEnum):
    NONE = 0
    MELEE = 1
    SMALL_ARM = 2
    HEAVY_MACHINE_GUN = 4
    HEAVY_ANTI_ARMOR = 5
    EXPLOSIVE = 6
    TANK_SHELL = 7
    AIRCRAFT_MACHINE_GUN = 8
    ANTI_VEHICLE_MINE = 9
    FLAK_EXPLOSIVE_BLAST = 12
    ANTI_AIRCRAFT_MACHINE_GUN = 22
    AIR_TO_GROUND_WARHEAD = 23
    ARMOR_PIERCING_CHAIN_GUN = 28
    DEFAULT_ROCKET_LAUNCHER = 34
    ANTI_MATERIEL_RIFLE = 40
    WHALE_HUNTER = 45
    CORE_EXPLOSION = 46


class ResourceType(IntEnum):
    FUEL = 7
    HEAVY_SHIELD = 9
    CLOAKER_JUICE = 35
    MEDIC_FUEL = 38
    NC_MAX_AEGIS_SHIELD_01 = 41
    NC_MAX_AEGIS_SHIELD_02 = 43
    NC_MAX_AEGIS_SHIELD_03 = 44
    NC_MAX_AEGIS_SHIELD_04 = 45
    NC_MAX_AEGIS_SHIELD_05 = 46
    VS_MAX_ABILITY_ZEALOT = 50
    CORTIUM = 58
    AMBUSHER_FUEL = 75
    NSO_MAX_TIME_BOMB = 133


class RewardType(IntEnum):
    ITEM = 1
    XP = 3


class TargetType(IntEnum):
    SELF = 1
    ANY = 2
    ENEMY = 3
    ALLY = 4


class Vehicle(IntEnum):
    FLASH_1 = 1
    SUNDERER = 2
    LIGHTNING = 3
    MAGRIDER = 4
    VANGUARD = 5
    PROWLER = 6
    SCYTHE = 7
    REAVER = 8
    MOSQUITO = 9
    LIBERATOR = 10
    GALAXY = 11
    HARASSER = 12
    DROP_POD_1 = 13
    VALKYRIE = 14
    ANT = 15
    XIPHOS_ANTI_PERSONNEL_PHALANX_TURRET_1 = 100
    MANA_ANTI_PERSONNEL_TURRET = 101
    MANA_ANTI_VEHICLE_TURRET = 102
    SPITFIRE_AUTO_TURRET_1 = 103
    SPITFIRE_AUTO_TURRET_2 = 104
    AA_SPITFIRE_TURRET = 105
    ASPIS_ANTI_AIRCRAFT_PHALANX_TURRET_1 = 150
    SPEAR_ANTI_VEHICLE_PHALANX_TURRET_1 = 151
    SPEAR_ANTI_VEHICLE_TOWER = 160
    ASPIS_ANTI_AIRCRAFT_PHALANX_TURRET_2 = 161
    XIPHOS_ANTI_PERSONNEL_TOWER = 162
    GLAIVE_IPC_1 = 163
    RECON_DRONE = 1013
    SPEAR_ANTI_VEHICLE_PHALANX_TURRET_2 = 2006
    COLOSSUS = 2007
    DROP_POD_2 = 2008
    XIPHOS_ANTI_PERSONNEL_PHALANX_TURRET_2 = 2009
    FLASH_2 = 2010
    FORWARD_STATION = 2011
    BASTION_FLEET_CARRIER = 2019
    GLAIVE_IPC_2 = 2021
    JAVELIN_1 = 2033
    PUMPKIN_PATCH = 2036
    DELIVERER_PROTOTYPE = 2039
    WASP_PROTOTYPE = 2040
    MOSQUITO_INTERCEPTOR = 2122
    REAVER_INTERCEPTOR = 2123
    SCYTHE_INTERCEPTOR = 2124
    JAVELIN_2 = 2125


class World(IntEnum):
    JAEGER = 19
    EMERALD = 17
    CONNERY = 1
    MILLER = 10
    COBALT = 13
    SOLTECH = 40
    BRIGGS = 25
