__all__ = ('ScorePoint',)

from expressmoney.api import *


SERVICE = 'scoring'
APP = 'pdl_ru_v1'


class ScoreCreateContract(Contract):
    order_id = serializers.IntegerField(min_value=1, allow_null=True)
    em_amount_requested = serializers.IntegerField(min_value=1)


class ScoreResponseContract(Contract):
    score = serializers.DecimalField(max_digits=3, decimal_places=2)
    is_first_loan = serializers.BooleanField()


class ScoreID(ID):
    _service = SERVICE
    _app = APP
    _view_set = 'score'


class ScorePoint(ResponseMixin, CreatePointMixin, ContractPoint):
    _point_id = ScoreID()
    _create_contract = ScoreCreateContract
    _response_contract = ScoreResponseContract
