/* File: _fortranmodule.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Sun Mar 29 08:34:13 2020
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include "Python.h"
#include <stdarg.h>
#include "fortranobject.h"
#include <math.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *_fortran_error;
static PyObject *_fortran_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
/*need_typedefs*/

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f##_,F##_)
#else
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f,F)
#endif

#define CHECKSCALAR(check,tcheck,name,show,var)\
    if (!(check)) {\
        char errstring[256];\
        sprintf(errstring, "%s: "show, "("tcheck") failed for "name, var);\
        PyErr_SetString(_fortran_error,errstring);\
        /*goto capi_fail;*/\
    } else 

/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int int_from_pyobj(int* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyInt_Check(obj)) {
        *v = (int)PyInt_AS_LONG(obj);
        return 1;
    }
    tmp = PyNumber_Int(obj);
    if (tmp) {
        *v = PyInt_AS_LONG(tmp);
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _fortran_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int double_from_pyobj(double* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyFloat_Check(obj)) {
#ifdef __sgi
        *v = PyFloat_AsDouble(obj);
#else
        *v = PyFloat_AS_DOUBLE(obj);
#endif
        return 1;
    }
    tmp = PyNumber_Float(obj);
    if (tmp) {
#ifdef __sgi
        *v = PyFloat_AsDouble(tmp);
#else
        *v = PyFloat_AS_DOUBLE(tmp);
#endif
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _fortran_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/
  /* start usercode multiline (0) */
 
    #include "fortran/functionsmodule.h"
    
  /* end multiline (0)*/

/* See f2py2e/rules.py */
extern void F_FUNC(euclid,EUCLID)(double*,double*,double*);
extern void F_WRAPPEDFUNC(quicksort,QUICKSORT)(double*,int*,int*,int*,int*,int*);
extern void F_WRAPPEDFUNC(split,SPLIT)(double*,int*,int*,int*,int*,int*,int*);
extern void F_FUNC(setMaxNb,SETMAXNB)(int*,int*);
extern void F_FUNC(setHillslopeCoeff,SETHILLSLOPECOEFF)(int*,double*,double*);
extern void F_FUNC(setDiffusionCoeff,SETDIFFUSIONCOEFF)(double*,double*,double*,double*,double*,int*);
extern void F_FUNC(MFDreceivers,MFDRECEIVERS)(int*,int*,double*,double*,int*,double*,double*,int*);
extern void F_FUNC(fillPIT,FILLPIT)(double*,double*,double*,int*);
extern void F_FUNC(ngbGlob,NGBGLOB)(int*,int*);
extern void F_FUNC(defineTIN,DEFINETIN)(double*,int*,int*,int*,double*,double*,int*,int*,int*,int*);
extern void F_FUNC(defineGTIN,DEFINEGTIN)(int*,int*,int*,int*,int*,int*,int*);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/*********************************** euclid ***********************************/
static char doc_f2py_rout__fortran_euclid[] = "\
norm = euclid(p1,p2)\n\nWrapper for ``euclid``.\
\n\nParameters\n----------\n"
"p1 : input rank-1 array('d') with bounds (3)\n"
"p2 : input rank-1 array('d') with bounds (3)\n"
"\nReturns\n-------\n"
"norm : float";
/* extern void F_FUNC(euclid,EUCLID)(double*,double*,double*); */
static PyObject *f2py_rout__fortran_euclid(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *p1 = NULL;
  npy_intp p1_Dims[1] = {-1};
  const int p1_Rank = 1;
  PyArrayObject *capi_p1_tmp = NULL;
  int capi_p1_intent = 0;
  PyObject *p1_capi = Py_None;
  double *p2 = NULL;
  npy_intp p2_Dims[1] = {-1};
  const int p2_Rank = 1;
  PyArrayObject *capi_p2_tmp = NULL;
  int capi_p2_intent = 0;
  PyObject *p2_capi = Py_None;
  double norm = 0;
  static char *capi_kwlist[] = {"p1","p2",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO:_fortran.euclid",\
    capi_kwlist,&p1_capi,&p2_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable p1 */
  p1_Dims[0]=3;
  capi_p1_intent |= F2PY_INTENT_IN;
  capi_p1_tmp = array_from_pyobj(NPY_DOUBLE,p1_Dims,p1_Rank,capi_p1_intent,p1_capi);
  if (capi_p1_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 1st argument `p1' of _fortran.euclid to C/Fortran array" );
  } else {
    p1 = (double *)(PyArray_DATA(capi_p1_tmp));

  /* Processing variable p2 */
  p2_Dims[0]=3;
  capi_p2_intent |= F2PY_INTENT_IN;
  capi_p2_tmp = array_from_pyobj(NPY_DOUBLE,p2_Dims,p2_Rank,capi_p2_intent,p2_capi);
  if (capi_p2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 2nd argument `p2' of _fortran.euclid to C/Fortran array" );
  } else {
    p2 = (double *)(PyArray_DATA(capi_p2_tmp));

  /* Processing variable norm */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(p1,p2,&norm);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",norm);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable norm */
  if((PyObject *)capi_p2_tmp!=p2_capi) {
    Py_XDECREF(capi_p2_tmp); }
  }  /*if (capi_p2_tmp == NULL) ... else of p2*/
  /* End of cleaning variable p2 */
  if((PyObject *)capi_p1_tmp!=p1_capi) {
    Py_XDECREF(capi_p1_tmp); }
  }  /*if (capi_p1_tmp == NULL) ... else of p1*/
  /* End of cleaning variable p1 */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of euclid *******************************/

/********************************* quicksort *********************************/
static char doc_f2py_rout__fortran_quicksort[] = "\
quicksort(array,first,last,indices)\n\nWrapper for ``quicksort``.\
\n\nParameters\n----------\n"
"array : in/output rank-1 array('d') with bounds (f2py_array_d0)\n"
"first : input int\n"
"last : input int\n"
"indices : in/output rank-1 array('i') with bounds (f2py_indices_d0)";
/* extern void F_WRAPPEDFUNC(quicksort,QUICKSORT)(double*,int*,int*,int*,int*,int*); */
static PyObject *f2py_rout__fortran_quicksort(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*,int*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *array = NULL;
  npy_intp array_Dims[1] = {-1};
  const int array_Rank = 1;
  PyArrayObject *capi_array_tmp = NULL;
  int capi_array_intent = 0;
  PyObject *array_capi = Py_None;
  int first = 0;
  PyObject *first_capi = Py_None;
  int last = 0;
  PyObject *last_capi = Py_None;
  int *indices = NULL;
  npy_intp indices_Dims[1] = {-1};
  const int indices_Rank = 1;
  PyArrayObject *capi_indices_tmp = NULL;
  int capi_indices_intent = 0;
  PyObject *indices_capi = Py_None;
  int f2py_array_d0 = 0;
  int f2py_indices_d0 = 0;
  static char *capi_kwlist[] = {"array","first","last","indices",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO:_fortran.quicksort",\
    capi_kwlist,&array_capi,&first_capi,&last_capi,&indices_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable array */
  ;
  capi_array_intent |= F2PY_INTENT_INOUT;
  capi_array_tmp = array_from_pyobj(NPY_DOUBLE,array_Dims,array_Rank,capi_array_intent,array_capi);
  if (capi_array_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 1st argument `array' of _fortran.quicksort to C/Fortran array" );
  } else {
    array = (double *)(PyArray_DATA(capi_array_tmp));

  /* Processing variable first */
    f2py_success = int_from_pyobj(&first,first_capi,"_fortran.quicksort() 2nd argument (first) can't be converted to int");
  if (f2py_success) {
  /* Processing variable last */
    f2py_success = int_from_pyobj(&last,last_capi,"_fortran.quicksort() 3rd argument (last) can't be converted to int");
  if (f2py_success) {
  /* Processing variable indices */
  ;
  capi_indices_intent |= F2PY_INTENT_INOUT;
  capi_indices_tmp = array_from_pyobj(NPY_INT,indices_Dims,indices_Rank,capi_indices_intent,indices_capi);
  if (capi_indices_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 4th argument `indices' of _fortran.quicksort to C/Fortran array" );
  } else {
    indices = (int *)(PyArray_DATA(capi_indices_tmp));

  /* Processing variable f2py_array_d0 */
  f2py_array_d0 = shape(array, 0);
  /* Processing variable f2py_indices_d0 */
  f2py_indices_d0 = shape(indices, 0);
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(array,&first,&last,indices,&f2py_array_d0,&f2py_indices_d0);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable f2py_indices_d0 */
  /* End of cleaning variable f2py_array_d0 */
  if((PyObject *)capi_indices_tmp!=indices_capi) {
    Py_XDECREF(capi_indices_tmp); }
  }  /*if (capi_indices_tmp == NULL) ... else of indices*/
  /* End of cleaning variable indices */
  } /*if (f2py_success) of last*/
  /* End of cleaning variable last */
  } /*if (f2py_success) of first*/
  /* End of cleaning variable first */
  if((PyObject *)capi_array_tmp!=array_capi) {
    Py_XDECREF(capi_array_tmp); }
  }  /*if (capi_array_tmp == NULL) ... else of array*/
  /* End of cleaning variable array */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of quicksort ******************************/

/*********************************** split ***********************************/
static char doc_f2py_rout__fortran_split[] = "\
mid = split(array,low,high,indices)\n\nWrapper for ``split``.\
\n\nParameters\n----------\n"
"array : in/output rank-1 array('d') with bounds (f2py_array_d0)\n"
"low : input int\n"
"high : input int\n"
"indices : in/output rank-1 array('i') with bounds (f2py_indices_d0)\n"
"\nReturns\n-------\n"
"mid : int";
/* extern void F_WRAPPEDFUNC(split,SPLIT)(double*,int*,int*,int*,int*,int*,int*); */
static PyObject *f2py_rout__fortran_split(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*,int*,int*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *array = NULL;
  npy_intp array_Dims[1] = {-1};
  const int array_Rank = 1;
  PyArrayObject *capi_array_tmp = NULL;
  int capi_array_intent = 0;
  PyObject *array_capi = Py_None;
  int low = 0;
  PyObject *low_capi = Py_None;
  int high = 0;
  PyObject *high_capi = Py_None;
  int mid = 0;
  int *indices = NULL;
  npy_intp indices_Dims[1] = {-1};
  const int indices_Rank = 1;
  PyArrayObject *capi_indices_tmp = NULL;
  int capi_indices_intent = 0;
  PyObject *indices_capi = Py_None;
  int f2py_array_d0 = 0;
  int f2py_indices_d0 = 0;
  static char *capi_kwlist[] = {"array","low","high","indices",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO:_fortran.split",\
    capi_kwlist,&array_capi,&low_capi,&high_capi,&indices_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable array */
  ;
  capi_array_intent |= F2PY_INTENT_INOUT;
  capi_array_tmp = array_from_pyobj(NPY_DOUBLE,array_Dims,array_Rank,capi_array_intent,array_capi);
  if (capi_array_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 1st argument `array' of _fortran.split to C/Fortran array" );
  } else {
    array = (double *)(PyArray_DATA(capi_array_tmp));

  /* Processing variable low */
    f2py_success = int_from_pyobj(&low,low_capi,"_fortran.split() 2nd argument (low) can't be converted to int");
  if (f2py_success) {
  /* Processing variable high */
    f2py_success = int_from_pyobj(&high,high_capi,"_fortran.split() 3rd argument (high) can't be converted to int");
  if (f2py_success) {
  /* Processing variable mid */
  /* Processing variable indices */
  ;
  capi_indices_intent |= F2PY_INTENT_INOUT;
  capi_indices_tmp = array_from_pyobj(NPY_INT,indices_Dims,indices_Rank,capi_indices_intent,indices_capi);
  if (capi_indices_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 4th argument `indices' of _fortran.split to C/Fortran array" );
  } else {
    indices = (int *)(PyArray_DATA(capi_indices_tmp));

  /* Processing variable f2py_array_d0 */
  f2py_array_d0 = shape(array, 0);
  /* Processing variable f2py_indices_d0 */
  f2py_indices_d0 = shape(indices, 0);
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(array,&low,&high,&mid,indices,&f2py_array_d0,&f2py_indices_d0);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",mid);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable f2py_indices_d0 */
  /* End of cleaning variable f2py_array_d0 */
  if((PyObject *)capi_indices_tmp!=indices_capi) {
    Py_XDECREF(capi_indices_tmp); }
  }  /*if (capi_indices_tmp == NULL) ... else of indices*/
  /* End of cleaning variable indices */
  /* End of cleaning variable mid */
  } /*if (f2py_success) of high*/
  /* End of cleaning variable high */
  } /*if (f2py_success) of low*/
  /* End of cleaning variable low */
  if((PyObject *)capi_array_tmp!=array_capi) {
    Py_XDECREF(capi_array_tmp); }
  }  /*if (capi_array_tmp == NULL) ... else of array*/
  /* End of cleaning variable array */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of split ********************************/

/********************************** setMaxNb **********************************/
static char doc_f2py_rout__fortran_setMaxNb[] = "\
maxnb = setMaxNb(nb)\n\nWrapper for ``setMaxNb``.\
\n\nParameters\n----------\n"
"nb : input int\n"
"\nReturns\n-------\n"
"maxnb : int";
/* extern void F_FUNC(setMaxNb,SETMAXNB)(int*,int*); */
static PyObject *f2py_rout__fortran_setMaxNb(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nb = 0;
  PyObject *nb_capi = Py_None;
  int maxnb = 0;
  static char *capi_kwlist[] = {"nb",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:_fortran.setMaxNb",\
    capi_kwlist,&nb_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable nb */
    f2py_success = int_from_pyobj(&nb,nb_capi,"_fortran.setMaxNb() 1st argument (nb) can't be converted to int");
  if (f2py_success) {
  /* Processing variable maxnb */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nb,&maxnb);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",maxnb);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable maxnb */
  } /*if (f2py_success) of nb*/
  /* End of cleaning variable nb */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of setMaxNb ******************************/

/***************************** setHillslopeCoeff *****************************/
static char doc_f2py_rout__fortran_setHillslopeCoeff[] = "\
dcoeff = setHillslopeCoeff(nb,kd)\n\nWrapper for ``setHillslopeCoeff``.\
\n\nParameters\n----------\n"
"nb : input int\n"
"kd : input rank-1 array('d') with bounds (nb)\n"
"\nReturns\n-------\n"
"dcoeff : rank-2 array('d') with bounds (nb,8)";
/* extern void F_FUNC(setHillslopeCoeff,SETHILLSLOPECOEFF)(int*,double*,double*); */
static PyObject *f2py_rout__fortran_setHillslopeCoeff(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nb = 0;
  PyObject *nb_capi = Py_None;
  double *kd = NULL;
  npy_intp kd_Dims[1] = {-1};
  const int kd_Rank = 1;
  PyArrayObject *capi_kd_tmp = NULL;
  int capi_kd_intent = 0;
  PyObject *kd_capi = Py_None;
  double *dcoeff = NULL;
  npy_intp dcoeff_Dims[2] = {-1, -1};
  const int dcoeff_Rank = 2;
  PyArrayObject *capi_dcoeff_tmp = NULL;
  int capi_dcoeff_intent = 0;
  static char *capi_kwlist[] = {"nb","kd",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO:_fortran.setHillslopeCoeff",\
    capi_kwlist,&nb_capi,&kd_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable nb */
    f2py_success = int_from_pyobj(&nb,nb_capi,"_fortran.setHillslopeCoeff() 1st argument (nb) can't be converted to int");
  if (f2py_success) {
  /* Processing variable kd */
  kd_Dims[0]=nb;
  capi_kd_intent |= F2PY_INTENT_IN;
  capi_kd_tmp = array_from_pyobj(NPY_DOUBLE,kd_Dims,kd_Rank,capi_kd_intent,kd_capi);
  if (capi_kd_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 2nd argument `kd' of _fortran.setHillslopeCoeff to C/Fortran array" );
  } else {
    kd = (double *)(PyArray_DATA(capi_kd_tmp));

  /* Processing variable dcoeff */
  dcoeff_Dims[0]=nb,dcoeff_Dims[1]=8;
  capi_dcoeff_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_dcoeff_tmp = array_from_pyobj(NPY_DOUBLE,dcoeff_Dims,dcoeff_Rank,capi_dcoeff_intent,Py_None);
  if (capi_dcoeff_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting hidden `dcoeff' of _fortran.setHillslopeCoeff to C/Fortran array" );
  } else {
    dcoeff = (double *)(PyArray_DATA(capi_dcoeff_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nb,kd,dcoeff);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("N",capi_dcoeff_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_dcoeff_tmp == NULL) ... else of dcoeff*/
  /* End of cleaning variable dcoeff */
  if((PyObject *)capi_kd_tmp!=kd_capi) {
    Py_XDECREF(capi_kd_tmp); }
  }  /*if (capi_kd_tmp == NULL) ... else of kd*/
  /* End of cleaning variable kd */
  } /*if (f2py_success) of nb*/
  /* End of cleaning variable nb */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************** end of setHillslopeCoeff **************************/

/***************************** setDiffusionCoeff *****************************/
static char doc_f2py_rout__fortran_setDiffusionCoeff[] = "\
dcoeff = setDiffusionCoeff(kd,limit,elev,dh,[nb])\n\nWrapper for ``setDiffusionCoeff``.\
\n\nParameters\n----------\n"
"kd : input float\n"
"limit : input float\n"
"elev : input rank-1 array('d') with bounds (nb)\n"
"dh : input rank-1 array('d') with bounds (nb)\n"
"\nOther Parameters\n----------------\n"
"nb : input int, optional\n    Default: len(elev)\n"
"\nReturns\n-------\n"
"dcoeff : rank-2 array('d') with bounds (nb,13)";
/* extern void F_FUNC(setDiffusionCoeff,SETDIFFUSIONCOEFF)(double*,double*,double*,double*,double*,int*); */
static PyObject *f2py_rout__fortran_setDiffusionCoeff(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double kd = 0;
  PyObject *kd_capi = Py_None;
  double limit = 0;
  PyObject *limit_capi = Py_None;
  double *elev = NULL;
  npy_intp elev_Dims[1] = {-1};
  const int elev_Rank = 1;
  PyArrayObject *capi_elev_tmp = NULL;
  int capi_elev_intent = 0;
  PyObject *elev_capi = Py_None;
  double *dh = NULL;
  npy_intp dh_Dims[1] = {-1};
  const int dh_Rank = 1;
  PyArrayObject *capi_dh_tmp = NULL;
  int capi_dh_intent = 0;
  PyObject *dh_capi = Py_None;
  double *dcoeff = NULL;
  npy_intp dcoeff_Dims[2] = {-1, -1};
  const int dcoeff_Rank = 2;
  PyArrayObject *capi_dcoeff_tmp = NULL;
  int capi_dcoeff_intent = 0;
  int nb = 0;
  PyObject *nb_capi = Py_None;
  static char *capi_kwlist[] = {"kd","limit","elev","dh","nb",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|O:_fortran.setDiffusionCoeff",\
    capi_kwlist,&kd_capi,&limit_capi,&elev_capi,&dh_capi,&nb_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable kd */
    f2py_success = double_from_pyobj(&kd,kd_capi,"_fortran.setDiffusionCoeff() 1st argument (kd) can't be converted to double");
  if (f2py_success) {
  /* Processing variable limit */
    f2py_success = double_from_pyobj(&limit,limit_capi,"_fortran.setDiffusionCoeff() 2nd argument (limit) can't be converted to double");
  if (f2py_success) {
  /* Processing variable elev */
  ;
  capi_elev_intent |= F2PY_INTENT_IN;
  capi_elev_tmp = array_from_pyobj(NPY_DOUBLE,elev_Dims,elev_Rank,capi_elev_intent,elev_capi);
  if (capi_elev_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 3rd argument `elev' of _fortran.setDiffusionCoeff to C/Fortran array" );
  } else {
    elev = (double *)(PyArray_DATA(capi_elev_tmp));

  /* Processing variable nb */
  if (nb_capi == Py_None) nb = len(elev); else
    f2py_success = int_from_pyobj(&nb,nb_capi,"_fortran.setDiffusionCoeff() 1st keyword (nb) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(elev)>=nb,"len(elev)>=nb","1st keyword nb","setDiffusionCoeff:nb=%d",nb) {
  /* Processing variable dh */
  dh_Dims[0]=nb;
  capi_dh_intent |= F2PY_INTENT_IN;
  capi_dh_tmp = array_from_pyobj(NPY_DOUBLE,dh_Dims,dh_Rank,capi_dh_intent,dh_capi);
  if (capi_dh_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 4th argument `dh' of _fortran.setDiffusionCoeff to C/Fortran array" );
  } else {
    dh = (double *)(PyArray_DATA(capi_dh_tmp));

  /* Processing variable dcoeff */
  dcoeff_Dims[0]=nb,dcoeff_Dims[1]=13;
  capi_dcoeff_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_dcoeff_tmp = array_from_pyobj(NPY_DOUBLE,dcoeff_Dims,dcoeff_Rank,capi_dcoeff_intent,Py_None);
  if (capi_dcoeff_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting hidden `dcoeff' of _fortran.setDiffusionCoeff to C/Fortran array" );
  } else {
    dcoeff = (double *)(PyArray_DATA(capi_dcoeff_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&kd,&limit,elev,dh,dcoeff,&nb);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("N",capi_dcoeff_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_dcoeff_tmp == NULL) ... else of dcoeff*/
  /* End of cleaning variable dcoeff */
  if((PyObject *)capi_dh_tmp!=dh_capi) {
    Py_XDECREF(capi_dh_tmp); }
  }  /*if (capi_dh_tmp == NULL) ... else of dh*/
  /* End of cleaning variable dh */
  } /*CHECKSCALAR(len(elev)>=nb)*/
  } /*if (f2py_success) of nb*/
  /* End of cleaning variable nb */
  if((PyObject *)capi_elev_tmp!=elev_capi) {
    Py_XDECREF(capi_elev_tmp); }
  }  /*if (capi_elev_tmp == NULL) ... else of elev*/
  /* End of cleaning variable elev */
  } /*if (f2py_success) of limit*/
  /* End of cleaning variable limit */
  } /*if (f2py_success) of kd*/
  /* End of cleaning variable kd */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************** end of setDiffusionCoeff **************************/

/******************************** MFDreceivers ********************************/
static char doc_f2py_rout__fortran_MFDreceivers[] = "\
rcv,dist,wgt = MFDreceivers(nrcv,inids,elev,sl,[nb])\n\nWrapper for ``MFDreceivers``.\
\n\nParameters\n----------\n"
"nrcv : input int\n"
"inids : input rank-1 array('i') with bounds (nb)\n"
"elev : input rank-1 array('d') with bounds (nb)\n"
"sl : input float\n"
"\nOther Parameters\n----------------\n"
"nb : input int, optional\n    Default: len(inids)\n"
"\nReturns\n-------\n"
"rcv : rank-2 array('i') with bounds (nb,nrcv)\n"
"dist : rank-2 array('d') with bounds (nb,nrcv)\n"
"wgt : rank-2 array('d') with bounds (nb,nrcv)";
/* extern void F_FUNC(MFDreceivers,MFDRECEIVERS)(int*,int*,double*,double*,int*,double*,double*,int*); */
static PyObject *f2py_rout__fortran_MFDreceivers(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,int*,double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nrcv = 0;
  PyObject *nrcv_capi = Py_None;
  int *inids = NULL;
  npy_intp inids_Dims[1] = {-1};
  const int inids_Rank = 1;
  PyArrayObject *capi_inids_tmp = NULL;
  int capi_inids_intent = 0;
  PyObject *inids_capi = Py_None;
  double *elev = NULL;
  npy_intp elev_Dims[1] = {-1};
  const int elev_Rank = 1;
  PyArrayObject *capi_elev_tmp = NULL;
  int capi_elev_intent = 0;
  PyObject *elev_capi = Py_None;
  double sl = 0;
  PyObject *sl_capi = Py_None;
  int *rcv = NULL;
  npy_intp rcv_Dims[2] = {-1, -1};
  const int rcv_Rank = 2;
  PyArrayObject *capi_rcv_tmp = NULL;
  int capi_rcv_intent = 0;
  double *dist = NULL;
  npy_intp dist_Dims[2] = {-1, -1};
  const int dist_Rank = 2;
  PyArrayObject *capi_dist_tmp = NULL;
  int capi_dist_intent = 0;
  double *wgt = NULL;
  npy_intp wgt_Dims[2] = {-1, -1};
  const int wgt_Rank = 2;
  PyArrayObject *capi_wgt_tmp = NULL;
  int capi_wgt_intent = 0;
  int nb = 0;
  PyObject *nb_capi = Py_None;
  static char *capi_kwlist[] = {"nrcv","inids","elev","sl","nb",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|O:_fortran.MFDreceivers",\
    capi_kwlist,&nrcv_capi,&inids_capi,&elev_capi,&sl_capi,&nb_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable nrcv */
    f2py_success = int_from_pyobj(&nrcv,nrcv_capi,"_fortran.MFDreceivers() 1st argument (nrcv) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sl */
    f2py_success = double_from_pyobj(&sl,sl_capi,"_fortran.MFDreceivers() 4th argument (sl) can't be converted to double");
  if (f2py_success) {
  /* Processing variable inids */
  ;
  capi_inids_intent |= F2PY_INTENT_IN;
  capi_inids_tmp = array_from_pyobj(NPY_INT,inids_Dims,inids_Rank,capi_inids_intent,inids_capi);
  if (capi_inids_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 2nd argument `inids' of _fortran.MFDreceivers to C/Fortran array" );
  } else {
    inids = (int *)(PyArray_DATA(capi_inids_tmp));

  /* Processing variable nb */
  if (nb_capi == Py_None) nb = len(inids); else
    f2py_success = int_from_pyobj(&nb,nb_capi,"_fortran.MFDreceivers() 1st keyword (nb) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(inids)>=nb,"len(inids)>=nb","1st keyword nb","MFDreceivers:nb=%d",nb) {
  /* Processing variable elev */
  elev_Dims[0]=nb;
  capi_elev_intent |= F2PY_INTENT_IN;
  capi_elev_tmp = array_from_pyobj(NPY_DOUBLE,elev_Dims,elev_Rank,capi_elev_intent,elev_capi);
  if (capi_elev_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 3rd argument `elev' of _fortran.MFDreceivers to C/Fortran array" );
  } else {
    elev = (double *)(PyArray_DATA(capi_elev_tmp));

  /* Processing variable rcv */
  rcv_Dims[0]=nb,rcv_Dims[1]=nrcv;
  capi_rcv_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_rcv_tmp = array_from_pyobj(NPY_INT,rcv_Dims,rcv_Rank,capi_rcv_intent,Py_None);
  if (capi_rcv_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting hidden `rcv' of _fortran.MFDreceivers to C/Fortran array" );
  } else {
    rcv = (int *)(PyArray_DATA(capi_rcv_tmp));

  /* Processing variable dist */
  dist_Dims[0]=nb,dist_Dims[1]=nrcv;
  capi_dist_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_dist_tmp = array_from_pyobj(NPY_DOUBLE,dist_Dims,dist_Rank,capi_dist_intent,Py_None);
  if (capi_dist_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting hidden `dist' of _fortran.MFDreceivers to C/Fortran array" );
  } else {
    dist = (double *)(PyArray_DATA(capi_dist_tmp));

  /* Processing variable wgt */
  wgt_Dims[0]=nb,wgt_Dims[1]=nrcv;
  capi_wgt_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_wgt_tmp = array_from_pyobj(NPY_DOUBLE,wgt_Dims,wgt_Rank,capi_wgt_intent,Py_None);
  if (capi_wgt_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting hidden `wgt' of _fortran.MFDreceivers to C/Fortran array" );
  } else {
    wgt = (double *)(PyArray_DATA(capi_wgt_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nrcv,inids,elev,&sl,rcv,dist,wgt,&nb);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("NNN",capi_rcv_tmp,capi_dist_tmp,capi_wgt_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_wgt_tmp == NULL) ... else of wgt*/
  /* End of cleaning variable wgt */
  }  /*if (capi_dist_tmp == NULL) ... else of dist*/
  /* End of cleaning variable dist */
  }  /*if (capi_rcv_tmp == NULL) ... else of rcv*/
  /* End of cleaning variable rcv */
  if((PyObject *)capi_elev_tmp!=elev_capi) {
    Py_XDECREF(capi_elev_tmp); }
  }  /*if (capi_elev_tmp == NULL) ... else of elev*/
  /* End of cleaning variable elev */
  } /*CHECKSCALAR(len(inids)>=nb)*/
  } /*if (f2py_success) of nb*/
  /* End of cleaning variable nb */
  if((PyObject *)capi_inids_tmp!=inids_capi) {
    Py_XDECREF(capi_inids_tmp); }
  }  /*if (capi_inids_tmp == NULL) ... else of inids*/
  /* End of cleaning variable inids */
  } /*if (f2py_success) of sl*/
  /* End of cleaning variable sl */
  } /*if (f2py_success) of nrcv*/
  /* End of cleaning variable nrcv */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of MFDreceivers ****************************/

/********************************** fillPIT **********************************/
static char doc_f2py_rout__fortran_fillPIT[] = "\
fillz = fillPIT(sl,elev,[nb])\n\nWrapper for ``fillPIT``.\
\n\nParameters\n----------\n"
"sl : input float\n"
"elev : input rank-1 array('d') with bounds (nb)\n"
"\nOther Parameters\n----------------\n"
"nb : input int, optional\n    Default: len(elev)\n"
"\nReturns\n-------\n"
"fillz : rank-1 array('d') with bounds (nb)";
/* extern void F_FUNC(fillPIT,FILLPIT)(double*,double*,double*,int*); */
static PyObject *f2py_rout__fortran_fillPIT(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double sl = 0;
  PyObject *sl_capi = Py_None;
  double *elev = NULL;
  npy_intp elev_Dims[1] = {-1};
  const int elev_Rank = 1;
  PyArrayObject *capi_elev_tmp = NULL;
  int capi_elev_intent = 0;
  PyObject *elev_capi = Py_None;
  double *fillz = NULL;
  npy_intp fillz_Dims[1] = {-1};
  const int fillz_Rank = 1;
  PyArrayObject *capi_fillz_tmp = NULL;
  int capi_fillz_intent = 0;
  int nb = 0;
  PyObject *nb_capi = Py_None;
  static char *capi_kwlist[] = {"sl","elev","nb",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|O:_fortran.fillPIT",\
    capi_kwlist,&sl_capi,&elev_capi,&nb_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable sl */
    f2py_success = double_from_pyobj(&sl,sl_capi,"_fortran.fillPIT() 1st argument (sl) can't be converted to double");
  if (f2py_success) {
  /* Processing variable elev */
  ;
  capi_elev_intent |= F2PY_INTENT_IN;
  capi_elev_tmp = array_from_pyobj(NPY_DOUBLE,elev_Dims,elev_Rank,capi_elev_intent,elev_capi);
  if (capi_elev_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 2nd argument `elev' of _fortran.fillPIT to C/Fortran array" );
  } else {
    elev = (double *)(PyArray_DATA(capi_elev_tmp));

  /* Processing variable nb */
  if (nb_capi == Py_None) nb = len(elev); else
    f2py_success = int_from_pyobj(&nb,nb_capi,"_fortran.fillPIT() 1st keyword (nb) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(elev)>=nb,"len(elev)>=nb","1st keyword nb","fillPIT:nb=%d",nb) {
  /* Processing variable fillz */
  fillz_Dims[0]=nb;
  capi_fillz_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_fillz_tmp = array_from_pyobj(NPY_DOUBLE,fillz_Dims,fillz_Rank,capi_fillz_intent,Py_None);
  if (capi_fillz_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting hidden `fillz' of _fortran.fillPIT to C/Fortran array" );
  } else {
    fillz = (double *)(PyArray_DATA(capi_fillz_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&sl,elev,fillz,&nb);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("N",capi_fillz_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_fillz_tmp == NULL) ... else of fillz*/
  /* End of cleaning variable fillz */
  } /*CHECKSCALAR(len(elev)>=nb)*/
  } /*if (f2py_success) of nb*/
  /* End of cleaning variable nb */
  if((PyObject *)capi_elev_tmp!=elev_capi) {
    Py_XDECREF(capi_elev_tmp); }
  }  /*if (capi_elev_tmp == NULL) ... else of elev*/
  /* End of cleaning variable elev */
  } /*if (f2py_success) of sl*/
  /* End of cleaning variable sl */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of fillPIT *******************************/

/********************************** ngbGlob **********************************/
static char doc_f2py_rout__fortran_ngbGlob[] = "\
ngbGlob(nb,ngbid)\n\nWrapper for ``ngbGlob``.\
\n\nParameters\n----------\n"
"nb : input int\n"
"ngbid : input rank-2 array('i') with bounds (nb,6)";
/* extern void F_FUNC(ngbGlob,NGBGLOB)(int*,int*); */
static PyObject *f2py_rout__fortran_ngbGlob(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nb = 0;
  PyObject *nb_capi = Py_None;
  int *ngbid = NULL;
  npy_intp ngbid_Dims[2] = {-1, -1};
  const int ngbid_Rank = 2;
  PyArrayObject *capi_ngbid_tmp = NULL;
  int capi_ngbid_intent = 0;
  PyObject *ngbid_capi = Py_None;
  static char *capi_kwlist[] = {"nb","ngbid",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO:_fortran.ngbGlob",\
    capi_kwlist,&nb_capi,&ngbid_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable nb */
    f2py_success = int_from_pyobj(&nb,nb_capi,"_fortran.ngbGlob() 1st argument (nb) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ngbid */
  ngbid_Dims[0]=nb,ngbid_Dims[1]=6;
  capi_ngbid_intent |= F2PY_INTENT_IN;
  capi_ngbid_tmp = array_from_pyobj(NPY_INT,ngbid_Dims,ngbid_Rank,capi_ngbid_intent,ngbid_capi);
  if (capi_ngbid_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 2nd argument `ngbid' of _fortran.ngbGlob to C/Fortran array" );
  } else {
    ngbid = (int *)(PyArray_DATA(capi_ngbid_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nb,ngbid);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_ngbid_tmp!=ngbid_capi) {
    Py_XDECREF(capi_ngbid_tmp); }
  }  /*if (capi_ngbid_tmp == NULL) ... else of ngbid*/
  /* End of cleaning variable ngbid */
  } /*if (f2py_success) of nb*/
  /* End of cleaning variable nb */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of ngbGlob *******************************/

/********************************* defineTIN *********************************/
static char doc_f2py_rout__fortran_defineTIN[] = "\
ngbid = defineTIN(coords,cells_nodes,cells_edges,edges_nodes,area,circumcenter,[n,nb,m])\n\nWrapper for ``defineTIN``.\
\n\nParameters\n----------\n"
"coords : input rank-2 array('d') with bounds (nb,3)\n"
"cells_nodes : input rank-2 array('i') with bounds (n,3)\n"
"cells_edges : input rank-2 array('i') with bounds (n,3)\n"
"edges_nodes : input rank-2 array('i') with bounds (m,2)\n"
"area : input rank-1 array('d') with bounds (nb)\n"
"circumcenter : input rank-2 array('d') with bounds (3,n)\n"
"\nOther Parameters\n----------------\n"
"n : input int, optional\n    Default: shape(cells_nodes,0)\n"
"nb : input int, optional\n    Default: shape(coords,0)\n"
"m : input int, optional\n    Default: shape(edges_nodes,0)\n"
"\nReturns\n-------\n"
"ngbid : rank-2 array('i') with bounds (nb,8)";
/* extern void F_FUNC(defineTIN,DEFINETIN)(double*,int*,int*,int*,double*,double*,int*,int*,int*,int*); */
static PyObject *f2py_rout__fortran_defineTIN(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*,int*,double*,double*,int*,int*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *coords = NULL;
  npy_intp coords_Dims[2] = {-1, -1};
  const int coords_Rank = 2;
  PyArrayObject *capi_coords_tmp = NULL;
  int capi_coords_intent = 0;
  PyObject *coords_capi = Py_None;
  int *cells_nodes = NULL;
  npy_intp cells_nodes_Dims[2] = {-1, -1};
  const int cells_nodes_Rank = 2;
  PyArrayObject *capi_cells_nodes_tmp = NULL;
  int capi_cells_nodes_intent = 0;
  PyObject *cells_nodes_capi = Py_None;
  int *cells_edges = NULL;
  npy_intp cells_edges_Dims[2] = {-1, -1};
  const int cells_edges_Rank = 2;
  PyArrayObject *capi_cells_edges_tmp = NULL;
  int capi_cells_edges_intent = 0;
  PyObject *cells_edges_capi = Py_None;
  int *edges_nodes = NULL;
  npy_intp edges_nodes_Dims[2] = {-1, -1};
  const int edges_nodes_Rank = 2;
  PyArrayObject *capi_edges_nodes_tmp = NULL;
  int capi_edges_nodes_intent = 0;
  PyObject *edges_nodes_capi = Py_None;
  double *area = NULL;
  npy_intp area_Dims[1] = {-1};
  const int area_Rank = 1;
  PyArrayObject *capi_area_tmp = NULL;
  int capi_area_intent = 0;
  PyObject *area_capi = Py_None;
  double *circumcenter = NULL;
  npy_intp circumcenter_Dims[2] = {-1, -1};
  const int circumcenter_Rank = 2;
  PyArrayObject *capi_circumcenter_tmp = NULL;
  int capi_circumcenter_intent = 0;
  PyObject *circumcenter_capi = Py_None;
  int *ngbid = NULL;
  npy_intp ngbid_Dims[2] = {-1, -1};
  const int ngbid_Rank = 2;
  PyArrayObject *capi_ngbid_tmp = NULL;
  int capi_ngbid_intent = 0;
  int n = 0;
  PyObject *n_capi = Py_None;
  int nb = 0;
  PyObject *nb_capi = Py_None;
  int m = 0;
  PyObject *m_capi = Py_None;
  static char *capi_kwlist[] = {"coords","cells_nodes","cells_edges","edges_nodes","area","circumcenter","n","nb","m",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOO|OOO:_fortran.defineTIN",\
    capi_kwlist,&coords_capi,&cells_nodes_capi,&cells_edges_capi,&edges_nodes_capi,&area_capi,&circumcenter_capi,&n_capi,&nb_capi,&m_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable coords */
  coords_Dims[1]=3;
  capi_coords_intent |= F2PY_INTENT_IN;
  capi_coords_tmp = array_from_pyobj(NPY_DOUBLE,coords_Dims,coords_Rank,capi_coords_intent,coords_capi);
  if (capi_coords_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 1st argument `coords' of _fortran.defineTIN to C/Fortran array" );
  } else {
    coords = (double *)(PyArray_DATA(capi_coords_tmp));

  /* Processing variable cells_nodes */
  cells_nodes_Dims[1]=3;
  capi_cells_nodes_intent |= F2PY_INTENT_IN;
  capi_cells_nodes_tmp = array_from_pyobj(NPY_INT,cells_nodes_Dims,cells_nodes_Rank,capi_cells_nodes_intent,cells_nodes_capi);
  if (capi_cells_nodes_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 2nd argument `cells_nodes' of _fortran.defineTIN to C/Fortran array" );
  } else {
    cells_nodes = (int *)(PyArray_DATA(capi_cells_nodes_tmp));

  /* Processing variable edges_nodes */
  edges_nodes_Dims[1]=2;
  capi_edges_nodes_intent |= F2PY_INTENT_IN;
  capi_edges_nodes_tmp = array_from_pyobj(NPY_INT,edges_nodes_Dims,edges_nodes_Rank,capi_edges_nodes_intent,edges_nodes_capi);
  if (capi_edges_nodes_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 4th argument `edges_nodes' of _fortran.defineTIN to C/Fortran array" );
  } else {
    edges_nodes = (int *)(PyArray_DATA(capi_edges_nodes_tmp));

  /* Processing variable n */
  if (n_capi == Py_None) n = shape(cells_nodes,0); else
    f2py_success = int_from_pyobj(&n,n_capi,"_fortran.defineTIN() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(cells_nodes,0)==n,"shape(cells_nodes,0)==n","1st keyword n","defineTIN:n=%d",n) {
  /* Processing variable nb */
  if (nb_capi == Py_None) nb = shape(coords,0); else
    f2py_success = int_from_pyobj(&nb,nb_capi,"_fortran.defineTIN() 2nd keyword (nb) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(coords,0)==nb,"shape(coords,0)==nb","2nd keyword nb","defineTIN:nb=%d",nb) {
  /* Processing variable m */
  if (m_capi == Py_None) m = shape(edges_nodes,0); else
    f2py_success = int_from_pyobj(&m,m_capi,"_fortran.defineTIN() 3rd keyword (m) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(edges_nodes,0)==m,"shape(edges_nodes,0)==m","3rd keyword m","defineTIN:m=%d",m) {
  /* Processing variable cells_edges */
  cells_edges_Dims[0]=n,cells_edges_Dims[1]=3;
  capi_cells_edges_intent |= F2PY_INTENT_IN;
  capi_cells_edges_tmp = array_from_pyobj(NPY_INT,cells_edges_Dims,cells_edges_Rank,capi_cells_edges_intent,cells_edges_capi);
  if (capi_cells_edges_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 3rd argument `cells_edges' of _fortran.defineTIN to C/Fortran array" );
  } else {
    cells_edges = (int *)(PyArray_DATA(capi_cells_edges_tmp));

  /* Processing variable area */
  area_Dims[0]=nb;
  capi_area_intent |= F2PY_INTENT_IN;
  capi_area_tmp = array_from_pyobj(NPY_DOUBLE,area_Dims,area_Rank,capi_area_intent,area_capi);
  if (capi_area_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 5th argument `area' of _fortran.defineTIN to C/Fortran array" );
  } else {
    area = (double *)(PyArray_DATA(capi_area_tmp));

  /* Processing variable circumcenter */
  circumcenter_Dims[0]=3,circumcenter_Dims[1]=n;
  capi_circumcenter_intent |= F2PY_INTENT_IN;
  capi_circumcenter_tmp = array_from_pyobj(NPY_DOUBLE,circumcenter_Dims,circumcenter_Rank,capi_circumcenter_intent,circumcenter_capi);
  if (capi_circumcenter_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 6th argument `circumcenter' of _fortran.defineTIN to C/Fortran array" );
  } else {
    circumcenter = (double *)(PyArray_DATA(capi_circumcenter_tmp));

  /* Processing variable ngbid */
  ngbid_Dims[0]=nb,ngbid_Dims[1]=8;
  capi_ngbid_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ngbid_tmp = array_from_pyobj(NPY_INT,ngbid_Dims,ngbid_Rank,capi_ngbid_intent,Py_None);
  if (capi_ngbid_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting hidden `ngbid' of _fortran.defineTIN to C/Fortran array" );
  } else {
    ngbid = (int *)(PyArray_DATA(capi_ngbid_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(coords,cells_nodes,cells_edges,edges_nodes,area,circumcenter,ngbid,&n,&nb,&m);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("N",capi_ngbid_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_ngbid_tmp == NULL) ... else of ngbid*/
  /* End of cleaning variable ngbid */
  if((PyObject *)capi_circumcenter_tmp!=circumcenter_capi) {
    Py_XDECREF(capi_circumcenter_tmp); }
  }  /*if (capi_circumcenter_tmp == NULL) ... else of circumcenter*/
  /* End of cleaning variable circumcenter */
  if((PyObject *)capi_area_tmp!=area_capi) {
    Py_XDECREF(capi_area_tmp); }
  }  /*if (capi_area_tmp == NULL) ... else of area*/
  /* End of cleaning variable area */
  if((PyObject *)capi_cells_edges_tmp!=cells_edges_capi) {
    Py_XDECREF(capi_cells_edges_tmp); }
  }  /*if (capi_cells_edges_tmp == NULL) ... else of cells_edges*/
  /* End of cleaning variable cells_edges */
  } /*CHECKSCALAR(shape(edges_nodes,0)==m)*/
  } /*if (f2py_success) of m*/
  /* End of cleaning variable m */
  } /*CHECKSCALAR(shape(coords,0)==nb)*/
  } /*if (f2py_success) of nb*/
  /* End of cleaning variable nb */
  } /*CHECKSCALAR(shape(cells_nodes,0)==n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  if((PyObject *)capi_edges_nodes_tmp!=edges_nodes_capi) {
    Py_XDECREF(capi_edges_nodes_tmp); }
  }  /*if (capi_edges_nodes_tmp == NULL) ... else of edges_nodes*/
  /* End of cleaning variable edges_nodes */
  if((PyObject *)capi_cells_nodes_tmp!=cells_nodes_capi) {
    Py_XDECREF(capi_cells_nodes_tmp); }
  }  /*if (capi_cells_nodes_tmp == NULL) ... else of cells_nodes*/
  /* End of cleaning variable cells_nodes */
  if((PyObject *)capi_coords_tmp!=coords_capi) {
    Py_XDECREF(capi_coords_tmp); }
  }  /*if (capi_coords_tmp == NULL) ... else of coords*/
  /* End of cleaning variable coords */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of defineTIN ******************************/

/********************************* defineGTIN *********************************/
static char doc_f2py_rout__fortran_defineGTIN[] = "\
ngbnb,ngbid = defineGTIN(nb,cells_nodes,edges_nodes,[n,m])\n\nWrapper for ``defineGTIN``.\
\n\nParameters\n----------\n"
"nb : input int\n"
"cells_nodes : input rank-2 array('i') with bounds (n,3)\n"
"edges_nodes : input rank-2 array('i') with bounds (m,2)\n"
"\nOther Parameters\n----------------\n"
"n : input int, optional\n    Default: shape(cells_nodes,0)\n"
"m : input int, optional\n    Default: shape(edges_nodes,0)\n"
"\nReturns\n-------\n"
"ngbnb : rank-1 array('i') with bounds (nb)\n"
"ngbid : rank-2 array('i') with bounds (nb,12)";
/* extern void F_FUNC(defineGTIN,DEFINEGTIN)(int*,int*,int*,int*,int*,int*,int*); */
static PyObject *f2py_rout__fortran_defineGTIN(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*,int*,int*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nb = 0;
  PyObject *nb_capi = Py_None;
  int *cells_nodes = NULL;
  npy_intp cells_nodes_Dims[2] = {-1, -1};
  const int cells_nodes_Rank = 2;
  PyArrayObject *capi_cells_nodes_tmp = NULL;
  int capi_cells_nodes_intent = 0;
  PyObject *cells_nodes_capi = Py_None;
  int *edges_nodes = NULL;
  npy_intp edges_nodes_Dims[2] = {-1, -1};
  const int edges_nodes_Rank = 2;
  PyArrayObject *capi_edges_nodes_tmp = NULL;
  int capi_edges_nodes_intent = 0;
  PyObject *edges_nodes_capi = Py_None;
  int *ngbnb = NULL;
  npy_intp ngbnb_Dims[1] = {-1};
  const int ngbnb_Rank = 1;
  PyArrayObject *capi_ngbnb_tmp = NULL;
  int capi_ngbnb_intent = 0;
  int *ngbid = NULL;
  npy_intp ngbid_Dims[2] = {-1, -1};
  const int ngbid_Rank = 2;
  PyArrayObject *capi_ngbid_tmp = NULL;
  int capi_ngbid_intent = 0;
  int n = 0;
  PyObject *n_capi = Py_None;
  int m = 0;
  PyObject *m_capi = Py_None;
  static char *capi_kwlist[] = {"nb","cells_nodes","edges_nodes","n","m",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|OO:_fortran.defineGTIN",\
    capi_kwlist,&nb_capi,&cells_nodes_capi,&edges_nodes_capi,&n_capi,&m_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable nb */
    f2py_success = int_from_pyobj(&nb,nb_capi,"_fortran.defineGTIN() 1st argument (nb) can't be converted to int");
  if (f2py_success) {
  /* Processing variable cells_nodes */
  cells_nodes_Dims[1]=3;
  capi_cells_nodes_intent |= F2PY_INTENT_IN;
  capi_cells_nodes_tmp = array_from_pyobj(NPY_INT,cells_nodes_Dims,cells_nodes_Rank,capi_cells_nodes_intent,cells_nodes_capi);
  if (capi_cells_nodes_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 2nd argument `cells_nodes' of _fortran.defineGTIN to C/Fortran array" );
  } else {
    cells_nodes = (int *)(PyArray_DATA(capi_cells_nodes_tmp));

  /* Processing variable edges_nodes */
  edges_nodes_Dims[1]=2;
  capi_edges_nodes_intent |= F2PY_INTENT_IN;
  capi_edges_nodes_tmp = array_from_pyobj(NPY_INT,edges_nodes_Dims,edges_nodes_Rank,capi_edges_nodes_intent,edges_nodes_capi);
  if (capi_edges_nodes_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting 3rd argument `edges_nodes' of _fortran.defineGTIN to C/Fortran array" );
  } else {
    edges_nodes = (int *)(PyArray_DATA(capi_edges_nodes_tmp));

  /* Processing variable ngbnb */
  ngbnb_Dims[0]=nb;
  capi_ngbnb_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ngbnb_tmp = array_from_pyobj(NPY_INT,ngbnb_Dims,ngbnb_Rank,capi_ngbnb_intent,Py_None);
  if (capi_ngbnb_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting hidden `ngbnb' of _fortran.defineGTIN to C/Fortran array" );
  } else {
    ngbnb = (int *)(PyArray_DATA(capi_ngbnb_tmp));

  /* Processing variable ngbid */
  ngbid_Dims[0]=nb,ngbid_Dims[1]=12;
  capi_ngbid_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ngbid_tmp = array_from_pyobj(NPY_INT,ngbid_Dims,ngbid_Rank,capi_ngbid_intent,Py_None);
  if (capi_ngbid_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_fortran_error,"failed in converting hidden `ngbid' of _fortran.defineGTIN to C/Fortran array" );
  } else {
    ngbid = (int *)(PyArray_DATA(capi_ngbid_tmp));

  /* Processing variable n */
  if (n_capi == Py_None) n = shape(cells_nodes,0); else
    f2py_success = int_from_pyobj(&n,n_capi,"_fortran.defineGTIN() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(cells_nodes,0)==n,"shape(cells_nodes,0)==n","1st keyword n","defineGTIN:n=%d",n) {
  /* Processing variable m */
  if (m_capi == Py_None) m = shape(edges_nodes,0); else
    f2py_success = int_from_pyobj(&m,m_capi,"_fortran.defineGTIN() 2nd keyword (m) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(edges_nodes,0)==m,"shape(edges_nodes,0)==m","2nd keyword m","defineGTIN:m=%d",m) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nb,cells_nodes,edges_nodes,ngbnb,ngbid,&n,&m);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("NN",capi_ngbnb_tmp,capi_ngbid_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*CHECKSCALAR(shape(edges_nodes,0)==m)*/
  } /*if (f2py_success) of m*/
  /* End of cleaning variable m */
  } /*CHECKSCALAR(shape(cells_nodes,0)==n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  }  /*if (capi_ngbid_tmp == NULL) ... else of ngbid*/
  /* End of cleaning variable ngbid */
  }  /*if (capi_ngbnb_tmp == NULL) ... else of ngbnb*/
  /* End of cleaning variable ngbnb */
  if((PyObject *)capi_edges_nodes_tmp!=edges_nodes_capi) {
    Py_XDECREF(capi_edges_nodes_tmp); }
  }  /*if (capi_edges_nodes_tmp == NULL) ... else of edges_nodes*/
  /* End of cleaning variable edges_nodes */
  if((PyObject *)capi_cells_nodes_tmp!=cells_nodes_capi) {
    Py_XDECREF(capi_cells_nodes_tmp); }
  }  /*if (capi_cells_nodes_tmp == NULL) ... else of cells_nodes*/
  /* End of cleaning variable cells_nodes */
  } /*if (f2py_success) of nb*/
  /* End of cleaning variable nb */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of defineGTIN *****************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/

static FortranDataDef f2py_meshparams_def[] = {
  {"nlocal",0,{{-1}},NPY_INT},
  {"eps",0,{{-1}},NPY_DOUBLE},
  {"gnid",2,{{-1,-1}},NPY_INT},
  {"fvnid",2,{{-1,-1}},NPY_INT},
  {"fvnnb",1,{{-1}},NPY_INT},
  {"fvarea",1,{{-1}},NPY_DOUBLE},
  {"fvelgt",2,{{-1,-1}},NPY_DOUBLE},
  {"fvvdist",2,{{-1,-1}},NPY_DOUBLE},
  {NULL}
};

static void f2py_setup_meshparams(char *nlocal,char *eps,void (*gnid)(int*,int*,void(*)(char*,int*),int*),void (*fvnid)(int*,int*,void(*)(char*,int*),int*),void (*fvnnb)(int*,int*,void(*)(char*,int*),int*),void (*fvarea)(int*,int*,void(*)(char*,int*),int*),void (*fvelgt)(int*,int*,void(*)(char*,int*),int*),void (*fvvdist)(int*,int*,void(*)(char*,int*),int*)) {
  int i_f2py=0;
  f2py_meshparams_def[i_f2py++].data = nlocal;
  f2py_meshparams_def[i_f2py++].data = eps;
  f2py_meshparams_def[i_f2py++].func = gnid;
  f2py_meshparams_def[i_f2py++].func = fvnid;
  f2py_meshparams_def[i_f2py++].func = fvnnb;
  f2py_meshparams_def[i_f2py++].func = fvarea;
  f2py_meshparams_def[i_f2py++].func = fvelgt;
  f2py_meshparams_def[i_f2py++].func = fvvdist;
}
extern void F_FUNC(f2pyinitmeshparams,F2PYINITMESHPARAMS)(void (*)(char*,char*,void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*)));
static void f2py_init_meshparams(void) {
  F_FUNC(f2pyinitmeshparams,F2PYINITMESHPARAMS)(f2py_setup_meshparams);
}

/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"euclid",-1,{{-1}},0,(char *)F_FUNC(euclid,EUCLID),(f2py_init_func)f2py_rout__fortran_euclid,doc_f2py_rout__fortran_euclid},
  {"quicksort",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(quicksort,QUICKSORT),(f2py_init_func)f2py_rout__fortran_quicksort,doc_f2py_rout__fortran_quicksort},
  {"split",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(split,SPLIT),(f2py_init_func)f2py_rout__fortran_split,doc_f2py_rout__fortran_split},
  {"setMaxNb",-1,{{-1}},0,(char *)F_FUNC(setMaxNb,SETMAXNB),(f2py_init_func)f2py_rout__fortran_setMaxNb,doc_f2py_rout__fortran_setMaxNb},
  {"setHillslopeCoeff",-1,{{-1}},0,(char *)F_FUNC(setHillslopeCoeff,SETHILLSLOPECOEFF),(f2py_init_func)f2py_rout__fortran_setHillslopeCoeff,doc_f2py_rout__fortran_setHillslopeCoeff},
  {"setDiffusionCoeff",-1,{{-1}},0,(char *)F_FUNC(setDiffusionCoeff,SETDIFFUSIONCOEFF),(f2py_init_func)f2py_rout__fortran_setDiffusionCoeff,doc_f2py_rout__fortran_setDiffusionCoeff},
  {"MFDreceivers",-1,{{-1}},0,(char *)F_FUNC(MFDreceivers,MFDRECEIVERS),(f2py_init_func)f2py_rout__fortran_MFDreceivers,doc_f2py_rout__fortran_MFDreceivers},
  {"fillPIT",-1,{{-1}},0,(char *)F_FUNC(fillPIT,FILLPIT),(f2py_init_func)f2py_rout__fortran_fillPIT,doc_f2py_rout__fortran_fillPIT},
  {"ngbGlob",-1,{{-1}},0,(char *)F_FUNC(ngbGlob,NGBGLOB),(f2py_init_func)f2py_rout__fortran_ngbGlob,doc_f2py_rout__fortran_ngbGlob},
  {"defineTIN",-1,{{-1}},0,(char *)F_FUNC(defineTIN,DEFINETIN),(f2py_init_func)f2py_rout__fortran_defineTIN,doc_f2py_rout__fortran_defineTIN},
  {"defineGTIN",-1,{{-1}},0,(char *)F_FUNC(defineGTIN,DEFINEGTIN),(f2py_init_func)f2py_rout__fortran_defineGTIN,doc_f2py_rout__fortran_defineGTIN},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

#if PY_VERSION_HEX >= 0x03000000
static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "_fortran",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};
#endif

#if PY_VERSION_HEX >= 0x03000000
#define RETVAL m
PyMODINIT_FUNC PyInit__fortran(void) {
#else
#define RETVAL
PyMODINIT_FUNC init_fortran(void) {
#endif
  int i;
  PyObject *m,*d, *s, *tmp;
#if PY_VERSION_HEX >= 0x03000000
  m = _fortran_module = PyModule_Create(&moduledef);
#else
  m = _fortran_module = Py_InitModule("_fortran", f2py_module_methods);
#endif
  Py_TYPE(&PyFortran_Type) = &PyType_Type;
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module _fortran (failed to import numpy)"); return RETVAL;}
  d = PyModule_GetDict(m);
  s = PyString_FromString("$Revision: $");
  PyDict_SetItemString(d, "__version__", s);
  Py_DECREF(s);
#if PY_VERSION_HEX >= 0x03000000
  s = PyUnicode_FromString(
#else
  s = PyString_FromString(
#endif
    "This module '_fortran' is auto-generated with f2py (version:2).\nFunctions:\n"
"  norm = euclid(p1,p2)\n"
"  quicksort(array,first,last,indices)\n"
"  mid = split(array,low,high,indices)\n"
"  maxnb = setMaxNb(nb)\n"
"  dcoeff = setHillslopeCoeff(nb,kd)\n"
"  dcoeff = setDiffusionCoeff(kd,limit,elev,dh,nb=len(elev))\n"
"  rcv,dist,wgt = MFDreceivers(nrcv,inids,elev,sl,nb=len(inids))\n"
"  fillz = fillPIT(sl,elev,nb=len(elev))\n"
"  ngbGlob(nb,ngbid)\n"
"  ngbid = defineTIN(coords,cells_nodes,cells_edges,edges_nodes,area,circumcenter,n=shape(cells_nodes,0),nb=shape(coords,0),m=shape(edges_nodes,0))\n"
"  ngbnb,ngbid = defineGTIN(nb,cells_nodes,edges_nodes,n=shape(cells_nodes,0),m=shape(edges_nodes,0))\n"
"Fortran 90/95 modules:\n""  meshparams --- nlocal,eps,gnid,fvnid,fvnnb,fvarea,fvelgt,fvvdist"".");
  PyDict_SetItemString(d, "__doc__", s);
  Py_DECREF(s);
  _fortran_error = PyErr_NewException ("_fortran.error", NULL, NULL);
  /*
   * Store the error object inside the dict, so that it could get deallocated.
   * (in practice, this is a module, so it likely will not and cannot.)
   */
  PyDict_SetItemString(d, "__fortran_error", _fortran_error);
  Py_DECREF(_fortran_error);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++) {
    tmp = PyFortranObject_NewAsAttr(&f2py_routine_defs[i]);
    PyDict_SetItemString(d, f2py_routine_defs[i].name, tmp);
    Py_DECREF(tmp);
  }


    {
      extern void F_FUNC(quicksort,QUICKSORT)(void);
      PyObject* o = PyDict_GetItemString(d,"quicksort");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(quicksort,QUICKSORT),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
#if PY_VERSION_HEX >= 0x03000000
      s = PyUnicode_FromString("quicksort");
#else
      s = PyString_FromString("quicksort");
#endif
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    

    {
      extern void F_FUNC(split,SPLIT)(void);
      PyObject* o = PyDict_GetItemString(d,"split");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(split,SPLIT),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
#if PY_VERSION_HEX >= 0x03000000
      s = PyUnicode_FromString("split");
#else
      s = PyString_FromString("split");
#endif
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    








/*eof initf2pywraphooks*/
  PyDict_SetItemString(d, "meshparams", PyFortranObject_New(f2py_meshparams_def,f2py_init_meshparams));
/*eof initf90modhooks*/

/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"_fortran");
#endif
  return RETVAL;
}
#ifdef __cplusplus
}
#endif
